#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1074
#define LARGE_STATE_COUNT 741
#define SYMBOL_COUNT 117
#define ALIAS_COUNT 0
#define TOKEN_COUNT 75
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 18

enum {
  anon_sym_LF = 1,
  anon_sym_SEMI = 2,
  anon_sym_function = 3,
  anon_sym_if = 4,
  anon_sym_LPAREN = 5,
  anon_sym_RPAREN = 6,
  anon_sym_else = 7,
  anon_sym_while = 8,
  anon_sym_repeat = 9,
  anon_sym_for = 10,
  anon_sym_in = 11,
  anon_sym_switch = 12,
  anon_sym_COMMA = 13,
  anon_sym_EQ = 14,
  anon_sym_LBRACE = 15,
  anon_sym_RBRACE = 16,
  anon_sym_LT_DASH = 17,
  anon_sym_COLON_EQ = 18,
  anon_sym_LT_LT_DASH = 19,
  anon_sym_DASH_GT = 20,
  anon_sym_LBRACK = 21,
  anon_sym_RBRACK = 22,
  anon_sym_LBRACK_LBRACK = 23,
  anon_sym_RBRACK_RBRACK = 24,
  anon_sym_DOLLAR = 25,
  anon_sym_AT = 26,
  anon_sym_COLON_COLON = 27,
  anon_sym_COLON_COLON_COLON = 28,
  sym_dots = 29,
  anon_sym_DASH = 30,
  anon_sym_PLUS = 31,
  anon_sym_BANG = 32,
  anon_sym_TILDE = 33,
  anon_sym_STAR = 34,
  anon_sym_SLASH = 35,
  anon_sym_CARET = 36,
  anon_sym_LT = 37,
  anon_sym_GT = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_EQ_EQ = 41,
  anon_sym_BANG_EQ = 42,
  anon_sym_PIPE_PIPE = 43,
  anon_sym_PIPE = 44,
  anon_sym_AMP_AMP = 45,
  anon_sym_AMP = 46,
  anon_sym_PIPE_GT = 47,
  anon_sym_COLON = 48,
  sym_break = 49,
  sym_next = 50,
  sym_true = 51,
  sym_false = 52,
  sym_null = 53,
  sym_inf = 54,
  sym_nan = 55,
  anon_sym_NA = 56,
  anon_sym_NA_character_ = 57,
  anon_sym_NA_complex_ = 58,
  anon_sym_NA_integer_ = 59,
  anon_sym_NA_real_ = 60,
  aux_sym_identifier_token1 = 61,
  anon_sym_BQUOTE = 62,
  aux_sym_identifier_token2 = 63,
  sym_integer = 64,
  sym_float = 65,
  anon_sym_i = 66,
  sym_comment = 67,
  anon_sym_DQUOTE = 68,
  aux_sym_string_token1 = 69,
  anon_sym_SQUOTE = 70,
  aux_sym_string_token2 = 71,
  anon_sym_PERCENT = 72,
  aux_sym_special_token1 = 73,
  sym_escape_sequence = 74,
  sym_program = 75,
  sym_function_definition = 76,
  sym_if = 77,
  sym_while = 78,
  sym_repeat = 79,
  sym_for = 80,
  sym_switch = 81,
  sym_formal_parameters = 82,
  sym__formal_parameter = 83,
  sym_arguments = 84,
  sym__argument = 85,
  sym_call = 86,
  sym__assignment = 87,
  sym_left_assignment = 88,
  sym_left_assignment2 = 89,
  sym_equals_assignment = 90,
  sym_super_assignment = 91,
  sym_right_assignment = 92,
  sym_brace_list = 93,
  sym_paren_list = 94,
  sym_subset = 95,
  sym_subset2 = 96,
  sym_dollar = 97,
  sym_slot = 98,
  sym_namespace_get = 99,
  sym_namespace_get_internal = 100,
  sym_unary = 101,
  sym_binary = 102,
  sym_na = 103,
  sym__expression = 104,
  sym_identifier = 105,
  sym_complex = 106,
  sym_string = 107,
  sym_special = 108,
  aux_sym_program_repeat1 = 109,
  aux_sym_formal_parameters_repeat1 = 110,
  aux_sym_block_repeat1 = 111,
  aux_sym_arguments_repeat1 = 112,
  aux_sym_identifier_repeat1 = 113,
  aux_sym_string_repeat1 = 114,
  aux_sym_string_repeat2 = 115,
  aux_sym_special_repeat1 = 116,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_if] = "if",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_switch] = "switch",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [sym_dots] = "dots",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_COLON] = ":",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_character_] = "NA_character_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [aux_sym_identifier_token1] = "identifier_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_identifier_token2] = "identifier_token2",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_i] = "i",
  [sym_comment] = "comment",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_PERCENT] = "%",
  [aux_sym_special_token1] = "special_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_if] = "if",
  [sym_while] = "while",
  [sym_repeat] = "repeat",
  [sym_for] = "for",
  [sym_switch] = "switch",
  [sym_formal_parameters] = "formal_parameters",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_arguments] = "arguments",
  [sym__argument] = "_argument",
  [sym_call] = "call",
  [sym__assignment] = "_assignment",
  [sym_left_assignment] = "left_assignment",
  [sym_left_assignment2] = "left_assignment2",
  [sym_equals_assignment] = "equals_assignment",
  [sym_super_assignment] = "super_assignment",
  [sym_right_assignment] = "right_assignment",
  [sym_brace_list] = "brace_list",
  [sym_paren_list] = "paren_list",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_dollar] = "dollar",
  [sym_slot] = "slot",
  [sym_namespace_get] = "namespace_get",
  [sym_namespace_get_internal] = "namespace_get_internal",
  [sym_unary] = "unary",
  [sym_binary] = "binary",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym_identifier] = "identifier",
  [sym_complex] = "complex",
  [sym_string] = "string",
  [sym_special] = "special",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_special_repeat1] = "special_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [sym_dots] = sym_dots,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_i] = anon_sym_i,
  [sym_comment] = sym_comment,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_special_token1] = aux_sym_special_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_if] = sym_if,
  [sym_while] = sym_while,
  [sym_repeat] = sym_repeat,
  [sym_for] = sym_for,
  [sym_switch] = sym_switch,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_arguments] = sym_arguments,
  [sym__argument] = sym__argument,
  [sym_call] = sym_call,
  [sym__assignment] = sym__assignment,
  [sym_left_assignment] = sym_left_assignment,
  [sym_left_assignment2] = sym_left_assignment2,
  [sym_equals_assignment] = sym_equals_assignment,
  [sym_super_assignment] = sym_super_assignment,
  [sym_right_assignment] = sym_right_assignment,
  [sym_brace_list] = sym_brace_list,
  [sym_paren_list] = sym_paren_list,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_dollar] = sym_dollar,
  [sym_slot] = sym_slot,
  [sym_namespace_get] = sym_namespace_get,
  [sym_namespace_get_internal] = sym_namespace_get_internal,
  [sym_unary] = sym_unary,
  [sym_binary] = sym_binary,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym_identifier] = sym_identifier,
  [sym_complex] = sym_complex,
  [sym_string] = sym_string,
  [sym_special] = sym_special,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_special_repeat1] = aux_sym_special_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_special_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_left_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_left_assignment2] = {
    .visible = true,
    .named = true,
  },
  [sym_equals_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_list] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_list] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_slot] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get_internal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_special] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_special_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_function = 6,
  field_left = 7,
  field_name = 8,
  field_namespace = 9,
  field_operand = 10,
  field_operator = 11,
  field_right = 12,
  field_value = 13,
  field_vector = 14,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_value] = "value",
  [field_vector] = "vector",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 3},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 1},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 4},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 2},
  [15] = {.index = 27, .length = 2},
  [16] = {.index = 29, .length = 4},
  [17] = {.index = 33, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 1},
  [1] =
    {field_operand, 1},
    {field_operator, 0},
  [3] =
    {field_function, 0},
  [4] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [6] =
    {field_value, 0},
  [7] =
    {field_name, 0},
    {field_value, 2},
  [9] =
    {field_name, 2},
    {field_value, 0},
  [11] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [14] =
    {field_function, 2},
    {field_namespace, 0},
  [16] =
    {field_name, 0},
  [17] =
    {field_arguments, 2},
    {field_function, 0},
  [19] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [23] =
    {field_condition, 2},
    {field_consequence, 4},
  [25] =
    {field_body, 4},
    {field_condition, 2},
  [27] =
    {field_body, 4},
    {field_value, 2},
  [29] =
    {field_alternative, 5},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [33] =
    {field_body, 6},
    {field_name, 2},
    {field_vector, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(54);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(38);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(222);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(223);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(224);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(225);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(210);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '\r') ADVANCE(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(214);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '\r') ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(196);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(196);
      if (lookahead == '\r') ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\r') ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(74);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 33:
      if (lookahead == ']') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 40:
      if (lookahead == '}') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 41:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 48:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 49:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 50:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 51:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 52:
      if (eof) ADVANCE(54);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 53:
      if (eof) ADVANCE(54);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '0') ADVANCE(201);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(78);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(83);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_dots);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(75);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(100);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_break);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_next);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_inf);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_nan);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(140);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(124);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(112);
      if (lookahead == 'U') ADVANCE(126);
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(107);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(108);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(129);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(109);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(125);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N') ADVANCE(111);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R') ADVANCE(130);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S') ADVANCE(123);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U') ADVANCE(122);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(116);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(115);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(113);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(164);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(182);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(166);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(185);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(143);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(160);
      if (lookahead == 'i') ADVANCE(173);
      if (lookahead == 'r') ADVANCE(153);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(189);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(191);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(177);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(135);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(63);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(157);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(192);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(138);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(110);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(67);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(169);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(175);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'k') ADVANCE(105);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(183);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(131);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(150);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'm') ADVANCE(176);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(142);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(188);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(178);
      if (lookahead == 'u') ADVANCE(171);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(172);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(168);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(151);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(65);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(134);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(139);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(106);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(141);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(161);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(154);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'w') ADVANCE(163);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(184);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(132);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '`') ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(199);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(44);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'L') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_i);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(212);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_special_token1);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%') ADVANCE(220);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(210);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(214);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(196);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(221);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 53},
  [2] = {.lex_state = 53},
  [3] = {.lex_state = 53},
  [4] = {.lex_state = 22},
  [5] = {.lex_state = 53},
  [6] = {.lex_state = 22},
  [7] = {.lex_state = 53},
  [8] = {.lex_state = 22},
  [9] = {.lex_state = 53},
  [10] = {.lex_state = 22},
  [11] = {.lex_state = 22},
  [12] = {.lex_state = 53},
  [13] = {.lex_state = 53},
  [14] = {.lex_state = 22},
  [15] = {.lex_state = 22},
  [16] = {.lex_state = 53},
  [17] = {.lex_state = 22},
  [18] = {.lex_state = 53},
  [19] = {.lex_state = 53},
  [20] = {.lex_state = 22},
  [21] = {.lex_state = 53},
  [22] = {.lex_state = 22},
  [23] = {.lex_state = 53},
  [24] = {.lex_state = 22},
  [25] = {.lex_state = 53},
  [26] = {.lex_state = 53},
  [27] = {.lex_state = 53},
  [28] = {.lex_state = 53},
  [29] = {.lex_state = 53},
  [30] = {.lex_state = 53},
  [31] = {.lex_state = 53},
  [32] = {.lex_state = 53},
  [33] = {.lex_state = 53},
  [34] = {.lex_state = 53},
  [35] = {.lex_state = 53},
  [36] = {.lex_state = 53},
  [37] = {.lex_state = 53},
  [38] = {.lex_state = 53},
  [39] = {.lex_state = 53},
  [40] = {.lex_state = 53},
  [41] = {.lex_state = 53},
  [42] = {.lex_state = 21},
  [43] = {.lex_state = 21},
  [44] = {.lex_state = 22},
  [45] = {.lex_state = 21},
  [46] = {.lex_state = 21},
  [47] = {.lex_state = 48},
  [48] = {.lex_state = 53},
  [49] = {.lex_state = 53},
  [50] = {.lex_state = 53},
  [51] = {.lex_state = 53},
  [52] = {.lex_state = 21},
  [53] = {.lex_state = 53},
  [54] = {.lex_state = 53},
  [55] = {.lex_state = 53},
  [56] = {.lex_state = 53},
  [57] = {.lex_state = 53},
  [58] = {.lex_state = 53},
  [59] = {.lex_state = 53},
  [60] = {.lex_state = 53},
  [61] = {.lex_state = 53},
  [62] = {.lex_state = 53},
  [63] = {.lex_state = 53},
  [64] = {.lex_state = 53},
  [65] = {.lex_state = 53},
  [66] = {.lex_state = 53},
  [67] = {.lex_state = 53},
  [68] = {.lex_state = 53},
  [69] = {.lex_state = 53},
  [70] = {.lex_state = 53},
  [71] = {.lex_state = 53},
  [72] = {.lex_state = 53},
  [73] = {.lex_state = 21},
  [74] = {.lex_state = 21},
  [75] = {.lex_state = 53},
  [76] = {.lex_state = 21},
  [77] = {.lex_state = 53},
  [78] = {.lex_state = 21},
  [79] = {.lex_state = 53},
  [80] = {.lex_state = 48},
  [81] = {.lex_state = 53},
  [82] = {.lex_state = 53},
  [83] = {.lex_state = 53},
  [84] = {.lex_state = 53},
  [85] = {.lex_state = 53},
  [86] = {.lex_state = 21},
  [87] = {.lex_state = 53},
  [88] = {.lex_state = 53},
  [89] = {.lex_state = 53},
  [90] = {.lex_state = 22},
  [91] = {.lex_state = 53},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 48},
  [94] = {.lex_state = 53},
  [95] = {.lex_state = 53},
  [96] = {.lex_state = 48},
  [97] = {.lex_state = 22},
  [98] = {.lex_state = 53},
  [99] = {.lex_state = 48},
  [100] = {.lex_state = 48},
  [101] = {.lex_state = 21},
  [102] = {.lex_state = 48},
  [103] = {.lex_state = 21},
  [104] = {.lex_state = 21},
  [105] = {.lex_state = 22},
  [106] = {.lex_state = 24},
  [107] = {.lex_state = 24},
  [108] = {.lex_state = 21},
  [109] = {.lex_state = 21},
  [110] = {.lex_state = 21},
  [111] = {.lex_state = 22},
  [112] = {.lex_state = 24},
  [113] = {.lex_state = 21},
  [114] = {.lex_state = 24},
  [115] = {.lex_state = 22},
  [116] = {.lex_state = 21},
  [117] = {.lex_state = 21},
  [118] = {.lex_state = 21},
  [119] = {.lex_state = 21},
  [120] = {.lex_state = 21},
  [121] = {.lex_state = 21},
  [122] = {.lex_state = 21},
  [123] = {.lex_state = 48},
  [124] = {.lex_state = 53},
  [125] = {.lex_state = 21},
  [126] = {.lex_state = 53},
  [127] = {.lex_state = 21},
  [128] = {.lex_state = 21},
  [129] = {.lex_state = 21},
  [130] = {.lex_state = 48},
  [131] = {.lex_state = 48},
  [132] = {.lex_state = 48},
  [133] = {.lex_state = 48},
  [134] = {.lex_state = 48},
  [135] = {.lex_state = 53},
  [136] = {.lex_state = 48},
  [137] = {.lex_state = 48},
  [138] = {.lex_state = 53},
  [139] = {.lex_state = 53},
  [140] = {.lex_state = 22},
  [141] = {.lex_state = 53},
  [142] = {.lex_state = 48},
  [143] = {.lex_state = 48},
  [144] = {.lex_state = 48},
  [145] = {.lex_state = 48},
  [146] = {.lex_state = 48},
  [147] = {.lex_state = 48},
  [148] = {.lex_state = 48},
  [149] = {.lex_state = 48},
  [150] = {.lex_state = 48},
  [151] = {.lex_state = 48},
  [152] = {.lex_state = 48},
  [153] = {.lex_state = 48},
  [154] = {.lex_state = 23},
  [155] = {.lex_state = 48},
  [156] = {.lex_state = 25},
  [157] = {.lex_state = 24},
  [158] = {.lex_state = 24},
  [159] = {.lex_state = 22},
  [160] = {.lex_state = 24},
  [161] = {.lex_state = 22},
  [162] = {.lex_state = 22},
  [163] = {.lex_state = 22},
  [164] = {.lex_state = 24},
  [165] = {.lex_state = 24},
  [166] = {.lex_state = 24},
  [167] = {.lex_state = 24},
  [168] = {.lex_state = 24},
  [169] = {.lex_state = 24},
  [170] = {.lex_state = 50},
  [171] = {.lex_state = 24},
  [172] = {.lex_state = 48},
  [173] = {.lex_state = 48},
  [174] = {.lex_state = 48},
  [175] = {.lex_state = 48},
  [176] = {.lex_state = 48},
  [177] = {.lex_state = 48},
  [178] = {.lex_state = 48},
  [179] = {.lex_state = 48},
  [180] = {.lex_state = 48},
  [181] = {.lex_state = 48},
  [182] = {.lex_state = 48},
  [183] = {.lex_state = 48},
  [184] = {.lex_state = 48},
  [185] = {.lex_state = 48},
  [186] = {.lex_state = 24},
  [187] = {.lex_state = 22},
  [188] = {.lex_state = 48},
  [189] = {.lex_state = 48},
  [190] = {.lex_state = 24},
  [191] = {.lex_state = 48},
  [192] = {.lex_state = 24},
  [193] = {.lex_state = 48},
  [194] = {.lex_state = 24},
  [195] = {.lex_state = 48},
  [196] = {.lex_state = 53},
  [197] = {.lex_state = 24},
  [198] = {.lex_state = 22},
  [199] = {.lex_state = 22},
  [200] = {.lex_state = 22},
  [201] = {.lex_state = 22},
  [202] = {.lex_state = 22},
  [203] = {.lex_state = 48},
  [204] = {.lex_state = 48},
  [205] = {.lex_state = 48},
  [206] = {.lex_state = 24},
  [207] = {.lex_state = 22},
  [208] = {.lex_state = 22},
  [209] = {.lex_state = 22},
  [210] = {.lex_state = 22},
  [211] = {.lex_state = 22},
  [212] = {.lex_state = 22},
  [213] = {.lex_state = 22},
  [214] = {.lex_state = 22},
  [215] = {.lex_state = 22},
  [216] = {.lex_state = 24},
  [217] = {.lex_state = 24},
  [218] = {.lex_state = 21},
  [219] = {.lex_state = 22},
  [220] = {.lex_state = 24},
  [221] = {.lex_state = 24},
  [222] = {.lex_state = 21},
  [223] = {.lex_state = 21},
  [224] = {.lex_state = 24},
  [225] = {.lex_state = 22},
  [226] = {.lex_state = 21},
  [227] = {.lex_state = 21},
  [228] = {.lex_state = 21},
  [229] = {.lex_state = 21},
  [230] = {.lex_state = 22},
  [231] = {.lex_state = 22},
  [232] = {.lex_state = 21},
  [233] = {.lex_state = 21},
  [234] = {.lex_state = 21},
  [235] = {.lex_state = 21},
  [236] = {.lex_state = 21},
  [237] = {.lex_state = 49},
  [238] = {.lex_state = 24},
  [239] = {.lex_state = 49},
  [240] = {.lex_state = 21},
  [241] = {.lex_state = 21},
  [242] = {.lex_state = 21},
  [243] = {.lex_state = 21},
  [244] = {.lex_state = 24},
  [245] = {.lex_state = 49},
  [246] = {.lex_state = 48},
  [247] = {.lex_state = 49},
  [248] = {.lex_state = 48},
  [249] = {.lex_state = 21},
  [250] = {.lex_state = 49},
  [251] = {.lex_state = 21},
  [252] = {.lex_state = 49},
  [253] = {.lex_state = 50},
  [254] = {.lex_state = 49},
  [255] = {.lex_state = 21},
  [256] = {.lex_state = 48},
  [257] = {.lex_state = 48},
  [258] = {.lex_state = 49},
  [259] = {.lex_state = 48},
  [260] = {.lex_state = 24},
  [261] = {.lex_state = 48},
  [262] = {.lex_state = 53},
  [263] = {.lex_state = 24},
  [264] = {.lex_state = 53},
  [265] = {.lex_state = 53},
  [266] = {.lex_state = 53},
  [267] = {.lex_state = 53},
  [268] = {.lex_state = 49},
  [269] = {.lex_state = 53},
  [270] = {.lex_state = 53},
  [271] = {.lex_state = 53},
  [272] = {.lex_state = 53},
  [273] = {.lex_state = 53},
  [274] = {.lex_state = 49},
  [275] = {.lex_state = 49},
  [276] = {.lex_state = 49},
  [277] = {.lex_state = 49},
  [278] = {.lex_state = 49},
  [279] = {.lex_state = 53},
  [280] = {.lex_state = 53},
  [281] = {.lex_state = 53},
  [282] = {.lex_state = 53},
  [283] = {.lex_state = 49},
  [284] = {.lex_state = 49},
  [285] = {.lex_state = 49},
  [286] = {.lex_state = 49},
  [287] = {.lex_state = 49},
  [288] = {.lex_state = 49},
  [289] = {.lex_state = 49},
  [290] = {.lex_state = 49},
  [291] = {.lex_state = 49},
  [292] = {.lex_state = 53},
  [293] = {.lex_state = 53},
  [294] = {.lex_state = 53},
  [295] = {.lex_state = 53},
  [296] = {.lex_state = 53},
  [297] = {.lex_state = 53},
  [298] = {.lex_state = 53},
  [299] = {.lex_state = 49},
  [300] = {.lex_state = 53},
  [301] = {.lex_state = 53},
  [302] = {.lex_state = 53},
  [303] = {.lex_state = 49},
  [304] = {.lex_state = 49},
  [305] = {.lex_state = 53},
  [306] = {.lex_state = 53},
  [307] = {.lex_state = 53},
  [308] = {.lex_state = 53},
  [309] = {.lex_state = 48},
  [310] = {.lex_state = 53},
  [311] = {.lex_state = 53},
  [312] = {.lex_state = 53},
  [313] = {.lex_state = 53},
  [314] = {.lex_state = 48},
  [315] = {.lex_state = 53},
  [316] = {.lex_state = 48},
  [317] = {.lex_state = 53},
  [318] = {.lex_state = 53},
  [319] = {.lex_state = 53},
  [320] = {.lex_state = 53},
  [321] = {.lex_state = 48},
  [322] = {.lex_state = 48},
  [323] = {.lex_state = 53},
  [324] = {.lex_state = 53},
  [325] = {.lex_state = 53},
  [326] = {.lex_state = 53},
  [327] = {.lex_state = 53},
  [328] = {.lex_state = 53},
  [329] = {.lex_state = 53},
  [330] = {.lex_state = 53},
  [331] = {.lex_state = 53},
  [332] = {.lex_state = 53},
  [333] = {.lex_state = 53},
  [334] = {.lex_state = 53},
  [335] = {.lex_state = 53},
  [336] = {.lex_state = 53},
  [337] = {.lex_state = 53},
  [338] = {.lex_state = 53},
  [339] = {.lex_state = 53},
  [340] = {.lex_state = 53},
  [341] = {.lex_state = 53},
  [342] = {.lex_state = 48},
  [343] = {.lex_state = 48},
  [344] = {.lex_state = 53},
  [345] = {.lex_state = 48},
  [346] = {.lex_state = 48},
  [347] = {.lex_state = 53},
  [348] = {.lex_state = 53},
  [349] = {.lex_state = 53},
  [350] = {.lex_state = 53},
  [351] = {.lex_state = 53},
  [352] = {.lex_state = 48},
  [353] = {.lex_state = 48},
  [354] = {.lex_state = 48},
  [355] = {.lex_state = 48},
  [356] = {.lex_state = 53},
  [357] = {.lex_state = 53},
  [358] = {.lex_state = 53},
  [359] = {.lex_state = 53},
  [360] = {.lex_state = 53},
  [361] = {.lex_state = 53},
  [362] = {.lex_state = 53},
  [363] = {.lex_state = 53},
  [364] = {.lex_state = 53},
  [365] = {.lex_state = 48},
  [366] = {.lex_state = 48},
  [367] = {.lex_state = 53},
  [368] = {.lex_state = 48},
  [369] = {.lex_state = 48},
  [370] = {.lex_state = 48},
  [371] = {.lex_state = 53},
  [372] = {.lex_state = 51},
  [373] = {.lex_state = 53},
  [374] = {.lex_state = 53},
  [375] = {.lex_state = 48},
  [376] = {.lex_state = 49},
  [377] = {.lex_state = 53},
  [378] = {.lex_state = 53},
  [379] = {.lex_state = 53},
  [380] = {.lex_state = 53},
  [381] = {.lex_state = 53},
  [382] = {.lex_state = 53},
  [383] = {.lex_state = 53},
  [384] = {.lex_state = 53},
  [385] = {.lex_state = 53},
  [386] = {.lex_state = 53},
  [387] = {.lex_state = 53},
  [388] = {.lex_state = 53},
  [389] = {.lex_state = 53},
  [390] = {.lex_state = 53},
  [391] = {.lex_state = 49},
  [392] = {.lex_state = 49},
  [393] = {.lex_state = 49},
  [394] = {.lex_state = 49},
  [395] = {.lex_state = 53},
  [396] = {.lex_state = 53},
  [397] = {.lex_state = 53},
  [398] = {.lex_state = 53},
  [399] = {.lex_state = 53},
  [400] = {.lex_state = 53},
  [401] = {.lex_state = 53},
  [402] = {.lex_state = 49},
  [403] = {.lex_state = 53},
  [404] = {.lex_state = 53},
  [405] = {.lex_state = 53},
  [406] = {.lex_state = 53},
  [407] = {.lex_state = 53},
  [408] = {.lex_state = 53},
  [409] = {.lex_state = 53},
  [410] = {.lex_state = 53},
  [411] = {.lex_state = 53},
  [412] = {.lex_state = 49},
  [413] = {.lex_state = 49},
  [414] = {.lex_state = 53},
  [415] = {.lex_state = 49},
  [416] = {.lex_state = 53},
  [417] = {.lex_state = 53},
  [418] = {.lex_state = 51},
  [419] = {.lex_state = 53},
  [420] = {.lex_state = 53},
  [421] = {.lex_state = 53},
  [422] = {.lex_state = 53},
  [423] = {.lex_state = 53},
  [424] = {.lex_state = 53},
  [425] = {.lex_state = 53},
  [426] = {.lex_state = 53},
  [427] = {.lex_state = 53},
  [428] = {.lex_state = 53},
  [429] = {.lex_state = 53},
  [430] = {.lex_state = 53},
  [431] = {.lex_state = 53},
  [432] = {.lex_state = 53},
  [433] = {.lex_state = 53},
  [434] = {.lex_state = 53},
  [435] = {.lex_state = 53},
  [436] = {.lex_state = 53},
  [437] = {.lex_state = 53},
  [438] = {.lex_state = 22},
  [439] = {.lex_state = 53},
  [440] = {.lex_state = 53},
  [441] = {.lex_state = 53},
  [442] = {.lex_state = 53},
  [443] = {.lex_state = 22},
  [444] = {.lex_state = 22},
  [445] = {.lex_state = 53},
  [446] = {.lex_state = 53},
  [447] = {.lex_state = 53},
  [448] = {.lex_state = 22},
  [449] = {.lex_state = 53},
  [450] = {.lex_state = 53},
  [451] = {.lex_state = 48},
  [452] = {.lex_state = 53},
  [453] = {.lex_state = 22},
  [454] = {.lex_state = 22},
  [455] = {.lex_state = 53},
  [456] = {.lex_state = 48},
  [457] = {.lex_state = 22},
  [458] = {.lex_state = 48},
  [459] = {.lex_state = 22},
  [460] = {.lex_state = 22},
  [461] = {.lex_state = 22},
  [462] = {.lex_state = 53},
  [463] = {.lex_state = 48},
  [464] = {.lex_state = 48},
  [465] = {.lex_state = 53},
  [466] = {.lex_state = 53},
  [467] = {.lex_state = 53},
  [468] = {.lex_state = 53},
  [469] = {.lex_state = 53},
  [470] = {.lex_state = 53},
  [471] = {.lex_state = 53},
  [472] = {.lex_state = 53},
  [473] = {.lex_state = 53},
  [474] = {.lex_state = 53},
  [475] = {.lex_state = 53},
  [476] = {.lex_state = 53},
  [477] = {.lex_state = 53},
  [478] = {.lex_state = 53},
  [479] = {.lex_state = 53},
  [480] = {.lex_state = 48},
  [481] = {.lex_state = 48},
  [482] = {.lex_state = 49},
  [483] = {.lex_state = 48},
  [484] = {.lex_state = 48},
  [485] = {.lex_state = 22},
  [486] = {.lex_state = 22},
  [487] = {.lex_state = 22},
  [488] = {.lex_state = 22},
  [489] = {.lex_state = 53},
  [490] = {.lex_state = 48},
  [491] = {.lex_state = 48},
  [492] = {.lex_state = 48},
  [493] = {.lex_state = 48},
  [494] = {.lex_state = 53},
  [495] = {.lex_state = 53},
  [496] = {.lex_state = 53},
  [497] = {.lex_state = 53},
  [498] = {.lex_state = 53},
  [499] = {.lex_state = 53},
  [500] = {.lex_state = 53},
  [501] = {.lex_state = 53},
  [502] = {.lex_state = 53},
  [503] = {.lex_state = 48},
  [504] = {.lex_state = 48},
  [505] = {.lex_state = 53},
  [506] = {.lex_state = 48},
  [507] = {.lex_state = 48},
  [508] = {.lex_state = 48},
  [509] = {.lex_state = 53},
  [510] = {.lex_state = 53},
  [511] = {.lex_state = 53},
  [512] = {.lex_state = 48},
  [513] = {.lex_state = 53},
  [514] = {.lex_state = 53},
  [515] = {.lex_state = 53},
  [516] = {.lex_state = 53},
  [517] = {.lex_state = 53},
  [518] = {.lex_state = 53},
  [519] = {.lex_state = 53},
  [520] = {.lex_state = 53},
  [521] = {.lex_state = 53},
  [522] = {.lex_state = 53},
  [523] = {.lex_state = 53},
  [524] = {.lex_state = 53},
  [525] = {.lex_state = 53},
  [526] = {.lex_state = 53},
  [527] = {.lex_state = 53},
  [528] = {.lex_state = 53},
  [529] = {.lex_state = 53},
  [530] = {.lex_state = 53},
  [531] = {.lex_state = 53},
  [532] = {.lex_state = 53},
  [533] = {.lex_state = 53},
  [534] = {.lex_state = 53},
  [535] = {.lex_state = 53},
  [536] = {.lex_state = 53},
  [537] = {.lex_state = 53},
  [538] = {.lex_state = 53},
  [539] = {.lex_state = 53},
  [540] = {.lex_state = 53},
  [541] = {.lex_state = 53},
  [542] = {.lex_state = 53},
  [543] = {.lex_state = 53},
  [544] = {.lex_state = 53},
  [545] = {.lex_state = 53},
  [546] = {.lex_state = 53},
  [547] = {.lex_state = 53},
  [548] = {.lex_state = 53},
  [549] = {.lex_state = 53},
  [550] = {.lex_state = 22},
  [551] = {.lex_state = 22},
  [552] = {.lex_state = 22},
  [553] = {.lex_state = 22},
  [554] = {.lex_state = 53},
  [555] = {.lex_state = 53},
  [556] = {.lex_state = 53},
  [557] = {.lex_state = 53},
  [558] = {.lex_state = 53},
  [559] = {.lex_state = 49},
  [560] = {.lex_state = 22},
  [561] = {.lex_state = 53},
  [562] = {.lex_state = 53},
  [563] = {.lex_state = 53},
  [564] = {.lex_state = 53},
  [565] = {.lex_state = 49},
  [566] = {.lex_state = 49},
  [567] = {.lex_state = 53},
  [568] = {.lex_state = 53},
  [569] = {.lex_state = 53},
  [570] = {.lex_state = 53},
  [571] = {.lex_state = 53},
  [572] = {.lex_state = 53},
  [573] = {.lex_state = 53},
  [574] = {.lex_state = 53},
  [575] = {.lex_state = 53},
  [576] = {.lex_state = 53},
  [577] = {.lex_state = 53},
  [578] = {.lex_state = 53},
  [579] = {.lex_state = 53},
  [580] = {.lex_state = 53},
  [581] = {.lex_state = 53},
  [582] = {.lex_state = 53},
  [583] = {.lex_state = 53},
  [584] = {.lex_state = 53},
  [585] = {.lex_state = 53},
  [586] = {.lex_state = 53},
  [587] = {.lex_state = 53},
  [588] = {.lex_state = 53},
  [589] = {.lex_state = 53},
  [590] = {.lex_state = 53},
  [591] = {.lex_state = 53},
  [592] = {.lex_state = 53},
  [593] = {.lex_state = 53},
  [594] = {.lex_state = 53},
  [595] = {.lex_state = 53},
  [596] = {.lex_state = 53},
  [597] = {.lex_state = 53},
  [598] = {.lex_state = 53},
  [599] = {.lex_state = 53},
  [600] = {.lex_state = 53},
  [601] = {.lex_state = 53},
  [602] = {.lex_state = 53},
  [603] = {.lex_state = 53},
  [604] = {.lex_state = 53},
  [605] = {.lex_state = 53},
  [606] = {.lex_state = 53},
  [607] = {.lex_state = 53},
  [608] = {.lex_state = 53},
  [609] = {.lex_state = 53},
  [610] = {.lex_state = 53},
  [611] = {.lex_state = 49},
  [612] = {.lex_state = 53},
  [613] = {.lex_state = 53},
  [614] = {.lex_state = 53},
  [615] = {.lex_state = 53},
  [616] = {.lex_state = 53},
  [617] = {.lex_state = 53},
  [618] = {.lex_state = 53},
  [619] = {.lex_state = 53},
  [620] = {.lex_state = 53},
  [621] = {.lex_state = 53},
  [622] = {.lex_state = 53},
  [623] = {.lex_state = 53},
  [624] = {.lex_state = 53},
  [625] = {.lex_state = 53},
  [626] = {.lex_state = 53},
  [627] = {.lex_state = 53},
  [628] = {.lex_state = 53},
  [629] = {.lex_state = 53},
  [630] = {.lex_state = 53},
  [631] = {.lex_state = 53},
  [632] = {.lex_state = 53},
  [633] = {.lex_state = 53},
  [634] = {.lex_state = 53},
  [635] = {.lex_state = 53},
  [636] = {.lex_state = 53},
  [637] = {.lex_state = 53},
  [638] = {.lex_state = 53},
  [639] = {.lex_state = 53},
  [640] = {.lex_state = 53},
  [641] = {.lex_state = 53},
  [642] = {.lex_state = 53},
  [643] = {.lex_state = 24},
  [644] = {.lex_state = 53},
  [645] = {.lex_state = 53},
  [646] = {.lex_state = 53},
  [647] = {.lex_state = 24},
  [648] = {.lex_state = 53},
  [649] = {.lex_state = 24},
  [650] = {.lex_state = 49},
  [651] = {.lex_state = 49},
  [652] = {.lex_state = 49},
  [653] = {.lex_state = 49},
  [654] = {.lex_state = 24},
  [655] = {.lex_state = 24},
  [656] = {.lex_state = 22},
  [657] = {.lex_state = 24},
  [658] = {.lex_state = 24},
  [659] = {.lex_state = 49},
  [660] = {.lex_state = 24},
  [661] = {.lex_state = 24},
  [662] = {.lex_state = 49},
  [663] = {.lex_state = 49},
  [664] = {.lex_state = 49},
  [665] = {.lex_state = 49},
  [666] = {.lex_state = 49},
  [667] = {.lex_state = 24},
  [668] = {.lex_state = 53},
  [669] = {.lex_state = 24},
  [670] = {.lex_state = 24},
  [671] = {.lex_state = 49},
  [672] = {.lex_state = 49},
  [673] = {.lex_state = 49},
  [674] = {.lex_state = 49},
  [675] = {.lex_state = 26},
  [676] = {.lex_state = 24},
  [677] = {.lex_state = 24},
  [678] = {.lex_state = 24},
  [679] = {.lex_state = 24},
  [680] = {.lex_state = 24},
  [681] = {.lex_state = 24},
  [682] = {.lex_state = 49},
  [683] = {.lex_state = 53},
  [684] = {.lex_state = 49},
  [685] = {.lex_state = 53},
  [686] = {.lex_state = 53},
  [687] = {.lex_state = 53},
  [688] = {.lex_state = 53},
  [689] = {.lex_state = 53},
  [690] = {.lex_state = 53},
  [691] = {.lex_state = 53},
  [692] = {.lex_state = 53},
  [693] = {.lex_state = 53},
  [694] = {.lex_state = 49},
  [695] = {.lex_state = 49},
  [696] = {.lex_state = 49},
  [697] = {.lex_state = 49},
  [698] = {.lex_state = 49},
  [699] = {.lex_state = 49},
  [700] = {.lex_state = 53},
  [701] = {.lex_state = 53},
  [702] = {.lex_state = 53},
  [703] = {.lex_state = 49},
  [704] = {.lex_state = 53},
  [705] = {.lex_state = 49},
  [706] = {.lex_state = 49},
  [707] = {.lex_state = 49},
  [708] = {.lex_state = 49},
  [709] = {.lex_state = 49},
  [710] = {.lex_state = 49},
  [711] = {.lex_state = 49},
  [712] = {.lex_state = 49},
  [713] = {.lex_state = 49},
  [714] = {.lex_state = 49},
  [715] = {.lex_state = 53},
  [716] = {.lex_state = 49},
  [717] = {.lex_state = 49},
  [718] = {.lex_state = 49},
  [719] = {.lex_state = 49},
  [720] = {.lex_state = 49},
  [721] = {.lex_state = 49},
  [722] = {.lex_state = 53},
  [723] = {.lex_state = 49},
  [724] = {.lex_state = 53},
  [725] = {.lex_state = 53},
  [726] = {.lex_state = 53},
  [727] = {.lex_state = 49},
  [728] = {.lex_state = 49},
  [729] = {.lex_state = 49},
  [730] = {.lex_state = 53},
  [731] = {.lex_state = 49},
  [732] = {.lex_state = 49},
  [733] = {.lex_state = 49},
  [734] = {.lex_state = 49},
  [735] = {.lex_state = 49},
  [736] = {.lex_state = 49},
  [737] = {.lex_state = 49},
  [738] = {.lex_state = 53},
  [739] = {.lex_state = 49},
  [740] = {.lex_state = 49},
  [741] = {.lex_state = 27},
  [742] = {.lex_state = 27},
  [743] = {.lex_state = 22},
  [744] = {.lex_state = 27},
  [745] = {.lex_state = 27},
  [746] = {.lex_state = 53},
  [747] = {.lex_state = 27},
  [748] = {.lex_state = 27},
  [749] = {.lex_state = 27},
  [750] = {.lex_state = 27},
  [751] = {.lex_state = 27},
  [752] = {.lex_state = 28},
  [753] = {.lex_state = 27},
  [754] = {.lex_state = 27},
  [755] = {.lex_state = 27},
  [756] = {.lex_state = 53},
  [757] = {.lex_state = 27},
  [758] = {.lex_state = 27},
  [759] = {.lex_state = 27},
  [760] = {.lex_state = 27},
  [761] = {.lex_state = 27},
  [762] = {.lex_state = 27},
  [763] = {.lex_state = 53},
  [764] = {.lex_state = 27},
  [765] = {.lex_state = 27},
  [766] = {.lex_state = 27},
  [767] = {.lex_state = 27},
  [768] = {.lex_state = 27},
  [769] = {.lex_state = 27},
  [770] = {.lex_state = 27},
  [771] = {.lex_state = 27},
  [772] = {.lex_state = 27},
  [773] = {.lex_state = 27},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 27},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 53},
  [783] = {.lex_state = 27},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 27},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 53},
  [789] = {.lex_state = 53},
  [790] = {.lex_state = 28},
  [791] = {.lex_state = 53},
  [792] = {.lex_state = 27},
  [793] = {.lex_state = 27},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 27},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 27},
  [802] = {.lex_state = 53},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 53},
  [805] = {.lex_state = 27},
  [806] = {.lex_state = 27},
  [807] = {.lex_state = 27},
  [808] = {.lex_state = 27},
  [809] = {.lex_state = 27},
  [810] = {.lex_state = 27},
  [811] = {.lex_state = 27},
  [812] = {.lex_state = 27},
  [813] = {.lex_state = 27},
  [814] = {.lex_state = 27},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 27},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 27},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 29},
  [863] = {.lex_state = 29},
  [864] = {.lex_state = 29},
  [865] = {.lex_state = 29},
  [866] = {.lex_state = 30},
  [867] = {.lex_state = 30},
  [868] = {.lex_state = 30},
  [869] = {.lex_state = 30},
  [870] = {.lex_state = 30},
  [871] = {.lex_state = 30},
  [872] = {.lex_state = 30},
  [873] = {.lex_state = 30},
  [874] = {.lex_state = 30},
  [875] = {.lex_state = 13},
  [876] = {.lex_state = 16},
  [877] = {.lex_state = 16},
  [878] = {.lex_state = 18},
  [879] = {.lex_state = 18},
  [880] = {.lex_state = 13},
  [881] = {.lex_state = 16},
  [882] = {.lex_state = 13},
  [883] = {.lex_state = 16},
  [884] = {.lex_state = 18},
  [885] = {.lex_state = 13},
  [886] = {.lex_state = 16},
  [887] = {.lex_state = 16},
  [888] = {.lex_state = 13},
  [889] = {.lex_state = 13},
  [890] = {.lex_state = 18},
  [891] = {.lex_state = 18},
  [892] = {.lex_state = 13},
  [893] = {.lex_state = 13},
  [894] = {.lex_state = 16},
  [895] = {.lex_state = 18},
  [896] = {.lex_state = 18},
  [897] = {.lex_state = 13},
  [898] = {.lex_state = 16},
  [899] = {.lex_state = 16},
  [900] = {.lex_state = 18},
  [901] = {.lex_state = 18},
  [902] = {.lex_state = 13},
  [903] = {.lex_state = 16},
  [904] = {.lex_state = 18},
  [905] = {.lex_state = 13},
  [906] = {.lex_state = 16},
  [907] = {.lex_state = 20},
  [908] = {.lex_state = 20},
  [909] = {.lex_state = 18},
  [910] = {.lex_state = 13},
  [911] = {.lex_state = 16},
  [912] = {.lex_state = 18},
  [913] = {.lex_state = 13},
  [914] = {.lex_state = 16},
  [915] = {.lex_state = 16},
  [916] = {.lex_state = 13},
  [917] = {.lex_state = 18},
  [918] = {.lex_state = 13},
  [919] = {.lex_state = 16},
  [920] = {.lex_state = 18},
  [921] = {.lex_state = 13},
  [922] = {.lex_state = 18},
  [923] = {.lex_state = 16},
  [924] = {.lex_state = 16},
  [925] = {.lex_state = 20},
  [926] = {.lex_state = 13},
  [927] = {.lex_state = 16},
  [928] = {.lex_state = 18},
  [929] = {.lex_state = 13},
  [930] = {.lex_state = 16},
  [931] = {.lex_state = 13},
  [932] = {.lex_state = 18},
  [933] = {.lex_state = 18},
  [934] = {.lex_state = 18},
  [935] = {.lex_state = 30},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 30},
  [938] = {.lex_state = 30},
  [939] = {.lex_state = 30},
  [940] = {.lex_state = 30},
  [941] = {.lex_state = 30},
  [942] = {.lex_state = 30},
  [943] = {.lex_state = 30},
  [944] = {.lex_state = 30},
  [945] = {.lex_state = 30},
  [946] = {.lex_state = 30},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 30},
  [949] = {.lex_state = 30},
  [950] = {.lex_state = 30},
  [951] = {.lex_state = 30},
  [952] = {.lex_state = 30},
  [953] = {.lex_state = 30},
  [954] = {.lex_state = 30},
  [955] = {.lex_state = 30},
  [956] = {.lex_state = 30},
  [957] = {.lex_state = 30},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 30},
  [960] = {.lex_state = 30},
  [961] = {.lex_state = 30},
  [962] = {.lex_state = 30},
  [963] = {.lex_state = 30},
  [964] = {.lex_state = 30},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 30},
  [967] = {.lex_state = 30},
  [968] = {.lex_state = 30},
  [969] = {.lex_state = 30},
  [970] = {.lex_state = 30},
  [971] = {.lex_state = 30},
  [972] = {.lex_state = 30},
  [973] = {.lex_state = 30},
  [974] = {.lex_state = 30},
  [975] = {.lex_state = 30},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 27},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 27},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 53},
  [1004] = {.lex_state = 27},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 27},
  [1008] = {.lex_state = 27},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 27},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 27},
  [1015] = {.lex_state = 53},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 27},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 53},
  [1022] = {.lex_state = 27},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 27},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 53},
  [1031] = {.lex_state = 53},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 53},
  [1042] = {.lex_state = 53},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 53},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 53},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1033),
    [sym_function_definition] = STATE(376),
    [sym_if] = STATE(376),
    [sym_while] = STATE(376),
    [sym_repeat] = STATE(376),
    [sym_for] = STATE(376),
    [sym_switch] = STATE(376),
    [sym_call] = STATE(376),
    [sym__assignment] = STATE(376),
    [sym_left_assignment] = STATE(376),
    [sym_left_assignment2] = STATE(376),
    [sym_equals_assignment] = STATE(376),
    [sym_super_assignment] = STATE(376),
    [sym_right_assignment] = STATE(376),
    [sym_brace_list] = STATE(376),
    [sym_paren_list] = STATE(376),
    [sym_subset] = STATE(376),
    [sym_subset2] = STATE(376),
    [sym_dollar] = STATE(376),
    [sym_slot] = STATE(376),
    [sym_namespace_get] = STATE(376),
    [sym_namespace_get_internal] = STATE(376),
    [sym_unary] = STATE(376),
    [sym_binary] = STATE(376),
    [sym_na] = STATE(376),
    [sym__expression] = STATE(376),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(376),
    [sym_string] = STATE(376),
    [aux_sym_program_repeat1] = STATE(87),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(25),
    [sym_next] = ACTIONS(25),
    [sym_true] = ACTIONS(25),
    [sym_false] = ACTIONS(25),
    [sym_null] = ACTIONS(25),
    [sym_inf] = ACTIONS(25),
    [sym_nan] = ACTIONS(25),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [2] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1031),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [3] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1015),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(89),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [4] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1023),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [5] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1021),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(135),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [6] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1001),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(137),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [7] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1055),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(139),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [8] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1048),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(141),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [9] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1038),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [10] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(10),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(148),
    [anon_sym_if] = ACTIONS(151),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_repeat] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_switch] = ACTIONS(168),
    [anon_sym_COMMA] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(174),
    [anon_sym_RBRACK] = ACTIONS(157),
    [sym_dots] = ACTIONS(177),
    [anon_sym_DASH] = ACTIONS(180),
    [anon_sym_PLUS] = ACTIONS(180),
    [anon_sym_BANG] = ACTIONS(183),
    [anon_sym_TILDE] = ACTIONS(186),
    [sym_break] = ACTIONS(189),
    [sym_next] = ACTIONS(189),
    [sym_true] = ACTIONS(189),
    [sym_false] = ACTIONS(189),
    [sym_null] = ACTIONS(189),
    [sym_inf] = ACTIONS(189),
    [sym_nan] = ACTIONS(189),
    [anon_sym_NA] = ACTIONS(192),
    [anon_sym_NA_character_] = ACTIONS(192),
    [anon_sym_NA_complex_] = ACTIONS(192),
    [anon_sym_NA_integer_] = ACTIONS(192),
    [anon_sym_NA_real_] = ACTIONS(192),
    [aux_sym_identifier_token1] = ACTIONS(195),
    [anon_sym_BQUOTE] = ACTIONS(198),
    [sym_integer] = ACTIONS(145),
    [sym_float] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(204),
    [anon_sym_SQUOTE] = ACTIONS(207),
  },
  [11] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1039),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(210),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [12] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1050),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(212),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [13] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(990),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(214),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [14] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(10),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(216),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(216),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [15] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(992),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(220),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [16] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1032),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(222),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [17] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1035),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(224),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [18] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(998),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(226),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [19] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1030),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(228),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [20] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(994),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(230),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [21] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1042),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(232),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [22] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(993),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(234),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [23] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1041),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(236),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [24] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1044),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(238),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [25] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1047),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(240),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [26] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(999),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [27] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_arguments] = STATE(1003),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(33),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(244),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [28] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1045),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(246),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [29] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(996),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [30] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1025),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [31] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1029),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [32] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(32),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_function] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_while] = ACTIONS(264),
    [anon_sym_repeat] = ACTIONS(267),
    [anon_sym_for] = ACTIONS(270),
    [anon_sym_switch] = ACTIONS(273),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(279),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(157),
    [sym_dots] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(285),
    [anon_sym_BANG] = ACTIONS(288),
    [anon_sym_TILDE] = ACTIONS(291),
    [sym_break] = ACTIONS(294),
    [sym_next] = ACTIONS(294),
    [sym_true] = ACTIONS(294),
    [sym_false] = ACTIONS(294),
    [sym_null] = ACTIONS(294),
    [sym_inf] = ACTIONS(294),
    [sym_nan] = ACTIONS(294),
    [anon_sym_NA] = ACTIONS(297),
    [anon_sym_NA_character_] = ACTIONS(297),
    [anon_sym_NA_complex_] = ACTIONS(297),
    [anon_sym_NA_integer_] = ACTIONS(297),
    [anon_sym_NA_real_] = ACTIONS(297),
    [aux_sym_identifier_token1] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(303),
    [sym_integer] = ACTIONS(252),
    [sym_float] = ACTIONS(306),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_SQUOTE] = ACTIONS(312),
  },
  [33] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym__argument] = STATE(746),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(722),
    [aux_sym_arguments_repeat1] = STATE(32),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_COMMA] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(63),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(216),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [34] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1036),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [35] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1017),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [36] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1051),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [37] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1027),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [38] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1005),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [39] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1053),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [40] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(1019),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [41] = {
    [sym_function_definition] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_arguments] = STATE(989),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(90),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(656),
    [aux_sym_arguments_repeat1] = STATE(14),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [42] = {
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(317),
    [anon_sym_else] = ACTIONS(319),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_LT_DASH] = ACTIONS(317),
    [anon_sym_COLON_EQ] = ACTIONS(317),
    [anon_sym_LT_LT_DASH] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(317),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_RBRACK] = ACTIONS(317),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(317),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(317),
    [anon_sym_CARET] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(317),
    [anon_sym_GT_EQ] = ACTIONS(317),
    [anon_sym_EQ_EQ] = ACTIONS(317),
    [anon_sym_BANG_EQ] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(317),
    [sym_integer] = ACTIONS(317),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
    [anon_sym_PERCENT] = ACTIONS(317),
  },
  [43] = {
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(321),
    [anon_sym_RPAREN] = ACTIONS(321),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_COMMA] = ACTIONS(321),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_LT_DASH] = ACTIONS(321),
    [anon_sym_COLON_EQ] = ACTIONS(321),
    [anon_sym_LT_LT_DASH] = ACTIONS(321),
    [anon_sym_DASH_GT] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_RBRACK] = ACTIONS(321),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(321),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(321),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_STAR] = ACTIONS(321),
    [anon_sym_SLASH] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(321),
    [anon_sym_GT_EQ] = ACTIONS(321),
    [anon_sym_EQ_EQ] = ACTIONS(321),
    [anon_sym_BANG_EQ] = ACTIONS(321),
    [anon_sym_PIPE_PIPE] = ACTIONS(321),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(321),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(321),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(321),
    [anon_sym_PERCENT] = ACTIONS(321),
  },
  [44] = {
    [sym_function_definition] = STATE(140),
    [sym_if] = STATE(140),
    [sym_while] = STATE(140),
    [sym_repeat] = STATE(140),
    [sym_for] = STATE(140),
    [sym_switch] = STATE(140),
    [sym_call] = STATE(140),
    [sym__assignment] = STATE(140),
    [sym_left_assignment] = STATE(140),
    [sym_left_assignment2] = STATE(140),
    [sym_equals_assignment] = STATE(140),
    [sym_super_assignment] = STATE(140),
    [sym_right_assignment] = STATE(140),
    [sym_brace_list] = STATE(140),
    [sym_paren_list] = STATE(140),
    [sym_subset] = STATE(140),
    [sym_subset2] = STATE(140),
    [sym_dollar] = STATE(140),
    [sym_slot] = STATE(140),
    [sym_namespace_get] = STATE(140),
    [sym_namespace_get_internal] = STATE(140),
    [sym_unary] = STATE(140),
    [sym_binary] = STATE(140),
    [sym_na] = STATE(140),
    [sym__expression] = STATE(140),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(140),
    [sym_string] = STATE(140),
    [anon_sym_SEMI] = ACTIONS(325),
    [anon_sym_function] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_while] = ACTIONS(327),
    [anon_sym_repeat] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(327),
    [anon_sym_switch] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(325),
    [sym_dots] = ACTIONS(327),
    [anon_sym_DASH] = ACTIONS(325),
    [anon_sym_PLUS] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(325),
    [anon_sym_TILDE] = ACTIONS(325),
    [sym_break] = ACTIONS(327),
    [sym_next] = ACTIONS(327),
    [sym_true] = ACTIONS(327),
    [sym_false] = ACTIONS(327),
    [sym_null] = ACTIONS(327),
    [sym_inf] = ACTIONS(327),
    [sym_nan] = ACTIONS(327),
    [anon_sym_NA] = ACTIONS(327),
    [anon_sym_NA_character_] = ACTIONS(327),
    [anon_sym_NA_complex_] = ACTIONS(327),
    [anon_sym_NA_integer_] = ACTIONS(327),
    [anon_sym_NA_real_] = ACTIONS(327),
    [aux_sym_identifier_token1] = ACTIONS(327),
    [anon_sym_BQUOTE] = ACTIONS(325),
    [sym_integer] = ACTIONS(325),
    [sym_float] = ACTIONS(327),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_SQUOTE] = ACTIONS(325),
  },
  [45] = {
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_else] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_LT_DASH] = ACTIONS(329),
    [anon_sym_COLON_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_DASH] = ACTIONS(329),
    [anon_sym_DASH_GT] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(329),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(329),
    [anon_sym_DOLLAR] = ACTIONS(329),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(329),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(329),
    [anon_sym_STAR] = ACTIONS(329),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(329),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(329),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
    [anon_sym_PERCENT] = ACTIONS(329),
  },
  [46] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(333),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(337),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(339),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(317),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_else] = ACTIONS(319),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(319),
    [anon_sym_LT_DASH] = ACTIONS(319),
    [anon_sym_COLON_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_DASH] = ACTIONS(319),
    [anon_sym_DASH_GT] = ACTIONS(319),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(319),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(319),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(319),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(319),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_STAR] = ACTIONS(319),
    [anon_sym_SLASH] = ACTIONS(319),
    [anon_sym_CARET] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(319),
    [anon_sym_GT_EQ] = ACTIONS(319),
    [anon_sym_EQ_EQ] = ACTIONS(319),
    [anon_sym_BANG_EQ] = ACTIONS(319),
    [anon_sym_PIPE_PIPE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(319),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(319),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym_integer] = ACTIONS(319),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [anon_sym_SQUOTE] = ACTIONS(319),
    [anon_sym_PERCENT] = ACTIONS(319),
  },
  [48] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(361),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [49] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(383),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [50] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [51] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(49),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(391),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [52] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(393),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(393),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(393),
    [anon_sym_GT_EQ] = ACTIONS(393),
    [anon_sym_EQ_EQ] = ACTIONS(393),
    [anon_sym_BANG_EQ] = ACTIONS(393),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(393),
    [anon_sym_COLON] = ACTIONS(395),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(393),
  },
  [53] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(50),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [54] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(411),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [55] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [56] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(54),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(415),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [57] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(55),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [58] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(419),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [59] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [60] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(58),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(423),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [61] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(59),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [62] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(427),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [63] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [64] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(62),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(431),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [65] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [66] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(91),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(435),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [67] = {
    [sym_function_definition] = STATE(376),
    [sym_if] = STATE(376),
    [sym_while] = STATE(376),
    [sym_repeat] = STATE(376),
    [sym_for] = STATE(376),
    [sym_switch] = STATE(376),
    [sym_call] = STATE(376),
    [sym__assignment] = STATE(376),
    [sym_left_assignment] = STATE(376),
    [sym_left_assignment2] = STATE(376),
    [sym_equals_assignment] = STATE(376),
    [sym_super_assignment] = STATE(376),
    [sym_right_assignment] = STATE(376),
    [sym_brace_list] = STATE(376),
    [sym_paren_list] = STATE(376),
    [sym_subset] = STATE(376),
    [sym_subset2] = STATE(376),
    [sym_dollar] = STATE(376),
    [sym_slot] = STATE(376),
    [sym_namespace_get] = STATE(376),
    [sym_namespace_get_internal] = STATE(376),
    [sym_unary] = STATE(376),
    [sym_binary] = STATE(376),
    [sym_na] = STATE(376),
    [sym__expression] = STATE(376),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(376),
    [sym_string] = STATE(376),
    [aux_sym_program_repeat1] = STATE(67),
    [ts_builtin_sym_end] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(442),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(448),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_repeat] = ACTIONS(454),
    [anon_sym_for] = ACTIONS(457),
    [anon_sym_switch] = ACTIONS(460),
    [anon_sym_LBRACE] = ACTIONS(463),
    [sym_dots] = ACTIONS(466),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(472),
    [anon_sym_TILDE] = ACTIONS(475),
    [sym_break] = ACTIONS(466),
    [sym_next] = ACTIONS(466),
    [sym_true] = ACTIONS(466),
    [sym_false] = ACTIONS(466),
    [sym_null] = ACTIONS(466),
    [sym_inf] = ACTIONS(466),
    [sym_nan] = ACTIONS(466),
    [anon_sym_NA] = ACTIONS(478),
    [anon_sym_NA_character_] = ACTIONS(478),
    [anon_sym_NA_complex_] = ACTIONS(478),
    [anon_sym_NA_integer_] = ACTIONS(478),
    [anon_sym_NA_real_] = ACTIONS(478),
    [aux_sym_identifier_token1] = ACTIONS(481),
    [anon_sym_BQUOTE] = ACTIONS(484),
    [sym_integer] = ACTIONS(439),
    [sym_float] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(490),
    [anon_sym_SQUOTE] = ACTIONS(493),
  },
  [68] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(124),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [69] = {
    [sym_function_definition] = STATE(442),
    [sym_if] = STATE(442),
    [sym_while] = STATE(442),
    [sym_repeat] = STATE(442),
    [sym_for] = STATE(442),
    [sym_switch] = STATE(442),
    [sym_call] = STATE(442),
    [sym__assignment] = STATE(442),
    [sym_left_assignment] = STATE(442),
    [sym_left_assignment2] = STATE(442),
    [sym_equals_assignment] = STATE(442),
    [sym_super_assignment] = STATE(442),
    [sym_right_assignment] = STATE(442),
    [sym_brace_list] = STATE(442),
    [sym_paren_list] = STATE(442),
    [sym_subset] = STATE(442),
    [sym_subset2] = STATE(442),
    [sym_dollar] = STATE(442),
    [sym_slot] = STATE(442),
    [sym_namespace_get] = STATE(442),
    [sym_namespace_get_internal] = STATE(442),
    [sym_unary] = STATE(442),
    [sym_binary] = STATE(442),
    [sym_na] = STATE(442),
    [sym__expression] = STATE(442),
    [sym_identifier] = STATE(139),
    [sym_complex] = STATE(442),
    [sym_string] = STATE(442),
    [anon_sym_SEMI] = ACTIONS(325),
    [anon_sym_function] = ACTIONS(327),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_while] = ACTIONS(327),
    [anon_sym_repeat] = ACTIONS(327),
    [anon_sym_for] = ACTIONS(327),
    [anon_sym_switch] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(325),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(325),
    [sym_dots] = ACTIONS(327),
    [anon_sym_DASH] = ACTIONS(325),
    [anon_sym_PLUS] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(325),
    [anon_sym_TILDE] = ACTIONS(325),
    [sym_break] = ACTIONS(327),
    [sym_next] = ACTIONS(327),
    [sym_true] = ACTIONS(327),
    [sym_false] = ACTIONS(327),
    [sym_null] = ACTIONS(327),
    [sym_inf] = ACTIONS(327),
    [sym_nan] = ACTIONS(327),
    [anon_sym_NA] = ACTIONS(327),
    [anon_sym_NA_character_] = ACTIONS(327),
    [anon_sym_NA_complex_] = ACTIONS(327),
    [anon_sym_NA_integer_] = ACTIONS(327),
    [anon_sym_NA_real_] = ACTIONS(327),
    [aux_sym_identifier_token1] = ACTIONS(327),
    [anon_sym_BQUOTE] = ACTIONS(325),
    [sym_integer] = ACTIONS(325),
    [sym_float] = ACTIONS(327),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_SQUOTE] = ACTIONS(325),
  },
  [70] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(498),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [71] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(48),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(500),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [72] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(70),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(502),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [73] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(393),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [74] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(520),
    [anon_sym_else] = ACTIONS(524),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_COMMA] = ACTIONS(520),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(520),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(520),
    [sym_integer] = ACTIONS(520),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(520),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [75] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(546),
    [anon_sym_function] = ACTIONS(549),
    [anon_sym_if] = ACTIONS(552),
    [anon_sym_LPAREN] = ACTIONS(555),
    [anon_sym_RPAREN] = ACTIONS(558),
    [anon_sym_while] = ACTIONS(560),
    [anon_sym_repeat] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_switch] = ACTIONS(569),
    [anon_sym_LBRACE] = ACTIONS(572),
    [sym_dots] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(578),
    [anon_sym_PLUS] = ACTIONS(578),
    [anon_sym_BANG] = ACTIONS(581),
    [anon_sym_TILDE] = ACTIONS(584),
    [sym_break] = ACTIONS(575),
    [sym_next] = ACTIONS(575),
    [sym_true] = ACTIONS(575),
    [sym_false] = ACTIONS(575),
    [sym_null] = ACTIONS(575),
    [sym_inf] = ACTIONS(575),
    [sym_nan] = ACTIONS(575),
    [anon_sym_NA] = ACTIONS(587),
    [anon_sym_NA_character_] = ACTIONS(587),
    [anon_sym_NA_complex_] = ACTIONS(587),
    [anon_sym_NA_integer_] = ACTIONS(587),
    [anon_sym_NA_real_] = ACTIONS(587),
    [aux_sym_identifier_token1] = ACTIONS(590),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [sym_integer] = ACTIONS(546),
    [sym_float] = ACTIONS(596),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(599),
    [anon_sym_SQUOTE] = ACTIONS(602),
  },
  [76] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(393),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [77] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(605),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [78] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_function] = ACTIONS(609),
    [anon_sym_if] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(607),
    [anon_sym_else] = ACTIONS(609),
    [anon_sym_while] = ACTIONS(609),
    [anon_sym_repeat] = ACTIONS(609),
    [anon_sym_for] = ACTIONS(609),
    [anon_sym_switch] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(607),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(609),
    [sym_next] = ACTIONS(609),
    [sym_true] = ACTIONS(609),
    [sym_false] = ACTIONS(609),
    [sym_null] = ACTIONS(609),
    [sym_inf] = ACTIONS(609),
    [sym_nan] = ACTIONS(609),
    [anon_sym_NA] = ACTIONS(609),
    [anon_sym_NA_character_] = ACTIONS(609),
    [anon_sym_NA_complex_] = ACTIONS(609),
    [anon_sym_NA_integer_] = ACTIONS(609),
    [anon_sym_NA_real_] = ACTIONS(609),
    [aux_sym_identifier_token1] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(607),
    [sym_integer] = ACTIONS(607),
    [sym_float] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(607),
    [anon_sym_SQUOTE] = ACTIONS(607),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [79] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(77),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(611),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(329),
    [anon_sym_LF] = ACTIONS(331),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_else] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(331),
    [anon_sym_COLON_EQ] = ACTIONS(331),
    [anon_sym_LT_LT_DASH] = ACTIONS(331),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(331),
    [anon_sym_DOLLAR] = ACTIONS(331),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(331),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(331),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(331),
    [anon_sym_GT_EQ] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_BANG_EQ] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(331),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(331),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(331),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(331),
    [sym_integer] = ACTIONS(331),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(331),
    [anon_sym_SQUOTE] = ACTIONS(331),
    [anon_sym_PERCENT] = ACTIONS(331),
  },
  [81] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(613),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [82] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [83] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(81),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(617),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [84] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(82),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(619),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [85] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(621),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [86] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(520),
    [anon_sym_else] = ACTIONS(623),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_COMMA] = ACTIONS(520),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(520),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(520),
    [sym_integer] = ACTIONS(520),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(520),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [87] = {
    [sym_function_definition] = STATE(376),
    [sym_if] = STATE(376),
    [sym_while] = STATE(376),
    [sym_repeat] = STATE(376),
    [sym_for] = STATE(376),
    [sym_switch] = STATE(376),
    [sym_call] = STATE(376),
    [sym__assignment] = STATE(376),
    [sym_left_assignment] = STATE(376),
    [sym_left_assignment2] = STATE(376),
    [sym_equals_assignment] = STATE(376),
    [sym_super_assignment] = STATE(376),
    [sym_right_assignment] = STATE(376),
    [sym_brace_list] = STATE(376),
    [sym_paren_list] = STATE(376),
    [sym_subset] = STATE(376),
    [sym_subset2] = STATE(376),
    [sym_dollar] = STATE(376),
    [sym_slot] = STATE(376),
    [sym_namespace_get] = STATE(376),
    [sym_namespace_get_internal] = STATE(376),
    [sym_unary] = STATE(376),
    [sym_binary] = STATE(376),
    [sym_na] = STATE(376),
    [sym__expression] = STATE(376),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(376),
    [sym_string] = STATE(376),
    [aux_sym_program_repeat1] = STATE(67),
    [ts_builtin_sym_end] = ACTIONS(625),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(25),
    [sym_next] = ACTIONS(25),
    [sym_true] = ACTIONS(25),
    [sym_false] = ACTIONS(25),
    [sym_null] = ACTIONS(25),
    [sym_inf] = ACTIONS(25),
    [sym_nan] = ACTIONS(25),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [88] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(627),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [89] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(63),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(629),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [90] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(631),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(333),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(633),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(635),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [91] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(637),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [92] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(333),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [anon_sym_i] = ACTIONS(639),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [93] = {
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [anon_sym_COLON_COLON] = ACTIONS(641),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(643),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [94] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(65),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(645),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [95] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(647),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(321),
    [anon_sym_LF] = ACTIONS(323),
    [anon_sym_SEMI] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(323),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_AT] = ACTIONS(323),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(323),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(323),
    [anon_sym_SLASH] = ACTIONS(323),
    [anon_sym_CARET] = ACTIONS(323),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(323),
    [anon_sym_GT_EQ] = ACTIONS(323),
    [anon_sym_EQ_EQ] = ACTIONS(323),
    [anon_sym_BANG_EQ] = ACTIONS(323),
    [anon_sym_PIPE_PIPE] = ACTIONS(323),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(323),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_SQUOTE] = ACTIONS(323),
    [anon_sym_PERCENT] = ACTIONS(323),
  },
  [97] = {
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_LT_DASH] = ACTIONS(317),
    [anon_sym_COLON_EQ] = ACTIONS(317),
    [anon_sym_LT_LT_DASH] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(317),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_RBRACK] = ACTIONS(317),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(317),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(317),
    [anon_sym_CARET] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(317),
    [anon_sym_GT_EQ] = ACTIONS(317),
    [anon_sym_EQ_EQ] = ACTIONS(317),
    [anon_sym_BANG_EQ] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(317),
    [sym_integer] = ACTIONS(317),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
    [anon_sym_PERCENT] = ACTIONS(317),
  },
  [98] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(98),
    [anon_sym_SEMI] = ACTIONS(649),
    [anon_sym_function] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_LPAREN] = ACTIONS(658),
    [anon_sym_while] = ACTIONS(661),
    [anon_sym_repeat] = ACTIONS(664),
    [anon_sym_for] = ACTIONS(667),
    [anon_sym_switch] = ACTIONS(670),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_RBRACE] = ACTIONS(437),
    [sym_dots] = ACTIONS(676),
    [anon_sym_DASH] = ACTIONS(679),
    [anon_sym_PLUS] = ACTIONS(679),
    [anon_sym_BANG] = ACTIONS(682),
    [anon_sym_TILDE] = ACTIONS(685),
    [sym_break] = ACTIONS(676),
    [sym_next] = ACTIONS(676),
    [sym_true] = ACTIONS(676),
    [sym_false] = ACTIONS(676),
    [sym_null] = ACTIONS(676),
    [sym_inf] = ACTIONS(676),
    [sym_nan] = ACTIONS(676),
    [anon_sym_NA] = ACTIONS(688),
    [anon_sym_NA_character_] = ACTIONS(688),
    [anon_sym_NA_complex_] = ACTIONS(688),
    [anon_sym_NA_integer_] = ACTIONS(688),
    [anon_sym_NA_real_] = ACTIONS(688),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(694),
    [sym_integer] = ACTIONS(649),
    [sym_float] = ACTIONS(697),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(703),
  },
  [99] = {
    [anon_sym_LF] = ACTIONS(323),
    [anon_sym_SEMI] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(323),
    [anon_sym_RBRACE] = ACTIONS(323),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_AT] = ACTIONS(323),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(323),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(323),
    [anon_sym_SLASH] = ACTIONS(323),
    [anon_sym_CARET] = ACTIONS(323),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(323),
    [anon_sym_GT_EQ] = ACTIONS(323),
    [anon_sym_EQ_EQ] = ACTIONS(323),
    [anon_sym_BANG_EQ] = ACTIONS(323),
    [anon_sym_PIPE_PIPE] = ACTIONS(323),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(323),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_SQUOTE] = ACTIONS(323),
    [anon_sym_PERCENT] = ACTIONS(323),
  },
  [100] = {
    [anon_sym_LF] = ACTIONS(331),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_else] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_RBRACE] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(331),
    [anon_sym_COLON_EQ] = ACTIONS(331),
    [anon_sym_LT_LT_DASH] = ACTIONS(331),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(331),
    [anon_sym_DOLLAR] = ACTIONS(331),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(331),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(331),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(331),
    [anon_sym_GT_EQ] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_BANG_EQ] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(331),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(331),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(331),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(331),
    [sym_integer] = ACTIONS(331),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(331),
    [anon_sym_SQUOTE] = ACTIONS(331),
    [anon_sym_PERCENT] = ACTIONS(331),
  },
  [101] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(706),
    [anon_sym_else] = ACTIONS(708),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_repeat] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(706),
    [anon_sym_LT_DASH] = ACTIONS(706),
    [anon_sym_COLON_EQ] = ACTIONS(706),
    [anon_sym_LT_LT_DASH] = ACTIONS(706),
    [anon_sym_DASH_GT] = ACTIONS(706),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(706),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(708),
    [sym_next] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_inf] = ACTIONS(708),
    [sym_nan] = ACTIONS(708),
    [anon_sym_NA] = ACTIONS(708),
    [anon_sym_NA_character_] = ACTIONS(708),
    [anon_sym_NA_complex_] = ACTIONS(708),
    [anon_sym_NA_integer_] = ACTIONS(708),
    [anon_sym_NA_real_] = ACTIONS(708),
    [aux_sym_identifier_token1] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(706),
    [sym_integer] = ACTIONS(706),
    [sym_float] = ACTIONS(708),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(706),
    [anon_sym_SQUOTE] = ACTIONS(706),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [102] = {
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_else] = ACTIONS(319),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(319),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_LT_DASH] = ACTIONS(319),
    [anon_sym_COLON_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_DASH] = ACTIONS(319),
    [anon_sym_DASH_GT] = ACTIONS(319),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(319),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(319),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(319),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(319),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_STAR] = ACTIONS(319),
    [anon_sym_SLASH] = ACTIONS(319),
    [anon_sym_CARET] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(319),
    [anon_sym_GT_EQ] = ACTIONS(319),
    [anon_sym_EQ_EQ] = ACTIONS(319),
    [anon_sym_BANG_EQ] = ACTIONS(319),
    [anon_sym_PIPE_PIPE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(319),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(319),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym_integer] = ACTIONS(319),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [anon_sym_SQUOTE] = ACTIONS(319),
    [anon_sym_PERCENT] = ACTIONS(319),
  },
  [103] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(710),
    [sym_integer] = ACTIONS(710),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(710),
    [anon_sym_SQUOTE] = ACTIONS(710),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [104] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(714),
    [anon_sym_function] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(714),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(714),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(714),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(716),
    [sym_next] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_inf] = ACTIONS(716),
    [sym_nan] = ACTIONS(716),
    [anon_sym_NA] = ACTIONS(716),
    [anon_sym_NA_character_] = ACTIONS(716),
    [anon_sym_NA_complex_] = ACTIONS(716),
    [anon_sym_NA_integer_] = ACTIONS(716),
    [anon_sym_NA_real_] = ACTIONS(716),
    [aux_sym_identifier_token1] = ACTIONS(716),
    [anon_sym_BQUOTE] = ACTIONS(714),
    [sym_integer] = ACTIONS(714),
    [sym_float] = ACTIONS(716),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(714),
    [anon_sym_SQUOTE] = ACTIONS(714),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [105] = {
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_LT_DASH] = ACTIONS(329),
    [anon_sym_COLON_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_DASH] = ACTIONS(329),
    [anon_sym_DASH_GT] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(329),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(329),
    [anon_sym_DOLLAR] = ACTIONS(329),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(329),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(329),
    [anon_sym_STAR] = ACTIONS(329),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(329),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(329),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
    [anon_sym_PERCENT] = ACTIONS(329),
  },
  [106] = {
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_else] = ACTIONS(319),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_LT_DASH] = ACTIONS(317),
    [anon_sym_COLON_EQ] = ACTIONS(317),
    [anon_sym_LT_LT_DASH] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(317),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(317),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(317),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(317),
    [anon_sym_CARET] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(317),
    [anon_sym_GT_EQ] = ACTIONS(317),
    [anon_sym_EQ_EQ] = ACTIONS(317),
    [anon_sym_BANG_EQ] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(317),
    [sym_integer] = ACTIONS(317),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
    [anon_sym_PERCENT] = ACTIONS(317),
  },
  [107] = {
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_else] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_LT_DASH] = ACTIONS(329),
    [anon_sym_COLON_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_DASH] = ACTIONS(329),
    [anon_sym_DASH_GT] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(329),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(329),
    [anon_sym_DOLLAR] = ACTIONS(329),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(329),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(329),
    [anon_sym_STAR] = ACTIONS(329),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(329),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(329),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
    [anon_sym_PERCENT] = ACTIONS(329),
  },
  [108] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_function] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(718),
    [anon_sym_else] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_repeat] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(718),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(720),
    [sym_next] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_inf] = ACTIONS(720),
    [sym_nan] = ACTIONS(720),
    [anon_sym_NA] = ACTIONS(720),
    [anon_sym_NA_character_] = ACTIONS(720),
    [anon_sym_NA_complex_] = ACTIONS(720),
    [anon_sym_NA_integer_] = ACTIONS(720),
    [anon_sym_NA_real_] = ACTIONS(720),
    [aux_sym_identifier_token1] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(718),
    [sym_integer] = ACTIONS(718),
    [sym_float] = ACTIONS(720),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(718),
    [anon_sym_SQUOTE] = ACTIONS(718),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [109] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_function] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(722),
    [anon_sym_else] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_repeat] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_COMMA] = ACTIONS(722),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(722),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(724),
    [sym_next] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_inf] = ACTIONS(724),
    [sym_nan] = ACTIONS(724),
    [anon_sym_NA] = ACTIONS(724),
    [anon_sym_NA_character_] = ACTIONS(724),
    [anon_sym_NA_complex_] = ACTIONS(724),
    [anon_sym_NA_integer_] = ACTIONS(724),
    [anon_sym_NA_real_] = ACTIONS(724),
    [aux_sym_identifier_token1] = ACTIONS(724),
    [anon_sym_BQUOTE] = ACTIONS(722),
    [sym_integer] = ACTIONS(722),
    [sym_float] = ACTIONS(724),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [110] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(726),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_repeat] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_COMMA] = ACTIONS(726),
    [anon_sym_EQ] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_LT_DASH] = ACTIONS(726),
    [anon_sym_COLON_EQ] = ACTIONS(726),
    [anon_sym_LT_LT_DASH] = ACTIONS(726),
    [anon_sym_DASH_GT] = ACTIONS(726),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(726),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(728),
    [sym_next] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_inf] = ACTIONS(728),
    [sym_nan] = ACTIONS(728),
    [anon_sym_NA] = ACTIONS(728),
    [anon_sym_NA_character_] = ACTIONS(728),
    [anon_sym_NA_complex_] = ACTIONS(728),
    [anon_sym_NA_integer_] = ACTIONS(728),
    [anon_sym_NA_real_] = ACTIONS(728),
    [aux_sym_identifier_token1] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(726),
    [sym_integer] = ACTIONS(726),
    [sym_float] = ACTIONS(728),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(726),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [111] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(333),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(633),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(635),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [112] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(730),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(732),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [113] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [114] = {
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(321),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_COMMA] = ACTIONS(321),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_LT_DASH] = ACTIONS(321),
    [anon_sym_COLON_EQ] = ACTIONS(321),
    [anon_sym_LT_LT_DASH] = ACTIONS(321),
    [anon_sym_DASH_GT] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(321),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(321),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(321),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_STAR] = ACTIONS(321),
    [anon_sym_SLASH] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(321),
    [anon_sym_GT_EQ] = ACTIONS(321),
    [anon_sym_EQ_EQ] = ACTIONS(321),
    [anon_sym_BANG_EQ] = ACTIONS(321),
    [anon_sym_PIPE_PIPE] = ACTIONS(321),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(321),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(321),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(321),
    [anon_sym_PERCENT] = ACTIONS(321),
  },
  [115] = {
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(321),
    [anon_sym_RPAREN] = ACTIONS(321),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_COMMA] = ACTIONS(321),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_LT_DASH] = ACTIONS(321),
    [anon_sym_COLON_EQ] = ACTIONS(321),
    [anon_sym_LT_LT_DASH] = ACTIONS(321),
    [anon_sym_DASH_GT] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_RBRACK] = ACTIONS(321),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(321),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(321),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_STAR] = ACTIONS(321),
    [anon_sym_SLASH] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(321),
    [anon_sym_GT_EQ] = ACTIONS(321),
    [anon_sym_EQ_EQ] = ACTIONS(321),
    [anon_sym_BANG_EQ] = ACTIONS(321),
    [anon_sym_PIPE_PIPE] = ACTIONS(321),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(321),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(321),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(321),
    [anon_sym_PERCENT] = ACTIONS(321),
  },
  [116] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [117] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [118] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [119] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [120] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [121] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [122] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(333),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [anon_sym_COLON_COLON] = ACTIONS(738),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(740),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [124] = {
    [sym_function_definition] = STATE(730),
    [sym_if] = STATE(730),
    [sym_while] = STATE(730),
    [sym_repeat] = STATE(730),
    [sym_for] = STATE(730),
    [sym_switch] = STATE(730),
    [sym_call] = STATE(730),
    [sym__assignment] = STATE(730),
    [sym_left_assignment] = STATE(730),
    [sym_left_assignment2] = STATE(730),
    [sym_equals_assignment] = STATE(730),
    [sym_super_assignment] = STATE(730),
    [sym_right_assignment] = STATE(730),
    [sym_brace_list] = STATE(730),
    [sym_paren_list] = STATE(730),
    [sym_subset] = STATE(730),
    [sym_subset2] = STATE(730),
    [sym_dollar] = STATE(730),
    [sym_slot] = STATE(730),
    [sym_namespace_get] = STATE(730),
    [sym_namespace_get_internal] = STATE(730),
    [sym_unary] = STATE(730),
    [sym_binary] = STATE(730),
    [sym_na] = STATE(730),
    [sym__expression] = STATE(730),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(730),
    [sym_string] = STATE(730),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_RPAREN] = ACTIONS(742),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(385),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [125] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [126] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [aux_sym_program_repeat1] = STATE(88),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(744),
    [sym_dots] = ACTIONS(363),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(363),
    [sym_next] = ACTIONS(363),
    [sym_true] = ACTIONS(363),
    [sym_false] = ACTIONS(363),
    [sym_null] = ACTIONS(363),
    [sym_inf] = ACTIONS(363),
    [sym_nan] = ACTIONS(363),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(343),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [127] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(746),
    [sym_integer] = ACTIONS(746),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [128] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(750),
    [anon_sym_function] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(750),
    [anon_sym_else] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_repeat] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(750),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(750),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(752),
    [sym_next] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_inf] = ACTIONS(752),
    [sym_nan] = ACTIONS(752),
    [anon_sym_NA] = ACTIONS(752),
    [anon_sym_NA_character_] = ACTIONS(752),
    [anon_sym_NA_complex_] = ACTIONS(752),
    [anon_sym_NA_integer_] = ACTIONS(752),
    [anon_sym_NA_real_] = ACTIONS(752),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_integer] = ACTIONS(750),
    [sym_float] = ACTIONS(752),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(750),
    [anon_sym_SQUOTE] = ACTIONS(750),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [129] = {
    [sym_special] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(754),
    [anon_sym_function] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_RPAREN] = ACTIONS(754),
    [anon_sym_else] = ACTIONS(756),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_repeat] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_COMMA] = ACTIONS(754),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_LT_DASH] = ACTIONS(528),
    [anon_sym_COLON_EQ] = ACTIONS(530),
    [anon_sym_LT_LT_DASH] = ACTIONS(532),
    [anon_sym_DASH_GT] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_RBRACK] = ACTIONS(754),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(405),
    [sym_dots] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(508),
    [anon_sym_SLASH] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(540),
    [anon_sym_AMP_AMP] = ACTIONS(542),
    [anon_sym_AMP] = ACTIONS(544),
    [anon_sym_PIPE_GT] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(516),
    [sym_break] = ACTIONS(756),
    [sym_next] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_inf] = ACTIONS(756),
    [sym_nan] = ACTIONS(756),
    [anon_sym_NA] = ACTIONS(756),
    [anon_sym_NA_character_] = ACTIONS(756),
    [anon_sym_NA_complex_] = ACTIONS(756),
    [anon_sym_NA_integer_] = ACTIONS(756),
    [anon_sym_NA_real_] = ACTIONS(756),
    [aux_sym_identifier_token1] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(754),
    [sym_integer] = ACTIONS(754),
    [sym_float] = ACTIONS(756),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(754),
    [anon_sym_SQUOTE] = ACTIONS(754),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [130] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(728),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_repeat] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_EQ] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_RBRACE] = ACTIONS(728),
    [anon_sym_LT_DASH] = ACTIONS(728),
    [anon_sym_COLON_EQ] = ACTIONS(728),
    [anon_sym_LT_LT_DASH] = ACTIONS(728),
    [anon_sym_DASH_GT] = ACTIONS(728),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(728),
    [sym_next] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_inf] = ACTIONS(728),
    [sym_nan] = ACTIONS(728),
    [anon_sym_NA] = ACTIONS(728),
    [anon_sym_NA_character_] = ACTIONS(728),
    [anon_sym_NA_complex_] = ACTIONS(728),
    [anon_sym_NA_integer_] = ACTIONS(728),
    [anon_sym_NA_real_] = ACTIONS(728),
    [aux_sym_identifier_token1] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(728),
    [sym_integer] = ACTIONS(728),
    [sym_float] = ACTIONS(728),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [131] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_LT_DASH] = ACTIONS(395),
    [anon_sym_COLON_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_DASH] = ACTIONS(395),
    [anon_sym_DASH_GT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(395),
    [sym_integer] = ACTIONS(395),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [132] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(720),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_repeat] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_RBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(720),
    [sym_next] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_inf] = ACTIONS(720),
    [sym_nan] = ACTIONS(720),
    [anon_sym_NA] = ACTIONS(720),
    [anon_sym_NA_character_] = ACTIONS(720),
    [anon_sym_NA_complex_] = ACTIONS(720),
    [anon_sym_NA_integer_] = ACTIONS(720),
    [anon_sym_NA_real_] = ACTIONS(720),
    [aux_sym_identifier_token1] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(720),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [133] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(716),
    [anon_sym_function] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_RBRACE] = ACTIONS(716),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(716),
    [sym_next] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_inf] = ACTIONS(716),
    [sym_nan] = ACTIONS(716),
    [anon_sym_NA] = ACTIONS(716),
    [anon_sym_NA_character_] = ACTIONS(716),
    [anon_sym_NA_complex_] = ACTIONS(716),
    [anon_sym_NA_integer_] = ACTIONS(716),
    [anon_sym_NA_real_] = ACTIONS(716),
    [aux_sym_identifier_token1] = ACTIONS(716),
    [anon_sym_BQUOTE] = ACTIONS(716),
    [sym_integer] = ACTIONS(716),
    [sym_float] = ACTIONS(716),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(716),
    [anon_sym_SQUOTE] = ACTIONS(716),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [134] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(712),
    [anon_sym_SEMI] = ACTIONS(712),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(712),
    [anon_sym_RBRACE] = ACTIONS(712),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(712),
    [sym_integer] = ACTIONS(712),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(712),
    [anon_sym_SQUOTE] = ACTIONS(712),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [135] = {
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_LT_DASH] = ACTIONS(317),
    [anon_sym_COLON_EQ] = ACTIONS(317),
    [anon_sym_LT_LT_DASH] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(317),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(317),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(317),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(317),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(317),
    [anon_sym_CARET] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(317),
    [anon_sym_GT_EQ] = ACTIONS(317),
    [anon_sym_EQ_EQ] = ACTIONS(317),
    [anon_sym_BANG_EQ] = ACTIONS(317),
    [anon_sym_PIPE_PIPE] = ACTIONS(317),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(317),
    [sym_integer] = ACTIONS(317),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
    [anon_sym_PERCENT] = ACTIONS(317),
  },
  [136] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(520),
    [anon_sym_LF] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(522),
    [sym_integer] = ACTIONS(522),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(522),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [137] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(708),
    [anon_sym_SEMI] = ACTIONS(708),
    [anon_sym_function] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(708),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_repeat] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(708),
    [anon_sym_RBRACE] = ACTIONS(708),
    [anon_sym_LT_DASH] = ACTIONS(708),
    [anon_sym_COLON_EQ] = ACTIONS(708),
    [anon_sym_LT_LT_DASH] = ACTIONS(708),
    [anon_sym_DASH_GT] = ACTIONS(708),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(708),
    [sym_next] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_inf] = ACTIONS(708),
    [sym_nan] = ACTIONS(708),
    [anon_sym_NA] = ACTIONS(708),
    [anon_sym_NA_character_] = ACTIONS(708),
    [anon_sym_NA_complex_] = ACTIONS(708),
    [anon_sym_NA_integer_] = ACTIONS(708),
    [anon_sym_NA_real_] = ACTIONS(708),
    [aux_sym_identifier_token1] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(708),
    [sym_integer] = ACTIONS(708),
    [sym_float] = ACTIONS(708),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(708),
    [anon_sym_SQUOTE] = ACTIONS(708),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [138] = {
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_LT_DASH] = ACTIONS(329),
    [anon_sym_COLON_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_DASH] = ACTIONS(329),
    [anon_sym_DASH_GT] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(329),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(329),
    [anon_sym_DOLLAR] = ACTIONS(329),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(329),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(329),
    [anon_sym_STAR] = ACTIONS(329),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(329),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(329),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
    [anon_sym_PERCENT] = ACTIONS(329),
  },
  [139] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(838),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(840),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [140] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(842),
    [anon_sym_function] = ACTIONS(844),
    [anon_sym_if] = ACTIONS(844),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(842),
    [anon_sym_while] = ACTIONS(844),
    [anon_sym_repeat] = ACTIONS(844),
    [anon_sym_for] = ACTIONS(844),
    [anon_sym_switch] = ACTIONS(844),
    [anon_sym_COMMA] = ACTIONS(842),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(842),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(842),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(844),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(844),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(844),
    [sym_next] = ACTIONS(844),
    [sym_true] = ACTIONS(844),
    [sym_false] = ACTIONS(844),
    [sym_null] = ACTIONS(844),
    [sym_inf] = ACTIONS(844),
    [sym_nan] = ACTIONS(844),
    [anon_sym_NA] = ACTIONS(844),
    [anon_sym_NA_character_] = ACTIONS(844),
    [anon_sym_NA_complex_] = ACTIONS(844),
    [anon_sym_NA_integer_] = ACTIONS(844),
    [anon_sym_NA_real_] = ACTIONS(844),
    [aux_sym_identifier_token1] = ACTIONS(844),
    [anon_sym_BQUOTE] = ACTIONS(842),
    [sym_integer] = ACTIONS(842),
    [sym_float] = ACTIONS(844),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(842),
    [anon_sym_SQUOTE] = ACTIONS(842),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [141] = {
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(321),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_COMMA] = ACTIONS(321),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_LT_DASH] = ACTIONS(321),
    [anon_sym_COLON_EQ] = ACTIONS(321),
    [anon_sym_LT_LT_DASH] = ACTIONS(321),
    [anon_sym_DASH_GT] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(321),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(321),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(321),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_STAR] = ACTIONS(321),
    [anon_sym_SLASH] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(321),
    [anon_sym_GT_EQ] = ACTIONS(321),
    [anon_sym_EQ_EQ] = ACTIONS(321),
    [anon_sym_BANG_EQ] = ACTIONS(321),
    [anon_sym_PIPE_PIPE] = ACTIONS(321),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(321),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(321),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(321),
    [anon_sym_PERCENT] = ACTIONS(321),
  },
  [142] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(393),
    [anon_sym_LF] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_LT_DASH] = ACTIONS(395),
    [anon_sym_COLON_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_DASH] = ACTIONS(395),
    [anon_sym_DASH_GT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(395),
    [anon_sym_SLASH] = ACTIONS(395),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(395),
    [anon_sym_GT_EQ] = ACTIONS(395),
    [anon_sym_EQ_EQ] = ACTIONS(395),
    [anon_sym_BANG_EQ] = ACTIONS(395),
    [anon_sym_PIPE_PIPE] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(395),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(395),
    [anon_sym_COLON] = ACTIONS(395),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(395),
    [sym_integer] = ACTIONS(395),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(395),
  },
  [143] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [144] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [145] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [146] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [147] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [148] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [149] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [150] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [151] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [152] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(748),
    [anon_sym_RBRACE] = ACTIONS(748),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(748),
    [sym_integer] = ACTIONS(748),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(748),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [153] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(752),
    [anon_sym_function] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_repeat] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_RBRACE] = ACTIONS(752),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(752),
    [sym_next] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_inf] = ACTIONS(752),
    [sym_nan] = ACTIONS(752),
    [anon_sym_NA] = ACTIONS(752),
    [anon_sym_NA_character_] = ACTIONS(752),
    [anon_sym_NA_complex_] = ACTIONS(752),
    [anon_sym_NA_integer_] = ACTIONS(752),
    [anon_sym_NA_real_] = ACTIONS(752),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(752),
    [sym_integer] = ACTIONS(752),
    [sym_float] = ACTIONS(752),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(752),
    [anon_sym_SQUOTE] = ACTIONS(752),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [154] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(333),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [anon_sym_i] = ACTIONS(892),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [155] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(756),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_function] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(756),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_repeat] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(756),
    [anon_sym_RBRACE] = ACTIONS(756),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(756),
    [sym_next] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_inf] = ACTIONS(756),
    [sym_nan] = ACTIONS(756),
    [anon_sym_NA] = ACTIONS(756),
    [anon_sym_NA_character_] = ACTIONS(756),
    [anon_sym_NA_complex_] = ACTIONS(756),
    [anon_sym_NA_integer_] = ACTIONS(756),
    [anon_sym_NA_real_] = ACTIONS(756),
    [aux_sym_identifier_token1] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(756),
    [sym_integer] = ACTIONS(756),
    [sym_float] = ACTIONS(756),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(756),
    [anon_sym_SQUOTE] = ACTIONS(756),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [156] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [anon_sym_i] = ACTIONS(894),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [157] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_function] = ACTIONS(609),
    [anon_sym_if] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(609),
    [anon_sym_while] = ACTIONS(609),
    [anon_sym_repeat] = ACTIONS(609),
    [anon_sym_for] = ACTIONS(609),
    [anon_sym_switch] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(607),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(609),
    [sym_next] = ACTIONS(609),
    [sym_true] = ACTIONS(609),
    [sym_false] = ACTIONS(609),
    [sym_null] = ACTIONS(609),
    [sym_inf] = ACTIONS(609),
    [sym_nan] = ACTIONS(609),
    [anon_sym_NA] = ACTIONS(609),
    [anon_sym_NA_character_] = ACTIONS(609),
    [anon_sym_NA_complex_] = ACTIONS(609),
    [anon_sym_NA_integer_] = ACTIONS(609),
    [anon_sym_NA_real_] = ACTIONS(609),
    [aux_sym_identifier_token1] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(607),
    [sym_integer] = ACTIONS(607),
    [sym_float] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(607),
    [anon_sym_SQUOTE] = ACTIONS(607),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [158] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(393),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(393),
    [anon_sym_GT_EQ] = ACTIONS(393),
    [anon_sym_EQ_EQ] = ACTIONS(393),
    [anon_sym_BANG_EQ] = ACTIONS(393),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(393),
    [anon_sym_COLON] = ACTIONS(395),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(393),
  },
  [159] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_function] = ACTIONS(609),
    [anon_sym_if] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(607),
    [anon_sym_while] = ACTIONS(609),
    [anon_sym_repeat] = ACTIONS(609),
    [anon_sym_for] = ACTIONS(609),
    [anon_sym_switch] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(607),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(609),
    [sym_next] = ACTIONS(609),
    [sym_true] = ACTIONS(609),
    [sym_false] = ACTIONS(609),
    [sym_null] = ACTIONS(609),
    [sym_inf] = ACTIONS(609),
    [sym_nan] = ACTIONS(609),
    [anon_sym_NA] = ACTIONS(609),
    [anon_sym_NA_character_] = ACTIONS(609),
    [anon_sym_NA_complex_] = ACTIONS(609),
    [anon_sym_NA_integer_] = ACTIONS(609),
    [anon_sym_NA_real_] = ACTIONS(609),
    [aux_sym_identifier_token1] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(607),
    [sym_integer] = ACTIONS(607),
    [sym_float] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(607),
    [anon_sym_SQUOTE] = ACTIONS(607),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [160] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [161] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(393),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(393),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(393),
    [anon_sym_GT_EQ] = ACTIONS(393),
    [anon_sym_EQ_EQ] = ACTIONS(393),
    [anon_sym_BANG_EQ] = ACTIONS(393),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(393),
    [anon_sym_COLON] = ACTIONS(395),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(393),
  },
  [162] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(393),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [163] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(393),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [164] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_LT_DASH] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_integer] = ACTIONS(393),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [165] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(708),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_repeat] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(706),
    [anon_sym_LT_DASH] = ACTIONS(706),
    [anon_sym_COLON_EQ] = ACTIONS(706),
    [anon_sym_LT_LT_DASH] = ACTIONS(706),
    [anon_sym_DASH_GT] = ACTIONS(706),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(706),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(708),
    [sym_next] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_inf] = ACTIONS(708),
    [sym_nan] = ACTIONS(708),
    [anon_sym_NA] = ACTIONS(708),
    [anon_sym_NA_character_] = ACTIONS(708),
    [anon_sym_NA_complex_] = ACTIONS(708),
    [anon_sym_NA_integer_] = ACTIONS(708),
    [anon_sym_NA_real_] = ACTIONS(708),
    [aux_sym_identifier_token1] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(706),
    [sym_integer] = ACTIONS(706),
    [sym_float] = ACTIONS(708),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(706),
    [anon_sym_SQUOTE] = ACTIONS(706),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [166] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(710),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(710),
    [sym_integer] = ACTIONS(710),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(710),
    [anon_sym_SQUOTE] = ACTIONS(710),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [167] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(714),
    [anon_sym_function] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(714),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(714),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(716),
    [sym_next] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_inf] = ACTIONS(716),
    [sym_nan] = ACTIONS(716),
    [anon_sym_NA] = ACTIONS(716),
    [anon_sym_NA_character_] = ACTIONS(716),
    [anon_sym_NA_complex_] = ACTIONS(716),
    [anon_sym_NA_integer_] = ACTIONS(716),
    [anon_sym_NA_real_] = ACTIONS(716),
    [aux_sym_identifier_token1] = ACTIONS(716),
    [anon_sym_BQUOTE] = ACTIONS(714),
    [sym_integer] = ACTIONS(714),
    [sym_float] = ACTIONS(716),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(714),
    [anon_sym_SQUOTE] = ACTIONS(714),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [168] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_function] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_repeat] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(718),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(720),
    [sym_next] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_inf] = ACTIONS(720),
    [sym_nan] = ACTIONS(720),
    [anon_sym_NA] = ACTIONS(720),
    [anon_sym_NA_character_] = ACTIONS(720),
    [anon_sym_NA_complex_] = ACTIONS(720),
    [anon_sym_NA_integer_] = ACTIONS(720),
    [anon_sym_NA_real_] = ACTIONS(720),
    [aux_sym_identifier_token1] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(718),
    [sym_integer] = ACTIONS(718),
    [sym_float] = ACTIONS(720),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(718),
    [anon_sym_SQUOTE] = ACTIONS(718),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [169] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_function] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_repeat] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_COMMA] = ACTIONS(722),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(722),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(724),
    [sym_next] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_inf] = ACTIONS(724),
    [sym_nan] = ACTIONS(724),
    [anon_sym_NA] = ACTIONS(724),
    [anon_sym_NA_character_] = ACTIONS(724),
    [anon_sym_NA_complex_] = ACTIONS(724),
    [anon_sym_NA_integer_] = ACTIONS(724),
    [anon_sym_NA_real_] = ACTIONS(724),
    [aux_sym_identifier_token1] = ACTIONS(724),
    [anon_sym_BQUOTE] = ACTIONS(722),
    [sym_integer] = ACTIONS(722),
    [sym_float] = ACTIONS(724),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [170] = {
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [anon_sym_i] = ACTIONS(942),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [171] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_repeat] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_COMMA] = ACTIONS(726),
    [anon_sym_EQ] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_LT_DASH] = ACTIONS(726),
    [anon_sym_COLON_EQ] = ACTIONS(726),
    [anon_sym_LT_LT_DASH] = ACTIONS(726),
    [anon_sym_DASH_GT] = ACTIONS(726),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(726),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(728),
    [sym_next] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_inf] = ACTIONS(728),
    [sym_nan] = ACTIONS(728),
    [anon_sym_NA] = ACTIONS(728),
    [anon_sym_NA_character_] = ACTIONS(728),
    [anon_sym_NA_complex_] = ACTIONS(728),
    [anon_sym_NA_integer_] = ACTIONS(728),
    [anon_sym_NA_real_] = ACTIONS(728),
    [aux_sym_identifier_token1] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(726),
    [sym_integer] = ACTIONS(726),
    [sym_float] = ACTIONS(728),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(726),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [172] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(754),
    [anon_sym_LF] = ACTIONS(756),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_function] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(756),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_repeat] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(756),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(756),
    [sym_next] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_inf] = ACTIONS(756),
    [sym_nan] = ACTIONS(756),
    [anon_sym_NA] = ACTIONS(756),
    [anon_sym_NA_character_] = ACTIONS(756),
    [anon_sym_NA_complex_] = ACTIONS(756),
    [anon_sym_NA_integer_] = ACTIONS(756),
    [anon_sym_NA_real_] = ACTIONS(756),
    [aux_sym_identifier_token1] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(756),
    [sym_integer] = ACTIONS(756),
    [sym_float] = ACTIONS(756),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(756),
    [anon_sym_SQUOTE] = ACTIONS(756),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [173] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(750),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(752),
    [anon_sym_function] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_repeat] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(752),
    [sym_next] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_inf] = ACTIONS(752),
    [sym_nan] = ACTIONS(752),
    [anon_sym_NA] = ACTIONS(752),
    [anon_sym_NA_character_] = ACTIONS(752),
    [anon_sym_NA_complex_] = ACTIONS(752),
    [anon_sym_NA_integer_] = ACTIONS(752),
    [anon_sym_NA_real_] = ACTIONS(752),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(752),
    [sym_integer] = ACTIONS(752),
    [sym_float] = ACTIONS(752),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(752),
    [anon_sym_SQUOTE] = ACTIONS(752),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [174] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(746),
    [anon_sym_LF] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(748),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(748),
    [sym_integer] = ACTIONS(748),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(748),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [175] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [176] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [177] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [178] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [179] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [180] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [181] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [182] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [183] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(734),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [184] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(726),
    [anon_sym_LF] = ACTIONS(728),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_repeat] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_EQ] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_LT_DASH] = ACTIONS(728),
    [anon_sym_COLON_EQ] = ACTIONS(728),
    [anon_sym_LT_LT_DASH] = ACTIONS(728),
    [anon_sym_DASH_GT] = ACTIONS(728),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(728),
    [sym_next] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_inf] = ACTIONS(728),
    [sym_nan] = ACTIONS(728),
    [anon_sym_NA] = ACTIONS(728),
    [anon_sym_NA_character_] = ACTIONS(728),
    [anon_sym_NA_complex_] = ACTIONS(728),
    [anon_sym_NA_integer_] = ACTIONS(728),
    [anon_sym_NA_real_] = ACTIONS(728),
    [aux_sym_identifier_token1] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(728),
    [sym_integer] = ACTIONS(728),
    [sym_float] = ACTIONS(728),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [185] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(722),
    [anon_sym_LF] = ACTIONS(724),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_function] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_repeat] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(724),
    [sym_next] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_inf] = ACTIONS(724),
    [sym_nan] = ACTIONS(724),
    [anon_sym_NA] = ACTIONS(724),
    [anon_sym_NA_character_] = ACTIONS(724),
    [anon_sym_NA_complex_] = ACTIONS(724),
    [anon_sym_NA_integer_] = ACTIONS(724),
    [anon_sym_NA_real_] = ACTIONS(724),
    [aux_sym_identifier_token1] = ACTIONS(724),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_integer] = ACTIONS(724),
    [sym_float] = ACTIONS(724),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(724),
    [anon_sym_SQUOTE] = ACTIONS(724),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [186] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [187] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_repeat] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(706),
    [anon_sym_LT_DASH] = ACTIONS(706),
    [anon_sym_COLON_EQ] = ACTIONS(706),
    [anon_sym_LT_LT_DASH] = ACTIONS(706),
    [anon_sym_DASH_GT] = ACTIONS(706),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(706),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(708),
    [sym_next] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_inf] = ACTIONS(708),
    [sym_nan] = ACTIONS(708),
    [anon_sym_NA] = ACTIONS(708),
    [anon_sym_NA_character_] = ACTIONS(708),
    [anon_sym_NA_complex_] = ACTIONS(708),
    [anon_sym_NA_integer_] = ACTIONS(708),
    [anon_sym_NA_real_] = ACTIONS(708),
    [aux_sym_identifier_token1] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(706),
    [sym_integer] = ACTIONS(706),
    [sym_float] = ACTIONS(708),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(706),
    [anon_sym_SQUOTE] = ACTIONS(706),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [188] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(718),
    [anon_sym_LF] = ACTIONS(720),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_repeat] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(720),
    [sym_next] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_inf] = ACTIONS(720),
    [sym_nan] = ACTIONS(720),
    [anon_sym_NA] = ACTIONS(720),
    [anon_sym_NA_character_] = ACTIONS(720),
    [anon_sym_NA_complex_] = ACTIONS(720),
    [anon_sym_NA_integer_] = ACTIONS(720),
    [anon_sym_NA_real_] = ACTIONS(720),
    [aux_sym_identifier_token1] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(720),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [189] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(714),
    [anon_sym_LF] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(716),
    [anon_sym_function] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(716),
    [sym_next] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_inf] = ACTIONS(716),
    [sym_nan] = ACTIONS(716),
    [anon_sym_NA] = ACTIONS(716),
    [anon_sym_NA_character_] = ACTIONS(716),
    [anon_sym_NA_complex_] = ACTIONS(716),
    [anon_sym_NA_integer_] = ACTIONS(716),
    [anon_sym_NA_real_] = ACTIONS(716),
    [aux_sym_identifier_token1] = ACTIONS(716),
    [anon_sym_BQUOTE] = ACTIONS(716),
    [sym_integer] = ACTIONS(716),
    [sym_float] = ACTIONS(716),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(716),
    [anon_sym_SQUOTE] = ACTIONS(716),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [190] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [191] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(710),
    [anon_sym_LF] = ACTIONS(712),
    [anon_sym_SEMI] = ACTIONS(712),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(712),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(712),
    [sym_integer] = ACTIONS(712),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(712),
    [anon_sym_SQUOTE] = ACTIONS(712),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [192] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [193] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(706),
    [anon_sym_LF] = ACTIONS(708),
    [anon_sym_SEMI] = ACTIONS(708),
    [anon_sym_function] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(708),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_repeat] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(708),
    [anon_sym_LT_DASH] = ACTIONS(708),
    [anon_sym_COLON_EQ] = ACTIONS(708),
    [anon_sym_LT_LT_DASH] = ACTIONS(708),
    [anon_sym_DASH_GT] = ACTIONS(708),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(708),
    [sym_next] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_inf] = ACTIONS(708),
    [sym_nan] = ACTIONS(708),
    [anon_sym_NA] = ACTIONS(708),
    [anon_sym_NA_character_] = ACTIONS(708),
    [anon_sym_NA_complex_] = ACTIONS(708),
    [anon_sym_NA_integer_] = ACTIONS(708),
    [anon_sym_NA_real_] = ACTIONS(708),
    [aux_sym_identifier_token1] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(708),
    [sym_integer] = ACTIONS(708),
    [sym_float] = ACTIONS(708),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(708),
    [anon_sym_SQUOTE] = ACTIONS(708),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [194] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [195] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(724),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_function] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_repeat] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_RBRACE] = ACTIONS(724),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(724),
    [sym_next] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_inf] = ACTIONS(724),
    [sym_nan] = ACTIONS(724),
    [anon_sym_NA] = ACTIONS(724),
    [anon_sym_NA_character_] = ACTIONS(724),
    [anon_sym_NA_complex_] = ACTIONS(724),
    [anon_sym_NA_integer_] = ACTIONS(724),
    [anon_sym_NA_real_] = ACTIONS(724),
    [aux_sym_identifier_token1] = ACTIONS(724),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_integer] = ACTIONS(724),
    [sym_float] = ACTIONS(724),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(724),
    [anon_sym_SQUOTE] = ACTIONS(724),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [196] = {
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(944),
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_COLON_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_DASH] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(333),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(333),
    [anon_sym_DOLLAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(838),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(840),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_SLASH] = ACTIONS(333),
    [anon_sym_CARET] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [anon_sym_PERCENT] = ACTIONS(333),
  },
  [197] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [198] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(710),
    [sym_integer] = ACTIONS(710),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(710),
    [anon_sym_SQUOTE] = ACTIONS(710),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [199] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(714),
    [anon_sym_function] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(714),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(714),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(714),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(716),
    [sym_next] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_inf] = ACTIONS(716),
    [sym_nan] = ACTIONS(716),
    [anon_sym_NA] = ACTIONS(716),
    [anon_sym_NA_character_] = ACTIONS(716),
    [anon_sym_NA_complex_] = ACTIONS(716),
    [anon_sym_NA_integer_] = ACTIONS(716),
    [anon_sym_NA_real_] = ACTIONS(716),
    [aux_sym_identifier_token1] = ACTIONS(716),
    [anon_sym_BQUOTE] = ACTIONS(714),
    [sym_integer] = ACTIONS(714),
    [sym_float] = ACTIONS(716),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(714),
    [anon_sym_SQUOTE] = ACTIONS(714),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [200] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_function] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(718),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_repeat] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(718),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(720),
    [sym_next] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_inf] = ACTIONS(720),
    [sym_nan] = ACTIONS(720),
    [anon_sym_NA] = ACTIONS(720),
    [anon_sym_NA_character_] = ACTIONS(720),
    [anon_sym_NA_complex_] = ACTIONS(720),
    [anon_sym_NA_integer_] = ACTIONS(720),
    [anon_sym_NA_real_] = ACTIONS(720),
    [aux_sym_identifier_token1] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(718),
    [sym_integer] = ACTIONS(718),
    [sym_float] = ACTIONS(720),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(718),
    [anon_sym_SQUOTE] = ACTIONS(718),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [201] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_function] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_repeat] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_COMMA] = ACTIONS(722),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(722),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(724),
    [sym_next] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_inf] = ACTIONS(724),
    [sym_nan] = ACTIONS(724),
    [anon_sym_NA] = ACTIONS(724),
    [anon_sym_NA_character_] = ACTIONS(724),
    [anon_sym_NA_complex_] = ACTIONS(724),
    [anon_sym_NA_integer_] = ACTIONS(724),
    [anon_sym_NA_real_] = ACTIONS(724),
    [aux_sym_identifier_token1] = ACTIONS(724),
    [anon_sym_BQUOTE] = ACTIONS(722),
    [sym_integer] = ACTIONS(722),
    [sym_float] = ACTIONS(724),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [202] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(726),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_repeat] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_COMMA] = ACTIONS(726),
    [anon_sym_EQ] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_LT_DASH] = ACTIONS(726),
    [anon_sym_COLON_EQ] = ACTIONS(726),
    [anon_sym_LT_LT_DASH] = ACTIONS(726),
    [anon_sym_DASH_GT] = ACTIONS(726),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(726),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(728),
    [sym_next] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_inf] = ACTIONS(728),
    [sym_nan] = ACTIONS(728),
    [anon_sym_NA] = ACTIONS(728),
    [anon_sym_NA_character_] = ACTIONS(728),
    [anon_sym_NA_complex_] = ACTIONS(728),
    [anon_sym_NA_integer_] = ACTIONS(728),
    [anon_sym_NA_real_] = ACTIONS(728),
    [aux_sym_identifier_token1] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(726),
    [sym_integer] = ACTIONS(726),
    [sym_float] = ACTIONS(728),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(726),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [203] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_LT_DASH] = ACTIONS(395),
    [anon_sym_COLON_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_DASH] = ACTIONS(395),
    [anon_sym_DASH_GT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(395),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(395),
    [sym_integer] = ACTIONS(395),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [204] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_LT_DASH] = ACTIONS(395),
    [anon_sym_COLON_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_DASH] = ACTIONS(395),
    [anon_sym_DASH_GT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(395),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(395),
    [anon_sym_SLASH] = ACTIONS(395),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(395),
    [anon_sym_GT_EQ] = ACTIONS(395),
    [anon_sym_EQ_EQ] = ACTIONS(395),
    [anon_sym_BANG_EQ] = ACTIONS(395),
    [anon_sym_PIPE_PIPE] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(395),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(395),
    [anon_sym_COLON] = ACTIONS(395),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(395),
    [sym_integer] = ACTIONS(395),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(395),
  },
  [205] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(609),
    [anon_sym_SEMI] = ACTIONS(609),
    [anon_sym_function] = ACTIONS(609),
    [anon_sym_if] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(609),
    [anon_sym_while] = ACTIONS(609),
    [anon_sym_repeat] = ACTIONS(609),
    [anon_sym_for] = ACTIONS(609),
    [anon_sym_switch] = ACTIONS(609),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_RBRACE] = ACTIONS(609),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(609),
    [sym_next] = ACTIONS(609),
    [sym_true] = ACTIONS(609),
    [sym_false] = ACTIONS(609),
    [sym_null] = ACTIONS(609),
    [sym_inf] = ACTIONS(609),
    [sym_nan] = ACTIONS(609),
    [anon_sym_NA] = ACTIONS(609),
    [anon_sym_NA_character_] = ACTIONS(609),
    [anon_sym_NA_complex_] = ACTIONS(609),
    [anon_sym_NA_integer_] = ACTIONS(609),
    [anon_sym_NA_real_] = ACTIONS(609),
    [aux_sym_identifier_token1] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [sym_integer] = ACTIONS(609),
    [sym_float] = ACTIONS(609),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(609),
    [anon_sym_SQUOTE] = ACTIONS(609),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [206] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [207] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [208] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [209] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [210] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [211] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [212] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [213] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [214] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [215] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [216] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [217] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [218] = {
    [anon_sym_SEMI] = ACTIONS(946),
    [anon_sym_function] = ACTIONS(948),
    [anon_sym_if] = ACTIONS(948),
    [anon_sym_LPAREN] = ACTIONS(946),
    [anon_sym_RPAREN] = ACTIONS(946),
    [anon_sym_else] = ACTIONS(948),
    [anon_sym_while] = ACTIONS(948),
    [anon_sym_repeat] = ACTIONS(948),
    [anon_sym_for] = ACTIONS(948),
    [anon_sym_switch] = ACTIONS(948),
    [anon_sym_COMMA] = ACTIONS(946),
    [anon_sym_EQ] = ACTIONS(948),
    [anon_sym_LBRACE] = ACTIONS(946),
    [anon_sym_LT_DASH] = ACTIONS(946),
    [anon_sym_COLON_EQ] = ACTIONS(946),
    [anon_sym_LT_LT_DASH] = ACTIONS(946),
    [anon_sym_DASH_GT] = ACTIONS(946),
    [anon_sym_LBRACK] = ACTIONS(948),
    [anon_sym_RBRACK] = ACTIONS(946),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(946),
    [anon_sym_DOLLAR] = ACTIONS(946),
    [anon_sym_AT] = ACTIONS(946),
    [sym_dots] = ACTIONS(948),
    [anon_sym_DASH] = ACTIONS(948),
    [anon_sym_PLUS] = ACTIONS(946),
    [anon_sym_BANG] = ACTIONS(948),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(946),
    [anon_sym_SLASH] = ACTIONS(946),
    [anon_sym_CARET] = ACTIONS(946),
    [anon_sym_LT] = ACTIONS(948),
    [anon_sym_GT] = ACTIONS(948),
    [anon_sym_LT_EQ] = ACTIONS(946),
    [anon_sym_GT_EQ] = ACTIONS(946),
    [anon_sym_EQ_EQ] = ACTIONS(946),
    [anon_sym_BANG_EQ] = ACTIONS(946),
    [anon_sym_PIPE_PIPE] = ACTIONS(946),
    [anon_sym_PIPE] = ACTIONS(948),
    [anon_sym_AMP_AMP] = ACTIONS(946),
    [anon_sym_AMP] = ACTIONS(948),
    [anon_sym_PIPE_GT] = ACTIONS(946),
    [anon_sym_COLON] = ACTIONS(948),
    [sym_break] = ACTIONS(948),
    [sym_next] = ACTIONS(948),
    [sym_true] = ACTIONS(948),
    [sym_false] = ACTIONS(948),
    [sym_null] = ACTIONS(948),
    [sym_inf] = ACTIONS(948),
    [sym_nan] = ACTIONS(948),
    [anon_sym_NA] = ACTIONS(948),
    [anon_sym_NA_character_] = ACTIONS(948),
    [anon_sym_NA_complex_] = ACTIONS(948),
    [anon_sym_NA_integer_] = ACTIONS(948),
    [anon_sym_NA_real_] = ACTIONS(948),
    [aux_sym_identifier_token1] = ACTIONS(948),
    [anon_sym_BQUOTE] = ACTIONS(946),
    [sym_integer] = ACTIONS(946),
    [sym_float] = ACTIONS(948),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(946),
    [anon_sym_SQUOTE] = ACTIONS(946),
    [anon_sym_PERCENT] = ACTIONS(946),
  },
  [219] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(950),
    [anon_sym_function] = ACTIONS(952),
    [anon_sym_if] = ACTIONS(952),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(950),
    [anon_sym_while] = ACTIONS(952),
    [anon_sym_repeat] = ACTIONS(952),
    [anon_sym_for] = ACTIONS(952),
    [anon_sym_switch] = ACTIONS(952),
    [anon_sym_COMMA] = ACTIONS(950),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(950),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(950),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(952),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(952),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(952),
    [sym_next] = ACTIONS(952),
    [sym_true] = ACTIONS(952),
    [sym_false] = ACTIONS(952),
    [sym_null] = ACTIONS(952),
    [sym_inf] = ACTIONS(952),
    [sym_nan] = ACTIONS(952),
    [anon_sym_NA] = ACTIONS(952),
    [anon_sym_NA_character_] = ACTIONS(952),
    [anon_sym_NA_complex_] = ACTIONS(952),
    [anon_sym_NA_integer_] = ACTIONS(952),
    [anon_sym_NA_real_] = ACTIONS(952),
    [aux_sym_identifier_token1] = ACTIONS(952),
    [anon_sym_BQUOTE] = ACTIONS(950),
    [sym_integer] = ACTIONS(950),
    [sym_float] = ACTIONS(952),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(950),
    [anon_sym_SQUOTE] = ACTIONS(950),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [220] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(954),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_COMMA] = ACTIONS(520),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(520),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(520),
    [sym_integer] = ACTIONS(520),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(520),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [221] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_LT_DASH] = ACTIONS(734),
    [anon_sym_COLON_EQ] = ACTIONS(734),
    [anon_sym_LT_LT_DASH] = ACTIONS(734),
    [anon_sym_DASH_GT] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(734),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_SLASH] = ACTIONS(734),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(734),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(734),
    [sym_integer] = ACTIONS(734),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE] = ACTIONS(734),
    [anon_sym_PERCENT] = ACTIONS(734),
  },
  [222] = {
    [anon_sym_SEMI] = ACTIONS(956),
    [anon_sym_function] = ACTIONS(958),
    [anon_sym_if] = ACTIONS(958),
    [anon_sym_LPAREN] = ACTIONS(956),
    [anon_sym_RPAREN] = ACTIONS(956),
    [anon_sym_else] = ACTIONS(958),
    [anon_sym_while] = ACTIONS(958),
    [anon_sym_repeat] = ACTIONS(958),
    [anon_sym_for] = ACTIONS(958),
    [anon_sym_switch] = ACTIONS(958),
    [anon_sym_COMMA] = ACTIONS(956),
    [anon_sym_EQ] = ACTIONS(958),
    [anon_sym_LBRACE] = ACTIONS(956),
    [anon_sym_LT_DASH] = ACTIONS(956),
    [anon_sym_COLON_EQ] = ACTIONS(956),
    [anon_sym_LT_LT_DASH] = ACTIONS(956),
    [anon_sym_DASH_GT] = ACTIONS(956),
    [anon_sym_LBRACK] = ACTIONS(958),
    [anon_sym_RBRACK] = ACTIONS(956),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(956),
    [anon_sym_DOLLAR] = ACTIONS(956),
    [anon_sym_AT] = ACTIONS(956),
    [sym_dots] = ACTIONS(958),
    [anon_sym_DASH] = ACTIONS(958),
    [anon_sym_PLUS] = ACTIONS(956),
    [anon_sym_BANG] = ACTIONS(958),
    [anon_sym_TILDE] = ACTIONS(956),
    [anon_sym_STAR] = ACTIONS(956),
    [anon_sym_SLASH] = ACTIONS(956),
    [anon_sym_CARET] = ACTIONS(956),
    [anon_sym_LT] = ACTIONS(958),
    [anon_sym_GT] = ACTIONS(958),
    [anon_sym_LT_EQ] = ACTIONS(956),
    [anon_sym_GT_EQ] = ACTIONS(956),
    [anon_sym_EQ_EQ] = ACTIONS(956),
    [anon_sym_BANG_EQ] = ACTIONS(956),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(956),
    [anon_sym_AMP] = ACTIONS(958),
    [anon_sym_PIPE_GT] = ACTIONS(956),
    [anon_sym_COLON] = ACTIONS(958),
    [sym_break] = ACTIONS(958),
    [sym_next] = ACTIONS(958),
    [sym_true] = ACTIONS(958),
    [sym_false] = ACTIONS(958),
    [sym_null] = ACTIONS(958),
    [sym_inf] = ACTIONS(958),
    [sym_nan] = ACTIONS(958),
    [anon_sym_NA] = ACTIONS(958),
    [anon_sym_NA_character_] = ACTIONS(958),
    [anon_sym_NA_complex_] = ACTIONS(958),
    [anon_sym_NA_integer_] = ACTIONS(958),
    [anon_sym_NA_real_] = ACTIONS(958),
    [aux_sym_identifier_token1] = ACTIONS(958),
    [anon_sym_BQUOTE] = ACTIONS(956),
    [sym_integer] = ACTIONS(956),
    [sym_float] = ACTIONS(958),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(956),
    [anon_sym_SQUOTE] = ACTIONS(956),
    [anon_sym_PERCENT] = ACTIONS(956),
  },
  [223] = {
    [anon_sym_SEMI] = ACTIONS(960),
    [anon_sym_function] = ACTIONS(962),
    [anon_sym_if] = ACTIONS(962),
    [anon_sym_LPAREN] = ACTIONS(960),
    [anon_sym_RPAREN] = ACTIONS(960),
    [anon_sym_else] = ACTIONS(962),
    [anon_sym_while] = ACTIONS(962),
    [anon_sym_repeat] = ACTIONS(962),
    [anon_sym_for] = ACTIONS(962),
    [anon_sym_switch] = ACTIONS(962),
    [anon_sym_COMMA] = ACTIONS(960),
    [anon_sym_EQ] = ACTIONS(962),
    [anon_sym_LBRACE] = ACTIONS(960),
    [anon_sym_LT_DASH] = ACTIONS(960),
    [anon_sym_COLON_EQ] = ACTIONS(960),
    [anon_sym_LT_LT_DASH] = ACTIONS(960),
    [anon_sym_DASH_GT] = ACTIONS(960),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_RBRACK] = ACTIONS(960),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(960),
    [anon_sym_DOLLAR] = ACTIONS(960),
    [anon_sym_AT] = ACTIONS(960),
    [sym_dots] = ACTIONS(962),
    [anon_sym_DASH] = ACTIONS(962),
    [anon_sym_PLUS] = ACTIONS(960),
    [anon_sym_BANG] = ACTIONS(962),
    [anon_sym_TILDE] = ACTIONS(960),
    [anon_sym_STAR] = ACTIONS(960),
    [anon_sym_SLASH] = ACTIONS(960),
    [anon_sym_CARET] = ACTIONS(960),
    [anon_sym_LT] = ACTIONS(962),
    [anon_sym_GT] = ACTIONS(962),
    [anon_sym_LT_EQ] = ACTIONS(960),
    [anon_sym_GT_EQ] = ACTIONS(960),
    [anon_sym_EQ_EQ] = ACTIONS(960),
    [anon_sym_BANG_EQ] = ACTIONS(960),
    [anon_sym_PIPE_PIPE] = ACTIONS(960),
    [anon_sym_PIPE] = ACTIONS(962),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_PIPE_GT] = ACTIONS(960),
    [anon_sym_COLON] = ACTIONS(962),
    [sym_break] = ACTIONS(962),
    [sym_next] = ACTIONS(962),
    [sym_true] = ACTIONS(962),
    [sym_false] = ACTIONS(962),
    [sym_null] = ACTIONS(962),
    [sym_inf] = ACTIONS(962),
    [sym_nan] = ACTIONS(962),
    [anon_sym_NA] = ACTIONS(962),
    [anon_sym_NA_character_] = ACTIONS(962),
    [anon_sym_NA_complex_] = ACTIONS(962),
    [anon_sym_NA_integer_] = ACTIONS(962),
    [anon_sym_NA_real_] = ACTIONS(962),
    [aux_sym_identifier_token1] = ACTIONS(962),
    [anon_sym_BQUOTE] = ACTIONS(960),
    [sym_integer] = ACTIONS(960),
    [sym_float] = ACTIONS(962),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(960),
    [anon_sym_SQUOTE] = ACTIONS(960),
    [anon_sym_PERCENT] = ACTIONS(960),
  },
  [224] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(746),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(746),
    [sym_integer] = ACTIONS(746),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [225] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(746),
    [sym_integer] = ACTIONS(746),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [226] = {
    [anon_sym_SEMI] = ACTIONS(964),
    [anon_sym_function] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(966),
    [anon_sym_LPAREN] = ACTIONS(964),
    [anon_sym_RPAREN] = ACTIONS(964),
    [anon_sym_else] = ACTIONS(966),
    [anon_sym_while] = ACTIONS(966),
    [anon_sym_repeat] = ACTIONS(966),
    [anon_sym_for] = ACTIONS(966),
    [anon_sym_switch] = ACTIONS(966),
    [anon_sym_COMMA] = ACTIONS(964),
    [anon_sym_EQ] = ACTIONS(966),
    [anon_sym_LBRACE] = ACTIONS(964),
    [anon_sym_LT_DASH] = ACTIONS(964),
    [anon_sym_COLON_EQ] = ACTIONS(964),
    [anon_sym_LT_LT_DASH] = ACTIONS(964),
    [anon_sym_DASH_GT] = ACTIONS(964),
    [anon_sym_LBRACK] = ACTIONS(966),
    [anon_sym_RBRACK] = ACTIONS(964),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(964),
    [anon_sym_DOLLAR] = ACTIONS(964),
    [anon_sym_AT] = ACTIONS(964),
    [sym_dots] = ACTIONS(966),
    [anon_sym_DASH] = ACTIONS(966),
    [anon_sym_PLUS] = ACTIONS(964),
    [anon_sym_BANG] = ACTIONS(966),
    [anon_sym_TILDE] = ACTIONS(964),
    [anon_sym_STAR] = ACTIONS(964),
    [anon_sym_SLASH] = ACTIONS(964),
    [anon_sym_CARET] = ACTIONS(964),
    [anon_sym_LT] = ACTIONS(966),
    [anon_sym_GT] = ACTIONS(966),
    [anon_sym_LT_EQ] = ACTIONS(964),
    [anon_sym_GT_EQ] = ACTIONS(964),
    [anon_sym_EQ_EQ] = ACTIONS(964),
    [anon_sym_BANG_EQ] = ACTIONS(964),
    [anon_sym_PIPE_PIPE] = ACTIONS(964),
    [anon_sym_PIPE] = ACTIONS(966),
    [anon_sym_AMP_AMP] = ACTIONS(964),
    [anon_sym_AMP] = ACTIONS(966),
    [anon_sym_PIPE_GT] = ACTIONS(964),
    [anon_sym_COLON] = ACTIONS(966),
    [sym_break] = ACTIONS(966),
    [sym_next] = ACTIONS(966),
    [sym_true] = ACTIONS(966),
    [sym_false] = ACTIONS(966),
    [sym_null] = ACTIONS(966),
    [sym_inf] = ACTIONS(966),
    [sym_nan] = ACTIONS(966),
    [anon_sym_NA] = ACTIONS(966),
    [anon_sym_NA_character_] = ACTIONS(966),
    [anon_sym_NA_complex_] = ACTIONS(966),
    [anon_sym_NA_integer_] = ACTIONS(966),
    [anon_sym_NA_real_] = ACTIONS(966),
    [aux_sym_identifier_token1] = ACTIONS(966),
    [anon_sym_BQUOTE] = ACTIONS(964),
    [sym_integer] = ACTIONS(964),
    [sym_float] = ACTIONS(966),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(964),
    [anon_sym_SQUOTE] = ACTIONS(964),
    [anon_sym_PERCENT] = ACTIONS(964),
  },
  [227] = {
    [anon_sym_SEMI] = ACTIONS(968),
    [anon_sym_function] = ACTIONS(970),
    [anon_sym_if] = ACTIONS(970),
    [anon_sym_LPAREN] = ACTIONS(968),
    [anon_sym_RPAREN] = ACTIONS(968),
    [anon_sym_else] = ACTIONS(970),
    [anon_sym_while] = ACTIONS(970),
    [anon_sym_repeat] = ACTIONS(970),
    [anon_sym_for] = ACTIONS(970),
    [anon_sym_switch] = ACTIONS(970),
    [anon_sym_COMMA] = ACTIONS(968),
    [anon_sym_EQ] = ACTIONS(970),
    [anon_sym_LBRACE] = ACTIONS(968),
    [anon_sym_LT_DASH] = ACTIONS(968),
    [anon_sym_COLON_EQ] = ACTIONS(968),
    [anon_sym_LT_LT_DASH] = ACTIONS(968),
    [anon_sym_DASH_GT] = ACTIONS(968),
    [anon_sym_LBRACK] = ACTIONS(970),
    [anon_sym_RBRACK] = ACTIONS(968),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(968),
    [anon_sym_DOLLAR] = ACTIONS(968),
    [anon_sym_AT] = ACTIONS(968),
    [sym_dots] = ACTIONS(970),
    [anon_sym_DASH] = ACTIONS(970),
    [anon_sym_PLUS] = ACTIONS(968),
    [anon_sym_BANG] = ACTIONS(970),
    [anon_sym_TILDE] = ACTIONS(968),
    [anon_sym_STAR] = ACTIONS(968),
    [anon_sym_SLASH] = ACTIONS(968),
    [anon_sym_CARET] = ACTIONS(968),
    [anon_sym_LT] = ACTIONS(970),
    [anon_sym_GT] = ACTIONS(970),
    [anon_sym_LT_EQ] = ACTIONS(968),
    [anon_sym_GT_EQ] = ACTIONS(968),
    [anon_sym_EQ_EQ] = ACTIONS(968),
    [anon_sym_BANG_EQ] = ACTIONS(968),
    [anon_sym_PIPE_PIPE] = ACTIONS(968),
    [anon_sym_PIPE] = ACTIONS(970),
    [anon_sym_AMP_AMP] = ACTIONS(968),
    [anon_sym_AMP] = ACTIONS(970),
    [anon_sym_PIPE_GT] = ACTIONS(968),
    [anon_sym_COLON] = ACTIONS(970),
    [sym_break] = ACTIONS(970),
    [sym_next] = ACTIONS(970),
    [sym_true] = ACTIONS(970),
    [sym_false] = ACTIONS(970),
    [sym_null] = ACTIONS(970),
    [sym_inf] = ACTIONS(970),
    [sym_nan] = ACTIONS(970),
    [anon_sym_NA] = ACTIONS(970),
    [anon_sym_NA_character_] = ACTIONS(970),
    [anon_sym_NA_complex_] = ACTIONS(970),
    [anon_sym_NA_integer_] = ACTIONS(970),
    [anon_sym_NA_real_] = ACTIONS(970),
    [aux_sym_identifier_token1] = ACTIONS(970),
    [anon_sym_BQUOTE] = ACTIONS(968),
    [sym_integer] = ACTIONS(968),
    [sym_float] = ACTIONS(970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(968),
    [anon_sym_SQUOTE] = ACTIONS(968),
    [anon_sym_PERCENT] = ACTIONS(968),
  },
  [228] = {
    [anon_sym_SEMI] = ACTIONS(972),
    [anon_sym_function] = ACTIONS(974),
    [anon_sym_if] = ACTIONS(974),
    [anon_sym_LPAREN] = ACTIONS(972),
    [anon_sym_RPAREN] = ACTIONS(972),
    [anon_sym_else] = ACTIONS(974),
    [anon_sym_while] = ACTIONS(974),
    [anon_sym_repeat] = ACTIONS(974),
    [anon_sym_for] = ACTIONS(974),
    [anon_sym_switch] = ACTIONS(974),
    [anon_sym_COMMA] = ACTIONS(972),
    [anon_sym_EQ] = ACTIONS(974),
    [anon_sym_LBRACE] = ACTIONS(972),
    [anon_sym_LT_DASH] = ACTIONS(972),
    [anon_sym_COLON_EQ] = ACTIONS(972),
    [anon_sym_LT_LT_DASH] = ACTIONS(972),
    [anon_sym_DASH_GT] = ACTIONS(972),
    [anon_sym_LBRACK] = ACTIONS(974),
    [anon_sym_RBRACK] = ACTIONS(972),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(972),
    [anon_sym_DOLLAR] = ACTIONS(972),
    [anon_sym_AT] = ACTIONS(972),
    [sym_dots] = ACTIONS(974),
    [anon_sym_DASH] = ACTIONS(974),
    [anon_sym_PLUS] = ACTIONS(972),
    [anon_sym_BANG] = ACTIONS(974),
    [anon_sym_TILDE] = ACTIONS(972),
    [anon_sym_STAR] = ACTIONS(972),
    [anon_sym_SLASH] = ACTIONS(972),
    [anon_sym_CARET] = ACTIONS(972),
    [anon_sym_LT] = ACTIONS(974),
    [anon_sym_GT] = ACTIONS(974),
    [anon_sym_LT_EQ] = ACTIONS(972),
    [anon_sym_GT_EQ] = ACTIONS(972),
    [anon_sym_EQ_EQ] = ACTIONS(972),
    [anon_sym_BANG_EQ] = ACTIONS(972),
    [anon_sym_PIPE_PIPE] = ACTIONS(972),
    [anon_sym_PIPE] = ACTIONS(974),
    [anon_sym_AMP_AMP] = ACTIONS(972),
    [anon_sym_AMP] = ACTIONS(974),
    [anon_sym_PIPE_GT] = ACTIONS(972),
    [anon_sym_COLON] = ACTIONS(974),
    [sym_break] = ACTIONS(974),
    [sym_next] = ACTIONS(974),
    [sym_true] = ACTIONS(974),
    [sym_false] = ACTIONS(974),
    [sym_null] = ACTIONS(974),
    [sym_inf] = ACTIONS(974),
    [sym_nan] = ACTIONS(974),
    [anon_sym_NA] = ACTIONS(974),
    [anon_sym_NA_character_] = ACTIONS(974),
    [anon_sym_NA_complex_] = ACTIONS(974),
    [anon_sym_NA_integer_] = ACTIONS(974),
    [anon_sym_NA_real_] = ACTIONS(974),
    [aux_sym_identifier_token1] = ACTIONS(974),
    [anon_sym_BQUOTE] = ACTIONS(972),
    [sym_integer] = ACTIONS(972),
    [sym_float] = ACTIONS(974),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(972),
    [anon_sym_SQUOTE] = ACTIONS(972),
    [anon_sym_PERCENT] = ACTIONS(972),
  },
  [229] = {
    [anon_sym_SEMI] = ACTIONS(976),
    [anon_sym_function] = ACTIONS(978),
    [anon_sym_if] = ACTIONS(978),
    [anon_sym_LPAREN] = ACTIONS(976),
    [anon_sym_RPAREN] = ACTIONS(976),
    [anon_sym_else] = ACTIONS(978),
    [anon_sym_while] = ACTIONS(978),
    [anon_sym_repeat] = ACTIONS(978),
    [anon_sym_for] = ACTIONS(978),
    [anon_sym_switch] = ACTIONS(978),
    [anon_sym_COMMA] = ACTIONS(976),
    [anon_sym_EQ] = ACTIONS(978),
    [anon_sym_LBRACE] = ACTIONS(976),
    [anon_sym_LT_DASH] = ACTIONS(976),
    [anon_sym_COLON_EQ] = ACTIONS(976),
    [anon_sym_LT_LT_DASH] = ACTIONS(976),
    [anon_sym_DASH_GT] = ACTIONS(976),
    [anon_sym_LBRACK] = ACTIONS(978),
    [anon_sym_RBRACK] = ACTIONS(976),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(976),
    [anon_sym_DOLLAR] = ACTIONS(976),
    [anon_sym_AT] = ACTIONS(976),
    [sym_dots] = ACTIONS(978),
    [anon_sym_DASH] = ACTIONS(978),
    [anon_sym_PLUS] = ACTIONS(976),
    [anon_sym_BANG] = ACTIONS(978),
    [anon_sym_TILDE] = ACTIONS(976),
    [anon_sym_STAR] = ACTIONS(976),
    [anon_sym_SLASH] = ACTIONS(976),
    [anon_sym_CARET] = ACTIONS(976),
    [anon_sym_LT] = ACTIONS(978),
    [anon_sym_GT] = ACTIONS(978),
    [anon_sym_LT_EQ] = ACTIONS(976),
    [anon_sym_GT_EQ] = ACTIONS(976),
    [anon_sym_EQ_EQ] = ACTIONS(976),
    [anon_sym_BANG_EQ] = ACTIONS(976),
    [anon_sym_PIPE_PIPE] = ACTIONS(976),
    [anon_sym_PIPE] = ACTIONS(978),
    [anon_sym_AMP_AMP] = ACTIONS(976),
    [anon_sym_AMP] = ACTIONS(978),
    [anon_sym_PIPE_GT] = ACTIONS(976),
    [anon_sym_COLON] = ACTIONS(978),
    [sym_break] = ACTIONS(978),
    [sym_next] = ACTIONS(978),
    [sym_true] = ACTIONS(978),
    [sym_false] = ACTIONS(978),
    [sym_null] = ACTIONS(978),
    [sym_inf] = ACTIONS(978),
    [sym_nan] = ACTIONS(978),
    [anon_sym_NA] = ACTIONS(978),
    [anon_sym_NA_character_] = ACTIONS(978),
    [anon_sym_NA_complex_] = ACTIONS(978),
    [anon_sym_NA_integer_] = ACTIONS(978),
    [anon_sym_NA_real_] = ACTIONS(978),
    [aux_sym_identifier_token1] = ACTIONS(978),
    [anon_sym_BQUOTE] = ACTIONS(976),
    [sym_integer] = ACTIONS(976),
    [sym_float] = ACTIONS(978),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(976),
    [anon_sym_SQUOTE] = ACTIONS(976),
    [anon_sym_PERCENT] = ACTIONS(976),
  },
  [230] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(750),
    [anon_sym_function] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(750),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_repeat] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(750),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(750),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(752),
    [sym_next] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_inf] = ACTIONS(752),
    [sym_nan] = ACTIONS(752),
    [anon_sym_NA] = ACTIONS(752),
    [anon_sym_NA_character_] = ACTIONS(752),
    [anon_sym_NA_complex_] = ACTIONS(752),
    [anon_sym_NA_integer_] = ACTIONS(752),
    [anon_sym_NA_real_] = ACTIONS(752),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_integer] = ACTIONS(750),
    [sym_float] = ACTIONS(752),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(750),
    [anon_sym_SQUOTE] = ACTIONS(750),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [231] = {
    [sym_special] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(754),
    [anon_sym_function] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_RPAREN] = ACTIONS(754),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_repeat] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_COMMA] = ACTIONS(754),
    [anon_sym_EQ] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_LT_DASH] = ACTIONS(850),
    [anon_sym_COLON_EQ] = ACTIONS(852),
    [anon_sym_LT_LT_DASH] = ACTIONS(854),
    [anon_sym_DASH_GT] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(858),
    [anon_sym_RBRACK] = ACTIONS(754),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(864),
    [sym_dots] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(872),
    [anon_sym_SLASH] = ACTIONS(872),
    [anon_sym_CARET] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(876),
    [anon_sym_GT] = ACTIONS(876),
    [anon_sym_LT_EQ] = ACTIONS(878),
    [anon_sym_GT_EQ] = ACTIONS(878),
    [anon_sym_EQ_EQ] = ACTIONS(878),
    [anon_sym_BANG_EQ] = ACTIONS(878),
    [anon_sym_PIPE_PIPE] = ACTIONS(880),
    [anon_sym_PIPE] = ACTIONS(882),
    [anon_sym_AMP_AMP] = ACTIONS(884),
    [anon_sym_AMP] = ACTIONS(886),
    [anon_sym_PIPE_GT] = ACTIONS(888),
    [anon_sym_COLON] = ACTIONS(890),
    [sym_break] = ACTIONS(756),
    [sym_next] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_inf] = ACTIONS(756),
    [sym_nan] = ACTIONS(756),
    [anon_sym_NA] = ACTIONS(756),
    [anon_sym_NA_character_] = ACTIONS(756),
    [anon_sym_NA_complex_] = ACTIONS(756),
    [anon_sym_NA_integer_] = ACTIONS(756),
    [anon_sym_NA_real_] = ACTIONS(756),
    [aux_sym_identifier_token1] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(754),
    [sym_integer] = ACTIONS(754),
    [sym_float] = ACTIONS(756),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(754),
    [anon_sym_SQUOTE] = ACTIONS(754),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [232] = {
    [anon_sym_SEMI] = ACTIONS(980),
    [anon_sym_function] = ACTIONS(982),
    [anon_sym_if] = ACTIONS(982),
    [anon_sym_LPAREN] = ACTIONS(980),
    [anon_sym_RPAREN] = ACTIONS(980),
    [anon_sym_else] = ACTIONS(982),
    [anon_sym_while] = ACTIONS(982),
    [anon_sym_repeat] = ACTIONS(982),
    [anon_sym_for] = ACTIONS(982),
    [anon_sym_switch] = ACTIONS(982),
    [anon_sym_COMMA] = ACTIONS(980),
    [anon_sym_EQ] = ACTIONS(982),
    [anon_sym_LBRACE] = ACTIONS(980),
    [anon_sym_LT_DASH] = ACTIONS(980),
    [anon_sym_COLON_EQ] = ACTIONS(980),
    [anon_sym_LT_LT_DASH] = ACTIONS(980),
    [anon_sym_DASH_GT] = ACTIONS(980),
    [anon_sym_LBRACK] = ACTIONS(982),
    [anon_sym_RBRACK] = ACTIONS(980),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(980),
    [anon_sym_DOLLAR] = ACTIONS(980),
    [anon_sym_AT] = ACTIONS(980),
    [sym_dots] = ACTIONS(982),
    [anon_sym_DASH] = ACTIONS(982),
    [anon_sym_PLUS] = ACTIONS(980),
    [anon_sym_BANG] = ACTIONS(982),
    [anon_sym_TILDE] = ACTIONS(980),
    [anon_sym_STAR] = ACTIONS(980),
    [anon_sym_SLASH] = ACTIONS(980),
    [anon_sym_CARET] = ACTIONS(980),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_LT_EQ] = ACTIONS(980),
    [anon_sym_GT_EQ] = ACTIONS(980),
    [anon_sym_EQ_EQ] = ACTIONS(980),
    [anon_sym_BANG_EQ] = ACTIONS(980),
    [anon_sym_PIPE_PIPE] = ACTIONS(980),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(980),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_PIPE_GT] = ACTIONS(980),
    [anon_sym_COLON] = ACTIONS(982),
    [sym_break] = ACTIONS(982),
    [sym_next] = ACTIONS(982),
    [sym_true] = ACTIONS(982),
    [sym_false] = ACTIONS(982),
    [sym_null] = ACTIONS(982),
    [sym_inf] = ACTIONS(982),
    [sym_nan] = ACTIONS(982),
    [anon_sym_NA] = ACTIONS(982),
    [anon_sym_NA_character_] = ACTIONS(982),
    [anon_sym_NA_complex_] = ACTIONS(982),
    [anon_sym_NA_integer_] = ACTIONS(982),
    [anon_sym_NA_real_] = ACTIONS(982),
    [aux_sym_identifier_token1] = ACTIONS(982),
    [anon_sym_BQUOTE] = ACTIONS(980),
    [sym_integer] = ACTIONS(980),
    [sym_float] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(980),
    [anon_sym_SQUOTE] = ACTIONS(980),
    [anon_sym_PERCENT] = ACTIONS(980),
  },
  [233] = {
    [anon_sym_SEMI] = ACTIONS(984),
    [anon_sym_function] = ACTIONS(986),
    [anon_sym_if] = ACTIONS(986),
    [anon_sym_LPAREN] = ACTIONS(984),
    [anon_sym_RPAREN] = ACTIONS(984),
    [anon_sym_else] = ACTIONS(986),
    [anon_sym_while] = ACTIONS(986),
    [anon_sym_repeat] = ACTIONS(986),
    [anon_sym_for] = ACTIONS(986),
    [anon_sym_switch] = ACTIONS(986),
    [anon_sym_COMMA] = ACTIONS(984),
    [anon_sym_EQ] = ACTIONS(986),
    [anon_sym_LBRACE] = ACTIONS(984),
    [anon_sym_LT_DASH] = ACTIONS(984),
    [anon_sym_COLON_EQ] = ACTIONS(984),
    [anon_sym_LT_LT_DASH] = ACTIONS(984),
    [anon_sym_DASH_GT] = ACTIONS(984),
    [anon_sym_LBRACK] = ACTIONS(986),
    [anon_sym_RBRACK] = ACTIONS(984),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(984),
    [anon_sym_DOLLAR] = ACTIONS(984),
    [anon_sym_AT] = ACTIONS(984),
    [sym_dots] = ACTIONS(986),
    [anon_sym_DASH] = ACTIONS(986),
    [anon_sym_PLUS] = ACTIONS(984),
    [anon_sym_BANG] = ACTIONS(986),
    [anon_sym_TILDE] = ACTIONS(984),
    [anon_sym_STAR] = ACTIONS(984),
    [anon_sym_SLASH] = ACTIONS(984),
    [anon_sym_CARET] = ACTIONS(984),
    [anon_sym_LT] = ACTIONS(986),
    [anon_sym_GT] = ACTIONS(986),
    [anon_sym_LT_EQ] = ACTIONS(984),
    [anon_sym_GT_EQ] = ACTIONS(984),
    [anon_sym_EQ_EQ] = ACTIONS(984),
    [anon_sym_BANG_EQ] = ACTIONS(984),
    [anon_sym_PIPE_PIPE] = ACTIONS(984),
    [anon_sym_PIPE] = ACTIONS(986),
    [anon_sym_AMP_AMP] = ACTIONS(984),
    [anon_sym_AMP] = ACTIONS(986),
    [anon_sym_PIPE_GT] = ACTIONS(984),
    [anon_sym_COLON] = ACTIONS(986),
    [sym_break] = ACTIONS(986),
    [sym_next] = ACTIONS(986),
    [sym_true] = ACTIONS(986),
    [sym_false] = ACTIONS(986),
    [sym_null] = ACTIONS(986),
    [sym_inf] = ACTIONS(986),
    [sym_nan] = ACTIONS(986),
    [anon_sym_NA] = ACTIONS(986),
    [anon_sym_NA_character_] = ACTIONS(986),
    [anon_sym_NA_complex_] = ACTIONS(986),
    [anon_sym_NA_integer_] = ACTIONS(986),
    [anon_sym_NA_real_] = ACTIONS(986),
    [aux_sym_identifier_token1] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(984),
    [sym_integer] = ACTIONS(984),
    [sym_float] = ACTIONS(986),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(984),
    [anon_sym_SQUOTE] = ACTIONS(984),
    [anon_sym_PERCENT] = ACTIONS(984),
  },
  [234] = {
    [anon_sym_SEMI] = ACTIONS(988),
    [anon_sym_function] = ACTIONS(990),
    [anon_sym_if] = ACTIONS(990),
    [anon_sym_LPAREN] = ACTIONS(988),
    [anon_sym_RPAREN] = ACTIONS(988),
    [anon_sym_else] = ACTIONS(990),
    [anon_sym_while] = ACTIONS(990),
    [anon_sym_repeat] = ACTIONS(990),
    [anon_sym_for] = ACTIONS(990),
    [anon_sym_switch] = ACTIONS(990),
    [anon_sym_COMMA] = ACTIONS(988),
    [anon_sym_EQ] = ACTIONS(990),
    [anon_sym_LBRACE] = ACTIONS(988),
    [anon_sym_LT_DASH] = ACTIONS(988),
    [anon_sym_COLON_EQ] = ACTIONS(988),
    [anon_sym_LT_LT_DASH] = ACTIONS(988),
    [anon_sym_DASH_GT] = ACTIONS(988),
    [anon_sym_LBRACK] = ACTIONS(990),
    [anon_sym_RBRACK] = ACTIONS(988),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(988),
    [anon_sym_DOLLAR] = ACTIONS(988),
    [anon_sym_AT] = ACTIONS(988),
    [sym_dots] = ACTIONS(990),
    [anon_sym_DASH] = ACTIONS(990),
    [anon_sym_PLUS] = ACTIONS(988),
    [anon_sym_BANG] = ACTIONS(990),
    [anon_sym_TILDE] = ACTIONS(988),
    [anon_sym_STAR] = ACTIONS(988),
    [anon_sym_SLASH] = ACTIONS(988),
    [anon_sym_CARET] = ACTIONS(988),
    [anon_sym_LT] = ACTIONS(990),
    [anon_sym_GT] = ACTIONS(990),
    [anon_sym_LT_EQ] = ACTIONS(988),
    [anon_sym_GT_EQ] = ACTIONS(988),
    [anon_sym_EQ_EQ] = ACTIONS(988),
    [anon_sym_BANG_EQ] = ACTIONS(988),
    [anon_sym_PIPE_PIPE] = ACTIONS(988),
    [anon_sym_PIPE] = ACTIONS(990),
    [anon_sym_AMP_AMP] = ACTIONS(988),
    [anon_sym_AMP] = ACTIONS(990),
    [anon_sym_PIPE_GT] = ACTIONS(988),
    [anon_sym_COLON] = ACTIONS(990),
    [sym_break] = ACTIONS(990),
    [sym_next] = ACTIONS(990),
    [sym_true] = ACTIONS(990),
    [sym_false] = ACTIONS(990),
    [sym_null] = ACTIONS(990),
    [sym_inf] = ACTIONS(990),
    [sym_nan] = ACTIONS(990),
    [anon_sym_NA] = ACTIONS(990),
    [anon_sym_NA_character_] = ACTIONS(990),
    [anon_sym_NA_complex_] = ACTIONS(990),
    [anon_sym_NA_integer_] = ACTIONS(990),
    [anon_sym_NA_real_] = ACTIONS(990),
    [aux_sym_identifier_token1] = ACTIONS(990),
    [anon_sym_BQUOTE] = ACTIONS(988),
    [sym_integer] = ACTIONS(988),
    [sym_float] = ACTIONS(990),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(988),
    [anon_sym_SQUOTE] = ACTIONS(988),
    [anon_sym_PERCENT] = ACTIONS(988),
  },
  [235] = {
    [anon_sym_SEMI] = ACTIONS(992),
    [anon_sym_function] = ACTIONS(994),
    [anon_sym_if] = ACTIONS(994),
    [anon_sym_LPAREN] = ACTIONS(992),
    [anon_sym_RPAREN] = ACTIONS(992),
    [anon_sym_else] = ACTIONS(994),
    [anon_sym_while] = ACTIONS(994),
    [anon_sym_repeat] = ACTIONS(994),
    [anon_sym_for] = ACTIONS(994),
    [anon_sym_switch] = ACTIONS(994),
    [anon_sym_COMMA] = ACTIONS(992),
    [anon_sym_EQ] = ACTIONS(994),
    [anon_sym_LBRACE] = ACTIONS(992),
    [anon_sym_LT_DASH] = ACTIONS(992),
    [anon_sym_COLON_EQ] = ACTIONS(992),
    [anon_sym_LT_LT_DASH] = ACTIONS(992),
    [anon_sym_DASH_GT] = ACTIONS(992),
    [anon_sym_LBRACK] = ACTIONS(994),
    [anon_sym_RBRACK] = ACTIONS(992),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(992),
    [anon_sym_DOLLAR] = ACTIONS(992),
    [anon_sym_AT] = ACTIONS(992),
    [sym_dots] = ACTIONS(994),
    [anon_sym_DASH] = ACTIONS(994),
    [anon_sym_PLUS] = ACTIONS(992),
    [anon_sym_BANG] = ACTIONS(994),
    [anon_sym_TILDE] = ACTIONS(992),
    [anon_sym_STAR] = ACTIONS(992),
    [anon_sym_SLASH] = ACTIONS(992),
    [anon_sym_CARET] = ACTIONS(992),
    [anon_sym_LT] = ACTIONS(994),
    [anon_sym_GT] = ACTIONS(994),
    [anon_sym_LT_EQ] = ACTIONS(992),
    [anon_sym_GT_EQ] = ACTIONS(992),
    [anon_sym_EQ_EQ] = ACTIONS(992),
    [anon_sym_BANG_EQ] = ACTIONS(992),
    [anon_sym_PIPE_PIPE] = ACTIONS(992),
    [anon_sym_PIPE] = ACTIONS(994),
    [anon_sym_AMP_AMP] = ACTIONS(992),
    [anon_sym_AMP] = ACTIONS(994),
    [anon_sym_PIPE_GT] = ACTIONS(992),
    [anon_sym_COLON] = ACTIONS(994),
    [sym_break] = ACTIONS(994),
    [sym_next] = ACTIONS(994),
    [sym_true] = ACTIONS(994),
    [sym_false] = ACTIONS(994),
    [sym_null] = ACTIONS(994),
    [sym_inf] = ACTIONS(994),
    [sym_nan] = ACTIONS(994),
    [anon_sym_NA] = ACTIONS(994),
    [anon_sym_NA_character_] = ACTIONS(994),
    [anon_sym_NA_complex_] = ACTIONS(994),
    [anon_sym_NA_integer_] = ACTIONS(994),
    [anon_sym_NA_real_] = ACTIONS(994),
    [aux_sym_identifier_token1] = ACTIONS(994),
    [anon_sym_BQUOTE] = ACTIONS(992),
    [sym_integer] = ACTIONS(992),
    [sym_float] = ACTIONS(994),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(992),
    [anon_sym_SQUOTE] = ACTIONS(992),
    [anon_sym_PERCENT] = ACTIONS(992),
  },
  [236] = {
    [anon_sym_SEMI] = ACTIONS(996),
    [anon_sym_function] = ACTIONS(998),
    [anon_sym_if] = ACTIONS(998),
    [anon_sym_LPAREN] = ACTIONS(996),
    [anon_sym_RPAREN] = ACTIONS(996),
    [anon_sym_else] = ACTIONS(998),
    [anon_sym_while] = ACTIONS(998),
    [anon_sym_repeat] = ACTIONS(998),
    [anon_sym_for] = ACTIONS(998),
    [anon_sym_switch] = ACTIONS(998),
    [anon_sym_COMMA] = ACTIONS(996),
    [anon_sym_EQ] = ACTIONS(998),
    [anon_sym_LBRACE] = ACTIONS(996),
    [anon_sym_LT_DASH] = ACTIONS(996),
    [anon_sym_COLON_EQ] = ACTIONS(996),
    [anon_sym_LT_LT_DASH] = ACTIONS(996),
    [anon_sym_DASH_GT] = ACTIONS(996),
    [anon_sym_LBRACK] = ACTIONS(998),
    [anon_sym_RBRACK] = ACTIONS(996),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(996),
    [anon_sym_DOLLAR] = ACTIONS(996),
    [anon_sym_AT] = ACTIONS(996),
    [sym_dots] = ACTIONS(998),
    [anon_sym_DASH] = ACTIONS(998),
    [anon_sym_PLUS] = ACTIONS(996),
    [anon_sym_BANG] = ACTIONS(998),
    [anon_sym_TILDE] = ACTIONS(996),
    [anon_sym_STAR] = ACTIONS(996),
    [anon_sym_SLASH] = ACTIONS(996),
    [anon_sym_CARET] = ACTIONS(996),
    [anon_sym_LT] = ACTIONS(998),
    [anon_sym_GT] = ACTIONS(998),
    [anon_sym_LT_EQ] = ACTIONS(996),
    [anon_sym_GT_EQ] = ACTIONS(996),
    [anon_sym_EQ_EQ] = ACTIONS(996),
    [anon_sym_BANG_EQ] = ACTIONS(996),
    [anon_sym_PIPE_PIPE] = ACTIONS(996),
    [anon_sym_PIPE] = ACTIONS(998),
    [anon_sym_AMP_AMP] = ACTIONS(996),
    [anon_sym_AMP] = ACTIONS(998),
    [anon_sym_PIPE_GT] = ACTIONS(996),
    [anon_sym_COLON] = ACTIONS(998),
    [sym_break] = ACTIONS(998),
    [sym_next] = ACTIONS(998),
    [sym_true] = ACTIONS(998),
    [sym_false] = ACTIONS(998),
    [sym_null] = ACTIONS(998),
    [sym_inf] = ACTIONS(998),
    [sym_nan] = ACTIONS(998),
    [anon_sym_NA] = ACTIONS(998),
    [anon_sym_NA_character_] = ACTIONS(998),
    [anon_sym_NA_complex_] = ACTIONS(998),
    [anon_sym_NA_integer_] = ACTIONS(998),
    [anon_sym_NA_real_] = ACTIONS(998),
    [aux_sym_identifier_token1] = ACTIONS(998),
    [anon_sym_BQUOTE] = ACTIONS(996),
    [sym_integer] = ACTIONS(996),
    [sym_float] = ACTIONS(998),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(996),
    [anon_sym_SQUOTE] = ACTIONS(996),
    [anon_sym_PERCENT] = ACTIONS(996),
  },
  [237] = {
    [anon_sym_LF] = ACTIONS(323),
    [anon_sym_SEMI] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(323),
    [anon_sym_RBRACE] = ACTIONS(323),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_AT] = ACTIONS(323),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(323),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(323),
    [anon_sym_SLASH] = ACTIONS(323),
    [anon_sym_CARET] = ACTIONS(323),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(323),
    [anon_sym_GT_EQ] = ACTIONS(323),
    [anon_sym_EQ_EQ] = ACTIONS(323),
    [anon_sym_BANG_EQ] = ACTIONS(323),
    [anon_sym_PIPE_PIPE] = ACTIONS(323),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(323),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_SQUOTE] = ACTIONS(323),
    [anon_sym_PERCENT] = ACTIONS(323),
  },
  [238] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(750),
    [anon_sym_function] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_repeat] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(750),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(752),
    [sym_next] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_inf] = ACTIONS(752),
    [sym_nan] = ACTIONS(752),
    [anon_sym_NA] = ACTIONS(752),
    [anon_sym_NA_character_] = ACTIONS(752),
    [anon_sym_NA_complex_] = ACTIONS(752),
    [anon_sym_NA_integer_] = ACTIONS(752),
    [anon_sym_NA_real_] = ACTIONS(752),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [sym_integer] = ACTIONS(750),
    [sym_float] = ACTIONS(752),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(750),
    [anon_sym_SQUOTE] = ACTIONS(750),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [239] = {
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [anon_sym_COLON_COLON] = ACTIONS(1000),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1002),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [240] = {
    [anon_sym_SEMI] = ACTIONS(1004),
    [anon_sym_function] = ACTIONS(1006),
    [anon_sym_if] = ACTIONS(1006),
    [anon_sym_LPAREN] = ACTIONS(1004),
    [anon_sym_RPAREN] = ACTIONS(1004),
    [anon_sym_else] = ACTIONS(1006),
    [anon_sym_while] = ACTIONS(1006),
    [anon_sym_repeat] = ACTIONS(1006),
    [anon_sym_for] = ACTIONS(1006),
    [anon_sym_switch] = ACTIONS(1006),
    [anon_sym_COMMA] = ACTIONS(1004),
    [anon_sym_EQ] = ACTIONS(1006),
    [anon_sym_LBRACE] = ACTIONS(1004),
    [anon_sym_LT_DASH] = ACTIONS(1004),
    [anon_sym_COLON_EQ] = ACTIONS(1004),
    [anon_sym_LT_LT_DASH] = ACTIONS(1004),
    [anon_sym_DASH_GT] = ACTIONS(1004),
    [anon_sym_LBRACK] = ACTIONS(1006),
    [anon_sym_RBRACK] = ACTIONS(1004),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1004),
    [anon_sym_DOLLAR] = ACTIONS(1004),
    [anon_sym_AT] = ACTIONS(1004),
    [sym_dots] = ACTIONS(1006),
    [anon_sym_DASH] = ACTIONS(1006),
    [anon_sym_PLUS] = ACTIONS(1004),
    [anon_sym_BANG] = ACTIONS(1006),
    [anon_sym_TILDE] = ACTIONS(1004),
    [anon_sym_STAR] = ACTIONS(1004),
    [anon_sym_SLASH] = ACTIONS(1004),
    [anon_sym_CARET] = ACTIONS(1004),
    [anon_sym_LT] = ACTIONS(1006),
    [anon_sym_GT] = ACTIONS(1006),
    [anon_sym_LT_EQ] = ACTIONS(1004),
    [anon_sym_GT_EQ] = ACTIONS(1004),
    [anon_sym_EQ_EQ] = ACTIONS(1004),
    [anon_sym_BANG_EQ] = ACTIONS(1004),
    [anon_sym_PIPE_PIPE] = ACTIONS(1004),
    [anon_sym_PIPE] = ACTIONS(1006),
    [anon_sym_AMP_AMP] = ACTIONS(1004),
    [anon_sym_AMP] = ACTIONS(1006),
    [anon_sym_PIPE_GT] = ACTIONS(1004),
    [anon_sym_COLON] = ACTIONS(1006),
    [sym_break] = ACTIONS(1006),
    [sym_next] = ACTIONS(1006),
    [sym_true] = ACTIONS(1006),
    [sym_false] = ACTIONS(1006),
    [sym_null] = ACTIONS(1006),
    [sym_inf] = ACTIONS(1006),
    [sym_nan] = ACTIONS(1006),
    [anon_sym_NA] = ACTIONS(1006),
    [anon_sym_NA_character_] = ACTIONS(1006),
    [anon_sym_NA_complex_] = ACTIONS(1006),
    [anon_sym_NA_integer_] = ACTIONS(1006),
    [anon_sym_NA_real_] = ACTIONS(1006),
    [aux_sym_identifier_token1] = ACTIONS(1006),
    [anon_sym_BQUOTE] = ACTIONS(1004),
    [sym_integer] = ACTIONS(1004),
    [sym_float] = ACTIONS(1006),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1004),
    [anon_sym_SQUOTE] = ACTIONS(1004),
    [anon_sym_PERCENT] = ACTIONS(1004),
  },
  [241] = {
    [anon_sym_SEMI] = ACTIONS(1008),
    [anon_sym_function] = ACTIONS(1010),
    [anon_sym_if] = ACTIONS(1010),
    [anon_sym_LPAREN] = ACTIONS(1008),
    [anon_sym_RPAREN] = ACTIONS(1008),
    [anon_sym_else] = ACTIONS(1010),
    [anon_sym_while] = ACTIONS(1010),
    [anon_sym_repeat] = ACTIONS(1010),
    [anon_sym_for] = ACTIONS(1010),
    [anon_sym_switch] = ACTIONS(1010),
    [anon_sym_COMMA] = ACTIONS(1008),
    [anon_sym_EQ] = ACTIONS(1010),
    [anon_sym_LBRACE] = ACTIONS(1008),
    [anon_sym_LT_DASH] = ACTIONS(1008),
    [anon_sym_COLON_EQ] = ACTIONS(1008),
    [anon_sym_LT_LT_DASH] = ACTIONS(1008),
    [anon_sym_DASH_GT] = ACTIONS(1008),
    [anon_sym_LBRACK] = ACTIONS(1010),
    [anon_sym_RBRACK] = ACTIONS(1008),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1008),
    [anon_sym_DOLLAR] = ACTIONS(1008),
    [anon_sym_AT] = ACTIONS(1008),
    [sym_dots] = ACTIONS(1010),
    [anon_sym_DASH] = ACTIONS(1010),
    [anon_sym_PLUS] = ACTIONS(1008),
    [anon_sym_BANG] = ACTIONS(1010),
    [anon_sym_TILDE] = ACTIONS(1008),
    [anon_sym_STAR] = ACTIONS(1008),
    [anon_sym_SLASH] = ACTIONS(1008),
    [anon_sym_CARET] = ACTIONS(1008),
    [anon_sym_LT] = ACTIONS(1010),
    [anon_sym_GT] = ACTIONS(1010),
    [anon_sym_LT_EQ] = ACTIONS(1008),
    [anon_sym_GT_EQ] = ACTIONS(1008),
    [anon_sym_EQ_EQ] = ACTIONS(1008),
    [anon_sym_BANG_EQ] = ACTIONS(1008),
    [anon_sym_PIPE_PIPE] = ACTIONS(1008),
    [anon_sym_PIPE] = ACTIONS(1010),
    [anon_sym_AMP_AMP] = ACTIONS(1008),
    [anon_sym_AMP] = ACTIONS(1010),
    [anon_sym_PIPE_GT] = ACTIONS(1008),
    [anon_sym_COLON] = ACTIONS(1010),
    [sym_break] = ACTIONS(1010),
    [sym_next] = ACTIONS(1010),
    [sym_true] = ACTIONS(1010),
    [sym_false] = ACTIONS(1010),
    [sym_null] = ACTIONS(1010),
    [sym_inf] = ACTIONS(1010),
    [sym_nan] = ACTIONS(1010),
    [anon_sym_NA] = ACTIONS(1010),
    [anon_sym_NA_character_] = ACTIONS(1010),
    [anon_sym_NA_complex_] = ACTIONS(1010),
    [anon_sym_NA_integer_] = ACTIONS(1010),
    [anon_sym_NA_real_] = ACTIONS(1010),
    [aux_sym_identifier_token1] = ACTIONS(1010),
    [anon_sym_BQUOTE] = ACTIONS(1008),
    [sym_integer] = ACTIONS(1008),
    [sym_float] = ACTIONS(1010),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1008),
    [anon_sym_SQUOTE] = ACTIONS(1008),
    [anon_sym_PERCENT] = ACTIONS(1008),
  },
  [242] = {
    [anon_sym_SEMI] = ACTIONS(1012),
    [anon_sym_function] = ACTIONS(1014),
    [anon_sym_if] = ACTIONS(1014),
    [anon_sym_LPAREN] = ACTIONS(1012),
    [anon_sym_RPAREN] = ACTIONS(1012),
    [anon_sym_else] = ACTIONS(1014),
    [anon_sym_while] = ACTIONS(1014),
    [anon_sym_repeat] = ACTIONS(1014),
    [anon_sym_for] = ACTIONS(1014),
    [anon_sym_switch] = ACTIONS(1014),
    [anon_sym_COMMA] = ACTIONS(1012),
    [anon_sym_EQ] = ACTIONS(1014),
    [anon_sym_LBRACE] = ACTIONS(1012),
    [anon_sym_LT_DASH] = ACTIONS(1012),
    [anon_sym_COLON_EQ] = ACTIONS(1012),
    [anon_sym_LT_LT_DASH] = ACTIONS(1012),
    [anon_sym_DASH_GT] = ACTIONS(1012),
    [anon_sym_LBRACK] = ACTIONS(1014),
    [anon_sym_RBRACK] = ACTIONS(1012),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1012),
    [anon_sym_DOLLAR] = ACTIONS(1012),
    [anon_sym_AT] = ACTIONS(1012),
    [sym_dots] = ACTIONS(1014),
    [anon_sym_DASH] = ACTIONS(1014),
    [anon_sym_PLUS] = ACTIONS(1012),
    [anon_sym_BANG] = ACTIONS(1014),
    [anon_sym_TILDE] = ACTIONS(1012),
    [anon_sym_STAR] = ACTIONS(1012),
    [anon_sym_SLASH] = ACTIONS(1012),
    [anon_sym_CARET] = ACTIONS(1012),
    [anon_sym_LT] = ACTIONS(1014),
    [anon_sym_GT] = ACTIONS(1014),
    [anon_sym_LT_EQ] = ACTIONS(1012),
    [anon_sym_GT_EQ] = ACTIONS(1012),
    [anon_sym_EQ_EQ] = ACTIONS(1012),
    [anon_sym_BANG_EQ] = ACTIONS(1012),
    [anon_sym_PIPE_PIPE] = ACTIONS(1012),
    [anon_sym_PIPE] = ACTIONS(1014),
    [anon_sym_AMP_AMP] = ACTIONS(1012),
    [anon_sym_AMP] = ACTIONS(1014),
    [anon_sym_PIPE_GT] = ACTIONS(1012),
    [anon_sym_COLON] = ACTIONS(1014),
    [sym_break] = ACTIONS(1014),
    [sym_next] = ACTIONS(1014),
    [sym_true] = ACTIONS(1014),
    [sym_false] = ACTIONS(1014),
    [sym_null] = ACTIONS(1014),
    [sym_inf] = ACTIONS(1014),
    [sym_nan] = ACTIONS(1014),
    [anon_sym_NA] = ACTIONS(1014),
    [anon_sym_NA_character_] = ACTIONS(1014),
    [anon_sym_NA_complex_] = ACTIONS(1014),
    [anon_sym_NA_integer_] = ACTIONS(1014),
    [anon_sym_NA_real_] = ACTIONS(1014),
    [aux_sym_identifier_token1] = ACTIONS(1014),
    [anon_sym_BQUOTE] = ACTIONS(1012),
    [sym_integer] = ACTIONS(1012),
    [sym_float] = ACTIONS(1014),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1012),
    [anon_sym_SQUOTE] = ACTIONS(1012),
    [anon_sym_PERCENT] = ACTIONS(1012),
  },
  [243] = {
    [anon_sym_SEMI] = ACTIONS(1016),
    [anon_sym_function] = ACTIONS(1018),
    [anon_sym_if] = ACTIONS(1018),
    [anon_sym_LPAREN] = ACTIONS(1016),
    [anon_sym_RPAREN] = ACTIONS(1016),
    [anon_sym_else] = ACTIONS(1018),
    [anon_sym_while] = ACTIONS(1018),
    [anon_sym_repeat] = ACTIONS(1018),
    [anon_sym_for] = ACTIONS(1018),
    [anon_sym_switch] = ACTIONS(1018),
    [anon_sym_COMMA] = ACTIONS(1016),
    [anon_sym_EQ] = ACTIONS(1018),
    [anon_sym_LBRACE] = ACTIONS(1016),
    [anon_sym_LT_DASH] = ACTIONS(1016),
    [anon_sym_COLON_EQ] = ACTIONS(1016),
    [anon_sym_LT_LT_DASH] = ACTIONS(1016),
    [anon_sym_DASH_GT] = ACTIONS(1016),
    [anon_sym_LBRACK] = ACTIONS(1018),
    [anon_sym_RBRACK] = ACTIONS(1016),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1016),
    [anon_sym_DOLLAR] = ACTIONS(1016),
    [anon_sym_AT] = ACTIONS(1016),
    [sym_dots] = ACTIONS(1018),
    [anon_sym_DASH] = ACTIONS(1018),
    [anon_sym_PLUS] = ACTIONS(1016),
    [anon_sym_BANG] = ACTIONS(1018),
    [anon_sym_TILDE] = ACTIONS(1016),
    [anon_sym_STAR] = ACTIONS(1016),
    [anon_sym_SLASH] = ACTIONS(1016),
    [anon_sym_CARET] = ACTIONS(1016),
    [anon_sym_LT] = ACTIONS(1018),
    [anon_sym_GT] = ACTIONS(1018),
    [anon_sym_LT_EQ] = ACTIONS(1016),
    [anon_sym_GT_EQ] = ACTIONS(1016),
    [anon_sym_EQ_EQ] = ACTIONS(1016),
    [anon_sym_BANG_EQ] = ACTIONS(1016),
    [anon_sym_PIPE_PIPE] = ACTIONS(1016),
    [anon_sym_PIPE] = ACTIONS(1018),
    [anon_sym_AMP_AMP] = ACTIONS(1016),
    [anon_sym_AMP] = ACTIONS(1018),
    [anon_sym_PIPE_GT] = ACTIONS(1016),
    [anon_sym_COLON] = ACTIONS(1018),
    [sym_break] = ACTIONS(1018),
    [sym_next] = ACTIONS(1018),
    [sym_true] = ACTIONS(1018),
    [sym_false] = ACTIONS(1018),
    [sym_null] = ACTIONS(1018),
    [sym_inf] = ACTIONS(1018),
    [sym_nan] = ACTIONS(1018),
    [anon_sym_NA] = ACTIONS(1018),
    [anon_sym_NA_character_] = ACTIONS(1018),
    [anon_sym_NA_complex_] = ACTIONS(1018),
    [anon_sym_NA_integer_] = ACTIONS(1018),
    [anon_sym_NA_real_] = ACTIONS(1018),
    [aux_sym_identifier_token1] = ACTIONS(1018),
    [anon_sym_BQUOTE] = ACTIONS(1016),
    [sym_integer] = ACTIONS(1016),
    [sym_float] = ACTIONS(1018),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1016),
    [anon_sym_SQUOTE] = ACTIONS(1016),
    [anon_sym_PERCENT] = ACTIONS(1016),
  },
  [244] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(754),
    [anon_sym_function] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(756),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_repeat] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_COMMA] = ACTIONS(754),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(754),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(756),
    [sym_next] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_inf] = ACTIONS(756),
    [sym_nan] = ACTIONS(756),
    [anon_sym_NA] = ACTIONS(756),
    [anon_sym_NA_character_] = ACTIONS(756),
    [anon_sym_NA_complex_] = ACTIONS(756),
    [anon_sym_NA_integer_] = ACTIONS(756),
    [anon_sym_NA_real_] = ACTIONS(756),
    [aux_sym_identifier_token1] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(754),
    [sym_integer] = ACTIONS(754),
    [sym_float] = ACTIONS(756),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(754),
    [anon_sym_SQUOTE] = ACTIONS(754),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [245] = {
    [ts_builtin_sym_end] = ACTIONS(317),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(319),
    [anon_sym_LT_DASH] = ACTIONS(319),
    [anon_sym_COLON_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_DASH] = ACTIONS(319),
    [anon_sym_DASH_GT] = ACTIONS(319),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(319),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(319),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(319),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(319),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_STAR] = ACTIONS(319),
    [anon_sym_SLASH] = ACTIONS(319),
    [anon_sym_CARET] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(319),
    [anon_sym_GT_EQ] = ACTIONS(319),
    [anon_sym_EQ_EQ] = ACTIONS(319),
    [anon_sym_BANG_EQ] = ACTIONS(319),
    [anon_sym_PIPE_PIPE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(319),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(319),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym_integer] = ACTIONS(319),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [anon_sym_SQUOTE] = ACTIONS(319),
    [anon_sym_PERCENT] = ACTIONS(319),
  },
  [246] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(520),
    [anon_sym_LF] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(1020),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(522),
    [sym_integer] = ACTIONS(522),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(522),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [247] = {
    [anon_sym_LF] = ACTIONS(331),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_RBRACE] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(331),
    [anon_sym_COLON_EQ] = ACTIONS(331),
    [anon_sym_LT_LT_DASH] = ACTIONS(331),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(331),
    [anon_sym_DOLLAR] = ACTIONS(331),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(331),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(331),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(331),
    [anon_sym_GT_EQ] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_BANG_EQ] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(331),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(331),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(331),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(331),
    [sym_integer] = ACTIONS(331),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(331),
    [anon_sym_SQUOTE] = ACTIONS(331),
    [anon_sym_PERCENT] = ACTIONS(331),
  },
  [248] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(1022),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(522),
    [sym_integer] = ACTIONS(522),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(522),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [249] = {
    [anon_sym_SEMI] = ACTIONS(1024),
    [anon_sym_function] = ACTIONS(1026),
    [anon_sym_if] = ACTIONS(1026),
    [anon_sym_LPAREN] = ACTIONS(1024),
    [anon_sym_RPAREN] = ACTIONS(1024),
    [anon_sym_else] = ACTIONS(1026),
    [anon_sym_while] = ACTIONS(1026),
    [anon_sym_repeat] = ACTIONS(1026),
    [anon_sym_for] = ACTIONS(1026),
    [anon_sym_switch] = ACTIONS(1026),
    [anon_sym_COMMA] = ACTIONS(1024),
    [anon_sym_EQ] = ACTIONS(1026),
    [anon_sym_LBRACE] = ACTIONS(1024),
    [anon_sym_LT_DASH] = ACTIONS(1024),
    [anon_sym_COLON_EQ] = ACTIONS(1024),
    [anon_sym_LT_LT_DASH] = ACTIONS(1024),
    [anon_sym_DASH_GT] = ACTIONS(1024),
    [anon_sym_LBRACK] = ACTIONS(1026),
    [anon_sym_RBRACK] = ACTIONS(1024),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1024),
    [anon_sym_DOLLAR] = ACTIONS(1024),
    [anon_sym_AT] = ACTIONS(1024),
    [sym_dots] = ACTIONS(1026),
    [anon_sym_DASH] = ACTIONS(1026),
    [anon_sym_PLUS] = ACTIONS(1024),
    [anon_sym_BANG] = ACTIONS(1026),
    [anon_sym_TILDE] = ACTIONS(1024),
    [anon_sym_STAR] = ACTIONS(1024),
    [anon_sym_SLASH] = ACTIONS(1024),
    [anon_sym_CARET] = ACTIONS(1024),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_GT] = ACTIONS(1026),
    [anon_sym_LT_EQ] = ACTIONS(1024),
    [anon_sym_GT_EQ] = ACTIONS(1024),
    [anon_sym_EQ_EQ] = ACTIONS(1024),
    [anon_sym_BANG_EQ] = ACTIONS(1024),
    [anon_sym_PIPE_PIPE] = ACTIONS(1024),
    [anon_sym_PIPE] = ACTIONS(1026),
    [anon_sym_AMP_AMP] = ACTIONS(1024),
    [anon_sym_AMP] = ACTIONS(1026),
    [anon_sym_PIPE_GT] = ACTIONS(1024),
    [anon_sym_COLON] = ACTIONS(1026),
    [sym_break] = ACTIONS(1026),
    [sym_next] = ACTIONS(1026),
    [sym_true] = ACTIONS(1026),
    [sym_false] = ACTIONS(1026),
    [sym_null] = ACTIONS(1026),
    [sym_inf] = ACTIONS(1026),
    [sym_nan] = ACTIONS(1026),
    [anon_sym_NA] = ACTIONS(1026),
    [anon_sym_NA_character_] = ACTIONS(1026),
    [anon_sym_NA_complex_] = ACTIONS(1026),
    [anon_sym_NA_integer_] = ACTIONS(1026),
    [anon_sym_NA_real_] = ACTIONS(1026),
    [aux_sym_identifier_token1] = ACTIONS(1026),
    [anon_sym_BQUOTE] = ACTIONS(1024),
    [sym_integer] = ACTIONS(1024),
    [sym_float] = ACTIONS(1026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1024),
    [anon_sym_SQUOTE] = ACTIONS(1024),
    [anon_sym_PERCENT] = ACTIONS(1024),
  },
  [250] = {
    [ts_builtin_sym_end] = ACTIONS(329),
    [anon_sym_LF] = ACTIONS(331),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(331),
    [anon_sym_COLON_EQ] = ACTIONS(331),
    [anon_sym_LT_LT_DASH] = ACTIONS(331),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(331),
    [anon_sym_DOLLAR] = ACTIONS(331),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(331),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(331),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_LT_EQ] = ACTIONS(331),
    [anon_sym_GT_EQ] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_BANG_EQ] = ACTIONS(331),
    [anon_sym_PIPE_PIPE] = ACTIONS(331),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(331),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE_GT] = ACTIONS(331),
    [anon_sym_COLON] = ACTIONS(331),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(331),
    [sym_integer] = ACTIONS(331),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(331),
    [anon_sym_SQUOTE] = ACTIONS(331),
    [anon_sym_PERCENT] = ACTIONS(331),
  },
  [251] = {
    [anon_sym_SEMI] = ACTIONS(1028),
    [anon_sym_function] = ACTIONS(1030),
    [anon_sym_if] = ACTIONS(1030),
    [anon_sym_LPAREN] = ACTIONS(1028),
    [anon_sym_RPAREN] = ACTIONS(1028),
    [anon_sym_else] = ACTIONS(1030),
    [anon_sym_while] = ACTIONS(1030),
    [anon_sym_repeat] = ACTIONS(1030),
    [anon_sym_for] = ACTIONS(1030),
    [anon_sym_switch] = ACTIONS(1030),
    [anon_sym_COMMA] = ACTIONS(1028),
    [anon_sym_EQ] = ACTIONS(1030),
    [anon_sym_LBRACE] = ACTIONS(1028),
    [anon_sym_LT_DASH] = ACTIONS(1028),
    [anon_sym_COLON_EQ] = ACTIONS(1028),
    [anon_sym_LT_LT_DASH] = ACTIONS(1028),
    [anon_sym_DASH_GT] = ACTIONS(1028),
    [anon_sym_LBRACK] = ACTIONS(1030),
    [anon_sym_RBRACK] = ACTIONS(1028),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1028),
    [anon_sym_DOLLAR] = ACTIONS(1028),
    [anon_sym_AT] = ACTIONS(1028),
    [sym_dots] = ACTIONS(1030),
    [anon_sym_DASH] = ACTIONS(1030),
    [anon_sym_PLUS] = ACTIONS(1028),
    [anon_sym_BANG] = ACTIONS(1030),
    [anon_sym_TILDE] = ACTIONS(1028),
    [anon_sym_STAR] = ACTIONS(1028),
    [anon_sym_SLASH] = ACTIONS(1028),
    [anon_sym_CARET] = ACTIONS(1028),
    [anon_sym_LT] = ACTIONS(1030),
    [anon_sym_GT] = ACTIONS(1030),
    [anon_sym_LT_EQ] = ACTIONS(1028),
    [anon_sym_GT_EQ] = ACTIONS(1028),
    [anon_sym_EQ_EQ] = ACTIONS(1028),
    [anon_sym_BANG_EQ] = ACTIONS(1028),
    [anon_sym_PIPE_PIPE] = ACTIONS(1028),
    [anon_sym_PIPE] = ACTIONS(1030),
    [anon_sym_AMP_AMP] = ACTIONS(1028),
    [anon_sym_AMP] = ACTIONS(1030),
    [anon_sym_PIPE_GT] = ACTIONS(1028),
    [anon_sym_COLON] = ACTIONS(1030),
    [sym_break] = ACTIONS(1030),
    [sym_next] = ACTIONS(1030),
    [sym_true] = ACTIONS(1030),
    [sym_false] = ACTIONS(1030),
    [sym_null] = ACTIONS(1030),
    [sym_inf] = ACTIONS(1030),
    [sym_nan] = ACTIONS(1030),
    [anon_sym_NA] = ACTIONS(1030),
    [anon_sym_NA_character_] = ACTIONS(1030),
    [anon_sym_NA_complex_] = ACTIONS(1030),
    [anon_sym_NA_integer_] = ACTIONS(1030),
    [anon_sym_NA_real_] = ACTIONS(1030),
    [aux_sym_identifier_token1] = ACTIONS(1030),
    [anon_sym_BQUOTE] = ACTIONS(1028),
    [sym_integer] = ACTIONS(1028),
    [sym_float] = ACTIONS(1030),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1028),
    [anon_sym_SQUOTE] = ACTIONS(1028),
    [anon_sym_PERCENT] = ACTIONS(1028),
  },
  [252] = {
    [ts_builtin_sym_end] = ACTIONS(333),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [anon_sym_COLON_COLON] = ACTIONS(1032),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1034),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [253] = {
    [ts_builtin_sym_end] = ACTIONS(333),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_else] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [anon_sym_i] = ACTIONS(1036),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [254] = {
    [ts_builtin_sym_end] = ACTIONS(321),
    [anon_sym_LF] = ACTIONS(323),
    [anon_sym_SEMI] = ACTIONS(323),
    [anon_sym_function] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_repeat] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(323),
    [anon_sym_LT_DASH] = ACTIONS(323),
    [anon_sym_COLON_EQ] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(323),
    [anon_sym_DASH_GT] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(323),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_AT] = ACTIONS(323),
    [anon_sym_COLON_COLON] = ACTIONS(323),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(323),
    [sym_dots] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(323),
    [anon_sym_SLASH] = ACTIONS(323),
    [anon_sym_CARET] = ACTIONS(323),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_EQ] = ACTIONS(323),
    [anon_sym_GT_EQ] = ACTIONS(323),
    [anon_sym_EQ_EQ] = ACTIONS(323),
    [anon_sym_BANG_EQ] = ACTIONS(323),
    [anon_sym_PIPE_PIPE] = ACTIONS(323),
    [anon_sym_PIPE] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(323),
    [anon_sym_PIPE_GT] = ACTIONS(323),
    [anon_sym_COLON] = ACTIONS(323),
    [sym_break] = ACTIONS(323),
    [sym_next] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_null] = ACTIONS(323),
    [sym_inf] = ACTIONS(323),
    [sym_nan] = ACTIONS(323),
    [anon_sym_NA] = ACTIONS(323),
    [anon_sym_NA_character_] = ACTIONS(323),
    [anon_sym_NA_complex_] = ACTIONS(323),
    [anon_sym_NA_integer_] = ACTIONS(323),
    [anon_sym_NA_real_] = ACTIONS(323),
    [aux_sym_identifier_token1] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(323),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_SQUOTE] = ACTIONS(323),
    [anon_sym_PERCENT] = ACTIONS(323),
  },
  [255] = {
    [anon_sym_SEMI] = ACTIONS(1038),
    [anon_sym_function] = ACTIONS(1040),
    [anon_sym_if] = ACTIONS(1040),
    [anon_sym_LPAREN] = ACTIONS(1038),
    [anon_sym_RPAREN] = ACTIONS(1038),
    [anon_sym_else] = ACTIONS(1040),
    [anon_sym_while] = ACTIONS(1040),
    [anon_sym_repeat] = ACTIONS(1040),
    [anon_sym_for] = ACTIONS(1040),
    [anon_sym_switch] = ACTIONS(1040),
    [anon_sym_COMMA] = ACTIONS(1038),
    [anon_sym_EQ] = ACTIONS(1040),
    [anon_sym_LBRACE] = ACTIONS(1038),
    [anon_sym_LT_DASH] = ACTIONS(1038),
    [anon_sym_COLON_EQ] = ACTIONS(1038),
    [anon_sym_LT_LT_DASH] = ACTIONS(1038),
    [anon_sym_DASH_GT] = ACTIONS(1038),
    [anon_sym_LBRACK] = ACTIONS(1040),
    [anon_sym_RBRACK] = ACTIONS(1038),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1038),
    [anon_sym_DOLLAR] = ACTIONS(1038),
    [anon_sym_AT] = ACTIONS(1038),
    [sym_dots] = ACTIONS(1040),
    [anon_sym_DASH] = ACTIONS(1040),
    [anon_sym_PLUS] = ACTIONS(1038),
    [anon_sym_BANG] = ACTIONS(1040),
    [anon_sym_TILDE] = ACTIONS(1038),
    [anon_sym_STAR] = ACTIONS(1038),
    [anon_sym_SLASH] = ACTIONS(1038),
    [anon_sym_CARET] = ACTIONS(1038),
    [anon_sym_LT] = ACTIONS(1040),
    [anon_sym_GT] = ACTIONS(1040),
    [anon_sym_LT_EQ] = ACTIONS(1038),
    [anon_sym_GT_EQ] = ACTIONS(1038),
    [anon_sym_EQ_EQ] = ACTIONS(1038),
    [anon_sym_BANG_EQ] = ACTIONS(1038),
    [anon_sym_PIPE_PIPE] = ACTIONS(1038),
    [anon_sym_PIPE] = ACTIONS(1040),
    [anon_sym_AMP_AMP] = ACTIONS(1038),
    [anon_sym_AMP] = ACTIONS(1040),
    [anon_sym_PIPE_GT] = ACTIONS(1038),
    [anon_sym_COLON] = ACTIONS(1040),
    [sym_break] = ACTIONS(1040),
    [sym_next] = ACTIONS(1040),
    [sym_true] = ACTIONS(1040),
    [sym_false] = ACTIONS(1040),
    [sym_null] = ACTIONS(1040),
    [sym_inf] = ACTIONS(1040),
    [sym_nan] = ACTIONS(1040),
    [anon_sym_NA] = ACTIONS(1040),
    [anon_sym_NA_character_] = ACTIONS(1040),
    [anon_sym_NA_complex_] = ACTIONS(1040),
    [anon_sym_NA_integer_] = ACTIONS(1040),
    [anon_sym_NA_real_] = ACTIONS(1040),
    [aux_sym_identifier_token1] = ACTIONS(1040),
    [anon_sym_BQUOTE] = ACTIONS(1038),
    [sym_integer] = ACTIONS(1038),
    [sym_float] = ACTIONS(1040),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1038),
    [anon_sym_SQUOTE] = ACTIONS(1038),
    [anon_sym_PERCENT] = ACTIONS(1038),
  },
  [256] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(393),
    [anon_sym_LF] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_LT_DASH] = ACTIONS(395),
    [anon_sym_COLON_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_DASH] = ACTIONS(395),
    [anon_sym_DASH_GT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(395),
    [sym_integer] = ACTIONS(395),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [257] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(393),
    [anon_sym_LF] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_repeat] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_LT_DASH] = ACTIONS(395),
    [anon_sym_COLON_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_DASH] = ACTIONS(395),
    [anon_sym_DASH_GT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_AMP_AMP] = ACTIONS(395),
    [anon_sym_AMP] = ACTIONS(395),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(395),
    [sym_next] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_inf] = ACTIONS(395),
    [sym_nan] = ACTIONS(395),
    [anon_sym_NA] = ACTIONS(395),
    [anon_sym_NA_character_] = ACTIONS(395),
    [anon_sym_NA_complex_] = ACTIONS(395),
    [anon_sym_NA_integer_] = ACTIONS(395),
    [anon_sym_NA_real_] = ACTIONS(395),
    [aux_sym_identifier_token1] = ACTIONS(395),
    [anon_sym_BQUOTE] = ACTIONS(395),
    [sym_integer] = ACTIONS(395),
    [sym_float] = ACTIONS(395),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [258] = {
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(319),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_LT_DASH] = ACTIONS(319),
    [anon_sym_COLON_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_DASH] = ACTIONS(319),
    [anon_sym_DASH_GT] = ACTIONS(319),
    [anon_sym_LBRACK] = ACTIONS(319),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(319),
    [anon_sym_DOLLAR] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(319),
    [anon_sym_COLON_COLON] = ACTIONS(319),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(319),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(319),
    [anon_sym_PLUS] = ACTIONS(319),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_STAR] = ACTIONS(319),
    [anon_sym_SLASH] = ACTIONS(319),
    [anon_sym_CARET] = ACTIONS(319),
    [anon_sym_LT] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(319),
    [anon_sym_LT_EQ] = ACTIONS(319),
    [anon_sym_GT_EQ] = ACTIONS(319),
    [anon_sym_EQ_EQ] = ACTIONS(319),
    [anon_sym_BANG_EQ] = ACTIONS(319),
    [anon_sym_PIPE_PIPE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(319),
    [anon_sym_AMP] = ACTIONS(319),
    [anon_sym_PIPE_GT] = ACTIONS(319),
    [anon_sym_COLON] = ACTIONS(319),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym_integer] = ACTIONS(319),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [anon_sym_SQUOTE] = ACTIONS(319),
    [anon_sym_PERCENT] = ACTIONS(319),
  },
  [259] = {
    [sym_special] = STATE(616),
    [anon_sym_LF] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_else] = ACTIONS(1042),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_EQ] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_LT_DASH] = ACTIONS(790),
    [anon_sym_COLON_EQ] = ACTIONS(792),
    [anon_sym_LT_LT_DASH] = ACTIONS(794),
    [anon_sym_DASH_GT] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(760),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(762),
    [anon_sym_DOLLAR] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(766),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(772),
    [anon_sym_CARET] = ACTIONS(774),
    [anon_sym_LT] = ACTIONS(776),
    [anon_sym_GT] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(780),
    [anon_sym_PIPE_GT] = ACTIONS(782),
    [anon_sym_COLON] = ACTIONS(784),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(522),
    [sym_integer] = ACTIONS(522),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(522),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [260] = {
    [sym_special] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_function] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_else] = ACTIONS(1044),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_repeat] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_COMMA] = ACTIONS(520),
    [anon_sym_EQ] = ACTIONS(898),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_LT_DASH] = ACTIONS(900),
    [anon_sym_COLON_EQ] = ACTIONS(902),
    [anon_sym_LT_LT_DASH] = ACTIONS(904),
    [anon_sym_DASH_GT] = ACTIONS(906),
    [anon_sym_LBRACK] = ACTIONS(908),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(910),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(520),
    [anon_sym_DOLLAR] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(914),
    [sym_dots] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_PLUS] = ACTIONS(918),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_STAR] = ACTIONS(922),
    [anon_sym_SLASH] = ACTIONS(922),
    [anon_sym_CARET] = ACTIONS(924),
    [anon_sym_LT] = ACTIONS(926),
    [anon_sym_GT] = ACTIONS(926),
    [anon_sym_LT_EQ] = ACTIONS(928),
    [anon_sym_GT_EQ] = ACTIONS(928),
    [anon_sym_EQ_EQ] = ACTIONS(928),
    [anon_sym_BANG_EQ] = ACTIONS(928),
    [anon_sym_PIPE_PIPE] = ACTIONS(930),
    [anon_sym_PIPE] = ACTIONS(932),
    [anon_sym_AMP_AMP] = ACTIONS(934),
    [anon_sym_AMP] = ACTIONS(936),
    [anon_sym_PIPE_GT] = ACTIONS(938),
    [anon_sym_COLON] = ACTIONS(940),
    [sym_break] = ACTIONS(522),
    [sym_next] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_null] = ACTIONS(522),
    [sym_inf] = ACTIONS(522),
    [sym_nan] = ACTIONS(522),
    [anon_sym_NA] = ACTIONS(522),
    [anon_sym_NA_character_] = ACTIONS(522),
    [anon_sym_NA_complex_] = ACTIONS(522),
    [anon_sym_NA_integer_] = ACTIONS(522),
    [anon_sym_NA_real_] = ACTIONS(522),
    [aux_sym_identifier_token1] = ACTIONS(522),
    [anon_sym_BQUOTE] = ACTIONS(520),
    [sym_integer] = ACTIONS(520),
    [sym_float] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(520),
    [anon_sym_PERCENT] = ACTIONS(518),
  },
  [261] = {
    [sym_special] = STATE(477),
    [ts_builtin_sym_end] = ACTIONS(607),
    [anon_sym_LF] = ACTIONS(609),
    [anon_sym_SEMI] = ACTIONS(609),
    [anon_sym_function] = ACTIONS(609),
    [anon_sym_if] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_else] = ACTIONS(609),
    [anon_sym_while] = ACTIONS(609),
    [anon_sym_repeat] = ACTIONS(609),
    [anon_sym_for] = ACTIONS(609),
    [anon_sym_switch] = ACTIONS(609),
    [anon_sym_EQ] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_LT_DASH] = ACTIONS(804),
    [anon_sym_COLON_EQ] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(808),
    [anon_sym_DASH_GT] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(812),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(814),
    [anon_sym_DOLLAR] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(818),
    [sym_dots] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(820),
    [anon_sym_BANG] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(822),
    [anon_sym_STAR] = ACTIONS(824),
    [anon_sym_SLASH] = ACTIONS(824),
    [anon_sym_CARET] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(828),
    [anon_sym_GT] = ACTIONS(828),
    [anon_sym_LT_EQ] = ACTIONS(828),
    [anon_sym_GT_EQ] = ACTIONS(828),
    [anon_sym_EQ_EQ] = ACTIONS(828),
    [anon_sym_BANG_EQ] = ACTIONS(828),
    [anon_sym_PIPE_PIPE] = ACTIONS(830),
    [anon_sym_PIPE] = ACTIONS(830),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_PIPE_GT] = ACTIONS(834),
    [anon_sym_COLON] = ACTIONS(836),
    [sym_break] = ACTIONS(609),
    [sym_next] = ACTIONS(609),
    [sym_true] = ACTIONS(609),
    [sym_false] = ACTIONS(609),
    [sym_null] = ACTIONS(609),
    [sym_inf] = ACTIONS(609),
    [sym_nan] = ACTIONS(609),
    [anon_sym_NA] = ACTIONS(609),
    [anon_sym_NA_character_] = ACTIONS(609),
    [anon_sym_NA_complex_] = ACTIONS(609),
    [anon_sym_NA_integer_] = ACTIONS(609),
    [anon_sym_NA_real_] = ACTIONS(609),
    [aux_sym_identifier_token1] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [sym_integer] = ACTIONS(609),
    [sym_float] = ACTIONS(609),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(609),
    [anon_sym_SQUOTE] = ACTIONS(609),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [262] = {
    [sym_function_definition] = STATE(192),
    [sym_if] = STATE(192),
    [sym_while] = STATE(192),
    [sym_repeat] = STATE(192),
    [sym_for] = STATE(192),
    [sym_switch] = STATE(192),
    [sym_call] = STATE(192),
    [sym__assignment] = STATE(192),
    [sym_left_assignment] = STATE(192),
    [sym_left_assignment2] = STATE(192),
    [sym_equals_assignment] = STATE(192),
    [sym_super_assignment] = STATE(192),
    [sym_right_assignment] = STATE(192),
    [sym_brace_list] = STATE(192),
    [sym_paren_list] = STATE(192),
    [sym_subset] = STATE(192),
    [sym_subset2] = STATE(192),
    [sym_dollar] = STATE(192),
    [sym_slot] = STATE(192),
    [sym_namespace_get] = STATE(192),
    [sym_namespace_get_internal] = STATE(192),
    [sym_unary] = STATE(192),
    [sym_binary] = STATE(192),
    [sym_na] = STATE(192),
    [sym__expression] = STATE(192),
    [sym_identifier] = STATE(112),
    [sym_complex] = STATE(192),
    [sym_string] = STATE(192),
    [anon_sym_SEMI] = ACTIONS(1046),
    [anon_sym_function] = ACTIONS(1048),
    [anon_sym_if] = ACTIONS(1050),
    [anon_sym_LPAREN] = ACTIONS(1052),
    [anon_sym_while] = ACTIONS(1054),
    [anon_sym_repeat] = ACTIONS(1056),
    [anon_sym_for] = ACTIONS(1058),
    [anon_sym_switch] = ACTIONS(1060),
    [anon_sym_LBRACE] = ACTIONS(1062),
    [sym_dots] = ACTIONS(1064),
    [anon_sym_DASH] = ACTIONS(1066),
    [anon_sym_PLUS] = ACTIONS(1066),
    [anon_sym_BANG] = ACTIONS(1068),
    [anon_sym_TILDE] = ACTIONS(1070),
    [sym_break] = ACTIONS(1064),
    [sym_next] = ACTIONS(1064),
    [sym_true] = ACTIONS(1064),
    [sym_false] = ACTIONS(1064),
    [sym_null] = ACTIONS(1064),
    [sym_inf] = ACTIONS(1064),
    [sym_nan] = ACTIONS(1064),
    [anon_sym_NA] = ACTIONS(1072),
    [anon_sym_NA_character_] = ACTIONS(1072),
    [anon_sym_NA_complex_] = ACTIONS(1072),
    [anon_sym_NA_integer_] = ACTIONS(1072),
    [anon_sym_NA_real_] = ACTIONS(1072),
    [aux_sym_identifier_token1] = ACTIONS(1074),
    [anon_sym_BQUOTE] = ACTIONS(1076),
    [sym_integer] = ACTIONS(1046),
    [sym_float] = ACTIONS(1078),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1080),
    [anon_sym_SQUOTE] = ACTIONS(1082),
  },
  [263] = {
    [anon_sym_SEMI] = ACTIONS(984),
    [anon_sym_function] = ACTIONS(986),
    [anon_sym_if] = ACTIONS(986),
    [anon_sym_LPAREN] = ACTIONS(984),
    [anon_sym_else] = ACTIONS(986),
    [anon_sym_while] = ACTIONS(986),
    [anon_sym_repeat] = ACTIONS(986),
    [anon_sym_for] = ACTIONS(986),
    [anon_sym_switch] = ACTIONS(986),
    [anon_sym_COMMA] = ACTIONS(984),
    [anon_sym_EQ] = ACTIONS(986),
    [anon_sym_LBRACE] = ACTIONS(984),
    [anon_sym_LT_DASH] = ACTIONS(984),
    [anon_sym_COLON_EQ] = ACTIONS(984),
    [anon_sym_LT_LT_DASH] = ACTIONS(984),
    [anon_sym_DASH_GT] = ACTIONS(984),
    [anon_sym_LBRACK] = ACTIONS(986),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(984),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(984),
    [anon_sym_DOLLAR] = ACTIONS(984),
    [anon_sym_AT] = ACTIONS(984),
    [sym_dots] = ACTIONS(986),
    [anon_sym_DASH] = ACTIONS(986),
    [anon_sym_PLUS] = ACTIONS(984),
    [anon_sym_BANG] = ACTIONS(986),
    [anon_sym_TILDE] = ACTIONS(984),
    [anon_sym_STAR] = ACTIONS(984),
    [anon_sym_SLASH] = ACTIONS(984),
    [anon_sym_CARET] = ACTIONS(984),
    [anon_sym_LT] = ACTIONS(986),
    [anon_sym_GT] = ACTIONS(986),
    [anon_sym_LT_EQ] = ACTIONS(984),
    [anon_sym_GT_EQ] = ACTIONS(984),
    [anon_sym_EQ_EQ] = ACTIONS(984),
    [anon_sym_BANG_EQ] = ACTIONS(984),
    [anon_sym_PIPE_PIPE] = ACTIONS(984),
    [anon_sym_PIPE] = ACTIONS(986),
    [anon_sym_AMP_AMP] = ACTIONS(984),
    [anon_sym_AMP] = ACTIONS(986),
    [anon_sym_PIPE_GT] = ACTIONS(984),
    [anon_sym_COLON] = ACTIONS(986),
    [sym_break] = ACTIONS(986),
    [sym_next] = ACTIONS(986),
    [sym_true] = ACTIONS(986),
    [sym_false] = ACTIONS(986),
    [sym_null] = ACTIONS(986),
    [sym_inf] = ACTIONS(986),
    [sym_nan] = ACTIONS(986),
    [anon_sym_NA] = ACTIONS(986),
    [anon_sym_NA_character_] = ACTIONS(986),
    [anon_sym_NA_complex_] = ACTIONS(986),
    [anon_sym_NA_integer_] = ACTIONS(986),
    [anon_sym_NA_real_] = ACTIONS(986),
    [aux_sym_identifier_token1] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(984),
    [sym_integer] = ACTIONS(984),
    [sym_float] = ACTIONS(986),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(984),
    [anon_sym_SQUOTE] = ACTIONS(984),
    [anon_sym_PERCENT] = ACTIONS(984),
  },
  [264] = {
    [sym_function_definition] = STATE(290),
    [sym_if] = STATE(290),
    [sym_while] = STATE(290),
    [sym_repeat] = STATE(290),
    [sym_for] = STATE(290),
    [sym_switch] = STATE(290),
    [sym_call] = STATE(290),
    [sym__assignment] = STATE(290),
    [sym_left_assignment] = STATE(290),
    [sym_left_assignment2] = STATE(290),
    [sym_equals_assignment] = STATE(290),
    [sym_super_assignment] = STATE(290),
    [sym_right_assignment] = STATE(290),
    [sym_brace_list] = STATE(290),
    [sym_paren_list] = STATE(290),
    [sym_subset] = STATE(290),
    [sym_subset2] = STATE(290),
    [sym_dollar] = STATE(290),
    [sym_slot] = STATE(290),
    [sym_namespace_get] = STATE(290),
    [sym_namespace_get_internal] = STATE(290),
    [sym_unary] = STATE(290),
    [sym_binary] = STATE(290),
    [sym_na] = STATE(290),
    [sym__expression] = STATE(290),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(290),
    [sym_string] = STATE(290),
    [anon_sym_SEMI] = ACTIONS(1084),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1086),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1086),
    [sym_next] = ACTIONS(1086),
    [sym_true] = ACTIONS(1086),
    [sym_false] = ACTIONS(1086),
    [sym_null] = ACTIONS(1086),
    [sym_inf] = ACTIONS(1086),
    [sym_nan] = ACTIONS(1086),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1084),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [265] = {
    [sym_function_definition] = STATE(291),
    [sym_if] = STATE(291),
    [sym_while] = STATE(291),
    [sym_repeat] = STATE(291),
    [sym_for] = STATE(291),
    [sym_switch] = STATE(291),
    [sym_call] = STATE(291),
    [sym__assignment] = STATE(291),
    [sym_left_assignment] = STATE(291),
    [sym_left_assignment2] = STATE(291),
    [sym_equals_assignment] = STATE(291),
    [sym_super_assignment] = STATE(291),
    [sym_right_assignment] = STATE(291),
    [sym_brace_list] = STATE(291),
    [sym_paren_list] = STATE(291),
    [sym_subset] = STATE(291),
    [sym_subset2] = STATE(291),
    [sym_dollar] = STATE(291),
    [sym_slot] = STATE(291),
    [sym_namespace_get] = STATE(291),
    [sym_namespace_get_internal] = STATE(291),
    [sym_unary] = STATE(291),
    [sym_binary] = STATE(291),
    [sym_na] = STATE(291),
    [sym__expression] = STATE(291),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(291),
    [sym_string] = STATE(291),
    [anon_sym_SEMI] = ACTIONS(1088),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1090),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1090),
    [sym_next] = ACTIONS(1090),
    [sym_true] = ACTIONS(1090),
    [sym_false] = ACTIONS(1090),
    [sym_null] = ACTIONS(1090),
    [sym_inf] = ACTIONS(1090),
    [sym_nan] = ACTIONS(1090),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1088),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [266] = {
    [sym_function_definition] = STATE(849),
    [sym_if] = STATE(849),
    [sym_while] = STATE(849),
    [sym_repeat] = STATE(849),
    [sym_for] = STATE(849),
    [sym_switch] = STATE(849),
    [sym_call] = STATE(849),
    [sym__assignment] = STATE(849),
    [sym_left_assignment] = STATE(849),
    [sym_left_assignment2] = STATE(849),
    [sym_equals_assignment] = STATE(849),
    [sym_super_assignment] = STATE(849),
    [sym_right_assignment] = STATE(849),
    [sym_brace_list] = STATE(849),
    [sym_paren_list] = STATE(849),
    [sym_subset] = STATE(849),
    [sym_subset2] = STATE(849),
    [sym_dollar] = STATE(849),
    [sym_slot] = STATE(849),
    [sym_namespace_get] = STATE(849),
    [sym_namespace_get_internal] = STATE(849),
    [sym_unary] = STATE(849),
    [sym_binary] = STATE(849),
    [sym_na] = STATE(849),
    [sym__expression] = STATE(849),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(849),
    [sym_string] = STATE(849),
    [anon_sym_SEMI] = ACTIONS(1092),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1104),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1104),
    [sym_next] = ACTIONS(1104),
    [sym_true] = ACTIONS(1104),
    [sym_false] = ACTIONS(1104),
    [sym_null] = ACTIONS(1104),
    [sym_inf] = ACTIONS(1104),
    [sym_nan] = ACTIONS(1104),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1092),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [267] = {
    [sym_function_definition] = STATE(852),
    [sym_if] = STATE(852),
    [sym_while] = STATE(852),
    [sym_repeat] = STATE(852),
    [sym_for] = STATE(852),
    [sym_switch] = STATE(852),
    [sym_call] = STATE(852),
    [sym__assignment] = STATE(852),
    [sym_left_assignment] = STATE(852),
    [sym_left_assignment2] = STATE(852),
    [sym_equals_assignment] = STATE(852),
    [sym_super_assignment] = STATE(852),
    [sym_right_assignment] = STATE(852),
    [sym_brace_list] = STATE(852),
    [sym_paren_list] = STATE(852),
    [sym_subset] = STATE(852),
    [sym_subset2] = STATE(852),
    [sym_dollar] = STATE(852),
    [sym_slot] = STATE(852),
    [sym_namespace_get] = STATE(852),
    [sym_namespace_get_internal] = STATE(852),
    [sym_unary] = STATE(852),
    [sym_binary] = STATE(852),
    [sym_na] = STATE(852),
    [sym__expression] = STATE(852),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(852),
    [sym_string] = STATE(852),
    [anon_sym_SEMI] = ACTIONS(1114),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1116),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1116),
    [sym_next] = ACTIONS(1116),
    [sym_true] = ACTIONS(1116),
    [sym_false] = ACTIONS(1116),
    [sym_null] = ACTIONS(1116),
    [sym_inf] = ACTIONS(1116),
    [sym_nan] = ACTIONS(1116),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1114),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [268] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(708),
    [anon_sym_SEMI] = ACTIONS(708),
    [anon_sym_function] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_repeat] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_EQ] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(708),
    [anon_sym_RBRACE] = ACTIONS(708),
    [anon_sym_LT_DASH] = ACTIONS(708),
    [anon_sym_COLON_EQ] = ACTIONS(708),
    [anon_sym_LT_LT_DASH] = ACTIONS(708),
    [anon_sym_DASH_GT] = ACTIONS(708),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(708),
    [sym_next] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_inf] = ACTIONS(708),
    [sym_nan] = ACTIONS(708),
    [anon_sym_NA] = ACTIONS(708),
    [anon_sym_NA_character_] = ACTIONS(708),
    [anon_sym_NA_complex_] = ACTIONS(708),
    [anon_sym_NA_integer_] = ACTIONS(708),
    [anon_sym_NA_real_] = ACTIONS(708),
    [aux_sym_identifier_token1] = ACTIONS(708),
    [anon_sym_BQUOTE] = ACTIONS(708),
    [sym_integer] = ACTIONS(708),
    [sym_float] = ACTIONS(708),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(708),
    [anon_sym_SQUOTE] = ACTIONS(708),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [269] = {
    [sym_function_definition] = STATE(824),
    [sym_if] = STATE(824),
    [sym_while] = STATE(824),
    [sym_repeat] = STATE(824),
    [sym_for] = STATE(824),
    [sym_switch] = STATE(824),
    [sym_call] = STATE(824),
    [sym__assignment] = STATE(824),
    [sym_left_assignment] = STATE(824),
    [sym_left_assignment2] = STATE(824),
    [sym_equals_assignment] = STATE(824),
    [sym_super_assignment] = STATE(824),
    [sym_right_assignment] = STATE(824),
    [sym_brace_list] = STATE(824),
    [sym_paren_list] = STATE(824),
    [sym_subset] = STATE(824),
    [sym_subset2] = STATE(824),
    [sym_dollar] = STATE(824),
    [sym_slot] = STATE(824),
    [sym_namespace_get] = STATE(824),
    [sym_namespace_get_internal] = STATE(824),
    [sym_unary] = STATE(824),
    [sym_binary] = STATE(824),
    [sym_na] = STATE(824),
    [sym__expression] = STATE(824),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(824),
    [sym_string] = STATE(824),
    [anon_sym_SEMI] = ACTIONS(1146),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1148),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1148),
    [sym_next] = ACTIONS(1148),
    [sym_true] = ACTIONS(1148),
    [sym_false] = ACTIONS(1148),
    [sym_null] = ACTIONS(1148),
    [sym_inf] = ACTIONS(1148),
    [sym_nan] = ACTIONS(1148),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1146),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [270] = {
    [sym_function_definition] = STATE(858),
    [sym_if] = STATE(858),
    [sym_while] = STATE(858),
    [sym_repeat] = STATE(858),
    [sym_for] = STATE(858),
    [sym_switch] = STATE(858),
    [sym_call] = STATE(858),
    [sym__assignment] = STATE(858),
    [sym_left_assignment] = STATE(858),
    [sym_left_assignment2] = STATE(858),
    [sym_equals_assignment] = STATE(858),
    [sym_super_assignment] = STATE(858),
    [sym_right_assignment] = STATE(858),
    [sym_brace_list] = STATE(858),
    [sym_paren_list] = STATE(858),
    [sym_subset] = STATE(858),
    [sym_subset2] = STATE(858),
    [sym_dollar] = STATE(858),
    [sym_slot] = STATE(858),
    [sym_namespace_get] = STATE(858),
    [sym_namespace_get_internal] = STATE(858),
    [sym_unary] = STATE(858),
    [sym_binary] = STATE(858),
    [sym_na] = STATE(858),
    [sym__expression] = STATE(858),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(858),
    [sym_string] = STATE(858),
    [anon_sym_SEMI] = ACTIONS(1150),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1152),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1152),
    [sym_next] = ACTIONS(1152),
    [sym_true] = ACTIONS(1152),
    [sym_false] = ACTIONS(1152),
    [sym_null] = ACTIONS(1152),
    [sym_inf] = ACTIONS(1152),
    [sym_nan] = ACTIONS(1152),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1150),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [271] = {
    [sym_function_definition] = STATE(284),
    [sym_if] = STATE(284),
    [sym_while] = STATE(284),
    [sym_repeat] = STATE(284),
    [sym_for] = STATE(284),
    [sym_switch] = STATE(284),
    [sym_call] = STATE(284),
    [sym__assignment] = STATE(284),
    [sym_left_assignment] = STATE(284),
    [sym_left_assignment2] = STATE(284),
    [sym_equals_assignment] = STATE(284),
    [sym_super_assignment] = STATE(284),
    [sym_right_assignment] = STATE(284),
    [sym_brace_list] = STATE(284),
    [sym_paren_list] = STATE(284),
    [sym_subset] = STATE(284),
    [sym_subset2] = STATE(284),
    [sym_dollar] = STATE(284),
    [sym_slot] = STATE(284),
    [sym_namespace_get] = STATE(284),
    [sym_namespace_get_internal] = STATE(284),
    [sym_unary] = STATE(284),
    [sym_binary] = STATE(284),
    [sym_na] = STATE(284),
    [sym__expression] = STATE(284),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(284),
    [sym_string] = STATE(284),
    [anon_sym_SEMI] = ACTIONS(1154),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1156),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1156),
    [sym_next] = ACTIONS(1156),
    [sym_true] = ACTIONS(1156),
    [sym_false] = ACTIONS(1156),
    [sym_null] = ACTIONS(1156),
    [sym_inf] = ACTIONS(1156),
    [sym_nan] = ACTIONS(1156),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1154),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [272] = {
    [sym_function_definition] = STATE(856),
    [sym_if] = STATE(856),
    [sym_while] = STATE(856),
    [sym_repeat] = STATE(856),
    [sym_for] = STATE(856),
    [sym_switch] = STATE(856),
    [sym_call] = STATE(856),
    [sym__assignment] = STATE(856),
    [sym_left_assignment] = STATE(856),
    [sym_left_assignment2] = STATE(856),
    [sym_equals_assignment] = STATE(856),
    [sym_super_assignment] = STATE(856),
    [sym_right_assignment] = STATE(856),
    [sym_brace_list] = STATE(856),
    [sym_paren_list] = STATE(856),
    [sym_subset] = STATE(856),
    [sym_subset2] = STATE(856),
    [sym_dollar] = STATE(856),
    [sym_slot] = STATE(856),
    [sym_namespace_get] = STATE(856),
    [sym_namespace_get_internal] = STATE(856),
    [sym_unary] = STATE(856),
    [sym_binary] = STATE(856),
    [sym_na] = STATE(856),
    [sym__expression] = STATE(856),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(856),
    [sym_string] = STATE(856),
    [anon_sym_SEMI] = ACTIONS(1158),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1160),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1160),
    [sym_next] = ACTIONS(1160),
    [sym_true] = ACTIONS(1160),
    [sym_false] = ACTIONS(1160),
    [sym_null] = ACTIONS(1160),
    [sym_inf] = ACTIONS(1160),
    [sym_nan] = ACTIONS(1160),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1158),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [273] = {
    [sym_function_definition] = STATE(855),
    [sym_if] = STATE(855),
    [sym_while] = STATE(855),
    [sym_repeat] = STATE(855),
    [sym_for] = STATE(855),
    [sym_switch] = STATE(855),
    [sym_call] = STATE(855),
    [sym__assignment] = STATE(855),
    [sym_left_assignment] = STATE(855),
    [sym_left_assignment2] = STATE(855),
    [sym_equals_assignment] = STATE(855),
    [sym_super_assignment] = STATE(855),
    [sym_right_assignment] = STATE(855),
    [sym_brace_list] = STATE(855),
    [sym_paren_list] = STATE(855),
    [sym_subset] = STATE(855),
    [sym_subset2] = STATE(855),
    [sym_dollar] = STATE(855),
    [sym_slot] = STATE(855),
    [sym_namespace_get] = STATE(855),
    [sym_namespace_get_internal] = STATE(855),
    [sym_unary] = STATE(855),
    [sym_binary] = STATE(855),
    [sym_na] = STATE(855),
    [sym__expression] = STATE(855),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(855),
    [sym_string] = STATE(855),
    [anon_sym_SEMI] = ACTIONS(1162),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1164),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1164),
    [sym_next] = ACTIONS(1164),
    [sym_true] = ACTIONS(1164),
    [sym_false] = ACTIONS(1164),
    [sym_null] = ACTIONS(1164),
    [sym_inf] = ACTIONS(1164),
    [sym_nan] = ACTIONS(1164),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1162),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [274] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(712),
    [anon_sym_SEMI] = ACTIONS(712),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(712),
    [anon_sym_RBRACE] = ACTIONS(712),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(712),
    [sym_integer] = ACTIONS(712),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(712),
    [anon_sym_SQUOTE] = ACTIONS(712),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [275] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(716),
    [anon_sym_function] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_RBRACE] = ACTIONS(716),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(716),
    [sym_next] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_inf] = ACTIONS(716),
    [sym_nan] = ACTIONS(716),
    [anon_sym_NA] = ACTIONS(716),
    [anon_sym_NA_character_] = ACTIONS(716),
    [anon_sym_NA_complex_] = ACTIONS(716),
    [anon_sym_NA_integer_] = ACTIONS(716),
    [anon_sym_NA_real_] = ACTIONS(716),
    [aux_sym_identifier_token1] = ACTIONS(716),
    [anon_sym_BQUOTE] = ACTIONS(716),
    [sym_integer] = ACTIONS(716),
    [sym_float] = ACTIONS(716),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(716),
    [anon_sym_SQUOTE] = ACTIONS(716),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [276] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(720),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_repeat] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_RBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(720),
    [sym_next] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_inf] = ACTIONS(720),
    [sym_nan] = ACTIONS(720),
    [anon_sym_NA] = ACTIONS(720),
    [anon_sym_NA_character_] = ACTIONS(720),
    [anon_sym_NA_complex_] = ACTIONS(720),
    [anon_sym_NA_integer_] = ACTIONS(720),
    [anon_sym_NA_real_] = ACTIONS(720),
    [aux_sym_identifier_token1] = ACTIONS(720),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(720),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [277] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(724),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_function] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_repeat] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_RBRACE] = ACTIONS(724),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(724),
    [sym_next] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_inf] = ACTIONS(724),
    [sym_nan] = ACTIONS(724),
    [anon_sym_NA] = ACTIONS(724),
    [anon_sym_NA_character_] = ACTIONS(724),
    [anon_sym_NA_complex_] = ACTIONS(724),
    [anon_sym_NA_integer_] = ACTIONS(724),
    [anon_sym_NA_real_] = ACTIONS(724),
    [aux_sym_identifier_token1] = ACTIONS(724),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_integer] = ACTIONS(724),
    [sym_float] = ACTIONS(724),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(724),
    [anon_sym_SQUOTE] = ACTIONS(724),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [278] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(728),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_repeat] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_EQ] = ACTIONS(728),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_RBRACE] = ACTIONS(728),
    [anon_sym_LT_DASH] = ACTIONS(728),
    [anon_sym_COLON_EQ] = ACTIONS(728),
    [anon_sym_LT_LT_DASH] = ACTIONS(728),
    [anon_sym_DASH_GT] = ACTIONS(728),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(728),
    [sym_next] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_inf] = ACTIONS(728),
    [sym_nan] = ACTIONS(728),
    [anon_sym_NA] = ACTIONS(728),
    [anon_sym_NA_character_] = ACTIONS(728),
    [anon_sym_NA_complex_] = ACTIONS(728),
    [anon_sym_NA_integer_] = ACTIONS(728),
    [anon_sym_NA_real_] = ACTIONS(728),
    [aux_sym_identifier_token1] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(728),
    [sym_integer] = ACTIONS(728),
    [sym_float] = ACTIONS(728),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [279] = {
    [sym_function_definition] = STATE(845),
    [sym_if] = STATE(845),
    [sym_while] = STATE(845),
    [sym_repeat] = STATE(845),
    [sym_for] = STATE(845),
    [sym_switch] = STATE(845),
    [sym_call] = STATE(845),
    [sym__assignment] = STATE(845),
    [sym_left_assignment] = STATE(845),
    [sym_left_assignment2] = STATE(845),
    [sym_equals_assignment] = STATE(845),
    [sym_super_assignment] = STATE(845),
    [sym_right_assignment] = STATE(845),
    [sym_brace_list] = STATE(845),
    [sym_paren_list] = STATE(845),
    [sym_subset] = STATE(845),
    [sym_subset2] = STATE(845),
    [sym_dollar] = STATE(845),
    [sym_slot] = STATE(845),
    [sym_namespace_get] = STATE(845),
    [sym_namespace_get_internal] = STATE(845),
    [sym_unary] = STATE(845),
    [sym_binary] = STATE(845),
    [sym_na] = STATE(845),
    [sym__expression] = STATE(845),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(845),
    [sym_string] = STATE(845),
    [anon_sym_SEMI] = ACTIONS(1176),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1178),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1178),
    [sym_next] = ACTIONS(1178),
    [sym_true] = ACTIONS(1178),
    [sym_false] = ACTIONS(1178),
    [sym_null] = ACTIONS(1178),
    [sym_inf] = ACTIONS(1178),
    [sym_nan] = ACTIONS(1178),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1176),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [280] = {
    [sym_function_definition] = STATE(840),
    [sym_if] = STATE(840),
    [sym_while] = STATE(840),
    [sym_repeat] = STATE(840),
    [sym_for] = STATE(840),
    [sym_switch] = STATE(840),
    [sym_call] = STATE(840),
    [sym__assignment] = STATE(840),
    [sym_left_assignment] = STATE(840),
    [sym_left_assignment2] = STATE(840),
    [sym_equals_assignment] = STATE(840),
    [sym_super_assignment] = STATE(840),
    [sym_right_assignment] = STATE(840),
    [sym_brace_list] = STATE(840),
    [sym_paren_list] = STATE(840),
    [sym_subset] = STATE(840),
    [sym_subset2] = STATE(840),
    [sym_dollar] = STATE(840),
    [sym_slot] = STATE(840),
    [sym_namespace_get] = STATE(840),
    [sym_namespace_get_internal] = STATE(840),
    [sym_unary] = STATE(840),
    [sym_binary] = STATE(840),
    [sym_na] = STATE(840),
    [sym__expression] = STATE(840),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(840),
    [sym_string] = STATE(840),
    [anon_sym_SEMI] = ACTIONS(1180),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1182),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1182),
    [sym_next] = ACTIONS(1182),
    [sym_true] = ACTIONS(1182),
    [sym_false] = ACTIONS(1182),
    [sym_null] = ACTIONS(1182),
    [sym_inf] = ACTIONS(1182),
    [sym_nan] = ACTIONS(1182),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1180),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [281] = {
    [sym_function_definition] = STATE(838),
    [sym_if] = STATE(838),
    [sym_while] = STATE(838),
    [sym_repeat] = STATE(838),
    [sym_for] = STATE(838),
    [sym_switch] = STATE(838),
    [sym_call] = STATE(838),
    [sym__assignment] = STATE(838),
    [sym_left_assignment] = STATE(838),
    [sym_left_assignment2] = STATE(838),
    [sym_equals_assignment] = STATE(838),
    [sym_super_assignment] = STATE(838),
    [sym_right_assignment] = STATE(838),
    [sym_brace_list] = STATE(838),
    [sym_paren_list] = STATE(838),
    [sym_subset] = STATE(838),
    [sym_subset2] = STATE(838),
    [sym_dollar] = STATE(838),
    [sym_slot] = STATE(838),
    [sym_namespace_get] = STATE(838),
    [sym_namespace_get_internal] = STATE(838),
    [sym_unary] = STATE(838),
    [sym_binary] = STATE(838),
    [sym_na] = STATE(838),
    [sym__expression] = STATE(838),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(838),
    [sym_string] = STATE(838),
    [anon_sym_SEMI] = ACTIONS(1184),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1186),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1186),
    [sym_next] = ACTIONS(1186),
    [sym_true] = ACTIONS(1186),
    [sym_false] = ACTIONS(1186),
    [sym_null] = ACTIONS(1186),
    [sym_inf] = ACTIONS(1186),
    [sym_nan] = ACTIONS(1186),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1184),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [282] = {
    [sym_function_definition] = STATE(836),
    [sym_if] = STATE(836),
    [sym_while] = STATE(836),
    [sym_repeat] = STATE(836),
    [sym_for] = STATE(836),
    [sym_switch] = STATE(836),
    [sym_call] = STATE(836),
    [sym__assignment] = STATE(836),
    [sym_left_assignment] = STATE(836),
    [sym_left_assignment2] = STATE(836),
    [sym_equals_assignment] = STATE(836),
    [sym_super_assignment] = STATE(836),
    [sym_right_assignment] = STATE(836),
    [sym_brace_list] = STATE(836),
    [sym_paren_list] = STATE(836),
    [sym_subset] = STATE(836),
    [sym_subset2] = STATE(836),
    [sym_dollar] = STATE(836),
    [sym_slot] = STATE(836),
    [sym_namespace_get] = STATE(836),
    [sym_namespace_get_internal] = STATE(836),
    [sym_unary] = STATE(836),
    [sym_binary] = STATE(836),
    [sym_na] = STATE(836),
    [sym__expression] = STATE(836),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(836),
    [sym_string] = STATE(836),
    [anon_sym_SEMI] = ACTIONS(1188),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1190),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1190),
    [sym_next] = ACTIONS(1190),
    [sym_true] = ACTIONS(1190),
    [sym_false] = ACTIONS(1190),
    [sym_null] = ACTIONS(1190),
    [sym_inf] = ACTIONS(1190),
    [sym_nan] = ACTIONS(1190),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1188),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [283] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [284] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [285] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [286] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [287] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [288] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [289] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [290] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [291] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(736),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(736),
    [anon_sym_COLON_EQ] = ACTIONS(736),
    [anon_sym_LT_LT_DASH] = ACTIONS(736),
    [anon_sym_DASH_GT] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_TILDE] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_LT_EQ] = ACTIONS(736),
    [anon_sym_GT_EQ] = ACTIONS(736),
    [anon_sym_EQ_EQ] = ACTIONS(736),
    [anon_sym_BANG_EQ] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP_AMP] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_GT] = ACTIONS(736),
    [anon_sym_COLON] = ACTIONS(736),
    [sym_break] = ACTIONS(736),
    [sym_next] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_inf] = ACTIONS(736),
    [sym_nan] = ACTIONS(736),
    [anon_sym_NA] = ACTIONS(736),
    [anon_sym_NA_character_] = ACTIONS(736),
    [anon_sym_NA_complex_] = ACTIONS(736),
    [anon_sym_NA_integer_] = ACTIONS(736),
    [anon_sym_NA_real_] = ACTIONS(736),
    [aux_sym_identifier_token1] = ACTIONS(736),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(736),
  },
  [292] = {
    [sym_function_definition] = STATE(834),
    [sym_if] = STATE(834),
    [sym_while] = STATE(834),
    [sym_repeat] = STATE(834),
    [sym_for] = STATE(834),
    [sym_switch] = STATE(834),
    [sym_call] = STATE(834),
    [sym__assignment] = STATE(834),
    [sym_left_assignment] = STATE(834),
    [sym_left_assignment2] = STATE(834),
    [sym_equals_assignment] = STATE(834),
    [sym_super_assignment] = STATE(834),
    [sym_right_assignment] = STATE(834),
    [sym_brace_list] = STATE(834),
    [sym_paren_list] = STATE(834),
    [sym_subset] = STATE(834),
    [sym_subset2] = STATE(834),
    [sym_dollar] = STATE(834),
    [sym_slot] = STATE(834),
    [sym_namespace_get] = STATE(834),
    [sym_namespace_get_internal] = STATE(834),
    [sym_unary] = STATE(834),
    [sym_binary] = STATE(834),
    [sym_na] = STATE(834),
    [sym__expression] = STATE(834),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(834),
    [sym_string] = STATE(834),
    [anon_sym_SEMI] = ACTIONS(1192),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1194),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1194),
    [sym_next] = ACTIONS(1194),
    [sym_true] = ACTIONS(1194),
    [sym_false] = ACTIONS(1194),
    [sym_null] = ACTIONS(1194),
    [sym_inf] = ACTIONS(1194),
    [sym_nan] = ACTIONS(1194),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1192),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [293] = {
    [sym_function_definition] = STATE(831),
    [sym_if] = STATE(831),
    [sym_while] = STATE(831),
    [sym_repeat] = STATE(831),
    [sym_for] = STATE(831),
    [sym_switch] = STATE(831),
    [sym_call] = STATE(831),
    [sym__assignment] = STATE(831),
    [sym_left_assignment] = STATE(831),
    [sym_left_assignment2] = STATE(831),
    [sym_equals_assignment] = STATE(831),
    [sym_super_assignment] = STATE(831),
    [sym_right_assignment] = STATE(831),
    [sym_brace_list] = STATE(831),
    [sym_paren_list] = STATE(831),
    [sym_subset] = STATE(831),
    [sym_subset2] = STATE(831),
    [sym_dollar] = STATE(831),
    [sym_slot] = STATE(831),
    [sym_namespace_get] = STATE(831),
    [sym_namespace_get_internal] = STATE(831),
    [sym_unary] = STATE(831),
    [sym_binary] = STATE(831),
    [sym_na] = STATE(831),
    [sym__expression] = STATE(831),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(831),
    [sym_string] = STATE(831),
    [anon_sym_SEMI] = ACTIONS(1196),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1198),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1198),
    [sym_next] = ACTIONS(1198),
    [sym_true] = ACTIONS(1198),
    [sym_false] = ACTIONS(1198),
    [sym_null] = ACTIONS(1198),
    [sym_inf] = ACTIONS(1198),
    [sym_nan] = ACTIONS(1198),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1196),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [294] = {
    [sym_function_definition] = STATE(299),
    [sym_if] = STATE(299),
    [sym_while] = STATE(299),
    [sym_repeat] = STATE(299),
    [sym_for] = STATE(299),
    [sym_switch] = STATE(299),
    [sym_call] = STATE(299),
    [sym__assignment] = STATE(299),
    [sym_left_assignment] = STATE(299),
    [sym_left_assignment2] = STATE(299),
    [sym_equals_assignment] = STATE(299),
    [sym_super_assignment] = STATE(299),
    [sym_right_assignment] = STATE(299),
    [sym_brace_list] = STATE(299),
    [sym_paren_list] = STATE(299),
    [sym_subset] = STATE(299),
    [sym_subset2] = STATE(299),
    [sym_dollar] = STATE(299),
    [sym_slot] = STATE(299),
    [sym_namespace_get] = STATE(299),
    [sym_namespace_get_internal] = STATE(299),
    [sym_unary] = STATE(299),
    [sym_binary] = STATE(299),
    [sym_na] = STATE(299),
    [sym__expression] = STATE(299),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(299),
    [sym_string] = STATE(299),
    [anon_sym_SEMI] = ACTIONS(1200),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1202),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1202),
    [sym_next] = ACTIONS(1202),
    [sym_true] = ACTIONS(1202),
    [sym_false] = ACTIONS(1202),
    [sym_null] = ACTIONS(1202),
    [sym_inf] = ACTIONS(1202),
    [sym_nan] = ACTIONS(1202),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1200),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [295] = {
    [sym_function_definition] = STATE(847),
    [sym_if] = STATE(847),
    [sym_while] = STATE(847),
    [sym_repeat] = STATE(847),
    [sym_for] = STATE(847),
    [sym_switch] = STATE(847),
    [sym_call] = STATE(847),
    [sym__assignment] = STATE(847),
    [sym_left_assignment] = STATE(847),
    [sym_left_assignment2] = STATE(847),
    [sym_equals_assignment] = STATE(847),
    [sym_super_assignment] = STATE(847),
    [sym_right_assignment] = STATE(847),
    [sym_brace_list] = STATE(847),
    [sym_paren_list] = STATE(847),
    [sym_subset] = STATE(847),
    [sym_subset2] = STATE(847),
    [sym_dollar] = STATE(847),
    [sym_slot] = STATE(847),
    [sym_namespace_get] = STATE(847),
    [sym_namespace_get_internal] = STATE(847),
    [sym_unary] = STATE(847),
    [sym_binary] = STATE(847),
    [sym_na] = STATE(847),
    [sym__expression] = STATE(847),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(847),
    [sym_string] = STATE(847),
    [anon_sym_SEMI] = ACTIONS(1204),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1206),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1206),
    [sym_next] = ACTIONS(1206),
    [sym_true] = ACTIONS(1206),
    [sym_false] = ACTIONS(1206),
    [sym_null] = ACTIONS(1206),
    [sym_inf] = ACTIONS(1206),
    [sym_nan] = ACTIONS(1206),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1204),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [296] = {
    [sym_function_definition] = STATE(825),
    [sym_if] = STATE(825),
    [sym_while] = STATE(825),
    [sym_repeat] = STATE(825),
    [sym_for] = STATE(825),
    [sym_switch] = STATE(825),
    [sym_call] = STATE(825),
    [sym__assignment] = STATE(825),
    [sym_left_assignment] = STATE(825),
    [sym_left_assignment2] = STATE(825),
    [sym_equals_assignment] = STATE(825),
    [sym_super_assignment] = STATE(825),
    [sym_right_assignment] = STATE(825),
    [sym_brace_list] = STATE(825),
    [sym_paren_list] = STATE(825),
    [sym_subset] = STATE(825),
    [sym_subset2] = STATE(825),
    [sym_dollar] = STATE(825),
    [sym_slot] = STATE(825),
    [sym_namespace_get] = STATE(825),
    [sym_namespace_get_internal] = STATE(825),
    [sym_unary] = STATE(825),
    [sym_binary] = STATE(825),
    [sym_na] = STATE(825),
    [sym__expression] = STATE(825),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(825),
    [sym_string] = STATE(825),
    [anon_sym_SEMI] = ACTIONS(1208),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1210),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1210),
    [sym_next] = ACTIONS(1210),
    [sym_true] = ACTIONS(1210),
    [sym_false] = ACTIONS(1210),
    [sym_null] = ACTIONS(1210),
    [sym_inf] = ACTIONS(1210),
    [sym_nan] = ACTIONS(1210),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1208),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [297] = {
    [sym_function_definition] = STATE(839),
    [sym_if] = STATE(839),
    [sym_while] = STATE(839),
    [sym_repeat] = STATE(839),
    [sym_for] = STATE(839),
    [sym_switch] = STATE(839),
    [sym_call] = STATE(839),
    [sym__assignment] = STATE(839),
    [sym_left_assignment] = STATE(839),
    [sym_left_assignment2] = STATE(839),
    [sym_equals_assignment] = STATE(839),
    [sym_super_assignment] = STATE(839),
    [sym_right_assignment] = STATE(839),
    [sym_brace_list] = STATE(839),
    [sym_paren_list] = STATE(839),
    [sym_subset] = STATE(839),
    [sym_subset2] = STATE(839),
    [sym_dollar] = STATE(839),
    [sym_slot] = STATE(839),
    [sym_namespace_get] = STATE(839),
    [sym_namespace_get_internal] = STATE(839),
    [sym_unary] = STATE(839),
    [sym_binary] = STATE(839),
    [sym_na] = STATE(839),
    [sym__expression] = STATE(839),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(839),
    [sym_string] = STATE(839),
    [anon_sym_SEMI] = ACTIONS(1212),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1214),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1214),
    [sym_next] = ACTIONS(1214),
    [sym_true] = ACTIONS(1214),
    [sym_false] = ACTIONS(1214),
    [sym_null] = ACTIONS(1214),
    [sym_inf] = ACTIONS(1214),
    [sym_nan] = ACTIONS(1214),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1212),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [298] = {
    [sym_function_definition] = STATE(285),
    [sym_if] = STATE(285),
    [sym_while] = STATE(285),
    [sym_repeat] = STATE(285),
    [sym_for] = STATE(285),
    [sym_switch] = STATE(285),
    [sym_call] = STATE(285),
    [sym__assignment] = STATE(285),
    [sym_left_assignment] = STATE(285),
    [sym_left_assignment2] = STATE(285),
    [sym_equals_assignment] = STATE(285),
    [sym_super_assignment] = STATE(285),
    [sym_right_assignment] = STATE(285),
    [sym_brace_list] = STATE(285),
    [sym_paren_list] = STATE(285),
    [sym_subset] = STATE(285),
    [sym_subset2] = STATE(285),
    [sym_dollar] = STATE(285),
    [sym_slot] = STATE(285),
    [sym_namespace_get] = STATE(285),
    [sym_namespace_get_internal] = STATE(285),
    [sym_unary] = STATE(285),
    [sym_binary] = STATE(285),
    [sym_na] = STATE(285),
    [sym__expression] = STATE(285),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(285),
    [sym_string] = STATE(285),
    [anon_sym_SEMI] = ACTIONS(1216),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1218),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1218),
    [sym_next] = ACTIONS(1218),
    [sym_true] = ACTIONS(1218),
    [sym_false] = ACTIONS(1218),
    [sym_null] = ACTIONS(1218),
    [sym_inf] = ACTIONS(1218),
    [sym_nan] = ACTIONS(1218),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1216),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [299] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(748),
    [anon_sym_RBRACE] = ACTIONS(748),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(748),
    [sym_integer] = ACTIONS(748),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(748),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [300] = {
    [sym_function_definition] = STATE(303),
    [sym_if] = STATE(303),
    [sym_while] = STATE(303),
    [sym_repeat] = STATE(303),
    [sym_for] = STATE(303),
    [sym_switch] = STATE(303),
    [sym_call] = STATE(303),
    [sym__assignment] = STATE(303),
    [sym_left_assignment] = STATE(303),
    [sym_left_assignment2] = STATE(303),
    [sym_equals_assignment] = STATE(303),
    [sym_super_assignment] = STATE(303),
    [sym_right_assignment] = STATE(303),
    [sym_brace_list] = STATE(303),
    [sym_paren_list] = STATE(303),
    [sym_subset] = STATE(303),
    [sym_subset2] = STATE(303),
    [sym_dollar] = STATE(303),
    [sym_slot] = STATE(303),
    [sym_namespace_get] = STATE(303),
    [sym_namespace_get_internal] = STATE(303),
    [sym_unary] = STATE(303),
    [sym_binary] = STATE(303),
    [sym_na] = STATE(303),
    [sym__expression] = STATE(303),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(303),
    [sym_string] = STATE(303),
    [anon_sym_SEMI] = ACTIONS(1220),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1222),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1222),
    [sym_next] = ACTIONS(1222),
    [sym_true] = ACTIONS(1222),
    [sym_false] = ACTIONS(1222),
    [sym_null] = ACTIONS(1222),
    [sym_inf] = ACTIONS(1222),
    [sym_nan] = ACTIONS(1222),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1220),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [301] = {
    [sym_function_definition] = STATE(304),
    [sym_if] = STATE(304),
    [sym_while] = STATE(304),
    [sym_repeat] = STATE(304),
    [sym_for] = STATE(304),
    [sym_switch] = STATE(304),
    [sym_call] = STATE(304),
    [sym__assignment] = STATE(304),
    [sym_left_assignment] = STATE(304),
    [sym_left_assignment2] = STATE(304),
    [sym_equals_assignment] = STATE(304),
    [sym_super_assignment] = STATE(304),
    [sym_right_assignment] = STATE(304),
    [sym_brace_list] = STATE(304),
    [sym_paren_list] = STATE(304),
    [sym_subset] = STATE(304),
    [sym_subset2] = STATE(304),
    [sym_dollar] = STATE(304),
    [sym_slot] = STATE(304),
    [sym_namespace_get] = STATE(304),
    [sym_namespace_get_internal] = STATE(304),
    [sym_unary] = STATE(304),
    [sym_binary] = STATE(304),
    [sym_na] = STATE(304),
    [sym__expression] = STATE(304),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(304),
    [sym_string] = STATE(304),
    [anon_sym_SEMI] = ACTIONS(1224),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1226),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1226),
    [sym_next] = ACTIONS(1226),
    [sym_true] = ACTIONS(1226),
    [sym_false] = ACTIONS(1226),
    [sym_null] = ACTIONS(1226),
    [sym_inf] = ACTIONS(1226),
    [sym_nan] = ACTIONS(1226),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1224),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [302] = {
    [sym_function_definition] = STATE(861),
    [sym_if] = STATE(861),
    [sym_while] = STATE(861),
    [sym_repeat] = STATE(861),
    [sym_for] = STATE(861),
    [sym_switch] = STATE(861),
    [sym_call] = STATE(861),
    [sym__assignment] = STATE(861),
    [sym_left_assignment] = STATE(861),
    [sym_left_assignment2] = STATE(861),
    [sym_equals_assignment] = STATE(861),
    [sym_super_assignment] = STATE(861),
    [sym_right_assignment] = STATE(861),
    [sym_brace_list] = STATE(861),
    [sym_paren_list] = STATE(861),
    [sym_subset] = STATE(861),
    [sym_subset2] = STATE(861),
    [sym_dollar] = STATE(861),
    [sym_slot] = STATE(861),
    [sym_namespace_get] = STATE(861),
    [sym_namespace_get_internal] = STATE(861),
    [sym_unary] = STATE(861),
    [sym_binary] = STATE(861),
    [sym_na] = STATE(861),
    [sym__expression] = STATE(861),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(861),
    [sym_string] = STATE(861),
    [anon_sym_SEMI] = ACTIONS(1228),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1230),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1230),
    [sym_next] = ACTIONS(1230),
    [sym_true] = ACTIONS(1230),
    [sym_false] = ACTIONS(1230),
    [sym_null] = ACTIONS(1230),
    [sym_inf] = ACTIONS(1230),
    [sym_nan] = ACTIONS(1230),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1228),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [303] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(752),
    [anon_sym_function] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_repeat] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(752),
    [anon_sym_RBRACE] = ACTIONS(752),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(752),
    [sym_next] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_inf] = ACTIONS(752),
    [sym_nan] = ACTIONS(752),
    [anon_sym_NA] = ACTIONS(752),
    [anon_sym_NA_character_] = ACTIONS(752),
    [anon_sym_NA_complex_] = ACTIONS(752),
    [anon_sym_NA_integer_] = ACTIONS(752),
    [anon_sym_NA_real_] = ACTIONS(752),
    [aux_sym_identifier_token1] = ACTIONS(752),
    [anon_sym_BQUOTE] = ACTIONS(752),
    [sym_integer] = ACTIONS(752),
    [sym_float] = ACTIONS(752),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(752),
    [anon_sym_SQUOTE] = ACTIONS(752),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [304] = {
    [sym_special] = STATE(264),
    [anon_sym_LF] = ACTIONS(756),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_function] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(1118),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_repeat] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_EQ] = ACTIONS(1166),
    [anon_sym_LBRACE] = ACTIONS(756),
    [anon_sym_RBRACE] = ACTIONS(756),
    [anon_sym_LT_DASH] = ACTIONS(1168),
    [anon_sym_COLON_EQ] = ACTIONS(1170),
    [anon_sym_LT_LT_DASH] = ACTIONS(1172),
    [anon_sym_DASH_GT] = ACTIONS(1174),
    [anon_sym_LBRACK] = ACTIONS(1120),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1122),
    [anon_sym_DOLLAR] = ACTIONS(1124),
    [anon_sym_AT] = ACTIONS(1126),
    [sym_dots] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(1128),
    [anon_sym_PLUS] = ACTIONS(1128),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_TILDE] = ACTIONS(1130),
    [anon_sym_STAR] = ACTIONS(1132),
    [anon_sym_SLASH] = ACTIONS(1132),
    [anon_sym_CARET] = ACTIONS(1134),
    [anon_sym_LT] = ACTIONS(1136),
    [anon_sym_GT] = ACTIONS(1136),
    [anon_sym_LT_EQ] = ACTIONS(1136),
    [anon_sym_GT_EQ] = ACTIONS(1136),
    [anon_sym_EQ_EQ] = ACTIONS(1136),
    [anon_sym_BANG_EQ] = ACTIONS(1136),
    [anon_sym_PIPE_PIPE] = ACTIONS(1138),
    [anon_sym_PIPE] = ACTIONS(1138),
    [anon_sym_AMP_AMP] = ACTIONS(1140),
    [anon_sym_AMP] = ACTIONS(1140),
    [anon_sym_PIPE_GT] = ACTIONS(1142),
    [anon_sym_COLON] = ACTIONS(1144),
    [sym_break] = ACTIONS(756),
    [sym_next] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_inf] = ACTIONS(756),
    [sym_nan] = ACTIONS(756),
    [anon_sym_NA] = ACTIONS(756),
    [anon_sym_NA_character_] = ACTIONS(756),
    [anon_sym_NA_complex_] = ACTIONS(756),
    [anon_sym_NA_integer_] = ACTIONS(756),
    [anon_sym_NA_real_] = ACTIONS(756),
    [aux_sym_identifier_token1] = ACTIONS(756),
    [anon_sym_BQUOTE] = ACTIONS(756),
    [sym_integer] = ACTIONS(756),
    [sym_float] = ACTIONS(756),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(756),
    [anon_sym_SQUOTE] = ACTIONS(756),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [305] = {
    [sym_function_definition] = STATE(585),
    [sym_if] = STATE(585),
    [sym_while] = STATE(585),
    [sym_repeat] = STATE(585),
    [sym_for] = STATE(585),
    [sym_switch] = STATE(585),
    [sym_call] = STATE(585),
    [sym__assignment] = STATE(585),
    [sym_left_assignment] = STATE(585),
    [sym_left_assignment2] = STATE(585),
    [sym_equals_assignment] = STATE(585),
    [sym_super_assignment] = STATE(585),
    [sym_right_assignment] = STATE(585),
    [sym_brace_list] = STATE(585),
    [sym_paren_list] = STATE(585),
    [sym_subset] = STATE(585),
    [sym_subset2] = STATE(585),
    [sym_dollar] = STATE(585),
    [sym_slot] = STATE(585),
    [sym_namespace_get] = STATE(585),
    [sym_namespace_get_internal] = STATE(585),
    [sym_unary] = STATE(585),
    [sym_binary] = STATE(585),
    [sym_na] = STATE(585),
    [sym__expression] = STATE(585),
    [sym_identifier] = STATE(139),
    [sym_complex] = STATE(585),
    [sym_string] = STATE(585),
    [anon_sym_SEMI] = ACTIONS(1232),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(63),
    [sym_dots] = ACTIONS(1234),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1234),
    [sym_next] = ACTIONS(1234),
    [sym_true] = ACTIONS(1234),
    [sym_false] = ACTIONS(1234),
    [sym_null] = ACTIONS(1234),
    [sym_inf] = ACTIONS(1234),
    [sym_nan] = ACTIONS(1234),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1232),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [306] = {
    [sym_function_definition] = STATE(587),
    [sym_if] = STATE(587),
    [sym_while] = STATE(587),
    [sym_repeat] = STATE(587),
    [sym_for] = STATE(587),
    [sym_switch] = STATE(587),
    [sym_call] = STATE(587),
    [sym__assignment] = STATE(587),
    [sym_left_assignment] = STATE(587),
    [sym_left_assignment2] = STATE(587),
    [sym_equals_assignment] = STATE(587),
    [sym_super_assignment] = STATE(587),
    [sym_right_assignment] = STATE(587),
    [sym_brace_list] = STATE(587),
    [sym_paren_list] = STATE(587),
    [sym_subset] = STATE(587),
    [sym_subset2] = STATE(587),
    [sym_dollar] = STATE(587),
    [sym_slot] = STATE(587),
    [sym_namespace_get] = STATE(587),
    [sym_namespace_get_internal] = STATE(587),
    [sym_unary] = STATE(587),
    [sym_binary] = STATE(587),
    [sym_na] = STATE(587),
    [sym__expression] = STATE(587),
    [sym_identifier] = STATE(139),
    [sym_complex] = STATE(587),
    [sym_string] = STATE(587),
    [anon_sym_SEMI] = ACTIONS(1236),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(63),
    [sym_dots] = ACTIONS(1238),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1238),
    [sym_next] = ACTIONS(1238),
    [sym_true] = ACTIONS(1238),
    [sym_false] = ACTIONS(1238),
    [sym_null] = ACTIONS(1238),
    [sym_inf] = ACTIONS(1238),
    [sym_nan] = ACTIONS(1238),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1236),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [307] = {
    [sym_function_definition] = STATE(588),
    [sym_if] = STATE(588),
    [sym_while] = STATE(588),
    [sym_repeat] = STATE(588),
    [sym_for] = STATE(588),
    [sym_switch] = STATE(588),
    [sym_call] = STATE(588),
    [sym__assignment] = STATE(588),
    [sym_left_assignment] = STATE(588),
    [sym_left_assignment2] = STATE(588),
    [sym_equals_assignment] = STATE(588),
    [sym_super_assignment] = STATE(588),
    [sym_right_assignment] = STATE(588),
    [sym_brace_list] = STATE(588),
    [sym_paren_list] = STATE(588),
    [sym_subset] = STATE(588),
    [sym_subset2] = STATE(588),
    [sym_dollar] = STATE(588),
    [sym_slot] = STATE(588),
    [sym_namespace_get] = STATE(588),
    [sym_namespace_get_internal] = STATE(588),
    [sym_unary] = STATE(588),
    [sym_binary] = STATE(588),
    [sym_na] = STATE(588),
    [sym__expression] = STATE(588),
    [sym_identifier] = STATE(139),
    [sym_complex] = STATE(588),
    [sym_string] = STATE(588),
    [anon_sym_SEMI] = ACTIONS(1240),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(63),
    [sym_dots] = ACTIONS(1242),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1242),
    [sym_next] = ACTIONS(1242),
    [sym_true] = ACTIONS(1242),
    [sym_false] = ACTIONS(1242),
    [sym_null] = ACTIONS(1242),
    [sym_inf] = ACTIONS(1242),
    [sym_nan] = ACTIONS(1242),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1240),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [308] = {
    [sym_function_definition] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(139),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [anon_sym_SEMI] = ACTIONS(1244),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(53),
    [anon_sym_repeat] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(63),
    [sym_dots] = ACTIONS(1246),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1246),
    [sym_next] = ACTIONS(1246),
    [sym_true] = ACTIONS(1246),
    [sym_false] = ACTIONS(1246),
    [sym_null] = ACTIONS(1246),
    [sym_inf] = ACTIONS(1246),
    [sym_nan] = ACTIONS(1246),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1244),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [309] = {
    [ts_builtin_sym_end] = ACTIONS(1038),
    [anon_sym_LF] = ACTIONS(1040),
    [anon_sym_SEMI] = ACTIONS(1040),
    [anon_sym_function] = ACTIONS(1040),
    [anon_sym_if] = ACTIONS(1040),
    [anon_sym_LPAREN] = ACTIONS(1040),
    [anon_sym_else] = ACTIONS(1040),
    [anon_sym_while] = ACTIONS(1040),
    [anon_sym_repeat] = ACTIONS(1040),
    [anon_sym_for] = ACTIONS(1040),
    [anon_sym_switch] = ACTIONS(1040),
    [anon_sym_EQ] = ACTIONS(1040),
    [anon_sym_LBRACE] = ACTIONS(1040),
    [anon_sym_LT_DASH] = ACTIONS(1040),
    [anon_sym_COLON_EQ] = ACTIONS(1040),
    [anon_sym_LT_LT_DASH] = ACTIONS(1040),
    [anon_sym_DASH_GT] = ACTIONS(1040),
    [anon_sym_LBRACK] = ACTIONS(1040),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1040),
    [anon_sym_DOLLAR] = ACTIONS(1040),
    [anon_sym_AT] = ACTIONS(1040),
    [sym_dots] = ACTIONS(1040),
    [anon_sym_DASH] = ACTIONS(1040),
    [anon_sym_PLUS] = ACTIONS(1040),
    [anon_sym_BANG] = ACTIONS(1040),
    [anon_sym_TILDE] = ACTIONS(1040),
    [anon_sym_STAR] = ACTIONS(1040),
    [anon_sym_SLASH] = ACTIONS(1040),
    [anon_sym_CARET] = ACTIONS(1040),
    [anon_sym_LT] = ACTIONS(1040),
    [anon_sym_GT] = ACTIONS(1040),
    [anon_sym_LT_EQ] = ACTIONS(1040),
    [anon_sym_GT_EQ] = ACTIONS(1040),
    [anon_sym_EQ_EQ] = ACTIONS(1040),
    [anon_sym_BANG_EQ] = ACTIONS(1040),
    [anon_sym_PIPE_PIPE] = ACTIONS(1040),
    [anon_sym_PIPE] = ACTIONS(1040),
    [anon_sym_AMP_AMP] = ACTIONS(1040),
    [anon_sym_AMP] = ACTIONS(1040),
    [anon_sym_PIPE_GT] = ACTIONS(1040),
    [anon_sym_COLON] = ACTIONS(1040),
    [sym_break] = ACTIONS(1040),
    [sym_next] = ACTIONS(1040),
    [sym_true] = ACTIONS(1040),
    [sym_false] = ACTIONS(1040),
    [sym_null] = ACTIONS(1040),
    [sym_inf] = ACTIONS(1040),
    [sym_nan] = ACTIONS(1040),
    [anon_sym_NA] = ACTIONS(1040),
    [anon_sym_NA_character_] = ACTIONS(1040),
    [anon_sym_NA_complex_] = ACTIONS(1040),
    [anon_sym_NA_integer_] = ACTIONS(1040),
    [anon_sym_NA_real_] = ACTIONS(1040),
    [aux_sym_identifier_token1] = ACTIONS(1040),
    [anon_sym_BQUOTE] = ACTIONS(1040),
    [sym_integer] = ACTIONS(1040),
    [sym_float] = ACTIONS(1040),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1040),
    [anon_sym_SQUOTE] = ACTIONS(1040),
    [anon_sym_PERCENT] = ACTIONS(1040),
  },
  [310] = {
    [sym_function_definition] = STATE(841),
    [sym_if] = STATE(841),
    [sym_while] = STATE(841),
    [sym_repeat] = STATE(841),
    [sym_for] = STATE(841),
    [sym_switch] = STATE(841),
    [sym_call] = STATE(841),
    [sym__assignment] = STATE(841),
    [sym_left_assignment] = STATE(841),
    [sym_left_assignment2] = STATE(841),
    [sym_equals_assignment] = STATE(841),
    [sym_super_assignment] = STATE(841),
    [sym_right_assignment] = STATE(841),
    [sym_brace_list] = STATE(841),
    [sym_paren_list] = STATE(841),
    [sym_subset] = STATE(841),
    [sym_subset2] = STATE(841),
    [sym_dollar] = STATE(841),
    [sym_slot] = STATE(841),
    [sym_namespace_get] = STATE(841),
    [sym_namespace_get_internal] = STATE(841),
    [sym_unary] = STATE(841),
    [sym_binary] = STATE(841),
    [sym_na] = STATE(841),
    [sym__expression] = STATE(841),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(841),
    [sym_string] = STATE(841),
    [anon_sym_SEMI] = ACTIONS(1248),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1250),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1250),
    [sym_next] = ACTIONS(1250),
    [sym_true] = ACTIONS(1250),
    [sym_false] = ACTIONS(1250),
    [sym_null] = ACTIONS(1250),
    [sym_inf] = ACTIONS(1250),
    [sym_nan] = ACTIONS(1250),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1248),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [311] = {
    [sym_function_definition] = STATE(843),
    [sym_if] = STATE(843),
    [sym_while] = STATE(843),
    [sym_repeat] = STATE(843),
    [sym_for] = STATE(843),
    [sym_switch] = STATE(843),
    [sym_call] = STATE(843),
    [sym__assignment] = STATE(843),
    [sym_left_assignment] = STATE(843),
    [sym_left_assignment2] = STATE(843),
    [sym_equals_assignment] = STATE(843),
    [sym_super_assignment] = STATE(843),
    [sym_right_assignment] = STATE(843),
    [sym_brace_list] = STATE(843),
    [sym_paren_list] = STATE(843),
    [sym_subset] = STATE(843),
    [sym_subset2] = STATE(843),
    [sym_dollar] = STATE(843),
    [sym_slot] = STATE(843),
    [sym_namespace_get] = STATE(843),
    [sym_namespace_get_internal] = STATE(843),
    [sym_unary] = STATE(843),
    [sym_binary] = STATE(843),
    [sym_na] = STATE(843),
    [sym__expression] = STATE(843),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(843),
    [sym_string] = STATE(843),
    [anon_sym_SEMI] = ACTIONS(1252),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1254),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1254),
    [sym_next] = ACTIONS(1254),
    [sym_true] = ACTIONS(1254),
    [sym_false] = ACTIONS(1254),
    [sym_null] = ACTIONS(1254),
    [sym_inf] = ACTIONS(1254),
    [sym_nan] = ACTIONS(1254),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1252),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [312] = {
    [sym_function_definition] = STATE(286),
    [sym_if] = STATE(286),
    [sym_while] = STATE(286),
    [sym_repeat] = STATE(286),
    [sym_for] = STATE(286),
    [sym_switch] = STATE(286),
    [sym_call] = STATE(286),
    [sym__assignment] = STATE(286),
    [sym_left_assignment] = STATE(286),
    [sym_left_assignment2] = STATE(286),
    [sym_equals_assignment] = STATE(286),
    [sym_super_assignment] = STATE(286),
    [sym_right_assignment] = STATE(286),
    [sym_brace_list] = STATE(286),
    [sym_paren_list] = STATE(286),
    [sym_subset] = STATE(286),
    [sym_subset2] = STATE(286),
    [sym_dollar] = STATE(286),
    [sym_slot] = STATE(286),
    [sym_namespace_get] = STATE(286),
    [sym_namespace_get_internal] = STATE(286),
    [sym_unary] = STATE(286),
    [sym_binary] = STATE(286),
    [sym_na] = STATE(286),
    [sym__expression] = STATE(286),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(286),
    [sym_string] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(1256),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1258),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1258),
    [sym_next] = ACTIONS(1258),
    [sym_true] = ACTIONS(1258),
    [sym_false] = ACTIONS(1258),
    [sym_null] = ACTIONS(1258),
    [sym_inf] = ACTIONS(1258),
    [sym_nan] = ACTIONS(1258),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1256),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [313] = {
    [sym_function_definition] = STATE(795),
    [sym_if] = STATE(795),
    [sym_while] = STATE(795),
    [sym_repeat] = STATE(795),
    [sym_for] = STATE(795),
    [sym_switch] = STATE(795),
    [sym_call] = STATE(795),
    [sym__assignment] = STATE(795),
    [sym_left_assignment] = STATE(795),
    [sym_left_assignment2] = STATE(795),
    [sym_equals_assignment] = STATE(795),
    [sym_super_assignment] = STATE(795),
    [sym_right_assignment] = STATE(795),
    [sym_brace_list] = STATE(795),
    [sym_paren_list] = STATE(795),
    [sym_subset] = STATE(795),
    [sym_subset2] = STATE(795),
    [sym_dollar] = STATE(795),
    [sym_slot] = STATE(795),
    [sym_namespace_get] = STATE(795),
    [sym_namespace_get_internal] = STATE(795),
    [sym_unary] = STATE(795),
    [sym_binary] = STATE(795),
    [sym_na] = STATE(795),
    [sym__expression] = STATE(795),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(795),
    [sym_string] = STATE(795),
    [anon_sym_SEMI] = ACTIONS(1260),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1262),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1262),
    [sym_next] = ACTIONS(1262),
    [sym_true] = ACTIONS(1262),
    [sym_false] = ACTIONS(1262),
    [sym_null] = ACTIONS(1262),
    [sym_inf] = ACTIONS(1262),
    [sym_nan] = ACTIONS(1262),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1260),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [314] = {
    [ts_builtin_sym_end] = ACTIONS(1028),
    [anon_sym_LF] = ACTIONS(1030),
    [anon_sym_SEMI] = ACTIONS(1030),
    [anon_sym_function] = ACTIONS(1030),
    [anon_sym_if] = ACTIONS(1030),
    [anon_sym_LPAREN] = ACTIONS(1030),
    [anon_sym_else] = ACTIONS(1030),
    [anon_sym_while] = ACTIONS(1030),
    [anon_sym_repeat] = ACTIONS(1030),
    [anon_sym_for] = ACTIONS(1030),
    [anon_sym_switch] = ACTIONS(1030),
    [anon_sym_EQ] = ACTIONS(1030),
    [anon_sym_LBRACE] = ACTIONS(1030),
    [anon_sym_LT_DASH] = ACTIONS(1030),
    [anon_sym_COLON_EQ] = ACTIONS(1030),
    [anon_sym_LT_LT_DASH] = ACTIONS(1030),
    [anon_sym_DASH_GT] = ACTIONS(1030),
    [anon_sym_LBRACK] = ACTIONS(1030),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1030),
    [anon_sym_DOLLAR] = ACTIONS(1030),
    [anon_sym_AT] = ACTIONS(1030),
    [sym_dots] = ACTIONS(1030),
    [anon_sym_DASH] = ACTIONS(1030),
    [anon_sym_PLUS] = ACTIONS(1030),
    [anon_sym_BANG] = ACTIONS(1030),
    [anon_sym_TILDE] = ACTIONS(1030),
    [anon_sym_STAR] = ACTIONS(1030),
    [anon_sym_SLASH] = ACTIONS(1030),
    [anon_sym_CARET] = ACTIONS(1030),
    [anon_sym_LT] = ACTIONS(1030),
    [anon_sym_GT] = ACTIONS(1030),
    [anon_sym_LT_EQ] = ACTIONS(1030),
    [anon_sym_GT_EQ] = ACTIONS(1030),
    [anon_sym_EQ_EQ] = ACTIONS(1030),
    [anon_sym_BANG_EQ] = ACTIONS(1030),
    [anon_sym_PIPE_PIPE] = ACTIONS(1030),
    [anon_sym_PIPE] = ACTIONS(1030),
    [anon_sym_AMP_AMP] = ACTIONS(1030),
    [anon_sym_AMP] = ACTIONS(1030),
    [anon_sym_PIPE_GT] = ACTIONS(1030),
    [anon_sym_COLON] = ACTIONS(1030),
    [sym_break] = ACTIONS(1030),
    [sym_next] = ACTIONS(1030),
    [sym_true] = ACTIONS(1030),
    [sym_false] = ACTIONS(1030),
    [sym_null] = ACTIONS(1030),
    [sym_inf] = ACTIONS(1030),
    [sym_nan] = ACTIONS(1030),
    [anon_sym_NA] = ACTIONS(1030),
    [anon_sym_NA_character_] = ACTIONS(1030),
    [anon_sym_NA_complex_] = ACTIONS(1030),
    [anon_sym_NA_integer_] = ACTIONS(1030),
    [anon_sym_NA_real_] = ACTIONS(1030),
    [aux_sym_identifier_token1] = ACTIONS(1030),
    [anon_sym_BQUOTE] = ACTIONS(1030),
    [sym_integer] = ACTIONS(1030),
    [sym_float] = ACTIONS(1030),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1030),
    [anon_sym_SQUOTE] = ACTIONS(1030),
    [anon_sym_PERCENT] = ACTIONS(1030),
  },
  [315] = {
    [sym_function_definition] = STATE(287),
    [sym_if] = STATE(287),
    [sym_while] = STATE(287),
    [sym_repeat] = STATE(287),
    [sym_for] = STATE(287),
    [sym_switch] = STATE(287),
    [sym_call] = STATE(287),
    [sym__assignment] = STATE(287),
    [sym_left_assignment] = STATE(287),
    [sym_left_assignment2] = STATE(287),
    [sym_equals_assignment] = STATE(287),
    [sym_super_assignment] = STATE(287),
    [sym_right_assignment] = STATE(287),
    [sym_brace_list] = STATE(287),
    [sym_paren_list] = STATE(287),
    [sym_subset] = STATE(287),
    [sym_subset2] = STATE(287),
    [sym_dollar] = STATE(287),
    [sym_slot] = STATE(287),
    [sym_namespace_get] = STATE(287),
    [sym_namespace_get_internal] = STATE(287),
    [sym_unary] = STATE(287),
    [sym_binary] = STATE(287),
    [sym_na] = STATE(287),
    [sym__expression] = STATE(287),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(287),
    [sym_string] = STATE(287),
    [anon_sym_SEMI] = ACTIONS(1264),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1266),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1266),
    [sym_next] = ACTIONS(1266),
    [sym_true] = ACTIONS(1266),
    [sym_false] = ACTIONS(1266),
    [sym_null] = ACTIONS(1266),
    [sym_inf] = ACTIONS(1266),
    [sym_nan] = ACTIONS(1266),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1264),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [316] = {
    [ts_builtin_sym_end] = ACTIONS(1024),
    [anon_sym_LF] = ACTIONS(1026),
    [anon_sym_SEMI] = ACTIONS(1026),
    [anon_sym_function] = ACTIONS(1026),
    [anon_sym_if] = ACTIONS(1026),
    [anon_sym_LPAREN] = ACTIONS(1026),
    [anon_sym_else] = ACTIONS(1026),
    [anon_sym_while] = ACTIONS(1026),
    [anon_sym_repeat] = ACTIONS(1026),
    [anon_sym_for] = ACTIONS(1026),
    [anon_sym_switch] = ACTIONS(1026),
    [anon_sym_EQ] = ACTIONS(1026),
    [anon_sym_LBRACE] = ACTIONS(1026),
    [anon_sym_LT_DASH] = ACTIONS(1026),
    [anon_sym_COLON_EQ] = ACTIONS(1026),
    [anon_sym_LT_LT_DASH] = ACTIONS(1026),
    [anon_sym_DASH_GT] = ACTIONS(1026),
    [anon_sym_LBRACK] = ACTIONS(1026),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1026),
    [anon_sym_DOLLAR] = ACTIONS(1026),
    [anon_sym_AT] = ACTIONS(1026),
    [sym_dots] = ACTIONS(1026),
    [anon_sym_DASH] = ACTIONS(1026),
    [anon_sym_PLUS] = ACTIONS(1026),
    [anon_sym_BANG] = ACTIONS(1026),
    [anon_sym_TILDE] = ACTIONS(1026),
    [anon_sym_STAR] = ACTIONS(1026),
    [anon_sym_SLASH] = ACTIONS(1026),
    [anon_sym_CARET] = ACTIONS(1026),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_GT] = ACTIONS(1026),
    [anon_sym_LT_EQ] = ACTIONS(1026),
    [anon_sym_GT_EQ] = ACTIONS(1026),
    [anon_sym_EQ_EQ] = ACTIONS(1026),
    [anon_sym_BANG_EQ] = ACTIONS(1026),
    [anon_sym_PIPE_PIPE] = ACTIONS(1026),
    [anon_sym_PIPE] = ACTIONS(1026),
    [anon_sym_AMP_AMP] = ACTIONS(1026),
    [anon_sym_AMP] = ACTIONS(1026),
    [anon_sym_PIPE_GT] = ACTIONS(1026),
    [anon_sym_COLON] = ACTIONS(1026),
    [sym_break] = ACTIONS(1026),
    [sym_next] = ACTIONS(1026),
    [sym_true] = ACTIONS(1026),
    [sym_false] = ACTIONS(1026),
    [sym_null] = ACTIONS(1026),
    [sym_inf] = ACTIONS(1026),
    [sym_nan] = ACTIONS(1026),
    [anon_sym_NA] = ACTIONS(1026),
    [anon_sym_NA_character_] = ACTIONS(1026),
    [anon_sym_NA_complex_] = ACTIONS(1026),
    [anon_sym_NA_integer_] = ACTIONS(1026),
    [anon_sym_NA_real_] = ACTIONS(1026),
    [aux_sym_identifier_token1] = ACTIONS(1026),
    [anon_sym_BQUOTE] = ACTIONS(1026),
    [sym_integer] = ACTIONS(1026),
    [sym_float] = ACTIONS(1026),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1026),
    [anon_sym_SQUOTE] = ACTIONS(1026),
    [anon_sym_PERCENT] = ACTIONS(1026),
  },
  [317] = {
    [sym_function_definition] = STATE(288),
    [sym_if] = STATE(288),
    [sym_while] = STATE(288),
    [sym_repeat] = STATE(288),
    [sym_for] = STATE(288),
    [sym_switch] = STATE(288),
    [sym_call] = STATE(288),
    [sym__assignment] = STATE(288),
    [sym_left_assignment] = STATE(288),
    [sym_left_assignment2] = STATE(288),
    [sym_equals_assignment] = STATE(288),
    [sym_super_assignment] = STATE(288),
    [sym_right_assignment] = STATE(288),
    [sym_brace_list] = STATE(288),
    [sym_paren_list] = STATE(288),
    [sym_subset] = STATE(288),
    [sym_subset2] = STATE(288),
    [sym_dollar] = STATE(288),
    [sym_slot] = STATE(288),
    [sym_namespace_get] = STATE(288),
    [sym_namespace_get_internal] = STATE(288),
    [sym_unary] = STATE(288),
    [sym_binary] = STATE(288),
    [sym_na] = STATE(288),
    [sym__expression] = STATE(288),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(288),
    [sym_string] = STATE(288),
    [anon_sym_SEMI] = ACTIONS(1268),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1270),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1270),
    [sym_next] = ACTIONS(1270),
    [sym_true] = ACTIONS(1270),
    [sym_false] = ACTIONS(1270),
    [sym_null] = ACTIONS(1270),
    [sym_inf] = ACTIONS(1270),
    [sym_nan] = ACTIONS(1270),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1268),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [318] = {
    [sym_function_definition] = STATE(846),
    [sym_if] = STATE(846),
    [sym_while] = STATE(846),
    [sym_repeat] = STATE(846),
    [sym_for] = STATE(846),
    [sym_switch] = STATE(846),
    [sym_call] = STATE(846),
    [sym__assignment] = STATE(846),
    [sym_left_assignment] = STATE(846),
    [sym_left_assignment2] = STATE(846),
    [sym_equals_assignment] = STATE(846),
    [sym_super_assignment] = STATE(846),
    [sym_right_assignment] = STATE(846),
    [sym_brace_list] = STATE(846),
    [sym_paren_list] = STATE(846),
    [sym_subset] = STATE(846),
    [sym_subset2] = STATE(846),
    [sym_dollar] = STATE(846),
    [sym_slot] = STATE(846),
    [sym_namespace_get] = STATE(846),
    [sym_namespace_get_internal] = STATE(846),
    [sym_unary] = STATE(846),
    [sym_binary] = STATE(846),
    [sym_na] = STATE(846),
    [sym__expression] = STATE(846),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(846),
    [sym_string] = STATE(846),
    [anon_sym_SEMI] = ACTIONS(1272),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1274),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1274),
    [sym_next] = ACTIONS(1274),
    [sym_true] = ACTIONS(1274),
    [sym_false] = ACTIONS(1274),
    [sym_null] = ACTIONS(1274),
    [sym_inf] = ACTIONS(1274),
    [sym_nan] = ACTIONS(1274),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1272),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [319] = {
    [sym_function_definition] = STATE(283),
    [sym_if] = STATE(283),
    [sym_while] = STATE(283),
    [sym_repeat] = STATE(283),
    [sym_for] = STATE(283),
    [sym_switch] = STATE(283),
    [sym_call] = STATE(283),
    [sym__assignment] = STATE(283),
    [sym_left_assignment] = STATE(283),
    [sym_left_assignment2] = STATE(283),
    [sym_equals_assignment] = STATE(283),
    [sym_super_assignment] = STATE(283),
    [sym_right_assignment] = STATE(283),
    [sym_brace_list] = STATE(283),
    [sym_paren_list] = STATE(283),
    [sym_subset] = STATE(283),
    [sym_subset2] = STATE(283),
    [sym_dollar] = STATE(283),
    [sym_slot] = STATE(283),
    [sym_namespace_get] = STATE(283),
    [sym_namespace_get_internal] = STATE(283),
    [sym_unary] = STATE(283),
    [sym_binary] = STATE(283),
    [sym_na] = STATE(283),
    [sym__expression] = STATE(283),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(283),
    [sym_string] = STATE(283),
    [anon_sym_SEMI] = ACTIONS(1276),
    [anon_sym_function] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_repeat] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(355),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(359),
    [sym_dots] = ACTIONS(1278),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(369),
    [sym_break] = ACTIONS(1278),
    [sym_next] = ACTIONS(1278),
    [sym_true] = ACTIONS(1278),
    [sym_false] = ACTIONS(1278),
    [sym_null] = ACTIONS(1278),
    [sym_inf] = ACTIONS(1278),
    [sym_nan] = ACTIONS(1278),
    [anon_sym_NA] = ACTIONS(371),
    [anon_sym_NA_character_] = ACTIONS(371),
    [anon_sym_NA_complex_] = ACTIONS(371),
    [anon_sym_NA_integer_] = ACTIONS(371),
    [anon_sym_NA_real_] = ACTIONS(371),
    [aux_sym_identifier_token1] = ACTIONS(373),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym_integer] = ACTIONS(1276),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(381),
  },
  [320] = {
    [sym_function_definition] = STATE(827),
    [sym_if] = STATE(827),
    [sym_while] = STATE(827),
    [sym_repeat] = STATE(827),
    [sym_for] = STATE(827),
    [sym_switch] = STATE(827),
    [sym_call] = STATE(827),
    [sym__assignment] = STATE(827),
    [sym_left_assignment] = STATE(827),
    [sym_left_assignment2] = STATE(827),
    [sym_equals_assignment] = STATE(827),
    [sym_super_assignment] = STATE(827),
    [sym_right_assignment] = STATE(827),
    [sym_brace_list] = STATE(827),
    [sym_paren_list] = STATE(827),
    [sym_subset] = STATE(827),
    [sym_subset2] = STATE(827),
    [sym_dollar] = STATE(827),
    [sym_slot] = STATE(827),
    [sym_namespace_get] = STATE(827),
    [sym_namespace_get_internal] = STATE(827),
    [sym_unary] = STATE(827),
    [sym_binary] = STATE(827),
    [sym_na] = STATE(827),
    [sym__expression] = STATE(827),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(827),
    [sym_string] = STATE(827),
    [anon_sym_SEMI] = ACTIONS(1280),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1282),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1282),
    [sym_next] = ACTIONS(1282),
    [sym_true] = ACTIONS(1282),
    [sym_false] = ACTIONS(1282),
    [sym_null] = ACTIONS(1282),
    [sym_inf] = ACTIONS(1282),
    [sym_nan] = ACTIONS(1282),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1280),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [321] = {
    [ts_builtin_sym_end] = ACTIONS(1016),
    [anon_sym_LF] = ACTIONS(1018),
    [anon_sym_SEMI] = ACTIONS(1018),
    [anon_sym_function] = ACTIONS(1018),
    [anon_sym_if] = ACTIONS(1018),
    [anon_sym_LPAREN] = ACTIONS(1018),
    [anon_sym_else] = ACTIONS(1018),
    [anon_sym_while] = ACTIONS(1018),
    [anon_sym_repeat] = ACTIONS(1018),
    [anon_sym_for] = ACTIONS(1018),
    [anon_sym_switch] = ACTIONS(1018),
    [anon_sym_EQ] = ACTIONS(1018),
    [anon_sym_LBRACE] = ACTIONS(1018),
    [anon_sym_LT_DASH] = ACTIONS(1018),
    [anon_sym_COLON_EQ] = ACTIONS(1018),
    [anon_sym_LT_LT_DASH] = ACTIONS(1018),
    [anon_sym_DASH_GT] = ACTIONS(1018),
    [anon_sym_LBRACK] = ACTIONS(1018),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1018),
    [anon_sym_DOLLAR] = ACTIONS(1018),
    [anon_sym_AT] = ACTIONS(1018),
    [sym_dots] = ACTIONS(1018),
    [anon_sym_DASH] = ACTIONS(1018),
    [anon_sym_PLUS] = ACTIONS(1018),
    [anon_sym_BANG] = ACTIONS(1018),
    [anon_sym_TILDE] = ACTIONS(1018),
    [anon_sym_STAR] = ACTIONS(1018),
    [anon_sym_SLASH] = ACTIONS(1018),
    [anon_sym_CARET] = ACTIONS(1018),
    [anon_sym_LT] = ACTIONS(1018),
    [anon_sym_GT] = ACTIONS(1018),
    [anon_sym_LT_EQ] = ACTIONS(1018),
    [anon_sym_GT_EQ] = ACTIONS(1018),
    [anon_sym_EQ_EQ] = ACTIONS(1018),
    [anon_sym_BANG_EQ] = ACTIONS(1018),
    [anon_sym_PIPE_PIPE] = ACTIONS(1018),
    [anon_sym_PIPE] = ACTIONS(1018),
    [anon_sym_AMP_AMP] = ACTIONS(1018),
    [anon_sym_AMP] = ACTIONS(1018),
    [anon_sym_PIPE_GT] = ACTIONS(1018),
    [anon_sym_COLON] = ACTIONS(1018),
    [sym_break] = ACTIONS(1018),
    [sym_next] = ACTIONS(1018),
    [sym_true] = ACTIONS(1018),
    [sym_false] = ACTIONS(1018),
    [sym_null] = ACTIONS(1018),
    [sym_inf] = ACTIONS(1018),
    [sym_nan] = ACTIONS(1018),
    [anon_sym_NA] = ACTIONS(1018),
    [anon_sym_NA_character_] = ACTIONS(1018),
    [anon_sym_NA_complex_] = ACTIONS(1018),
    [anon_sym_NA_integer_] = ACTIONS(1018),
    [anon_sym_NA_real_] = ACTIONS(1018),
    [aux_sym_identifier_token1] = ACTIONS(1018),
    [anon_sym_BQUOTE] = ACTIONS(1018),
    [sym_integer] = ACTIONS(1018),
    [sym_float] = ACTIONS(1018),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1018),
    [anon_sym_SQUOTE] = ACTIONS(1018),
    [anon_sym_PERCENT] = ACTIONS(1018),
  },
  [322] = {
    [ts_builtin_sym_end] = ACTIONS(1012),
    [anon_sym_LF] = ACTIONS(1014),
    [anon_sym_SEMI] = ACTIONS(1014),
    [anon_sym_function] = ACTIONS(1014),
    [anon_sym_if] = ACTIONS(1014),
    [anon_sym_LPAREN] = ACTIONS(1014),
    [anon_sym_else] = ACTIONS(1014),
    [anon_sym_while] = ACTIONS(1014),
    [anon_sym_repeat] = ACTIONS(1014),
    [anon_sym_for] = ACTIONS(1014),
    [anon_sym_switch] = ACTIONS(1014),
    [anon_sym_EQ] = ACTIONS(1014),
    [anon_sym_LBRACE] = ACTIONS(1014),
    [anon_sym_LT_DASH] = ACTIONS(1014),
    [anon_sym_COLON_EQ] = ACTIONS(1014),
    [anon_sym_LT_LT_DASH] = ACTIONS(1014),
    [anon_sym_DASH_GT] = ACTIONS(1014),
    [anon_sym_LBRACK] = ACTIONS(1014),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1014),
    [anon_sym_DOLLAR] = ACTIONS(1014),
    [anon_sym_AT] = ACTIONS(1014),
    [sym_dots] = ACTIONS(1014),
    [anon_sym_DASH] = ACTIONS(1014),
    [anon_sym_PLUS] = ACTIONS(1014),
    [anon_sym_BANG] = ACTIONS(1014),
    [anon_sym_TILDE] = ACTIONS(1014),
    [anon_sym_STAR] = ACTIONS(1014),
    [anon_sym_SLASH] = ACTIONS(1014),
    [anon_sym_CARET] = ACTIONS(1014),
    [anon_sym_LT] = ACTIONS(1014),
    [anon_sym_GT] = ACTIONS(1014),
    [anon_sym_LT_EQ] = ACTIONS(1014),
    [anon_sym_GT_EQ] = ACTIONS(1014),
    [anon_sym_EQ_EQ] = ACTIONS(1014),
    [anon_sym_BANG_EQ] = ACTIONS(1014),
    [anon_sym_PIPE_PIPE] = ACTIONS(1014),
    [anon_sym_PIPE] = ACTIONS(1014),
    [anon_sym_AMP_AMP] = ACTIONS(1014),
    [anon_sym_AMP] = ACTIONS(1014),
    [anon_sym_PIPE_GT] = ACTIONS(1014),
    [anon_sym_COLON] = ACTIONS(1014),
    [sym_break] = ACTIONS(1014),
    [sym_next] = ACTIONS(1014),
    [sym_true] = ACTIONS(1014),
    [sym_false] = ACTIONS(1014),
    [sym_null] = ACTIONS(1014),
    [sym_inf] = ACTIONS(1014),
    [sym_nan] = ACTIONS(1014),
    [anon_sym_NA] = ACTIONS(1014),
    [anon_sym_NA_character_] = ACTIONS(1014),
    [anon_sym_NA_complex_] = ACTIONS(1014),
    [anon_sym_NA_integer_] = ACTIONS(1014),
    [anon_sym_NA_real_] = ACTIONS(1014),
    [aux_sym_identifier_token1] = ACTIONS(1014),
    [anon_sym_BQUOTE] = ACTIONS(1014),
    [sym_integer] = ACTIONS(1014),
    [sym_float] = ACTIONS(1014),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1014),
    [anon_sym_SQUOTE] = ACTIONS(1014),
    [anon_sym_PERCENT] = ACTIONS(1014),
  },
  [323] = {
    [sym_function_definition] = STATE(800),
    [sym_if] = STATE(800),
    [sym_while] = STATE(800),
    [sym_repeat] = STATE(800),
    [sym_for] = STATE(800),
    [sym_switch] = STATE(800),
    [sym_call] = STATE(800),
    [sym__assignment] = STATE(800),
    [sym_left_assignment] = STATE(800),
    [sym_left_assignment2] = STATE(800),
    [sym_equals_assignment] = STATE(800),
    [sym_super_assignment] = STATE(800),
    [sym_right_assignment] = STATE(800),
    [sym_brace_list] = STATE(800),
    [sym_paren_list] = STATE(800),
    [sym_subset] = STATE(800),
    [sym_subset2] = STATE(800),
    [sym_dollar] = STATE(800),
    [sym_slot] = STATE(800),
    [sym_namespace_get] = STATE(800),
    [sym_namespace_get_internal] = STATE(800),
    [sym_unary] = STATE(800),
    [sym_binary] = STATE(800),
    [sym_na] = STATE(800),
    [sym__expression] = STATE(800),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(800),
    [sym_string] = STATE(800),
    [anon_sym_SEMI] = ACTIONS(1284),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1286),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1286),
    [sym_next] = ACTIONS(1286),
    [sym_true] = ACTIONS(1286),
    [sym_false] = ACTIONS(1286),
    [sym_null] = ACTIONS(1286),
    [sym_inf] = ACTIONS(1286),
    [sym_nan] = ACTIONS(1286),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1284),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [324] = {
    [sym_function_definition] = STATE(774),
    [sym_if] = STATE(774),
    [sym_while] = STATE(774),
    [sym_repeat] = STATE(774),
    [sym_for] = STATE(774),
    [sym_switch] = STATE(774),
    [sym_call] = STATE(774),
    [sym__assignment] = STATE(774),
    [sym_left_assignment] = STATE(774),
    [sym_left_assignment2] = STATE(774),
    [sym_equals_assignment] = STATE(774),
    [sym_super_assignment] = STATE(774),
    [sym_right_assignment] = STATE(774),
    [sym_brace_list] = STATE(774),
    [sym_paren_list] = STATE(774),
    [sym_subset] = STATE(774),
    [sym_subset2] = STATE(774),
    [sym_dollar] = STATE(774),
    [sym_slot] = STATE(774),
    [sym_namespace_get] = STATE(774),
    [sym_namespace_get_internal] = STATE(774),
    [sym_unary] = STATE(774),
    [sym_binary] = STATE(774),
    [sym_na] = STATE(774),
    [sym__expression] = STATE(774),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(774),
    [sym_string] = STATE(774),
    [anon_sym_SEMI] = ACTIONS(1288),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1290),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1290),
    [sym_next] = ACTIONS(1290),
    [sym_true] = ACTIONS(1290),
    [sym_false] = ACTIONS(1290),
    [sym_null] = ACTIONS(1290),
    [sym_inf] = ACTIONS(1290),
    [sym_nan] = ACTIONS(1290),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1288),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [325] = {
    [sym_function_definition] = STATE(803),
    [sym_if] = STATE(803),
    [sym_while] = STATE(803),
    [sym_repeat] = STATE(803),
    [sym_for] = STATE(803),
    [sym_switch] = STATE(803),
    [sym_call] = STATE(803),
    [sym__assignment] = STATE(803),
    [sym_left_assignment] = STATE(803),
    [sym_left_assignment2] = STATE(803),
    [sym_equals_assignment] = STATE(803),
    [sym_super_assignment] = STATE(803),
    [sym_right_assignment] = STATE(803),
    [sym_brace_list] = STATE(803),
    [sym_paren_list] = STATE(803),
    [sym_subset] = STATE(803),
    [sym_subset2] = STATE(803),
    [sym_dollar] = STATE(803),
    [sym_slot] = STATE(803),
    [sym_namespace_get] = STATE(803),
    [sym_namespace_get_internal] = STATE(803),
    [sym_unary] = STATE(803),
    [sym_binary] = STATE(803),
    [sym_na] = STATE(803),
    [sym__expression] = STATE(803),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(803),
    [sym_string] = STATE(803),
    [anon_sym_SEMI] = ACTIONS(1292),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1294),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1294),
    [sym_next] = ACTIONS(1294),
    [sym_true] = ACTIONS(1294),
    [sym_false] = ACTIONS(1294),
    [sym_null] = ACTIONS(1294),
    [sym_inf] = ACTIONS(1294),
    [sym_nan] = ACTIONS(1294),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1292),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [326] = {
    [sym_function_definition] = STATE(815),
    [sym_if] = STATE(815),
    [sym_while] = STATE(815),
    [sym_repeat] = STATE(815),
    [sym_for] = STATE(815),
    [sym_switch] = STATE(815),
    [sym_call] = STATE(815),
    [sym__assignment] = STATE(815),
    [sym_left_assignment] = STATE(815),
    [sym_left_assignment2] = STATE(815),
    [sym_equals_assignment] = STATE(815),
    [sym_super_assignment] = STATE(815),
    [sym_right_assignment] = STATE(815),
    [sym_brace_list] = STATE(815),
    [sym_paren_list] = STATE(815),
    [sym_subset] = STATE(815),
    [sym_subset2] = STATE(815),
    [sym_dollar] = STATE(815),
    [sym_slot] = STATE(815),
    [sym_namespace_get] = STATE(815),
    [sym_namespace_get_internal] = STATE(815),
    [sym_unary] = STATE(815),
    [sym_binary] = STATE(815),
    [sym_na] = STATE(815),
    [sym__expression] = STATE(815),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(815),
    [sym_string] = STATE(815),
    [anon_sym_SEMI] = ACTIONS(1296),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1298),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1298),
    [sym_next] = ACTIONS(1298),
    [sym_true] = ACTIONS(1298),
    [sym_false] = ACTIONS(1298),
    [sym_null] = ACTIONS(1298),
    [sym_inf] = ACTIONS(1298),
    [sym_nan] = ACTIONS(1298),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1296),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [327] = {
    [sym_function_definition] = STATE(816),
    [sym_if] = STATE(816),
    [sym_while] = STATE(816),
    [sym_repeat] = STATE(816),
    [sym_for] = STATE(816),
    [sym_switch] = STATE(816),
    [sym_call] = STATE(816),
    [sym__assignment] = STATE(816),
    [sym_left_assignment] = STATE(816),
    [sym_left_assignment2] = STATE(816),
    [sym_equals_assignment] = STATE(816),
    [sym_super_assignment] = STATE(816),
    [sym_right_assignment] = STATE(816),
    [sym_brace_list] = STATE(816),
    [sym_paren_list] = STATE(816),
    [sym_subset] = STATE(816),
    [sym_subset2] = STATE(816),
    [sym_dollar] = STATE(816),
    [sym_slot] = STATE(816),
    [sym_namespace_get] = STATE(816),
    [sym_namespace_get_internal] = STATE(816),
    [sym_unary] = STATE(816),
    [sym_binary] = STATE(816),
    [sym_na] = STATE(816),
    [sym__expression] = STATE(816),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(816),
    [sym_string] = STATE(816),
    [anon_sym_SEMI] = ACTIONS(1300),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1302),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1302),
    [sym_next] = ACTIONS(1302),
    [sym_true] = ACTIONS(1302),
    [sym_false] = ACTIONS(1302),
    [sym_null] = ACTIONS(1302),
    [sym_inf] = ACTIONS(1302),
    [sym_nan] = ACTIONS(1302),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1300),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [328] = {
    [sym_function_definition] = STATE(835),
    [sym_if] = STATE(835),
    [sym_while] = STATE(835),
    [sym_repeat] = STATE(835),
    [sym_for] = STATE(835),
    [sym_switch] = STATE(835),
    [sym_call] = STATE(835),
    [sym__assignment] = STATE(835),
    [sym_left_assignment] = STATE(835),
    [sym_left_assignment2] = STATE(835),
    [sym_equals_assignment] = STATE(835),
    [sym_super_assignment] = STATE(835),
    [sym_right_assignment] = STATE(835),
    [sym_brace_list] = STATE(835),
    [sym_paren_list] = STATE(835),
    [sym_subset] = STATE(835),
    [sym_subset2] = STATE(835),
    [sym_dollar] = STATE(835),
    [sym_slot] = STATE(835),
    [sym_namespace_get] = STATE(835),
    [sym_namespace_get_internal] = STATE(835),
    [sym_unary] = STATE(835),
    [sym_binary] = STATE(835),
    [sym_na] = STATE(835),
    [sym__expression] = STATE(835),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(835),
    [sym_string] = STATE(835),
    [anon_sym_SEMI] = ACTIONS(1304),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1306),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1306),
    [sym_next] = ACTIONS(1306),
    [sym_true] = ACTIONS(1306),
    [sym_false] = ACTIONS(1306),
    [sym_null] = ACTIONS(1306),
    [sym_inf] = ACTIONS(1306),
    [sym_nan] = ACTIONS(1306),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1304),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [329] = {
    [sym_function_definition] = STATE(853),
    [sym_if] = STATE(853),
    [sym_while] = STATE(853),
    [sym_repeat] = STATE(853),
    [sym_for] = STATE(853),
    [sym_switch] = STATE(853),
    [sym_call] = STATE(853),
    [sym__assignment] = STATE(853),
    [sym_left_assignment] = STATE(853),
    [sym_left_assignment2] = STATE(853),
    [sym_equals_assignment] = STATE(853),
    [sym_super_assignment] = STATE(853),
    [sym_right_assignment] = STATE(853),
    [sym_brace_list] = STATE(853),
    [sym_paren_list] = STATE(853),
    [sym_subset] = STATE(853),
    [sym_subset2] = STATE(853),
    [sym_dollar] = STATE(853),
    [sym_slot] = STATE(853),
    [sym_namespace_get] = STATE(853),
    [sym_namespace_get_internal] = STATE(853),
    [sym_unary] = STATE(853),
    [sym_binary] = STATE(853),
    [sym_na] = STATE(853),
    [sym__expression] = STATE(853),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(853),
    [sym_string] = STATE(853),
    [anon_sym_SEMI] = ACTIONS(1308),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1310),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1310),
    [sym_next] = ACTIONS(1310),
    [sym_true] = ACTIONS(1310),
    [sym_false] = ACTIONS(1310),
    [sym_null] = ACTIONS(1310),
    [sym_inf] = ACTIONS(1310),
    [sym_nan] = ACTIONS(1310),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1308),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [330] = {
    [sym_function_definition] = STATE(818),
    [sym_if] = STATE(818),
    [sym_while] = STATE(818),
    [sym_repeat] = STATE(818),
    [sym_for] = STATE(818),
    [sym_switch] = STATE(818),
    [sym_call] = STATE(818),
    [sym__assignment] = STATE(818),
    [sym_left_assignment] = STATE(818),
    [sym_left_assignment2] = STATE(818),
    [sym_equals_assignment] = STATE(818),
    [sym_super_assignment] = STATE(818),
    [sym_right_assignment] = STATE(818),
    [sym_brace_list] = STATE(818),
    [sym_paren_list] = STATE(818),
    [sym_subset] = STATE(818),
    [sym_subset2] = STATE(818),
    [sym_dollar] = STATE(818),
    [sym_slot] = STATE(818),
    [sym_namespace_get] = STATE(818),
    [sym_namespace_get_internal] = STATE(818),
    [sym_unary] = STATE(818),
    [sym_binary] = STATE(818),
    [sym_na] = STATE(818),
    [sym__expression] = STATE(818),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(818),
    [sym_string] = STATE(818),
    [anon_sym_SEMI] = ACTIONS(1312),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1314),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1314),
    [sym_next] = ACTIONS(1314),
    [sym_true] = ACTIONS(1314),
    [sym_false] = ACTIONS(1314),
    [sym_null] = ACTIONS(1314),
    [sym_inf] = ACTIONS(1314),
    [sym_nan] = ACTIONS(1314),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1312),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [331] = {
    [sym_function_definition] = STATE(820),
    [sym_if] = STATE(820),
    [sym_while] = STATE(820),
    [sym_repeat] = STATE(820),
    [sym_for] = STATE(820),
    [sym_switch] = STATE(820),
    [sym_call] = STATE(820),
    [sym__assignment] = STATE(820),
    [sym_left_assignment] = STATE(820),
    [sym_left_assignment2] = STATE(820),
    [sym_equals_assignment] = STATE(820),
    [sym_super_assignment] = STATE(820),
    [sym_right_assignment] = STATE(820),
    [sym_brace_list] = STATE(820),
    [sym_paren_list] = STATE(820),
    [sym_subset] = STATE(820),
    [sym_subset2] = STATE(820),
    [sym_dollar] = STATE(820),
    [sym_slot] = STATE(820),
    [sym_namespace_get] = STATE(820),
    [sym_namespace_get_internal] = STATE(820),
    [sym_unary] = STATE(820),
    [sym_binary] = STATE(820),
    [sym_na] = STATE(820),
    [sym__expression] = STATE(820),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(820),
    [sym_string] = STATE(820),
    [anon_sym_SEMI] = ACTIONS(1316),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1318),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1318),
    [sym_next] = ACTIONS(1318),
    [sym_true] = ACTIONS(1318),
    [sym_false] = ACTIONS(1318),
    [sym_null] = ACTIONS(1318),
    [sym_inf] = ACTIONS(1318),
    [sym_nan] = ACTIONS(1318),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1316),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [332] = {
    [sym_function_definition] = STATE(822),
    [sym_if] = STATE(822),
    [sym_while] = STATE(822),
    [sym_repeat] = STATE(822),
    [sym_for] = STATE(822),
    [sym_switch] = STATE(822),
    [sym_call] = STATE(822),
    [sym__assignment] = STATE(822),
    [sym_left_assignment] = STATE(822),
    [sym_left_assignment2] = STATE(822),
    [sym_equals_assignment] = STATE(822),
    [sym_super_assignment] = STATE(822),
    [sym_right_assignment] = STATE(822),
    [sym_brace_list] = STATE(822),
    [sym_paren_list] = STATE(822),
    [sym_subset] = STATE(822),
    [sym_subset2] = STATE(822),
    [sym_dollar] = STATE(822),
    [sym_slot] = STATE(822),
    [sym_namespace_get] = STATE(822),
    [sym_namespace_get_internal] = STATE(822),
    [sym_unary] = STATE(822),
    [sym_binary] = STATE(822),
    [sym_na] = STATE(822),
    [sym__expression] = STATE(822),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(822),
    [sym_string] = STATE(822),
    [anon_sym_SEMI] = ACTIONS(1320),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1322),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1322),
    [sym_next] = ACTIONS(1322),
    [sym_true] = ACTIONS(1322),
    [sym_false] = ACTIONS(1322),
    [sym_null] = ACTIONS(1322),
    [sym_inf] = ACTIONS(1322),
    [sym_nan] = ACTIONS(1322),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1320),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [333] = {
    [sym_function_definition] = STATE(819),
    [sym_if] = STATE(819),
    [sym_while] = STATE(819),
    [sym_repeat] = STATE(819),
    [sym_for] = STATE(819),
    [sym_switch] = STATE(819),
    [sym_call] = STATE(819),
    [sym__assignment] = STATE(819),
    [sym_left_assignment] = STATE(819),
    [sym_left_assignment2] = STATE(819),
    [sym_equals_assignment] = STATE(819),
    [sym_super_assignment] = STATE(819),
    [sym_right_assignment] = STATE(819),
    [sym_brace_list] = STATE(819),
    [sym_paren_list] = STATE(819),
    [sym_subset] = STATE(819),
    [sym_subset2] = STATE(819),
    [sym_dollar] = STATE(819),
    [sym_slot] = STATE(819),
    [sym_namespace_get] = STATE(819),
    [sym_namespace_get_internal] = STATE(819),
    [sym_unary] = STATE(819),
    [sym_binary] = STATE(819),
    [sym_na] = STATE(819),
    [sym__expression] = STATE(819),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(819),
    [sym_string] = STATE(819),
    [anon_sym_SEMI] = ACTIONS(1324),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1326),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1326),
    [sym_next] = ACTIONS(1326),
    [sym_true] = ACTIONS(1326),
    [sym_false] = ACTIONS(1326),
    [sym_null] = ACTIONS(1326),
    [sym_inf] = ACTIONS(1326),
    [sym_nan] = ACTIONS(1326),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1324),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [334] = {
    [sym_function_definition] = STATE(799),
    [sym_if] = STATE(799),
    [sym_while] = STATE(799),
    [sym_repeat] = STATE(799),
    [sym_for] = STATE(799),
    [sym_switch] = STATE(799),
    [sym_call] = STATE(799),
    [sym__assignment] = STATE(799),
    [sym_left_assignment] = STATE(799),
    [sym_left_assignment2] = STATE(799),
    [sym_equals_assignment] = STATE(799),
    [sym_super_assignment] = STATE(799),
    [sym_right_assignment] = STATE(799),
    [sym_brace_list] = STATE(799),
    [sym_paren_list] = STATE(799),
    [sym_subset] = STATE(799),
    [sym_subset2] = STATE(799),
    [sym_dollar] = STATE(799),
    [sym_slot] = STATE(799),
    [sym_namespace_get] = STATE(799),
    [sym_namespace_get_internal] = STATE(799),
    [sym_unary] = STATE(799),
    [sym_binary] = STATE(799),
    [sym_na] = STATE(799),
    [sym__expression] = STATE(799),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(799),
    [sym_string] = STATE(799),
    [anon_sym_SEMI] = ACTIONS(1328),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1330),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1330),
    [sym_next] = ACTIONS(1330),
    [sym_true] = ACTIONS(1330),
    [sym_false] = ACTIONS(1330),
    [sym_null] = ACTIONS(1330),
    [sym_inf] = ACTIONS(1330),
    [sym_nan] = ACTIONS(1330),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1328),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [335] = {
    [sym_function_definition] = STATE(798),
    [sym_if] = STATE(798),
    [sym_while] = STATE(798),
    [sym_repeat] = STATE(798),
    [sym_for] = STATE(798),
    [sym_switch] = STATE(798),
    [sym_call] = STATE(798),
    [sym__assignment] = STATE(798),
    [sym_left_assignment] = STATE(798),
    [sym_left_assignment2] = STATE(798),
    [sym_equals_assignment] = STATE(798),
    [sym_super_assignment] = STATE(798),
    [sym_right_assignment] = STATE(798),
    [sym_brace_list] = STATE(798),
    [sym_paren_list] = STATE(798),
    [sym_subset] = STATE(798),
    [sym_subset2] = STATE(798),
    [sym_dollar] = STATE(798),
    [sym_slot] = STATE(798),
    [sym_namespace_get] = STATE(798),
    [sym_namespace_get_internal] = STATE(798),
    [sym_unary] = STATE(798),
    [sym_binary] = STATE(798),
    [sym_na] = STATE(798),
    [sym__expression] = STATE(798),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(798),
    [sym_string] = STATE(798),
    [anon_sym_SEMI] = ACTIONS(1332),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1334),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1334),
    [sym_next] = ACTIONS(1334),
    [sym_true] = ACTIONS(1334),
    [sym_false] = ACTIONS(1334),
    [sym_null] = ACTIONS(1334),
    [sym_inf] = ACTIONS(1334),
    [sym_nan] = ACTIONS(1334),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1332),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [336] = {
    [sym_function_definition] = STATE(797),
    [sym_if] = STATE(797),
    [sym_while] = STATE(797),
    [sym_repeat] = STATE(797),
    [sym_for] = STATE(797),
    [sym_switch] = STATE(797),
    [sym_call] = STATE(797),
    [sym__assignment] = STATE(797),
    [sym_left_assignment] = STATE(797),
    [sym_left_assignment2] = STATE(797),
    [sym_equals_assignment] = STATE(797),
    [sym_super_assignment] = STATE(797),
    [sym_right_assignment] = STATE(797),
    [sym_brace_list] = STATE(797),
    [sym_paren_list] = STATE(797),
    [sym_subset] = STATE(797),
    [sym_subset2] = STATE(797),
    [sym_dollar] = STATE(797),
    [sym_slot] = STATE(797),
    [sym_namespace_get] = STATE(797),
    [sym_namespace_get_internal] = STATE(797),
    [sym_unary] = STATE(797),
    [sym_binary] = STATE(797),
    [sym_na] = STATE(797),
    [sym__expression] = STATE(797),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(797),
    [sym_string] = STATE(797),
    [anon_sym_SEMI] = ACTIONS(1336),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1338),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1338),
    [sym_next] = ACTIONS(1338),
    [sym_true] = ACTIONS(1338),
    [sym_false] = ACTIONS(1338),
    [sym_null] = ACTIONS(1338),
    [sym_inf] = ACTIONS(1338),
    [sym_nan] = ACTIONS(1338),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1336),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [337] = {
    [sym_function_definition] = STATE(794),
    [sym_if] = STATE(794),
    [sym_while] = STATE(794),
    [sym_repeat] = STATE(794),
    [sym_for] = STATE(794),
    [sym_switch] = STATE(794),
    [sym_call] = STATE(794),
    [sym__assignment] = STATE(794),
    [sym_left_assignment] = STATE(794),
    [sym_left_assignment2] = STATE(794),
    [sym_equals_assignment] = STATE(794),
    [sym_super_assignment] = STATE(794),
    [sym_right_assignment] = STATE(794),
    [sym_brace_list] = STATE(794),
    [sym_paren_list] = STATE(794),
    [sym_subset] = STATE(794),
    [sym_subset2] = STATE(794),
    [sym_dollar] = STATE(794),
    [sym_slot] = STATE(794),
    [sym_namespace_get] = STATE(794),
    [sym_namespace_get_internal] = STATE(794),
    [sym_unary] = STATE(794),
    [sym_binary] = STATE(794),
    [sym_na] = STATE(794),
    [sym__expression] = STATE(794),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(794),
    [sym_string] = STATE(794),
    [anon_sym_SEMI] = ACTIONS(1340),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1342),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1342),
    [sym_next] = ACTIONS(1342),
    [sym_true] = ACTIONS(1342),
    [sym_false] = ACTIONS(1342),
    [sym_null] = ACTIONS(1342),
    [sym_inf] = ACTIONS(1342),
    [sym_nan] = ACTIONS(1342),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1340),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [338] = {
    [sym_function_definition] = STATE(787),
    [sym_if] = STATE(787),
    [sym_while] = STATE(787),
    [sym_repeat] = STATE(787),
    [sym_for] = STATE(787),
    [sym_switch] = STATE(787),
    [sym_call] = STATE(787),
    [sym__assignment] = STATE(787),
    [sym_left_assignment] = STATE(787),
    [sym_left_assignment2] = STATE(787),
    [sym_equals_assignment] = STATE(787),
    [sym_super_assignment] = STATE(787),
    [sym_right_assignment] = STATE(787),
    [sym_brace_list] = STATE(787),
    [sym_paren_list] = STATE(787),
    [sym_subset] = STATE(787),
    [sym_subset2] = STATE(787),
    [sym_dollar] = STATE(787),
    [sym_slot] = STATE(787),
    [sym_namespace_get] = STATE(787),
    [sym_namespace_get_internal] = STATE(787),
    [sym_unary] = STATE(787),
    [sym_binary] = STATE(787),
    [sym_na] = STATE(787),
    [sym__expression] = STATE(787),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(787),
    [sym_string] = STATE(787),
    [anon_sym_SEMI] = ACTIONS(1344),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1346),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1346),
    [sym_next] = ACTIONS(1346),
    [sym_true] = ACTIONS(1346),
    [sym_false] = ACTIONS(1346),
    [sym_null] = ACTIONS(1346),
    [sym_inf] = ACTIONS(1346),
    [sym_nan] = ACTIONS(1346),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1344),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [339] = {
    [sym_function_definition] = STATE(859),
    [sym_if] = STATE(859),
    [sym_while] = STATE(859),
    [sym_repeat] = STATE(859),
    [sym_for] = STATE(859),
    [sym_switch] = STATE(859),
    [sym_call] = STATE(859),
    [sym__assignment] = STATE(859),
    [sym_left_assignment] = STATE(859),
    [sym_left_assignment2] = STATE(859),
    [sym_equals_assignment] = STATE(859),
    [sym_super_assignment] = STATE(859),
    [sym_right_assignment] = STATE(859),
    [sym_brace_list] = STATE(859),
    [sym_paren_list] = STATE(859),
    [sym_subset] = STATE(859),
    [sym_subset2] = STATE(859),
    [sym_dollar] = STATE(859),
    [sym_slot] = STATE(859),
    [sym_namespace_get] = STATE(859),
    [sym_namespace_get_internal] = STATE(859),
    [sym_unary] = STATE(859),
    [sym_binary] = STATE(859),
    [sym_na] = STATE(859),
    [sym__expression] = STATE(859),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(859),
    [sym_string] = STATE(859),
    [anon_sym_SEMI] = ACTIONS(1348),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1350),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1350),
    [sym_next] = ACTIONS(1350),
    [sym_true] = ACTIONS(1350),
    [sym_false] = ACTIONS(1350),
    [sym_null] = ACTIONS(1350),
    [sym_inf] = ACTIONS(1350),
    [sym_nan] = ACTIONS(1350),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1348),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [340] = {
    [sym_function_definition] = STATE(391),
    [sym_if] = STATE(391),
    [sym_while] = STATE(391),
    [sym_repeat] = STATE(391),
    [sym_for] = STATE(391),
    [sym_switch] = STATE(391),
    [sym_call] = STATE(391),
    [sym__assignment] = STATE(391),
    [sym_left_assignment] = STATE(391),
    [sym_left_assignment2] = STATE(391),
    [sym_equals_assignment] = STATE(391),
    [sym_super_assignment] = STATE(391),
    [sym_right_assignment] = STATE(391),
    [sym_brace_list] = STATE(391),
    [sym_paren_list] = STATE(391),
    [sym_subset] = STATE(391),
    [sym_subset2] = STATE(391),
    [sym_dollar] = STATE(391),
    [sym_slot] = STATE(391),
    [sym_namespace_get] = STATE(391),
    [sym_namespace_get_internal] = STATE(391),
    [sym_unary] = STATE(391),
    [sym_binary] = STATE(391),
    [sym_na] = STATE(391),
    [sym__expression] = STATE(391),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(391),
    [sym_string] = STATE(391),
    [anon_sym_SEMI] = ACTIONS(1352),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1354),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1354),
    [sym_next] = ACTIONS(1354),
    [sym_true] = ACTIONS(1354),
    [sym_false] = ACTIONS(1354),
    [sym_null] = ACTIONS(1354),
    [sym_inf] = ACTIONS(1354),
    [sym_nan] = ACTIONS(1354),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1352),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [341] = {
    [sym_function_definition] = STATE(851),
    [sym_if] = STATE(851),
    [sym_while] = STATE(851),
    [sym_repeat] = STATE(851),
    [sym_for] = STATE(851),
    [sym_switch] = STATE(851),
    [sym_call] = STATE(851),
    [sym__assignment] = STATE(851),
    [sym_left_assignment] = STATE(851),
    [sym_left_assignment2] = STATE(851),
    [sym_equals_assignment] = STATE(851),
    [sym_super_assignment] = STATE(851),
    [sym_right_assignment] = STATE(851),
    [sym_brace_list] = STATE(851),
    [sym_paren_list] = STATE(851),
    [sym_subset] = STATE(851),
    [sym_subset2] = STATE(851),
    [sym_dollar] = STATE(851),
    [sym_slot] = STATE(851),
    [sym_namespace_get] = STATE(851),
    [sym_namespace_get_internal] = STATE(851),
    [sym_unary] = STATE(851),
    [sym_binary] = STATE(851),
    [sym_na] = STATE(851),
    [sym__expression] = STATE(851),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(851),
    [sym_string] = STATE(851),
    [anon_sym_SEMI] = ACTIONS(1356),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1358),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1358),
    [sym_next] = ACTIONS(1358),
    [sym_true] = ACTIONS(1358),
    [sym_false] = ACTIONS(1358),
    [sym_null] = ACTIONS(1358),
    [sym_inf] = ACTIONS(1358),
    [sym_nan] = ACTIONS(1358),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1356),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [342] = {
    [ts_builtin_sym_end] = ACTIONS(1008),
    [anon_sym_LF] = ACTIONS(1010),
    [anon_sym_SEMI] = ACTIONS(1010),
    [anon_sym_function] = ACTIONS(1010),
    [anon_sym_if] = ACTIONS(1010),
    [anon_sym_LPAREN] = ACTIONS(1010),
    [anon_sym_else] = ACTIONS(1010),
    [anon_sym_while] = ACTIONS(1010),
    [anon_sym_repeat] = ACTIONS(1010),
    [anon_sym_for] = ACTIONS(1010),
    [anon_sym_switch] = ACTIONS(1010),
    [anon_sym_EQ] = ACTIONS(1010),
    [anon_sym_LBRACE] = ACTIONS(1010),
    [anon_sym_LT_DASH] = ACTIONS(1010),
    [anon_sym_COLON_EQ] = ACTIONS(1010),
    [anon_sym_LT_LT_DASH] = ACTIONS(1010),
    [anon_sym_DASH_GT] = ACTIONS(1010),
    [anon_sym_LBRACK] = ACTIONS(1010),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1010),
    [anon_sym_DOLLAR] = ACTIONS(1010),
    [anon_sym_AT] = ACTIONS(1010),
    [sym_dots] = ACTIONS(1010),
    [anon_sym_DASH] = ACTIONS(1010),
    [anon_sym_PLUS] = ACTIONS(1010),
    [anon_sym_BANG] = ACTIONS(1010),
    [anon_sym_TILDE] = ACTIONS(1010),
    [anon_sym_STAR] = ACTIONS(1010),
    [anon_sym_SLASH] = ACTIONS(1010),
    [anon_sym_CARET] = ACTIONS(1010),
    [anon_sym_LT] = ACTIONS(1010),
    [anon_sym_GT] = ACTIONS(1010),
    [anon_sym_LT_EQ] = ACTIONS(1010),
    [anon_sym_GT_EQ] = ACTIONS(1010),
    [anon_sym_EQ_EQ] = ACTIONS(1010),
    [anon_sym_BANG_EQ] = ACTIONS(1010),
    [anon_sym_PIPE_PIPE] = ACTIONS(1010),
    [anon_sym_PIPE] = ACTIONS(1010),
    [anon_sym_AMP_AMP] = ACTIONS(1010),
    [anon_sym_AMP] = ACTIONS(1010),
    [anon_sym_PIPE_GT] = ACTIONS(1010),
    [anon_sym_COLON] = ACTIONS(1010),
    [sym_break] = ACTIONS(1010),
    [sym_next] = ACTIONS(1010),
    [sym_true] = ACTIONS(1010),
    [sym_false] = ACTIONS(1010),
    [sym_null] = ACTIONS(1010),
    [sym_inf] = ACTIONS(1010),
    [sym_nan] = ACTIONS(1010),
    [anon_sym_NA] = ACTIONS(1010),
    [anon_sym_NA_character_] = ACTIONS(1010),
    [anon_sym_NA_complex_] = ACTIONS(1010),
    [anon_sym_NA_integer_] = ACTIONS(1010),
    [anon_sym_NA_real_] = ACTIONS(1010),
    [aux_sym_identifier_token1] = ACTIONS(1010),
    [anon_sym_BQUOTE] = ACTIONS(1010),
    [sym_integer] = ACTIONS(1010),
    [sym_float] = ACTIONS(1010),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1010),
    [anon_sym_SQUOTE] = ACTIONS(1010),
    [anon_sym_PERCENT] = ACTIONS(1010),
  },
  [343] = {
    [ts_builtin_sym_end] = ACTIONS(1004),
    [anon_sym_LF] = ACTIONS(1006),
    [anon_sym_SEMI] = ACTIONS(1006),
    [anon_sym_function] = ACTIONS(1006),
    [anon_sym_if] = ACTIONS(1006),
    [anon_sym_LPAREN] = ACTIONS(1006),
    [anon_sym_else] = ACTIONS(1006),
    [anon_sym_while] = ACTIONS(1006),
    [anon_sym_repeat] = ACTIONS(1006),
    [anon_sym_for] = ACTIONS(1006),
    [anon_sym_switch] = ACTIONS(1006),
    [anon_sym_EQ] = ACTIONS(1006),
    [anon_sym_LBRACE] = ACTIONS(1006),
    [anon_sym_LT_DASH] = ACTIONS(1006),
    [anon_sym_COLON_EQ] = ACTIONS(1006),
    [anon_sym_LT_LT_DASH] = ACTIONS(1006),
    [anon_sym_DASH_GT] = ACTIONS(1006),
    [anon_sym_LBRACK] = ACTIONS(1006),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1006),
    [anon_sym_DOLLAR] = ACTIONS(1006),
    [anon_sym_AT] = ACTIONS(1006),
    [sym_dots] = ACTIONS(1006),
    [anon_sym_DASH] = ACTIONS(1006),
    [anon_sym_PLUS] = ACTIONS(1006),
    [anon_sym_BANG] = ACTIONS(1006),
    [anon_sym_TILDE] = ACTIONS(1006),
    [anon_sym_STAR] = ACTIONS(1006),
    [anon_sym_SLASH] = ACTIONS(1006),
    [anon_sym_CARET] = ACTIONS(1006),
    [anon_sym_LT] = ACTIONS(1006),
    [anon_sym_GT] = ACTIONS(1006),
    [anon_sym_LT_EQ] = ACTIONS(1006),
    [anon_sym_GT_EQ] = ACTIONS(1006),
    [anon_sym_EQ_EQ] = ACTIONS(1006),
    [anon_sym_BANG_EQ] = ACTIONS(1006),
    [anon_sym_PIPE_PIPE] = ACTIONS(1006),
    [anon_sym_PIPE] = ACTIONS(1006),
    [anon_sym_AMP_AMP] = ACTIONS(1006),
    [anon_sym_AMP] = ACTIONS(1006),
    [anon_sym_PIPE_GT] = ACTIONS(1006),
    [anon_sym_COLON] = ACTIONS(1006),
    [sym_break] = ACTIONS(1006),
    [sym_next] = ACTIONS(1006),
    [sym_true] = ACTIONS(1006),
    [sym_false] = ACTIONS(1006),
    [sym_null] = ACTIONS(1006),
    [sym_inf] = ACTIONS(1006),
    [sym_nan] = ACTIONS(1006),
    [anon_sym_NA] = ACTIONS(1006),
    [anon_sym_NA_character_] = ACTIONS(1006),
    [anon_sym_NA_complex_] = ACTIONS(1006),
    [anon_sym_NA_integer_] = ACTIONS(1006),
    [anon_sym_NA_real_] = ACTIONS(1006),
    [aux_sym_identifier_token1] = ACTIONS(1006),
    [anon_sym_BQUOTE] = ACTIONS(1006),
    [sym_integer] = ACTIONS(1006),
    [sym_float] = ACTIONS(1006),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1006),
    [anon_sym_SQUOTE] = ACTIONS(1006),
    [anon_sym_PERCENT] = ACTIONS(1006),
  },
  [344] = {
    [sym_function_definition] = STATE(848),
    [sym_if] = STATE(848),
    [sym_while] = STATE(848),
    [sym_repeat] = STATE(848),
    [sym_for] = STATE(848),
    [sym_switch] = STATE(848),
    [sym_call] = STATE(848),
    [sym__assignment] = STATE(848),
    [sym_left_assignment] = STATE(848),
    [sym_left_assignment2] = STATE(848),
    [sym_equals_assignment] = STATE(848),
    [sym_super_assignment] = STATE(848),
    [sym_right_assignment] = STATE(848),
    [sym_brace_list] = STATE(848),
    [sym_paren_list] = STATE(848),
    [sym_subset] = STATE(848),
    [sym_subset2] = STATE(848),
    [sym_dollar] = STATE(848),
    [sym_slot] = STATE(848),
    [sym_namespace_get] = STATE(848),
    [sym_namespace_get_internal] = STATE(848),
    [sym_unary] = STATE(848),
    [sym_binary] = STATE(848),
    [sym_na] = STATE(848),
    [sym__expression] = STATE(848),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(848),
    [sym_string] = STATE(848),
    [anon_sym_SEMI] = ACTIONS(1360),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1362),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1362),
    [sym_next] = ACTIONS(1362),
    [sym_true] = ACTIONS(1362),
    [sym_false] = ACTIONS(1362),
    [sym_null] = ACTIONS(1362),
    [sym_inf] = ACTIONS(1362),
    [sym_nan] = ACTIONS(1362),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1360),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [345] = {
    [ts_builtin_sym_end] = ACTIONS(996),
    [anon_sym_LF] = ACTIONS(998),
    [anon_sym_SEMI] = ACTIONS(998),
    [anon_sym_function] = ACTIONS(998),
    [anon_sym_if] = ACTIONS(998),
    [anon_sym_LPAREN] = ACTIONS(998),
    [anon_sym_else] = ACTIONS(998),
    [anon_sym_while] = ACTIONS(998),
    [anon_sym_repeat] = ACTIONS(998),
    [anon_sym_for] = ACTIONS(998),
    [anon_sym_switch] = ACTIONS(998),
    [anon_sym_EQ] = ACTIONS(998),
    [anon_sym_LBRACE] = ACTIONS(998),
    [anon_sym_LT_DASH] = ACTIONS(998),
    [anon_sym_COLON_EQ] = ACTIONS(998),
    [anon_sym_LT_LT_DASH] = ACTIONS(998),
    [anon_sym_DASH_GT] = ACTIONS(998),
    [anon_sym_LBRACK] = ACTIONS(998),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(998),
    [anon_sym_DOLLAR] = ACTIONS(998),
    [anon_sym_AT] = ACTIONS(998),
    [sym_dots] = ACTIONS(998),
    [anon_sym_DASH] = ACTIONS(998),
    [anon_sym_PLUS] = ACTIONS(998),
    [anon_sym_BANG] = ACTIONS(998),
    [anon_sym_TILDE] = ACTIONS(998),
    [anon_sym_STAR] = ACTIONS(998),
    [anon_sym_SLASH] = ACTIONS(998),
    [anon_sym_CARET] = ACTIONS(998),
    [anon_sym_LT] = ACTIONS(998),
    [anon_sym_GT] = ACTIONS(998),
    [anon_sym_LT_EQ] = ACTIONS(998),
    [anon_sym_GT_EQ] = ACTIONS(998),
    [anon_sym_EQ_EQ] = ACTIONS(998),
    [anon_sym_BANG_EQ] = ACTIONS(998),
    [anon_sym_PIPE_PIPE] = ACTIONS(998),
    [anon_sym_PIPE] = ACTIONS(998),
    [anon_sym_AMP_AMP] = ACTIONS(998),
    [anon_sym_AMP] = ACTIONS(998),
    [anon_sym_PIPE_GT] = ACTIONS(998),
    [anon_sym_COLON] = ACTIONS(998),
    [sym_break] = ACTIONS(998),
    [sym_next] = ACTIONS(998),
    [sym_true] = ACTIONS(998),
    [sym_false] = ACTIONS(998),
    [sym_null] = ACTIONS(998),
    [sym_inf] = ACTIONS(998),
    [sym_nan] = ACTIONS(998),
    [anon_sym_NA] = ACTIONS(998),
    [anon_sym_NA_character_] = ACTIONS(998),
    [anon_sym_NA_complex_] = ACTIONS(998),
    [anon_sym_NA_integer_] = ACTIONS(998),
    [anon_sym_NA_real_] = ACTIONS(998),
    [aux_sym_identifier_token1] = ACTIONS(998),
    [anon_sym_BQUOTE] = ACTIONS(998),
    [sym_integer] = ACTIONS(998),
    [sym_float] = ACTIONS(998),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(998),
    [anon_sym_SQUOTE] = ACTIONS(998),
    [anon_sym_PERCENT] = ACTIONS(998),
  },
  [346] = {
    [ts_builtin_sym_end] = ACTIONS(992),
    [anon_sym_LF] = ACTIONS(994),
    [anon_sym_SEMI] = ACTIONS(994),
    [anon_sym_function] = ACTIONS(994),
    [anon_sym_if] = ACTIONS(994),
    [anon_sym_LPAREN] = ACTIONS(994),
    [anon_sym_else] = ACTIONS(994),
    [anon_sym_while] = ACTIONS(994),
    [anon_sym_repeat] = ACTIONS(994),
    [anon_sym_for] = ACTIONS(994),
    [anon_sym_switch] = ACTIONS(994),
    [anon_sym_EQ] = ACTIONS(994),
    [anon_sym_LBRACE] = ACTIONS(994),
    [anon_sym_LT_DASH] = ACTIONS(994),
    [anon_sym_COLON_EQ] = ACTIONS(994),
    [anon_sym_LT_LT_DASH] = ACTIONS(994),
    [anon_sym_DASH_GT] = ACTIONS(994),
    [anon_sym_LBRACK] = ACTIONS(994),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(994),
    [anon_sym_DOLLAR] = ACTIONS(994),
    [anon_sym_AT] = ACTIONS(994),
    [sym_dots] = ACTIONS(994),
    [anon_sym_DASH] = ACTIONS(994),
    [anon_sym_PLUS] = ACTIONS(994),
    [anon_sym_BANG] = ACTIONS(994),
    [anon_sym_TILDE] = ACTIONS(994),
    [anon_sym_STAR] = ACTIONS(994),
    [anon_sym_SLASH] = ACTIONS(994),
    [anon_sym_CARET] = ACTIONS(994),
    [anon_sym_LT] = ACTIONS(994),
    [anon_sym_GT] = ACTIONS(994),
    [anon_sym_LT_EQ] = ACTIONS(994),
    [anon_sym_GT_EQ] = ACTIONS(994),
    [anon_sym_EQ_EQ] = ACTIONS(994),
    [anon_sym_BANG_EQ] = ACTIONS(994),
    [anon_sym_PIPE_PIPE] = ACTIONS(994),
    [anon_sym_PIPE] = ACTIONS(994),
    [anon_sym_AMP_AMP] = ACTIONS(994),
    [anon_sym_AMP] = ACTIONS(994),
    [anon_sym_PIPE_GT] = ACTIONS(994),
    [anon_sym_COLON] = ACTIONS(994),
    [sym_break] = ACTIONS(994),
    [sym_next] = ACTIONS(994),
    [sym_true] = ACTIONS(994),
    [sym_false] = ACTIONS(994),
    [sym_null] = ACTIONS(994),
    [sym_inf] = ACTIONS(994),
    [sym_nan] = ACTIONS(994),
    [anon_sym_NA] = ACTIONS(994),
    [anon_sym_NA_character_] = ACTIONS(994),
    [anon_sym_NA_complex_] = ACTIONS(994),
    [anon_sym_NA_integer_] = ACTIONS(994),
    [anon_sym_NA_real_] = ACTIONS(994),
    [aux_sym_identifier_token1] = ACTIONS(994),
    [anon_sym_BQUOTE] = ACTIONS(994),
    [sym_integer] = ACTIONS(994),
    [sym_float] = ACTIONS(994),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(994),
    [anon_sym_SQUOTE] = ACTIONS(994),
    [anon_sym_PERCENT] = ACTIONS(994),
  },
  [347] = {
    [sym_function_definition] = STATE(829),
    [sym_if] = STATE(829),
    [sym_while] = STATE(829),
    [sym_repeat] = STATE(829),
    [sym_for] = STATE(829),
    [sym_switch] = STATE(829),
    [sym_call] = STATE(829),
    [sym__assignment] = STATE(829),
    [sym_left_assignment] = STATE(829),
    [sym_left_assignment2] = STATE(829),
    [sym_equals_assignment] = STATE(829),
    [sym_super_assignment] = STATE(829),
    [sym_right_assignment] = STATE(829),
    [sym_brace_list] = STATE(829),
    [sym_paren_list] = STATE(829),
    [sym_subset] = STATE(829),
    [sym_subset2] = STATE(829),
    [sym_dollar] = STATE(829),
    [sym_slot] = STATE(829),
    [sym_namespace_get] = STATE(829),
    [sym_namespace_get_internal] = STATE(829),
    [sym_unary] = STATE(829),
    [sym_binary] = STATE(829),
    [sym_na] = STATE(829),
    [sym__expression] = STATE(829),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(829),
    [sym_string] = STATE(829),
    [anon_sym_SEMI] = ACTIONS(1364),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1366),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1366),
    [sym_next] = ACTIONS(1366),
    [sym_true] = ACTIONS(1366),
    [sym_false] = ACTIONS(1366),
    [sym_null] = ACTIONS(1366),
    [sym_inf] = ACTIONS(1366),
    [sym_nan] = ACTIONS(1366),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1364),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [348] = {
    [sym_function_definition] = STATE(826),
    [sym_if] = STATE(826),
    [sym_while] = STATE(826),
    [sym_repeat] = STATE(826),
    [sym_for] = STATE(826),
    [sym_switch] = STATE(826),
    [sym_call] = STATE(826),
    [sym__assignment] = STATE(826),
    [sym_left_assignment] = STATE(826),
    [sym_left_assignment2] = STATE(826),
    [sym_equals_assignment] = STATE(826),
    [sym_super_assignment] = STATE(826),
    [sym_right_assignment] = STATE(826),
    [sym_brace_list] = STATE(826),
    [sym_paren_list] = STATE(826),
    [sym_subset] = STATE(826),
    [sym_subset2] = STATE(826),
    [sym_dollar] = STATE(826),
    [sym_slot] = STATE(826),
    [sym_namespace_get] = STATE(826),
    [sym_namespace_get_internal] = STATE(826),
    [sym_unary] = STATE(826),
    [sym_binary] = STATE(826),
    [sym_na] = STATE(826),
    [sym__expression] = STATE(826),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(826),
    [sym_string] = STATE(826),
    [anon_sym_SEMI] = ACTIONS(1368),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1370),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1370),
    [sym_next] = ACTIONS(1370),
    [sym_true] = ACTIONS(1370),
    [sym_false] = ACTIONS(1370),
    [sym_null] = ACTIONS(1370),
    [sym_inf] = ACTIONS(1370),
    [sym_nan] = ACTIONS(1370),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1368),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [349] = {
    [sym_function_definition] = STATE(860),
    [sym_if] = STATE(860),
    [sym_while] = STATE(860),
    [sym_repeat] = STATE(860),
    [sym_for] = STATE(860),
    [sym_switch] = STATE(860),
    [sym_call] = STATE(860),
    [sym__assignment] = STATE(860),
    [sym_left_assignment] = STATE(860),
    [sym_left_assignment2] = STATE(860),
    [sym_equals_assignment] = STATE(860),
    [sym_super_assignment] = STATE(860),
    [sym_right_assignment] = STATE(860),
    [sym_brace_list] = STATE(860),
    [sym_paren_list] = STATE(860),
    [sym_subset] = STATE(860),
    [sym_subset2] = STATE(860),
    [sym_dollar] = STATE(860),
    [sym_slot] = STATE(860),
    [sym_namespace_get] = STATE(860),
    [sym_namespace_get_internal] = STATE(860),
    [sym_unary] = STATE(860),
    [sym_binary] = STATE(860),
    [sym_na] = STATE(860),
    [sym__expression] = STATE(860),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(860),
    [sym_string] = STATE(860),
    [anon_sym_SEMI] = ACTIONS(1372),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1374),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1374),
    [sym_next] = ACTIONS(1374),
    [sym_true] = ACTIONS(1374),
    [sym_false] = ACTIONS(1374),
    [sym_null] = ACTIONS(1374),
    [sym_inf] = ACTIONS(1374),
    [sym_nan] = ACTIONS(1374),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1372),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [350] = {
    [sym_function_definition] = STATE(857),
    [sym_if] = STATE(857),
    [sym_while] = STATE(857),
    [sym_repeat] = STATE(857),
    [sym_for] = STATE(857),
    [sym_switch] = STATE(857),
    [sym_call] = STATE(857),
    [sym__assignment] = STATE(857),
    [sym_left_assignment] = STATE(857),
    [sym_left_assignment2] = STATE(857),
    [sym_equals_assignment] = STATE(857),
    [sym_super_assignment] = STATE(857),
    [sym_right_assignment] = STATE(857),
    [sym_brace_list] = STATE(857),
    [sym_paren_list] = STATE(857),
    [sym_subset] = STATE(857),
    [sym_subset2] = STATE(857),
    [sym_dollar] = STATE(857),
    [sym_slot] = STATE(857),
    [sym_namespace_get] = STATE(857),
    [sym_namespace_get_internal] = STATE(857),
    [sym_unary] = STATE(857),
    [sym_binary] = STATE(857),
    [sym_na] = STATE(857),
    [sym__expression] = STATE(857),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(857),
    [sym_string] = STATE(857),
    [anon_sym_SEMI] = ACTIONS(1376),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1378),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1378),
    [sym_next] = ACTIONS(1378),
    [sym_true] = ACTIONS(1378),
    [sym_false] = ACTIONS(1378),
    [sym_null] = ACTIONS(1378),
    [sym_inf] = ACTIONS(1378),
    [sym_nan] = ACTIONS(1378),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1376),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [351] = {
    [sym_function_definition] = STATE(402),
    [sym_if] = STATE(402),
    [sym_while] = STATE(402),
    [sym_repeat] = STATE(402),
    [sym_for] = STATE(402),
    [sym_switch] = STATE(402),
    [sym_call] = STATE(402),
    [sym__assignment] = STATE(402),
    [sym_left_assignment] = STATE(402),
    [sym_left_assignment2] = STATE(402),
    [sym_equals_assignment] = STATE(402),
    [sym_super_assignment] = STATE(402),
    [sym_right_assignment] = STATE(402),
    [sym_brace_list] = STATE(402),
    [sym_paren_list] = STATE(402),
    [sym_subset] = STATE(402),
    [sym_subset2] = STATE(402),
    [sym_dollar] = STATE(402),
    [sym_slot] = STATE(402),
    [sym_namespace_get] = STATE(402),
    [sym_namespace_get_internal] = STATE(402),
    [sym_unary] = STATE(402),
    [sym_binary] = STATE(402),
    [sym_na] = STATE(402),
    [sym__expression] = STATE(402),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(402),
    [sym_string] = STATE(402),
    [anon_sym_SEMI] = ACTIONS(1380),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1382),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1382),
    [sym_next] = ACTIONS(1382),
    [sym_true] = ACTIONS(1382),
    [sym_false] = ACTIONS(1382),
    [sym_null] = ACTIONS(1382),
    [sym_inf] = ACTIONS(1382),
    [sym_nan] = ACTIONS(1382),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1380),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [352] = {
    [ts_builtin_sym_end] = ACTIONS(988),
    [anon_sym_LF] = ACTIONS(990),
    [anon_sym_SEMI] = ACTIONS(990),
    [anon_sym_function] = ACTIONS(990),
    [anon_sym_if] = ACTIONS(990),
    [anon_sym_LPAREN] = ACTIONS(990),
    [anon_sym_else] = ACTIONS(990),
    [anon_sym_while] = ACTIONS(990),
    [anon_sym_repeat] = ACTIONS(990),
    [anon_sym_for] = ACTIONS(990),
    [anon_sym_switch] = ACTIONS(990),
    [anon_sym_EQ] = ACTIONS(990),
    [anon_sym_LBRACE] = ACTIONS(990),
    [anon_sym_LT_DASH] = ACTIONS(990),
    [anon_sym_COLON_EQ] = ACTIONS(990),
    [anon_sym_LT_LT_DASH] = ACTIONS(990),
    [anon_sym_DASH_GT] = ACTIONS(990),
    [anon_sym_LBRACK] = ACTIONS(990),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(990),
    [anon_sym_DOLLAR] = ACTIONS(990),
    [anon_sym_AT] = ACTIONS(990),
    [sym_dots] = ACTIONS(990),
    [anon_sym_DASH] = ACTIONS(990),
    [anon_sym_PLUS] = ACTIONS(990),
    [anon_sym_BANG] = ACTIONS(990),
    [anon_sym_TILDE] = ACTIONS(990),
    [anon_sym_STAR] = ACTIONS(990),
    [anon_sym_SLASH] = ACTIONS(990),
    [anon_sym_CARET] = ACTIONS(990),
    [anon_sym_LT] = ACTIONS(990),
    [anon_sym_GT] = ACTIONS(990),
    [anon_sym_LT_EQ] = ACTIONS(990),
    [anon_sym_GT_EQ] = ACTIONS(990),
    [anon_sym_EQ_EQ] = ACTIONS(990),
    [anon_sym_BANG_EQ] = ACTIONS(990),
    [anon_sym_PIPE_PIPE] = ACTIONS(990),
    [anon_sym_PIPE] = ACTIONS(990),
    [anon_sym_AMP_AMP] = ACTIONS(990),
    [anon_sym_AMP] = ACTIONS(990),
    [anon_sym_PIPE_GT] = ACTIONS(990),
    [anon_sym_COLON] = ACTIONS(990),
    [sym_break] = ACTIONS(990),
    [sym_next] = ACTIONS(990),
    [sym_true] = ACTIONS(990),
    [sym_false] = ACTIONS(990),
    [sym_null] = ACTIONS(990),
    [sym_inf] = ACTIONS(990),
    [sym_nan] = ACTIONS(990),
    [anon_sym_NA] = ACTIONS(990),
    [anon_sym_NA_character_] = ACTIONS(990),
    [anon_sym_NA_complex_] = ACTIONS(990),
    [anon_sym_NA_integer_] = ACTIONS(990),
    [anon_sym_NA_real_] = ACTIONS(990),
    [aux_sym_identifier_token1] = ACTIONS(990),
    [anon_sym_BQUOTE] = ACTIONS(990),
    [sym_integer] = ACTIONS(990),
    [sym_float] = ACTIONS(990),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(990),
    [anon_sym_SQUOTE] = ACTIONS(990),
    [anon_sym_PERCENT] = ACTIONS(990),
  },
  [353] = {
    [ts_builtin_sym_end] = ACTIONS(984),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(986),
    [anon_sym_function] = ACTIONS(986),
    [anon_sym_if] = ACTIONS(986),
    [anon_sym_LPAREN] = ACTIONS(986),
    [anon_sym_else] = ACTIONS(986),
    [anon_sym_while] = ACTIONS(986),
    [anon_sym_repeat] = ACTIONS(986),
    [anon_sym_for] = ACTIONS(986),
    [anon_sym_switch] = ACTIONS(986),
    [anon_sym_EQ] = ACTIONS(986),
    [anon_sym_LBRACE] = ACTIONS(986),
    [anon_sym_LT_DASH] = ACTIONS(986),
    [anon_sym_COLON_EQ] = ACTIONS(986),
    [anon_sym_LT_LT_DASH] = ACTIONS(986),
    [anon_sym_DASH_GT] = ACTIONS(986),
    [anon_sym_LBRACK] = ACTIONS(986),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(986),
    [anon_sym_DOLLAR] = ACTIONS(986),
    [anon_sym_AT] = ACTIONS(986),
    [sym_dots] = ACTIONS(986),
    [anon_sym_DASH] = ACTIONS(986),
    [anon_sym_PLUS] = ACTIONS(986),
    [anon_sym_BANG] = ACTIONS(986),
    [anon_sym_TILDE] = ACTIONS(986),
    [anon_sym_STAR] = ACTIONS(986),
    [anon_sym_SLASH] = ACTIONS(986),
    [anon_sym_CARET] = ACTIONS(986),
    [anon_sym_LT] = ACTIONS(986),
    [anon_sym_GT] = ACTIONS(986),
    [anon_sym_LT_EQ] = ACTIONS(986),
    [anon_sym_GT_EQ] = ACTIONS(986),
    [anon_sym_EQ_EQ] = ACTIONS(986),
    [anon_sym_BANG_EQ] = ACTIONS(986),
    [anon_sym_PIPE_PIPE] = ACTIONS(986),
    [anon_sym_PIPE] = ACTIONS(986),
    [anon_sym_AMP_AMP] = ACTIONS(986),
    [anon_sym_AMP] = ACTIONS(986),
    [anon_sym_PIPE_GT] = ACTIONS(986),
    [anon_sym_COLON] = ACTIONS(986),
    [sym_break] = ACTIONS(986),
    [sym_next] = ACTIONS(986),
    [sym_true] = ACTIONS(986),
    [sym_false] = ACTIONS(986),
    [sym_null] = ACTIONS(986),
    [sym_inf] = ACTIONS(986),
    [sym_nan] = ACTIONS(986),
    [anon_sym_NA] = ACTIONS(986),
    [anon_sym_NA_character_] = ACTIONS(986),
    [anon_sym_NA_complex_] = ACTIONS(986),
    [anon_sym_NA_integer_] = ACTIONS(986),
    [anon_sym_NA_real_] = ACTIONS(986),
    [aux_sym_identifier_token1] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(986),
    [sym_integer] = ACTIONS(986),
    [sym_float] = ACTIONS(986),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(986),
    [anon_sym_SQUOTE] = ACTIONS(986),
    [anon_sym_PERCENT] = ACTIONS(986),
  },
  [354] = {
    [ts_builtin_sym_end] = ACTIONS(980),
    [anon_sym_LF] = ACTIONS(982),
    [anon_sym_SEMI] = ACTIONS(982),
    [anon_sym_function] = ACTIONS(982),
    [anon_sym_if] = ACTIONS(982),
    [anon_sym_LPAREN] = ACTIONS(982),
    [anon_sym_else] = ACTIONS(982),
    [anon_sym_while] = ACTIONS(982),
    [anon_sym_repeat] = ACTIONS(982),
    [anon_sym_for] = ACTIONS(982),
    [anon_sym_switch] = ACTIONS(982),
    [anon_sym_EQ] = ACTIONS(982),
    [anon_sym_LBRACE] = ACTIONS(982),
    [anon_sym_LT_DASH] = ACTIONS(982),
    [anon_sym_COLON_EQ] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DASH_GT] = ACTIONS(982),
    [anon_sym_LBRACK] = ACTIONS(982),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_AT] = ACTIONS(982),
    [sym_dots] = ACTIONS(982),
    [anon_sym_DASH] = ACTIONS(982),
    [anon_sym_PLUS] = ACTIONS(982),
    [anon_sym_BANG] = ACTIONS(982),
    [anon_sym_TILDE] = ACTIONS(982),
    [anon_sym_STAR] = ACTIONS(982),
    [anon_sym_SLASH] = ACTIONS(982),
    [anon_sym_CARET] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_LT_EQ] = ACTIONS(982),
    [anon_sym_GT_EQ] = ACTIONS(982),
    [anon_sym_EQ_EQ] = ACTIONS(982),
    [anon_sym_BANG_EQ] = ACTIONS(982),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_PIPE_GT] = ACTIONS(982),
    [anon_sym_COLON] = ACTIONS(982),
    [sym_break] = ACTIONS(982),
    [sym_next] = ACTIONS(982),
    [sym_true] = ACTIONS(982),
    [sym_false] = ACTIONS(982),
    [sym_null] = ACTIONS(982),
    [sym_inf] = ACTIONS(982),
    [sym_nan] = ACTIONS(982),
    [anon_sym_NA] = ACTIONS(982),
    [anon_sym_NA_character_] = ACTIONS(982),
    [anon_sym_NA_complex_] = ACTIONS(982),
    [anon_sym_NA_integer_] = ACTIONS(982),
    [anon_sym_NA_real_] = ACTIONS(982),
    [aux_sym_identifier_token1] = ACTIONS(982),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [sym_integer] = ACTIONS(982),
    [sym_float] = ACTIONS(982),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_SQUOTE] = ACTIONS(982),
    [anon_sym_PERCENT] = ACTIONS(982),
  },
  [355] = {
    [ts_builtin_sym_end] = ACTIONS(976),
    [anon_sym_LF] = ACTIONS(978),
    [anon_sym_SEMI] = ACTIONS(978),
    [anon_sym_function] = ACTIONS(978),
    [anon_sym_if] = ACTIONS(978),
    [anon_sym_LPAREN] = ACTIONS(978),
    [anon_sym_else] = ACTIONS(978),
    [anon_sym_while] = ACTIONS(978),
    [anon_sym_repeat] = ACTIONS(978),
    [anon_sym_for] = ACTIONS(978),
    [anon_sym_switch] = ACTIONS(978),
    [anon_sym_EQ] = ACTIONS(978),
    [anon_sym_LBRACE] = ACTIONS(978),
    [anon_sym_LT_DASH] = ACTIONS(978),
    [anon_sym_COLON_EQ] = ACTIONS(978),
    [anon_sym_LT_LT_DASH] = ACTIONS(978),
    [anon_sym_DASH_GT] = ACTIONS(978),
    [anon_sym_LBRACK] = ACTIONS(978),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(978),
    [anon_sym_DOLLAR] = ACTIONS(978),
    [anon_sym_AT] = ACTIONS(978),
    [sym_dots] = ACTIONS(978),
    [anon_sym_DASH] = ACTIONS(978),
    [anon_sym_PLUS] = ACTIONS(978),
    [anon_sym_BANG] = ACTIONS(978),
    [anon_sym_TILDE] = ACTIONS(978),
    [anon_sym_STAR] = ACTIONS(978),
    [anon_sym_SLASH] = ACTIONS(978),
    [anon_sym_CARET] = ACTIONS(978),
    [anon_sym_LT] = ACTIONS(978),
    [anon_sym_GT] = ACTIONS(978),
    [anon_sym_LT_EQ] = ACTIONS(978),
    [anon_sym_GT_EQ] = ACTIONS(978),
    [anon_sym_EQ_EQ] = ACTIONS(978),
    [anon_sym_BANG_EQ] = ACTIONS(978),
    [anon_sym_PIPE_PIPE] = ACTIONS(978),
    [anon_sym_PIPE] = ACTIONS(978),
    [anon_sym_AMP_AMP] = ACTIONS(978),
    [anon_sym_AMP] = ACTIONS(978),
    [anon_sym_PIPE_GT] = ACTIONS(978),
    [anon_sym_COLON] = ACTIONS(978),
    [sym_break] = ACTIONS(978),
    [sym_next] = ACTIONS(978),
    [sym_true] = ACTIONS(978),
    [sym_false] = ACTIONS(978),
    [sym_null] = ACTIONS(978),
    [sym_inf] = ACTIONS(978),
    [sym_nan] = ACTIONS(978),
    [anon_sym_NA] = ACTIONS(978),
    [anon_sym_NA_character_] = ACTIONS(978),
    [anon_sym_NA_complex_] = ACTIONS(978),
    [anon_sym_NA_integer_] = ACTIONS(978),
    [anon_sym_NA_real_] = ACTIONS(978),
    [aux_sym_identifier_token1] = ACTIONS(978),
    [anon_sym_BQUOTE] = ACTIONS(978),
    [sym_integer] = ACTIONS(978),
    [sym_float] = ACTIONS(978),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(978),
    [anon_sym_SQUOTE] = ACTIONS(978),
    [anon_sym_PERCENT] = ACTIONS(978),
  },
  [356] = {
    [sym_function_definition] = STATE(833),
    [sym_if] = STATE(833),
    [sym_while] = STATE(833),
    [sym_repeat] = STATE(833),
    [sym_for] = STATE(833),
    [sym_switch] = STATE(833),
    [sym_call] = STATE(833),
    [sym__assignment] = STATE(833),
    [sym_left_assignment] = STATE(833),
    [sym_left_assignment2] = STATE(833),
    [sym_equals_assignment] = STATE(833),
    [sym_super_assignment] = STATE(833),
    [sym_right_assignment] = STATE(833),
    [sym_brace_list] = STATE(833),
    [sym_paren_list] = STATE(833),
    [sym_subset] = STATE(833),
    [sym_subset2] = STATE(833),
    [sym_dollar] = STATE(833),
    [sym_slot] = STATE(833),
    [sym_namespace_get] = STATE(833),
    [sym_namespace_get_internal] = STATE(833),
    [sym_unary] = STATE(833),
    [sym_binary] = STATE(833),
    [sym_na] = STATE(833),
    [sym__expression] = STATE(833),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(833),
    [sym_string] = STATE(833),
    [anon_sym_SEMI] = ACTIONS(1384),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1386),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1386),
    [sym_next] = ACTIONS(1386),
    [sym_true] = ACTIONS(1386),
    [sym_false] = ACTIONS(1386),
    [sym_null] = ACTIONS(1386),
    [sym_inf] = ACTIONS(1386),
    [sym_nan] = ACTIONS(1386),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1384),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [357] = {
    [sym_function_definition] = STATE(828),
    [sym_if] = STATE(828),
    [sym_while] = STATE(828),
    [sym_repeat] = STATE(828),
    [sym_for] = STATE(828),
    [sym_switch] = STATE(828),
    [sym_call] = STATE(828),
    [sym__assignment] = STATE(828),
    [sym_left_assignment] = STATE(828),
    [sym_left_assignment2] = STATE(828),
    [sym_equals_assignment] = STATE(828),
    [sym_super_assignment] = STATE(828),
    [sym_right_assignment] = STATE(828),
    [sym_brace_list] = STATE(828),
    [sym_paren_list] = STATE(828),
    [sym_subset] = STATE(828),
    [sym_subset2] = STATE(828),
    [sym_dollar] = STATE(828),
    [sym_slot] = STATE(828),
    [sym_namespace_get] = STATE(828),
    [sym_namespace_get_internal] = STATE(828),
    [sym_unary] = STATE(828),
    [sym_binary] = STATE(828),
    [sym_na] = STATE(828),
    [sym__expression] = STATE(828),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(828),
    [sym_string] = STATE(828),
    [anon_sym_SEMI] = ACTIONS(1388),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1390),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1390),
    [sym_next] = ACTIONS(1390),
    [sym_true] = ACTIONS(1390),
    [sym_false] = ACTIONS(1390),
    [sym_null] = ACTIONS(1390),
    [sym_inf] = ACTIONS(1390),
    [sym_nan] = ACTIONS(1390),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1388),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [358] = {
    [sym_function_definition] = STATE(412),
    [sym_if] = STATE(412),
    [sym_while] = STATE(412),
    [sym_repeat] = STATE(412),
    [sym_for] = STATE(412),
    [sym_switch] = STATE(412),
    [sym_call] = STATE(412),
    [sym__assignment] = STATE(412),
    [sym_left_assignment] = STATE(412),
    [sym_left_assignment2] = STATE(412),
    [sym_equals_assignment] = STATE(412),
    [sym_super_assignment] = STATE(412),
    [sym_right_assignment] = STATE(412),
    [sym_brace_list] = STATE(412),
    [sym_paren_list] = STATE(412),
    [sym_subset] = STATE(412),
    [sym_subset2] = STATE(412),
    [sym_dollar] = STATE(412),
    [sym_slot] = STATE(412),
    [sym_namespace_get] = STATE(412),
    [sym_namespace_get_internal] = STATE(412),
    [sym_unary] = STATE(412),
    [sym_binary] = STATE(412),
    [sym_na] = STATE(412),
    [sym__expression] = STATE(412),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(412),
    [sym_string] = STATE(412),
    [anon_sym_SEMI] = ACTIONS(1392),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1394),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1394),
    [sym_next] = ACTIONS(1394),
    [sym_true] = ACTIONS(1394),
    [sym_false] = ACTIONS(1394),
    [sym_null] = ACTIONS(1394),
    [sym_inf] = ACTIONS(1394),
    [sym_nan] = ACTIONS(1394),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1392),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [359] = {
    [sym_function_definition] = STATE(832),
    [sym_if] = STATE(832),
    [sym_while] = STATE(832),
    [sym_repeat] = STATE(832),
    [sym_for] = STATE(832),
    [sym_switch] = STATE(832),
    [sym_call] = STATE(832),
    [sym__assignment] = STATE(832),
    [sym_left_assignment] = STATE(832),
    [sym_left_assignment2] = STATE(832),
    [sym_equals_assignment] = STATE(832),
    [sym_super_assignment] = STATE(832),
    [sym_right_assignment] = STATE(832),
    [sym_brace_list] = STATE(832),
    [sym_paren_list] = STATE(832),
    [sym_subset] = STATE(832),
    [sym_subset2] = STATE(832),
    [sym_dollar] = STATE(832),
    [sym_slot] = STATE(832),
    [sym_namespace_get] = STATE(832),
    [sym_namespace_get_internal] = STATE(832),
    [sym_unary] = STATE(832),
    [sym_binary] = STATE(832),
    [sym_na] = STATE(832),
    [sym__expression] = STATE(832),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(832),
    [sym_string] = STATE(832),
    [anon_sym_SEMI] = ACTIONS(1396),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1398),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1398),
    [sym_next] = ACTIONS(1398),
    [sym_true] = ACTIONS(1398),
    [sym_false] = ACTIONS(1398),
    [sym_null] = ACTIONS(1398),
    [sym_inf] = ACTIONS(1398),
    [sym_nan] = ACTIONS(1398),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1396),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [360] = {
    [sym_function_definition] = STATE(837),
    [sym_if] = STATE(837),
    [sym_while] = STATE(837),
    [sym_repeat] = STATE(837),
    [sym_for] = STATE(837),
    [sym_switch] = STATE(837),
    [sym_call] = STATE(837),
    [sym__assignment] = STATE(837),
    [sym_left_assignment] = STATE(837),
    [sym_left_assignment2] = STATE(837),
    [sym_equals_assignment] = STATE(837),
    [sym_super_assignment] = STATE(837),
    [sym_right_assignment] = STATE(837),
    [sym_brace_list] = STATE(837),
    [sym_paren_list] = STATE(837),
    [sym_subset] = STATE(837),
    [sym_subset2] = STATE(837),
    [sym_dollar] = STATE(837),
    [sym_slot] = STATE(837),
    [sym_namespace_get] = STATE(837),
    [sym_namespace_get_internal] = STATE(837),
    [sym_unary] = STATE(837),
    [sym_binary] = STATE(837),
    [sym_na] = STATE(837),
    [sym__expression] = STATE(837),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(837),
    [sym_string] = STATE(837),
    [anon_sym_SEMI] = ACTIONS(1400),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1402),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1402),
    [sym_next] = ACTIONS(1402),
    [sym_true] = ACTIONS(1402),
    [sym_false] = ACTIONS(1402),
    [sym_null] = ACTIONS(1402),
    [sym_inf] = ACTIONS(1402),
    [sym_nan] = ACTIONS(1402),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1400),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [361] = {
    [sym_function_definition] = STATE(260),
    [sym_if] = STATE(260),
    [sym_while] = STATE(260),
    [sym_repeat] = STATE(260),
    [sym_for] = STATE(260),
    [sym_switch] = STATE(260),
    [sym_call] = STATE(260),
    [sym__assignment] = STATE(260),
    [sym_left_assignment] = STATE(260),
    [sym_left_assignment2] = STATE(260),
    [sym_equals_assignment] = STATE(260),
    [sym_super_assignment] = STATE(260),
    [sym_right_assignment] = STATE(260),
    [sym_brace_list] = STATE(260),
    [sym_paren_list] = STATE(260),
    [sym_subset] = STATE(260),
    [sym_subset2] = STATE(260),
    [sym_dollar] = STATE(260),
    [sym_slot] = STATE(260),
    [sym_namespace_get] = STATE(260),
    [sym_namespace_get_internal] = STATE(260),
    [sym_unary] = STATE(260),
    [sym_binary] = STATE(260),
    [sym_na] = STATE(260),
    [sym__expression] = STATE(260),
    [sym_identifier] = STATE(112),
    [sym_complex] = STATE(260),
    [sym_string] = STATE(260),
    [anon_sym_SEMI] = ACTIONS(1404),
    [anon_sym_function] = ACTIONS(1048),
    [anon_sym_if] = ACTIONS(1050),
    [anon_sym_LPAREN] = ACTIONS(1052),
    [anon_sym_while] = ACTIONS(1054),
    [anon_sym_repeat] = ACTIONS(1056),
    [anon_sym_for] = ACTIONS(1058),
    [anon_sym_switch] = ACTIONS(1060),
    [anon_sym_LBRACE] = ACTIONS(1062),
    [sym_dots] = ACTIONS(1406),
    [anon_sym_DASH] = ACTIONS(1066),
    [anon_sym_PLUS] = ACTIONS(1066),
    [anon_sym_BANG] = ACTIONS(1068),
    [anon_sym_TILDE] = ACTIONS(1070),
    [sym_break] = ACTIONS(1406),
    [sym_next] = ACTIONS(1406),
    [sym_true] = ACTIONS(1406),
    [sym_false] = ACTIONS(1406),
    [sym_null] = ACTIONS(1406),
    [sym_inf] = ACTIONS(1406),
    [sym_nan] = ACTIONS(1406),
    [anon_sym_NA] = ACTIONS(1072),
    [anon_sym_NA_character_] = ACTIONS(1072),
    [anon_sym_NA_complex_] = ACTIONS(1072),
    [anon_sym_NA_integer_] = ACTIONS(1072),
    [anon_sym_NA_real_] = ACTIONS(1072),
    [aux_sym_identifier_token1] = ACTIONS(1074),
    [anon_sym_BQUOTE] = ACTIONS(1076),
    [sym_integer] = ACTIONS(1404),
    [sym_float] = ACTIONS(1078),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1080),
    [anon_sym_SQUOTE] = ACTIONS(1082),
  },
  [362] = {
    [sym_function_definition] = STATE(413),
    [sym_if] = STATE(413),
    [sym_while] = STATE(413),
    [sym_repeat] = STATE(413),
    [sym_for] = STATE(413),
    [sym_switch] = STATE(413),
    [sym_call] = STATE(413),
    [sym__assignment] = STATE(413),
    [sym_left_assignment] = STATE(413),
    [sym_left_assignment2] = STATE(413),
    [sym_equals_assignment] = STATE(413),
    [sym_super_assignment] = STATE(413),
    [sym_right_assignment] = STATE(413),
    [sym_brace_list] = STATE(413),
    [sym_paren_list] = STATE(413),
    [sym_subset] = STATE(413),
    [sym_subset2] = STATE(413),
    [sym_dollar] = STATE(413),
    [sym_slot] = STATE(413),
    [sym_namespace_get] = STATE(413),
    [sym_namespace_get_internal] = STATE(413),
    [sym_unary] = STATE(413),
    [sym_binary] = STATE(413),
    [sym_na] = STATE(413),
    [sym__expression] = STATE(413),
    [sym_identifier] = STATE(252),
    [sym_complex] = STATE(413),
    [sym_string] = STATE(413),
    [anon_sym_SEMI] = ACTIONS(1408),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1410),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1410),
    [sym_next] = ACTIONS(1410),
    [sym_true] = ACTIONS(1410),
    [sym_false] = ACTIONS(1410),
    [sym_null] = ACTIONS(1410),
    [sym_inf] = ACTIONS(1410),
    [sym_nan] = ACTIONS(1410),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1408),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [363] = {
    [sym_function_definition] = STATE(842),
    [sym_if] = STATE(842),
    [sym_while] = STATE(842),
    [sym_repeat] = STATE(842),
    [sym_for] = STATE(842),
    [sym_switch] = STATE(842),
    [sym_call] = STATE(842),
    [sym__assignment] = STATE(842),
    [sym_left_assignment] = STATE(842),
    [sym_left_assignment2] = STATE(842),
    [sym_equals_assignment] = STATE(842),
    [sym_super_assignment] = STATE(842),
    [sym_right_assignment] = STATE(842),
    [sym_brace_list] = STATE(842),
    [sym_paren_list] = STATE(842),
    [sym_subset] = STATE(842),
    [sym_subset2] = STATE(842),
    [sym_dollar] = STATE(842),
    [sym_slot] = STATE(842),
    [sym_namespace_get] = STATE(842),
    [sym_namespace_get_internal] = STATE(842),
    [sym_unary] = STATE(842),
    [sym_binary] = STATE(842),
    [sym_na] = STATE(842),
    [sym__expression] = STATE(842),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(842),
    [sym_string] = STATE(842),
    [anon_sym_SEMI] = ACTIONS(1412),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1414),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1414),
    [sym_next] = ACTIONS(1414),
    [sym_true] = ACTIONS(1414),
    [sym_false] = ACTIONS(1414),
    [sym_null] = ACTIONS(1414),
    [sym_inf] = ACTIONS(1414),
    [sym_nan] = ACTIONS(1414),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1412),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [364] = {
    [sym_function_definition] = STATE(246),
    [sym_if] = STATE(246),
    [sym_while] = STATE(246),
    [sym_repeat] = STATE(246),
    [sym_for] = STATE(246),
    [sym_switch] = STATE(246),
    [sym_call] = STATE(246),
    [sym__assignment] = STATE(246),
    [sym_left_assignment] = STATE(246),
    [sym_left_assignment2] = STATE(246),
    [sym_equals_assignment] = STATE(246),
    [sym_super_assignment] = STATE(246),
    [sym_right_assignment] = STATE(246),
    [sym_brace_list] = STATE(246),
    [sym_paren_list] = STATE(246),
    [sym_subset] = STATE(246),
    [sym_subset2] = STATE(246),
    [sym_dollar] = STATE(246),
    [sym_slot] = STATE(246),
    [sym_namespace_get] = STATE(246),
    [sym_namespace_get_internal] = STATE(246),
    [sym_unary] = STATE(246),
    [sym_binary] = STATE(246),
    [sym_na] = STATE(246),
    [sym__expression] = STATE(246),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(246),
    [sym_string] = STATE(246),
    [anon_sym_SEMI] = ACTIONS(1416),
    [anon_sym_function] = ACTIONS(1418),
    [anon_sym_if] = ACTIONS(1420),
    [anon_sym_LPAREN] = ACTIONS(1422),
    [anon_sym_while] = ACTIONS(1424),
    [anon_sym_repeat] = ACTIONS(1426),
    [anon_sym_for] = ACTIONS(1428),
    [anon_sym_switch] = ACTIONS(1430),
    [anon_sym_LBRACE] = ACTIONS(1432),
    [sym_dots] = ACTIONS(1434),
    [anon_sym_DASH] = ACTIONS(1436),
    [anon_sym_PLUS] = ACTIONS(1436),
    [anon_sym_BANG] = ACTIONS(1438),
    [anon_sym_TILDE] = ACTIONS(1440),
    [sym_break] = ACTIONS(1434),
    [sym_next] = ACTIONS(1434),
    [sym_true] = ACTIONS(1434),
    [sym_false] = ACTIONS(1434),
    [sym_null] = ACTIONS(1434),
    [sym_inf] = ACTIONS(1434),
    [sym_nan] = ACTIONS(1434),
    [anon_sym_NA] = ACTIONS(1442),
    [anon_sym_NA_character_] = ACTIONS(1442),
    [anon_sym_NA_complex_] = ACTIONS(1442),
    [anon_sym_NA_integer_] = ACTIONS(1442),
    [anon_sym_NA_real_] = ACTIONS(1442),
    [aux_sym_identifier_token1] = ACTIONS(1444),
    [anon_sym_BQUOTE] = ACTIONS(1446),
    [sym_integer] = ACTIONS(1416),
    [sym_float] = ACTIONS(1448),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1450),
    [anon_sym_SQUOTE] = ACTIONS(1452),
  },
  [365] = {
    [ts_builtin_sym_end] = ACTIONS(972),
    [anon_sym_LF] = ACTIONS(974),
    [anon_sym_SEMI] = ACTIONS(974),
    [anon_sym_function] = ACTIONS(974),
    [anon_sym_if] = ACTIONS(974),
    [anon_sym_LPAREN] = ACTIONS(974),
    [anon_sym_else] = ACTIONS(974),
    [anon_sym_while] = ACTIONS(974),
    [anon_sym_repeat] = ACTIONS(974),
    [anon_sym_for] = ACTIONS(974),
    [anon_sym_switch] = ACTIONS(974),
    [anon_sym_EQ] = ACTIONS(974),
    [anon_sym_LBRACE] = ACTIONS(974),
    [anon_sym_LT_DASH] = ACTIONS(974),
    [anon_sym_COLON_EQ] = ACTIONS(974),
    [anon_sym_LT_LT_DASH] = ACTIONS(974),
    [anon_sym_DASH_GT] = ACTIONS(974),
    [anon_sym_LBRACK] = ACTIONS(974),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(974),
    [anon_sym_DOLLAR] = ACTIONS(974),
    [anon_sym_AT] = ACTIONS(974),
    [sym_dots] = ACTIONS(974),
    [anon_sym_DASH] = ACTIONS(974),
    [anon_sym_PLUS] = ACTIONS(974),
    [anon_sym_BANG] = ACTIONS(974),
    [anon_sym_TILDE] = ACTIONS(974),
    [anon_sym_STAR] = ACTIONS(974),
    [anon_sym_SLASH] = ACTIONS(974),
    [anon_sym_CARET] = ACTIONS(974),
    [anon_sym_LT] = ACTIONS(974),
    [anon_sym_GT] = ACTIONS(974),
    [anon_sym_LT_EQ] = ACTIONS(974),
    [anon_sym_GT_EQ] = ACTIONS(974),
    [anon_sym_EQ_EQ] = ACTIONS(974),
    [anon_sym_BANG_EQ] = ACTIONS(974),
    [anon_sym_PIPE_PIPE] = ACTIONS(974),
    [anon_sym_PIPE] = ACTIONS(974),
    [anon_sym_AMP_AMP] = ACTIONS(974),
    [anon_sym_AMP] = ACTIONS(974),
    [anon_sym_PIPE_GT] = ACTIONS(974),
    [anon_sym_COLON] = ACTIONS(974),
    [sym_break] = ACTIONS(974),
    [sym_next] = ACTIONS(974),
    [sym_true] = ACTIONS(974),
    [sym_false] = ACTIONS(974),
    [sym_null] = ACTIONS(974),
    [sym_inf] = ACTIONS(974),
    [sym_nan] = ACTIONS(974),
    [anon_sym_NA] = ACTIONS(974),
    [anon_sym_NA_character_] = ACTIONS(974),
    [anon_sym_NA_complex_] = ACTIONS(974),
    [anon_sym_NA_integer_] = ACTIONS(974),
    [anon_sym_NA_real_] = ACTIONS(974),
    [aux_sym_identifier_token1] = ACTIONS(974),
    [anon_sym_BQUOTE] = ACTIONS(974),
    [sym_integer] = ACTIONS(974),
    [sym_float] = ACTIONS(974),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(974),
    [anon_sym_SQUOTE] = ACTIONS(974),
    [anon_sym_PERCENT] = ACTIONS(974),
  },
  [366] = {
    [ts_builtin_sym_end] = ACTIONS(968),
    [anon_sym_LF] = ACTIONS(970),
    [anon_sym_SEMI] = ACTIONS(970),
    [anon_sym_function] = ACTIONS(970),
    [anon_sym_if] = ACTIONS(970),
    [anon_sym_LPAREN] = ACTIONS(970),
    [anon_sym_else] = ACTIONS(970),
    [anon_sym_while] = ACTIONS(970),
    [anon_sym_repeat] = ACTIONS(970),
    [anon_sym_for] = ACTIONS(970),
    [anon_sym_switch] = ACTIONS(970),
    [anon_sym_EQ] = ACTIONS(970),
    [anon_sym_LBRACE] = ACTIONS(970),
    [anon_sym_LT_DASH] = ACTIONS(970),
    [anon_sym_COLON_EQ] = ACTIONS(970),
    [anon_sym_LT_LT_DASH] = ACTIONS(970),
    [anon_sym_DASH_GT] = ACTIONS(970),
    [anon_sym_LBRACK] = ACTIONS(970),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(970),
    [anon_sym_DOLLAR] = ACTIONS(970),
    [anon_sym_AT] = ACTIONS(970),
    [sym_dots] = ACTIONS(970),
    [anon_sym_DASH] = ACTIONS(970),
    [anon_sym_PLUS] = ACTIONS(970),
    [anon_sym_BANG] = ACTIONS(970),
    [anon_sym_TILDE] = ACTIONS(970),
    [anon_sym_STAR] = ACTIONS(970),
    [anon_sym_SLASH] = ACTIONS(970),
    [anon_sym_CARET] = ACTIONS(970),
    [anon_sym_LT] = ACTIONS(970),
    [anon_sym_GT] = ACTIONS(970),
    [anon_sym_LT_EQ] = ACTIONS(970),
    [anon_sym_GT_EQ] = ACTIONS(970),
    [anon_sym_EQ_EQ] = ACTIONS(970),
    [anon_sym_BANG_EQ] = ACTIONS(970),
    [anon_sym_PIPE_PIPE] = ACTIONS(970),
    [anon_sym_PIPE] = ACTIONS(970),
    [anon_sym_AMP_AMP] = ACTIONS(970),
    [anon_sym_AMP] = ACTIONS(970),
    [anon_sym_PIPE_GT] = ACTIONS(970),
    [anon_sym_COLON] = ACTIONS(970),
    [sym_break] = ACTIONS(970),
    [sym_next] = ACTIONS(970),
    [sym_true] = ACTIONS(970),
    [sym_false] = ACTIONS(970),
    [sym_null] = ACTIONS(970),
    [sym_inf] = ACTIONS(970),
    [sym_nan] = ACTIONS(970),
    [anon_sym_NA] = ACTIONS(970),
    [anon_sym_NA_character_] = ACTIONS(970),
    [anon_sym_NA_complex_] = ACTIONS(970),
    [anon_sym_NA_integer_] = ACTIONS(970),
    [anon_sym_NA_real_] = ACTIONS(970),
    [aux_sym_identifier_token1] = ACTIONS(970),
    [anon_sym_BQUOTE] = ACTIONS(970),
    [sym_integer] = ACTIONS(970),
    [sym_float] = ACTIONS(970),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [anon_sym_SQUOTE] = ACTIONS(970),
    [anon_sym_PERCENT] = ACTIONS(970),
  },
  [367] = {
    [sym_function_definition] = STATE(784),
    [sym_if] = STATE(784),
    [sym_while] = STATE(784),
    [sym_repeat] = STATE(784),
    [sym_for] = STATE(784),
    [sym_switch] = STATE(784),
    [sym_call] = STATE(784),
    [sym__assignment] = STATE(784),
    [sym_left_assignment] = STATE(784),
    [sym_left_assignment2] = STATE(784),
    [sym_equals_assignment] = STATE(784),
    [sym_super_assignment] = STATE(784),
    [sym_right_assignment] = STATE(784),
    [sym_brace_list] = STATE(784),
    [sym_paren_list] = STATE(784),
    [sym_subset] = STATE(784),
    [sym_subset2] = STATE(784),
    [sym_dollar] = STATE(784),
    [sym_slot] = STATE(784),
    [sym_namespace_get] = STATE(784),
    [sym_namespace_get_internal] = STATE(784),
    [sym_unary] = STATE(784),
    [sym_binary] = STATE(784),
    [sym_na] = STATE(784),
    [sym__expression] = STATE(784),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(784),
    [sym_string] = STATE(784),
    [anon_sym_SEMI] = ACTIONS(1454),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1456),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1456),
    [sym_next] = ACTIONS(1456),
    [sym_true] = ACTIONS(1456),
    [sym_false] = ACTIONS(1456),
    [sym_null] = ACTIONS(1456),
    [sym_inf] = ACTIONS(1456),
    [sym_nan] = ACTIONS(1456),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1454),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [368] = {
    [ts_builtin_sym_end] = ACTIONS(964),
    [anon_sym_LF] = ACTIONS(966),
    [anon_sym_SEMI] = ACTIONS(966),
    [anon_sym_function] = ACTIONS(966),
    [anon_sym_if] = ACTIONS(966),
    [anon_sym_LPAREN] = ACTIONS(966),
    [anon_sym_else] = ACTIONS(966),
    [anon_sym_while] = ACTIONS(966),
    [anon_sym_repeat] = ACTIONS(966),
    [anon_sym_for] = ACTIONS(966),
    [anon_sym_switch] = ACTIONS(966),
    [anon_sym_EQ] = ACTIONS(966),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_LT_DASH] = ACTIONS(966),
    [anon_sym_COLON_EQ] = ACTIONS(966),
    [anon_sym_LT_LT_DASH] = ACTIONS(966),
    [anon_sym_DASH_GT] = ACTIONS(966),
    [anon_sym_LBRACK] = ACTIONS(966),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(966),
    [anon_sym_DOLLAR] = ACTIONS(966),
    [anon_sym_AT] = ACTIONS(966),
    [sym_dots] = ACTIONS(966),
    [anon_sym_DASH] = ACTIONS(966),
    [anon_sym_PLUS] = ACTIONS(966),
    [anon_sym_BANG] = ACTIONS(966),
    [anon_sym_TILDE] = ACTIONS(966),
    [anon_sym_STAR] = ACTIONS(966),
    [anon_sym_SLASH] = ACTIONS(966),
    [anon_sym_CARET] = ACTIONS(966),
    [anon_sym_LT] = ACTIONS(966),
    [anon_sym_GT] = ACTIONS(966),
    [anon_sym_LT_EQ] = ACTIONS(966),
    [anon_sym_GT_EQ] = ACTIONS(966),
    [anon_sym_EQ_EQ] = ACTIONS(966),
    [anon_sym_BANG_EQ] = ACTIONS(966),
    [anon_sym_PIPE_PIPE] = ACTIONS(966),
    [anon_sym_PIPE] = ACTIONS(966),
    [anon_sym_AMP_AMP] = ACTIONS(966),
    [anon_sym_AMP] = ACTIONS(966),
    [anon_sym_PIPE_GT] = ACTIONS(966),
    [anon_sym_COLON] = ACTIONS(966),
    [sym_break] = ACTIONS(966),
    [sym_next] = ACTIONS(966),
    [sym_true] = ACTIONS(966),
    [sym_false] = ACTIONS(966),
    [sym_null] = ACTIONS(966),
    [sym_inf] = ACTIONS(966),
    [sym_nan] = ACTIONS(966),
    [anon_sym_NA] = ACTIONS(966),
    [anon_sym_NA_character_] = ACTIONS(966),
    [anon_sym_NA_complex_] = ACTIONS(966),
    [anon_sym_NA_integer_] = ACTIONS(966),
    [anon_sym_NA_real_] = ACTIONS(966),
    [aux_sym_identifier_token1] = ACTIONS(966),
    [anon_sym_BQUOTE] = ACTIONS(966),
    [sym_integer] = ACTIONS(966),
    [sym_float] = ACTIONS(966),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(966),
    [anon_sym_SQUOTE] = ACTIONS(966),
    [anon_sym_PERCENT] = ACTIONS(966),
  },
  [369] = {
    [ts_builtin_sym_end] = ACTIONS(960),
    [anon_sym_LF] = ACTIONS(962),
    [anon_sym_SEMI] = ACTIONS(962),
    [anon_sym_function] = ACTIONS(962),
    [anon_sym_if] = ACTIONS(962),
    [anon_sym_LPAREN] = ACTIONS(962),
    [anon_sym_else] = ACTIONS(962),
    [anon_sym_while] = ACTIONS(962),
    [anon_sym_repeat] = ACTIONS(962),
    [anon_sym_for] = ACTIONS(962),
    [anon_sym_switch] = ACTIONS(962),
    [anon_sym_EQ] = ACTIONS(962),
    [anon_sym_LBRACE] = ACTIONS(962),
    [anon_sym_LT_DASH] = ACTIONS(962),
    [anon_sym_COLON_EQ] = ACTIONS(962),
    [anon_sym_LT_LT_DASH] = ACTIONS(962),
    [anon_sym_DASH_GT] = ACTIONS(962),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(962),
    [anon_sym_DOLLAR] = ACTIONS(962),
    [anon_sym_AT] = ACTIONS(962),
    [sym_dots] = ACTIONS(962),
    [anon_sym_DASH] = ACTIONS(962),
    [anon_sym_PLUS] = ACTIONS(962),
    [anon_sym_BANG] = ACTIONS(962),
    [anon_sym_TILDE] = ACTIONS(962),
    [anon_sym_STAR] = ACTIONS(962),
    [anon_sym_SLASH] = ACTIONS(962),
    [anon_sym_CARET] = ACTIONS(962),
    [anon_sym_LT] = ACTIONS(962),
    [anon_sym_GT] = ACTIONS(962),
    [anon_sym_LT_EQ] = ACTIONS(962),
    [anon_sym_GT_EQ] = ACTIONS(962),
    [anon_sym_EQ_EQ] = ACTIONS(962),
    [anon_sym_BANG_EQ] = ACTIONS(962),
    [anon_sym_PIPE_PIPE] = ACTIONS(962),
    [anon_sym_PIPE] = ACTIONS(962),
    [anon_sym_AMP_AMP] = ACTIONS(962),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_PIPE_GT] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(962),
    [sym_break] = ACTIONS(962),
    [sym_next] = ACTIONS(962),
    [sym_true] = ACTIONS(962),
    [sym_false] = ACTIONS(962),
    [sym_null] = ACTIONS(962),
    [sym_inf] = ACTIONS(962),
    [sym_nan] = ACTIONS(962),
    [anon_sym_NA] = ACTIONS(962),
    [anon_sym_NA_character_] = ACTIONS(962),
    [anon_sym_NA_complex_] = ACTIONS(962),
    [anon_sym_NA_integer_] = ACTIONS(962),
    [anon_sym_NA_real_] = ACTIONS(962),
    [aux_sym_identifier_token1] = ACTIONS(962),
    [anon_sym_BQUOTE] = ACTIONS(962),
    [sym_integer] = ACTIONS(962),
    [sym_float] = ACTIONS(962),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(962),
    [anon_sym_SQUOTE] = ACTIONS(962),
    [anon_sym_PERCENT] = ACTIONS(962),
  },
  [370] = {
    [ts_builtin_sym_end] = ACTIONS(956),
    [anon_sym_LF] = ACTIONS(958),
    [anon_sym_SEMI] = ACTIONS(958),
    [anon_sym_function] = ACTIONS(958),
    [anon_sym_if] = ACTIONS(958),
    [anon_sym_LPAREN] = ACTIONS(958),
    [anon_sym_else] = ACTIONS(958),
    [anon_sym_while] = ACTIONS(958),
    [anon_sym_repeat] = ACTIONS(958),
    [anon_sym_for] = ACTIONS(958),
    [anon_sym_switch] = ACTIONS(958),
    [anon_sym_EQ] = ACTIONS(958),
    [anon_sym_LBRACE] = ACTIONS(958),
    [anon_sym_LT_DASH] = ACTIONS(958),
    [anon_sym_COLON_EQ] = ACTIONS(958),
    [anon_sym_LT_LT_DASH] = ACTIONS(958),
    [anon_sym_DASH_GT] = ACTIONS(958),
    [anon_sym_LBRACK] = ACTIONS(958),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(958),
    [anon_sym_DOLLAR] = ACTIONS(958),
    [anon_sym_AT] = ACTIONS(958),
    [sym_dots] = ACTIONS(958),
    [anon_sym_DASH] = ACTIONS(958),
    [anon_sym_PLUS] = ACTIONS(958),
    [anon_sym_BANG] = ACTIONS(958),
    [anon_sym_TILDE] = ACTIONS(958),
    [anon_sym_STAR] = ACTIONS(958),
    [anon_sym_SLASH] = ACTIONS(958),
    [anon_sym_CARET] = ACTIONS(958),
    [anon_sym_LT] = ACTIONS(958),
    [anon_sym_GT] = ACTIONS(958),
    [anon_sym_LT_EQ] = ACTIONS(958),
    [anon_sym_GT_EQ] = ACTIONS(958),
    [anon_sym_EQ_EQ] = ACTIONS(958),
    [anon_sym_BANG_EQ] = ACTIONS(958),
    [anon_sym_PIPE_PIPE] = ACTIONS(958),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(958),
    [anon_sym_AMP] = ACTIONS(958),
    [anon_sym_PIPE_GT] = ACTIONS(958),
    [anon_sym_COLON] = ACTIONS(958),
    [sym_break] = ACTIONS(958),
    [sym_next] = ACTIONS(958),
    [sym_true] = ACTIONS(958),
    [sym_false] = ACTIONS(958),
    [sym_null] = ACTIONS(958),
    [sym_inf] = ACTIONS(958),
    [sym_nan] = ACTIONS(958),
    [anon_sym_NA] = ACTIONS(958),
    [anon_sym_NA_character_] = ACTIONS(958),
    [anon_sym_NA_complex_] = ACTIONS(958),
    [anon_sym_NA_integer_] = ACTIONS(958),
    [anon_sym_NA_real_] = ACTIONS(958),
    [aux_sym_identifier_token1] = ACTIONS(958),
    [anon_sym_BQUOTE] = ACTIONS(958),
    [sym_integer] = ACTIONS(958),
    [sym_float] = ACTIONS(958),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(958),
    [anon_sym_SQUOTE] = ACTIONS(958),
    [anon_sym_PERCENT] = ACTIONS(958),
  },
  [371] = {
    [sym_function_definition] = STATE(844),
    [sym_if] = STATE(844),
    [sym_while] = STATE(844),
    [sym_repeat] = STATE(844),
    [sym_for] = STATE(844),
    [sym_switch] = STATE(844),
    [sym_call] = STATE(844),
    [sym__assignment] = STATE(844),
    [sym_left_assignment] = STATE(844),
    [sym_left_assignment2] = STATE(844),
    [sym_equals_assignment] = STATE(844),
    [sym_super_assignment] = STATE(844),
    [sym_right_assignment] = STATE(844),
    [sym_brace_list] = STATE(844),
    [sym_paren_list] = STATE(844),
    [sym_subset] = STATE(844),
    [sym_subset2] = STATE(844),
    [sym_dollar] = STATE(844),
    [sym_slot] = STATE(844),
    [sym_namespace_get] = STATE(844),
    [sym_namespace_get_internal] = STATE(844),
    [sym_unary] = STATE(844),
    [sym_binary] = STATE(844),
    [sym_na] = STATE(844),
    [sym__expression] = STATE(844),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(844),
    [sym_string] = STATE(844),
    [anon_sym_SEMI] = ACTIONS(1458),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1460),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1460),
    [sym_next] = ACTIONS(1460),
    [sym_true] = ACTIONS(1460),
    [sym_false] = ACTIONS(1460),
    [sym_null] = ACTIONS(1460),
    [sym_inf] = ACTIONS(1460),
    [sym_nan] = ACTIONS(1460),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1458),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [372] = {
    [ts_builtin_sym_end] = ACTIONS(333),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_while] = ACTIONS(335),
    [anon_sym_repeat] = ACTIONS(335),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(335),
    [anon_sym_LT_DASH] = ACTIONS(335),
    [anon_sym_COLON_EQ] = ACTIONS(335),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(335),
    [sym_dots] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(335),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE_GT] = ACTIONS(335),
    [anon_sym_COLON] = ACTIONS(335),
    [sym_break] = ACTIONS(335),
    [sym_next] = ACTIONS(335),
    [sym_true] = ACTIONS(335),
    [sym_false] = ACTIONS(335),
    [sym_null] = ACTIONS(335),
    [sym_inf] = ACTIONS(335),
    [sym_nan] = ACTIONS(335),
    [anon_sym_NA] = ACTIONS(335),
    [anon_sym_NA_character_] = ACTIONS(335),
    [anon_sym_NA_complex_] = ACTIONS(335),
    [anon_sym_NA_integer_] = ACTIONS(335),
    [anon_sym_NA_real_] = ACTIONS(335),
    [aux_sym_identifier_token1] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(335),
    [anon_sym_i] = ACTIONS(1462),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [anon_sym_SQUOTE] = ACTIONS(335),
    [anon_sym_PERCENT] = ACTIONS(335),
  },
  [373] = {
    [sym_function_definition] = STATE(775),
    [sym_if] = STATE(775),
    [sym_while] = STATE(775),
    [sym_repeat] = STATE(775),
    [sym_for] = STATE(775),
    [sym_switch] = STATE(775),
    [sym_call] = STATE(775),
    [sym__assignment] = STATE(775),
    [sym_left_assignment] = STATE(775),
    [sym_left_assignment2] = STATE(775),
    [sym_equals_assignment] = STATE(775),
    [sym_super_assignment] = STATE(775),
    [sym_right_assignment] = STATE(775),
    [sym_brace_list] = STATE(775),
    [sym_paren_list] = STATE(775),
    [sym_subset] = STATE(775),
    [sym_subset2] = STATE(775),
    [sym_dollar] = STATE(775),
    [sym_slot] = STATE(775),
    [sym_namespace_get] = STATE(775),
    [sym_namespace_get_internal] = STATE(775),
    [sym_unary] = STATE(775),
    [sym_binary] = STATE(775),
    [sym_na] = STATE(775),
    [sym__expression] = STATE(775),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(775),
    [sym_string] = STATE(775),
    [anon_sym_SEMI] = ACTIONS(1464),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1466),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1466),
    [sym_next] = ACTIONS(1466),
    [sym_true] = ACTIONS(1466),
    [sym_false] = ACTIONS(1466),
    [sym_null] = ACTIONS(1466),
    [sym_inf] = ACTIONS(1466),
    [sym_nan] = ACTIONS(1466),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1464),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [374] = {
    [sym_function_definition] = STATE(781),
    [sym_if] = STATE(781),
    [sym_while] = STATE(781),
    [sym_repeat] = STATE(781),
    [sym_for] = STATE(781),
    [sym_switch] = STATE(781),
    [sym_call] = STATE(781),
    [sym__assignment] = STATE(781),
    [sym_left_assignment] = STATE(781),
    [sym_left_assignment2] = STATE(781),
    [sym_equals_assignment] = STATE(781),
    [sym_super_assignment] = STATE(781),
    [sym_right_assignment] = STATE(781),
    [sym_brace_list] = STATE(781),
    [sym_paren_list] = STATE(781),
    [sym_subset] = STATE(781),
    [sym_subset2] = STATE(781),
    [sym_dollar] = STATE(781),
    [sym_slot] = STATE(781),
    [sym_namespace_get] = STATE(781),
    [sym_namespace_get_internal] = STATE(781),
    [sym_unary] = STATE(781),
    [sym_binary] = STATE(781),
    [sym_na] = STATE(781),
    [sym__expression] = STATE(781),
    [sym_identifier] = STATE(111),
    [sym_complex] = STATE(781),
    [sym_string] = STATE(781),
    [anon_sym_SEMI] = ACTIONS(1468),
    [anon_sym_function] = ACTIONS(1094),
    [anon_sym_if] = ACTIONS(1096),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1100),
    [anon_sym_for] = ACTIONS(1102),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1470),
    [anon_sym_DASH] = ACTIONS(1106),
    [anon_sym_PLUS] = ACTIONS(1106),
    [anon_sym_BANG] = ACTIONS(1108),
    [anon_sym_TILDE] = ACTIONS(1110),
    [sym_break] = ACTIONS(1470),
    [sym_next] = ACTIONS(1470),
    [sym_true] = ACTIONS(1470),
    [sym_false] = ACTIONS(1470),
    [sym_null] = ACTIONS(1470),
    [sym_inf] = ACTIONS(1470),
    [sym_nan] = ACTIONS(1470),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1468),
    [sym_float] = ACTIONS(1112),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [375] = {
    [ts_builtin_sym_end] = ACTIONS(946),
    [anon_sym_LF] = ACTIONS(948),
    [anon_sym_SEMI] = ACTIONS(948),
    [anon_sym_function] = ACTIONS(948),
    [anon_sym_if] = ACTIONS(948),
    [anon_sym_LPAREN] = ACTIONS(948),
    [anon_sym_else] = ACTIONS(948),
    [anon_sym_while] = ACTIONS(948),
    [anon_sym_repeat] = ACTIONS(948),
    [anon_sym_for] = ACTIONS(948),
    [anon_sym_switch] = ACTIONS(948),
    [anon_sym_EQ] = ACTIONS(948),
    [anon_sym_LBRACE] = ACTIONS(948),
    [anon_sym_LT_DASH] = ACTIONS(948),
    [anon_sym_COLON_EQ] = ACTIONS(948),
    [anon_sym_LT_LT_DASH] = ACTIONS(948),
    [anon_sym_DASH_GT] = ACTIONS(948),
    [anon_sym_LBRACK] = ACTIONS(948),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(948),
    [anon_sym_DOLLAR] = ACTIONS(948),
    [anon_sym_AT] = ACTIONS(948),
    [sym_dots] = ACTIONS(948),
    [anon_sym_DASH] = ACTIONS(948),
    [anon_sym_PLUS] = ACTIONS(948),
    [anon_sym_BANG] = ACTIONS(948),
    [anon_sym_TILDE] = ACTIONS(948),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(948),
    [anon_sym_LT] = ACTIONS(948),
    [anon_sym_GT] = ACTIONS(948),
    [anon_sym_LT_EQ] = ACTIONS(948),
    [anon_sym_GT_EQ] = ACTIONS(948),
    [anon_sym_EQ_EQ] = ACTIONS(948),
    [anon_sym_BANG_EQ] = ACTIONS(948),
    [anon_sym_PIPE_PIPE] = ACTIONS(948),
    [anon_sym_PIPE] = ACTIONS(948),
    [anon_sym_AMP_AMP] = ACTIONS(948),
    [anon_sym_AMP] = ACTIONS(948),
    [anon_sym_PIPE_GT] = ACTIONS(948),
    [anon_sym_COLON] = ACTIONS(948),
    [sym_break] = ACTIONS(948),
    [sym_next] = ACTIONS(948),
    [sym_true] = ACTIONS(948),
    [sym_false] = ACTIONS(948),
    [sym_null] = ACTIONS(948),
    [sym_inf] = ACTIONS(948),
    [sym_nan] = ACTIONS(948),
    [anon_sym_NA] = ACTIONS(948),
    [anon_sym_NA_character_] = ACTIONS(948),
    [anon_sym_NA_complex_] = ACTIONS(948),
    [anon_sym_NA_integer_] = ACTIONS(948),
    [anon_sym_NA_real_] = ACTIONS(948),
    [aux_sym_identifier_token1] = ACTIONS(948),
    [anon_sym_BQUOTE] = ACTIONS(948),
    [sym_integer] = ACTIONS(948),
    [sym_float] = ACTIONS(948),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(948),
    [anon_sym_SQUOTE] = ACTIONS(948),
    [anon_sym_PERCENT] = ACTIONS(948),
  },
  [376] = {
    [sym_special] = STATE(554),
    [ts_builtin_sym_end] = ACTIONS(1472),
    [anon_sym_LF] = ACTIONS(1474),
    [anon_sym_SEMI] = ACTIONS(1476),
    [anon_sym_function] = ACTIONS(1479),
    [anon_sym_if] = ACTIONS(1479),
    [anon_sym_LPAREN] = ACTIONS(1481),
    [anon_sym_while] = ACTIONS(1479),
    [anon_sym_repeat] = ACTIONS(1479),
    [anon_sym_for] = ACTIONS(1479),
    [anon_sym_switch] = ACTIONS(1479),
    [anon_sym_EQ] = ACTIONS(1483),
    [anon_sym_LBRACE] = ACTIONS(1479),
    [anon_sym_LT_DASH] = ACTIONS(1485),
    [anon_sym_COLON_EQ] = ACTIONS(1487),
    [anon_sym_LT_LT_DASH] = ACTIONS(1489),
    [anon_sym_DASH_GT] = ACTIONS(1491),
    [anon_sym_LBRACK] = ACTIONS(1493),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1495),
    [anon_sym_DOLLAR] = ACTIONS(1497),
    [anon_sym_AT] = ACTIONS(1499),
    [sym_dots] = ACTIONS(1479),
    [anon_sym_DASH] = ACTIONS(1501),
    [anon_sym_PLUS] = ACTIONS(1501),
    [anon_sym_BANG] = ACTIONS(1479),
    [anon_sym_TILDE] = ACTIONS(1503),
    [anon_sym_STAR] = ACTIONS(1505),
    [anon_sym_SLASH] = ACTIONS(1505),
    [anon_sym_CARET] = ACTIONS(1507),
    [anon_sym_LT] = ACTIONS(1509),
    [anon_sym_GT] = ACTIONS(1509),
    [anon_sym_LT_EQ] = ACTIONS(1509),
    [anon_sym_GT_EQ] = ACTIONS(1509),
    [anon_sym_EQ_EQ] = ACTIONS(1509),
    [anon_sym_BANG_EQ] = ACTIONS(1509),
    [anon_sym_PIPE_PIPE] = ACTIONS(1511),
    [anon_sym_PIPE] = ACTIONS(1511),
    [anon_sym_AMP_AMP] = ACTIONS(1513),
    [anon_sym_AMP] = ACTIONS(1513),
    [anon_sym_PIPE_GT] = ACTIONS(1515),
    [anon_sym_COLON] = ACTIONS(1517),
    [sym_break] = ACTIONS(1479),
    [sym_next] = ACTIONS(1479),
    [sym_true] = ACTIONS(1479),
    [sym_false] = ACTIONS(1479),
    [sym_null] = ACTIONS(1479),
    [sym_inf] = ACTIONS(1479),
    [sym_nan] = ACTIONS(1479),
    [anon_sym_NA] = ACTIONS(1479),
    [anon_sym_NA_character_] = ACTIONS(1479),
    [anon_sym_NA_complex_] = ACTIONS(1479),
    [anon_sym_NA_integer_] = ACTIONS(1479),
    [anon_sym_NA_real_] = ACTIONS(1479),
    [aux_sym_identifier_token1] = ACTIONS(1479),
    [anon_sym_BQUOTE] = ACTIONS(1479),
    [sym_integer] = ACTIONS(1479),
    [sym_float] = ACTIONS(1479),
    [sym_comment] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(1479),
    [anon_sym_SQUOTE] = ACTIONS(1479),
    [anon_sym_PERCENT] = ACTIONS(786),
  },
  [377] = {
    [sym_function_definition] = STATE(760),
    [sym_if] = STATE(760),
    [sym_while] = STATE(760),
    [sym_repeat] = STATE(760),
    [sym_for] = STATE(760),
    [sym_switch] = STATE(760),
    [sym_call] = STATE(760),
    [sym__assignment] = STATE(760),
    [sym_left_assignment] = STATE(760),
    [sym_left_assignment2] = STATE(760),
    [sym_equals_assignment] = STATE(760),
    [sym_super_assignment] = STATE(760),
    [sym_right_assignment] = STATE(760),
    [sym_brace_list] = STATE(760),
    [sym_paren_list] = STATE(760),
    [sym_subset] = STATE(760),
    [sym_subset2] = STATE(760),
    [sym_dollar] = STATE(760),
    [sym_slot] = STATE(760),
    [sym_namespace_get] = STATE(760),
    [sym_namespace_get_internal] = STATE(760),
    [sym_unary] = STATE(760),
    [sym_binary] = STATE(760),
    [sym_na] = STATE(760),
    [sym__expression] = STATE(760),
    [sym_identifier] = STATE(745),
    [sym_complex] = STATE(760),
    [sym_string] = STATE(760),
    [anon_sym_SEMI] = ACTIONS(1519),
    [anon_sym_function] = ACTIONS(1521),
    [anon_sym_if] = ACTIONS(1523),
    [anon_sym_LPAREN] = ACTIONS(1525),
    [anon_sym_while] = ACTIONS(1527),
    [anon_sym_repeat] = ACTIONS(1529),
    [anon_sym_for] = ACTIONS(1531),
    [anon_sym_switch] = ACTIONS(1533),
    [anon_sym_LBRACE] = ACTIONS(1535),
    [sym_dots] = ACTIONS(1537),
    [anon_sym_DASH] = ACTIONS(1539),
    [anon_sym_PLUS] = ACTIONS(1539),
    [anon_sym_BANG] = ACTIONS(1541),
    [anon_sym_TILDE] = ACTIONS(1543),
    [sym_break] = ACTIONS(1537),
    [sym_next] = ACTIONS(1537),
    [sym_true] = ACTIONS(1537),
    [sym_false] = ACTIONS(1537),
    [sym_null] = ACTIONS(1537),
    [sym_inf] = ACTIONS(1537),
    [sym_nan] = ACTIONS(1537),
    [anon_sym_NA] = ACTIONS(1545),
    [anon_sym_NA_character_] = ACTIONS(1545),
    [anon_sym_NA_complex_] = ACTIONS(1545),
    [anon_sym_NA_integer_] = ACTIONS(1545),
    [anon_sym_NA_real_] = ACTIONS(1545),
    [aux_sym_identifier_token1] = ACTIONS(1547),
    [anon_sym_BQUOTE] = ACTIONS(1549),
    [sym_integer] = ACTIONS(1519),
    [sym_float] = ACTIONS(1551),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1553),
    [anon_sym_SQUOTE] = ACTIONS(1555),
  },
  [378] = {
    [sym_function_definition] = STATE(261),
    [sym_if] = STATE(261),
    [sym_while] = STATE(261),
    [sym_repeat] = STATE(261),
    [sym_for] = STATE(261),
    [sym_switch] = STATE(261),
    [sym_call] = STATE(261),
    [sym__assignment] = STATE(261),
    [sym_left_assignment] = STATE(261),
    [sym_left_assignment2] = STATE(261),
    [sym_equals_assignment] = STATE(261),
    [sym_super_assignment] = STATE(261),
    [sym_right_assignment] = STATE(261),
    [sym_brace_list] = STATE(261),
    [sym_paren_list] = STATE(261),
    [sym_subset] = STATE(261),
    [sym_subset2] = STATE(261),
    [sym_dollar] = STATE(261),
    [sym_slot] = STATE(261),
    [sym_namespace_get] = STATE(261),
    [sym_namespace_get_internal] = STATE(261),
    [sym_unary] = STATE(261),
    [sym_binary] = STATE(261),
    [sym_na] = STATE(261),
    [sym__expression] = STATE(261),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(261),
    [sym_string] = STATE(261),
    [anon_sym_SEMI] = ACTIONS(1557),
    [anon_sym_function] = ACTIONS(1418),
    [anon_sym_if] = ACTIONS(1420),
    [anon_sym_LPAREN] = ACTIONS(1422),
    [anon_sym_while] = ACTIONS(1424),
    [anon_sym_repeat] = ACTIONS(1426),
    [anon_sym_for] = ACTIONS(1428),
    [anon_sym_switch] = ACTIONS(1430),
    [anon_sym_LBRACE] = ACTIONS(1432),
    [sym_dots] = ACTIONS(1559),
    [anon_sym_DASH] = ACTIONS(1436),
    [anon_sym_PLUS] = ACTIONS(1436),
    [anon_sym_BANG] = ACTIONS(1438),
    [anon_sym_TILDE] = ACTIONS(1440),
    [sym_break] = ACTIONS(1559),
    [sym_next] = ACTIONS(1559),
    [sym_true] = ACTIONS(1559),
    [sym_false] = ACTIONS(1559),
    [sym_null] = ACTIONS(1559),
    [sym_inf] = ACTIONS(1559),
    [sym_nan] = ACTIONS(1559),
    [anon_sym_NA] = ACTIONS(1442),
    [anon_sym_NA_character_] = ACTIONS(1442),
    [anon_sym_NA_complex_] = ACTIONS(1442),
    [anon_sym_NA_integer_] = ACTIONS(1442),
    [anon_sym_NA_real_] = ACTIONS(1442),
    [aux_sym_identifier_token1] = ACTIONS(1444),
    [anon_sym_BQUOTE] = ACTIONS(1446),
    [sym_integer] = ACTIONS(1557),
    [sym_float] = ACTIONS(1448),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1450),
    [anon_sym_SQUOTE] = ACTIONS(1452),
  },
  [379] = {
    [sym_function_definition] = STATE(142),
    [sym_if] = STATE(142),
    [sym_while] = STATE(142),
    [sym_repeat] = STATE(142),
    [sym_for] = STATE(142),
    [sym_switch] = STATE(142),
    [sym_call] = STATE(142),
    [sym__assignment] = STATE(142),
    [sym_left_assignment] = STATE(142),
    [sym_left_assignment2] = STATE(142),
    [sym_equals_assignment] = STATE(142),
    [sym_super_assignment] = STATE(142),
    [sym_right_assignment] = STATE(142),
    [sym_brace_list] = STATE(142),
    [sym_paren_list] = STATE(142),
    [sym_subset] = STATE(142),
    [sym_subset2] = STATE(142),
    [sym_dollar] = STATE(142),
    [sym_slot] = STATE(142),
    [sym_namespace_get] = STATE(142),
    [sym_namespace_get_internal] = STATE(142),
    [sym_unary] = STATE(142),
    [sym_binary] = STATE(142),
    [sym_na] = STATE(142),
    [sym__expression] = STATE(142),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(142),
    [sym_string] = STATE(142),
    [anon_sym_SEMI] = ACTIONS(1561),
    [anon_sym_function] = ACTIONS(1418),
    [anon_sym_if] = ACTIONS(1420),
    [anon_sym_LPAREN] = ACTIONS(1422),
    [anon_sym_while] = ACTIONS(1424),
    [anon_sym_repeat] = ACTIONS(1426),
    [anon_sym_for] = ACTIONS(1428),
    [anon_sym_switch] = ACTIONS(1430),
    [anon_sym_LBRACE] = ACTIONS(1432),
    [sym_dots] = ACTIONS(1563),
    [anon_sym_DASH] = ACTIONS(1436),
    [anon_sym_PLUS] = ACTIONS(1436),
    [anon_sym_BANG] = ACTIONS(1438),
    [anon_sym_TILDE] = ACTIONS(1440),
    [sym_break] = ACTIONS(1563),
    [sym_next] = ACTIONS(1563),
    [sym_true] = ACTIONS(1563),
    [sym_false] = ACTIONS(1563),
    [sym_null] = ACTIONS(1563),
    [sym_inf] = ACTIONS(1563),
    [sym_nan] = ACTIONS(1563),
    [anon_sym_NA] = ACTIONS(1442),
    [anon_sym_NA_character_] = ACTIONS(1442),
    [anon_sym_NA_complex_] = ACTIONS(1442),
    [anon_sym_NA_integer_] = ACTIONS(1442),
    [anon_sym_NA_real_] = ACTIONS(1442),
    [aux_sym_identifier_token1] = ACTIONS(1444),
    [anon_sym_BQUOTE] = ACTIONS(1446),
    [sym_integer] = ACTIONS(1561),
    [sym_float] = ACTIONS(1448),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1450),
    [anon_sym_SQUOTE] = ACTIONS(1452),
  },
  [380] = {
    [sym_function_definition] = STATE(257),
    [sym_if] = STATE(257),
    [sym_while] = STATE(257),
    [sym_repeat] = STATE(257),
    [sym_for] = STATE(257),
    [sym_switch]