#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1074
#define LARGE_STATE_COUNT 741
#define SYMBOL_COUNT 116
#define ALIAS_COUNT 0
#define TOKEN_COUNT 74
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 18

enum {
  anon_sym_LF = 1,
  anon_sym_SEMI = 2,
  anon_sym_function = 3,
  anon_sym_if = 4,
  anon_sym_LPAREN = 5,
  anon_sym_RPAREN = 6,
  anon_sym_else = 7,
  anon_sym_while = 8,
  anon_sym_repeat = 9,
  anon_sym_for = 10,
  anon_sym_in = 11,
  anon_sym_switch = 12,
  anon_sym_COMMA = 13,
  anon_sym_EQ = 14,
  anon_sym_LBRACE = 15,
  anon_sym_RBRACE = 16,
  anon_sym_LT_DASH = 17,
  anon_sym_COLON_EQ = 18,
  anon_sym_LT_LT_DASH = 19,
  anon_sym_DASH_GT = 20,
  anon_sym_LBRACK = 21,
  anon_sym_RBRACK = 22,
  anon_sym_LBRACK_LBRACK = 23,
  anon_sym_RBRACK_RBRACK = 24,
  anon_sym_DOLLAR = 25,
  anon_sym_AT = 26,
  anon_sym_COLON_COLON = 27,
  anon_sym_COLON_COLON_COLON = 28,
  sym_dots = 29,
  anon_sym_DASH = 30,
  anon_sym_PLUS = 31,
  anon_sym_BANG = 32,
  anon_sym_TILDE = 33,
  anon_sym_STAR = 34,
  anon_sym_SLASH = 35,
  anon_sym_CARET = 36,
  anon_sym_LT = 37,
  anon_sym_GT = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_EQ_EQ = 41,
  anon_sym_BANG_EQ = 42,
  anon_sym_PIPE_PIPE = 43,
  anon_sym_PIPE = 44,
  anon_sym_AMP_AMP = 45,
  anon_sym_AMP = 46,
  anon_sym_COLON = 47,
  sym_break = 48,
  sym_next = 49,
  sym_true = 50,
  sym_false = 51,
  sym_null = 52,
  sym_inf = 53,
  sym_nan = 54,
  anon_sym_NA = 55,
  anon_sym_NA_character_ = 56,
  anon_sym_NA_complex_ = 57,
  anon_sym_NA_integer_ = 58,
  anon_sym_NA_real_ = 59,
  aux_sym_identifier_token1 = 60,
  anon_sym_BQUOTE = 61,
  aux_sym_identifier_token2 = 62,
  sym_integer = 63,
  sym_float = 64,
  anon_sym_i = 65,
  sym_comment = 66,
  anon_sym_DQUOTE = 67,
  aux_sym_string_token1 = 68,
  anon_sym_SQUOTE = 69,
  aux_sym_string_token2 = 70,
  anon_sym_PERCENT = 71,
  aux_sym_special_token1 = 72,
  sym_escape_sequence = 73,
  sym_program = 74,
  sym_function_definition = 75,
  sym_if = 76,
  sym_while = 77,
  sym_repeat = 78,
  sym_for = 79,
  sym_switch = 80,
  sym_formal_parameters = 81,
  sym__formal_parameter = 82,
  sym_arguments = 83,
  sym__argument = 84,
  sym_call = 85,
  sym__assignment = 86,
  sym_left_assignment = 87,
  sym_left_assignment2 = 88,
  sym_equals_assignment = 89,
  sym_super_assignment = 90,
  sym_right_assignment = 91,
  sym_brace_list = 92,
  sym_paren_list = 93,
  sym_subset = 94,
  sym_subset2 = 95,
  sym_dollar = 96,
  sym_slot = 97,
  sym_namespace_get = 98,
  sym_namespace_get_internal = 99,
  sym_unary = 100,
  sym_binary = 101,
  sym_na = 102,
  sym__expression = 103,
  sym_identifier = 104,
  sym_complex = 105,
  sym_string = 106,
  sym_special = 107,
  aux_sym_program_repeat1 = 108,
  aux_sym_formal_parameters_repeat1 = 109,
  aux_sym_block_repeat1 = 110,
  aux_sym_arguments_repeat1 = 111,
  aux_sym_identifier_repeat1 = 112,
  aux_sym_string_repeat1 = 113,
  aux_sym_string_repeat2 = 114,
  aux_sym_special_repeat1 = 115,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_if] = "if",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_switch] = "switch",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [sym_dots] = "dots",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP] = "&",
  [anon_sym_COLON] = ":",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_character_] = "NA_character_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [aux_sym_identifier_token1] = "identifier_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_identifier_token2] = "identifier_token2",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_i] = "i",
  [sym_comment] = "comment",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_PERCENT] = "%",
  [aux_sym_special_token1] = "special_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_if] = "if",
  [sym_while] = "while",
  [sym_repeat] = "repeat",
  [sym_for] = "for",
  [sym_switch] = "switch",
  [sym_formal_parameters] = "formal_parameters",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_arguments] = "arguments",
  [sym__argument] = "_argument",
  [sym_call] = "call",
  [sym__assignment] = "_assignment",
  [sym_left_assignment] = "left_assignment",
  [sym_left_assignment2] = "left_assignment2",
  [sym_equals_assignment] = "equals_assignment",
  [sym_super_assignment] = "super_assignment",
  [sym_right_assignment] = "right_assignment",
  [sym_brace_list] = "brace_list",
  [sym_paren_list] = "paren_list",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_dollar] = "dollar",
  [sym_slot] = "slot",
  [sym_namespace_get] = "namespace_get",
  [sym_namespace_get_internal] = "namespace_get_internal",
  [sym_unary] = "unary",
  [sym_binary] = "binary",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym_identifier] = "identifier",
  [sym_complex] = "complex",
  [sym_string] = "string",
  [sym_special] = "special",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_special_repeat1] = "special_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [sym_dots] = sym_dots,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_i] = anon_sym_i,
  [sym_comment] = sym_comment,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_special_token1] = aux_sym_special_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_if] = sym_if,
  [sym_while] = sym_while,
  [sym_repeat] = sym_repeat,
  [sym_for] = sym_for,
  [sym_switch] = sym_switch,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_arguments] = sym_arguments,
  [sym__argument] = sym__argument,
  [sym_call] = sym_call,
  [sym__assignment] = sym__assignment,
  [sym_left_assignment] = sym_left_assignment,
  [sym_left_assignment2] = sym_left_assignment2,
  [sym_equals_assignment] = sym_equals_assignment,
  [sym_super_assignment] = sym_super_assignment,
  [sym_right_assignment] = sym_right_assignment,
  [sym_brace_list] = sym_brace_list,
  [sym_paren_list] = sym_paren_list,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_dollar] = sym_dollar,
  [sym_slot] = sym_slot,
  [sym_namespace_get] = sym_namespace_get,
  [sym_namespace_get_internal] = sym_namespace_get_internal,
  [sym_unary] = sym_unary,
  [sym_binary] = sym_binary,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym_identifier] = sym_identifier,
  [sym_complex] = sym_complex,
  [sym_string] = sym_string,
  [sym_special] = sym_special,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_special_repeat1] = aux_sym_special_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_special_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_left_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_left_assignment2] = {
    .visible = true,
    .named = true,
  },
  [sym_equals_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_list] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_list] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_slot] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get_internal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_special] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_special_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_function = 6,
  field_left = 7,
  field_name = 8,
  field_namespace = 9,
  field_operand = 10,
  field_operator = 11,
  field_right = 12,
  field_value = 13,
  field_vector = 14,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_value] = "value",
  [field_vector] = "vector",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 3},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 1},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 4},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 2},
  [15] = {.index = 27, .length = 2},
  [16] = {.index = 29, .length = 4},
  [17] = {.index = 33, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 1},
  [1] =
    {field_operand, 1},
    {field_operator, 0},
  [3] =
    {field_function, 0},
  [4] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [6] =
    {field_value, 0},
  [7] =
    {field_name, 0},
    {field_value, 2},
  [9] =
    {field_name, 2},
    {field_value, 0},
  [11] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [14] =
    {field_function, 2},
    {field_namespace, 0},
  [16] =
    {field_name, 0},
  [17] =
    {field_arguments, 2},
    {field_function, 0},
  [19] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [23] =
    {field_condition, 2},
    {field_consequence, 4},
  [25] =
    {field_body, 4},
    {field_condition, 2},
  [27] =
    {field_body, 4},
    {field_value, 2},
  [29] =
    {field_alternative, 5},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [33] =
    {field_body, 6},
    {field_name, 2},
    {field_vector, 4},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(54);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(38);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\r') ADVANCE(221);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\r') ADVANCE(222);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\r') ADVANCE(223);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\r') ADVANCE(224);
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(213);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '\r') ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(195);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(195);
      if (lookahead == '\r') ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(217);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '\r') ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(210);
      if (lookahead != 0) ADVANCE(211);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(210);
      if (lookahead != 0) ADVANCE(211);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(215);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(215);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(214);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(196);
      if (lookahead != 0) ADVANCE(197);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(196);
      if (lookahead != 0) ADVANCE(197);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(219);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(219);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(218);
      if (lookahead != 0) ADVANCE(219);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(205);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(74);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 33:
      if (lookahead == ']') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 40:
      if (lookahead == '}') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 41:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(220);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 48:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 49:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 50:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 51:
      if (eof) ADVANCE(54);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 52:
      if (eof) ADVANCE(54);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 53:
      if (eof) ADVANCE(54);
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '"') ADVANCE(208);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(216);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(86);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(169);
      if (lookahead == 'N') ADVANCE(120);
      if (lookahead == 'T') ADVANCE(127);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '`') ADVANCE(194);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(154);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(144);
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 'w') ADVANCE(158);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(55);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '0') ADVANCE(200);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(78);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(83);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_dots);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(75);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(100);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_break);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_next);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_inf);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_nan);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(139);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(123);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(111);
      if (lookahead == 'U') ADVANCE(125);
      if (lookahead == 'a') ADVANCE(126);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(106);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(107);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(128);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(108);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(124);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N') ADVANCE(110);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R') ADVANCE(129);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S') ADVANCE(122);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U') ADVANCE(121);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(115);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(113);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(112);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(163);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(181);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(165);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(184);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(142);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(172);
      if (lookahead == 'r') ADVANCE(152);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(157);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(186);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(188);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(190);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(176);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(134);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(63);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(156);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(191);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(109);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'g') ADVANCE(151);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(67);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(161);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(135);
      if (lookahead == 'o') ADVANCE(168);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(174);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(166);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(185);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'k') ADVANCE(104);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(182);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(130);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(147);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(149);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'm') ADVANCE(175);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(155);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(141);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(187);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(177);
      if (lookahead == 'u') ADVANCE(170);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(171);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(167);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(150);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(65);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(132);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(138);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(146);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(105);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(64);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(140);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(160);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(153);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'w') ADVANCE(162);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(183);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(131);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '`') ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == 'L') ADVANCE(198);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == 'L') ADVANCE(198);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(44);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'L') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_i);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(210);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(211);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(214);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(215);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(aux_sym_special_token1);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead == '#') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(218);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%') ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(213);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(195);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(217);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(220);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(225);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 53},
  [2] = {.lex_state = 53},
  [3] = {.lex_state = 53},
  [4] = {.lex_state = 24},
  [5] = {.lex_state = 24},
  [6] = {.lex_state = 53},
  [7] = {.lex_state = 53},
  [8] = {.lex_state = 24},
  [9] = {.lex_state = 24},
  [10] = {.lex_state = 53},
  [11] = {.lex_state = 53},
  [12] = {.lex_state = 53},
  [13] = {.lex_state = 53},
  [14] = {.lex_state = 24},
  [15] = {.lex_state = 24},
  [16] = {.lex_state = 24},
  [17] = {.lex_state = 53},
  [18] = {.lex_state = 24},
  [19] = {.lex_state = 53},
  [20] = {.lex_state = 53},
  [21] = {.lex_state = 53},
  [22] = {.lex_state = 53},
  [23] = {.lex_state = 53},
  [24] = {.lex_state = 53},
  [25] = {.lex_state = 53},
  [26] = {.lex_state = 24},
  [27] = {.lex_state = 53},
  [28] = {.lex_state = 53},
  [29] = {.lex_state = 53},
  [30] = {.lex_state = 53},
  [31] = {.lex_state = 24},
  [32] = {.lex_state = 53},
  [33] = {.lex_state = 53},
  [34] = {.lex_state = 24},
  [35] = {.lex_state = 53},
  [36] = {.lex_state = 53},
  [37] = {.lex_state = 53},
  [38] = {.lex_state = 53},
  [39] = {.lex_state = 53},
  [40] = {.lex_state = 53},
  [41] = {.lex_state = 53},
  [42] = {.lex_state = 53},
  [43] = {.lex_state = 53},
  [44] = {.lex_state = 53},
  [45] = {.lex_state = 53},
  [46] = {.lex_state = 53},
  [47] = {.lex_state = 53},
  [48] = {.lex_state = 53},
  [49] = {.lex_state = 53},
  [50] = {.lex_state = 53},
  [51] = {.lex_state = 53},
  [52] = {.lex_state = 53},
  [53] = {.lex_state = 53},
  [54] = {.lex_state = 53},
  [55] = {.lex_state = 53},
  [56] = {.lex_state = 53},
  [57] = {.lex_state = 53},
  [58] = {.lex_state = 53},
  [59] = {.lex_state = 53},
  [60] = {.lex_state = 53},
  [61] = {.lex_state = 53},
  [62] = {.lex_state = 53},
  [63] = {.lex_state = 53},
  [64] = {.lex_state = 53},
  [65] = {.lex_state = 53},
  [66] = {.lex_state = 53},
  [67] = {.lex_state = 53},
  [68] = {.lex_state = 53},
  [69] = {.lex_state = 53},
  [70] = {.lex_state = 53},
  [71] = {.lex_state = 53},
  [72] = {.lex_state = 53},
  [73] = {.lex_state = 53},
  [74] = {.lex_state = 53},
  [75] = {.lex_state = 53},
  [76] = {.lex_state = 53},
  [77] = {.lex_state = 53},
  [78] = {.lex_state = 53},
  [79] = {.lex_state = 53},
  [80] = {.lex_state = 53},
  [81] = {.lex_state = 24},
  [82] = {.lex_state = 53},
  [83] = {.lex_state = 21},
  [84] = {.lex_state = 21},
  [85] = {.lex_state = 21},
  [86] = {.lex_state = 53},
  [87] = {.lex_state = 21},
  [88] = {.lex_state = 21},
  [89] = {.lex_state = 21},
  [90] = {.lex_state = 21},
  [91] = {.lex_state = 53},
  [92] = {.lex_state = 21},
  [93] = {.lex_state = 21},
  [94] = {.lex_state = 21},
  [95] = {.lex_state = 21},
  [96] = {.lex_state = 21},
  [97] = {.lex_state = 21},
  [98] = {.lex_state = 21},
  [99] = {.lex_state = 21},
  [100] = {.lex_state = 21},
  [101] = {.lex_state = 48},
  [102] = {.lex_state = 21},
  [103] = {.lex_state = 48},
  [104] = {.lex_state = 48},
  [105] = {.lex_state = 53},
  [106] = {.lex_state = 21},
  [107] = {.lex_state = 48},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 21},
  [110] = {.lex_state = 48},
  [111] = {.lex_state = 48},
  [112] = {.lex_state = 21},
  [113] = {.lex_state = 21},
  [114] = {.lex_state = 21},
  [115] = {.lex_state = 21},
  [116] = {.lex_state = 21},
  [117] = {.lex_state = 48},
  [118] = {.lex_state = 48},
  [119] = {.lex_state = 21},
  [120] = {.lex_state = 21},
  [121] = {.lex_state = 21},
  [122] = {.lex_state = 23},
  [123] = {.lex_state = 23},
  [124] = {.lex_state = 23},
  [125] = {.lex_state = 53},
  [126] = {.lex_state = 23},
  [127] = {.lex_state = 21},
  [128] = {.lex_state = 53},
  [129] = {.lex_state = 53},
  [130] = {.lex_state = 53},
  [131] = {.lex_state = 53},
  [132] = {.lex_state = 53},
  [133] = {.lex_state = 53},
  [134] = {.lex_state = 53},
  [135] = {.lex_state = 53},
  [136] = {.lex_state = 48},
  [137] = {.lex_state = 53},
  [138] = {.lex_state = 53},
  [139] = {.lex_state = 53},
  [140] = {.lex_state = 53},
  [141] = {.lex_state = 53},
  [142] = {.lex_state = 53},
  [143] = {.lex_state = 53},
  [144] = {.lex_state = 53},
  [145] = {.lex_state = 53},
  [146] = {.lex_state = 53},
  [147] = {.lex_state = 53},
  [148] = {.lex_state = 53},
  [149] = {.lex_state = 53},
  [150] = {.lex_state = 53},
  [151] = {.lex_state = 53},
  [152] = {.lex_state = 53},
  [153] = {.lex_state = 53},
  [154] = {.lex_state = 22},
  [155] = {.lex_state = 53},
  [156] = {.lex_state = 53},
  [157] = {.lex_state = 53},
  [158] = {.lex_state = 53},
  [159] = {.lex_state = 53},
  [160] = {.lex_state = 53},
  [161] = {.lex_state = 53},
  [162] = {.lex_state = 53},
  [163] = {.lex_state = 53},
  [164] = {.lex_state = 53},
  [165] = {.lex_state = 53},
  [166] = {.lex_state = 53},
  [167] = {.lex_state = 53},
  [168] = {.lex_state = 53},
  [169] = {.lex_state = 53},
  [170] = {.lex_state = 53},
  [171] = {.lex_state = 53},
  [172] = {.lex_state = 53},
  [173] = {.lex_state = 53},
  [174] = {.lex_state = 53},
  [175] = {.lex_state = 53},
  [176] = {.lex_state = 53},
  [177] = {.lex_state = 53},
  [178] = {.lex_state = 53},
  [179] = {.lex_state = 53},
  [180] = {.lex_state = 53},
  [181] = {.lex_state = 53},
  [182] = {.lex_state = 53},
  [183] = {.lex_state = 53},
  [184] = {.lex_state = 53},
  [185] = {.lex_state = 53},
  [186] = {.lex_state = 53},
  [187] = {.lex_state = 53},
  [188] = {.lex_state = 53},
  [189] = {.lex_state = 53},
  [190] = {.lex_state = 53},
  [191] = {.lex_state = 53},
  [192] = {.lex_state = 53},
  [193] = {.lex_state = 53},
  [194] = {.lex_state = 53},
  [195] = {.lex_state = 53},
  [196] = {.lex_state = 24},
  [197] = {.lex_state = 53},
  [198] = {.lex_state = 53},
  [199] = {.lex_state = 53},
  [200] = {.lex_state = 53},
  [201] = {.lex_state = 53},
  [202] = {.lex_state = 53},
  [203] = {.lex_state = 53},
  [204] = {.lex_state = 23},
  [205] = {.lex_state = 53},
  [206] = {.lex_state = 53},
  [207] = {.lex_state = 53},
  [208] = {.lex_state = 53},
  [209] = {.lex_state = 53},
  [210] = {.lex_state = 53},
  [211] = {.lex_state = 53},
  [212] = {.lex_state = 53},
  [213] = {.lex_state = 53},
  [214] = {.lex_state = 53},
  [215] = {.lex_state = 53},
  [216] = {.lex_state = 53},
  [217] = {.lex_state = 53},
  [218] = {.lex_state = 53},
  [219] = {.lex_state = 53},
  [220] = {.lex_state = 49},
  [221] = {.lex_state = 53},
  [222] = {.lex_state = 53},
  [223] = {.lex_state = 49},
  [224] = {.lex_state = 53},
  [225] = {.lex_state = 53},
  [226] = {.lex_state = 53},
  [227] = {.lex_state = 53},
  [228] = {.lex_state = 53},
  [229] = {.lex_state = 53},
  [230] = {.lex_state = 53},
  [231] = {.lex_state = 53},
  [232] = {.lex_state = 53},
  [233] = {.lex_state = 53},
  [234] = {.lex_state = 53},
  [235] = {.lex_state = 53},
  [236] = {.lex_state = 53},
  [237] = {.lex_state = 49},
  [238] = {.lex_state = 53},
  [239] = {.lex_state = 49},
  [240] = {.lex_state = 53},
  [241] = {.lex_state = 53},
  [242] = {.lex_state = 53},
  [243] = {.lex_state = 53},
  [244] = {.lex_state = 49},
  [245] = {.lex_state = 53},
  [246] = {.lex_state = 53},
  [247] = {.lex_state = 49},
  [248] = {.lex_state = 53},
  [249] = {.lex_state = 53},
  [250] = {.lex_state = 53},
  [251] = {.lex_state = 53},
  [252] = {.lex_state = 53},
  [253] = {.lex_state = 53},
  [254] = {.lex_state = 53},
  [255] = {.lex_state = 53},
  [256] = {.lex_state = 53},
  [257] = {.lex_state = 53},
  [258] = {.lex_state = 53},
  [259] = {.lex_state = 53},
  [260] = {.lex_state = 53},
  [261] = {.lex_state = 53},
  [262] = {.lex_state = 53},
  [263] = {.lex_state = 53},
  [264] = {.lex_state = 53},
  [265] = {.lex_state = 53},
  [266] = {.lex_state = 53},
  [267] = {.lex_state = 53},
  [268] = {.lex_state = 53},
  [269] = {.lex_state = 53},
  [270] = {.lex_state = 53},
  [271] = {.lex_state = 49},
  [272] = {.lex_state = 53},
  [273] = {.lex_state = 53},
  [274] = {.lex_state = 53},
  [275] = {.lex_state = 53},
  [276] = {.lex_state = 53},
  [277] = {.lex_state = 53},
  [278] = {.lex_state = 53},
  [279] = {.lex_state = 53},
  [280] = {.lex_state = 53},
  [281] = {.lex_state = 53},
  [282] = {.lex_state = 53},
  [283] = {.lex_state = 53},
  [284] = {.lex_state = 53},
  [285] = {.lex_state = 53},
  [286] = {.lex_state = 53},
  [287] = {.lex_state = 53},
  [288] = {.lex_state = 53},
  [289] = {.lex_state = 53},
  [290] = {.lex_state = 53},
  [291] = {.lex_state = 53},
  [292] = {.lex_state = 53},
  [293] = {.lex_state = 53},
  [294] = {.lex_state = 53},
  [295] = {.lex_state = 53},
  [296] = {.lex_state = 53},
  [297] = {.lex_state = 53},
  [298] = {.lex_state = 48},
  [299] = {.lex_state = 53},
  [300] = {.lex_state = 53},
  [301] = {.lex_state = 53},
  [302] = {.lex_state = 53},
  [303] = {.lex_state = 53},
  [304] = {.lex_state = 53},
  [305] = {.lex_state = 53},
  [306] = {.lex_state = 53},
  [307] = {.lex_state = 53},
  [308] = {.lex_state = 53},
  [309] = {.lex_state = 53},
  [310] = {.lex_state = 53},
  [311] = {.lex_state = 53},
  [312] = {.lex_state = 53},
  [313] = {.lex_state = 53},
  [314] = {.lex_state = 53},
  [315] = {.lex_state = 48},
  [316] = {.lex_state = 53},
  [317] = {.lex_state = 48},
  [318] = {.lex_state = 48},
  [319] = {.lex_state = 48},
  [320] = {.lex_state = 53},
  [321] = {.lex_state = 53},
  [322] = {.lex_state = 53},
  [323] = {.lex_state = 53},
  [324] = {.lex_state = 53},
  [325] = {.lex_state = 53},
  [326] = {.lex_state = 53},
  [327] = {.lex_state = 53},
  [328] = {.lex_state = 53},
  [329] = {.lex_state = 53},
  [330] = {.lex_state = 53},
  [331] = {.lex_state = 53},
  [332] = {.lex_state = 53},
  [333] = {.lex_state = 53},
  [334] = {.lex_state = 53},
  [335] = {.lex_state = 53},
  [336] = {.lex_state = 53},
  [337] = {.lex_state = 53},
  [338] = {.lex_state = 53},
  [339] = {.lex_state = 53},
  [340] = {.lex_state = 53},
  [341] = {.lex_state = 53},
  [342] = {.lex_state = 53},
  [343] = {.lex_state = 53},
  [344] = {.lex_state = 53},
  [345] = {.lex_state = 53},
  [346] = {.lex_state = 53},
  [347] = {.lex_state = 53},
  [348] = {.lex_state = 53},
  [349] = {.lex_state = 53},
  [350] = {.lex_state = 53},
  [351] = {.lex_state = 53},
  [352] = {.lex_state = 53},
  [353] = {.lex_state = 53},
  [354] = {.lex_state = 53},
  [355] = {.lex_state = 53},
  [356] = {.lex_state = 53},
  [357] = {.lex_state = 53},
  [358] = {.lex_state = 48},
  [359] = {.lex_state = 53},
  [360] = {.lex_state = 53},
  [361] = {.lex_state = 53},
  [362] = {.lex_state = 53},
  [363] = {.lex_state = 48},
  [364] = {.lex_state = 53},
  [365] = {.lex_state = 23},
  [366] = {.lex_state = 23},
  [367] = {.lex_state = 53},
  [368] = {.lex_state = 23},
  [369] = {.lex_state = 23},
  [370] = {.lex_state = 23},
  [371] = {.lex_state = 23},
  [372] = {.lex_state = 23},
  [373] = {.lex_state = 53},
  [374] = {.lex_state = 53},
  [375] = {.lex_state = 23},
  [376] = {.lex_state = 23},
  [377] = {.lex_state = 23},
  [378] = {.lex_state = 53},
  [379] = {.lex_state = 53},
  [380] = {.lex_state = 53},
  [381] = {.lex_state = 53},
  [382] = {.lex_state = 21},
  [383] = {.lex_state = 23},
  [384] = {.lex_state = 50},
  [385] = {.lex_state = 23},
  [386] = {.lex_state = 53},
  [387] = {.lex_state = 21},
  [388] = {.lex_state = 53},
  [389] = {.lex_state = 21},
  [390] = {.lex_state = 23},
  [391] = {.lex_state = 23},
  [392] = {.lex_state = 23},
  [393] = {.lex_state = 23},
  [394] = {.lex_state = 21},
  [395] = {.lex_state = 21},
  [396] = {.lex_state = 53},
  [397] = {.lex_state = 53},
  [398] = {.lex_state = 53},
  [399] = {.lex_state = 53},
  [400] = {.lex_state = 53},
  [401] = {.lex_state = 23},
  [402] = {.lex_state = 23},
  [403] = {.lex_state = 53},
  [404] = {.lex_state = 53},
  [405] = {.lex_state = 53},
  [406] = {.lex_state = 53},
  [407] = {.lex_state = 53},
  [408] = {.lex_state = 53},
  [409] = {.lex_state = 53},
  [410] = {.lex_state = 53},
  [411] = {.lex_state = 53},
  [412] = {.lex_state = 49},
  [413] = {.lex_state = 23},
  [414] = {.lex_state = 23},
  [415] = {.lex_state = 21},
  [416] = {.lex_state = 21},
  [417] = {.lex_state = 23},
  [418] = {.lex_state = 21},
  [419] = {.lex_state = 21},
  [420] = {.lex_state = 23},
  [421] = {.lex_state = 25},
  [422] = {.lex_state = 48},
  [423] = {.lex_state = 48},
  [424] = {.lex_state = 53},
  [425] = {.lex_state = 21},
  [426] = {.lex_state = 21},
  [427] = {.lex_state = 21},
  [428] = {.lex_state = 21},
  [429] = {.lex_state = 53},
  [430] = {.lex_state = 48},
  [431] = {.lex_state = 53},
  [432] = {.lex_state = 48},
  [433] = {.lex_state = 48},
  [434] = {.lex_state = 48},
  [435] = {.lex_state = 48},
  [436] = {.lex_state = 48},
  [437] = {.lex_state = 48},
  [438] = {.lex_state = 21},
  [439] = {.lex_state = 21},
  [440] = {.lex_state = 53},
  [441] = {.lex_state = 21},
  [442] = {.lex_state = 21},
  [443] = {.lex_state = 21},
  [444] = {.lex_state = 23},
  [445] = {.lex_state = 48},
  [446] = {.lex_state = 53},
  [447] = {.lex_state = 53},
  [448] = {.lex_state = 21},
  [449] = {.lex_state = 48},
  [450] = {.lex_state = 48},
  [451] = {.lex_state = 48},
  [452] = {.lex_state = 48},
  [453] = {.lex_state = 48},
  [454] = {.lex_state = 48},
  [455] = {.lex_state = 53},
  [456] = {.lex_state = 48},
  [457] = {.lex_state = 48},
  [458] = {.lex_state = 24},
  [459] = {.lex_state = 48},
  [460] = {.lex_state = 48},
  [461] = {.lex_state = 48},
  [462] = {.lex_state = 48},
  [463] = {.lex_state = 53},
  [464] = {.lex_state = 53},
  [465] = {.lex_state = 53},
  [466] = {.lex_state = 53},
  [467] = {.lex_state = 53},
  [468] = {.lex_state = 53},
  [469] = {.lex_state = 53},
  [470] = {.lex_state = 53},
  [471] = {.lex_state = 53},
  [472] = {.lex_state = 53},
  [473] = {.lex_state = 53},
  [474] = {.lex_state = 53},
  [475] = {.lex_state = 53},
  [476] = {.lex_state = 53},
  [477] = {.lex_state = 53},
  [478] = {.lex_state = 53},
  [479] = {.lex_state = 48},
  [480] = {.lex_state = 53},
  [481] = {.lex_state = 53},
  [482] = {.lex_state = 53},
  [483] = {.lex_state = 53},
  [484] = {.lex_state = 53},
  [485] = {.lex_state = 48},
  [486] = {.lex_state = 48},
  [487] = {.lex_state = 48},
  [488] = {.lex_state = 48},
  [489] = {.lex_state = 48},
  [490] = {.lex_state = 53},
  [491] = {.lex_state = 53},
  [492] = {.lex_state = 53},
  [493] = {.lex_state = 53},
  [494] = {.lex_state = 48},
  [495] = {.lex_state = 48},
  [496] = {.lex_state = 48},
  [497] = {.lex_state = 48},
  [498] = {.lex_state = 48},
  [499] = {.lex_state = 48},
  [500] = {.lex_state = 48},
  [501] = {.lex_state = 48},
  [502] = {.lex_state = 48},
  [503] = {.lex_state = 24},
  [504] = {.lex_state = 53},
  [505] = {.lex_state = 53},
  [506] = {.lex_state = 24},
  [507] = {.lex_state = 24},
  [508] = {.lex_state = 53},
  [509] = {.lex_state = 48},
  [510] = {.lex_state = 53},
  [511] = {.lex_state = 53},
  [512] = {.lex_state = 53},
  [513] = {.lex_state = 48},
  [514] = {.lex_state = 48},
  [515] = {.lex_state = 53},
  [516] = {.lex_state = 53},
  [517] = {.lex_state = 50},
  [518] = {.lex_state = 53},
  [519] = {.lex_state = 53},
  [520] = {.lex_state = 53},
  [521] = {.lex_state = 53},
  [522] = {.lex_state = 53},
  [523] = {.lex_state = 53},
  [524] = {.lex_state = 53},
  [525] = {.lex_state = 53},
  [526] = {.lex_state = 53},
  [527] = {.lex_state = 53},
  [528] = {.lex_state = 53},
  [529] = {.lex_state = 53},
  [530] = {.lex_state = 53},
  [531] = {.lex_state = 53},
  [532] = {.lex_state = 48},
  [533] = {.lex_state = 48},
  [534] = {.lex_state = 49},
  [535] = {.lex_state = 49},
  [536] = {.lex_state = 49},
  [537] = {.lex_state = 53},
  [538] = {.lex_state = 49},
  [539] = {.lex_state = 53},
  [540] = {.lex_state = 49},
  [541] = {.lex_state = 53},
  [542] = {.lex_state = 53},
  [543] = {.lex_state = 49},
  [544] = {.lex_state = 53},
  [545] = {.lex_state = 53},
  [546] = {.lex_state = 53},
  [547] = {.lex_state = 53},
  [548] = {.lex_state = 53},
  [549] = {.lex_state = 24},
  [550] = {.lex_state = 53},
  [551] = {.lex_state = 53},
  [552] = {.lex_state = 53},
  [553] = {.lex_state = 53},
  [554] = {.lex_state = 53},
  [555] = {.lex_state = 53},
  [556] = {.lex_state = 53},
  [557] = {.lex_state = 53},
  [558] = {.lex_state = 49},
  [559] = {.lex_state = 49},
  [560] = {.lex_state = 49},
  [561] = {.lex_state = 49},
  [562] = {.lex_state = 49},
  [563] = {.lex_state = 49},
  [564] = {.lex_state = 51},
  [565] = {.lex_state = 49},
  [566] = {.lex_state = 53},
  [567] = {.lex_state = 24},
  [568] = {.lex_state = 53},
  [569] = {.lex_state = 51},
  [570] = {.lex_state = 49},
  [571] = {.lex_state = 49},
  [572] = {.lex_state = 49},
  [573] = {.lex_state = 49},
  [574] = {.lex_state = 49},
  [575] = {.lex_state = 48},
  [576] = {.lex_state = 49},
  [577] = {.lex_state = 49},
  [578] = {.lex_state = 49},
  [579] = {.lex_state = 53},
  [580] = {.lex_state = 48},
  [581] = {.lex_state = 49},
  [582] = {.lex_state = 48},
  [583] = {.lex_state = 48},
  [584] = {.lex_state = 49},
  [585] = {.lex_state = 24},
  [586] = {.lex_state = 49},
  [587] = {.lex_state = 24},
  [588] = {.lex_state = 24},
  [589] = {.lex_state = 24},
  [590] = {.lex_state = 48},
  [591] = {.lex_state = 49},
  [592] = {.lex_state = 49},
  [593] = {.lex_state = 48},
  [594] = {.lex_state = 48},
  [595] = {.lex_state = 48},
  [596] = {.lex_state = 48},
  [597] = {.lex_state = 48},
  [598] = {.lex_state = 48},
  [599] = {.lex_state = 48},
  [600] = {.lex_state = 49},
  [601] = {.lex_state = 49},
  [602] = {.lex_state = 49},
  [603] = {.lex_state = 49},
  [604] = {.lex_state = 48},
  [605] = {.lex_state = 48},
  [606] = {.lex_state = 48},
  [607] = {.lex_state = 48},
  [608] = {.lex_state = 49},
  [609] = {.lex_state = 49},
  [610] = {.lex_state = 49},
  [611] = {.lex_state = 49},
  [612] = {.lex_state = 49},
  [613] = {.lex_state = 48},
  [614] = {.lex_state = 48},
  [615] = {.lex_state = 49},
  [616] = {.lex_state = 49},
  [617] = {.lex_state = 49},
  [618] = {.lex_state = 49},
  [619] = {.lex_state = 49},
  [620] = {.lex_state = 49},
  [621] = {.lex_state = 49},
  [622] = {.lex_state = 48},
  [623] = {.lex_state = 24},
  [624] = {.lex_state = 24},
  [625] = {.lex_state = 24},
  [626] = {.lex_state = 24},
  [627] = {.lex_state = 24},
  [628] = {.lex_state = 24},
  [629] = {.lex_state = 24},
  [630] = {.lex_state = 24},
  [631] = {.lex_state = 48},
  [632] = {.lex_state = 48},
  [633] = {.lex_state = 24},
  [634] = {.lex_state = 48},
  [635] = {.lex_state = 48},
  [636] = {.lex_state = 48},
  [637] = {.lex_state = 24},
  [638] = {.lex_state = 24},
  [639] = {.lex_state = 24},
  [640] = {.lex_state = 48},
  [641] = {.lex_state = 24},
  [642] = {.lex_state = 24},
  [643] = {.lex_state = 23},
  [644] = {.lex_state = 48},
  [645] = {.lex_state = 24},
  [646] = {.lex_state = 48},
  [647] = {.lex_state = 23},
  [648] = {.lex_state = 24},
  [649] = {.lex_state = 23},
  [650] = {.lex_state = 24},
  [651] = {.lex_state = 48},
  [652] = {.lex_state = 24},
  [653] = {.lex_state = 48},
  [654] = {.lex_state = 23},
  [655] = {.lex_state = 23},
  [656] = {.lex_state = 48},
  [657] = {.lex_state = 23},
  [658] = {.lex_state = 23},
  [659] = {.lex_state = 48},
  [660] = {.lex_state = 23},
  [661] = {.lex_state = 23},
  [662] = {.lex_state = 23},
  [663] = {.lex_state = 23},
  [664] = {.lex_state = 23},
  [665] = {.lex_state = 23},
  [666] = {.lex_state = 23},
  [667] = {.lex_state = 23},
  [668] = {.lex_state = 23},
  [669] = {.lex_state = 23},
  [670] = {.lex_state = 23},
  [671] = {.lex_state = 23},
  [672] = {.lex_state = 26},
  [673] = {.lex_state = 49},
  [674] = {.lex_state = 49},
  [675] = {.lex_state = 49},
  [676] = {.lex_state = 48},
  [677] = {.lex_state = 48},
  [678] = {.lex_state = 48},
  [679] = {.lex_state = 48},
  [680] = {.lex_state = 48},
  [681] = {.lex_state = 49},
  [682] = {.lex_state = 49},
  [683] = {.lex_state = 49},
  [684] = {.lex_state = 24},
  [685] = {.lex_state = 49},
  [686] = {.lex_state = 49},
  [687] = {.lex_state = 49},
  [688] = {.lex_state = 24},
  [689] = {.lex_state = 49},
  [690] = {.lex_state = 49},
  [691] = {.lex_state = 49},
  [692] = {.lex_state = 49},
  [693] = {.lex_state = 49},
  [694] = {.lex_state = 49},
  [695] = {.lex_state = 49},
  [696] = {.lex_state = 24},
  [697] = {.lex_state = 24},
  [698] = {.lex_state = 24},
  [699] = {.lex_state = 24},
  [700] = {.lex_state = 24},
  [701] = {.lex_state = 24},
  [702] = {.lex_state = 24},
  [703] = {.lex_state = 49},
  [704] = {.lex_state = 49},
  [705] = {.lex_state = 49},
  [706] = {.lex_state = 49},
  [707] = {.lex_state = 24},
  [708] = {.lex_state = 49},
  [709] = {.lex_state = 49},
  [710] = {.lex_state = 24},
  [711] = {.lex_state = 49},
  [712] = {.lex_state = 49},
  [713] = {.lex_state = 24},
  [714] = {.lex_state = 49},
  [715] = {.lex_state = 49},
  [716] = {.lex_state = 49},
  [717] = {.lex_state = 24},
  [718] = {.lex_state = 24},
  [719] = {.lex_state = 49},
  [720] = {.lex_state = 24},
  [721] = {.lex_state = 49},
  [722] = {.lex_state = 24},
  [723] = {.lex_state = 49},
  [724] = {.lex_state = 49},
  [725] = {.lex_state = 49},
  [726] = {.lex_state = 49},
  [727] = {.lex_state = 49},
  [728] = {.lex_state = 24},
  [729] = {.lex_state = 24},
  [730] = {.lex_state = 24},
  [731] = {.lex_state = 49},
  [732] = {.lex_state = 24},
  [733] = {.lex_state = 49},
  [734] = {.lex_state = 49},
  [735] = {.lex_state = 49},
  [736] = {.lex_state = 53},
  [737] = {.lex_state = 49},
  [738] = {.lex_state = 49},
  [739] = {.lex_state = 49},
  [740] = {.lex_state = 49},
  [741] = {.lex_state = 53},
  [742] = {.lex_state = 27},
  [743] = {.lex_state = 24},
  [744] = {.lex_state = 27},
  [745] = {.lex_state = 27},
  [746] = {.lex_state = 53},
  [747] = {.lex_state = 27},
  [748] = {.lex_state = 53},
  [749] = {.lex_state = 27},
  [750] = {.lex_state = 27},
  [751] = {.lex_state = 27},
  [752] = {.lex_state = 27},
  [753] = {.lex_state = 27},
  [754] = {.lex_state = 27},
  [755] = {.lex_state = 27},
  [756] = {.lex_state = 53},
  [757] = {.lex_state = 27},
  [758] = {.lex_state = 53},
  [759] = {.lex_state = 27},
  [760] = {.lex_state = 53},
  [761] = {.lex_state = 53},
  [762] = {.lex_state = 27},
  [763] = {.lex_state = 27},
  [764] = {.lex_state = 27},
  [765] = {.lex_state = 27},
  [766] = {.lex_state = 27},
  [767] = {.lex_state = 27},
  [768] = {.lex_state = 27},
  [769] = {.lex_state = 53},
  [770] = {.lex_state = 27},
  [771] = {.lex_state = 27},
  [772] = {.lex_state = 27},
  [773] = {.lex_state = 27},
  [774] = {.lex_state = 27},
  [775] = {.lex_state = 27},
  [776] = {.lex_state = 53},
  [777] = {.lex_state = 28},
  [778] = {.lex_state = 27},
  [779] = {.lex_state = 27},
  [780] = {.lex_state = 27},
  [781] = {.lex_state = 27},
  [782] = {.lex_state = 27},
  [783] = {.lex_state = 27},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 27},
  [788] = {.lex_state = 27},
  [789] = {.lex_state = 27},
  [790] = {.lex_state = 27},
  [791] = {.lex_state = 28},
  [792] = {.lex_state = 27},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 27},
  [797] = {.lex_state = 27},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 27},
  [800] = {.lex_state = 27},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 27},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 27},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 27},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 27},
  [816] = {.lex_state = 27},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 27},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 29},
  [863] = {.lex_state = 29},
  [864] = {.lex_state = 29},
  [865] = {.lex_state = 29},
  [866] = {.lex_state = 30},
  [867] = {.lex_state = 30},
  [868] = {.lex_state = 30},
  [869] = {.lex_state = 30},
  [870] = {.lex_state = 30},
  [871] = {.lex_state = 30},
  [872] = {.lex_state = 30},
  [873] = {.lex_state = 30},
  [874] = {.lex_state = 30},
  [875] = {.lex_state = 13},
  [876] = {.lex_state = 16},
  [877] = {.lex_state = 18},
  [878] = {.lex_state = 13},
  [879] = {.lex_state = 16},
  [880] = {.lex_state = 18},
  [881] = {.lex_state = 13},
  [882] = {.lex_state = 16},
  [883] = {.lex_state = 13},
  [884] = {.lex_state = 18},
  [885] = {.lex_state = 13},
  [886] = {.lex_state = 16},
  [887] = {.lex_state = 18},
  [888] = {.lex_state = 18},
  [889] = {.lex_state = 13},
  [890] = {.lex_state = 16},
  [891] = {.lex_state = 18},
  [892] = {.lex_state = 13},
  [893] = {.lex_state = 16},
  [894] = {.lex_state = 13},
  [895] = {.lex_state = 16},
  [896] = {.lex_state = 18},
  [897] = {.lex_state = 16},
  [898] = {.lex_state = 16},
  [899] = {.lex_state = 18},
  [900] = {.lex_state = 18},
  [901] = {.lex_state = 16},
  [902] = {.lex_state = 18},
  [903] = {.lex_state = 13},
  [904] = {.lex_state = 13},
  [905] = {.lex_state = 20},
  [906] = {.lex_state = 16},
  [907] = {.lex_state = 13},
  [908] = {.lex_state = 13},
  [909] = {.lex_state = 16},
  [910] = {.lex_state = 13},
  [911] = {.lex_state = 18},
  [912] = {.lex_state = 20},
  [913] = {.lex_state = 18},
  [914] = {.lex_state = 16},
  [915] = {.lex_state = 18},
  [916] = {.lex_state = 16},
  [917] = {.lex_state = 20},
  [918] = {.lex_state = 13},
  [919] = {.lex_state = 16},
  [920] = {.lex_state = 13},
  [921] = {.lex_state = 18},
  [922] = {.lex_state = 13},
  [923] = {.lex_state = 16},
  [924] = {.lex_state = 18},
  [925] = {.lex_state = 18},
  [926] = {.lex_state = 18},
  [927] = {.lex_state = 13},
  [928] = {.lex_state = 16},
  [929] = {.lex_state = 13},
  [930] = {.lex_state = 16},
  [931] = {.lex_state = 18},
  [932] = {.lex_state = 13},
  [933] = {.lex_state = 16},
  [934] = {.lex_state = 18},
  [935] = {.lex_state = 30},
  [936] = {.lex_state = 30},
  [937] = {.lex_state = 30},
  [938] = {.lex_state = 30},
  [939] = {.lex_state = 30},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 30},
  [942] = {.lex_state = 30},
  [943] = {.lex_state = 30},
  [944] = {.lex_state = 30},
  [945] = {.lex_state = 30},
  [946] = {.lex_state = 30},
  [947] = {.lex_state = 30},
  [948] = {.lex_state = 30},
  [949] = {.lex_state = 30},
  [950] = {.lex_state = 30},
  [951] = {.lex_state = 30},
  [952] = {.lex_state = 30},
  [953] = {.lex_state = 30},
  [954] = {.lex_state = 30},
  [955] = {.lex_state = 30},
  [956] = {.lex_state = 30},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 30},
  [960] = {.lex_state = 30},
  [961] = {.lex_state = 30},
  [962] = {.lex_state = 30},
  [963] = {.lex_state = 30},
  [964] = {.lex_state = 30},
  [965] = {.lex_state = 30},
  [966] = {.lex_state = 30},
  [967] = {.lex_state = 30},
  [968] = {.lex_state = 30},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 30},
  [971] = {.lex_state = 30},
  [972] = {.lex_state = 30},
  [973] = {.lex_state = 30},
  [974] = {.lex_state = 30},
  [975] = {.lex_state = 30},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 24},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 27},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 24},
  [1002] = {.lex_state = 27},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 27},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 24},
  [1010] = {.lex_state = 27},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 24},
  [1014] = {.lex_state = 27},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 27},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 27},
  [1022] = {.lex_state = 27},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 27},
  [1027] = {.lex_state = 24},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 27},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 24},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 24},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 24},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 24},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1025),
    [sym_function_definition] = STATE(565),
    [sym_if] = STATE(565),
    [sym_while] = STATE(565),
    [sym_repeat] = STATE(565),
    [sym_for] = STATE(565),
    [sym_switch] = STATE(565),
    [sym_call] = STATE(565),
    [sym__assignment] = STATE(565),
    [sym_left_assignment] = STATE(565),
    [sym_left_assignment2] = STATE(565),
    [sym_equals_assignment] = STATE(565),
    [sym_super_assignment] = STATE(565),
    [sym_right_assignment] = STATE(565),
    [sym_brace_list] = STATE(565),
    [sym_paren_list] = STATE(565),
    [sym_subset] = STATE(565),
    [sym_subset2] = STATE(565),
    [sym_dollar] = STATE(565),
    [sym_slot] = STATE(565),
    [sym_namespace_get] = STATE(565),
    [sym_namespace_get_internal] = STATE(565),
    [sym_unary] = STATE(565),
    [sym_binary] = STATE(565),
    [sym_na] = STATE(565),
    [sym__expression] = STATE(565),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(565),
    [sym_string] = STATE(565),
    [aux_sym_program_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(25),
    [sym_next] = ACTIONS(25),
    [sym_true] = ACTIONS(25),
    [sym_false] = ACTIONS(25),
    [sym_null] = ACTIONS(25),
    [sym_inf] = ACTIONS(25),
    [sym_nan] = ACTIONS(25),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [2] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1036),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [3] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1003),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(89),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [4] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1009),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(111),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [5] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1051),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(135),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [6] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1042),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(137),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [7] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1033),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(139),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [8] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1027),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(141),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [9] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(987),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(143),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [10] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1017),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [11] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1055),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [12] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(12),
    [anon_sym_SEMI] = ACTIONS(149),
    [anon_sym_function] = ACTIONS(152),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_RPAREN] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(163),
    [anon_sym_repeat] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(172),
    [anon_sym_COMMA] = ACTIONS(175),
    [anon_sym_LBRACE] = ACTIONS(178),
    [anon_sym_RBRACK] = ACTIONS(161),
    [sym_dots] = ACTIONS(181),
    [anon_sym_DASH] = ACTIONS(184),
    [anon_sym_PLUS] = ACTIONS(184),
    [anon_sym_BANG] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(190),
    [sym_break] = ACTIONS(193),
    [sym_next] = ACTIONS(193),
    [sym_true] = ACTIONS(193),
    [sym_false] = ACTIONS(193),
    [sym_null] = ACTIONS(193),
    [sym_inf] = ACTIONS(193),
    [sym_nan] = ACTIONS(193),
    [anon_sym_NA] = ACTIONS(196),
    [anon_sym_NA_character_] = ACTIONS(196),
    [anon_sym_NA_complex_] = ACTIONS(196),
    [anon_sym_NA_integer_] = ACTIONS(196),
    [anon_sym_NA_real_] = ACTIONS(196),
    [aux_sym_identifier_token1] = ACTIONS(199),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [sym_integer] = ACTIONS(149),
    [sym_float] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(208),
    [anon_sym_SQUOTE] = ACTIONS(211),
  },
  [13] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1054),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(214),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [14] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1053),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(216),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [15] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1001),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(218),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [16] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1013),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(220),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [17] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(12),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(222),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(222),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [18] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1032),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(226),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [19] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1035),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(228),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [20] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1007),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(230),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [21] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(993),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(232),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [22] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1015),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(234),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [23] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(990),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(236),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [24] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1019),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [25] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1005),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(240),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [26] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_arguments] = STATE(1041),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(242),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [27] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1048),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(244),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [28] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1044),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACK] = ACTIONS(246),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [29] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1045),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [30] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1047),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [31] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(31),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_function] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_while] = ACTIONS(264),
    [anon_sym_repeat] = ACTIONS(267),
    [anon_sym_for] = ACTIONS(270),
    [anon_sym_switch] = ACTIONS(273),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(279),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(161),
    [sym_dots] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(285),
    [anon_sym_BANG] = ACTIONS(288),
    [anon_sym_TILDE] = ACTIONS(291),
    [sym_break] = ACTIONS(294),
    [sym_next] = ACTIONS(294),
    [sym_true] = ACTIONS(294),
    [sym_false] = ACTIONS(294),
    [sym_null] = ACTIONS(294),
    [sym_inf] = ACTIONS(294),
    [sym_nan] = ACTIONS(294),
    [anon_sym_NA] = ACTIONS(297),
    [anon_sym_NA_character_] = ACTIONS(297),
    [anon_sym_NA_complex_] = ACTIONS(297),
    [anon_sym_NA_integer_] = ACTIONS(297),
    [anon_sym_NA_real_] = ACTIONS(297),
    [aux_sym_identifier_token1] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(303),
    [sym_integer] = ACTIONS(252),
    [sym_float] = ACTIONS(306),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_SQUOTE] = ACTIONS(312),
  },
  [32] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1011),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [33] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1031),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [34] = {
    [sym_function_definition] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym__argument] = STATE(743),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(196),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(728),
    [aux_sym_arguments_repeat1] = STATE(31),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(109),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(222),
    [sym_dots] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(121),
    [sym_next] = ACTIONS(121),
    [sym_true] = ACTIONS(121),
    [sym_false] = ACTIONS(121),
    [sym_null] = ACTIONS(121),
    [sym_inf] = ACTIONS(121),
    [sym_nan] = ACTIONS(121),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(91),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [35] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1039),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [36] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(996),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [37] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(999),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [38] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1023),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [39] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(994),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [40] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1050),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [41] = {
    [sym_function_definition] = STATE(516),
    [sym_if] = STATE(516),
    [sym_while] = STATE(516),
    [sym_repeat] = STATE(516),
    [sym_for] = STATE(516),
    [sym_switch] = STATE(516),
    [sym_arguments] = STATE(1038),
    [sym__argument] = STATE(741),
    [sym_call] = STATE(516),
    [sym__assignment] = STATE(516),
    [sym_left_assignment] = STATE(516),
    [sym_left_assignment2] = STATE(516),
    [sym_equals_assignment] = STATE(516),
    [sym_super_assignment] = STATE(516),
    [sym_right_assignment] = STATE(516),
    [sym_brace_list] = STATE(516),
    [sym_paren_list] = STATE(516),
    [sym_subset] = STATE(516),
    [sym_subset2] = STATE(516),
    [sym_dollar] = STATE(516),
    [sym_slot] = STATE(516),
    [sym_namespace_get] = STATE(516),
    [sym_namespace_get_internal] = STATE(516),
    [sym_unary] = STATE(516),
    [sym_binary] = STATE(516),
    [sym_na] = STATE(516),
    [sym__expression] = STATE(516),
    [sym_identifier] = STATE(91),
    [sym_complex] = STATE(516),
    [sym_string] = STATE(566),
    [aux_sym_arguments_repeat1] = STATE(17),
    [anon_sym_SEMI] = ACTIONS(45),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(75),
    [sym_next] = ACTIONS(75),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_null] = ACTIONS(75),
    [sym_inf] = ACTIONS(75),
    [sym_nan] = ACTIONS(75),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(45),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [42] = {
    [sym_function_definition] = STATE(140),
    [sym_if] = STATE(140),
    [sym_while] = STATE(140),
    [sym_repeat] = STATE(140),
    [sym_for] = STATE(140),
    [sym_switch] = STATE(140),
    [sym_call] = STATE(140),
    [sym__assignment] = STATE(140),
    [sym_left_assignment] = STATE(140),
    [sym_left_assignment2] = STATE(140),
    [sym_equals_assignment] = STATE(140),
    [sym_super_assignment] = STATE(140),
    [sym_right_assignment] = STATE(140),
    [sym_brace_list] = STATE(140),
    [sym_paren_list] = STATE(140),
    [sym_subset] = STATE(140),
    [sym_subset2] = STATE(140),
    [sym_dollar] = STATE(140),
    [sym_slot] = STATE(140),
    [sym_namespace_get] = STATE(140),
    [sym_namespace_get_internal] = STATE(140),
    [sym_unary] = STATE(140),
    [sym_binary] = STATE(140),
    [sym_na] = STATE(140),
    [sym__expression] = STATE(140),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(140),
    [sym_string] = STATE(140),
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_RBRACK] = ACTIONS(317),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(317),
    [anon_sym_TILDE] = ACTIONS(317),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(317),
    [sym_integer] = ACTIONS(317),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
  },
  [43] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [44] = {
    [sym_function_definition] = STATE(565),
    [sym_if] = STATE(565),
    [sym_while] = STATE(565),
    [sym_repeat] = STATE(565),
    [sym_for] = STATE(565),
    [sym_switch] = STATE(565),
    [sym_call] = STATE(565),
    [sym__assignment] = STATE(565),
    [sym_left_assignment] = STATE(565),
    [sym_left_assignment2] = STATE(565),
    [sym_equals_assignment] = STATE(565),
    [sym_super_assignment] = STATE(565),
    [sym_right_assignment] = STATE(565),
    [sym_brace_list] = STATE(565),
    [sym_paren_list] = STATE(565),
    [sym_subset] = STATE(565),
    [sym_subset2] = STATE(565),
    [sym_dollar] = STATE(565),
    [sym_slot] = STATE(565),
    [sym_namespace_get] = STATE(565),
    [sym_namespace_get_internal] = STATE(565),
    [sym_unary] = STATE(565),
    [sym_binary] = STATE(565),
    [sym_na] = STATE(565),
    [sym__expression] = STATE(565),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(565),
    [sym_string] = STATE(565),
    [aux_sym_program_repeat1] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(327),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(338),
    [anon_sym_while] = ACTIONS(341),
    [anon_sym_repeat] = ACTIONS(344),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(350),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(356),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(365),
    [sym_break] = ACTIONS(356),
    [sym_next] = ACTIONS(356),
    [sym_true] = ACTIONS(356),
    [sym_false] = ACTIONS(356),
    [sym_null] = ACTIONS(356),
    [sym_inf] = ACTIONS(356),
    [sym_nan] = ACTIONS(356),
    [anon_sym_NA] = ACTIONS(368),
    [anon_sym_NA_character_] = ACTIONS(368),
    [anon_sym_NA_complex_] = ACTIONS(368),
    [anon_sym_NA_integer_] = ACTIONS(368),
    [anon_sym_NA_real_] = ACTIONS(368),
    [aux_sym_identifier_token1] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(380),
    [anon_sym_SQUOTE] = ACTIONS(383),
  },
  [45] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(71),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [46] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [47] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(408),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [48] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(430),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [49] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(47),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(432),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [50] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(434),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [51] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(48),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [52] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(438),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [53] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [54] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(52),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(442),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [55] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(53),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(444),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [56] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(446),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [57] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(448),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [58] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(56),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(450),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [59] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(57),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [60] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(454),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [61] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(456),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [62] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(60),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(458),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [63] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(61),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(460),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [64] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(462),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [65] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(64),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(464),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [66] = {
    [sym_function_definition] = STATE(565),
    [sym_if] = STATE(565),
    [sym_while] = STATE(565),
    [sym_repeat] = STATE(565),
    [sym_for] = STATE(565),
    [sym_switch] = STATE(565),
    [sym_call] = STATE(565),
    [sym__assignment] = STATE(565),
    [sym_left_assignment] = STATE(565),
    [sym_left_assignment2] = STATE(565),
    [sym_equals_assignment] = STATE(565),
    [sym_super_assignment] = STATE(565),
    [sym_right_assignment] = STATE(565),
    [sym_brace_list] = STATE(565),
    [sym_paren_list] = STATE(565),
    [sym_subset] = STATE(565),
    [sym_subset2] = STATE(565),
    [sym_dollar] = STATE(565),
    [sym_slot] = STATE(565),
    [sym_namespace_get] = STATE(565),
    [sym_namespace_get_internal] = STATE(565),
    [sym_unary] = STATE(565),
    [sym_binary] = STATE(565),
    [sym_na] = STATE(565),
    [sym__expression] = STATE(565),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(565),
    [sym_string] = STATE(565),
    [aux_sym_program_repeat1] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(25),
    [sym_next] = ACTIONS(25),
    [sym_true] = ACTIONS(25),
    [sym_false] = ACTIONS(25),
    [sym_null] = ACTIONS(25),
    [sym_inf] = ACTIONS(25),
    [sym_nan] = ACTIONS(25),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [67] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(43),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [68] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(470),
    [anon_sym_function] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_while] = ACTIONS(482),
    [anon_sym_repeat] = ACTIONS(485),
    [anon_sym_for] = ACTIONS(488),
    [anon_sym_switch] = ACTIONS(491),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(327),
    [sym_dots] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(506),
    [sym_break] = ACTIONS(497),
    [sym_next] = ACTIONS(497),
    [sym_true] = ACTIONS(497),
    [sym_false] = ACTIONS(497),
    [sym_null] = ACTIONS(497),
    [sym_inf] = ACTIONS(497),
    [sym_nan] = ACTIONS(497),
    [anon_sym_NA] = ACTIONS(509),
    [anon_sym_NA_character_] = ACTIONS(509),
    [anon_sym_NA_complex_] = ACTIONS(509),
    [anon_sym_NA_integer_] = ACTIONS(509),
    [anon_sym_NA_real_] = ACTIONS(509),
    [aux_sym_identifier_token1] = ACTIONS(512),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [sym_integer] = ACTIONS(470),
    [sym_float] = ACTIONS(518),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(521),
    [anon_sym_SQUOTE] = ACTIONS(524),
  },
  [69] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(50),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(527),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [70] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(46),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(529),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [71] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(531),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [72] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(533),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [73] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(535),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [74] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [75] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(542),
    [anon_sym_if] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(548),
    [anon_sym_RPAREN] = ACTIONS(551),
    [anon_sym_while] = ACTIONS(553),
    [anon_sym_repeat] = ACTIONS(556),
    [anon_sym_for] = ACTIONS(559),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_LBRACE] = ACTIONS(565),
    [sym_dots] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(571),
    [anon_sym_PLUS] = ACTIONS(571),
    [anon_sym_BANG] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(577),
    [sym_break] = ACTIONS(568),
    [sym_next] = ACTIONS(568),
    [sym_true] = ACTIONS(568),
    [sym_false] = ACTIONS(568),
    [sym_null] = ACTIONS(568),
    [sym_inf] = ACTIONS(568),
    [sym_nan] = ACTIONS(568),
    [anon_sym_NA] = ACTIONS(580),
    [anon_sym_NA_character_] = ACTIONS(580),
    [anon_sym_NA_complex_] = ACTIONS(580),
    [anon_sym_NA_integer_] = ACTIONS(580),
    [anon_sym_NA_real_] = ACTIONS(580),
    [aux_sym_identifier_token1] = ACTIONS(583),
    [anon_sym_BQUOTE] = ACTIONS(586),
    [sym_integer] = ACTIONS(539),
    [sym_float] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(592),
    [anon_sym_SQUOTE] = ACTIONS(595),
  },
  [76] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(73),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(598),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [77] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(74),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(600),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [78] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(602),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [79] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(75),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(604),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [80] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(78),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(606),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [81] = {
    [sym_function_definition] = STATE(567),
    [sym_if] = STATE(567),
    [sym_while] = STATE(567),
    [sym_repeat] = STATE(567),
    [sym_for] = STATE(567),
    [sym_switch] = STATE(567),
    [sym_call] = STATE(567),
    [sym__assignment] = STATE(567),
    [sym_left_assignment] = STATE(567),
    [sym_left_assignment2] = STATE(567),
    [sym_equals_assignment] = STATE(567),
    [sym_super_assignment] = STATE(567),
    [sym_right_assignment] = STATE(567),
    [sym_brace_list] = STATE(567),
    [sym_paren_list] = STATE(567),
    [sym_subset] = STATE(567),
    [sym_subset2] = STATE(567),
    [sym_dollar] = STATE(567),
    [sym_slot] = STATE(567),
    [sym_namespace_get] = STATE(567),
    [sym_namespace_get_internal] = STATE(567),
    [sym_unary] = STATE(567),
    [sym_binary] = STATE(567),
    [sym_na] = STATE(567),
    [sym__expression] = STATE(567),
    [sym_identifier] = STATE(506),
    [sym_complex] = STATE(567),
    [sym_string] = STATE(567),
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(319),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(319),
    [anon_sym_repeat] = ACTIONS(319),
    [anon_sym_for] = ACTIONS(319),
    [anon_sym_switch] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(317),
    [sym_dots] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(317),
    [anon_sym_TILDE] = ACTIONS(317),
    [sym_break] = ACTIONS(319),
    [sym_next] = ACTIONS(319),
    [sym_true] = ACTIONS(319),
    [sym_false] = ACTIONS(319),
    [sym_null] = ACTIONS(319),
    [sym_inf] = ACTIONS(319),
    [sym_nan] = ACTIONS(319),
    [anon_sym_NA] = ACTIONS(319),
    [anon_sym_NA_character_] = ACTIONS(319),
    [anon_sym_NA_complex_] = ACTIONS(319),
    [anon_sym_NA_integer_] = ACTIONS(319),
    [anon_sym_NA_real_] = ACTIONS(319),
    [aux_sym_identifier_token1] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(317),
    [sym_integer] = ACTIONS(317),
    [sym_float] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
  },
  [82] = {
    [sym_function_definition] = STATE(736),
    [sym_if] = STATE(736),
    [sym_while] = STATE(736),
    [sym_repeat] = STATE(736),
    [sym_for] = STATE(736),
    [sym_switch] = STATE(736),
    [sym_call] = STATE(736),
    [sym__assignment] = STATE(736),
    [sym_left_assignment] = STATE(736),
    [sym_left_assignment2] = STATE(736),
    [sym_equals_assignment] = STATE(736),
    [sym_super_assignment] = STATE(736),
    [sym_right_assignment] = STATE(736),
    [sym_brace_list] = STATE(736),
    [sym_paren_list] = STATE(736),
    [sym_subset] = STATE(736),
    [sym_subset2] = STATE(736),
    [sym_dollar] = STATE(736),
    [sym_slot] = STATE(736),
    [sym_namespace_get] = STATE(736),
    [sym_namespace_get_internal] = STATE(736),
    [sym_unary] = STATE(736),
    [sym_binary] = STATE(736),
    [sym_na] = STATE(736),
    [sym__expression] = STATE(736),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(736),
    [sym_string] = STATE(736),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(608),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(325),
    [sym_next] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_null] = ACTIONS(325),
    [sym_inf] = ACTIONS(325),
    [sym_nan] = ACTIONS(325),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(321),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [83] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_RBRACK] = ACTIONS(610),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_COLON_COLON] = ACTIONS(614),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(616),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [84] = {
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_RPAREN] = ACTIONS(618),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_COMMA] = ACTIONS(618),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_LT_DASH] = ACTIONS(618),
    [anon_sym_COLON_EQ] = ACTIONS(618),
    [anon_sym_LT_LT_DASH] = ACTIONS(618),
    [anon_sym_DASH_GT] = ACTIONS(618),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_RBRACK] = ACTIONS(618),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(618),
    [anon_sym_DOLLAR] = ACTIONS(618),
    [anon_sym_AT] = ACTIONS(618),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(618),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_STAR] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(618),
    [anon_sym_CARET] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(618),
    [anon_sym_GT_EQ] = ACTIONS(618),
    [anon_sym_EQ_EQ] = ACTIONS(618),
    [anon_sym_BANG_EQ] = ACTIONS(618),
    [anon_sym_PIPE_PIPE] = ACTIONS(618),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(618),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(618),
    [sym_integer] = ACTIONS(618),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(618),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [anon_sym_PERCENT] = ACTIONS(618),
  },
  [85] = {
    [anon_sym_SEMI] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_RPAREN] = ACTIONS(622),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_COMMA] = ACTIONS(622),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(622),
    [anon_sym_LT_DASH] = ACTIONS(622),
    [anon_sym_COLON_EQ] = ACTIONS(622),
    [anon_sym_LT_LT_DASH] = ACTIONS(622),
    [anon_sym_DASH_GT] = ACTIONS(622),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_RBRACK] = ACTIONS(622),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(622),
    [anon_sym_DOLLAR] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(622),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(622),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_STAR] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(622),
    [anon_sym_CARET] = ACTIONS(622),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(622),
    [anon_sym_GT_EQ] = ACTIONS(622),
    [anon_sym_EQ_EQ] = ACTIONS(622),
    [anon_sym_BANG_EQ] = ACTIONS(622),
    [anon_sym_PIPE_PIPE] = ACTIONS(622),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(622),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_integer] = ACTIONS(622),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(622),
    [anon_sym_SQUOTE] = ACTIONS(622),
    [anon_sym_PERCENT] = ACTIONS(622),
  },
  [86] = {
    [sym_function_definition] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [aux_sym_program_repeat1] = STATE(72),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(626),
    [sym_dots] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(410),
    [sym_next] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_null] = ACTIONS(410),
    [sym_inf] = ACTIONS(410),
    [sym_nan] = ACTIONS(410),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(390),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [87] = {
    [anon_sym_SEMI] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(628),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_repeat] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(628),
    [anon_sym_EQ] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_LT_DASH] = ACTIONS(628),
    [anon_sym_COLON_EQ] = ACTIONS(628),
    [anon_sym_LT_LT_DASH] = ACTIONS(628),
    [anon_sym_DASH_GT] = ACTIONS(628),
    [anon_sym_LBRACK] = ACTIONS(630),
    [anon_sym_RBRACK] = ACTIONS(628),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(628),
    [anon_sym_DOLLAR] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_COLON_COLON] = ACTIONS(630),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(628),
    [sym_dots] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(628),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(628),
    [anon_sym_CARET] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(628),
    [anon_sym_GT_EQ] = ACTIONS(628),
    [anon_sym_EQ_EQ] = ACTIONS(628),
    [anon_sym_BANG_EQ] = ACTIONS(628),
    [anon_sym_PIPE_PIPE] = ACTIONS(628),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP_AMP] = ACTIONS(628),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_COLON] = ACTIONS(630),
    [sym_break] = ACTIONS(630),
    [sym_next] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_inf] = ACTIONS(630),
    [sym_nan] = ACTIONS(630),
    [anon_sym_NA] = ACTIONS(630),
    [anon_sym_NA_character_] = ACTIONS(630),
    [anon_sym_NA_complex_] = ACTIONS(630),
    [anon_sym_NA_integer_] = ACTIONS(630),
    [anon_sym_NA_real_] = ACTIONS(630),
    [aux_sym_identifier_token1] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(628),
    [sym_integer] = ACTIONS(628),
    [sym_float] = ACTIONS(630),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(628),
    [anon_sym_SQUOTE] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(628),
  },
  [88] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(634),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [89] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [90] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [91] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(666),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_RBRACK] = ACTIONS(610),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_COLON_COLON] = ACTIONS(668),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(670),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [92] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(634),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [93] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [94] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [95] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [96] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(676),
    [anon_sym_function] = ACTIONS(678),
    [anon_sym_if] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(676),
    [anon_sym_else] = ACTIONS(678),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_repeat] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(678),
    [anon_sym_switch] = ACTIONS(678),
    [anon_sym_COMMA] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(678),
    [anon_sym_LBRACE] = ACTIONS(676),
    [anon_sym_LT_DASH] = ACTIONS(676),
    [anon_sym_COLON_EQ] = ACTIONS(676),
    [anon_sym_LT_LT_DASH] = ACTIONS(676),
    [anon_sym_DASH_GT] = ACTIONS(676),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(676),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(678),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(678),
    [sym_next] = ACTIONS(678),
    [sym_true] = ACTIONS(678),
    [sym_false] = ACTIONS(678),
    [sym_null] = ACTIONS(678),
    [sym_inf] = ACTIONS(678),
    [sym_nan] = ACTIONS(678),
    [anon_sym_NA] = ACTIONS(678),
    [anon_sym_NA_character_] = ACTIONS(678),
    [anon_sym_NA_complex_] = ACTIONS(678),
    [anon_sym_NA_integer_] = ACTIONS(678),
    [anon_sym_NA_real_] = ACTIONS(678),
    [aux_sym_identifier_token1] = ACTIONS(678),
    [anon_sym_BQUOTE] = ACTIONS(676),
    [sym_integer] = ACTIONS(676),
    [sym_float] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(676),
    [anon_sym_SQUOTE] = ACTIONS(676),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [97] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(682),
    [anon_sym_function] = ACTIONS(684),
    [anon_sym_if] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(682),
    [anon_sym_else] = ACTIONS(684),
    [anon_sym_while] = ACTIONS(684),
    [anon_sym_repeat] = ACTIONS(684),
    [anon_sym_for] = ACTIONS(684),
    [anon_sym_switch] = ACTIONS(684),
    [anon_sym_COMMA] = ACTIONS(682),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(682),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(682),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(684),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(684),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(684),
    [sym_next] = ACTIONS(684),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_null] = ACTIONS(684),
    [sym_inf] = ACTIONS(684),
    [sym_nan] = ACTIONS(684),
    [anon_sym_NA] = ACTIONS(684),
    [anon_sym_NA_character_] = ACTIONS(684),
    [anon_sym_NA_complex_] = ACTIONS(684),
    [anon_sym_NA_integer_] = ACTIONS(684),
    [anon_sym_NA_real_] = ACTIONS(684),
    [aux_sym_identifier_token1] = ACTIONS(684),
    [anon_sym_BQUOTE] = ACTIONS(682),
    [sym_integer] = ACTIONS(682),
    [sym_float] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(682),
    [anon_sym_SQUOTE] = ACTIONS(682),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [98] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_function] = ACTIONS(698),
    [anon_sym_if] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(696),
    [anon_sym_else] = ACTIONS(698),
    [anon_sym_while] = ACTIONS(698),
    [anon_sym_repeat] = ACTIONS(698),
    [anon_sym_for] = ACTIONS(698),
    [anon_sym_switch] = ACTIONS(698),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(696),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(698),
    [sym_next] = ACTIONS(698),
    [sym_true] = ACTIONS(698),
    [sym_false] = ACTIONS(698),
    [sym_null] = ACTIONS(698),
    [sym_inf] = ACTIONS(698),
    [sym_nan] = ACTIONS(698),
    [anon_sym_NA] = ACTIONS(698),
    [anon_sym_NA_character_] = ACTIONS(698),
    [anon_sym_NA_complex_] = ACTIONS(698),
    [anon_sym_NA_integer_] = ACTIONS(698),
    [anon_sym_NA_real_] = ACTIONS(698),
    [aux_sym_identifier_token1] = ACTIONS(698),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [sym_integer] = ACTIONS(696),
    [sym_float] = ACTIONS(698),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [99] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(700),
    [anon_sym_function] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(700),
    [anon_sym_else] = ACTIONS(702),
    [anon_sym_while] = ACTIONS(702),
    [anon_sym_repeat] = ACTIONS(702),
    [anon_sym_for] = ACTIONS(702),
    [anon_sym_switch] = ACTIONS(702),
    [anon_sym_COMMA] = ACTIONS(700),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(700),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(702),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(702),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(702),
    [sym_next] = ACTIONS(702),
    [sym_true] = ACTIONS(702),
    [sym_false] = ACTIONS(702),
    [sym_null] = ACTIONS(702),
    [sym_inf] = ACTIONS(702),
    [sym_nan] = ACTIONS(702),
    [anon_sym_NA] = ACTIONS(702),
    [anon_sym_NA_character_] = ACTIONS(702),
    [anon_sym_NA_complex_] = ACTIONS(702),
    [anon_sym_NA_integer_] = ACTIONS(702),
    [anon_sym_NA_real_] = ACTIONS(702),
    [aux_sym_identifier_token1] = ACTIONS(702),
    [anon_sym_BQUOTE] = ACTIONS(700),
    [sym_integer] = ACTIONS(700),
    [sym_float] = ACTIONS(702),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(700),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [100] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(704),
    [anon_sym_function] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(706),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(704),
    [anon_sym_else] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(706),
    [anon_sym_repeat] = ACTIONS(706),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_switch] = ACTIONS(706),
    [anon_sym_COMMA] = ACTIONS(704),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(704),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(706),
    [sym_next] = ACTIONS(706),
    [sym_true] = ACTIONS(706),
    [sym_false] = ACTIONS(706),
    [sym_null] = ACTIONS(706),
    [sym_inf] = ACTIONS(706),
    [sym_nan] = ACTIONS(706),
    [anon_sym_NA] = ACTIONS(706),
    [anon_sym_NA_character_] = ACTIONS(706),
    [anon_sym_NA_complex_] = ACTIONS(706),
    [anon_sym_NA_integer_] = ACTIONS(706),
    [anon_sym_NA_real_] = ACTIONS(706),
    [aux_sym_identifier_token1] = ACTIONS(706),
    [anon_sym_BQUOTE] = ACTIONS(704),
    [sym_integer] = ACTIONS(704),
    [sym_float] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(704),
    [anon_sym_SQUOTE] = ACTIONS(704),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [101] = {
    [anon_sym_LF] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(630),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_repeat] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_RBRACE] = ACTIONS(630),
    [anon_sym_LT_DASH] = ACTIONS(630),
    [anon_sym_COLON_EQ] = ACTIONS(630),
    [anon_sym_LT_LT_DASH] = ACTIONS(630),
    [anon_sym_DASH_GT] = ACTIONS(630),
    [anon_sym_LBRACK] = ACTIONS(630),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(630),
    [anon_sym_DOLLAR] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(630),
    [anon_sym_COLON_COLON] = ACTIONS(630),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(630),
    [sym_dots] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(630),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_SLASH] = ACTIONS(630),
    [anon_sym_CARET] = ACTIONS(630),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(630),
    [anon_sym_GT_EQ] = ACTIONS(630),
    [anon_sym_EQ_EQ] = ACTIONS(630),
    [anon_sym_BANG_EQ] = ACTIONS(630),
    [anon_sym_PIPE_PIPE] = ACTIONS(630),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP_AMP] = ACTIONS(630),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_COLON] = ACTIONS(630),
    [sym_break] = ACTIONS(630),
    [sym_next] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_inf] = ACTIONS(630),
    [sym_nan] = ACTIONS(630),
    [anon_sym_NA] = ACTIONS(630),
    [anon_sym_NA_character_] = ACTIONS(630),
    [anon_sym_NA_complex_] = ACTIONS(630),
    [anon_sym_NA_integer_] = ACTIONS(630),
    [anon_sym_NA_real_] = ACTIONS(630),
    [aux_sym_identifier_token1] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(630),
    [sym_integer] = ACTIONS(630),
    [sym_float] = ACTIONS(630),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [anon_sym_SQUOTE] = ACTIONS(630),
    [anon_sym_PERCENT] = ACTIONS(630),
  },
  [102] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_EQ] = ACTIONS(712),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_LT_DASH] = ACTIONS(710),
    [anon_sym_COLON_EQ] = ACTIONS(710),
    [anon_sym_LT_LT_DASH] = ACTIONS(710),
    [anon_sym_DASH_GT] = ACTIONS(710),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(710),
    [sym_integer] = ACTIONS(710),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(710),
    [anon_sym_SQUOTE] = ACTIONS(710),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [103] = {
    [anon_sym_LF] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_RBRACE] = ACTIONS(624),
    [anon_sym_LT_DASH] = ACTIONS(624),
    [anon_sym_COLON_EQ] = ACTIONS(624),
    [anon_sym_LT_LT_DASH] = ACTIONS(624),
    [anon_sym_DASH_GT] = ACTIONS(624),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(624),
    [anon_sym_DOLLAR] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(624),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_STAR] = ACTIONS(624),
    [anon_sym_SLASH] = ACTIONS(624),
    [anon_sym_CARET] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(624),
    [anon_sym_GT_EQ] = ACTIONS(624),
    [anon_sym_EQ_EQ] = ACTIONS(624),
    [anon_sym_BANG_EQ] = ACTIONS(624),
    [anon_sym_PIPE_PIPE] = ACTIONS(624),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(624),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(624),
    [sym_integer] = ACTIONS(624),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(624),
    [anon_sym_SQUOTE] = ACTIONS(624),
    [anon_sym_PERCENT] = ACTIONS(624),
  },
  [104] = {
    [anon_sym_LF] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_LT_DASH] = ACTIONS(620),
    [anon_sym_COLON_EQ] = ACTIONS(620),
    [anon_sym_LT_LT_DASH] = ACTIONS(620),
    [anon_sym_DASH_GT] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(620),
    [anon_sym_DOLLAR] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(620),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_STAR] = ACTIONS(620),
    [anon_sym_SLASH] = ACTIONS(620),
    [anon_sym_CARET] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(620),
    [anon_sym_GT_EQ] = ACTIONS(620),
    [anon_sym_EQ_EQ] = ACTIONS(620),
    [anon_sym_BANG_EQ] = ACTIONS(620),
    [anon_sym_PIPE_PIPE] = ACTIONS(620),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(620),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_integer] = ACTIONS(620),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(620),
    [anon_sym_SQUOTE] = ACTIONS(620),
    [anon_sym_PERCENT] = ACTIONS(620),
  },
  [105] = {
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_RPAREN] = ACTIONS(618),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_COMMA] = ACTIONS(618),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_LT_DASH] = ACTIONS(618),
    [anon_sym_COLON_EQ] = ACTIONS(618),
    [anon_sym_LT_LT_DASH] = ACTIONS(618),
    [anon_sym_DASH_GT] = ACTIONS(618),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_RBRACK] = ACTIONS(618),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(618),
    [anon_sym_DOLLAR] = ACTIONS(618),
    [anon_sym_AT] = ACTIONS(618),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(618),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_STAR] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(618),
    [anon_sym_CARET] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(618),
    [anon_sym_GT_EQ] = ACTIONS(618),
    [anon_sym_EQ_EQ] = ACTIONS(618),
    [anon_sym_BANG_EQ] = ACTIONS(618),
    [anon_sym_PIPE_PIPE] = ACTIONS(618),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(618),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(618),
    [sym_integer] = ACTIONS(618),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(618),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [anon_sym_PERCENT] = ACTIONS(618),
  },
  [106] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [107] = {
    [anon_sym_LF] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_RBRACE] = ACTIONS(612),
    [anon_sym_LT_DASH] = ACTIONS(612),
    [anon_sym_COLON_EQ] = ACTIONS(612),
    [anon_sym_LT_LT_DASH] = ACTIONS(612),
    [anon_sym_DASH_GT] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(612),
    [anon_sym_DOLLAR] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_COLON_COLON] = ACTIONS(714),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(716),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_CARET] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(612),
    [anon_sym_GT_EQ] = ACTIONS(612),
    [anon_sym_EQ_EQ] = ACTIONS(612),
    [anon_sym_BANG_EQ] = ACTIONS(612),
    [anon_sym_PIPE_PIPE] = ACTIONS(612),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(612),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(612),
    [sym_integer] = ACTIONS(612),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(612),
    [anon_sym_SQUOTE] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(612),
  },
  [108] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_RBRACK] = ACTIONS(610),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [anon_sym_i] = ACTIONS(718),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [109] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(628),
    [anon_sym_LF] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(630),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_repeat] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_LT_DASH] = ACTIONS(630),
    [anon_sym_COLON_EQ] = ACTIONS(630),
    [anon_sym_LT_LT_DASH] = ACTIONS(630),
    [anon_sym_DASH_GT] = ACTIONS(630),
    [anon_sym_LBRACK] = ACTIONS(630),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(630),
    [anon_sym_DOLLAR] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(630),
    [anon_sym_COLON_COLON] = ACTIONS(630),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(630),
    [sym_dots] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(630),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_SLASH] = ACTIONS(630),
    [anon_sym_CARET] = ACTIONS(630),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(630),
    [anon_sym_GT_EQ] = ACTIONS(630),
    [anon_sym_EQ_EQ] = ACTIONS(630),
    [anon_sym_BANG_EQ] = ACTIONS(630),
    [anon_sym_PIPE_PIPE] = ACTIONS(630),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP_AMP] = ACTIONS(630),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_COLON] = ACTIONS(630),
    [sym_break] = ACTIONS(630),
    [sym_next] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_inf] = ACTIONS(630),
    [sym_nan] = ACTIONS(630),
    [anon_sym_NA] = ACTIONS(630),
    [anon_sym_NA_character_] = ACTIONS(630),
    [anon_sym_NA_complex_] = ACTIONS(630),
    [anon_sym_NA_integer_] = ACTIONS(630),
    [anon_sym_NA_real_] = ACTIONS(630),
    [aux_sym_identifier_token1] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(630),
    [sym_integer] = ACTIONS(630),
    [sym_float] = ACTIONS(630),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [anon_sym_SQUOTE] = ACTIONS(630),
    [anon_sym_PERCENT] = ACTIONS(630),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(622),
    [anon_sym_LF] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_LT_DASH] = ACTIONS(624),
    [anon_sym_COLON_EQ] = ACTIONS(624),
    [anon_sym_LT_LT_DASH] = ACTIONS(624),
    [anon_sym_DASH_GT] = ACTIONS(624),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(624),
    [anon_sym_DOLLAR] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(624),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_STAR] = ACTIONS(624),
    [anon_sym_SLASH] = ACTIONS(624),
    [anon_sym_CARET] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(624),
    [anon_sym_GT_EQ] = ACTIONS(624),
    [anon_sym_EQ_EQ] = ACTIONS(624),
    [anon_sym_BANG_EQ] = ACTIONS(624),
    [anon_sym_PIPE_PIPE] = ACTIONS(624),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(624),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(624),
    [sym_integer] = ACTIONS(624),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(624),
    [anon_sym_SQUOTE] = ACTIONS(624),
    [anon_sym_PERCENT] = ACTIONS(624),
  },
  [112] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_LT_LT_DASH] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [113] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_LT_LT_DASH] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(720),
    [anon_sym_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(720),
    [anon_sym_AMP] = ACTIONS(722),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [114] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_LT_LT_DASH] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(720),
    [anon_sym_SLASH] = ACTIONS(720),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(722),
    [anon_sym_LT_EQ] = ACTIONS(720),
    [anon_sym_GT_EQ] = ACTIONS(720),
    [anon_sym_EQ_EQ] = ACTIONS(720),
    [anon_sym_BANG_EQ] = ACTIONS(720),
    [anon_sym_PIPE_PIPE] = ACTIONS(720),
    [anon_sym_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(720),
    [anon_sym_AMP] = ACTIONS(722),
    [anon_sym_COLON] = ACTIONS(722),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(720),
  },
  [115] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_function] = ACTIONS(726),
    [anon_sym_if] = ACTIONS(726),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(724),
    [anon_sym_else] = ACTIONS(726),
    [anon_sym_while] = ACTIONS(726),
    [anon_sym_repeat] = ACTIONS(726),
    [anon_sym_for] = ACTIONS(726),
    [anon_sym_switch] = ACTIONS(726),
    [anon_sym_COMMA] = ACTIONS(724),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(724),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(726),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(726),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(726),
    [sym_next] = ACTIONS(726),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_null] = ACTIONS(726),
    [sym_inf] = ACTIONS(726),
    [sym_nan] = ACTIONS(726),
    [anon_sym_NA] = ACTIONS(726),
    [anon_sym_NA_character_] = ACTIONS(726),
    [anon_sym_NA_complex_] = ACTIONS(726),
    [anon_sym_NA_integer_] = ACTIONS(726),
    [anon_sym_NA_real_] = ACTIONS(726),
    [aux_sym_identifier_token1] = ACTIONS(726),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_integer] = ACTIONS(724),
    [sym_float] = ACTIONS(726),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(724),
    [anon_sym_SQUOTE] = ACTIONS(724),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [116] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_if] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(728),
    [anon_sym_else] = ACTIONS(730),
    [anon_sym_while] = ACTIONS(730),
    [anon_sym_repeat] = ACTIONS(730),
    [anon_sym_for] = ACTIONS(730),
    [anon_sym_switch] = ACTIONS(730),
    [anon_sym_COMMA] = ACTIONS(728),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(728),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(730),
    [sym_next] = ACTIONS(730),
    [sym_true] = ACTIONS(730),
    [sym_false] = ACTIONS(730),
    [sym_null] = ACTIONS(730),
    [sym_inf] = ACTIONS(730),
    [sym_nan] = ACTIONS(730),
    [anon_sym_NA] = ACTIONS(730),
    [anon_sym_NA_character_] = ACTIONS(730),
    [anon_sym_NA_complex_] = ACTIONS(730),
    [anon_sym_NA_integer_] = ACTIONS(730),
    [anon_sym_NA_real_] = ACTIONS(730),
    [aux_sym_identifier_token1] = ACTIONS(730),
    [anon_sym_BQUOTE] = ACTIONS(728),
    [sym_integer] = ACTIONS(728),
    [sym_float] = ACTIONS(730),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(618),
    [anon_sym_LF] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_LT_DASH] = ACTIONS(620),
    [anon_sym_COLON_EQ] = ACTIONS(620),
    [anon_sym_LT_LT_DASH] = ACTIONS(620),
    [anon_sym_DASH_GT] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(620),
    [anon_sym_DOLLAR] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(620),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_STAR] = ACTIONS(620),
    [anon_sym_SLASH] = ACTIONS(620),
    [anon_sym_CARET] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(620),
    [anon_sym_GT_EQ] = ACTIONS(620),
    [anon_sym_EQ_EQ] = ACTIONS(620),
    [anon_sym_BANG_EQ] = ACTIONS(620),
    [anon_sym_PIPE_PIPE] = ACTIONS(620),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(620),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_integer] = ACTIONS(620),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(620),
    [anon_sym_SQUOTE] = ACTIONS(620),
    [anon_sym_PERCENT] = ACTIONS(620),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [anon_sym_LF] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_LT_DASH] = ACTIONS(612),
    [anon_sym_COLON_EQ] = ACTIONS(612),
    [anon_sym_LT_LT_DASH] = ACTIONS(612),
    [anon_sym_DASH_GT] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(612),
    [anon_sym_DOLLAR] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_COLON_COLON] = ACTIONS(732),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(734),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_CARET] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(612),
    [anon_sym_GT_EQ] = ACTIONS(612),
    [anon_sym_EQ_EQ] = ACTIONS(612),
    [anon_sym_BANG_EQ] = ACTIONS(612),
    [anon_sym_PIPE_PIPE] = ACTIONS(612),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(612),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(612),
    [sym_integer] = ACTIONS(612),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(612),
    [anon_sym_SQUOTE] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(612),
  },
  [119] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(736),
    [anon_sym_else] = ACTIONS(740),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [120] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(742),
    [anon_sym_function] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(742),
    [anon_sym_else] = ACTIONS(744),
    [anon_sym_while] = ACTIONS(744),
    [anon_sym_repeat] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_switch] = ACTIONS(744),
    [anon_sym_COMMA] = ACTIONS(742),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(742),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(744),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(744),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(744),
    [sym_next] = ACTIONS(744),
    [sym_true] = ACTIONS(744),
    [sym_false] = ACTIONS(744),
    [sym_null] = ACTIONS(744),
    [sym_inf] = ACTIONS(744),
    [sym_nan] = ACTIONS(744),
    [anon_sym_NA] = ACTIONS(744),
    [anon_sym_NA_character_] = ACTIONS(744),
    [anon_sym_NA_complex_] = ACTIONS(744),
    [anon_sym_NA_integer_] = ACTIONS(744),
    [anon_sym_NA_real_] = ACTIONS(744),
    [aux_sym_identifier_token1] = ACTIONS(744),
    [anon_sym_BQUOTE] = ACTIONS(742),
    [sym_integer] = ACTIONS(742),
    [sym_float] = ACTIONS(744),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(742),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [121] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(746),
    [sym_integer] = ACTIONS(746),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [122] = {
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_COMMA] = ACTIONS(618),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_LT_DASH] = ACTIONS(618),
    [anon_sym_COLON_EQ] = ACTIONS(618),
    [anon_sym_LT_LT_DASH] = ACTIONS(618),
    [anon_sym_DASH_GT] = ACTIONS(618),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(618),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(618),
    [anon_sym_DOLLAR] = ACTIONS(618),
    [anon_sym_AT] = ACTIONS(618),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(618),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_STAR] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(618),
    [anon_sym_CARET] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(618),
    [anon_sym_GT_EQ] = ACTIONS(618),
    [anon_sym_EQ_EQ] = ACTIONS(618),
    [anon_sym_BANG_EQ] = ACTIONS(618),
    [anon_sym_PIPE_PIPE] = ACTIONS(618),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(618),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(618),
    [sym_integer] = ACTIONS(618),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(618),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [anon_sym_PERCENT] = ACTIONS(618),
  },
  [123] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_COLON_COLON] = ACTIONS(750),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(752),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [124] = {
    [anon_sym_SEMI] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_COMMA] = ACTIONS(622),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(622),
    [anon_sym_LT_DASH] = ACTIONS(622),
    [anon_sym_COLON_EQ] = ACTIONS(622),
    [anon_sym_LT_LT_DASH] = ACTIONS(622),
    [anon_sym_DASH_GT] = ACTIONS(622),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(622),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(622),
    [anon_sym_DOLLAR] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(622),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(622),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_STAR] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(622),
    [anon_sym_CARET] = ACTIONS(622),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(622),
    [anon_sym_GT_EQ] = ACTIONS(622),
    [anon_sym_EQ_EQ] = ACTIONS(622),
    [anon_sym_BANG_EQ] = ACTIONS(622),
    [anon_sym_PIPE_PIPE] = ACTIONS(622),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(622),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_integer] = ACTIONS(622),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(622),
    [anon_sym_SQUOTE] = ACTIONS(622),
    [anon_sym_PERCENT] = ACTIONS(622),
  },
  [125] = {
    [anon_sym_SEMI] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(628),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_repeat] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(628),
    [anon_sym_EQ] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_LT_DASH] = ACTIONS(628),
    [anon_sym_COLON_EQ] = ACTIONS(628),
    [anon_sym_LT_LT_DASH] = ACTIONS(628),
    [anon_sym_DASH_GT] = ACTIONS(628),
    [anon_sym_LBRACK] = ACTIONS(630),
    [anon_sym_RBRACK] = ACTIONS(628),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(628),
    [anon_sym_DOLLAR] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_COLON_COLON] = ACTIONS(630),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(628),
    [sym_dots] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(628),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(628),
    [anon_sym_CARET] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(628),
    [anon_sym_GT_EQ] = ACTIONS(628),
    [anon_sym_EQ_EQ] = ACTIONS(628),
    [anon_sym_BANG_EQ] = ACTIONS(628),
    [anon_sym_PIPE_PIPE] = ACTIONS(628),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP_AMP] = ACTIONS(628),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_COLON] = ACTIONS(630),
    [sym_break] = ACTIONS(630),
    [sym_next] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_inf] = ACTIONS(630),
    [sym_nan] = ACTIONS(630),
    [anon_sym_NA] = ACTIONS(630),
    [anon_sym_NA_character_] = ACTIONS(630),
    [anon_sym_NA_complex_] = ACTIONS(630),
    [anon_sym_NA_integer_] = ACTIONS(630),
    [anon_sym_NA_real_] = ACTIONS(630),
    [aux_sym_identifier_token1] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(628),
    [sym_integer] = ACTIONS(628),
    [sym_float] = ACTIONS(630),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(628),
    [anon_sym_SQUOTE] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(628),
  },
  [126] = {
    [anon_sym_SEMI] = ACTIONS(628),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_repeat] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(628),
    [anon_sym_EQ] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_LT_DASH] = ACTIONS(628),
    [anon_sym_COLON_EQ] = ACTIONS(628),
    [anon_sym_LT_LT_DASH] = ACTIONS(628),
    [anon_sym_DASH_GT] = ACTIONS(628),
    [anon_sym_LBRACK] = ACTIONS(630),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(628),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(628),
    [anon_sym_DOLLAR] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_COLON_COLON] = ACTIONS(630),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(628),
    [sym_dots] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(628),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(628),
    [anon_sym_CARET] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(628),
    [anon_sym_GT_EQ] = ACTIONS(628),
    [anon_sym_EQ_EQ] = ACTIONS(628),
    [anon_sym_BANG_EQ] = ACTIONS(628),
    [anon_sym_PIPE_PIPE] = ACTIONS(628),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP_AMP] = ACTIONS(628),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_COLON] = ACTIONS(630),
    [sym_break] = ACTIONS(630),
    [sym_next] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_inf] = ACTIONS(630),
    [sym_nan] = ACTIONS(630),
    [anon_sym_NA] = ACTIONS(630),
    [anon_sym_NA_character_] = ACTIONS(630),
    [anon_sym_NA_complex_] = ACTIONS(630),
    [anon_sym_NA_integer_] = ACTIONS(630),
    [anon_sym_NA_real_] = ACTIONS(630),
    [aux_sym_identifier_token1] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(628),
    [sym_integer] = ACTIONS(628),
    [sym_float] = ACTIONS(630),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(628),
    [anon_sym_SQUOTE] = ACTIONS(628),
    [anon_sym_PERCENT] = ACTIONS(628),
  },
  [127] = {
    [sym_special] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(736),
    [anon_sym_else] = ACTIONS(754),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(688),
    [anon_sym_COLON_EQ] = ACTIONS(690),
    [anon_sym_LT_LT_DASH] = ACTIONS(692),
    [anon_sym_DASH_GT] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(638),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(640),
    [anon_sym_DOLLAR] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(644),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_CARET] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(654),
    [anon_sym_GT] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(656),
    [anon_sym_GT_EQ] = ACTIONS(656),
    [anon_sym_EQ_EQ] = ACTIONS(656),
    [anon_sym_BANG_EQ] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_COLON] = ACTIONS(662),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [128] = {
    [anon_sym_SEMI] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_RPAREN] = ACTIONS(622),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_COMMA] = ACTIONS(622),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(622),
    [anon_sym_LT_DASH] = ACTIONS(622),
    [anon_sym_COLON_EQ] = ACTIONS(622),
    [anon_sym_LT_LT_DASH] = ACTIONS(622),
    [anon_sym_DASH_GT] = ACTIONS(622),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_RBRACK] = ACTIONS(622),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(622),
    [anon_sym_DOLLAR] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(622),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(622),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_STAR] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(622),
    [anon_sym_CARET] = ACTIONS(622),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(622),
    [anon_sym_GT_EQ] = ACTIONS(622),
    [anon_sym_EQ_EQ] = ACTIONS(622),
    [anon_sym_BANG_EQ] = ACTIONS(622),
    [anon_sym_PIPE_PIPE] = ACTIONS(622),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(622),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_integer] = ACTIONS(622),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(622),
    [anon_sym_SQUOTE] = ACTIONS(622),
    [anon_sym_PERCENT] = ACTIONS(622),
  },
  [129] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_RBRACK] = ACTIONS(610),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_COLON_COLON] = ACTIONS(668),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(670),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [130] = {
    [sym_function_definition] = STATE(377),
    [sym_if] = STATE(377),
    [sym_while] = STATE(377),
    [sym_repeat] = STATE(377),
    [sym_for] = STATE(377),
    [sym_switch] = STATE(377),
    [sym_call] = STATE(377),
    [sym__assignment] = STATE(377),
    [sym_left_assignment] = STATE(377),
    [sym_left_assignment2] = STATE(377),
    [sym_equals_assignment] = STATE(377),
    [sym_super_assignment] = STATE(377),
    [sym_right_assignment] = STATE(377),
    [sym_brace_list] = STATE(377),
    [sym_paren_list] = STATE(377),
    [sym_subset] = STATE(377),
    [sym_subset2] = STATE(377),
    [sym_dollar] = STATE(377),
    [sym_slot] = STATE(377),
    [sym_namespace_get] = STATE(377),
    [sym_namespace_get_internal] = STATE(377),
    [sym_unary] = STATE(377),
    [sym_binary] = STATE(377),
    [sym_na] = STATE(377),
    [sym__expression] = STATE(377),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(377),
    [sym_string] = STATE(377),
    [anon_sym_SEMI] = ACTIONS(756),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(774),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(774),
    [sym_next] = ACTIONS(774),
    [sym_true] = ACTIONS(774),
    [sym_false] = ACTIONS(774),
    [sym_null] = ACTIONS(774),
    [sym_inf] = ACTIONS(774),
    [sym_nan] = ACTIONS(774),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(756),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [131] = {
    [sym_function_definition] = STATE(97),
    [sym_if] = STATE(97),
    [sym_while] = STATE(97),
    [sym_repeat] = STATE(97),
    [sym_for] = STATE(97),
    [sym_switch] = STATE(97),
    [sym_call] = STATE(97),
    [sym__assignment] = STATE(97),
    [sym_left_assignment] = STATE(97),
    [sym_left_assignment2] = STATE(97),
    [sym_equals_assignment] = STATE(97),
    [sym_super_assignment] = STATE(97),
    [sym_right_assignment] = STATE(97),
    [sym_brace_list] = STATE(97),
    [sym_paren_list] = STATE(97),
    [sym_subset] = STATE(97),
    [sym_subset2] = STATE(97),
    [sym_dollar] = STATE(97),
    [sym_slot] = STATE(97),
    [sym_namespace_get] = STATE(97),
    [sym_namespace_get_internal] = STATE(97),
    [sym_unary] = STATE(97),
    [sym_binary] = STATE(97),
    [sym_na] = STATE(97),
    [sym__expression] = STATE(97),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(97),
    [sym_string] = STATE(97),
    [anon_sym_SEMI] = ACTIONS(794),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(812),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(812),
    [sym_next] = ACTIONS(812),
    [sym_true] = ACTIONS(812),
    [sym_false] = ACTIONS(812),
    [sym_null] = ACTIONS(812),
    [sym_inf] = ACTIONS(812),
    [sym_nan] = ACTIONS(812),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(794),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [132] = {
    [sym_function_definition] = STATE(826),
    [sym_if] = STATE(826),
    [sym_while] = STATE(826),
    [sym_repeat] = STATE(826),
    [sym_for] = STATE(826),
    [sym_switch] = STATE(826),
    [sym_call] = STATE(826),
    [sym__assignment] = STATE(826),
    [sym_left_assignment] = STATE(826),
    [sym_left_assignment2] = STATE(826),
    [sym_equals_assignment] = STATE(826),
    [sym_super_assignment] = STATE(826),
    [sym_right_assignment] = STATE(826),
    [sym_brace_list] = STATE(826),
    [sym_paren_list] = STATE(826),
    [sym_subset] = STATE(826),
    [sym_subset2] = STATE(826),
    [sym_dollar] = STATE(826),
    [sym_slot] = STATE(826),
    [sym_namespace_get] = STATE(826),
    [sym_namespace_get_internal] = STATE(826),
    [sym_unary] = STATE(826),
    [sym_binary] = STATE(826),
    [sym_na] = STATE(826),
    [sym__expression] = STATE(826),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(826),
    [sym_string] = STATE(826),
    [anon_sym_SEMI] = ACTIONS(832),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(844),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(844),
    [sym_next] = ACTIONS(844),
    [sym_true] = ACTIONS(844),
    [sym_false] = ACTIONS(844),
    [sym_null] = ACTIONS(844),
    [sym_inf] = ACTIONS(844),
    [sym_nan] = ACTIONS(844),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(832),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [133] = {
    [sym_function_definition] = STATE(828),
    [sym_if] = STATE(828),
    [sym_while] = STATE(828),
    [sym_repeat] = STATE(828),
    [sym_for] = STATE(828),
    [sym_switch] = STATE(828),
    [sym_call] = STATE(828),
    [sym__assignment] = STATE(828),
    [sym_left_assignment] = STATE(828),
    [sym_left_assignment2] = STATE(828),
    [sym_equals_assignment] = STATE(828),
    [sym_super_assignment] = STATE(828),
    [sym_right_assignment] = STATE(828),
    [sym_brace_list] = STATE(828),
    [sym_paren_list] = STATE(828),
    [sym_subset] = STATE(828),
    [sym_subset2] = STATE(828),
    [sym_dollar] = STATE(828),
    [sym_slot] = STATE(828),
    [sym_namespace_get] = STATE(828),
    [sym_namespace_get_internal] = STATE(828),
    [sym_unary] = STATE(828),
    [sym_binary] = STATE(828),
    [sym_na] = STATE(828),
    [sym__expression] = STATE(828),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(828),
    [sym_string] = STATE(828),
    [anon_sym_SEMI] = ACTIONS(854),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(856),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(856),
    [sym_next] = ACTIONS(856),
    [sym_true] = ACTIONS(856),
    [sym_false] = ACTIONS(856),
    [sym_null] = ACTIONS(856),
    [sym_inf] = ACTIONS(856),
    [sym_nan] = ACTIONS(856),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(854),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [134] = {
    [sym_function_definition] = STATE(830),
    [sym_if] = STATE(830),
    [sym_while] = STATE(830),
    [sym_repeat] = STATE(830),
    [sym_for] = STATE(830),
    [sym_switch] = STATE(830),
    [sym_call] = STATE(830),
    [sym__assignment] = STATE(830),
    [sym_left_assignment] = STATE(830),
    [sym_left_assignment2] = STATE(830),
    [sym_equals_assignment] = STATE(830),
    [sym_super_assignment] = STATE(830),
    [sym_right_assignment] = STATE(830),
    [sym_brace_list] = STATE(830),
    [sym_paren_list] = STATE(830),
    [sym_subset] = STATE(830),
    [sym_subset2] = STATE(830),
    [sym_dollar] = STATE(830),
    [sym_slot] = STATE(830),
    [sym_namespace_get] = STATE(830),
    [sym_namespace_get_internal] = STATE(830),
    [sym_unary] = STATE(830),
    [sym_binary] = STATE(830),
    [sym_na] = STATE(830),
    [sym__expression] = STATE(830),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(830),
    [sym_string] = STATE(830),
    [anon_sym_SEMI] = ACTIONS(858),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(860),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(860),
    [sym_next] = ACTIONS(860),
    [sym_true] = ACTIONS(860),
    [sym_false] = ACTIONS(860),
    [sym_null] = ACTIONS(860),
    [sym_inf] = ACTIONS(860),
    [sym_nan] = ACTIONS(860),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(858),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [135] = {
    [sym_function_definition] = STATE(831),
    [sym_if] = STATE(831),
    [sym_while] = STATE(831),
    [sym_repeat] = STATE(831),
    [sym_for] = STATE(831),
    [sym_switch] = STATE(831),
    [sym_call] = STATE(831),
    [sym__assignment] = STATE(831),
    [sym_left_assignment] = STATE(831),
    [sym_left_assignment2] = STATE(831),
    [sym_equals_assignment] = STATE(831),
    [sym_super_assignment] = STATE(831),
    [sym_right_assignment] = STATE(831),
    [sym_brace_list] = STATE(831),
    [sym_paren_list] = STATE(831),
    [sym_subset] = STATE(831),
    [sym_subset2] = STATE(831),
    [sym_dollar] = STATE(831),
    [sym_slot] = STATE(831),
    [sym_namespace_get] = STATE(831),
    [sym_namespace_get_internal] = STATE(831),
    [sym_unary] = STATE(831),
    [sym_binary] = STATE(831),
    [sym_na] = STATE(831),
    [sym__expression] = STATE(831),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(831),
    [sym_string] = STATE(831),
    [anon_sym_SEMI] = ACTIONS(862),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(864),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(864),
    [sym_next] = ACTIONS(864),
    [sym_true] = ACTIONS(864),
    [sym_false] = ACTIONS(864),
    [sym_null] = ACTIONS(864),
    [sym_inf] = ACTIONS(864),
    [sym_nan] = ACTIONS(864),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(862),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [136] = {
    [sym_special] = STATE(478),
    [ts_builtin_sym_end] = ACTIONS(736),
    [anon_sym_LF] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(868),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(870),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_LT_DASH] = ACTIONS(872),
    [anon_sym_COLON_EQ] = ACTIONS(874),
    [anon_sym_LT_LT_DASH] = ACTIONS(876),
    [anon_sym_DASH_GT] = ACTIONS(878),
    [anon_sym_LBRACK] = ACTIONS(880),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(882),
    [anon_sym_DOLLAR] = ACTIONS(884),
    [anon_sym_AT] = ACTIONS(886),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(888),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(890),
    [anon_sym_STAR] = ACTIONS(892),
    [anon_sym_SLASH] = ACTIONS(892),
    [anon_sym_CARET] = ACTIONS(894),
    [anon_sym_LT] = ACTIONS(896),
    [anon_sym_GT] = ACTIONS(896),
    [anon_sym_LT_EQ] = ACTIONS(896),
    [anon_sym_GT_EQ] = ACTIONS(896),
    [anon_sym_EQ_EQ] = ACTIONS(896),
    [anon_sym_BANG_EQ] = ACTIONS(896),
    [anon_sym_PIPE_PIPE] = ACTIONS(898),
    [anon_sym_PIPE] = ACTIONS(898),
    [anon_sym_AMP_AMP] = ACTIONS(900),
    [anon_sym_AMP] = ACTIONS(900),
    [anon_sym_COLON] = ACTIONS(902),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [sym_integer] = ACTIONS(738),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [137] = {
    [sym_function_definition] = STATE(832),
    [sym_if] = STATE(832),
    [sym_while] = STATE(832),
    [sym_repeat] = STATE(832),
    [sym_for] = STATE(832),
    [sym_switch] = STATE(832),
    [sym_call] = STATE(832),
    [sym__assignment] = STATE(832),
    [sym_left_assignment] = STATE(832),
    [sym_left_assignment2] = STATE(832),
    [sym_equals_assignment] = STATE(832),
    [sym_super_assignment] = STATE(832),
    [sym_right_assignment] = STATE(832),
    [sym_brace_list] = STATE(832),
    [sym_paren_list] = STATE(832),
    [sym_subset] = STATE(832),
    [sym_subset2] = STATE(832),
    [sym_dollar] = STATE(832),
    [sym_slot] = STATE(832),
    [sym_namespace_get] = STATE(832),
    [sym_namespace_get_internal] = STATE(832),
    [sym_unary] = STATE(832),
    [sym_binary] = STATE(832),
    [sym_na] = STATE(832),
    [sym__expression] = STATE(832),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(832),
    [sym_string] = STATE(832),
    [anon_sym_SEMI] = ACTIONS(906),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(908),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(908),
    [sym_next] = ACTIONS(908),
    [sym_true] = ACTIONS(908),
    [sym_false] = ACTIONS(908),
    [sym_null] = ACTIONS(908),
    [sym_inf] = ACTIONS(908),
    [sym_nan] = ACTIONS(908),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(906),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [138] = {
    [sym_function_definition] = STATE(833),
    [sym_if] = STATE(833),
    [sym_while] = STATE(833),
    [sym_repeat] = STATE(833),
    [sym_for] = STATE(833),
    [sym_switch] = STATE(833),
    [sym_call] = STATE(833),
    [sym__assignment] = STATE(833),
    [sym_left_assignment] = STATE(833),
    [sym_left_assignment2] = STATE(833),
    [sym_equals_assignment] = STATE(833),
    [sym_super_assignment] = STATE(833),
    [sym_right_assignment] = STATE(833),
    [sym_brace_list] = STATE(833),
    [sym_paren_list] = STATE(833),
    [sym_subset] = STATE(833),
    [sym_subset2] = STATE(833),
    [sym_dollar] = STATE(833),
    [sym_slot] = STATE(833),
    [sym_namespace_get] = STATE(833),
    [sym_namespace_get_internal] = STATE(833),
    [sym_unary] = STATE(833),
    [sym_binary] = STATE(833),
    [sym_na] = STATE(833),
    [sym__expression] = STATE(833),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(833),
    [sym_string] = STATE(833),
    [anon_sym_SEMI] = ACTIONS(910),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(912),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(912),
    [sym_next] = ACTIONS(912),
    [sym_true] = ACTIONS(912),
    [sym_false] = ACTIONS(912),
    [sym_null] = ACTIONS(912),
    [sym_inf] = ACTIONS(912),
    [sym_nan] = ACTIONS(912),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(910),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [139] = {
    [sym_function_definition] = STATE(834),
    [sym_if] = STATE(834),
    [sym_while] = STATE(834),
    [sym_repeat] = STATE(834),
    [sym_for] = STATE(834),
    [sym_switch] = STATE(834),
    [sym_call] = STATE(834),
    [sym__assignment] = STATE(834),
    [sym_left_assignment] = STATE(834),
    [sym_left_assignment2] = STATE(834),
    [sym_equals_assignment] = STATE(834),
    [sym_super_assignment] = STATE(834),
    [sym_right_assignment] = STATE(834),
    [sym_brace_list] = STATE(834),
    [sym_paren_list] = STATE(834),
    [sym_subset] = STATE(834),
    [sym_subset2] = STATE(834),
    [sym_dollar] = STATE(834),
    [sym_slot] = STATE(834),
    [sym_namespace_get] = STATE(834),
    [sym_namespace_get_internal] = STATE(834),
    [sym_unary] = STATE(834),
    [sym_binary] = STATE(834),
    [sym_na] = STATE(834),
    [sym__expression] = STATE(834),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(834),
    [sym_string] = STATE(834),
    [anon_sym_SEMI] = ACTIONS(914),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(916),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(916),
    [sym_next] = ACTIONS(916),
    [sym_true] = ACTIONS(916),
    [sym_false] = ACTIONS(916),
    [sym_null] = ACTIONS(916),
    [sym_inf] = ACTIONS(916),
    [sym_nan] = ACTIONS(916),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(914),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [140] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(918),
    [anon_sym_function] = ACTIONS(920),
    [anon_sym_if] = ACTIONS(920),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(918),
    [anon_sym_while] = ACTIONS(920),
    [anon_sym_repeat] = ACTIONS(920),
    [anon_sym_for] = ACTIONS(920),
    [anon_sym_switch] = ACTIONS(920),
    [anon_sym_COMMA] = ACTIONS(918),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(918),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(918),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(920),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(920),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(920),
    [sym_next] = ACTIONS(920),
    [sym_true] = ACTIONS(920),
    [sym_false] = ACTIONS(920),
    [sym_null] = ACTIONS(920),
    [sym_inf] = ACTIONS(920),
    [sym_nan] = ACTIONS(920),
    [anon_sym_NA] = ACTIONS(920),
    [anon_sym_NA_character_] = ACTIONS(920),
    [anon_sym_NA_complex_] = ACTIONS(920),
    [anon_sym_NA_integer_] = ACTIONS(920),
    [anon_sym_NA_real_] = ACTIONS(920),
    [aux_sym_identifier_token1] = ACTIONS(920),
    [anon_sym_BQUOTE] = ACTIONS(918),
    [sym_integer] = ACTIONS(918),
    [sym_float] = ACTIONS(920),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(918),
    [anon_sym_SQUOTE] = ACTIONS(918),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [141] = {
    [sym_function_definition] = STATE(840),
    [sym_if] = STATE(840),
    [sym_while] = STATE(840),
    [sym_repeat] = STATE(840),
    [sym_for] = STATE(840),
    [sym_switch] = STATE(840),
    [sym_call] = STATE(840),
    [sym__assignment] = STATE(840),
    [sym_left_assignment] = STATE(840),
    [sym_left_assignment2] = STATE(840),
    [sym_equals_assignment] = STATE(840),
    [sym_super_assignment] = STATE(840),
    [sym_right_assignment] = STATE(840),
    [sym_brace_list] = STATE(840),
    [sym_paren_list] = STATE(840),
    [sym_subset] = STATE(840),
    [sym_subset2] = STATE(840),
    [sym_dollar] = STATE(840),
    [sym_slot] = STATE(840),
    [sym_namespace_get] = STATE(840),
    [sym_namespace_get_internal] = STATE(840),
    [sym_unary] = STATE(840),
    [sym_binary] = STATE(840),
    [sym_na] = STATE(840),
    [sym__expression] = STATE(840),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(840),
    [sym_string] = STATE(840),
    [anon_sym_SEMI] = ACTIONS(966),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(968),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(968),
    [sym_next] = ACTIONS(968),
    [sym_true] = ACTIONS(968),
    [sym_false] = ACTIONS(968),
    [sym_null] = ACTIONS(968),
    [sym_inf] = ACTIONS(968),
    [sym_nan] = ACTIONS(968),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(966),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [142] = {
    [sym_function_definition] = STATE(841),
    [sym_if] = STATE(841),
    [sym_while] = STATE(841),
    [sym_repeat] = STATE(841),
    [sym_for] = STATE(841),
    [sym_switch] = STATE(841),
    [sym_call] = STATE(841),
    [sym__assignment] = STATE(841),
    [sym_left_assignment] = STATE(841),
    [sym_left_assignment2] = STATE(841),
    [sym_equals_assignment] = STATE(841),
    [sym_super_assignment] = STATE(841),
    [sym_right_assignment] = STATE(841),
    [sym_brace_list] = STATE(841),
    [sym_paren_list] = STATE(841),
    [sym_subset] = STATE(841),
    [sym_subset2] = STATE(841),
    [sym_dollar] = STATE(841),
    [sym_slot] = STATE(841),
    [sym_namespace_get] = STATE(841),
    [sym_namespace_get_internal] = STATE(841),
    [sym_unary] = STATE(841),
    [sym_binary] = STATE(841),
    [sym_na] = STATE(841),
    [sym__expression] = STATE(841),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(841),
    [sym_string] = STATE(841),
    [anon_sym_SEMI] = ACTIONS(970),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(972),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(972),
    [sym_next] = ACTIONS(972),
    [sym_true] = ACTIONS(972),
    [sym_false] = ACTIONS(972),
    [sym_null] = ACTIONS(972),
    [sym_inf] = ACTIONS(972),
    [sym_nan] = ACTIONS(972),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(970),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [143] = {
    [sym_function_definition] = STATE(535),
    [sym_if] = STATE(535),
    [sym_while] = STATE(535),
    [sym_repeat] = STATE(535),
    [sym_for] = STATE(535),
    [sym_switch] = STATE(535),
    [sym_call] = STATE(535),
    [sym__assignment] = STATE(535),
    [sym_left_assignment] = STATE(535),
    [sym_left_assignment2] = STATE(535),
    [sym_equals_assignment] = STATE(535),
    [sym_super_assignment] = STATE(535),
    [sym_right_assignment] = STATE(535),
    [sym_brace_list] = STATE(535),
    [sym_paren_list] = STATE(535),
    [sym_subset] = STATE(535),
    [sym_subset2] = STATE(535),
    [sym_dollar] = STATE(535),
    [sym_slot] = STATE(535),
    [sym_namespace_get] = STATE(535),
    [sym_namespace_get_internal] = STATE(535),
    [sym_unary] = STATE(535),
    [sym_binary] = STATE(535),
    [sym_na] = STATE(535),
    [sym__expression] = STATE(535),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(535),
    [sym_string] = STATE(535),
    [anon_sym_SEMI] = ACTIONS(974),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(976),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(976),
    [sym_next] = ACTIONS(976),
    [sym_true] = ACTIONS(976),
    [sym_false] = ACTIONS(976),
    [sym_null] = ACTIONS(976),
    [sym_inf] = ACTIONS(976),
    [sym_nan] = ACTIONS(976),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(974),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [144] = {
    [sym_function_definition] = STATE(536),
    [sym_if] = STATE(536),
    [sym_while] = STATE(536),
    [sym_repeat] = STATE(536),
    [sym_for] = STATE(536),
    [sym_switch] = STATE(536),
    [sym_call] = STATE(536),
    [sym__assignment] = STATE(536),
    [sym_left_assignment] = STATE(536),
    [sym_left_assignment2] = STATE(536),
    [sym_equals_assignment] = STATE(536),
    [sym_super_assignment] = STATE(536),
    [sym_right_assignment] = STATE(536),
    [sym_brace_list] = STATE(536),
    [sym_paren_list] = STATE(536),
    [sym_subset] = STATE(536),
    [sym_subset2] = STATE(536),
    [sym_dollar] = STATE(536),
    [sym_slot] = STATE(536),
    [sym_namespace_get] = STATE(536),
    [sym_namespace_get_internal] = STATE(536),
    [sym_unary] = STATE(536),
    [sym_binary] = STATE(536),
    [sym_na] = STATE(536),
    [sym__expression] = STATE(536),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(536),
    [sym_string] = STATE(536),
    [anon_sym_SEMI] = ACTIONS(978),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(980),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(980),
    [sym_next] = ACTIONS(980),
    [sym_true] = ACTIONS(980),
    [sym_false] = ACTIONS(980),
    [sym_null] = ACTIONS(980),
    [sym_inf] = ACTIONS(980),
    [sym_nan] = ACTIONS(980),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(978),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [145] = {
    [sym_function_definition] = STATE(843),
    [sym_if] = STATE(843),
    [sym_while] = STATE(843),
    [sym_repeat] = STATE(843),
    [sym_for] = STATE(843),
    [sym_switch] = STATE(843),
    [sym_call] = STATE(843),
    [sym__assignment] = STATE(843),
    [sym_left_assignment] = STATE(843),
    [sym_left_assignment2] = STATE(843),
    [sym_equals_assignment] = STATE(843),
    [sym_super_assignment] = STATE(843),
    [sym_right_assignment] = STATE(843),
    [sym_brace_list] = STATE(843),
    [sym_paren_list] = STATE(843),
    [sym_subset] = STATE(843),
    [sym_subset2] = STATE(843),
    [sym_dollar] = STATE(843),
    [sym_slot] = STATE(843),
    [sym_namespace_get] = STATE(843),
    [sym_namespace_get_internal] = STATE(843),
    [sym_unary] = STATE(843),
    [sym_binary] = STATE(843),
    [sym_na] = STATE(843),
    [sym__expression] = STATE(843),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(843),
    [sym_string] = STATE(843),
    [anon_sym_SEMI] = ACTIONS(982),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(984),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(984),
    [sym_next] = ACTIONS(984),
    [sym_true] = ACTIONS(984),
    [sym_false] = ACTIONS(984),
    [sym_null] = ACTIONS(984),
    [sym_inf] = ACTIONS(984),
    [sym_nan] = ACTIONS(984),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(982),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [146] = {
    [sym_function_definition] = STATE(847),
    [sym_if] = STATE(847),
    [sym_while] = STATE(847),
    [sym_repeat] = STATE(847),
    [sym_for] = STATE(847),
    [sym_switch] = STATE(847),
    [sym_call] = STATE(847),
    [sym__assignment] = STATE(847),
    [sym_left_assignment] = STATE(847),
    [sym_left_assignment2] = STATE(847),
    [sym_equals_assignment] = STATE(847),
    [sym_super_assignment] = STATE(847),
    [sym_right_assignment] = STATE(847),
    [sym_brace_list] = STATE(847),
    [sym_paren_list] = STATE(847),
    [sym_subset] = STATE(847),
    [sym_subset2] = STATE(847),
    [sym_dollar] = STATE(847),
    [sym_slot] = STATE(847),
    [sym_namespace_get] = STATE(847),
    [sym_namespace_get_internal] = STATE(847),
    [sym_unary] = STATE(847),
    [sym_binary] = STATE(847),
    [sym_na] = STATE(847),
    [sym__expression] = STATE(847),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(847),
    [sym_string] = STATE(847),
    [anon_sym_SEMI] = ACTIONS(986),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(988),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(988),
    [sym_next] = ACTIONS(988),
    [sym_true] = ACTIONS(988),
    [sym_false] = ACTIONS(988),
    [sym_null] = ACTIONS(988),
    [sym_inf] = ACTIONS(988),
    [sym_nan] = ACTIONS(988),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(986),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [147] = {
    [sym_function_definition] = STATE(824),
    [sym_if] = STATE(824),
    [sym_while] = STATE(824),
    [sym_repeat] = STATE(824),
    [sym_for] = STATE(824),
    [sym_switch] = STATE(824),
    [sym_call] = STATE(824),
    [sym__assignment] = STATE(824),
    [sym_left_assignment] = STATE(824),
    [sym_left_assignment2] = STATE(824),
    [sym_equals_assignment] = STATE(824),
    [sym_super_assignment] = STATE(824),
    [sym_right_assignment] = STATE(824),
    [sym_brace_list] = STATE(824),
    [sym_paren_list] = STATE(824),
    [sym_subset] = STATE(824),
    [sym_subset2] = STATE(824),
    [sym_dollar] = STATE(824),
    [sym_slot] = STATE(824),
    [sym_namespace_get] = STATE(824),
    [sym_namespace_get_internal] = STATE(824),
    [sym_unary] = STATE(824),
    [sym_binary] = STATE(824),
    [sym_na] = STATE(824),
    [sym__expression] = STATE(824),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(824),
    [sym_string] = STATE(824),
    [anon_sym_SEMI] = ACTIONS(990),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(992),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(992),
    [sym_next] = ACTIONS(992),
    [sym_true] = ACTIONS(992),
    [sym_false] = ACTIONS(992),
    [sym_null] = ACTIONS(992),
    [sym_inf] = ACTIONS(992),
    [sym_nan] = ACTIONS(992),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(990),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [148] = {
    [sym_function_definition] = STATE(159),
    [sym_if] = STATE(159),
    [sym_while] = STATE(159),
    [sym_repeat] = STATE(159),
    [sym_for] = STATE(159),
    [sym_switch] = STATE(159),
    [sym_call] = STATE(159),
    [sym__assignment] = STATE(159),
    [sym_left_assignment] = STATE(159),
    [sym_left_assignment2] = STATE(159),
    [sym_equals_assignment] = STATE(159),
    [sym_super_assignment] = STATE(159),
    [sym_right_assignment] = STATE(159),
    [sym_brace_list] = STATE(159),
    [sym_paren_list] = STATE(159),
    [sym_subset] = STATE(159),
    [sym_subset2] = STATE(159),
    [sym_dollar] = STATE(159),
    [sym_slot] = STATE(159),
    [sym_namespace_get] = STATE(159),
    [sym_namespace_get_internal] = STATE(159),
    [sym_unary] = STATE(159),
    [sym_binary] = STATE(159),
    [sym_na] = STATE(159),
    [sym__expression] = STATE(159),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(159),
    [sym_string] = STATE(159),
    [anon_sym_SEMI] = ACTIONS(994),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(996),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(996),
    [sym_next] = ACTIONS(996),
    [sym_true] = ACTIONS(996),
    [sym_false] = ACTIONS(996),
    [sym_null] = ACTIONS(996),
    [sym_inf] = ACTIONS(996),
    [sym_nan] = ACTIONS(996),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(994),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [149] = {
    [sym_function_definition] = STATE(161),
    [sym_if] = STATE(161),
    [sym_while] = STATE(161),
    [sym_repeat] = STATE(161),
    [sym_for] = STATE(161),
    [sym_switch] = STATE(161),
    [sym_call] = STATE(161),
    [sym__assignment] = STATE(161),
    [sym_left_assignment] = STATE(161),
    [sym_left_assignment2] = STATE(161),
    [sym_equals_assignment] = STATE(161),
    [sym_super_assignment] = STATE(161),
    [sym_right_assignment] = STATE(161),
    [sym_brace_list] = STATE(161),
    [sym_paren_list] = STATE(161),
    [sym_subset] = STATE(161),
    [sym_subset2] = STATE(161),
    [sym_dollar] = STATE(161),
    [sym_slot] = STATE(161),
    [sym_namespace_get] = STATE(161),
    [sym_namespace_get_internal] = STATE(161),
    [sym_unary] = STATE(161),
    [sym_binary] = STATE(161),
    [sym_na] = STATE(161),
    [sym__expression] = STATE(161),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(161),
    [sym_string] = STATE(161),
    [anon_sym_SEMI] = ACTIONS(998),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1000),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1000),
    [sym_next] = ACTIONS(1000),
    [sym_true] = ACTIONS(1000),
    [sym_false] = ACTIONS(1000),
    [sym_null] = ACTIONS(1000),
    [sym_inf] = ACTIONS(1000),
    [sym_nan] = ACTIONS(1000),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(998),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [150] = {
    [sym_function_definition] = STATE(162),
    [sym_if] = STATE(162),
    [sym_while] = STATE(162),
    [sym_repeat] = STATE(162),
    [sym_for] = STATE(162),
    [sym_switch] = STATE(162),
    [sym_call] = STATE(162),
    [sym__assignment] = STATE(162),
    [sym_left_assignment] = STATE(162),
    [sym_left_assignment2] = STATE(162),
    [sym_equals_assignment] = STATE(162),
    [sym_super_assignment] = STATE(162),
    [sym_right_assignment] = STATE(162),
    [sym_brace_list] = STATE(162),
    [sym_paren_list] = STATE(162),
    [sym_subset] = STATE(162),
    [sym_subset2] = STATE(162),
    [sym_dollar] = STATE(162),
    [sym_slot] = STATE(162),
    [sym_namespace_get] = STATE(162),
    [sym_namespace_get_internal] = STATE(162),
    [sym_unary] = STATE(162),
    [sym_binary] = STATE(162),
    [sym_na] = STATE(162),
    [sym__expression] = STATE(162),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(162),
    [sym_string] = STATE(162),
    [anon_sym_SEMI] = ACTIONS(1002),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1004),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1004),
    [sym_next] = ACTIONS(1004),
    [sym_true] = ACTIONS(1004),
    [sym_false] = ACTIONS(1004),
    [sym_null] = ACTIONS(1004),
    [sym_inf] = ACTIONS(1004),
    [sym_nan] = ACTIONS(1004),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1002),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [151] = {
    [sym_function_definition] = STATE(163),
    [sym_if] = STATE(163),
    [sym_while] = STATE(163),
    [sym_repeat] = STATE(163),
    [sym_for] = STATE(163),
    [sym_switch] = STATE(163),
    [sym_call] = STATE(163),
    [sym__assignment] = STATE(163),
    [sym_left_assignment] = STATE(163),
    [sym_left_assignment2] = STATE(163),
    [sym_equals_assignment] = STATE(163),
    [sym_super_assignment] = STATE(163),
    [sym_right_assignment] = STATE(163),
    [sym_brace_list] = STATE(163),
    [sym_paren_list] = STATE(163),
    [sym_subset] = STATE(163),
    [sym_subset2] = STATE(163),
    [sym_dollar] = STATE(163),
    [sym_slot] = STATE(163),
    [sym_namespace_get] = STATE(163),
    [sym_namespace_get_internal] = STATE(163),
    [sym_unary] = STATE(163),
    [sym_binary] = STATE(163),
    [sym_na] = STATE(163),
    [sym__expression] = STATE(163),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(163),
    [sym_string] = STATE(163),
    [anon_sym_SEMI] = ACTIONS(1006),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1008),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1008),
    [sym_next] = ACTIONS(1008),
    [sym_true] = ACTIONS(1008),
    [sym_false] = ACTIONS(1008),
    [sym_null] = ACTIONS(1008),
    [sym_inf] = ACTIONS(1008),
    [sym_nan] = ACTIONS(1008),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1006),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [152] = {
    [sym_function_definition] = STATE(850),
    [sym_if] = STATE(850),
    [sym_while] = STATE(850),
    [sym_repeat] = STATE(850),
    [sym_for] = STATE(850),
    [sym_switch] = STATE(850),
    [sym_call] = STATE(850),
    [sym__assignment] = STATE(850),
    [sym_left_assignment] = STATE(850),
    [sym_left_assignment2] = STATE(850),
    [sym_equals_assignment] = STATE(850),
    [sym_super_assignment] = STATE(850),
    [sym_right_assignment] = STATE(850),
    [sym_brace_list] = STATE(850),
    [sym_paren_list] = STATE(850),
    [sym_subset] = STATE(850),
    [sym_subset2] = STATE(850),
    [sym_dollar] = STATE(850),
    [sym_slot] = STATE(850),
    [sym_namespace_get] = STATE(850),
    [sym_namespace_get_internal] = STATE(850),
    [sym_unary] = STATE(850),
    [sym_binary] = STATE(850),
    [sym_na] = STATE(850),
    [sym__expression] = STATE(850),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(850),
    [sym_string] = STATE(850),
    [anon_sym_SEMI] = ACTIONS(1010),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1012),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1012),
    [sym_next] = ACTIONS(1012),
    [sym_true] = ACTIONS(1012),
    [sym_false] = ACTIONS(1012),
    [sym_null] = ACTIONS(1012),
    [sym_inf] = ACTIONS(1012),
    [sym_nan] = ACTIONS(1012),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1010),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [153] = {
    [sym_function_definition] = STATE(851),
    [sym_if] = STATE(851),
    [sym_while] = STATE(851),
    [sym_repeat] = STATE(851),
    [sym_for] = STATE(851),
    [sym_switch] = STATE(851),
    [sym_call] = STATE(851),
    [sym__assignment] = STATE(851),
    [sym_left_assignment] = STATE(851),
    [sym_left_assignment2] = STATE(851),
    [sym_equals_assignment] = STATE(851),
    [sym_super_assignment] = STATE(851),
    [sym_right_assignment] = STATE(851),
    [sym_brace_list] = STATE(851),
    [sym_paren_list] = STATE(851),
    [sym_subset] = STATE(851),
    [sym_subset2] = STATE(851),
    [sym_dollar] = STATE(851),
    [sym_slot] = STATE(851),
    [sym_namespace_get] = STATE(851),
    [sym_namespace_get_internal] = STATE(851),
    [sym_unary] = STATE(851),
    [sym_binary] = STATE(851),
    [sym_na] = STATE(851),
    [sym__expression] = STATE(851),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(851),
    [sym_string] = STATE(851),
    [anon_sym_SEMI] = ACTIONS(1014),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1016),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1016),
    [sym_next] = ACTIONS(1016),
    [sym_true] = ACTIONS(1016),
    [sym_false] = ACTIONS(1016),
    [sym_null] = ACTIONS(1016),
    [sym_inf] = ACTIONS(1016),
    [sym_nan] = ACTIONS(1016),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1014),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [154] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_RBRACK] = ACTIONS(610),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [anon_sym_i] = ACTIONS(1018),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [155] = {
    [sym_function_definition] = STATE(853),
    [sym_if] = STATE(853),
    [sym_while] = STATE(853),
    [sym_repeat] = STATE(853),
    [sym_for] = STATE(853),
    [sym_switch] = STATE(853),
    [sym_call] = STATE(853),
    [sym__assignment] = STATE(853),
    [sym_left_assignment] = STATE(853),
    [sym_left_assignment2] = STATE(853),
    [sym_equals_assignment] = STATE(853),
    [sym_super_assignment] = STATE(853),
    [sym_right_assignment] = STATE(853),
    [sym_brace_list] = STATE(853),
    [sym_paren_list] = STATE(853),
    [sym_subset] = STATE(853),
    [sym_subset2] = STATE(853),
    [sym_dollar] = STATE(853),
    [sym_slot] = STATE(853),
    [sym_namespace_get] = STATE(853),
    [sym_namespace_get_internal] = STATE(853),
    [sym_unary] = STATE(853),
    [sym_binary] = STATE(853),
    [sym_na] = STATE(853),
    [sym__expression] = STATE(853),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(853),
    [sym_string] = STATE(853),
    [anon_sym_SEMI] = ACTIONS(1020),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1022),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1022),
    [sym_next] = ACTIONS(1022),
    [sym_true] = ACTIONS(1022),
    [sym_false] = ACTIONS(1022),
    [sym_null] = ACTIONS(1022),
    [sym_inf] = ACTIONS(1022),
    [sym_nan] = ACTIONS(1022),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1020),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [156] = {
    [sym_function_definition] = STATE(855),
    [sym_if] = STATE(855),
    [sym_while] = STATE(855),
    [sym_repeat] = STATE(855),
    [sym_for] = STATE(855),
    [sym_switch] = STATE(855),
    [sym_call] = STATE(855),
    [sym__assignment] = STATE(855),
    [sym_left_assignment] = STATE(855),
    [sym_left_assignment2] = STATE(855),
    [sym_equals_assignment] = STATE(855),
    [sym_super_assignment] = STATE(855),
    [sym_right_assignment] = STATE(855),
    [sym_brace_list] = STATE(855),
    [sym_paren_list] = STATE(855),
    [sym_subset] = STATE(855),
    [sym_subset2] = STATE(855),
    [sym_dollar] = STATE(855),
    [sym_slot] = STATE(855),
    [sym_namespace_get] = STATE(855),
    [sym_namespace_get_internal] = STATE(855),
    [sym_unary] = STATE(855),
    [sym_binary] = STATE(855),
    [sym_na] = STATE(855),
    [sym__expression] = STATE(855),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(855),
    [sym_string] = STATE(855),
    [anon_sym_SEMI] = ACTIONS(1024),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1026),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1026),
    [sym_next] = ACTIONS(1026),
    [sym_true] = ACTIONS(1026),
    [sym_false] = ACTIONS(1026),
    [sym_null] = ACTIONS(1026),
    [sym_inf] = ACTIONS(1026),
    [sym_nan] = ACTIONS(1026),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1024),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [157] = {
    [sym_function_definition] = STATE(187),
    [sym_if] = STATE(187),
    [sym_while] = STATE(187),
    [sym_repeat] = STATE(187),
    [sym_for] = STATE(187),
    [sym_switch] = STATE(187),
    [sym_call] = STATE(187),
    [sym__assignment] = STATE(187),
    [sym_left_assignment] = STATE(187),
    [sym_left_assignment2] = STATE(187),
    [sym_equals_assignment] = STATE(187),
    [sym_super_assignment] = STATE(187),
    [sym_right_assignment] = STATE(187),
    [sym_brace_list] = STATE(187),
    [sym_paren_list] = STATE(187),
    [sym_subset] = STATE(187),
    [sym_subset2] = STATE(187),
    [sym_dollar] = STATE(187),
    [sym_slot] = STATE(187),
    [sym_namespace_get] = STATE(187),
    [sym_namespace_get_internal] = STATE(187),
    [sym_unary] = STATE(187),
    [sym_binary] = STATE(187),
    [sym_na] = STATE(187),
    [sym__expression] = STATE(187),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(187),
    [sym_string] = STATE(187),
    [anon_sym_SEMI] = ACTIONS(1028),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1030),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1030),
    [sym_next] = ACTIONS(1030),
    [sym_true] = ACTIONS(1030),
    [sym_false] = ACTIONS(1030),
    [sym_null] = ACTIONS(1030),
    [sym_inf] = ACTIONS(1030),
    [sym_nan] = ACTIONS(1030),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1028),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [158] = {
    [sym_function_definition] = STATE(856),
    [sym_if] = STATE(856),
    [sym_while] = STATE(856),
    [sym_repeat] = STATE(856),
    [sym_for] = STATE(856),
    [sym_switch] = STATE(856),
    [sym_call] = STATE(856),
    [sym__assignment] = STATE(856),
    [sym_left_assignment] = STATE(856),
    [sym_left_assignment2] = STATE(856),
    [sym_equals_assignment] = STATE(856),
    [sym_super_assignment] = STATE(856),
    [sym_right_assignment] = STATE(856),
    [sym_brace_list] = STATE(856),
    [sym_paren_list] = STATE(856),
    [sym_subset] = STATE(856),
    [sym_subset2] = STATE(856),
    [sym_dollar] = STATE(856),
    [sym_slot] = STATE(856),
    [sym_namespace_get] = STATE(856),
    [sym_namespace_get_internal] = STATE(856),
    [sym_unary] = STATE(856),
    [sym_binary] = STATE(856),
    [sym_na] = STATE(856),
    [sym__expression] = STATE(856),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(856),
    [sym_string] = STATE(856),
    [anon_sym_SEMI] = ACTIONS(1032),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1034),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1034),
    [sym_next] = ACTIONS(1034),
    [sym_true] = ACTIONS(1034),
    [sym_false] = ACTIONS(1034),
    [sym_null] = ACTIONS(1034),
    [sym_inf] = ACTIONS(1034),
    [sym_nan] = ACTIONS(1034),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1032),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [159] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_function] = ACTIONS(726),
    [anon_sym_if] = ACTIONS(726),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(726),
    [anon_sym_repeat] = ACTIONS(726),
    [anon_sym_for] = ACTIONS(726),
    [anon_sym_switch] = ACTIONS(726),
    [anon_sym_COMMA] = ACTIONS(724),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(724),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(726),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(726),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(726),
    [sym_next] = ACTIONS(726),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_null] = ACTIONS(726),
    [sym_inf] = ACTIONS(726),
    [sym_nan] = ACTIONS(726),
    [anon_sym_NA] = ACTIONS(726),
    [anon_sym_NA_character_] = ACTIONS(726),
    [anon_sym_NA_complex_] = ACTIONS(726),
    [anon_sym_NA_integer_] = ACTIONS(726),
    [anon_sym_NA_real_] = ACTIONS(726),
    [aux_sym_identifier_token1] = ACTIONS(726),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_integer] = ACTIONS(724),
    [sym_float] = ACTIONS(726),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(724),
    [anon_sym_SQUOTE] = ACTIONS(724),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [160] = {
    [sym_function_definition] = STATE(858),
    [sym_if] = STATE(858),
    [sym_while] = STATE(858),
    [sym_repeat] = STATE(858),
    [sym_for] = STATE(858),
    [sym_switch] = STATE(858),
    [sym_call] = STATE(858),
    [sym__assignment] = STATE(858),
    [sym_left_assignment] = STATE(858),
    [sym_left_assignment2] = STATE(858),
    [sym_equals_assignment] = STATE(858),
    [sym_super_assignment] = STATE(858),
    [sym_right_assignment] = STATE(858),
    [sym_brace_list] = STATE(858),
    [sym_paren_list] = STATE(858),
    [sym_subset] = STATE(858),
    [sym_subset2] = STATE(858),
    [sym_dollar] = STATE(858),
    [sym_slot] = STATE(858),
    [sym_namespace_get] = STATE(858),
    [sym_namespace_get_internal] = STATE(858),
    [sym_unary] = STATE(858),
    [sym_binary] = STATE(858),
    [sym_na] = STATE(858),
    [sym__expression] = STATE(858),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(858),
    [sym_string] = STATE(858),
    [anon_sym_SEMI] = ACTIONS(1036),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1038),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1038),
    [sym_next] = ACTIONS(1038),
    [sym_true] = ACTIONS(1038),
    [sym_false] = ACTIONS(1038),
    [sym_null] = ACTIONS(1038),
    [sym_inf] = ACTIONS(1038),
    [sym_nan] = ACTIONS(1038),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1036),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [161] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_LT_LT_DASH] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(720),
    [anon_sym_SLASH] = ACTIONS(720),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(722),
    [anon_sym_LT_EQ] = ACTIONS(720),
    [anon_sym_GT_EQ] = ACTIONS(720),
    [anon_sym_EQ_EQ] = ACTIONS(720),
    [anon_sym_BANG_EQ] = ACTIONS(720),
    [anon_sym_PIPE_PIPE] = ACTIONS(720),
    [anon_sym_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(720),
    [anon_sym_AMP] = ACTIONS(722),
    [anon_sym_COLON] = ACTIONS(722),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(720),
  },
  [162] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_LT_LT_DASH] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(720),
    [anon_sym_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(720),
    [anon_sym_AMP] = ACTIONS(722),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [163] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_COMMA] = ACTIONS(720),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_LT_DASH] = ACTIONS(720),
    [anon_sym_COLON_EQ] = ACTIONS(720),
    [anon_sym_LT_LT_DASH] = ACTIONS(720),
    [anon_sym_DASH_GT] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(720),
    [sym_integer] = ACTIONS(720),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [164] = {
    [sym_function_definition] = STATE(859),
    [sym_if] = STATE(859),
    [sym_while] = STATE(859),
    [sym_repeat] = STATE(859),
    [sym_for] = STATE(859),
    [sym_switch] = STATE(859),
    [sym_call] = STATE(859),
    [sym__assignment] = STATE(859),
    [sym_left_assignment] = STATE(859),
    [sym_left_assignment2] = STATE(859),
    [sym_equals_assignment] = STATE(859),
    [sym_super_assignment] = STATE(859),
    [sym_right_assignment] = STATE(859),
    [sym_brace_list] = STATE(859),
    [sym_paren_list] = STATE(859),
    [sym_subset] = STATE(859),
    [sym_subset2] = STATE(859),
    [sym_dollar] = STATE(859),
    [sym_slot] = STATE(859),
    [sym_namespace_get] = STATE(859),
    [sym_namespace_get_internal] = STATE(859),
    [sym_unary] = STATE(859),
    [sym_binary] = STATE(859),
    [sym_na] = STATE(859),
    [sym__expression] = STATE(859),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(859),
    [sym_string] = STATE(859),
    [anon_sym_SEMI] = ACTIONS(1040),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1042),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1042),
    [sym_next] = ACTIONS(1042),
    [sym_true] = ACTIONS(1042),
    [sym_false] = ACTIONS(1042),
    [sym_null] = ACTIONS(1042),
    [sym_inf] = ACTIONS(1042),
    [sym_nan] = ACTIONS(1042),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1040),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [165] = {
    [sym_function_definition] = STATE(860),
    [sym_if] = STATE(860),
    [sym_while] = STATE(860),
    [sym_repeat] = STATE(860),
    [sym_for] = STATE(860),
    [sym_switch] = STATE(860),
    [sym_call] = STATE(860),
    [sym__assignment] = STATE(860),
    [sym_left_assignment] = STATE(860),
    [sym_left_assignment2] = STATE(860),
    [sym_equals_assignment] = STATE(860),
    [sym_super_assignment] = STATE(860),
    [sym_right_assignment] = STATE(860),
    [sym_brace_list] = STATE(860),
    [sym_paren_list] = STATE(860),
    [sym_subset] = STATE(860),
    [sym_subset2] = STATE(860),
    [sym_dollar] = STATE(860),
    [sym_slot] = STATE(860),
    [sym_namespace_get] = STATE(860),
    [sym_namespace_get_internal] = STATE(860),
    [sym_unary] = STATE(860),
    [sym_binary] = STATE(860),
    [sym_na] = STATE(860),
    [sym__expression] = STATE(860),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(860),
    [sym_string] = STATE(860),
    [anon_sym_SEMI] = ACTIONS(1044),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1046),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1046),
    [sym_next] = ACTIONS(1046),
    [sym_true] = ACTIONS(1046),
    [sym_false] = ACTIONS(1046),
    [sym_null] = ACTIONS(1046),
    [sym_inf] = ACTIONS(1046),
    [sym_nan] = ACTIONS(1046),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1044),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [166] = {
    [sym_function_definition] = STATE(861),
    [sym_if] = STATE(861),
    [sym_while] = STATE(861),
    [sym_repeat] = STATE(861),
    [sym_for] = STATE(861),
    [sym_switch] = STATE(861),
    [sym_call] = STATE(861),
    [sym__assignment] = STATE(861),
    [sym_left_assignment] = STATE(861),
    [sym_left_assignment2] = STATE(861),
    [sym_equals_assignment] = STATE(861),
    [sym_super_assignment] = STATE(861),
    [sym_right_assignment] = STATE(861),
    [sym_brace_list] = STATE(861),
    [sym_paren_list] = STATE(861),
    [sym_subset] = STATE(861),
    [sym_subset2] = STATE(861),
    [sym_dollar] = STATE(861),
    [sym_slot] = STATE(861),
    [sym_namespace_get] = STATE(861),
    [sym_namespace_get_internal] = STATE(861),
    [sym_unary] = STATE(861),
    [sym_binary] = STATE(861),
    [sym_na] = STATE(861),
    [sym__expression] = STATE(861),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(861),
    [sym_string] = STATE(861),
    [anon_sym_SEMI] = ACTIONS(1048),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1050),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1050),
    [sym_next] = ACTIONS(1050),
    [sym_true] = ACTIONS(1050),
    [sym_false] = ACTIONS(1050),
    [sym_null] = ACTIONS(1050),
    [sym_inf] = ACTIONS(1050),
    [sym_nan] = ACTIONS(1050),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1048),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [167] = {
    [sym_function_definition] = STATE(836),
    [sym_if] = STATE(836),
    [sym_while] = STATE(836),
    [sym_repeat] = STATE(836),
    [sym_for] = STATE(836),
    [sym_switch] = STATE(836),
    [sym_call] = STATE(836),
    [sym__assignment] = STATE(836),
    [sym_left_assignment] = STATE(836),
    [sym_left_assignment2] = STATE(836),
    [sym_equals_assignment] = STATE(836),
    [sym_super_assignment] = STATE(836),
    [sym_right_assignment] = STATE(836),
    [sym_brace_list] = STATE(836),
    [sym_paren_list] = STATE(836),
    [sym_subset] = STATE(836),
    [sym_subset2] = STATE(836),
    [sym_dollar] = STATE(836),
    [sym_slot] = STATE(836),
    [sym_namespace_get] = STATE(836),
    [sym_namespace_get_internal] = STATE(836),
    [sym_unary] = STATE(836),
    [sym_binary] = STATE(836),
    [sym_na] = STATE(836),
    [sym__expression] = STATE(836),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(836),
    [sym_string] = STATE(836),
    [anon_sym_SEMI] = ACTIONS(1052),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1054),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1054),
    [sym_next] = ACTIONS(1054),
    [sym_true] = ACTIONS(1054),
    [sym_false] = ACTIONS(1054),
    [sym_null] = ACTIONS(1054),
    [sym_inf] = ACTIONS(1054),
    [sym_nan] = ACTIONS(1054),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1052),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [168] = {
    [sym_function_definition] = STATE(198),
    [sym_if] = STATE(198),
    [sym_while] = STATE(198),
    [sym_repeat] = STATE(198),
    [sym_for] = STATE(198),
    [sym_switch] = STATE(198),
    [sym_call] = STATE(198),
    [sym__assignment] = STATE(198),
    [sym_left_assignment] = STATE(198),
    [sym_left_assignment2] = STATE(198),
    [sym_equals_assignment] = STATE(198),
    [sym_super_assignment] = STATE(198),
    [sym_right_assignment] = STATE(198),
    [sym_brace_list] = STATE(198),
    [sym_paren_list] = STATE(198),
    [sym_subset] = STATE(198),
    [sym_subset2] = STATE(198),
    [sym_dollar] = STATE(198),
    [sym_slot] = STATE(198),
    [sym_namespace_get] = STATE(198),
    [sym_namespace_get_internal] = STATE(198),
    [sym_unary] = STATE(198),
    [sym_binary] = STATE(198),
    [sym_na] = STATE(198),
    [sym__expression] = STATE(198),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(198),
    [sym_string] = STATE(198),
    [anon_sym_SEMI] = ACTIONS(1056),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1058),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1058),
    [sym_next] = ACTIONS(1058),
    [sym_true] = ACTIONS(1058),
    [sym_false] = ACTIONS(1058),
    [sym_null] = ACTIONS(1058),
    [sym_inf] = ACTIONS(1058),
    [sym_nan] = ACTIONS(1058),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1056),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [169] = {
    [sym_function_definition] = STATE(199),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_repeat] = STATE(199),
    [sym_for] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_call] = STATE(199),
    [sym__assignment] = STATE(199),
    [sym_left_assignment] = STATE(199),
    [sym_left_assignment2] = STATE(199),
    [sym_equals_assignment] = STATE(199),
    [sym_super_assignment] = STATE(199),
    [sym_right_assignment] = STATE(199),
    [sym_brace_list] = STATE(199),
    [sym_paren_list] = STATE(199),
    [sym_subset] = STATE(199),
    [sym_subset2] = STATE(199),
    [sym_dollar] = STATE(199),
    [sym_slot] = STATE(199),
    [sym_namespace_get] = STATE(199),
    [sym_namespace_get_internal] = STATE(199),
    [sym_unary] = STATE(199),
    [sym_binary] = STATE(199),
    [sym_na] = STATE(199),
    [sym__expression] = STATE(199),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(199),
    [sym_string] = STATE(199),
    [anon_sym_SEMI] = ACTIONS(1060),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1062),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1062),
    [sym_next] = ACTIONS(1062),
    [sym_true] = ACTIONS(1062),
    [sym_false] = ACTIONS(1062),
    [sym_null] = ACTIONS(1062),
    [sym_inf] = ACTIONS(1062),
    [sym_nan] = ACTIONS(1062),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1060),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [170] = {
    [sym_function_definition] = STATE(200),
    [sym_if] = STATE(200),
    [sym_while] = STATE(200),
    [sym_repeat] = STATE(200),
    [sym_for] = STATE(200),
    [sym_switch] = STATE(200),
    [sym_call] = STATE(200),
    [sym__assignment] = STATE(200),
    [sym_left_assignment] = STATE(200),
    [sym_left_assignment2] = STATE(200),
    [sym_equals_assignment] = STATE(200),
    [sym_super_assignment] = STATE(200),
    [sym_right_assignment] = STATE(200),
    [sym_brace_list] = STATE(200),
    [sym_paren_list] = STATE(200),
    [sym_subset] = STATE(200),
    [sym_subset2] = STATE(200),
    [sym_dollar] = STATE(200),
    [sym_slot] = STATE(200),
    [sym_namespace_get] = STATE(200),
    [sym_namespace_get_internal] = STATE(200),
    [sym_unary] = STATE(200),
    [sym_binary] = STATE(200),
    [sym_na] = STATE(200),
    [sym__expression] = STATE(200),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(200),
    [sym_string] = STATE(200),
    [anon_sym_SEMI] = ACTIONS(1064),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1066),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1066),
    [sym_next] = ACTIONS(1066),
    [sym_true] = ACTIONS(1066),
    [sym_false] = ACTIONS(1066),
    [sym_null] = ACTIONS(1066),
    [sym_inf] = ACTIONS(1066),
    [sym_nan] = ACTIONS(1066),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1064),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [171] = {
    [sym_function_definition] = STATE(201),
    [sym_if] = STATE(201),
    [sym_while] = STATE(201),
    [sym_repeat] = STATE(201),
    [sym_for] = STATE(201),
    [sym_switch] = STATE(201),
    [sym_call] = STATE(201),
    [sym__assignment] = STATE(201),
    [sym_left_assignment] = STATE(201),
    [sym_left_assignment2] = STATE(201),
    [sym_equals_assignment] = STATE(201),
    [sym_super_assignment] = STATE(201),
    [sym_right_assignment] = STATE(201),
    [sym_brace_list] = STATE(201),
    [sym_paren_list] = STATE(201),
    [sym_subset] = STATE(201),
    [sym_subset2] = STATE(201),
    [sym_dollar] = STATE(201),
    [sym_slot] = STATE(201),
    [sym_namespace_get] = STATE(201),
    [sym_namespace_get_internal] = STATE(201),
    [sym_unary] = STATE(201),
    [sym_binary] = STATE(201),
    [sym_na] = STATE(201),
    [sym__expression] = STATE(201),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(201),
    [sym_string] = STATE(201),
    [anon_sym_SEMI] = ACTIONS(1068),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1070),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1070),
    [sym_next] = ACTIONS(1070),
    [sym_true] = ACTIONS(1070),
    [sym_false] = ACTIONS(1070),
    [sym_null] = ACTIONS(1070),
    [sym_inf] = ACTIONS(1070),
    [sym_nan] = ACTIONS(1070),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1068),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [172] = {
    [sym_function_definition] = STATE(202),
    [sym_if] = STATE(202),
    [sym_while] = STATE(202),
    [sym_repeat] = STATE(202),
    [sym_for] = STATE(202),
    [sym_switch] = STATE(202),
    [sym_call] = STATE(202),
    [sym__assignment] = STATE(202),
    [sym_left_assignment] = STATE(202),
    [sym_left_assignment2] = STATE(202),
    [sym_equals_assignment] = STATE(202),
    [sym_super_assignment] = STATE(202),
    [sym_right_assignment] = STATE(202),
    [sym_brace_list] = STATE(202),
    [sym_paren_list] = STATE(202),
    [sym_subset] = STATE(202),
    [sym_subset2] = STATE(202),
    [sym_dollar] = STATE(202),
    [sym_slot] = STATE(202),
    [sym_namespace_get] = STATE(202),
    [sym_namespace_get_internal] = STATE(202),
    [sym_unary] = STATE(202),
    [sym_binary] = STATE(202),
    [sym_na] = STATE(202),
    [sym__expression] = STATE(202),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(202),
    [sym_string] = STATE(202),
    [anon_sym_SEMI] = ACTIONS(1072),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1074),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1074),
    [sym_next] = ACTIONS(1074),
    [sym_true] = ACTIONS(1074),
    [sym_false] = ACTIONS(1074),
    [sym_null] = ACTIONS(1074),
    [sym_inf] = ACTIONS(1074),
    [sym_nan] = ACTIONS(1074),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1072),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [173] = {
    [sym_function_definition] = STATE(846),
    [sym_if] = STATE(846),
    [sym_while] = STATE(846),
    [sym_repeat] = STATE(846),
    [sym_for] = STATE(846),
    [sym_switch] = STATE(846),
    [sym_call] = STATE(846),
    [sym__assignment] = STATE(846),
    [sym_left_assignment] = STATE(846),
    [sym_left_assignment2] = STATE(846),
    [sym_equals_assignment] = STATE(846),
    [sym_super_assignment] = STATE(846),
    [sym_right_assignment] = STATE(846),
    [sym_brace_list] = STATE(846),
    [sym_paren_list] = STATE(846),
    [sym_subset] = STATE(846),
    [sym_subset2] = STATE(846),
    [sym_dollar] = STATE(846),
    [sym_slot] = STATE(846),
    [sym_namespace_get] = STATE(846),
    [sym_namespace_get_internal] = STATE(846),
    [sym_unary] = STATE(846),
    [sym_binary] = STATE(846),
    [sym_na] = STATE(846),
    [sym__expression] = STATE(846),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(846),
    [sym_string] = STATE(846),
    [anon_sym_SEMI] = ACTIONS(1076),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1078),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1078),
    [sym_next] = ACTIONS(1078),
    [sym_true] = ACTIONS(1078),
    [sym_false] = ACTIONS(1078),
    [sym_null] = ACTIONS(1078),
    [sym_inf] = ACTIONS(1078),
    [sym_nan] = ACTIONS(1078),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1076),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [174] = {
    [sym_function_definition] = STATE(570),
    [sym_if] = STATE(570),
    [sym_while] = STATE(570),
    [sym_repeat] = STATE(570),
    [sym_for] = STATE(570),
    [sym_switch] = STATE(570),
    [sym_call] = STATE(570),
    [sym__assignment] = STATE(570),
    [sym_left_assignment] = STATE(570),
    [sym_left_assignment2] = STATE(570),
    [sym_equals_assignment] = STATE(570),
    [sym_super_assignment] = STATE(570),
    [sym_right_assignment] = STATE(570),
    [sym_brace_list] = STATE(570),
    [sym_paren_list] = STATE(570),
    [sym_subset] = STATE(570),
    [sym_subset2] = STATE(570),
    [sym_dollar] = STATE(570),
    [sym_slot] = STATE(570),
    [sym_namespace_get] = STATE(570),
    [sym_namespace_get_internal] = STATE(570),
    [sym_unary] = STATE(570),
    [sym_binary] = STATE(570),
    [sym_na] = STATE(570),
    [sym__expression] = STATE(570),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(570),
    [sym_string] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(1080),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1082),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1082),
    [sym_next] = ACTIONS(1082),
    [sym_true] = ACTIONS(1082),
    [sym_false] = ACTIONS(1082),
    [sym_null] = ACTIONS(1082),
    [sym_inf] = ACTIONS(1082),
    [sym_nan] = ACTIONS(1082),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1080),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [175] = {
    [sym_function_definition] = STATE(207),
    [sym_if] = STATE(207),
    [sym_while] = STATE(207),
    [sym_repeat] = STATE(207),
    [sym_for] = STATE(207),
    [sym_switch] = STATE(207),
    [sym_call] = STATE(207),
    [sym__assignment] = STATE(207),
    [sym_left_assignment] = STATE(207),
    [sym_left_assignment2] = STATE(207),
    [sym_equals_assignment] = STATE(207),
    [sym_super_assignment] = STATE(207),
    [sym_right_assignment] = STATE(207),
    [sym_brace_list] = STATE(207),
    [sym_paren_list] = STATE(207),
    [sym_subset] = STATE(207),
    [sym_subset2] = STATE(207),
    [sym_dollar] = STATE(207),
    [sym_slot] = STATE(207),
    [sym_namespace_get] = STATE(207),
    [sym_namespace_get_internal] = STATE(207),
    [sym_unary] = STATE(207),
    [sym_binary] = STATE(207),
    [sym_na] = STATE(207),
    [sym__expression] = STATE(207),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(207),
    [sym_string] = STATE(207),
    [anon_sym_SEMI] = ACTIONS(1084),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1086),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1086),
    [sym_next] = ACTIONS(1086),
    [sym_true] = ACTIONS(1086),
    [sym_false] = ACTIONS(1086),
    [sym_null] = ACTIONS(1086),
    [sym_inf] = ACTIONS(1086),
    [sym_nan] = ACTIONS(1086),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1084),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [176] = {
    [sym_function_definition] = STATE(208),
    [sym_if] = STATE(208),
    [sym_while] = STATE(208),
    [sym_repeat] = STATE(208),
    [sym_for] = STATE(208),
    [sym_switch] = STATE(208),
    [sym_call] = STATE(208),
    [sym__assignment] = STATE(208),
    [sym_left_assignment] = STATE(208),
    [sym_left_assignment2] = STATE(208),
    [sym_equals_assignment] = STATE(208),
    [sym_super_assignment] = STATE(208),
    [sym_right_assignment] = STATE(208),
    [sym_brace_list] = STATE(208),
    [sym_paren_list] = STATE(208),
    [sym_subset] = STATE(208),
    [sym_subset2] = STATE(208),
    [sym_dollar] = STATE(208),
    [sym_slot] = STATE(208),
    [sym_namespace_get] = STATE(208),
    [sym_namespace_get_internal] = STATE(208),
    [sym_unary] = STATE(208),
    [sym_binary] = STATE(208),
    [sym_na] = STATE(208),
    [sym__expression] = STATE(208),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(208),
    [sym_string] = STATE(208),
    [anon_sym_SEMI] = ACTIONS(1088),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1090),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1090),
    [sym_next] = ACTIONS(1090),
    [sym_true] = ACTIONS(1090),
    [sym_false] = ACTIONS(1090),
    [sym_null] = ACTIONS(1090),
    [sym_inf] = ACTIONS(1090),
    [sym_nan] = ACTIONS(1090),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1088),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [177] = {
    [sym_function_definition] = STATE(209),
    [sym_if] = STATE(209),
    [sym_while] = STATE(209),
    [sym_repeat] = STATE(209),
    [sym_for] = STATE(209),
    [sym_switch] = STATE(209),
    [sym_call] = STATE(209),
    [sym__assignment] = STATE(209),
    [sym_left_assignment] = STATE(209),
    [sym_left_assignment2] = STATE(209),
    [sym_equals_assignment] = STATE(209),
    [sym_super_assignment] = STATE(209),
    [sym_right_assignment] = STATE(209),
    [sym_brace_list] = STATE(209),
    [sym_paren_list] = STATE(209),
    [sym_subset] = STATE(209),
    [sym_subset2] = STATE(209),
    [sym_dollar] = STATE(209),
    [sym_slot] = STATE(209),
    [sym_namespace_get] = STATE(209),
    [sym_namespace_get_internal] = STATE(209),
    [sym_unary] = STATE(209),
    [sym_binary] = STATE(209),
    [sym_na] = STATE(209),
    [sym__expression] = STATE(209),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(209),
    [sym_string] = STATE(209),
    [anon_sym_SEMI] = ACTIONS(1092),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1094),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1094),
    [sym_next] = ACTIONS(1094),
    [sym_true] = ACTIONS(1094),
    [sym_false] = ACTIONS(1094),
    [sym_null] = ACTIONS(1094),
    [sym_inf] = ACTIONS(1094),
    [sym_nan] = ACTIONS(1094),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1092),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [178] = {
    [sym_function_definition] = STATE(210),
    [sym_if] = STATE(210),
    [sym_while] = STATE(210),
    [sym_repeat] = STATE(210),
    [sym_for] = STATE(210),
    [sym_switch] = STATE(210),
    [sym_call] = STATE(210),
    [sym__assignment] = STATE(210),
    [sym_left_assignment] = STATE(210),
    [sym_left_assignment2] = STATE(210),
    [sym_equals_assignment] = STATE(210),
    [sym_super_assignment] = STATE(210),
    [sym_right_assignment] = STATE(210),
    [sym_brace_list] = STATE(210),
    [sym_paren_list] = STATE(210),
    [sym_subset] = STATE(210),
    [sym_subset2] = STATE(210),
    [sym_dollar] = STATE(210),
    [sym_slot] = STATE(210),
    [sym_namespace_get] = STATE(210),
    [sym_namespace_get_internal] = STATE(210),
    [sym_unary] = STATE(210),
    [sym_binary] = STATE(210),
    [sym_na] = STATE(210),
    [sym__expression] = STATE(210),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(210),
    [sym_string] = STATE(210),
    [anon_sym_SEMI] = ACTIONS(1096),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1098),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1098),
    [sym_next] = ACTIONS(1098),
    [sym_true] = ACTIONS(1098),
    [sym_false] = ACTIONS(1098),
    [sym_null] = ACTIONS(1098),
    [sym_inf] = ACTIONS(1098),
    [sym_nan] = ACTIONS(1098),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1096),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [179] = {
    [sym_function_definition] = STATE(211),
    [sym_if] = STATE(211),
    [sym_while] = STATE(211),
    [sym_repeat] = STATE(211),
    [sym_for] = STATE(211),
    [sym_switch] = STATE(211),
    [sym_call] = STATE(211),
    [sym__assignment] = STATE(211),
    [sym_left_assignment] = STATE(211),
    [sym_left_assignment2] = STATE(211),
    [sym_equals_assignment] = STATE(211),
    [sym_super_assignment] = STATE(211),
    [sym_right_assignment] = STATE(211),
    [sym_brace_list] = STATE(211),
    [sym_paren_list] = STATE(211),
    [sym_subset] = STATE(211),
    [sym_subset2] = STATE(211),
    [sym_dollar] = STATE(211),
    [sym_slot] = STATE(211),
    [sym_namespace_get] = STATE(211),
    [sym_namespace_get_internal] = STATE(211),
    [sym_unary] = STATE(211),
    [sym_binary] = STATE(211),
    [sym_na] = STATE(211),
    [sym__expression] = STATE(211),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(211),
    [sym_string] = STATE(211),
    [anon_sym_SEMI] = ACTIONS(1100),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1102),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1102),
    [sym_next] = ACTIONS(1102),
    [sym_true] = ACTIONS(1102),
    [sym_false] = ACTIONS(1102),
    [sym_null] = ACTIONS(1102),
    [sym_inf] = ACTIONS(1102),
    [sym_nan] = ACTIONS(1102),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1100),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [180] = {
    [sym_function_definition] = STATE(212),
    [sym_if] = STATE(212),
    [sym_while] = STATE(212),
    [sym_repeat] = STATE(212),
    [sym_for] = STATE(212),
    [sym_switch] = STATE(212),
    [sym_call] = STATE(212),
    [sym__assignment] = STATE(212),
    [sym_left_assignment] = STATE(212),
    [sym_left_assignment2] = STATE(212),
    [sym_equals_assignment] = STATE(212),
    [sym_super_assignment] = STATE(212),
    [sym_right_assignment] = STATE(212),
    [sym_brace_list] = STATE(212),
    [sym_paren_list] = STATE(212),
    [sym_subset] = STATE(212),
    [sym_subset2] = STATE(212),
    [sym_dollar] = STATE(212),
    [sym_slot] = STATE(212),
    [sym_namespace_get] = STATE(212),
    [sym_namespace_get_internal] = STATE(212),
    [sym_unary] = STATE(212),
    [sym_binary] = STATE(212),
    [sym_na] = STATE(212),
    [sym__expression] = STATE(212),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(212),
    [sym_string] = STATE(212),
    [anon_sym_SEMI] = ACTIONS(1104),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1106),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1106),
    [sym_next] = ACTIONS(1106),
    [sym_true] = ACTIONS(1106),
    [sym_false] = ACTIONS(1106),
    [sym_null] = ACTIONS(1106),
    [sym_inf] = ACTIONS(1106),
    [sym_nan] = ACTIONS(1106),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1104),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [181] = {
    [sym_function_definition] = STATE(213),
    [sym_if] = STATE(213),
    [sym_while] = STATE(213),
    [sym_repeat] = STATE(213),
    [sym_for] = STATE(213),
    [sym_switch] = STATE(213),
    [sym_call] = STATE(213),
    [sym__assignment] = STATE(213),
    [sym_left_assignment] = STATE(213),
    [sym_left_assignment2] = STATE(213),
    [sym_equals_assignment] = STATE(213),
    [sym_super_assignment] = STATE(213),
    [sym_right_assignment] = STATE(213),
    [sym_brace_list] = STATE(213),
    [sym_paren_list] = STATE(213),
    [sym_subset] = STATE(213),
    [sym_subset2] = STATE(213),
    [sym_dollar] = STATE(213),
    [sym_slot] = STATE(213),
    [sym_namespace_get] = STATE(213),
    [sym_namespace_get_internal] = STATE(213),
    [sym_unary] = STATE(213),
    [sym_binary] = STATE(213),
    [sym_na] = STATE(213),
    [sym__expression] = STATE(213),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(213),
    [sym_string] = STATE(213),
    [anon_sym_SEMI] = ACTIONS(1108),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1110),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1110),
    [sym_next] = ACTIONS(1110),
    [sym_true] = ACTIONS(1110),
    [sym_false] = ACTIONS(1110),
    [sym_null] = ACTIONS(1110),
    [sym_inf] = ACTIONS(1110),
    [sym_nan] = ACTIONS(1110),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1108),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [182] = {
    [sym_function_definition] = STATE(214),
    [sym_if] = STATE(214),
    [sym_while] = STATE(214),
    [sym_repeat] = STATE(214),
    [sym_for] = STATE(214),
    [sym_switch] = STATE(214),
    [sym_call] = STATE(214),
    [sym__assignment] = STATE(214),
    [sym_left_assignment] = STATE(214),
    [sym_left_assignment2] = STATE(214),
    [sym_equals_assignment] = STATE(214),
    [sym_super_assignment] = STATE(214),
    [sym_right_assignment] = STATE(214),
    [sym_brace_list] = STATE(214),
    [sym_paren_list] = STATE(214),
    [sym_subset] = STATE(214),
    [sym_subset2] = STATE(214),
    [sym_dollar] = STATE(214),
    [sym_slot] = STATE(214),
    [sym_namespace_get] = STATE(214),
    [sym_namespace_get_internal] = STATE(214),
    [sym_unary] = STATE(214),
    [sym_binary] = STATE(214),
    [sym_na] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(214),
    [sym_string] = STATE(214),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1114),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1114),
    [sym_next] = ACTIONS(1114),
    [sym_true] = ACTIONS(1114),
    [sym_false] = ACTIONS(1114),
    [sym_null] = ACTIONS(1114),
    [sym_inf] = ACTIONS(1114),
    [sym_nan] = ACTIONS(1114),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1112),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [183] = {
    [sym_function_definition] = STATE(215),
    [sym_if] = STATE(215),
    [sym_while] = STATE(215),
    [sym_repeat] = STATE(215),
    [sym_for] = STATE(215),
    [sym_switch] = STATE(215),
    [sym_call] = STATE(215),
    [sym__assignment] = STATE(215),
    [sym_left_assignment] = STATE(215),
    [sym_left_assignment2] = STATE(215),
    [sym_equals_assignment] = STATE(215),
    [sym_super_assignment] = STATE(215),
    [sym_right_assignment] = STATE(215),
    [sym_brace_list] = STATE(215),
    [sym_paren_list] = STATE(215),
    [sym_subset] = STATE(215),
    [sym_subset2] = STATE(215),
    [sym_dollar] = STATE(215),
    [sym_slot] = STATE(215),
    [sym_namespace_get] = STATE(215),
    [sym_namespace_get_internal] = STATE(215),
    [sym_unary] = STATE(215),
    [sym_binary] = STATE(215),
    [sym_na] = STATE(215),
    [sym__expression] = STATE(215),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(215),
    [sym_string] = STATE(215),
    [anon_sym_SEMI] = ACTIONS(1116),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1118),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1118),
    [sym_next] = ACTIONS(1118),
    [sym_true] = ACTIONS(1118),
    [sym_false] = ACTIONS(1118),
    [sym_null] = ACTIONS(1118),
    [sym_inf] = ACTIONS(1118),
    [sym_nan] = ACTIONS(1118),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1116),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [184] = {
    [sym_function_definition] = STATE(839),
    [sym_if] = STATE(839),
    [sym_while] = STATE(839),
    [sym_repeat] = STATE(839),
    [sym_for] = STATE(839),
    [sym_switch] = STATE(839),
    [sym_call] = STATE(839),
    [sym__assignment] = STATE(839),
    [sym_left_assignment] = STATE(839),
    [sym_left_assignment2] = STATE(839),
    [sym_equals_assignment] = STATE(839),
    [sym_super_assignment] = STATE(839),
    [sym_right_assignment] = STATE(839),
    [sym_brace_list] = STATE(839),
    [sym_paren_list] = STATE(839),
    [sym_subset] = STATE(839),
    [sym_subset2] = STATE(839),
    [sym_dollar] = STATE(839),
    [sym_slot] = STATE(839),
    [sym_namespace_get] = STATE(839),
    [sym_namespace_get_internal] = STATE(839),
    [sym_unary] = STATE(839),
    [sym_binary] = STATE(839),
    [sym_na] = STATE(839),
    [sym__expression] = STATE(839),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(839),
    [sym_string] = STATE(839),
    [anon_sym_SEMI] = ACTIONS(1120),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1122),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1122),
    [sym_next] = ACTIONS(1122),
    [sym_true] = ACTIONS(1122),
    [sym_false] = ACTIONS(1122),
    [sym_null] = ACTIONS(1122),
    [sym_inf] = ACTIONS(1122),
    [sym_nan] = ACTIONS(1122),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1120),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [185] = {
    [sym_function_definition] = STATE(837),
    [sym_if] = STATE(837),
    [sym_while] = STATE(837),
    [sym_repeat] = STATE(837),
    [sym_for] = STATE(837),
    [sym_switch] = STATE(837),
    [sym_call] = STATE(837),
    [sym__assignment] = STATE(837),
    [sym_left_assignment] = STATE(837),
    [sym_left_assignment2] = STATE(837),
    [sym_equals_assignment] = STATE(837),
    [sym_super_assignment] = STATE(837),
    [sym_right_assignment] = STATE(837),
    [sym_brace_list] = STATE(837),
    [sym_paren_list] = STATE(837),
    [sym_subset] = STATE(837),
    [sym_subset2] = STATE(837),
    [sym_dollar] = STATE(837),
    [sym_slot] = STATE(837),
    [sym_namespace_get] = STATE(837),
    [sym_namespace_get_internal] = STATE(837),
    [sym_unary] = STATE(837),
    [sym_binary] = STATE(837),
    [sym_na] = STATE(837),
    [sym__expression] = STATE(837),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(837),
    [sym_string] = STATE(837),
    [anon_sym_SEMI] = ACTIONS(1124),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1126),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1126),
    [sym_next] = ACTIONS(1126),
    [sym_true] = ACTIONS(1126),
    [sym_false] = ACTIONS(1126),
    [sym_null] = ACTIONS(1126),
    [sym_inf] = ACTIONS(1126),
    [sym_nan] = ACTIONS(1126),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1124),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [186] = {
    [sym_function_definition] = STATE(835),
    [sym_if] = STATE(835),
    [sym_while] = STATE(835),
    [sym_repeat] = STATE(835),
    [sym_for] = STATE(835),
    [sym_switch] = STATE(835),
    [sym_call] = STATE(835),
    [sym__assignment] = STATE(835),
    [sym_left_assignment] = STATE(835),
    [sym_left_assignment2] = STATE(835),
    [sym_equals_assignment] = STATE(835),
    [sym_super_assignment] = STATE(835),
    [sym_right_assignment] = STATE(835),
    [sym_brace_list] = STATE(835),
    [sym_paren_list] = STATE(835),
    [sym_subset] = STATE(835),
    [sym_subset2] = STATE(835),
    [sym_dollar] = STATE(835),
    [sym_slot] = STATE(835),
    [sym_namespace_get] = STATE(835),
    [sym_namespace_get_internal] = STATE(835),
    [sym_unary] = STATE(835),
    [sym_binary] = STATE(835),
    [sym_na] = STATE(835),
    [sym__expression] = STATE(835),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(835),
    [sym_string] = STATE(835),
    [anon_sym_SEMI] = ACTIONS(1128),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1130),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1130),
    [sym_next] = ACTIONS(1130),
    [sym_true] = ACTIONS(1130),
    [sym_false] = ACTIONS(1130),
    [sym_null] = ACTIONS(1130),
    [sym_inf] = ACTIONS(1130),
    [sym_nan] = ACTIONS(1130),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1128),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [187] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_function] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_repeat] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_EQ] = ACTIONS(712),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_LT_DASH] = ACTIONS(710),
    [anon_sym_COLON_EQ] = ACTIONS(710),
    [anon_sym_LT_LT_DASH] = ACTIONS(710),
    [anon_sym_DASH_GT] = ACTIONS(710),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(712),
    [sym_next] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_inf] = ACTIONS(712),
    [sym_nan] = ACTIONS(712),
    [anon_sym_NA] = ACTIONS(712),
    [anon_sym_NA_character_] = ACTIONS(712),
    [anon_sym_NA_complex_] = ACTIONS(712),
    [anon_sym_NA_integer_] = ACTIONS(712),
    [anon_sym_NA_real_] = ACTIONS(712),
    [aux_sym_identifier_token1] = ACTIONS(712),
    [anon_sym_BQUOTE] = ACTIONS(710),
    [sym_integer] = ACTIONS(710),
    [sym_float] = ACTIONS(712),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(710),
    [anon_sym_SQUOTE] = ACTIONS(710),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [188] = {
    [sym_function_definition] = STATE(844),
    [sym_if] = STATE(844),
    [sym_while] = STATE(844),
    [sym_repeat] = STATE(844),
    [sym_for] = STATE(844),
    [sym_switch] = STATE(844),
    [sym_call] = STATE(844),
    [sym__assignment] = STATE(844),
    [sym_left_assignment] = STATE(844),
    [sym_left_assignment2] = STATE(844),
    [sym_equals_assignment] = STATE(844),
    [sym_super_assignment] = STATE(844),
    [sym_right_assignment] = STATE(844),
    [sym_brace_list] = STATE(844),
    [sym_paren_list] = STATE(844),
    [sym_subset] = STATE(844),
    [sym_subset2] = STATE(844),
    [sym_dollar] = STATE(844),
    [sym_slot] = STATE(844),
    [sym_namespace_get] = STATE(844),
    [sym_namespace_get_internal] = STATE(844),
    [sym_unary] = STATE(844),
    [sym_binary] = STATE(844),
    [sym_na] = STATE(844),
    [sym__expression] = STATE(844),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(844),
    [sym_string] = STATE(844),
    [anon_sym_SEMI] = ACTIONS(1132),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1134),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1134),
    [sym_next] = ACTIONS(1134),
    [sym_true] = ACTIONS(1134),
    [sym_false] = ACTIONS(1134),
    [sym_null] = ACTIONS(1134),
    [sym_inf] = ACTIONS(1134),
    [sym_nan] = ACTIONS(1134),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1132),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [189] = {
    [sym_function_definition] = STATE(854),
    [sym_if] = STATE(854),
    [sym_while] = STATE(854),
    [sym_repeat] = STATE(854),
    [sym_for] = STATE(854),
    [sym_switch] = STATE(854),
    [sym_call] = STATE(854),
    [sym__assignment] = STATE(854),
    [sym_left_assignment] = STATE(854),
    [sym_left_assignment2] = STATE(854),
    [sym_equals_assignment] = STATE(854),
    [sym_super_assignment] = STATE(854),
    [sym_right_assignment] = STATE(854),
    [sym_brace_list] = STATE(854),
    [sym_paren_list] = STATE(854),
    [sym_subset] = STATE(854),
    [sym_subset2] = STATE(854),
    [sym_dollar] = STATE(854),
    [sym_slot] = STATE(854),
    [sym_namespace_get] = STATE(854),
    [sym_namespace_get_internal] = STATE(854),
    [sym_unary] = STATE(854),
    [sym_binary] = STATE(854),
    [sym_na] = STATE(854),
    [sym__expression] = STATE(854),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(854),
    [sym_string] = STATE(854),
    [anon_sym_SEMI] = ACTIONS(1136),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1138),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1138),
    [sym_next] = ACTIONS(1138),
    [sym_true] = ACTIONS(1138),
    [sym_false] = ACTIONS(1138),
    [sym_null] = ACTIONS(1138),
    [sym_inf] = ACTIONS(1138),
    [sym_nan] = ACTIONS(1138),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1136),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [190] = {
    [sym_function_definition] = STATE(857),
    [sym_if] = STATE(857),
    [sym_while] = STATE(857),
    [sym_repeat] = STATE(857),
    [sym_for] = STATE(857),
    [sym_switch] = STATE(857),
    [sym_call] = STATE(857),
    [sym__assignment] = STATE(857),
    [sym_left_assignment] = STATE(857),
    [sym_left_assignment2] = STATE(857),
    [sym_equals_assignment] = STATE(857),
    [sym_super_assignment] = STATE(857),
    [sym_right_assignment] = STATE(857),
    [sym_brace_list] = STATE(857),
    [sym_paren_list] = STATE(857),
    [sym_subset] = STATE(857),
    [sym_subset2] = STATE(857),
    [sym_dollar] = STATE(857),
    [sym_slot] = STATE(857),
    [sym_namespace_get] = STATE(857),
    [sym_namespace_get_internal] = STATE(857),
    [sym_unary] = STATE(857),
    [sym_binary] = STATE(857),
    [sym_na] = STATE(857),
    [sym__expression] = STATE(857),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(857),
    [sym_string] = STATE(857),
    [anon_sym_SEMI] = ACTIONS(1140),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1142),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1142),
    [sym_next] = ACTIONS(1142),
    [sym_true] = ACTIONS(1142),
    [sym_false] = ACTIONS(1142),
    [sym_null] = ACTIONS(1142),
    [sym_inf] = ACTIONS(1142),
    [sym_nan] = ACTIONS(1142),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1140),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [191] = {
    [sym_function_definition] = STATE(572),
    [sym_if] = STATE(572),
    [sym_while] = STATE(572),
    [sym_repeat] = STATE(572),
    [sym_for] = STATE(572),
    [sym_switch] = STATE(572),
    [sym_call] = STATE(572),
    [sym__assignment] = STATE(572),
    [sym_left_assignment] = STATE(572),
    [sym_left_assignment2] = STATE(572),
    [sym_equals_assignment] = STATE(572),
    [sym_super_assignment] = STATE(572),
    [sym_right_assignment] = STATE(572),
    [sym_brace_list] = STATE(572),
    [sym_paren_list] = STATE(572),
    [sym_subset] = STATE(572),
    [sym_subset2] = STATE(572),
    [sym_dollar] = STATE(572),
    [sym_slot] = STATE(572),
    [sym_namespace_get] = STATE(572),
    [sym_namespace_get_internal] = STATE(572),
    [sym_unary] = STATE(572),
    [sym_binary] = STATE(572),
    [sym_na] = STATE(572),
    [sym__expression] = STATE(572),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(572),
    [sym_string] = STATE(572),
    [anon_sym_SEMI] = ACTIONS(1144),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1146),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1146),
    [sym_next] = ACTIONS(1146),
    [sym_true] = ACTIONS(1146),
    [sym_false] = ACTIONS(1146),
    [sym_null] = ACTIONS(1146),
    [sym_inf] = ACTIONS(1146),
    [sym_nan] = ACTIONS(1146),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1144),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [192] = {
    [sym_function_definition] = STATE(829),
    [sym_if] = STATE(829),
    [sym_while] = STATE(829),
    [sym_repeat] = STATE(829),
    [sym_for] = STATE(829),
    [sym_switch] = STATE(829),
    [sym_call] = STATE(829),
    [sym__assignment] = STATE(829),
    [sym_left_assignment] = STATE(829),
    [sym_left_assignment2] = STATE(829),
    [sym_equals_assignment] = STATE(829),
    [sym_super_assignment] = STATE(829),
    [sym_right_assignment] = STATE(829),
    [sym_brace_list] = STATE(829),
    [sym_paren_list] = STATE(829),
    [sym_subset] = STATE(829),
    [sym_subset2] = STATE(829),
    [sym_dollar] = STATE(829),
    [sym_slot] = STATE(829),
    [sym_namespace_get] = STATE(829),
    [sym_namespace_get_internal] = STATE(829),
    [sym_unary] = STATE(829),
    [sym_binary] = STATE(829),
    [sym_na] = STATE(829),
    [sym__expression] = STATE(829),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(829),
    [sym_string] = STATE(829),
    [anon_sym_SEMI] = ACTIONS(1148),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1150),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1150),
    [sym_next] = ACTIONS(1150),
    [sym_true] = ACTIONS(1150),
    [sym_false] = ACTIONS(1150),
    [sym_null] = ACTIONS(1150),
    [sym_inf] = ACTIONS(1150),
    [sym_nan] = ACTIONS(1150),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1148),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [193] = {
    [sym_function_definition] = STATE(825),
    [sym_if] = STATE(825),
    [sym_while] = STATE(825),
    [sym_repeat] = STATE(825),
    [sym_for] = STATE(825),
    [sym_switch] = STATE(825),
    [sym_call] = STATE(825),
    [sym__assignment] = STATE(825),
    [sym_left_assignment] = STATE(825),
    [sym_left_assignment2] = STATE(825),
    [sym_equals_assignment] = STATE(825),
    [sym_super_assignment] = STATE(825),
    [sym_right_assignment] = STATE(825),
    [sym_brace_list] = STATE(825),
    [sym_paren_list] = STATE(825),
    [sym_subset] = STATE(825),
    [sym_subset2] = STATE(825),
    [sym_dollar] = STATE(825),
    [sym_slot] = STATE(825),
    [sym_namespace_get] = STATE(825),
    [sym_namespace_get_internal] = STATE(825),
    [sym_unary] = STATE(825),
    [sym_binary] = STATE(825),
    [sym_na] = STATE(825),
    [sym__expression] = STATE(825),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(825),
    [sym_string] = STATE(825),
    [anon_sym_SEMI] = ACTIONS(1152),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1154),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1154),
    [sym_next] = ACTIONS(1154),
    [sym_true] = ACTIONS(1154),
    [sym_false] = ACTIONS(1154),
    [sym_null] = ACTIONS(1154),
    [sym_inf] = ACTIONS(1154),
    [sym_nan] = ACTIONS(1154),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1152),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [194] = {
    [sym_function_definition] = STATE(573),
    [sym_if] = STATE(573),
    [sym_while] = STATE(573),
    [sym_repeat] = STATE(573),
    [sym_for] = STATE(573),
    [sym_switch] = STATE(573),
    [sym_call] = STATE(573),
    [sym__assignment] = STATE(573),
    [sym_left_assignment] = STATE(573),
    [sym_left_assignment2] = STATE(573),
    [sym_equals_assignment] = STATE(573),
    [sym_super_assignment] = STATE(573),
    [sym_right_assignment] = STATE(573),
    [sym_brace_list] = STATE(573),
    [sym_paren_list] = STATE(573),
    [sym_subset] = STATE(573),
    [sym_subset2] = STATE(573),
    [sym_dollar] = STATE(573),
    [sym_slot] = STATE(573),
    [sym_namespace_get] = STATE(573),
    [sym_namespace_get_internal] = STATE(573),
    [sym_unary] = STATE(573),
    [sym_binary] = STATE(573),
    [sym_na] = STATE(573),
    [sym__expression] = STATE(573),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(573),
    [sym_string] = STATE(573),
    [anon_sym_SEMI] = ACTIONS(1156),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1158),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1158),
    [sym_next] = ACTIONS(1158),
    [sym_true] = ACTIONS(1158),
    [sym_false] = ACTIONS(1158),
    [sym_null] = ACTIONS(1158),
    [sym_inf] = ACTIONS(1158),
    [sym_nan] = ACTIONS(1158),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1156),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [195] = {
    [sym_function_definition] = STATE(838),
    [sym_if] = STATE(838),
    [sym_while] = STATE(838),
    [sym_repeat] = STATE(838),
    [sym_for] = STATE(838),
    [sym_switch] = STATE(838),
    [sym_call] = STATE(838),
    [sym__assignment] = STATE(838),
    [sym_left_assignment] = STATE(838),
    [sym_left_assignment2] = STATE(838),
    [sym_equals_assignment] = STATE(838),
    [sym_super_assignment] = STATE(838),
    [sym_right_assignment] = STATE(838),
    [sym_brace_list] = STATE(838),
    [sym_paren_list] = STATE(838),
    [sym_subset] = STATE(838),
    [sym_subset2] = STATE(838),
    [sym_dollar] = STATE(838),
    [sym_slot] = STATE(838),
    [sym_namespace_get] = STATE(838),
    [sym_namespace_get_internal] = STATE(838),
    [sym_unary] = STATE(838),
    [sym_binary] = STATE(838),
    [sym_na] = STATE(838),
    [sym__expression] = STATE(838),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(838),
    [sym_string] = STATE(838),
    [anon_sym_SEMI] = ACTIONS(1160),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1162),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1162),
    [sym_next] = ACTIONS(1162),
    [sym_true] = ACTIONS(1162),
    [sym_false] = ACTIONS(1162),
    [sym_null] = ACTIONS(1162),
    [sym_inf] = ACTIONS(1162),
    [sym_nan] = ACTIONS(1162),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1160),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [196] = {
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(610),
    [anon_sym_EQ] = ACTIONS(1164),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_LT_DASH] = ACTIONS(610),
    [anon_sym_COLON_EQ] = ACTIONS(610),
    [anon_sym_LT_LT_DASH] = ACTIONS(610),
    [anon_sym_DASH_GT] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(610),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(610),
    [anon_sym_DOLLAR] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_COLON_COLON] = ACTIONS(1166),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1168),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_CARET] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(610),
    [anon_sym_GT_EQ] = ACTIONS(610),
    [anon_sym_EQ_EQ] = ACTIONS(610),
    [anon_sym_BANG_EQ] = ACTIONS(610),
    [anon_sym_PIPE_PIPE] = ACTIONS(610),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(610),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_integer] = ACTIONS(610),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(610),
  },
  [197] = {
    [sym_function_definition] = STATE(823),
    [sym_if] = STATE(823),
    [sym_while] = STATE(823),
    [sym_repeat] = STATE(823),
    [sym_for] = STATE(823),
    [sym_switch] = STATE(823),
    [sym_call] = STATE(823),
    [sym__assignment] = STATE(823),
    [sym_left_assignment] = STATE(823),
    [sym_left_assignment2] = STATE(823),
    [sym_equals_assignment] = STATE(823),
    [sym_super_assignment] = STATE(823),
    [sym_right_assignment] = STATE(823),
    [sym_brace_list] = STATE(823),
    [sym_paren_list] = STATE(823),
    [sym_subset] = STATE(823),
    [sym_subset2] = STATE(823),
    [sym_dollar] = STATE(823),
    [sym_slot] = STATE(823),
    [sym_namespace_get] = STATE(823),
    [sym_namespace_get_internal] = STATE(823),
    [sym_unary] = STATE(823),
    [sym_binary] = STATE(823),
    [sym_na] = STATE(823),
    [sym__expression] = STATE(823),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(823),
    [sym_string] = STATE(823),
    [anon_sym_SEMI] = ACTIONS(1170),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1172),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1172),
    [sym_next] = ACTIONS(1172),
    [sym_true] = ACTIONS(1172),
    [sym_false] = ACTIONS(1172),
    [sym_null] = ACTIONS(1172),
    [sym_inf] = ACTIONS(1172),
    [sym_nan] = ACTIONS(1172),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1170),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [198] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(704),
    [anon_sym_function] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(706),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(704),
    [anon_sym_while] = ACTIONS(706),
    [anon_sym_repeat] = ACTIONS(706),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_switch] = ACTIONS(706),
    [anon_sym_COMMA] = ACTIONS(704),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(704),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(706),
    [sym_next] = ACTIONS(706),
    [sym_true] = ACTIONS(706),
    [sym_false] = ACTIONS(706),
    [sym_null] = ACTIONS(706),
    [sym_inf] = ACTIONS(706),
    [sym_nan] = ACTIONS(706),
    [anon_sym_NA] = ACTIONS(706),
    [anon_sym_NA_character_] = ACTIONS(706),
    [anon_sym_NA_complex_] = ACTIONS(706),
    [anon_sym_NA_integer_] = ACTIONS(706),
    [anon_sym_NA_real_] = ACTIONS(706),
    [aux_sym_identifier_token1] = ACTIONS(706),
    [anon_sym_BQUOTE] = ACTIONS(704),
    [sym_integer] = ACTIONS(704),
    [sym_float] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(704),
    [anon_sym_SQUOTE] = ACTIONS(704),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [199] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(700),
    [anon_sym_function] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(700),
    [anon_sym_while] = ACTIONS(702),
    [anon_sym_repeat] = ACTIONS(702),
    [anon_sym_for] = ACTIONS(702),
    [anon_sym_switch] = ACTIONS(702),
    [anon_sym_COMMA] = ACTIONS(700),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(700),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(702),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(702),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(702),
    [sym_next] = ACTIONS(702),
    [sym_true] = ACTIONS(702),
    [sym_false] = ACTIONS(702),
    [sym_null] = ACTIONS(702),
    [sym_inf] = ACTIONS(702),
    [sym_nan] = ACTIONS(702),
    [anon_sym_NA] = ACTIONS(702),
    [anon_sym_NA_character_] = ACTIONS(702),
    [anon_sym_NA_complex_] = ACTIONS(702),
    [anon_sym_NA_integer_] = ACTIONS(702),
    [anon_sym_NA_real_] = ACTIONS(702),
    [aux_sym_identifier_token1] = ACTIONS(702),
    [anon_sym_BQUOTE] = ACTIONS(700),
    [sym_integer] = ACTIONS(700),
    [sym_float] = ACTIONS(702),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(700),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [200] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_function] = ACTIONS(698),
    [anon_sym_if] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(696),
    [anon_sym_while] = ACTIONS(698),
    [anon_sym_repeat] = ACTIONS(698),
    [anon_sym_for] = ACTIONS(698),
    [anon_sym_switch] = ACTIONS(698),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(696),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(698),
    [sym_next] = ACTIONS(698),
    [sym_true] = ACTIONS(698),
    [sym_false] = ACTIONS(698),
    [sym_null] = ACTIONS(698),
    [sym_inf] = ACTIONS(698),
    [sym_nan] = ACTIONS(698),
    [anon_sym_NA] = ACTIONS(698),
    [anon_sym_NA_character_] = ACTIONS(698),
    [anon_sym_NA_complex_] = ACTIONS(698),
    [anon_sym_NA_integer_] = ACTIONS(698),
    [anon_sym_NA_real_] = ACTIONS(698),
    [aux_sym_identifier_token1] = ACTIONS(698),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [sym_integer] = ACTIONS(696),
    [sym_float] = ACTIONS(698),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [201] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(682),
    [anon_sym_function] = ACTIONS(684),
    [anon_sym_if] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(682),
    [anon_sym_while] = ACTIONS(684),
    [anon_sym_repeat] = ACTIONS(684),
    [anon_sym_for] = ACTIONS(684),
    [anon_sym_switch] = ACTIONS(684),
    [anon_sym_COMMA] = ACTIONS(682),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(682),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(682),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(684),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(684),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(684),
    [sym_next] = ACTIONS(684),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_null] = ACTIONS(684),
    [sym_inf] = ACTIONS(684),
    [sym_nan] = ACTIONS(684),
    [anon_sym_NA] = ACTIONS(684),
    [anon_sym_NA_character_] = ACTIONS(684),
    [anon_sym_NA_complex_] = ACTIONS(684),
    [anon_sym_NA_integer_] = ACTIONS(684),
    [anon_sym_NA_real_] = ACTIONS(684),
    [aux_sym_identifier_token1] = ACTIONS(684),
    [anon_sym_BQUOTE] = ACTIONS(682),
    [sym_integer] = ACTIONS(682),
    [sym_float] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(682),
    [anon_sym_SQUOTE] = ACTIONS(682),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [202] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(676),
    [anon_sym_function] = ACTIONS(678),
    [anon_sym_if] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(676),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_repeat] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(678),
    [anon_sym_switch] = ACTIONS(678),
    [anon_sym_COMMA] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(678),
    [anon_sym_LBRACE] = ACTIONS(676),
    [anon_sym_LT_DASH] = ACTIONS(676),
    [anon_sym_COLON_EQ] = ACTIONS(676),
    [anon_sym_LT_LT_DASH] = ACTIONS(676),
    [anon_sym_DASH_GT] = ACTIONS(676),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(676),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(678),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(678),
    [sym_next] = ACTIONS(678),
    [sym_true] = ACTIONS(678),
    [sym_false] = ACTIONS(678),
    [sym_null] = ACTIONS(678),
    [sym_inf] = ACTIONS(678),
    [sym_nan] = ACTIONS(678),
    [anon_sym_NA] = ACTIONS(678),
    [anon_sym_NA_character_] = ACTIONS(678),
    [anon_sym_NA_complex_] = ACTIONS(678),
    [anon_sym_NA_integer_] = ACTIONS(678),
    [anon_sym_NA_real_] = ACTIONS(678),
    [aux_sym_identifier_token1] = ACTIONS(678),
    [anon_sym_BQUOTE] = ACTIONS(676),
    [sym_integer] = ACTIONS(676),
    [sym_float] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(676),
    [anon_sym_SQUOTE] = ACTIONS(676),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [203] = {
    [sym_function_definition] = STATE(204),
    [sym_if] = STATE(204),
    [sym_while] = STATE(204),
    [sym_repeat] = STATE(204),
    [sym_for] = STATE(204),
    [sym_switch] = STATE(204),
    [sym_call] = STATE(204),
    [sym__assignment] = STATE(204),
    [sym_left_assignment] = STATE(204),
    [sym_left_assignment2] = STATE(204),
    [sym_equals_assignment] = STATE(204),
    [sym_super_assignment] = STATE(204),
    [sym_right_assignment] = STATE(204),
    [sym_brace_list] = STATE(204),
    [sym_paren_list] = STATE(204),
    [sym_subset] = STATE(204),
    [sym_subset2] = STATE(204),
    [sym_dollar] = STATE(204),
    [sym_slot] = STATE(204),
    [sym_namespace_get] = STATE(204),
    [sym_namespace_get_internal] = STATE(204),
    [sym_unary] = STATE(204),
    [sym_binary] = STATE(204),
    [sym_na] = STATE(204),
    [sym__expression] = STATE(204),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(204),
    [sym_string] = STATE(204),
    [anon_sym_SEMI] = ACTIONS(1174),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1176),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1176),
    [sym_next] = ACTIONS(1176),
    [sym_true] = ACTIONS(1176),
    [sym_false] = ACTIONS(1176),
    [sym_null] = ACTIONS(1176),
    [sym_inf] = ACTIONS(1176),
    [sym_nan] = ACTIONS(1176),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1174),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [204] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(736),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(1180),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_COMMA] = ACTIONS(736),
    [anon_sym_EQ] = ACTIONS(1182),
    [anon_sym_LBRACE] = ACTIONS(736),
    [anon_sym_LT_DASH] = ACTIONS(1184),
    [anon_sym_COLON_EQ] = ACTIONS(1186),
    [anon_sym_LT_LT_DASH] = ACTIONS(1188),
    [anon_sym_DASH_GT] = ACTIONS(1190),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(736),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(1214),
    [anon_sym_PIPE] = ACTIONS(1216),
    [anon_sym_AMP_AMP] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(736),
    [sym_integer] = ACTIONS(736),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [205] = {
    [sym_function_definition] = STATE(576),
    [sym_if] = STATE(576),
    [sym_while] = STATE(576),
    [sym_repeat] = STATE(576),
    [sym_for] = STATE(576),
    [sym_switch] = STATE(576),
    [sym_call] = STATE(576),
    [sym__assignment] = STATE(576),
    [sym_left_assignment] = STATE(576),
    [sym_left_assignment2] = STATE(576),
    [sym_equals_assignment] = STATE(576),
    [sym_super_assignment] = STATE(576),
    [sym_right_assignment] = STATE(576),
    [sym_brace_list] = STATE(576),
    [sym_paren_list] = STATE(576),
    [sym_subset] = STATE(576),
    [sym_subset2] = STATE(576),
    [sym_dollar] = STATE(576),
    [sym_slot] = STATE(576),
    [sym_namespace_get] = STATE(576),
    [sym_namespace_get_internal] = STATE(576),
    [sym_unary] = STATE(576),
    [sym_binary] = STATE(576),
    [sym_na] = STATE(576),
    [sym__expression] = STATE(576),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(576),
    [sym_string] = STATE(576),
    [anon_sym_SEMI] = ACTIONS(1224),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1226),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1226),
    [sym_next] = ACTIONS(1226),
    [sym_true] = ACTIONS(1226),
    [sym_false] = ACTIONS(1226),
    [sym_null] = ACTIONS(1226),
    [sym_inf] = ACTIONS(1226),
    [sym_nan] = ACTIONS(1226),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1224),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [206] = {
    [sym_function_definition] = STATE(852),
    [sym_if] = STATE(852),
    [sym_while] = STATE(852),
    [sym_repeat] = STATE(852),
    [sym_for] = STATE(852),
    [sym_switch] = STATE(852),
    [sym_call] = STATE(852),
    [sym__assignment] = STATE(852),
    [sym_left_assignment] = STATE(852),
    [sym_left_assignment2] = STATE(852),
    [sym_equals_assignment] = STATE(852),
    [sym_super_assignment] = STATE(852),
    [sym_right_assignment] = STATE(852),
    [sym_brace_list] = STATE(852),
    [sym_paren_list] = STATE(852),
    [sym_subset] = STATE(852),
    [sym_subset2] = STATE(852),
    [sym_dollar] = STATE(852),
    [sym_slot] = STATE(852),
    [sym_namespace_get] = STATE(852),
    [sym_namespace_get_internal] = STATE(852),
    [sym_unary] = STATE(852),
    [sym_binary] = STATE(852),
    [sym_na] = STATE(852),
    [sym__expression] = STATE(852),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(852),
    [sym_string] = STATE(852),
    [anon_sym_SEMI] = ACTIONS(1228),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1230),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1230),
    [sym_next] = ACTIONS(1230),
    [sym_true] = ACTIONS(1230),
    [sym_false] = ACTIONS(1230),
    [sym_null] = ACTIONS(1230),
    [sym_inf] = ACTIONS(1230),
    [sym_nan] = ACTIONS(1230),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1228),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [207] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [208] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [209] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [210] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(634),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [211] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [212] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [213] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [214] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(634),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [215] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [216] = {
    [sym_function_definition] = STATE(363),
    [sym_if] = STATE(363),
    [sym_while] = STATE(363),
    [sym_repeat] = STATE(363),
    [sym_for] = STATE(363),
    [sym_switch] = STATE(363),
    [sym_call] = STATE(363),
    [sym__assignment] = STATE(363),
    [sym_left_assignment] = STATE(363),
    [sym_left_assignment2] = STATE(363),
    [sym_equals_assignment] = STATE(363),
    [sym_super_assignment] = STATE(363),
    [sym_right_assignment] = STATE(363),
    [sym_brace_list] = STATE(363),
    [sym_paren_list] = STATE(363),
    [sym_subset] = STATE(363),
    [sym_subset2] = STATE(363),
    [sym_dollar] = STATE(363),
    [sym_slot] = STATE(363),
    [sym_namespace_get] = STATE(363),
    [sym_namespace_get_internal] = STATE(363),
    [sym_unary] = STATE(363),
    [sym_binary] = STATE(363),
    [sym_na] = STATE(363),
    [sym__expression] = STATE(363),
    [sym_identifier] = STATE(118),
    [sym_complex] = STATE(363),
    [sym_string] = STATE(363),
    [anon_sym_SEMI] = ACTIONS(1232),
    [anon_sym_function] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1236),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1240),
    [anon_sym_repeat] = ACTIONS(1242),
    [anon_sym_for] = ACTIONS(1244),
    [anon_sym_switch] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(1248),
    [sym_dots] = ACTIONS(1250),
    [anon_sym_DASH] = ACTIONS(1252),
    [anon_sym_PLUS] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(1254),
    [anon_sym_TILDE] = ACTIONS(1256),
    [sym_break] = ACTIONS(1250),
    [sym_next] = ACTIONS(1250),
    [sym_true] = ACTIONS(1250),
    [sym_false] = ACTIONS(1250),
    [sym_null] = ACTIONS(1250),
    [sym_inf] = ACTIONS(1250),
    [sym_nan] = ACTIONS(1250),
    [anon_sym_NA] = ACTIONS(1258),
    [anon_sym_NA_character_] = ACTIONS(1258),
    [anon_sym_NA_complex_] = ACTIONS(1258),
    [anon_sym_NA_integer_] = ACTIONS(1258),
    [anon_sym_NA_real_] = ACTIONS(1258),
    [aux_sym_identifier_token1] = ACTIONS(1260),
    [anon_sym_BQUOTE] = ACTIONS(1262),
    [sym_integer] = ACTIONS(1232),
    [sym_float] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
  },
  [217] = {
    [sym_function_definition] = STATE(849),
    [sym_if] = STATE(849),
    [sym_while] = STATE(849),
    [sym_repeat] = STATE(849),
    [sym_for] = STATE(849),
    [sym_switch] = STATE(849),
    [sym_call] = STATE(849),
    [sym__assignment] = STATE(849),
    [sym_left_assignment] = STATE(849),
    [sym_left_assignment2] = STATE(849),
    [sym_equals_assignment] = STATE(849),
    [sym_super_assignment] = STATE(849),
    [sym_right_assignment] = STATE(849),
    [sym_brace_list] = STATE(849),
    [sym_paren_list] = STATE(849),
    [sym_subset] = STATE(849),
    [sym_subset2] = STATE(849),
    [sym_dollar] = STATE(849),
    [sym_slot] = STATE(849),
    [sym_namespace_get] = STATE(849),
    [sym_namespace_get_internal] = STATE(849),
    [sym_unary] = STATE(849),
    [sym_binary] = STATE(849),
    [sym_na] = STATE(849),
    [sym__expression] = STATE(849),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(849),
    [sym_string] = STATE(849),
    [anon_sym_SEMI] = ACTIONS(1270),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1272),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1272),
    [sym_next] = ACTIONS(1272),
    [sym_true] = ACTIONS(1272),
    [sym_false] = ACTIONS(1272),
    [sym_null] = ACTIONS(1272),
    [sym_inf] = ACTIONS(1272),
    [sym_nan] = ACTIONS(1272),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1270),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [218] = {
    [sym_function_definition] = STATE(225),
    [sym_if] = STATE(225),
    [sym_while] = STATE(225),
    [sym_repeat] = STATE(225),
    [sym_for] = STATE(225),
    [sym_switch] = STATE(225),
    [sym_call] = STATE(225),
    [sym__assignment] = STATE(225),
    [sym_left_assignment] = STATE(225),
    [sym_left_assignment2] = STATE(225),
    [sym_equals_assignment] = STATE(225),
    [sym_super_assignment] = STATE(225),
    [sym_right_assignment] = STATE(225),
    [sym_brace_list] = STATE(225),
    [sym_paren_list] = STATE(225),
    [sym_subset] = STATE(225),
    [sym_subset2] = STATE(225),
    [sym_dollar] = STATE(225),
    [sym_slot] = STATE(225),
    [sym_namespace_get] = STATE(225),
    [sym_namespace_get_internal] = STATE(225),
    [sym_unary] = STATE(225),
    [sym_binary] = STATE(225),
    [sym_na] = STATE(225),
    [sym__expression] = STATE(225),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(225),
    [sym_string] = STATE(225),
    [anon_sym_SEMI] = ACTIONS(1274),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1276),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1276),
    [sym_next] = ACTIONS(1276),
    [sym_true] = ACTIONS(1276),
    [sym_false] = ACTIONS(1276),
    [sym_null] = ACTIONS(1276),
    [sym_inf] = ACTIONS(1276),
    [sym_nan] = ACTIONS(1276),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1274),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [219] = {
    [sym_function_definition] = STATE(848),
    [sym_if] = STATE(848),
    [sym_while] = STATE(848),
    [sym_repeat] = STATE(848),
    [sym_for] = STATE(848),
    [sym_switch] = STATE(848),
    [sym_call] = STATE(848),
    [sym__assignment] = STATE(848),
    [sym_left_assignment] = STATE(848),
    [sym_left_assignment2] = STATE(848),
    [sym_equals_assignment] = STATE(848),
    [sym_super_assignment] = STATE(848),
    [sym_right_assignment] = STATE(848),
    [sym_brace_list] = STATE(848),
    [sym_paren_list] = STATE(848),
    [sym_subset] = STATE(848),
    [sym_subset2] = STATE(848),
    [sym_dollar] = STATE(848),
    [sym_slot] = STATE(848),
    [sym_namespace_get] = STATE(848),
    [sym_namespace_get_internal] = STATE(848),
    [sym_unary] = STATE(848),
    [sym_binary] = STATE(848),
    [sym_na] = STATE(848),
    [sym__expression] = STATE(848),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(848),
    [sym_string] = STATE(848),
    [anon_sym_SEMI] = ACTIONS(1278),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1280),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1280),
    [sym_next] = ACTIONS(1280),
    [sym_true] = ACTIONS(1280),
    [sym_false] = ACTIONS(1280),
    [sym_null] = ACTIONS(1280),
    [sym_inf] = ACTIONS(1280),
    [sym_nan] = ACTIONS(1280),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1278),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [220] = {
    [ts_builtin_sym_end] = ACTIONS(618),
    [anon_sym_LF] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_LT_DASH] = ACTIONS(620),
    [anon_sym_COLON_EQ] = ACTIONS(620),
    [anon_sym_LT_LT_DASH] = ACTIONS(620),
    [anon_sym_DASH_GT] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(620),
    [anon_sym_DOLLAR] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(620),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_STAR] = ACTIONS(620),
    [anon_sym_SLASH] = ACTIONS(620),
    [anon_sym_CARET] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(620),
    [anon_sym_GT_EQ] = ACTIONS(620),
    [anon_sym_EQ_EQ] = ACTIONS(620),
    [anon_sym_BANG_EQ] = ACTIONS(620),
    [anon_sym_PIPE_PIPE] = ACTIONS(620),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(620),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_integer] = ACTIONS(620),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(620),
    [anon_sym_SQUOTE] = ACTIONS(620),
    [anon_sym_PERCENT] = ACTIONS(620),
  },
  [221] = {
    [sym_function_definition] = STATE(534),
    [sym_if] = STATE(534),
    [sym_while] = STATE(534),
    [sym_repeat] = STATE(534),
    [sym_for] = STATE(534),
    [sym_switch] = STATE(534),
    [sym_call] = STATE(534),
    [sym__assignment] = STATE(534),
    [sym_left_assignment] = STATE(534),
    [sym_left_assignment2] = STATE(534),
    [sym_equals_assignment] = STATE(534),
    [sym_super_assignment] = STATE(534),
    [sym_right_assignment] = STATE(534),
    [sym_brace_list] = STATE(534),
    [sym_paren_list] = STATE(534),
    [sym_subset] = STATE(534),
    [sym_subset2] = STATE(534),
    [sym_dollar] = STATE(534),
    [sym_slot] = STATE(534),
    [sym_namespace_get] = STATE(534),
    [sym_namespace_get_internal] = STATE(534),
    [sym_unary] = STATE(534),
    [sym_binary] = STATE(534),
    [sym_na] = STATE(534),
    [sym__expression] = STATE(534),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(534),
    [sym_string] = STATE(534),
    [anon_sym_SEMI] = ACTIONS(1282),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1284),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1284),
    [sym_next] = ACTIONS(1284),
    [sym_true] = ACTIONS(1284),
    [sym_false] = ACTIONS(1284),
    [sym_null] = ACTIONS(1284),
    [sym_inf] = ACTIONS(1284),
    [sym_nan] = ACTIONS(1284),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1282),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [222] = {
    [sym_function_definition] = STATE(764),
    [sym_if] = STATE(764),
    [sym_while] = STATE(764),
    [sym_repeat] = STATE(764),
    [sym_for] = STATE(764),
    [sym_switch] = STATE(764),
    [sym_call] = STATE(764),
    [sym__assignment] = STATE(764),
    [sym_left_assignment] = STATE(764),
    [sym_left_assignment2] = STATE(764),
    [sym_equals_assignment] = STATE(764),
    [sym_super_assignment] = STATE(764),
    [sym_right_assignment] = STATE(764),
    [sym_brace_list] = STATE(764),
    [sym_paren_list] = STATE(764),
    [sym_subset] = STATE(764),
    [sym_subset2] = STATE(764),
    [sym_dollar] = STATE(764),
    [sym_slot] = STATE(764),
    [sym_namespace_get] = STATE(764),
    [sym_namespace_get_internal] = STATE(764),
    [sym_unary] = STATE(764),
    [sym_binary] = STATE(764),
    [sym_na] = STATE(764),
    [sym__expression] = STATE(764),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(764),
    [sym_string] = STATE(764),
    [anon_sym_SEMI] = ACTIONS(1286),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1304),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1304),
    [sym_next] = ACTIONS(1304),
    [sym_true] = ACTIONS(1304),
    [sym_false] = ACTIONS(1304),
    [sym_null] = ACTIONS(1304),
    [sym_inf] = ACTIONS(1304),
    [sym_nan] = ACTIONS(1304),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1286),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [223] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [anon_sym_LF] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_LT_DASH] = ACTIONS(612),
    [anon_sym_COLON_EQ] = ACTIONS(612),
    [anon_sym_LT_LT_DASH] = ACTIONS(612),
    [anon_sym_DASH_GT] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(612),
    [anon_sym_DOLLAR] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_COLON_COLON] = ACTIONS(1324),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1326),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_CARET] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(612),
    [anon_sym_GT_EQ] = ACTIONS(612),
    [anon_sym_EQ_EQ] = ACTIONS(612),
    [anon_sym_BANG_EQ] = ACTIONS(612),
    [anon_sym_PIPE_PIPE] = ACTIONS(612),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(612),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(612),
    [sym_integer] = ACTIONS(612),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(612),
    [anon_sym_SQUOTE] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(612),
  },
  [224] = {
    [sym_function_definition] = STATE(136),
    [sym_if] = STATE(136),
    [sym_while] = STATE(136),
    [sym_repeat] = STATE(136),
    [sym_for] = STATE(136),
    [sym_switch] = STATE(136),
    [sym_call] = STATE(136),
    [sym__assignment] = STATE(136),
    [sym_left_assignment] = STATE(136),
    [sym_left_assignment2] = STATE(136),
    [sym_equals_assignment] = STATE(136),
    [sym_super_assignment] = STATE(136),
    [sym_right_assignment] = STATE(136),
    [sym_brace_list] = STATE(136),
    [sym_paren_list] = STATE(136),
    [sym_subset] = STATE(136),
    [sym_subset2] = STATE(136),
    [sym_dollar] = STATE(136),
    [sym_slot] = STATE(136),
    [sym_namespace_get] = STATE(136),
    [sym_namespace_get_internal] = STATE(136),
    [sym_unary] = STATE(136),
    [sym_binary] = STATE(136),
    [sym_na] = STATE(136),
    [sym__expression] = STATE(136),
    [sym_identifier] = STATE(118),
    [sym_complex] = STATE(136),
    [sym_string] = STATE(136),
    [anon_sym_SEMI] = ACTIONS(1328),
    [anon_sym_function] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1236),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1240),
    [anon_sym_repeat] = ACTIONS(1242),
    [anon_sym_for] = ACTIONS(1244),
    [anon_sym_switch] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(1248),
    [sym_dots] = ACTIONS(1330),
    [anon_sym_DASH] = ACTIONS(1252),
    [anon_sym_PLUS] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(1254),
    [anon_sym_TILDE] = ACTIONS(1256),
    [sym_break] = ACTIONS(1330),
    [sym_next] = ACTIONS(1330),
    [sym_true] = ACTIONS(1330),
    [sym_false] = ACTIONS(1330),
    [sym_null] = ACTIONS(1330),
    [sym_inf] = ACTIONS(1330),
    [sym_nan] = ACTIONS(1330),
    [anon_sym_NA] = ACTIONS(1258),
    [anon_sym_NA_character_] = ACTIONS(1258),
    [anon_sym_NA_complex_] = ACTIONS(1258),
    [anon_sym_NA_integer_] = ACTIONS(1258),
    [anon_sym_NA_real_] = ACTIONS(1258),
    [aux_sym_identifier_token1] = ACTIONS(1260),
    [anon_sym_BQUOTE] = ACTIONS(1262),
    [sym_integer] = ACTIONS(1328),
    [sym_float] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
  },
  [225] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_if] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(730),
    [anon_sym_repeat] = ACTIONS(730),
    [anon_sym_for] = ACTIONS(730),
    [anon_sym_switch] = ACTIONS(730),
    [anon_sym_COMMA] = ACTIONS(728),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(728),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(730),
    [sym_next] = ACTIONS(730),
    [sym_true] = ACTIONS(730),
    [sym_false] = ACTIONS(730),
    [sym_null] = ACTIONS(730),
    [sym_inf] = ACTIONS(730),
    [sym_nan] = ACTIONS(730),
    [anon_sym_NA] = ACTIONS(730),
    [anon_sym_NA_character_] = ACTIONS(730),
    [anon_sym_NA_complex_] = ACTIONS(730),
    [anon_sym_NA_integer_] = ACTIONS(730),
    [anon_sym_NA_real_] = ACTIONS(730),
    [aux_sym_identifier_token1] = ACTIONS(730),
    [anon_sym_BQUOTE] = ACTIONS(728),
    [sym_integer] = ACTIONS(728),
    [sym_float] = ACTIONS(730),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [226] = {
    [sym_function_definition] = STATE(681),
    [sym_if] = STATE(681),
    [sym_while] = STATE(681),
    [sym_repeat] = STATE(681),
    [sym_for] = STATE(681),
    [sym_switch] = STATE(681),
    [sym_call] = STATE(681),
    [sym__assignment] = STATE(681),
    [sym_left_assignment] = STATE(681),
    [sym_left_assignment2] = STATE(681),
    [sym_equals_assignment] = STATE(681),
    [sym_super_assignment] = STATE(681),
    [sym_right_assignment] = STATE(681),
    [sym_brace_list] = STATE(681),
    [sym_paren_list] = STATE(681),
    [sym_subset] = STATE(681),
    [sym_subset2] = STATE(681),
    [sym_dollar] = STATE(681),
    [sym_slot] = STATE(681),
    [sym_namespace_get] = STATE(681),
    [sym_namespace_get_internal] = STATE(681),
    [sym_unary] = STATE(681),
    [sym_binary] = STATE(681),
    [sym_na] = STATE(681),
    [sym__expression] = STATE(681),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(681),
    [sym_string] = STATE(681),
    [anon_sym_SEMI] = ACTIONS(1332),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1334),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1334),
    [sym_next] = ACTIONS(1334),
    [sym_true] = ACTIONS(1334),
    [sym_false] = ACTIONS(1334),
    [sym_null] = ACTIONS(1334),
    [sym_inf] = ACTIONS(1334),
    [sym_nan] = ACTIONS(1334),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1332),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [227] = {
    [sym_function_definition] = STATE(230),
    [sym_if] = STATE(230),
    [sym_while] = STATE(230),
    [sym_repeat] = STATE(230),
    [sym_for] = STATE(230),
    [sym_switch] = STATE(230),
    [sym_call] = STATE(230),
    [sym__assignment] = STATE(230),
    [sym_left_assignment] = STATE(230),
    [sym_left_assignment2] = STATE(230),
    [sym_equals_assignment] = STATE(230),
    [sym_super_assignment] = STATE(230),
    [sym_right_assignment] = STATE(230),
    [sym_brace_list] = STATE(230),
    [sym_paren_list] = STATE(230),
    [sym_subset] = STATE(230),
    [sym_subset2] = STATE(230),
    [sym_dollar] = STATE(230),
    [sym_slot] = STATE(230),
    [sym_namespace_get] = STATE(230),
    [sym_namespace_get_internal] = STATE(230),
    [sym_unary] = STATE(230),
    [sym_binary] = STATE(230),
    [sym_na] = STATE(230),
    [sym__expression] = STATE(230),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(230),
    [sym_string] = STATE(230),
    [anon_sym_SEMI] = ACTIONS(1336),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1338),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1338),
    [sym_next] = ACTIONS(1338),
    [sym_true] = ACTIONS(1338),
    [sym_false] = ACTIONS(1338),
    [sym_null] = ACTIONS(1338),
    [sym_inf] = ACTIONS(1338),
    [sym_nan] = ACTIONS(1338),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1336),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [228] = {
    [sym_function_definition] = STATE(231),
    [sym_if] = STATE(231),
    [sym_while] = STATE(231),
    [sym_repeat] = STATE(231),
    [sym_for] = STATE(231),
    [sym_switch] = STATE(231),
    [sym_call] = STATE(231),
    [sym__assignment] = STATE(231),
    [sym_left_assignment] = STATE(231),
    [sym_left_assignment2] = STATE(231),
    [sym_equals_assignment] = STATE(231),
    [sym_super_assignment] = STATE(231),
    [sym_right_assignment] = STATE(231),
    [sym_brace_list] = STATE(231),
    [sym_paren_list] = STATE(231),
    [sym_subset] = STATE(231),
    [sym_subset2] = STATE(231),
    [sym_dollar] = STATE(231),
    [sym_slot] = STATE(231),
    [sym_namespace_get] = STATE(231),
    [sym_namespace_get_internal] = STATE(231),
    [sym_unary] = STATE(231),
    [sym_binary] = STATE(231),
    [sym_na] = STATE(231),
    [sym__expression] = STATE(231),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(231),
    [sym_string] = STATE(231),
    [anon_sym_SEMI] = ACTIONS(1340),
    [anon_sym_function] = ACTIONS(47),
    [anon_sym_if] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_repeat] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1342),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(73),
    [sym_break] = ACTIONS(1342),
    [sym_next] = ACTIONS(1342),
    [sym_true] = ACTIONS(1342),
    [sym_false] = ACTIONS(1342),
    [sym_null] = ACTIONS(1342),
    [sym_inf] = ACTIONS(1342),
    [sym_nan] = ACTIONS(1342),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1340),
    [sym_float] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [229] = {
    [sym_function_definition] = STATE(845),
    [sym_if] = STATE(845),
    [sym_while] = STATE(845),
    [sym_repeat] = STATE(845),
    [sym_for] = STATE(845),
    [sym_switch] = STATE(845),
    [sym_call] = STATE(845),
    [sym__assignment] = STATE(845),
    [sym_left_assignment] = STATE(845),
    [sym_left_assignment2] = STATE(845),
    [sym_equals_assignment] = STATE(845),
    [sym_super_assignment] = STATE(845),
    [sym_right_assignment] = STATE(845),
    [sym_brace_list] = STATE(845),
    [sym_paren_list] = STATE(845),
    [sym_subset] = STATE(845),
    [sym_subset2] = STATE(845),
    [sym_dollar] = STATE(845),
    [sym_slot] = STATE(845),
    [sym_namespace_get] = STATE(845),
    [sym_namespace_get_internal] = STATE(845),
    [sym_unary] = STATE(845),
    [sym_binary] = STATE(845),
    [sym_na] = STATE(845),
    [sym__expression] = STATE(845),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(845),
    [sym_string] = STATE(845),
    [anon_sym_SEMI] = ACTIONS(1344),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1346),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1346),
    [sym_next] = ACTIONS(1346),
    [sym_true] = ACTIONS(1346),
    [sym_false] = ACTIONS(1346),
    [sym_null] = ACTIONS(1346),
    [sym_inf] = ACTIONS(1346),
    [sym_nan] = ACTIONS(1346),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1344),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [230] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(742),
    [anon_sym_function] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(742),
    [anon_sym_while] = ACTIONS(744),
    [anon_sym_repeat] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_switch] = ACTIONS(744),
    [anon_sym_COMMA] = ACTIONS(742),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(742),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(744),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(744),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(744),
    [sym_next] = ACTIONS(744),
    [sym_true] = ACTIONS(744),
    [sym_false] = ACTIONS(744),
    [sym_null] = ACTIONS(744),
    [sym_inf] = ACTIONS(744),
    [sym_nan] = ACTIONS(744),
    [anon_sym_NA] = ACTIONS(744),
    [anon_sym_NA_character_] = ACTIONS(744),
    [anon_sym_NA_complex_] = ACTIONS(744),
    [anon_sym_NA_integer_] = ACTIONS(744),
    [anon_sym_NA_real_] = ACTIONS(744),
    [aux_sym_identifier_token1] = ACTIONS(744),
    [anon_sym_BQUOTE] = ACTIONS(742),
    [sym_integer] = ACTIONS(742),
    [sym_float] = ACTIONS(744),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(742),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [231] = {
    [sym_special] = STATE(183),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_LT_DASH] = ACTIONS(926),
    [anon_sym_COLON_EQ] = ACTIONS(928),
    [anon_sym_LT_LT_DASH] = ACTIONS(930),
    [anon_sym_DASH_GT] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(934),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(936),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(940),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_STAR] = ACTIONS(948),
    [anon_sym_SLASH] = ACTIONS(948),
    [anon_sym_CARET] = ACTIONS(950),
    [anon_sym_LT] = ACTIONS(952),
    [anon_sym_GT] = ACTIONS(952),
    [anon_sym_LT_EQ] = ACTIONS(954),
    [anon_sym_GT_EQ] = ACTIONS(954),
    [anon_sym_EQ_EQ] = ACTIONS(954),
    [anon_sym_BANG_EQ] = ACTIONS(954),
    [anon_sym_PIPE_PIPE] = ACTIONS(956),
    [anon_sym_PIPE] = ACTIONS(958),
    [anon_sym_AMP_AMP] = ACTIONS(960),
    [anon_sym_AMP] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(746),
    [sym_integer] = ACTIONS(746),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [232] = {
    [sym_function_definition] = STATE(571),
    [sym_if] = STATE(571),
    [sym_while] = STATE(571),
    [sym_repeat] = STATE(571),
    [sym_for] = STATE(571),
    [sym_switch] = STATE(571),
    [sym_call] = STATE(571),
    [sym__assignment] = STATE(571),
    [sym_left_assignment] = STATE(571),
    [sym_left_assignment2] = STATE(571),
    [sym_equals_assignment] = STATE(571),
    [sym_super_assignment] = STATE(571),
    [sym_right_assignment] = STATE(571),
    [sym_brace_list] = STATE(571),
    [sym_paren_list] = STATE(571),
    [sym_subset] = STATE(571),
    [sym_subset2] = STATE(571),
    [sym_dollar] = STATE(571),
    [sym_slot] = STATE(571),
    [sym_namespace_get] = STATE(571),
    [sym_namespace_get_internal] = STATE(571),
    [sym_unary] = STATE(571),
    [sym_binary] = STATE(571),
    [sym_na] = STATE(571),
    [sym__expression] = STATE(571),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(571),
    [sym_string] = STATE(571),
    [anon_sym_SEMI] = ACTIONS(1348),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1350),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1350),
    [sym_next] = ACTIONS(1350),
    [sym_true] = ACTIONS(1350),
    [sym_false] = ACTIONS(1350),
    [sym_null] = ACTIONS(1350),
    [sym_inf] = ACTIONS(1350),
    [sym_nan] = ACTIONS(1350),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1348),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [233] = {
    [sym_function_definition] = STATE(574),
    [sym_if] = STATE(574),
    [sym_while] = STATE(574),
    [sym_repeat] = STATE(574),
    [sym_for] = STATE(574),
    [sym_switch] = STATE(574),
    [sym_call] = STATE(574),
    [sym__assignment] = STATE(574),
    [sym_left_assignment] = STATE(574),
    [sym_left_assignment2] = STATE(574),
    [sym_equals_assignment] = STATE(574),
    [sym_super_assignment] = STATE(574),
    [sym_right_assignment] = STATE(574),
    [sym_brace_list] = STATE(574),
    [sym_paren_list] = STATE(574),
    [sym_subset] = STATE(574),
    [sym_subset2] = STATE(574),
    [sym_dollar] = STATE(574),
    [sym_slot] = STATE(574),
    [sym_namespace_get] = STATE(574),
    [sym_namespace_get_internal] = STATE(574),
    [sym_unary] = STATE(574),
    [sym_binary] = STATE(574),
    [sym_na] = STATE(574),
    [sym__expression] = STATE(574),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(574),
    [sym_string] = STATE(574),
    [anon_sym_SEMI] = ACTIONS(1352),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1354),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1354),
    [sym_next] = ACTIONS(1354),
    [sym_true] = ACTIONS(1354),
    [sym_false] = ACTIONS(1354),
    [sym_null] = ACTIONS(1354),
    [sym_inf] = ACTIONS(1354),
    [sym_nan] = ACTIONS(1354),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1352),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [234] = {
    [sym_function_definition] = STATE(577),
    [sym_if] = STATE(577),
    [sym_while] = STATE(577),
    [sym_repeat] = STATE(577),
    [sym_for] = STATE(577),
    [sym_switch] = STATE(577),
    [sym_call] = STATE(577),
    [sym__assignment] = STATE(577),
    [sym_left_assignment] = STATE(577),
    [sym_left_assignment2] = STATE(577),
    [sym_equals_assignment] = STATE(577),
    [sym_super_assignment] = STATE(577),
    [sym_right_assignment] = STATE(577),
    [sym_brace_list] = STATE(577),
    [sym_paren_list] = STATE(577),
    [sym_subset] = STATE(577),
    [sym_subset2] = STATE(577),
    [sym_dollar] = STATE(577),
    [sym_slot] = STATE(577),
    [sym_namespace_get] = STATE(577),
    [sym_namespace_get_internal] = STATE(577),
    [sym_unary] = STATE(577),
    [sym_binary] = STATE(577),
    [sym_na] = STATE(577),
    [sym__expression] = STATE(577),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(577),
    [sym_string] = STATE(577),
    [anon_sym_SEMI] = ACTIONS(1356),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1358),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1358),
    [sym_next] = ACTIONS(1358),
    [sym_true] = ACTIONS(1358),
    [sym_false] = ACTIONS(1358),
    [sym_null] = ACTIONS(1358),
    [sym_inf] = ACTIONS(1358),
    [sym_nan] = ACTIONS(1358),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1356),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [235] = {
    [sym_function_definition] = STATE(578),
    [sym_if] = STATE(578),
    [sym_while] = STATE(578),
    [sym_repeat] = STATE(578),
    [sym_for] = STATE(578),
    [sym_switch] = STATE(578),
    [sym_call] = STATE(578),
    [sym__assignment] = STATE(578),
    [sym_left_assignment] = STATE(578),
    [sym_left_assignment2] = STATE(578),
    [sym_equals_assignment] = STATE(578),
    [sym_super_assignment] = STATE(578),
    [sym_right_assignment] = STATE(578),
    [sym_brace_list] = STATE(578),
    [sym_paren_list] = STATE(578),
    [sym_subset] = STATE(578),
    [sym_subset2] = STATE(578),
    [sym_dollar] = STATE(578),
    [sym_slot] = STATE(578),
    [sym_namespace_get] = STATE(578),
    [sym_namespace_get_internal] = STATE(578),
    [sym_unary] = STATE(578),
    [sym_binary] = STATE(578),
    [sym_na] = STATE(578),
    [sym__expression] = STATE(578),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(578),
    [sym_string] = STATE(578),
    [anon_sym_SEMI] = ACTIONS(1360),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1362),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1362),
    [sym_next] = ACTIONS(1362),
    [sym_true] = ACTIONS(1362),
    [sym_false] = ACTIONS(1362),
    [sym_null] = ACTIONS(1362),
    [sym_inf] = ACTIONS(1362),
    [sym_nan] = ACTIONS(1362),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1360),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [236] = {
    [sym_function_definition] = STATE(358),
    [sym_if] = STATE(358),
    [sym_while] = STATE(358),
    [sym_repeat] = STATE(358),
    [sym_for] = STATE(358),
    [sym_switch] = STATE(358),
    [sym_call] = STATE(358),
    [sym__assignment] = STATE(358),
    [sym_left_assignment] = STATE(358),
    [sym_left_assignment2] = STATE(358),
    [sym_equals_assignment] = STATE(358),
    [sym_super_assignment] = STATE(358),
    [sym_right_assignment] = STATE(358),
    [sym_brace_list] = STATE(358),
    [sym_paren_list] = STATE(358),
    [sym_subset] = STATE(358),
    [sym_subset2] = STATE(358),
    [sym_dollar] = STATE(358),
    [sym_slot] = STATE(358),
    [sym_namespace_get] = STATE(358),
    [sym_namespace_get_internal] = STATE(358),
    [sym_unary] = STATE(358),
    [sym_binary] = STATE(358),
    [sym_na] = STATE(358),
    [sym__expression] = STATE(358),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(358),
    [sym_string] = STATE(358),
    [anon_sym_SEMI] = ACTIONS(1364),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1382),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1382),
    [sym_next] = ACTIONS(1382),
    [sym_true] = ACTIONS(1382),
    [sym_false] = ACTIONS(1382),
    [sym_null] = ACTIONS(1382),
    [sym_inf] = ACTIONS(1382),
    [sym_nan] = ACTIONS(1382),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1364),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [237] = {
    [anon_sym_LF] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_function] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_repeat] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_EQ] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_LT_DASH] = ACTIONS(620),
    [anon_sym_COLON_EQ] = ACTIONS(620),
    [anon_sym_LT_LT_DASH] = ACTIONS(620),
    [anon_sym_DASH_GT] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(620),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(620),
    [anon_sym_DOLLAR] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_COLON_COLON] = ACTIONS(620),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(620),
    [sym_dots] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_STAR] = ACTIONS(620),
    [anon_sym_SLASH] = ACTIONS(620),
    [anon_sym_CARET] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(620),
    [anon_sym_LT_EQ] = ACTIONS(620),
    [anon_sym_GT_EQ] = ACTIONS(620),
    [anon_sym_EQ_EQ] = ACTIONS(620),
    [anon_sym_BANG_EQ] = ACTIONS(620),
    [anon_sym_PIPE_PIPE] = ACTIONS(620),
    [anon_sym_PIPE] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(620),
    [anon_sym_AMP] = ACTIONS(620),
    [anon_sym_COLON] = ACTIONS(620),
    [sym_break] = ACTIONS(620),
    [sym_next] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_inf] = ACTIONS(620),
    [sym_nan] = ACTIONS(620),
    [anon_sym_NA] = ACTIONS(620),
    [anon_sym_NA_character_] = ACTIONS(620),
    [anon_sym_NA_complex_] = ACTIONS(620),
    [anon_sym_NA_integer_] = ACTIONS(620),
    [anon_sym_NA_real_] = ACTIONS(620),
    [aux_sym_identifier_token1] = ACTIONS(620),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_integer] = ACTIONS(620),
    [sym_float] = ACTIONS(620),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(620),
    [anon_sym_SQUOTE] = ACTIONS(620),
    [anon_sym_PERCENT] = ACTIONS(620),
  },
  [238] = {
    [sym_function_definition] = STATE(842),
    [sym_if] = STATE(842),
    [sym_while] = STATE(842),
    [sym_repeat] = STATE(842),
    [sym_for] = STATE(842),
    [sym_switch] = STATE(842),
    [sym_call] = STATE(842),
    [sym__assignment] = STATE(842),
    [sym_left_assignment] = STATE(842),
    [sym_left_assignment2] = STATE(842),
    [sym_equals_assignment] = STATE(842),
    [sym_super_assignment] = STATE(842),
    [sym_right_assignment] = STATE(842),
    [sym_brace_list] = STATE(842),
    [sym_paren_list] = STATE(842),
    [sym_subset] = STATE(842),
    [sym_subset2] = STATE(842),
    [sym_dollar] = STATE(842),
    [sym_slot] = STATE(842),
    [sym_namespace_get] = STATE(842),
    [sym_namespace_get_internal] = STATE(842),
    [sym_unary] = STATE(842),
    [sym_binary] = STATE(842),
    [sym_na] = STATE(842),
    [sym__expression] = STATE(842),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(842),
    [sym_string] = STATE(842),
    [anon_sym_SEMI] = ACTIONS(1402),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1404),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1404),
    [sym_next] = ACTIONS(1404),
    [sym_true] = ACTIONS(1404),
    [sym_false] = ACTIONS(1404),
    [sym_null] = ACTIONS(1404),
    [sym_inf] = ACTIONS(1404),
    [sym_nan] = ACTIONS(1404),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1402),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [239] = {
    [anon_sym_LF] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_RBRACE] = ACTIONS(612),
    [anon_sym_LT_DASH] = ACTIONS(612),
    [anon_sym_COLON_EQ] = ACTIONS(612),
    [anon_sym_LT_LT_DASH] = ACTIONS(612),
    [anon_sym_DASH_GT] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(612),
    [anon_sym_DOLLAR] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_COLON_COLON] = ACTIONS(1406),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1408),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_CARET] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(612),
    [anon_sym_GT_EQ] = ACTIONS(612),
    [anon_sym_EQ_EQ] = ACTIONS(612),
    [anon_sym_BANG_EQ] = ACTIONS(612),
    [anon_sym_PIPE_PIPE] = ACTIONS(612),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(612),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(612),
    [sym_integer] = ACTIONS(612),
    [sym_float] = ACTIONS(612),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(612),
    [anon_sym_SQUOTE] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(612),
  },
  [240] = {
    [sym_function_definition] = STATE(581),
    [sym_if] = STATE(581),
    [sym_while] = STATE(581),
    [sym_repeat] = STATE(581),
    [sym_for] = STATE(581),
    [sym_switch] = STATE(581),
    [sym_call] = STATE(581),
    [sym__assignment] = STATE(581),
    [sym_left_assignment] = STATE(581),
    [sym_left_assignment2] = STATE(581),
    [sym_equals_assignment] = STATE(581),
    [sym_super_assignment] = STATE(581),
    [sym_right_assignment] = STATE(581),
    [sym_brace_list] = STATE(581),
    [sym_paren_list] = STATE(581),
    [sym_subset] = STATE(581),
    [sym_subset2] = STATE(581),
    [sym_dollar] = STATE(581),
    [sym_slot] = STATE(581),
    [sym_namespace_get] = STATE(581),
    [sym_namespace_get_internal] = STATE(581),
    [sym_unary] = STATE(581),
    [sym_binary] = STATE(581),
    [sym_na] = STATE(581),
    [sym__expression] = STATE(581),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(581),
    [sym_string] = STATE(581),
    [anon_sym_SEMI] = ACTIONS(1410),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1412),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1412),
    [sym_next] = ACTIONS(1412),
    [sym_true] = ACTIONS(1412),
    [sym_false] = ACTIONS(1412),
    [sym_null] = ACTIONS(1412),
    [sym_inf] = ACTIONS(1412),
    [sym_nan] = ACTIONS(1412),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1410),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [241] = {
    [sym_function_definition] = STATE(757),
    [sym_if] = STATE(757),
    [sym_while] = STATE(757),
    [sym_repeat] = STATE(757),
    [sym_for] = STATE(757),
    [sym_switch] = STATE(757),
    [sym_call] = STATE(757),
    [sym__assignment] = STATE(757),
    [sym_left_assignment] = STATE(757),
    [sym_left_assignment2] = STATE(757),
    [sym_equals_assignment] = STATE(757),
    [sym_super_assignment] = STATE(757),
    [sym_right_assignment] = STATE(757),
    [sym_brace_list] = STATE(757),
    [sym_paren_list] = STATE(757),
    [sym_subset] = STATE(757),
    [sym_subset2] = STATE(757),
    [sym_dollar] = STATE(757),
    [sym_slot] = STATE(757),
    [sym_namespace_get] = STATE(757),
    [sym_namespace_get_internal] = STATE(757),
    [sym_unary] = STATE(757),
    [sym_binary] = STATE(757),
    [sym_na] = STATE(757),
    [sym__expression] = STATE(757),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(757),
    [sym_string] = STATE(757),
    [anon_sym_SEMI] = ACTIONS(1414),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1416),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1416),
    [sym_next] = ACTIONS(1416),
    [sym_true] = ACTIONS(1416),
    [sym_false] = ACTIONS(1416),
    [sym_null] = ACTIONS(1416),
    [sym_inf] = ACTIONS(1416),
    [sym_nan] = ACTIONS(1416),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1414),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [242] = {
    [sym_function_definition] = STATE(827),
    [sym_if] = STATE(827),
    [sym_while] = STATE(827),
    [sym_repeat] = STATE(827),
    [sym_for] = STATE(827),
    [sym_switch] = STATE(827),
    [sym_call] = STATE(827),
    [sym__assignment] = STATE(827),
    [sym_left_assignment] = STATE(827),
    [sym_left_assignment2] = STATE(827),
    [sym_equals_assignment] = STATE(827),
    [sym_super_assignment] = STATE(827),
    [sym_right_assignment] = STATE(827),
    [sym_brace_list] = STATE(827),
    [sym_paren_list] = STATE(827),
    [sym_subset] = STATE(827),
    [sym_subset2] = STATE(827),
    [sym_dollar] = STATE(827),
    [sym_slot] = STATE(827),
    [sym_namespace_get] = STATE(827),
    [sym_namespace_get_internal] = STATE(827),
    [sym_unary] = STATE(827),
    [sym_binary] = STATE(827),
    [sym_na] = STATE(827),
    [sym__expression] = STATE(827),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(827),
    [sym_string] = STATE(827),
    [anon_sym_SEMI] = ACTIONS(1418),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1420),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1420),
    [sym_next] = ACTIONS(1420),
    [sym_true] = ACTIONS(1420),
    [sym_false] = ACTIONS(1420),
    [sym_null] = ACTIONS(1420),
    [sym_inf] = ACTIONS(1420),
    [sym_nan] = ACTIONS(1420),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1418),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [243] = {
    [sym_function_definition] = STATE(127),
    [sym_if] = STATE(127),
    [sym_while] = STATE(127),
    [sym_repeat] = STATE(127),
    [sym_for] = STATE(127),
    [sym_switch] = STATE(127),
    [sym_call] = STATE(127),
    [sym__assignment] = STATE(127),
    [sym_left_assignment] = STATE(127),
    [sym_left_assignment2] = STATE(127),
    [sym_equals_assignment] = STATE(127),
    [sym_super_assignment] = STATE(127),
    [sym_right_assignment] = STATE(127),
    [sym_brace_list] = STATE(127),
    [sym_paren_list] = STATE(127),
    [sym_subset] = STATE(127),
    [sym_subset2] = STATE(127),
    [sym_dollar] = STATE(127),
    [sym_slot] = STATE(127),
    [sym_namespace_get] = STATE(127),
    [sym_namespace_get_internal] = STATE(127),
    [sym_unary] = STATE(127),
    [sym_binary] = STATE(127),
    [sym_na] = STATE(127),
    [sym__expression] = STATE(127),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(127),
    [sym_string] = STATE(127),
    [anon_sym_SEMI] = ACTIONS(1422),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(1424),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(1424),
    [sym_next] = ACTIONS(1424),
    [sym_true] = ACTIONS(1424),
    [sym_false] = ACTIONS(1424),
    [sym_null] = ACTIONS(1424),
    [sym_inf] = ACTIONS(1424),
    [sym_nan] = ACTIONS(1424),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(1422),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [244] = {
    [ts_builtin_sym_end] = ACTIONS(622),
    [anon_sym_LF] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_LT_DASH] = ACTIONS(624),
    [anon_sym_COLON_EQ] = ACTIONS(624),
    [anon_sym_LT_LT_DASH] = ACTIONS(624),
    [anon_sym_DASH_GT] = ACTIONS(624),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(624),
    [anon_sym_DOLLAR] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(624),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_STAR] = ACTIONS(624),
    [anon_sym_SLASH] = ACTIONS(624),
    [anon_sym_CARET] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(624),
    [anon_sym_GT_EQ] = ACTIONS(624),
    [anon_sym_EQ_EQ] = ACTIONS(624),
    [anon_sym_BANG_EQ] = ACTIONS(624),
    [anon_sym_PIPE_PIPE] = ACTIONS(624),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(624),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(624),
    [sym_integer] = ACTIONS(624),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(624),
    [anon_sym_SQUOTE] = ACTIONS(624),
    [anon_sym_PERCENT] = ACTIONS(624),
  },
  [245] = {
    [sym_function_definition] = STATE(413),
    [sym_if] = STATE(413),
    [sym_while] = STATE(413),
    [sym_repeat] = STATE(413),
    [sym_for] = STATE(413),
    [sym_switch] = STATE(413),
    [sym_call] = STATE(413),
    [sym__assignment] = STATE(413),
    [sym_left_assignment] = STATE(413),
    [sym_left_assignment2] = STATE(413),
    [sym_equals_assignment] = STATE(413),
    [sym_super_assignment] = STATE(413),
    [sym_right_assignment] = STATE(413),
    [sym_brace_list] = STATE(413),
    [sym_paren_list] = STATE(413),
    [sym_subset] = STATE(413),
    [sym_subset2] = STATE(413),
    [sym_dollar] = STATE(413),
    [sym_slot] = STATE(413),
    [sym_namespace_get] = STATE(413),
    [sym_namespace_get_internal] = STATE(413),
    [sym_unary] = STATE(413),
    [sym_binary] = STATE(413),
    [sym_na] = STATE(413),
    [sym__expression] = STATE(413),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(413),
    [sym_string] = STATE(413),
    [anon_sym_SEMI] = ACTIONS(1426),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1428),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1428),
    [sym_next] = ACTIONS(1428),
    [sym_true] = ACTIONS(1428),
    [sym_false] = ACTIONS(1428),
    [sym_null] = ACTIONS(1428),
    [sym_inf] = ACTIONS(1428),
    [sym_nan] = ACTIONS(1428),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1426),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [246] = {
    [sym_function_definition] = STATE(414),
    [sym_if] = STATE(414),
    [sym_while] = STATE(414),
    [sym_repeat] = STATE(414),
    [sym_for] = STATE(414),
    [sym_switch] = STATE(414),
    [sym_call] = STATE(414),
    [sym__assignment] = STATE(414),
    [sym_left_assignment] = STATE(414),
    [sym_left_assignment2] = STATE(414),
    [sym_equals_assignment] = STATE(414),
    [sym_super_assignment] = STATE(414),
    [sym_right_assignment] = STATE(414),
    [sym_brace_list] = STATE(414),
    [sym_paren_list] = STATE(414),
    [sym_subset] = STATE(414),
    [sym_subset2] = STATE(414),
    [sym_dollar] = STATE(414),
    [sym_slot] = STATE(414),
    [sym_namespace_get] = STATE(414),
    [sym_namespace_get_internal] = STATE(414),
    [sym_unary] = STATE(414),
    [sym_binary] = STATE(414),
    [sym_na] = STATE(414),
    [sym__expression] = STATE(414),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(414),
    [sym_string] = STATE(414),
    [anon_sym_SEMI] = ACTIONS(1430),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1432),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1432),
    [sym_next] = ACTIONS(1432),
    [sym_true] = ACTIONS(1432),
    [sym_false] = ACTIONS(1432),
    [sym_null] = ACTIONS(1432),
    [sym_inf] = ACTIONS(1432),
    [sym_nan] = ACTIONS(1432),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1430),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [247] = {
    [anon_sym_LF] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_function] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_repeat] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_EQ] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_RBRACE] = ACTIONS(624),
    [anon_sym_LT_DASH] = ACTIONS(624),
    [anon_sym_COLON_EQ] = ACTIONS(624),
    [anon_sym_LT_LT_DASH] = ACTIONS(624),
    [anon_sym_DASH_GT] = ACTIONS(624),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(624),
    [anon_sym_DOLLAR] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_COLON_COLON] = ACTIONS(624),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(624),
    [sym_dots] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_STAR] = ACTIONS(624),
    [anon_sym_SLASH] = ACTIONS(624),
    [anon_sym_CARET] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(624),
    [anon_sym_GT_EQ] = ACTIONS(624),
    [anon_sym_EQ_EQ] = ACTIONS(624),
    [anon_sym_BANG_EQ] = ACTIONS(624),
    [anon_sym_PIPE_PIPE] = ACTIONS(624),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_AMP_AMP] = ACTIONS(624),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_COLON] = ACTIONS(624),
    [sym_break] = ACTIONS(624),
    [sym_next] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_null] = ACTIONS(624),
    [sym_inf] = ACTIONS(624),
    [sym_nan] = ACTIONS(624),
    [anon_sym_NA] = ACTIONS(624),
    [anon_sym_NA_character_] = ACTIONS(624),
    [anon_sym_NA_complex_] = ACTIONS(624),
    [anon_sym_NA_integer_] = ACTIONS(624),
    [anon_sym_NA_real_] = ACTIONS(624),
    [aux_sym_identifier_token1] = ACTIONS(624),
    [anon_sym_BQUOTE] = ACTIONS(624),
    [sym_integer] = ACTIONS(624),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(624),
    [anon_sym_SQUOTE] = ACTIONS(624),
    [anon_sym_PERCENT] = ACTIONS(624),
  },
  [248] = {
    [sym_function_definition] = STATE(417),
    [sym_if] = STATE(417),
    [sym_while] = STATE(417),
    [sym_repeat] = STATE(417),
    [sym_for] = STATE(417),
    [sym_switch] = STATE(417),
    [sym_call] = STATE(417),
    [sym__assignment] = STATE(417),
    [sym_left_assignment] = STATE(417),
    [sym_left_assignment2] = STATE(417),
    [sym_equals_assignment] = STATE(417),
    [sym_super_assignment] = STATE(417),
    [sym_right_assignment] = STATE(417),
    [sym_brace_list] = STATE(417),
    [sym_paren_list] = STATE(417),
    [sym_subset] = STATE(417),
    [sym_subset2] = STATE(417),
    [sym_dollar] = STATE(417),
    [sym_slot] = STATE(417),
    [sym_namespace_get] = STATE(417),
    [sym_namespace_get_internal] = STATE(417),
    [sym_unary] = STATE(417),
    [sym_binary] = STATE(417),
    [sym_na] = STATE(417),
    [sym__expression] = STATE(417),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(417),
    [sym_string] = STATE(417),
    [anon_sym_SEMI] = ACTIONS(1434),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1436),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1436),
    [sym_next] = ACTIONS(1436),
    [sym_true] = ACTIONS(1436),
    [sym_false] = ACTIONS(1436),
    [sym_null] = ACTIONS(1436),
    [sym_inf] = ACTIONS(1436),
    [sym_nan] = ACTIONS(1436),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1434),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [249] = {
    [sym_function_definition] = STATE(420),
    [sym_if] = STATE(420),
    [sym_while] = STATE(420),
    [sym_repeat] = STATE(420),
    [sym_for] = STATE(420),
    [sym_switch] = STATE(420),
    [sym_call] = STATE(420),
    [sym__assignment] = STATE(420),
    [sym_left_assignment] = STATE(420),
    [sym_left_assignment2] = STATE(420),
    [sym_equals_assignment] = STATE(420),
    [sym_super_assignment] = STATE(420),
    [sym_right_assignment] = STATE(420),
    [sym_brace_list] = STATE(420),
    [sym_paren_list] = STATE(420),
    [sym_subset] = STATE(420),
    [sym_subset2] = STATE(420),
    [sym_dollar] = STATE(420),
    [sym_slot] = STATE(420),
    [sym_namespace_get] = STATE(420),
    [sym_namespace_get_internal] = STATE(420),
    [sym_unary] = STATE(420),
    [sym_binary] = STATE(420),
    [sym_na] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(420),
    [sym_string] = STATE(420),
    [anon_sym_SEMI] = ACTIONS(1438),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1440),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1440),
    [sym_next] = ACTIONS(1440),
    [sym_true] = ACTIONS(1440),
    [sym_false] = ACTIONS(1440),
    [sym_null] = ACTIONS(1440),
    [sym_inf] = ACTIONS(1440),
    [sym_nan] = ACTIONS(1440),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1438),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [250] = {
    [sym_function_definition] = STATE(584),
    [sym_if] = STATE(584),
    [sym_while] = STATE(584),
    [sym_repeat] = STATE(584),
    [sym_for] = STATE(584),
    [sym_switch] = STATE(584),
    [sym_call] = STATE(584),
    [sym__assignment] = STATE(584),
    [sym_left_assignment] = STATE(584),
    [sym_left_assignment2] = STATE(584),
    [sym_equals_assignment] = STATE(584),
    [sym_super_assignment] = STATE(584),
    [sym_right_assignment] = STATE(584),
    [sym_brace_list] = STATE(584),
    [sym_paren_list] = STATE(584),
    [sym_subset] = STATE(584),
    [sym_subset2] = STATE(584),
    [sym_dollar] = STATE(584),
    [sym_slot] = STATE(584),
    [sym_namespace_get] = STATE(584),
    [sym_namespace_get_internal] = STATE(584),
    [sym_unary] = STATE(584),
    [sym_binary] = STATE(584),
    [sym_na] = STATE(584),
    [sym__expression] = STATE(584),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(584),
    [sym_string] = STATE(584),
    [anon_sym_SEMI] = ACTIONS(1442),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1444),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1444),
    [sym_next] = ACTIONS(1444),
    [sym_true] = ACTIONS(1444),
    [sym_false] = ACTIONS(1444),
    [sym_null] = ACTIONS(1444),
    [sym_inf] = ACTIONS(1444),
    [sym_nan] = ACTIONS(1444),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1442),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [251] = {
    [sym_function_definition] = STATE(586),
    [sym_if] = STATE(586),
    [sym_while] = STATE(586),
    [sym_repeat] = STATE(586),
    [sym_for] = STATE(586),
    [sym_switch] = STATE(586),
    [sym_call] = STATE(586),
    [sym__assignment] = STATE(586),
    [sym_left_assignment] = STATE(586),
    [sym_left_assignment2] = STATE(586),
    [sym_equals_assignment] = STATE(586),
    [sym_super_assignment] = STATE(586),
    [sym_right_assignment] = STATE(586),
    [sym_brace_list] = STATE(586),
    [sym_paren_list] = STATE(586),
    [sym_subset] = STATE(586),
    [sym_subset2] = STATE(586),
    [sym_dollar] = STATE(586),
    [sym_slot] = STATE(586),
    [sym_namespace_get] = STATE(586),
    [sym_namespace_get_internal] = STATE(586),
    [sym_unary] = STATE(586),
    [sym_binary] = STATE(586),
    [sym_na] = STATE(586),
    [sym__expression] = STATE(586),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(586),
    [sym_string] = STATE(586),
    [anon_sym_SEMI] = ACTIONS(1446),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1448),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1448),
    [sym_next] = ACTIONS(1448),
    [sym_true] = ACTIONS(1448),
    [sym_false] = ACTIONS(1448),
    [sym_null] = ACTIONS(1448),
    [sym_inf] = ACTIONS(1448),
    [sym_nan] = ACTIONS(1448),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1446),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [252] = {
    [sym_function_definition] = STATE(591),
    [sym_if] = STATE(591),
    [sym_while] = STATE(591),
    [sym_repeat] = STATE(591),
    [sym_for] = STATE(591),
    [sym_switch] = STATE(591),
    [sym_call] = STATE(591),
    [sym__assignment] = STATE(591),
    [sym_left_assignment] = STATE(591),
    [sym_left_assignment2] = STATE(591),
    [sym_equals_assignment] = STATE(591),
    [sym_super_assignment] = STATE(591),
    [sym_right_assignment] = STATE(591),
    [sym_brace_list] = STATE(591),
    [sym_paren_list] = STATE(591),
    [sym_subset] = STATE(591),
    [sym_subset2] = STATE(591),
    [sym_dollar] = STATE(591),
    [sym_slot] = STATE(591),
    [sym_namespace_get] = STATE(591),
    [sym_namespace_get_internal] = STATE(591),
    [sym_unary] = STATE(591),
    [sym_binary] = STATE(591),
    [sym_na] = STATE(591),
    [sym__expression] = STATE(591),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(591),
    [sym_string] = STATE(591),
    [anon_sym_SEMI] = ACTIONS(1450),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1452),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1452),
    [sym_next] = ACTIONS(1452),
    [sym_true] = ACTIONS(1452),
    [sym_false] = ACTIONS(1452),
    [sym_null] = ACTIONS(1452),
    [sym_inf] = ACTIONS(1452),
    [sym_nan] = ACTIONS(1452),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1450),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [253] = {
    [sym_function_definition] = STATE(592),
    [sym_if] = STATE(592),
    [sym_while] = STATE(592),
    [sym_repeat] = STATE(592),
    [sym_for] = STATE(592),
    [sym_switch] = STATE(592),
    [sym_call] = STATE(592),
    [sym__assignment] = STATE(592),
    [sym_left_assignment] = STATE(592),
    [sym_left_assignment2] = STATE(592),
    [sym_equals_assignment] = STATE(592),
    [sym_super_assignment] = STATE(592),
    [sym_right_assignment] = STATE(592),
    [sym_brace_list] = STATE(592),
    [sym_paren_list] = STATE(592),
    [sym_subset] = STATE(592),
    [sym_subset2] = STATE(592),
    [sym_dollar] = STATE(592),
    [sym_slot] = STATE(592),
    [sym_namespace_get] = STATE(592),
    [sym_namespace_get_internal] = STATE(592),
    [sym_unary] = STATE(592),
    [sym_binary] = STATE(592),
    [sym_na] = STATE(592),
    [sym__expression] = STATE(592),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(592),
    [sym_string] = STATE(592),
    [anon_sym_SEMI] = ACTIONS(1454),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1456),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1456),
    [sym_next] = ACTIONS(1456),
    [sym_true] = ACTIONS(1456),
    [sym_false] = ACTIONS(1456),
    [sym_null] = ACTIONS(1456),
    [sym_inf] = ACTIONS(1456),
    [sym_nan] = ACTIONS(1456),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1454),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [254] = {
    [sym_function_definition] = STATE(600),
    [sym_if] = STATE(600),
    [sym_while] = STATE(600),
    [sym_repeat] = STATE(600),
    [sym_for] = STATE(600),
    [sym_switch] = STATE(600),
    [sym_call] = STATE(600),
    [sym__assignment] = STATE(600),
    [sym_left_assignment] = STATE(600),
    [sym_left_assignment2] = STATE(600),
    [sym_equals_assignment] = STATE(600),
    [sym_super_assignment] = STATE(600),
    [sym_right_assignment] = STATE(600),
    [sym_brace_list] = STATE(600),
    [sym_paren_list] = STATE(600),
    [sym_subset] = STATE(600),
    [sym_subset2] = STATE(600),
    [sym_dollar] = STATE(600),
    [sym_slot] = STATE(600),
    [sym_namespace_get] = STATE(600),
    [sym_namespace_get_internal] = STATE(600),
    [sym_unary] = STATE(600),
    [sym_binary] = STATE(600),
    [sym_na] = STATE(600),
    [sym__expression] = STATE(600),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(600),
    [sym_string] = STATE(600),
    [anon_sym_SEMI] = ACTIONS(1458),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1460),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1460),
    [sym_next] = ACTIONS(1460),
    [sym_true] = ACTIONS(1460),
    [sym_false] = ACTIONS(1460),
    [sym_null] = ACTIONS(1460),
    [sym_inf] = ACTIONS(1460),
    [sym_nan] = ACTIONS(1460),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1458),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [255] = {
    [sym_function_definition] = STATE(444),
    [sym_if] = STATE(444),
    [sym_while] = STATE(444),
    [sym_repeat] = STATE(444),
    [sym_for] = STATE(444),
    [sym_switch] = STATE(444),
    [sym_call] = STATE(444),
    [sym__assignment] = STATE(444),
    [sym_left_assignment] = STATE(444),
    [sym_left_assignment2] = STATE(444),
    [sym_equals_assignment] = STATE(444),
    [sym_super_assignment] = STATE(444),
    [sym_right_assignment] = STATE(444),
    [sym_brace_list] = STATE(444),
    [sym_paren_list] = STATE(444),
    [sym_subset] = STATE(444),
    [sym_subset2] = STATE(444),
    [sym_dollar] = STATE(444),
    [sym_slot] = STATE(444),
    [sym_namespace_get] = STATE(444),
    [sym_namespace_get_internal] = STATE(444),
    [sym_unary] = STATE(444),
    [sym_binary] = STATE(444),
    [sym_na] = STATE(444),
    [sym__expression] = STATE(444),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(444),
    [sym_string] = STATE(444),
    [anon_sym_SEMI] = ACTIONS(1462),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1464),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1464),
    [sym_next] = ACTIONS(1464),
    [sym_true] = ACTIONS(1464),
    [sym_false] = ACTIONS(1464),
    [sym_null] = ACTIONS(1464),
    [sym_inf] = ACTIONS(1464),
    [sym_nan] = ACTIONS(1464),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1462),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [256] = {
    [sym_function_definition] = STATE(562),
    [sym_if] = STATE(562),
    [sym_while] = STATE(562),
    [sym_repeat] = STATE(562),
    [sym_for] = STATE(562),
    [sym_switch] = STATE(562),
    [sym_call] = STATE(562),
    [sym__assignment] = STATE(562),
    [sym_left_assignment] = STATE(562),
    [sym_left_assignment2] = STATE(562),
    [sym_equals_assignment] = STATE(562),
    [sym_super_assignment] = STATE(562),
    [sym_right_assignment] = STATE(562),
    [sym_brace_list] = STATE(562),
    [sym_paren_list] = STATE(562),
    [sym_subset] = STATE(562),
    [sym_subset2] = STATE(562),
    [sym_dollar] = STATE(562),
    [sym_slot] = STATE(562),
    [sym_namespace_get] = STATE(562),
    [sym_namespace_get_internal] = STATE(562),
    [sym_unary] = STATE(562),
    [sym_binary] = STATE(562),
    [sym_na] = STATE(562),
    [sym__expression] = STATE(562),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(562),
    [sym_string] = STATE(562),
    [anon_sym_SEMI] = ACTIONS(1466),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1468),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1468),
    [sym_next] = ACTIONS(1468),
    [sym_true] = ACTIONS(1468),
    [sym_false] = ACTIONS(1468),
    [sym_null] = ACTIONS(1468),
    [sym_inf] = ACTIONS(1468),
    [sym_nan] = ACTIONS(1468),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1466),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [257] = {
    [sym_function_definition] = STATE(602),
    [sym_if] = STATE(602),
    [sym_while] = STATE(602),
    [sym_repeat] = STATE(602),
    [sym_for] = STATE(602),
    [sym_switch] = STATE(602),
    [sym_call] = STATE(602),
    [sym__assignment] = STATE(602),
    [sym_left_assignment] = STATE(602),
    [sym_left_assignment2] = STATE(602),
    [sym_equals_assignment] = STATE(602),
    [sym_super_assignment] = STATE(602),
    [sym_right_assignment] = STATE(602),
    [sym_brace_list] = STATE(602),
    [sym_paren_list] = STATE(602),
    [sym_subset] = STATE(602),
    [sym_subset2] = STATE(602),
    [sym_dollar] = STATE(602),
    [sym_slot] = STATE(602),
    [sym_namespace_get] = STATE(602),
    [sym_namespace_get_internal] = STATE(602),
    [sym_unary] = STATE(602),
    [sym_binary] = STATE(602),
    [sym_na] = STATE(602),
    [sym__expression] = STATE(602),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(602),
    [sym_string] = STATE(602),
    [anon_sym_SEMI] = ACTIONS(1470),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1472),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1472),
    [sym_next] = ACTIONS(1472),
    [sym_true] = ACTIONS(1472),
    [sym_false] = ACTIONS(1472),
    [sym_null] = ACTIONS(1472),
    [sym_inf] = ACTIONS(1472),
    [sym_nan] = ACTIONS(1472),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1470),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [258] = {
    [sym_function_definition] = STATE(603),
    [sym_if] = STATE(603),
    [sym_while] = STATE(603),
    [sym_repeat] = STATE(603),
    [sym_for] = STATE(603),
    [sym_switch] = STATE(603),
    [sym_call] = STATE(603),
    [sym__assignment] = STATE(603),
    [sym_left_assignment] = STATE(603),
    [sym_left_assignment2] = STATE(603),
    [sym_equals_assignment] = STATE(603),
    [sym_super_assignment] = STATE(603),
    [sym_right_assignment] = STATE(603),
    [sym_brace_list] = STATE(603),
    [sym_paren_list] = STATE(603),
    [sym_subset] = STATE(603),
    [sym_subset2] = STATE(603),
    [sym_dollar] = STATE(603),
    [sym_slot] = STATE(603),
    [sym_namespace_get] = STATE(603),
    [sym_namespace_get_internal] = STATE(603),
    [sym_unary] = STATE(603),
    [sym_binary] = STATE(603),
    [sym_na] = STATE(603),
    [sym__expression] = STATE(603),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(603),
    [sym_string] = STATE(603),
    [anon_sym_SEMI] = ACTIONS(1474),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1476),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1476),
    [sym_next] = ACTIONS(1476),
    [sym_true] = ACTIONS(1476),
    [sym_false] = ACTIONS(1476),
    [sym_null] = ACTIONS(1476),
    [sym_inf] = ACTIONS(1476),
    [sym_nan] = ACTIONS(1476),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1474),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [259] = {
    [sym_function_definition] = STATE(608),
    [sym_if] = STATE(608),
    [sym_while] = STATE(608),
    [sym_repeat] = STATE(608),
    [sym_for] = STATE(608),
    [sym_switch] = STATE(608),
    [sym_call] = STATE(608),
    [sym__assignment] = STATE(608),
    [sym_left_assignment] = STATE(608),
    [sym_left_assignment2] = STATE(608),
    [sym_equals_assignment] = STATE(608),
    [sym_super_assignment] = STATE(608),
    [sym_right_assignment] = STATE(608),
    [sym_brace_list] = STATE(608),
    [sym_paren_list] = STATE(608),
    [sym_subset] = STATE(608),
    [sym_subset2] = STATE(608),
    [sym_dollar] = STATE(608),
    [sym_slot] = STATE(608),
    [sym_namespace_get] = STATE(608),
    [sym_namespace_get_internal] = STATE(608),
    [sym_unary] = STATE(608),
    [sym_binary] = STATE(608),
    [sym_na] = STATE(608),
    [sym__expression] = STATE(608),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(608),
    [sym_string] = STATE(608),
    [anon_sym_SEMI] = ACTIONS(1478),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1480),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1480),
    [sym_next] = ACTIONS(1480),
    [sym_true] = ACTIONS(1480),
    [sym_false] = ACTIONS(1480),
    [sym_null] = ACTIONS(1480),
    [sym_inf] = ACTIONS(1480),
    [sym_nan] = ACTIONS(1480),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1478),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [260] = {
    [sym_function_definition] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_repeat] = STATE(609),
    [sym_for] = STATE(609),
    [sym_switch] = STATE(609),
    [sym_call] = STATE(609),
    [sym__assignment] = STATE(609),
    [sym_left_assignment] = STATE(609),
    [sym_left_assignment2] = STATE(609),
    [sym_equals_assignment] = STATE(609),
    [sym_super_assignment] = STATE(609),
    [sym_right_assignment] = STATE(609),
    [sym_brace_list] = STATE(609),
    [sym_paren_list] = STATE(609),
    [sym_subset] = STATE(609),
    [sym_subset2] = STATE(609),
    [sym_dollar] = STATE(609),
    [sym_slot] = STATE(609),
    [sym_namespace_get] = STATE(609),
    [sym_namespace_get_internal] = STATE(609),
    [sym_unary] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_na] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(609),
    [sym_string] = STATE(609),
    [anon_sym_SEMI] = ACTIONS(1482),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1484),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1484),
    [sym_next] = ACTIONS(1484),
    [sym_true] = ACTIONS(1484),
    [sym_false] = ACTIONS(1484),
    [sym_null] = ACTIONS(1484),
    [sym_inf] = ACTIONS(1484),
    [sym_nan] = ACTIONS(1484),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1482),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [261] = {
    [sym_function_definition] = STATE(601),
    [sym_if] = STATE(601),
    [sym_while] = STATE(601),
    [sym_repeat] = STATE(601),
    [sym_for] = STATE(601),
    [sym_switch] = STATE(601),
    [sym_call] = STATE(601),
    [sym__assignment] = STATE(601),
    [sym_left_assignment] = STATE(601),
    [sym_left_assignment2] = STATE(601),
    [sym_equals_assignment] = STATE(601),
    [sym_super_assignment] = STATE(601),
    [sym_right_assignment] = STATE(601),
    [sym_brace_list] = STATE(601),
    [sym_paren_list] = STATE(601),
    [sym_subset] = STATE(601),
    [sym_subset2] = STATE(601),
    [sym_dollar] = STATE(601),
    [sym_slot] = STATE(601),
    [sym_namespace_get] = STATE(601),
    [sym_namespace_get_internal] = STATE(601),
    [sym_unary] = STATE(601),
    [sym_binary] = STATE(601),
    [sym_na] = STATE(601),
    [sym__expression] = STATE(601),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(601),
    [sym_string] = STATE(601),
    [anon_sym_SEMI] = ACTIONS(1486),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1488),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1488),
    [sym_next] = ACTIONS(1488),
    [sym_true] = ACTIONS(1488),
    [sym_false] = ACTIONS(1488),
    [sym_null] = ACTIONS(1488),
    [sym_inf] = ACTIONS(1488),
    [sym_nan] = ACTIONS(1488),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1486),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [262] = {
    [sym_function_definition] = STATE(611),
    [sym_if] = STATE(611),
    [sym_while] = STATE(611),
    [sym_repeat] = STATE(611),
    [sym_for] = STATE(611),
    [sym_switch] = STATE(611),
    [sym_call] = STATE(611),
    [sym__assignment] = STATE(611),
    [sym_left_assignment] = STATE(611),
    [sym_left_assignment2] = STATE(611),
    [sym_equals_assignment] = STATE(611),
    [sym_super_assignment] = STATE(611),
    [sym_right_assignment] = STATE(611),
    [sym_brace_list] = STATE(611),
    [sym_paren_list] = STATE(611),
    [sym_subset] = STATE(611),
    [sym_subset2] = STATE(611),
    [sym_dollar] = STATE(611),
    [sym_slot] = STATE(611),
    [sym_namespace_get] = STATE(611),
    [sym_namespace_get_internal] = STATE(611),
    [sym_unary] = STATE(611),
    [sym_binary] = STATE(611),
    [sym_na] = STATE(611),
    [sym__expression] = STATE(611),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(611),
    [sym_string] = STATE(611),
    [anon_sym_SEMI] = ACTIONS(1490),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1492),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1492),
    [sym_next] = ACTIONS(1492),
    [sym_true] = ACTIONS(1492),
    [sym_false] = ACTIONS(1492),
    [sym_null] = ACTIONS(1492),
    [sym_inf] = ACTIONS(1492),
    [sym_nan] = ACTIONS(1492),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1490),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [263] = {
    [sym_function_definition] = STATE(612),
    [sym_if] = STATE(612),
    [sym_while] = STATE(612),
    [sym_repeat] = STATE(612),
    [sym_for] = STATE(612),
    [sym_switch] = STATE(612),
    [sym_call] = STATE(612),
    [sym__assignment] = STATE(612),
    [sym_left_assignment] = STATE(612),
    [sym_left_assignment2] = STATE(612),
    [sym_equals_assignment] = STATE(612),
    [sym_super_assignment] = STATE(612),
    [sym_right_assignment] = STATE(612),
    [sym_brace_list] = STATE(612),
    [sym_paren_list] = STATE(612),
    [sym_subset] = STATE(612),
    [sym_subset2] = STATE(612),
    [sym_dollar] = STATE(612),
    [sym_slot] = STATE(612),
    [sym_namespace_get] = STATE(612),
    [sym_namespace_get_internal] = STATE(612),
    [sym_unary] = STATE(612),
    [sym_binary] = STATE(612),
    [sym_na] = STATE(612),
    [sym__expression] = STATE(612),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(612),
    [sym_string] = STATE(612),
    [anon_sym_SEMI] = ACTIONS(1494),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1496),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1496),
    [sym_next] = ACTIONS(1496),
    [sym_true] = ACTIONS(1496),
    [sym_false] = ACTIONS(1496),
    [sym_null] = ACTIONS(1496),
    [sym_inf] = ACTIONS(1496),
    [sym_nan] = ACTIONS(1496),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1494),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [264] = {
    [sym_function_definition] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(618),
    [anon_sym_SEMI] = ACTIONS(1498),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1500),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1500),
    [sym_next] = ACTIONS(1500),
    [sym_true] = ACTIONS(1500),
    [sym_false] = ACTIONS(1500),
    [sym_null] = ACTIONS(1500),
    [sym_inf] = ACTIONS(1500),
    [sym_nan] = ACTIONS(1500),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1498),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [265] = {
    [sym_function_definition] = STATE(619),
    [sym_if] = STATE(619),
    [sym_while] = STATE(619),
    [sym_repeat] = STATE(619),
    [sym_for] = STATE(619),
    [sym_switch] = STATE(619),
    [sym_call] = STATE(619),
    [sym__assignment] = STATE(619),
    [sym_left_assignment] = STATE(619),
    [sym_left_assignment2] = STATE(619),
    [sym_equals_assignment] = STATE(619),
    [sym_super_assignment] = STATE(619),
    [sym_right_assignment] = STATE(619),
    [sym_brace_list] = STATE(619),
    [sym_paren_list] = STATE(619),
    [sym_subset] = STATE(619),
    [sym_subset2] = STATE(619),
    [sym_dollar] = STATE(619),
    [sym_slot] = STATE(619),
    [sym_namespace_get] = STATE(619),
    [sym_namespace_get_internal] = STATE(619),
    [sym_unary] = STATE(619),
    [sym_binary] = STATE(619),
    [sym_na] = STATE(619),
    [sym__expression] = STATE(619),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(619),
    [sym_string] = STATE(619),
    [anon_sym_SEMI] = ACTIONS(1502),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1504),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1504),
    [sym_next] = ACTIONS(1504),
    [sym_true] = ACTIONS(1504),
    [sym_false] = ACTIONS(1504),
    [sym_null] = ACTIONS(1504),
    [sym_inf] = ACTIONS(1504),
    [sym_nan] = ACTIONS(1504),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1502),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [266] = {
    [sym_function_definition] = STATE(561),
    [sym_if] = STATE(561),
    [sym_while] = STATE(561),
    [sym_repeat] = STATE(561),
    [sym_for] = STATE(561),
    [sym_switch] = STATE(561),
    [sym_call] = STATE(561),
    [sym__assignment] = STATE(561),
    [sym_left_assignment] = STATE(561),
    [sym_left_assignment2] = STATE(561),
    [sym_equals_assignment] = STATE(561),
    [sym_super_assignment] = STATE(561),
    [sym_right_assignment] = STATE(561),
    [sym_brace_list] = STATE(561),
    [sym_paren_list] = STATE(561),
    [sym_subset] = STATE(561),
    [sym_subset2] = STATE(561),
    [sym_dollar] = STATE(561),
    [sym_slot] = STATE(561),
    [sym_namespace_get] = STATE(561),
    [sym_namespace_get_internal] = STATE(561),
    [sym_unary] = STATE(561),
    [sym_binary] = STATE(561),
    [sym_na] = STATE(561),
    [sym__expression] = STATE(561),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(561),
    [sym_string] = STATE(561),
    [anon_sym_SEMI] = ACTIONS(1506),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1508),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1508),
    [sym_next] = ACTIONS(1508),
    [sym_true] = ACTIONS(1508),
    [sym_false] = ACTIONS(1508),
    [sym_null] = ACTIONS(1508),
    [sym_inf] = ACTIONS(1508),
    [sym_nan] = ACTIONS(1508),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1506),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [267] = {
    [sym_function_definition] = STATE(560),
    [sym_if] = STATE(560),
    [sym_while] = STATE(560),
    [sym_repeat] = STATE(560),
    [sym_for] = STATE(560),
    [sym_switch] = STATE(560),
    [sym_call] = STATE(560),
    [sym__assignment] = STATE(560),
    [sym_left_assignment] = STATE(560),
    [sym_left_assignment2] = STATE(560),
    [sym_equals_assignment] = STATE(560),
    [sym_super_assignment] = STATE(560),
    [sym_right_assignment] = STATE(560),
    [sym_brace_list] = STATE(560),
    [sym_paren_list] = STATE(560),
    [sym_subset] = STATE(560),
    [sym_subset2] = STATE(560),
    [sym_dollar] = STATE(560),
    [sym_slot] = STATE(560),
    [sym_namespace_get] = STATE(560),
    [sym_namespace_get_internal] = STATE(560),
    [sym_unary] = STATE(560),
    [sym_binary] = STATE(560),
    [sym_na] = STATE(560),
    [sym__expression] = STATE(560),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(560),
    [sym_string] = STATE(560),
    [anon_sym_SEMI] = ACTIONS(1510),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1512),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1512),
    [sym_next] = ACTIONS(1512),
    [sym_true] = ACTIONS(1512),
    [sym_false] = ACTIONS(1512),
    [sym_null] = ACTIONS(1512),
    [sym_inf] = ACTIONS(1512),
    [sym_nan] = ACTIONS(1512),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1510),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [268] = {
    [sym_function_definition] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [anon_sym_SEMI] = ACTIONS(1514),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1516),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1516),
    [sym_next] = ACTIONS(1516),
    [sym_true] = ACTIONS(1516),
    [sym_false] = ACTIONS(1516),
    [sym_null] = ACTIONS(1516),
    [sym_inf] = ACTIONS(1516),
    [sym_nan] = ACTIONS(1516),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1514),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [269] = {
    [sym_function_definition] = STATE(558),
    [sym_if] = STATE(558),
    [sym_while] = STATE(558),
    [sym_repeat] = STATE(558),
    [sym_for] = STATE(558),
    [sym_switch] = STATE(558),
    [sym_call] = STATE(558),
    [sym__assignment] = STATE(558),
    [sym_left_assignment] = STATE(558),
    [sym_left_assignment2] = STATE(558),
    [sym_equals_assignment] = STATE(558),
    [sym_super_assignment] = STATE(558),
    [sym_right_assignment] = STATE(558),
    [sym_brace_list] = STATE(558),
    [sym_paren_list] = STATE(558),
    [sym_subset] = STATE(558),
    [sym_subset2] = STATE(558),
    [sym_dollar] = STATE(558),
    [sym_slot] = STATE(558),
    [sym_namespace_get] = STATE(558),
    [sym_namespace_get_internal] = STATE(558),
    [sym_unary] = STATE(558),
    [sym_binary] = STATE(558),
    [sym_na] = STATE(558),
    [sym__expression] = STATE(558),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(558),
    [sym_string] = STATE(558),
    [anon_sym_SEMI] = ACTIONS(1518),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1520),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1520),
    [sym_next] = ACTIONS(1520),
    [sym_true] = ACTIONS(1520),
    [sym_false] = ACTIONS(1520),
    [sym_null] = ACTIONS(1520),
    [sym_inf] = ACTIONS(1520),
    [sym_nan] = ACTIONS(1520),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1518),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [270] = {
    [sym_function_definition] = STATE(775),
    [sym_if] = STATE(775),
    [sym_while] = STATE(775),
    [sym_repeat] = STATE(775),
    [sym_for] = STATE(775),
    [sym_switch] = STATE(775),
    [sym_call] = STATE(775),
    [sym__assignment] = STATE(775),
    [sym_left_assignment] = STATE(775),
    [sym_left_assignment2] = STATE(775),
    [sym_equals_assignment] = STATE(775),
    [sym_super_assignment] = STATE(775),
    [sym_right_assignment] = STATE(775),
    [sym_brace_list] = STATE(775),
    [sym_paren_list] = STATE(775),
    [sym_subset] = STATE(775),
    [sym_subset2] = STATE(775),
    [sym_dollar] = STATE(775),
    [sym_slot] = STATE(775),
    [sym_namespace_get] = STATE(775),
    [sym_namespace_get_internal] = STATE(775),
    [sym_unary] = STATE(775),
    [sym_binary] = STATE(775),
    [sym_na] = STATE(775),
    [sym__expression] = STATE(775),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(775),
    [sym_string] = STATE(775),
    [anon_sym_SEMI] = ACTIONS(1522),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1524),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1524),
    [sym_next] = ACTIONS(1524),
    [sym_true] = ACTIONS(1524),
    [sym_false] = ACTIONS(1524),
    [sym_null] = ACTIONS(1524),
    [sym_inf] = ACTIONS(1524),
    [sym_nan] = ACTIONS(1524),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1522),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [271] = {
    [anon_sym_LF] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(630),
    [anon_sym_function] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_repeat] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_EQ] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_RBRACE] = ACTIONS(630),
    [anon_sym_LT_DASH] = ACTIONS(630),
    [anon_sym_COLON_EQ] = ACTIONS(630),
    [anon_sym_LT_LT_DASH] = ACTIONS(630),
    [anon_sym_DASH_GT] = ACTIONS(630),
    [anon_sym_LBRACK] = ACTIONS(630),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(630),
    [anon_sym_DOLLAR] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(630),
    [anon_sym_COLON_COLON] = ACTIONS(630),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(630),
    [sym_dots] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(630),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_SLASH] = ACTIONS(630),
    [anon_sym_CARET] = ACTIONS(630),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_LT_EQ] = ACTIONS(630),
    [anon_sym_GT_EQ] = ACTIONS(630),
    [anon_sym_EQ_EQ] = ACTIONS(630),
    [anon_sym_BANG_EQ] = ACTIONS(630),
    [anon_sym_PIPE_PIPE] = ACTIONS(630),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP_AMP] = ACTIONS(630),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_COLON] = ACTIONS(630),
    [sym_break] = ACTIONS(630),
    [sym_next] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_inf] = ACTIONS(630),
    [sym_nan] = ACTIONS(630),
    [anon_sym_NA] = ACTIONS(630),
    [anon_sym_NA_character_] = ACTIONS(630),
    [anon_sym_NA_complex_] = ACTIONS(630),
    [anon_sym_NA_integer_] = ACTIONS(630),
    [anon_sym_NA_real_] = ACTIONS(630),
    [aux_sym_identifier_token1] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(630),
    [sym_integer] = ACTIONS(630),
    [sym_float] = ACTIONS(630),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [anon_sym_SQUOTE] = ACTIONS(630),
    [anon_sym_PERCENT] = ACTIONS(630),
  },
  [272] = {
    [sym_function_definition] = STATE(774),
    [sym_if] = STATE(774),
    [sym_while] = STATE(774),
    [sym_repeat] = STATE(774),
    [sym_for] = STATE(774),
    [sym_switch] = STATE(774),
    [sym_call] = STATE(774),
    [sym__assignment] = STATE(774),
    [sym_left_assignment] = STATE(774),
    [sym_left_assignment2] = STATE(774),
    [sym_equals_assignment] = STATE(774),
    [sym_super_assignment] = STATE(774),
    [sym_right_assignment] = STATE(774),
    [sym_brace_list] = STATE(774),
    [sym_paren_list] = STATE(774),
    [sym_subset] = STATE(774),
    [sym_subset2] = STATE(774),
    [sym_dollar] = STATE(774),
    [sym_slot] = STATE(774),
    [sym_namespace_get] = STATE(774),
    [sym_namespace_get_internal] = STATE(774),
    [sym_unary] = STATE(774),
    [sym_binary] = STATE(774),
    [sym_na] = STATE(774),
    [sym__expression] = STATE(774),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(774),
    [sym_string] = STATE(774),
    [anon_sym_SEMI] = ACTIONS(1526),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1528),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1528),
    [sym_next] = ACTIONS(1528),
    [sym_true] = ACTIONS(1528),
    [sym_false] = ACTIONS(1528),
    [sym_null] = ACTIONS(1528),
    [sym_inf] = ACTIONS(1528),
    [sym_nan] = ACTIONS(1528),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1526),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [273] = {
    [sym_function_definition] = STATE(773),
    [sym_if] = STATE(773),
    [sym_while] = STATE(773),
    [sym_repeat] = STATE(773),
    [sym_for] = STATE(773),
    [sym_switch] = STATE(773),
    [sym_call] = STATE(773),
    [sym__assignment] = STATE(773),
    [sym_left_assignment] = STATE(773),
    [sym_left_assignment2] = STATE(773),
    [sym_equals_assignment] = STATE(773),
    [sym_super_assignment] = STATE(773),
    [sym_right_assignment] = STATE(773),
    [sym_brace_list] = STATE(773),
    [sym_paren_list] = STATE(773),
    [sym_subset] = STATE(773),
    [sym_subset2] = STATE(773),
    [sym_dollar] = STATE(773),
    [sym_slot] = STATE(773),
    [sym_namespace_get] = STATE(773),
    [sym_namespace_get_internal] = STATE(773),
    [sym_unary] = STATE(773),
    [sym_binary] = STATE(773),
    [sym_na] = STATE(773),
    [sym__expression] = STATE(773),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(773),
    [sym_string] = STATE(773),
    [anon_sym_SEMI] = ACTIONS(1530),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1532),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1532),
    [sym_next] = ACTIONS(1532),
    [sym_true] = ACTIONS(1532),
    [sym_false] = ACTIONS(1532),
    [sym_null] = ACTIONS(1532),
    [sym_inf] = ACTIONS(1532),
    [sym_nan] = ACTIONS(1532),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1530),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [274] = {
    [sym_function_definition] = STATE(749),
    [sym_if] = STATE(749),
    [sym_while] = STATE(749),
    [sym_repeat] = STATE(749),
    [sym_for] = STATE(749),
    [sym_switch] = STATE(749),
    [sym_call] = STATE(749),
    [sym__assignment] = STATE(749),
    [sym_left_assignment] = STATE(749),
    [sym_left_assignment2] = STATE(749),
    [sym_equals_assignment] = STATE(749),
    [sym_super_assignment] = STATE(749),
    [sym_right_assignment] = STATE(749),
    [sym_brace_list] = STATE(749),
    [sym_paren_list] = STATE(749),
    [sym_subset] = STATE(749),
    [sym_subset2] = STATE(749),
    [sym_dollar] = STATE(749),
    [sym_slot] = STATE(749),
    [sym_namespace_get] = STATE(749),
    [sym_namespace_get_internal] = STATE(749),
    [sym_unary] = STATE(749),
    [sym_binary] = STATE(749),
    [sym_na] = STATE(749),
    [sym__expression] = STATE(749),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(749),
    [sym_string] = STATE(749),
    [anon_sym_SEMI] = ACTIONS(1534),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1536),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1536),
    [sym_next] = ACTIONS(1536),
    [sym_true] = ACTIONS(1536),
    [sym_false] = ACTIONS(1536),
    [sym_null] = ACTIONS(1536),
    [sym_inf] = ACTIONS(1536),
    [sym_nan] = ACTIONS(1536),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1534),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [275] = {
    [sym_function_definition] = STATE(762),
    [sym_if] = STATE(762),
    [sym_while] = STATE(762),
    [sym_repeat] = STATE(762),
    [sym_for] = STATE(762),
    [sym_switch] = STATE(762),
    [sym_call] = STATE(762),
    [sym__assignment] = STATE(762),
    [sym_left_assignment] = STATE(762),
    [sym_left_assignment2] = STATE(762),
    [sym_equals_assignment] = STATE(762),
    [sym_super_assignment] = STATE(762),
    [sym_right_assignment] = STATE(762),
    [sym_brace_list] = STATE(762),
    [sym_paren_list] = STATE(762),
    [sym_subset] = STATE(762),
    [sym_subset2] = STATE(762),
    [sym_dollar] = STATE(762),
    [sym_slot] = STATE(762),
    [sym_namespace_get] = STATE(762),
    [sym_namespace_get_internal] = STATE(762),
    [sym_unary] = STATE(762),
    [sym_binary] = STATE(762),
    [sym_na] = STATE(762),
    [sym__expression] = STATE(762),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(762),
    [sym_string] = STATE(762),
    [anon_sym_SEMI] = ACTIONS(1538),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1540),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1540),
    [sym_next] = ACTIONS(1540),
    [sym_true] = ACTIONS(1540),
    [sym_false] = ACTIONS(1540),
    [sym_null] = ACTIONS(1540),
    [sym_inf] = ACTIONS(1540),
    [sym_nan] = ACTIONS(1540),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1538),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [276] = {
    [sym_function_definition] = STATE(543),
    [sym_if] = STATE(543),
    [sym_while] = STATE(543),
    [sym_repeat] = STATE(543),
    [sym_for] = STATE(543),
    [sym_switch] = STATE(543),
    [sym_call] = STATE(543),
    [sym__assignment] = STATE(543),
    [sym_left_assignment] = STATE(543),
    [sym_left_assignment2] = STATE(543),
    [sym_equals_assignment] = STATE(543),
    [sym_super_assignment] = STATE(543),
    [sym_right_assignment] = STATE(543),
    [sym_brace_list] = STATE(543),
    [sym_paren_list] = STATE(543),
    [sym_subset] = STATE(543),
    [sym_subset2] = STATE(543),
    [sym_dollar] = STATE(543),
    [sym_slot] = STATE(543),
    [sym_namespace_get] = STATE(543),
    [sym_namespace_get_internal] = STATE(543),
    [sym_unary] = STATE(543),
    [sym_binary] = STATE(543),
    [sym_na] = STATE(543),
    [sym__expression] = STATE(543),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(543),
    [sym_string] = STATE(543),
    [anon_sym_SEMI] = ACTIONS(1542),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1544),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1544),
    [sym_next] = ACTIONS(1544),
    [sym_true] = ACTIONS(1544),
    [sym_false] = ACTIONS(1544),
    [sym_null] = ACTIONS(1544),
    [sym_inf] = ACTIONS(1544),
    [sym_nan] = ACTIONS(1544),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1542),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [277] = {
    [sym_function_definition] = STATE(540),
    [sym_if] = STATE(540),
    [sym_while] = STATE(540),
    [sym_repeat] = STATE(540),
    [sym_for] = STATE(540),
    [sym_switch] = STATE(540),
    [sym_call] = STATE(540),
    [sym__assignment] = STATE(540),
    [sym_left_assignment] = STATE(540),
    [sym_left_assignment2] = STATE(540),
    [sym_equals_assignment] = STATE(540),
    [sym_super_assignment] = STATE(540),
    [sym_right_assignment] = STATE(540),
    [sym_brace_list] = STATE(540),
    [sym_paren_list] = STATE(540),
    [sym_subset] = STATE(540),
    [sym_subset2] = STATE(540),
    [sym_dollar] = STATE(540),
    [sym_slot] = STATE(540),
    [sym_namespace_get] = STATE(540),
    [sym_namespace_get_internal] = STATE(540),
    [sym_unary] = STATE(540),
    [sym_binary] = STATE(540),
    [sym_na] = STATE(540),
    [sym__expression] = STATE(540),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(540),
    [sym_string] = STATE(540),
    [anon_sym_SEMI] = ACTIONS(1546),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1548),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1548),
    [sym_next] = ACTIONS(1548),
    [sym_true] = ACTIONS(1548),
    [sym_false] = ACTIONS(1548),
    [sym_null] = ACTIONS(1548),
    [sym_inf] = ACTIONS(1548),
    [sym_nan] = ACTIONS(1548),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1546),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [278] = {
    [sym_function_definition] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(563),
    [anon_sym_SEMI] = ACTIONS(1550),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1552),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1552),
    [sym_next] = ACTIONS(1552),
    [sym_true] = ACTIONS(1552),
    [sym_false] = ACTIONS(1552),
    [sym_null] = ACTIONS(1552),
    [sym_inf] = ACTIONS(1552),
    [sym_nan] = ACTIONS(1552),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1550),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [279] = {
    [sym_function_definition] = STATE(675),
    [sym_if] = STATE(675),
    [sym_while] = STATE(675),
    [sym_repeat] = STATE(675),
    [sym_for] = STATE(675),
    [sym_switch] = STATE(675),
    [sym_call] = STATE(675),
    [sym__assignment] = STATE(675),
    [sym_left_assignment] = STATE(675),
    [sym_left_assignment2] = STATE(675),
    [sym_equals_assignment] = STATE(675),
    [sym_super_assignment] = STATE(675),
    [sym_right_assignment] = STATE(675),
    [sym_brace_list] = STATE(675),
    [sym_paren_list] = STATE(675),
    [sym_subset] = STATE(675),
    [sym_subset2] = STATE(675),
    [sym_dollar] = STATE(675),
    [sym_slot] = STATE(675),
    [sym_namespace_get] = STATE(675),
    [sym_namespace_get_internal] = STATE(675),
    [sym_unary] = STATE(675),
    [sym_binary] = STATE(675),
    [sym_na] = STATE(675),
    [sym__expression] = STATE(675),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(675),
    [sym_string] = STATE(675),
    [anon_sym_SEMI] = ACTIONS(1554),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1556),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1556),
    [sym_next] = ACTIONS(1556),
    [sym_true] = ACTIONS(1556),
    [sym_false] = ACTIONS(1556),
    [sym_null] = ACTIONS(1556),
    [sym_inf] = ACTIONS(1556),
    [sym_nan] = ACTIONS(1556),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1554),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [280] = {
    [sym_function_definition] = STATE(610),
    [sym_if] = STATE(610),
    [sym_while] = STATE(610),
    [sym_repeat] = STATE(610),
    [sym_for] = STATE(610),
    [sym_switch] = STATE(610),
    [sym_call] = STATE(610),
    [sym__assignment] = STATE(610),
    [sym_left_assignment] = STATE(610),
    [sym_left_assignment2] = STATE(610),
    [sym_equals_assignment] = STATE(610),
    [sym_super_assignment] = STATE(610),
    [sym_right_assignment] = STATE(610),
    [sym_brace_list] = STATE(610),
    [sym_paren_list] = STATE(610),
    [sym_subset] = STATE(610),
    [sym_subset2] = STATE(610),
    [sym_dollar] = STATE(610),
    [sym_slot] = STATE(610),
    [sym_namespace_get] = STATE(610),
    [sym_namespace_get_internal] = STATE(610),
    [sym_unary] = STATE(610),
    [sym_binary] = STATE(610),
    [sym_na] = STATE(610),
    [sym__expression] = STATE(610),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(610),
    [sym_string] = STATE(610),
    [anon_sym_SEMI] = ACTIONS(1558),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1560),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1560),
    [sym_next] = ACTIONS(1560),
    [sym_true] = ACTIONS(1560),
    [sym_false] = ACTIONS(1560),
    [sym_null] = ACTIONS(1560),
    [sym_inf] = ACTIONS(1560),
    [sym_nan] = ACTIONS(1560),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1558),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [281] = {
    [sym_function_definition] = STATE(615),
    [sym_if] = STATE(615),
    [sym_while] = STATE(615),
    [sym_repeat] = STATE(615),
    [sym_for] = STATE(615),
    [sym_switch] = STATE(615),
    [sym_call] = STATE(615),
    [sym__assignment] = STATE(615),
    [sym_left_assignment] = STATE(615),
    [sym_left_assignment2] = STATE(615),
    [sym_equals_assignment] = STATE(615),
    [sym_super_assignment] = STATE(615),
    [sym_right_assignment] = STATE(615),
    [sym_brace_list] = STATE(615),
    [sym_paren_list] = STATE(615),
    [sym_subset] = STATE(615),
    [sym_subset2] = STATE(615),
    [sym_dollar] = STATE(615),
    [sym_slot] = STATE(615),
    [sym_namespace_get] = STATE(615),
    [sym_namespace_get_internal] = STATE(615),
    [sym_unary] = STATE(615),
    [sym_binary] = STATE(615),
    [sym_na] = STATE(615),
    [sym__expression] = STATE(615),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(615),
    [sym_string] = STATE(615),
    [anon_sym_SEMI] = ACTIONS(1562),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1564),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1564),
    [sym_next] = ACTIONS(1564),
    [sym_true] = ACTIONS(1564),
    [sym_false] = ACTIONS(1564),
    [sym_null] = ACTIONS(1564),
    [sym_inf] = ACTIONS(1564),
    [sym_nan] = ACTIONS(1564),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1562),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [282] = {
    [sym_function_definition] = STATE(365),
    [sym_if] = STATE(365),
    [sym_while] = STATE(365),
    [sym_repeat] = STATE(365),
    [sym_for] = STATE(365),
    [sym_switch] = STATE(365),
    [sym_call] = STATE(365),
    [sym__assignment] = STATE(365),
    [sym_left_assignment] = STATE(365),
    [sym_left_assignment2] = STATE(365),
    [sym_equals_assignment] = STATE(365),
    [sym_super_assignment] = STATE(365),
    [sym_right_assignment] = STATE(365),
    [sym_brace_list] = STATE(365),
    [sym_paren_list] = STATE(365),
    [sym_subset] = STATE(365),
    [sym_subset2] = STATE(365),
    [sym_dollar] = STATE(365),
    [sym_slot] = STATE(365),
    [sym_namespace_get] = STATE(365),
    [sym_namespace_get_internal] = STATE(365),
    [sym_unary] = STATE(365),
    [sym_binary] = STATE(365),
    [sym_na] = STATE(365),
    [sym__expression] = STATE(365),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(365),
    [sym_string] = STATE(365),
    [anon_sym_SEMI] = ACTIONS(1566),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1568),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1568),
    [sym_next] = ACTIONS(1568),
    [sym_true] = ACTIONS(1568),
    [sym_false] = ACTIONS(1568),
    [sym_null] = ACTIONS(1568),
    [sym_inf] = ACTIONS(1568),
    [sym_nan] = ACTIONS(1568),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1566),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [283] = {
    [sym_function_definition] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [anon_sym_SEMI] = ACTIONS(1570),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1572),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1572),
    [sym_next] = ACTIONS(1572),
    [sym_true] = ACTIONS(1572),
    [sym_false] = ACTIONS(1572),
    [sym_null] = ACTIONS(1572),
    [sym_inf] = ACTIONS(1572),
    [sym_nan] = ACTIONS(1572),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1570),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [284] = {
    [sym_function_definition] = STATE(366),
    [sym_if] = STATE(366),
    [sym_while] = STATE(366),
    [sym_repeat] = STATE(366),
    [sym_for] = STATE(366),
    [sym_switch] = STATE(366),
    [sym_call] = STATE(366),
    [sym__assignment] = STATE(366),
    [sym_left_assignment] = STATE(366),
    [sym_left_assignment2] = STATE(366),
    [sym_equals_assignment] = STATE(366),
    [sym_super_assignment] = STATE(366),
    [sym_right_assignment] = STATE(366),
    [sym_brace_list] = STATE(366),
    [sym_paren_list] = STATE(366),
    [sym_subset] = STATE(366),
    [sym_subset2] = STATE(366),
    [sym_dollar] = STATE(366),
    [sym_slot] = STATE(366),
    [sym_namespace_get] = STATE(366),
    [sym_namespace_get_internal] = STATE(366),
    [sym_unary] = STATE(366),
    [sym_binary] = STATE(366),
    [sym_na] = STATE(366),
    [sym__expression] = STATE(366),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(366),
    [sym_string] = STATE(366),
    [anon_sym_SEMI] = ACTIONS(1574),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1576),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1576),
    [sym_next] = ACTIONS(1576),
    [sym_true] = ACTIONS(1576),
    [sym_false] = ACTIONS(1576),
    [sym_null] = ACTIONS(1576),
    [sym_inf] = ACTIONS(1576),
    [sym_nan] = ACTIONS(1576),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1574),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [285] = {
    [sym_function_definition] = STATE(368),
    [sym_if] = STATE(368),
    [sym_while] = STATE(368),
    [sym_repeat] = STATE(368),
    [sym_for] = STATE(368),
    [sym_switch] = STATE(368),
    [sym_call] = STATE(368),
    [sym__assignment] = STATE(368),
    [sym_left_assignment] = STATE(368),
    [sym_left_assignment2] = STATE(368),
    [sym_equals_assignment] = STATE(368),
    [sym_super_assignment] = STATE(368),
    [sym_right_assignment] = STATE(368),
    [sym_brace_list] = STATE(368),
    [sym_paren_list] = STATE(368),
    [sym_subset] = STATE(368),
    [sym_subset2] = STATE(368),
    [sym_dollar] = STATE(368),
    [sym_slot] = STATE(368),
    [sym_namespace_get] = STATE(368),
    [sym_namespace_get_internal] = STATE(368),
    [sym_unary] = STATE(368),
    [sym_binary] = STATE(368),
    [sym_na] = STATE(368),
    [sym__expression] = STATE(368),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(368),
    [sym_string] = STATE(368),
    [anon_sym_SEMI] = ACTIONS(1578),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1580),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1580),
    [sym_next] = ACTIONS(1580),
    [sym_true] = ACTIONS(1580),
    [sym_false] = ACTIONS(1580),
    [sym_null] = ACTIONS(1580),
    [sym_inf] = ACTIONS(1580),
    [sym_nan] = ACTIONS(1580),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1578),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [286] = {
    [sym_function_definition] = STATE(369),
    [sym_if] = STATE(369),
    [sym_while] = STATE(369),
    [sym_repeat] = STATE(369),
    [sym_for] = STATE(369),
    [sym_switch] = STATE(369),
    [sym_call] = STATE(369),
    [sym__assignment] = STATE(369),
    [sym_left_assignment] = STATE(369),
    [sym_left_assignment2] = STATE(369),
    [sym_equals_assignment] = STATE(369),
    [sym_super_assignment] = STATE(369),
    [sym_right_assignment] = STATE(369),
    [sym_brace_list] = STATE(369),
    [sym_paren_list] = STATE(369),
    [sym_subset] = STATE(369),
    [sym_subset2] = STATE(369),
    [sym_dollar] = STATE(369),
    [sym_slot] = STATE(369),
    [sym_namespace_get] = STATE(369),
    [sym_namespace_get_internal] = STATE(369),
    [sym_unary] = STATE(369),
    [sym_binary] = STATE(369),
    [sym_na] = STATE(369),
    [sym__expression] = STATE(369),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(369),
    [sym_string] = STATE(369),
    [anon_sym_SEMI] = ACTIONS(1582),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1584),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1584),
    [sym_next] = ACTIONS(1584),
    [sym_true] = ACTIONS(1584),
    [sym_false] = ACTIONS(1584),
    [sym_null] = ACTIONS(1584),
    [sym_inf] = ACTIONS(1584),
    [sym_nan] = ACTIONS(1584),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1582),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [287] = {
    [sym_function_definition] = STATE(750),
    [sym_if] = STATE(750),
    [sym_while] = STATE(750),
    [sym_repeat] = STATE(750),
    [sym_for] = STATE(750),
    [sym_switch] = STATE(750),
    [sym_call] = STATE(750),
    [sym__assignment] = STATE(750),
    [sym_left_assignment] = STATE(750),
    [sym_left_assignment2] = STATE(750),
    [sym_equals_assignment] = STATE(750),
    [sym_super_assignment] = STATE(750),
    [sym_right_assignment] = STATE(750),
    [sym_brace_list] = STATE(750),
    [sym_paren_list] = STATE(750),
    [sym_subset] = STATE(750),
    [sym_subset2] = STATE(750),
    [sym_dollar] = STATE(750),
    [sym_slot] = STATE(750),
    [sym_namespace_get] = STATE(750),
    [sym_namespace_get_internal] = STATE(750),
    [sym_unary] = STATE(750),
    [sym_binary] = STATE(750),
    [sym_na] = STATE(750),
    [sym__expression] = STATE(750),
    [sym_identifier] = STATE(747),
    [sym_complex] = STATE(750),
    [sym_string] = STATE(750),
    [anon_sym_SEMI] = ACTIONS(1586),
    [anon_sym_function] = ACTIONS(1288),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1294),
    [anon_sym_repeat] = ACTIONS(1296),
    [anon_sym_for] = ACTIONS(1298),
    [anon_sym_switch] = ACTIONS(1300),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [sym_dots] = ACTIONS(1588),
    [anon_sym_DASH] = ACTIONS(1306),
    [anon_sym_PLUS] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1308),
    [anon_sym_TILDE] = ACTIONS(1310),
    [sym_break] = ACTIONS(1588),
    [sym_next] = ACTIONS(1588),
    [sym_true] = ACTIONS(1588),
    [sym_false] = ACTIONS(1588),
    [sym_null] = ACTIONS(1588),
    [sym_inf] = ACTIONS(1588),
    [sym_nan] = ACTIONS(1588),
    [anon_sym_NA] = ACTIONS(1312),
    [anon_sym_NA_character_] = ACTIONS(1312),
    [anon_sym_NA_complex_] = ACTIONS(1312),
    [anon_sym_NA_integer_] = ACTIONS(1312),
    [anon_sym_NA_real_] = ACTIONS(1312),
    [aux_sym_identifier_token1] = ACTIONS(1314),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [sym_integer] = ACTIONS(1586),
    [sym_float] = ACTIONS(1318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1322),
  },
  [288] = {
    [sym_function_definition] = STATE(370),
    [sym_if] = STATE(370),
    [sym_while] = STATE(370),
    [sym_repeat] = STATE(370),
    [sym_for] = STATE(370),
    [sym_switch] = STATE(370),
    [sym_call] = STATE(370),
    [sym__assignment] = STATE(370),
    [sym_left_assignment] = STATE(370),
    [sym_left_assignment2] = STATE(370),
    [sym_equals_assignment] = STATE(370),
    [sym_super_assignment] = STATE(370),
    [sym_right_assignment] = STATE(370),
    [sym_brace_list] = STATE(370),
    [sym_paren_list] = STATE(370),
    [sym_subset] = STATE(370),
    [sym_subset2] = STATE(370),
    [sym_dollar] = STATE(370),
    [sym_slot] = STATE(370),
    [sym_namespace_get] = STATE(370),
    [sym_namespace_get_internal] = STATE(370),
    [sym_unary] = STATE(370),
    [sym_binary] = STATE(370),
    [sym_na] = STATE(370),
    [sym__expression] = STATE(370),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(370),
    [sym_string] = STATE(370),
    [anon_sym_SEMI] = ACTIONS(1590),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1592),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1592),
    [sym_next] = ACTIONS(1592),
    [sym_true] = ACTIONS(1592),
    [sym_false] = ACTIONS(1592),
    [sym_null] = ACTIONS(1592),
    [sym_inf] = ACTIONS(1592),
    [sym_nan] = ACTIONS(1592),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1590),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [289] = {
    [sym_function_definition] = STATE(371),
    [sym_if] = STATE(371),
    [sym_while] = STATE(371),
    [sym_repeat] = STATE(371),
    [sym_for] = STATE(371),
    [sym_switch] = STATE(371),
    [sym_call] = STATE(371),
    [sym__assignment] = STATE(371),
    [sym_left_assignment] = STATE(371),
    [sym_left_assignment2] = STATE(371),
    [sym_equals_assignment] = STATE(371),
    [sym_super_assignment] = STATE(371),
    [sym_right_assignment] = STATE(371),
    [sym_brace_list] = STATE(371),
    [sym_paren_list] = STATE(371),
    [sym_subset] = STATE(371),
    [sym_subset2] = STATE(371),
    [sym_dollar] = STATE(371),
    [sym_slot] = STATE(371),
    [sym_namespace_get] = STATE(371),
    [sym_namespace_get_internal] = STATE(371),
    [sym_unary] = STATE(371),
    [sym_binary] = STATE(371),
    [sym_na] = STATE(371),
    [sym__expression] = STATE(371),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(371),
    [sym_string] = STATE(371),
    [anon_sym_SEMI] = ACTIONS(1594),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1596),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1596),
    [sym_next] = ACTIONS(1596),
    [sym_true] = ACTIONS(1596),
    [sym_false] = ACTIONS(1596),
    [sym_null] = ACTIONS(1596),
    [sym_inf] = ACTIONS(1596),
    [sym_nan] = ACTIONS(1596),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1594),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [290] = {
    [sym_function_definition] = STATE(372),
    [sym_if] = STATE(372),
    [sym_while] = STATE(372),
    [sym_repeat] = STATE(372),
    [sym_for] = STATE(372),
    [sym_switch] = STATE(372),
    [sym_call] = STATE(372),
    [sym__assignment] = STATE(372),
    [sym_left_assignment] = STATE(372),
    [sym_left_assignment2] = STATE(372),
    [sym_equals_assignment] = STATE(372),
    [sym_super_assignment] = STATE(372),
    [sym_right_assignment] = STATE(372),
    [sym_brace_list] = STATE(372),
    [sym_paren_list] = STATE(372),
    [sym_subset] = STATE(372),
    [sym_subset2] = STATE(372),
    [sym_dollar] = STATE(372),
    [sym_slot] = STATE(372),
    [sym_namespace_get] = STATE(372),
    [sym_namespace_get_internal] = STATE(372),
    [sym_unary] = STATE(372),
    [sym_binary] = STATE(372),
    [sym_na] = STATE(372),
    [sym__expression] = STATE(372),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(372),
    [sym_string] = STATE(372),
    [anon_sym_SEMI] = ACTIONS(1598),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1600),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1600),
    [sym_next] = ACTIONS(1600),
    [sym_true] = ACTIONS(1600),
    [sym_false] = ACTIONS(1600),
    [sym_null] = ACTIONS(1600),
    [sym_inf] = ACTIONS(1600),
    [sym_nan] = ACTIONS(1600),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1598),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [291] = {
    [sym_function_definition] = STATE(375),
    [sym_if] = STATE(375),
    [sym_while] = STATE(375),
    [sym_repeat] = STATE(375),
    [sym_for] = STATE(375),
    [sym_switch] = STATE(375),
    [sym_call] = STATE(375),
    [sym__assignment] = STATE(375),
    [sym_left_assignment] = STATE(375),
    [sym_left_assignment2] = STATE(375),
    [sym_equals_assignment] = STATE(375),
    [sym_super_assignment] = STATE(375),
    [sym_right_assignment] = STATE(375),
    [sym_brace_list] = STATE(375),
    [sym_paren_list] = STATE(375),
    [sym_subset] = STATE(375),
    [sym_subset2] = STATE(375),
    [sym_dollar] = STATE(375),
    [sym_slot] = STATE(375),
    [sym_namespace_get] = STATE(375),
    [sym_namespace_get_internal] = STATE(375),
    [sym_unary] = STATE(375),
    [sym_binary] = STATE(375),
    [sym_na] = STATE(375),
    [sym__expression] = STATE(375),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(375),
    [sym_string] = STATE(375),
    [anon_sym_SEMI] = ACTIONS(1602),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1604),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1604),
    [sym_next] = ACTIONS(1604),
    [sym_true] = ACTIONS(1604),
    [sym_false] = ACTIONS(1604),
    [sym_null] = ACTIONS(1604),
    [sym_inf] = ACTIONS(1604),
    [sym_nan] = ACTIONS(1604),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1602),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [292] = {
    [sym_function_definition] = STATE(376),
    [sym_if] = STATE(376),
    [sym_while] = STATE(376),
    [sym_repeat] = STATE(376),
    [sym_for] = STATE(376),
    [sym_switch] = STATE(376),
    [sym_call] = STATE(376),
    [sym__assignment] = STATE(376),
    [sym_left_assignment] = STATE(376),
    [sym_left_assignment2] = STATE(376),
    [sym_equals_assignment] = STATE(376),
    [sym_super_assignment] = STATE(376),
    [sym_right_assignment] = STATE(376),
    [sym_brace_list] = STATE(376),
    [sym_paren_list] = STATE(376),
    [sym_subset] = STATE(376),
    [sym_subset2] = STATE(376),
    [sym_dollar] = STATE(376),
    [sym_slot] = STATE(376),
    [sym_namespace_get] = STATE(376),
    [sym_namespace_get_internal] = STATE(376),
    [sym_unary] = STATE(376),
    [sym_binary] = STATE(376),
    [sym_na] = STATE(376),
    [sym__expression] = STATE(376),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(376),
    [sym_string] = STATE(376),
    [anon_sym_SEMI] = ACTIONS(1606),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1608),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1608),
    [sym_next] = ACTIONS(1608),
    [sym_true] = ACTIONS(1608),
    [sym_false] = ACTIONS(1608),
    [sym_null] = ACTIONS(1608),
    [sym_inf] = ACTIONS(1608),
    [sym_nan] = ACTIONS(1608),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1606),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [293] = {
    [sym_function_definition] = STATE(616),
    [sym_if] = STATE(616),
    [sym_while] = STATE(616),
    [sym_repeat] = STATE(616),
    [sym_for] = STATE(616),
    [sym_switch] = STATE(616),
    [sym_call] = STATE(616),
    [sym__assignment] = STATE(616),
    [sym_left_assignment] = STATE(616),
    [sym_left_assignment2] = STATE(616),
    [sym_equals_assignment] = STATE(616),
    [sym_super_assignment] = STATE(616),
    [sym_right_assignment] = STATE(616),
    [sym_brace_list] = STATE(616),
    [sym_paren_list] = STATE(616),
    [sym_subset] = STATE(616),
    [sym_subset2] = STATE(616),
    [sym_dollar] = STATE(616),
    [sym_slot] = STATE(616),
    [sym_namespace_get] = STATE(616),
    [sym_namespace_get_internal] = STATE(616),
    [sym_unary] = STATE(616),
    [sym_binary] = STATE(616),
    [sym_na] = STATE(616),
    [sym__expression] = STATE(616),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(616),
    [sym_string] = STATE(616),
    [anon_sym_SEMI] = ACTIONS(1610),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1612),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1612),
    [sym_next] = ACTIONS(1612),
    [sym_true] = ACTIONS(1612),
    [sym_false] = ACTIONS(1612),
    [sym_null] = ACTIONS(1612),
    [sym_inf] = ACTIONS(1612),
    [sym_nan] = ACTIONS(1612),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1610),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [294] = {
    [sym_function_definition] = STATE(620),
    [sym_if] = STATE(620),
    [sym_while] = STATE(620),
    [sym_repeat] = STATE(620),
    [sym_for] = STATE(620),
    [sym_switch] = STATE(620),
    [sym_call] = STATE(620),
    [sym__assignment] = STATE(620),
    [sym_left_assignment] = STATE(620),
    [sym_left_assignment2] = STATE(620),
    [sym_equals_assignment] = STATE(620),
    [sym_super_assignment] = STATE(620),
    [sym_right_assignment] = STATE(620),
    [sym_brace_list] = STATE(620),
    [sym_paren_list] = STATE(620),
    [sym_subset] = STATE(620),
    [sym_subset2] = STATE(620),
    [sym_dollar] = STATE(620),
    [sym_slot] = STATE(620),
    [sym_namespace_get] = STATE(620),
    [sym_namespace_get_internal] = STATE(620),
    [sym_unary] = STATE(620),
    [sym_binary] = STATE(620),
    [sym_na] = STATE(620),
    [sym__expression] = STATE(620),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(620),
    [sym_string] = STATE(620),
    [anon_sym_SEMI] = ACTIONS(1614),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1616),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1616),
    [sym_next] = ACTIONS(1616),
    [sym_true] = ACTIONS(1616),
    [sym_false] = ACTIONS(1616),
    [sym_null] = ACTIONS(1616),
    [sym_inf] = ACTIONS(1616),
    [sym_nan] = ACTIONS(1616),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1614),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [295] = {
    [sym_function_definition] = STATE(383),
    [sym_if] = STATE(383),
    [sym_while] = STATE(383),
    [sym_repeat] = STATE(383),
    [sym_for] = STATE(383),
    [sym_switch] = STATE(383),
    [sym_call] = STATE(383),
    [sym__assignment] = STATE(383),
    [sym_left_assignment] = STATE(383),
    [sym_left_assignment2] = STATE(383),
    [sym_equals_assignment] = STATE(383),
    [sym_super_assignment] = STATE(383),
    [sym_right_assignment] = STATE(383),
    [sym_brace_list] = STATE(383),
    [sym_paren_list] = STATE(383),
    [sym_subset] = STATE(383),
    [sym_subset2] = STATE(383),
    [sym_dollar] = STATE(383),
    [sym_slot] = STATE(383),
    [sym_namespace_get] = STATE(383),
    [sym_namespace_get_internal] = STATE(383),
    [sym_unary] = STATE(383),
    [sym_binary] = STATE(383),
    [sym_na] = STATE(383),
    [sym__expression] = STATE(383),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(383),
    [sym_string] = STATE(383),
    [anon_sym_SEMI] = ACTIONS(1618),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1620),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1620),
    [sym_next] = ACTIONS(1620),
    [sym_true] = ACTIONS(1620),
    [sym_false] = ACTIONS(1620),
    [sym_null] = ACTIONS(1620),
    [sym_inf] = ACTIONS(1620),
    [sym_nan] = ACTIONS(1620),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1618),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [296] = {
    [sym_function_definition] = STATE(385),
    [sym_if] = STATE(385),
    [sym_while] = STATE(385),
    [sym_repeat] = STATE(385),
    [sym_for] = STATE(385),
    [sym_switch] = STATE(385),
    [sym_call] = STATE(385),
    [sym__assignment] = STATE(385),
    [sym_left_assignment] = STATE(385),
    [sym_left_assignment2] = STATE(385),
    [sym_equals_assignment] = STATE(385),
    [sym_super_assignment] = STATE(385),
    [sym_right_assignment] = STATE(385),
    [sym_brace_list] = STATE(385),
    [sym_paren_list] = STATE(385),
    [sym_subset] = STATE(385),
    [sym_subset2] = STATE(385),
    [sym_dollar] = STATE(385),
    [sym_slot] = STATE(385),
    [sym_namespace_get] = STATE(385),
    [sym_namespace_get_internal] = STATE(385),
    [sym_unary] = STATE(385),
    [sym_binary] = STATE(385),
    [sym_na] = STATE(385),
    [sym__expression] = STATE(385),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(385),
    [sym_string] = STATE(385),
    [anon_sym_SEMI] = ACTIONS(1622),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1624),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1624),
    [sym_next] = ACTIONS(1624),
    [sym_true] = ACTIONS(1624),
    [sym_false] = ACTIONS(1624),
    [sym_null] = ACTIONS(1624),
    [sym_inf] = ACTIONS(1624),
    [sym_nan] = ACTIONS(1624),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1622),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [297] = {
    [sym_function_definition] = STATE(390),
    [sym_if] = STATE(390),
    [sym_while] = STATE(390),
    [sym_repeat] = STATE(390),
    [sym_for] = STATE(390),
    [sym_switch] = STATE(390),
    [sym_call] = STATE(390),
    [sym__assignment] = STATE(390),
    [sym_left_assignment] = STATE(390),
    [sym_left_assignment2] = STATE(390),
    [sym_equals_assignment] = STATE(390),
    [sym_super_assignment] = STATE(390),
    [sym_right_assignment] = STATE(390),
    [sym_brace_list] = STATE(390),
    [sym_paren_list] = STATE(390),
    [sym_subset] = STATE(390),
    [sym_subset2] = STATE(390),
    [sym_dollar] = STATE(390),
    [sym_slot] = STATE(390),
    [sym_namespace_get] = STATE(390),
    [sym_namespace_get_internal] = STATE(390),
    [sym_unary] = STATE(390),
    [sym_binary] = STATE(390),
    [sym_na] = STATE(390),
    [sym__expression] = STATE(390),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(390),
    [sym_string] = STATE(390),
    [anon_sym_SEMI] = ACTIONS(1626),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1628),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1628),
    [sym_next] = ACTIONS(1628),
    [sym_true] = ACTIONS(1628),
    [sym_false] = ACTIONS(1628),
    [sym_null] = ACTIONS(1628),
    [sym_inf] = ACTIONS(1628),
    [sym_nan] = ACTIONS(1628),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1626),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [298] = {
    [sym_special] = STATE(339),
    [anon_sym_LF] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(1630),
    [anon_sym_else] = ACTIONS(1632),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(1634),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_LT_DASH] = ACTIONS(1636),
    [anon_sym_COLON_EQ] = ACTIONS(1638),
    [anon_sym_LT_LT_DASH] = ACTIONS(1640),
    [anon_sym_DASH_GT] = ACTIONS(1642),
    [anon_sym_LBRACK] = ACTIONS(1644),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1646),
    [anon_sym_DOLLAR] = ACTIONS(1648),
    [anon_sym_AT] = ACTIONS(1650),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(1652),
    [anon_sym_PLUS] = ACTIONS(1652),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(1654),
    [anon_sym_STAR] = ACTIONS(1656),
    [anon_sym_SLASH] = ACTIONS(1656),
    [anon_sym_CARET] = ACTIONS(1658),
    [anon_sym_LT] = ACTIONS(1660),
    [anon_sym_GT] = ACTIONS(1660),
    [anon_sym_LT_EQ] = ACTIONS(1660),
    [anon_sym_GT_EQ] = ACTIONS(1660),
    [anon_sym_EQ_EQ] = ACTIONS(1660),
    [anon_sym_BANG_EQ] = ACTIONS(1660),
    [anon_sym_PIPE_PIPE] = ACTIONS(1662),
    [anon_sym_PIPE] = ACTIONS(1662),
    [anon_sym_AMP_AMP] = ACTIONS(1664),
    [anon_sym_AMP] = ACTIONS(1664),
    [anon_sym_COLON] = ACTIONS(1666),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [sym_integer] = ACTIONS(738),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [299] = {
    [sym_function_definition] = STATE(391),
    [sym_if] = STATE(391),
    [sym_while] = STATE(391),
    [sym_repeat] = STATE(391),
    [sym_for] = STATE(391),
    [sym_switch] = STATE(391),
    [sym_call] = STATE(391),
    [sym__assignment] = STATE(391),
    [sym_left_assignment] = STATE(391),
    [sym_left_assignment2] = STATE(391),
    [sym_equals_assignment] = STATE(391),
    [sym_super_assignment] = STATE(391),
    [sym_right_assignment] = STATE(391),
    [sym_brace_list] = STATE(391),
    [sym_paren_list] = STATE(391),
    [sym_subset] = STATE(391),
    [sym_subset2] = STATE(391),
    [sym_dollar] = STATE(391),
    [sym_slot] = STATE(391),
    [sym_namespace_get] = STATE(391),
    [sym_namespace_get_internal] = STATE(391),
    [sym_unary] = STATE(391),
    [sym_binary] = STATE(391),
    [sym_na] = STATE(391),
    [sym__expression] = STATE(391),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(391),
    [sym_string] = STATE(391),
    [anon_sym_SEMI] = ACTIONS(1668),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1670),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1670),
    [sym_next] = ACTIONS(1670),
    [sym_true] = ACTIONS(1670),
    [sym_false] = ACTIONS(1670),
    [sym_null] = ACTIONS(1670),
    [sym_inf] = ACTIONS(1670),
    [sym_nan] = ACTIONS(1670),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1668),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [300] = {
    [sym_function_definition] = STATE(674),
    [sym_if] = STATE(674),
    [sym_while] = STATE(674),
    [sym_repeat] = STATE(674),
    [sym_for] = STATE(674),
    [sym_switch] = STATE(674),
    [sym_call] = STATE(674),
    [sym__assignment] = STATE(674),
    [sym_left_assignment] = STATE(674),
    [sym_left_assignment2] = STATE(674),
    [sym_equals_assignment] = STATE(674),
    [sym_super_assignment] = STATE(674),
    [sym_right_assignment] = STATE(674),
    [sym_brace_list] = STATE(674),
    [sym_paren_list] = STATE(674),
    [sym_subset] = STATE(674),
    [sym_subset2] = STATE(674),
    [sym_dollar] = STATE(674),
    [sym_slot] = STATE(674),
    [sym_namespace_get] = STATE(674),
    [sym_namespace_get_internal] = STATE(674),
    [sym_unary] = STATE(674),
    [sym_binary] = STATE(674),
    [sym_na] = STATE(674),
    [sym__expression] = STATE(674),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(674),
    [sym_string] = STATE(674),
    [anon_sym_SEMI] = ACTIONS(1672),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1674),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1674),
    [sym_next] = ACTIONS(1674),
    [sym_true] = ACTIONS(1674),
    [sym_false] = ACTIONS(1674),
    [sym_null] = ACTIONS(1674),
    [sym_inf] = ACTIONS(1674),
    [sym_nan] = ACTIONS(1674),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1672),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [301] = {
    [sym_function_definition] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_repeat] = STATE(621),
    [sym_for] = STATE(621),
    [sym_switch] = STATE(621),
    [sym_call] = STATE(621),
    [sym__assignment] = STATE(621),
    [sym_left_assignment] = STATE(621),
    [sym_left_assignment2] = STATE(621),
    [sym_equals_assignment] = STATE(621),
    [sym_super_assignment] = STATE(621),
    [sym_right_assignment] = STATE(621),
    [sym_brace_list] = STATE(621),
    [sym_paren_list] = STATE(621),
    [sym_subset] = STATE(621),
    [sym_subset2] = STATE(621),
    [sym_dollar] = STATE(621),
    [sym_slot] = STATE(621),
    [sym_namespace_get] = STATE(621),
    [sym_namespace_get_internal] = STATE(621),
    [sym_unary] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_na] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_identifier] = STATE(239),
    [sym_complex] = STATE(621),
    [sym_string] = STATE(621),
    [anon_sym_SEMI] = ACTIONS(1676),
    [anon_sym_function] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_repeat] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(406),
    [sym_dots] = ACTIONS(1678),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_break] = ACTIONS(1678),
    [sym_next] = ACTIONS(1678),
    [sym_true] = ACTIONS(1678),
    [sym_false] = ACTIONS(1678),
    [sym_null] = ACTIONS(1678),
    [sym_inf] = ACTIONS(1678),
    [sym_nan] = ACTIONS(1678),
    [anon_sym_NA] = ACTIONS(418),
    [anon_sym_NA_character_] = ACTIONS(418),
    [anon_sym_NA_complex_] = ACTIONS(418),
    [anon_sym_NA_integer_] = ACTIONS(418),
    [anon_sym_NA_real_] = ACTIONS(418),
    [aux_sym_identifier_token1] = ACTIONS(420),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_integer] = ACTIONS(1676),
    [sym_float] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(426),
    [anon_sym_SQUOTE] = ACTIONS(428),
  },
  [302] = {
    [sym_function_definition] = STATE(392),
    [sym_if] = STATE(392),
    [sym_while] = STATE(392),
    [sym_repeat] = STATE(392),
    [sym_for] = STATE(392),
    [sym_switch] = STATE(392),
    [sym_call] = STATE(392),
    [sym__assignment] = STATE(392),
    [sym_left_assignment] = STATE(392),
    [sym_left_assignment2] = STATE(392),
    [sym_equals_assignment] = STATE(392),
    [sym_super_assignment] = STATE(392),
    [sym_right_assignment] = STATE(392),
    [sym_brace_list] = STATE(392),
    [sym_paren_list] = STATE(392),
    [sym_subset] = STATE(392),
    [sym_subset2] = STATE(392),
    [sym_dollar] = STATE(392),
    [sym_slot] = STATE(392),
    [sym_namespace_get] = STATE(392),
    [sym_namespace_get_internal] = STATE(392),
    [sym_unary] = STATE(392),
    [sym_binary] = STATE(392),
    [sym_na] = STATE(392),
    [sym__expression] = STATE(392),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(392),
    [sym_string] = STATE(392),
    [anon_sym_SEMI] = ACTIONS(1680),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1682),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1682),
    [sym_next] = ACTIONS(1682),
    [sym_true] = ACTIONS(1682),
    [sym_false] = ACTIONS(1682),
    [sym_null] = ACTIONS(1682),
    [sym_inf] = ACTIONS(1682),
    [sym_nan] = ACTIONS(1682),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1680),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [303] = {
    [sym_function_definition] = STATE(393),
    [sym_if] = STATE(393),
    [sym_while] = STATE(393),
    [sym_repeat] = STATE(393),
    [sym_for] = STATE(393),
    [sym_switch] = STATE(393),
    [sym_call] = STATE(393),
    [sym__assignment] = STATE(393),
    [sym_left_assignment] = STATE(393),
    [sym_left_assignment2] = STATE(393),
    [sym_equals_assignment] = STATE(393),
    [sym_super_assignment] = STATE(393),
    [sym_right_assignment] = STATE(393),
    [sym_brace_list] = STATE(393),
    [sym_paren_list] = STATE(393),
    [sym_subset] = STATE(393),
    [sym_subset2] = STATE(393),
    [sym_dollar] = STATE(393),
    [sym_slot] = STATE(393),
    [sym_namespace_get] = STATE(393),
    [sym_namespace_get_internal] = STATE(393),
    [sym_unary] = STATE(393),
    [sym_binary] = STATE(393),
    [sym_na] = STATE(393),
    [sym__expression] = STATE(393),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(393),
    [sym_string] = STATE(393),
    [anon_sym_SEMI] = ACTIONS(1684),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1686),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1686),
    [sym_next] = ACTIONS(1686),
    [sym_true] = ACTIONS(1686),
    [sym_false] = ACTIONS(1686),
    [sym_null] = ACTIONS(1686),
    [sym_inf] = ACTIONS(1686),
    [sym_nan] = ACTIONS(1686),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1684),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [304] = {
    [sym_function_definition] = STATE(401),
    [sym_if] = STATE(401),
    [sym_while] = STATE(401),
    [sym_repeat] = STATE(401),
    [sym_for] = STATE(401),
    [sym_switch] = STATE(401),
    [sym_call] = STATE(401),
    [sym__assignment] = STATE(401),
    [sym_left_assignment] = STATE(401),
    [sym_left_assignment2] = STATE(401),
    [sym_equals_assignment] = STATE(401),
    [sym_super_assignment] = STATE(401),
    [sym_right_assignment] = STATE(401),
    [sym_brace_list] = STATE(401),
    [sym_paren_list] = STATE(401),
    [sym_subset] = STATE(401),
    [sym_subset2] = STATE(401),
    [sym_dollar] = STATE(401),
    [sym_slot] = STATE(401),
    [sym_namespace_get] = STATE(401),
    [sym_namespace_get_internal] = STATE(401),
    [sym_unary] = STATE(401),
    [sym_binary] = STATE(401),
    [sym_na] = STATE(401),
    [sym__expression] = STATE(401),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(401),
    [sym_string] = STATE(401),
    [anon_sym_SEMI] = ACTIONS(1688),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1690),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1690),
    [sym_next] = ACTIONS(1690),
    [sym_true] = ACTIONS(1690),
    [sym_false] = ACTIONS(1690),
    [sym_null] = ACTIONS(1690),
    [sym_inf] = ACTIONS(1690),
    [sym_nan] = ACTIONS(1690),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1688),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [305] = {
    [sym_function_definition] = STATE(585),
    [sym_if] = STATE(585),
    [sym_while] = STATE(585),
    [sym_repeat] = STATE(585),
    [sym_for] = STATE(585),
    [sym_switch] = STATE(585),
    [sym_call] = STATE(585),
    [sym__assignment] = STATE(585),
    [sym_left_assignment] = STATE(585),
    [sym_left_assignment2] = STATE(585),
    [sym_equals_assignment] = STATE(585),
    [sym_super_assignment] = STATE(585),
    [sym_right_assignment] = STATE(585),
    [sym_brace_list] = STATE(585),
    [sym_paren_list] = STATE(585),
    [sym_subset] = STATE(585),
    [sym_subset2] = STATE(585),
    [sym_dollar] = STATE(585),
    [sym_slot] = STATE(585),
    [sym_namespace_get] = STATE(585),
    [sym_namespace_get_internal] = STATE(585),
    [sym_unary] = STATE(585),
    [sym_binary] = STATE(585),
    [sym_na] = STATE(585),
    [sym__expression] = STATE(585),
    [sym_identifier] = STATE(506),
    [sym_complex] = STATE(585),
    [sym_string] = STATE(585),
    [anon_sym_SEMI] = ACTIONS(1692),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1694),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(1694),
    [sym_next] = ACTIONS(1694),
    [sym_true] = ACTIONS(1694),
    [sym_false] = ACTIONS(1694),
    [sym_null] = ACTIONS(1694),
    [sym_inf] = ACTIONS(1694),
    [sym_nan] = ACTIONS(1694),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1692),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [306] = {
    [sym_function_definition] = STATE(587),
    [sym_if] = STATE(587),
    [sym_while] = STATE(587),
    [sym_repeat] = STATE(587),
    [sym_for] = STATE(587),
    [sym_switch] = STATE(587),
    [sym_call] = STATE(587),
    [sym__assignment] = STATE(587),
    [sym_left_assignment] = STATE(587),
    [sym_left_assignment2] = STATE(587),
    [sym_equals_assignment] = STATE(587),
    [sym_super_assignment] = STATE(587),
    [sym_right_assignment] = STATE(587),
    [sym_brace_list] = STATE(587),
    [sym_paren_list] = STATE(587),
    [sym_subset] = STATE(587),
    [sym_subset2] = STATE(587),
    [sym_dollar] = STATE(587),
    [sym_slot] = STATE(587),
    [sym_namespace_get] = STATE(587),
    [sym_namespace_get_internal] = STATE(587),
    [sym_unary] = STATE(587),
    [sym_binary] = STATE(587),
    [sym_na] = STATE(587),
    [sym__expression] = STATE(587),
    [sym_identifier] = STATE(506),
    [sym_complex] = STATE(587),
    [sym_string] = STATE(587),
    [anon_sym_SEMI] = ACTIONS(1696),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1698),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(1698),
    [sym_next] = ACTIONS(1698),
    [sym_true] = ACTIONS(1698),
    [sym_false] = ACTIONS(1698),
    [sym_null] = ACTIONS(1698),
    [sym_inf] = ACTIONS(1698),
    [sym_nan] = ACTIONS(1698),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1696),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [307] = {
    [sym_function_definition] = STATE(588),
    [sym_if] = STATE(588),
    [sym_while] = STATE(588),
    [sym_repeat] = STATE(588),
    [sym_for] = STATE(588),
    [sym_switch] = STATE(588),
    [sym_call] = STATE(588),
    [sym__assignment] = STATE(588),
    [sym_left_assignment] = STATE(588),
    [sym_left_assignment2] = STATE(588),
    [sym_equals_assignment] = STATE(588),
    [sym_super_assignment] = STATE(588),
    [sym_right_assignment] = STATE(588),
    [sym_brace_list] = STATE(588),
    [sym_paren_list] = STATE(588),
    [sym_subset] = STATE(588),
    [sym_subset2] = STATE(588),
    [sym_dollar] = STATE(588),
    [sym_slot] = STATE(588),
    [sym_namespace_get] = STATE(588),
    [sym_namespace_get_internal] = STATE(588),
    [sym_unary] = STATE(588),
    [sym_binary] = STATE(588),
    [sym_na] = STATE(588),
    [sym__expression] = STATE(588),
    [sym_identifier] = STATE(506),
    [sym_complex] = STATE(588),
    [sym_string] = STATE(588),
    [anon_sym_SEMI] = ACTIONS(1700),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1702),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(1702),
    [sym_next] = ACTIONS(1702),
    [sym_true] = ACTIONS(1702),
    [sym_false] = ACTIONS(1702),
    [sym_null] = ACTIONS(1702),
    [sym_inf] = ACTIONS(1702),
    [sym_nan] = ACTIONS(1702),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1700),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [308] = {
    [sym_function_definition] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(506),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [anon_sym_SEMI] = ACTIONS(1704),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1706),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(1706),
    [sym_next] = ACTIONS(1706),
    [sym_true] = ACTIONS(1706),
    [sym_false] = ACTIONS(1706),
    [sym_null] = ACTIONS(1706),
    [sym_inf] = ACTIONS(1706),
    [sym_nan] = ACTIONS(1706),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1704),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [309] = {
    [sym_function_definition] = STATE(402),
    [sym_if] = STATE(402),
    [sym_while] = STATE(402),
    [sym_repeat] = STATE(402),
    [sym_for] = STATE(402),
    [sym_switch] = STATE(402),
    [sym_call] = STATE(402),
    [sym__assignment] = STATE(402),
    [sym_left_assignment] = STATE(402),
    [sym_left_assignment2] = STATE(402),
    [sym_equals_assignment] = STATE(402),
    [sym_super_assignment] = STATE(402),
    [sym_right_assignment] = STATE(402),
    [sym_brace_list] = STATE(402),
    [sym_paren_list] = STATE(402),
    [sym_subset] = STATE(402),
    [sym_subset2] = STATE(402),
    [sym_dollar] = STATE(402),
    [sym_slot] = STATE(402),
    [sym_namespace_get] = STATE(402),
    [sym_namespace_get_internal] = STATE(402),
    [sym_unary] = STATE(402),
    [sym_binary] = STATE(402),
    [sym_na] = STATE(402),
    [sym__expression] = STATE(402),
    [sym_identifier] = STATE(123),
    [sym_complex] = STATE(402),
    [sym_string] = STATE(402),
    [anon_sym_SEMI] = ACTIONS(1708),
    [anon_sym_function] = ACTIONS(758),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_repeat] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(772),
    [sym_dots] = ACTIONS(1710),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(780),
    [sym_break] = ACTIONS(1710),
    [sym_next] = ACTIONS(1710),
    [sym_true] = ACTIONS(1710),
    [sym_false] = ACTIONS(1710),
    [sym_null] = ACTIONS(1710),
    [sym_inf] = ACTIONS(1710),
    [sym_nan] = ACTIONS(1710),
    [anon_sym_NA] = ACTIONS(782),
    [anon_sym_NA_character_] = ACTIONS(782),
    [anon_sym_NA_complex_] = ACTIONS(782),
    [anon_sym_NA_integer_] = ACTIONS(782),
    [anon_sym_NA_real_] = ACTIONS(782),
    [aux_sym_identifier_token1] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(786),
    [sym_integer] = ACTIONS(1708),
    [sym_float] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(792),
  },
  [310] = {
    [sym_function_definition] = STATE(461),
    [sym_if] = STATE(461),
    [sym_while] = STATE(461),
    [sym_repeat] = STATE(461),
    [sym_for] = STATE(461),
    [sym_switch] = STATE(461),
    [sym_call] = STATE(461),
    [sym__assignment] = STATE(461),
    [sym_left_assignment] = STATE(461),
    [sym_left_assignment2] = STATE(461),
    [sym_equals_assignment] = STATE(461),
    [sym_super_assignment] = STATE(461),
    [sym_right_assignment] = STATE(461),
    [sym_brace_list] = STATE(461),
    [sym_paren_list] = STATE(461),
    [sym_subset] = STATE(461),
    [sym_subset2] = STATE(461),
    [sym_dollar] = STATE(461),
    [sym_slot] = STATE(461),
    [sym_namespace_get] = STATE(461),
    [sym_namespace_get_internal] = STATE(461),
    [sym_unary] = STATE(461),
    [sym_binary] = STATE(461),
    [sym_na] = STATE(461),
    [sym__expression] = STATE(461),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(461),
    [sym_string] = STATE(461),
    [anon_sym_SEMI] = ACTIONS(1712),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1714),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1714),
    [sym_next] = ACTIONS(1714),
    [sym_true] = ACTIONS(1714),
    [sym_false] = ACTIONS(1714),
    [sym_null] = ACTIONS(1714),
    [sym_inf] = ACTIONS(1714),
    [sym_nan] = ACTIONS(1714),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1712),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [311] = {
    [sym_function_definition] = STATE(460),
    [sym_if] = STATE(460),
    [sym_while] = STATE(460),
    [sym_repeat] = STATE(460),
    [sym_for] = STATE(460),
    [sym_switch] = STATE(460),
    [sym_call] = STATE(460),
    [sym__assignment] = STATE(460),
    [sym_left_assignment] = STATE(460),
    [sym_left_assignment2] = STATE(460),
    [sym_equals_assignment] = STATE(460),
    [sym_super_assignment] = STATE(460),
    [sym_right_assignment] = STATE(460),
    [sym_brace_list] = STATE(460),
    [sym_paren_list] = STATE(460),
    [sym_subset] = STATE(460),
    [sym_subset2] = STATE(460),
    [sym_dollar] = STATE(460),
    [sym_slot] = STATE(460),
    [sym_namespace_get] = STATE(460),
    [sym_namespace_get_internal] = STATE(460),
    [sym_unary] = STATE(460),
    [sym_binary] = STATE(460),
    [sym_na] = STATE(460),
    [sym__expression] = STATE(460),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(460),
    [sym_string] = STATE(460),
    [anon_sym_SEMI] = ACTIONS(1716),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1718),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1718),
    [sym_next] = ACTIONS(1718),
    [sym_true] = ACTIONS(1718),
    [sym_false] = ACTIONS(1718),
    [sym_null] = ACTIONS(1718),
    [sym_inf] = ACTIONS(1718),
    [sym_nan] = ACTIONS(1718),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1716),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [312] = {
    [sym_function_definition] = STATE(459),
    [sym_if] = STATE(459),
    [sym_while] = STATE(459),
    [sym_repeat] = STATE(459),
    [sym_for] = STATE(459),
    [sym_switch] = STATE(459),
    [sym_call] = STATE(459),
    [sym__assignment] = STATE(459),
    [sym_left_assignment] = STATE(459),
    [sym_left_assignment2] = STATE(459),
    [sym_equals_assignment] = STATE(459),
    [sym_super_assignment] = STATE(459),
    [sym_right_assignment] = STATE(459),
    [sym_brace_list] = STATE(459),
    [sym_paren_list] = STATE(459),
    [sym_subset] = STATE(459),
    [sym_subset2] = STATE(459),
    [sym_dollar] = STATE(459),
    [sym_slot] = STATE(459),
    [sym_namespace_get] = STATE(459),
    [sym_namespace_get_internal] = STATE(459),
    [sym_unary] = STATE(459),
    [sym_binary] = STATE(459),
    [sym_na] = STATE(459),
    [sym__expression] = STATE(459),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(459),
    [sym_string] = STATE(459),
    [anon_sym_SEMI] = ACTIONS(1720),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1722),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1722),
    [sym_next] = ACTIONS(1722),
    [sym_true] = ACTIONS(1722),
    [sym_false] = ACTIONS(1722),
    [sym_null] = ACTIONS(1722),
    [sym_inf] = ACTIONS(1722),
    [sym_nan] = ACTIONS(1722),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1720),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [313] = {
    [sym_function_definition] = STATE(813),
    [sym_if] = STATE(813),
    [sym_while] = STATE(813),
    [sym_repeat] = STATE(813),
    [sym_for] = STATE(813),
    [sym_switch] = STATE(813),
    [sym_call] = STATE(813),
    [sym__assignment] = STATE(813),
    [sym_left_assignment] = STATE(813),
    [sym_left_assignment2] = STATE(813),
    [sym_equals_assignment] = STATE(813),
    [sym_super_assignment] = STATE(813),
    [sym_right_assignment] = STATE(813),
    [sym_brace_list] = STATE(813),
    [sym_paren_list] = STATE(813),
    [sym_subset] = STATE(813),
    [sym_subset2] = STATE(813),
    [sym_dollar] = STATE(813),
    [sym_slot] = STATE(813),
    [sym_namespace_get] = STATE(813),
    [sym_namespace_get_internal] = STATE(813),
    [sym_unary] = STATE(813),
    [sym_binary] = STATE(813),
    [sym_na] = STATE(813),
    [sym__expression] = STATE(813),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(813),
    [sym_string] = STATE(813),
    [anon_sym_SEMI] = ACTIONS(1724),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1726),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1726),
    [sym_next] = ACTIONS(1726),
    [sym_true] = ACTIONS(1726),
    [sym_false] = ACTIONS(1726),
    [sym_null] = ACTIONS(1726),
    [sym_inf] = ACTIONS(1726),
    [sym_nan] = ACTIONS(1726),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1724),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [314] = {
    [sym_function_definition] = STATE(457),
    [sym_if] = STATE(457),
    [sym_while] = STATE(457),
    [sym_repeat] = STATE(457),
    [sym_for] = STATE(457),
    [sym_switch] = STATE(457),
    [sym_call] = STATE(457),
    [sym__assignment] = STATE(457),
    [sym_left_assignment] = STATE(457),
    [sym_left_assignment2] = STATE(457),
    [sym_equals_assignment] = STATE(457),
    [sym_super_assignment] = STATE(457),
    [sym_right_assignment] = STATE(457),
    [sym_brace_list] = STATE(457),
    [sym_paren_list] = STATE(457),
    [sym_subset] = STATE(457),
    [sym_subset2] = STATE(457),
    [sym_dollar] = STATE(457),
    [sym_slot] = STATE(457),
    [sym_namespace_get] = STATE(457),
    [sym_namespace_get_internal] = STATE(457),
    [sym_unary] = STATE(457),
    [sym_binary] = STATE(457),
    [sym_na] = STATE(457),
    [sym__expression] = STATE(457),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(457),
    [sym_string] = STATE(457),
    [anon_sym_SEMI] = ACTIONS(1728),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1730),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1730),
    [sym_next] = ACTIONS(1730),
    [sym_true] = ACTIONS(1730),
    [sym_false] = ACTIONS(1730),
    [sym_null] = ACTIONS(1730),
    [sym_inf] = ACTIONS(1730),
    [sym_nan] = ACTIONS(1730),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1728),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [315] = {
    [sym_special] = STATE(478),
    [ts_builtin_sym_end] = ACTIONS(724),
    [anon_sym_LF] = ACTIONS(726),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(726),
    [anon_sym_if] = ACTIONS(726),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(726),
    [anon_sym_while] = ACTIONS(726),
    [anon_sym_repeat] = ACTIONS(726),
    [anon_sym_for] = ACTIONS(726),
    [anon_sym_switch] = ACTIONS(726),
    [anon_sym_EQ] = ACTIONS(870),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_LT_DASH] = ACTIONS(872),
    [anon_sym_COLON_EQ] = ACTIONS(874),
    [anon_sym_LT_LT_DASH] = ACTIONS(876),
    [anon_sym_DASH_GT] = ACTIONS(878),
    [anon_sym_LBRACK] = ACTIONS(880),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(882),
    [anon_sym_DOLLAR] = ACTIONS(884),
    [anon_sym_AT] = ACTIONS(886),
    [sym_dots] = ACTIONS(726),
    [anon_sym_DASH] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(888),
    [anon_sym_BANG] = ACTIONS(726),
    [anon_sym_TILDE] = ACTIONS(890),
    [anon_sym_STAR] = ACTIONS(892),
    [anon_sym_SLASH] = ACTIONS(892),
    [anon_sym_CARET] = ACTIONS(894),
    [anon_sym_LT] = ACTIONS(896),
    [anon_sym_GT] = ACTIONS(896),
    [anon_sym_LT_EQ] = ACTIONS(896),
    [anon_sym_GT_EQ] = ACTIONS(896),
    [anon_sym_EQ_EQ] = ACTIONS(896),
    [anon_sym_BANG_EQ] = ACTIONS(896),
    [anon_sym_PIPE_PIPE] = ACTIONS(898),
    [anon_sym_PIPE] = ACTIONS(898),
    [anon_sym_AMP_AMP] = ACTIONS(900),
    [anon_sym_AMP] = ACTIONS(900),
    [anon_sym_COLON] = ACTIONS(902),
    [sym_break] = ACTIONS(726),
    [sym_next] = ACTIONS(726),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_null] = ACTIONS(726),
    [sym_inf] = ACTIONS(726),
    [sym_nan] = ACTIONS(726),
    [anon_sym_NA] = ACTIONS(726),
    [anon_sym_NA_character_] = ACTIONS(726),
    [anon_sym_NA_complex_] = ACTIONS(726),
    [anon_sym_NA_integer_] = ACTIONS(726),
    [anon_sym_NA_real_] = ACTIONS(726),
    [aux_sym_identifier_token1] = ACTIONS(726),
    [anon_sym_BQUOTE] = ACTIONS(726),
    [sym_integer] = ACTIONS(726),
    [sym_float] = ACTIONS(726),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(726),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [316] = {
    [sym_function_definition] = STATE(298),
    [sym_if] = STATE(298),
    [sym_while] = STATE(298),
    [sym_repeat] = STATE(298),
    [sym_for] = STATE(298),
    [sym_switch] = STATE(298),
    [sym_call] = STATE(298),
    [sym__assignment] = STATE(298),
    [sym_left_assignment] = STATE(298),
    [sym_left_assignment2] = STATE(298),
    [sym_equals_assignment] = STATE(298),
    [sym_super_assignment] = STATE(298),
    [sym_right_assignment] = STATE(298),
    [sym_brace_list] = STATE(298),
    [sym_paren_list] = STATE(298),
    [sym_subset] = STATE(298),
    [sym_subset2] = STATE(298),
    [sym_dollar] = STATE(298),
    [sym_slot] = STATE(298),
    [sym_namespace_get] = STATE(298),
    [sym_namespace_get_internal] = STATE(298),
    [sym_unary] = STATE(298),
    [sym_binary] = STATE(298),
    [sym_na] = STATE(298),
    [sym__expression] = STATE(298),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(298),
    [sym_string] = STATE(298),
    [anon_sym_SEMI] = ACTIONS(1732),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1734),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1734),
    [sym_next] = ACTIONS(1734),
    [sym_true] = ACTIONS(1734),
    [sym_false] = ACTIONS(1734),
    [sym_null] = ACTIONS(1734),
    [sym_inf] = ACTIONS(1734),
    [sym_nan] = ACTIONS(1734),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1732),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [317] = {
    [sym_special] = STATE(478),
    [ts_builtin_sym_end] = ACTIONS(720),
    [anon_sym_LF] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_LT_DASH] = ACTIONS(722),
    [anon_sym_COLON_EQ] = ACTIONS(722),
    [anon_sym_LT_LT_DASH] = ACTIONS(722),
    [anon_sym_DASH_GT] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(880),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(882),
    [anon_sym_DOLLAR] = ACTIONS(884),
    [anon_sym_AT] = ACTIONS(886),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_PLUS] = ACTIONS(722),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(722),
    [anon_sym_STAR] = ACTIONS(722),
    [anon_sym_SLASH] = ACTIONS(722),
    [anon_sym_CARET] = ACTIONS(894),
    [anon_sym_LT] = ACTIONS(722),
    [anon_sym_GT] = ACTIONS(722),
    [anon_sym_LT_EQ] = ACTIONS(722),
    [anon_sym_GT_EQ] = ACTIONS(722),
    [anon_sym_EQ_EQ] = ACTIONS(722),
    [anon_sym_BANG_EQ] = ACTIONS(722),
    [anon_sym_PIPE_PIPE] = ACTIONS(722),
    [anon_sym_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(722),
    [anon_sym_AMP] = ACTIONS(722),
    [anon_sym_COLON] = ACTIONS(722),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(722),
    [sym_integer] = ACTIONS(722),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(722),
  },
  [318] = {
    [sym_special] = STATE(478),
    [ts_builtin_sym_end] = ACTIONS(720),
    [anon_sym_LF] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_LT_DASH] = ACTIONS(722),
    [anon_sym_COLON_EQ] = ACTIONS(722),
    [anon_sym_LT_LT_DASH] = ACTIONS(722),
    [anon_sym_DASH_GT] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(880),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(882),
    [anon_sym_DOLLAR] = ACTIONS(884),
    [anon_sym_AT] = ACTIONS(886),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(888),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(722),
    [anon_sym_STAR] = ACTIONS(892),
    [anon_sym_SLASH] = ACTIONS(892),
    [anon_sym_CARET] = ACTIONS(894),
    [anon_sym_LT] = ACTIONS(896),
    [anon_sym_GT] = ACTIONS(896),
    [anon_sym_LT_EQ] = ACTIONS(896),
    [anon_sym_GT_EQ] = ACTIONS(896),
    [anon_sym_EQ_EQ] = ACTIONS(896),
    [anon_sym_BANG_EQ] = ACTIONS(896),
    [anon_sym_PIPE_PIPE] = ACTIONS(722),
    [anon_sym_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(722),
    [anon_sym_AMP] = ACTIONS(722),
    [anon_sym_COLON] = ACTIONS(902),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(722),
    [sym_integer] = ACTIONS(722),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [319] = {
    [sym_special] = STATE(478),
    [ts_builtin_sym_end] = ACTIONS(720),
    [anon_sym_LF] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_function] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_repeat] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_LT_DASH] = ACTIONS(722),
    [anon_sym_COLON_EQ] = ACTIONS(722),
    [anon_sym_LT_LT_DASH] = ACTIONS(722),
    [anon_sym_DASH_GT] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(880),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(882),
    [anon_sym_DOLLAR] = ACTIONS(884),
    [anon_sym_AT] = ACTIONS(886),
    [sym_dots] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(888),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(722),
    [anon_sym_STAR] = ACTIONS(892),
    [anon_sym_SLASH] = ACTIONS(892),
    [anon_sym_CARET] = ACTIONS(894),
    [anon_sym_LT] = ACTIONS(896),
    [anon_sym_GT] = ACTIONS(896),
    [anon_sym_LT_EQ] = ACTIONS(896),
    [anon_sym_GT_EQ] = ACTIONS(896),
    [anon_sym_EQ_EQ] = ACTIONS(896),
    [anon_sym_BANG_EQ] = ACTIONS(896),
    [anon_sym_PIPE_PIPE] = ACTIONS(898),
    [anon_sym_PIPE] = ACTIONS(898),
    [anon_sym_AMP_AMP] = ACTIONS(900),
    [anon_sym_AMP] = ACTIONS(900),
    [anon_sym_COLON] = ACTIONS(902),
    [sym_break] = ACTIONS(722),
    [sym_next] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_inf] = ACTIONS(722),
    [sym_nan] = ACTIONS(722),
    [anon_sym_NA] = ACTIONS(722),
    [anon_sym_NA_character_] = ACTIONS(722),
    [anon_sym_NA_complex_] = ACTIONS(722),
    [anon_sym_NA_integer_] = ACTIONS(722),
    [anon_sym_NA_real_] = ACTIONS(722),
    [aux_sym_identifier_token1] = ACTIONS(722),
    [anon_sym_BQUOTE] = ACTIONS(722),
    [sym_integer] = ACTIONS(722),
    [sym_float] = ACTIONS(722),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE] = ACTIONS(722),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [320] = {
    [sym_function_definition] = STATE(617),
    [sym_if] = STATE(617),
    [sym_while] = STATE(617),
    [sym_repeat] = STATE(617),
    [sym_for] = STATE(617),
    [sym_switch] = STATE(617),
    [sym_call] = STATE(617),
    [sym__assignment] = STATE(617),
    [sym_left_assignment] = STATE(617),
    [sym_left_assignment2] = STATE(617),
    [sym_equals_assignment] = STATE(617),
    [sym_super_assignment] = STATE(617),
    [sym_right_assignment] = STATE(617),
    [sym_brace_list] = STATE(617),
    [sym_paren_list] = STATE(617),
    [sym_subset] = STATE(617),
    [sym_subset2] = STATE(617),
    [sym_dollar] = STATE(617),
    [sym_slot] = STATE(617),
    [sym_namespace_get] = STATE(617),
    [sym_namespace_get_internal] = STATE(617),
    [sym_unary] = STATE(617),
    [sym_binary] = STATE(617),
    [sym_na] = STATE(617),
    [sym__expression] = STATE(617),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(617),
    [sym_string] = STATE(617),
    [anon_sym_SEMI] = ACTIONS(1736),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1738),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1738),
    [sym_next] = ACTIONS(1738),
    [sym_true] = ACTIONS(1738),
    [sym_false] = ACTIONS(1738),
    [sym_null] = ACTIONS(1738),
    [sym_inf] = ACTIONS(1738),
    [sym_nan] = ACTIONS(1738),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1736),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [321] = {
    [sym_function_definition] = STATE(673),
    [sym_if] = STATE(673),
    [sym_while] = STATE(673),
    [sym_repeat] = STATE(673),
    [sym_for] = STATE(673),
    [sym_switch] = STATE(673),
    [sym_call] = STATE(673),
    [sym__assignment] = STATE(673),
    [sym_left_assignment] = STATE(673),
    [sym_left_assignment2] = STATE(673),
    [sym_equals_assignment] = STATE(673),
    [sym_super_assignment] = STATE(673),
    [sym_right_assignment] = STATE(673),
    [sym_brace_list] = STATE(673),
    [sym_paren_list] = STATE(673),
    [sym_subset] = STATE(673),
    [sym_subset2] = STATE(673),
    [sym_dollar] = STATE(673),
    [sym_slot] = STATE(673),
    [sym_namespace_get] = STATE(673),
    [sym_namespace_get_internal] = STATE(673),
    [sym_unary] = STATE(673),
    [sym_binary] = STATE(673),
    [sym_na] = STATE(673),
    [sym__expression] = STATE(673),
    [sym_identifier] = STATE(223),
    [sym_complex] = STATE(673),
    [sym_string] = STATE(673),
    [anon_sym_SEMI] = ACTIONS(1740),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_if] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_switch] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_dots] = ACTIONS(1742),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [sym_break] = ACTIONS(1742),
    [sym_next] = ACTIONS(1742),
    [sym_true] = ACTIONS(1742),
    [sym_false] = ACTIONS(1742),
    [sym_null] = ACTIONS(1742),
    [sym_inf] = ACTIONS(1742),
    [sym_nan] = ACTIONS(1742),
    [anon_sym_NA] = ACTIONS(33),
    [anon_sym_NA_character_] = ACTIONS(33),
    [anon_sym_NA_complex_] = ACTIONS(33),
    [anon_sym_NA_integer_] = ACTIONS(33),
    [anon_sym_NA_real_] = ACTIONS(33),
    [aux_sym_identifier_token1] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(37),
    [sym_integer] = ACTIONS(1740),
    [sym_float] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [anon_sym_SQUOTE] = ACTIONS(43),
  },
  [322] = {
    [sym_function_definition] = STATE(422),
    [sym_if] = STATE(422),
    [sym_while] = STATE(422),
    [sym_repeat] = STATE(422),
    [sym_for] = STATE(422),
    [sym_switch] = STATE(422),
    [sym_call] = STATE(422),
    [sym__assignment] = STATE(422),
    [sym_left_assignment] = STATE(422),
    [sym_left_assignment2] = STATE(422),
    [sym_equals_assignment] = STATE(422),
    [sym_super_assignment] = STATE(422),
    [sym_right_assignment] = STATE(422),
    [sym_brace_list] = STATE(422),
    [sym_paren_list] = STATE(422),
    [sym_subset] = STATE(422),
    [sym_subset2] = STATE(422),
    [sym_dollar] = STATE(422),
    [sym_slot] = STATE(422),
    [sym_namespace_get] = STATE(422),
    [sym_namespace_get_internal] = STATE(422),
    [sym_unary] = STATE(422),
    [sym_binary] = STATE(422),
    [sym_na] = STATE(422),
    [sym__expression] = STATE(422),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(422),
    [sym_string] = STATE(422),
    [anon_sym_SEMI] = ACTIONS(1744),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1746),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1746),
    [sym_next] = ACTIONS(1746),
    [sym_true] = ACTIONS(1746),
    [sym_false] = ACTIONS(1746),
    [sym_null] = ACTIONS(1746),
    [sym_inf] = ACTIONS(1746),
    [sym_nan] = ACTIONS(1746),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1744),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [323] = {
    [sym_function_definition] = STATE(817),
    [sym_if] = STATE(817),
    [sym_while] = STATE(817),
    [sym_repeat] = STATE(817),
    [sym_for] = STATE(817),
    [sym_switch] = STATE(817),
    [sym_call] = STATE(817),
    [sym__assignment] = STATE(817),
    [sym_left_assignment] = STATE(817),
    [sym_left_assignment2] = STATE(817),
    [sym_equals_assignment] = STATE(817),
    [sym_super_assignment] = STATE(817),
    [sym_right_assignment] = STATE(817),
    [sym_brace_list] = STATE(817),
    [sym_paren_list] = STATE(817),
    [sym_subset] = STATE(817),
    [sym_subset2] = STATE(817),
    [sym_dollar] = STATE(817),
    [sym_slot] = STATE(817),
    [sym_namespace_get] = STATE(817),
    [sym_namespace_get_internal] = STATE(817),
    [sym_unary] = STATE(817),
    [sym_binary] = STATE(817),
    [sym_na] = STATE(817),
    [sym__expression] = STATE(817),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(817),
    [sym_string] = STATE(817),
    [anon_sym_SEMI] = ACTIONS(1748),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1750),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1750),
    [sym_next] = ACTIONS(1750),
    [sym_true] = ACTIONS(1750),
    [sym_false] = ACTIONS(1750),
    [sym_null] = ACTIONS(1750),
    [sym_inf] = ACTIONS(1750),
    [sym_nan] = ACTIONS(1750),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1748),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [324] = {
    [sym_function_definition] = STATE(818),
    [sym_if] = STATE(818),
    [sym_while] = STATE(818),
    [sym_repeat] = STATE(818),
    [sym_for] = STATE(818),
    [sym_switch] = STATE(818),
    [sym_call] = STATE(818),
    [sym__assignment] = STATE(818),
    [sym_left_assignment] = STATE(818),
    [sym_left_assignment2] = STATE(818),
    [sym_equals_assignment] = STATE(818),
    [sym_super_assignment] = STATE(818),
    [sym_right_assignment] = STATE(818),
    [sym_brace_list] = STATE(818),
    [sym_paren_list] = STATE(818),
    [sym_subset] = STATE(818),
    [sym_subset2] = STATE(818),
    [sym_dollar] = STATE(818),
    [sym_slot] = STATE(818),
    [sym_namespace_get] = STATE(818),
    [sym_namespace_get_internal] = STATE(818),
    [sym_unary] = STATE(818),
    [sym_binary] = STATE(818),
    [sym_na] = STATE(818),
    [sym__expression] = STATE(818),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(818),
    [sym_string] = STATE(818),
    [anon_sym_SEMI] = ACTIONS(1752),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1754),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1754),
    [sym_next] = ACTIONS(1754),
    [sym_true] = ACTIONS(1754),
    [sym_false] = ACTIONS(1754),
    [sym_null] = ACTIONS(1754),
    [sym_inf] = ACTIONS(1754),
    [sym_nan] = ACTIONS(1754),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1752),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [325] = {
    [sym_function_definition] = STATE(819),
    [sym_if] = STATE(819),
    [sym_while] = STATE(819),
    [sym_repeat] = STATE(819),
    [sym_for] = STATE(819),
    [sym_switch] = STATE(819),
    [sym_call] = STATE(819),
    [sym__assignment] = STATE(819),
    [sym_left_assignment] = STATE(819),
    [sym_left_assignment2] = STATE(819),
    [sym_equals_assignment] = STATE(819),
    [sym_super_assignment] = STATE(819),
    [sym_right_assignment] = STATE(819),
    [sym_brace_list] = STATE(819),
    [sym_paren_list] = STATE(819),
    [sym_subset] = STATE(819),
    [sym_subset2] = STATE(819),
    [sym_dollar] = STATE(819),
    [sym_slot] = STATE(819),
    [sym_namespace_get] = STATE(819),
    [sym_namespace_get_internal] = STATE(819),
    [sym_unary] = STATE(819),
    [sym_binary] = STATE(819),
    [sym_na] = STATE(819),
    [sym__expression] = STATE(819),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(819),
    [sym_string] = STATE(819),
    [anon_sym_SEMI] = ACTIONS(1756),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1758),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1758),
    [sym_next] = ACTIONS(1758),
    [sym_true] = ACTIONS(1758),
    [sym_false] = ACTIONS(1758),
    [sym_null] = ACTIONS(1758),
    [sym_inf] = ACTIONS(1758),
    [sym_nan] = ACTIONS(1758),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1756),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [326] = {
    [sym_function_definition] = STATE(820),
    [sym_if] = STATE(820),
    [sym_while] = STATE(820),
    [sym_repeat] = STATE(820),
    [sym_for] = STATE(820),
    [sym_switch] = STATE(820),
    [sym_call] = STATE(820),
    [sym__assignment] = STATE(820),
    [sym_left_assignment] = STATE(820),
    [sym_left_assignment2] = STATE(820),
    [sym_equals_assignment] = STATE(820),
    [sym_super_assignment] = STATE(820),
    [sym_right_assignment] = STATE(820),
    [sym_brace_list] = STATE(820),
    [sym_paren_list] = STATE(820),
    [sym_subset] = STATE(820),
    [sym_subset2] = STATE(820),
    [sym_dollar] = STATE(820),
    [sym_slot] = STATE(820),
    [sym_namespace_get] = STATE(820),
    [sym_namespace_get_internal] = STATE(820),
    [sym_unary] = STATE(820),
    [sym_binary] = STATE(820),
    [sym_na] = STATE(820),
    [sym__expression] = STATE(820),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(820),
    [sym_string] = STATE(820),
    [anon_sym_SEMI] = ACTIONS(1760),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1762),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1762),
    [sym_next] = ACTIONS(1762),
    [sym_true] = ACTIONS(1762),
    [sym_false] = ACTIONS(1762),
    [sym_null] = ACTIONS(1762),
    [sym_inf] = ACTIONS(1762),
    [sym_nan] = ACTIONS(1762),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1760),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [327] = {
    [sym_function_definition] = STATE(821),
    [sym_if] = STATE(821),
    [sym_while] = STATE(821),
    [sym_repeat] = STATE(821),
    [sym_for] = STATE(821),
    [sym_switch] = STATE(821),
    [sym_call] = STATE(821),
    [sym__assignment] = STATE(821),
    [sym_left_assignment] = STATE(821),
    [sym_left_assignment2] = STATE(821),
    [sym_equals_assignment] = STATE(821),
    [sym_super_assignment] = STATE(821),
    [sym_right_assignment] = STATE(821),
    [sym_brace_list] = STATE(821),
    [sym_paren_list] = STATE(821),
    [sym_subset] = STATE(821),
    [sym_subset2] = STATE(821),
    [sym_dollar] = STATE(821),
    [sym_slot] = STATE(821),
    [sym_namespace_get] = STATE(821),
    [sym_namespace_get_internal] = STATE(821),
    [sym_unary] = STATE(821),
    [sym_binary] = STATE(821),
    [sym_na] = STATE(821),
    [sym__expression] = STATE(821),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(821),
    [sym_string] = STATE(821),
    [anon_sym_SEMI] = ACTIONS(1764),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1766),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1766),
    [sym_next] = ACTIONS(1766),
    [sym_true] = ACTIONS(1766),
    [sym_false] = ACTIONS(1766),
    [sym_null] = ACTIONS(1766),
    [sym_inf] = ACTIONS(1766),
    [sym_nan] = ACTIONS(1766),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1764),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [328] = {
    [sym_function_definition] = STATE(423),
    [sym_if] = STATE(423),
    [sym_while] = STATE(423),
    [sym_repeat] = STATE(423),
    [sym_for] = STATE(423),
    [sym_switch] = STATE(423),
    [sym_call] = STATE(423),
    [sym__assignment] = STATE(423),
    [sym_left_assignment] = STATE(423),
    [sym_left_assignment2] = STATE(423),
    [sym_equals_assignment] = STATE(423),
    [sym_super_assignment] = STATE(423),
    [sym_right_assignment] = STATE(423),
    [sym_brace_list] = STATE(423),
    [sym_paren_list] = STATE(423),
    [sym_subset] = STATE(423),
    [sym_subset2] = STATE(423),
    [sym_dollar] = STATE(423),
    [sym_slot] = STATE(423),
    [sym_namespace_get] = STATE(423),
    [sym_namespace_get_internal] = STATE(423),
    [sym_unary] = STATE(423),
    [sym_binary] = STATE(423),
    [sym_na] = STATE(423),
    [sym__expression] = STATE(423),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(423),
    [sym_string] = STATE(423),
    [anon_sym_SEMI] = ACTIONS(1768),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1770),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1770),
    [sym_next] = ACTIONS(1770),
    [sym_true] = ACTIONS(1770),
    [sym_false] = ACTIONS(1770),
    [sym_null] = ACTIONS(1770),
    [sym_inf] = ACTIONS(1770),
    [sym_nan] = ACTIONS(1770),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1768),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [329] = {
    [sym_function_definition] = STATE(430),
    [sym_if] = STATE(430),
    [sym_while] = STATE(430),
    [sym_repeat] = STATE(430),
    [sym_for] = STATE(430),
    [sym_switch] = STATE(430),
    [sym_call] = STATE(430),
    [sym__assignment] = STATE(430),
    [sym_left_assignment] = STATE(430),
    [sym_left_assignment2] = STATE(430),
    [sym_equals_assignment] = STATE(430),
    [sym_super_assignment] = STATE(430),
    [sym_right_assignment] = STATE(430),
    [sym_brace_list] = STATE(430),
    [sym_paren_list] = STATE(430),
    [sym_subset] = STATE(430),
    [sym_subset2] = STATE(430),
    [sym_dollar] = STATE(430),
    [sym_slot] = STATE(430),
    [sym_namespace_get] = STATE(430),
    [sym_namespace_get_internal] = STATE(430),
    [sym_unary] = STATE(430),
    [sym_binary] = STATE(430),
    [sym_na] = STATE(430),
    [sym__expression] = STATE(430),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(430),
    [sym_string] = STATE(430),
    [anon_sym_SEMI] = ACTIONS(1772),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1774),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1774),
    [sym_next] = ACTIONS(1774),
    [sym_true] = ACTIONS(1774),
    [sym_false] = ACTIONS(1774),
    [sym_null] = ACTIONS(1774),
    [sym_inf] = ACTIONS(1774),
    [sym_nan] = ACTIONS(1774),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1772),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [330] = {
    [sym_function_definition] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [anon_sym_SEMI] = ACTIONS(1776),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1778),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1778),
    [sym_next] = ACTIONS(1778),
    [sym_true] = ACTIONS(1778),
    [sym_false] = ACTIONS(1778),
    [sym_null] = ACTIONS(1778),
    [sym_inf] = ACTIONS(1778),
    [sym_nan] = ACTIONS(1778),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1776),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [331] = {
    [sym_function_definition] = STATE(812),
    [sym_if] = STATE(812),
    [sym_while] = STATE(812),
    [sym_repeat] = STATE(812),
    [sym_for] = STATE(812),
    [sym_switch] = STATE(812),
    [sym_call] = STATE(812),
    [sym__assignment] = STATE(812),
    [sym_left_assignment] = STATE(812),
    [sym_left_assignment2] = STATE(812),
    [sym_equals_assignment] = STATE(812),
    [sym_super_assignment] = STATE(812),
    [sym_right_assignment] = STATE(812),
    [sym_brace_list] = STATE(812),
    [sym_paren_list] = STATE(812),
    [sym_subset] = STATE(812),
    [sym_subset2] = STATE(812),
    [sym_dollar] = STATE(812),
    [sym_slot] = STATE(812),
    [sym_namespace_get] = STATE(812),
    [sym_namespace_get_internal] = STATE(812),
    [sym_unary] = STATE(812),
    [sym_binary] = STATE(812),
    [sym_na] = STATE(812),
    [sym__expression] = STATE(812),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(812),
    [sym_string] = STATE(812),
    [anon_sym_SEMI] = ACTIONS(1780),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1782),
    [sym_next] = ACTIONS(1782),
    [sym_true] = ACTIONS(1782),
    [sym_false] = ACTIONS(1782),
    [sym_null] = ACTIONS(1782),
    [sym_inf] = ACTIONS(1782),
    [sym_nan] = ACTIONS(1782),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1780),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [332] = {
    [sym_function_definition] = STATE(806),
    [sym_if] = STATE(806),
    [sym_while] = STATE(806),
    [sym_repeat] = STATE(806),
    [sym_for] = STATE(806),
    [sym_switch] = STATE(806),
    [sym_call] = STATE(806),
    [sym__assignment] = STATE(806),
    [sym_left_assignment] = STATE(806),
    [sym_left_assignment2] = STATE(806),
    [sym_equals_assignment] = STATE(806),
    [sym_super_assignment] = STATE(806),
    [sym_right_assignment] = STATE(806),
    [sym_brace_list] = STATE(806),
    [sym_paren_list] = STATE(806),
    [sym_subset] = STATE(806),
    [sym_subset2] = STATE(806),
    [sym_dollar] = STATE(806),
    [sym_slot] = STATE(806),
    [sym_namespace_get] = STATE(806),
    [sym_namespace_get_internal] = STATE(806),
    [sym_unary] = STATE(806),
    [sym_binary] = STATE(806),
    [sym_na] = STATE(806),
    [sym__expression] = STATE(806),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(806),
    [sym_string] = STATE(806),
    [anon_sym_SEMI] = ACTIONS(1784),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1786),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1786),
    [sym_next] = ACTIONS(1786),
    [sym_true] = ACTIONS(1786),
    [sym_false] = ACTIONS(1786),
    [sym_null] = ACTIONS(1786),
    [sym_inf] = ACTIONS(1786),
    [sym_nan] = ACTIONS(1786),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1784),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [333] = {
    [sym_function_definition] = STATE(805),
    [sym_if] = STATE(805),
    [sym_while] = STATE(805),
    [sym_repeat] = STATE(805),
    [sym_for] = STATE(805),
    [sym_switch] = STATE(805),
    [sym_call] = STATE(805),
    [sym__assignment] = STATE(805),
    [sym_left_assignment] = STATE(805),
    [sym_left_assignment2] = STATE(805),
    [sym_equals_assignment] = STATE(805),
    [sym_super_assignment] = STATE(805),
    [sym_right_assignment] = STATE(805),
    [sym_brace_list] = STATE(805),
    [sym_paren_list] = STATE(805),
    [sym_subset] = STATE(805),
    [sym_subset2] = STATE(805),
    [sym_dollar] = STATE(805),
    [sym_slot] = STATE(805),
    [sym_namespace_get] = STATE(805),
    [sym_namespace_get_internal] = STATE(805),
    [sym_unary] = STATE(805),
    [sym_binary] = STATE(805),
    [sym_na] = STATE(805),
    [sym__expression] = STATE(805),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(805),
    [sym_string] = STATE(805),
    [anon_sym_SEMI] = ACTIONS(1788),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1790),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1790),
    [sym_next] = ACTIONS(1790),
    [sym_true] = ACTIONS(1790),
    [sym_false] = ACTIONS(1790),
    [sym_null] = ACTIONS(1790),
    [sym_inf] = ACTIONS(1790),
    [sym_nan] = ACTIONS(1790),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1788),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [334] = {
    [sym_function_definition] = STATE(794),
    [sym_if] = STATE(794),
    [sym_while] = STATE(794),
    [sym_repeat] = STATE(794),
    [sym_for] = STATE(794),
    [sym_switch] = STATE(794),
    [sym_call] = STATE(794),
    [sym__assignment] = STATE(794),
    [sym_left_assignment] = STATE(794),
    [sym_left_assignment2] = STATE(794),
    [sym_equals_assignment] = STATE(794),
    [sym_super_assignment] = STATE(794),
    [sym_right_assignment] = STATE(794),
    [sym_brace_list] = STATE(794),
    [sym_paren_list] = STATE(794),
    [sym_subset] = STATE(794),
    [sym_subset2] = STATE(794),
    [sym_dollar] = STATE(794),
    [sym_slot] = STATE(794),
    [sym_namespace_get] = STATE(794),
    [sym_namespace_get_internal] = STATE(794),
    [sym_unary] = STATE(794),
    [sym_binary] = STATE(794),
    [sym_na] = STATE(794),
    [sym__expression] = STATE(794),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(794),
    [sym_string] = STATE(794),
    [anon_sym_SEMI] = ACTIONS(1792),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1794),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1794),
    [sym_next] = ACTIONS(1794),
    [sym_true] = ACTIONS(1794),
    [sym_false] = ACTIONS(1794),
    [sym_null] = ACTIONS(1794),
    [sym_inf] = ACTIONS(1794),
    [sym_nan] = ACTIONS(1794),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1792),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [335] = {
    [sym_function_definition] = STATE(793),
    [sym_if] = STATE(793),
    [sym_while] = STATE(793),
    [sym_repeat] = STATE(793),
    [sym_for] = STATE(793),
    [sym_switch] = STATE(793),
    [sym_call] = STATE(793),
    [sym__assignment] = STATE(793),
    [sym_left_assignment] = STATE(793),
    [sym_left_assignment2] = STATE(793),
    [sym_equals_assignment] = STATE(793),
    [sym_super_assignment] = STATE(793),
    [sym_right_assignment] = STATE(793),
    [sym_brace_list] = STATE(793),
    [sym_paren_list] = STATE(793),
    [sym_subset] = STATE(793),
    [sym_subset2] = STATE(793),
    [sym_dollar] = STATE(793),
    [sym_slot] = STATE(793),
    [sym_namespace_get] = STATE(793),
    [sym_namespace_get_internal] = STATE(793),
    [sym_unary] = STATE(793),
    [sym_binary] = STATE(793),
    [sym_na] = STATE(793),
    [sym__expression] = STATE(793),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(793),
    [sym_string] = STATE(793),
    [anon_sym_SEMI] = ACTIONS(1796),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1798),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1798),
    [sym_next] = ACTIONS(1798),
    [sym_true] = ACTIONS(1798),
    [sym_false] = ACTIONS(1798),
    [sym_null] = ACTIONS(1798),
    [sym_inf] = ACTIONS(1798),
    [sym_nan] = ACTIONS(1798),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1796),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [336] = {
    [sym_function_definition] = STATE(801),
    [sym_if] = STATE(801),
    [sym_while] = STATE(801),
    [sym_repeat] = STATE(801),
    [sym_for] = STATE(801),
    [sym_switch] = STATE(801),
    [sym_call] = STATE(801),
    [sym__assignment] = STATE(801),
    [sym_left_assignment] = STATE(801),
    [sym_left_assignment2] = STATE(801),
    [sym_equals_assignment] = STATE(801),
    [sym_super_assignment] = STATE(801),
    [sym_right_assignment] = STATE(801),
    [sym_brace_list] = STATE(801),
    [sym_paren_list] = STATE(801),
    [sym_subset] = STATE(801),
    [sym_subset2] = STATE(801),
    [sym_dollar] = STATE(801),
    [sym_slot] = STATE(801),
    [sym_namespace_get] = STATE(801),
    [sym_namespace_get_internal] = STATE(801),
    [sym_unary] = STATE(801),
    [sym_binary] = STATE(801),
    [sym_na] = STATE(801),
    [sym__expression] = STATE(801),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(801),
    [sym_string] = STATE(801),
    [anon_sym_SEMI] = ACTIONS(1800),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1802),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1802),
    [sym_next] = ACTIONS(1802),
    [sym_true] = ACTIONS(1802),
    [sym_false] = ACTIONS(1802),
    [sym_null] = ACTIONS(1802),
    [sym_inf] = ACTIONS(1802),
    [sym_nan] = ACTIONS(1802),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1800),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [337] = {
    [sym_function_definition] = STATE(784),
    [sym_if] = STATE(784),
    [sym_while] = STATE(784),
    [sym_repeat] = STATE(784),
    [sym_for] = STATE(784),
    [sym_switch] = STATE(784),
    [sym_call] = STATE(784),
    [sym__assignment] = STATE(784),
    [sym_left_assignment] = STATE(784),
    [sym_left_assignment2] = STATE(784),
    [sym_equals_assignment] = STATE(784),
    [sym_super_assignment] = STATE(784),
    [sym_right_assignment] = STATE(784),
    [sym_brace_list] = STATE(784),
    [sym_paren_list] = STATE(784),
    [sym_subset] = STATE(784),
    [sym_subset2] = STATE(784),
    [sym_dollar] = STATE(784),
    [sym_slot] = STATE(784),
    [sym_namespace_get] = STATE(784),
    [sym_namespace_get_internal] = STATE(784),
    [sym_unary] = STATE(784),
    [sym_binary] = STATE(784),
    [sym_na] = STATE(784),
    [sym__expression] = STATE(784),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(784),
    [sym_string] = STATE(784),
    [anon_sym_SEMI] = ACTIONS(1804),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1806),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1806),
    [sym_next] = ACTIONS(1806),
    [sym_true] = ACTIONS(1806),
    [sym_false] = ACTIONS(1806),
    [sym_null] = ACTIONS(1806),
    [sym_inf] = ACTIONS(1806),
    [sym_nan] = ACTIONS(1806),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1804),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [338] = {
    [sym_function_definition] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [anon_sym_SEMI] = ACTIONS(1808),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1810),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1810),
    [sym_next] = ACTIONS(1810),
    [sym_true] = ACTIONS(1810),
    [sym_false] = ACTIONS(1810),
    [sym_null] = ACTIONS(1810),
    [sym_inf] = ACTIONS(1810),
    [sym_nan] = ACTIONS(1810),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1808),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [339] = {
    [sym_function_definition] = STATE(432),
    [sym_if] = STATE(432),
    [sym_while] = STATE(432),
    [sym_repeat] = STATE(432),
    [sym_for] = STATE(432),
    [sym_switch] = STATE(432),
    [sym_call] = STATE(432),
    [sym__assignment] = STATE(432),
    [sym_left_assignment] = STATE(432),
    [sym_left_assignment2] = STATE(432),
    [sym_equals_assignment] = STATE(432),
    [sym_super_assignment] = STATE(432),
    [sym_right_assignment] = STATE(432),
    [sym_brace_list] = STATE(432),
    [sym_paren_list] = STATE(432),
    [sym_subset] = STATE(432),
    [sym_subset2] = STATE(432),
    [sym_dollar] = STATE(432),
    [sym_slot] = STATE(432),
    [sym_namespace_get] = STATE(432),
    [sym_namespace_get_internal] = STATE(432),
    [sym_unary] = STATE(432),
    [sym_binary] = STATE(432),
    [sym_na] = STATE(432),
    [sym__expression] = STATE(432),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(432),
    [sym_string] = STATE(432),
    [anon_sym_SEMI] = ACTIONS(1812),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1814),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1814),
    [sym_next] = ACTIONS(1814),
    [sym_true] = ACTIONS(1814),
    [sym_false] = ACTIONS(1814),
    [sym_null] = ACTIONS(1814),
    [sym_inf] = ACTIONS(1814),
    [sym_nan] = ACTIONS(1814),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1812),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [340] = {
    [sym_function_definition] = STATE(433),
    [sym_if] = STATE(433),
    [sym_while] = STATE(433),
    [sym_repeat] = STATE(433),
    [sym_for] = STATE(433),
    [sym_switch] = STATE(433),
    [sym_call] = STATE(433),
    [sym__assignment] = STATE(433),
    [sym_left_assignment] = STATE(433),
    [sym_left_assignment2] = STATE(433),
    [sym_equals_assignment] = STATE(433),
    [sym_super_assignment] = STATE(433),
    [sym_right_assignment] = STATE(433),
    [sym_brace_list] = STATE(433),
    [sym_paren_list] = STATE(433),
    [sym_subset] = STATE(433),
    [sym_subset2] = STATE(433),
    [sym_dollar] = STATE(433),
    [sym_slot] = STATE(433),
    [sym_namespace_get] = STATE(433),
    [sym_namespace_get_internal] = STATE(433),
    [sym_unary] = STATE(433),
    [sym_binary] = STATE(433),
    [sym_na] = STATE(433),
    [sym__expression] = STATE(433),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(433),
    [sym_string] = STATE(433),
    [anon_sym_SEMI] = ACTIONS(1816),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1818),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1818),
    [sym_next] = ACTIONS(1818),
    [sym_true] = ACTIONS(1818),
    [sym_false] = ACTIONS(1818),
    [sym_null] = ACTIONS(1818),
    [sym_inf] = ACTIONS(1818),
    [sym_nan] = ACTIONS(1818),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1816),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [341] = {
    [sym_function_definition] = STATE(434),
    [sym_if] = STATE(434),
    [sym_while] = STATE(434),
    [sym_repeat] = STATE(434),
    [sym_for] = STATE(434),
    [sym_switch] = STATE(434),
    [sym_call] = STATE(434),
    [sym__assignment] = STATE(434),
    [sym_left_assignment] = STATE(434),
    [sym_left_assignment2] = STATE(434),
    [sym_equals_assignment] = STATE(434),
    [sym_super_assignment] = STATE(434),
    [sym_right_assignment] = STATE(434),
    [sym_brace_list] = STATE(434),
    [sym_paren_list] = STATE(434),
    [sym_subset] = STATE(434),
    [sym_subset2] = STATE(434),
    [sym_dollar] = STATE(434),
    [sym_slot] = STATE(434),
    [sym_namespace_get] = STATE(434),
    [sym_namespace_get_internal] = STATE(434),
    [sym_unary] = STATE(434),
    [sym_binary] = STATE(434),
    [sym_na] = STATE(434),
    [sym__expression] = STATE(434),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(434),
    [sym_string] = STATE(434),
    [anon_sym_SEMI] = ACTIONS(1820),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1822),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1822),
    [sym_next] = ACTIONS(1822),
    [sym_true] = ACTIONS(1822),
    [sym_false] = ACTIONS(1822),
    [sym_null] = ACTIONS(1822),
    [sym_inf] = ACTIONS(1822),
    [sym_nan] = ACTIONS(1822),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1820),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [342] = {
    [sym_function_definition] = STATE(435),
    [sym_if] = STATE(435),
    [sym_while] = STATE(435),
    [sym_repeat] = STATE(435),
    [sym_for] = STATE(435),
    [sym_switch] = STATE(435),
    [sym_call] = STATE(435),
    [sym__assignment] = STATE(435),
    [sym_left_assignment] = STATE(435),
    [sym_left_assignment2] = STATE(435),
    [sym_equals_assignment] = STATE(435),
    [sym_super_assignment] = STATE(435),
    [sym_right_assignment] = STATE(435),
    [sym_brace_list] = STATE(435),
    [sym_paren_list] = STATE(435),
    [sym_subset] = STATE(435),
    [sym_subset2] = STATE(435),
    [sym_dollar] = STATE(435),
    [sym_slot] = STATE(435),
    [sym_namespace_get] = STATE(435),
    [sym_namespace_get_internal] = STATE(435),
    [sym_unary] = STATE(435),
    [sym_binary] = STATE(435),
    [sym_na] = STATE(435),
    [sym__expression] = STATE(435),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(435),
    [sym_string] = STATE(435),
    [anon_sym_SEMI] = ACTIONS(1824),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1826),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1826),
    [sym_next] = ACTIONS(1826),
    [sym_true] = ACTIONS(1826),
    [sym_false] = ACTIONS(1826),
    [sym_null] = ACTIONS(1826),
    [sym_inf] = ACTIONS(1826),
    [sym_nan] = ACTIONS(1826),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1824),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [343] = {
    [sym_function_definition] = STATE(436),
    [sym_if] = STATE(436),
    [sym_while] = STATE(436),
    [sym_repeat] = STATE(436),
    [sym_for] = STATE(436),
    [sym_switch] = STATE(436),
    [sym_call] = STATE(436),
    [sym__assignment] = STATE(436),
    [sym_left_assignment] = STATE(436),
    [sym_left_assignment2] = STATE(436),
    [sym_equals_assignment] = STATE(436),
    [sym_super_assignment] = STATE(436),
    [sym_right_assignment] = STATE(436),
    [sym_brace_list] = STATE(436),
    [sym_paren_list] = STATE(436),
    [sym_subset] = STATE(436),
    [sym_subset2] = STATE(436),
    [sym_dollar] = STATE(436),
    [sym_slot] = STATE(436),
    [sym_namespace_get] = STATE(436),
    [sym_namespace_get_internal] = STATE(436),
    [sym_unary] = STATE(436),
    [sym_binary] = STATE(436),
    [sym_na] = STATE(436),
    [sym__expression] = STATE(436),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(436),
    [sym_string] = STATE(436),
    [anon_sym_SEMI] = ACTIONS(1828),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1830),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1830),
    [sym_next] = ACTIONS(1830),
    [sym_true] = ACTIONS(1830),
    [sym_false] = ACTIONS(1830),
    [sym_null] = ACTIONS(1830),
    [sym_inf] = ACTIONS(1830),
    [sym_nan] = ACTIONS(1830),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1828),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [344] = {
    [sym_function_definition] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(437),
    [anon_sym_SEMI] = ACTIONS(1832),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1834),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1834),
    [sym_next] = ACTIONS(1834),
    [sym_true] = ACTIONS(1834),
    [sym_false] = ACTIONS(1834),
    [sym_null] = ACTIONS(1834),
    [sym_inf] = ACTIONS(1834),
    [sym_nan] = ACTIONS(1834),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1832),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [345] = {
    [sym_function_definition] = STATE(445),
    [sym_if] = STATE(445),
    [sym_while] = STATE(445),
    [sym_repeat] = STATE(445),
    [sym_for] = STATE(445),
    [sym_switch] = STATE(445),
    [sym_call] = STATE(445),
    [sym__assignment] = STATE(445),
    [sym_left_assignment] = STATE(445),
    [sym_left_assignment2] = STATE(445),
    [sym_equals_assignment] = STATE(445),
    [sym_super_assignment] = STATE(445),
    [sym_right_assignment] = STATE(445),
    [sym_brace_list] = STATE(445),
    [sym_paren_list] = STATE(445),
    [sym_subset] = STATE(445),
    [sym_subset2] = STATE(445),
    [sym_dollar] = STATE(445),
    [sym_slot] = STATE(445),
    [sym_namespace_get] = STATE(445),
    [sym_namespace_get_internal] = STATE(445),
    [sym_unary] = STATE(445),
    [sym_binary] = STATE(445),
    [sym_na] = STATE(445),
    [sym__expression] = STATE(445),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(445),
    [sym_string] = STATE(445),
    [anon_sym_SEMI] = ACTIONS(1836),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1838),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1838),
    [sym_next] = ACTIONS(1838),
    [sym_true] = ACTIONS(1838),
    [sym_false] = ACTIONS(1838),
    [sym_null] = ACTIONS(1838),
    [sym_inf] = ACTIONS(1838),
    [sym_nan] = ACTIONS(1838),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1836),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [346] = {
    [sym_function_definition] = STATE(449),
    [sym_if] = STATE(449),
    [sym_while] = STATE(449),
    [sym_repeat] = STATE(449),
    [sym_for] = STATE(449),
    [sym_switch] = STATE(449),
    [sym_call] = STATE(449),
    [sym__assignment] = STATE(449),
    [sym_left_assignment] = STATE(449),
    [sym_left_assignment2] = STATE(449),
    [sym_equals_assignment] = STATE(449),
    [sym_super_assignment] = STATE(449),
    [sym_right_assignment] = STATE(449),
    [sym_brace_list] = STATE(449),
    [sym_paren_list] = STATE(449),
    [sym_subset] = STATE(449),
    [sym_subset2] = STATE(449),
    [sym_dollar] = STATE(449),
    [sym_slot] = STATE(449),
    [sym_namespace_get] = STATE(449),
    [sym_namespace_get_internal] = STATE(449),
    [sym_unary] = STATE(449),
    [sym_binary] = STATE(449),
    [sym_na] = STATE(449),
    [sym__expression] = STATE(449),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(449),
    [sym_string] = STATE(449),
    [anon_sym_SEMI] = ACTIONS(1840),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1842),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1842),
    [sym_next] = ACTIONS(1842),
    [sym_true] = ACTIONS(1842),
    [sym_false] = ACTIONS(1842),
    [sym_null] = ACTIONS(1842),
    [sym_inf] = ACTIONS(1842),
    [sym_nan] = ACTIONS(1842),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1840),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [347] = {
    [sym_function_definition] = STATE(450),
    [sym_if] = STATE(450),
    [sym_while] = STATE(450),
    [sym_repeat] = STATE(450),
    [sym_for] = STATE(450),
    [sym_switch] = STATE(450),
    [sym_call] = STATE(450),
    [sym__assignment] = STATE(450),
    [sym_left_assignment] = STATE(450),
    [sym_left_assignment2] = STATE(450),
    [sym_equals_assignment] = STATE(450),
    [sym_super_assignment] = STATE(450),
    [sym_right_assignment] = STATE(450),
    [sym_brace_list] = STATE(450),
    [sym_paren_list] = STATE(450),
    [sym_subset] = STATE(450),
    [sym_subset2] = STATE(450),
    [sym_dollar] = STATE(450),
    [sym_slot] = STATE(450),
    [sym_namespace_get] = STATE(450),
    [sym_namespace_get_internal] = STATE(450),
    [sym_unary] = STATE(450),
    [sym_binary] = STATE(450),
    [sym_na] = STATE(450),
    [sym__expression] = STATE(450),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(450),
    [sym_string] = STATE(450),
    [anon_sym_SEMI] = ACTIONS(1844),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1846),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1846),
    [sym_next] = ACTIONS(1846),
    [sym_true] = ACTIONS(1846),
    [sym_false] = ACTIONS(1846),
    [sym_null] = ACTIONS(1846),
    [sym_inf] = ACTIONS(1846),
    [sym_nan] = ACTIONS(1846),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1844),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [348] = {
    [sym_function_definition] = STATE(451),
    [sym_if] = STATE(451),
    [sym_while] = STATE(451),
    [sym_repeat] = STATE(451),
    [sym_for] = STATE(451),
    [sym_switch] = STATE(451),
    [sym_call] = STATE(451),
    [sym__assignment] = STATE(451),
    [sym_left_assignment] = STATE(451),
    [sym_left_assignment2] = STATE(451),
    [sym_equals_assignment] = STATE(451),
    [sym_super_assignment] = STATE(451),
    [sym_right_assignment] = STATE(451),
    [sym_brace_list] = STATE(451),
    [sym_paren_list] = STATE(451),
    [sym_subset] = STATE(451),
    [sym_subset2] = STATE(451),
    [sym_dollar] = STATE(451),
    [sym_slot] = STATE(451),
    [sym_namespace_get] = STATE(451),
    [sym_namespace_get_internal] = STATE(451),
    [sym_unary] = STATE(451),
    [sym_binary] = STATE(451),
    [sym_na] = STATE(451),
    [sym__expression] = STATE(451),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(451),
    [sym_string] = STATE(451),
    [anon_sym_SEMI] = ACTIONS(1848),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1850),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1850),
    [sym_next] = ACTIONS(1850),
    [sym_true] = ACTIONS(1850),
    [sym_false] = ACTIONS(1850),
    [sym_null] = ACTIONS(1850),
    [sym_inf] = ACTIONS(1850),
    [sym_nan] = ACTIONS(1850),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1848),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [349] = {
    [sym_function_definition] = STATE(452),
    [sym_if] = STATE(452),
    [sym_while] = STATE(452),
    [sym_repeat] = STATE(452),
    [sym_for] = STATE(452),
    [sym_switch] = STATE(452),
    [sym_call] = STATE(452),
    [sym__assignment] = STATE(452),
    [sym_left_assignment] = STATE(452),
    [sym_left_assignment2] = STATE(452),
    [sym_equals_assignment] = STATE(452),
    [sym_super_assignment] = STATE(452),
    [sym_right_assignment] = STATE(452),
    [sym_brace_list] = STATE(452),
    [sym_paren_list] = STATE(452),
    [sym_subset] = STATE(452),
    [sym_subset2] = STATE(452),
    [sym_dollar] = STATE(452),
    [sym_slot] = STATE(452),
    [sym_namespace_get] = STATE(452),
    [sym_namespace_get_internal] = STATE(452),
    [sym_unary] = STATE(452),
    [sym_binary] = STATE(452),
    [sym_na] = STATE(452),
    [sym__expression] = STATE(452),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(452),
    [sym_string] = STATE(452),
    [anon_sym_SEMI] = ACTIONS(1852),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1854),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1854),
    [sym_next] = ACTIONS(1854),
    [sym_true] = ACTIONS(1854),
    [sym_false] = ACTIONS(1854),
    [sym_null] = ACTIONS(1854),
    [sym_inf] = ACTIONS(1854),
    [sym_nan] = ACTIONS(1854),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1852),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [350] = {
    [sym_function_definition] = STATE(453),
    [sym_if] = STATE(453),
    [sym_while] = STATE(453),
    [sym_repeat] = STATE(453),
    [sym_for] = STATE(453),
    [sym_switch] = STATE(453),
    [sym_call] = STATE(453),
    [sym__assignment] = STATE(453),
    [sym_left_assignment] = STATE(453),
    [sym_left_assignment2] = STATE(453),
    [sym_equals_assignment] = STATE(453),
    [sym_super_assignment] = STATE(453),
    [sym_right_assignment] = STATE(453),
    [sym_brace_list] = STATE(453),
    [sym_paren_list] = STATE(453),
    [sym_subset] = STATE(453),
    [sym_subset2] = STATE(453),
    [sym_dollar] = STATE(453),
    [sym_slot] = STATE(453),
    [sym_namespace_get] = STATE(453),
    [sym_namespace_get_internal] = STATE(453),
    [sym_unary] = STATE(453),
    [sym_binary] = STATE(453),
    [sym_na] = STATE(453),
    [sym__expression] = STATE(453),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(453),
    [sym_string] = STATE(453),
    [anon_sym_SEMI] = ACTIONS(1856),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1858),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1858),
    [sym_next] = ACTIONS(1858),
    [sym_true] = ACTIONS(1858),
    [sym_false] = ACTIONS(1858),
    [sym_null] = ACTIONS(1858),
    [sym_inf] = ACTIONS(1858),
    [sym_nan] = ACTIONS(1858),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1856),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [351] = {
    [sym_function_definition] = STATE(454),
    [sym_if] = STATE(454),
    [sym_while] = STATE(454),
    [sym_repeat] = STATE(454),
    [sym_for] = STATE(454),
    [sym_switch] = STATE(454),
    [sym_call] = STATE(454),
    [sym__assignment] = STATE(454),
    [sym_left_assignment] = STATE(454),
    [sym_left_assignment2] = STATE(454),
    [sym_equals_assignment] = STATE(454),
    [sym_super_assignment] = STATE(454),
    [sym_right_assignment] = STATE(454),
    [sym_brace_list] = STATE(454),
    [sym_paren_list] = STATE(454),
    [sym_subset] = STATE(454),
    [sym_subset2] = STATE(454),
    [sym_dollar] = STATE(454),
    [sym_slot] = STATE(454),
    [sym_namespace_get] = STATE(454),
    [sym_namespace_get_internal] = STATE(454),
    [sym_unary] = STATE(454),
    [sym_binary] = STATE(454),
    [sym_na] = STATE(454),
    [sym__expression] = STATE(454),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(454),
    [sym_string] = STATE(454),
    [anon_sym_SEMI] = ACTIONS(1860),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1862),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1862),
    [sym_next] = ACTIONS(1862),
    [sym_true] = ACTIONS(1862),
    [sym_false] = ACTIONS(1862),
    [sym_null] = ACTIONS(1862),
    [sym_inf] = ACTIONS(1862),
    [sym_nan] = ACTIONS(1862),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1860),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [352] = {
    [sym_function_definition] = STATE(456),
    [sym_if] = STATE(456),
    [sym_while] = STATE(456),
    [sym_repeat] = STATE(456),
    [sym_for] = STATE(456),
    [sym_switch] = STATE(456),
    [sym_call] = STATE(456),
    [sym__assignment] = STATE(456),
    [sym_left_assignment] = STATE(456),
    [sym_left_assignment2] = STATE(456),
    [sym_equals_assignment] = STATE(456),
    [sym_super_assignment] = STATE(456),
    [sym_right_assignment] = STATE(456),
    [sym_brace_list] = STATE(456),
    [sym_paren_list] = STATE(456),
    [sym_subset] = STATE(456),
    [sym_subset2] = STATE(456),
    [sym_dollar] = STATE(456),
    [sym_slot] = STATE(456),
    [sym_namespace_get] = STATE(456),
    [sym_namespace_get_internal] = STATE(456),
    [sym_unary] = STATE(456),
    [sym_binary] = STATE(456),
    [sym_na] = STATE(456),
    [sym__expression] = STATE(456),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(456),
    [sym_string] = STATE(456),
    [anon_sym_SEMI] = ACTIONS(1864),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1866),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1866),
    [sym_next] = ACTIONS(1866),
    [sym_true] = ACTIONS(1866),
    [sym_false] = ACTIONS(1866),
    [sym_null] = ACTIONS(1866),
    [sym_inf] = ACTIONS(1866),
    [sym_nan] = ACTIONS(1866),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1864),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [353] = {
    [sym_function_definition] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(107),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(462),
    [anon_sym_SEMI] = ACTIONS(1868),
    [anon_sym_function] = ACTIONS(1366),
    [anon_sym_if] = ACTIONS(1368),
    [anon_sym_LPAREN] = ACTIONS(1370),
    [anon_sym_while] = ACTIONS(1372),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1376),
    [anon_sym_switch] = ACTIONS(1378),
    [anon_sym_LBRACE] = ACTIONS(1380),
    [sym_dots] = ACTIONS(1870),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1386),
    [anon_sym_TILDE] = ACTIONS(1388),
    [sym_break] = ACTIONS(1870),
    [sym_next] = ACTIONS(1870),
    [sym_true] = ACTIONS(1870),
    [sym_false] = ACTIONS(1870),
    [sym_null] = ACTIONS(1870),
    [sym_inf] = ACTIONS(1870),
    [sym_nan] = ACTIONS(1870),
    [anon_sym_NA] = ACTIONS(1390),
    [anon_sym_NA_character_] = ACTIONS(1390),
    [anon_sym_NA_complex_] = ACTIONS(1390),
    [anon_sym_NA_integer_] = ACTIONS(1390),
    [anon_sym_NA_real_] = ACTIONS(1390),
    [aux_sym_identifier_token1] = ACTIONS(1392),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [sym_integer] = ACTIONS(1868),
    [sym_float] = ACTIONS(1396),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1398),
    [anon_sym_SQUOTE] = ACTIONS(1400),
  },
  [354] = {
    [sym_function_definition] = STATE(112),
    [sym_if] = STATE(112),
    [sym_while] = STATE(112),
    [sym_repeat] = STATE(112),
    [sym_for] = STATE(112),
    [sym_switch] = STATE(112),
    [sym_call] = STATE(112),
    [sym__assignment] = STATE(112),
    [sym_left_assignment] = STATE(112),
    [sym_left_assignment2] = STATE(112),
    [sym_equals_assignment] = STATE(112),
    [sym_super_assignment] = STATE(112),
    [sym_right_assignment] = STATE(112),
    [sym_brace_list] = STATE(112),
    [sym_paren_list] = STATE(112),
    [sym_subset] = STATE(112),
    [sym_subset2] = STATE(112),
    [sym_dollar] = STATE(112),
    [sym_slot] = STATE(112),
    [sym_namespace_get] = STATE(112),
    [sym_namespace_get_internal] = STATE(112),
    [sym_unary] = STATE(112),
    [sym_binary] = STATE(112),
    [sym_na] = STATE(112),
    [sym__expression] = STATE(112),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(112),
    [sym_string] = STATE(112),
    [anon_sym_SEMI] = ACTIONS(1872),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(1874),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(1874),
    [sym_next] = ACTIONS(1874),
    [sym_true] = ACTIONS(1874),
    [sym_false] = ACTIONS(1874),
    [sym_null] = ACTIONS(1874),
    [sym_inf] = ACTIONS(1874),
    [sym_nan] = ACTIONS(1874),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(1872),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [355] = {
    [sym_function_definition] = STATE(113),
    [sym_if] = STATE(113),
    [sym_while] = STATE(113),
    [sym_repeat] = STATE(113),
    [sym_for] = STATE(113),
    [sym_switch] = STATE(113),
    [sym_call] = STATE(113),
    [sym__assignment] = STATE(113),
    [sym_left_assignment] = STATE(113),
    [sym_left_assignment2] = STATE(113),
    [sym_equals_assignment] = STATE(113),
    [sym_super_assignment] = STATE(113),
    [sym_right_assignment] = STATE(113),
    [sym_brace_list] = STATE(113),
    [sym_paren_list] = STATE(113),
    [sym_subset] = STATE(113),
    [sym_subset2] = STATE(113),
    [sym_dollar] = STATE(113),
    [sym_slot] = STATE(113),
    [sym_namespace_get] = STATE(113),
    [sym_namespace_get_internal] = STATE(113),
    [sym_unary] = STATE(113),
    [sym_binary] = STATE(113),
    [sym_na] = STATE(113),
    [sym__expression] = STATE(113),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(113),
    [sym_string] = STATE(113),
    [anon_sym_SEMI] = ACTIONS(1876),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(1878),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(1878),
    [sym_next] = ACTIONS(1878),
    [sym_true] = ACTIONS(1878),
    [sym_false] = ACTIONS(1878),
    [sym_null] = ACTIONS(1878),
    [sym_inf] = ACTIONS(1878),
    [sym_nan] = ACTIONS(1878),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(1876),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [356] = {
    [sym_function_definition] = STATE(114),
    [sym_if] = STATE(114),
    [sym_while] = STATE(114),
    [sym_repeat] = STATE(114),
    [sym_for] = STATE(114),
    [sym_switch] = STATE(114),
    [sym_call] = STATE(114),
    [sym__assignment] = STATE(114),
    [sym_left_assignment] = STATE(114),
    [sym_left_assignment2] = STATE(114),
    [sym_equals_assignment] = STATE(114),
    [sym_super_assignment] = STATE(114),
    [sym_right_assignment] = STATE(114),
    [sym_brace_list] = STATE(114),
    [sym_paren_list] = STATE(114),
    [sym_subset] = STATE(114),
    [sym_subset2] = STATE(114),
    [sym_dollar] = STATE(114),
    [sym_slot] = STATE(114),
    [sym_namespace_get] = STATE(114),
    [sym_namespace_get_internal] = STATE(114),
    [sym_unary] = STATE(114),
    [sym_binary] = STATE(114),
    [sym_na] = STATE(114),
    [sym__expression] = STATE(114),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(114),
    [sym_string] = STATE(114),
    [anon_sym_SEMI] = ACTIONS(1880),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(1882),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(1882),
    [sym_next] = ACTIONS(1882),
    [sym_true] = ACTIONS(1882),
    [sym_false] = ACTIONS(1882),
    [sym_null] = ACTIONS(1882),
    [sym_inf] = ACTIONS(1882),
    [sym_nan] = ACTIONS(1882),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(1880),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [357] = {
    [sym_function_definition] = STATE(115),
    [sym_if] = STATE(115),
    [sym_while] = STATE(115),
    [sym_repeat] = STATE(115),
    [sym_for] = STATE(115),
    [sym_switch] = STATE(115),
    [sym_call] = STATE(115),
    [sym__assignment] = STATE(115),
    [sym_left_assignment] = STATE(115),
    [sym_left_assignment2] = STATE(115),
    [sym_equals_assignment] = STATE(115),
    [sym_super_assignment] = STATE(115),
    [sym_right_assignment] = STATE(115),
    [sym_brace_list] = STATE(115),
    [sym_paren_list] = STATE(115),
    [sym_subset] = STATE(115),
    [sym_subset2] = STATE(115),
    [sym_dollar] = STATE(115),
    [sym_slot] = STATE(115),
    [sym_namespace_get] = STATE(115),
    [sym_namespace_get_internal] = STATE(115),
    [sym_unary] = STATE(115),
    [sym_binary] = STATE(115),
    [sym_na] = STATE(115),
    [sym__expression] = STATE(115),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(115),
    [sym_string] = STATE(115),
    [anon_sym_SEMI] = ACTIONS(1884),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(1886),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(1886),
    [sym_next] = ACTIONS(1886),
    [sym_true] = ACTIONS(1886),
    [sym_false] = ACTIONS(1886),
    [sym_null] = ACTIONS(1886),
    [sym_inf] = ACTIONS(1886),
    [sym_nan] = ACTIONS(1886),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(1884),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [358] = {
    [sym_special] = STATE(339),
    [anon_sym_LF] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(1630),
    [anon_sym_else] = ACTIONS(1888),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(1634),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_LT_DASH] = ACTIONS(1636),
    [anon_sym_COLON_EQ] = ACTIONS(1638),
    [anon_sym_LT_LT_DASH] = ACTIONS(1640),
    [anon_sym_DASH_GT] = ACTIONS(1642),
    [anon_sym_LBRACK] = ACTIONS(1644),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1646),
    [anon_sym_DOLLAR] = ACTIONS(1648),
    [anon_sym_AT] = ACTIONS(1650),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(1652),
    [anon_sym_PLUS] = ACTIONS(1652),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(1654),
    [anon_sym_STAR] = ACTIONS(1656),
    [anon_sym_SLASH] = ACTIONS(1656),
    [anon_sym_CARET] = ACTIONS(1658),
    [anon_sym_LT] = ACTIONS(1660),
    [anon_sym_GT] = ACTIONS(1660),
    [anon_sym_LT_EQ] = ACTIONS(1660),
    [anon_sym_GT_EQ] = ACTIONS(1660),
    [anon_sym_EQ_EQ] = ACTIONS(1660),
    [anon_sym_BANG_EQ] = ACTIONS(1660),
    [anon_sym_PIPE_PIPE] = ACTIONS(1662),
    [anon_sym_PIPE] = ACTIONS(1662),
    [anon_sym_AMP_AMP] = ACTIONS(1664),
    [anon_sym_AMP] = ACTIONS(1664),
    [anon_sym_COLON] = ACTIONS(1666),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [sym_integer] = ACTIONS(738),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [359] = {
    [sym_function_definition] = STATE(804),
    [sym_if] = STATE(804),
    [sym_while] = STATE(804),
    [sym_repeat] = STATE(804),
    [sym_for] = STATE(804),
    [sym_switch] = STATE(804),
    [sym_call] = STATE(804),
    [sym__assignment] = STATE(804),
    [sym_left_assignment] = STATE(804),
    [sym_left_assignment2] = STATE(804),
    [sym_equals_assignment] = STATE(804),
    [sym_super_assignment] = STATE(804),
    [sym_right_assignment] = STATE(804),
    [sym_brace_list] = STATE(804),
    [sym_paren_list] = STATE(804),
    [sym_subset] = STATE(804),
    [sym_subset2] = STATE(804),
    [sym_dollar] = STATE(804),
    [sym_slot] = STATE(804),
    [sym_namespace_get] = STATE(804),
    [sym_namespace_get_internal] = STATE(804),
    [sym_unary] = STATE(804),
    [sym_binary] = STATE(804),
    [sym_na] = STATE(804),
    [sym__expression] = STATE(804),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(804),
    [sym_string] = STATE(804),
    [anon_sym_SEMI] = ACTIONS(1890),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1892),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1892),
    [sym_next] = ACTIONS(1892),
    [sym_true] = ACTIONS(1892),
    [sym_false] = ACTIONS(1892),
    [sym_null] = ACTIONS(1892),
    [sym_inf] = ACTIONS(1892),
    [sym_nan] = ACTIONS(1892),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1890),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [360] = {
    [sym_function_definition] = STATE(802),
    [sym_if] = STATE(802),
    [sym_while] = STATE(802),
    [sym_repeat] = STATE(802),
    [sym_for] = STATE(802),
    [sym_switch] = STATE(802),
    [sym_call] = STATE(802),
    [sym__assignment] = STATE(802),
    [sym_left_assignment] = STATE(802),
    [sym_left_assignment2] = STATE(802),
    [sym_equals_assignment] = STATE(802),
    [sym_super_assignment] = STATE(802),
    [sym_right_assignment] = STATE(802),
    [sym_brace_list] = STATE(802),
    [sym_paren_list] = STATE(802),
    [sym_subset] = STATE(802),
    [sym_subset2] = STATE(802),
    [sym_dollar] = STATE(802),
    [sym_slot] = STATE(802),
    [sym_namespace_get] = STATE(802),
    [sym_namespace_get_internal] = STATE(802),
    [sym_unary] = STATE(802),
    [sym_binary] = STATE(802),
    [sym_na] = STATE(802),
    [sym__expression] = STATE(802),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(802),
    [sym_string] = STATE(802),
    [anon_sym_SEMI] = ACTIONS(1894),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1896),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1896),
    [sym_next] = ACTIONS(1896),
    [sym_true] = ACTIONS(1896),
    [sym_false] = ACTIONS(1896),
    [sym_null] = ACTIONS(1896),
    [sym_inf] = ACTIONS(1896),
    [sym_nan] = ACTIONS(1896),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1894),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [361] = {
    [sym_function_definition] = STATE(798),
    [sym_if] = STATE(798),
    [sym_while] = STATE(798),
    [sym_repeat] = STATE(798),
    [sym_for] = STATE(798),
    [sym_switch] = STATE(798),
    [sym_call] = STATE(798),
    [sym__assignment] = STATE(798),
    [sym_left_assignment] = STATE(798),
    [sym_left_assignment2] = STATE(798),
    [sym_equals_assignment] = STATE(798),
    [sym_super_assignment] = STATE(798),
    [sym_right_assignment] = STATE(798),
    [sym_brace_list] = STATE(798),
    [sym_paren_list] = STATE(798),
    [sym_subset] = STATE(798),
    [sym_subset2] = STATE(798),
    [sym_dollar] = STATE(798),
    [sym_slot] = STATE(798),
    [sym_namespace_get] = STATE(798),
    [sym_namespace_get_internal] = STATE(798),
    [sym_unary] = STATE(798),
    [sym_binary] = STATE(798),
    [sym_na] = STATE(798),
    [sym__expression] = STATE(798),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(798),
    [sym_string] = STATE(798),
    [anon_sym_SEMI] = ACTIONS(1898),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1900),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1900),
    [sym_next] = ACTIONS(1900),
    [sym_true] = ACTIONS(1900),
    [sym_false] = ACTIONS(1900),
    [sym_null] = ACTIONS(1900),
    [sym_inf] = ACTIONS(1900),
    [sym_nan] = ACTIONS(1900),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1898),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [362] = {
    [sym_function_definition] = STATE(795),
    [sym_if] = STATE(795),
    [sym_while] = STATE(795),
    [sym_repeat] = STATE(795),
    [sym_for] = STATE(795),
    [sym_switch] = STATE(795),
    [sym_call] = STATE(795),
    [sym__assignment] = STATE(795),
    [sym_left_assignment] = STATE(795),
    [sym_left_assignment2] = STATE(795),
    [sym_equals_assignment] = STATE(795),
    [sym_super_assignment] = STATE(795),
    [sym_right_assignment] = STATE(795),
    [sym_brace_list] = STATE(795),
    [sym_paren_list] = STATE(795),
    [sym_subset] = STATE(795),
    [sym_subset2] = STATE(795),
    [sym_dollar] = STATE(795),
    [sym_slot] = STATE(795),
    [sym_namespace_get] = STATE(795),
    [sym_namespace_get_internal] = STATE(795),
    [sym_unary] = STATE(795),
    [sym_binary] = STATE(795),
    [sym_na] = STATE(795),
    [sym__expression] = STATE(795),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(795),
    [sym_string] = STATE(795),
    [anon_sym_SEMI] = ACTIONS(1902),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1904),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1904),
    [sym_next] = ACTIONS(1904),
    [sym_true] = ACTIONS(1904),
    [sym_false] = ACTIONS(1904),
    [sym_null] = ACTIONS(1904),
    [sym_inf] = ACTIONS(1904),
    [sym_nan] = ACTIONS(1904),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1902),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [363] = {
    [sym_special] = STATE(478),
    [ts_builtin_sym_end] = ACTIONS(736),
    [anon_sym_LF] = ACTIONS(738),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(738),
    [anon_sym_if] = ACTIONS(738),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(1906),
    [anon_sym_while] = ACTIONS(738),
    [anon_sym_repeat] = ACTIONS(738),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_switch] = ACTIONS(738),
    [anon_sym_EQ] = ACTIONS(870),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_LT_DASH] = ACTIONS(872),
    [anon_sym_COLON_EQ] = ACTIONS(874),
    [anon_sym_LT_LT_DASH] = ACTIONS(876),
    [anon_sym_DASH_GT] = ACTIONS(878),
    [anon_sym_LBRACK] = ACTIONS(880),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(882),
    [anon_sym_DOLLAR] = ACTIONS(884),
    [anon_sym_AT] = ACTIONS(886),
    [sym_dots] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(888),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(890),
    [anon_sym_STAR] = ACTIONS(892),
    [anon_sym_SLASH] = ACTIONS(892),
    [anon_sym_CARET] = ACTIONS(894),
    [anon_sym_LT] = ACTIONS(896),
    [anon_sym_GT] = ACTIONS(896),
    [anon_sym_LT_EQ] = ACTIONS(896),
    [anon_sym_GT_EQ] = ACTIONS(896),
    [anon_sym_EQ_EQ] = ACTIONS(896),
    [anon_sym_BANG_EQ] = ACTIONS(896),
    [anon_sym_PIPE_PIPE] = ACTIONS(898),
    [anon_sym_PIPE] = ACTIONS(898),
    [anon_sym_AMP_AMP] = ACTIONS(900),
    [anon_sym_AMP] = ACTIONS(900),
    [anon_sym_COLON] = ACTIONS(902),
    [sym_break] = ACTIONS(738),
    [sym_next] = ACTIONS(738),
    [sym_true] = ACTIONS(738),
    [sym_false] = ACTIONS(738),
    [sym_null] = ACTIONS(738),
    [sym_inf] = ACTIONS(738),
    [sym_nan] = ACTIONS(738),
    [anon_sym_NA] = ACTIONS(738),
    [anon_sym_NA_character_] = ACTIONS(738),
    [anon_sym_NA_complex_] = ACTIONS(738),
    [anon_sym_NA_integer_] = ACTIONS(738),
    [anon_sym_NA_real_] = ACTIONS(738),
    [aux_sym_identifier_token1] = ACTIONS(738),
    [anon_sym_BQUOTE] = ACTIONS(738),
    [sym_integer] = ACTIONS(738),
    [sym_float] = ACTIONS(738),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(738),
    [anon_sym_SQUOTE] = ACTIONS(738),
    [anon_sym_PERCENT] = ACTIONS(904),
  },
  [364] = {
    [sym_function_definition] = STATE(119),
    [sym_if] = STATE(119),
    [sym_while] = STATE(119),
    [sym_repeat] = STATE(119),
    [sym_for] = STATE(119),
    [sym_switch] = STATE(119),
    [sym_call] = STATE(119),
    [sym__assignment] = STATE(119),
    [sym_left_assignment] = STATE(119),
    [sym_left_assignment2] = STATE(119),
    [sym_equals_assignment] = STATE(119),
    [sym_super_assignment] = STATE(119),
    [sym_right_assignment] = STATE(119),
    [sym_brace_list] = STATE(119),
    [sym_paren_list] = STATE(119),
    [sym_subset] = STATE(119),
    [sym_subset2] = STATE(119),
    [sym_dollar] = STATE(119),
    [sym_slot] = STATE(119),
    [sym_namespace_get] = STATE(119),
    [sym_namespace_get_internal] = STATE(119),
    [sym_unary] = STATE(119),
    [sym_binary] = STATE(119),
    [sym_na] = STATE(119),
    [sym__expression] = STATE(119),
    [sym_identifier] = STATE(83),
    [sym_complex] = STATE(119),
    [sym_string] = STATE(119),
    [anon_sym_SEMI] = ACTIONS(1908),
    [anon_sym_function] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_repeat] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(810),
    [sym_dots] = ACTIONS(1910),
    [anon_sym_DASH] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(814),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(818),
    [sym_break] = ACTIONS(1910),
    [sym_next] = ACTIONS(1910),
    [sym_true] = ACTIONS(1910),
    [sym_false] = ACTIONS(1910),
    [sym_null] = ACTIONS(1910),
    [sym_inf] = ACTIONS(1910),
    [sym_nan] = ACTIONS(1910),
    [anon_sym_NA] = ACTIONS(820),
    [anon_sym_NA_character_] = ACTIONS(820),
    [anon_sym_NA_complex_] = ACTIONS(820),
    [anon_sym_NA_integer_] = ACTIONS(820),
    [anon_sym_NA_real_] = ACTIONS(820),
    [aux_sym_identifier_token1] = ACTIONS(822),
    [anon_sym_BQUOTE] = ACTIONS(824),
    [sym_integer] = ACTIONS(1908),
    [sym_float] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(830),
  },
  [365] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_function] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_EQ] = ACTIONS(1182),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_LT_DASH] = ACTIONS(1184),
    [anon_sym_COLON_EQ] = ACTIONS(1186),
    [anon_sym_LT_LT_DASH] = ACTIONS(1188),
    [anon_sym_DASH_GT] = ACTIONS(1190),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(746),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(1214),
    [anon_sym_PIPE] = ACTIONS(1216),
    [anon_sym_AMP_AMP] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(748),
    [sym_next] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_inf] = ACTIONS(748),
    [sym_nan] = ACTIONS(748),
    [anon_sym_NA] = ACTIONS(748),
    [anon_sym_NA_character_] = ACTIONS(748),
    [anon_sym_NA_complex_] = ACTIONS(748),
    [anon_sym_NA_integer_] = ACTIONS(748),
    [anon_sym_NA_real_] = ACTIONS(748),
    [aux_sym_identifier_token1] = ACTIONS(748),
    [anon_sym_BQUOTE] = ACTIONS(746),
    [sym_integer] = ACTIONS(746),
    [sym_float] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE] = ACTIONS(746),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [366] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(742),
    [anon_sym_function] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(744),
    [anon_sym_while] = ACTIONS(744),
    [anon_sym_repeat] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_switch] = ACTIONS(744),
    [anon_sym_COMMA] = ACTIONS(742),
    [anon_sym_EQ] = ACTIONS(1182),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_LT_DASH] = ACTIONS(1184),
    [anon_sym_COLON_EQ] = ACTIONS(1186),
    [anon_sym_LT_LT_DASH] = ACTIONS(1188),
    [anon_sym_DASH_GT] = ACTIONS(1190),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(742),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(744),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(744),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(1214),
    [anon_sym_PIPE] = ACTIONS(1216),
    [anon_sym_AMP_AMP] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(744),
    [sym_next] = ACTIONS(744),
    [sym_true] = ACTIONS(744),
    [sym_false] = ACTIONS(744),
    [sym_null] = ACTIONS(744),
    [sym_inf] = ACTIONS(744),
    [sym_nan] = ACTIONS(744),
    [anon_sym_NA] = ACTIONS(744),
    [anon_sym_NA_character_] = ACTIONS(744),
    [anon_sym_NA_complex_] = ACTIONS(744),
    [anon_sym_NA_integer_] = ACTIONS(744),
    [anon_sym_NA_real_] = ACTIONS(744),
    [aux_sym_identifier_token1] = ACTIONS(744),
    [anon_sym_BQUOTE] = ACTIONS(742),
    [sym_integer] = ACTIONS(742),
    [sym_float] = ACTIONS(744),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(742),
    [anon_sym_SQUOTE] = ACTIONS(742),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [367] = {
    [sym_function_definition] = STATE(808),
    [sym_if] = STATE(808),
    [sym_while] = STATE(808),
    [sym_repeat] = STATE(808),
    [sym_for] = STATE(808),
    [sym_switch] = STATE(808),
    [sym_call] = STATE(808),
    [sym__assignment] = STATE(808),
    [sym_left_assignment] = STATE(808),
    [sym_left_assignment2] = STATE(808),
    [sym_equals_assignment] = STATE(808),
    [sym_super_assignment] = STATE(808),
    [sym_right_assignment] = STATE(808),
    [sym_brace_list] = STATE(808),
    [sym_paren_list] = STATE(808),
    [sym_subset] = STATE(808),
    [sym_subset2] = STATE(808),
    [sym_dollar] = STATE(808),
    [sym_slot] = STATE(808),
    [sym_namespace_get] = STATE(808),
    [sym_namespace_get_internal] = STATE(808),
    [sym_unary] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_na] = STATE(808),
    [sym__expression] = STATE(808),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(808),
    [sym_string] = STATE(808),
    [anon_sym_SEMI] = ACTIONS(1912),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1914),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1914),
    [sym_next] = ACTIONS(1914),
    [sym_true] = ACTIONS(1914),
    [sym_false] = ACTIONS(1914),
    [sym_null] = ACTIONS(1914),
    [sym_inf] = ACTIONS(1914),
    [sym_nan] = ACTIONS(1914),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1912),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [368] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(728),
    [anon_sym_function] = ACTIONS(730),
    [anon_sym_if] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(730),
    [anon_sym_while] = ACTIONS(730),
    [anon_sym_repeat] = ACTIONS(730),
    [anon_sym_for] = ACTIONS(730),
    [anon_sym_switch] = ACTIONS(730),
    [anon_sym_COMMA] = ACTIONS(728),
    [anon_sym_EQ] = ACTIONS(1182),
    [anon_sym_LBRACE] = ACTIONS(728),
    [anon_sym_LT_DASH] = ACTIONS(1184),
    [anon_sym_COLON_EQ] = ACTIONS(1186),
    [anon_sym_LT_LT_DASH] = ACTIONS(1188),
    [anon_sym_DASH_GT] = ACTIONS(1190),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(728),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_TILDE] = ACTIONS(1204),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(1214),
    [anon_sym_PIPE] = ACTIONS(1216),
    [anon_sym_AMP_AMP] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(730),
    [sym_next] = ACTIONS(730),
    [sym_true] = ACTIONS(730),
    [sym_false] = ACTIONS(730),
    [sym_null] = ACTIONS(730),
    [sym_inf] = ACTIONS(730),
    [sym_nan] = ACTIONS(730),
    [anon_sym_NA] = ACTIONS(730),
    [anon_sym_NA_character_] = ACTIONS(730),
    [anon_sym_NA_complex_] = ACTIONS(730),
    [anon_sym_NA_integer_] = ACTIONS(730),
    [anon_sym_NA_real_] = ACTIONS(730),
    [aux_sym_identifier_token1] = ACTIONS(730),
    [anon_sym_BQUOTE] = ACTIONS(728),
    [sym_integer] = ACTIONS(728),
    [sym_float] = ACTIONS(730),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [369] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [370] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(634),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [371] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [372] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [373] = {
    [sym_function_definition] = STATE(810),
    [sym_if] = STATE(810),
    [sym_while] = STATE(810),
    [sym_repeat] = STATE(810),
    [sym_for] = STATE(810),
    [sym_switch] = STATE(810),
    [sym_call] = STATE(810),
    [sym__assignment] = STATE(810),
    [sym_left_assignment] = STATE(810),
    [sym_left_assignment2] = STATE(810),
    [sym_equals_assignment] = STATE(810),
    [sym_super_assignment] = STATE(810),
    [sym_right_assignment] = STATE(810),
    [sym_brace_list] = STATE(810),
    [sym_paren_list] = STATE(810),
    [sym_subset] = STATE(810),
    [sym_subset2] = STATE(810),
    [sym_dollar] = STATE(810),
    [sym_slot] = STATE(810),
    [sym_namespace_get] = STATE(810),
    [sym_namespace_get_internal] = STATE(810),
    [sym_unary] = STATE(810),
    [sym_binary] = STATE(810),
    [sym_na] = STATE(810),
    [sym__expression] = STATE(810),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(810),
    [sym_string] = STATE(810),
    [anon_sym_SEMI] = ACTIONS(1916),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1918),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1918),
    [sym_next] = ACTIONS(1918),
    [sym_true] = ACTIONS(1918),
    [sym_false] = ACTIONS(1918),
    [sym_null] = ACTIONS(1918),
    [sym_inf] = ACTIONS(1918),
    [sym_nan] = ACTIONS(1918),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1916),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [374] = {
    [sym_function_definition] = STATE(811),
    [sym_if] = STATE(811),
    [sym_while] = STATE(811),
    [sym_repeat] = STATE(811),
    [sym_for] = STATE(811),
    [sym_switch] = STATE(811),
    [sym_call] = STATE(811),
    [sym__assignment] = STATE(811),
    [sym_left_assignment] = STATE(811),
    [sym_left_assignment2] = STATE(811),
    [sym_equals_assignment] = STATE(811),
    [sym_super_assignment] = STATE(811),
    [sym_right_assignment] = STATE(811),
    [sym_brace_list] = STATE(811),
    [sym_paren_list] = STATE(811),
    [sym_subset] = STATE(811),
    [sym_subset2] = STATE(811),
    [sym_dollar] = STATE(811),
    [sym_slot] = STATE(811),
    [sym_namespace_get] = STATE(811),
    [sym_namespace_get_internal] = STATE(811),
    [sym_unary] = STATE(811),
    [sym_binary] = STATE(811),
    [sym_na] = STATE(811),
    [sym__expression] = STATE(811),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(811),
    [sym_string] = STATE(811),
    [anon_sym_SEMI] = ACTIONS(1920),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1922),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1922),
    [sym_next] = ACTIONS(1922),
    [sym_true] = ACTIONS(1922),
    [sym_false] = ACTIONS(1922),
    [sym_null] = ACTIONS(1922),
    [sym_inf] = ACTIONS(1922),
    [sym_nan] = ACTIONS(1922),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1920),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [375] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [376] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(634),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(632),
  },
  [377] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_SLASH] = ACTIONS(632),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [378] = {
    [sym_function_definition] = STATE(315),
    [sym_if] = STATE(315),
    [sym_while] = STATE(315),
    [sym_repeat] = STATE(315),
    [sym_for] = STATE(315),
    [sym_switch] = STATE(315),
    [sym_call] = STATE(315),
    [sym__assignment] = STATE(315),
    [sym_left_assignment] = STATE(315),
    [sym_left_assignment2] = STATE(315),
    [sym_equals_assignment] = STATE(315),
    [sym_super_assignment] = STATE(315),
    [sym_right_assignment] = STATE(315),
    [sym_brace_list] = STATE(315),
    [sym_paren_list] = STATE(315),
    [sym_subset] = STATE(315),
    [sym_subset2] = STATE(315),
    [sym_dollar] = STATE(315),
    [sym_slot] = STATE(315),
    [sym_namespace_get] = STATE(315),
    [sym_namespace_get_internal] = STATE(315),
    [sym_unary] = STATE(315),
    [sym_binary] = STATE(315),
    [sym_na] = STATE(315),
    [sym__expression] = STATE(315),
    [sym_identifier] = STATE(118),
    [sym_complex] = STATE(315),
    [sym_string] = STATE(315),
    [anon_sym_SEMI] = ACTIONS(1924),
    [anon_sym_function] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1236),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1240),
    [anon_sym_repeat] = ACTIONS(1242),
    [anon_sym_for] = ACTIONS(1244),
    [anon_sym_switch] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(1248),
    [sym_dots] = ACTIONS(1926),
    [anon_sym_DASH] = ACTIONS(1252),
    [anon_sym_PLUS] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(1254),
    [anon_sym_TILDE] = ACTIONS(1256),
    [sym_break] = ACTIONS(1926),
    [sym_next] = ACTIONS(1926),
    [sym_true] = ACTIONS(1926),
    [sym_false] = ACTIONS(1926),
    [sym_null] = ACTIONS(1926),
    [sym_inf] = ACTIONS(1926),
    [sym_nan] = ACTIONS(1926),
    [anon_sym_NA] = ACTIONS(1258),
    [anon_sym_NA_character_] = ACTIONS(1258),
    [anon_sym_NA_complex_] = ACTIONS(1258),
    [anon_sym_NA_integer_] = ACTIONS(1258),
    [anon_sym_NA_real_] = ACTIONS(1258),
    [aux_sym_identifier_token1] = ACTIONS(1260),
    [anon_sym_BQUOTE] = ACTIONS(1262),
    [sym_integer] = ACTIONS(1924),
    [sym_float] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
  },
  [379] = {
    [sym_function_definition] = STATE(317),
    [sym_if] = STATE(317),
    [sym_while] = STATE(317),
    [sym_repeat] = STATE(317),
    [sym_for] = STATE(317),
    [sym_switch] = STATE(317),
    [sym_call] = STATE(317),
    [sym__assignment] = STATE(317),
    [sym_left_assignment] = STATE(317),
    [sym_left_assignment2] = STATE(317),
    [sym_equals_assignment] = STATE(317),
    [sym_super_assignment] = STATE(317),
    [sym_right_assignment] = STATE(317),
    [sym_brace_list] = STATE(317),
    [sym_paren_list] = STATE(317),
    [sym_subset] = STATE(317),
    [sym_subset2] = STATE(317),
    [sym_dollar] = STATE(317),
    [sym_slot] = STATE(317),
    [sym_namespace_get] = STATE(317),
    [sym_namespace_get_internal] = STATE(317),
    [sym_unary] = STATE(317),
    [sym_binary] = STATE(317),
    [sym_na] = STATE(317),
    [sym__expression] = STATE(317),
    [sym_identifier] = STATE(118),
    [sym_complex] = STATE(317),
    [sym_string] = STATE(317),
    [anon_sym_SEMI] = ACTIONS(1928),
    [anon_sym_function] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1236),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1240),
    [anon_sym_repeat] = ACTIONS(1242),
    [anon_sym_for] = ACTIONS(1244),
    [anon_sym_switch] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(1248),
    [sym_dots] = ACTIONS(1930),
    [anon_sym_DASH] = ACTIONS(1252),
    [anon_sym_PLUS] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(1254),
    [anon_sym_TILDE] = ACTIONS(1256),
    [sym_break] = ACTIONS(1930),
    [sym_next] = ACTIONS(1930),
    [sym_true] = ACTIONS(1930),
    [sym_false] = ACTIONS(1930),
    [sym_null] = ACTIONS(1930),
    [sym_inf] = ACTIONS(1930),
    [sym_nan] = ACTIONS(1930),
    [anon_sym_NA] = ACTIONS(1258),
    [anon_sym_NA_character_] = ACTIONS(1258),
    [anon_sym_NA_complex_] = ACTIONS(1258),
    [anon_sym_NA_integer_] = ACTIONS(1258),
    [anon_sym_NA_real_] = ACTIONS(1258),
    [aux_sym_identifier_token1] = ACTIONS(1260),
    [anon_sym_BQUOTE] = ACTIONS(1262),
    [sym_integer] = ACTIONS(1928),
    [sym_float] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
  },
  [380] = {
    [sym_function_definition] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_repeat] = STATE(318),
    [sym_for] = STATE(318),
    [sym_switch] = STATE(318),
    [sym_call] = STATE(318),
    [sym__assignment] = STATE(318),
    [sym_left_assignment] = STATE(318),
    [sym_left_assignment2] = STATE(318),
    [sym_equals_assignment] = STATE(318),
    [sym_super_assignment] = STATE(318),
    [sym_right_assignment] = STATE(318),
    [sym_brace_list] = STATE(318),
    [sym_paren_list] = STATE(318),
    [sym_subset] = STATE(318),
    [sym_subset2] = STATE(318),
    [sym_dollar] = STATE(318),
    [sym_slot] = STATE(318),
    [sym_namespace_get] = STATE(318),
    [sym_namespace_get_internal] = STATE(318),
    [sym_unary] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_na] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_identifier] = STATE(118),
    [sym_complex] = STATE(318),
    [sym_string] = STATE(318),
    [anon_sym_SEMI] = ACTIONS(1932),
    [anon_sym_function] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1236),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1240),
    [anon_sym_repeat] = ACTIONS(1242),
    [anon_sym_for] = ACTIONS(1244),
    [anon_sym_switch] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(1248),
    [sym_dots] = ACTIONS(1934),
    [anon_sym_DASH] = ACTIONS(1252),
    [anon_sym_PLUS] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(1254),
    [anon_sym_TILDE] = ACTIONS(1256),
    [sym_break] = ACTIONS(1934),
    [sym_next] = ACTIONS(1934),
    [sym_true] = ACTIONS(1934),
    [sym_false] = ACTIONS(1934),
    [sym_null] = ACTIONS(1934),
    [sym_inf] = ACTIONS(1934),
    [sym_nan] = ACTIONS(1934),
    [anon_sym_NA] = ACTIONS(1258),
    [anon_sym_NA_character_] = ACTIONS(1258),
    [anon_sym_NA_complex_] = ACTIONS(1258),
    [anon_sym_NA_integer_] = ACTIONS(1258),
    [anon_sym_NA_real_] = ACTIONS(1258),
    [aux_sym_identifier_token1] = ACTIONS(1260),
    [anon_sym_BQUOTE] = ACTIONS(1262),
    [sym_integer] = ACTIONS(1932),
    [sym_float] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
  },
  [381] = {
    [sym_function_definition] = STATE(319),
    [sym_if] = STATE(319),
    [sym_while] = STATE(319),
    [sym_repeat] = STATE(319),
    [sym_for] = STATE(319),
    [sym_switch] = STATE(319),
    [sym_call] = STATE(319),
    [sym__assignment] = STATE(319),
    [sym_left_assignment] = STATE(319),
    [sym_left_assignment2] = STATE(319),
    [sym_equals_assignment] = STATE(319),
    [sym_super_assignment] = STATE(319),
    [sym_right_assignment] = STATE(319),
    [sym_brace_list] = STATE(319),
    [sym_paren_list] = STATE(319),
    [sym_subset] = STATE(319),
    [sym_subset2] = STATE(319),
    [sym_dollar] = STATE(319),
    [sym_slot] = STATE(319),
    [sym_namespace_get] = STATE(319),
    [sym_namespace_get_internal] = STATE(319),
    [sym_unary] = STATE(319),
    [sym_binary] = STATE(319),
    [sym_na] = STATE(319),
    [sym__expression] = STATE(319),
    [sym_identifier] = STATE(118),
    [sym_complex] = STATE(319),
    [sym_string] = STATE(319),
    [anon_sym_SEMI] = ACTIONS(1936),
    [anon_sym_function] = ACTIONS(1234),
    [anon_sym_if] = ACTIONS(1236),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_while] = ACTIONS(1240),
    [anon_sym_repeat] = ACTIONS(1242),
    [anon_sym_for] = ACTIONS(1244),
    [anon_sym_switch] = ACTIONS(1246),
    [anon_sym_LBRACE] = ACTIONS(1248),
    [sym_dots] = ACTIONS(1938),
    [anon_sym_DASH] = ACTIONS(1252),
    [anon_sym_PLUS] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(1254),
    [anon_sym_TILDE] = ACTIONS(1256),
    [sym_break] = ACTIONS(1938),
    [sym_next] = ACTIONS(1938),
    [sym_true] = ACTIONS(1938),
    [sym_false] = ACTIONS(1938),
    [sym_null] = ACTIONS(1938),
    [sym_inf] = ACTIONS(1938),
    [sym_nan] = ACTIONS(1938),
    [anon_sym_NA] = ACTIONS(1258),
    [anon_sym_NA_character_] = ACTIONS(1258),
    [anon_sym_NA_complex_] = ACTIONS(1258),
    [anon_sym_NA_integer_] = ACTIONS(1258),
    [anon_sym_NA_real_] = ACTIONS(1258),
    [aux_sym_identifier_token1] = ACTIONS(1260),
    [anon_sym_BQUOTE] = ACTIONS(1262),
    [sym_integer] = ACTIONS(1936),
    [sym_float] = ACTIONS(1264),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
  },
  [382] = {
    [anon_sym_SEMI] = ACTIONS(1940),
    [anon_sym_function] = ACTIONS(1942),
    [anon_sym_if] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1940),
    [anon_sym_RPAREN] = ACTIONS(1940),
    [anon_sym_else] = ACTIONS(1942),
    [anon_sym_while] = ACTIONS(1942),
    [anon_sym_repeat] = ACTIONS(1942),
    [anon_sym_for] = ACTIONS(1942),
    [anon_sym_switch] = ACTIONS(1942),
    [anon_sym_COMMA] = ACTIONS(1940),
    [anon_sym_EQ] = ACTIONS(1942),
    [anon_sym_LBRACE] = ACTIONS(1940),
    [anon_sym_LT_DASH] = ACTIONS(1940),
    [anon_sym_COLON_EQ] = ACTIONS(1940),
    [anon_sym_LT_LT_DASH] = ACTIONS(1940),
    [anon_sym_DASH_GT] = ACTIONS(1940),
    [anon_sym_LBRACK] = ACTIONS(1942),
    [anon_sym_RBRACK] = ACTIONS(1940),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1940),
    [anon_sym_DOLLAR] = ACTIONS(1940),
    [anon_sym_AT] = ACTIONS(1940),
    [sym_dots] = ACTIONS(1942),
    [anon_sym_DASH] = ACTIONS(1942),
    [anon_sym_PLUS] = ACTIONS(1940),
    [anon_sym_BANG] = ACTIONS(1942),
    [anon_sym_TILDE] = ACTIONS(1940),
    [anon_sym_STAR] = ACTIONS(1940),
    [anon_sym_SLASH] = ACTIONS(1940),
    [anon_sym_CARET] = ACTIONS(1940),
    [anon_sym_LT] = ACTIONS(1942),
    [anon_sym_GT] = ACTIONS(1942),
    [anon_sym_LT_EQ] = ACTIONS(1940),
    [anon_sym_GT_EQ] = ACTIONS(1940),
    [anon_sym_EQ_EQ] = ACTIONS(1940),
    [anon_sym_BANG_EQ] = ACTIONS(1940),
    [anon_sym_PIPE_PIPE] = ACTIONS(1940),
    [anon_sym_PIPE] = ACTIONS(1942),
    [anon_sym_AMP_AMP] = ACTIONS(1940),
    [anon_sym_AMP] = ACTIONS(1942),
    [anon_sym_COLON] = ACTIONS(1942),
    [sym_break] = ACTIONS(1942),
    [sym_next] = ACTIONS(1942),
    [sym_true] = ACTIONS(1942),
    [sym_false] = ACTIONS(1942),
    [sym_null] = ACTIONS(1942),
    [sym_inf] = ACTIONS(1942),
    [sym_nan] = ACTIONS(1942),
    [anon_sym_NA] = ACTIONS(1942),
    [anon_sym_NA_character_] = ACTIONS(1942),
    [anon_sym_NA_complex_] = ACTIONS(1942),
    [anon_sym_NA_integer_] = ACTIONS(1942),
    [anon_sym_NA_real_] = ACTIONS(1942),
    [aux_sym_identifier_token1] = ACTIONS(1942),
    [anon_sym_BQUOTE] = ACTIONS(1940),
    [sym_integer] = ACTIONS(1940),
    [sym_float] = ACTIONS(1942),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1940),
    [anon_sym_SQUOTE] = ACTIONS(1940),
    [anon_sym_PERCENT] = ACTIONS(1940),
  },
  [383] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_PLUS] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [anon_sym_LT_EQ] = ACTIONS(1212),
    [anon_sym_GT_EQ] = ACTIONS(1212),
    [anon_sym_EQ_EQ] = ACTIONS(1212),
    [anon_sym_BANG_EQ] = ACTIONS(1212),
    [anon_sym_PIPE_PIPE] = ACTIONS(1214),
    [anon_sym_PIPE] = ACTIONS(1216),
    [anon_sym_AMP_AMP] = ACTIONS(1218),
    [anon_sym_AMP] = ACTIONS(1220),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [384] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [anon_sym_LF] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_repeat] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_EQ] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_LT_DASH] = ACTIONS(612),
    [anon_sym_COLON_EQ] = ACTIONS(612),
    [anon_sym_LT_LT_DASH] = ACTIONS(612),
    [anon_sym_DASH_GT] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(612),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(612),
    [anon_sym_DOLLAR] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [sym_dots] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_CARET] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_LT_EQ] = ACTIONS(612),
    [anon_sym_GT_EQ] = ACTIONS(612),
    [anon_sym_EQ_EQ] = ACTIONS(612),
    [anon_sym_BANG_EQ] = ACTIONS(612),
    [anon_sym_PIPE_PIPE] = ACTIONS(612),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(612),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [sym_break] = ACTIONS(612),
    [sym_next] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_inf] = ACTIONS(612),
    [sym_nan] = ACTIONS(612),
    [anon_sym_NA] = ACTIONS(612),
    [anon_sym_NA_character_] = ACTIONS(612),
    [anon_sym_NA_complex_] = ACTIONS(612),
    [anon_sym_NA_integer_] = ACTIONS(612),
    [anon_sym_NA_real_] = ACTIONS(612),
    [aux_sym_identifier_token1] = ACTIONS(612),
    [anon_sym_BQUOTE] = ACTIONS(612),
    [sym_integer] = ACTIONS(612),
    [sym_float] = ACTIONS(612),
    [anon_sym_i] = ACTIONS(1944),
    [sym_comment] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(612),
    [anon_sym_SQUOTE] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(612),
  },
  [385] = {
    [sym_special] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(1178),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_repeat] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_LT_DASH] = ACTIONS(632),
    [anon_sym_COLON_EQ] = ACTIONS(632),
    [anon_sym_LT_LT_DASH] = ACTIONS(632),
    [anon_sym_DASH_GT] = ACTIONS(632),
    [anon_sym_LBRACK] = ACTIONS(1192),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1194),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(632),
    [anon_sym_DOLLAR] = ACTIONS(1196),
    [anon_sym_AT] = ACTIONS(1198),
    [sym_dots] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(1206),
    [anon_sym_SLASH] = ACTIONS(1206),
    [anon_sym_CARET] = ACTIONS(1208),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(1222),
    [sym_break] = ACTIONS(634),
    [sym_next] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_inf] = ACTIONS(634),
    [sym_nan] = ACTIONS(634),
    [anon_sym_NA] = ACTIONS(634),
    [anon_sym_NA_character_] = ACTIONS(634),
    [anon_sym_NA_complex_] = ACTIONS(634),
    [anon_sym_NA_integer_] = ACTIONS(634),
    [anon_sym_NA_real_] = ACTIONS(634),
    [aux_sym_identifier_token1] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_integer] = ACTIONS(632),
    [sym_float] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_PERCENT] = ACTIONS(664),
  },
  [386] = {
    [sym_function_definition] = STATE(652),
    [sym_if] = STATE(652),
    [sym_while] = STATE(652),
    [sym_repeat] = STATE(652),
    [sym_for] = STATE(652),
    [sym_switch] = STATE(652),
    [sym_call] = STATE(652),
    [sym__assignment] = STATE(652),
    [sym_left_assignment] = STATE(652),
    [sym_left_assignment2] = STATE(652),
    [sym_equals_assignment] = STATE(652),
    [sym_super_assignment] = STATE(652),
    [sym_right_assignment] = STATE(652),
    [sym_brace_list] = STATE(652),
    [sym_paren_list] = STATE(652),
    [sym_subset] = STATE(652),
    [sym_subset2] = STATE(652),
    [sym_dollar] = STATE(652),
    [sym_slot] = STATE(652),
    [sym_namespace_get] = STATE(652),
    [sym_namespace_get_internal] = STATE(652),
    [sym_unary] = STATE(652),
    [sym_binary] = STATE(652),
    [sym_na] = STATE(652),
    [sym__expression] = STATE(652),
    [sym_identifier] = STATE(506),
    [sym_complex] = STATE(652),
    [sym_string] = STATE(652),
    [anon_sym_SEMI] = ACTIONS(1946),
    [anon_sym_function] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_while] = ACTIONS(99),
    [anon_sym_repeat] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_switch] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(109),
    [sym_dots] = ACTIONS(1948),
    [anon_sym_DASH] = ACTIONS(115),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_BANG] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [sym_break] = ACTIONS(1948),
    [sym_next] = ACTIONS(1948),
    [sym_true] = ACTIONS(1948),
    [sym_false] = ACTIONS(1948),
    [sym_null] = ACTIONS(1948),
    [sym_inf] = ACTIONS(1948),
    [sym_nan] = ACTIONS(1948),
    [anon_sym_NA] = ACTIONS(123),
    [anon_sym_NA_character_] = ACTIONS(123),
    [anon_sym_NA_complex_] = ACTIONS(123),
    [anon_sym_NA_integer_] = ACTIONS(123),
    [anon_sym_NA_real_] = ACTIONS(123),
    [aux_sym_identifier_token1] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [sym_integer] = ACTIONS(1946),
    [sym_float] = ACTIONS(129),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_SQUOTE] = ACTIONS(133),
  },
  [387] = {
    [anon_sym_SEMI] = ACTIONS(1950),
    [anon_sym_function] = ACTIONS(1952),
    [anon_sym_if] = ACTIONS(1952),
    [anon_sym_LPAREN] = ACTIONS(1950),
    [anon_sym_RPAREN] = ACTIONS(1950),
    [anon_sym_else] = ACTIONS(1952),
    [anon_sym_while] = ACTIONS(1952),
    [anon_sym_repeat] = ACTIONS(1952),
    [anon_sym_for] = ACTIONS(1952),
    [anon_sym_switch] = ACTIONS(1952),
    [anon_sym_COMMA] = ACTIONS(1950),
    [anon_sym_EQ] = ACTIONS(1952),
    [anon_sym_LBRACE] = ACTIONS(1950),
    [anon_sym_LT_DASH] = ACTIONS(1950),
    [anon_sym_COLON_EQ] = ACTIONS(1950),
    [anon_sym_LT_LT_DASH] = ACTIONS(1950),
    [anon_sym_DASH_GT] = ACTIONS(1950),
    [anon_sym_LBRACK] = ACTIONS(1952),
    [anon_sym_RBRACK] = ACTIONS(1950),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1950),
    [anon_sym_DOLLAR] = ACTIONS(1950),
    [anon_sym_AT] = ACTIONS(1950),
    [sym_dots] = ACTIONS(1952),
    [anon_sym_DASH] = ACTIONS(1952),
    [anon_sym_PLUS] = ACTIONS(1950),
    [anon_sym_BANG] = ACTIONS(1952),
    [anon_sym_TILDE] = ACTIONS(1950),
    [anon_sym_STAR] = ACTIONS(1950),
    [anon_sym_SLASH] = ACTIONS(1950),
    [anon_sym_CARET] = ACTIONS(1950),
    [anon_sym_LT] = ACTIONS(1952),
    [anon_sym_GT] = ACTIONS(1952),
    [anon_sym_LT_EQ] = ACTIONS(1950),
    [anon_sym_GT_EQ] = ACTIONS(1950),
    [anon_sym_EQ_EQ] = ACTIONS(1950),
    [anon_sym_BANG_EQ] = ACTIONS(1950),
    [anon_sym_PIPE_PIPE] = ACTIONS(1950),
    [anon_sym_PIPE] = ACTIONS(1952),
    [anon_sym_AMP_AMP] = ACTIONS(1950),
    [anon_sym_AMP] = ACTIONS(1952),
    [anon_sym_COLON] = ACTIONS(1952),
    [sym_break] = ACTIONS(1952),
    [sym_next] = ACTIONS(1952),
    [sym_true] = ACTIONS(1952),
    [sym_false] = ACTIONS(1952),
    [sym_null] = ACTIONS(1952),
    [sym_inf] = ACTIONS(1952),
    [sym_nan] = ACTIONS(1952),
    [anon_sym_NA] = ACTIONS(1952),
    [anon_sym_NA_character_] = ACTIONS(1952),
    [anon_sym_NA_complex_] = ACTIONS(1952),
    [anon_sym_NA_integer_] = ACTIONS(1952),
    [anon_sym_NA_real_] = ACTIONS(1952),
    [aux_sym_identifier_token1] = ACTIONS(1952),
    [anon_sym_BQUOTE] = ACTIONS(1950),
    [sym_integer] = ACTIONS(1950),
    [sym_float] = ACTIONS(1952),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1950),
    [anon_sym_SQUOTE] = ACTIONS(1950),
    [anon_sym_PERCENT] = ACTIONS(1950),
  },
  [388] = {
    [sym_function_definition] = STATE(786),
    [sym_if] = STATE(786),
    [sym_while] = STATE(786),
    [sym_repeat] = STATE(786),
    [sym_for] = STATE(786),
    [sym_switch] = STATE(786),
    [sym_call] = STATE(786),
    [sym__assignment] = STATE(786),
    [sym_left_assignment] = STATE(786),
    [sym_left_assignment2] = STATE(786),
    [sym_equals_assignment] = STATE(786),
    [sym_super_assignment] = STATE(786),
    [sym_right_assignment] = STATE(786),
    [sym_brace_list] = STATE(786),
    [sym_paren_list] = STATE(786),
    [sym_subset] = STATE(786),
    [sym_subset2] = STATE(786),
    [sym_dollar] = STATE(786),
    [sym_slot] = STATE(786),
    [sym_namespace_get] = STATE(786),
    [sym_namespace_get_internal] = STATE(786),
    [sym_unary] = STATE(786),
    [sym_binary] = STATE(786),
    [sym_na] = STATE(786),
    [sym__expression] = STATE(786),
    [sym_identifier] = STATE(129),
    [sym_complex] = STATE(786),
    [sym_string] = STATE(786),
    [anon_sym_SEMI] = ACTIONS(1954),
    [anon_sym_function] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_repeat] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(65),
    [sym_dots] = ACTIONS(1956),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(848),
    [anon_sym_TILDE] = ACTIONS(850),
    [sym_break] = ACTIONS(1956),
    [sym_next] = ACTIONS(1956),
    [sym_true] = ACTIONS(1956),
    [sym_false] = ACTIONS(1956),
    [sym_null] = ACTIONS(1956),
    [sym_inf] = ACTIONS(1956),
    [sym_nan] = ACTIONS(1956),
    [anon_sym_NA] = ACTIONS(77),
    [anon_sym_NA_character_] = ACTIONS(77),
    [anon_sym_NA_complex_] = ACTIONS(77),
    [anon_sym_NA_integer_] = ACTIONS(77),
    [anon_sym_NA_real_] = ACTIONS(77),
    [aux_sym_identifier_token1] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_integer] = ACTIONS(1954),
    [sym_float] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
  },
  [389] = {
    [anon_sym_SEMI] = ACTIONS(1958),
    [anon_sym_function] = ACTIONS(1960),
    [anon_sym_if] = ACTIONS(1960),
    [anon_sym_LPAREN] = ACTIONS(1958),
    [anon_sym_RPAREN] = ACTIONS(1958),
    [anon_sym_else] = ACTIONS(1960),
    [anon_sym_while] = ACTIONS(1960),
    [anon_sym_repeat] = ACTIONS(1960),
    [anon_sym_for] = ACTIONS(1960),
    [anon_sym_switch] = ACTIONS(1960),
    [anon_sym_COMMA] = ACTIONS(1958),
    [anon_sym_EQ] = ACTIONS(1960),
    [anon_sym_LBRACE] = ACTIONS(1958),
    [anon_sym_LT_