#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 186
#define LARGE_STATE_COUNT 27
#define SYMBOL_COUNT 81
#define ALIAS_COUNT 2
#define TOKEN_COUNT 49
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 3

enum {
  anon_sym_datasource = 1,
  anon_sym_model = 2,
  anon_sym_generator = 3,
  anon_sym_type = 4,
  anon_sym_enum = 5,
  sym_developer_comment = 6,
  aux_sym_comment_token1 = 7,
  anon_sym_LBRACE = 8,
  anon_sym_RBRACE = 9,
  anon_sym_EQ = 10,
  anon_sym_AMP_AMP = 11,
  anon_sym_PIPE_PIPE = 12,
  anon_sym_GT_GT = 13,
  anon_sym_GT_GT_GT = 14,
  anon_sym_LT_LT = 15,
  anon_sym_AMP = 16,
  anon_sym_CARET = 17,
  anon_sym_PIPE = 18,
  anon_sym_PLUS = 19,
  anon_sym_DASH = 20,
  anon_sym_STAR = 21,
  anon_sym_SLASH = 22,
  anon_sym_PERCENT = 23,
  anon_sym_STAR_STAR = 24,
  anon_sym_LT = 25,
  anon_sym_LT_EQ = 26,
  anon_sym_EQ_EQ = 27,
  anon_sym_EQ_EQ_EQ = 28,
  anon_sym_BANG_EQ = 29,
  anon_sym_BANG_EQ_EQ = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_GT = 32,
  anon_sym_DOT = 33,
  aux_sym_column_type_token1 = 34,
  anon_sym_COLON = 35,
  anon_sym_AT = 36,
  anon_sym_AT_AT = 37,
  anon_sym_LPAREN = 38,
  anon_sym_COMMA = 39,
  anon_sym_RPAREN = 40,
  aux_sym_identifier_token1 = 41,
  sym_string = 42,
  sym_number = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  sym_true = 46,
  sym_false = 47,
  sym_null = 48,
  sym_program = 49,
  sym_datasource_declaration = 50,
  sym_model_declaration = 51,
  sym_generator_declaration = 52,
  sym_type_declaration = 53,
  sym_enum_declaration = 54,
  sym__declaration = 55,
  sym_comment = 56,
  sym_statement_block = 57,
  sym_enum_block = 58,
  sym__statement = 59,
  sym_column_declaration = 60,
  sym_assignment_expression = 61,
  sym__constructable_expression = 62,
  sym_binary_expression = 63,
  sym_member_expression = 64,
  sym_column_type = 65,
  sym_type_expression = 66,
  sym_call_expression = 67,
  sym_attribute = 68,
  sym_block_attribute_declaration = 69,
  sym_arguments = 70,
  sym__expression = 71,
  sym_identifier = 72,
  sym_enumeral = 73,
  sym_array = 74,
  aux_sym_program_repeat1 = 75,
  aux_sym_type_declaration_repeat1 = 76,
  aux_sym_statement_block_repeat1 = 77,
  aux_sym_enum_block_repeat1 = 78,
  aux_sym_column_declaration_repeat1 = 79,
  aux_sym_arguments_repeat1 = 80,
  alias_sym_property_identifier = 81,
  alias_sym_variable = 82,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_datasource] = "datasource",
  [anon_sym_model] = "model",
  [anon_sym_generator] = "generator",
  [anon_sym_type] = "type",
  [anon_sym_enum] = "enum",
  [sym_developer_comment] = "developer_comment",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ] = "=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_DOT] = ".",
  [aux_sym_column_type_token1] = "column_type_token1",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_AT_AT] = "@@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_identifier_token1] = "identifier_token1",
  [sym_string] = "string",
  [sym_number] = "number",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_program] = "program",
  [sym_datasource_declaration] = "datasource_declaration",
  [sym_model_declaration] = "model_declaration",
  [sym_generator_declaration] = "generator_declaration",
  [sym_type_declaration] = "type_declaration",
  [sym_enum_declaration] = "enum_declaration",
  [sym__declaration] = "_declaration",
  [sym_comment] = "comment",
  [sym_statement_block] = "statement_block",
  [sym_enum_block] = "enum_block",
  [sym__statement] = "_statement",
  [sym_column_declaration] = "column_declaration",
  [sym_assignment_expression] = "assignment_expression",
  [sym__constructable_expression] = "_constructable_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_member_expression] = "member_expression",
  [sym_column_type] = "column_type",
  [sym_type_expression] = "type_expression",
  [sym_call_expression] = "call_expression",
  [sym_attribute] = "attribute",
  [sym_block_attribute_declaration] = "block_attribute_declaration",
  [sym_arguments] = "arguments",
  [sym__expression] = "_expression",
  [sym_identifier] = "identifier",
  [sym_enumeral] = "enumeral",
  [sym_array] = "array",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_statement_block_repeat1] = "statement_block_repeat1",
  [aux_sym_enum_block_repeat1] = "enum_block_repeat1",
  [aux_sym_column_declaration_repeat1] = "column_declaration_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_variable] = "variable",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_datasource] = anon_sym_datasource,
  [anon_sym_model] = anon_sym_model,
  [anon_sym_generator] = anon_sym_generator,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_enum] = anon_sym_enum,
  [sym_developer_comment] = sym_developer_comment,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [aux_sym_column_type_token1] = aux_sym_column_type_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [sym_string] = sym_string,
  [sym_number] = sym_number,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_program] = sym_program,
  [sym_datasource_declaration] = sym_datasource_declaration,
  [sym_model_declaration] = sym_model_declaration,
  [sym_generator_declaration] = sym_generator_declaration,
  [sym_type_declaration] = sym_type_declaration,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym__declaration] = sym__declaration,
  [sym_comment] = sym_comment,
  [sym_statement_block] = sym_statement_block,
  [sym_enum_block] = sym_enum_block,
  [sym__statement] = sym__statement,
  [sym_column_declaration] = sym_column_declaration,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__constructable_expression] = sym__constructable_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_column_type] = sym_column_type,
  [sym_type_expression] = sym_type_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_attribute] = sym_attribute,
  [sym_block_attribute_declaration] = sym_block_attribute_declaration,
  [sym_arguments] = sym_arguments,
  [sym__expression] = sym__expression,
  [sym_identifier] = sym_identifier,
  [sym_enumeral] = sym_enumeral,
  [sym_array] = sym_array,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_statement_block_repeat1] = aux_sym_statement_block_repeat1,
  [aux_sym_enum_block_repeat1] = aux_sym_enum_block_repeat1,
  [aux_sym_column_declaration_repeat1] = aux_sym_column_declaration_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_variable] = alias_sym_variable,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_datasource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_model] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_generator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [sym_developer_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_column_type_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_datasource_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_model_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_column_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__constructable_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_column_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_block_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumeral] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_column_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [2] = alias_sym_property_identifier,
  },
  [2] = {
    [0] = alias_sym_variable,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_identifier, 3,
    sym_identifier,
    alias_sym_property_identifier,
    alias_sym_variable,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '\'') ADVANCE(4);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(88);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(65);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(67);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '/') ADVANCE(69);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == '<') ADVANCE(72);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(63);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(90);
      if (lookahead == 'g') ADVANCE(100);
      if (lookahead == 'm') ADVANCE(109);
      if (lookahead == 'n') ADVANCE(123);
      if (lookahead == 't') ADVANCE(115);
      if (lookahead == '{') ADVANCE(53);
      if (lookahead == '|') ADVANCE(64);
      if (lookahead == '}') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(65);
      if (lookahead == '-') ADVANCE(67);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '/') ADVANCE(69);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == '<') ADVANCE(72);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '^') ADVANCE(63);
      if (lookahead == '|') ADVANCE(64);
      if (lookahead == '}') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '\'') ADVANCE(4);
      if (lookahead == ')') ADVANCE(88);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(90);
      if (lookahead == 'n') ADVANCE(123);
      if (lookahead == 't') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '\'') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(37);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '/') ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(52);
      if (lookahead != 0) ADVANCE(51);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '}') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(7)
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(31);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(17);
      END_STATE();
    case 13:
      if (lookahead == 'd') ADVANCE(15);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(19);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 19:
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 20:
      if (lookahead == 'm') ADVANCE(49);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(14);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 26:
      if (lookahead == 'p') ADVANCE(16);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(12);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 29:
      if (lookahead == 'r') ADVANCE(11);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(24);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(10);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 35:
      if (lookahead == 'y') ADVANCE(26);
      END_STATE();
    case 36:
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(3);
      if (lookahead == '"') ADVANCE(128);
      if (lookahead == '\\') ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(129);
      if (lookahead == '\\') ADVANCE(37);
      END_STATE();
    case 38:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(62);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(88);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(65);
      if (lookahead == ',') ADVANCE(87);
      if (lookahead == '-') ADVANCE(66);
      if (lookahead == '.') ADVANCE(80);
      if (lookahead == '/') ADVANCE(69);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == '<') ADVANCE(72);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(63);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(21);
      if (lookahead == 'g') ADVANCE(18);
      if (lookahead == 'm') ADVANCE(23);
      if (lookahead == 't') ADVANCE(35);
      if (lookahead == '|') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      END_STATE();
    case 39:
      if (eof) ADVANCE(40);
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '\'') ADVANCE(4);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(90);
      if (lookahead == 'g') ADVANCE(100);
      if (lookahead == 'm') ADVANCE(109);
      if (lookahead == 'n') ADVANCE(123);
      if (lookahead == 't') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(39)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_datasource);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_datasource);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_model);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_model);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_generator);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_generator);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_developer_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(74);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(60);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(57);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(58);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(71);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(6);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(61);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(75);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(59);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_column_type_token1);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_column_type_token1);
      if (lookahead == '?') ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(85);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(120);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(121);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(99);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'd') ADVANCE(101);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(117);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(133);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(134);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(107);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(119);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(135);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(44);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(103);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'm') ADVANCE(50);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(122);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(114);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(124);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(93);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(46);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(125);
      if (lookahead == 'y') ADVANCE(112);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(125);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(91);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(111);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(98);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(110);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(106);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(105);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(113);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(96);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(3);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '\'') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(37);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 38},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 38},
  [30] = {.lex_state = 38},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 38},
  [44] = {.lex_state = 38},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 38},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 38},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 38},
  [52] = {.lex_state = 39},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 38},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 38},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 38},
  [61] = {.lex_state = 38},
  [62] = {.lex_state = 38},
  [63] = {.lex_state = 38},
  [64] = {.lex_state = 38},
  [65] = {.lex_state = 39},
  [66] = {.lex_state = 38},
  [67] = {.lex_state = 38},
  [68] = {.lex_state = 38},
  [69] = {.lex_state = 38},
  [70] = {.lex_state = 38},
  [71] = {.lex_state = 38},
  [72] = {.lex_state = 38},
  [73] = {.lex_state = 38},
  [74] = {.lex_state = 38},
  [75] = {.lex_state = 38},
  [76] = {.lex_state = 38},
  [77] = {.lex_state = 38},
  [78] = {.lex_state = 38},
  [79] = {.lex_state = 38},
  [80] = {.lex_state = 38},
  [81] = {.lex_state = 38},
  [82] = {.lex_state = 38},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 2},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 2},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 2},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 38},
  [123] = {.lex_state = 38},
  [124] = {.lex_state = 7},
  [125] = {.lex_state = 7},
  [126] = {.lex_state = 7},
  [127] = {.lex_state = 7},
  [128] = {.lex_state = 7},
  [129] = {.lex_state = 38},
  [130] = {.lex_state = 38},
  [131] = {.lex_state = 38},
  [132] = {.lex_state = 38},
  [133] = {.lex_state = 38},
  [134] = {.lex_state = 38},
  [135] = {.lex_state = 38},
  [136] = {.lex_state = 7},
  [137] = {.lex_state = 38},
  [138] = {.lex_state = 38},
  [139] = {.lex_state = 38},
  [140] = {.lex_state = 7},
  [141] = {.lex_state = 38},
  [142] = {.lex_state = 7},
  [143] = {.lex_state = 7},
  [144] = {.lex_state = 7},
  [145] = {.lex_state = 7},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 7},
  [148] = {.lex_state = 7},
  [149] = {.lex_state = 7},
  [150] = {.lex_state = 7},
  [151] = {.lex_state = 7},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 7},
  [154] = {.lex_state = 7},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 7},
  [169] = {.lex_state = 7},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 7},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 7},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 7},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 7},
  [178] = {.lex_state = 7},
  [179] = {.lex_state = 7},
  [180] = {.lex_state = 7},
  [181] = {.lex_state = 7},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 82},
  [184] = {.lex_state = 82},
  [185] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_datasource] = ACTIONS(1),
    [anon_sym_model] = ACTIONS(1),
    [anon_sym_generator] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(182),
    [sym_datasource_declaration] = STATE(129),
    [sym_model_declaration] = STATE(129),
    [sym_generator_declaration] = STATE(129),
    [sym_type_declaration] = STATE(129),
    [sym_enum_declaration] = STATE(129),
    [sym__declaration] = STATE(138),
    [sym_comment] = STATE(1),
    [aux_sym_program_repeat1] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_datasource] = ACTIONS(9),
    [anon_sym_model] = ACTIONS(11),
    [anon_sym_generator] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_enum] = ACTIONS(17),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
  },
  [2] = {
    [sym_comment] = STATE(2),
    [sym_statement_block] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(19),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_EQ] = ACTIONS(25),
    [anon_sym_AMP_AMP] = ACTIONS(19),
    [anon_sym_PIPE_PIPE] = ACTIONS(19),
    [anon_sym_GT_GT] = ACTIONS(21),
    [anon_sym_GT_GT_GT] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(21),
    [anon_sym_CARET] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(21),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(21),
    [anon_sym_PERCENT] = ACTIONS(19),
    [anon_sym_STAR_STAR] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(21),
    [anon_sym_LT_EQ] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(19),
    [anon_sym_BANG_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(19),
    [anon_sym_GT_EQ] = ACTIONS(19),
    [anon_sym_GT] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(27),
    [anon_sym_COLON] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_AT_AT] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(19),
    [aux_sym_identifier_token1] = ACTIONS(21),
    [sym_string] = ACTIONS(19),
    [sym_number] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(19),
    [sym_true] = ACTIONS(21),
    [sym_false] = ACTIONS(21),
    [sym_null] = ACTIONS(21),
  },
  [3] = {
    [sym_comment] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(31),
    [anon_sym_datasource] = ACTIONS(33),
    [anon_sym_model] = ACTIONS(33),
    [anon_sym_generator] = ACTIONS(33),
    [anon_sym_type] = ACTIONS(33),
    [anon_sym_enum] = ACTIONS(33),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_EQ] = ACTIONS(33),
    [anon_sym_AMP_AMP] = ACTIONS(31),
    [anon_sym_PIPE_PIPE] = ACTIONS(31),
    [anon_sym_GT_GT] = ACTIONS(33),
    [anon_sym_GT_GT_GT] = ACTIONS(31),
    [anon_sym_LT_LT] = ACTIONS(31),
    [anon_sym_AMP] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(31),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(31),
    [anon_sym_DASH] = ACTIONS(33),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(31),
    [anon_sym_STAR_STAR] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(31),
    [anon_sym_EQ_EQ] = ACTIONS(33),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(31),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(31),
    [anon_sym_GT_EQ] = ACTIONS(31),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_DOT] = ACTIONS(31),
    [anon_sym_COLON] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_AT_AT] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(31),
    [aux_sym_identifier_token1] = ACTIONS(33),
    [sym_string] = ACTIONS(31),
    [sym_number] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(31),
    [sym_true] = ACTIONS(33),
    [sym_false] = ACTIONS(33),
    [sym_null] = ACTIONS(33),
  },
  [4] = {
    [sym_comment] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(19),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(25),
    [anon_sym_AMP_AMP] = ACTIONS(19),
    [anon_sym_PIPE_PIPE] = ACTIONS(19),
    [anon_sym_GT_GT] = ACTIONS(21),
    [anon_sym_GT_GT_GT] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(21),
    [anon_sym_CARET] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(21),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(21),
    [anon_sym_PERCENT] = ACTIONS(19),
    [anon_sym_STAR_STAR] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(21),
    [anon_sym_LT_EQ] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(19),
    [anon_sym_BANG_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(19),
    [anon_sym_GT_EQ] = ACTIONS(19),
    [anon_sym_GT] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(27),
    [anon_sym_COLON] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_AT_AT] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(19),
    [aux_sym_identifier_token1] = ACTIONS(21),
    [sym_string] = ACTIONS(19),
    [sym_number] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(19),
    [sym_true] = ACTIONS(21),
    [sym_false] = ACTIONS(21),
    [sym_null] = ACTIONS(21),
  },
  [5] = {
    [sym_comment] = STATE(5),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(35),
    [anon_sym_datasource] = ACTIONS(37),
    [anon_sym_model] = ACTIONS(37),
    [anon_sym_generator] = ACTIONS(37),
    [anon_sym_type] = ACTIONS(37),
    [anon_sym_enum] = ACTIONS(37),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(39),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_AT_AT] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [sym_string] = ACTIONS(35),
    [sym_number] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(35),
    [sym_true] = ACTIONS(37),
    [sym_false] = ACTIONS(37),
    [sym_null] = ACTIONS(37),
  },
  [6] = {
    [sym_comment] = STATE(6),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(63),
    [anon_sym_datasource] = ACTIONS(65),
    [anon_sym_model] = ACTIONS(65),
    [anon_sym_generator] = ACTIONS(65),
    [anon_sym_type] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(65),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(39),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_AT_AT] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(65),
    [sym_string] = ACTIONS(63),
    [sym_number] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_true] = ACTIONS(65),
    [sym_false] = ACTIONS(65),
    [sym_null] = ACTIONS(65),
  },
  [7] = {
    [sym_comment] = STATE(7),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(67),
    [anon_sym_datasource] = ACTIONS(69),
    [anon_sym_model] = ACTIONS(69),
    [anon_sym_generator] = ACTIONS(69),
    [anon_sym_type] = ACTIONS(69),
    [anon_sym_enum] = ACTIONS(69),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(39),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(69),
    [anon_sym_AT_AT] = ACTIONS(67),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(69),
    [sym_string] = ACTIONS(67),
    [sym_number] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_null] = ACTIONS(69),
  },
  [8] = {
    [sym_comment] = STATE(8),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_datasource] = ACTIONS(73),
    [anon_sym_model] = ACTIONS(73),
    [anon_sym_generator] = ACTIONS(73),
    [anon_sym_type] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(73),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(73),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(73),
    [anon_sym_LT_EQ] = ACTIONS(71),
    [anon_sym_EQ_EQ] = ACTIONS(73),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(71),
    [anon_sym_BANG_EQ] = ACTIONS(73),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(71),
    [anon_sym_GT_EQ] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(73),
    [sym_string] = ACTIONS(71),
    [sym_number] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_null] = ACTIONS(73),
  },
  [9] = {
    [sym_comment] = STATE(9),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_datasource] = ACTIONS(73),
    [anon_sym_model] = ACTIONS(73),
    [anon_sym_generator] = ACTIONS(73),
    [anon_sym_type] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(73),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(73),
    [anon_sym_GT_GT_GT] = ACTIONS(71),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_AMP] = ACTIONS(73),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_STAR] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(73),
    [anon_sym_PERCENT] = ACTIONS(71),
    [anon_sym_STAR_STAR] = ACTIONS(71),
    [anon_sym_LT] = ACTIONS(73),
    [anon_sym_LT_EQ] = ACTIONS(71),
    [anon_sym_EQ_EQ] = ACTIONS(73),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(71),
    [anon_sym_BANG_EQ] = ACTIONS(73),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(71),
    [anon_sym_GT_EQ] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(73),
    [sym_string] = ACTIONS(71),
    [sym_number] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_null] = ACTIONS(73),
  },
  [10] = {
    [sym_comment] = STATE(10),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_datasource] = ACTIONS(73),
    [anon_sym_model] = ACTIONS(73),
    [anon_sym_generator] = ACTIONS(73),
    [anon_sym_type] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(73),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(73),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(73),
    [anon_sym_LT_EQ] = ACTIONS(71),
    [anon_sym_EQ_EQ] = ACTIONS(73),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(71),
    [anon_sym_BANG_EQ] = ACTIONS(73),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(71),
    [anon_sym_GT_EQ] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(73),
    [sym_string] = ACTIONS(71),
    [sym_number] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_null] = ACTIONS(73),
  },
  [11] = {
    [sym_comment] = STATE(11),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_datasource] = ACTIONS(73),
    [anon_sym_model] = ACTIONS(73),
    [anon_sym_generator] = ACTIONS(73),
    [anon_sym_type] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(73),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(73),
    [anon_sym_GT_GT_GT] = ACTIONS(71),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_AMP] = ACTIONS(73),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_STAR] = ACTIONS(73),
    [anon_sym_SLASH] = ACTIONS(73),
    [anon_sym_PERCENT] = ACTIONS(71),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(73),
    [anon_sym_LT_EQ] = ACTIONS(71),
    [anon_sym_EQ_EQ] = ACTIONS(73),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(71),
    [anon_sym_BANG_EQ] = ACTIONS(73),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(71),
    [anon_sym_GT_EQ] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(73),
    [sym_string] = ACTIONS(71),
    [sym_number] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_null] = ACTIONS(73),
  },
  [12] = {
    [sym_comment] = STATE(12),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_datasource] = ACTIONS(73),
    [anon_sym_model] = ACTIONS(73),
    [anon_sym_generator] = ACTIONS(73),
    [anon_sym_type] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(73),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(39),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(73),
    [sym_string] = ACTIONS(71),
    [sym_number] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_null] = ACTIONS(73),
  },
  [13] = {
    [sym_comment] = STATE(13),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_datasource] = ACTIONS(73),
    [anon_sym_model] = ACTIONS(73),
    [anon_sym_generator] = ACTIONS(73),
    [anon_sym_type] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(73),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(73),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(73),
    [sym_string] = ACTIONS(71),
    [sym_number] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_null] = ACTIONS(73),
  },
  [14] = {
    [sym_comment] = STATE(14),
    [ts_builtin_sym_end] = ACTIONS(75),
    [anon_sym_datasource] = ACTIONS(77),
    [anon_sym_model] = ACTIONS(77),
    [anon_sym_generator] = ACTIONS(77),
    [anon_sym_type] = ACTIONS(77),
    [anon_sym_enum] = ACTIONS(77),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_GT_GT] = ACTIONS(77),
    [anon_sym_GT_GT_GT] = ACTIONS(75),
    [anon_sym_LT_LT] = ACTIONS(75),
    [anon_sym_AMP] = ACTIONS(77),
    [anon_sym_CARET] = ACTIONS(75),
    [anon_sym_PIPE] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(77),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_PERCENT] = ACTIONS(75),
    [anon_sym_STAR_STAR] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(75),
    [anon_sym_EQ_EQ] = ACTIONS(77),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(75),
    [anon_sym_BANG_EQ] = ACTIONS(77),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(75),
    [anon_sym_GT_EQ] = ACTIONS(75),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_DOT] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_AT_AT] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(75),
    [aux_sym_identifier_token1] = ACTIONS(77),
    [sym_string] = ACTIONS(75),
    [sym_number] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(75),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_null] = ACTIONS(77),
  },
  [15] = {
    [sym_comment] = STATE(15),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(79),
    [anon_sym_datasource] = ACTIONS(81),
    [anon_sym_model] = ACTIONS(81),
    [anon_sym_generator] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(81),
    [anon_sym_enum] = ACTIONS(81),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(39),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(81),
    [anon_sym_AT_AT] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(81),
    [sym_string] = ACTIONS(79),
    [sym_number] = ACTIONS(79),
    [anon_sym_LBRACK] = ACTIONS(79),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
  },
  [16] = {
    [sym_comment] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(19),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(19),
    [anon_sym_PIPE_PIPE] = ACTIONS(19),
    [anon_sym_GT_GT] = ACTIONS(21),
    [anon_sym_GT_GT_GT] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(21),
    [anon_sym_CARET] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(21),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(21),
    [anon_sym_PERCENT] = ACTIONS(19),
    [anon_sym_STAR_STAR] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(21),
    [anon_sym_LT_EQ] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(19),
    [anon_sym_BANG_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(19),
    [anon_sym_GT_EQ] = ACTIONS(19),
    [anon_sym_GT] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_AT_AT] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(19),
    [aux_sym_identifier_token1] = ACTIONS(21),
    [sym_string] = ACTIONS(19),
    [sym_number] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(19),
    [sym_true] = ACTIONS(21),
    [sym_false] = ACTIONS(21),
    [sym_null] = ACTIONS(21),
  },
  [17] = {
    [sym_comment] = STATE(17),
    [sym_arguments] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(83),
    [anon_sym_datasource] = ACTIONS(85),
    [anon_sym_model] = ACTIONS(85),
    [anon_sym_generator] = ACTIONS(85),
    [anon_sym_type] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(85),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(39),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_GT_GT] = ACTIONS(43),
    [anon_sym_GT_GT_GT] = ACTIONS(45),
    [anon_sym_LT_LT] = ACTIONS(45),
    [anon_sym_AMP] = ACTIONS(47),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_PIPE] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_SLASH] = ACTIONS(43),
    [anon_sym_PERCENT] = ACTIONS(45),
    [anon_sym_STAR_STAR] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_LT_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(59),
    [anon_sym_GT_EQ] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_AT_AT] = ACTIONS(83),
    [anon_sym_LPAREN] = ACTIONS(61),
    [aux_sym_identifier_token1] = ACTIONS(85),
    [sym_string] = ACTIONS(83),
    [sym_number] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(83),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_null] = ACTIONS(85),
  },
  [18] = {
    [sym_comment] = STATE(18),
    [ts_builtin_sym_end] = ACTIONS(87),
    [anon_sym_datasource] = ACTIONS(89),
    [anon_sym_model] = ACTIONS(89),
    [anon_sym_generator] = ACTIONS(89),
    [anon_sym_type] = ACTIONS(89),
    [anon_sym_enum] = ACTIONS(89),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_GT_GT] = ACTIONS(89),
    [anon_sym_GT_GT_GT] = ACTIONS(87),
    [anon_sym_LT_LT] = ACTIONS(87),
    [anon_sym_AMP] = ACTIONS(89),
    [anon_sym_CARET] = ACTIONS(87),
    [anon_sym_PIPE] = ACTIONS(89),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_STAR] = ACTIONS(89),
    [anon_sym_SLASH] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(87),
    [anon_sym_STAR_STAR] = ACTIONS(87),
    [anon_sym_LT] = ACTIONS(89),
    [anon_sym_LT_EQ] = ACTIONS(87),
    [anon_sym_EQ_EQ] = ACTIONS(89),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(87),
    [anon_sym_BANG_EQ] = ACTIONS(89),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(87),
    [anon_sym_GT_EQ] = ACTIONS(87),
    [anon_sym_GT] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(89),
    [anon_sym_AT_AT] = ACTIONS(87),
    [anon_sym_LPAREN] = ACTIONS(87),
    [aux_sym_identifier_token1] = ACTIONS(89),
    [sym_string] = ACTIONS(87),
    [sym_number] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(87),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
  },
  [19] = {
    [sym_comment] = STATE(19),
    [ts_builtin_sym_end] = ACTIONS(91),
    [anon_sym_datasource] = ACTIONS(93),
    [anon_sym_model] = ACTIONS(93),
    [anon_sym_generator] = ACTIONS(93),
    [anon_sym_type] = ACTIONS(93),
    [anon_sym_enum] = ACTIONS(93),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(91),
    [anon_sym_PIPE_PIPE] = ACTIONS(91),
    [anon_sym_GT_GT] = ACTIONS(93),
    [anon_sym_GT_GT_GT] = ACTIONS(91),
    [anon_sym_LT_LT] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_CARET] = ACTIONS(91),
    [anon_sym_PIPE] = ACTIONS(93),
    [anon_sym_PLUS] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_SLASH] = ACTIONS(93),
    [anon_sym_PERCENT] = ACTIONS(91),
    [anon_sym_STAR_STAR] = ACTIONS(91),
    [anon_sym_LT] = ACTIONS(93),
    [anon_sym_LT_EQ] = ACTIONS(91),
    [anon_sym_EQ_EQ] = ACTIONS(93),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(91),
    [anon_sym_BANG_EQ] = ACTIONS(93),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(91),
    [anon_sym_GT_EQ] = ACTIONS(91),
    [anon_sym_GT] = ACTIONS(93),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_AT_AT] = ACTIONS(91),
    [anon_sym_LPAREN] = ACTIONS(91),
    [aux_sym_identifier_token1] = ACTIONS(93),
    [sym_string] = ACTIONS(91),
    [sym_number] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
  },
  [20] = {
    [sym_comment] = STATE(20),
    [ts_builtin_sym_end] = ACTIONS(95),
    [anon_sym_datasource] = ACTIONS(97),
    [anon_sym_model] = ACTIONS(97),
    [anon_sym_generator] = ACTIONS(97),
    [anon_sym_type] = ACTIONS(97),
    [anon_sym_enum] = ACTIONS(97),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(95),
    [anon_sym_PIPE_PIPE] = ACTIONS(95),
    [anon_sym_GT_GT] = ACTIONS(97),
    [anon_sym_GT_GT_GT] = ACTIONS(95),
    [anon_sym_LT_LT] = ACTIONS(95),
    [anon_sym_AMP] = ACTIONS(97),
    [anon_sym_CARET] = ACTIONS(95),
    [anon_sym_PIPE] = ACTIONS(97),
    [anon_sym_PLUS] = ACTIONS(95),
    [anon_sym_DASH] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_SLASH] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(95),
    [anon_sym_STAR_STAR] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(95),
    [anon_sym_EQ_EQ] = ACTIONS(97),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(97),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(95),
    [anon_sym_GT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_AT_AT] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(95),
    [aux_sym_identifier_token1] = ACTIONS(97),
    [sym_string] = ACTIONS(95),
    [sym_number] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
  },
  [21] = {
    [sym_comment] = STATE(21),
    [ts_builtin_sym_end] = ACTIONS(99),
    [anon_sym_datasource] = ACTIONS(101),
    [anon_sym_model] = ACTIONS(101),
    [anon_sym_generator] = ACTIONS(101),
    [anon_sym_type] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(101),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(99),
    [anon_sym_PIPE_PIPE] = ACTIONS(99),
    [anon_sym_GT_GT] = ACTIONS(101),
    [anon_sym_GT_GT_GT] = ACTIONS(99),
    [anon_sym_LT_LT] = ACTIONS(99),
    [anon_sym_AMP] = ACTIONS(101),
    [anon_sym_CARET] = ACTIONS(99),
    [anon_sym_PIPE] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(99),
    [anon_sym_DASH] = ACTIONS(101),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_SLASH] = ACTIONS(101),
    [anon_sym_PERCENT] = ACTIONS(99),
    [anon_sym_STAR_STAR] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(101),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(99),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(99),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(101),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_AT_AT] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(99),
    [aux_sym_identifier_token1] = ACTIONS(101),
    [sym_string] = ACTIONS(99),
    [sym_number] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(99),
    [sym_true] = ACTIONS(101),
    [sym_false] = ACTIONS(101),
    [sym_null] = ACTIONS(101),
  },
  [22] = {
    [sym_comment] = STATE(22),
    [ts_builtin_sym_end] = ACTIONS(19),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(19),
    [anon_sym_PIPE_PIPE] = ACTIONS(19),
    [anon_sym_GT_GT] = ACTIONS(21),
    [anon_sym_GT_GT_GT] = ACTIONS(19),
    [anon_sym_LT_LT] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(21),
    [anon_sym_CARET] = ACTIONS(19),
    [anon_sym_PIPE] = ACTIONS(21),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(21),
    [anon_sym_PERCENT] = ACTIONS(19),
    [anon_sym_STAR_STAR] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(21),
    [anon_sym_LT_EQ] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(19),
    [anon_sym_BANG_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(19),
    [anon_sym_GT_EQ] = ACTIONS(19),
    [anon_sym_GT] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_AT_AT] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(19),
    [aux_sym_identifier_token1] = ACTIONS(21),
    [sym_string] = ACTIONS(19),
    [sym_number] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(19),
    [sym_true] = ACTIONS(21),
    [sym_false] = ACTIONS(21),
    [sym_null] = ACTIONS(21),
  },
  [23] = {
    [sym_comment] = STATE(23),
    [ts_builtin_sym_end] = ACTIONS(103),
    [anon_sym_datasource] = ACTIONS(105),
    [anon_sym_model] = ACTIONS(105),
    [anon_sym_generator] = ACTIONS(105),
    [anon_sym_type] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(105),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(103),
    [anon_sym_GT_GT] = ACTIONS(105),
    [anon_sym_GT_GT_GT] = ACTIONS(103),
    [anon_sym_LT_LT] = ACTIONS(103),
    [anon_sym_AMP] = ACTIONS(105),
    [anon_sym_CARET] = ACTIONS(103),
    [anon_sym_PIPE] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(105),
    [anon_sym_STAR] = ACTIONS(105),
    [anon_sym_SLASH] = ACTIONS(105),
    [anon_sym_PERCENT] = ACTIONS(103),
    [anon_sym_STAR_STAR] = ACTIONS(103),
    [anon_sym_LT] = ACTIONS(105),
    [anon_sym_LT_EQ] = ACTIONS(103),
    [anon_sym_EQ_EQ] = ACTIONS(105),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(103),
    [anon_sym_BANG_EQ] = ACTIONS(105),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(103),
    [anon_sym_GT_EQ] = ACTIONS(103),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(105),
    [anon_sym_AT_AT] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(103),
    [aux_sym_identifier_token1] = ACTIONS(105),
    [sym_string] = ACTIONS(103),
    [sym_number] = ACTIONS(103),
    [anon_sym_LBRACK] = ACTIONS(103),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_null] = ACTIONS(105),
  },
  [24] = {
    [sym_comment] = STATE(24),
    [ts_builtin_sym_end] = ACTIONS(107),
    [anon_sym_datasource] = ACTIONS(109),
    [anon_sym_model] = ACTIONS(109),
    [anon_sym_generator] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(109),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_GT_GT] = ACTIONS(109),
    [anon_sym_GT_GT_GT] = ACTIONS(107),
    [anon_sym_LT_LT] = ACTIONS(107),
    [anon_sym_AMP] = ACTIONS(109),
    [anon_sym_CARET] = ACTIONS(107),
    [anon_sym_PIPE] = ACTIONS(109),
    [anon_sym_PLUS] = ACTIONS(107),
    [anon_sym_DASH] = ACTIONS(109),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_SLASH] = ACTIONS(109),
    [anon_sym_PERCENT] = ACTIONS(107),
    [anon_sym_STAR_STAR] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(109),
    [anon_sym_LT_EQ] = ACTIONS(107),
    [anon_sym_EQ_EQ] = ACTIONS(109),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(107),
    [anon_sym_BANG_EQ] = ACTIONS(109),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(107),
    [anon_sym_GT_EQ] = ACTIONS(107),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_AT_AT] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(107),
    [aux_sym_identifier_token1] = ACTIONS(109),
    [sym_string] = ACTIONS(107),
    [sym_number] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(107),
    [sym_true] = ACTIONS(109),
    [sym_false] = ACTIONS(109),
    [sym_null] = ACTIONS(109),
  },
  [25] = {
    [sym_comment] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(111),
    [anon_sym_datasource] = ACTIONS(113),
    [anon_sym_model] = ACTIONS(113),
    [anon_sym_generator] = ACTIONS(113),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_enum] = ACTIONS(113),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_GT_GT] = ACTIONS(113),
    [anon_sym_GT_GT_GT] = ACTIONS(111),
    [anon_sym_LT_LT] = ACTIONS(111),
    [anon_sym_AMP] = ACTIONS(113),
    [anon_sym_CARET] = ACTIONS(111),
    [anon_sym_PIPE] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(111),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_SLASH] = ACTIONS(113),
    [anon_sym_PERCENT] = ACTIONS(111),
    [anon_sym_STAR_STAR] = ACTIONS(111),
    [anon_sym_LT] = ACTIONS(113),
    [anon_sym_LT_EQ] = ACTIONS(111),
    [anon_sym_EQ_EQ] = ACTIONS(113),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(111),
    [anon_sym_BANG_EQ] = ACTIONS(113),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(111),
    [anon_sym_GT_EQ] = ACTIONS(111),
    [anon_sym_GT] = ACTIONS(113),
    [anon_sym_AT] = ACTIONS(113),
    [anon_sym_AT_AT] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(111),
    [aux_sym_identifier_token1] = ACTIONS(113),
    [sym_string] = ACTIONS(111),
    [sym_number] = ACTIONS(111),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_true] = ACTIONS(113),
    [sym_false] = ACTIONS(113),
    [sym_null] = ACTIONS(113),
  },
  [26] = {
    [sym_comment] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(115),
    [anon_sym_datasource] = ACTIONS(117),
    [anon_sym_model] = ACTIONS(117),
    [anon_sym_generator] = ACTIONS(117),
    [anon_sym_type] = ACTIONS(117),
    [anon_sym_enum] = ACTIONS(117),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_AMP_AMP] = ACTIONS(115),
    [anon_sym_PIPE_PIPE] = ACTIONS(115),
    [anon_sym_GT_GT] = ACTIONS(117),
    [anon_sym_GT_GT_GT] = ACTIONS(115),
    [anon_sym_LT_LT] = ACTIONS(115),
    [anon_sym_AMP] = ACTIONS(117),
    [anon_sym_CARET] = ACTIONS(115),
    [anon_sym_PIPE] = ACTIONS(117),
    [anon_sym_PLUS] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_SLASH] = ACTIONS(117),
    [anon_sym_PERCENT] = ACTIONS(115),
    [anon_sym_STAR_STAR] = ACTIONS(115),
    [anon_sym_LT] = ACTIONS(117),
    [anon_sym_LT_EQ] = ACTIONS(115),
    [anon_sym_EQ_EQ] = ACTIONS(117),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(115),
    [anon_sym_BANG_EQ] = ACTIONS(117),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(115),
    [anon_sym_GT_EQ] = ACTIONS(115),
    [anon_sym_GT] = ACTIONS(117),
    [anon_sym_AT] = ACTIONS(117),
    [anon_sym_AT_AT] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(115),
    [aux_sym_identifier_token1] = ACTIONS(117),
    [sym_string] = ACTIONS(115),
    [sym_number] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(115),
    [sym_true] = ACTIONS(117),
    [sym_false] = ACTIONS(117),
    [sym_null] = ACTIONS(117),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(27), 1,
      sym_comment,
    ACTIONS(33), 13,
      anon_sym_EQ,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(31), 17,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [44] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(119), 1,
      anon_sym_EQ,
    ACTIONS(121), 1,
      anon_sym_DOT,
    ACTIONS(123), 1,
      anon_sym_COLON,
    STATE(28), 1,
      sym_comment,
    ACTIONS(21), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(19), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [94] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(125), 1,
      anon_sym_EQ,
    ACTIONS(127), 1,
      anon_sym_DOT,
    ACTIONS(129), 1,
      anon_sym_COLON,
    STATE(29), 1,
      sym_comment,
    ACTIONS(21), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(19), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [143] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(30), 1,
      sym_comment,
    ACTIONS(33), 10,
      anon_sym_EQ,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(31), 19,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [186] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    STATE(31), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(73), 8,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(71), 9,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [242] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    STATE(32), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(73), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(71), 14,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [288] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    STATE(33), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(73), 9,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(71), 10,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [340] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(121), 1,
      anon_sym_DOT,
    STATE(34), 1,
      sym_comment,
    ACTIONS(21), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(19), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [384] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_AMP_AMP,
    ACTIONS(147), 1,
      anon_sym_AMP,
    ACTIONS(149), 1,
      anon_sym_PIPE,
    STATE(35), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(63), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(65), 2,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(145), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(151), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(153), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [452] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_AMP_AMP,
    ACTIONS(147), 1,
      anon_sym_AMP,
    ACTIONS(149), 1,
      anon_sym_PIPE,
    STATE(36), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(79), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(81), 2,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(145), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(151), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(153), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [520] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    STATE(37), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(73), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(71), 13,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [568] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_AMP_AMP,
    ACTIONS(147), 1,
      anon_sym_AMP,
    STATE(38), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(73), 3,
      anon_sym_PIPE,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(71), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
    ACTIONS(151), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(153), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [632] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    STATE(39), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(73), 4,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(151), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(153), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(71), 5,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
  [692] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(40), 1,
      sym_comment,
    ACTIONS(77), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(75), 16,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [734] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_AMP_AMP,
    ACTIONS(147), 1,
      anon_sym_AMP,
    ACTIONS(149), 1,
      anon_sym_PIPE,
    STATE(41), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(37), 2,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(145), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(151), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(153), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [802] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(135), 1,
      anon_sym_PLUS,
    ACTIONS(137), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_STAR_STAR,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_AMP_AMP,
    ACTIONS(147), 1,
      anon_sym_AMP,
    ACTIONS(149), 1,
      anon_sym_PIPE,
    STATE(42), 1,
      sym_comment,
    STATE(48), 1,
      sym_arguments,
    ACTIONS(67), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(69), 2,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(145), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(131), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(133), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(151), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(153), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [870] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(43), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(73), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(71), 10,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [923] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    STATE(44), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(177), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [986] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(45), 1,
      sym_comment,
    ACTIONS(101), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(99), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1027] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(181), 1,
      anon_sym_RBRACK,
    STATE(46), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(163), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1094] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(47), 1,
      sym_comment,
    ACTIONS(113), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(111), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1135] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(48), 1,
      sym_comment,
    ACTIONS(117), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(115), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1176] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(183), 1,
      anon_sym_RBRACK,
    STATE(49), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(155), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1243] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(50), 1,
      sym_comment,
    ACTIONS(93), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(91), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1284] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_DOT,
    STATE(51), 1,
      sym_comment,
    ACTIONS(21), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(19), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1327] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(185), 1,
      ts_builtin_sym_end,
    ACTIONS(189), 1,
      anon_sym_AT,
    ACTIONS(192), 1,
      anon_sym_AT_AT,
    ACTIONS(195), 1,
      aux_sym_identifier_token1,
    ACTIONS(201), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(16), 1,
      sym_member_expression,
    STATE(17), 1,
      sym__expression,
    ACTIONS(198), 2,
      sym_string,
      sym_number,
    STATE(52), 2,
      sym_comment,
      aux_sym_type_declaration_repeat1,
    ACTIONS(204), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    ACTIONS(187), 5,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [1390] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(53), 1,
      sym_comment,
    ACTIONS(109), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(107), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1431] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(54), 1,
      sym_comment,
    ACTIONS(21), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(19), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1472] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    STATE(55), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(79), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1535] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(56), 1,
      sym_comment,
    ACTIONS(89), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(87), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1576] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(57), 1,
      sym_comment,
    ACTIONS(105), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(103), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1617] = 13,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(58), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(73), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(71), 6,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1674] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(59), 1,
      sym_comment,
    ACTIONS(97), 12,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_AT,
      aux_sym_identifier_token1,
    ACTIONS(95), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [1715] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    STATE(60), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(63), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1778] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    STATE(61), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(67), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1841] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(207), 1,
      anon_sym_RBRACK,
    STATE(62), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(167), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1908] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    STATE(63), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(35), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1971] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(64), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(166), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2038] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(211), 1,
      ts_builtin_sym_end,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(16), 1,
      sym_member_expression,
    STATE(17), 1,
      sym__expression,
    STATE(52), 1,
      aux_sym_type_declaration_repeat1,
    STATE(65), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    ACTIONS(213), 5,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [2103] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_RBRACK,
    STATE(66), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(161), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2170] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(67), 1,
      sym_comment,
    ACTIONS(77), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(75), 18,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2211] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(159), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2278] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    ACTIONS(171), 1,
      anon_sym_PIPE,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(69), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    STATE(158), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(167), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2345] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(70), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(73), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(71), 16,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2390] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(71), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(73), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(71), 12,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2441] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(72), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(73), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(71), 15,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2488] = 15,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(73), 1,
      anon_sym_PIPE,
    ACTIONS(161), 1,
      anon_sym_STAR_STAR,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_AMP_AMP,
    ACTIONS(169), 1,
      anon_sym_AMP,
    STATE(73), 1,
      sym_comment,
    STATE(78), 1,
      sym_arguments,
    ACTIONS(159), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(155), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(157), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(173), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(175), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(71), 5,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2549] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(74), 1,
      sym_comment,
    ACTIONS(101), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(99), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2589] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(75), 1,
      sym_comment,
    ACTIONS(89), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(87), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2629] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(76), 1,
      sym_comment,
    ACTIONS(21), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(19), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2669] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(77), 1,
      sym_comment,
    ACTIONS(113), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2709] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(78), 1,
      sym_comment,
    ACTIONS(117), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(115), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2749] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(79), 1,
      sym_comment,
    ACTIONS(93), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(91), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2789] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(80), 1,
      sym_comment,
    ACTIONS(105), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(103), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2829] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(81), 1,
      sym_comment,
    ACTIONS(97), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(95), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2869] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(82), 1,
      sym_comment,
    ACTIONS(109), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(107), 17,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [2909] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(237), 1,
      anon_sym_RPAREN,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(69), 1,
      sym__expression,
    STATE(83), 1,
      sym_comment,
    STATE(160), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [2970] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    ACTIONS(247), 1,
      anon_sym_RBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(49), 1,
      sym__expression,
    STATE(51), 1,
      sym_member_expression,
    STATE(84), 1,
      sym_comment,
    STATE(157), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3031] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    ACTIONS(249), 1,
      anon_sym_RBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(62), 1,
      sym__expression,
    STATE(85), 1,
      sym_comment,
    STATE(165), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3092] = 15,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(44), 1,
      sym__expression,
    STATE(51), 1,
      sym_member_expression,
    STATE(86), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    ACTIONS(251), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3149] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    ACTIONS(253), 1,
      anon_sym_RBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(46), 1,
      sym__expression,
    STATE(51), 1,
      sym_member_expression,
    STATE(87), 1,
      sym_comment,
    STATE(156), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3210] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_RBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(66), 1,
      sym__expression,
    STATE(88), 1,
      sym_comment,
    STATE(162), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3271] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    ACTIONS(257), 1,
      anon_sym_RPAREN,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(64), 1,
      sym__expression,
    STATE(89), 1,
      sym_comment,
    STATE(152), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3332] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(68), 1,
      sym__expression,
    STATE(90), 1,
      sym_comment,
    STATE(164), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3393] = 15,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(2), 1,
      sym_identifier,
    STATE(16), 1,
      sym_member_expression,
    STATE(17), 1,
      sym__expression,
    STATE(65), 1,
      aux_sym_type_declaration_repeat1,
    STATE(91), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3448] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(33), 1,
      sym__expression,
    STATE(34), 1,
      sym_member_expression,
    STATE(92), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [3500] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(42), 1,
      sym__expression,
    STATE(93), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [3552] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(55), 1,
      sym__expression,
    STATE(94), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3604] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(63), 1,
      sym__expression,
    STATE(95), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3656] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(41), 1,
      sym__expression,
    STATE(96), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [3708] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(36), 1,
      sym__expression,
    STATE(97), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [3760] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(7), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(98), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3812] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(15), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(99), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3864] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(5), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(100), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [3916] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(39), 1,
      sym__expression,
    STATE(101), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [3968] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(38), 1,
      sym__expression,
    STATE(102), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [4020] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(13), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(103), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4072] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(58), 1,
      sym__expression,
    STATE(104), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4124] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(73), 1,
      sym__expression,
    STATE(105), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4176] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(72), 1,
      sym__expression,
    STATE(106), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4228] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(71), 1,
      sym__expression,
    STATE(107), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4280] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(70), 1,
      sym__expression,
    STATE(108), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4332] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(43), 1,
      sym__expression,
    STATE(51), 1,
      sym_member_expression,
    STATE(109), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4384] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(12), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(110), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4436] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(61), 1,
      sym__expression,
    STATE(111), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4488] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      anon_sym_AT,
    ACTIONS(235), 1,
      anon_sym_AT_AT,
    ACTIONS(239), 1,
      aux_sym_identifier_token1,
    ACTIONS(243), 1,
      anon_sym_LBRACK,
    STATE(29), 1,
      sym_identifier,
    STATE(51), 1,
      sym_member_expression,
    STATE(60), 1,
      sym__expression,
    STATE(112), 1,
      sym_comment,
    ACTIONS(241), 2,
      sym_string,
      sym_number,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(76), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(82), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4540] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(11), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(113), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4592] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(37), 1,
      sym__expression,
    STATE(114), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [4644] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(10), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(115), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4696] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(34), 1,
      sym_member_expression,
    STATE(35), 1,
      sym__expression,
    STATE(116), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [4748] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(6), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(117), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4800] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(9), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(118), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [4852] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(31), 1,
      sym__expression,
    STATE(34), 1,
      sym_member_expression,
    STATE(119), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [4904] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(265), 1,
      aux_sym_identifier_token1,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    STATE(28), 1,
      sym_identifier,
    STATE(32), 1,
      sym__expression,
    STATE(34), 1,
      sym_member_expression,
    STATE(120), 1,
      sym_comment,
    ACTIONS(267), 2,
      sym_string,
      sym_number,
    ACTIONS(271), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(53), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
    STATE(54), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
  [4956] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(215), 1,
      anon_sym_AT,
    ACTIONS(217), 1,
      anon_sym_AT_AT,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(8), 1,
      sym__expression,
    STATE(16), 1,
      sym_member_expression,
    STATE(121), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    ACTIONS(225), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(22), 4,
      sym_type_expression,
      sym_attribute,
      sym_block_attribute_declaration,
      sym_array,
    STATE(24), 4,
      sym_assignment_expression,
      sym__constructable_expression,
      sym_binary_expression,
      sym_call_expression,
  [5008] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(273), 1,
      ts_builtin_sym_end,
    ACTIONS(275), 1,
      anon_sym_datasource,
    ACTIONS(278), 1,
      anon_sym_model,
    ACTIONS(281), 1,
      anon_sym_generator,
    ACTIONS(284), 1,
      anon_sym_type,
    ACTIONS(287), 1,
      anon_sym_enum,
    STATE(138), 1,
      sym__declaration,
    STATE(122), 2,
      sym_comment,
      aux_sym_program_repeat1,
    STATE(129), 5,
      sym_datasource_declaration,
      sym_model_declaration,
      sym_generator_declaration,
      sym_type_declaration,
      sym_enum_declaration,
  [5047] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(9), 1,
      anon_sym_datasource,
    ACTIONS(11), 1,
      anon_sym_model,
    ACTIONS(13), 1,
      anon_sym_generator,
    ACTIONS(15), 1,
      anon_sym_type,
    ACTIONS(17), 1,
      anon_sym_enum,
    ACTIONS(290), 1,
      ts_builtin_sym_end,
    STATE(122), 1,
      aux_sym_program_repeat1,
    STATE(123), 1,
      sym_comment,
    STATE(138), 1,
      sym__declaration,
    STATE(129), 5,
      sym_datasource_declaration,
      sym_model_declaration,
      sym_generator_declaration,
      sym_type_declaration,
      sym_enum_declaration,
  [5088] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(292), 1,
      anon_sym_RBRACE,
    ACTIONS(294), 1,
      anon_sym_AT_AT,
    ACTIONS(297), 1,
      aux_sym_identifier_token1,
    STATE(147), 1,
      sym_identifier,
    STATE(154), 1,
      sym__statement,
    STATE(124), 2,
      sym_comment,
      aux_sym_statement_block_repeat1,
    STATE(153), 3,
      sym_column_declaration,
      sym_assignment_expression,
      sym_block_attribute_declaration,
  [5119] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(300), 1,
      anon_sym_RBRACE,
    ACTIONS(302), 1,
      aux_sym_identifier_token1,
    STATE(125), 1,
      sym_comment,
    STATE(126), 1,
      aux_sym_statement_block_repeat1,
    STATE(147), 1,
      sym_identifier,
    STATE(154), 1,
      sym__statement,
    STATE(153), 3,
      sym_column_declaration,
      sym_assignment_expression,
      sym_block_attribute_declaration,
  [5152] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(263), 1,
      anon_sym_AT_AT,
    ACTIONS(302), 1,
      aux_sym_identifier_token1,
    ACTIONS(304), 1,
      anon_sym_RBRACE,
    STATE(124), 1,
      aux_sym_statement_block_repeat1,
    STATE(126), 1,
      sym_comment,
    STATE(147), 1,
      sym_identifier,
    STATE(154), 1,
      sym__statement,
    STATE(153), 3,
      sym_column_declaration,
      sym_assignment_expression,
      sym_block_attribute_declaration,
  [5185] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    STATE(127), 1,
      sym_comment,
    STATE(128), 1,
      aux_sym_column_declaration_repeat1,
    STATE(148), 1,
      sym_attribute,
    ACTIONS(306), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5209] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(261), 1,
      anon_sym_AT,
    STATE(128), 1,
      sym_comment,
    STATE(136), 1,
      aux_sym_column_declaration_repeat1,
    STATE(148), 1,
      sym_attribute,
    ACTIONS(308), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5233] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(129), 1,
      sym_comment,
    ACTIONS(310), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5251] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(130), 1,
      sym_comment,
    ACTIONS(312), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5269] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(131), 1,
      sym_comment,
    ACTIONS(314), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5287] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(132), 1,
      sym_comment,
    ACTIONS(316), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5305] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(133), 1,
      sym_comment,
    ACTIONS(318), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5323] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(134), 1,
      sym_comment,
    ACTIONS(320), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5341] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(135), 1,
      sym_comment,
    ACTIONS(322), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5359] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(326), 1,
      anon_sym_AT,
    STATE(148), 1,
      sym_attribute,
    STATE(136), 2,
      sym_comment,
      aux_sym_column_declaration_repeat1,
    ACTIONS(324), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5381] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(137), 1,
      sym_comment,
    ACTIONS(329), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5399] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(138), 1,
      sym_comment,
    ACTIONS(331), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5417] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(139), 1,
      sym_comment,
    ACTIONS(333), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5435] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(337), 1,
      anon_sym_AT,
    ACTIONS(339), 1,
      anon_sym_LBRACK,
    STATE(140), 1,
      sym_comment,
    STATE(150), 1,
      sym_array,
    ACTIONS(335), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5459] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(141), 1,
      sym_comment,
    ACTIONS(341), 6,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [5477] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(343), 1,
      anon_sym_RBRACE,
    ACTIONS(345), 1,
      aux_sym_identifier_token1,
    STATE(142), 1,
      sym_comment,
    STATE(149), 1,
      aux_sym_enum_block_repeat1,
    STATE(171), 1,
      sym_enumeral,
  [5499] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(113), 1,
      anon_sym_AT,
    STATE(143), 1,
      sym_comment,
    ACTIONS(111), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5517] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_AT,
    STATE(144), 1,
      sym_comment,
    ACTIONS(91), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5535] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(105), 1,
      anon_sym_AT,
    STATE(145), 1,
      sym_comment,
    ACTIONS(103), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5553] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(347), 1,
      anon_sym_COMMA,
    ACTIONS(177), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(146), 2,
      sym_comment,
      aux_sym_arguments_repeat1,
  [5571] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(350), 1,
      anon_sym_EQ,
    ACTIONS(352), 1,
      aux_sym_identifier_token1,
    STATE(127), 1,
      sym_column_type,
    STATE(147), 1,
      sym_comment,
    STATE(184), 1,
      sym_identifier,
  [5593] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(356), 1,
      anon_sym_AT,
    STATE(148), 1,
      sym_comment,
    ACTIONS(354), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5611] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(358), 1,
      anon_sym_RBRACE,
    ACTIONS(360), 1,
      aux_sym_identifier_token1,
    STATE(171), 1,
      sym_enumeral,
    STATE(149), 2,
      sym_comment,
      aux_sym_enum_block_repeat1,
  [5631] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(365), 1,
      anon_sym_AT,
    STATE(150), 1,
      sym_comment,
    ACTIONS(363), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5649] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(345), 1,
      aux_sym_identifier_token1,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    STATE(142), 1,
      aux_sym_enum_block_repeat1,
    STATE(151), 1,
      sym_comment,
    STATE(171), 1,
      sym_enumeral,
  [5671] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(152), 1,
      sym_comment,
  [5690] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(153), 1,
      sym_comment,
    ACTIONS(369), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5705] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(154), 1,
      sym_comment,
    ACTIONS(371), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [5720] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(373), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(155), 1,
      sym_comment,
  [5739] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(181), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(156), 1,
      sym_comment,
  [5758] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(183), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(157), 1,
      sym_comment,
  [5777] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(158), 1,
      sym_comment,
  [5796] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(377), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(159), 1,
      sym_comment,
  [5815] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(160), 1,
      sym_comment,
  [5834] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(379), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(161), 1,
      sym_comment,
  [5853] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(162), 1,
      sym_comment,
  [5872] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(381), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(163), 1,
      sym_comment,
  [5891] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(164), 1,
      sym_comment,
  [5910] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(207), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(165), 1,
      sym_comment,
  [5929] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(166), 1,
      sym_comment,
  [5948] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(179), 1,
      anon_sym_COMMA,
    ACTIONS(385), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      aux_sym_arguments_repeat1,
    STATE(167), 1,
      sym_comment,
  [5967] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(387), 1,
      aux_sym_identifier_token1,
    STATE(168), 1,
      sym_comment,
    STATE(170), 1,
      sym_identifier,
  [5983] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(169), 1,
      sym_comment,
    ACTIONS(389), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [5997] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    STATE(131), 1,
      sym_enum_block,
    STATE(170), 1,
      sym_comment,
  [6013] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(171), 1,
      sym_comment,
    ACTIONS(393), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [6027] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(137), 1,
      sym_statement_block,
    STATE(172), 1,
      sym_comment,
  [6043] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(395), 1,
      aux_sym_identifier_token1,
    STATE(40), 1,
      sym_identifier,
    STATE(173), 1,
      sym_comment,
  [6059] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(132), 1,
      sym_statement_block,
    STATE(174), 1,
      sym_comment,
  [6075] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(397), 1,
      aux_sym_identifier_token1,
    STATE(67), 1,
      sym_identifier,
    STATE(175), 1,
      sym_comment,
  [6091] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_LBRACE,
    STATE(134), 1,
      sym_statement_block,
    STATE(176), 1,
      sym_comment,
  [6107] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(387), 1,
      aux_sym_identifier_token1,
    STATE(176), 1,
      sym_identifier,
    STATE(177), 1,
      sym_comment,
  [6123] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(387), 1,
      aux_sym_identifier_token1,
    STATE(174), 1,
      sym_identifier,
    STATE(178), 1,
      sym_comment,
  [6139] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(387), 1,
      aux_sym_identifier_token1,
    STATE(172), 1,
      sym_identifier,
    STATE(179), 1,
      sym_comment,
  [6155] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(180), 1,
      sym_comment,
    ACTIONS(31), 2,
      anon_sym_EQ,
      aux_sym_identifier_token1,
  [6169] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(387), 1,
      aux_sym_identifier_token1,
    STATE(14), 1,
      sym_identifier,
    STATE(181), 1,
      sym_comment,
  [6185] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(399), 1,
      ts_builtin_sym_end,
    STATE(182), 1,
      sym_comment,
  [6198] = 4,
    ACTIONS(31), 1,
      aux_sym_column_type_token1,
    ACTIONS(401), 1,
      sym_developer_comment,
    ACTIONS(403), 1,
      aux_sym_comment_token1,
    STATE(183), 1,
      sym_comment,
  [6211] = 4,
    ACTIONS(401), 1,
      sym_developer_comment,
    ACTIONS(403), 1,
      aux_sym_comment_token1,
    ACTIONS(405), 1,
      aux_sym_column_type_token1,
    STATE(184), 1,
      sym_comment,
  [6224] = 1,
    ACTIONS(407), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(27)] = 0,
  [SMALL_STATE(28)] = 44,
  [SMALL_STATE(29)] = 94,
  [SMALL_STATE(30)] = 143,
  [SMALL_STATE(31)] = 186,
  [SMALL_STATE(32)] = 242,
  [SMALL_STATE(33)] = 288,
  [SMALL_STATE(34)] = 340,
  [SMALL_STATE(35)] = 384,
  [SMALL_STATE(36)] = 452,
  [SMALL_STATE(37)] = 520,
  [SMALL_STATE(38)] = 568,
  [SMALL_STATE(39)] = 632,
  [SMALL_STATE(40)] = 692,
  [SMALL_STATE(41)] = 734,
  [SMALL_STATE(42)] = 802,
  [SMALL_STATE(43)] = 870,
  [SMALL_STATE(44)] = 923,
  [SMALL_STATE(45)] = 986,
  [SMALL_STATE(46)] = 1027,
  [SMALL_STATE(47)] = 1094,
  [SMALL_STATE(48)] = 1135,
  [SMALL_STATE(49)] = 1176,
  [SMALL_STATE(50)] = 1243,
  [SMALL_STATE(51)] = 1284,
  [SMALL_STATE(52)] = 1327,
  [SMALL_STATE(53)] = 1390,
  [SMALL_STATE(54)] = 1431,
  [SMALL_STATE(55)] = 1472,
  [SMALL_STATE(56)] = 1535,
  [SMALL_STATE(57)] = 1576,
  [SMALL_STATE(58)] = 1617,
  [SMALL_STATE(59)] = 1674,
  [SMALL_STATE(60)] = 1715,
  [SMALL_STATE(61)] = 1778,
  [SMALL_STATE(62)] = 1841,
  [SMALL_STATE(63)] = 1908,
  [SMALL_STATE(64)] = 1971,
  [SMALL_STATE(65)] = 2038,
  [SMALL_STATE(66)] = 2103,
  [SMALL_STATE(67)] = 2170,
  [SMALL_STATE(68)] = 2211,
  [SMALL_STATE(69)] = 2278,
  [SMALL_STATE(70)] = 2345,
  [SMALL_STATE(71)] = 2390,
  [SMALL_STATE(72)] = 2441,
  [SMALL_STATE(73)] = 2488,
  [SMALL_STATE(74)] = 2549,
  [SMALL_STATE(75)] = 2589,
  [SMALL_STATE(76)] = 2629,
  [SMALL_STATE(77)] = 2669,
  [SMALL_STATE(78)] = 2709,
  [SMALL_STATE(79)] = 2749,
  [SMALL_STATE(80)] = 2789,
  [SMALL_STATE(81)] = 2829,
  [SMALL_STATE(82)] = 2869,
  [SMALL_STATE(83)] = 2909,
  [SMALL_STATE(84)] = 2970,
  [SMALL_STATE(85)] = 3031,
  [SMALL_STATE(86)] = 3092,
  [SMALL_STATE(87)] = 3149,
  [SMALL_STATE(88)] = 3210,
  [SMALL_STATE(89)] = 3271,
  [SMALL_STATE(90)] = 3332,
  [SMALL_STATE(91)] = 3393,
  [SMALL_STATE(92)] = 3448,
  [SMALL_STATE(93)] = 3500,
  [SMALL_STATE(94)] = 3552,
  [SMALL_STATE(95)] = 3604,
  [SMALL_STATE(96)] = 3656,
  [SMALL_STATE(97)] = 3708,
  [SMALL_STATE(98)] = 3760,
  [SMALL_STATE(99)] = 3812,
  [SMALL_STATE(100)] = 3864,
  [SMALL_STATE(101)] = 3916,
  [SMALL_STATE(102)] = 3968,
  [SMALL_STATE(103)] = 4020,
  [SMALL_STATE(104)] = 4072,
  [SMALL_STATE(105)] = 4124,
  [SMALL_STATE(106)] = 4176,
  [SMALL_STATE(107)] = 4228,
  [SMALL_STATE(108)] = 4280,
  [SMALL_STATE(109)] = 4332,
  [SMALL_STATE(110)] = 4384,
  [SMALL_STATE(111)] = 4436,
  [SMALL_STATE(112)] = 4488,
  [SMALL_STATE(113)] = 4540,
  [SMALL_STATE(114)] = 4592,
  [SMALL_STATE(115)] = 4644,
  [SMALL_STATE(116)] = 4696,
  [SMALL_STATE(117)] = 4748,
  [SMALL_STATE(118)] = 4800,
  [SMALL_STATE(119)] = 4852,
  [SMALL_STATE(120)] = 4904,
  [SMALL_STATE(121)] = 4956,
  [SMALL_STATE(122)] = 5008,
  [SMALL_STATE(123)] = 5047,
  [SMALL_STATE(124)] = 5088,
  [SMALL_STATE(125)] = 5119,
  [SMALL_STATE(126)] = 5152,
  [SMALL_STATE(127)] = 5185,
  [SMALL_STATE(128)] = 5209,
  [SMALL_STATE(129)] = 5233,
  [SMALL_STATE(130)] = 5251,
  [SMALL_STATE(131)] = 5269,
  [SMALL_STATE(132)] = 5287,
  [SMALL_STATE(133)] = 5305,
  [SMALL_STATE(134)] = 5323,
  [SMALL_STATE(135)] = 5341,
  [SMALL_STATE(136)] = 5359,
  [SMALL_STATE(137)] = 5381,
  [SMALL_STATE(138)] = 5399,
  [SMALL_STATE(139)] = 5417,
  [SMALL_STATE(140)] = 5435,
  [SMALL_STATE(141)] = 5459,
  [SMALL_STATE(142)] = 5477,
  [SMALL_STATE(143)] = 5499,
  [SMALL_STATE(144)] = 5517,
  [SMALL_STATE(145)] = 5535,
  [SMALL_STATE(146)] = 5553,
  [SMALL_STATE(147)] = 5571,
  [SMALL_STATE(148)] = 5593,
  [SMALL_STATE(149)] = 5611,
  [SMALL_STATE(150)] = 5631,
  [SMALL_STATE(151)] = 5649,
  [SMALL_STATE(152)] = 5671,
  [SMALL_STATE(153)] = 5690,
  [SMALL_STATE(154)] = 5705,
  [SMALL_STATE(155)] = 5720,
  [SMALL_STATE(156)] = 5739,
  [SMALL_STATE(157)] = 5758,
  [SMALL_STATE(158)] = 5777,
  [SMALL_STATE(159)] = 5796,
  [SMALL_STATE(160)] = 5815,
  [SMALL_STATE(161)] = 5834,
  [SMALL_STATE(162)] = 5853,
  [SMALL_STATE(163)] = 5872,
  [SMALL_STATE(164)] = 5891,
  [SMALL_STATE(165)] = 5910,
  [SMALL_STATE(166)] = 5929,
  [SMALL_STATE(167)] = 5948,
  [SMALL_STATE(168)] = 5967,
  [SMALL_STATE(169)] = 5983,
  [SMALL_STATE(170)] = 5997,
  [SMALL_STATE(171)] = 6013,
  [SMALL_STATE(172)] = 6027,
  [SMALL_STATE(173)] = 6043,
  [SMALL_STATE(174)] = 6059,
  [SMALL_STATE(175)] = 6075,
  [SMALL_STATE(176)] = 6091,
  [SMALL_STATE(177)] = 6107,
  [SMALL_STATE(178)] = 6123,
  [SMALL_STATE(179)] = 6139,
  [SMALL_STATE(180)] = 6155,
  [SMALL_STATE(181)] = 6169,
  [SMALL_STATE(182)] = 6185,
  [SMALL_STATE(183)] = 6198,
  [SMALL_STATE(184)] = 6211,
  [SMALL_STATE(185)] = 6224,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [19] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__constructable_expression, 1),
  [21] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__constructable_expression, 1),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [31] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1),
  [33] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1),
  [35] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_attribute_declaration, 2),
  [37] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_attribute_declaration, 2),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expression, 3),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_expression, 3),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_expression, 3, .production_id = 2),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_expression, 3, .production_id = 2),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_expression, 3, .production_id = 1),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_expression, 3, .production_id = 1),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 2),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 2),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 1),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 1),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 4),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 4),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 2),
  [189] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(99),
  [192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(100),
  [195] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(3),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(22),
  [201] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(87),
  [204] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(22),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 2),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_declaration, 2),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 1),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [275] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(179),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(178),
  [281] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(177),
  [284] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(91),
  [287] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(168),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 2),
  [294] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 2), SHIFT_REPEAT(96),
  [297] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 2), SHIFT_REPEAT(180),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_declaration, 2),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_declaration, 3),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__declaration, 1),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_block, 2),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_declaration, 3),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_declaration, 3),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 3),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generator_declaration, 3),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_block, 3),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_column_declaration_repeat1, 2),
  [326] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_column_declaration_repeat1, 2), SHIFT_REPEAT(97),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_datasource_declaration, 3),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 1),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_block, 2),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_type, 2),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_column_type, 2),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_block, 3),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [347] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(86),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_column_declaration_repeat1, 1),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_column_declaration_repeat1, 1),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_block_repeat1, 2),
  [360] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_block_repeat1, 2), SHIFT_REPEAT(169),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_type, 3),
  [365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_column_type, 3),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 1),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enumeral, 1),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_block_repeat1, 1),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [399] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_prisma(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
