#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 962
#define LARGE_STATE_COUNT 245
#define SYMBOL_COUNT 271
#define ALIAS_COUNT 1
#define TOKEN_COUNT 123
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 30
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 169

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_null_literal = 12,
  anon_sym_LPAREN = 13,
  anon_sym_AMP = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PLUS_EQ = 17,
  anon_sym_DASH_EQ = 18,
  anon_sym_STAR_EQ = 19,
  anon_sym_SLASH_EQ = 20,
  anon_sym_AMP_EQ = 21,
  anon_sym_PIPE_EQ = 22,
  anon_sym_CARET_EQ = 23,
  anon_sym_PERCENT_EQ = 24,
  anon_sym_LT_LT_EQ = 25,
  anon_sym_GT_GT_EQ = 26,
  anon_sym_GT_GT_GT_EQ = 27,
  anon_sym_GT = 28,
  anon_sym_LT = 29,
  anon_sym_EQ_EQ = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_LT_EQ = 32,
  anon_sym_BANG_EQ = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_PLUS = 36,
  anon_sym_DASH = 37,
  anon_sym_STAR = 38,
  anon_sym_SLASH = 39,
  anon_sym_PIPE = 40,
  anon_sym_CARET = 41,
  anon_sym_PERCENT = 42,
  anon_sym_LT_LT = 43,
  anon_sym_GT_GT = 44,
  anon_sym_GT_GT_GT = 45,
  anon_sym_instanceof = 46,
  anon_sym_DASH_GT = 47,
  anon_sym_COMMA = 48,
  anon_sym_QMARK = 49,
  anon_sym_COLON = 50,
  anon_sym_BANG = 51,
  anon_sym_TILDE = 52,
  anon_sym_PLUS_PLUS = 53,
  anon_sym_DASH_DASH = 54,
  anon_sym_new = 55,
  anon_sym_LBRACK = 56,
  anon_sym_RBRACK = 57,
  anon_sym_DOT = 58,
  anon_sym_class = 59,
  anon_sym_COLON_COLON = 60,
  anon_sym_extends = 61,
  anon_sym_SEMI = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_assert = 65,
  anon_sym_switch = 66,
  anon_sym_case = 67,
  anon_sym_default = 68,
  anon_sym_do = 69,
  anon_sym_while = 70,
  anon_sym_break = 71,
  anon_sym_continue = 72,
  anon_sym_return = 73,
  anon_sym_synchronized = 74,
  anon_sym_throw = 75,
  anon_sym_try = 76,
  anon_sym_catch = 77,
  anon_sym_finally = 78,
  anon_sym_if = 79,
  anon_sym_else = 80,
  anon_sym_for = 81,
  anon_sym_AT = 82,
  anon_sym_open = 83,
  anon_sym_module = 84,
  anon_sym_requires = 85,
  anon_sym_exports = 86,
  anon_sym_to = 87,
  anon_sym_opens = 88,
  anon_sym_uses = 89,
  anon_sym_provides = 90,
  anon_sym_with = 91,
  anon_sym_transitive = 92,
  anon_sym_static = 93,
  anon_sym_package = 94,
  anon_sym_import = 95,
  anon_sym_enum = 96,
  anon_sym_public = 97,
  anon_sym_protected = 98,
  anon_sym_private = 99,
  anon_sym_abstract = 100,
  anon_sym_final = 101,
  anon_sym_strictfp = 102,
  anon_sym_native = 103,
  anon_sym_transient = 104,
  anon_sym_volatile = 105,
  anon_sym_implements = 106,
  anon_sym_ATinterface = 107,
  anon_sym_interface = 108,
  anon_sym_byte = 109,
  anon_sym_short = 110,
  anon_sym_int = 111,
  anon_sym_long = 112,
  anon_sym_char = 113,
  anon_sym_float = 114,
  anon_sym_double = 115,
  sym_boolean_type = 116,
  sym_void_type = 117,
  anon_sym_DOT_DOT_DOT = 118,
  anon_sym_throws = 119,
  sym_this = 120,
  sym_super = 121,
  sym_comment = 122,
  sym_program = 123,
  sym__literal = 124,
  sym_expression = 125,
  sym_cast_expression = 126,
  sym_assignment_expression = 127,
  sym_binary_expression = 128,
  sym_instanceof_expression = 129,
  sym_lambda_expression = 130,
  sym_inferred_parameters = 131,
  sym_ternary_expression = 132,
  sym_unary_expression = 133,
  sym_update_expression = 134,
  sym_primary_expression = 135,
  sym_array_creation_expression = 136,
  sym_dimensions_expr = 137,
  sym_parenthesized_expression = 138,
  sym_class_literal = 139,
  sym_object_creation_expression = 140,
  sym__unqualified_object_creation_expression = 141,
  sym_field_access = 142,
  sym_array_access = 143,
  sym_method_invocation = 144,
  sym_argument_list = 145,
  sym_method_reference = 146,
  sym_type_arguments = 147,
  sym_wildcard = 148,
  sym__wildcard_bounds = 149,
  sym_dimensions = 150,
  sym_statement = 151,
  sym_block = 152,
  sym_expression_statement = 153,
  sym_labeled_statement = 154,
  sym_assert_statement = 155,
  sym_switch_statement = 156,
  sym_switch_block = 157,
  sym_switch_label = 158,
  sym_do_statement = 159,
  sym_break_statement = 160,
  sym_continue_statement = 161,
  sym_return_statement = 162,
  sym_synchronized_statement = 163,
  sym_throw_statement = 164,
  sym_try_statement = 165,
  sym_catch_clause = 166,
  sym_catch_formal_parameter = 167,
  sym_catch_type = 168,
  sym_finally_clause = 169,
  sym_try_with_resources_statement = 170,
  sym_resource_specification = 171,
  sym_resource = 172,
  sym_if_statement = 173,
  sym_while_statement = 174,
  sym_for_statement = 175,
  sym_enhanced_for_statement = 176,
  sym__annotation = 177,
  sym_marker_annotation = 178,
  sym_annotation = 179,
  sym_annotation_argument_list = 180,
  sym_element_value_pair = 181,
  sym__element_value = 182,
  sym_element_value_array_initializer = 183,
  sym_declaration = 184,
  sym_module_declaration = 185,
  sym_module_body = 186,
  sym_module_directive = 187,
  sym_requires_modifier = 188,
  sym_package_declaration = 189,
  sym_import_declaration = 190,
  sym_asterisk = 191,
  sym_enum_declaration = 192,
  sym_enum_body = 193,
  sym_enum_body_declarations = 194,
  sym_enum_constant = 195,
  sym_class_declaration = 196,
  sym_modifiers = 197,
  sym_type_parameters = 198,
  sym_type_parameter = 199,
  sym_type_bound = 200,
  sym_superclass = 201,
  sym_super_interfaces = 202,
  sym_interface_type_list = 203,
  sym_class_body = 204,
  sym_static_initializer = 205,
  sym_constructor_declaration = 206,
  sym__constructor_declarator = 207,
  sym_constructor_body = 208,
  sym_explicit_constructor_invocation = 209,
  sym_scoped_identifier = 210,
  sym_field_declaration = 211,
  sym_annotation_type_declaration = 212,
  sym_annotation_type_body = 213,
  sym_annotation_type_element_declaration = 214,
  sym__default_value = 215,
  sym_interface_declaration = 216,
  sym_extends_interfaces = 217,
  sym_interface_body = 218,
  sym_constant_declaration = 219,
  sym__variable_declarator_list = 220,
  sym_variable_declarator = 221,
  sym__variable_declarator_id = 222,
  sym_array_initializer = 223,
  sym__type = 224,
  sym__unannotated_type = 225,
  sym_annotated_type = 226,
  sym_scoped_type_identifier = 227,
  sym_generic_type = 228,
  sym_array_type = 229,
  sym_integral_type = 230,
  sym_floating_point_type = 231,
  sym__method_header = 232,
  sym__method_declarator = 233,
  sym_formal_parameters = 234,
  sym_formal_parameter = 235,
  sym_receiver_parameter = 236,
  sym_spread_parameter = 237,
  sym_throws = 238,
  sym_local_variable_declaration = 239,
  sym_method_declaration = 240,
  aux_sym_program_repeat1 = 241,
  aux_sym_cast_expression_repeat1 = 242,
  aux_sym_inferred_parameters_repeat1 = 243,
  aux_sym_array_creation_expression_repeat1 = 244,
  aux_sym_dimensions_expr_repeat1 = 245,
  aux_sym_argument_list_repeat1 = 246,
  aux_sym_type_arguments_repeat1 = 247,
  aux_sym_dimensions_repeat1 = 248,
  aux_sym_switch_block_repeat1 = 249,
  aux_sym_try_statement_repeat1 = 250,
  aux_sym_catch_type_repeat1 = 251,
  aux_sym_resource_specification_repeat1 = 252,
  aux_sym_for_statement_repeat1 = 253,
  aux_sym_for_statement_repeat2 = 254,
  aux_sym_annotation_argument_list_repeat1 = 255,
  aux_sym_element_value_array_initializer_repeat1 = 256,
  aux_sym_module_body_repeat1 = 257,
  aux_sym_module_directive_repeat1 = 258,
  aux_sym_module_directive_repeat2 = 259,
  aux_sym_enum_body_repeat1 = 260,
  aux_sym_enum_body_declarations_repeat1 = 261,
  aux_sym_modifiers_repeat1 = 262,
  aux_sym_type_parameters_repeat1 = 263,
  aux_sym_type_bound_repeat1 = 264,
  aux_sym_interface_type_list_repeat1 = 265,
  aux_sym_annotation_type_body_repeat1 = 266,
  aux_sym_interface_body_repeat1 = 267,
  aux_sym__variable_declarator_list_repeat1 = 268,
  aux_sym_array_initializer_repeat1 = 269,
  aux_sym_formal_parameters_repeat1 = 270,
  alias_sym_type_identifier = 271,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_assert] = "assert",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_implements] = "implements",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_comment] = "comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_expression] = "expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_block] = "switch_block",
  [sym_switch_label] = "switch_label",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_dimensions_expr_repeat1] = "dimensions_expr_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_module_directive_repeat1] = "module_directive_repeat1",
  [aux_sym_module_directive_repeat2] = "module_directive_repeat2",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_comment] = sym_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_expression] = sym_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_label] = sym_switch_label,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_interface_type_list] = sym_interface_type_list,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_dimensions_expr_repeat1] = aux_sym_dimensions_expr_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_module_directive_repeat1] = aux_sym_module_directive_repeat1,
  [aux_sym_module_directive_repeat2] = aux_sym_module_directive_repeat2,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_interface_type_list_repeat1] = aux_sym_interface_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_name = 17,
  field_object = 18,
  field_operand = 19,
  field_operator = 20,
  field_parameters = 21,
  field_resources = 22,
  field_right = 23,
  field_scope = 24,
  field_superclass = 25,
  field_type = 26,
  field_type_arguments = 27,
  field_type_parameters = 28,
  field_update = 29,
  field_value = 30,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 3},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 19, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 1},
  [22] = {.index = 26, .length = 1},
  [23] = {.index = 27, .length = 2},
  [24] = {.index = 29, .length = 2},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 3},
  [28] = {.index = 21, .length = 2},
  [30] = {.index = 36, .length = 2},
  [31] = {.index = 36, .length = 2},
  [32] = {.index = 33, .length = 3},
  [33] = {.index = 38, .length = 2},
  [35] = {.index = 40, .length = 2},
  [36] = {.index = 42, .length = 3},
  [37] = {.index = 45, .length = 2},
  [38] = {.index = 45, .length = 2},
  [39] = {.index = 47, .length = 2},
  [40] = {.index = 49, .length = 2},
  [42] = {.index = 51, .length = 3},
  [43] = {.index = 54, .length = 1},
  [44] = {.index = 55, .length = 2},
  [45] = {.index = 57, .length = 2},
  [46] = {.index = 59, .length = 3},
  [47] = {.index = 62, .length = 3},
  [48] = {.index = 59, .length = 3},
  [49] = {.index = 62, .length = 3},
  [50] = {.index = 65, .length = 3},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 68, .length = 3},
  [53] = {.index = 71, .length = 3},
  [54] = {.index = 74, .length = 3},
  [55] = {.index = 77, .length = 2},
  [56] = {.index = 77, .length = 2},
  [57] = {.index = 79, .length = 2},
  [58] = {.index = 79, .length = 2},
  [60] = {.index = 81, .length = 2},
  [61] = {.index = 83, .length = 3},
  [62] = {.index = 83, .length = 3},
  [64] = {.index = 86, .length = 2},
  [65] = {.index = 88, .length = 2},
  [66] = {.index = 90, .length = 1},
  [67] = {.index = 91, .length = 2},
  [68] = {.index = 93, .length = 3},
  [70] = {.index = 96, .length = 3},
  [71] = {.index = 99, .length = 2},
  [72] = {.index = 101, .length = 4},
  [73] = {.index = 105, .length = 4},
  [74] = {.index = 109, .length = 5},
  [75] = {.index = 114, .length = 6},
  [76] = {.index = 120, .length = 4},
  [77] = {.index = 124, .length = 4},
  [78] = {.index = 128, .length = 4},
  [79] = {.index = 132, .length = 2},
  [80] = {.index = 134, .length = 3},
  [81] = {.index = 137, .length = 1},
  [82] = {.index = 138, .length = 2},
  [83] = {.index = 140, .length = 2},
  [84] = {.index = 142, .length = 3},
  [85] = {.index = 145, .length = 2},
  [86] = {.index = 145, .length = 2},
  [87] = {.index = 147, .length = 4},
  [88] = {.index = 147, .length = 4},
  [89] = {.index = 151, .length = 3},
  [90] = {.index = 154, .length = 3},
  [91] = {.index = 157, .length = 3},
  [92] = {.index = 160, .length = 3},
  [93] = {.index = 163, .length = 2},
  [94] = {.index = 165, .length = 2},
  [95] = {.index = 165, .length = 2},
  [96] = {.index = 167, .length = 4},
  [97] = {.index = 171, .length = 5},
  [98] = {.index = 176, .length = 6},
  [99] = {.index = 182, .length = 3},
  [100] = {.index = 185, .length = 5},
  [101] = {.index = 190, .length = 4},
  [102] = {.index = 99, .length = 2},
  [103] = {.index = 194, .length = 5},
  [104] = {.index = 199, .length = 4},
  [105] = {.index = 203, .length = 2},
  [106] = {.index = 205, .length = 1},
  [107] = {.index = 206, .length = 2},
  [108] = {.index = 208, .length = 2},
  [109] = {.index = 210, .length = 3},
  [110] = {.index = 213, .length = 3},
  [111] = {.index = 213, .length = 3},
  [112] = {.index = 216, .length = 4},
  [113] = {.index = 220, .length = 4},
  [114] = {.index = 224, .length = 4},
  [115] = {.index = 228, .length = 3},
  [116] = {.index = 231, .length = 4},
  [117] = {.index = 235, .length = 5},
  [118] = {.index = 240, .length = 3},
  [119] = {.index = 240, .length = 3},
  [120] = {.index = 243, .length = 4},
  [121] = {.index = 247, .length = 1},
  [122] = {.index = 248, .length = 2},
  [123] = {.index = 250, .length = 2},
  [124] = {.index = 252, .length = 1},
  [125] = {.index = 253, .length = 2},
  [126] = {.index = 255, .length = 2},
  [127] = {.index = 257, .length = 2},
  [128] = {.index = 259, .length = 3},
  [129] = {.index = 262, .length = 3},
  [131] = {.index = 265, .length = 3},
  [132] = {.index = 268, .length = 4},
  [133] = {.index = 268, .length = 4},
  [134] = {.index = 272, .length = 5},
  [135] = {.index = 277, .length = 2},
  [136] = {.index = 279, .length = 3},
  [137] = {.index = 282, .length = 3},
  [138] = {.index = 285, .length = 3},
  [139] = {.index = 288, .length = 3},
  [140] = {.index = 291, .length = 3},
  [141] = {.index = 294, .length = 5},
  [142] = {.index = 299, .length = 4},
  [143] = {.index = 303, .length = 4},
  [146] = {.index = 307, .length = 2},
  [147] = {.index = 309, .length = 3},
  [148] = {.index = 312, .length = 4},
  [149] = {.index = 316, .length = 4},
  [150] = {.index = 320, .length = 4},
  [151] = {.index = 324, .length = 4},
  [152] = {.index = 328, .length = 4},
  [153] = {.index = 332, .length = 5},
  [154] = {.index = 337, .length = 5},
  [155] = {.index = 342, .length = 2},
  [156] = {.index = 344, .length = 1},
  [157] = {.index = 345, .length = 3},
  [158] = {.index = 348, .length = 3},
  [159] = {.index = 351, .length = 3},
  [160] = {.index = 354, .length = 5},
  [161] = {.index = 359, .length = 5},
  [162] = {.index = 364, .length = 5},
  [163] = {.index = 369, .length = 3},
  [164] = {.index = 372, .length = 3},
  [165] = {.index = 375, .length = 4},
  [166] = {.index = 379, .length = 4},
  [167] = {.index = 383, .length = 6},
  [168] = {.index = 389, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_name, 1},
  [23] =
    {field_body, 2},
    {field_condition, 1},
  [25] =
    {field_body, 2},
  [26] =
    {field_body, 1},
  [27] =
    {field_body, 2},
    {field_resources, 1},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_arguments, 2},
    {field_name, 1},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_field, 2},
    {field_object, 0},
  [38] =
    {field_body, 2},
    {field_parameters, 0},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [45] =
    {field_dimensions, 1},
    {field_name, 0},
  [47] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [49] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [51] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [54] =
    {field_type, 1},
  [55] =
    {field_type, 1},
    {field_value, 3},
  [57] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [59] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [62] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [65] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [68] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [71] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [74] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [77] =
    {field_name, 2},
    {field_scope, 0},
  [79] =
    {field_body, 3},
    {field_name, 2},
  [81] =
    {field_body, 3},
    {field_name, 1},
  [83] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [86] =
    {field_array, 0},
    {field_index, 2},
  [88] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [90] =
    {field_declarator, 1},
  [91] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [93] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [96] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [99] =
    {field_name, 0},
    {field_parameters, 1},
  [101] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [105] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [109] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [114] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [120] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [124] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [128] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [132] =
    {field_body, 1},
    {field_condition, 3},
  [134] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [137] =
    {field_init, 1},
  [138] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [140] =
    {field_body, 1},
    {field_name, 0},
  [142] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [145] =
    {field_field, 4},
    {field_object, 0},
  [147] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [151] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [154] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [157] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [160] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [163] =
    {field_body, 4},
    {field_name, 2},
  [165] =
    {field_body, 4},
    {field_name, 3},
  [167] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [171] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [176] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [182] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [185] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [190] =
    {field_body, 2},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [194] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [199] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [203] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [205] =
    {field_body, 5},
  [206] =
    {field_body, 5},
    {field_init, 2},
  [208] =
    {field_key, 0},
    {field_value, 2},
  [210] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [213] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [216] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [220] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [224] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [228] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [231] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [235] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [240] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [243] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [247] =
    {field_body, 4},
  [248] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [250] =
    {field_body, 6},
    {field_update, 4},
  [252] =
    {field_update, 1},
  [253] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [255] =
    {field_body, 6},
    {field_condition, 3},
  [257] =
    {field_body, 6},
    {field_init, 2},
  [259] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [262] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [265] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [268] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [272] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [277] =
    {field_arguments, 1},
    {field_constructor, 0},
  [279] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [282] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [285] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [288] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [291] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [294] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [299] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [303] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [307] =
    {field_name, 1},
    {field_type, 0},
  [309] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [312] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [316] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [320] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [324] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [328] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [332] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [337] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [342] =
    {field_name, 2},
    {field_type, 1},
  [344] =
    {field_value, 1},
  [345] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [348] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [351] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [354] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [359] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [364] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [369] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [372] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [375] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [379] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [383] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [389] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_type_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [1] = sym_identifier,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [29] = {
    [1] = sym_identifier,
  },
  [30] = {
    [2] = sym_identifier,
  },
  [34] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [37] = {
    [0] = sym_identifier,
  },
  [41] = {
    [2] = alias_sym_type_identifier,
  },
  [48] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [2] = alias_sym_type_identifier,
  },
  [55] = {
    [0] = sym_identifier,
  },
  [57] = {
    [2] = sym_identifier,
  },
  [59] = {
    [2] = sym_identifier,
  },
  [61] = {
    [2] = sym_identifier,
  },
  [63] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [69] = {
    [3] = alias_sym_type_identifier,
  },
  [85] = {
    [4] = sym_identifier,
  },
  [87] = {
    [3] = sym_identifier,
  },
  [94] = {
    [3] = sym_identifier,
  },
  [102] = {
    [0] = sym_identifier,
  },
  [110] = {
    [4] = sym_identifier,
  },
  [118] = {
    [0] = sym_identifier,
  },
  [130] = {
    [1] = sym_identifier,
    [2] = sym_identifier,
  },
  [132] = {
    [5] = sym_identifier,
  },
  [144] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [145] = {
    [3] = sym_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(46);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(115);
      if (lookahead == '&') ADVANCE(73);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(106);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(108);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(126);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(143);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '^') ADVANCE(113);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('$' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(104);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(126);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '%') ADVANCE(115);
      if (lookahead == '&') ADVANCE(73);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(106);
      if (lookahead == '+') ADVANCE(101);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '/') ADVANCE(108);
      if (lookahead == ':') ADVANCE(126);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(76);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '^') ADVANCE(113);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == ':') ADVANCE(126);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(111);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(126);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '@') ADVANCE(143);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(148);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(145);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 14:
      if (lookahead == ':') ADVANCE(138);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 17:
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(6);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 19:
      if (lookahead == '_') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 20:
      if (lookahead == '_') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(25);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(27);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(24);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(26);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 33:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 34:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(57);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(55);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 41:
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 42:
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 43:
      if (eof) ADVANCE(46);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(137);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(126);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(143);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(111);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('$' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 44:
      if (eof) ADVANCE(46);
      if (lookahead == '!') ADVANCE(128);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(124);
      if (lookahead == '@') ADVANCE(143);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '|') ADVANCE(111);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (('$' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 45:
      if (eof) ADVANCE(46);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(74);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(123);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(48);
      if (lookahead == ':') ADVANCE(14);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(143);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(49);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(34);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(47);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(35);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(13);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(47);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(50);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(50);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(50);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(54);
      if (lookahead == '_') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(56);
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(19);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(23);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(22);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(66);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(98);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(95);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(95);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(116);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(130);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(131);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(148);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '|') ADVANCE(99);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(99);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(86);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(138);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(29);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(148);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'r') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'h') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(32);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'i') ADVANCE(34);
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 't') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(53);
      if (lookahead == 'y') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 27:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(72);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 43:
      if (lookahead == 'w') ADVANCE(88);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(93);
      END_STATE();
    case 48:
      if (lookahead == 'b') ADVANCE(94);
      END_STATE();
    case 49:
      if (lookahead == 'q') ADVANCE(95);
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(100);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(106);
      if (lookahead == 'y') ADVANCE(107);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(119);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == 'b') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(132);
      if (lookahead == 'o') ADVANCE(133);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(136);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 91:
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 92:
      if (lookahead == 'v') ADVANCE(142);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(143);
      if (lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 95:
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 96:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 105:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 109:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 112:
      if (lookahead == 'h') ADVANCE(162);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 116:
      if (lookahead == 'k') ADVANCE(166);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(167);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 138:
      if (lookahead == 'v') ADVANCE(182);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 150:
      if (lookahead == 'c') ADVANCE(193);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(195);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(196);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 155:
      if (lookahead == 'w') ADVANCE(197);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(201);
      END_STATE();
    case 164:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 177:
      if (lookahead == 'm') ADVANCE(210);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 180:
      if (lookahead == 'f') ADVANCE(213);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 184:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'c') ADVANCE(218);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 188:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(223);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 195:
      if (lookahead == 'h') ADVANCE(225);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 198:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(229);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(230);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(232);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 207:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 208:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 209:
      if (lookahead == 'y') ADVANCE(236);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 212:
      if (lookahead == 'c') ADVANCE(238);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 224:
      if (lookahead == 'f') ADVANCE(245);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(246);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 229:
      if (lookahead == 'l') ADVANCE(249);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 237:
      if (lookahead == 'n') ADVANCE(252);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 239:
      if (lookahead == 'c') ADVANCE(254);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 243:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 244:
      if (lookahead == 's') ADVANCE(257);
      END_STATE();
    case 245:
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 246:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 247:
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 252:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 253:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(266);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 259:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 261:
      if (lookahead == 'v') ADVANCE(269);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 263:
      if (lookahead == 's') ADVANCE(270);
      END_STATE();
    case 264:
      if (lookahead == 'f') ADVANCE(271);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 267:
      if (lookahead == 'z') ADVANCE(272);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 274:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 45},
  [2] = {.lex_state = 45},
  [3] = {.lex_state = 45},
  [4] = {.lex_state = 45},
  [5] = {.lex_state = 45},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 45},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 45},
  [14] = {.lex_state = 45},
  [15] = {.lex_state = 45},
  [16] = {.lex_state = 45},
  [17] = {.lex_state = 45},
  [18] = {.lex_state = 45},
  [19] = {.lex_state = 45},
  [20] = {.lex_state = 45},
  [21] = {.lex_state = 45},
  [22] = {.lex_state = 45},
  [23] = {.lex_state = 45},
  [24] = {.lex_state = 45},
  [25] = {.lex_state = 45},
  [26] = {.lex_state = 45},
  [27] = {.lex_state = 45},
  [28] = {.lex_state = 45},
  [29] = {.lex_state = 45},
  [30] = {.lex_state = 45},
  [31] = {.lex_state = 45},
  [32] = {.lex_state = 45},
  [33] = {.lex_state = 45},
  [34] = {.lex_state = 45},
  [35] = {.lex_state = 45},
  [36] = {.lex_state = 45},
  [37] = {.lex_state = 45},
  [38] = {.lex_state = 45},
  [39] = {.lex_state = 45},
  [40] = {.lex_state = 45},
  [41] = {.lex_state = 45},
  [42] = {.lex_state = 45},
  [43] = {.lex_state = 45},
  [44] = {.lex_state = 45},
  [45] = {.lex_state = 45},
  [46] = {.lex_state = 43},
  [47] = {.lex_state = 43},
  [48] = {.lex_state = 44},
  [49] = {.lex_state = 44},
  [50] = {.lex_state = 43},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 45},
  [54] = {.lex_state = 45},
  [55] = {.lex_state = 45},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 45},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 45},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 45},
  [71] = {.lex_state = 45},
  [72] = {.lex_state = 45},
  [73] = {.lex_state = 45},
  [74] = {.lex_state = 45},
  [75] = {.lex_state = 45},
  [76] = {.lex_state = 45},
  [77] = {.lex_state = 45},
  [78] = {.lex_state = 45},
  [79] = {.lex_state = 45},
  [80] = {.lex_state = 45},
  [81] = {.lex_state = 45},
  [82] = {.lex_state = 45},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 45},
  [85] = {.lex_state = 45},
  [86] = {.lex_state = 45},
  [87] = {.lex_state = 45},
  [88] = {.lex_state = 45},
  [89] = {.lex_state = 45},
  [90] = {.lex_state = 45},
  [91] = {.lex_state = 45},
  [92] = {.lex_state = 45},
  [93] = {.lex_state = 45},
  [94] = {.lex_state = 45},
  [95] = {.lex_state = 45},
  [96] = {.lex_state = 45},
  [97] = {.lex_state = 45},
  [98] = {.lex_state = 45},
  [99] = {.lex_state = 45},
  [100] = {.lex_state = 45},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 45},
  [103] = {.lex_state = 45},
  [104] = {.lex_state = 45},
  [105] = {.lex_state = 45},
  [106] = {.lex_state = 45},
  [107] = {.lex_state = 45},
  [108] = {.lex_state = 45},
  [109] = {.lex_state = 45},
  [110] = {.lex_state = 45},
  [111] = {.lex_state = 45},
  [112] = {.lex_state = 45},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 45},
  [115] = {.lex_state = 45},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 45},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 45},
  [121] = {.lex_state = 45},
  [122] = {.lex_state = 45},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 45},
  [125] = {.lex_state = 45},
  [126] = {.lex_state = 45},
  [127] = {.lex_state = 45},
  [128] = {.lex_state = 45},
  [129] = {.lex_state = 45},
  [130] = {.lex_state = 45},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 45},
  [133] = {.lex_state = 45},
  [134] = {.lex_state = 45},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 45},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 45},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 45},
  [143] = {.lex_state = 45},
  [144] = {.lex_state = 45},
  [145] = {.lex_state = 45},
  [146] = {.lex_state = 45},
  [147] = {.lex_state = 45},
  [148] = {.lex_state = 45},
  [149] = {.lex_state = 45},
  [150] = {.lex_state = 45},
  [151] = {.lex_state = 45},
  [152] = {.lex_state = 45},
  [153] = {.lex_state = 45},
  [154] = {.lex_state = 45},
  [155] = {.lex_state = 45},
  [156] = {.lex_state = 45},
  [157] = {.lex_state = 45},
  [158] = {.lex_state = 45},
  [159] = {.lex_state = 45},
  [160] = {.lex_state = 45},
  [161] = {.lex_state = 45},
  [162] = {.lex_state = 45},
  [163] = {.lex_state = 45},
  [164] = {.lex_state = 45},
  [165] = {.lex_state = 45},
  [166] = {.lex_state = 45},
  [167] = {.lex_state = 45},
  [168] = {.lex_state = 45},
  [169] = {.lex_state = 45},
  [170] = {.lex_state = 45},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 45},
  [174] = {.lex_state = 45},
  [175] = {.lex_state = 45},
  [176] = {.lex_state = 45},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 45},
  [179] = {.lex_state = 45},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 45},
  [182] = {.lex_state = 45},
  [183] = {.lex_state = 45},
  [184] = {.lex_state = 45},
  [185] = {.lex_state = 45},
  [186] = {.lex_state = 45},
  [187] = {.lex_state = 45},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 45},
  [190] = {.lex_state = 45},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 45},
  [195] = {.lex_state = 45},
  [196] = {.lex_state = 45},
  [197] = {.lex_state = 45},
  [198] = {.lex_state = 45},
  [199] = {.lex_state = 45},
  [200] = {.lex_state = 45},
  [201] = {.lex_state = 45},
  [202] = {.lex_state = 45},
  [203] = {.lex_state = 45},
  [204] = {.lex_state = 45},
  [205] = {.lex_state = 45},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 45},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 45},
  [239] = {.lex_state = 45},
  [240] = {.lex_state = 45},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 45},
  [244] = {.lex_state = 45},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 2},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 2},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 2},
  [260] = {.lex_state = 2},
  [261] = {.lex_state = 2},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 2},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 2},
  [267] = {.lex_state = 2},
  [268] = {.lex_state = 2},
  [269] = {.lex_state = 2},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 3},
  [272] = {.lex_state = 3},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 3},
  [275] = {.lex_state = 3},
  [276] = {.lex_state = 7},
  [277] = {.lex_state = 7},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 3},
  [281] = {.lex_state = 3},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 2},
  [286] = {.lex_state = 2},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 3},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 7},
  [291] = {.lex_state = 3},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 3},
  [294] = {.lex_state = 7},
  [295] = {.lex_state = 2},
  [296] = {.lex_state = 3},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 3},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 3},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 3},
  [313] = {.lex_state = 3},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 3},
  [316] = {.lex_state = 3},
  [317] = {.lex_state = 3},
  [318] = {.lex_state = 3},
  [319] = {.lex_state = 3},
  [320] = {.lex_state = 3},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 3},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 3},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 3},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 3},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 1},
  [339] = {.lex_state = 1},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 1},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 3},
  [364] = {.lex_state = 3},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 3},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 3},
  [380] = {.lex_state = 3},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 3},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 3},
  [385] = {.lex_state = 3},
  [386] = {.lex_state = 3},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 3},
  [391] = {.lex_state = 3},
  [392] = {.lex_state = 3},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 3},
  [395] = {.lex_state = 3},
  [396] = {.lex_state = 3},
  [397] = {.lex_state = 3},
  [398] = {.lex_state = 3},
  [399] = {.lex_state = 3},
  [400] = {.lex_state = 3},
  [401] = {.lex_state = 3},
  [402] = {.lex_state = 3},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 3},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 3},
  [418] = {.lex_state = 5},
  [419] = {.lex_state = 3},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 3},
  [422] = {.lex_state = 3},
  [423] = {.lex_state = 3},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 3},
  [426] = {.lex_state = 3},
  [427] = {.lex_state = 5},
  [428] = {.lex_state = 3},
  [429] = {.lex_state = 3},
  [430] = {.lex_state = 3},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 3},
  [433] = {.lex_state = 3},
  [434] = {.lex_state = 3},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 3},
  [437] = {.lex_state = 3},
  [438] = {.lex_state = 3},
  [439] = {.lex_state = 3},
  [440] = {.lex_state = 3},
  [441] = {.lex_state = 3},
  [442] = {.lex_state = 3},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 3},
  [445] = {.lex_state = 3},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 1},
  [450] = {.lex_state = 3},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 1},
  [453] = {.lex_state = 3},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 3},
  [456] = {.lex_state = 3},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 3},
  [459] = {.lex_state = 3},
  [460] = {.lex_state = 3},
  [461] = {.lex_state = 3},
  [462] = {.lex_state = 3},
  [463] = {.lex_state = 3},
  [464] = {.lex_state = 3},
  [465] = {.lex_state = 1},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 1},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 5},
  [482] = {.lex_state = 5},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 1},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 1},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 1},
  [491] = {.lex_state = 5},
  [492] = {.lex_state = 5},
  [493] = {.lex_state = 5},
  [494] = {.lex_state = 5},
  [495] = {.lex_state = 5},
  [496] = {.lex_state = 5},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 5},
  [499] = {.lex_state = 5},
  [500] = {.lex_state = 5},
  [501] = {.lex_state = 5},
  [502] = {.lex_state = 2},
  [503] = {.lex_state = 5},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 5},
  [506] = {.lex_state = 5},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 2},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 2},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 2},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 2},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 1},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 2},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 2},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 1},
  [536] = {.lex_state = 2},
  [537] = {.lex_state = 2},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 2},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 1},
  [546] = {.lex_state = 2},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 1},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 1},
  [552] = {.lex_state = 1},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 2},
  [556] = {.lex_state = 2},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 1},
  [560] = {.lex_state = 2},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 1},
  [563] = {.lex_state = 2},
  [564] = {.lex_state = 2},
  [565] = {.lex_state = 2},
  [566] = {.lex_state = 2},
  [567] = {.lex_state = 1},
  [568] = {.lex_state = 2},
  [569] = {.lex_state = 2},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 45},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 1},
  [588] = {.lex_state = 1},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 1},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 1},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 1},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 1},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 1},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 1},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 2},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 2},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 2},
  [641] = {.lex_state = 2},
  [642] = {.lex_state = 45},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 45},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 2},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 2},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 45},
  [657] = {.lex_state = 2},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 2},
  [660] = {.lex_state = 2},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 45},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 45},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 45},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 2},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 2},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 45},
  [701] = {.lex_state = 2},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 45},
  [726] = {.lex_state = 2},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 2},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 2},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 2},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 2},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 45},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 45},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 2},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 45},
  [767] = {.lex_state = 2},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 2},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 45},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 45},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 45},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 2},
  [781] = {.lex_state = 2},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 45},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 2},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 45},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 2},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 45},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 45},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 45},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 2},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 2},
  [826] = {.lex_state = 2},
  [827] = {.lex_state = 45},
  [828] = {.lex_state = 2},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 45},
  [832] = {.lex_state = 2},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 45},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 2},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 2},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 45},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 2},
  [849] = {.lex_state = 2},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 2},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 2},
  [876] = {.lex_state = 2},
  [877] = {.lex_state = 2},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 2},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 2},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 2},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(887),
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(10),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(412),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_type_arguments] = STATE(839),
    [sym_statement] = STATE(7),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_explicit_constructor_invocation] = STATE(8),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(83),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(85),
    [sym_super] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(5),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_switch_label] = STATE(5),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_switch_block_repeat1] = STATE(5),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(91),
    [anon_sym_default] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_switch_label] = STATE(4),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_switch_block_repeat1] = STATE(4),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(95),
    [sym_decimal_integer_literal] = ACTIONS(98),
    [sym_hex_integer_literal] = ACTIONS(98),
    [sym_octal_integer_literal] = ACTIONS(101),
    [sym_binary_integer_literal] = ACTIONS(101),
    [sym_decimal_floating_point_literal] = ACTIONS(101),
    [sym_hex_floating_point_literal] = ACTIONS(98),
    [sym_true] = ACTIONS(98),
    [sym_false] = ACTIONS(98),
    [sym_character_literal] = ACTIONS(101),
    [sym_string_literal] = ACTIONS(101),
    [sym_null_literal] = ACTIONS(98),
    [anon_sym_LPAREN] = ACTIONS(104),
    [anon_sym_PLUS] = ACTIONS(107),
    [anon_sym_DASH] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(110),
    [anon_sym_TILDE] = ACTIONS(110),
    [anon_sym_PLUS_PLUS] = ACTIONS(113),
    [anon_sym_DASH_DASH] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(116),
    [anon_sym_class] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(125),
    [anon_sym_RBRACE] = ACTIONS(128),
    [anon_sym_assert] = ACTIONS(130),
    [anon_sym_switch] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(136),
    [anon_sym_default] = ACTIONS(139),
    [anon_sym_do] = ACTIONS(142),
    [anon_sym_while] = ACTIONS(145),
    [anon_sym_break] = ACTIONS(148),
    [anon_sym_continue] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_synchronized] = ACTIONS(157),
    [anon_sym_throw] = ACTIONS(160),
    [anon_sym_try] = ACTIONS(163),
    [anon_sym_if] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_AT] = ACTIONS(172),
    [anon_sym_open] = ACTIONS(175),
    [anon_sym_module] = ACTIONS(178),
    [anon_sym_static] = ACTIONS(181),
    [anon_sym_package] = ACTIONS(184),
    [anon_sym_import] = ACTIONS(187),
    [anon_sym_enum] = ACTIONS(190),
    [anon_sym_public] = ACTIONS(181),
    [anon_sym_protected] = ACTIONS(181),
    [anon_sym_private] = ACTIONS(181),
    [anon_sym_abstract] = ACTIONS(181),
    [anon_sym_final] = ACTIONS(181),
    [anon_sym_strictfp] = ACTIONS(181),
    [anon_sym_native] = ACTIONS(181),
    [anon_sym_transient] = ACTIONS(181),
    [anon_sym_volatile] = ACTIONS(181),
    [anon_sym_ATinterface] = ACTIONS(193),
    [anon_sym_interface] = ACTIONS(196),
    [anon_sym_byte] = ACTIONS(199),
    [anon_sym_short] = ACTIONS(199),
    [anon_sym_int] = ACTIONS(199),
    [anon_sym_long] = ACTIONS(199),
    [anon_sym_char] = ACTIONS(199),
    [anon_sym_float] = ACTIONS(202),
    [anon_sym_double] = ACTIONS(202),
    [sym_boolean_type] = ACTIONS(205),
    [sym_void_type] = ACTIONS(205),
    [sym_this] = ACTIONS(208),
    [sym_super] = ACTIONS(211),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_switch_label] = STATE(4),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_switch_block_repeat1] = STATE(4),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(91),
    [anon_sym_default] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [ts_builtin_sym_end] = ACTIONS(216),
    [sym_identifier] = ACTIONS(218),
    [sym_decimal_integer_literal] = ACTIONS(221),
    [sym_hex_integer_literal] = ACTIONS(221),
    [sym_octal_integer_literal] = ACTIONS(224),
    [sym_binary_integer_literal] = ACTIONS(224),
    [sym_decimal_floating_point_literal] = ACTIONS(224),
    [sym_hex_floating_point_literal] = ACTIONS(221),
    [sym_true] = ACTIONS(221),
    [sym_false] = ACTIONS(221),
    [sym_character_literal] = ACTIONS(224),
    [sym_string_literal] = ACTIONS(224),
    [sym_null_literal] = ACTIONS(221),
    [anon_sym_LPAREN] = ACTIONS(227),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(233),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_new] = ACTIONS(239),
    [anon_sym_class] = ACTIONS(242),
    [anon_sym_SEMI] = ACTIONS(245),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_assert] = ACTIONS(251),
    [anon_sym_switch] = ACTIONS(254),
    [anon_sym_default] = ACTIONS(257),
    [anon_sym_do] = ACTIONS(260),
    [anon_sym_while] = ACTIONS(263),
    [anon_sym_break] = ACTIONS(266),
    [anon_sym_continue] = ACTIONS(269),
    [anon_sym_return] = ACTIONS(272),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_throw] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(284),
    [anon_sym_for] = ACTIONS(287),
    [anon_sym_AT] = ACTIONS(290),
    [anon_sym_open] = ACTIONS(293),
    [anon_sym_module] = ACTIONS(296),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_package] = ACTIONS(299),
    [anon_sym_import] = ACTIONS(302),
    [anon_sym_enum] = ACTIONS(305),
    [anon_sym_public] = ACTIONS(257),
    [anon_sym_protected] = ACTIONS(257),
    [anon_sym_private] = ACTIONS(257),
    [anon_sym_abstract] = ACTIONS(257),
    [anon_sym_final] = ACTIONS(257),
    [anon_sym_strictfp] = ACTIONS(257),
    [anon_sym_native] = ACTIONS(257),
    [anon_sym_transient] = ACTIONS(257),
    [anon_sym_volatile] = ACTIONS(257),
    [anon_sym_ATinterface] = ACTIONS(308),
    [anon_sym_interface] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(314),
    [anon_sym_short] = ACTIONS(314),
    [anon_sym_int] = ACTIONS(314),
    [anon_sym_long] = ACTIONS(314),
    [anon_sym_char] = ACTIONS(314),
    [anon_sym_float] = ACTIONS(317),
    [anon_sym_double] = ACTIONS(317),
    [sym_boolean_type] = ACTIONS(320),
    [sym_void_type] = ACTIONS(320),
    [sym_this] = ACTIONS(323),
    [sym_super] = ACTIONS(326),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(13),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(331),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [ts_builtin_sym_end] = ACTIONS(333),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(9),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(339),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(12),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(341),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(205),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(175),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(200),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(185),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(196),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(122),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(114),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(159),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(160),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(161),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(144),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(121),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(152),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(173),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(132),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(162),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(955),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(136),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(165),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(181),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(138),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(199),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(146),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(170),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(174),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(186),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(189),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(118),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(195),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(153),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_statement] = STATE(120),
    [sym_block] = STATE(124),
    [sym_expression_statement] = STATE(124),
    [sym_labeled_statement] = STATE(124),
    [sym_assert_statement] = STATE(124),
    [sym_switch_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_break_statement] = STATE(124),
    [sym_continue_statement] = STATE(124),
    [sym_return_statement] = STATE(124),
    [sym_synchronized_statement] = STATE(124),
    [sym_throw_statement] = STATE(124),
    [sym_try_statement] = STATE(124),
    [sym_try_with_resources_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_enhanced_for_statement] = STATE(124),
    [sym__annotation] = STATE(377),
    [sym_marker_annotation] = STATE(377),
    [sym_annotation] = STATE(377),
    [sym_declaration] = STATE(124),
    [sym_module_declaration] = STATE(203),
    [sym_package_declaration] = STATE(203),
    [sym_import_declaration] = STATE(203),
    [sym_enum_declaration] = STATE(203),
    [sym_class_declaration] = STATE(203),
    [sym_modifiers] = STATE(489),
    [sym_annotation_type_declaration] = STATE(203),
    [sym_interface_declaration] = STATE(203),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(513),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(124),
    [aux_sym_dimensions_expr_repeat1] = STATE(451),
    [aux_sym_modifiers_repeat1] = STATE(309),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(343),
    [sym_identifier] = ACTIONS(345),
    [sym_decimal_integer_literal] = ACTIONS(345),
    [sym_hex_integer_literal] = ACTIONS(345),
    [sym_octal_integer_literal] = ACTIONS(343),
    [sym_binary_integer_literal] = ACTIONS(343),
    [sym_decimal_floating_point_literal] = ACTIONS(343),
    [sym_hex_floating_point_literal] = ACTIONS(345),
    [sym_true] = ACTIONS(345),
    [sym_false] = ACTIONS(345),
    [sym_character_literal] = ACTIONS(343),
    [sym_string_literal] = ACTIONS(343),
    [sym_null_literal] = ACTIONS(345),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_AMP] = ACTIONS(345),
    [anon_sym_RPAREN] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(345),
    [anon_sym_LT] = ACTIONS(345),
    [anon_sym_EQ_EQ] = ACTIONS(343),
    [anon_sym_GT_EQ] = ACTIONS(343),
    [anon_sym_LT_EQ] = ACTIONS(343),
    [anon_sym_BANG_EQ] = ACTIONS(343),
    [anon_sym_AMP_AMP] = ACTIONS(343),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_STAR] = ACTIONS(343),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_PIPE] = ACTIONS(345),
    [anon_sym_CARET] = ACTIONS(343),
    [anon_sym_PERCENT] = ACTIONS(343),
    [anon_sym_LT_LT] = ACTIONS(343),
    [anon_sym_GT_GT] = ACTIONS(345),
    [anon_sym_GT_GT_GT] = ACTIONS(343),
    [anon_sym_instanceof] = ACTIONS(345),
    [anon_sym_COMMA] = ACTIONS(343),
    [anon_sym_QMARK] = ACTIONS(343),
    [anon_sym_COLON] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_PLUS_PLUS] = ACTIONS(343),
    [anon_sym_DASH_DASH] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(343),
    [anon_sym_RBRACK] = ACTIONS(343),
    [anon_sym_DOT] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(345),
    [anon_sym_COLON_COLON] = ACTIONS(343),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_RBRACE] = ACTIONS(343),
    [anon_sym_assert] = ACTIONS(345),
    [anon_sym_switch] = ACTIONS(345),
    [anon_sym_case] = ACTIONS(345),
    [anon_sym_default] = ACTIONS(345),
    [anon_sym_do] = ACTIONS(345),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_break] = ACTIONS(345),
    [anon_sym_continue] = ACTIONS(345),
    [anon_sym_return] = ACTIONS(345),
    [anon_sym_synchronized] = ACTIONS(345),
    [anon_sym_throw] = ACTIONS(345),
    [anon_sym_try] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(345),
    [anon_sym_else] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(345),
    [anon_sym_AT] = ACTIONS(345),
    [anon_sym_open] = ACTIONS(345),
    [anon_sym_module] = ACTIONS(345),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_package] = ACTIONS(345),
    [anon_sym_import] = ACTIONS(345),
    [anon_sym_enum] = ACTIONS(345),
    [anon_sym_public] = ACTIONS(345),
    [anon_sym_protected] = ACTIONS(345),
    [anon_sym_private] = ACTIONS(345),
    [anon_sym_abstract] = ACTIONS(345),
    [anon_sym_final] = ACTIONS(345),
    [anon_sym_strictfp] = ACTIONS(345),
    [anon_sym_native] = ACTIONS(345),
    [anon_sym_transient] = ACTIONS(345),
    [anon_sym_volatile] = ACTIONS(345),
    [anon_sym_ATinterface] = ACTIONS(343),
    [anon_sym_interface] = ACTIONS(345),
    [anon_sym_byte] = ACTIONS(345),
    [anon_sym_short] = ACTIONS(345),
    [anon_sym_int] = ACTIONS(345),
    [anon_sym_long] = ACTIONS(345),
    [anon_sym_char] = ACTIONS(345),
    [anon_sym_float] = ACTIONS(345),
    [anon_sym_double] = ACTIONS(345),
    [sym_boolean_type] = ACTIONS(345),
    [sym_void_type] = ACTIONS(345),
    [sym_this] = ACTIONS(345),
    [sym_super] = ACTIONS(345),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(347),
    [sym_identifier] = ACTIONS(349),
    [sym_decimal_integer_literal] = ACTIONS(349),
    [sym_hex_integer_literal] = ACTIONS(349),
    [sym_octal_integer_literal] = ACTIONS(347),
    [sym_binary_integer_literal] = ACTIONS(347),
    [sym_decimal_floating_point_literal] = ACTIONS(347),
    [sym_hex_floating_point_literal] = ACTIONS(349),
    [sym_true] = ACTIONS(349),
    [sym_false] = ACTIONS(349),
    [sym_character_literal] = ACTIONS(347),
    [sym_string_literal] = ACTIONS(347),
    [sym_null_literal] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(347),
    [anon_sym_AMP] = ACTIONS(349),
    [anon_sym_RPAREN] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(349),
    [anon_sym_LT] = ACTIONS(349),
    [anon_sym_EQ_EQ] = ACTIONS(347),
    [anon_sym_GT_EQ] = ACTIONS(347),
    [anon_sym_LT_EQ] = ACTIONS(347),
    [anon_sym_BANG_EQ] = ACTIONS(347),
    [anon_sym_AMP_AMP] = ACTIONS(347),
    [anon_sym_PIPE_PIPE] = ACTIONS(347),
    [anon_sym_PLUS] = ACTIONS(349),
    [anon_sym_DASH] = ACTIONS(349),
    [anon_sym_STAR] = ACTIONS(347),
    [anon_sym_SLASH] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(349),
    [anon_sym_CARET] = ACTIONS(347),
    [anon_sym_PERCENT] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_GT_GT_GT] = ACTIONS(347),
    [anon_sym_instanceof] = ACTIONS(349),
    [anon_sym_COMMA] = ACTIONS(347),
    [anon_sym_QMARK] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(349),
    [anon_sym_BANG] = ACTIONS(349),
    [anon_sym_TILDE] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_new] = ACTIONS(349),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(347),
    [anon_sym_DOT] = ACTIONS(349),
    [anon_sym_class] = ACTIONS(349),
    [anon_sym_COLON_COLON] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_LBRACE] = ACTIONS(347),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_assert] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_case] = ACTIONS(349),
    [anon_sym_default] = ACTIONS(349),
    [anon_sym_do] = ACTIONS(349),
    [anon_sym_while] = ACTIONS(349),
    [anon_sym_break] = ACTIONS(349),
    [anon_sym_continue] = ACTIONS(349),
    [anon_sym_return] = ACTIONS(349),
    [anon_sym_synchronized] = ACTIONS(349),
    [anon_sym_throw] = ACTIONS(349),
    [anon_sym_try] = ACTIONS(349),
    [anon_sym_if] = ACTIONS(349),
    [anon_sym_else] = ACTIONS(349),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_AT] = ACTIONS(349),
    [anon_sym_open] = ACTIONS(349),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_package] = ACTIONS(349),
    [anon_sym_import] = ACTIONS(349),
    [anon_sym_enum] = ACTIONS(349),
    [anon_sym_public] = ACTIONS(349),
    [anon_sym_protected] = ACTIONS(349),
    [anon_sym_private] = ACTIONS(349),
    [anon_sym_abstract] = ACTIONS(349),
    [anon_sym_final] = ACTIONS(349),
    [anon_sym_strictfp] = ACTIONS(349),
    [anon_sym_native] = ACTIONS(349),
    [anon_sym_transient] = ACTIONS(349),
    [anon_sym_volatile] = ACTIONS(349),
    [anon_sym_ATinterface] = ACTIONS(347),
    [anon_sym_interface] = ACTIONS(349),
    [anon_sym_byte] = ACTIONS(349),
    [anon_sym_short] = ACTIONS(349),
    [anon_sym_int] = ACTIONS(349),
    [anon_sym_long] = ACTIONS(349),
    [anon_sym_char] = ACTIONS(349),
    [anon_sym_float] = ACTIONS(349),
    [anon_sym_double] = ACTIONS(349),
    [sym_boolean_type] = ACTIONS(349),
    [sym_void_type] = ACTIONS(349),
    [sym_this] = ACTIONS(349),
    [sym_super] = ACTIONS(349),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(351),
    [sym_identifier] = ACTIONS(353),
    [sym_decimal_integer_literal] = ACTIONS(353),
    [sym_hex_integer_literal] = ACTIONS(353),
    [sym_octal_integer_literal] = ACTIONS(351),
    [sym_binary_integer_literal] = ACTIONS(351),
    [sym_decimal_floating_point_literal] = ACTIONS(351),
    [sym_hex_floating_point_literal] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_character_literal] = ACTIONS(351),
    [sym_string_literal] = ACTIONS(351),
    [sym_null_literal] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_AMP] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(351),
    [anon_sym_GT] = ACTIONS(353),
    [anon_sym_LT] = ACTIONS(353),
    [anon_sym_EQ_EQ] = ACTIONS(351),
    [anon_sym_GT_EQ] = ACTIONS(351),
    [anon_sym_LT_EQ] = ACTIONS(351),
    [anon_sym_BANG_EQ] = ACTIONS(351),
    [anon_sym_AMP_AMP] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(353),
    [anon_sym_DASH] = ACTIONS(353),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_SLASH] = ACTIONS(353),
    [anon_sym_PIPE] = ACTIONS(353),
    [anon_sym_CARET] = ACTIONS(351),
    [anon_sym_PERCENT] = ACTIONS(351),
    [anon_sym_LT_LT] = ACTIONS(351),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_GT_GT_GT] = ACTIONS(351),
    [anon_sym_instanceof] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(351),
    [anon_sym_QMARK] = ACTIONS(351),
    [anon_sym_COLON] = ACTIONS(351),
    [anon_sym_BANG] = ACTIONS(353),
    [anon_sym_TILDE] = ACTIONS(351),
    [anon_sym_PLUS_PLUS] = ACTIONS(351),
    [anon_sym_DASH_DASH] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_RBRACK] = ACTIONS(351),
    [anon_sym_class] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(351),
    [anon_sym_assert] = ACTIONS(353),
    [anon_sym_switch] = ACTIONS(353),
    [anon_sym_case] = ACTIONS(353),
    [anon_sym_default] = ACTIONS(353),
    [anon_sym_do] = ACTIONS(353),
    [anon_sym_while] = ACTIONS(353),
    [anon_sym_break] = ACTIONS(353),
    [anon_sym_continue] = ACTIONS(353),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_synchronized] = ACTIONS(353),
    [anon_sym_throw] = ACTIONS(353),
    [anon_sym_try] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_else] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(353),
    [anon_sym_AT] = ACTIONS(353),
    [anon_sym_open] = ACTIONS(353),
    [anon_sym_module] = ACTIONS(353),
    [anon_sym_static] = ACTIONS(353),
    [anon_sym_package] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(353),
    [anon_sym_enum] = ACTIONS(353),
    [anon_sym_public] = ACTIONS(353),
    [anon_sym_protected] = ACTIONS(353),
    [anon_sym_private] = ACTIONS(353),
    [anon_sym_abstract] = ACTIONS(353),
    [anon_sym_final] = ACTIONS(353),
    [anon_sym_strictfp] = ACTIONS(353),
    [anon_sym_native] = ACTIONS(353),
    [anon_sym_transient] = ACTIONS(353),
    [anon_sym_volatile] = ACTIONS(353),
    [anon_sym_ATinterface] = ACTIONS(351),
    [anon_sym_interface] = ACTIONS(353),
    [anon_sym_byte] = ACTIONS(353),
    [anon_sym_short] = ACTIONS(353),
    [anon_sym_int] = ACTIONS(353),
    [anon_sym_long] = ACTIONS(353),
    [anon_sym_char] = ACTIONS(353),
    [anon_sym_float] = ACTIONS(353),
    [anon_sym_double] = ACTIONS(353),
    [sym_boolean_type] = ACTIONS(353),
    [sym_void_type] = ACTIONS(353),
    [sym_this] = ACTIONS(353),
    [sym_super] = ACTIONS(353),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(355),
    [sym_identifier] = ACTIONS(357),
    [sym_decimal_integer_literal] = ACTIONS(357),
    [sym_hex_integer_literal] = ACTIONS(357),
    [sym_octal_integer_literal] = ACTIONS(355),
    [sym_binary_integer_literal] = ACTIONS(355),
    [sym_decimal_floating_point_literal] = ACTIONS(355),
    [sym_hex_floating_point_literal] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_character_literal] = ACTIONS(355),
    [sym_string_literal] = ACTIONS(355),
    [sym_null_literal] = ACTIONS(357),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(357),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(357),
    [anon_sym_LT] = ACTIONS(357),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(355),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_STAR] = ACTIONS(355),
    [anon_sym_SLASH] = ACTIONS(357),
    [anon_sym_PIPE] = ACTIONS(357),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(357),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(357),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_COLON] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(355),
    [anon_sym_DASH_DASH] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(357),
    [anon_sym_RBRACK] = ACTIONS(355),
    [anon_sym_class] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_assert] = ACTIONS(357),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_case] = ACTIONS(357),
    [anon_sym_default] = ACTIONS(357),
    [anon_sym_do] = ACTIONS(357),
    [anon_sym_while] = ACTIONS(357),
    [anon_sym_break] = ACTIONS(357),
    [anon_sym_continue] = ACTIONS(357),
    [anon_sym_return] = ACTIONS(357),
    [anon_sym_synchronized] = ACTIONS(357),
    [anon_sym_throw] = ACTIONS(357),
    [anon_sym_try] = ACTIONS(357),
    [anon_sym_if] = ACTIONS(357),
    [anon_sym_else] = ACTIONS(357),
    [anon_sym_for] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(357),
    [anon_sym_open] = ACTIONS(357),
    [anon_sym_module] = ACTIONS(357),
    [anon_sym_static] = ACTIONS(357),
    [anon_sym_package] = ACTIONS(357),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_enum] = ACTIONS(357),
    [anon_sym_public] = ACTIONS(357),
    [anon_sym_protected] = ACTIONS(357),
    [anon_sym_private] = ACTIONS(357),
    [anon_sym_abstract] = ACTIONS(357),
    [anon_sym_final] = ACTIONS(357),
    [anon_sym_strictfp] = ACTIONS(357),
    [anon_sym_native] = ACTIONS(357),
    [anon_sym_transient] = ACTIONS(357),
    [anon_sym_volatile] = ACTIONS(357),
    [anon_sym_ATinterface] = ACTIONS(355),
    [anon_sym_interface] = ACTIONS(357),
    [anon_sym_byte] = ACTIONS(357),
    [anon_sym_short] = ACTIONS(357),
    [anon_sym_int] = ACTIONS(357),
    [anon_sym_long] = ACTIONS(357),
    [anon_sym_char] = ACTIONS(357),
    [anon_sym_float] = ACTIONS(357),
    [anon_sym_double] = ACTIONS(357),
    [sym_boolean_type] = ACTIONS(357),
    [sym_void_type] = ACTIONS(357),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_identifier] = ACTIONS(359),
    [sym_decimal_integer_literal] = ACTIONS(359),
    [sym_hex_integer_literal] = ACTIONS(359),
    [sym_octal_integer_literal] = ACTIONS(361),
    [sym_binary_integer_literal] = ACTIONS(361),
    [sym_decimal_floating_point_literal] = ACTIONS(361),
    [sym_hex_floating_point_literal] = ACTIONS(359),
    [sym_true] = ACTIONS(359),
    [sym_false] = ACTIONS(359),
    [sym_character_literal] = ACTIONS(361),
    [sym_string_literal] = ACTIONS(361),
    [sym_null_literal] = ACTIONS(359),
    [anon_sym_LPAREN] = ACTIONS(361),
    [anon_sym_AMP] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(361),
    [anon_sym_GT] = ACTIONS(359),
    [anon_sym_LT] = ACTIONS(359),
    [anon_sym_EQ_EQ] = ACTIONS(361),
    [anon_sym_GT_EQ] = ACTIONS(361),
    [anon_sym_LT_EQ] = ACTIONS(361),
    [anon_sym_BANG_EQ] = ACTIONS(361),
    [anon_sym_AMP_AMP] = ACTIONS(361),
    [anon_sym_PIPE_PIPE] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_STAR] = ACTIONS(361),
    [anon_sym_SLASH] = ACTIONS(359),
    [anon_sym_PIPE] = ACTIONS(359),
    [anon_sym_CARET] = ACTIONS(361),
    [anon_sym_PERCENT] = ACTIONS(361),
    [anon_sym_LT_LT] = ACTIONS(361),
    [anon_sym_GT_GT] = ACTIONS(359),
    [anon_sym_GT_GT_GT] = ACTIONS(361),
    [anon_sym_instanceof] = ACTIONS(359),
    [anon_sym_COMMA] = ACTIONS(361),
    [anon_sym_QMARK] = ACTIONS(361),
    [anon_sym_COLON] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_new] = ACTIONS(359),
    [anon_sym_LBRACK] = ACTIONS(361),
    [anon_sym_RBRACK] = ACTIONS(361),
    [anon_sym_DOT] = ACTIONS(359),
    [anon_sym_class] = ACTIONS(359),
    [anon_sym_COLON_COLON] = ACTIONS(361),
    [anon_sym_SEMI] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_assert] = ACTIONS(359),
    [anon_sym_switch] = ACTIONS(359),
    [anon_sym_default] = ACTIONS(359),
    [anon_sym_do] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(359),
    [anon_sym_break] = ACTIONS(359),
    [anon_sym_continue] = ACTIONS(359),
    [anon_sym_return] = ACTIONS(359),
    [anon_sym_synchronized] = ACTIONS(359),
    [anon_sym_throw] = ACTIONS(359),
    [anon_sym_try] = ACTIONS(359),
    [anon_sym_if] = ACTIONS(359),
    [anon_sym_for] = ACTIONS(359),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_open] = ACTIONS(359),
    [anon_sym_module] = ACTIONS(359),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_package] = ACTIONS(359),
    [anon_sym_import] = ACTIONS(359),
    [anon_sym_enum] = ACTIONS(359),
    [anon_sym_public] = ACTIONS(359),
    [anon_sym_protected] = ACTIONS(359),
    [anon_sym_private] = ACTIONS(359),
    [anon_sym_abstract] = ACTIONS(359),
    [anon_sym_final] = ACTIONS(359),
    [anon_sym_strictfp] = ACTIONS(359),
    [anon_sym_native] = ACTIONS(359),
    [anon_sym_transient] = ACTIONS(359),
    [anon_sym_volatile] = ACTIONS(359),
    [anon_sym_ATinterface] = ACTIONS(361),
    [anon_sym_interface] = ACTIONS(359),
    [anon_sym_byte] = ACTIONS(359),
    [anon_sym_short] = ACTIONS(359),
    [anon_sym_int] = ACTIONS(359),
    [anon_sym_long] = ACTIONS(359),
    [anon_sym_char] = ACTIONS(359),
    [anon_sym_float] = ACTIONS(359),
    [anon_sym_double] = ACTIONS(359),
    [sym_boolean_type] = ACTIONS(359),
    [sym_void_type] = ACTIONS(359),
    [sym_this] = ACTIONS(359),
    [sym_super] = ACTIONS(359),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(455),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(468),
    [sym_marker_annotation] = STATE(468),
    [sym_annotation] = STATE(468),
    [sym_modifiers] = STATE(512),
    [sym__type] = STATE(688),
    [sym__unannotated_type] = STATE(502),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_formal_parameter] = STATE(751),
    [sym_receiver_parameter] = STATE(279),
    [sym_spread_parameter] = STATE(751),
    [aux_sym_dimensions_expr_repeat1] = STATE(483),
    [aux_sym_modifiers_repeat1] = STATE(404),
    [sym_identifier] = ACTIONS(363),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(417),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(468),
    [sym_marker_annotation] = STATE(468),
    [sym_annotation] = STATE(468),
    [sym_modifiers] = STATE(507),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(509),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [sym_local_variable_declaration] = STATE(171),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [aux_sym_modifiers_repeat1] = STATE(404),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(375),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_catch_clause] = STATE(59),
    [sym_finally_clause] = STATE(128),
    [aux_sym_try_statement_repeat1] = STATE(59),
    [ts_builtin_sym_end] = ACTIONS(377),
    [sym_identifier] = ACTIONS(379),
    [sym_decimal_integer_literal] = ACTIONS(379),
    [sym_hex_integer_literal] = ACTIONS(379),
    [sym_octal_integer_literal] = ACTIONS(377),
    [sym_binary_integer_literal] = ACTIONS(377),
    [sym_decimal_floating_point_literal] = ACTIONS(377),
    [sym_hex_floating_point_literal] = ACTIONS(379),
    [sym_true] = ACTIONS(379),
    [sym_false] = ACTIONS(379),
    [sym_character_literal] = ACTIONS(377),
    [sym_string_literal] = ACTIONS(377),
    [sym_null_literal] = ACTIONS(379),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(377),
    [anon_sym_PLUS_PLUS] = ACTIONS(377),
    [anon_sym_DASH_DASH] = ACTIONS(377),
    [anon_sym_new] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_RBRACE] = ACTIONS(377),
    [anon_sym_assert] = ACTIONS(379),
    [anon_sym_switch] = ACTIONS(379),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(379),
    [anon_sym_do] = ACTIONS(379),
    [anon_sym_while] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(379),
    [anon_sym_return] = ACTIONS(379),
    [anon_sym_synchronized] = ACTIONS(379),
    [anon_sym_throw] = ACTIONS(379),
    [anon_sym_try] = ACTIONS(379),
    [anon_sym_catch] = ACTIONS(381),
    [anon_sym_finally] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_else] = ACTIONS(379),
    [anon_sym_for] = ACTIONS(379),
    [anon_sym_AT] = ACTIONS(379),
    [anon_sym_open] = ACTIONS(379),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_package] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(379),
    [anon_sym_enum] = ACTIONS(379),
    [anon_sym_public] = ACTIONS(379),
    [anon_sym_protected] = ACTIONS(379),
    [anon_sym_private] = ACTIONS(379),
    [anon_sym_abstract] = ACTIONS(379),
    [anon_sym_final] = ACTIONS(379),
    [anon_sym_strictfp] = ACTIONS(379),
    [anon_sym_native] = ACTIONS(379),
    [anon_sym_transient] = ACTIONS(379),
    [anon_sym_volatile] = ACTIONS(379),
    [anon_sym_ATinterface] = ACTIONS(377),
    [anon_sym_interface] = ACTIONS(379),
    [anon_sym_byte] = ACTIONS(379),
    [anon_sym_short] = ACTIONS(379),
    [anon_sym_int] = ACTIONS(379),
    [anon_sym_long] = ACTIONS(379),
    [anon_sym_char] = ACTIONS(379),
    [anon_sym_float] = ACTIONS(379),
    [anon_sym_double] = ACTIONS(379),
    [sym_boolean_type] = ACTIONS(379),
    [sym_void_type] = ACTIONS(379),
    [sym_this] = ACTIONS(379),
    [sym_super] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_catch_clause] = STATE(55),
    [sym_finally_clause] = STATE(129),
    [aux_sym_try_statement_repeat1] = STATE(55),
    [ts_builtin_sym_end] = ACTIONS(385),
    [sym_identifier] = ACTIONS(387),
    [sym_decimal_integer_literal] = ACTIONS(387),
    [sym_hex_integer_literal] = ACTIONS(387),
    [sym_octal_integer_literal] = ACTIONS(385),
    [sym_binary_integer_literal] = ACTIONS(385),
    [sym_decimal_floating_point_literal] = ACTIONS(385),
    [sym_hex_floating_point_literal] = ACTIONS(387),
    [sym_true] = ACTIONS(387),
    [sym_false] = ACTIONS(387),
    [sym_character_literal] = ACTIONS(385),
    [sym_string_literal] = ACTIONS(385),
    [sym_null_literal] = ACTIONS(387),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(387),
    [anon_sym_DASH] = ACTIONS(387),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_TILDE] = ACTIONS(385),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_new] = ACTIONS(387),
    [anon_sym_class] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_LBRACE] = ACTIONS(385),
    [anon_sym_RBRACE] = ACTIONS(385),
    [anon_sym_assert] = ACTIONS(387),
    [anon_sym_switch] = ACTIONS(387),
    [anon_sym_case] = ACTIONS(387),
    [anon_sym_default] = ACTIONS(387),
    [anon_sym_do] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(387),
    [anon_sym_break] = ACTIONS(387),
    [anon_sym_continue] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_synchronized] = ACTIONS(387),
    [anon_sym_throw] = ACTIONS(387),
    [anon_sym_try] = ACTIONS(387),
    [anon_sym_catch] = ACTIONS(381),
    [anon_sym_finally] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(387),
    [anon_sym_else] = ACTIONS(387),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_AT] = ACTIONS(387),
    [anon_sym_open] = ACTIONS(387),
    [anon_sym_module] = ACTIONS(387),
    [anon_sym_static] = ACTIONS(387),
    [anon_sym_package] = ACTIONS(387),
    [anon_sym_import] = ACTIONS(387),
    [anon_sym_enum] = ACTIONS(387),
    [anon_sym_public] = ACTIONS(387),
    [anon_sym_protected] = ACTIONS(387),
    [anon_sym_private] = ACTIONS(387),
    [anon_sym_abstract] = ACTIONS(387),
    [anon_sym_final] = ACTIONS(387),
    [anon_sym_strictfp] = ACTIONS(387),
    [anon_sym_native] = ACTIONS(387),
    [anon_sym_transient] = ACTIONS(387),
    [anon_sym_volatile] = ACTIONS(387),
    [anon_sym_ATinterface] = ACTIONS(385),
    [anon_sym_interface] = ACTIONS(387),
    [anon_sym_byte] = ACTIONS(387),
    [anon_sym_short] = ACTIONS(387),
    [anon_sym_int] = ACTIONS(387),
    [anon_sym_long] = ACTIONS(387),
    [anon_sym_char] = ACTIONS(387),
    [anon_sym_float] = ACTIONS(387),
    [anon_sym_double] = ACTIONS(387),
    [sym_boolean_type] = ACTIONS(387),
    [sym_void_type] = ACTIONS(387),
    [sym_this] = ACTIONS(387),
    [sym_super] = ACTIONS(387),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_catch_clause] = STATE(59),
    [sym_finally_clause] = STATE(197),
    [aux_sym_try_statement_repeat1] = STATE(59),
    [ts_builtin_sym_end] = ACTIONS(389),
    [sym_identifier] = ACTIONS(391),
    [sym_decimal_integer_literal] = ACTIONS(391),
    [sym_hex_integer_literal] = ACTIONS(391),
    [sym_octal_integer_literal] = ACTIONS(389),
    [sym_binary_integer_literal] = ACTIONS(389),
    [sym_decimal_floating_point_literal] = ACTIONS(389),
    [sym_hex_floating_point_literal] = ACTIONS(391),
    [sym_true] = ACTIONS(391),
    [sym_false] = ACTIONS(391),
    [sym_character_literal] = ACTIONS(389),
    [sym_string_literal] = ACTIONS(389),
    [sym_null_literal] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(391),
    [anon_sym_DASH] = ACTIONS(391),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_TILDE] = ACTIONS(389),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(391),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_RBRACE] = ACTIONS(389),
    [anon_sym_assert] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(391),
    [anon_sym_case] = ACTIONS(391),
    [anon_sym_default] = ACTIONS(391),
    [anon_sym_do] = ACTIONS(391),
    [anon_sym_while] = ACTIONS(391),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(391),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_synchronized] = ACTIONS(391),
    [anon_sym_throw] = ACTIONS(391),
    [anon_sym_try] = ACTIONS(391),
    [anon_sym_catch] = ACTIONS(381),
    [anon_sym_finally] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_else] = ACTIONS(391),
    [anon_sym_for] = ACTIONS(391),
    [anon_sym_AT] = ACTIONS(391),
    [anon_sym_open] = ACTIONS(391),
    [anon_sym_module] = ACTIONS(391),
    [anon_sym_static] = ACTIONS(391),
    [anon_sym_package] = ACTIONS(391),
    [anon_sym_import] = ACTIONS(391),
    [anon_sym_enum] = ACTIONS(391),
    [anon_sym_public] = ACTIONS(391),
    [anon_sym_protected] = ACTIONS(391),
    [anon_sym_private] = ACTIONS(391),
    [anon_sym_abstract] = ACTIONS(391),
    [anon_sym_final] = ACTIONS(391),
    [anon_sym_strictfp] = ACTIONS(391),
    [anon_sym_native] = ACTIONS(391),
    [anon_sym_transient] = ACTIONS(391),
    [anon_sym_volatile] = ACTIONS(391),
    [anon_sym_ATinterface] = ACTIONS(389),
    [anon_sym_interface] = ACTIONS(391),
    [anon_sym_byte] = ACTIONS(391),
    [anon_sym_short] = ACTIONS(391),
    [anon_sym_int] = ACTIONS(391),
    [anon_sym_long] = ACTIONS(391),
    [anon_sym_char] = ACTIONS(391),
    [anon_sym_float] = ACTIONS(391),
    [anon_sym_double] = ACTIONS(391),
    [sym_boolean_type] = ACTIONS(391),
    [sym_void_type] = ACTIONS(391),
    [sym_this] = ACTIONS(391),
    [sym_super] = ACTIONS(391),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym_element_value_pair] = STATE(708),
    [sym__element_value] = STATE(897),
    [sym_element_value_array_initializer] = STATE(897),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(393),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(395),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(752),
    [sym_element_value_array_initializer] = STATE(752),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_RBRACE] = ACTIONS(401),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym_element_value_pair] = STATE(779),
    [sym__element_value] = STATE(953),
    [sym_element_value_array_initializer] = STATE(953),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(393),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(403),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_catch_clause] = STATE(59),
    [aux_sym_try_statement_repeat1] = STATE(59),
    [ts_builtin_sym_end] = ACTIONS(405),
    [sym_identifier] = ACTIONS(407),
    [sym_decimal_integer_literal] = ACTIONS(407),
    [sym_hex_integer_literal] = ACTIONS(407),
    [sym_octal_integer_literal] = ACTIONS(405),
    [sym_binary_integer_literal] = ACTIONS(405),
    [sym_decimal_floating_point_literal] = ACTIONS(405),
    [sym_hex_floating_point_literal] = ACTIONS(407),
    [sym_true] = ACTIONS(407),
    [sym_false] = ACTIONS(407),
    [sym_character_literal] = ACTIONS(405),
    [sym_string_literal] = ACTIONS(405),
    [sym_null_literal] = ACTIONS(407),
    [anon_sym_LPAREN] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_TILDE] = ACTIONS(405),
    [anon_sym_PLUS_PLUS] = ACTIONS(405),
    [anon_sym_DASH_DASH] = ACTIONS(405),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(407),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_LBRACE] = ACTIONS(405),
    [anon_sym_RBRACE] = ACTIONS(405),
    [anon_sym_assert] = ACTIONS(407),
    [anon_sym_switch] = ACTIONS(407),
    [anon_sym_case] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(407),
    [anon_sym_do] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(407),
    [anon_sym_break] = ACTIONS(407),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_return] = ACTIONS(407),
    [anon_sym_synchronized] = ACTIONS(407),
    [anon_sym_throw] = ACTIONS(407),
    [anon_sym_try] = ACTIONS(407),
    [anon_sym_catch] = ACTIONS(409),
    [anon_sym_finally] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(407),
    [anon_sym_else] = ACTIONS(407),
    [anon_sym_for] = ACTIONS(407),
    [anon_sym_AT] = ACTIONS(407),
    [anon_sym_open] = ACTIONS(407),
    [anon_sym_module] = ACTIONS(407),
    [anon_sym_static] = ACTIONS(407),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(407),
    [anon_sym_enum] = ACTIONS(407),
    [anon_sym_public] = ACTIONS(407),
    [anon_sym_protected] = ACTIONS(407),
    [anon_sym_private] = ACTIONS(407),
    [anon_sym_abstract] = ACTIONS(407),
    [anon_sym_final] = ACTIONS(407),
    [anon_sym_strictfp] = ACTIONS(407),
    [anon_sym_native] = ACTIONS(407),
    [anon_sym_transient] = ACTIONS(407),
    [anon_sym_volatile] = ACTIONS(407),
    [anon_sym_ATinterface] = ACTIONS(405),
    [anon_sym_interface] = ACTIONS(407),
    [anon_sym_byte] = ACTIONS(407),
    [anon_sym_short] = ACTIONS(407),
    [anon_sym_int] = ACTIONS(407),
    [anon_sym_long] = ACTIONS(407),
    [anon_sym_char] = ACTIONS(407),
    [anon_sym_float] = ACTIONS(407),
    [anon_sym_double] = ACTIONS(407),
    [sym_boolean_type] = ACTIONS(407),
    [sym_void_type] = ACTIONS(407),
    [sym_this] = ACTIONS(407),
    [sym_super] = ACTIONS(407),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(820),
    [sym_element_value_array_initializer] = STATE(820),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_RBRACE] = ACTIONS(412),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(431),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym_array_initializer] = STATE(758),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(416),
    [anon_sym_RBRACE] = ACTIONS(418),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(820),
    [sym_element_value_array_initializer] = STATE(820),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_RBRACE] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(440),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(863),
    [sym_element_value_array_initializer] = STATE(863),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [ts_builtin_sym_end] = ACTIONS(422),
    [sym_identifier] = ACTIONS(424),
    [sym_decimal_integer_literal] = ACTIONS(424),
    [sym_hex_integer_literal] = ACTIONS(424),
    [sym_octal_integer_literal] = ACTIONS(422),
    [sym_binary_integer_literal] = ACTIONS(422),
    [sym_decimal_floating_point_literal] = ACTIONS(422),
    [sym_hex_floating_point_literal] = ACTIONS(424),
    [sym_true] = ACTIONS(424),
    [sym_false] = ACTIONS(424),
    [sym_character_literal] = ACTIONS(422),
    [sym_string_literal] = ACTIONS(422),
    [sym_null_literal] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(422),
    [anon_sym_PLUS] = ACTIONS(424),
    [anon_sym_DASH] = ACTIONS(424),
    [anon_sym_BANG] = ACTIONS(422),
    [anon_sym_TILDE] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(422),
    [anon_sym_DASH_DASH] = ACTIONS(422),
    [anon_sym_new] = ACTIONS(424),
    [anon_sym_class] = ACTIONS(424),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_LBRACE] = ACTIONS(422),
    [anon_sym_RBRACE] = ACTIONS(422),
    [anon_sym_assert] = ACTIONS(424),
    [anon_sym_switch] = ACTIONS(424),
    [anon_sym_case] = ACTIONS(424),
    [anon_sym_default] = ACTIONS(424),
    [anon_sym_do] = ACTIONS(424),
    [anon_sym_while] = ACTIONS(424),
    [anon_sym_break] = ACTIONS(424),
    [anon_sym_continue] = ACTIONS(424),
    [anon_sym_return] = ACTIONS(424),
    [anon_sym_synchronized] = ACTIONS(424),
    [anon_sym_throw] = ACTIONS(424),
    [anon_sym_try] = ACTIONS(424),
    [anon_sym_catch] = ACTIONS(424),
    [anon_sym_finally] = ACTIONS(424),
    [anon_sym_if] = ACTIONS(424),
    [anon_sym_else] = ACTIONS(424),
    [anon_sym_for] = ACTIONS(424),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(424),
    [anon_sym_module] = ACTIONS(424),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_package] = ACTIONS(424),
    [anon_sym_import] = ACTIONS(424),
    [anon_sym_enum] = ACTIONS(424),
    [anon_sym_public] = ACTIONS(424),
    [anon_sym_protected] = ACTIONS(424),
    [anon_sym_private] = ACTIONS(424),
    [anon_sym_abstract] = ACTIONS(424),
    [anon_sym_final] = ACTIONS(424),
    [anon_sym_strictfp] = ACTIONS(424),
    [anon_sym_native] = ACTIONS(424),
    [anon_sym_transient] = ACTIONS(424),
    [anon_sym_volatile] = ACTIONS(424),
    [anon_sym_ATinterface] = ACTIONS(422),
    [anon_sym_interface] = ACTIONS(424),
    [anon_sym_byte] = ACTIONS(424),
    [anon_sym_short] = ACTIONS(424),
    [anon_sym_int] = ACTIONS(424),
    [anon_sym_long] = ACTIONS(424),
    [anon_sym_char] = ACTIONS(424),
    [anon_sym_float] = ACTIONS(424),
    [anon_sym_double] = ACTIONS(424),
    [sym_boolean_type] = ACTIONS(424),
    [sym_void_type] = ACTIONS(424),
    [sym_this] = ACTIONS(424),
    [sym_super] = ACTIONS(424),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(914),
    [sym_element_value_array_initializer] = STATE(914),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(820),
    [sym_element_value_array_initializer] = STATE(820),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(433),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym_array_initializer] = STATE(856),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(416),
    [anon_sym_RBRACE] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(433),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym_array_initializer] = STATE(856),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(416),
    [anon_sym_RBRACE] = ACTIONS(428),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(521),
    [sym_marker_annotation] = STATE(521),
    [sym_annotation] = STATE(521),
    [sym__element_value] = STATE(863),
    [sym_element_value_array_initializer] = STATE(863),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [ts_builtin_sym_end] = ACTIONS(355),
    [sym_identifier] = ACTIONS(357),
    [sym_decimal_integer_literal] = ACTIONS(357),
    [sym_hex_integer_literal] = ACTIONS(357),
    [sym_octal_integer_literal] = ACTIONS(355),
    [sym_binary_integer_literal] = ACTIONS(355),
    [sym_decimal_floating_point_literal] = ACTIONS(355),
    [sym_hex_floating_point_literal] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_character_literal] = ACTIONS(355),
    [sym_string_literal] = ACTIONS(355),
    [sym_null_literal] = ACTIONS(357),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(355),
    [anon_sym_TILDE] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(355),
    [anon_sym_DASH_DASH] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(357),
    [anon_sym_class] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_assert] = ACTIONS(357),
    [anon_sym_switch] = ACTIONS(357),
    [anon_sym_case] = ACTIONS(357),
    [anon_sym_default] = ACTIONS(357),
    [anon_sym_do] = ACTIONS(357),
    [anon_sym_while] = ACTIONS(357),
    [anon_sym_break] = ACTIONS(357),
    [anon_sym_continue] = ACTIONS(357),
    [anon_sym_return] = ACTIONS(357),
    [anon_sym_synchronized] = ACTIONS(357),
    [anon_sym_throw] = ACTIONS(357),
    [anon_sym_try] = ACTIONS(357),
    [anon_sym_catch] = ACTIONS(357),
    [anon_sym_finally] = ACTIONS(357),
    [anon_sym_if] = ACTIONS(357),
    [anon_sym_else] = ACTIONS(357),
    [anon_sym_for] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(357),
    [anon_sym_open] = ACTIONS(357),
    [anon_sym_module] = ACTIONS(357),
    [anon_sym_static] = ACTIONS(357),
    [anon_sym_package] = ACTIONS(357),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_enum] = ACTIONS(357),
    [anon_sym_public] = ACTIONS(357),
    [anon_sym_protected] = ACTIONS(357),
    [anon_sym_private] = ACTIONS(357),
    [anon_sym_abstract] = ACTIONS(357),
    [anon_sym_final] = ACTIONS(357),
    [anon_sym_strictfp] = ACTIONS(357),
    [anon_sym_native] = ACTIONS(357),
    [anon_sym_transient] = ACTIONS(357),
    [anon_sym_volatile] = ACTIONS(357),
    [anon_sym_ATinterface] = ACTIONS(355),
    [anon_sym_interface] = ACTIONS(357),
    [anon_sym_byte] = ACTIONS(357),
    [anon_sym_short] = ACTIONS(357),
    [anon_sym_int] = ACTIONS(357),
    [anon_sym_long] = ACTIONS(357),
    [anon_sym_char] = ACTIONS(357),
    [anon_sym_float] = ACTIONS(357),
    [anon_sym_double] = ACTIONS(357),
    [sym_boolean_type] = ACTIONS(357),
    [sym_void_type] = ACTIONS(357),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(351),
    [sym_identifier] = ACTIONS(353),
    [sym_decimal_integer_literal] = ACTIONS(353),
    [sym_hex_integer_literal] = ACTIONS(353),
    [sym_octal_integer_literal] = ACTIONS(351),
    [sym_binary_integer_literal] = ACTIONS(351),
    [sym_decimal_floating_point_literal] = ACTIONS(351),
    [sym_hex_floating_point_literal] = ACTIONS(353),
    [sym_true] = ACTIONS(353),
    [sym_false] = ACTIONS(353),
    [sym_character_literal] = ACTIONS(351),
    [sym_string_literal] = ACTIONS(351),
    [sym_null_literal] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_PLUS] = ACTIONS(353),
    [anon_sym_DASH] = ACTIONS(353),
    [anon_sym_BANG] = ACTIONS(351),
    [anon_sym_TILDE] = ACTIONS(351),
    [anon_sym_PLUS_PLUS] = ACTIONS(351),
    [anon_sym_DASH_DASH] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_class] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(351),
    [anon_sym_assert] = ACTIONS(353),
    [anon_sym_switch] = ACTIONS(353),
    [anon_sym_case] = ACTIONS(353),
    [anon_sym_default] = ACTIONS(353),
    [anon_sym_do] = ACTIONS(353),
    [anon_sym_while] = ACTIONS(353),
    [anon_sym_break] = ACTIONS(353),
    [anon_sym_continue] = ACTIONS(353),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_synchronized] = ACTIONS(353),
    [anon_sym_throw] = ACTIONS(353),
    [anon_sym_try] = ACTIONS(353),
    [anon_sym_catch] = ACTIONS(353),
    [anon_sym_finally] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_else] = ACTIONS(353),
    [anon_sym_for] = ACTIONS(353),
    [anon_sym_AT] = ACTIONS(353),
    [anon_sym_open] = ACTIONS(353),
    [anon_sym_module] = ACTIONS(353),
    [anon_sym_static] = ACTIONS(353),
    [anon_sym_package] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(353),
    [anon_sym_enum] = ACTIONS(353),
    [anon_sym_public] = ACTIONS(353),
    [anon_sym_protected] = ACTIONS(353),
    [anon_sym_private] = ACTIONS(353),
    [anon_sym_abstract] = ACTIONS(353),
    [anon_sym_final] = ACTIONS(353),
    [anon_sym_strictfp] = ACTIONS(353),
    [anon_sym_native] = ACTIONS(353),
    [anon_sym_transient] = ACTIONS(353),
    [anon_sym_volatile] = ACTIONS(353),
    [anon_sym_ATinterface] = ACTIONS(351),
    [anon_sym_interface] = ACTIONS(353),
    [anon_sym_byte] = ACTIONS(353),
    [anon_sym_short] = ACTIONS(353),
    [anon_sym_int] = ACTIONS(353),
    [anon_sym_long] = ACTIONS(353),
    [anon_sym_char] = ACTIONS(353),
    [anon_sym_float] = ACTIONS(353),
    [anon_sym_double] = ACTIONS(353),
    [sym_boolean_type] = ACTIONS(353),
    [sym_void_type] = ACTIONS(353),
    [sym_this] = ACTIONS(353),
    [sym_super] = ACTIONS(353),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(430),
    [sym_identifier] = ACTIONS(432),
    [sym_decimal_integer_literal] = ACTIONS(432),
    [sym_hex_integer_literal] = ACTIONS(432),
    [sym_octal_integer_literal] = ACTIONS(430),
    [sym_binary_integer_literal] = ACTIONS(430),
    [sym_decimal_floating_point_literal] = ACTIONS(430),
    [sym_hex_floating_point_literal] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_character_literal] = ACTIONS(430),
    [sym_string_literal] = ACTIONS(430),
    [sym_null_literal] = ACTIONS(432),
    [anon_sym_LPAREN] = ACTIONS(430),
    [anon_sym_LT] = ACTIONS(430),
    [anon_sym_PLUS] = ACTIONS(432),
    [anon_sym_DASH] = ACTIONS(432),
    [anon_sym_BANG] = ACTIONS(430),
    [anon_sym_TILDE] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(432),
    [anon_sym_class] = ACTIONS(432),
    [anon_sym_SEMI] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(430),
    [anon_sym_RBRACE] = ACTIONS(430),
    [anon_sym_assert] = ACTIONS(432),
    [anon_sym_switch] = ACTIONS(432),
    [anon_sym_case] = ACTIONS(432),
    [anon_sym_default] = ACTIONS(432),
    [anon_sym_do] = ACTIONS(432),
    [anon_sym_while] = ACTIONS(432),
    [anon_sym_break] = ACTIONS(432),
    [anon_sym_continue] = ACTIONS(432),
    [anon_sym_return] = ACTIONS(432),
    [anon_sym_synchronized] = ACTIONS(432),
    [anon_sym_throw] = ACTIONS(432),
    [anon_sym_try] = ACTIONS(432),
    [anon_sym_if] = ACTIONS(432),
    [anon_sym_else] = ACTIONS(432),
    [anon_sym_for] = ACTIONS(432),
    [anon_sym_AT] = ACTIONS(432),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_static] = ACTIONS(432),
    [anon_sym_package] = ACTIONS(432),
    [anon_sym_import] = ACTIONS(432),
    [anon_sym_enum] = ACTIONS(432),
    [anon_sym_public] = ACTIONS(432),
    [anon_sym_protected] = ACTIONS(432),
    [anon_sym_private] = ACTIONS(432),
    [anon_sym_abstract] = ACTIONS(432),
    [anon_sym_final] = ACTIONS(432),
    [anon_sym_strictfp] = ACTIONS(432),
    [anon_sym_native] = ACTIONS(432),
    [anon_sym_transient] = ACTIONS(432),
    [anon_sym_volatile] = ACTIONS(432),
    [anon_sym_ATinterface] = ACTIONS(430),
    [anon_sym_interface] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(432),
    [anon_sym_short] = ACTIONS(432),
    [anon_sym_int] = ACTIONS(432),
    [anon_sym_long] = ACTIONS(432),
    [anon_sym_char] = ACTIONS(432),
    [anon_sym_float] = ACTIONS(432),
    [anon_sym_double] = ACTIONS(432),
    [sym_boolean_type] = ACTIONS(432),
    [sym_void_type] = ACTIONS(432),
    [sym_this] = ACTIONS(432),
    [sym_super] = ACTIONS(432),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(434),
    [sym_identifier] = ACTIONS(436),
    [sym_decimal_integer_literal] = ACTIONS(436),
    [sym_hex_integer_literal] = ACTIONS(436),
    [sym_octal_integer_literal] = ACTIONS(434),
    [sym_binary_integer_literal] = ACTIONS(434),
    [sym_decimal_floating_point_literal] = ACTIONS(434),
    [sym_hex_floating_point_literal] = ACTIONS(436),
    [sym_true] = ACTIONS(436),
    [sym_false] = ACTIONS(436),
    [sym_character_literal] = ACTIONS(434),
    [sym_string_literal] = ACTIONS(434),
    [sym_null_literal] = ACTIONS(436),
    [anon_sym_LPAREN] = ACTIONS(434),
    [anon_sym_LT] = ACTIONS(434),
    [anon_sym_PLUS] = ACTIONS(436),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_BANG] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(434),
    [anon_sym_PLUS_PLUS] = ACTIONS(434),
    [anon_sym_DASH_DASH] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(436),
    [anon_sym_SEMI] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(434),
    [anon_sym_assert] = ACTIONS(436),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(436),
    [anon_sym_default] = ACTIONS(436),
    [anon_sym_do] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(436),
    [anon_sym_break] = ACTIONS(436),
    [anon_sym_continue] = ACTIONS(436),
    [anon_sym_return] = ACTIONS(436),
    [anon_sym_synchronized] = ACTIONS(436),
    [anon_sym_throw] = ACTIONS(436),
    [anon_sym_try] = ACTIONS(436),
    [anon_sym_if] = ACTIONS(436),
    [anon_sym_else] = ACTIONS(436),
    [anon_sym_for] = ACTIONS(436),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_open] = ACTIONS(436),
    [anon_sym_module] = ACTIONS(436),
    [anon_sym_static] = ACTIONS(436),
    [anon_sym_package] = ACTIONS(436),
    [anon_sym_import] = ACTIONS(436),
    [anon_sym_enum] = ACTIONS(436),
    [anon_sym_public] = ACTIONS(436),
    [anon_sym_protected] = ACTIONS(436),
    [anon_sym_private] = ACTIONS(436),
    [anon_sym_abstract] = ACTIONS(436),
    [anon_sym_final] = ACTIONS(436),
    [anon_sym_strictfp] = ACTIONS(436),
    [anon_sym_native] = ACTIONS(436),
    [anon_sym_transient] = ACTIONS(436),
    [anon_sym_volatile] = ACTIONS(436),
    [anon_sym_ATinterface] = ACTIONS(434),
    [anon_sym_interface] = ACTIONS(436),
    [anon_sym_byte] = ACTIONS(436),
    [anon_sym_short] = ACTIONS(436),
    [anon_sym_int] = ACTIONS(436),
    [anon_sym_long] = ACTIONS(436),
    [anon_sym_char] = ACTIONS(436),
    [anon_sym_float] = ACTIONS(436),
    [anon_sym_double] = ACTIONS(436),
    [sym_boolean_type] = ACTIONS(436),
    [sym_void_type] = ACTIONS(436),
    [sym_this] = ACTIONS(436),
    [sym_super] = ACTIONS(436),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(438),
    [sym_identifier] = ACTIONS(440),
    [sym_decimal_integer_literal] = ACTIONS(440),
    [sym_hex_integer_literal] = ACTIONS(440),
    [sym_octal_integer_literal] = ACTIONS(438),
    [sym_binary_integer_literal] = ACTIONS(438),
    [sym_decimal_floating_point_literal] = ACTIONS(438),
    [sym_hex_floating_point_literal] = ACTIONS(440),
    [sym_true] = ACTIONS(440),
    [sym_false] = ACTIONS(440),
    [sym_character_literal] = ACTIONS(438),
    [sym_string_literal] = ACTIONS(438),
    [sym_null_literal] = ACTIONS(440),
    [anon_sym_LPAREN] = ACTIONS(438),
    [anon_sym_LT] = ACTIONS(438),
    [anon_sym_PLUS] = ACTIONS(440),
    [anon_sym_DASH] = ACTIONS(440),
    [anon_sym_BANG] = ACTIONS(438),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_PLUS_PLUS] = ACTIONS(438),
    [anon_sym_DASH_DASH] = ACTIONS(438),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_class] = ACTIONS(440),
    [anon_sym_SEMI] = ACTIONS(438),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(438),
    [anon_sym_assert] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(440),
    [anon_sym_case] = ACTIONS(440),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_do] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(440),
    [anon_sym_break] = ACTIONS(440),
    [anon_sym_continue] = ACTIONS(440),
    [anon_sym_return] = ACTIONS(440),
    [anon_sym_synchronized] = ACTIONS(440),
    [anon_sym_throw] = ACTIONS(440),
    [anon_sym_try] = ACTIONS(440),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_else] = ACTIONS(440),
    [anon_sym_for] = ACTIONS(440),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_open] = ACTIONS(440),
    [anon_sym_module] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(440),
    [anon_sym_package] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(440),
    [anon_sym_enum] = ACTIONS(440),
    [anon_sym_public] = ACTIONS(440),
    [anon_sym_protected] = ACTIONS(440),
    [anon_sym_private] = ACTIONS(440),
    [anon_sym_abstract] = ACTIONS(440),
    [anon_sym_final] = ACTIONS(440),
    [anon_sym_strictfp] = ACTIONS(440),
    [anon_sym_native] = ACTIONS(440),
    [anon_sym_transient] = ACTIONS(440),
    [anon_sym_volatile] = ACTIONS(440),
    [anon_sym_ATinterface] = ACTIONS(438),
    [anon_sym_interface] = ACTIONS(440),
    [anon_sym_byte] = ACTIONS(440),
    [anon_sym_short] = ACTIONS(440),
    [anon_sym_int] = ACTIONS(440),
    [anon_sym_long] = ACTIONS(440),
    [anon_sym_char] = ACTIONS(440),
    [anon_sym_float] = ACTIONS(440),
    [anon_sym_double] = ACTIONS(440),
    [sym_boolean_type] = ACTIONS(440),
    [sym_void_type] = ACTIONS(440),
    [sym_this] = ACTIONS(440),
    [sym_super] = ACTIONS(440),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(442),
    [sym_identifier] = ACTIONS(444),
    [sym_decimal_integer_literal] = ACTIONS(444),
    [sym_hex_integer_literal] = ACTIONS(444),
    [sym_octal_integer_literal] = ACTIONS(442),
    [sym_binary_integer_literal] = ACTIONS(442),
    [sym_decimal_floating_point_literal] = ACTIONS(442),
    [sym_hex_floating_point_literal] = ACTIONS(444),
    [sym_true] = ACTIONS(444),
    [sym_false] = ACTIONS(444),
    [sym_character_literal] = ACTIONS(442),
    [sym_string_literal] = ACTIONS(442),
    [sym_null_literal] = ACTIONS(444),
    [anon_sym_LPAREN] = ACTIONS(442),
    [anon_sym_LT] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(444),
    [anon_sym_DASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(442),
    [anon_sym_DASH_DASH] = ACTIONS(442),
    [anon_sym_new] = ACTIONS(444),
    [anon_sym_class] = ACTIONS(444),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_LBRACE] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(442),
    [anon_sym_assert] = ACTIONS(444),
    [anon_sym_switch] = ACTIONS(444),
    [anon_sym_case] = ACTIONS(444),
    [anon_sym_default] = ACTIONS(444),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_while] = ACTIONS(444),
    [anon_sym_break] = ACTIONS(444),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_return] = ACTIONS(444),
    [anon_sym_synchronized] = ACTIONS(444),
    [anon_sym_throw] = ACTIONS(444),
    [anon_sym_try] = ACTIONS(444),
    [anon_sym_if] = ACTIONS(444),
    [anon_sym_else] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(444),
    [anon_sym_AT] = ACTIONS(444),
    [anon_sym_open] = ACTIONS(444),
    [anon_sym_module] = ACTIONS(444),
    [anon_sym_static] = ACTIONS(444),
    [anon_sym_package] = ACTIONS(444),
    [anon_sym_import] = ACTIONS(444),
    [anon_sym_enum] = ACTIONS(444),
    [anon_sym_public] = ACTIONS(444),
    [anon_sym_protected] = ACTIONS(444),
    [anon_sym_private] = ACTIONS(444),
    [anon_sym_abstract] = ACTIONS(444),
    [anon_sym_final] = ACTIONS(444),
    [anon_sym_strictfp] = ACTIONS(444),
    [anon_sym_native] = ACTIONS(444),
    [anon_sym_transient] = ACTIONS(444),
    [anon_sym_volatile] = ACTIONS(444),
    [anon_sym_ATinterface] = ACTIONS(442),
    [anon_sym_interface] = ACTIONS(444),
    [anon_sym_byte] = ACTIONS(444),
    [anon_sym_short] = ACTIONS(444),
    [anon_sym_int] = ACTIONS(444),
    [anon_sym_long] = ACTIONS(444),
    [anon_sym_char] = ACTIONS(444),
    [anon_sym_float] = ACTIONS(444),
    [anon_sym_double] = ACTIONS(444),
    [sym_boolean_type] = ACTIONS(444),
    [sym_void_type] = ACTIONS(444),
    [sym_this] = ACTIONS(444),
    [sym_super] = ACTIONS(444),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(446),
    [sym_identifier] = ACTIONS(448),
    [sym_decimal_integer_literal] = ACTIONS(448),
    [sym_hex_integer_literal] = ACTIONS(448),
    [sym_octal_integer_literal] = ACTIONS(446),
    [sym_binary_integer_literal] = ACTIONS(446),
    [sym_decimal_floating_point_literal] = ACTIONS(446),
    [sym_hex_floating_point_literal] = ACTIONS(448),
    [sym_true] = ACTIONS(448),
    [sym_false] = ACTIONS(448),
    [sym_character_literal] = ACTIONS(446),
    [sym_string_literal] = ACTIONS(446),
    [sym_null_literal] = ACTIONS(448),
    [anon_sym_LPAREN] = ACTIONS(446),
    [anon_sym_LT] = ACTIONS(446),
    [anon_sym_PLUS] = ACTIONS(448),
    [anon_sym_DASH] = ACTIONS(448),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_new] = ACTIONS(448),
    [anon_sym_class] = ACTIONS(448),
    [anon_sym_SEMI] = ACTIONS(446),
    [anon_sym_LBRACE] = ACTIONS(446),
    [anon_sym_RBRACE] = ACTIONS(446),
    [anon_sym_assert] = ACTIONS(448),
    [anon_sym_switch] = ACTIONS(448),
    [anon_sym_case] = ACTIONS(448),
    [anon_sym_default] = ACTIONS(448),
    [anon_sym_do] = ACTIONS(448),
    [anon_sym_while] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(448),
    [anon_sym_continue] = ACTIONS(448),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_synchronized] = ACTIONS(448),
    [anon_sym_throw] = ACTIONS(448),
    [anon_sym_try] = ACTIONS(448),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_else] = ACTIONS(448),
    [anon_sym_for] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(448),
    [anon_sym_open] = ACTIONS(448),
    [anon_sym_module] = ACTIONS(448),
    [anon_sym_static] = ACTIONS(448),
    [anon_sym_package] = ACTIONS(448),
    [anon_sym_import] = ACTIONS(448),
    [anon_sym_enum] = ACTIONS(448),
    [anon_sym_public] = ACTIONS(448),
    [anon_sym_protected] = ACTIONS(448),
    [anon_sym_private] = ACTIONS(448),
    [anon_sym_abstract] = ACTIONS(448),
    [anon_sym_final] = ACTIONS(448),
    [anon_sym_strictfp] = ACTIONS(448),
    [anon_sym_native] = ACTIONS(448),
    [anon_sym_transient] = ACTIONS(448),
    [anon_sym_volatile] = ACTIONS(448),
    [anon_sym_ATinterface] = ACTIONS(446),
    [anon_sym_interface] = ACTIONS(448),
    [anon_sym_byte] = ACTIONS(448),
    [anon_sym_short] = ACTIONS(448),
    [anon_sym_int] = ACTIONS(448),
    [anon_sym_long] = ACTIONS(448),
    [anon_sym_char] = ACTIONS(448),
    [anon_sym_float] = ACTIONS(448),
    [anon_sym_double] = ACTIONS(448),
    [sym_boolean_type] = ACTIONS(448),
    [sym_void_type] = ACTIONS(448),
    [sym_this] = ACTIONS(448),
    [sym_super] = ACTIONS(448),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(450),
    [sym_identifier] = ACTIONS(452),
    [sym_decimal_integer_literal] = ACTIONS(452),
    [sym_hex_integer_literal] = ACTIONS(452),
    [sym_octal_integer_literal] = ACTIONS(450),
    [sym_binary_integer_literal] = ACTIONS(450),
    [sym_decimal_floating_point_literal] = ACTIONS(450),
    [sym_hex_floating_point_literal] = ACTIONS(452),
    [sym_true] = ACTIONS(452),
    [sym_false] = ACTIONS(452),
    [sym_character_literal] = ACTIONS(450),
    [sym_string_literal] = ACTIONS(450),
    [sym_null_literal] = ACTIONS(452),
    [anon_sym_LPAREN] = ACTIONS(450),
    [anon_sym_LT] = ACTIONS(450),
    [anon_sym_PLUS] = ACTIONS(452),
    [anon_sym_DASH] = ACTIONS(452),
    [anon_sym_BANG] = ACTIONS(450),
    [anon_sym_TILDE] = ACTIONS(450),
    [anon_sym_PLUS_PLUS] = ACTIONS(450),
    [anon_sym_DASH_DASH] = ACTIONS(450),
    [anon_sym_new] = ACTIONS(452),
    [anon_sym_class] = ACTIONS(452),
    [anon_sym_SEMI] = ACTIONS(450),
    [anon_sym_LBRACE] = ACTIONS(450),
    [anon_sym_RBRACE] = ACTIONS(450),
    [anon_sym_assert] = ACTIONS(452),
    [anon_sym_switch] = ACTIONS(452),
    [anon_sym_case] = ACTIONS(452),
    [anon_sym_default] = ACTIONS(452),
    [anon_sym_do] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_break] = ACTIONS(452),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_return] = ACTIONS(452),
    [anon_sym_synchronized] = ACTIONS(452),
    [anon_sym_throw] = ACTIONS(452),
    [anon_sym_try] = ACTIONS(452),
    [anon_sym_if] = ACTIONS(452),
    [anon_sym_else] = ACTIONS(452),
    [anon_sym_for] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(452),
    [anon_sym_open] = ACTIONS(452),
    [anon_sym_module] = ACTIONS(452),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_package] = ACTIONS(452),
    [anon_sym_import] = ACTIONS(452),
    [anon_sym_enum] = ACTIONS(452),
    [anon_sym_public] = ACTIONS(452),
    [anon_sym_protected] = ACTIONS(452),
    [anon_sym_private] = ACTIONS(452),
    [anon_sym_abstract] = ACTIONS(452),
    [anon_sym_final] = ACTIONS(452),
    [anon_sym_strictfp] = ACTIONS(452),
    [anon_sym_native] = ACTIONS(452),
    [anon_sym_transient] = ACTIONS(452),
    [anon_sym_volatile] = ACTIONS(452),
    [anon_sym_ATinterface] = ACTIONS(450),
    [anon_sym_interface] = ACTIONS(452),
    [anon_sym_byte] = ACTIONS(452),
    [anon_sym_short] = ACTIONS(452),
    [anon_sym_int] = ACTIONS(452),
    [anon_sym_long] = ACTIONS(452),
    [anon_sym_char] = ACTIONS(452),
    [anon_sym_float] = ACTIONS(452),
    [anon_sym_double] = ACTIONS(452),
    [sym_boolean_type] = ACTIONS(452),
    [sym_void_type] = ACTIONS(452),
    [sym_this] = ACTIONS(452),
    [sym_super] = ACTIONS(452),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(454),
    [sym_identifier] = ACTIONS(456),
    [sym_decimal_integer_literal] = ACTIONS(456),
    [sym_hex_integer_literal] = ACTIONS(456),
    [sym_octal_integer_literal] = ACTIONS(454),
    [sym_binary_integer_literal] = ACTIONS(454),
    [sym_decimal_floating_point_literal] = ACTIONS(454),
    [sym_hex_floating_point_literal] = ACTIONS(456),
    [sym_true] = ACTIONS(456),
    [sym_false] = ACTIONS(456),
    [sym_character_literal] = ACTIONS(454),
    [sym_string_literal] = ACTIONS(454),
    [sym_null_literal] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(454),
    [anon_sym_LT] = ACTIONS(454),
    [anon_sym_PLUS] = ACTIONS(456),
    [anon_sym_DASH] = ACTIONS(456),
    [anon_sym_BANG] = ACTIONS(454),
    [anon_sym_TILDE] = ACTIONS(454),
    [anon_sym_PLUS_PLUS] = ACTIONS(454),
    [anon_sym_DASH_DASH] = ACTIONS(454),
    [anon_sym_new] = ACTIONS(456),
    [anon_sym_class] = ACTIONS(456),
    [anon_sym_SEMI] = ACTIONS(454),
    [anon_sym_LBRACE] = ACTIONS(454),
    [anon_sym_RBRACE] = ACTIONS(454),
    [anon_sym_assert] = ACTIONS(456),
    [anon_sym_switch] = ACTIONS(456),
    [anon_sym_case] = ACTIONS(456),
    [anon_sym_default] = ACTIONS(456),
    [anon_sym_do] = ACTIONS(456),
    [anon_sym_while] = ACTIONS(456),
    [anon_sym_break] = ACTIONS(456),
    [anon_sym_continue] = ACTIONS(456),
    [anon_sym_return] = ACTIONS(456),
    [anon_sym_synchronized] = ACTIONS(456),
    [anon_sym_throw] = ACTIONS(456),
    [anon_sym_try] = ACTIONS(456),
    [anon_sym_if] = ACTIONS(456),
    [anon_sym_else] = ACTIONS(456),
    [anon_sym_for] = ACTIONS(456),
    [anon_sym_AT] = ACTIONS(456),
    [anon_sym_open] = ACTIONS(456),
    [anon_sym_module] = ACTIONS(456),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_package] = ACTIONS(456),
    [anon_sym_import] = ACTIONS(456),
    [anon_sym_enum] = ACTIONS(456),
    [anon_sym_public] = ACTIONS(456),
    [anon_sym_protected] = ACTIONS(456),
    [anon_sym_private] = ACTIONS(456),
    [anon_sym_abstract] = ACTIONS(456),
    [anon_sym_final] = ACTIONS(456),
    [anon_sym_strictfp] = ACTIONS(456),
    [anon_sym_native] = ACTIONS(456),
    [anon_sym_transient] = ACTIONS(456),
    [anon_sym_volatile] = ACTIONS(456),
    [anon_sym_ATinterface] = ACTIONS(454),
    [anon_sym_interface] = ACTIONS(456),
    [anon_sym_byte] = ACTIONS(456),
    [anon_sym_short] = ACTIONS(456),
    [anon_sym_int] = ACTIONS(456),
    [anon_sym_long] = ACTIONS(456),
    [anon_sym_char] = ACTIONS(456),
    [anon_sym_float] = ACTIONS(456),
    [anon_sym_double] = ACTIONS(456),
    [sym_boolean_type] = ACTIONS(456),
    [sym_void_type] = ACTIONS(456),
    [sym_this] = ACTIONS(456),
    [sym_super] = ACTIONS(456),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(458),
    [sym_identifier] = ACTIONS(460),
    [sym_decimal_integer_literal] = ACTIONS(460),
    [sym_hex_integer_literal] = ACTIONS(460),
    [sym_octal_integer_literal] = ACTIONS(458),
    [sym_binary_integer_literal] = ACTIONS(458),
    [sym_decimal_floating_point_literal] = ACTIONS(458),
    [sym_hex_floating_point_literal] = ACTIONS(460),
    [sym_true] = ACTIONS(460),
    [sym_false] = ACTIONS(460),
    [sym_character_literal] = ACTIONS(458),
    [sym_string_literal] = ACTIONS(458),
    [sym_null_literal] = ACTIONS(460),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_LT] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(460),
    [anon_sym_DASH] = ACTIONS(460),
    [anon_sym_BANG] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_PLUS_PLUS] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(458),
    [anon_sym_new] = ACTIONS(460),
    [anon_sym_class] = ACTIONS(460),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_assert] = ACTIONS(460),
    [anon_sym_switch] = ACTIONS(460),
    [anon_sym_case] = ACTIONS(460),
    [anon_sym_default] = ACTIONS(460),
    [anon_sym_do] = ACTIONS(460),
    [anon_sym_while] = ACTIONS(460),
    [anon_sym_break] = ACTIONS(460),
    [anon_sym_continue] = ACTIONS(460),
    [anon_sym_return] = ACTIONS(460),
    [anon_sym_synchronized] = ACTIONS(460),
    [anon_sym_throw] = ACTIONS(460),
    [anon_sym_try] = ACTIONS(460),
    [anon_sym_if] = ACTIONS(460),
    [anon_sym_else] = ACTIONS(460),
    [anon_sym_for] = ACTIONS(460),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(460),
    [anon_sym_module] = ACTIONS(460),
    [anon_sym_static] = ACTIONS(460),
    [anon_sym_package] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(460),
    [anon_sym_enum] = ACTIONS(460),
    [anon_sym_public] = ACTIONS(460),
    [anon_sym_protected] = ACTIONS(460),
    [anon_sym_private] = ACTIONS(460),
    [anon_sym_abstract] = ACTIONS(460),
    [anon_sym_final] = ACTIONS(460),
    [anon_sym_strictfp] = ACTIONS(460),
    [anon_sym_native] = ACTIONS(460),
    [anon_sym_transient] = ACTIONS(460),
    [anon_sym_volatile] = ACTIONS(460),
    [anon_sym_ATinterface] = ACTIONS(458),
    [anon_sym_interface] = ACTIONS(460),
    [anon_sym_byte] = ACTIONS(460),
    [anon_sym_short] = ACTIONS(460),
    [anon_sym_int] = ACTIONS(460),
    [anon_sym_long] = ACTIONS(460),
    [anon_sym_char] = ACTIONS(460),
    [anon_sym_float] = ACTIONS(460),
    [anon_sym_double] = ACTIONS(460),
    [sym_boolean_type] = ACTIONS(460),
    [sym_void_type] = ACTIONS(460),
    [sym_this] = ACTIONS(460),
    [sym_super] = ACTIONS(460),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(462),
    [sym_identifier] = ACTIONS(464),
    [sym_decimal_integer_literal] = ACTIONS(464),
    [sym_hex_integer_literal] = ACTIONS(464),
    [sym_octal_integer_literal] = ACTIONS(462),
    [sym_binary_integer_literal] = ACTIONS(462),
    [sym_decimal_floating_point_literal] = ACTIONS(462),
    [sym_hex_floating_point_literal] = ACTIONS(464),
    [sym_true] = ACTIONS(464),
    [sym_false] = ACTIONS(464),
    [sym_character_literal] = ACTIONS(462),
    [sym_string_literal] = ACTIONS(462),
    [sym_null_literal] = ACTIONS(464),
    [anon_sym_LPAREN] = ACTIONS(462),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(462),
    [anon_sym_PLUS_PLUS] = ACTIONS(462),
    [anon_sym_DASH_DASH] = ACTIONS(462),
    [anon_sym_new] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(464),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(462),
    [anon_sym_RBRACE] = ACTIONS(462),
    [anon_sym_assert] = ACTIONS(464),
    [anon_sym_switch] = ACTIONS(464),
    [anon_sym_case] = ACTIONS(464),
    [anon_sym_default] = ACTIONS(464),
    [anon_sym_do] = ACTIONS(464),
    [anon_sym_while] = ACTIONS(464),
    [anon_sym_break] = ACTIONS(464),
    [anon_sym_continue] = ACTIONS(464),
    [anon_sym_return] = ACTIONS(464),
    [anon_sym_synchronized] = ACTIONS(464),
    [anon_sym_throw] = ACTIONS(464),
    [anon_sym_try] = ACTIONS(464),
    [anon_sym_if] = ACTIONS(464),
    [anon_sym_else] = ACTIONS(464),
    [anon_sym_for] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_open] = ACTIONS(464),
    [anon_sym_module] = ACTIONS(464),
    [anon_sym_static] = ACTIONS(464),
    [anon_sym_package] = ACTIONS(464),
    [anon_sym_import] = ACTIONS(464),
    [anon_sym_enum] = ACTIONS(464),
    [anon_sym_public] = ACTIONS(464),
    [anon_sym_protected] = ACTIONS(464),
    [anon_sym_private] = ACTIONS(464),
    [anon_sym_abstract] = ACTIONS(464),
    [anon_sym_final] = ACTIONS(464),
    [anon_sym_strictfp] = ACTIONS(464),
    [anon_sym_native] = ACTIONS(464),
    [anon_sym_transient] = ACTIONS(464),
    [anon_sym_volatile] = ACTIONS(464),
    [anon_sym_ATinterface] = ACTIONS(462),
    [anon_sym_interface] = ACTIONS(464),
    [anon_sym_byte] = ACTIONS(464),
    [anon_sym_short] = ACTIONS(464),
    [anon_sym_int] = ACTIONS(464),
    [anon_sym_long] = ACTIONS(464),
    [anon_sym_char] = ACTIONS(464),
    [anon_sym_float] = ACTIONS(464),
    [anon_sym_double] = ACTIONS(464),
    [sym_boolean_type] = ACTIONS(464),
    [sym_void_type] = ACTIONS(464),
    [sym_this] = ACTIONS(464),
    [sym_super] = ACTIONS(464),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(466),
    [sym_identifier] = ACTIONS(468),
    [sym_decimal_integer_literal] = ACTIONS(468),
    [sym_hex_integer_literal] = ACTIONS(468),
    [sym_octal_integer_literal] = ACTIONS(466),
    [sym_binary_integer_literal] = ACTIONS(466),
    [sym_decimal_floating_point_literal] = ACTIONS(466),
    [sym_hex_floating_point_literal] = ACTIONS(468),
    [sym_true] = ACTIONS(468),
    [sym_false] = ACTIONS(468),
    [sym_character_literal] = ACTIONS(466),
    [sym_string_literal] = ACTIONS(466),
    [sym_null_literal] = ACTIONS(468),
    [anon_sym_LPAREN] = ACTIONS(466),
    [anon_sym_LT] = ACTIONS(466),
    [anon_sym_PLUS] = ACTIONS(468),
    [anon_sym_DASH] = ACTIONS(468),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_PLUS_PLUS] = ACTIONS(466),
    [anon_sym_DASH_DASH] = ACTIONS(466),
    [anon_sym_new] = ACTIONS(468),
    [anon_sym_class] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_LBRACE] = ACTIONS(466),
    [anon_sym_RBRACE] = ACTIONS(466),
    [anon_sym_assert] = ACTIONS(468),
    [anon_sym_switch] = ACTIONS(468),
    [anon_sym_case] = ACTIONS(468),
    [anon_sym_default] = ACTIONS(468),
    [anon_sym_do] = ACTIONS(468),
    [anon_sym_while] = ACTIONS(468),
    [anon_sym_break] = ACTIONS(468),
    [anon_sym_continue] = ACTIONS(468),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_synchronized] = ACTIONS(468),
    [anon_sym_throw] = ACTIONS(468),
    [anon_sym_try] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(468),
    [anon_sym_else] = ACTIONS(468),
    [anon_sym_for] = ACTIONS(468),
    [anon_sym_AT] = ACTIONS(468),
    [anon_sym_open] = ACTIONS(468),
    [anon_sym_module] = ACTIONS(468),
    [anon_sym_static] = ACTIONS(468),
    [anon_sym_package] = ACTIONS(468),
    [anon_sym_import] = ACTIONS(468),
    [anon_sym_enum] = ACTIONS(468),
    [anon_sym_public] = ACTIONS(468),
    [anon_sym_protected] = ACTIONS(468),
    [anon_sym_private] = ACTIONS(468),
    [anon_sym_abstract] = ACTIONS(468),
    [anon_sym_final] = ACTIONS(468),
    [anon_sym_strictfp] = ACTIONS(468),
    [anon_sym_native] = ACTIONS(468),
    [anon_sym_transient] = ACTIONS(468),
    [anon_sym_volatile] = ACTIONS(468),
    [anon_sym_ATinterface] = ACTIONS(466),
    [anon_sym_interface] = ACTIONS(468),
    [anon_sym_byte] = ACTIONS(468),
    [anon_sym_short] = ACTIONS(468),
    [anon_sym_int] = ACTIONS(468),
    [anon_sym_long] = ACTIONS(468),
    [anon_sym_char] = ACTIONS(468),
    [anon_sym_float] = ACTIONS(468),
    [anon_sym_double] = ACTIONS(468),
    [sym_boolean_type] = ACTIONS(468),
    [sym_void_type] = ACTIONS(468),
    [sym_this] = ACTIONS(468),
    [sym_super] = ACTIONS(468),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(470),
    [sym_identifier] = ACTIONS(472),
    [sym_decimal_integer_literal] = ACTIONS(472),
    [sym_hex_integer_literal] = ACTIONS(472),
    [sym_octal_integer_literal] = ACTIONS(470),
    [sym_binary_integer_literal] = ACTIONS(470),
    [sym_decimal_floating_point_literal] = ACTIONS(470),
    [sym_hex_floating_point_literal] = ACTIONS(472),
    [sym_true] = ACTIONS(472),
    [sym_false] = ACTIONS(472),
    [sym_character_literal] = ACTIONS(470),
    [sym_string_literal] = ACTIONS(470),
    [sym_null_literal] = ACTIONS(472),
    [anon_sym_LPAREN] = ACTIONS(470),
    [anon_sym_LT] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_BANG] = ACTIONS(470),
    [anon_sym_TILDE] = ACTIONS(470),
    [anon_sym_PLUS_PLUS] = ACTIONS(470),
    [anon_sym_DASH_DASH] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(472),
    [anon_sym_class] = ACTIONS(472),
    [anon_sym_SEMI] = ACTIONS(470),
    [anon_sym_LBRACE] = ACTIONS(470),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_assert] = ACTIONS(472),
    [anon_sym_switch] = ACTIONS(472),
    [anon_sym_case] = ACTIONS(472),
    [anon_sym_default] = ACTIONS(472),
    [anon_sym_do] = ACTIONS(472),
    [anon_sym_while] = ACTIONS(472),
    [anon_sym_break] = ACTIONS(472),
    [anon_sym_continue] = ACTIONS(472),
    [anon_sym_return] = ACTIONS(472),
    [anon_sym_synchronized] = ACTIONS(472),
    [anon_sym_throw] = ACTIONS(472),
    [anon_sym_try] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(472),
    [anon_sym_else] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(472),
    [anon_sym_open] = ACTIONS(472),
    [anon_sym_module] = ACTIONS(472),
    [anon_sym_static] = ACTIONS(472),
    [anon_sym_package] = ACTIONS(472),
    [anon_sym_import] = ACTIONS(472),
    [anon_sym_enum] = ACTIONS(472),
    [anon_sym_public] = ACTIONS(472),
    [anon_sym_protected] = ACTIONS(472),
    [anon_sym_private] = ACTIONS(472),
    [anon_sym_abstract] = ACTIONS(472),
    [anon_sym_final] = ACTIONS(472),
    [anon_sym_strictfp] = ACTIONS(472),
    [anon_sym_native] = ACTIONS(472),
    [anon_sym_transient] = ACTIONS(472),
    [anon_sym_volatile] = ACTIONS(472),
    [anon_sym_ATinterface] = ACTIONS(470),
    [anon_sym_interface] = ACTIONS(472),
    [anon_sym_byte] = ACTIONS(472),
    [anon_sym_short] = ACTIONS(472),
    [anon_sym_int] = ACTIONS(472),
    [anon_sym_long] = ACTIONS(472),
    [anon_sym_char] = ACTIONS(472),
    [anon_sym_float] = ACTIONS(472),
    [anon_sym_double] = ACTIONS(472),
    [sym_boolean_type] = ACTIONS(472),
    [sym_void_type] = ACTIONS(472),
    [sym_this] = ACTIONS(472),
    [sym_super] = ACTIONS(472),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(433),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym_array_initializer] = STATE(856),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(474),
    [sym_identifier] = ACTIONS(476),
    [sym_decimal_integer_literal] = ACTIONS(476),
    [sym_hex_integer_literal] = ACTIONS(476),
    [sym_octal_integer_literal] = ACTIONS(474),
    [sym_binary_integer_literal] = ACTIONS(474),
    [sym_decimal_floating_point_literal] = ACTIONS(474),
    [sym_hex_floating_point_literal] = ACTIONS(476),
    [sym_true] = ACTIONS(476),
    [sym_false] = ACTIONS(476),
    [sym_character_literal] = ACTIONS(474),
    [sym_string_literal] = ACTIONS(474),
    [sym_null_literal] = ACTIONS(476),
    [anon_sym_LPAREN] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(474),
    [anon_sym_PLUS] = ACTIONS(476),
    [anon_sym_DASH] = ACTIONS(476),
    [anon_sym_BANG] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(474),
    [anon_sym_PLUS_PLUS] = ACTIONS(474),
    [anon_sym_DASH_DASH] = ACTIONS(474),
    [anon_sym_new] = ACTIONS(476),
    [anon_sym_class] = ACTIONS(476),
    [anon_sym_SEMI] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(474),
    [anon_sym_RBRACE] = ACTIONS(474),
    [anon_sym_assert] = ACTIONS(476),
    [anon_sym_switch] = ACTIONS(476),
    [anon_sym_case] = ACTIONS(476),
    [anon_sym_default] = ACTIONS(476),
    [anon_sym_do] = ACTIONS(476),
    [anon_sym_while] = ACTIONS(476),
    [anon_sym_break] = ACTIONS(476),
    [anon_sym_continue] = ACTIONS(476),
    [anon_sym_return] = ACTIONS(476),
    [anon_sym_synchronized] = ACTIONS(476),
    [anon_sym_throw] = ACTIONS(476),
    [anon_sym_try] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_else] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [anon_sym_AT] = ACTIONS(476),
    [anon_sym_open] = ACTIONS(476),
    [anon_sym_module] = ACTIONS(476),
    [anon_sym_static] = ACTIONS(476),
    [anon_sym_package] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(476),
    [anon_sym_enum] = ACTIONS(476),
    [anon_sym_public] = ACTIONS(476),
    [anon_sym_protected] = ACTIONS(476),
    [anon_sym_private] = ACTIONS(476),
    [anon_sym_abstract] = ACTIONS(476),
    [anon_sym_final] = ACTIONS(476),
    [anon_sym_strictfp] = ACTIONS(476),
    [anon_sym_native] = ACTIONS(476),
    [anon_sym_transient] = ACTIONS(476),
    [anon_sym_volatile] = ACTIONS(476),
    [anon_sym_ATinterface] = ACTIONS(474),
    [anon_sym_interface] = ACTIONS(476),
    [anon_sym_byte] = ACTIONS(476),
    [anon_sym_short] = ACTIONS(476),
    [anon_sym_int] = ACTIONS(476),
    [anon_sym_long] = ACTIONS(476),
    [anon_sym_char] = ACTIONS(476),
    [anon_sym_float] = ACTIONS(476),
    [anon_sym_double] = ACTIONS(476),
    [sym_boolean_type] = ACTIONS(476),
    [sym_void_type] = ACTIONS(476),
    [sym_this] = ACTIONS(476),
    [sym_super] = ACTIONS(476),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(478),
    [sym_identifier] = ACTIONS(480),
    [sym_decimal_integer_literal] = ACTIONS(480),
    [sym_hex_integer_literal] = ACTIONS(480),
    [sym_octal_integer_literal] = ACTIONS(478),
    [sym_binary_integer_literal] = ACTIONS(478),
    [sym_decimal_floating_point_literal] = ACTIONS(478),
    [sym_hex_floating_point_literal] = ACTIONS(480),
    [sym_true] = ACTIONS(480),
    [sym_false] = ACTIONS(480),
    [sym_character_literal] = ACTIONS(478),
    [sym_string_literal] = ACTIONS(478),
    [sym_null_literal] = ACTIONS(480),
    [anon_sym_LPAREN] = ACTIONS(478),
    [anon_sym_LT] = ACTIONS(478),
    [anon_sym_PLUS] = ACTIONS(480),
    [anon_sym_DASH] = ACTIONS(480),
    [anon_sym_BANG] = ACTIONS(478),
    [anon_sym_TILDE] = ACTIONS(478),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [anon_sym_new] = ACTIONS(480),
    [anon_sym_class] = ACTIONS(480),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_LBRACE] = ACTIONS(478),
    [anon_sym_RBRACE] = ACTIONS(478),
    [anon_sym_assert] = ACTIONS(480),
    [anon_sym_switch] = ACTIONS(480),
    [anon_sym_case] = ACTIONS(480),
    [anon_sym_default] = ACTIONS(480),
    [anon_sym_do] = ACTIONS(480),
    [anon_sym_while] = ACTIONS(480),
    [anon_sym_break] = ACTIONS(480),
    [anon_sym_continue] = ACTIONS(480),
    [anon_sym_return] = ACTIONS(480),
    [anon_sym_synchronized] = ACTIONS(480),
    [anon_sym_throw] = ACTIONS(480),
    [anon_sym_try] = ACTIONS(480),
    [anon_sym_if] = ACTIONS(480),
    [anon_sym_else] = ACTIONS(480),
    [anon_sym_for] = ACTIONS(480),
    [anon_sym_AT] = ACTIONS(480),
    [anon_sym_open] = ACTIONS(480),
    [anon_sym_module] = ACTIONS(480),
    [anon_sym_static] = ACTIONS(480),
    [anon_sym_package] = ACTIONS(480),
    [anon_sym_import] = ACTIONS(480),
    [anon_sym_enum] = ACTIONS(480),
    [anon_sym_public] = ACTIONS(480),
    [anon_sym_protected] = ACTIONS(480),
    [anon_sym_private] = ACTIONS(480),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_final] = ACTIONS(480),
    [anon_sym_strictfp] = ACTIONS(480),
    [anon_sym_native] = ACTIONS(480),
    [anon_sym_transient] = ACTIONS(480),
    [anon_sym_volatile] = ACTIONS(480),
    [anon_sym_ATinterface] = ACTIONS(478),
    [anon_sym_interface] = ACTIONS(480),
    [anon_sym_byte] = ACTIONS(480),
    [anon_sym_short] = ACTIONS(480),
    [anon_sym_int] = ACTIONS(480),
    [anon_sym_long] = ACTIONS(480),
    [anon_sym_char] = ACTIONS(480),
    [anon_sym_float] = ACTIONS(480),
    [anon_sym_double] = ACTIONS(480),
    [sym_boolean_type] = ACTIONS(480),
    [sym_void_type] = ACTIONS(480),
    [sym_this] = ACTIONS(480),
    [sym_super] = ACTIONS(480),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [ts_builtin_sym_end] = ACTIONS(482),
    [sym_identifier] = ACTIONS(484),
    [sym_decimal_integer_literal] = ACTIONS(484),
    [sym_hex_integer_literal] = ACTIONS(484),
    [sym_octal_integer_literal] = ACTIONS(482),
    [sym_binary_integer_literal] = ACTIONS(482),
    [sym_decimal_floating_point_literal] = ACTIONS(482),
    [sym_hex_floating_point_literal] = ACTIONS(484),
    [sym_true] = ACTIONS(484),
    [sym_false] = ACTIONS(484),
    [sym_character_literal] = ACTIONS(482),
    [sym_string_literal] = ACTIONS(482),
    [sym_null_literal] = ACTIONS(484),
    [anon_sym_LPAREN] = ACTIONS(482),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_PLUS] = ACTIONS(484),
    [anon_sym_DASH] = ACTIONS(484),
    [anon_sym_BANG] = ACTIONS(482),
    [anon_sym_TILDE] = ACTIONS(482),
    [anon_sym_PLUS_PLUS] = ACTIONS(482),
    [anon_sym_DASH_DASH] = ACTIONS(482),
    [anon_sym_new] = ACTIONS(484),
    [anon_sym_class] = ACTIONS(484),
    [anon_sym_SEMI] = ACTIONS(482),
    [anon_sym_LBRACE] = ACTIONS(482),
    [anon_sym_RBRACE] = ACTIONS(482),
    [anon_sym_assert] = ACTIONS(484),
    [anon_sym_switch] = ACTIONS(484),
    [anon_sym_case] = ACTIONS(484),
    [anon_sym_default] = ACTIONS(484),
    [anon_sym_do] = ACTIONS(484),
    [anon_sym_while] = ACTIONS(484),
    [anon_sym_break] = ACTIONS(484),
    [anon_sym_continue] = ACTIONS(484),
    [anon_sym_return] = ACTIONS(484),
    [anon_sym_synchronized] = ACTIONS(484),
    [anon_sym_throw] = ACTIONS(484),
    [anon_sym_try] = ACTIONS(484),
    [anon_sym_if] = ACTIONS(484),
    [anon_sym_else] = ACTIONS(484),
    [anon_sym_for] = ACTIONS(484),
    [anon_sym_AT] = ACTIONS(484),
    [anon_sym_open] = ACTIONS(484),
    [anon_sym_module] = ACTIONS(484),
    [anon_sym_static] = ACTIONS(484),
    [anon_sym_package] = ACTIONS(484),
    [anon_sym_import] = ACTIONS(484),
    [anon_sym_enum] = ACTIONS(484),
    [anon_sym_public] = ACTIONS(484),
    [anon_sym_protected] = ACTIONS(484),
    [anon_sym_private] = ACTIONS(484),
    [anon_sym_abstract] = ACTIONS(484),
    [anon_sym_final] = ACTIONS(484),
    [anon_sym_strictfp] = ACTIONS(484),
    [anon_sym_native] = ACTIONS(484),
    [anon_sym_transient] = ACTIONS(484),
    [anon_sym_volatile] = ACTIONS(484),
    [anon_sym_ATinterface] = ACTIONS(482),
    [anon_sym_interface] = ACTIONS(484),
    [anon_sym_byte] = ACTIONS(484),
    [anon_sym_short] = ACTIONS(484),
    [anon_sym_int] = ACTIONS(484),
    [anon_sym_long] = ACTIONS(484),
    [anon_sym_char] = ACTIONS(484),
    [anon_sym_float] = ACTIONS(484),
    [anon_sym_double] = ACTIONS(484),
    [sym_boolean_type] = ACTIONS(484),
    [sym_void_type] = ACTIONS(484),
    [sym_this] = ACTIONS(484),
    [sym_super] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(486),
    [sym_identifier] = ACTIONS(488),
    [sym_decimal_integer_literal] = ACTIONS(488),
    [sym_hex_integer_literal] = ACTIONS(488),
    [sym_octal_integer_literal] = ACTIONS(486),
    [sym_binary_integer_literal] = ACTIONS(486),
    [sym_decimal_floating_point_literal] = ACTIONS(486),
    [sym_hex_floating_point_literal] = ACTIONS(488),
    [sym_true] = ACTIONS(488),
    [sym_false] = ACTIONS(488),
    [sym_character_literal] = ACTIONS(486),
    [sym_string_literal] = ACTIONS(486),
    [sym_null_literal] = ACTIONS(488),
    [anon_sym_LPAREN] = ACTIONS(486),
    [anon_sym_LT] = ACTIONS(486),
    [anon_sym_PLUS] = ACTIONS(488),
    [anon_sym_DASH] = ACTIONS(488),
    [anon_sym_BANG] = ACTIONS(486),
    [anon_sym_TILDE] = ACTIONS(486),
    [anon_sym_PLUS_PLUS] = ACTIONS(486),
    [anon_sym_DASH_DASH] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(488),
    [anon_sym_class] = ACTIONS(488),
    [anon_sym_SEMI] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(486),
    [anon_sym_RBRACE] = ACTIONS(486),
    [anon_sym_assert] = ACTIONS(488),
    [anon_sym_switch] = ACTIONS(488),
    [anon_sym_case] = ACTIONS(488),
    [anon_sym_default] = ACTIONS(488),
    [anon_sym_do] = ACTIONS(488),
    [anon_sym_while] = ACTIONS(488),
    [anon_sym_break] = ACTIONS(488),
    [anon_sym_continue] = ACTIONS(488),
    [anon_sym_return] = ACTIONS(488),
    [anon_sym_synchronized] = ACTIONS(488),
    [anon_sym_throw] = ACTIONS(488),
    [anon_sym_try] = ACTIONS(488),
    [anon_sym_if] = ACTIONS(488),
    [anon_sym_else] = ACTIONS(488),
    [anon_sym_for] = ACTIONS(488),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_open] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(488),
    [anon_sym_static] = ACTIONS(488),
    [anon_sym_package] = ACTIONS(488),
    [anon_sym_import] = ACTIONS(488),
    [anon_sym_enum] = ACTIONS(488),
    [anon_sym_public] = ACTIONS(488),
    [anon_sym_protected] = ACTIONS(488),
    [anon_sym_private] = ACTIONS(488),
    [anon_sym_abstract] = ACTIONS(488),
    [anon_sym_final] = ACTIONS(488),
    [anon_sym_strictfp] = ACTIONS(488),
    [anon_sym_native] = ACTIONS(488),
    [anon_sym_transient] = ACTIONS(488),
    [anon_sym_volatile] = ACTIONS(488),
    [anon_sym_ATinterface] = ACTIONS(486),
    [anon_sym_interface] = ACTIONS(488),
    [anon_sym_byte] = ACTIONS(488),
    [anon_sym_short] = ACTIONS(488),
    [anon_sym_int] = ACTIONS(488),
    [anon_sym_long] = ACTIONS(488),
    [anon_sym_char] = ACTIONS(488),
    [anon_sym_float] = ACTIONS(488),
    [anon_sym_double] = ACTIONS(488),
    [sym_boolean_type] = ACTIONS(488),
    [sym_void_type] = ACTIONS(488),
    [sym_this] = ACTIONS(488),
    [sym_super] = ACTIONS(488),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [ts_builtin_sym_end] = ACTIONS(490),
    [sym_identifier] = ACTIONS(492),
    [sym_decimal_integer_literal] = ACTIONS(492),
    [sym_hex_integer_literal] = ACTIONS(492),
    [sym_octal_integer_literal] = ACTIONS(490),
    [sym_binary_integer_literal] = ACTIONS(490),
    [sym_decimal_floating_point_literal] = ACTIONS(490),
    [sym_hex_floating_point_literal] = ACTIONS(492),
    [sym_true] = ACTIONS(492),
    [sym_false] = ACTIONS(492),
    [sym_character_literal] = ACTIONS(490),
    [sym_string_literal] = ACTIONS(490),
    [sym_null_literal] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(490),
    [anon_sym_LT] = ACTIONS(490),
    [anon_sym_PLUS] = ACTIONS(492),
    [anon_sym_DASH] = ACTIONS(492),
    [anon_sym_BANG] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(490),
    [anon_sym_PLUS_PLUS] = ACTIONS(490),
    [anon_sym_DASH_DASH] = ACTIONS(490),
    [anon_sym_new] = ACTIONS(492),
    [anon_sym_class] = ACTIONS(492),
    [anon_sym_SEMI] = ACTIONS(490),
    [anon_sym_LBRACE] = ACTIONS(490),
    [anon_sym_RBRACE] = ACTIONS(490),
    [anon_sym_assert] = ACTIONS(492),
    [anon_sym_switch] = ACTIONS(492),
    [anon_sym_case] = ACTIONS(492),
    [anon_sym_default] = ACTIONS(492),
    [anon_sym_do] = ACTIONS(492),
    [anon_sym_while] = ACTIONS(492),
    [anon_sym_break] = ACTIONS(492),
    [anon_sym_continue] = ACTIONS(492),
    [anon_sym_return] = ACTIONS(492),
    [anon_sym_synchronized] = ACTIONS(492),
    [anon_sym_throw] = ACTIONS(492),
    [anon_sym_try] = ACTIONS(492),
    [anon_sym_if] = ACTIONS(492),
    [anon_sym_else] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(492),
    [anon_sym_AT] = ACTIONS(492),
    [anon_sym_open] = ACTIONS(492),
    [anon_sym_module] = ACTIONS(492),
    [anon_sym_static] = ACTIONS(492),
    [anon_sym_package] = ACTIONS(492),
    [anon_sym_import] = ACTIONS(492),
    [anon_sym_enum] = ACTIONS(492),
    [anon_sym_public] = ACTIONS(492),
    [anon_sym_protected] = ACTIONS(492),
    [anon_sym_private] = ACTIONS(492),
    [anon_sym_abstract] = ACTIONS(492),
    [anon_sym_final] = ACTIONS(492),
    [anon_sym_strictfp] = ACTIONS(492),
    [anon_sym_native] = ACTIONS(492),
    [anon_sym_transient] = ACTIONS(492),
    [anon_sym_volatile] = ACTIONS(492),
    [anon_sym_ATinterface] = ACTIONS(490),
    [anon_sym_interface] = ACTIONS(492),
    [anon_sym_byte] = ACTIONS(492),
    [anon_sym_short] = ACTIONS(492),
    [anon_sym_int] = ACTIONS(492),
    [anon_sym_long] = ACTIONS(492),
    [anon_sym_char] = ACTIONS(492),
    [anon_sym_float] = ACTIONS(492),
    [anon_sym_double] = ACTIONS(492),
    [sym_boolean_type] = ACTIONS(492),
    [sym_void_type] = ACTIONS(492),
    [sym_this] = ACTIONS(492),
    [sym_super] = ACTIONS(492),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [ts_builtin_sym_end] = ACTIONS(494),
    [sym_identifier] = ACTIONS(496),
    [sym_decimal_integer_literal] = ACTIONS(496),
    [sym_hex_integer_literal] = ACTIONS(496),
    [sym_octal_integer_literal] = ACTIONS(494),
    [sym_binary_integer_literal] = ACTIONS(494),
    [sym_decimal_floating_point_literal] = ACTIONS(494),
    [sym_hex_floating_point_literal] = ACTIONS(496),
    [sym_true] = ACTIONS(496),
    [sym_false] = ACTIONS(496),
    [sym_character_literal] = ACTIONS(494),
    [sym_string_literal] = ACTIONS(494),
    [sym_null_literal] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_LT] = ACTIONS(494),
    [anon_sym_PLUS] = ACTIONS(496),
    [anon_sym_DASH] = ACTIONS(496),
    [anon_sym_BANG] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_PLUS_PLUS] = ACTIONS(494),
    [anon_sym_DASH_DASH] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_class] = ACTIONS(496),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_assert] = ACTIONS(496),
    [anon_sym_switch] = ACTIONS(496),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_break] = ACTIONS(496),
    [anon_sym_continue] = ACTIONS(496),
    [anon_sym_return] = ACTIONS(496),
    [anon_sym_synchronized] = ACTIONS(496),
    [anon_sym_throw] = ACTIONS(496),
    [anon_sym_try] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_else] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(496),
    [anon_sym_open] = ACTIONS(496),
    [anon_sym_module] = ACTIONS(496),
    [anon_sym_static] = ACTIONS(496),
    [anon_sym_package] = ACTIONS(496),
    [anon_sym_import] = ACTIONS(496),
    [anon_sym_enum] = ACTIONS(496),
    [anon_sym_public] = ACTIONS(496),
    [anon_sym_protected] = ACTIONS(496),
    [anon_sym_private] = ACTIONS(496),
    [anon_sym_abstract] = ACTIONS(496),
    [anon_sym_final] = ACTIONS(496),
    [anon_sym_strictfp] = ACTIONS(496),
    [anon_sym_native] = ACTIONS(496),
    [anon_sym_transient] = ACTIONS(496),
    [anon_sym_volatile] = ACTIONS(496),
    [anon_sym_ATinterface] = ACTIONS(494),
    [anon_sym_interface] = ACTIONS(496),
    [anon_sym_byte] = ACTIONS(496),
    [anon_sym_short] = ACTIONS(496),
    [anon_sym_int] = ACTIONS(496),
    [anon_sym_long] = ACTIONS(496),
    [anon_sym_char] = ACTIONS(496),
    [anon_sym_float] = ACTIONS(496),
    [anon_sym_double] = ACTIONS(496),
    [sym_boolean_type] = ACTIONS(496),
    [sym_void_type] = ACTIONS(496),
    [sym_this] = ACTIONS(496),
    [sym_super] = ACTIONS(496),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(498),
    [sym_identifier] = ACTIONS(500),
    [sym_decimal_integer_literal] = ACTIONS(500),
    [sym_hex_integer_literal] = ACTIONS(500),
    [sym_octal_integer_literal] = ACTIONS(498),
    [sym_binary_integer_literal] = ACTIONS(498),
    [sym_decimal_floating_point_literal] = ACTIONS(498),
    [sym_hex_floating_point_literal] = ACTIONS(500),
    [sym_true] = ACTIONS(500),
    [sym_false] = ACTIONS(500),
    [sym_character_literal] = ACTIONS(498),
    [sym_string_literal] = ACTIONS(498),
    [sym_null_literal] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_LT] = ACTIONS(498),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(498),
    [anon_sym_DASH_DASH] = ACTIONS(498),
    [anon_sym_new] = ACTIONS(500),
    [anon_sym_class] = ACTIONS(500),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym_LBRACE] = ACTIONS(498),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_assert] = ACTIONS(500),
    [anon_sym_switch] = ACTIONS(500),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_default] = ACTIONS(500),
    [anon_sym_do] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_break] = ACTIONS(500),
    [anon_sym_continue] = ACTIONS(500),
    [anon_sym_return] = ACTIONS(500),
    [anon_sym_synchronized] = ACTIONS(500),
    [anon_sym_throw] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(500),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_else] = ACTIONS(500),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_AT] = ACTIONS(500),
    [anon_sym_open] = ACTIONS(500),
    [anon_sym_module] = ACTIONS(500),
    [anon_sym_static] = ACTIONS(500),
    [anon_sym_package] = ACTIONS(500),
    [anon_sym_import] = ACTIONS(500),
    [anon_sym_enum] = ACTIONS(500),
    [anon_sym_public] = ACTIONS(500),
    [anon_sym_protected] = ACTIONS(500),
    [anon_sym_private] = ACTIONS(500),
    [anon_sym_abstract] = ACTIONS(500),
    [anon_sym_final] = ACTIONS(500),
    [anon_sym_strictfp] = ACTIONS(500),
    [anon_sym_native] = ACTIONS(500),
    [anon_sym_transient] = ACTIONS(500),
    [anon_sym_volatile] = ACTIONS(500),
    [anon_sym_ATinterface] = ACTIONS(498),
    [anon_sym_interface] = ACTIONS(500),
    [anon_sym_byte] = ACTIONS(500),
    [anon_sym_short] = ACTIONS(500),
    [anon_sym_int] = ACTIONS(500),
    [anon_sym_long] = ACTIONS(500),
    [anon_sym_char] = ACTIONS(500),
    [anon_sym_float] = ACTIONS(500),
    [anon_sym_double] = ACTIONS(500),
    [sym_boolean_type] = ACTIONS(500),
    [sym_void_type] = ACTIONS(500),
    [sym_this] = ACTIONS(500),
    [sym_super] = ACTIONS(500),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(502),
    [sym_identifier] = ACTIONS(504),
    [sym_decimal_integer_literal] = ACTIONS(504),
    [sym_hex_integer_literal] = ACTIONS(504),
    [sym_octal_integer_literal] = ACTIONS(502),
    [sym_binary_integer_literal] = ACTIONS(502),
    [sym_decimal_floating_point_literal] = ACTIONS(502),
    [sym_hex_floating_point_literal] = ACTIONS(504),
    [sym_true] = ACTIONS(504),
    [sym_false] = ACTIONS(504),
    [sym_character_literal] = ACTIONS(502),
    [sym_string_literal] = ACTIONS(502),
    [sym_null_literal] = ACTIONS(504),
    [anon_sym_LPAREN] = ACTIONS(502),
    [anon_sym_LT] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(504),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_BANG] = ACTIONS(502),
    [anon_sym_TILDE] = ACTIONS(502),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [anon_sym_new] = ACTIONS(504),
    [anon_sym_class] = ACTIONS(504),
    [anon_sym_SEMI] = ACTIONS(502),
    [anon_sym_LBRACE] = ACTIONS(502),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_assert] = ACTIONS(504),
    [anon_sym_switch] = ACTIONS(504),
    [anon_sym_case] = ACTIONS(504),
    [anon_sym_default] = ACTIONS(504),
    [anon_sym_do] = ACTIONS(504),
    [anon_sym_while] = ACTIONS(504),
    [anon_sym_break] = ACTIONS(504),
    [anon_sym_continue] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(504),
    [anon_sym_synchronized] = ACTIONS(504),
    [anon_sym_throw] = ACTIONS(504),
    [anon_sym_try] = ACTIONS(504),
    [anon_sym_if] = ACTIONS(504),
    [anon_sym_else] = ACTIONS(504),
    [anon_sym_for] = ACTIONS(504),
    [anon_sym_AT] = ACTIONS(504),
    [anon_sym_open] = ACTIONS(504),
    [anon_sym_module] = ACTIONS(504),
    [anon_sym_static] = ACTIONS(504),
    [anon_sym_package] = ACTIONS(504),
    [anon_sym_import] = ACTIONS(504),
    [anon_sym_enum] = ACTIONS(504),
    [anon_sym_public] = ACTIONS(504),
    [anon_sym_protected] = ACTIONS(504),
    [anon_sym_private] = ACTIONS(504),
    [anon_sym_abstract] = ACTIONS(504),
    [anon_sym_final] = ACTIONS(504),
    [anon_sym_strictfp] = ACTIONS(504),
    [anon_sym_native] = ACTIONS(504),
    [anon_sym_transient] = ACTIONS(504),
    [anon_sym_volatile] = ACTIONS(504),
    [anon_sym_ATinterface] = ACTIONS(502),
    [anon_sym_interface] = ACTIONS(504),
    [anon_sym_byte] = ACTIONS(504),
    [anon_sym_short] = ACTIONS(504),
    [anon_sym_int] = ACTIONS(504),
    [anon_sym_long] = ACTIONS(504),
    [anon_sym_char] = ACTIONS(504),
    [anon_sym_float] = ACTIONS(504),
    [anon_sym_double] = ACTIONS(504),
    [sym_boolean_type] = ACTIONS(504),
    [sym_void_type] = ACTIONS(504),
    [sym_this] = ACTIONS(504),
    [sym_super] = ACTIONS(504),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(506),
    [sym_identifier] = ACTIONS(508),
    [sym_decimal_integer_literal] = ACTIONS(508),
    [sym_hex_integer_literal] = ACTIONS(508),
    [sym_octal_integer_literal] = ACTIONS(506),
    [sym_binary_integer_literal] = ACTIONS(506),
    [sym_decimal_floating_point_literal] = ACTIONS(506),
    [sym_hex_floating_point_literal] = ACTIONS(508),
    [sym_true] = ACTIONS(508),
    [sym_false] = ACTIONS(508),
    [sym_character_literal] = ACTIONS(506),
    [sym_string_literal] = ACTIONS(506),
    [sym_null_literal] = ACTIONS(508),
    [anon_sym_LPAREN] = ACTIONS(506),
    [anon_sym_LT] = ACTIONS(506),
    [anon_sym_PLUS] = ACTIONS(508),
    [anon_sym_DASH] = ACTIONS(508),
    [anon_sym_BANG] = ACTIONS(506),
    [anon_sym_TILDE] = ACTIONS(506),
    [anon_sym_PLUS_PLUS] = ACTIONS(506),
    [anon_sym_DASH_DASH] = ACTIONS(506),
    [anon_sym_new] = ACTIONS(508),
    [anon_sym_class] = ACTIONS(508),
    [anon_sym_SEMI] = ACTIONS(506),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_RBRACE] = ACTIONS(506),
    [anon_sym_assert] = ACTIONS(508),
    [anon_sym_switch] = ACTIONS(508),
    [anon_sym_case] = ACTIONS(508),
    [anon_sym_default] = ACTIONS(508),
    [anon_sym_do] = ACTIONS(508),
    [anon_sym_while] = ACTIONS(508),
    [anon_sym_break] = ACTIONS(508),
    [anon_sym_continue] = ACTIONS(508),
    [anon_sym_return] = ACTIONS(508),
    [anon_sym_synchronized] = ACTIONS(508),
    [anon_sym_throw] = ACTIONS(508),
    [anon_sym_try] = ACTIONS(508),
    [anon_sym_if] = ACTIONS(508),
    [anon_sym_else] = ACTIONS(508),
    [anon_sym_for] = ACTIONS(508),
    [anon_sym_AT] = ACTIONS(508),
    [anon_sym_open] = ACTIONS(508),
    [anon_sym_module] = ACTIONS(508),
    [anon_sym_static] = ACTIONS(508),
    [anon_sym_package] = ACTIONS(508),
    [anon_sym_import] = ACTIONS(508),
    [anon_sym_enum] = ACTIONS(508),
    [anon_sym_public] = ACTIONS(508),
    [anon_sym_protected] = ACTIONS(508),
    [anon_sym_private] = ACTIONS(508),
    [anon_sym_abstract] = ACTIONS(508),
    [anon_sym_final] = ACTIONS(508),
    [anon_sym_strictfp] = ACTIONS(508),
    [anon_sym_native] = ACTIONS(508),
    [anon_sym_transient] = ACTIONS(508),
    [anon_sym_volatile] = ACTIONS(508),
    [anon_sym_ATinterface] = ACTIONS(506),
    [anon_sym_interface] = ACTIONS(508),
    [anon_sym_byte] = ACTIONS(508),
    [anon_sym_short] = ACTIONS(508),
    [anon_sym_int] = ACTIONS(508),
    [anon_sym_long] = ACTIONS(508),
    [anon_sym_char] = ACTIONS(508),
    [anon_sym_float] = ACTIONS(508),
    [anon_sym_double] = ACTIONS(508),
    [sym_boolean_type] = ACTIONS(508),
    [sym_void_type] = ACTIONS(508),
    [sym_this] = ACTIONS(508),
    [sym_super] = ACTIONS(508),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(510),
    [sym_identifier] = ACTIONS(512),
    [sym_decimal_integer_literal] = ACTIONS(512),
    [sym_hex_integer_literal] = ACTIONS(512),
    [sym_octal_integer_literal] = ACTIONS(510),
    [sym_binary_integer_literal] = ACTIONS(510),
    [sym_decimal_floating_point_literal] = ACTIONS(510),
    [sym_hex_floating_point_literal] = ACTIONS(512),
    [sym_true] = ACTIONS(512),
    [sym_false] = ACTIONS(512),
    [sym_character_literal] = ACTIONS(510),
    [sym_string_literal] = ACTIONS(510),
    [sym_null_literal] = ACTIONS(512),
    [anon_sym_LPAREN] = ACTIONS(510),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_PLUS] = ACTIONS(512),
    [anon_sym_DASH] = ACTIONS(512),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(510),
    [anon_sym_PLUS_PLUS] = ACTIONS(510),
    [anon_sym_DASH_DASH] = ACTIONS(510),
    [anon_sym_new] = ACTIONS(512),
    [anon_sym_class] = ACTIONS(512),
    [anon_sym_SEMI] = ACTIONS(510),
    [anon_sym_LBRACE] = ACTIONS(510),
    [anon_sym_RBRACE] = ACTIONS(510),
    [anon_sym_assert] = ACTIONS(512),
    [anon_sym_switch] = ACTIONS(512),
    [anon_sym_case] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(512),
    [anon_sym_do] = ACTIONS(512),
    [anon_sym_while] = ACTIONS(512),
    [anon_sym_break] = ACTIONS(512),
    [anon_sym_continue] = ACTIONS(512),
    [anon_sym_return] = ACTIONS(512),
    [anon_sym_synchronized] = ACTIONS(512),
    [anon_sym_throw] = ACTIONS(512),
    [anon_sym_try] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(512),
    [anon_sym_else] = ACTIONS(512),
    [anon_sym_for] = ACTIONS(512),
    [anon_sym_AT] = ACTIONS(512),
    [anon_sym_open] = ACTIONS(512),
    [anon_sym_module] = ACTIONS(512),
    [anon_sym_static] = ACTIONS(512),
    [anon_sym_package] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(512),
    [anon_sym_enum] = ACTIONS(512),
    [anon_sym_public] = ACTIONS(512),
    [anon_sym_protected] = ACTIONS(512),
    [anon_sym_private] = ACTIONS(512),
    [anon_sym_abstract] = ACTIONS(512),
    [anon_sym_final] = ACTIONS(512),
    [anon_sym_strictfp] = ACTIONS(512),
    [anon_sym_native] = ACTIONS(512),
    [anon_sym_transient] = ACTIONS(512),
    [anon_sym_volatile] = ACTIONS(512),
    [anon_sym_ATinterface] = ACTIONS(510),
    [anon_sym_interface] = ACTIONS(512),
    [anon_sym_byte] = ACTIONS(512),
    [anon_sym_short] = ACTIONS(512),
    [anon_sym_int] = ACTIONS(512),
    [anon_sym_long] = ACTIONS(512),
    [anon_sym_char] = ACTIONS(512),
    [anon_sym_float] = ACTIONS(512),
    [anon_sym_double] = ACTIONS(512),
    [sym_boolean_type] = ACTIONS(512),
    [sym_void_type] = ACTIONS(512),
    [sym_this] = ACTIONS(512),
    [sym_super] = ACTIONS(512),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [ts_builtin_sym_end] = ACTIONS(514),
    [sym_identifier] = ACTIONS(516),
    [sym_decimal_integer_literal] = ACTIONS(516),
    [sym_hex_integer_literal] = ACTIONS(516),
    [sym_octal_integer_literal] = ACTIONS(514),
    [sym_binary_integer_literal] = ACTIONS(514),
    [sym_decimal_floating_point_literal] = ACTIONS(514),
    [sym_hex_floating_point_literal] = ACTIONS(516),
    [sym_true] = ACTIONS(516),
    [sym_false] = ACTIONS(516),
    [sym_character_literal] = ACTIONS(514),
    [sym_string_literal] = ACTIONS(514),
    [sym_null_literal] = ACTIONS(516),
    [anon_sym_LPAREN] = ACTIONS(514),
    [anon_sym_LT] = ACTIONS(514),
    [anon_sym_PLUS] = ACTIONS(516),
    [anon_sym_DASH] = ACTIONS(516),
    [anon_sym_BANG] = ACTIONS(514),
    [anon_sym_TILDE] = ACTIONS(514),
    [anon_sym_PLUS_PLUS] = ACTIONS(514),
    [anon_sym_DASH_DASH] = ACTIONS(514),
    [anon_sym_new] = ACTIONS(516),
    [anon_sym_class] = ACTIONS(516),
    [anon_sym_SEMI] = ACTIONS(514),
    [anon_sym_LBRACE] = ACTIONS(514),
    [anon_sym_RBRACE] = ACTIONS(514),
    [anon_sym_assert] = ACTIONS(516),
    [anon_sym_switch] = ACTIONS(516),
    [anon_sym_case] = ACTIONS(516),
    [anon_sym_default] = ACTIONS(516),
    [anon_sym_do] = ACTIONS(516),
    [anon_sym_while] = ACTIONS(516),
    [anon_sym_break] = ACTIONS(516),
    [anon_sym_continue] = ACTIONS(516),
    [anon_sym_return] = ACTIONS(516),
    [anon_sym_synchronized] = ACTIONS(516),
    [anon_sym_throw] = ACTIONS(516),
    [anon_sym_try] = ACTIONS(516),
    [anon_sym_if] = ACTIONS(516),
    [anon_sym_else] = ACTIONS(516),
    [anon_sym_for] = ACTIONS(516),
    [anon_sym_AT] = ACTIONS(516),
    [anon_sym_open] = ACTIONS(516),
    [anon_sym_module] = ACTIONS(516),
    [anon_sym_static] = ACTIONS(516),
    [anon_sym_package] = ACTIONS(516),
    [anon_sym_import] = ACTIONS(516),
    [anon_sym_enum] = ACTIONS(516),
    [anon_sym_public] = ACTIONS(516),
    [anon_sym_protected] = ACTIONS(516),
    [anon_sym_private] = ACTIONS(516),
    [anon_sym_abstract] = ACTIONS(516),
    [anon_sym_final] = ACTIONS(516),
    [anon_sym_strictfp] = ACTIONS(516),
    [anon_sym_native] = ACTIONS(516),
    [anon_sym_transient] = ACTIONS(516),
    [anon_sym_volatile] = ACTIONS(516),
    [anon_sym_ATinterface] = ACTIONS(514),
    [anon_sym_interface] = ACTIONS(516),
    [anon_sym_byte] = ACTIONS(516),
    [anon_sym_short] = ACTIONS(516),
    [anon_sym_int] = ACTIONS(516),
    [anon_sym_long] = ACTIONS(516),
    [anon_sym_char] = ACTIONS(516),
    [anon_sym_float] = ACTIONS(516),
    [anon_sym_double] = ACTIONS(516),
    [sym_boolean_type] = ACTIONS(516),
    [sym_void_type] = ACTIONS(516),
    [sym_this] = ACTIONS(516),
    [sym_super] = ACTIONS(516),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [ts_builtin_sym_end] = ACTIONS(518),
    [sym_identifier] = ACTIONS(520),
    [sym_decimal_integer_literal] = ACTIONS(520),
    [sym_hex_integer_literal] = ACTIONS(520),
    [sym_octal_integer_literal] = ACTIONS(518),
    [sym_binary_integer_literal] = ACTIONS(518),
    [sym_decimal_floating_point_literal] = ACTIONS(518),
    [sym_hex_floating_point_literal] = ACTIONS(520),
    [sym_true] = ACTIONS(520),
    [sym_false] = ACTIONS(520),
    [sym_character_literal] = ACTIONS(518),
    [sym_string_literal] = ACTIONS(518),
    [sym_null_literal] = ACTIONS(520),
    [anon_sym_LPAREN] = ACTIONS(518),
    [anon_sym_LT] = ACTIONS(518),
    [anon_sym_PLUS] = ACTIONS(520),
    [anon_sym_DASH] = ACTIONS(520),
    [anon_sym_BANG] = ACTIONS(518),
    [anon_sym_TILDE] = ACTIONS(518),
    [anon_sym_PLUS_PLUS] = ACTIONS(518),
    [anon_sym_DASH_DASH] = ACTIONS(518),
    [anon_sym_new] = ACTIONS(520),
    [anon_sym_class] = ACTIONS(520),
    [anon_sym_SEMI] = ACTIONS(518),
    [anon_sym_LBRACE] = ACTIONS(518),
    [anon_sym_RBRACE] = ACTIONS(518),
    [anon_sym_assert] = ACTIONS(520),
    [anon_sym_switch] = ACTIONS(520),
    [anon_sym_case] = ACTIONS(520),
    [anon_sym_default] = ACTIONS(520),
    [anon_sym_do] = ACTIONS(520),
    [anon_sym_while] = ACTIONS(520),
    [anon_sym_break] = ACTIONS(520),
    [anon_sym_continue] = ACTIONS(520),
    [anon_sym_return] = ACTIONS(520),
    [anon_sym_synchronized] = ACTIONS(520),
    [anon_sym_throw] = ACTIONS(520),
    [anon_sym_try] = ACTIONS(520),
    [anon_sym_if] = ACTIONS(520),
    [anon_sym_else] = ACTIONS(520),
    [anon_sym_for] = ACTIONS(520),
    [anon_sym_AT] = ACTIONS(520),
    [anon_sym_open] = ACTIONS(520),
    [anon_sym_module] = ACTIONS(520),
    [anon_sym_static] = ACTIONS(520),
    [anon_sym_package] = ACTIONS(520),
    [anon_sym_import] = ACTIONS(520),
    [anon_sym_enum] = ACTIONS(520),
    [anon_sym_public] = ACTIONS(520),
    [anon_sym_protected] = ACTIONS(520),
    [anon_sym_private] = ACTIONS(520),
    [anon_sym_abstract] = ACTIONS(520),
    [anon_sym_final] = ACTIONS(520),
    [anon_sym_strictfp] = ACTIONS(520),
    [anon_sym_native] = ACTIONS(520),
    [anon_sym_transient] = ACTIONS(520),
    [anon_sym_volatile] = ACTIONS(520),
    [anon_sym_ATinterface] = ACTIONS(518),
    [anon_sym_interface] = ACTIONS(520),
    [anon_sym_byte] = ACTIONS(520),
    [anon_sym_short] = ACTIONS(520),
    [anon_sym_int] = ACTIONS(520),
    [anon_sym_long] = ACTIONS(520),
    [anon_sym_char] = ACTIONS(520),
    [anon_sym_float] = ACTIONS(520),
    [anon_sym_double] = ACTIONS(520),
    [sym_boolean_type] = ACTIONS(520),
    [sym_void_type] = ACTIONS(520),
    [sym_this] = ACTIONS(520),
    [sym_super] = ACTIONS(520),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(522),
    [sym_identifier] = ACTIONS(524),
    [sym_decimal_integer_literal] = ACTIONS(524),
    [sym_hex_integer_literal] = ACTIONS(524),
    [sym_octal_integer_literal] = ACTIONS(522),
    [sym_binary_integer_literal] = ACTIONS(522),
    [sym_decimal_floating_point_literal] = ACTIONS(522),
    [sym_hex_floating_point_literal] = ACTIONS(524),
    [sym_true] = ACTIONS(524),
    [sym_false] = ACTIONS(524),
    [sym_character_literal] = ACTIONS(522),
    [sym_string_literal] = ACTIONS(522),
    [sym_null_literal] = ACTIONS(524),
    [anon_sym_LPAREN] = ACTIONS(522),
    [anon_sym_LT] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(524),
    [anon_sym_DASH] = ACTIONS(524),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_TILDE] = ACTIONS(522),
    [anon_sym_PLUS_PLUS] = ACTIONS(522),
    [anon_sym_DASH_DASH] = ACTIONS(522),
    [anon_sym_new] = ACTIONS(524),
    [anon_sym_class] = ACTIONS(524),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(522),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_assert] = ACTIONS(524),
    [anon_sym_switch] = ACTIONS(524),
    [anon_sym_case] = ACTIONS(524),
    [anon_sym_default] = ACTIONS(524),
    [anon_sym_do] = ACTIONS(524),
    [anon_sym_while] = ACTIONS(524),
    [anon_sym_break] = ACTIONS(524),
    [anon_sym_continue] = ACTIONS(524),
    [anon_sym_return] = ACTIONS(524),
    [anon_sym_synchronized] = ACTIONS(524),
    [anon_sym_throw] = ACTIONS(524),
    [anon_sym_try] = ACTIONS(524),
    [anon_sym_if] = ACTIONS(524),
    [anon_sym_else] = ACTIONS(524),
    [anon_sym_for] = ACTIONS(524),
    [anon_sym_AT] = ACTIONS(524),
    [anon_sym_open] = ACTIONS(524),
    [anon_sym_module] = ACTIONS(524),
    [anon_sym_static] = ACTIONS(524),
    [anon_sym_package] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(524),
    [anon_sym_enum] = ACTIONS(524),
    [anon_sym_public] = ACTIONS(524),
    [anon_sym_protected] = ACTIONS(524),
    [anon_sym_private] = ACTIONS(524),
    [anon_sym_abstract] = ACTIONS(524),
    [anon_sym_final] = ACTIONS(524),
    [anon_sym_strictfp] = ACTIONS(524),
    [anon_sym_native] = ACTIONS(524),
    [anon_sym_transient] = ACTIONS(524),
    [anon_sym_volatile] = ACTIONS(524),
    [anon_sym_ATinterface] = ACTIONS(522),
    [anon_sym_interface] = ACTIONS(524),
    [anon_sym_byte] = ACTIONS(524),
    [anon_sym_short] = ACTIONS(524),
    [anon_sym_int] = ACTIONS(524),
    [anon_sym_long] = ACTIONS(524),
    [anon_sym_char] = ACTIONS(524),
    [anon_sym_float] = ACTIONS(524),
    [anon_sym_double] = ACTIONS(524),
    [sym_boolean_type] = ACTIONS(524),
    [sym_void_type] = ACTIONS(524),
    [sym_this] = ACTIONS(524),
    [sym_super] = ACTIONS(524),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(526),
    [sym_identifier] = ACTIONS(528),
    [sym_decimal_integer_literal] = ACTIONS(528),
    [sym_hex_integer_literal] = ACTIONS(528),
    [sym_octal_integer_literal] = ACTIONS(526),
    [sym_binary_integer_literal] = ACTIONS(526),
    [sym_decimal_floating_point_literal] = ACTIONS(526),
    [sym_hex_floating_point_literal] = ACTIONS(528),
    [sym_true] = ACTIONS(528),
    [sym_false] = ACTIONS(528),
    [sym_character_literal] = ACTIONS(526),
    [sym_string_literal] = ACTIONS(526),
    [sym_null_literal] = ACTIONS(528),
    [anon_sym_LPAREN] = ACTIONS(526),
    [anon_sym_LT] = ACTIONS(526),
    [anon_sym_PLUS] = ACTIONS(528),
    [anon_sym_DASH] = ACTIONS(528),
    [anon_sym_BANG] = ACTIONS(526),
    [anon_sym_TILDE] = ACTIONS(526),
    [anon_sym_PLUS_PLUS] = ACTIONS(526),
    [anon_sym_DASH_DASH] = ACTIONS(526),
    [anon_sym_new] = ACTIONS(528),
    [anon_sym_class] = ACTIONS(528),
    [anon_sym_SEMI] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(526),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_assert] = ACTIONS(528),
    [anon_sym_switch] = ACTIONS(528),
    [anon_sym_case] = ACTIONS(528),
    [anon_sym_default] = ACTIONS(528),
    [anon_sym_do] = ACTIONS(528),
    [anon_sym_while] = ACTIONS(528),
    [anon_sym_break] = ACTIONS(528),
    [anon_sym_continue] = ACTIONS(528),
    [anon_sym_return] = ACTIONS(528),
    [anon_sym_synchronized] = ACTIONS(528),
    [anon_sym_throw] = ACTIONS(528),
    [anon_sym_try] = ACTIONS(528),
    [anon_sym_if] = ACTIONS(528),
    [anon_sym_else] = ACTIONS(528),
    [anon_sym_for] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(528),
    [anon_sym_open] = ACTIONS(528),
    [anon_sym_module] = ACTIONS(528),
    [anon_sym_static] = ACTIONS(528),
    [anon_sym_package] = ACTIONS(528),
    [anon_sym_import] = ACTIONS(528),
    [anon_sym_enum] = ACTIONS(528),
    [anon_sym_public] = ACTIONS(528),
    [anon_sym_protected] = ACTIONS(528),
    [anon_sym_private] = ACTIONS(528),
    [anon_sym_abstract] = ACTIONS(528),
    [anon_sym_final] = ACTIONS(528),
    [anon_sym_strictfp] = ACTIONS(528),
    [anon_sym_native] = ACTIONS(528),
    [anon_sym_transient] = ACTIONS(528),
    [anon_sym_volatile] = ACTIONS(528),
    [anon_sym_ATinterface] = ACTIONS(526),
    [anon_sym_interface] = ACTIONS(528),
    [anon_sym_byte] = ACTIONS(528),
    [anon_sym_short] = ACTIONS(528),
    [anon_sym_int] = ACTIONS(528),
    [anon_sym_long] = ACTIONS(528),
    [anon_sym_char] = ACTIONS(528),
    [anon_sym_float] = ACTIONS(528),
    [anon_sym_double] = ACTIONS(528),
    [sym_boolean_type] = ACTIONS(528),
    [sym_void_type] = ACTIONS(528),
    [sym_this] = ACTIONS(528),
    [sym_super] = ACTIONS(528),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(530),
    [sym_identifier] = ACTIONS(532),
    [sym_decimal_integer_literal] = ACTIONS(532),
    [sym_hex_integer_literal] = ACTIONS(532),
    [sym_octal_integer_literal] = ACTIONS(530),
    [sym_binary_integer_literal] = ACTIONS(530),
    [sym_decimal_floating_point_literal] = ACTIONS(530),
    [sym_hex_floating_point_literal] = ACTIONS(532),
    [sym_true] = ACTIONS(532),
    [sym_false] = ACTIONS(532),
    [sym_character_literal] = ACTIONS(530),
    [sym_string_literal] = ACTIONS(530),
    [sym_null_literal] = ACTIONS(532),
    [anon_sym_LPAREN] = ACTIONS(530),
    [anon_sym_LT] = ACTIONS(530),
    [anon_sym_PLUS] = ACTIONS(532),
    [anon_sym_DASH] = ACTIONS(532),
    [anon_sym_BANG] = ACTIONS(530),
    [anon_sym_TILDE] = ACTIONS(530),
    [anon_sym_PLUS_PLUS] = ACTIONS(530),
    [anon_sym_DASH_DASH] = ACTIONS(530),
    [anon_sym_new] = ACTIONS(532),
    [anon_sym_class] = ACTIONS(532),
    [anon_sym_SEMI] = ACTIONS(530),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_assert] = ACTIONS(532),
    [anon_sym_switch] = ACTIONS(532),
    [anon_sym_case] = ACTIONS(532),
    [anon_sym_default] = ACTIONS(532),
    [anon_sym_do] = ACTIONS(532),
    [anon_sym_while] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(532),
    [anon_sym_continue] = ACTIONS(532),
    [anon_sym_return] = ACTIONS(532),
    [anon_sym_synchronized] = ACTIONS(532),
    [anon_sym_throw] = ACTIONS(532),
    [anon_sym_try] = ACTIONS(532),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_else] = ACTIONS(532),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_open] = ACTIONS(532),
    [anon_sym_module] = ACTIONS(532),
    [anon_sym_static] = ACTIONS(532),
    [anon_sym_package] = ACTIONS(532),
    [anon_sym_import] = ACTIONS(532),
    [anon_sym_enum] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(532),
    [anon_sym_protected] = ACTIONS(532),
    [anon_sym_private] = ACTIONS(532),
    [anon_sym_abstract] = ACTIONS(532),
    [anon_sym_final] = ACTIONS(532),
    [anon_sym_strictfp] = ACTIONS(532),
    [anon_sym_native] = ACTIONS(532),
    [anon_sym_transient] = ACTIONS(532),
    [anon_sym_volatile] = ACTIONS(532),
    [anon_sym_ATinterface] = ACTIONS(530),
    [anon_sym_interface] = ACTIONS(532),
    [anon_sym_byte] = ACTIONS(532),
    [anon_sym_short] = ACTIONS(532),
    [anon_sym_int] = ACTIONS(532),
    [anon_sym_long] = ACTIONS(532),
    [anon_sym_char] = ACTIONS(532),
    [anon_sym_float] = ACTIONS(532),
    [anon_sym_double] = ACTIONS(532),
    [sym_boolean_type] = ACTIONS(532),
    [sym_void_type] = ACTIONS(532),
    [sym_this] = ACTIONS(532),
    [sym_super] = ACTIONS(532),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [ts_builtin_sym_end] = ACTIONS(534),
    [sym_identifier] = ACTIONS(536),
    [sym_decimal_integer_literal] = ACTIONS(536),
    [sym_hex_integer_literal] = ACTIONS(536),
    [sym_octal_integer_literal] = ACTIONS(534),
    [sym_binary_integer_literal] = ACTIONS(534),
    [sym_decimal_floating_point_literal] = ACTIONS(534),
    [sym_hex_floating_point_literal] = ACTIONS(536),
    [sym_true] = ACTIONS(536),
    [sym_false] = ACTIONS(536),
    [sym_character_literal] = ACTIONS(534),
    [sym_string_literal] = ACTIONS(534),
    [sym_null_literal] = ACTIONS(536),
    [anon_sym_LPAREN] = ACTIONS(534),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(536),
    [anon_sym_DASH] = ACTIONS(536),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(534),
    [anon_sym_PLUS_PLUS] = ACTIONS(534),
    [anon_sym_DASH_DASH] = ACTIONS(534),
    [anon_sym_new] = ACTIONS(536),
    [anon_sym_class] = ACTIONS(536),
    [anon_sym_SEMI] = ACTIONS(534),
    [anon_sym_LBRACE] = ACTIONS(534),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_assert] = ACTIONS(536),
    [anon_sym_switch] = ACTIONS(536),
    [anon_sym_case] = ACTIONS(536),
    [anon_sym_default] = ACTIONS(536),
    [anon_sym_do] = ACTIONS(536),
    [anon_sym_while] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(536),
    [anon_sym_continue] = ACTIONS(536),
    [anon_sym_return] = ACTIONS(536),
    [anon_sym_synchronized] = ACTIONS(536),
    [anon_sym_throw] = ACTIONS(536),
    [anon_sym_try] = ACTIONS(536),
    [anon_sym_if] = ACTIONS(536),
    [anon_sym_else] = ACTIONS(536),
    [anon_sym_for] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_open] = ACTIONS(536),
    [anon_sym_module] = ACTIONS(536),
    [anon_sym_static] = ACTIONS(536),
    [anon_sym_package] = ACTIONS(536),
    [anon_sym_import] = ACTIONS(536),
    [anon_sym_enum] = ACTIONS(536),
    [anon_sym_public] = ACTIONS(536),
    [anon_sym_protected] = ACTIONS(536),
    [anon_sym_private] = ACTIONS(536),
    [anon_sym_abstract] = ACTIONS(536),
    [anon_sym_final] = ACTIONS(536),
    [anon_sym_strictfp] = ACTIONS(536),
    [anon_sym_native] = ACTIONS(536),
    [anon_sym_transient] = ACTIONS(536),
    [anon_sym_volatile] = ACTIONS(536),
    [anon_sym_ATinterface] = ACTIONS(534),
    [anon_sym_interface] = ACTIONS(536),
    [anon_sym_byte] = ACTIONS(536),
    [anon_sym_short] = ACTIONS(536),
    [anon_sym_int] = ACTIONS(536),
    [anon_sym_long] = ACTIONS(536),
    [anon_sym_char] = ACTIONS(536),
    [anon_sym_float] = ACTIONS(536),
    [anon_sym_double] = ACTIONS(536),
    [sym_boolean_type] = ACTIONS(536),
    [sym_void_type] = ACTIONS(536),
    [sym_this] = ACTIONS(536),
    [sym_super] = ACTIONS(536),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(538),
    [sym_identifier] = ACTIONS(540),
    [sym_decimal_integer_literal] = ACTIONS(540),
    [sym_hex_integer_literal] = ACTIONS(540),
    [sym_octal_integer_literal] = ACTIONS(538),
    [sym_binary_integer_literal] = ACTIONS(538),
    [sym_decimal_floating_point_literal] = ACTIONS(538),
    [sym_hex_floating_point_literal] = ACTIONS(540),
    [sym_true] = ACTIONS(540),
    [sym_false] = ACTIONS(540),
    [sym_character_literal] = ACTIONS(538),
    [sym_string_literal] = ACTIONS(538),
    [sym_null_literal] = ACTIONS(540),
    [anon_sym_LPAREN] = ACTIONS(538),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(540),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_TILDE] = ACTIONS(538),
    [anon_sym_PLUS_PLUS] = ACTIONS(538),
    [anon_sym_DASH_DASH] = ACTIONS(538),
    [anon_sym_new] = ACTIONS(540),
    [anon_sym_class] = ACTIONS(540),
    [anon_sym_SEMI] = ACTIONS(538),
    [anon_sym_LBRACE] = ACTIONS(538),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_assert] = ACTIONS(540),
    [anon_sym_switch] = ACTIONS(540),
    [anon_sym_case] = ACTIONS(540),
    [anon_sym_default] = ACTIONS(540),
    [anon_sym_do] = ACTIONS(540),
    [anon_sym_while] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(540),
    [anon_sym_continue] = ACTIONS(540),
    [anon_sym_return] = ACTIONS(540),
    [anon_sym_synchronized] = ACTIONS(540),
    [anon_sym_throw] = ACTIONS(540),
    [anon_sym_try] = ACTIONS(540),
    [anon_sym_if] = ACTIONS(540),
    [anon_sym_else] = ACTIONS(540),
    [anon_sym_for] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_open] = ACTIONS(540),
    [anon_sym_module] = ACTIONS(540),
    [anon_sym_static] = ACTIONS(540),
    [anon_sym_package] = ACTIONS(540),
    [anon_sym_import] = ACTIONS(540),
    [anon_sym_enum] = ACTIONS(540),
    [anon_sym_public] = ACTIONS(540),
    [anon_sym_protected] = ACTIONS(540),
    [anon_sym_private] = ACTIONS(540),
    [anon_sym_abstract] = ACTIONS(540),
    [anon_sym_final] = ACTIONS(540),
    [anon_sym_strictfp] = ACTIONS(540),
    [anon_sym_native] = ACTIONS(540),
    [anon_sym_transient] = ACTIONS(540),
    [anon_sym_volatile] = ACTIONS(540),
    [anon_sym_ATinterface] = ACTIONS(538),
    [anon_sym_interface] = ACTIONS(540),
    [anon_sym_byte] = ACTIONS(540),
    [anon_sym_short] = ACTIONS(540),
    [anon_sym_int] = ACTIONS(540),
    [anon_sym_long] = ACTIONS(540),
    [anon_sym_char] = ACTIONS(540),
    [anon_sym_float] = ACTIONS(540),
    [anon_sym_double] = ACTIONS(540),
    [sym_boolean_type] = ACTIONS(540),
    [sym_void_type] = ACTIONS(540),
    [sym_this] = ACTIONS(540),
    [sym_super] = ACTIONS(540),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(392),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_block] = STATE(398),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [ts_builtin_sym_end] = ACTIONS(542),
    [sym_identifier] = ACTIONS(544),
    [sym_decimal_integer_literal] = ACTIONS(544),
    [sym_hex_integer_literal] = ACTIONS(544),
    [sym_octal_integer_literal] = ACTIONS(542),
    [sym_binary_integer_literal] = ACTIONS(542),
    [sym_decimal_floating_point_literal] = ACTIONS(542),
    [sym_hex_floating_point_literal] = ACTIONS(544),
    [sym_true] = ACTIONS(544),
    [sym_false] = ACTIONS(544),
    [sym_character_literal] = ACTIONS(542),
    [sym_string_literal] = ACTIONS(542),
    [sym_null_literal] = ACTIONS(544),
    [anon_sym_LPAREN] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(544),
    [anon_sym_DASH] = ACTIONS(544),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_PLUS_PLUS] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(542),
    [anon_sym_new] = ACTIONS(544),
    [anon_sym_class] = ACTIONS(544),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(542),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_assert] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(544),
    [anon_sym_case] = ACTIONS(544),
    [anon_sym_default] = ACTIONS(544),
    [anon_sym_do] = ACTIONS(544),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(544),
    [anon_sym_return] = ACTIONS(544),
    [anon_sym_synchronized] = ACTIONS(544),
    [anon_sym_throw] = ACTIONS(544),
    [anon_sym_try] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_else] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_open] = ACTIONS(544),
    [anon_sym_module] = ACTIONS(544),
    [anon_sym_static] = ACTIONS(544),
    [anon_sym_package] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(544),
    [anon_sym_enum] = ACTIONS(544),
    [anon_sym_public] = ACTIONS(544),
    [anon_sym_protected] = ACTIONS(544),
    [anon_sym_private] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(544),
    [anon_sym_final] = ACTIONS(544),
    [anon_sym_strictfp] = ACTIONS(544),
    [anon_sym_native] = ACTIONS(544),
    [anon_sym_transient] = ACTIONS(544),
    [anon_sym_volatile] = ACTIONS(544),
    [anon_sym_ATinterface] = ACTIONS(542),
    [anon_sym_interface] = ACTIONS(544),
    [anon_sym_byte] = ACTIONS(544),
    [anon_sym_short] = ACTIONS(544),
    [anon_sym_int] = ACTIONS(544),
    [anon_sym_long] = ACTIONS(544),
    [anon_sym_char] = ACTIONS(544),
    [anon_sym_float] = ACTIONS(544),
    [anon_sym_double] = ACTIONS(544),
    [sym_boolean_type] = ACTIONS(544),
    [sym_void_type] = ACTIONS(544),
    [sym_this] = ACTIONS(544),
    [sym_super] = ACTIONS(544),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(546),
    [sym_identifier] = ACTIONS(548),
    [sym_decimal_integer_literal] = ACTIONS(548),
    [sym_hex_integer_literal] = ACTIONS(548),
    [sym_octal_integer_literal] = ACTIONS(546),
    [sym_binary_integer_literal] = ACTIONS(546),
    [sym_decimal_floating_point_literal] = ACTIONS(546),
    [sym_hex_floating_point_literal] = ACTIONS(548),
    [sym_true] = ACTIONS(548),
    [sym_false] = ACTIONS(548),
    [sym_character_literal] = ACTIONS(546),
    [sym_string_literal] = ACTIONS(546),
    [sym_null_literal] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(548),
    [anon_sym_DASH] = ACTIONS(548),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(546),
    [anon_sym_PLUS_PLUS] = ACTIONS(546),
    [anon_sym_DASH_DASH] = ACTIONS(546),
    [anon_sym_new] = ACTIONS(548),
    [anon_sym_class] = ACTIONS(548),
    [anon_sym_SEMI] = ACTIONS(546),
    [anon_sym_LBRACE] = ACTIONS(546),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_assert] = ACTIONS(548),
    [anon_sym_switch] = ACTIONS(548),
    [anon_sym_case] = ACTIONS(548),
    [anon_sym_default] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(548),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(548),
    [anon_sym_continue] = ACTIONS(548),
    [anon_sym_return] = ACTIONS(548),
    [anon_sym_synchronized] = ACTIONS(548),
    [anon_sym_throw] = ACTIONS(548),
    [anon_sym_try] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(548),
    [anon_sym_else] = ACTIONS(548),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_open] = ACTIONS(548),
    [anon_sym_module] = ACTIONS(548),
    [anon_sym_static] = ACTIONS(548),
    [anon_sym_package] = ACTIONS(548),
    [anon_sym_import] = ACTIONS(548),
    [anon_sym_enum] = ACTIONS(548),
    [anon_sym_public] = ACTIONS(548),
    [anon_sym_protected] = ACTIONS(548),
    [anon_sym_private] = ACTIONS(548),
    [anon_sym_abstract] = ACTIONS(548),
    [anon_sym_final] = ACTIONS(548),
    [anon_sym_strictfp] = ACTIONS(548),
    [anon_sym_native] = ACTIONS(548),
    [anon_sym_transient] = ACTIONS(548),
    [anon_sym_volatile] = ACTIONS(548),
    [anon_sym_ATinterface] = ACTIONS(546),
    [anon_sym_interface] = ACTIONS(548),
    [anon_sym_byte] = ACTIONS(548),
    [anon_sym_short] = ACTIONS(548),
    [anon_sym_int] = ACTIONS(548),
    [anon_sym_long] = ACTIONS(548),
    [anon_sym_char] = ACTIONS(548),
    [anon_sym_float] = ACTIONS(548),
    [anon_sym_double] = ACTIONS(548),
    [sym_boolean_type] = ACTIONS(548),
    [sym_void_type] = ACTIONS(548),
    [sym_this] = ACTIONS(548),
    [sym_super] = ACTIONS(548),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(550),
    [sym_identifier] = ACTIONS(552),
    [sym_decimal_integer_literal] = ACTIONS(552),
    [sym_hex_integer_literal] = ACTIONS(552),
    [sym_octal_integer_literal] = ACTIONS(550),
    [sym_binary_integer_literal] = ACTIONS(550),
    [sym_decimal_floating_point_literal] = ACTIONS(550),
    [sym_hex_floating_point_literal] = ACTIONS(552),
    [sym_true] = ACTIONS(552),
    [sym_false] = ACTIONS(552),
    [sym_character_literal] = ACTIONS(550),
    [sym_string_literal] = ACTIONS(550),
    [sym_null_literal] = ACTIONS(552),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_LT] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(552),
    [anon_sym_DASH] = ACTIONS(552),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_TILDE] = ACTIONS(550),
    [anon_sym_PLUS_PLUS] = ACTIONS(550),
    [anon_sym_DASH_DASH] = ACTIONS(550),
    [anon_sym_new] = ACTIONS(552),
    [anon_sym_class] = ACTIONS(552),
    [anon_sym_SEMI] = ACTIONS(550),
    [anon_sym_LBRACE] = ACTIONS(550),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_assert] = ACTIONS(552),
    [anon_sym_switch] = ACTIONS(552),
    [anon_sym_case] = ACTIONS(552),
    [anon_sym_default] = ACTIONS(552),
    [anon_sym_do] = ACTIONS(552),
    [anon_sym_while] = ACTIONS(552),
    [anon_sym_break] = ACTIONS(552),
    [anon_sym_continue] = ACTIONS(552),
    [anon_sym_return] = ACTIONS(552),
    [anon_sym_synchronized] = ACTIONS(552),
    [anon_sym_throw] = ACTIONS(552),
    [anon_sym_try] = ACTIONS(552),
    [anon_sym_if] = ACTIONS(552),
    [anon_sym_else] = ACTIONS(552),
    [anon_sym_for] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_open] = ACTIONS(552),
    [anon_sym_module] = ACTIONS(552),
    [anon_sym_static] = ACTIONS(552),
    [anon_sym_package] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(552),
    [anon_sym_enum] = ACTIONS(552),
    [anon_sym_public] = ACTIONS(552),
    [anon_sym_protected] = ACTIONS(552),
    [anon_sym_private] = ACTIONS(552),
    [anon_sym_abstract] = ACTIONS(552),
    [anon_sym_final] = ACTIONS(552),
    [anon_sym_strictfp] = ACTIONS(552),
    [anon_sym_native] = ACTIONS(552),
    [anon_sym_transient] = ACTIONS(552),
    [anon_sym_volatile] = ACTIONS(552),
    [anon_sym_ATinterface] = ACTIONS(550),
    [anon_sym_interface] = ACTIONS(552),
    [anon_sym_byte] = ACTIONS(552),
    [anon_sym_short] = ACTIONS(552),
    [anon_sym_int] = ACTIONS(552),
    [anon_sym_long] = ACTIONS(552),
    [anon_sym_char] = ACTIONS(552),
    [anon_sym_float] = ACTIONS(552),
    [anon_sym_double] = ACTIONS(552),
    [sym_boolean_type] = ACTIONS(552),
    [sym_void_type] = ACTIONS(552),
    [sym_this] = ACTIONS(552),
    [sym_super] = ACTIONS(552),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [ts_builtin_sym_end] = ACTIONS(554),
    [sym_identifier] = ACTIONS(556),
    [sym_decimal_integer_literal] = ACTIONS(556),
    [sym_hex_integer_literal] = ACTIONS(556),
    [sym_octal_integer_literal] = ACTIONS(554),
    [sym_binary_integer_literal] = ACTIONS(554),
    [sym_decimal_floating_point_literal] = ACTIONS(554),
    [sym_hex_floating_point_literal] = ACTIONS(556),
    [sym_true] = ACTIONS(556),
    [sym_false] = ACTIONS(556),
    [sym_character_literal] = ACTIONS(554),
    [sym_string_literal] = ACTIONS(554),
    [sym_null_literal] = ACTIONS(556),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_LT] = ACTIONS(554),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_BANG] = ACTIONS(554),
    [anon_sym_TILDE] = ACTIONS(554),
    [anon_sym_PLUS_PLUS] = ACTIONS(554),
    [anon_sym_DASH_DASH] = ACTIONS(554),
    [anon_sym_new] = ACTIONS(556),
    [anon_sym_class] = ACTIONS(556),
    [anon_sym_SEMI] = ACTIONS(554),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_assert] = ACTIONS(556),
    [anon_sym_switch] = ACTIONS(556),
    [anon_sym_case] = ACTIONS(556),
    [anon_sym_default] = ACTIONS(556),
    [anon_sym_do] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(556),
    [anon_sym_break] = ACTIONS(556),
    [anon_sym_continue] = ACTIONS(556),
    [anon_sym_return] = ACTIONS(556),
    [anon_sym_synchronized] = ACTIONS(556),
    [anon_sym_throw] = ACTIONS(556),
    [anon_sym_try] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(556),
    [anon_sym_else] = ACTIONS(556),
    [anon_sym_for] = ACTIONS(556),
    [anon_sym_AT] = ACTIONS(556),
    [anon_sym_open] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_package] = ACTIONS(556),
    [anon_sym_import] = ACTIONS(556),
    [anon_sym_enum] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(556),
    [anon_sym_final] = ACTIONS(556),
    [anon_sym_strictfp] = ACTIONS(556),
    [anon_sym_native] = ACTIONS(556),
    [anon_sym_transient] = ACTIONS(556),
    [anon_sym_volatile] = ACTIONS(556),
    [anon_sym_ATinterface] = ACTIONS(554),
    [anon_sym_interface] = ACTIONS(556),
    [anon_sym_byte] = ACTIONS(556),
    [anon_sym_short] = ACTIONS(556),
    [anon_sym_int] = ACTIONS(556),
    [anon_sym_long] = ACTIONS(556),
    [anon_sym_char] = ACTIONS(556),
    [anon_sym_float] = ACTIONS(556),
    [anon_sym_double] = ACTIONS(556),
    [sym_boolean_type] = ACTIONS(556),
    [sym_void_type] = ACTIONS(556),
    [sym_this] = ACTIONS(556),
    [sym_super] = ACTIONS(556),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(558),
    [sym_identifier] = ACTIONS(560),
    [sym_decimal_integer_literal] = ACTIONS(560),
    [sym_hex_integer_literal] = ACTIONS(560),
    [sym_octal_integer_literal] = ACTIONS(558),
    [sym_binary_integer_literal] = ACTIONS(558),
    [sym_decimal_floating_point_literal] = ACTIONS(558),
    [sym_hex_floating_point_literal] = ACTIONS(560),
    [sym_true] = ACTIONS(560),
    [sym_false] = ACTIONS(560),
    [sym_character_literal] = ACTIONS(558),
    [sym_string_literal] = ACTIONS(558),
    [sym_null_literal] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(558),
    [anon_sym_LT] = ACTIONS(558),
    [anon_sym_PLUS] = ACTIONS(560),
    [anon_sym_DASH] = ACTIONS(560),
    [anon_sym_BANG] = ACTIONS(558),
    [anon_sym_TILDE] = ACTIONS(558),
    [anon_sym_PLUS_PLUS] = ACTIONS(558),
    [anon_sym_DASH_DASH] = ACTIONS(558),
    [anon_sym_new] = ACTIONS(560),
    [anon_sym_class] = ACTIONS(560),
    [anon_sym_SEMI] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(558),
    [anon_sym_RBRACE] = ACTIONS(558),
    [anon_sym_assert] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(560),
    [anon_sym_case] = ACTIONS(560),
    [anon_sym_default] = ACTIONS(560),
    [anon_sym_do] = ACTIONS(560),
    [anon_sym_while] = ACTIONS(560),
    [anon_sym_break] = ACTIONS(560),
    [anon_sym_continue] = ACTIONS(560),
    [anon_sym_return] = ACTIONS(560),
    [anon_sym_synchronized] = ACTIONS(560),
    [anon_sym_throw] = ACTIONS(560),
    [anon_sym_try] = ACTIONS(560),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_else] = ACTIONS(560),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(560),
    [anon_sym_open] = ACTIONS(560),
    [anon_sym_module] = ACTIONS(560),
    [anon_sym_static] = ACTIONS(560),
    [anon_sym_package] = ACTIONS(560),
    [anon_sym_import] = ACTIONS(560),
    [anon_sym_enum] = ACTIONS(560),
    [anon_sym_public] = ACTIONS(560),
    [anon_sym_protected] = ACTIONS(560),
    [anon_sym_private] = ACTIONS(560),
    [anon_sym_abstract] = ACTIONS(560),
    [anon_sym_final] = ACTIONS(560),
    [anon_sym_strictfp] = ACTIONS(560),
    [anon_sym_native] = ACTIONS(560),
    [anon_sym_transient] = ACTIONS(560),
    [anon_sym_volatile] = ACTIONS(560),
    [anon_sym_ATinterface] = ACTIONS(558),
    [anon_sym_interface] = ACTIONS(560),
    [anon_sym_byte] = ACTIONS(560),
    [anon_sym_short] = ACTIONS(560),
    [anon_sym_int] = ACTIONS(560),
    [anon_sym_long] = ACTIONS(560),
    [anon_sym_char] = ACTIONS(560),
    [anon_sym_float] = ACTIONS(560),
    [anon_sym_double] = ACTIONS(560),
    [sym_boolean_type] = ACTIONS(560),
    [sym_void_type] = ACTIONS(560),
    [sym_this] = ACTIONS(560),
    [sym_super] = ACTIONS(560),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(562),
    [sym_identifier] = ACTIONS(564),
    [sym_decimal_integer_literal] = ACTIONS(564),
    [sym_hex_integer_literal] = ACTIONS(564),
    [sym_octal_integer_literal] = ACTIONS(562),
    [sym_binary_integer_literal] = ACTIONS(562),
    [sym_decimal_floating_point_literal] = ACTIONS(562),
    [sym_hex_floating_point_literal] = ACTIONS(564),
    [sym_true] = ACTIONS(564),
    [sym_false] = ACTIONS(564),
    [sym_character_literal] = ACTIONS(562),
    [sym_string_literal] = ACTIONS(562),
    [sym_null_literal] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_PLUS] = ACTIONS(564),
    [anon_sym_DASH] = ACTIONS(564),
    [anon_sym_BANG] = ACTIONS(562),
    [anon_sym_TILDE] = ACTIONS(562),
    [anon_sym_PLUS_PLUS] = ACTIONS(562),
    [anon_sym_DASH_DASH] = ACTIONS(562),
    [anon_sym_new] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_SEMI] = ACTIONS(562),
    [anon_sym_LBRACE] = ACTIONS(562),
    [anon_sym_RBRACE] = ACTIONS(562),
    [anon_sym_assert] = ACTIONS(564),
    [anon_sym_switch] = ACTIONS(564),
    [anon_sym_case] = ACTIONS(564),
    [anon_sym_default] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(564),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_break] = ACTIONS(564),
    [anon_sym_continue] = ACTIONS(564),
    [anon_sym_return] = ACTIONS(564),
    [anon_sym_synchronized] = ACTIONS(564),
    [anon_sym_throw] = ACTIONS(564),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_if] = ACTIONS(564),
    [anon_sym_else] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(564),
    [anon_sym_open] = ACTIONS(564),
    [anon_sym_module] = ACTIONS(564),
    [anon_sym_static] = ACTIONS(564),
    [anon_sym_package] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(564),
    [anon_sym_enum] = ACTIONS(564),
    [anon_sym_public] = ACTIONS(564),
    [anon_sym_protected] = ACTIONS(564),
    [anon_sym_private] = ACTIONS(564),
    [anon_sym_abstract] = ACTIONS(564),
    [anon_sym_final] = ACTIONS(564),
    [anon_sym_strictfp] = ACTIONS(564),
    [anon_sym_native] = ACTIONS(564),
    [anon_sym_transient] = ACTIONS(564),
    [anon_sym_volatile] = ACTIONS(564),
    [anon_sym_ATinterface] = ACTIONS(562),
    [anon_sym_interface] = ACTIONS(564),
    [anon_sym_byte] = ACTIONS(564),
    [anon_sym_short] = ACTIONS(564),
    [anon_sym_int] = ACTIONS(564),
    [anon_sym_long] = ACTIONS(564),
    [anon_sym_char] = ACTIONS(564),
    [anon_sym_float] = ACTIONS(564),
    [anon_sym_double] = ACTIONS(564),
    [sym_boolean_type] = ACTIONS(564),
    [sym_void_type] = ACTIONS(564),
    [sym_this] = ACTIONS(564),
    [sym_super] = ACTIONS(564),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(566),
    [sym_identifier] = ACTIONS(568),
    [sym_decimal_integer_literal] = ACTIONS(568),
    [sym_hex_integer_literal] = ACTIONS(568),
    [sym_octal_integer_literal] = ACTIONS(566),
    [sym_binary_integer_literal] = ACTIONS(566),
    [sym_decimal_floating_point_literal] = ACTIONS(566),
    [sym_hex_floating_point_literal] = ACTIONS(568),
    [sym_true] = ACTIONS(568),
    [sym_false] = ACTIONS(568),
    [sym_character_literal] = ACTIONS(566),
    [sym_string_literal] = ACTIONS(566),
    [sym_null_literal] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(566),
    [anon_sym_LT] = ACTIONS(566),
    [anon_sym_PLUS] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(568),
    [anon_sym_BANG] = ACTIONS(566),
    [anon_sym_TILDE] = ACTIONS(566),
    [anon_sym_PLUS_PLUS] = ACTIONS(566),
    [anon_sym_DASH_DASH] = ACTIONS(566),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_class] = ACTIONS(568),
    [anon_sym_SEMI] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(566),
    [anon_sym_RBRACE] = ACTIONS(566),
    [anon_sym_assert] = ACTIONS(568),
    [anon_sym_switch] = ACTIONS(568),
    [anon_sym_case] = ACTIONS(568),
    [anon_sym_default] = ACTIONS(568),
    [anon_sym_do] = ACTIONS(568),
    [anon_sym_while] = ACTIONS(568),
    [anon_sym_break] = ACTIONS(568),
    [anon_sym_continue] = ACTIONS(568),
    [anon_sym_return] = ACTIONS(568),
    [anon_sym_synchronized] = ACTIONS(568),
    [anon_sym_throw] = ACTIONS(568),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_if] = ACTIONS(568),
    [anon_sym_else] = ACTIONS(568),
    [anon_sym_for] = ACTIONS(568),
    [anon_sym_AT] = ACTIONS(568),
    [anon_sym_open] = ACTIONS(568),
    [anon_sym_module] = ACTIONS(568),
    [anon_sym_static] = ACTIONS(568),
    [anon_sym_package] = ACTIONS(568),
    [anon_sym_import] = ACTIONS(568),
    [anon_sym_enum] = ACTIONS(568),
    [anon_sym_public] = ACTIONS(568),
    [anon_sym_protected] = ACTIONS(568),
    [anon_sym_private] = ACTIONS(568),
    [anon_sym_abstract] = ACTIONS(568),
    [anon_sym_final] = ACTIONS(568),
    [anon_sym_strictfp] = ACTIONS(568),
    [anon_sym_native] = ACTIONS(568),
    [anon_sym_transient] = ACTIONS(568),
    [anon_sym_volatile] = ACTIONS(568),
    [anon_sym_ATinterface] = ACTIONS(566),
    [anon_sym_interface] = ACTIONS(568),
    [anon_sym_byte] = ACTIONS(568),
    [anon_sym_short] = ACTIONS(568),
    [anon_sym_int] = ACTIONS(568),
    [anon_sym_long] = ACTIONS(568),
    [anon_sym_char] = ACTIONS(568),
    [anon_sym_float] = ACTIONS(568),
    [anon_sym_double] = ACTIONS(568),
    [sym_boolean_type] = ACTIONS(568),
    [sym_void_type] = ACTIONS(568),
    [sym_this] = ACTIONS(568),
    [sym_super] = ACTIONS(568),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [sym_identifier] = ACTIONS(572),
    [sym_decimal_integer_literal] = ACTIONS(572),
    [sym_hex_integer_literal] = ACTIONS(572),
    [sym_octal_integer_literal] = ACTIONS(570),
    [sym_binary_integer_literal] = ACTIONS(570),
    [sym_decimal_floating_point_literal] = ACTIONS(570),
    [sym_hex_floating_point_literal] = ACTIONS(572),
    [sym_true] = ACTIONS(572),
    [sym_false] = ACTIONS(572),
    [sym_character_literal] = ACTIONS(570),
    [sym_string_literal] = ACTIONS(570),
    [sym_null_literal] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(570),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(570),
    [anon_sym_TILDE] = ACTIONS(570),
    [anon_sym_PLUS_PLUS] = ACTIONS(570),
    [anon_sym_DASH_DASH] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_class] = ACTIONS(572),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_RBRACE] = ACTIONS(570),
    [anon_sym_assert] = ACTIONS(572),
    [anon_sym_switch] = ACTIONS(572),
    [anon_sym_case] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(572),
    [anon_sym_do] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_synchronized] = ACTIONS(572),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_try] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_AT] = ACTIONS(572),
    [anon_sym_open] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(572),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_package] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_enum] = ACTIONS(572),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(572),
    [anon_sym_final] = ACTIONS(572),
    [anon_sym_strictfp] = ACTIONS(572),
    [anon_sym_native] = ACTIONS(572),
    [anon_sym_transient] = ACTIONS(572),
    [anon_sym_volatile] = ACTIONS(572),
    [anon_sym_ATinterface] = ACTIONS(570),
    [anon_sym_interface] = ACTIONS(572),
    [anon_sym_byte] = ACTIONS(572),
    [anon_sym_short] = ACTIONS(572),
    [anon_sym_int] = ACTIONS(572),
    [anon_sym_long] = ACTIONS(572),
    [anon_sym_char] = ACTIONS(572),
    [anon_sym_float] = ACTIONS(572),
    [anon_sym_double] = ACTIONS(572),
    [sym_boolean_type] = ACTIONS(572),
    [sym_void_type] = ACTIONS(572),
    [sym_this] = ACTIONS(572),
    [sym_super] = ACTIONS(572),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(574),
    [sym_identifier] = ACTIONS(576),
    [sym_decimal_integer_literal] = ACTIONS(576),
    [sym_hex_integer_literal] = ACTIONS(576),
    [sym_octal_integer_literal] = ACTIONS(574),
    [sym_binary_integer_literal] = ACTIONS(574),
    [sym_decimal_floating_point_literal] = ACTIONS(574),
    [sym_hex_floating_point_literal] = ACTIONS(576),
    [sym_true] = ACTIONS(576),
    [sym_false] = ACTIONS(576),
    [sym_character_literal] = ACTIONS(574),
    [sym_string_literal] = ACTIONS(574),
    [sym_null_literal] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(574),
    [anon_sym_LT] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(576),
    [anon_sym_DASH] = ACTIONS(576),
    [anon_sym_BANG] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(574),
    [anon_sym_PLUS_PLUS] = ACTIONS(574),
    [anon_sym_DASH_DASH] = ACTIONS(574),
    [anon_sym_new] = ACTIONS(576),
    [anon_sym_class] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(574),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_RBRACE] = ACTIONS(574),
    [anon_sym_assert] = ACTIONS(576),
    [anon_sym_switch] = ACTIONS(576),
    [anon_sym_case] = ACTIONS(576),
    [anon_sym_default] = ACTIONS(576),
    [anon_sym_do] = ACTIONS(576),
    [anon_sym_while] = ACTIONS(576),
    [anon_sym_break] = ACTIONS(576),
    [anon_sym_continue] = ACTIONS(576),
    [anon_sym_return] = ACTIONS(576),
    [anon_sym_synchronized] = ACTIONS(576),
    [anon_sym_throw] = ACTIONS(576),
    [anon_sym_try] = ACTIONS(576),
    [anon_sym_if] = ACTIONS(576),
    [anon_sym_else] = ACTIONS(576),
    [anon_sym_for] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(576),
    [anon_sym_open] = ACTIONS(576),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_static] = ACTIONS(576),
    [anon_sym_package] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(576),
    [anon_sym_enum] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(576),
    [anon_sym_protected] = ACTIONS(576),
    [anon_sym_private] = ACTIONS(576),
    [anon_sym_abstract] = ACTIONS(576),
    [anon_sym_final] = ACTIONS(576),
    [anon_sym_strictfp] = ACTIONS(576),
    [anon_sym_native] = ACTIONS(576),
    [anon_sym_transient] = ACTIONS(576),
    [anon_sym_volatile] = ACTIONS(576),
    [anon_sym_ATinterface] = ACTIONS(574),
    [anon_sym_interface] = ACTIONS(576),
    [anon_sym_byte] = ACTIONS(576),
    [anon_sym_short] = ACTIONS(576),
    [anon_sym_int] = ACTIONS(576),
    [anon_sym_long] = ACTIONS(576),
    [anon_sym_char] = ACTIONS(576),
    [anon_sym_float] = ACTIONS(576),
    [anon_sym_double] = ACTIONS(576),
    [sym_boolean_type] = ACTIONS(576),
    [sym_void_type] = ACTIONS(576),
    [sym_this] = ACTIONS(576),
    [sym_super] = ACTIONS(576),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [sym_decimal_integer_literal] = ACTIONS(580),
    [sym_hex_integer_literal] = ACTIONS(580),
    [sym_octal_integer_literal] = ACTIONS(578),
    [sym_binary_integer_literal] = ACTIONS(578),
    [sym_decimal_floating_point_literal] = ACTIONS(578),
    [sym_hex_floating_point_literal] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_character_literal] = ACTIONS(578),
    [sym_string_literal] = ACTIONS(578),
    [sym_null_literal] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(578),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(578),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_assert] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_synchronized] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(580),
    [anon_sym_open] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_package] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_enum] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_abstract] = ACTIONS(580),
    [anon_sym_final] = ACTIONS(580),
    [anon_sym_strictfp] = ACTIONS(580),
    [anon_sym_native] = ACTIONS(580),
    [anon_sym_transient] = ACTIONS(580),
    [anon_sym_volatile] = ACTIONS(580),
    [anon_sym_ATinterface] = ACTIONS(578),
    [anon_sym_interface] = ACTIONS(580),
    [anon_sym_byte] = ACTIONS(580),
    [anon_sym_short] = ACTIONS(580),
    [anon_sym_int] = ACTIONS(580),
    [anon_sym_long] = ACTIONS(580),
    [anon_sym_char] = ACTIONS(580),
    [anon_sym_float] = ACTIONS(580),
    [anon_sym_double] = ACTIONS(580),
    [sym_boolean_type] = ACTIONS(580),
    [sym_void_type] = ACTIONS(580),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(582),
    [sym_identifier] = ACTIONS(584),
    [sym_decimal_integer_literal] = ACTIONS(584),
    [sym_hex_integer_literal] = ACTIONS(584),
    [sym_octal_integer_literal] = ACTIONS(582),
    [sym_binary_integer_literal] = ACTIONS(582),
    [sym_decimal_floating_point_literal] = ACTIONS(582),
    [sym_hex_floating_point_literal] = ACTIONS(584),
    [sym_true] = ACTIONS(584),
    [sym_false] = ACTIONS(584),
    [sym_character_literal] = ACTIONS(582),
    [sym_string_literal] = ACTIONS(582),
    [sym_null_literal] = ACTIONS(584),
    [anon_sym_LPAREN] = ACTIONS(582),
    [anon_sym_LT] = ACTIONS(582),
    [anon_sym_PLUS] = ACTIONS(584),
    [anon_sym_DASH] = ACTIONS(584),
    [anon_sym_BANG] = ACTIONS(582),
    [anon_sym_TILDE] = ACTIONS(582),
    [anon_sym_PLUS_PLUS] = ACTIONS(582),
    [anon_sym_DASH_DASH] = ACTIONS(582),
    [anon_sym_new] = ACTIONS(584),
    [anon_sym_class] = ACTIONS(584),
    [anon_sym_SEMI] = ACTIONS(582),
    [anon_sym_LBRACE] = ACTIONS(582),
    [anon_sym_RBRACE] = ACTIONS(582),
    [anon_sym_assert] = ACTIONS(584),
    [anon_sym_switch] = ACTIONS(584),
    [anon_sym_case] = ACTIONS(584),
    [anon_sym_default] = ACTIONS(584),
    [anon_sym_do] = ACTIONS(584),
    [anon_sym_while] = ACTIONS(584),
    [anon_sym_break] = ACTIONS(584),
    [anon_sym_continue] = ACTIONS(584),
    [anon_sym_return] = ACTIONS(584),
    [anon_sym_synchronized] = ACTIONS(584),
    [anon_sym_throw] = ACTIONS(584),
    [anon_sym_try] = ACTIONS(584),
    [anon_sym_if] = ACTIONS(584),
    [anon_sym_else] = ACTIONS(584),
    [anon_sym_for] = ACTIONS(584),
    [anon_sym_AT] = ACTIONS(584),
    [anon_sym_open] = ACTIONS(584),
    [anon_sym_module] = ACTIONS(584),
    [anon_sym_static] = ACTIONS(584),
    [anon_sym_package] = ACTIONS(584),
    [anon_sym_import] = ACTIONS(584),
    [anon_sym_enum] = ACTIONS(584),
    [anon_sym_public] = ACTIONS(584),
    [anon_sym_protected] = ACTIONS(584),
    [anon_sym_private] = ACTIONS(584),
    [anon_sym_abstract] = ACTIONS(584),
    [anon_sym_final] = ACTIONS(584),
    [anon_sym_strictfp] = ACTIONS(584),
    [anon_sym_native] = ACTIONS(584),
    [anon_sym_transient] = ACTIONS(584),
    [anon_sym_volatile] = ACTIONS(584),
    [anon_sym_ATinterface] = ACTIONS(582),
    [anon_sym_interface] = ACTIONS(584),
    [anon_sym_byte] = ACTIONS(584),
    [anon_sym_short] = ACTIONS(584),
    [anon_sym_int] = ACTIONS(584),
    [anon_sym_long] = ACTIONS(584),
    [anon_sym_char] = ACTIONS(584),
    [anon_sym_float] = ACTIONS(584),
    [anon_sym_double] = ACTIONS(584),
    [sym_boolean_type] = ACTIONS(584),
    [sym_void_type] = ACTIONS(584),
    [sym_this] = ACTIONS(584),
    [sym_super] = ACTIONS(584),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(423),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym_array_initializer] = STATE(737),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(586),
    [sym_identifier] = ACTIONS(588),
    [sym_decimal_integer_literal] = ACTIONS(588),
    [sym_hex_integer_literal] = ACTIONS(588),
    [sym_octal_integer_literal] = ACTIONS(586),
    [sym_binary_integer_literal] = ACTIONS(586),
    [sym_decimal_floating_point_literal] = ACTIONS(586),
    [sym_hex_floating_point_literal] = ACTIONS(588),
    [sym_true] = ACTIONS(588),
    [sym_false] = ACTIONS(588),
    [sym_character_literal] = ACTIONS(586),
    [sym_string_literal] = ACTIONS(586),
    [sym_null_literal] = ACTIONS(588),
    [anon_sym_LPAREN] = ACTIONS(586),
    [anon_sym_PLUS] = ACTIONS(588),
    [anon_sym_DASH] = ACTIONS(588),
    [anon_sym_BANG] = ACTIONS(586),
    [anon_sym_TILDE] = ACTIONS(586),
    [anon_sym_PLUS_PLUS] = ACTIONS(586),
    [anon_sym_DASH_DASH] = ACTIONS(586),
    [anon_sym_new] = ACTIONS(588),
    [anon_sym_class] = ACTIONS(588),
    [anon_sym_SEMI] = ACTIONS(586),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_assert] = ACTIONS(588),
    [anon_sym_switch] = ACTIONS(588),
    [anon_sym_case] = ACTIONS(588),
    [anon_sym_default] = ACTIONS(588),
    [anon_sym_do] = ACTIONS(588),
    [anon_sym_while] = ACTIONS(588),
    [anon_sym_break] = ACTIONS(588),
    [anon_sym_continue] = ACTIONS(588),
    [anon_sym_return] = ACTIONS(588),
    [anon_sym_synchronized] = ACTIONS(588),
    [anon_sym_throw] = ACTIONS(588),
    [anon_sym_try] = ACTIONS(588),
    [anon_sym_if] = ACTIONS(588),
    [anon_sym_else] = ACTIONS(588),
    [anon_sym_for] = ACTIONS(588),
    [anon_sym_AT] = ACTIONS(588),
    [anon_sym_open] = ACTIONS(588),
    [anon_sym_module] = ACTIONS(588),
    [anon_sym_static] = ACTIONS(588),
    [anon_sym_package] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(588),
    [anon_sym_enum] = ACTIONS(588),
    [anon_sym_public] = ACTIONS(588),
    [anon_sym_protected] = ACTIONS(588),
    [anon_sym_private] = ACTIONS(588),
    [anon_sym_abstract] = ACTIONS(588),
    [anon_sym_final] = ACTIONS(588),
    [anon_sym_strictfp] = ACTIONS(588),
    [anon_sym_native] = ACTIONS(588),
    [anon_sym_transient] = ACTIONS(588),
    [anon_sym_volatile] = ACTIONS(588),
    [anon_sym_ATinterface] = ACTIONS(586),
    [anon_sym_interface] = ACTIONS(588),
    [anon_sym_byte] = ACTIONS(588),
    [anon_sym_short] = ACTIONS(588),
    [anon_sym_int] = ACTIONS(588),
    [anon_sym_long] = ACTIONS(588),
    [anon_sym_char] = ACTIONS(588),
    [anon_sym_float] = ACTIONS(588),
    [anon_sym_double] = ACTIONS(588),
    [sym_boolean_type] = ACTIONS(588),
    [sym_void_type] = ACTIONS(588),
    [sym_this] = ACTIONS(588),
    [sym_super] = ACTIONS(588),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(590),
    [sym_identifier] = ACTIONS(592),
    [sym_decimal_integer_literal] = ACTIONS(592),
    [sym_hex_integer_literal] = ACTIONS(592),
    [sym_octal_integer_literal] = ACTIONS(590),
    [sym_binary_integer_literal] = ACTIONS(590),
    [sym_decimal_floating_point_literal] = ACTIONS(590),
    [sym_hex_floating_point_literal] = ACTIONS(592),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_character_literal] = ACTIONS(590),
    [sym_string_literal] = ACTIONS(590),
    [sym_null_literal] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_PLUS_PLUS] = ACTIONS(590),
    [anon_sym_DASH_DASH] = ACTIONS(590),
    [anon_sym_new] = ACTIONS(592),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_assert] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(592),
    [anon_sym_case] = ACTIONS(592),
    [anon_sym_default] = ACTIONS(592),
    [anon_sym_do] = ACTIONS(592),
    [anon_sym_while] = ACTIONS(592),
    [anon_sym_break] = ACTIONS(592),
    [anon_sym_continue] = ACTIONS(592),
    [anon_sym_return] = ACTIONS(592),
    [anon_sym_synchronized] = ACTIONS(592),
    [anon_sym_throw] = ACTIONS(592),
    [anon_sym_try] = ACTIONS(592),
    [anon_sym_if] = ACTIONS(592),
    [anon_sym_else] = ACTIONS(592),
    [anon_sym_for] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(592),
    [anon_sym_open] = ACTIONS(592),
    [anon_sym_module] = ACTIONS(592),
    [anon_sym_static] = ACTIONS(592),
    [anon_sym_package] = ACTIONS(592),
    [anon_sym_import] = ACTIONS(592),
    [anon_sym_enum] = ACTIONS(592),
    [anon_sym_public] = ACTIONS(592),
    [anon_sym_protected] = ACTIONS(592),
    [anon_sym_private] = ACTIONS(592),
    [anon_sym_abstract] = ACTIONS(592),
    [anon_sym_final] = ACTIONS(592),
    [anon_sym_strictfp] = ACTIONS(592),
    [anon_sym_native] = ACTIONS(592),
    [anon_sym_transient] = ACTIONS(592),
    [anon_sym_volatile] = ACTIONS(592),
    [anon_sym_ATinterface] = ACTIONS(590),
    [anon_sym_interface] = ACTIONS(592),
    [anon_sym_byte] = ACTIONS(592),
    [anon_sym_short] = ACTIONS(592),
    [anon_sym_int] = ACTIONS(592),
    [anon_sym_long] = ACTIONS(592),
    [anon_sym_char] = ACTIONS(592),
    [anon_sym_float] = ACTIONS(592),
    [anon_sym_double] = ACTIONS(592),
    [sym_boolean_type] = ACTIONS(592),
    [sym_void_type] = ACTIONS(592),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(592),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(419),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(594),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(442),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(596),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [sym_decimal_integer_literal] = ACTIONS(600),
    [sym_hex_integer_literal] = ACTIONS(600),
    [sym_octal_integer_literal] = ACTIONS(598),
    [sym_binary_integer_literal] = ACTIONS(598),
    [sym_decimal_floating_point_literal] = ACTIONS(598),
    [sym_hex_floating_point_literal] = ACTIONS(600),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_character_literal] = ACTIONS(598),
    [sym_string_literal] = ACTIONS(598),
    [sym_null_literal] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(598),
    [anon_sym_TILDE] = ACTIONS(598),
    [anon_sym_PLUS_PLUS] = ACTIONS(598),
    [anon_sym_DASH_DASH] = ACTIONS(598),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_class] = ACTIONS(600),
    [anon_sym_SEMI] = ACTIONS(598),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_assert] = ACTIONS(600),
    [anon_sym_switch] = ACTIONS(600),
    [anon_sym_case] = ACTIONS(600),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(600),
    [anon_sym_continue] = ACTIONS(600),
    [anon_sym_return] = ACTIONS(600),
    [anon_sym_synchronized] = ACTIONS(600),
    [anon_sym_throw] = ACTIONS(600),
    [anon_sym_try] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_else] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(600),
    [anon_sym_open] = ACTIONS(600),
    [anon_sym_module] = ACTIONS(600),
    [anon_sym_static] = ACTIONS(600),
    [anon_sym_package] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(600),
    [anon_sym_enum] = ACTIONS(600),
    [anon_sym_public] = ACTIONS(600),
    [anon_sym_protected] = ACTIONS(600),
    [anon_sym_private] = ACTIONS(600),
    [anon_sym_abstract] = ACTIONS(600),
    [anon_sym_final] = ACTIONS(600),
    [anon_sym_strictfp] = ACTIONS(600),
    [anon_sym_native] = ACTIONS(600),
    [anon_sym_transient] = ACTIONS(600),
    [anon_sym_volatile] = ACTIONS(600),
    [anon_sym_ATinterface] = ACTIONS(598),
    [anon_sym_interface] = ACTIONS(600),
    [anon_sym_byte] = ACTIONS(600),
    [anon_sym_short] = ACTIONS(600),
    [anon_sym_int] = ACTIONS(600),
    [anon_sym_long] = ACTIONS(600),
    [anon_sym_char] = ACTIONS(600),
    [anon_sym_float] = ACTIONS(600),
    [anon_sym_double] = ACTIONS(600),
    [sym_boolean_type] = ACTIONS(600),
    [sym_void_type] = ACTIONS(600),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(600),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(425),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(602),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(604),
    [sym_identifier] = ACTIONS(606),
    [sym_decimal_integer_literal] = ACTIONS(606),
    [sym_hex_integer_literal] = ACTIONS(606),
    [sym_octal_integer_literal] = ACTIONS(604),
    [sym_binary_integer_literal] = ACTIONS(604),
    [sym_decimal_floating_point_literal] = ACTIONS(604),
    [sym_hex_floating_point_literal] = ACTIONS(606),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_character_literal] = ACTIONS(604),
    [sym_string_literal] = ACTIONS(604),
    [sym_null_literal] = ACTIONS(606),
    [anon_sym_LPAREN] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(606),
    [anon_sym_DASH] = ACTIONS(606),
    [anon_sym_BANG] = ACTIONS(604),
    [anon_sym_TILDE] = ACTIONS(604),
    [anon_sym_PLUS_PLUS] = ACTIONS(604),
    [anon_sym_DASH_DASH] = ACTIONS(604),
    [anon_sym_new] = ACTIONS(606),
    [anon_sym_class] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(604),
    [anon_sym_assert] = ACTIONS(606),
    [anon_sym_switch] = ACTIONS(606),
    [anon_sym_case] = ACTIONS(606),
    [anon_sym_default] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(606),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_break] = ACTIONS(606),
    [anon_sym_continue] = ACTIONS(606),
    [anon_sym_return] = ACTIONS(606),
    [anon_sym_synchronized] = ACTIONS(606),
    [anon_sym_throw] = ACTIONS(606),
    [anon_sym_try] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(606),
    [anon_sym_else] = ACTIONS(606),
    [anon_sym_for] = ACTIONS(606),
    [anon_sym_AT] = ACTIONS(606),
    [anon_sym_open] = ACTIONS(606),
    [anon_sym_module] = ACTIONS(606),
    [anon_sym_static] = ACTIONS(606),
    [anon_sym_package] = ACTIONS(606),
    [anon_sym_import] = ACTIONS(606),
    [anon_sym_enum] = ACTIONS(606),
    [anon_sym_public] = ACTIONS(606),
    [anon_sym_protected] = ACTIONS(606),
    [anon_sym_private] = ACTIONS(606),
    [anon_sym_abstract] = ACTIONS(606),
    [anon_sym_final] = ACTIONS(606),
    [anon_sym_strictfp] = ACTIONS(606),
    [anon_sym_native] = ACTIONS(606),
    [anon_sym_transient] = ACTIONS(606),
    [anon_sym_volatile] = ACTIONS(606),
    [anon_sym_ATinterface] = ACTIONS(604),
    [anon_sym_interface] = ACTIONS(606),
    [anon_sym_byte] = ACTIONS(606),
    [anon_sym_short] = ACTIONS(606),
    [anon_sym_int] = ACTIONS(606),
    [anon_sym_long] = ACTIONS(606),
    [anon_sym_char] = ACTIONS(606),
    [anon_sym_float] = ACTIONS(606),
    [anon_sym_double] = ACTIONS(606),
    [sym_boolean_type] = ACTIONS(606),
    [sym_void_type] = ACTIONS(606),
    [sym_this] = ACTIONS(606),
    [sym_super] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(608),
    [sym_identifier] = ACTIONS(610),
    [sym_decimal_integer_literal] = ACTIONS(610),
    [sym_hex_integer_literal] = ACTIONS(610),
    [sym_octal_integer_literal] = ACTIONS(608),
    [sym_binary_integer_literal] = ACTIONS(608),
    [sym_decimal_floating_point_literal] = ACTIONS(608),
    [sym_hex_floating_point_literal] = ACTIONS(610),
    [sym_true] = ACTIONS(610),
    [sym_false] = ACTIONS(610),
    [sym_character_literal] = ACTIONS(608),
    [sym_string_literal] = ACTIONS(608),
    [sym_null_literal] = ACTIONS(610),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_DASH] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(608),
    [anon_sym_PLUS_PLUS] = ACTIONS(608),
    [anon_sym_DASH_DASH] = ACTIONS(608),
    [anon_sym_new] = ACTIONS(610),
    [anon_sym_class] = ACTIONS(610),
    [anon_sym_SEMI] = ACTIONS(608),
    [anon_sym_LBRACE] = ACTIONS(608),
    [anon_sym_RBRACE] = ACTIONS(608),
    [anon_sym_assert] = ACTIONS(610),
    [anon_sym_switch] = ACTIONS(610),
    [anon_sym_case] = ACTIONS(610),
    [anon_sym_default] = ACTIONS(610),
    [anon_sym_do] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(610),
    [anon_sym_continue] = ACTIONS(610),
    [anon_sym_return] = ACTIONS(610),
    [anon_sym_synchronized] = ACTIONS(610),
    [anon_sym_throw] = ACTIONS(610),
    [anon_sym_try] = ACTIONS(610),
    [anon_sym_if] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(610),
    [anon_sym_for] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_open] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_package] = ACTIONS(610),
    [anon_sym_import] = ACTIONS(610),
    [anon_sym_enum] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_abstract] = ACTIONS(610),
    [anon_sym_final] = ACTIONS(610),
    [anon_sym_strictfp] = ACTIONS(610),
    [anon_sym_native] = ACTIONS(610),
    [anon_sym_transient] = ACTIONS(610),
    [anon_sym_volatile] = ACTIONS(610),
    [anon_sym_ATinterface] = ACTIONS(608),
    [anon_sym_interface] = ACTIONS(610),
    [anon_sym_byte] = ACTIONS(610),
    [anon_sym_short] = ACTIONS(610),
    [anon_sym_int] = ACTIONS(610),
    [anon_sym_long] = ACTIONS(610),
    [anon_sym_char] = ACTIONS(610),
    [anon_sym_float] = ACTIONS(610),
    [anon_sym_double] = ACTIONS(610),
    [sym_boolean_type] = ACTIONS(610),
    [sym_void_type] = ACTIONS(610),
    [sym_this] = ACTIONS(610),
    [sym_super] = ACTIONS(610),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(612),
    [sym_identifier] = ACTIONS(614),
    [sym_decimal_integer_literal] = ACTIONS(614),
    [sym_hex_integer_literal] = ACTIONS(614),
    [sym_octal_integer_literal] = ACTIONS(612),
    [sym_binary_integer_literal] = ACTIONS(612),
    [sym_decimal_floating_point_literal] = ACTIONS(612),
    [sym_hex_floating_point_literal] = ACTIONS(614),
    [sym_true] = ACTIONS(614),
    [sym_false] = ACTIONS(614),
    [sym_character_literal] = ACTIONS(612),
    [sym_string_literal] = ACTIONS(612),
    [sym_null_literal] = ACTIONS(614),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(614),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(612),
    [anon_sym_DASH_DASH] = ACTIONS(612),
    [anon_sym_new] = ACTIONS(614),
    [anon_sym_class] = ACTIONS(614),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_RBRACE] = ACTIONS(612),
    [anon_sym_assert] = ACTIONS(614),
    [anon_sym_switch] = ACTIONS(614),
    [anon_sym_case] = ACTIONS(614),
    [anon_sym_default] = ACTIONS(614),
    [anon_sym_do] = ACTIONS(614),
    [anon_sym_while] = ACTIONS(614),
    [anon_sym_break] = ACTIONS(614),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_return] = ACTIONS(614),
    [anon_sym_synchronized] = ACTIONS(614),
    [anon_sym_throw] = ACTIONS(614),
    [anon_sym_try] = ACTIONS(614),
    [anon_sym_if] = ACTIONS(614),
    [anon_sym_else] = ACTIONS(614),
    [anon_sym_for] = ACTIONS(614),
    [anon_sym_AT] = ACTIONS(614),
    [anon_sym_open] = ACTIONS(614),
    [anon_sym_module] = ACTIONS(614),
    [anon_sym_static] = ACTIONS(614),
    [anon_sym_package] = ACTIONS(614),
    [anon_sym_import] = ACTIONS(614),
    [anon_sym_enum] = ACTIONS(614),
    [anon_sym_public] = ACTIONS(614),
    [anon_sym_protected] = ACTIONS(614),
    [anon_sym_private] = ACTIONS(614),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_final] = ACTIONS(614),
    [anon_sym_strictfp] = ACTIONS(614),
    [anon_sym_native] = ACTIONS(614),
    [anon_sym_transient] = ACTIONS(614),
    [anon_sym_volatile] = ACTIONS(614),
    [anon_sym_ATinterface] = ACTIONS(612),
    [anon_sym_interface] = ACTIONS(614),
    [anon_sym_byte] = ACTIONS(614),
    [anon_sym_short] = ACTIONS(614),
    [anon_sym_int] = ACTIONS(614),
    [anon_sym_long] = ACTIONS(614),
    [anon_sym_char] = ACTIONS(614),
    [anon_sym_float] = ACTIONS(614),
    [anon_sym_double] = ACTIONS(614),
    [sym_boolean_type] = ACTIONS(614),
    [sym_void_type] = ACTIONS(614),
    [sym_this] = ACTIONS(614),
    [sym_super] = ACTIONS(614),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(446),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(616),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(618),
    [sym_identifier] = ACTIONS(620),
    [sym_decimal_integer_literal] = ACTIONS(620),
    [sym_hex_integer_literal] = ACTIONS(620),
    [sym_octal_integer_literal] = ACTIONS(618),
    [sym_binary_integer_literal] = ACTIONS(618),
    [sym_decimal_floating_point_literal] = ACTIONS(618),
    [sym_hex_floating_point_literal] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_character_literal] = ACTIONS(618),
    [sym_string_literal] = ACTIONS(618),
    [sym_null_literal] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(618),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_PLUS_PLUS] = ACTIONS(618),
    [anon_sym_DASH_DASH] = ACTIONS(618),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_class] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_RBRACE] = ACTIONS(618),
    [anon_sym_assert] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_case] = ACTIONS(620),
    [anon_sym_default] = ACTIONS(620),
    [anon_sym_do] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_break] = ACTIONS(620),
    [anon_sym_continue] = ACTIONS(620),
    [anon_sym_return] = ACTIONS(620),
    [anon_sym_synchronized] = ACTIONS(620),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_try] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_open] = ACTIONS(620),
    [anon_sym_module] = ACTIONS(620),
    [anon_sym_static] = ACTIONS(620),
    [anon_sym_package] = ACTIONS(620),
    [anon_sym_import] = ACTIONS(620),
    [anon_sym_enum] = ACTIONS(620),
    [anon_sym_public] = ACTIONS(620),
    [anon_sym_protected] = ACTIONS(620),
    [anon_sym_private] = ACTIONS(620),
    [anon_sym_abstract] = ACTIONS(620),
    [anon_sym_final] = ACTIONS(620),
    [anon_sym_strictfp] = ACTIONS(620),
    [anon_sym_native] = ACTIONS(620),
    [anon_sym_transient] = ACTIONS(620),
    [anon_sym_volatile] = ACTIONS(620),
    [anon_sym_ATinterface] = ACTIONS(618),
    [anon_sym_interface] = ACTIONS(620),
    [anon_sym_byte] = ACTIONS(620),
    [anon_sym_short] = ACTIONS(620),
    [anon_sym_int] = ACTIONS(620),
    [anon_sym_long] = ACTIONS(620),
    [anon_sym_char] = ACTIONS(620),
    [anon_sym_float] = ACTIONS(620),
    [anon_sym_double] = ACTIONS(620),
    [sym_boolean_type] = ACTIONS(620),
    [sym_void_type] = ACTIONS(620),
    [sym_this] = ACTIONS(620),
    [sym_super] = ACTIONS(620),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(622),
    [sym_identifier] = ACTIONS(624),
    [sym_decimal_integer_literal] = ACTIONS(624),
    [sym_hex_integer_literal] = ACTIONS(624),
    [sym_octal_integer_literal] = ACTIONS(622),
    [sym_binary_integer_literal] = ACTIONS(622),
    [sym_decimal_floating_point_literal] = ACTIONS(622),
    [sym_hex_floating_point_literal] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_character_literal] = ACTIONS(622),
    [sym_string_literal] = ACTIONS(622),
    [sym_null_literal] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(622),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_PLUS_PLUS] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(622),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_class] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(622),
    [anon_sym_LBRACE] = ACTIONS(622),
    [anon_sym_RBRACE] = ACTIONS(622),
    [anon_sym_assert] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_case] = ACTIONS(624),
    [anon_sym_default] = ACTIONS(624),
    [anon_sym_do] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_break] = ACTIONS(624),
    [anon_sym_continue] = ACTIONS(624),
    [anon_sym_return] = ACTIONS(624),
    [anon_sym_synchronized] = ACTIONS(624),
    [anon_sym_throw] = ACTIONS(624),
    [anon_sym_try] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_open] = ACTIONS(624),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_static] = ACTIONS(624),
    [anon_sym_package] = ACTIONS(624),
    [anon_sym_import] = ACTIONS(624),
    [anon_sym_enum] = ACTIONS(624),
    [anon_sym_public] = ACTIONS(624),
    [anon_sym_protected] = ACTIONS(624),
    [anon_sym_private] = ACTIONS(624),
    [anon_sym_abstract] = ACTIONS(624),
    [anon_sym_final] = ACTIONS(624),
    [anon_sym_strictfp] = ACTIONS(624),
    [anon_sym_native] = ACTIONS(624),
    [anon_sym_transient] = ACTIONS(624),
    [anon_sym_volatile] = ACTIONS(624),
    [anon_sym_ATinterface] = ACTIONS(622),
    [anon_sym_interface] = ACTIONS(624),
    [anon_sym_byte] = ACTIONS(624),
    [anon_sym_short] = ACTIONS(624),
    [anon_sym_int] = ACTIONS(624),
    [anon_sym_long] = ACTIONS(624),
    [anon_sym_char] = ACTIONS(624),
    [anon_sym_float] = ACTIONS(624),
    [anon_sym_double] = ACTIONS(624),
    [sym_boolean_type] = ACTIONS(624),
    [sym_void_type] = ACTIONS(624),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(624),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(626),
    [sym_identifier] = ACTIONS(628),
    [sym_decimal_integer_literal] = ACTIONS(628),
    [sym_hex_integer_literal] = ACTIONS(628),
    [sym_octal_integer_literal] = ACTIONS(626),
    [sym_binary_integer_literal] = ACTIONS(626),
    [sym_decimal_floating_point_literal] = ACTIONS(626),
    [sym_hex_floating_point_literal] = ACTIONS(628),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_character_literal] = ACTIONS(626),
    [sym_string_literal] = ACTIONS(626),
    [sym_null_literal] = ACTIONS(628),
    [anon_sym_LPAREN] = ACTIONS(626),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(626),
    [anon_sym_TILDE] = ACTIONS(626),
    [anon_sym_PLUS_PLUS] = ACTIONS(626),
    [anon_sym_DASH_DASH] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(628),
    [anon_sym_class] = ACTIONS(628),
    [anon_sym_SEMI] = ACTIONS(626),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_RBRACE] = ACTIONS(626),
    [anon_sym_assert] = ACTIONS(628),
    [anon_sym_switch] = ACTIONS(628),
    [anon_sym_case] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(628),
    [anon_sym_do] = ACTIONS(628),
    [anon_sym_while] = ACTIONS(628),
    [anon_sym_break] = ACTIONS(628),
    [anon_sym_continue] = ACTIONS(628),
    [anon_sym_return] = ACTIONS(628),
    [anon_sym_synchronized] = ACTIONS(628),
    [anon_sym_throw] = ACTIONS(628),
    [anon_sym_try] = ACTIONS(628),
    [anon_sym_if] = ACTIONS(628),
    [anon_sym_else] = ACTIONS(628),
    [anon_sym_for] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_open] = ACTIONS(628),
    [anon_sym_module] = ACTIONS(628),
    [anon_sym_static] = ACTIONS(628),
    [anon_sym_package] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(628),
    [anon_sym_enum] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(628),
    [anon_sym_protected] = ACTIONS(628),
    [anon_sym_private] = ACTIONS(628),
    [anon_sym_abstract] = ACTIONS(628),
    [anon_sym_final] = ACTIONS(628),
    [anon_sym_strictfp] = ACTIONS(628),
    [anon_sym_native] = ACTIONS(628),
    [anon_sym_transient] = ACTIONS(628),
    [anon_sym_volatile] = ACTIONS(628),
    [anon_sym_ATinterface] = ACTIONS(626),
    [anon_sym_interface] = ACTIONS(628),
    [anon_sym_byte] = ACTIONS(628),
    [anon_sym_short] = ACTIONS(628),
    [anon_sym_int] = ACTIONS(628),
    [anon_sym_long] = ACTIONS(628),
    [anon_sym_char] = ACTIONS(628),
    [anon_sym_float] = ACTIONS(628),
    [anon_sym_double] = ACTIONS(628),
    [sym_boolean_type] = ACTIONS(628),
    [sym_void_type] = ACTIONS(628),
    [sym_this] = ACTIONS(628),
    [sym_super] = ACTIONS(628),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [ts_builtin_sym_end] = ACTIONS(630),
    [sym_identifier] = ACTIONS(632),
    [sym_decimal_integer_literal] = ACTIONS(632),
    [sym_hex_integer_literal] = ACTIONS(632),
    [sym_octal_integer_literal] = ACTIONS(630),
    [sym_binary_integer_literal] = ACTIONS(630),
    [sym_decimal_floating_point_literal] = ACTIONS(630),
    [sym_hex_floating_point_literal] = ACTIONS(632),
    [sym_true] = ACTIONS(632),
    [sym_false] = ACTIONS(632),
    [sym_character_literal] = ACTIONS(630),
    [sym_string_literal] = ACTIONS(630),
    [sym_null_literal] = ACTIONS(632),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_DASH] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(630),
    [anon_sym_PLUS_PLUS] = ACTIONS(630),
    [anon_sym_DASH_DASH] = ACTIONS(630),
    [anon_sym_new] = ACTIONS(632),
    [anon_sym_class] = ACTIONS(632),
    [anon_sym_SEMI] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_RBRACE] = ACTIONS(630),
    [anon_sym_assert] = ACTIONS(632),
    [anon_sym_switch] = ACTIONS(632),
    [anon_sym_case] = ACTIONS(632),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_do] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(632),
    [anon_sym_break] = ACTIONS(632),
    [anon_sym_continue] = ACTIONS(632),
    [anon_sym_return] = ACTIONS(632),
    [anon_sym_synchronized] = ACTIONS(632),
    [anon_sym_throw] = ACTIONS(632),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(632),
    [anon_sym_AT] = ACTIONS(632),
    [anon_sym_open] = ACTIONS(632),
    [anon_sym_module] = ACTIONS(632),
    [anon_sym_static] = ACTIONS(632),
    [anon_sym_package] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(632),
    [anon_sym_enum] = ACTIONS(632),
    [anon_sym_public] = ACTIONS(632),
    [anon_sym_protected] = ACTIONS(632),
    [anon_sym_private] = ACTIONS(632),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_final] = ACTIONS(632),
    [anon_sym_strictfp] = ACTIONS(632),
    [anon_sym_native] = ACTIONS(632),
    [anon_sym_transient] = ACTIONS(632),
    [anon_sym_volatile] = ACTIONS(632),
    [anon_sym_ATinterface] = ACTIONS(630),
    [anon_sym_interface] = ACTIONS(632),
    [anon_sym_byte] = ACTIONS(632),
    [anon_sym_short] = ACTIONS(632),
    [anon_sym_int] = ACTIONS(632),
    [anon_sym_long] = ACTIONS(632),
    [anon_sym_char] = ACTIONS(632),
    [anon_sym_float] = ACTIONS(632),
    [anon_sym_double] = ACTIONS(632),
    [sym_boolean_type] = ACTIONS(632),
    [sym_void_type] = ACTIONS(632),
    [sym_this] = ACTIONS(632),
    [sym_super] = ACTIONS(632),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(634),
    [sym_identifier] = ACTIONS(636),
    [sym_decimal_integer_literal] = ACTIONS(636),
    [sym_hex_integer_literal] = ACTIONS(636),
    [sym_octal_integer_literal] = ACTIONS(634),
    [sym_binary_integer_literal] = ACTIONS(634),
    [sym_decimal_floating_point_literal] = ACTIONS(634),
    [sym_hex_floating_point_literal] = ACTIONS(636),
    [sym_true] = ACTIONS(636),
    [sym_false] = ACTIONS(636),
    [sym_character_literal] = ACTIONS(634),
    [sym_string_literal] = ACTIONS(634),
    [sym_null_literal] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_new] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(636),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(634),
    [anon_sym_assert] = ACTIONS(636),
    [anon_sym_switch] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_default] = ACTIONS(636),
    [anon_sym_do] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_break] = ACTIONS(636),
    [anon_sym_continue] = ACTIONS(636),
    [anon_sym_return] = ACTIONS(636),
    [anon_sym_synchronized] = ACTIONS(636),
    [anon_sym_throw] = ACTIONS(636),
    [anon_sym_try] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_else] = ACTIONS(636),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_open] = ACTIONS(636),
    [anon_sym_module] = ACTIONS(636),
    [anon_sym_static] = ACTIONS(636),
    [anon_sym_package] = ACTIONS(636),
    [anon_sym_import] = ACTIONS(636),
    [anon_sym_enum] = ACTIONS(636),
    [anon_sym_public] = ACTIONS(636),
    [anon_sym_protected] = ACTIONS(636),
    [anon_sym_private] = ACTIONS(636),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_final] = ACTIONS(636),
    [anon_sym_strictfp] = ACTIONS(636),
    [anon_sym_native] = ACTIONS(636),
    [anon_sym_transient] = ACTIONS(636),
    [anon_sym_volatile] = ACTIONS(636),
    [anon_sym_ATinterface] = ACTIONS(634),
    [anon_sym_interface] = ACTIONS(636),
    [anon_sym_byte] = ACTIONS(636),
    [anon_sym_short] = ACTIONS(636),
    [anon_sym_int] = ACTIONS(636),
    [anon_sym_long] = ACTIONS(636),
    [anon_sym_char] = ACTIONS(636),
    [anon_sym_float] = ACTIONS(636),
    [anon_sym_double] = ACTIONS(636),
    [sym_boolean_type] = ACTIONS(636),
    [sym_void_type] = ACTIONS(636),
    [sym_this] = ACTIONS(636),
    [sym_super] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(389),
    [sym_identifier] = ACTIONS(391),
    [sym_decimal_integer_literal] = ACTIONS(391),
    [sym_hex_integer_literal] = ACTIONS(391),
    [sym_octal_integer_literal] = ACTIONS(389),
    [sym_binary_integer_literal] = ACTIONS(389),
    [sym_decimal_floating_point_literal] = ACTIONS(389),
    [sym_hex_floating_point_literal] = ACTIONS(391),
    [sym_true] = ACTIONS(391),
    [sym_false] = ACTIONS(391),
    [sym_character_literal] = ACTIONS(389),
    [sym_string_literal] = ACTIONS(389),
    [sym_null_literal] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(391),
    [anon_sym_DASH] = ACTIONS(391),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_TILDE] = ACTIONS(389),
    [anon_sym_PLUS_PLUS] = ACTIONS(389),
    [anon_sym_DASH_DASH] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(391),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_RBRACE] = ACTIONS(389),
    [anon_sym_assert] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(391),
    [anon_sym_case] = ACTIONS(391),
    [anon_sym_default] = ACTIONS(391),
    [anon_sym_do] = ACTIONS(391),
    [anon_sym_while] = ACTIONS(391),
    [anon_sym_break] = ACTIONS(391),
    [anon_sym_continue] = ACTIONS(391),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_synchronized] = ACTIONS(391),
    [anon_sym_throw] = ACTIONS(391),
    [anon_sym_try] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_else] = ACTIONS(391),
    [anon_sym_for] = ACTIONS(391),
    [anon_sym_AT] = ACTIONS(391),
    [anon_sym_open] = ACTIONS(391),
    [anon_sym_module] = ACTIONS(391),
    [anon_sym_static] = ACTIONS(391),
    [anon_sym_package] = ACTIONS(391),
    [anon_sym_import] = ACTIONS(391),
    [anon_sym_enum] = ACTIONS(391),
    [anon_sym_public] = ACTIONS(391),
    [anon_sym_protected] = ACTIONS(391),
    [anon_sym_private] = ACTIONS(391),
    [anon_sym_abstract] = ACTIONS(391),
    [anon_sym_final] = ACTIONS(391),
    [anon_sym_strictfp] = ACTIONS(391),
    [anon_sym_native] = ACTIONS(391),
    [anon_sym_transient] = ACTIONS(391),
    [anon_sym_volatile] = ACTIONS(391),
    [anon_sym_ATinterface] = ACTIONS(389),
    [anon_sym_interface] = ACTIONS(391),
    [anon_sym_byte] = ACTIONS(391),
    [anon_sym_short] = ACTIONS(391),
    [anon_sym_int] = ACTIONS(391),
    [anon_sym_long] = ACTIONS(391),
    [anon_sym_char] = ACTIONS(391),
    [anon_sym_float] = ACTIONS(391),
    [anon_sym_double] = ACTIONS(391),
    [sym_boolean_type] = ACTIONS(391),
    [sym_void_type] = ACTIONS(391),
    [sym_this] = ACTIONS(391),
    [sym_super] = ACTIONS(391),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(638),
    [sym_identifier] = ACTIONS(640),
    [sym_decimal_integer_literal] = ACTIONS(640),
    [sym_hex_integer_literal] = ACTIONS(640),
    [sym_octal_integer_literal] = ACTIONS(638),
    [sym_binary_integer_literal] = ACTIONS(638),
    [sym_decimal_floating_point_literal] = ACTIONS(638),
    [sym_hex_floating_point_literal] = ACTIONS(640),
    [sym_true] = ACTIONS(640),
    [sym_false] = ACTIONS(640),
    [sym_character_literal] = ACTIONS(638),
    [sym_string_literal] = ACTIONS(638),
    [sym_null_literal] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(638),
    [anon_sym_PLUS] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(638),
    [anon_sym_TILDE] = ACTIONS(638),
    [anon_sym_PLUS_PLUS] = ACTIONS(638),
    [anon_sym_DASH_DASH] = ACTIONS(638),
    [anon_sym_new] = ACTIONS(640),
    [anon_sym_class] = ACTIONS(640),
    [anon_sym_SEMI] = ACTIONS(638),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_assert] = ACTIONS(640),
    [anon_sym_switch] = ACTIONS(640),
    [anon_sym_case] = ACTIONS(640),
    [anon_sym_default] = ACTIONS(640),
    [anon_sym_do] = ACTIONS(640),
    [anon_sym_while] = ACTIONS(640),
    [anon_sym_break] = ACTIONS(640),
    [anon_sym_continue] = ACTIONS(640),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_synchronized] = ACTIONS(640),
    [anon_sym_throw] = ACTIONS(640),
    [anon_sym_try] = ACTIONS(640),
    [anon_sym_if] = ACTIONS(640),
    [anon_sym_else] = ACTIONS(640),
    [anon_sym_for] = ACTIONS(640),
    [anon_sym_AT] = ACTIONS(640),
    [anon_sym_open] = ACTIONS(640),
    [anon_sym_module] = ACTIONS(640),
    [anon_sym_static] = ACTIONS(640),
    [anon_sym_package] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(640),
    [anon_sym_enum] = ACTIONS(640),
    [anon_sym_public] = ACTIONS(640),
    [anon_sym_protected] = ACTIONS(640),
    [anon_sym_private] = ACTIONS(640),
    [anon_sym_abstract] = ACTIONS(640),
    [anon_sym_final] = ACTIONS(640),
    [anon_sym_strictfp] = ACTIONS(640),
    [anon_sym_native] = ACTIONS(640),
    [anon_sym_transient] = ACTIONS(640),
    [anon_sym_volatile] = ACTIONS(640),
    [anon_sym_ATinterface] = ACTIONS(638),
    [anon_sym_interface] = ACTIONS(640),
    [anon_sym_byte] = ACTIONS(640),
    [anon_sym_short] = ACTIONS(640),
    [anon_sym_int] = ACTIONS(640),
    [anon_sym_long] = ACTIONS(640),
    [anon_sym_char] = ACTIONS(640),
    [anon_sym_float] = ACTIONS(640),
    [anon_sym_double] = ACTIONS(640),
    [sym_boolean_type] = ACTIONS(640),
    [sym_void_type] = ACTIONS(640),
    [sym_this] = ACTIONS(640),
    [sym_super] = ACTIONS(640),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(441),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(644),
    [sym_identifier] = ACTIONS(646),
    [sym_decimal_integer_literal] = ACTIONS(646),
    [sym_hex_integer_literal] = ACTIONS(646),
    [sym_octal_integer_literal] = ACTIONS(644),
    [sym_binary_integer_literal] = ACTIONS(644),
    [sym_decimal_floating_point_literal] = ACTIONS(644),
    [sym_hex_floating_point_literal] = ACTIONS(646),
    [sym_true] = ACTIONS(646),
    [sym_false] = ACTIONS(646),
    [sym_character_literal] = ACTIONS(644),
    [sym_string_literal] = ACTIONS(644),
    [sym_null_literal] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(646),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_TILDE] = ACTIONS(644),
    [anon_sym_PLUS_PLUS] = ACTIONS(644),
    [anon_sym_DASH_DASH] = ACTIONS(644),
    [anon_sym_new] = ACTIONS(646),
    [anon_sym_class] = ACTIONS(646),
    [anon_sym_SEMI] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(644),
    [anon_sym_RBRACE] = ACTIONS(644),
    [anon_sym_assert] = ACTIONS(646),
    [anon_sym_switch] = ACTIONS(646),
    [anon_sym_case] = ACTIONS(646),
    [anon_sym_default] = ACTIONS(646),
    [anon_sym_do] = ACTIONS(646),
    [anon_sym_while] = ACTIONS(646),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(646),
    [anon_sym_return] = ACTIONS(646),
    [anon_sym_synchronized] = ACTIONS(646),
    [anon_sym_throw] = ACTIONS(646),
    [anon_sym_try] = ACTIONS(646),
    [anon_sym_if] = ACTIONS(646),
    [anon_sym_else] = ACTIONS(646),
    [anon_sym_for] = ACTIONS(646),
    [anon_sym_AT] = ACTIONS(646),
    [anon_sym_open] = ACTIONS(646),
    [anon_sym_module] = ACTIONS(646),
    [anon_sym_static] = ACTIONS(646),
    [anon_sym_package] = ACTIONS(646),
    [anon_sym_import] = ACTIONS(646),
    [anon_sym_enum] = ACTIONS(646),
    [anon_sym_public] = ACTIONS(646),
    [anon_sym_protected] = ACTIONS(646),
    [anon_sym_private] = ACTIONS(646),
    [anon_sym_abstract] = ACTIONS(646),
    [anon_sym_final] = ACTIONS(646),
    [anon_sym_strictfp] = ACTIONS(646),
    [anon_sym_native] = ACTIONS(646),
    [anon_sym_transient] = ACTIONS(646),
    [anon_sym_volatile] = ACTIONS(646),
    [anon_sym_ATinterface] = ACTIONS(644),
    [anon_sym_interface] = ACTIONS(646),
    [anon_sym_byte] = ACTIONS(646),
    [anon_sym_short] = ACTIONS(646),
    [anon_sym_int] = ACTIONS(646),
    [anon_sym_long] = ACTIONS(646),
    [anon_sym_char] = ACTIONS(646),
    [anon_sym_float] = ACTIONS(646),
    [anon_sym_double] = ACTIONS(646),
    [sym_boolean_type] = ACTIONS(646),
    [sym_void_type] = ACTIONS(646),
    [sym_this] = ACTIONS(646),
    [sym_super] = ACTIONS(646),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(648),
    [sym_identifier] = ACTIONS(650),
    [sym_decimal_integer_literal] = ACTIONS(650),
    [sym_hex_integer_literal] = ACTIONS(650),
    [sym_octal_integer_literal] = ACTIONS(648),
    [sym_binary_integer_literal] = ACTIONS(648),
    [sym_decimal_floating_point_literal] = ACTIONS(648),
    [sym_hex_floating_point_literal] = ACTIONS(650),
    [sym_true] = ACTIONS(650),
    [sym_false] = ACTIONS(650),
    [sym_character_literal] = ACTIONS(648),
    [sym_string_literal] = ACTIONS(648),
    [sym_null_literal] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(648),
    [anon_sym_TILDE] = ACTIONS(648),
    [anon_sym_PLUS_PLUS] = ACTIONS(648),
    [anon_sym_DASH_DASH] = ACTIONS(648),
    [anon_sym_new] = ACTIONS(650),
    [anon_sym_class] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(648),
    [anon_sym_RBRACE] = ACTIONS(648),
    [anon_sym_assert] = ACTIONS(650),
    [anon_sym_switch] = ACTIONS(650),
    [anon_sym_case] = ACTIONS(650),
    [anon_sym_default] = ACTIONS(650),
    [anon_sym_do] = ACTIONS(650),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_break] = ACTIONS(650),
    [anon_sym_continue] = ACTIONS(650),
    [anon_sym_return] = ACTIONS(650),
    [anon_sym_synchronized] = ACTIONS(650),
    [anon_sym_throw] = ACTIONS(650),
    [anon_sym_try] = ACTIONS(650),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_else] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_open] = ACTIONS(650),
    [anon_sym_module] = ACTIONS(650),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_package] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(650),
    [anon_sym_enum] = ACTIONS(650),
    [anon_sym_public] = ACTIONS(650),
    [anon_sym_protected] = ACTIONS(650),
    [anon_sym_private] = ACTIONS(650),
    [anon_sym_abstract] = ACTIONS(650),
    [anon_sym_final] = ACTIONS(650),
    [anon_sym_strictfp] = ACTIONS(650),
    [anon_sym_native] = ACTIONS(650),
    [anon_sym_transient] = ACTIONS(650),
    [anon_sym_volatile] = ACTIONS(650),
    [anon_sym_ATinterface] = ACTIONS(648),
    [anon_sym_interface] = ACTIONS(650),
    [anon_sym_byte] = ACTIONS(650),
    [anon_sym_short] = ACTIONS(650),
    [anon_sym_int] = ACTIONS(650),
    [anon_sym_long] = ACTIONS(650),
    [anon_sym_char] = ACTIONS(650),
    [anon_sym_float] = ACTIONS(650),
    [anon_sym_double] = ACTIONS(650),
    [sym_boolean_type] = ACTIONS(650),
    [sym_void_type] = ACTIONS(650),
    [sym_this] = ACTIONS(650),
    [sym_super] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(652),
    [sym_identifier] = ACTIONS(654),
    [sym_decimal_integer_literal] = ACTIONS(654),
    [sym_hex_integer_literal] = ACTIONS(654),
    [sym_octal_integer_literal] = ACTIONS(652),
    [sym_binary_integer_literal] = ACTIONS(652),
    [sym_decimal_floating_point_literal] = ACTIONS(652),
    [sym_hex_floating_point_literal] = ACTIONS(654),
    [sym_true] = ACTIONS(654),
    [sym_false] = ACTIONS(654),
    [sym_character_literal] = ACTIONS(652),
    [sym_string_literal] = ACTIONS(652),
    [sym_null_literal] = ACTIONS(654),
    [anon_sym_LPAREN] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(654),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(652),
    [anon_sym_new] = ACTIONS(654),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_SEMI] = ACTIONS(652),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_RBRACE] = ACTIONS(652),
    [anon_sym_assert] = ACTIONS(654),
    [anon_sym_switch] = ACTIONS(654),
    [anon_sym_case] = ACTIONS(654),
    [anon_sym_default] = ACTIONS(654),
    [anon_sym_do] = ACTIONS(654),
    [anon_sym_while] = ACTIONS(654),
    [anon_sym_break] = ACTIONS(654),
    [anon_sym_continue] = ACTIONS(654),
    [anon_sym_return] = ACTIONS(654),
    [anon_sym_synchronized] = ACTIONS(654),
    [anon_sym_throw] = ACTIONS(654),
    [anon_sym_try] = ACTIONS(654),
    [anon_sym_if] = ACTIONS(654),
    [anon_sym_else] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(654),
    [anon_sym_open] = ACTIONS(654),
    [anon_sym_module] = ACTIONS(654),
    [anon_sym_static] = ACTIONS(654),
    [anon_sym_package] = ACTIONS(654),
    [anon_sym_import] = ACTIONS(654),
    [anon_sym_enum] = ACTIONS(654),
    [anon_sym_public] = ACTIONS(654),
    [anon_sym_protected] = ACTIONS(654),
    [anon_sym_private] = ACTIONS(654),
    [anon_sym_abstract] = ACTIONS(654),
    [anon_sym_final] = ACTIONS(654),
    [anon_sym_strictfp] = ACTIONS(654),
    [anon_sym_native] = ACTIONS(654),
    [anon_sym_transient] = ACTIONS(654),
    [anon_sym_volatile] = ACTIONS(654),
    [anon_sym_ATinterface] = ACTIONS(652),
    [anon_sym_interface] = ACTIONS(654),
    [anon_sym_byte] = ACTIONS(654),
    [anon_sym_short] = ACTIONS(654),
    [anon_sym_int] = ACTIONS(654),
    [anon_sym_long] = ACTIONS(654),
    [anon_sym_char] = ACTIONS(654),
    [anon_sym_float] = ACTIONS(654),
    [anon_sym_double] = ACTIONS(654),
    [sym_boolean_type] = ACTIONS(654),
    [sym_void_type] = ACTIONS(654),
    [sym_this] = ACTIONS(654),
    [sym_super] = ACTIONS(654),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(422),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(658),
    [sym_identifier] = ACTIONS(660),
    [sym_decimal_integer_literal] = ACTIONS(660),
    [sym_hex_integer_literal] = ACTIONS(660),
    [sym_octal_integer_literal] = ACTIONS(658),
    [sym_binary_integer_literal] = ACTIONS(658),
    [sym_decimal_floating_point_literal] = ACTIONS(658),
    [sym_hex_floating_point_literal] = ACTIONS(660),
    [sym_true] = ACTIONS(660),
    [sym_false] = ACTIONS(660),
    [sym_character_literal] = ACTIONS(658),
    [sym_string_literal] = ACTIONS(658),
    [sym_null_literal] = ACTIONS(660),
    [anon_sym_LPAREN] = ACTIONS(658),
    [anon_sym_PLUS] = ACTIONS(660),
    [anon_sym_DASH] = ACTIONS(660),
    [anon_sym_BANG] = ACTIONS(658),
    [anon_sym_TILDE] = ACTIONS(658),
    [anon_sym_PLUS_PLUS] = ACTIONS(658),
    [anon_sym_DASH_DASH] = ACTIONS(658),
    [anon_sym_new] = ACTIONS(660),
    [anon_sym_class] = ACTIONS(660),
    [anon_sym_SEMI] = ACTIONS(658),
    [anon_sym_LBRACE] = ACTIONS(658),
    [anon_sym_RBRACE] = ACTIONS(658),
    [anon_sym_assert] = ACTIONS(660),
    [anon_sym_switch] = ACTIONS(660),
    [anon_sym_case] = ACTIONS(660),
    [anon_sym_default] = ACTIONS(660),
    [anon_sym_do] = ACTIONS(660),
    [anon_sym_while] = ACTIONS(660),
    [anon_sym_break] = ACTIONS(660),
    [anon_sym_continue] = ACTIONS(660),
    [anon_sym_return] = ACTIONS(660),
    [anon_sym_synchronized] = ACTIONS(660),
    [anon_sym_throw] = ACTIONS(660),
    [anon_sym_try] = ACTIONS(660),
    [anon_sym_if] = ACTIONS(660),
    [anon_sym_else] = ACTIONS(660),
    [anon_sym_for] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(660),
    [anon_sym_open] = ACTIONS(660),
    [anon_sym_module] = ACTIONS(660),
    [anon_sym_static] = ACTIONS(660),
    [anon_sym_package] = ACTIONS(660),
    [anon_sym_import] = ACTIONS(660),
    [anon_sym_enum] = ACTIONS(660),
    [anon_sym_public] = ACTIONS(660),
    [anon_sym_protected] = ACTIONS(660),
    [anon_sym_private] = ACTIONS(660),
    [anon_sym_abstract] = ACTIONS(660),
    [anon_sym_final] = ACTIONS(660),
    [anon_sym_strictfp] = ACTIONS(660),
    [anon_sym_native] = ACTIONS(660),
    [anon_sym_transient] = ACTIONS(660),
    [anon_sym_volatile] = ACTIONS(660),
    [anon_sym_ATinterface] = ACTIONS(658),
    [anon_sym_interface] = ACTIONS(660),
    [anon_sym_byte] = ACTIONS(660),
    [anon_sym_short] = ACTIONS(660),
    [anon_sym_int] = ACTIONS(660),
    [anon_sym_long] = ACTIONS(660),
    [anon_sym_char] = ACTIONS(660),
    [anon_sym_float] = ACTIONS(660),
    [anon_sym_double] = ACTIONS(660),
    [sym_boolean_type] = ACTIONS(660),
    [sym_void_type] = ACTIONS(660),
    [sym_this] = ACTIONS(660),
    [sym_super] = ACTIONS(660),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(464),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(662),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(664),
    [sym_identifier] = ACTIONS(666),
    [sym_decimal_integer_literal] = ACTIONS(666),
    [sym_hex_integer_literal] = ACTIONS(666),
    [sym_octal_integer_literal] = ACTIONS(664),
    [sym_binary_integer_literal] = ACTIONS(664),
    [sym_decimal_floating_point_literal] = ACTIONS(664),
    [sym_hex_floating_point_literal] = ACTIONS(666),
    [sym_true] = ACTIONS(666),
    [sym_false] = ACTIONS(666),
    [sym_character_literal] = ACTIONS(664),
    [sym_string_literal] = ACTIONS(664),
    [sym_null_literal] = ACTIONS(666),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(666),
    [anon_sym_DASH] = ACTIONS(666),
    [anon_sym_BANG] = ACTIONS(664),
    [anon_sym_TILDE] = ACTIONS(664),
    [anon_sym_PLUS_PLUS] = ACTIONS(664),
    [anon_sym_DASH_DASH] = ACTIONS(664),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(666),
    [anon_sym_SEMI] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_assert] = ACTIONS(666),
    [anon_sym_switch] = ACTIONS(666),
    [anon_sym_case] = ACTIONS(666),
    [anon_sym_default] = ACTIONS(666),
    [anon_sym_do] = ACTIONS(666),
    [anon_sym_while] = ACTIONS(666),
    [anon_sym_break] = ACTIONS(666),
    [anon_sym_continue] = ACTIONS(666),
    [anon_sym_return] = ACTIONS(666),
    [anon_sym_synchronized] = ACTIONS(666),
    [anon_sym_throw] = ACTIONS(666),
    [anon_sym_try] = ACTIONS(666),
    [anon_sym_if] = ACTIONS(666),
    [anon_sym_else] = ACTIONS(666),
    [anon_sym_for] = ACTIONS(666),
    [anon_sym_AT] = ACTIONS(666),
    [anon_sym_open] = ACTIONS(666),
    [anon_sym_module] = ACTIONS(666),
    [anon_sym_static] = ACTIONS(666),
    [anon_sym_package] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(666),
    [anon_sym_enum] = ACTIONS(666),
    [anon_sym_public] = ACTIONS(666),
    [anon_sym_protected] = ACTIONS(666),
    [anon_sym_private] = ACTIONS(666),
    [anon_sym_abstract] = ACTIONS(666),
    [anon_sym_final] = ACTIONS(666),
    [anon_sym_strictfp] = ACTIONS(666),
    [anon_sym_native] = ACTIONS(666),
    [anon_sym_transient] = ACTIONS(666),
    [anon_sym_volatile] = ACTIONS(666),
    [anon_sym_ATinterface] = ACTIONS(664),
    [anon_sym_interface] = ACTIONS(666),
    [anon_sym_byte] = ACTIONS(666),
    [anon_sym_short] = ACTIONS(666),
    [anon_sym_int] = ACTIONS(666),
    [anon_sym_long] = ACTIONS(666),
    [anon_sym_char] = ACTIONS(666),
    [anon_sym_float] = ACTIONS(666),
    [anon_sym_double] = ACTIONS(666),
    [sym_boolean_type] = ACTIONS(666),
    [sym_void_type] = ACTIONS(666),
    [sym_this] = ACTIONS(666),
    [sym_super] = ACTIONS(666),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(429),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(424),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(670),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(428),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(674),
    [sym_identifier] = ACTIONS(676),
    [sym_decimal_integer_literal] = ACTIONS(676),
    [sym_hex_integer_literal] = ACTIONS(676),
    [sym_octal_integer_literal] = ACTIONS(674),
    [sym_binary_integer_literal] = ACTIONS(674),
    [sym_decimal_floating_point_literal] = ACTIONS(674),
    [sym_hex_floating_point_literal] = ACTIONS(676),
    [sym_true] = ACTIONS(676),
    [sym_false] = ACTIONS(676),
    [sym_character_literal] = ACTIONS(674),
    [sym_string_literal] = ACTIONS(674),
    [sym_null_literal] = ACTIONS(676),
    [anon_sym_LPAREN] = ACTIONS(674),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_BANG] = ACTIONS(674),
    [anon_sym_TILDE] = ACTIONS(674),
    [anon_sym_PLUS_PLUS] = ACTIONS(674),
    [anon_sym_DASH_DASH] = ACTIONS(674),
    [anon_sym_new] = ACTIONS(676),
    [anon_sym_class] = ACTIONS(676),
    [anon_sym_SEMI] = ACTIONS(674),
    [anon_sym_LBRACE] = ACTIONS(674),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_assert] = ACTIONS(676),
    [anon_sym_switch] = ACTIONS(676),
    [anon_sym_case] = ACTIONS(676),
    [anon_sym_default] = ACTIONS(676),
    [anon_sym_do] = ACTIONS(676),
    [anon_sym_while] = ACTIONS(676),
    [anon_sym_break] = ACTIONS(676),
    [anon_sym_continue] = ACTIONS(676),
    [anon_sym_return] = ACTIONS(676),
    [anon_sym_synchronized] = ACTIONS(676),
    [anon_sym_throw] = ACTIONS(676),
    [anon_sym_try] = ACTIONS(676),
    [anon_sym_if] = ACTIONS(676),
    [anon_sym_else] = ACTIONS(676),
    [anon_sym_for] = ACTIONS(676),
    [anon_sym_AT] = ACTIONS(676),
    [anon_sym_open] = ACTIONS(676),
    [anon_sym_module] = ACTIONS(676),
    [anon_sym_static] = ACTIONS(676),
    [anon_sym_package] = ACTIONS(676),
    [anon_sym_import] = ACTIONS(676),
    [anon_sym_enum] = ACTIONS(676),
    [anon_sym_public] = ACTIONS(676),
    [anon_sym_protected] = ACTIONS(676),
    [anon_sym_private] = ACTIONS(676),
    [anon_sym_abstract] = ACTIONS(676),
    [anon_sym_final] = ACTIONS(676),
    [anon_sym_strictfp] = ACTIONS(676),
    [anon_sym_native] = ACTIONS(676),
    [anon_sym_transient] = ACTIONS(676),
    [anon_sym_volatile] = ACTIONS(676),
    [anon_sym_ATinterface] = ACTIONS(674),
    [anon_sym_interface] = ACTIONS(676),
    [anon_sym_byte] = ACTIONS(676),
    [anon_sym_short] = ACTIONS(676),
    [anon_sym_int] = ACTIONS(676),
    [anon_sym_long] = ACTIONS(676),
    [anon_sym_char] = ACTIONS(676),
    [anon_sym_float] = ACTIONS(676),
    [anon_sym_double] = ACTIONS(676),
    [sym_boolean_type] = ACTIONS(676),
    [sym_void_type] = ACTIONS(676),
    [sym_this] = ACTIONS(676),
    [sym_super] = ACTIONS(676),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(678),
    [sym_identifier] = ACTIONS(680),
    [sym_decimal_integer_literal] = ACTIONS(680),
    [sym_hex_integer_literal] = ACTIONS(680),
    [sym_octal_integer_literal] = ACTIONS(678),
    [sym_binary_integer_literal] = ACTIONS(678),
    [sym_decimal_floating_point_literal] = ACTIONS(678),
    [sym_hex_floating_point_literal] = ACTIONS(680),
    [sym_true] = ACTIONS(680),
    [sym_false] = ACTIONS(680),
    [sym_character_literal] = ACTIONS(678),
    [sym_string_literal] = ACTIONS(678),
    [sym_null_literal] = ACTIONS(680),
    [anon_sym_LPAREN] = ACTIONS(678),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_DASH] = ACTIONS(680),
    [anon_sym_BANG] = ACTIONS(678),
    [anon_sym_TILDE] = ACTIONS(678),
    [anon_sym_PLUS_PLUS] = ACTIONS(678),
    [anon_sym_DASH_DASH] = ACTIONS(678),
    [anon_sym_new] = ACTIONS(680),
    [anon_sym_class] = ACTIONS(680),
    [anon_sym_SEMI] = ACTIONS(678),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_assert] = ACTIONS(680),
    [anon_sym_switch] = ACTIONS(680),
    [anon_sym_case] = ACTIONS(680),
    [anon_sym_default] = ACTIONS(680),
    [anon_sym_do] = ACTIONS(680),
    [anon_sym_while] = ACTIONS(680),
    [anon_sym_break] = ACTIONS(680),
    [anon_sym_continue] = ACTIONS(680),
    [anon_sym_return] = ACTIONS(680),
    [anon_sym_synchronized] = ACTIONS(680),
    [anon_sym_throw] = ACTIONS(680),
    [anon_sym_try] = ACTIONS(680),
    [anon_sym_if] = ACTIONS(680),
    [anon_sym_else] = ACTIONS(680),
    [anon_sym_for] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(680),
    [anon_sym_open] = ACTIONS(680),
    [anon_sym_module] = ACTIONS(680),
    [anon_sym_static] = ACTIONS(680),
    [anon_sym_package] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(680),
    [anon_sym_enum] = ACTIONS(680),
    [anon_sym_public] = ACTIONS(680),
    [anon_sym_protected] = ACTIONS(680),
    [anon_sym_private] = ACTIONS(680),
    [anon_sym_abstract] = ACTIONS(680),
    [anon_sym_final] = ACTIONS(680),
    [anon_sym_strictfp] = ACTIONS(680),
    [anon_sym_native] = ACTIONS(680),
    [anon_sym_transient] = ACTIONS(680),
    [anon_sym_volatile] = ACTIONS(680),
    [anon_sym_ATinterface] = ACTIONS(678),
    [anon_sym_interface] = ACTIONS(680),
    [anon_sym_byte] = ACTIONS(680),
    [anon_sym_short] = ACTIONS(680),
    [anon_sym_int] = ACTIONS(680),
    [anon_sym_long] = ACTIONS(680),
    [anon_sym_char] = ACTIONS(680),
    [anon_sym_float] = ACTIONS(680),
    [anon_sym_double] = ACTIONS(680),
    [sym_boolean_type] = ACTIONS(680),
    [sym_void_type] = ACTIONS(680),
    [sym_this] = ACTIONS(680),
    [sym_super] = ACTIONS(680),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(682),
    [sym_identifier] = ACTIONS(684),
    [sym_decimal_integer_literal] = ACTIONS(684),
    [sym_hex_integer_literal] = ACTIONS(684),
    [sym_octal_integer_literal] = ACTIONS(682),
    [sym_binary_integer_literal] = ACTIONS(682),
    [sym_decimal_floating_point_literal] = ACTIONS(682),
    [sym_hex_floating_point_literal] = ACTIONS(684),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_character_literal] = ACTIONS(682),
    [sym_string_literal] = ACTIONS(682),
    [sym_null_literal] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(682),
    [anon_sym_PLUS] = ACTIONS(684),
    [anon_sym_DASH] = ACTIONS(684),
    [anon_sym_BANG] = ACTIONS(682),
    [anon_sym_TILDE] = ACTIONS(682),
    [anon_sym_PLUS_PLUS] = ACTIONS(682),
    [anon_sym_DASH_DASH] = ACTIONS(682),
    [anon_sym_new] = ACTIONS(684),
    [anon_sym_class] = ACTIONS(684),
    [anon_sym_SEMI] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(682),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_assert] = ACTIONS(684),
    [anon_sym_switch] = ACTIONS(684),
    [anon_sym_case] = ACTIONS(684),
    [anon_sym_default] = ACTIONS(684),
    [anon_sym_do] = ACTIONS(684),
    [anon_sym_while] = ACTIONS(684),
    [anon_sym_break] = ACTIONS(684),
    [anon_sym_continue] = ACTIONS(684),
    [anon_sym_return] = ACTIONS(684),
    [anon_sym_synchronized] = ACTIONS(684),
    [anon_sym_throw] = ACTIONS(684),
    [anon_sym_try] = ACTIONS(684),
    [anon_sym_if] = ACTIONS(684),
    [anon_sym_else] = ACTIONS(684),
    [anon_sym_for] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(684),
    [anon_sym_open] = ACTIONS(684),
    [anon_sym_module] = ACTIONS(684),
    [anon_sym_static] = ACTIONS(684),
    [anon_sym_package] = ACTIONS(684),
    [anon_sym_import] = ACTIONS(684),
    [anon_sym_enum] = ACTIONS(684),
    [anon_sym_public] = ACTIONS(684),
    [anon_sym_protected] = ACTIONS(684),
    [anon_sym_private] = ACTIONS(684),
    [anon_sym_abstract] = ACTIONS(684),
    [anon_sym_final] = ACTIONS(684),
    [anon_sym_strictfp] = ACTIONS(684),
    [anon_sym_native] = ACTIONS(684),
    [anon_sym_transient] = ACTIONS(684),
    [anon_sym_volatile] = ACTIONS(684),
    [anon_sym_ATinterface] = ACTIONS(682),
    [anon_sym_interface] = ACTIONS(684),
    [anon_sym_byte] = ACTIONS(684),
    [anon_sym_short] = ACTIONS(684),
    [anon_sym_int] = ACTIONS(684),
    [anon_sym_long] = ACTIONS(684),
    [anon_sym_char] = ACTIONS(684),
    [anon_sym_float] = ACTIONS(684),
    [anon_sym_double] = ACTIONS(684),
    [sym_boolean_type] = ACTIONS(684),
    [sym_void_type] = ACTIONS(684),
    [sym_this] = ACTIONS(684),
    [sym_super] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(686),
    [sym_identifier] = ACTIONS(688),
    [sym_decimal_integer_literal] = ACTIONS(688),
    [sym_hex_integer_literal] = ACTIONS(688),
    [sym_octal_integer_literal] = ACTIONS(686),
    [sym_binary_integer_literal] = ACTIONS(686),
    [sym_decimal_floating_point_literal] = ACTIONS(686),
    [sym_hex_floating_point_literal] = ACTIONS(688),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_character_literal] = ACTIONS(686),
    [sym_string_literal] = ACTIONS(686),
    [sym_null_literal] = ACTIONS(688),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_PLUS] = ACTIONS(688),
    [anon_sym_DASH] = ACTIONS(688),
    [anon_sym_BANG] = ACTIONS(686),
    [anon_sym_TILDE] = ACTIONS(686),
    [anon_sym_PLUS_PLUS] = ACTIONS(686),
    [anon_sym_DASH_DASH] = ACTIONS(686),
    [anon_sym_new] = ACTIONS(688),
    [anon_sym_class] = ACTIONS(688),
    [anon_sym_SEMI] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_RBRACE] = ACTIONS(686),
    [anon_sym_assert] = ACTIONS(688),
    [anon_sym_switch] = ACTIONS(688),
    [anon_sym_case] = ACTIONS(688),
    [anon_sym_default] = ACTIONS(688),
    [anon_sym_do] = ACTIONS(688),
    [anon_sym_while] = ACTIONS(688),
    [anon_sym_break] = ACTIONS(688),
    [anon_sym_continue] = ACTIONS(688),
    [anon_sym_return] = ACTIONS(688),
    [anon_sym_synchronized] = ACTIONS(688),
    [anon_sym_throw] = ACTIONS(688),
    [anon_sym_try] = ACTIONS(688),
    [anon_sym_if] = ACTIONS(688),
    [anon_sym_else] = ACTIONS(688),
    [anon_sym_for] = ACTIONS(688),
    [anon_sym_AT] = ACTIONS(688),
    [anon_sym_open] = ACTIONS(688),
    [anon_sym_module] = ACTIONS(688),
    [anon_sym_static] = ACTIONS(688),
    [anon_sym_package] = ACTIONS(688),
    [anon_sym_import] = ACTIONS(688),
    [anon_sym_enum] = ACTIONS(688),
    [anon_sym_public] = ACTIONS(688),
    [anon_sym_protected] = ACTIONS(688),
    [anon_sym_private] = ACTIONS(688),
    [anon_sym_abstract] = ACTIONS(688),
    [anon_sym_final] = ACTIONS(688),
    [anon_sym_strictfp] = ACTIONS(688),
    [anon_sym_native] = ACTIONS(688),
    [anon_sym_transient] = ACTIONS(688),
    [anon_sym_volatile] = ACTIONS(688),
    [anon_sym_ATinterface] = ACTIONS(686),
    [anon_sym_interface] = ACTIONS(688),
    [anon_sym_byte] = ACTIONS(688),
    [anon_sym_short] = ACTIONS(688),
    [anon_sym_int] = ACTIONS(688),
    [anon_sym_long] = ACTIONS(688),
    [anon_sym_char] = ACTIONS(688),
    [anon_sym_float] = ACTIONS(688),
    [anon_sym_double] = ACTIONS(688),
    [sym_boolean_type] = ACTIONS(688),
    [sym_void_type] = ACTIONS(688),
    [sym_this] = ACTIONS(688),
    [sym_super] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [ts_builtin_sym_end] = ACTIONS(690),
    [sym_identifier] = ACTIONS(692),
    [sym_decimal_integer_literal] = ACTIONS(692),
    [sym_hex_integer_literal] = ACTIONS(692),
    [sym_octal_integer_literal] = ACTIONS(690),
    [sym_binary_integer_literal] = ACTIONS(690),
    [sym_decimal_floating_point_literal] = ACTIONS(690),
    [sym_hex_floating_point_literal] = ACTIONS(692),
    [sym_true] = ACTIONS(692),
    [sym_false] = ACTIONS(692),
    [sym_character_literal] = ACTIONS(690),
    [sym_string_literal] = ACTIONS(690),
    [sym_null_literal] = ACTIONS(692),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_PLUS] = ACTIONS(692),
    [anon_sym_DASH] = ACTIONS(692),
    [anon_sym_BANG] = ACTIONS(690),
    [anon_sym_TILDE] = ACTIONS(690),
    [anon_sym_PLUS_PLUS] = ACTIONS(690),
    [anon_sym_DASH_DASH] = ACTIONS(690),
    [anon_sym_new] = ACTIONS(692),
    [anon_sym_class] = ACTIONS(692),
    [anon_sym_SEMI] = ACTIONS(690),
    [anon_sym_LBRACE] = ACTIONS(690),
    [anon_sym_RBRACE] = ACTIONS(690),
    [anon_sym_assert] = ACTIONS(692),
    [anon_sym_switch] = ACTIONS(692),
    [anon_sym_case] = ACTIONS(692),
    [anon_sym_default] = ACTIONS(692),
    [anon_sym_do] = ACTIONS(692),
    [anon_sym_while] = ACTIONS(692),
    [anon_sym_break] = ACTIONS(692),
    [anon_sym_continue] = ACTIONS(692),
    [anon_sym_return] = ACTIONS(692),
    [anon_sym_synchronized] = ACTIONS(692),
    [anon_sym_throw] = ACTIONS(692),
    [anon_sym_try] = ACTIONS(692),
    [anon_sym_if] = ACTIONS(692),
    [anon_sym_else] = ACTIONS(692),
    [anon_sym_for] = ACTIONS(692),
    [anon_sym_AT] = ACTIONS(692),
    [anon_sym_open] = ACTIONS(692),
    [anon_sym_module] = ACTIONS(692),
    [anon_sym_static] = ACTIONS(692),
    [anon_sym_package] = ACTIONS(692),
    [anon_sym_import] = ACTIONS(692),
    [anon_sym_enum] = ACTIONS(692),
    [anon_sym_public] = ACTIONS(692),
    [anon_sym_protected] = ACTIONS(692),
    [anon_sym_private] = ACTIONS(692),
    [anon_sym_abstract] = ACTIONS(692),
    [anon_sym_final] = ACTIONS(692),
    [anon_sym_strictfp] = ACTIONS(692),
    [anon_sym_native] = ACTIONS(692),
    [anon_sym_transient] = ACTIONS(692),
    [anon_sym_volatile] = ACTIONS(692),
    [anon_sym_ATinterface] = ACTIONS(690),
    [anon_sym_interface] = ACTIONS(692),
    [anon_sym_byte] = ACTIONS(692),
    [anon_sym_short] = ACTIONS(692),
    [anon_sym_int] = ACTIONS(692),
    [anon_sym_long] = ACTIONS(692),
    [anon_sym_char] = ACTIONS(692),
    [anon_sym_float] = ACTIONS(692),
    [anon_sym_double] = ACTIONS(692),
    [sym_boolean_type] = ACTIONS(692),
    [sym_void_type] = ACTIONS(692),
    [sym_this] = ACTIONS(692),
    [sym_super] = ACTIONS(692),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [ts_builtin_sym_end] = ACTIONS(694),
    [sym_identifier] = ACTIONS(696),
    [sym_decimal_integer_literal] = ACTIONS(696),
    [sym_hex_integer_literal] = ACTIONS(696),
    [sym_octal_integer_literal] = ACTIONS(694),
    [sym_binary_integer_literal] = ACTIONS(694),
    [sym_decimal_floating_point_literal] = ACTIONS(694),
    [sym_hex_floating_point_literal] = ACTIONS(696),
    [sym_true] = ACTIONS(696),
    [sym_false] = ACTIONS(696),
    [sym_character_literal] = ACTIONS(694),
    [sym_string_literal] = ACTIONS(694),
    [sym_null_literal] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(694),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(694),
    [anon_sym_TILDE] = ACTIONS(694),
    [anon_sym_PLUS_PLUS] = ACTIONS(694),
    [anon_sym_DASH_DASH] = ACTIONS(694),
    [anon_sym_new] = ACTIONS(696),
    [anon_sym_class] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(694),
    [anon_sym_RBRACE] = ACTIONS(694),
    [anon_sym_assert] = ACTIONS(696),
    [anon_sym_switch] = ACTIONS(696),
    [anon_sym_case] = ACTIONS(696),
    [anon_sym_default] = ACTIONS(696),
    [anon_sym_do] = ACTIONS(696),
    [anon_sym_while] = ACTIONS(696),
    [anon_sym_break] = ACTIONS(696),
    [anon_sym_continue] = ACTIONS(696),
    [anon_sym_return] = ACTIONS(696),
    [anon_sym_synchronized] = ACTIONS(696),
    [anon_sym_throw] = ACTIONS(696),
    [anon_sym_try] = ACTIONS(696),
    [anon_sym_if] = ACTIONS(696),
    [anon_sym_else] = ACTIONS(696),
    [anon_sym_for] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_open] = ACTIONS(696),
    [anon_sym_module] = ACTIONS(696),
    [anon_sym_static] = ACTIONS(696),
    [anon_sym_package] = ACTIONS(696),
    [anon_sym_import] = ACTIONS(696),
    [anon_sym_enum] = ACTIONS(696),
    [anon_sym_public] = ACTIONS(696),
    [anon_sym_protected] = ACTIONS(696),
    [anon_sym_private] = ACTIONS(696),
    [anon_sym_abstract] = ACTIONS(696),
    [anon_sym_final] = ACTIONS(696),
    [anon_sym_strictfp] = ACTIONS(696),
    [anon_sym_native] = ACTIONS(696),
    [anon_sym_transient] = ACTIONS(696),
    [anon_sym_volatile] = ACTIONS(696),
    [anon_sym_ATinterface] = ACTIONS(694),
    [anon_sym_interface] = ACTIONS(696),
    [anon_sym_byte] = ACTIONS(696),
    [anon_sym_short] = ACTIONS(696),
    [anon_sym_int] = ACTIONS(696),
    [anon_sym_long] = ACTIONS(696),
    [anon_sym_char] = ACTIONS(696),
    [anon_sym_float] = ACTIONS(696),
    [anon_sym_double] = ACTIONS(696),
    [sym_boolean_type] = ACTIONS(696),
    [sym_void_type] = ACTIONS(696),
    [sym_this] = ACTIONS(696),
    [sym_super] = ACTIONS(696),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(698),
    [sym_identifier] = ACTIONS(700),
    [sym_decimal_integer_literal] = ACTIONS(700),
    [sym_hex_integer_literal] = ACTIONS(700),
    [sym_octal_integer_literal] = ACTIONS(698),
    [sym_binary_integer_literal] = ACTIONS(698),
    [sym_decimal_floating_point_literal] = ACTIONS(698),
    [sym_hex_floating_point_literal] = ACTIONS(700),
    [sym_true] = ACTIONS(700),
    [sym_false] = ACTIONS(700),
    [sym_character_literal] = ACTIONS(698),
    [sym_string_literal] = ACTIONS(698),
    [sym_null_literal] = ACTIONS(700),
    [anon_sym_LPAREN] = ACTIONS(698),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_TILDE] = ACTIONS(698),
    [anon_sym_PLUS_PLUS] = ACTIONS(698),
    [anon_sym_DASH_DASH] = ACTIONS(698),
    [anon_sym_new] = ACTIONS(700),
    [anon_sym_class] = ACTIONS(700),
    [anon_sym_SEMI] = ACTIONS(698),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(698),
    [anon_sym_assert] = ACTIONS(700),
    [anon_sym_switch] = ACTIONS(700),
    [anon_sym_case] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(700),
    [anon_sym_do] = ACTIONS(700),
    [anon_sym_while] = ACTIONS(700),
    [anon_sym_break] = ACTIONS(700),
    [anon_sym_continue] = ACTIONS(700),
    [anon_sym_return] = ACTIONS(700),
    [anon_sym_synchronized] = ACTIONS(700),
    [anon_sym_throw] = ACTIONS(700),
    [anon_sym_try] = ACTIONS(700),
    [anon_sym_if] = ACTIONS(700),
    [anon_sym_else] = ACTIONS(700),
    [anon_sym_for] = ACTIONS(700),
    [anon_sym_AT] = ACTIONS(700),
    [anon_sym_open] = ACTIONS(700),
    [anon_sym_module] = ACTIONS(700),
    [anon_sym_static] = ACTIONS(700),
    [anon_sym_package] = ACTIONS(700),
    [anon_sym_import] = ACTIONS(700),
    [anon_sym_enum] = ACTIONS(700),
    [anon_sym_public] = ACTIONS(700),
    [anon_sym_protected] = ACTIONS(700),
    [anon_sym_private] = ACTIONS(700),
    [anon_sym_abstract] = ACTIONS(700),
    [anon_sym_final] = ACTIONS(700),
    [anon_sym_strictfp] = ACTIONS(700),
    [anon_sym_native] = ACTIONS(700),
    [anon_sym_transient] = ACTIONS(700),
    [anon_sym_volatile] = ACTIONS(700),
    [anon_sym_ATinterface] = ACTIONS(698),
    [anon_sym_interface] = ACTIONS(700),
    [anon_sym_byte] = ACTIONS(700),
    [anon_sym_short] = ACTIONS(700),
    [anon_sym_int] = ACTIONS(700),
    [anon_sym_long] = ACTIONS(700),
    [anon_sym_char] = ACTIONS(700),
    [anon_sym_float] = ACTIONS(700),
    [anon_sym_double] = ACTIONS(700),
    [sym_boolean_type] = ACTIONS(700),
    [sym_void_type] = ACTIONS(700),
    [sym_this] = ACTIONS(700),
    [sym_super] = ACTIONS(700),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(702),
    [sym_identifier] = ACTIONS(704),
    [sym_decimal_integer_literal] = ACTIONS(704),
    [sym_hex_integer_literal] = ACTIONS(704),
    [sym_octal_integer_literal] = ACTIONS(702),
    [sym_binary_integer_literal] = ACTIONS(702),
    [sym_decimal_floating_point_literal] = ACTIONS(702),
    [sym_hex_floating_point_literal] = ACTIONS(704),
    [sym_true] = ACTIONS(704),
    [sym_false] = ACTIONS(704),
    [sym_character_literal] = ACTIONS(702),
    [sym_string_literal] = ACTIONS(702),
    [sym_null_literal] = ACTIONS(704),
    [anon_sym_LPAREN] = ACTIONS(702),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_BANG] = ACTIONS(702),
    [anon_sym_TILDE] = ACTIONS(702),
    [anon_sym_PLUS_PLUS] = ACTIONS(702),
    [anon_sym_DASH_DASH] = ACTIONS(702),
    [anon_sym_new] = ACTIONS(704),
    [anon_sym_class] = ACTIONS(704),
    [anon_sym_SEMI] = ACTIONS(702),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(702),
    [anon_sym_assert] = ACTIONS(704),
    [anon_sym_switch] = ACTIONS(704),
    [anon_sym_case] = ACTIONS(704),
    [anon_sym_default] = ACTIONS(704),
    [anon_sym_do] = ACTIONS(704),
    [anon_sym_while] = ACTIONS(704),
    [anon_sym_break] = ACTIONS(704),
    [anon_sym_continue] = ACTIONS(704),
    [anon_sym_return] = ACTIONS(704),
    [anon_sym_synchronized] = ACTIONS(704),
    [anon_sym_throw] = ACTIONS(704),
    [anon_sym_try] = ACTIONS(704),
    [anon_sym_if] = ACTIONS(704),
    [anon_sym_else] = ACTIONS(704),
    [anon_sym_for] = ACTIONS(704),
    [anon_sym_AT] = ACTIONS(704),
    [anon_sym_open] = ACTIONS(704),
    [anon_sym_module] = ACTIONS(704),
    [anon_sym_static] = ACTIONS(704),
    [anon_sym_package] = ACTIONS(704),
    [anon_sym_import] = ACTIONS(704),
    [anon_sym_enum] = ACTIONS(704),
    [anon_sym_public] = ACTIONS(704),
    [anon_sym_protected] = ACTIONS(704),
    [anon_sym_private] = ACTIONS(704),
    [anon_sym_abstract] = ACTIONS(704),
    [anon_sym_final] = ACTIONS(704),
    [anon_sym_strictfp] = ACTIONS(704),
    [anon_sym_native] = ACTIONS(704),
    [anon_sym_transient] = ACTIONS(704),
    [anon_sym_volatile] = ACTIONS(704),
    [anon_sym_ATinterface] = ACTIONS(702),
    [anon_sym_interface] = ACTIONS(704),
    [anon_sym_byte] = ACTIONS(704),
    [anon_sym_short] = ACTIONS(704),
    [anon_sym_int] = ACTIONS(704),
    [anon_sym_long] = ACTIONS(704),
    [anon_sym_char] = ACTIONS(704),
    [anon_sym_float] = ACTIONS(704),
    [anon_sym_double] = ACTIONS(704),
    [sym_boolean_type] = ACTIONS(704),
    [sym_void_type] = ACTIONS(704),
    [sym_this] = ACTIONS(704),
    [sym_super] = ACTIONS(704),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(706),
    [sym_identifier] = ACTIONS(708),
    [sym_decimal_integer_literal] = ACTIONS(708),
    [sym_hex_integer_literal] = ACTIONS(708),
    [sym_octal_integer_literal] = ACTIONS(706),
    [sym_binary_integer_literal] = ACTIONS(706),
    [sym_decimal_floating_point_literal] = ACTIONS(706),
    [sym_hex_floating_point_literal] = ACTIONS(708),
    [sym_true] = ACTIONS(708),
    [sym_false] = ACTIONS(708),
    [sym_character_literal] = ACTIONS(706),
    [sym_string_literal] = ACTIONS(706),
    [sym_null_literal] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(706),
    [anon_sym_PLUS] = ACTIONS(708),
    [anon_sym_DASH] = ACTIONS(708),
    [anon_sym_BANG] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(706),
    [anon_sym_PLUS_PLUS] = ACTIONS(706),
    [anon_sym_DASH_DASH] = ACTIONS(706),
    [anon_sym_new] = ACTIONS(708),
    [anon_sym_class] = ACTIONS(708),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(706),
    [anon_sym_RBRACE] = ACTIONS(706),
    [anon_sym_assert] = ACTIONS(708),
    [anon_sym_switch] = ACTIONS(708),
    [anon_sym_case] = ACTIONS(708),
    [anon_sym_default] = ACTIONS(708),
    [anon_sym_do] = ACTIONS(708),
    [anon_sym_while] = ACTIONS(708),
    [anon_sym_break] = ACTIONS(708),
    [anon_sym_continue] = ACTIONS(708),
    [anon_sym_return] = ACTIONS(708),
    [anon_sym_synchronized] = ACTIONS(708),
    [anon_sym_throw] = ACTIONS(708),
    [anon_sym_try] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_else] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_AT] = ACTIONS(708),
    [anon_sym_open] = ACTIONS(708),
    [anon_sym_module] = ACTIONS(708),
    [anon_sym_static] = ACTIONS(708),
    [anon_sym_package] = ACTIONS(708),
    [anon_sym_import] = ACTIONS(708),
    [anon_sym_enum] = ACTIONS(708),
    [anon_sym_public] = ACTIONS(708),
    [anon_sym_protected] = ACTIONS(708),
    [anon_sym_private] = ACTIONS(708),
    [anon_sym_abstract] = ACTIONS(708),
    [anon_sym_final] = ACTIONS(708),
    [anon_sym_strictfp] = ACTIONS(708),
    [anon_sym_native] = ACTIONS(708),
    [anon_sym_transient] = ACTIONS(708),
    [anon_sym_volatile] = ACTIONS(708),
    [anon_sym_ATinterface] = ACTIONS(706),
    [anon_sym_interface] = ACTIONS(708),
    [anon_sym_byte] = ACTIONS(708),
    [anon_sym_short] = ACTIONS(708),
    [anon_sym_int] = ACTIONS(708),
    [anon_sym_long] = ACTIONS(708),
    [anon_sym_char] = ACTIONS(708),
    [anon_sym_float] = ACTIONS(708),
    [anon_sym_double] = ACTIONS(708),
    [sym_boolean_type] = ACTIONS(708),
    [sym_void_type] = ACTIONS(708),
    [sym_this] = ACTIONS(708),
    [sym_super] = ACTIONS(708),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(710),
    [sym_identifier] = ACTIONS(712),
    [sym_decimal_integer_literal] = ACTIONS(712),
    [sym_hex_integer_literal] = ACTIONS(712),
    [sym_octal_integer_literal] = ACTIONS(710),
    [sym_binary_integer_literal] = ACTIONS(710),
    [sym_decimal_floating_point_literal] = ACTIONS(710),
    [sym_hex_floating_point_literal] = ACTIONS(712),
    [sym_true] = ACTIONS(712),
    [sym_false] = ACTIONS(712),
    [sym_character_literal] = ACTIONS(710),
    [sym_string_literal] = ACTIONS(710),
    [sym_null_literal] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(710),
    [anon_sym_PLUS] = ACTIONS(712),
    [anon_sym_DASH] = ACTIONS(712),
    [anon_sym_BANG] = ACTIONS(710),
    [anon_sym_TILDE] = ACTIONS(710),
    [anon_sym_PLUS_PLUS] = ACTIONS(710),
    [anon_sym_DASH_DASH] = ACTIONS(710),
    [anon_sym_new] = ACTIONS(712),
    [anon_sym_class] = ACTIONS(712),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_RBRACE] = ACTIONS(710),
    [anon_sym_assert] = ACTIONS(712),
    [anon_sym_switch] = ACTIONS(712),
    [anon_sym_case] = ACTIONS(712),
    [anon_sym_default] = ACTIONS(712),
    [anon_sym_do] = ACTIONS(712),
    [anon_sym_while] = ACTIONS(712),
    [anon_sym_break] = ACTIONS(712),
    [anon_sym_continue] = ACTIONS(712),
    [anon_sym_return] = ACTIONS(712),
    [anon_sym_synchronized] = ACTIONS(712),
    [anon_sym_throw] = ACTIONS(712),
    [anon_sym_try] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_else] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_AT] = ACTIONS(712),
    [anon_sym_open] = ACTIONS(712),
    [anon_sym_module] = ACTIONS(712),
    [anon_sym_static] = ACTIONS(712),
    [anon_sym_package] = ACTIONS(712),
    [anon_sym_import] = ACTIONS(712),
    [anon_sym_enum] = ACTIONS(712),
    [anon_sym_public] = ACTIONS(712),
    [anon_sym_protected] = ACTIONS(712),
    [anon_sym_private] = ACTIONS(712),
    [anon_sym_abstract] = ACTIONS(712),
    [anon_sym_final] = ACTIONS(712),
    [anon_sym_strictfp] = ACTIONS(712),
    [anon_sym_native] = ACTIONS(712),
    [anon_sym_transient] = ACTIONS(712),
    [anon_sym_volatile] = ACTIONS(712),
    [anon_sym_ATinterface] = ACTIONS(710),
    [anon_sym_interface] = ACTIONS(712),
    [anon_sym_byte] = ACTIONS(712),
    [anon_sym_short] = ACTIONS(712),
    [anon_sym_int] = ACTIONS(712),
    [anon_sym_long] = ACTIONS(712),
    [anon_sym_char] = ACTIONS(712),
    [anon_sym_float] = ACTIONS(712),
    [anon_sym_double] = ACTIONS(712),
    [sym_boolean_type] = ACTIONS(712),
    [sym_void_type] = ACTIONS(712),
    [sym_this] = ACTIONS(712),
    [sym_super] = ACTIONS(712),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(714),
    [sym_identifier] = ACTIONS(716),
    [sym_decimal_integer_literal] = ACTIONS(716),
    [sym_hex_integer_literal] = ACTIONS(716),
    [sym_octal_integer_literal] = ACTIONS(714),
    [sym_binary_integer_literal] = ACTIONS(714),
    [sym_decimal_floating_point_literal] = ACTIONS(714),
    [sym_hex_floating_point_literal] = ACTIONS(716),
    [sym_true] = ACTIONS(716),
    [sym_false] = ACTIONS(716),
    [sym_character_literal] = ACTIONS(714),
    [sym_string_literal] = ACTIONS(714),
    [sym_null_literal] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_PLUS] = ACTIONS(716),
    [anon_sym_DASH] = ACTIONS(716),
    [anon_sym_BANG] = ACTIONS(714),
    [anon_sym_TILDE] = ACTIONS(714),
    [anon_sym_PLUS_PLUS] = ACTIONS(714),
    [anon_sym_DASH_DASH] = ACTIONS(714),
    [anon_sym_new] = ACTIONS(716),
    [anon_sym_class] = ACTIONS(716),
    [anon_sym_SEMI] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_RBRACE] = ACTIONS(714),
    [anon_sym_assert] = ACTIONS(716),
    [anon_sym_switch] = ACTIONS(716),
    [anon_sym_case] = ACTIONS(716),
    [anon_sym_default] = ACTIONS(716),
    [anon_sym_do] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_break] = ACTIONS(716),
    [anon_sym_continue] = ACTIONS(716),
    [anon_sym_return] = ACTIONS(716),
    [anon_sym_synchronized] = ACTIONS(716),
    [anon_sym_throw] = ACTIONS(716),
    [anon_sym_try] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_AT] = ACTIONS(716),
    [anon_sym_open] = ACTIONS(716),
    [anon_sym_module] = ACTIONS(716),
    [anon_sym_static] = ACTIONS(716),
    [anon_sym_package] = ACTIONS(716),
    [anon_sym_import] = ACTIONS(716),
    [anon_sym_enum] = ACTIONS(716),
    [anon_sym_public] = ACTIONS(716),
    [anon_sym_protected] = ACTIONS(716),
    [anon_sym_private] = ACTIONS(716),
    [anon_sym_abstract] = ACTIONS(716),
    [anon_sym_final] = ACTIONS(716),
    [anon_sym_strictfp] = ACTIONS(716),
    [anon_sym_native] = ACTIONS(716),
    [anon_sym_transient] = ACTIONS(716),
    [anon_sym_volatile] = ACTIONS(716),
    [anon_sym_ATinterface] = ACTIONS(714),
    [anon_sym_interface] = ACTIONS(716),
    [anon_sym_byte] = ACTIONS(716),
    [anon_sym_short] = ACTIONS(716),
    [anon_sym_int] = ACTIONS(716),
    [anon_sym_long] = ACTIONS(716),
    [anon_sym_char] = ACTIONS(716),
    [anon_sym_float] = ACTIONS(716),
    [anon_sym_double] = ACTIONS(716),
    [sym_boolean_type] = ACTIONS(716),
    [sym_void_type] = ACTIONS(716),
    [sym_this] = ACTIONS(716),
    [sym_super] = ACTIONS(716),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(718),
    [sym_identifier] = ACTIONS(720),
    [sym_decimal_integer_literal] = ACTIONS(720),
    [sym_hex_integer_literal] = ACTIONS(720),
    [sym_octal_integer_literal] = ACTIONS(718),
    [sym_binary_integer_literal] = ACTIONS(718),
    [sym_decimal_floating_point_literal] = ACTIONS(718),
    [sym_hex_floating_point_literal] = ACTIONS(720),
    [sym_true] = ACTIONS(720),
    [sym_false] = ACTIONS(720),
    [sym_character_literal] = ACTIONS(718),
    [sym_string_literal] = ACTIONS(718),
    [sym_null_literal] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(718),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_DASH] = ACTIONS(720),
    [anon_sym_BANG] = ACTIONS(718),
    [anon_sym_TILDE] = ACTIONS(718),
    [anon_sym_PLUS_PLUS] = ACTIONS(718),
    [anon_sym_DASH_DASH] = ACTIONS(718),
    [anon_sym_new] = ACTIONS(720),
    [anon_sym_class] = ACTIONS(720),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(718),
    [anon_sym_assert] = ACTIONS(720),
    [anon_sym_switch] = ACTIONS(720),
    [anon_sym_case] = ACTIONS(720),
    [anon_sym_default] = ACTIONS(720),
    [anon_sym_do] = ACTIONS(720),
    [anon_sym_while] = ACTIONS(720),
    [anon_sym_break] = ACTIONS(720),
    [anon_sym_continue] = ACTIONS(720),
    [anon_sym_return] = ACTIONS(720),
    [anon_sym_synchronized] = ACTIONS(720),
    [anon_sym_throw] = ACTIONS(720),
    [anon_sym_try] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_else] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_AT] = ACTIONS(720),
    [anon_sym_open] = ACTIONS(720),
    [anon_sym_module] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(720),
    [anon_sym_package] = ACTIONS(720),
    [anon_sym_import] = ACTIONS(720),
    [anon_sym_enum] = ACTIONS(720),
    [anon_sym_public] = ACTIONS(720),
    [anon_sym_protected] = ACTIONS(720),
    [anon_sym_private] = ACTIONS(720),
    [anon_sym_abstract] = ACTIONS(720),
    [anon_sym_final] = ACTIONS(720),
    [anon_sym_strictfp] = ACTIONS(720),
    [anon_sym_native] = ACTIONS(720),
    [anon_sym_transient] = ACTIONS(720),
    [anon_sym_volatile] = ACTIONS(720),
    [anon_sym_ATinterface] = ACTIONS(718),
    [anon_sym_interface] = ACTIONS(720),
    [anon_sym_byte] = ACTIONS(720),
    [anon_sym_short] = ACTIONS(720),
    [anon_sym_int] = ACTIONS(720),
    [anon_sym_long] = ACTIONS(720),
    [anon_sym_char] = ACTIONS(720),
    [anon_sym_float] = ACTIONS(720),
    [anon_sym_double] = ACTIONS(720),
    [sym_boolean_type] = ACTIONS(720),
    [sym_void_type] = ACTIONS(720),
    [sym_this] = ACTIONS(720),
    [sym_super] = ACTIONS(720),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(722),
    [sym_identifier] = ACTIONS(724),
    [sym_decimal_integer_literal] = ACTIONS(724),
    [sym_hex_integer_literal] = ACTIONS(724),
    [sym_octal_integer_literal] = ACTIONS(722),
    [sym_binary_integer_literal] = ACTIONS(722),
    [sym_decimal_floating_point_literal] = ACTIONS(722),
    [sym_hex_floating_point_literal] = ACTIONS(724),
    [sym_true] = ACTIONS(724),
    [sym_false] = ACTIONS(724),
    [sym_character_literal] = ACTIONS(722),
    [sym_string_literal] = ACTIONS(722),
    [sym_null_literal] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(722),
    [anon_sym_PLUS] = ACTIONS(724),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_BANG] = ACTIONS(722),
    [anon_sym_TILDE] = ACTIONS(722),
    [anon_sym_PLUS_PLUS] = ACTIONS(722),
    [anon_sym_DASH_DASH] = ACTIONS(722),
    [anon_sym_new] = ACTIONS(724),
    [anon_sym_class] = ACTIONS(724),
    [anon_sym_SEMI] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_RBRACE] = ACTIONS(722),
    [anon_sym_assert] = ACTIONS(724),
    [anon_sym_switch] = ACTIONS(724),
    [anon_sym_case] = ACTIONS(724),
    [anon_sym_default] = ACTIONS(724),
    [anon_sym_do] = ACTIONS(724),
    [anon_sym_while] = ACTIONS(724),
    [anon_sym_break] = ACTIONS(724),
    [anon_sym_continue] = ACTIONS(724),
    [anon_sym_return] = ACTIONS(724),
    [anon_sym_synchronized] = ACTIONS(724),
    [anon_sym_throw] = ACTIONS(724),
    [anon_sym_try] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_else] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_AT] = ACTIONS(724),
    [anon_sym_open] = ACTIONS(724),
    [anon_sym_module] = ACTIONS(724),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_package] = ACTIONS(724),
    [anon_sym_import] = ACTIONS(724),
    [anon_sym_enum] = ACTIONS(724),
    [anon_sym_public] = ACTIONS(724),
    [anon_sym_protected] = ACTIONS(724),
    [anon_sym_private] = ACTIONS(724),
    [anon_sym_abstract] = ACTIONS(724),
    [anon_sym_final] = ACTIONS(724),
    [anon_sym_strictfp] = ACTIONS(724),
    [anon_sym_native] = ACTIONS(724),
    [anon_sym_transient] = ACTIONS(724),
    [anon_sym_volatile] = ACTIONS(724),
    [anon_sym_ATinterface] = ACTIONS(722),
    [anon_sym_interface] = ACTIONS(724),
    [anon_sym_byte] = ACTIONS(724),
    [anon_sym_short] = ACTIONS(724),
    [anon_sym_int] = ACTIONS(724),
    [anon_sym_long] = ACTIONS(724),
    [anon_sym_char] = ACTIONS(724),
    [anon_sym_float] = ACTIONS(724),
    [anon_sym_double] = ACTIONS(724),
    [sym_boolean_type] = ACTIONS(724),
    [sym_void_type] = ACTIONS(724),
    [sym_this] = ACTIONS(724),
    [sym_super] = ACTIONS(724),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [ts_builtin_sym_end] = ACTIONS(726),
    [sym_identifier] = ACTIONS(728),
    [sym_decimal_integer_literal] = ACTIONS(728),
    [sym_hex_integer_literal] = ACTIONS(728),
    [sym_octal_integer_literal] = ACTIONS(726),
    [sym_binary_integer_literal] = ACTIONS(726),
    [sym_decimal_floating_point_literal] = ACTIONS(726),
    [sym_hex_floating_point_literal] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_character_literal] = ACTIONS(726),
    [sym_string_literal] = ACTIONS(726),
    [sym_null_literal] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_PLUS] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_BANG] = ACTIONS(726),
    [anon_sym_TILDE] = ACTIONS(726),
    [anon_sym_PLUS_PLUS] = ACTIONS(726),
    [anon_sym_DASH_DASH] = ACTIONS(726),
    [anon_sym_new] = ACTIONS(728),
    [anon_sym_class] = ACTIONS(728),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_RBRACE] = ACTIONS(726),
    [anon_sym_assert] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_case] = ACTIONS(728),
    [anon_sym_default] = ACTIONS(728),
    [anon_sym_do] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_break] = ACTIONS(728),
    [anon_sym_continue] = ACTIONS(728),
    [anon_sym_return] = ACTIONS(728),
    [anon_sym_synchronized] = ACTIONS(728),
    [anon_sym_throw] = ACTIONS(728),
    [anon_sym_try] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_AT] = ACTIONS(728),
    [anon_sym_open] = ACTIONS(728),
    [anon_sym_module] = ACTIONS(728),
    [anon_sym_static] = ACTIONS(728),
    [anon_sym_package] = ACTIONS(728),
    [anon_sym_import] = ACTIONS(728),
    [anon_sym_enum] = ACTIONS(728),
    [anon_sym_public] = ACTIONS(728),
    [anon_sym_protected] = ACTIONS(728),
    [anon_sym_private] = ACTIONS(728),
    [anon_sym_abstract] = ACTIONS(728),
    [anon_sym_final] = ACTIONS(728),
    [anon_sym_strictfp] = ACTIONS(728),
    [anon_sym_native] = ACTIONS(728),
    [anon_sym_transient] = ACTIONS(728),
    [anon_sym_volatile] = ACTIONS(728),
    [anon_sym_ATinterface] = ACTIONS(726),
    [anon_sym_interface] = ACTIONS(728),
    [anon_sym_byte] = ACTIONS(728),
    [anon_sym_short] = ACTIONS(728),
    [anon_sym_int] = ACTIONS(728),
    [anon_sym_long] = ACTIONS(728),
    [anon_sym_char] = ACTIONS(728),
    [anon_sym_float] = ACTIONS(728),
    [anon_sym_double] = ACTIONS(728),
    [sym_boolean_type] = ACTIONS(728),
    [sym_void_type] = ACTIONS(728),
    [sym_this] = ACTIONS(728),
    [sym_super] = ACTIONS(728),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(730),
    [sym_identifier] = ACTIONS(732),
    [sym_decimal_integer_literal] = ACTIONS(732),
    [sym_hex_integer_literal] = ACTIONS(732),
    [sym_octal_integer_literal] = ACTIONS(730),
    [sym_binary_integer_literal] = ACTIONS(730),
    [sym_decimal_floating_point_literal] = ACTIONS(730),
    [sym_hex_floating_point_literal] = ACTIONS(732),
    [sym_true] = ACTIONS(732),
    [sym_false] = ACTIONS(732),
    [sym_character_literal] = ACTIONS(730),
    [sym_string_literal] = ACTIONS(730),
    [sym_null_literal] = ACTIONS(732),
    [anon_sym_LPAREN] = ACTIONS(730),
    [anon_sym_PLUS] = ACTIONS(732),
    [anon_sym_DASH] = ACTIONS(732),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_TILDE] = ACTIONS(730),
    [anon_sym_PLUS_PLUS] = ACTIONS(730),
    [anon_sym_DASH_DASH] = ACTIONS(730),
    [anon_sym_new] = ACTIONS(732),
    [anon_sym_class] = ACTIONS(732),
    [anon_sym_SEMI] = ACTIONS(730),
    [anon_sym_LBRACE] = ACTIONS(730),
    [anon_sym_RBRACE] = ACTIONS(730),
    [anon_sym_assert] = ACTIONS(732),
    [anon_sym_switch] = ACTIONS(732),
    [anon_sym_case] = ACTIONS(732),
    [anon_sym_default] = ACTIONS(732),
    [anon_sym_do] = ACTIONS(732),
    [anon_sym_while] = ACTIONS(732),
    [anon_sym_break] = ACTIONS(732),
    [anon_sym_continue] = ACTIONS(732),
    [anon_sym_return] = ACTIONS(732),
    [anon_sym_synchronized] = ACTIONS(732),
    [anon_sym_throw] = ACTIONS(732),
    [anon_sym_try] = ACTIONS(732),
    [anon_sym_if] = ACTIONS(732),
    [anon_sym_else] = ACTIONS(732),
    [anon_sym_for] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(732),
    [anon_sym_open] = ACTIONS(732),
    [anon_sym_module] = ACTIONS(732),
    [anon_sym_static] = ACTIONS(732),
    [anon_sym_package] = ACTIONS(732),
    [anon_sym_import] = ACTIONS(732),
    [anon_sym_enum] = ACTIONS(732),
    [anon_sym_public] = ACTIONS(732),
    [anon_sym_protected] = ACTIONS(732),
    [anon_sym_private] = ACTIONS(732),
    [anon_sym_abstract] = ACTIONS(732),
    [anon_sym_final] = ACTIONS(732),
    [anon_sym_strictfp] = ACTIONS(732),
    [anon_sym_native] = ACTIONS(732),
    [anon_sym_transient] = ACTIONS(732),
    [anon_sym_volatile] = ACTIONS(732),
    [anon_sym_ATinterface] = ACTIONS(730),
    [anon_sym_interface] = ACTIONS(732),
    [anon_sym_byte] = ACTIONS(732),
    [anon_sym_short] = ACTIONS(732),
    [anon_sym_int] = ACTIONS(732),
    [anon_sym_long] = ACTIONS(732),
    [anon_sym_char] = ACTIONS(732),
    [anon_sym_float] = ACTIONS(732),
    [anon_sym_double] = ACTIONS(732),
    [sym_boolean_type] = ACTIONS(732),
    [sym_void_type] = ACTIONS(732),
    [sym_this] = ACTIONS(732),
    [sym_super] = ACTIONS(732),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [ts_builtin_sym_end] = ACTIONS(734),
    [sym_identifier] = ACTIONS(736),
    [sym_decimal_integer_literal] = ACTIONS(736),
    [sym_hex_integer_literal] = ACTIONS(736),
    [sym_octal_integer_literal] = ACTIONS(734),
    [sym_binary_integer_literal] = ACTIONS(734),
    [sym_decimal_floating_point_literal] = ACTIONS(734),
    [sym_hex_floating_point_literal] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_character_literal] = ACTIONS(734),
    [sym_string_literal] = ACTIONS(734),
    [sym_null_literal] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(734),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(734),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_PLUS_PLUS] = ACTIONS(734),
    [anon_sym_DASH_DASH] = ACTIONS(734),
    [anon_sym_new] = ACTIONS(736),
    [anon_sym_class] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_RBRACE] = ACTIONS(734),
    [anon_sym_assert] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_case] = ACTIONS(736),
    [anon_sym_default] = ACTIONS(736),
    [anon_sym_do] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_break] = ACTIONS(736),
    [anon_sym_continue] = ACTIONS(736),
    [anon_sym_return] = ACTIONS(736),
    [anon_sym_synchronized] = ACTIONS(736),
    [anon_sym_throw] = ACTIONS(736),
    [anon_sym_try] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_AT] = ACTIONS(736),
    [anon_sym_open] = ACTIONS(736),
    [anon_sym_module] = ACTIONS(736),
    [anon_sym_static] = ACTIONS(736),
    [anon_sym_package] = ACTIONS(736),
    [anon_sym_import] = ACTIONS(736),
    [anon_sym_enum] = ACTIONS(736),
    [anon_sym_public] = ACTIONS(736),
    [anon_sym_protected] = ACTIONS(736),
    [anon_sym_private] = ACTIONS(736),
    [anon_sym_abstract] = ACTIONS(736),
    [anon_sym_final] = ACTIONS(736),
    [anon_sym_strictfp] = ACTIONS(736),
    [anon_sym_native] = ACTIONS(736),
    [anon_sym_transient] = ACTIONS(736),
    [anon_sym_volatile] = ACTIONS(736),
    [anon_sym_ATinterface] = ACTIONS(734),
    [anon_sym_interface] = ACTIONS(736),
    [anon_sym_byte] = ACTIONS(736),
    [anon_sym_short] = ACTIONS(736),
    [anon_sym_int] = ACTIONS(736),
    [anon_sym_long] = ACTIONS(736),
    [anon_sym_char] = ACTIONS(736),
    [anon_sym_float] = ACTIONS(736),
    [anon_sym_double] = ACTIONS(736),
    [sym_boolean_type] = ACTIONS(736),
    [sym_void_type] = ACTIONS(736),
    [sym_this] = ACTIONS(736),
    [sym_super] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(738),
    [sym_identifier] = ACTIONS(740),
    [sym_decimal_integer_literal] = ACTIONS(740),
    [sym_hex_integer_literal] = ACTIONS(740),
    [sym_octal_integer_literal] = ACTIONS(738),
    [sym_binary_integer_literal] = ACTIONS(738),
    [sym_decimal_floating_point_literal] = ACTIONS(738),
    [sym_hex_floating_point_literal] = ACTIONS(740),
    [sym_true] = ACTIONS(740),
    [sym_false] = ACTIONS(740),
    [sym_character_literal] = ACTIONS(738),
    [sym_string_literal] = ACTIONS(738),
    [sym_null_literal] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_PLUS_PLUS] = ACTIONS(738),
    [anon_sym_DASH_DASH] = ACTIONS(738),
    [anon_sym_new] = ACTIONS(740),
    [anon_sym_class] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_assert] = ACTIONS(740),
    [anon_sym_switch] = ACTIONS(740),
    [anon_sym_case] = ACTIONS(740),
    [anon_sym_default] = ACTIONS(740),
    [anon_sym_do] = ACTIONS(740),
    [anon_sym_while] = ACTIONS(740),
    [anon_sym_break] = ACTIONS(740),
    [anon_sym_continue] = ACTIONS(740),
    [anon_sym_return] = ACTIONS(740),
    [anon_sym_synchronized] = ACTIONS(740),
    [anon_sym_throw] = ACTIONS(740),
    [anon_sym_try] = ACTIONS(740),
    [anon_sym_if] = ACTIONS(740),
    [anon_sym_else] = ACTIONS(740),
    [anon_sym_for] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_open] = ACTIONS(740),
    [anon_sym_module] = ACTIONS(740),
    [anon_sym_static] = ACTIONS(740),
    [anon_sym_package] = ACTIONS(740),
    [anon_sym_import] = ACTIONS(740),
    [anon_sym_enum] = ACTIONS(740),
    [anon_sym_public] = ACTIONS(740),
    [anon_sym_protected] = ACTIONS(740),
    [anon_sym_private] = ACTIONS(740),
    [anon_sym_abstract] = ACTIONS(740),
    [anon_sym_final] = ACTIONS(740),
    [anon_sym_strictfp] = ACTIONS(740),
    [anon_sym_native] = ACTIONS(740),
    [anon_sym_transient] = ACTIONS(740),
    [anon_sym_volatile] = ACTIONS(740),
    [anon_sym_ATinterface] = ACTIONS(738),
    [anon_sym_interface] = ACTIONS(740),
    [anon_sym_byte] = ACTIONS(740),
    [anon_sym_short] = ACTIONS(740),
    [anon_sym_int] = ACTIONS(740),
    [anon_sym_long] = ACTIONS(740),
    [anon_sym_char] = ACTIONS(740),
    [anon_sym_float] = ACTIONS(740),
    [anon_sym_double] = ACTIONS(740),
    [sym_boolean_type] = ACTIONS(740),
    [sym_void_type] = ACTIONS(740),
    [sym_this] = ACTIONS(740),
    [sym_super] = ACTIONS(740),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(742),
    [sym_identifier] = ACTIONS(744),
    [sym_decimal_integer_literal] = ACTIONS(744),
    [sym_hex_integer_literal] = ACTIONS(744),
    [sym_octal_integer_literal] = ACTIONS(742),
    [sym_binary_integer_literal] = ACTIONS(742),
    [sym_decimal_floating_point_literal] = ACTIONS(742),
    [sym_hex_floating_point_literal] = ACTIONS(744),
    [sym_true] = ACTIONS(744),
    [sym_false] = ACTIONS(744),
    [sym_character_literal] = ACTIONS(742),
    [sym_string_literal] = ACTIONS(742),
    [sym_null_literal] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(742),
    [anon_sym_PLUS] = ACTIONS(744),
    [anon_sym_DASH] = ACTIONS(744),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_TILDE] = ACTIONS(742),
    [anon_sym_PLUS_PLUS] = ACTIONS(742),
    [anon_sym_DASH_DASH] = ACTIONS(742),
    [anon_sym_new] = ACTIONS(744),
    [anon_sym_class] = ACTIONS(744),
    [anon_sym_SEMI] = ACTIONS(742),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_RBRACE] = ACTIONS(742),
    [anon_sym_assert] = ACTIONS(744),
    [anon_sym_switch] = ACTIONS(744),
    [anon_sym_case] = ACTIONS(744),
    [anon_sym_default] = ACTIONS(744),
    [anon_sym_do] = ACTIONS(744),
    [anon_sym_while] = ACTIONS(744),
    [anon_sym_break] = ACTIONS(744),
    [anon_sym_continue] = ACTIONS(744),
    [anon_sym_return] = ACTIONS(744),
    [anon_sym_synchronized] = ACTIONS(744),
    [anon_sym_throw] = ACTIONS(744),
    [anon_sym_try] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_else] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_AT] = ACTIONS(744),
    [anon_sym_open] = ACTIONS(744),
    [anon_sym_module] = ACTIONS(744),
    [anon_sym_static] = ACTIONS(744),
    [anon_sym_package] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(744),
    [anon_sym_enum] = ACTIONS(744),
    [anon_sym_public] = ACTIONS(744),
    [anon_sym_protected] = ACTIONS(744),
    [anon_sym_private] = ACTIONS(744),
    [anon_sym_abstract] = ACTIONS(744),
    [anon_sym_final] = ACTIONS(744),
    [anon_sym_strictfp] = ACTIONS(744),
    [anon_sym_native] = ACTIONS(744),
    [anon_sym_transient] = ACTIONS(744),
    [anon_sym_volatile] = ACTIONS(744),
    [anon_sym_ATinterface] = ACTIONS(742),
    [anon_sym_interface] = ACTIONS(744),
    [anon_sym_byte] = ACTIONS(744),
    [anon_sym_short] = ACTIONS(744),
    [anon_sym_int] = ACTIONS(744),
    [anon_sym_long] = ACTIONS(744),
    [anon_sym_char] = ACTIONS(744),
    [anon_sym_float] = ACTIONS(744),
    [anon_sym_double] = ACTIONS(744),
    [sym_boolean_type] = ACTIONS(744),
    [sym_void_type] = ACTIONS(744),
    [sym_this] = ACTIONS(744),
    [sym_super] = ACTIONS(744),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [ts_builtin_sym_end] = ACTIONS(746),
    [sym_identifier] = ACTIONS(748),
    [sym_decimal_integer_literal] = ACTIONS(748),
    [sym_hex_integer_literal] = ACTIONS(748),
    [sym_octal_integer_literal] = ACTIONS(746),
    [sym_binary_integer_literal] = ACTIONS(746),
    [sym_decimal_floating_point_literal] = ACTIONS(746),
    [sym_hex_floating_point_literal] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_character_literal] = ACTIONS(746),
    [sym_string_literal] = ACTIONS(746),
    [sym_null_literal] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(746),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(748),
    [anon_sym_BANG] = ACTIONS(746),
    [anon_sym_TILDE] = ACTIONS(746),
    [anon_sym_PLUS_PLUS] = ACTIONS(746),
    [anon_sym_DASH_DASH] = ACTIONS(746),
    [anon_sym_new] = ACTIONS(748),
    [anon_sym_class] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_RBRACE] = ACTIONS(746),
    [anon_sym_assert] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_case] = ACTIONS(748),
    [anon_sym_default] = ACTIONS(748),
    [anon_sym_do] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_break] = ACTIONS(748),
    [anon_sym_continue] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_synchronized] = ACTIONS(748),
    [anon_sym_throw] = ACTIONS(748),
    [anon_sym_try] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_AT] = ACTIONS(748),
    [anon_sym_open] = ACTIONS(748),
    [anon_sym_module] = ACTIONS(748),
    [anon_sym_static] = ACTIONS(748),
    [anon_sym_package] = ACTIONS(748),
    [anon_sym_import] = ACTIONS(748),
    [anon_sym_enum] = ACTIONS(748),
    [anon_sym_public] = ACTIONS(748),
    [anon_sym_protected] = ACTIONS(748),
    [anon_sym_private] = ACTIONS(748),
    [anon_sym_abstract] = ACTIONS(748),
    [anon_sym_final] = ACTIONS(748),
    [anon_sym_strictfp] = ACTIONS(748),
    [anon_sym_native] = ACTIONS(748),
    [anon_sym_transient] = ACTIONS(748),
    [anon_sym_volatile] = ACTIONS(748),
    [anon_sym_ATinterface] = ACTIONS(746),
    [anon_sym_interface] = ACTIONS(748),
    [anon_sym_byte] = ACTIONS(748),
    [anon_sym_short] = ACTIONS(748),
    [anon_sym_int] = ACTIONS(748),
    [anon_sym_long] = ACTIONS(748),
    [anon_sym_char] = ACTIONS(748),
    [anon_sym_float] = ACTIONS(748),
    [anon_sym_double] = ACTIONS(748),
    [sym_boolean_type] = ACTIONS(748),
    [sym_void_type] = ACTIONS(748),
    [sym_this] = ACTIONS(748),
    [sym_super] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(750),
    [sym_identifier] = ACTIONS(752),
    [sym_decimal_integer_literal] = ACTIONS(752),
    [sym_hex_integer_literal] = ACTIONS(752),
    [sym_octal_integer_literal] = ACTIONS(750),
    [sym_binary_integer_literal] = ACTIONS(750),
    [sym_decimal_floating_point_literal] = ACTIONS(750),
    [sym_hex_floating_point_literal] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_character_literal] = ACTIONS(750),
    [sym_string_literal] = ACTIONS(750),
    [sym_null_literal] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(750),
    [anon_sym_PLUS] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(752),
    [anon_sym_BANG] = ACTIONS(750),
    [anon_sym_TILDE] = ACTIONS(750),
    [anon_sym_PLUS_PLUS] = ACTIONS(750),
    [anon_sym_DASH_DASH] = ACTIONS(750),
    [anon_sym_new] = ACTIONS(752),
    [anon_sym_class] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_RBRACE] = ACTIONS(750),
    [anon_sym_assert] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_case] = ACTIONS(752),
    [anon_sym_default] = ACTIONS(752),
    [anon_sym_do] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_break] = ACTIONS(752),
    [anon_sym_continue] = ACTIONS(752),
    [anon_sym_return] = ACTIONS(752),
    [anon_sym_synchronized] = ACTIONS(752),
    [anon_sym_throw] = ACTIONS(752),
    [anon_sym_try] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_else] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(752),
    [anon_sym_open] = ACTIONS(752),
    [anon_sym_module] = ACTIONS(752),
    [anon_sym_static] = ACTIONS(752),
    [anon_sym_package] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(752),
    [anon_sym_enum] = ACTIONS(752),
    [anon_sym_public] = ACTIONS(752),
    [anon_sym_protected] = ACTIONS(752),
    [anon_sym_private] = ACTIONS(752),
    [anon_sym_abstract] = ACTIONS(752),
    [anon_sym_final] = ACTIONS(752),
    [anon_sym_strictfp] = ACTIONS(752),
    [anon_sym_native] = ACTIONS(752),
    [anon_sym_transient] = ACTIONS(752),
    [anon_sym_volatile] = ACTIONS(752),
    [anon_sym_ATinterface] = ACTIONS(750),
    [anon_sym_interface] = ACTIONS(752),
    [anon_sym_byte] = ACTIONS(752),
    [anon_sym_short] = ACTIONS(752),
    [anon_sym_int] = ACTIONS(752),
    [anon_sym_long] = ACTIONS(752),
    [anon_sym_char] = ACTIONS(752),
    [anon_sym_float] = ACTIONS(752),
    [anon_sym_double] = ACTIONS(752),
    [sym_boolean_type] = ACTIONS(752),
    [sym_void_type] = ACTIONS(752),
    [sym_this] = ACTIONS(752),
    [sym_super] = ACTIONS(752),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(754),
    [sym_identifier] = ACTIONS(756),
    [sym_decimal_integer_literal] = ACTIONS(756),
    [sym_hex_integer_literal] = ACTIONS(756),
    [sym_octal_integer_literal] = ACTIONS(754),
    [sym_binary_integer_literal] = ACTIONS(754),
    [sym_decimal_floating_point_literal] = ACTIONS(754),
    [sym_hex_floating_point_literal] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_character_literal] = ACTIONS(754),
    [sym_string_literal] = ACTIONS(754),
    [sym_null_literal] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(754),
    [anon_sym_PLUS] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(756),
    [anon_sym_BANG] = ACTIONS(754),
    [anon_sym_TILDE] = ACTIONS(754),
    [anon_sym_PLUS_PLUS] = ACTIONS(754),
    [anon_sym_DASH_DASH] = ACTIONS(754),
    [anon_sym_new] = ACTIONS(756),
    [anon_sym_class] = ACTIONS(756),
    [anon_sym_SEMI] = ACTIONS(754),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_RBRACE] = ACTIONS(754),
    [anon_sym_assert] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_case] = ACTIONS(756),
    [anon_sym_default] = ACTIONS(756),
    [anon_sym_do] = ACTIONS(756),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_break] = ACTIONS(756),
    [anon_sym_continue] = ACTIONS(756),
    [anon_sym_return] = ACTIONS(756),
    [anon_sym_synchronized] = ACTIONS(756),
    [anon_sym_throw] = ACTIONS(756),
    [anon_sym_try] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_else] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_AT] = ACTIONS(756),
    [anon_sym_open] = ACTIONS(756),
    [anon_sym_module] = ACTIONS(756),
    [anon_sym_static] = ACTIONS(756),
    [anon_sym_package] = ACTIONS(756),
    [anon_sym_import] = ACTIONS(756),
    [anon_sym_enum] = ACTIONS(756),
    [anon_sym_public] = ACTIONS(756),
    [anon_sym_protected] = ACTIONS(756),
    [anon_sym_private] = ACTIONS(756),
    [anon_sym_abstract] = ACTIONS(756),
    [anon_sym_final] = ACTIONS(756),
    [anon_sym_strictfp] = ACTIONS(756),
    [anon_sym_native] = ACTIONS(756),
    [anon_sym_transient] = ACTIONS(756),
    [anon_sym_volatile] = ACTIONS(756),
    [anon_sym_ATinterface] = ACTIONS(754),
    [anon_sym_interface] = ACTIONS(756),
    [anon_sym_byte] = ACTIONS(756),
    [anon_sym_short] = ACTIONS(756),
    [anon_sym_int] = ACTIONS(756),
    [anon_sym_long] = ACTIONS(756),
    [anon_sym_char] = ACTIONS(756),
    [anon_sym_float] = ACTIONS(756),
    [anon_sym_double] = ACTIONS(756),
    [sym_boolean_type] = ACTIONS(756),
    [sym_void_type] = ACTIONS(756),
    [sym_this] = ACTIONS(756),
    [sym_super] = ACTIONS(756),
    [sym_comment] = ACTIONS(3),
  },
  [163] = {
    [ts_builtin_sym_end] = ACTIONS(758),
    [sym_identifier] = ACTIONS(760),
    [sym_decimal_integer_literal] = ACTIONS(760),
    [sym_hex_integer_literal] = ACTIONS(760),
    [sym_octal_integer_literal] = ACTIONS(758),
    [sym_binary_integer_literal] = ACTIONS(758),
    [sym_decimal_floating_point_literal] = ACTIONS(758),
    [sym_hex_floating_point_literal] = ACTIONS(760),
    [sym_true] = ACTIONS(760),
    [sym_false] = ACTIONS(760),
    [sym_character_literal] = ACTIONS(758),
    [sym_string_literal] = ACTIONS(758),
    [sym_null_literal] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_BANG] = ACTIONS(758),
    [anon_sym_TILDE] = ACTIONS(758),
    [anon_sym_PLUS_PLUS] = ACTIONS(758),
    [anon_sym_DASH_DASH] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(760),
    [anon_sym_class] = ACTIONS(760),
    [anon_sym_SEMI] = ACTIONS(758),
    [anon_sym_LBRACE] = ACTIONS(758),
    [anon_sym_RBRACE] = ACTIONS(758),
    [anon_sym_assert] = ACTIONS(760),
    [anon_sym_switch] = ACTIONS(760),
    [anon_sym_case] = ACTIONS(760),
    [anon_sym_default] = ACTIONS(760),
    [anon_sym_do] = ACTIONS(760),
    [anon_sym_while] = ACTIONS(760),
    [anon_sym_break] = ACTIONS(760),
    [anon_sym_continue] = ACTIONS(760),
    [anon_sym_return] = ACTIONS(760),
    [anon_sym_synchronized] = ACTIONS(760),
    [anon_sym_throw] = ACTIONS(760),
    [anon_sym_try] = ACTIONS(760),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_else] = ACTIONS(760),
    [anon_sym_for] = ACTIONS(760),
    [anon_sym_AT] = ACTIONS(760),
    [anon_sym_open] = ACTIONS(760),
    [anon_sym_module] = ACTIONS(760),
    [anon_sym_static] = ACTIONS(760),
    [anon_sym_package] = ACTIONS(760),
    [anon_sym_import] = ACTIONS(760),
    [anon_sym_enum] = ACTIONS(760),
    [anon_sym_public] = ACTIONS(760),
    [anon_sym_protected] = ACTIONS(760),
    [anon_sym_private] = ACTIONS(760),
    [anon_sym_abstract] = ACTIONS(760),
    [anon_sym_final] = ACTIONS(760),
    [anon_sym_strictfp] = ACTIONS(760),
    [anon_sym_native] = ACTIONS(760),
    [anon_sym_transient] = ACTIONS(760),
    [anon_sym_volatile] = ACTIONS(760),
    [anon_sym_ATinterface] = ACTIONS(758),
    [anon_sym_interface] = ACTIONS(760),
    [anon_sym_byte] = ACTIONS(760),
    [anon_sym_short] = ACTIONS(760),
    [anon_sym_int] = ACTIONS(760),
    [anon_sym_long] = ACTIONS(760),
    [anon_sym_char] = ACTIONS(760),
    [anon_sym_float] = ACTIONS(760),
    [anon_sym_double] = ACTIONS(760),
    [sym_boolean_type] = ACTIONS(760),
    [sym_void_type] = ACTIONS(760),
    [sym_this] = ACTIONS(760),
    [sym_super] = ACTIONS(760),
    [sym_comment] = ACTIONS(3),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(762),
    [sym_identifier] = ACTIONS(764),
    [sym_decimal_integer_literal] = ACTIONS(764),
    [sym_hex_integer_literal] = ACTIONS(764),
    [sym_octal_integer_literal] = ACTIONS(762),
    [sym_binary_integer_literal] = ACTIONS(762),
    [sym_decimal_floating_point_literal] = ACTIONS(762),
    [sym_hex_floating_point_literal] = ACTIONS(764),
    [sym_true] = ACTIONS(764),
    [sym_false] = ACTIONS(764),
    [sym_character_literal] = ACTIONS(762),
    [sym_string_literal] = ACTIONS(762),
    [sym_null_literal] = ACTIONS(764),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_PLUS] = ACTIONS(764),
    [anon_sym_DASH] = ACTIONS(764),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(762),
    [anon_sym_PLUS_PLUS] = ACTIONS(762),
    [anon_sym_DASH_DASH] = ACTIONS(762),
    [anon_sym_new] = ACTIONS(764),
    [anon_sym_class] = ACTIONS(764),
    [anon_sym_SEMI] = ACTIONS(762),
    [anon_sym_LBRACE] = ACTIONS(762),
    [anon_sym_RBRACE] = ACTIONS(762),
    [anon_sym_assert] = ACTIONS(764),
    [anon_sym_switch] = ACTIONS(764),
    [anon_sym_case] = ACTIONS(764),
    [anon_sym_default] = ACTIONS(764),
    [anon_sym_do] = ACTIONS(764),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_break] = ACTIONS(764),
    [anon_sym_continue] = ACTIONS(764),
    [anon_sym_return] = ACTIONS(764),
    [anon_sym_synchronized] = ACTIONS(764),
    [anon_sym_throw] = ACTIONS(764),
    [anon_sym_try] = ACTIONS(764),
    [anon_sym_if] = ACTIONS(764),
    [anon_sym_else] = ACTIONS(764),
    [anon_sym_for] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(764),
    [anon_sym_open] = ACTIONS(764),
    [anon_sym_module] = ACTIONS(764),
    [anon_sym_static] = ACTIONS(764),
    [anon_sym_package] = ACTIONS(764),
    [anon_sym_import] = ACTIONS(764),
    [anon_sym_enum] = ACTIONS(764),
    [anon_sym_public] = ACTIONS(764),
    [anon_sym_protected] = ACTIONS(764),
    [anon_sym_private] = ACTIONS(764),
    [anon_sym_abstract] = ACTIONS(764),
    [anon_sym_final] = ACTIONS(764),
    [anon_sym_strictfp] = ACTIONS(764),
    [anon_sym_native] = ACTIONS(764),
    [anon_sym_transient] = ACTIONS(764),
    [anon_sym_volatile] = ACTIONS(764),
    [anon_sym_ATinterface] = ACTIONS(762),
    [anon_sym_interface] = ACTIONS(764),
    [anon_sym_byte] = ACTIONS(764),
    [anon_sym_short] = ACTIONS(764),
    [anon_sym_int] = ACTIONS(764),
    [anon_sym_long] = ACTIONS(764),
    [anon_sym_char] = ACTIONS(764),
    [anon_sym_float] = ACTIONS(764),
    [anon_sym_double] = ACTIONS(764),
    [sym_boolean_type] = ACTIONS(764),
    [sym_void_type] = ACTIONS(764),
    [sym_this] = ACTIONS(764),
    [sym_super] = ACTIONS(764),
    [sym_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(766),
    [sym_identifier] = ACTIONS(768),
    [sym_decimal_integer_literal] = ACTIONS(768),
    [sym_hex_integer_literal] = ACTIONS(768),
    [sym_octal_integer_literal] = ACTIONS(766),
    [sym_binary_integer_literal] = ACTIONS(766),
    [sym_decimal_floating_point_literal] = ACTIONS(766),
    [sym_hex_floating_point_literal] = ACTIONS(768),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_character_literal] = ACTIONS(766),
    [sym_string_literal] = ACTIONS(766),
    [sym_null_literal] = ACTIONS(768),
    [anon_sym_LPAREN] = ACTIONS(766),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(766),
    [anon_sym_TILDE] = ACTIONS(766),
    [anon_sym_PLUS_PLUS] = ACTIONS(766),
    [anon_sym_DASH_DASH] = ACTIONS(766),
    [anon_sym_new] = ACTIONS(768),
    [anon_sym_class] = ACTIONS(768),
    [anon_sym_SEMI] = ACTIONS(766),
    [anon_sym_LBRACE] = ACTIONS(766),
    [anon_sym_RBRACE] = ACTIONS(766),
    [anon_sym_assert] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(768),
    [anon_sym_case] = ACTIONS(768),
    [anon_sym_default] = ACTIONS(768),
    [anon_sym_do] = ACTIONS(768),
    [anon_sym_while] = ACTIONS(768),
    [anon_sym_break] = ACTIONS(768),
    [anon_sym_continue] = ACTIONS(768),
    [anon_sym_return] = ACTIONS(768),
    [anon_sym_synchronized] = ACTIONS(768),
    [anon_sym_throw] = ACTIONS(768),
    [anon_sym_try] = ACTIONS(768),
    [anon_sym_if] = ACTIONS(768),
    [anon_sym_else] = ACTIONS(768),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_AT] = ACTIONS(768),
    [anon_sym_open] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_package] = ACTIONS(768),
    [anon_sym_import] = ACTIONS(768),
    [anon_sym_enum] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_abstract] = ACTIONS(768),
    [anon_sym_final] = ACTIONS(768),
    [anon_sym_strictfp] = ACTIONS(768),
    [anon_sym_native] = ACTIONS(768),
    [anon_sym_transient] = ACTIONS(768),
    [anon_sym_volatile] = ACTIONS(768),
    [anon_sym_ATinterface] = ACTIONS(766),
    [anon_sym_interface] = ACTIONS(768),
    [anon_sym_byte] = ACTIONS(768),
    [anon_sym_short] = ACTIONS(768),
    [anon_sym_int] = ACTIONS(768),
    [anon_sym_long] = ACTIONS(768),
    [anon_sym_char] = ACTIONS(768),
    [anon_sym_float] = ACTIONS(768),
    [anon_sym_double] = ACTIONS(768),
    [sym_boolean_type] = ACTIONS(768),
    [sym_void_type] = ACTIONS(768),
    [sym_this] = ACTIONS(768),
    [sym_super] = ACTIONS(768),
    [sym_comment] = ACTIONS(3),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(770),
    [sym_identifier] = ACTIONS(772),
    [sym_decimal_integer_literal] = ACTIONS(772),
    [sym_hex_integer_literal] = ACTIONS(772),
    [sym_octal_integer_literal] = ACTIONS(770),
    [sym_binary_integer_literal] = ACTIONS(770),
    [sym_decimal_floating_point_literal] = ACTIONS(770),
    [sym_hex_floating_point_literal] = ACTIONS(772),
    [sym_true] = ACTIONS(772),
    [sym_false] = ACTIONS(772),
    [sym_character_literal] = ACTIONS(770),
    [sym_string_literal] = ACTIONS(770),
    [sym_null_literal] = ACTIONS(772),
    [anon_sym_LPAREN] = ACTIONS(770),
    [anon_sym_PLUS] = ACTIONS(772),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_BANG] = ACTIONS(770),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_PLUS_PLUS] = ACTIONS(770),
    [anon_sym_DASH_DASH] = ACTIONS(770),
    [anon_sym_new] = ACTIONS(772),
    [anon_sym_class] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(770),
    [anon_sym_RBRACE] = ACTIONS(770),
    [anon_sym_assert] = ACTIONS(772),
    [anon_sym_switch] = ACTIONS(772),
    [anon_sym_case] = ACTIONS(772),
    [anon_sym_default] = ACTIONS(772),
    [anon_sym_do] = ACTIONS(772),
    [anon_sym_while] = ACTIONS(772),
    [anon_sym_break] = ACTIONS(772),
    [anon_sym_continue] = ACTIONS(772),
    [anon_sym_return] = ACTIONS(772),
    [anon_sym_synchronized] = ACTIONS(772),
    [anon_sym_throw] = ACTIONS(772),
    [anon_sym_try] = ACTIONS(772),
    [anon_sym_if] = ACTIONS(772),
    [anon_sym_else] = ACTIONS(772),
    [anon_sym_for] = ACTIONS(772),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_open] = ACTIONS(772),
    [anon_sym_module] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(772),
    [anon_sym_package] = ACTIONS(772),
    [anon_sym_import] = ACTIONS(772),
    [anon_sym_enum] = ACTIONS(772),
    [anon_sym_public] = ACTIONS(772),
    [anon_sym_protected] = ACTIONS(772),
    [anon_sym_private] = ACTIONS(772),
    [anon_sym_abstract] = ACTIONS(772),
    [anon_sym_final] = ACTIONS(772),
    [anon_sym_strictfp] = ACTIONS(772),
    [anon_sym_native] = ACTIONS(772),
    [anon_sym_transient] = ACTIONS(772),
    [anon_sym_volatile] = ACTIONS(772),
    [anon_sym_ATinterface] = ACTIONS(770),
    [anon_sym_interface] = ACTIONS(772),
    [anon_sym_byte] = ACTIONS(772),
    [anon_sym_short] = ACTIONS(772),
    [anon_sym_int] = ACTIONS(772),
    [anon_sym_long] = ACTIONS(772),
    [anon_sym_char] = ACTIONS(772),
    [anon_sym_float] = ACTIONS(772),
    [anon_sym_double] = ACTIONS(772),
    [sym_boolean_type] = ACTIONS(772),
    [sym_void_type] = ACTIONS(772),
    [sym_this] = ACTIONS(772),
    [sym_super] = ACTIONS(772),
    [sym_comment] = ACTIONS(3),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(774),
    [sym_identifier] = ACTIONS(776),
    [sym_decimal_integer_literal] = ACTIONS(776),
    [sym_hex_integer_literal] = ACTIONS(776),
    [sym_octal_integer_literal] = ACTIONS(774),
    [sym_binary_integer_literal] = ACTIONS(774),
    [sym_decimal_floating_point_literal] = ACTIONS(774),
    [sym_hex_floating_point_literal] = ACTIONS(776),
    [sym_true] = ACTIONS(776),
    [sym_false] = ACTIONS(776),
    [sym_character_literal] = ACTIONS(774),
    [sym_string_literal] = ACTIONS(774),
    [sym_null_literal] = ACTIONS(776),
    [anon_sym_LPAREN] = ACTIONS(774),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(774),
    [anon_sym_TILDE] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(774),
    [anon_sym_DASH_DASH] = ACTIONS(774),
    [anon_sym_new] = ACTIONS(776),
    [anon_sym_class] = ACTIONS(776),
    [anon_sym_SEMI] = ACTIONS(774),
    [anon_sym_LBRACE] = ACTIONS(774),
    [anon_sym_RBRACE] = ACTIONS(774),
    [anon_sym_assert] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(776),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_do] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(776),
    [anon_sym_break] = ACTIONS(776),
    [anon_sym_continue] = ACTIONS(776),
    [anon_sym_return] = ACTIONS(776),
    [anon_sym_synchronized] = ACTIONS(776),
    [anon_sym_throw] = ACTIONS(776),
    [anon_sym_try] = ACTIONS(776),
    [anon_sym_if] = ACTIONS(776),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_for] = ACTIONS(776),
    [anon_sym_AT] = ACTIONS(776),
    [anon_sym_open] = ACTIONS(776),
    [anon_sym_module] = ACTIONS(776),
    [anon_sym_static] = ACTIONS(776),
    [anon_sym_package] = ACTIONS(776),
    [anon_sym_import] = ACTIONS(776),
    [anon_sym_enum] = ACTIONS(776),
    [anon_sym_public] = ACTIONS(776),
    [anon_sym_protected] = ACTIONS(776),
    [anon_sym_private] = ACTIONS(776),
    [anon_sym_abstract] = ACTIONS(776),
    [anon_sym_final] = ACTIONS(776),
    [anon_sym_strictfp] = ACTIONS(776),
    [anon_sym_native] = ACTIONS(776),
    [anon_sym_transient] = ACTIONS(776),
    [anon_sym_volatile] = ACTIONS(776),
    [anon_sym_ATinterface] = ACTIONS(774),
    [anon_sym_interface] = ACTIONS(776),
    [anon_sym_byte] = ACTIONS(776),
    [anon_sym_short] = ACTIONS(776),
    [anon_sym_int] = ACTIONS(776),
    [anon_sym_long] = ACTIONS(776),
    [anon_sym_char] = ACTIONS(776),
    [anon_sym_float] = ACTIONS(776),
    [anon_sym_double] = ACTIONS(776),
    [sym_boolean_type] = ACTIONS(776),
    [sym_void_type] = ACTIONS(776),
    [sym_this] = ACTIONS(776),
    [sym_super] = ACTIONS(776),
    [sym_comment] = ACTIONS(3),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(778),
    [sym_identifier] = ACTIONS(780),
    [sym_decimal_integer_literal] = ACTIONS(780),
    [sym_hex_integer_literal] = ACTIONS(780),
    [sym_octal_integer_literal] = ACTIONS(778),
    [sym_binary_integer_literal] = ACTIONS(778),
    [sym_decimal_floating_point_literal] = ACTIONS(778),
    [sym_hex_floating_point_literal] = ACTIONS(780),
    [sym_true] = ACTIONS(780),
    [sym_false] = ACTIONS(780),
    [sym_character_literal] = ACTIONS(778),
    [sym_string_literal] = ACTIONS(778),
    [sym_null_literal] = ACTIONS(780),
    [anon_sym_LPAREN] = ACTIONS(778),
    [anon_sym_PLUS] = ACTIONS(780),
    [anon_sym_DASH] = ACTIONS(780),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(778),
    [anon_sym_PLUS_PLUS] = ACTIONS(778),
    [anon_sym_DASH_DASH] = ACTIONS(778),
    [anon_sym_new] = ACTIONS(780),
    [anon_sym_class] = ACTIONS(780),
    [anon_sym_SEMI] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(778),
    [anon_sym_RBRACE] = ACTIONS(778),
    [anon_sym_assert] = ACTIONS(780),
    [anon_sym_switch] = ACTIONS(780),
    [anon_sym_case] = ACTIONS(780),
    [anon_sym_default] = ACTIONS(780),
    [anon_sym_do] = ACTIONS(780),
    [anon_sym_while] = ACTIONS(780),
    [anon_sym_break] = ACTIONS(780),
    [anon_sym_continue] = ACTIONS(780),
    [anon_sym_return] = ACTIONS(780),
    [anon_sym_synchronized] = ACTIONS(780),
    [anon_sym_throw] = ACTIONS(780),
    [anon_sym_try] = ACTIONS(780),
    [anon_sym_if] = ACTIONS(780),
    [anon_sym_else] = ACTIONS(780),
    [anon_sym_for] = ACTIONS(780),
    [anon_sym_AT] = ACTIONS(780),
    [anon_sym_open] = ACTIONS(780),
    [anon_sym_module] = ACTIONS(780),
    [anon_sym_static] = ACTIONS(780),
    [anon_sym_package] = ACTIONS(780),
    [anon_sym_import] = ACTIONS(780),
    [anon_sym_enum] = ACTIONS(780),
    [anon_sym_public] = ACTIONS(780),
    [anon_sym_protected] = ACTIONS(780),
    [anon_sym_private] = ACTIONS(780),
    [anon_sym_abstract] = ACTIONS(780),
    [anon_sym_final] = ACTIONS(780),
    [anon_sym_strictfp] = ACTIONS(780),
    [anon_sym_native] = ACTIONS(780),
    [anon_sym_transient] = ACTIONS(780),
    [anon_sym_volatile] = ACTIONS(780),
    [anon_sym_ATinterface] = ACTIONS(778),
    [anon_sym_interface] = ACTIONS(780),
    [anon_sym_byte] = ACTIONS(780),
    [anon_sym_short] = ACTIONS(780),
    [anon_sym_int] = ACTIONS(780),
    [anon_sym_long] = ACTIONS(780),
    [anon_sym_char] = ACTIONS(780),
    [anon_sym_float] = ACTIONS(780),
    [anon_sym_double] = ACTIONS(780),
    [sym_boolean_type] = ACTIONS(780),
    [sym_void_type] = ACTIONS(780),
    [sym_this] = ACTIONS(780),
    [sym_super] = ACTIONS(780),
    [sym_comment] = ACTIONS(3),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(782),
    [sym_identifier] = ACTIONS(784),
    [sym_decimal_integer_literal] = ACTIONS(784),
    [sym_hex_integer_literal] = ACTIONS(784),
    [sym_octal_integer_literal] = ACTIONS(782),
    [sym_binary_integer_literal] = ACTIONS(782),
    [sym_decimal_floating_point_literal] = ACTIONS(782),
    [sym_hex_floating_point_literal] = ACTIONS(784),
    [sym_true] = ACTIONS(784),
    [sym_false] = ACTIONS(784),
    [sym_character_literal] = ACTIONS(782),
    [sym_string_literal] = ACTIONS(782),
    [sym_null_literal] = ACTIONS(784),
    [anon_sym_LPAREN] = ACTIONS(782),
    [anon_sym_PLUS] = ACTIONS(784),
    [anon_sym_DASH] = ACTIONS(784),
    [anon_sym_BANG] = ACTIONS(782),
    [anon_sym_TILDE] = ACTIONS(782),
    [anon_sym_PLUS_PLUS] = ACTIONS(782),
    [anon_sym_DASH_DASH] = ACTIONS(782),
    [anon_sym_new] = ACTIONS(784),
    [anon_sym_class] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [anon_sym_LBRACE] = ACTIONS(782),
    [anon_sym_RBRACE] = ACTIONS(782),
    [anon_sym_assert] = ACTIONS(784),
    [anon_sym_switch] = ACTIONS(784),
    [anon_sym_case] = ACTIONS(784),
    [anon_sym_default] = ACTIONS(784),
    [anon_sym_do] = ACTIONS(784),
    [anon_sym_while] = ACTIONS(784),
    [anon_sym_break] = ACTIONS(784),
    [anon_sym_continue] = ACTIONS(784),
    [anon_sym_return] = ACTIONS(784),
    [anon_sym_synchronized] = ACTIONS(784),
    [anon_sym_throw] = ACTIONS(784),
    [anon_sym_try] = ACTIONS(784),
    [anon_sym_if] = ACTIONS(784),
    [anon_sym_else] = ACTIONS(784),
    [anon_sym_for] = ACTIONS(784),
    [anon_sym_AT] = ACTIONS(784),
    [anon_sym_open] = ACTIONS(784),
    [anon_sym_module] = ACTIONS(784),
    [anon_sym_static] = ACTIONS(784),
    [anon_sym_package] = ACTIONS(784),
    [anon_sym_import] = ACTIONS(784),
    [anon_sym_enum] = ACTIONS(784),
    [anon_sym_public] = ACTIONS(784),
    [anon_sym_protected] = ACTIONS(784),
    [anon_sym_private] = ACTIONS(784),
    [anon_sym_abstract] = ACTIONS(784),
    [anon_sym_final] = ACTIONS(784),
    [anon_sym_strictfp] = ACTIONS(784),
    [anon_sym_native] = ACTIONS(784),
    [anon_sym_transient] = ACTIONS(784),
    [anon_sym_volatile] = ACTIONS(784),
    [anon_sym_ATinterface] = ACTIONS(782),
    [anon_sym_interface] = ACTIONS(784),
    [anon_sym_byte] = ACTIONS(784),
    [anon_sym_short] = ACTIONS(784),
    [anon_sym_int] = ACTIONS(784),
    [anon_sym_long] = ACTIONS(784),
    [anon_sym_char] = ACTIONS(784),
    [anon_sym_float] = ACTIONS(784),
    [anon_sym_double] = ACTIONS(784),
    [sym_boolean_type] = ACTIONS(784),
    [sym_void_type] = ACTIONS(784),
    [sym_this] = ACTIONS(784),
    [sym_super] = ACTIONS(784),
    [sym_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(786),
    [sym_identifier] = ACTIONS(788),
    [sym_decimal_integer_literal] = ACTIONS(788),
    [sym_hex_integer_literal] = ACTIONS(788),
    [sym_octal_integer_literal] = ACTIONS(786),
    [sym_binary_integer_literal] = ACTIONS(786),
    [sym_decimal_floating_point_literal] = ACTIONS(786),
    [sym_hex_floating_point_literal] = ACTIONS(788),
    [sym_true] = ACTIONS(788),
    [sym_false] = ACTIONS(788),
    [sym_character_literal] = ACTIONS(786),
    [sym_string_literal] = ACTIONS(786),
    [sym_null_literal] = ACTIONS(788),
    [anon_sym_LPAREN] = ACTIONS(786),
    [anon_sym_PLUS] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(788),
    [anon_sym_BANG] = ACTIONS(786),
    [anon_sym_TILDE] = ACTIONS(786),
    [anon_sym_PLUS_PLUS] = ACTIONS(786),
    [anon_sym_DASH_DASH] = ACTIONS(786),
    [anon_sym_new] = ACTIONS(788),
    [anon_sym_class] = ACTIONS(788),
    [anon_sym_SEMI] = ACTIONS(786),
    [anon_sym_LBRACE] = ACTIONS(786),
    [anon_sym_RBRACE] = ACTIONS(786),
    [anon_sym_assert] = ACTIONS(788),
    [anon_sym_switch] = ACTIONS(788),
    [anon_sym_case] = ACTIONS(788),
    [anon_sym_default] = ACTIONS(788),
    [anon_sym_do] = ACTIONS(788),
    [anon_sym_while] = ACTIONS(788),
    [anon_sym_break] = ACTIONS(788),
    [anon_sym_continue] = ACTIONS(788),
    [anon_sym_return] = ACTIONS(788),
    [anon_sym_synchronized] = ACTIONS(788),
    [anon_sym_throw] = ACTIONS(788),
    [anon_sym_try] = ACTIONS(788),
    [anon_sym_if] = ACTIONS(788),
    [anon_sym_else] = ACTIONS(788),
    [anon_sym_for] = ACTIONS(788),
    [anon_sym_AT] = ACTIONS(788),
    [anon_sym_open] = ACTIONS(788),
    [anon_sym_module] = ACTIONS(788),
    [anon_sym_static] = ACTIONS(788),
    [anon_sym_package] = ACTIONS(788),
    [anon_sym_import] = ACTIONS(788),
    [anon_sym_enum] = ACTIONS(788),
    [anon_sym_public] = ACTIONS(788),
    [anon_sym_protected] = ACTIONS(788),
    [anon_sym_private] = ACTIONS(788),
    [anon_sym_abstract] = ACTIONS(788),
    [anon_sym_final] = ACTIONS(788),
    [anon_sym_strictfp] = ACTIONS(788),
    [anon_sym_native] = ACTIONS(788),
    [anon_sym_transient] = ACTIONS(788),
    [anon_sym_volatile] = ACTIONS(788),
    [anon_sym_ATinterface] = ACTIONS(786),
    [anon_sym_interface] = ACTIONS(788),
    [anon_sym_byte] = ACTIONS(788),
    [anon_sym_short] = ACTIONS(788),
    [anon_sym_int] = ACTIONS(788),
    [anon_sym_long] = ACTIONS(788),
    [anon_sym_char] = ACTIONS(788),
    [anon_sym_float] = ACTIONS(788),
    [anon_sym_double] = ACTIONS(788),
    [sym_boolean_type] = ACTIONS(788),
    [sym_void_type] = ACTIONS(788),
    [sym_this] = ACTIONS(788),
    [sym_super] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
  },
  [171] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(463),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(790),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [172] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(456),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(792),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(794),
    [sym_identifier] = ACTIONS(796),
    [sym_decimal_integer_literal] = ACTIONS(796),
    [sym_hex_integer_literal] = ACTIONS(796),
    [sym_octal_integer_literal] = ACTIONS(794),
    [sym_binary_integer_literal] = ACTIONS(794),
    [sym_decimal_floating_point_literal] = ACTIONS(794),
    [sym_hex_floating_point_literal] = ACTIONS(796),
    [sym_true] = ACTIONS(796),
    [sym_false] = ACTIONS(796),
    [sym_character_literal] = ACTIONS(794),
    [sym_string_literal] = ACTIONS(794),
    [sym_null_literal] = ACTIONS(796),
    [anon_sym_LPAREN] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(796),
    [anon_sym_DASH] = ACTIONS(796),
    [anon_sym_BANG] = ACTIONS(794),
    [anon_sym_TILDE] = ACTIONS(794),
    [anon_sym_PLUS_PLUS] = ACTIONS(794),
    [anon_sym_DASH_DASH] = ACTIONS(794),
    [anon_sym_new] = ACTIONS(796),
    [anon_sym_class] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(794),
    [anon_sym_LBRACE] = ACTIONS(794),
    [anon_sym_RBRACE] = ACTIONS(794),
    [anon_sym_assert] = ACTIONS(796),
    [anon_sym_switch] = ACTIONS(796),
    [anon_sym_case] = ACTIONS(796),
    [anon_sym_default] = ACTIONS(796),
    [anon_sym_do] = ACTIONS(796),
    [anon_sym_while] = ACTIONS(796),
    [anon_sym_break] = ACTIONS(796),
    [anon_sym_continue] = ACTIONS(796),
    [anon_sym_return] = ACTIONS(796),
    [anon_sym_synchronized] = ACTIONS(796),
    [anon_sym_throw] = ACTIONS(796),
    [anon_sym_try] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(796),
    [anon_sym_else] = ACTIONS(798),
    [anon_sym_for] = ACTIONS(796),
    [anon_sym_AT] = ACTIONS(796),
    [anon_sym_open] = ACTIONS(796),
    [anon_sym_module] = ACTIONS(796),
    [anon_sym_static] = ACTIONS(796),
    [anon_sym_package] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(796),
    [anon_sym_enum] = ACTIONS(796),
    [anon_sym_public] = ACTIONS(796),
    [anon_sym_protected] = ACTIONS(796),
    [anon_sym_private] = ACTIONS(796),
    [anon_sym_abstract] = ACTIONS(796),
    [anon_sym_final] = ACTIONS(796),
    [anon_sym_strictfp] = ACTIONS(796),
    [anon_sym_native] = ACTIONS(796),
    [anon_sym_transient] = ACTIONS(796),
    [anon_sym_volatile] = ACTIONS(796),
    [anon_sym_ATinterface] = ACTIONS(794),
    [anon_sym_interface] = ACTIONS(796),
    [anon_sym_byte] = ACTIONS(796),
    [anon_sym_short] = ACTIONS(796),
    [anon_sym_int] = ACTIONS(796),
    [anon_sym_long] = ACTIONS(796),
    [anon_sym_char] = ACTIONS(796),
    [anon_sym_float] = ACTIONS(796),
    [anon_sym_double] = ACTIONS(796),
    [sym_boolean_type] = ACTIONS(796),
    [sym_void_type] = ACTIONS(796),
    [sym_this] = ACTIONS(796),
    [sym_super] = ACTIONS(796),
    [sym_comment] = ACTIONS(3),
  },
  [174] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [sym_decimal_integer_literal] = ACTIONS(802),
    [sym_hex_integer_literal] = ACTIONS(802),
    [sym_octal_integer_literal] = ACTIONS(800),
    [sym_binary_integer_literal] = ACTIONS(800),
    [sym_decimal_floating_point_literal] = ACTIONS(800),
    [sym_hex_floating_point_literal] = ACTIONS(802),
    [sym_true] = ACTIONS(802),
    [sym_false] = ACTIONS(802),
    [sym_character_literal] = ACTIONS(800),
    [sym_string_literal] = ACTIONS(800),
    [sym_null_literal] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_PLUS] = ACTIONS(802),
    [anon_sym_DASH] = ACTIONS(802),
    [anon_sym_BANG] = ACTIONS(800),
    [anon_sym_TILDE] = ACTIONS(800),
    [anon_sym_PLUS_PLUS] = ACTIONS(800),
    [anon_sym_DASH_DASH] = ACTIONS(800),
    [anon_sym_new] = ACTIONS(802),
    [anon_sym_class] = ACTIONS(802),
    [anon_sym_SEMI] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_assert] = ACTIONS(802),
    [anon_sym_switch] = ACTIONS(802),
    [anon_sym_case] = ACTIONS(802),
    [anon_sym_default] = ACTIONS(802),
    [anon_sym_do] = ACTIONS(802),
    [anon_sym_while] = ACTIONS(802),
    [anon_sym_break] = ACTIONS(802),
    [anon_sym_continue] = ACTIONS(802),
    [anon_sym_return] = ACTIONS(802),
    [anon_sym_synchronized] = ACTIONS(802),
    [anon_sym_throw] = ACTIONS(802),
    [anon_sym_try] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_else] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(802),
    [anon_sym_open] = ACTIONS(802),
    [anon_sym_module] = ACTIONS(802),
    [anon_sym_static] = ACTIONS(802),
    [anon_sym_package] = ACTIONS(802),
    [anon_sym_import] = ACTIONS(802),
    [anon_sym_enum] = ACTIONS(802),
    [anon_sym_public] = ACTIONS(802),
    [anon_sym_protected] = ACTIONS(802),
    [anon_sym_private] = ACTIONS(802),
    [anon_sym_abstract] = ACTIONS(802),
    [anon_sym_final] = ACTIONS(802),
    [anon_sym_strictfp] = ACTIONS(802),
    [anon_sym_native] = ACTIONS(802),
    [anon_sym_transient] = ACTIONS(802),
    [anon_sym_volatile] = ACTIONS(802),
    [anon_sym_ATinterface] = ACTIONS(800),
    [anon_sym_interface] = ACTIONS(802),
    [anon_sym_byte] = ACTIONS(802),
    [anon_sym_short] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_long] = ACTIONS(802),
    [anon_sym_char] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_double] = ACTIONS(802),
    [sym_boolean_type] = ACTIONS(802),
    [sym_void_type] = ACTIONS(802),
    [sym_this] = ACTIONS(802),
    [sym_super] = ACTIONS(802),
    [sym_comment] = ACTIONS(3),
  },
  [175] = {
    [ts_builtin_sym_end] = ACTIONS(804),
    [sym_identifier] = ACTIONS(806),
    [sym_decimal_integer_literal] = ACTIONS(806),
    [sym_hex_integer_literal] = ACTIONS(806),
    [sym_octal_integer_literal] = ACTIONS(804),
    [sym_binary_integer_literal] = ACTIONS(804),
    [sym_decimal_floating_point_literal] = ACTIONS(804),
    [sym_hex_floating_point_literal] = ACTIONS(806),
    [sym_true] = ACTIONS(806),
    [sym_false] = ACTIONS(806),
    [sym_character_literal] = ACTIONS(804),
    [sym_string_literal] = ACTIONS(804),
    [sym_null_literal] = ACTIONS(806),
    [anon_sym_LPAREN] = ACTIONS(804),
    [anon_sym_PLUS] = ACTIONS(806),
    [anon_sym_DASH] = ACTIONS(806),
    [anon_sym_BANG] = ACTIONS(804),
    [anon_sym_TILDE] = ACTIONS(804),
    [anon_sym_PLUS_PLUS] = ACTIONS(804),
    [anon_sym_DASH_DASH] = ACTIONS(804),
    [anon_sym_new] = ACTIONS(806),
    [anon_sym_class] = ACTIONS(806),
    [anon_sym_SEMI] = ACTIONS(804),
    [anon_sym_LBRACE] = ACTIONS(804),
    [anon_sym_RBRACE] = ACTIONS(804),
    [anon_sym_assert] = ACTIONS(806),
    [anon_sym_switch] = ACTIONS(806),
    [anon_sym_case] = ACTIONS(806),
    [anon_sym_default] = ACTIONS(806),
    [anon_sym_do] = ACTIONS(806),
    [anon_sym_while] = ACTIONS(806),
    [anon_sym_break] = ACTIONS(806),
    [anon_sym_continue] = ACTIONS(806),
    [anon_sym_return] = ACTIONS(806),
    [anon_sym_synchronized] = ACTIONS(806),
    [anon_sym_throw] = ACTIONS(806),
    [anon_sym_try] = ACTIONS(806),
    [anon_sym_if] = ACTIONS(806),
    [anon_sym_else] = ACTIONS(806),
    [anon_sym_for] = ACTIONS(806),
    [anon_sym_AT] = ACTIONS(806),
    [anon_sym_open] = ACTIONS(806),
    [anon_sym_module] = ACTIONS(806),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_package] = ACTIONS(806),
    [anon_sym_import] = ACTIONS(806),
    [anon_sym_enum] = ACTIONS(806),
    [anon_sym_public] = ACTIONS(806),
    [anon_sym_protected] = ACTIONS(806),
    [anon_sym_private] = ACTIONS(806),
    [anon_sym_abstract] = ACTIONS(806),
    [anon_sym_final] = ACTIONS(806),
    [anon_sym_strictfp] = ACTIONS(806),
    [anon_sym_native] = ACTIONS(806),
    [anon_sym_transient] = ACTIONS(806),
    [anon_sym_volatile] = ACTIONS(806),
    [anon_sym_ATinterface] = ACTIONS(804),
    [anon_sym_interface] = ACTIONS(806),
    [anon_sym_byte] = ACTIONS(806),
    [anon_sym_short] = ACTIONS(806),
    [anon_sym_int] = ACTIONS(806),
    [anon_sym_long] = ACTIONS(806),
    [anon_sym_char] = ACTIONS(806),
    [anon_sym_float] = ACTIONS(806),
    [anon_sym_double] = ACTIONS(806),
    [sym_boolean_type] = ACTIONS(806),
    [sym_void_type] = ACTIONS(806),
    [sym_this] = ACTIONS(806),
    [sym_super] = ACTIONS(806),
    [sym_comment] = ACTIONS(3),
  },
  [176] = {
    [ts_builtin_sym_end] = ACTIONS(377),
    [sym_identifier] = ACTIONS(379),
    [sym_decimal_integer_literal] = ACTIONS(379),
    [sym_hex_integer_literal] = ACTIONS(379),
    [sym_octal_integer_literal] = ACTIONS(377),
    [sym_binary_integer_literal] = ACTIONS(377),
    [sym_decimal_floating_point_literal] = ACTIONS(377),
    [sym_hex_floating_point_literal] = ACTIONS(379),
    [sym_true] = ACTIONS(379),
    [sym_false] = ACTIONS(379),
    [sym_character_literal] = ACTIONS(377),
    [sym_string_literal] = ACTIONS(377),
    [sym_null_literal] = ACTIONS(379),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(377),
    [anon_sym_PLUS_PLUS] = ACTIONS(377),
    [anon_sym_DASH_DASH] = ACTIONS(377),
    [anon_sym_new] = ACTIONS(379),
    [anon_sym_class] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_RBRACE] = ACTIONS(377),
    [anon_sym_assert] = ACTIONS(379),
    [anon_sym_switch] = ACTIONS(379),
    [anon_sym_case] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(379),
    [anon_sym_do] = ACTIONS(379),
    [anon_sym_while] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(379),
    [anon_sym_return] = ACTIONS(379),
    [anon_sym_synchronized] = ACTIONS(379),
    [anon_sym_throw] = ACTIONS(379),
    [anon_sym_try] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_else] = ACTIONS(379),
    [anon_sym_for] = ACTIONS(379),
    [anon_sym_AT] = ACTIONS(379),
    [anon_sym_open] = ACTIONS(379),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_package] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(379),
    [anon_sym_enum] = ACTIONS(379),
    [anon_sym_public] = ACTIONS(379),
    [anon_sym_protected] = ACTIONS(379),
    [anon_sym_private] = ACTIONS(379),
    [anon_sym_abstract] = ACTIONS(379),
    [anon_sym_final] = ACTIONS(379),
    [anon_sym_strictfp] = ACTIONS(379),
    [anon_sym_native] = ACTIONS(379),
    [anon_sym_transient] = ACTIONS(379),
    [anon_sym_volatile] = ACTIONS(379),
    [anon_sym_ATinterface] = ACTIONS(377),
    [anon_sym_interface] = ACTIONS(379),
    [anon_sym_byte] = ACTIONS(379),
    [anon_sym_short] = ACTIONS(379),
    [anon_sym_int] = ACTIONS(379),
    [anon_sym_long] = ACTIONS(379),
    [anon_sym_char] = ACTIONS(379),
    [anon_sym_float] = ACTIONS(379),
    [anon_sym_double] = ACTIONS(379),
    [sym_boolean_type] = ACTIONS(379),
    [sym_void_type] = ACTIONS(379),
    [sym_this] = ACTIONS(379),
    [sym_super] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
  },
  [177] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(442),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(808),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [178] = {
    [ts_builtin_sym_end] = ACTIONS(810),
    [sym_identifier] = ACTIONS(812),
    [sym_decimal_integer_literal] = ACTIONS(812),
    [sym_hex_integer_literal] = ACTIONS(812),
    [sym_octal_integer_literal] = ACTIONS(810),
    [sym_binary_integer_literal] = ACTIONS(810),
    [sym_decimal_floating_point_literal] = ACTIONS(810),
    [sym_hex_floating_point_literal] = ACTIONS(812),
    [sym_true] = ACTIONS(812),
    [sym_false] = ACTIONS(812),
    [sym_character_literal] = ACTIONS(810),
    [sym_string_literal] = ACTIONS(810),
    [sym_null_literal] = ACTIONS(812),
    [anon_sym_LPAREN] = ACTIONS(810),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_BANG] = ACTIONS(810),
    [anon_sym_TILDE] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(810),
    [anon_sym_DASH_DASH] = ACTIONS(810),
    [anon_sym_new] = ACTIONS(812),
    [anon_sym_class] = ACTIONS(812),
    [anon_sym_SEMI] = ACTIONS(810),
    [anon_sym_LBRACE] = ACTIONS(810),
    [anon_sym_RBRACE] = ACTIONS(810),
    [anon_sym_assert] = ACTIONS(812),
    [anon_sym_switch] = ACTIONS(812),
    [anon_sym_case] = ACTIONS(812),
    [anon_sym_default] = ACTIONS(812),
    [anon_sym_do] = ACTIONS(812),
    [anon_sym_while] = ACTIONS(812),
    [anon_sym_break] = ACTIONS(812),
    [anon_sym_continue] = ACTIONS(812),
    [anon_sym_return] = ACTIONS(812),
    [anon_sym_synchronized] = ACTIONS(812),
    [anon_sym_throw] = ACTIONS(812),
    [anon_sym_try] = ACTIONS(812),
    [anon_sym_if] = ACTIONS(812),
    [anon_sym_else] = ACTIONS(812),
    [anon_sym_for] = ACTIONS(812),
    [anon_sym_AT] = ACTIONS(812),
    [anon_sym_open] = ACTIONS(812),
    [anon_sym_module] = ACTIONS(812),
    [anon_sym_static] = ACTIONS(812),
    [anon_sym_package] = ACTIONS(812),
    [anon_sym_import] = ACTIONS(812),
    [anon_sym_enum] = ACTIONS(812),
    [anon_sym_public] = ACTIONS(812),
    [anon_sym_protected] = ACTIONS(812),
    [anon_sym_private] = ACTIONS(812),
    [anon_sym_abstract] = ACTIONS(812),
    [anon_sym_final] = ACTIONS(812),
    [anon_sym_strictfp] = ACTIONS(812),
    [anon_sym_native] = ACTIONS(812),
    [anon_sym_transient] = ACTIONS(812),
    [anon_sym_volatile] = ACTIONS(812),
    [anon_sym_ATinterface] = ACTIONS(810),
    [anon_sym_interface] = ACTIONS(812),
    [anon_sym_byte] = ACTIONS(812),
    [anon_sym_short] = ACTIONS(812),
    [anon_sym_int] = ACTIONS(812),
    [anon_sym_long] = ACTIONS(812),
    [anon_sym_char] = ACTIONS(812),
    [anon_sym_float] = ACTIONS(812),
    [anon_sym_double] = ACTIONS(812),
    [sym_boolean_type] = ACTIONS(812),
    [sym_void_type] = ACTIONS(812),
    [sym_this] = ACTIONS(812),
    [sym_super] = ACTIONS(812),
    [sym_comment] = ACTIONS(3),
  },
  [179] = {
    [ts_builtin_sym_end] = ACTIONS(814),
    [sym_identifier] = ACTIONS(816),
    [sym_decimal_integer_literal] = ACTIONS(816),
    [sym_hex_integer_literal] = ACTIONS(816),
    [sym_octal_integer_literal] = ACTIONS(814),
    [sym_binary_integer_literal] = ACTIONS(814),
    [sym_decimal_floating_point_literal] = ACTIONS(814),
    [sym_hex_floating_point_literal] = ACTIONS(816),
    [sym_true] = ACTIONS(816),
    [sym_false] = ACTIONS(816),
    [sym_character_literal] = ACTIONS(814),
    [sym_string_literal] = ACTIONS(814),
    [sym_null_literal] = ACTIONS(816),
    [anon_sym_LPAREN] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(816),
    [anon_sym_DASH] = ACTIONS(816),
    [anon_sym_BANG] = ACTIONS(814),
    [anon_sym_TILDE] = ACTIONS(814),
    [anon_sym_PLUS_PLUS] = ACTIONS(814),
    [anon_sym_DASH_DASH] = ACTIONS(814),
    [anon_sym_new] = ACTIONS(816),
    [anon_sym_class] = ACTIONS(816),
    [anon_sym_SEMI] = ACTIONS(814),
    [anon_sym_LBRACE] = ACTIONS(814),
    [anon_sym_RBRACE] = ACTIONS(814),
    [anon_sym_assert] = ACTIONS(816),
    [anon_sym_switch] = ACTIONS(816),
    [anon_sym_case] = ACTIONS(816),
    [anon_sym_default] = ACTIONS(816),
    [anon_sym_do] = ACTIONS(816),
    [anon_sym_while] = ACTIONS(816),
    [anon_sym_break] = ACTIONS(816),
    [anon_sym_continue] = ACTIONS(816),
    [anon_sym_return] = ACTIONS(816),
    [anon_sym_synchronized] = ACTIONS(816),
    [anon_sym_throw] = ACTIONS(816),
    [anon_sym_try] = ACTIONS(816),
    [anon_sym_if] = ACTIONS(816),
    [anon_sym_else] = ACTIONS(816),
    [anon_sym_for] = ACTIONS(816),
    [anon_sym_AT] = ACTIONS(816),
    [anon_sym_open] = ACTIONS(816),
    [anon_sym_module] = ACTIONS(816),
    [anon_sym_static] = ACTIONS(816),
    [anon_sym_package] = ACTIONS(816),
    [anon_sym_import] = ACTIONS(816),
    [anon_sym_enum] = ACTIONS(816),
    [anon_sym_public] = ACTIONS(816),
    [anon_sym_protected] = ACTIONS(816),
    [anon_sym_private] = ACTIONS(816),
    [anon_sym_abstract] = ACTIONS(816),
    [anon_sym_final] = ACTIONS(816),
    [anon_sym_strictfp] = ACTIONS(816),
    [anon_sym_native] = ACTIONS(816),
    [anon_sym_transient] = ACTIONS(816),
    [anon_sym_volatile] = ACTIONS(816),
    [anon_sym_ATinterface] = ACTIONS(814),
    [anon_sym_interface] = ACTIONS(816),
    [anon_sym_byte] = ACTIONS(816),
    [anon_sym_short] = ACTIONS(816),
    [anon_sym_int] = ACTIONS(816),
    [anon_sym_long] = ACTIONS(816),
    [anon_sym_char] = ACTIONS(816),
    [anon_sym_float] = ACTIONS(816),
    [anon_sym_double] = ACTIONS(816),
    [sym_boolean_type] = ACTIONS(816),
    [sym_void_type] = ACTIONS(816),
    [sym_this] = ACTIONS(816),
    [sym_super] = ACTIONS(816),
    [sym_comment] = ACTIONS(3),
  },
  [180] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(446),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(818),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(820),
    [sym_identifier] = ACTIONS(822),
    [sym_decimal_integer_literal] = ACTIONS(822),
    [sym_hex_integer_literal] = ACTIONS(822),
    [sym_octal_integer_literal] = ACTIONS(820),
    [sym_binary_integer_literal] = ACTIONS(820),
    [sym_decimal_floating_point_literal] = ACTIONS(820),
    [sym_hex_floating_point_literal] = ACTIONS(822),
    [sym_true] = ACTIONS(822),
    [sym_false] = ACTIONS(822),
    [sym_character_literal] = ACTIONS(820),
    [sym_string_literal] = ACTIONS(820),
    [sym_null_literal] = ACTIONS(822),
    [anon_sym_LPAREN] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(822),
    [anon_sym_DASH] = ACTIONS(822),
    [anon_sym_BANG] = ACTIONS(820),
    [anon_sym_TILDE] = ACTIONS(820),
    [anon_sym_PLUS_PLUS] = ACTIONS(820),
    [anon_sym_DASH_DASH] = ACTIONS(820),
    [anon_sym_new] = ACTIONS(822),
    [anon_sym_class] = ACTIONS(822),
    [anon_sym_SEMI] = ACTIONS(820),
    [anon_sym_LBRACE] = ACTIONS(820),
    [anon_sym_RBRACE] = ACTIONS(820),
    [anon_sym_assert] = ACTIONS(822),
    [anon_sym_switch] = ACTIONS(822),
    [anon_sym_case] = ACTIONS(822),
    [anon_sym_default] = ACTIONS(822),
    [anon_sym_do] = ACTIONS(822),
    [anon_sym_while] = ACTIONS(822),
    [anon_sym_break] = ACTIONS(822),
    [anon_sym_continue] = ACTIONS(822),
    [anon_sym_return] = ACTIONS(822),
    [anon_sym_synchronized] = ACTIONS(822),
    [anon_sym_throw] = ACTIONS(822),
    [anon_sym_try] = ACTIONS(822),
    [anon_sym_if] = ACTIONS(822),
    [anon_sym_else] = ACTIONS(822),
    [anon_sym_for] = ACTIONS(822),
    [anon_sym_AT] = ACTIONS(822),
    [anon_sym_open] = ACTIONS(822),
    [anon_sym_module] = ACTIONS(822),
    [anon_sym_static] = ACTIONS(822),
    [anon_sym_package] = ACTIONS(822),
    [anon_sym_import] = ACTIONS(822),
    [anon_sym_enum] = ACTIONS(822),
    [anon_sym_public] = ACTIONS(822),
    [anon_sym_protected] = ACTIONS(822),
    [anon_sym_private] = ACTIONS(822),
    [anon_sym_abstract] = ACTIONS(822),
    [anon_sym_final] = ACTIONS(822),
    [anon_sym_strictfp] = ACTIONS(822),
    [anon_sym_native] = ACTIONS(822),
    [anon_sym_transient] = ACTIONS(822),
    [anon_sym_volatile] = ACTIONS(822),
    [anon_sym_ATinterface] = ACTIONS(820),
    [anon_sym_interface] = ACTIONS(822),
    [anon_sym_byte] = ACTIONS(822),
    [anon_sym_short] = ACTIONS(822),
    [anon_sym_int] = ACTIONS(822),
    [anon_sym_long] = ACTIONS(822),
    [anon_sym_char] = ACTIONS(822),
    [anon_sym_float] = ACTIONS(822),
    [anon_sym_double] = ACTIONS(822),
    [sym_boolean_type] = ACTIONS(822),
    [sym_void_type] = ACTIONS(822),
    [sym_this] = ACTIONS(822),
    [sym_super] = ACTIONS(822),
    [sym_comment] = ACTIONS(3),
  },
  [182] = {
    [ts_builtin_sym_end] = ACTIONS(824),
    [sym_identifier] = ACTIONS(826),
    [sym_decimal_integer_literal] = ACTIONS(826),
    [sym_hex_integer_literal] = ACTIONS(826),
    [sym_octal_integer_literal] = ACTIONS(824),
    [sym_binary_integer_literal] = ACTIONS(824),
    [sym_decimal_floating_point_literal] = ACTIONS(824),
    [sym_hex_floating_point_literal] = ACTIONS(826),
    [sym_true] = ACTIONS(826),
    [sym_false] = ACTIONS(826),
    [sym_character_literal] = ACTIONS(824),
    [sym_string_literal] = ACTIONS(824),
    [sym_null_literal] = ACTIONS(826),
    [anon_sym_LPAREN] = ACTIONS(824),
    [anon_sym_PLUS] = ACTIONS(826),
    [anon_sym_DASH] = ACTIONS(826),
    [anon_sym_BANG] = ACTIONS(824),
    [anon_sym_TILDE] = ACTIONS(824),
    [anon_sym_PLUS_PLUS] = ACTIONS(824),
    [anon_sym_DASH_DASH] = ACTIONS(824),
    [anon_sym_new] = ACTIONS(826),
    [anon_sym_class] = ACTIONS(826),
    [anon_sym_SEMI] = ACTIONS(824),
    [anon_sym_LBRACE] = ACTIONS(824),
    [anon_sym_RBRACE] = ACTIONS(824),
    [anon_sym_assert] = ACTIONS(826),
    [anon_sym_switch] = ACTIONS(826),
    [anon_sym_case] = ACTIONS(826),
    [anon_sym_default] = ACTIONS(826),
    [anon_sym_do] = ACTIONS(826),
    [anon_sym_while] = ACTIONS(826),
    [anon_sym_break] = ACTIONS(826),
    [anon_sym_continue] = ACTIONS(826),
    [anon_sym_return] = ACTIONS(826),
    [anon_sym_synchronized] = ACTIONS(826),
    [anon_sym_throw] = ACTIONS(826),
    [anon_sym_try] = ACTIONS(826),
    [anon_sym_if] = ACTIONS(826),
    [anon_sym_else] = ACTIONS(826),
    [anon_sym_for] = ACTIONS(826),
    [anon_sym_AT] = ACTIONS(826),
    [anon_sym_open] = ACTIONS(826),
    [anon_sym_module] = ACTIONS(826),
    [anon_sym_static] = ACTIONS(826),
    [anon_sym_package] = ACTIONS(826),
    [anon_sym_import] = ACTIONS(826),
    [anon_sym_enum] = ACTIONS(826),
    [anon_sym_public] = ACTIONS(826),
    [anon_sym_protected] = ACTIONS(826),
    [anon_sym_private] = ACTIONS(826),
    [anon_sym_abstract] = ACTIONS(826),
    [anon_sym_final] = ACTIONS(826),
    [anon_sym_strictfp] = ACTIONS(826),
    [anon_sym_native] = ACTIONS(826),
    [anon_sym_transient] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_ATinterface] = ACTIONS(824),
    [anon_sym_interface] = ACTIONS(826),
    [anon_sym_byte] = ACTIONS(826),
    [anon_sym_short] = ACTIONS(826),
    [anon_sym_int] = ACTIONS(826),
    [anon_sym_long] = ACTIONS(826),
    [anon_sym_char] = ACTIONS(826),
    [anon_sym_float] = ACTIONS(826),
    [anon_sym_double] = ACTIONS(826),
    [sym_boolean_type] = ACTIONS(826),
    [sym_void_type] = ACTIONS(826),
    [sym_this] = ACTIONS(826),
    [sym_super] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
  },
  [183] = {
    [ts_builtin_sym_end] = ACTIONS(828),
    [sym_identifier] = ACTIONS(830),
    [sym_decimal_integer_literal] = ACTIONS(830),
    [sym_hex_integer_literal] = ACTIONS(830),
    [sym_octal_integer_literal] = ACTIONS(828),
    [sym_binary_integer_literal] = ACTIONS(828),
    [sym_decimal_floating_point_literal] = ACTIONS(828),
    [sym_hex_floating_point_literal] = ACTIONS(830),
    [sym_true] = ACTIONS(830),
    [sym_false] = ACTIONS(830),
    [sym_character_literal] = ACTIONS(828),
    [sym_string_literal] = ACTIONS(828),
    [sym_null_literal] = ACTIONS(830),
    [anon_sym_LPAREN] = ACTIONS(828),
    [anon_sym_PLUS] = ACTIONS(830),
    [anon_sym_DASH] = ACTIONS(830),
    [anon_sym_BANG] = ACTIONS(828),
    [anon_sym_TILDE] = ACTIONS(828),
    [anon_sym_PLUS_PLUS] = ACTIONS(828),
    [anon_sym_DASH_DASH] = ACTIONS(828),
    [anon_sym_new] = ACTIONS(830),
    [anon_sym_class] = ACTIONS(830),
    [anon_sym_SEMI] = ACTIONS(828),
    [anon_sym_LBRACE] = ACTIONS(828),
    [anon_sym_RBRACE] = ACTIONS(828),
    [anon_sym_assert] = ACTIONS(830),
    [anon_sym_switch] = ACTIONS(830),
    [anon_sym_case] = ACTIONS(830),
    [anon_sym_default] = ACTIONS(830),
    [anon_sym_do] = ACTIONS(830),
    [anon_sym_while] = ACTIONS(830),
    [anon_sym_break] = ACTIONS(830),
    [anon_sym_continue] = ACTIONS(830),
    [anon_sym_return] = ACTIONS(830),
    [anon_sym_synchronized] = ACTIONS(830),
    [anon_sym_throw] = ACTIONS(830),
    [anon_sym_try] = ACTIONS(830),
    [anon_sym_if] = ACTIONS(830),
    [anon_sym_else] = ACTIONS(830),
    [anon_sym_for] = ACTIONS(830),
    [anon_sym_AT] = ACTIONS(830),
    [anon_sym_open] = ACTIONS(830),
    [anon_sym_module] = ACTIONS(830),
    [anon_sym_static] = ACTIONS(830),
    [anon_sym_package] = ACTIONS(830),
    [anon_sym_import] = ACTIONS(830),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_public] = ACTIONS(830),
    [anon_sym_protected] = ACTIONS(830),
    [anon_sym_private] = ACTIONS(830),
    [anon_sym_abstract] = ACTIONS(830),
    [anon_sym_final] = ACTIONS(830),
    [anon_sym_strictfp] = ACTIONS(830),
    [anon_sym_native] = ACTIONS(830),
    [anon_sym_transient] = ACTIONS(830),
    [anon_sym_volatile] = ACTIONS(830),
    [anon_sym_ATinterface] = ACTIONS(828),
    [anon_sym_interface] = ACTIONS(830),
    [anon_sym_byte] = ACTIONS(830),
    [anon_sym_short] = ACTIONS(830),
    [anon_sym_int] = ACTIONS(830),
    [anon_sym_long] = ACTIONS(830),
    [anon_sym_char] = ACTIONS(830),
    [anon_sym_float] = ACTIONS(830),
    [anon_sym_double] = ACTIONS(830),
    [sym_boolean_type] = ACTIONS(830),
    [sym_void_type] = ACTIONS(830),
    [sym_this] = ACTIONS(830),
    [sym_super] = ACTIONS(830),
    [sym_comment] = ACTIONS(3),
  },
  [184] = {
    [ts_builtin_sym_end] = ACTIONS(832),
    [sym_identifier] = ACTIONS(834),
    [sym_decimal_integer_literal] = ACTIONS(834),
    [sym_hex_integer_literal] = ACTIONS(834),
    [sym_octal_integer_literal] = ACTIONS(832),
    [sym_binary_integer_literal] = ACTIONS(832),
    [sym_decimal_floating_point_literal] = ACTIONS(832),
    [sym_hex_floating_point_literal] = ACTIONS(834),
    [sym_true] = ACTIONS(834),
    [sym_false] = ACTIONS(834),
    [sym_character_literal] = ACTIONS(832),
    [sym_string_literal] = ACTIONS(832),
    [sym_null_literal] = ACTIONS(834),
    [anon_sym_LPAREN] = ACTIONS(832),
    [anon_sym_PLUS] = ACTIONS(834),
    [anon_sym_DASH] = ACTIONS(834),
    [anon_sym_BANG] = ACTIONS(832),
    [anon_sym_TILDE] = ACTIONS(832),
    [anon_sym_PLUS_PLUS] = ACTIONS(832),
    [anon_sym_DASH_DASH] = ACTIONS(832),
    [anon_sym_new] = ACTIONS(834),
    [anon_sym_class] = ACTIONS(834),
    [anon_sym_SEMI] = ACTIONS(832),
    [anon_sym_LBRACE] = ACTIONS(832),
    [anon_sym_RBRACE] = ACTIONS(832),
    [anon_sym_assert] = ACTIONS(834),
    [anon_sym_switch] = ACTIONS(834),
    [anon_sym_case] = ACTIONS(834),
    [anon_sym_default] = ACTIONS(834),
    [anon_sym_do] = ACTIONS(834),
    [anon_sym_while] = ACTIONS(834),
    [anon_sym_break] = ACTIONS(834),
    [anon_sym_continue] = ACTIONS(834),
    [anon_sym_return] = ACTIONS(834),
    [anon_sym_synchronized] = ACTIONS(834),
    [anon_sym_throw] = ACTIONS(834),
    [anon_sym_try] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(834),
    [anon_sym_else] = ACTIONS(834),
    [anon_sym_for] = ACTIONS(834),
    [anon_sym_AT] = ACTIONS(834),
    [anon_sym_open] = ACTIONS(834),
    [anon_sym_module] = ACTIONS(834),
    [anon_sym_static] = ACTIONS(834),
    [anon_sym_package] = ACTIONS(834),
    [anon_sym_import] = ACTIONS(834),
    [anon_sym_enum] = ACTIONS(834),
    [anon_sym_public] = ACTIONS(834),
    [anon_sym_protected] = ACTIONS(834),
    [anon_sym_private] = ACTIONS(834),
    [anon_sym_abstract] = ACTIONS(834),
    [anon_sym_final] = ACTIONS(834),
    [anon_sym_strictfp] = ACTIONS(834),
    [anon_sym_native] = ACTIONS(834),
    [anon_sym_transient] = ACTIONS(834),
    [anon_sym_volatile] = ACTIONS(834),
    [anon_sym_ATinterface] = ACTIONS(832),
    [anon_sym_interface] = ACTIONS(834),
    [anon_sym_byte] = ACTIONS(834),
    [anon_sym_short] = ACTIONS(834),
    [anon_sym_int] = ACTIONS(834),
    [anon_sym_long] = ACTIONS(834),
    [anon_sym_char] = ACTIONS(834),
    [anon_sym_float] = ACTIONS(834),
    [anon_sym_double] = ACTIONS(834),
    [sym_boolean_type] = ACTIONS(834),
    [sym_void_type] = ACTIONS(834),
    [sym_this] = ACTIONS(834),
    [sym_super] = ACTIONS(834),
    [sym_comment] = ACTIONS(3),
  },
  [185] = {
    [ts_builtin_sym_end] = ACTIONS(836),
    [sym_identifier] = ACTIONS(838),
    [sym_decimal_integer_literal] = ACTIONS(838),
    [sym_hex_integer_literal] = ACTIONS(838),
    [sym_octal_integer_literal] = ACTIONS(836),
    [sym_binary_integer_literal] = ACTIONS(836),
    [sym_decimal_floating_point_literal] = ACTIONS(836),
    [sym_hex_floating_point_literal] = ACTIONS(838),
    [sym_true] = ACTIONS(838),
    [sym_false] = ACTIONS(838),
    [sym_character_literal] = ACTIONS(836),
    [sym_string_literal] = ACTIONS(836),
    [sym_null_literal] = ACTIONS(838),
    [anon_sym_LPAREN] = ACTIONS(836),
    [anon_sym_PLUS] = ACTIONS(838),
    [anon_sym_DASH] = ACTIONS(838),
    [anon_sym_BANG] = ACTIONS(836),
    [anon_sym_TILDE] = ACTIONS(836),
    [anon_sym_PLUS_PLUS] = ACTIONS(836),
    [anon_sym_DASH_DASH] = ACTIONS(836),
    [anon_sym_new] = ACTIONS(838),
    [anon_sym_class] = ACTIONS(838),
    [anon_sym_SEMI] = ACTIONS(836),
    [anon_sym_LBRACE] = ACTIONS(836),
    [anon_sym_RBRACE] = ACTIONS(836),
    [anon_sym_assert] = ACTIONS(838),
    [anon_sym_switch] = ACTIONS(838),
    [anon_sym_case] = ACTIONS(838),
    [anon_sym_default] = ACTIONS(838),
    [anon_sym_do] = ACTIONS(838),
    [anon_sym_while] = ACTIONS(838),
    [anon_sym_break] = ACTIONS(838),
    [anon_sym_continue] = ACTIONS(838),
    [anon_sym_return] = ACTIONS(838),
    [anon_sym_synchronized] = ACTIONS(838),
    [anon_sym_throw] = ACTIONS(838),
    [anon_sym_try] = ACTIONS(838),
    [anon_sym_if] = ACTIONS(838),
    [anon_sym_else] = ACTIONS(838),
    [anon_sym_for] = ACTIONS(838),
    [anon_sym_AT] = ACTIONS(838),
    [anon_sym_open] = ACTIONS(838),
    [anon_sym_module] = ACTIONS(838),
    [anon_sym_static] = ACTIONS(838),
    [anon_sym_package] = ACTIONS(838),
    [anon_sym_import] = ACTIONS(838),
    [anon_sym_enum] = ACTIONS(838),
    [anon_sym_public] = ACTIONS(838),
    [anon_sym_protected] = ACTIONS(838),
    [anon_sym_private] = ACTIONS(838),
    [anon_sym_abstract] = ACTIONS(838),
    [anon_sym_final] = ACTIONS(838),
    [anon_sym_strictfp] = ACTIONS(838),
    [anon_sym_native] = ACTIONS(838),
    [anon_sym_transient] = ACTIONS(838),
    [anon_sym_volatile] = ACTIONS(838),
    [anon_sym_ATinterface] = ACTIONS(836),
    [anon_sym_interface] = ACTIONS(838),
    [anon_sym_byte] = ACTIONS(838),
    [anon_sym_short] = ACTIONS(838),
    [anon_sym_int] = ACTIONS(838),
    [anon_sym_long] = ACTIONS(838),
    [anon_sym_char] = ACTIONS(838),
    [anon_sym_float] = ACTIONS(838),
    [anon_sym_double] = ACTIONS(838),
    [sym_boolean_type] = ACTIONS(838),
    [sym_void_type] = ACTIONS(838),
    [sym_this] = ACTIONS(838),
    [sym_super] = ACTIONS(838),
    [sym_comment] = ACTIONS(3),
  },
  [186] = {
    [ts_builtin_sym_end] = ACTIONS(840),
    [sym_identifier] = ACTIONS(842),
    [sym_decimal_integer_literal] = ACTIONS(842),
    [sym_hex_integer_literal] = ACTIONS(842),
    [sym_octal_integer_literal] = ACTIONS(840),
    [sym_binary_integer_literal] = ACTIONS(840),
    [sym_decimal_floating_point_literal] = ACTIONS(840),
    [sym_hex_floating_point_literal] = ACTIONS(842),
    [sym_true] = ACTIONS(842),
    [sym_false] = ACTIONS(842),
    [sym_character_literal] = ACTIONS(840),
    [sym_string_literal] = ACTIONS(840),
    [sym_null_literal] = ACTIONS(842),
    [anon_sym_LPAREN] = ACTIONS(840),
    [anon_sym_PLUS] = ACTIONS(842),
    [anon_sym_DASH] = ACTIONS(842),
    [anon_sym_BANG] = ACTIONS(840),
    [anon_sym_TILDE] = ACTIONS(840),
    [anon_sym_PLUS_PLUS] = ACTIONS(840),
    [anon_sym_DASH_DASH] = ACTIONS(840),
    [anon_sym_new] = ACTIONS(842),
    [anon_sym_class] = ACTIONS(842),
    [anon_sym_SEMI] = ACTIONS(840),
    [anon_sym_LBRACE] = ACTIONS(840),
    [anon_sym_RBRACE] = ACTIONS(840),
    [anon_sym_assert] = ACTIONS(842),
    [anon_sym_switch] = ACTIONS(842),
    [anon_sym_case] = ACTIONS(842),
    [anon_sym_default] = ACTIONS(842),
    [anon_sym_do] = ACTIONS(842),
    [anon_sym_while] = ACTIONS(842),
    [anon_sym_break] = ACTIONS(842),
    [anon_sym_continue] = ACTIONS(842),
    [anon_sym_return] = ACTIONS(842),
    [anon_sym_synchronized] = ACTIONS(842),
    [anon_sym_throw] = ACTIONS(842),
    [anon_sym_try] = ACTIONS(842),
    [anon_sym_if] = ACTIONS(842),
    [anon_sym_else] = ACTIONS(842),
    [anon_sym_for] = ACTIONS(842),
    [anon_sym_AT] = ACTIONS(842),
    [anon_sym_open] = ACTIONS(842),
    [anon_sym_module] = ACTIONS(842),
    [anon_sym_static] = ACTIONS(842),
    [anon_sym_package] = ACTIONS(842),
    [anon_sym_import] = ACTIONS(842),
    [anon_sym_enum] = ACTIONS(842),
    [anon_sym_public] = ACTIONS(842),
    [anon_sym_protected] = ACTIONS(842),
    [anon_sym_private] = ACTIONS(842),
    [anon_sym_abstract] = ACTIONS(842),
    [anon_sym_final] = ACTIONS(842),
    [anon_sym_strictfp] = ACTIONS(842),
    [anon_sym_native] = ACTIONS(842),
    [anon_sym_transient] = ACTIONS(842),
    [anon_sym_volatile] = ACTIONS(842),
    [anon_sym_ATinterface] = ACTIONS(840),
    [anon_sym_interface] = ACTIONS(842),
    [anon_sym_byte] = ACTIONS(842),
    [anon_sym_short] = ACTIONS(842),
    [anon_sym_int] = ACTIONS(842),
    [anon_sym_long] = ACTIONS(842),
    [anon_sym_char] = ACTIONS(842),
    [anon_sym_float] = ACTIONS(842),
    [anon_sym_double] = ACTIONS(842),
    [sym_boolean_type] = ACTIONS(842),
    [sym_void_type] = ACTIONS(842),
    [sym_this] = ACTIONS(842),
    [sym_super] = ACTIONS(842),
    [sym_comment] = ACTIONS(3),
  },
  [187] = {
    [ts_builtin_sym_end] = ACTIONS(844),
    [sym_identifier] = ACTIONS(846),
    [sym_decimal_integer_literal] = ACTIONS(846),
    [sym_hex_integer_literal] = ACTIONS(846),
    [sym_octal_integer_literal] = ACTIONS(844),
    [sym_binary_integer_literal] = ACTIONS(844),
    [sym_decimal_floating_point_literal] = ACTIONS(844),
    [sym_hex_floating_point_literal] = ACTIONS(846),
    [sym_true] = ACTIONS(846),
    [sym_false] = ACTIONS(846),
    [sym_character_literal] = ACTIONS(844),
    [sym_string_literal] = ACTIONS(844),
    [sym_null_literal] = ACTIONS(846),
    [anon_sym_LPAREN] = ACTIONS(844),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_BANG] = ACTIONS(844),
    [anon_sym_TILDE] = ACTIONS(844),
    [anon_sym_PLUS_PLUS] = ACTIONS(844),
    [anon_sym_DASH_DASH] = ACTIONS(844),
    [anon_sym_new] = ACTIONS(846),
    [anon_sym_class] = ACTIONS(846),
    [anon_sym_SEMI] = ACTIONS(844),
    [anon_sym_LBRACE] = ACTIONS(844),
    [anon_sym_RBRACE] = ACTIONS(844),
    [anon_sym_assert] = ACTIONS(846),
    [anon_sym_switch] = ACTIONS(846),
    [anon_sym_case] = ACTIONS(846),
    [anon_sym_default] = ACTIONS(846),
    [anon_sym_do] = ACTIONS(846),
    [anon_sym_while] = ACTIONS(846),
    [anon_sym_break] = ACTIONS(846),
    [anon_sym_continue] = ACTIONS(846),
    [anon_sym_return] = ACTIONS(846),
    [anon_sym_synchronized] = ACTIONS(846),
    [anon_sym_throw] = ACTIONS(846),
    [anon_sym_try] = ACTIONS(846),
    [anon_sym_if] = ACTIONS(846),
    [anon_sym_else] = ACTIONS(846),
    [anon_sym_for] = ACTIONS(846),
    [anon_sym_AT] = ACTIONS(846),
    [anon_sym_open] = ACTIONS(846),
    [anon_sym_module] = ACTIONS(846),
    [anon_sym_static] = ACTIONS(846),
    [anon_sym_package] = ACTIONS(846),
    [anon_sym_import] = ACTIONS(846),
    [anon_sym_enum] = ACTIONS(846),
    [anon_sym_public] = ACTIONS(846),
    [anon_sym_protected] = ACTIONS(846),
    [anon_sym_private] = ACTIONS(846),
    [anon_sym_abstract] = ACTIONS(846),
    [anon_sym_final] = ACTIONS(846),
    [anon_sym_strictfp] = ACTIONS(846),
    [anon_sym_native] = ACTIONS(846),
    [anon_sym_transient] = ACTIONS(846),
    [anon_sym_volatile] = ACTIONS(846),
    [anon_sym_ATinterface] = ACTIONS(844),
    [anon_sym_interface] = ACTIONS(846),
    [anon_sym_byte] = ACTIONS(846),
    [anon_sym_short] = ACTIONS(846),
    [anon_sym_int] = ACTIONS(846),
    [anon_sym_long] = ACTIONS(846),
    [anon_sym_char] = ACTIONS(846),
    [anon_sym_float] = ACTIONS(846),
    [anon_sym_double] = ACTIONS(846),
    [sym_boolean_type] = ACTIONS(846),
    [sym_void_type] = ACTIONS(846),
    [sym_this] = ACTIONS(846),
    [sym_super] = ACTIONS(846),
    [sym_comment] = ACTIONS(3),
  },
  [188] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(426),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(848),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [189] = {
    [ts_builtin_sym_end] = ACTIONS(850),
    [sym_identifier] = ACTIONS(852),
    [sym_decimal_integer_literal] = ACTIONS(852),
    [sym_hex_integer_literal] = ACTIONS(852),
    [sym_octal_integer_literal] = ACTIONS(850),
    [sym_binary_integer_literal] = ACTIONS(850),
    [sym_decimal_floating_point_literal] = ACTIONS(850),
    [sym_hex_floating_point_literal] = ACTIONS(852),
    [sym_true] = ACTIONS(852),
    [sym_false] = ACTIONS(852),
    [sym_character_literal] = ACTIONS(850),
    [sym_string_literal] = ACTIONS(850),
    [sym_null_literal] = ACTIONS(852),
    [anon_sym_LPAREN] = ACTIONS(850),
    [anon_sym_PLUS] = ACTIONS(852),
    [anon_sym_DASH] = ACTIONS(852),
    [anon_sym_BANG] = ACTIONS(850),
    [anon_sym_TILDE] = ACTIONS(850),
    [anon_sym_PLUS_PLUS] = ACTIONS(850),
    [anon_sym_DASH_DASH] = ACTIONS(850),
    [anon_sym_new] = ACTIONS(852),
    [anon_sym_class] = ACTIONS(852),
    [anon_sym_SEMI] = ACTIONS(850),
    [anon_sym_LBRACE] = ACTIONS(850),
    [anon_sym_RBRACE] = ACTIONS(850),
    [anon_sym_assert] = ACTIONS(852),
    [anon_sym_switch] = ACTIONS(852),
    [anon_sym_case] = ACTIONS(852),
    [anon_sym_default] = ACTIONS(852),
    [anon_sym_do] = ACTIONS(852),
    [anon_sym_while] = ACTIONS(852),
    [anon_sym_break] = ACTIONS(852),
    [anon_sym_continue] = ACTIONS(852),
    [anon_sym_return] = ACTIONS(852),
    [anon_sym_synchronized] = ACTIONS(852),
    [anon_sym_throw] = ACTIONS(852),
    [anon_sym_try] = ACTIONS(852),
    [anon_sym_if] = ACTIONS(852),
    [anon_sym_else] = ACTIONS(852),
    [anon_sym_for] = ACTIONS(852),
    [anon_sym_AT] = ACTIONS(852),
    [anon_sym_open] = ACTIONS(852),
    [anon_sym_module] = ACTIONS(852),
    [anon_sym_static] = ACTIONS(852),
    [anon_sym_package] = ACTIONS(852),
    [anon_sym_import] = ACTIONS(852),
    [anon_sym_enum] = ACTIONS(852),
    [anon_sym_public] = ACTIONS(852),
    [anon_sym_protected] = ACTIONS(852),
    [anon_sym_private] = ACTIONS(852),
    [anon_sym_abstract] = ACTIONS(852),
    [anon_sym_final] = ACTIONS(852),
    [anon_sym_strictfp] = ACTIONS(852),
    [anon_sym_native] = ACTIONS(852),
    [anon_sym_transient] = ACTIONS(852),
    [anon_sym_volatile] = ACTIONS(852),
    [anon_sym_ATinterface] = ACTIONS(850),
    [anon_sym_interface] = ACTIONS(852),
    [anon_sym_byte] = ACTIONS(852),
    [anon_sym_short] = ACTIONS(852),
    [anon_sym_int] = ACTIONS(852),
    [anon_sym_long] = ACTIONS(852),
    [anon_sym_char] = ACTIONS(852),
    [anon_sym_float] = ACTIONS(852),
    [anon_sym_double] = ACTIONS(852),
    [sym_boolean_type] = ACTIONS(852),
    [sym_void_type] = ACTIONS(852),
    [sym_this] = ACTIONS(852),
    [sym_super] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
  },
  [190] = {
    [ts_builtin_sym_end] = ACTIONS(854),
    [sym_identifier] = ACTIONS(856),
    [sym_decimal_integer_literal] = ACTIONS(856),
    [sym_hex_integer_literal] = ACTIONS(856),
    [sym_octal_integer_literal] = ACTIONS(854),
    [sym_binary_integer_literal] = ACTIONS(854),
    [sym_decimal_floating_point_literal] = ACTIONS(854),
    [sym_hex_floating_point_literal] = ACTIONS(856),
    [sym_true] = ACTIONS(856),
    [sym_false] = ACTIONS(856),
    [sym_character_literal] = ACTIONS(854),
    [sym_string_literal] = ACTIONS(854),
    [sym_null_literal] = ACTIONS(856),
    [anon_sym_LPAREN] = ACTIONS(854),
    [anon_sym_PLUS] = ACTIONS(856),
    [anon_sym_DASH] = ACTIONS(856),
    [anon_sym_BANG] = ACTIONS(854),
    [anon_sym_TILDE] = ACTIONS(854),
    [anon_sym_PLUS_PLUS] = ACTIONS(854),
    [anon_sym_DASH_DASH] = ACTIONS(854),
    [anon_sym_new] = ACTIONS(856),
    [anon_sym_class] = ACTIONS(856),
    [anon_sym_SEMI] = ACTIONS(854),
    [anon_sym_LBRACE] = ACTIONS(854),
    [anon_sym_RBRACE] = ACTIONS(854),
    [anon_sym_assert] = ACTIONS(856),
    [anon_sym_switch] = ACTIONS(856),
    [anon_sym_case] = ACTIONS(856),
    [anon_sym_default] = ACTIONS(856),
    [anon_sym_do] = ACTIONS(856),
    [anon_sym_while] = ACTIONS(856),
    [anon_sym_break] = ACTIONS(856),
    [anon_sym_continue] = ACTIONS(856),
    [anon_sym_return] = ACTIONS(856),
    [anon_sym_synchronized] = ACTIONS(856),
    [anon_sym_throw] = ACTIONS(856),
    [anon_sym_try] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(856),
    [anon_sym_else] = ACTIONS(856),
    [anon_sym_for] = ACTIONS(856),
    [anon_sym_AT] = ACTIONS(856),
    [anon_sym_open] = ACTIONS(856),
    [anon_sym_module] = ACTIONS(856),
    [anon_sym_static] = ACTIONS(856),
    [anon_sym_package] = ACTIONS(856),
    [anon_sym_import] = ACTIONS(856),
    [anon_sym_enum] = ACTIONS(856),
    [anon_sym_public] = ACTIONS(856),
    [anon_sym_protected] = ACTIONS(856),
    [anon_sym_private] = ACTIONS(856),
    [anon_sym_abstract] = ACTIONS(856),
    [anon_sym_final] = ACTIONS(856),
    [anon_sym_strictfp] = ACTIONS(856),
    [anon_sym_native] = ACTIONS(856),
    [anon_sym_transient] = ACTIONS(856),
    [anon_sym_volatile] = ACTIONS(856),
    [anon_sym_ATinterface] = ACTIONS(854),
    [anon_sym_interface] = ACTIONS(856),
    [anon_sym_byte] = ACTIONS(856),
    [anon_sym_short] = ACTIONS(856),
    [anon_sym_int] = ACTIONS(856),
    [anon_sym_long] = ACTIONS(856),
    [anon_sym_char] = ACTIONS(856),
    [anon_sym_float] = ACTIONS(856),
    [anon_sym_double] = ACTIONS(856),
    [sym_boolean_type] = ACTIONS(856),
    [sym_void_type] = ACTIONS(856),
    [sym_this] = ACTIONS(856),
    [sym_super] = ACTIONS(856),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(453),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(858),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [192] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(430),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(860),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [193] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(421),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(862),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [194] = {
    [ts_builtin_sym_end] = ACTIONS(864),
    [sym_identifier] = ACTIONS(866),
    [sym_decimal_integer_literal] = ACTIONS(866),
    [sym_hex_integer_literal] = ACTIONS(866),
    [sym_octal_integer_literal] = ACTIONS(864),
    [sym_binary_integer_literal] = ACTIONS(864),
    [sym_decimal_floating_point_literal] = ACTIONS(864),
    [sym_hex_floating_point_literal] = ACTIONS(866),
    [sym_true] = ACTIONS(866),
    [sym_false] = ACTIONS(866),
    [sym_character_literal] = ACTIONS(864),
    [sym_string_literal] = ACTIONS(864),
    [sym_null_literal] = ACTIONS(866),
    [anon_sym_LPAREN] = ACTIONS(864),
    [anon_sym_PLUS] = ACTIONS(866),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_BANG] = ACTIONS(864),
    [anon_sym_TILDE] = ACTIONS(864),
    [anon_sym_PLUS_PLUS] = ACTIONS(864),
    [anon_sym_DASH_DASH] = ACTIONS(864),
    [anon_sym_new] = ACTIONS(866),
    [anon_sym_class] = ACTIONS(866),
    [anon_sym_SEMI] = ACTIONS(864),
    [anon_sym_LBRACE] = ACTIONS(864),
    [anon_sym_RBRACE] = ACTIONS(864),
    [anon_sym_assert] = ACTIONS(866),
    [anon_sym_switch] = ACTIONS(866),
    [anon_sym_case] = ACTIONS(866),
    [anon_sym_default] = ACTIONS(866),
    [anon_sym_do] = ACTIONS(866),
    [anon_sym_while] = ACTIONS(866),
    [anon_sym_break] = ACTIONS(866),
    [anon_sym_continue] = ACTIONS(866),
    [anon_sym_return] = ACTIONS(866),
    [anon_sym_synchronized] = ACTIONS(866),
    [anon_sym_throw] = ACTIONS(866),
    [anon_sym_try] = ACTIONS(866),
    [anon_sym_if] = ACTIONS(866),
    [anon_sym_else] = ACTIONS(866),
    [anon_sym_for] = ACTIONS(866),
    [anon_sym_AT] = ACTIONS(866),
    [anon_sym_open] = ACTIONS(866),
    [anon_sym_module] = ACTIONS(866),
    [anon_sym_static] = ACTIONS(866),
    [anon_sym_package] = ACTIONS(866),
    [anon_sym_import] = ACTIONS(866),
    [anon_sym_enum] = ACTIONS(866),
    [anon_sym_public] = ACTIONS(866),
    [anon_sym_protected] = ACTIONS(866),
    [anon_sym_private] = ACTIONS(866),
    [anon_sym_abstract] = ACTIONS(866),
    [anon_sym_final] = ACTIONS(866),
    [anon_sym_strictfp] = ACTIONS(866),
    [anon_sym_native] = ACTIONS(866),
    [anon_sym_transient] = ACTIONS(866),
    [anon_sym_volatile] = ACTIONS(866),
    [anon_sym_ATinterface] = ACTIONS(864),
    [anon_sym_interface] = ACTIONS(866),
    [anon_sym_byte] = ACTIONS(866),
    [anon_sym_short] = ACTIONS(866),
    [anon_sym_int] = ACTIONS(866),
    [anon_sym_long] = ACTIONS(866),
    [anon_sym_char] = ACTIONS(866),
    [anon_sym_float] = ACTIONS(866),
    [anon_sym_double] = ACTIONS(866),
    [sym_boolean_type] = ACTIONS(866),
    [sym_void_type] = ACTIONS(866),
    [sym_this] = ACTIONS(866),
    [sym_super] = ACTIONS(866),
    [sym_comment] = ACTIONS(3),
  },
  [195] = {
    [ts_builtin_sym_end] = ACTIONS(868),
    [sym_identifier] = ACTIONS(870),
    [sym_decimal_integer_literal] = ACTIONS(870),
    [sym_hex_integer_literal] = ACTIONS(870),
    [sym_octal_integer_literal] = ACTIONS(868),
    [sym_binary_integer_literal] = ACTIONS(868),
    [sym_decimal_floating_point_literal] = ACTIONS(868),
    [sym_hex_floating_point_literal] = ACTIONS(870),
    [sym_true] = ACTIONS(870),
    [sym_false] = ACTIONS(870),
    [sym_character_literal] = ACTIONS(868),
    [sym_string_literal] = ACTIONS(868),
    [sym_null_literal] = ACTIONS(870),
    [anon_sym_LPAREN] = ACTIONS(868),
    [anon_sym_PLUS] = ACTIONS(870),
    [anon_sym_DASH] = ACTIONS(870),
    [anon_sym_BANG] = ACTIONS(868),
    [anon_sym_TILDE] = ACTIONS(868),
    [anon_sym_PLUS_PLUS] = ACTIONS(868),
    [anon_sym_DASH_DASH] = ACTIONS(868),
    [anon_sym_new] = ACTIONS(870),
    [anon_sym_class] = ACTIONS(870),
    [anon_sym_SEMI] = ACTIONS(868),
    [anon_sym_LBRACE] = ACTIONS(868),
    [anon_sym_RBRACE] = ACTIONS(868),
    [anon_sym_assert] = ACTIONS(870),
    [anon_sym_switch] = ACTIONS(870),
    [anon_sym_case] = ACTIONS(870),
    [anon_sym_default] = ACTIONS(870),
    [anon_sym_do] = ACTIONS(870),
    [anon_sym_while] = ACTIONS(870),
    [anon_sym_break] = ACTIONS(870),
    [anon_sym_continue] = ACTIONS(870),
    [anon_sym_return] = ACTIONS(870),
    [anon_sym_synchronized] = ACTIONS(870),
    [anon_sym_throw] = ACTIONS(870),
    [anon_sym_try] = ACTIONS(870),
    [anon_sym_if] = ACTIONS(870),
    [anon_sym_else] = ACTIONS(870),
    [anon_sym_for] = ACTIONS(870),
    [anon_sym_AT] = ACTIONS(870),
    [anon_sym_open] = ACTIONS(870),
    [anon_sym_module] = ACTIONS(870),
    [anon_sym_static] = ACTIONS(870),
    [anon_sym_package] = ACTIONS(870),
    [anon_sym_import] = ACTIONS(870),
    [anon_sym_enum] = ACTIONS(870),
    [anon_sym_public] = ACTIONS(870),
    [anon_sym_protected] = ACTIONS(870),
    [anon_sym_private] = ACTIONS(870),
    [anon_sym_abstract] = ACTIONS(870),
    [anon_sym_final] = ACTIONS(870),
    [anon_sym_strictfp] = ACTIONS(870),
    [anon_sym_native] = ACTIONS(870),
    [anon_sym_transient] = ACTIONS(870),
    [anon_sym_volatile] = ACTIONS(870),
    [anon_sym_ATinterface] = ACTIONS(868),
    [anon_sym_interface] = ACTIONS(870),
    [anon_sym_byte] = ACTIONS(870),
    [anon_sym_short] = ACTIONS(870),
    [anon_sym_int] = ACTIONS(870),
    [anon_sym_long] = ACTIONS(870),
    [anon_sym_char] = ACTIONS(870),
    [anon_sym_float] = ACTIONS(870),
    [anon_sym_double] = ACTIONS(870),
    [sym_boolean_type] = ACTIONS(870),
    [sym_void_type] = ACTIONS(870),
    [sym_this] = ACTIONS(870),
    [sym_super] = ACTIONS(870),
    [sym_comment] = ACTIONS(3),
  },
  [196] = {
    [ts_builtin_sym_end] = ACTIONS(872),
    [sym_identifier] = ACTIONS(874),
    [sym_decimal_integer_literal] = ACTIONS(874),
    [sym_hex_integer_literal] = ACTIONS(874),
    [sym_octal_integer_literal] = ACTIONS(872),
    [sym_binary_integer_literal] = ACTIONS(872),
    [sym_decimal_floating_point_literal] = ACTIONS(872),
    [sym_hex_floating_point_literal] = ACTIONS(874),
    [sym_true] = ACTIONS(874),
    [sym_false] = ACTIONS(874),
    [sym_character_literal] = ACTIONS(872),
    [sym_string_literal] = ACTIONS(872),
    [sym_null_literal] = ACTIONS(874),
    [anon_sym_LPAREN] = ACTIONS(872),
    [anon_sym_PLUS] = ACTIONS(874),
    [anon_sym_DASH] = ACTIONS(874),
    [anon_sym_BANG] = ACTIONS(872),
    [anon_sym_TILDE] = ACTIONS(872),
    [anon_sym_PLUS_PLUS] = ACTIONS(872),
    [anon_sym_DASH_DASH] = ACTIONS(872),
    [anon_sym_new] = ACTIONS(874),
    [anon_sym_class] = ACTIONS(874),
    [anon_sym_SEMI] = ACTIONS(872),
    [anon_sym_LBRACE] = ACTIONS(872),
    [anon_sym_RBRACE] = ACTIONS(872),
    [anon_sym_assert] = ACTIONS(874),
    [anon_sym_switch] = ACTIONS(874),
    [anon_sym_case] = ACTIONS(874),
    [anon_sym_default] = ACTIONS(874),
    [anon_sym_do] = ACTIONS(874),
    [anon_sym_while] = ACTIONS(874),
    [anon_sym_break] = ACTIONS(874),
    [anon_sym_continue] = ACTIONS(874),
    [anon_sym_return] = ACTIONS(874),
    [anon_sym_synchronized] = ACTIONS(874),
    [anon_sym_throw] = ACTIONS(874),
    [anon_sym_try] = ACTIONS(874),
    [anon_sym_if] = ACTIONS(874),
    [anon_sym_else] = ACTIONS(874),
    [anon_sym_for] = ACTIONS(874),
    [anon_sym_AT] = ACTIONS(874),
    [anon_sym_open] = ACTIONS(874),
    [anon_sym_module] = ACTIONS(874),
    [anon_sym_static] = ACTIONS(874),
    [anon_sym_package] = ACTIONS(874),
    [anon_sym_import] = ACTIONS(874),
    [anon_sym_enum] = ACTIONS(874),
    [anon_sym_public] = ACTIONS(874),
    [anon_sym_protected] = ACTIONS(874),
    [anon_sym_private] = ACTIONS(874),
    [anon_sym_abstract] = ACTIONS(874),
    [anon_sym_final] = ACTIONS(874),
    [anon_sym_strictfp] = ACTIONS(874),
    [anon_sym_native] = ACTIONS(874),
    [anon_sym_transient] = ACTIONS(874),
    [anon_sym_volatile] = ACTIONS(874),
    [anon_sym_ATinterface] = ACTIONS(872),
    [anon_sym_interface] = ACTIONS(874),
    [anon_sym_byte] = ACTIONS(874),
    [anon_sym_short] = ACTIONS(874),
    [anon_sym_int] = ACTIONS(874),
    [anon_sym_long] = ACTIONS(874),
    [anon_sym_char] = ACTIONS(874),
    [anon_sym_float] = ACTIONS(874),
    [anon_sym_double] = ACTIONS(874),
    [sym_boolean_type] = ACTIONS(874),
    [sym_void_type] = ACTIONS(874),
    [sym_this] = ACTIONS(874),
    [sym_super] = ACTIONS(874),
    [sym_comment] = ACTIONS(3),
  },
  [197] = {
    [ts_builtin_sym_end] = ACTIONS(876),
    [sym_identifier] = ACTIONS(878),
    [sym_decimal_integer_literal] = ACTIONS(878),
    [sym_hex_integer_literal] = ACTIONS(878),
    [sym_octal_integer_literal] = ACTIONS(876),
    [sym_binary_integer_literal] = ACTIONS(876),
    [sym_decimal_floating_point_literal] = ACTIONS(876),
    [sym_hex_floating_point_literal] = ACTIONS(878),
    [sym_true] = ACTIONS(878),
    [sym_false] = ACTIONS(878),
    [sym_character_literal] = ACTIONS(876),
    [sym_string_literal] = ACTIONS(876),
    [sym_null_literal] = ACTIONS(878),
    [anon_sym_LPAREN] = ACTIONS(876),
    [anon_sym_PLUS] = ACTIONS(878),
    [anon_sym_DASH] = ACTIONS(878),
    [anon_sym_BANG] = ACTIONS(876),
    [anon_sym_TILDE] = ACTIONS(876),
    [anon_sym_PLUS_PLUS] = ACTIONS(876),
    [anon_sym_DASH_DASH] = ACTIONS(876),
    [anon_sym_new] = ACTIONS(878),
    [anon_sym_class] = ACTIONS(878),
    [anon_sym_SEMI] = ACTIONS(876),
    [anon_sym_LBRACE] = ACTIONS(876),
    [anon_sym_RBRACE] = ACTIONS(876),
    [anon_sym_assert] = ACTIONS(878),
    [anon_sym_switch] = ACTIONS(878),
    [anon_sym_case] = ACTIONS(878),
    [anon_sym_default] = ACTIONS(878),
    [anon_sym_do] = ACTIONS(878),
    [anon_sym_while] = ACTIONS(878),
    [anon_sym_break] = ACTIONS(878),
    [anon_sym_continue] = ACTIONS(878),
    [anon_sym_return] = ACTIONS(878),
    [anon_sym_synchronized] = ACTIONS(878),
    [anon_sym_throw] = ACTIONS(878),
    [anon_sym_try] = ACTIONS(878),
    [anon_sym_if] = ACTIONS(878),
    [anon_sym_else] = ACTIONS(878),
    [anon_sym_for] = ACTIONS(878),
    [anon_sym_AT] = ACTIONS(878),
    [anon_sym_open] = ACTIONS(878),
    [anon_sym_module] = ACTIONS(878),
    [anon_sym_static] = ACTIONS(878),
    [anon_sym_package] = ACTIONS(878),
    [anon_sym_import] = ACTIONS(878),
    [anon_sym_enum] = ACTIONS(878),
    [anon_sym_public] = ACTIONS(878),
    [anon_sym_protected] = ACTIONS(878),
    [anon_sym_private] = ACTIONS(878),
    [anon_sym_abstract] = ACTIONS(878),
    [anon_sym_final] = ACTIONS(878),
    [anon_sym_strictfp] = ACTIONS(878),
    [anon_sym_native] = ACTIONS(878),
    [anon_sym_transient] = ACTIONS(878),
    [anon_sym_volatile] = ACTIONS(878),
    [anon_sym_ATinterface] = ACTIONS(876),
    [anon_sym_interface] = ACTIONS(878),
    [anon_sym_byte] = ACTIONS(878),
    [anon_sym_short] = ACTIONS(878),
    [anon_sym_int] = ACTIONS(878),
    [anon_sym_long] = ACTIONS(878),
    [anon_sym_char] = ACTIONS(878),
    [anon_sym_float] = ACTIONS(878),
    [anon_sym_double] = ACTIONS(878),
    [sym_boolean_type] = ACTIONS(878),
    [sym_void_type] = ACTIONS(878),
    [sym_this] = ACTIONS(878),
    [sym_super] = ACTIONS(878),
    [sym_comment] = ACTIONS(3),
  },
  [198] = {
    [ts_builtin_sym_end] = ACTIONS(880),
    [sym_identifier] = ACTIONS(882),
    [sym_decimal_integer_literal] = ACTIONS(882),
    [sym_hex_integer_literal] = ACTIONS(882),
    [sym_octal_integer_literal] = ACTIONS(880),
    [sym_binary_integer_literal] = ACTIONS(880),
    [sym_decimal_floating_point_literal] = ACTIONS(880),
    [sym_hex_floating_point_literal] = ACTIONS(882),
    [sym_true] = ACTIONS(882),
    [sym_false] = ACTIONS(882),
    [sym_character_literal] = ACTIONS(880),
    [sym_string_literal] = ACTIONS(880),
    [sym_null_literal] = ACTIONS(882),
    [anon_sym_LPAREN] = ACTIONS(880),
    [anon_sym_PLUS] = ACTIONS(882),
    [anon_sym_DASH] = ACTIONS(882),
    [anon_sym_BANG] = ACTIONS(880),
    [anon_sym_TILDE] = ACTIONS(880),
    [anon_sym_PLUS_PLUS] = ACTIONS(880),
    [anon_sym_DASH_DASH] = ACTIONS(880),
    [anon_sym_new] = ACTIONS(882),
    [anon_sym_class] = ACTIONS(882),
    [anon_sym_SEMI] = ACTIONS(880),
    [anon_sym_LBRACE] = ACTIONS(880),
    [anon_sym_RBRACE] = ACTIONS(880),
    [anon_sym_assert] = ACTIONS(882),
    [anon_sym_switch] = ACTIONS(882),
    [anon_sym_case] = ACTIONS(882),
    [anon_sym_default] = ACTIONS(882),
    [anon_sym_do] = ACTIONS(882),
    [anon_sym_while] = ACTIONS(882),
    [anon_sym_break] = ACTIONS(882),
    [anon_sym_continue] = ACTIONS(882),
    [anon_sym_return] = ACTIONS(882),
    [anon_sym_synchronized] = ACTIONS(882),
    [anon_sym_throw] = ACTIONS(882),
    [anon_sym_try] = ACTIONS(882),
    [anon_sym_if] = ACTIONS(882),
    [anon_sym_else] = ACTIONS(882),
    [anon_sym_for] = ACTIONS(882),
    [anon_sym_AT] = ACTIONS(882),
    [anon_sym_open] = ACTIONS(882),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_static] = ACTIONS(882),
    [anon_sym_package] = ACTIONS(882),
    [anon_sym_import] = ACTIONS(882),
    [anon_sym_enum] = ACTIONS(882),
    [anon_sym_public] = ACTIONS(882),
    [anon_sym_protected] = ACTIONS(882),
    [anon_sym_private] = ACTIONS(882),
    [anon_sym_abstract] = ACTIONS(882),
    [anon_sym_final] = ACTIONS(882),
    [anon_sym_strictfp] = ACTIONS(882),
    [anon_sym_native] = ACTIONS(882),
    [anon_sym_transient] = ACTIONS(882),
    [anon_sym_volatile] = ACTIONS(882),
    [anon_sym_ATinterface] = ACTIONS(880),
    [anon_sym_interface] = ACTIONS(882),
    [anon_sym_byte] = ACTIONS(882),
    [anon_sym_short] = ACTIONS(882),
    [anon_sym_int] = ACTIONS(882),
    [anon_sym_long] = ACTIONS(882),
    [anon_sym_char] = ACTIONS(882),
    [anon_sym_float] = ACTIONS(882),
    [anon_sym_double] = ACTIONS(882),
    [sym_boolean_type] = ACTIONS(882),
    [sym_void_type] = ACTIONS(882),
    [sym_this] = ACTIONS(882),
    [sym_super] = ACTIONS(882),
    [sym_comment] = ACTIONS(3),
  },
  [199] = {
    [ts_builtin_sym_end] = ACTIONS(884),
    [sym_identifier] = ACTIONS(886),
    [sym_decimal_integer_literal] = ACTIONS(886),
    [sym_hex_integer_literal] = ACTIONS(886),
    [sym_octal_integer_literal] = ACTIONS(884),
    [sym_binary_integer_literal] = ACTIONS(884),
    [sym_decimal_floating_point_literal] = ACTIONS(884),
    [sym_hex_floating_point_literal] = ACTIONS(886),
    [sym_true] = ACTIONS(886),
    [sym_false] = ACTIONS(886),
    [sym_character_literal] = ACTIONS(884),
    [sym_string_literal] = ACTIONS(884),
    [sym_null_literal] = ACTIONS(886),
    [anon_sym_LPAREN] = ACTIONS(884),
    [anon_sym_PLUS] = ACTIONS(886),
    [anon_sym_DASH] = ACTIONS(886),
    [anon_sym_BANG] = ACTIONS(884),
    [anon_sym_TILDE] = ACTIONS(884),
    [anon_sym_PLUS_PLUS] = ACTIONS(884),
    [anon_sym_DASH_DASH] = ACTIONS(884),
    [anon_sym_new] = ACTIONS(886),
    [anon_sym_class] = ACTIONS(886),
    [anon_sym_SEMI] = ACTIONS(884),
    [anon_sym_LBRACE] = ACTIONS(884),
    [anon_sym_RBRACE] = ACTIONS(884),
    [anon_sym_assert] = ACTIONS(886),
    [anon_sym_switch] = ACTIONS(886),
    [anon_sym_case] = ACTIONS(886),
    [anon_sym_default] = ACTIONS(886),
    [anon_sym_do] = ACTIONS(886),
    [anon_sym_while] = ACTIONS(886),
    [anon_sym_break] = ACTIONS(886),
    [anon_sym_continue] = ACTIONS(886),
    [anon_sym_return] = ACTIONS(886),
    [anon_sym_synchronized] = ACTIONS(886),
    [anon_sym_throw] = ACTIONS(886),
    [anon_sym_try] = ACTIONS(886),
    [anon_sym_if] = ACTIONS(886),
    [anon_sym_else] = ACTIONS(886),
    [anon_sym_for] = ACTIONS(886),
    [anon_sym_AT] = ACTIONS(886),
    [anon_sym_open] = ACTIONS(886),
    [anon_sym_module] = ACTIONS(886),
    [anon_sym_static] = ACTIONS(886),
    [anon_sym_package] = ACTIONS(886),
    [anon_sym_import] = ACTIONS(886),
    [anon_sym_enum] = ACTIONS(886),
    [anon_sym_public] = ACTIONS(886),
    [anon_sym_protected] = ACTIONS(886),
    [anon_sym_private] = ACTIONS(886),
    [anon_sym_abstract] = ACTIONS(886),
    [anon_sym_final] = ACTIONS(886),
    [anon_sym_strictfp] = ACTIONS(886),
    [anon_sym_native] = ACTIONS(886),
    [anon_sym_transient] = ACTIONS(886),
    [anon_sym_volatile] = ACTIONS(886),
    [anon_sym_ATinterface] = ACTIONS(884),
    [anon_sym_interface] = ACTIONS(886),
    [anon_sym_byte] = ACTIONS(886),
    [anon_sym_short] = ACTIONS(886),
    [anon_sym_int] = ACTIONS(886),
    [anon_sym_long] = ACTIONS(886),
    [anon_sym_char] = ACTIONS(886),
    [anon_sym_float] = ACTIONS(886),
    [anon_sym_double] = ACTIONS(886),
    [sym_boolean_type] = ACTIONS(886),
    [sym_void_type] = ACTIONS(886),
    [sym_this] = ACTIONS(886),
    [sym_super] = ACTIONS(886),
    [sym_comment] = ACTIONS(3),
  },
  [200] = {
    [ts_builtin_sym_end] = ACTIONS(888),
    [sym_identifier] = ACTIONS(890),
    [sym_decimal_integer_literal] = ACTIONS(890),
    [sym_hex_integer_literal] = ACTIONS(890),
    [sym_octal_integer_literal] = ACTIONS(888),
    [sym_binary_integer_literal] = ACTIONS(888),
    [sym_decimal_floating_point_literal] = ACTIONS(888),
    [sym_hex_floating_point_literal] = ACTIONS(890),
    [sym_true] = ACTIONS(890),
    [sym_false] = ACTIONS(890),
    [sym_character_literal] = ACTIONS(888),
    [sym_string_literal] = ACTIONS(888),
    [sym_null_literal] = ACTIONS(890),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(890),
    [anon_sym_DASH] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(888),
    [anon_sym_TILDE] = ACTIONS(888),
    [anon_sym_PLUS_PLUS] = ACTIONS(888),
    [anon_sym_DASH_DASH] = ACTIONS(888),
    [anon_sym_new] = ACTIONS(890),
    [anon_sym_class] = ACTIONS(890),
    [anon_sym_SEMI] = ACTIONS(888),
    [anon_sym_LBRACE] = ACTIONS(888),
    [anon_sym_RBRACE] = ACTIONS(888),
    [anon_sym_assert] = ACTIONS(890),
    [anon_sym_switch] = ACTIONS(890),
    [anon_sym_case] = ACTIONS(890),
    [anon_sym_default] = ACTIONS(890),
    [anon_sym_do] = ACTIONS(890),
    [anon_sym_while] = ACTIONS(890),
    [anon_sym_break] = ACTIONS(890),
    [anon_sym_continue] = ACTIONS(890),
    [anon_sym_return] = ACTIONS(890),
    [anon_sym_synchronized] = ACTIONS(890),
    [anon_sym_throw] = ACTIONS(890),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_if] = ACTIONS(890),
    [anon_sym_else] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(890),
    [anon_sym_AT] = ACTIONS(890),
    [anon_sym_open] = ACTIONS(890),
    [anon_sym_module] = ACTIONS(890),
    [anon_sym_static] = ACTIONS(890),
    [anon_sym_package] = ACTIONS(890),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_enum] = ACTIONS(890),
    [anon_sym_public] = ACTIONS(890),
    [anon_sym_protected] = ACTIONS(890),
    [anon_sym_private] = ACTIONS(890),
    [anon_sym_abstract] = ACTIONS(890),
    [anon_sym_final] = ACTIONS(890),
    [anon_sym_strictfp] = ACTIONS(890),
    [anon_sym_native] = ACTIONS(890),
    [anon_sym_transient] = ACTIONS(890),
    [anon_sym_volatile] = ACTIONS(890),
    [anon_sym_ATinterface] = ACTIONS(888),
    [anon_sym_interface] = ACTIONS(890),
    [anon_sym_byte] = ACTIONS(890),
    [anon_sym_short] = ACTIONS(890),
    [anon_sym_int] = ACTIONS(890),
    [anon_sym_long] = ACTIONS(890),
    [anon_sym_char] = ACTIONS(890),
    [anon_sym_float] = ACTIONS(890),
    [anon_sym_double] = ACTIONS(890),
    [sym_boolean_type] = ACTIONS(890),
    [sym_void_type] = ACTIONS(890),
    [sym_this] = ACTIONS(890),
    [sym_super] = ACTIONS(890),
    [sym_comment] = ACTIONS(3),
  },
  [201] = {
    [ts_builtin_sym_end] = ACTIONS(892),
    [sym_identifier] = ACTIONS(894),
    [sym_decimal_integer_literal] = ACTIONS(894),
    [sym_hex_integer_literal] = ACTIONS(894),
    [sym_octal_integer_literal] = ACTIONS(892),
    [sym_binary_integer_literal] = ACTIONS(892),
    [sym_decimal_floating_point_literal] = ACTIONS(892),
    [sym_hex_floating_point_literal] = ACTIONS(894),
    [sym_true] = ACTIONS(894),
    [sym_false] = ACTIONS(894),
    [sym_character_literal] = ACTIONS(892),
    [sym_string_literal] = ACTIONS(892),
    [sym_null_literal] = ACTIONS(894),
    [anon_sym_LPAREN] = ACTIONS(892),
    [anon_sym_PLUS] = ACTIONS(894),
    [anon_sym_DASH] = ACTIONS(894),
    [anon_sym_BANG] = ACTIONS(892),
    [anon_sym_TILDE] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_new] = ACTIONS(894),
    [anon_sym_class] = ACTIONS(894),
    [anon_sym_SEMI] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(892),
    [anon_sym_RBRACE] = ACTIONS(892),
    [anon_sym_assert] = ACTIONS(894),
    [anon_sym_switch] = ACTIONS(894),
    [anon_sym_case] = ACTIONS(894),
    [anon_sym_default] = ACTIONS(894),
    [anon_sym_do] = ACTIONS(894),
    [anon_sym_while] = ACTIONS(894),
    [anon_sym_break] = ACTIONS(894),
    [anon_sym_continue] = ACTIONS(894),
    [anon_sym_return] = ACTIONS(894),
    [anon_sym_synchronized] = ACTIONS(894),
    [anon_sym_throw] = ACTIONS(894),
    [anon_sym_try] = ACTIONS(894),
    [anon_sym_if] = ACTIONS(894),
    [anon_sym_else] = ACTIONS(894),
    [anon_sym_for] = ACTIONS(894),
    [anon_sym_AT] = ACTIONS(894),
    [anon_sym_open] = ACTIONS(894),
    [anon_sym_module] = ACTIONS(894),
    [anon_sym_static] = ACTIONS(894),
    [anon_sym_package] = ACTIONS(894),
    [anon_sym_import] = ACTIONS(894),
    [anon_sym_enum] = ACTIONS(894),
    [anon_sym_public] = ACTIONS(894),
    [anon_sym_protected] = ACTIONS(894),
    [anon_sym_private] = ACTIONS(894),
    [anon_sym_abstract] = ACTIONS(894),
    [anon_sym_final] = ACTIONS(894),
    [anon_sym_strictfp] = ACTIONS(894),
    [anon_sym_native] = ACTIONS(894),
    [anon_sym_transient] = ACTIONS(894),
    [anon_sym_volatile] = ACTIONS(894),
    [anon_sym_ATinterface] = ACTIONS(892),
    [anon_sym_interface] = ACTIONS(894),
    [anon_sym_byte] = ACTIONS(894),
    [anon_sym_short] = ACTIONS(894),
    [anon_sym_int] = ACTIONS(894),
    [anon_sym_long] = ACTIONS(894),
    [anon_sym_char] = ACTIONS(894),
    [anon_sym_float] = ACTIONS(894),
    [anon_sym_double] = ACTIONS(894),
    [sym_boolean_type] = ACTIONS(894),
    [sym_void_type] = ACTIONS(894),
    [sym_this] = ACTIONS(894),
    [sym_super] = ACTIONS(894),
    [sym_comment] = ACTIONS(3),
  },
  [202] = {
    [ts_builtin_sym_end] = ACTIONS(896),
    [sym_identifier] = ACTIONS(898),
    [sym_decimal_integer_literal] = ACTIONS(898),
    [sym_hex_integer_literal] = ACTIONS(898),
    [sym_octal_integer_literal] = ACTIONS(896),
    [sym_binary_integer_literal] = ACTIONS(896),
    [sym_decimal_floating_point_literal] = ACTIONS(896),
    [sym_hex_floating_point_literal] = ACTIONS(898),
    [sym_true] = ACTIONS(898),
    [sym_false] = ACTIONS(898),
    [sym_character_literal] = ACTIONS(896),
    [sym_string_literal] = ACTIONS(896),
    [sym_null_literal] = ACTIONS(898),
    [anon_sym_LPAREN] = ACTIONS(896),
    [anon_sym_PLUS] = ACTIONS(898),
    [anon_sym_DASH] = ACTIONS(898),
    [anon_sym_BANG] = ACTIONS(896),
    [anon_sym_TILDE] = ACTIONS(896),
    [anon_sym_PLUS_PLUS] = ACTIONS(896),
    [anon_sym_DASH_DASH] = ACTIONS(896),
    [anon_sym_new] = ACTIONS(898),
    [anon_sym_class] = ACTIONS(898),
    [anon_sym_SEMI] = ACTIONS(896),
    [anon_sym_LBRACE] = ACTIONS(896),
    [anon_sym_RBRACE] = ACTIONS(896),
    [anon_sym_assert] = ACTIONS(898),
    [anon_sym_switch] = ACTIONS(898),
    [anon_sym_case] = ACTIONS(898),
    [anon_sym_default] = ACTIONS(898),
    [anon_sym_do] = ACTIONS(898),
    [anon_sym_while] = ACTIONS(898),
    [anon_sym_break] = ACTIONS(898),
    [anon_sym_continue] = ACTIONS(898),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_synchronized] = ACTIONS(898),
    [anon_sym_throw] = ACTIONS(898),
    [anon_sym_try] = ACTIONS(898),
    [anon_sym_if] = ACTIONS(898),
    [anon_sym_else] = ACTIONS(898),
    [anon_sym_for] = ACTIONS(898),
    [anon_sym_AT] = ACTIONS(898),
    [anon_sym_open] = ACTIONS(898),
    [anon_sym_module] = ACTIONS(898),
    [anon_sym_static] = ACTIONS(898),
    [anon_sym_package] = ACTIONS(898),
    [anon_sym_import] = ACTIONS(898),
    [anon_sym_enum] = ACTIONS(898),
    [anon_sym_public] = ACTIONS(898),
    [anon_sym_protected] = ACTIONS(898),
    [anon_sym_private] = ACTIONS(898),
    [anon_sym_abstract] = ACTIONS(898),
    [anon_sym_final] = ACTIONS(898),
    [anon_sym_strictfp] = ACTIONS(898),
    [anon_sym_native] = ACTIONS(898),
    [anon_sym_transient] = ACTIONS(898),
    [anon_sym_volatile] = ACTIONS(898),
    [anon_sym_ATinterface] = ACTIONS(896),
    [anon_sym_interface] = ACTIONS(898),
    [anon_sym_byte] = ACTIONS(898),
    [anon_sym_short] = ACTIONS(898),
    [anon_sym_int] = ACTIONS(898),
    [anon_sym_long] = ACTIONS(898),
    [anon_sym_char] = ACTIONS(898),
    [anon_sym_float] = ACTIONS(898),
    [anon_sym_double] = ACTIONS(898),
    [sym_boolean_type] = ACTIONS(898),
    [sym_void_type] = ACTIONS(898),
    [sym_this] = ACTIONS(898),
    [sym_super] = ACTIONS(898),
    [sym_comment] = ACTIONS(3),
  },
  [203] = {
    [ts_builtin_sym_end] = ACTIONS(900),
    [sym_identifier] = ACTIONS(902),
    [sym_decimal_integer_literal] = ACTIONS(902),
    [sym_hex_integer_literal] = ACTIONS(902),
    [sym_octal_integer_literal] = ACTIONS(900),
    [sym_binary_integer_literal] = ACTIONS(900),
    [sym_decimal_floating_point_literal] = ACTIONS(900),
    [sym_hex_floating_point_literal] = ACTIONS(902),
    [sym_true] = ACTIONS(902),
    [sym_false] = ACTIONS(902),
    [sym_character_literal] = ACTIONS(900),
    [sym_string_literal] = ACTIONS(900),
    [sym_null_literal] = ACTIONS(902),
    [anon_sym_LPAREN] = ACTIONS(900),
    [anon_sym_PLUS] = ACTIONS(902),
    [anon_sym_DASH] = ACTIONS(902),
    [anon_sym_BANG] = ACTIONS(900),
    [anon_sym_TILDE] = ACTIONS(900),
    [anon_sym_PLUS_PLUS] = ACTIONS(900),
    [anon_sym_DASH_DASH] = ACTIONS(900),
    [anon_sym_new] = ACTIONS(902),
    [anon_sym_class] = ACTIONS(902),
    [anon_sym_SEMI] = ACTIONS(900),
    [anon_sym_LBRACE] = ACTIONS(900),
    [anon_sym_RBRACE] = ACTIONS(900),
    [anon_sym_assert] = ACTIONS(902),
    [anon_sym_switch] = ACTIONS(902),
    [anon_sym_case] = ACTIONS(902),
    [anon_sym_default] = ACTIONS(902),
    [anon_sym_do] = ACTIONS(902),
    [anon_sym_while] = ACTIONS(902),
    [anon_sym_break] = ACTIONS(902),
    [anon_sym_continue] = ACTIONS(902),
    [anon_sym_return] = ACTIONS(902),
    [anon_sym_synchronized] = ACTIONS(902),
    [anon_sym_throw] = ACTIONS(902),
    [anon_sym_try] = ACTIONS(902),
    [anon_sym_if] = ACTIONS(902),
    [anon_sym_else] = ACTIONS(902),
    [anon_sym_for] = ACTIONS(902),
    [anon_sym_AT] = ACTIONS(902),
    [anon_sym_open] = ACTIONS(902),
    [anon_sym_module] = ACTIONS(902),
    [anon_sym_static] = ACTIONS(902),
    [anon_sym_package] = ACTIONS(902),
    [anon_sym_import] = ACTIONS(902),
    [anon_sym_enum] = ACTIONS(902),
    [anon_sym_public] = ACTIONS(902),
    [anon_sym_protected] = ACTIONS(902),
    [anon_sym_private] = ACTIONS(902),
    [anon_sym_abstract] = ACTIONS(902),
    [anon_sym_final] = ACTIONS(902),
    [anon_sym_strictfp] = ACTIONS(902),
    [anon_sym_native] = ACTIONS(902),
    [anon_sym_transient] = ACTIONS(902),
    [anon_sym_volatile] = ACTIONS(902),
    [anon_sym_ATinterface] = ACTIONS(900),
    [anon_sym_interface] = ACTIONS(902),
    [anon_sym_byte] = ACTIONS(902),
    [anon_sym_short] = ACTIONS(902),
    [anon_sym_int] = ACTIONS(902),
    [anon_sym_long] = ACTIONS(902),
    [anon_sym_char] = ACTIONS(902),
    [anon_sym_float] = ACTIONS(902),
    [anon_sym_double] = ACTIONS(902),
    [sym_boolean_type] = ACTIONS(902),
    [sym_void_type] = ACTIONS(902),
    [sym_this] = ACTIONS(902),
    [sym_super] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
  },
  [204] = {
    [ts_builtin_sym_end] = ACTIONS(904),
    [sym_identifier] = ACTIONS(906),
    [sym_decimal_integer_literal] = ACTIONS(906),
    [sym_hex_integer_literal] = ACTIONS(906),
    [sym_octal_integer_literal] = ACTIONS(904),
    [sym_binary_integer_literal] = ACTIONS(904),
    [sym_decimal_floating_point_literal] = ACTIONS(904),
    [sym_hex_floating_point_literal] = ACTIONS(906),
    [sym_true] = ACTIONS(906),
    [sym_false] = ACTIONS(906),
    [sym_character_literal] = ACTIONS(904),
    [sym_string_literal] = ACTIONS(904),
    [sym_null_literal] = ACTIONS(906),
    [anon_sym_LPAREN] = ACTIONS(904),
    [anon_sym_PLUS] = ACTIONS(906),
    [anon_sym_DASH] = ACTIONS(906),
    [anon_sym_BANG] = ACTIONS(904),
    [anon_sym_TILDE] = ACTIONS(904),
    [anon_sym_PLUS_PLUS] = ACTIONS(904),
    [anon_sym_DASH_DASH] = ACTIONS(904),
    [anon_sym_new] = ACTIONS(906),
    [anon_sym_class] = ACTIONS(906),
    [anon_sym_SEMI] = ACTIONS(904),
    [anon_sym_LBRACE] = ACTIONS(904),
    [anon_sym_RBRACE] = ACTIONS(904),
    [anon_sym_assert] = ACTIONS(906),
    [anon_sym_switch] = ACTIONS(906),
    [anon_sym_case] = ACTIONS(906),
    [anon_sym_default] = ACTIONS(906),
    [anon_sym_do] = ACTIONS(906),
    [anon_sym_while] = ACTIONS(906),
    [anon_sym_break] = ACTIONS(906),
    [anon_sym_continue] = ACTIONS(906),
    [anon_sym_return] = ACTIONS(906),
    [anon_sym_synchronized] = ACTIONS(906),
    [anon_sym_throw] = ACTIONS(906),
    [anon_sym_try] = ACTIONS(906),
    [anon_sym_if] = ACTIONS(906),
    [anon_sym_else] = ACTIONS(906),
    [anon_sym_for] = ACTIONS(906),
    [anon_sym_AT] = ACTIONS(906),
    [anon_sym_open] = ACTIONS(906),
    [anon_sym_module] = ACTIONS(906),
    [anon_sym_static] = ACTIONS(906),
    [anon_sym_package] = ACTIONS(906),
    [anon_sym_import] = ACTIONS(906),
    [anon_sym_enum] = ACTIONS(906),
    [anon_sym_public] = ACTIONS(906),
    [anon_sym_protected] = ACTIONS(906),
    [anon_sym_private] = ACTIONS(906),
    [anon_sym_abstract] = ACTIONS(906),
    [anon_sym_final] = ACTIONS(906),
    [anon_sym_strictfp] = ACTIONS(906),
    [anon_sym_native] = ACTIONS(906),
    [anon_sym_transient] = ACTIONS(906),
    [anon_sym_volatile] = ACTIONS(906),
    [anon_sym_ATinterface] = ACTIONS(904),
    [anon_sym_interface] = ACTIONS(906),
    [anon_sym_byte] = ACTIONS(906),
    [anon_sym_short] = ACTIONS(906),
    [anon_sym_int] = ACTIONS(906),
    [anon_sym_long] = ACTIONS(906),
    [anon_sym_char] = ACTIONS(906),
    [anon_sym_float] = ACTIONS(906),
    [anon_sym_double] = ACTIONS(906),
    [sym_boolean_type] = ACTIONS(906),
    [sym_void_type] = ACTIONS(906),
    [sym_this] = ACTIONS(906),
    [sym_super] = ACTIONS(906),
    [sym_comment] = ACTIONS(3),
  },
  [205] = {
    [ts_builtin_sym_end] = ACTIONS(908),
    [sym_identifier] = ACTIONS(910),
    [sym_decimal_integer_literal] = ACTIONS(910),
    [sym_hex_integer_literal] = ACTIONS(910),
    [sym_octal_integer_literal] = ACTIONS(908),
    [sym_binary_integer_literal] = ACTIONS(908),
    [sym_decimal_floating_point_literal] = ACTIONS(908),
    [sym_hex_floating_point_literal] = ACTIONS(910),
    [sym_true] = ACTIONS(910),
    [sym_false] = ACTIONS(910),
    [sym_character_literal] = ACTIONS(908),
    [sym_string_literal] = ACTIONS(908),
    [sym_null_literal] = ACTIONS(910),
    [anon_sym_LPAREN] = ACTIONS(908),
    [anon_sym_PLUS] = ACTIONS(910),
    [anon_sym_DASH] = ACTIONS(910),
    [anon_sym_BANG] = ACTIONS(908),
    [anon_sym_TILDE] = ACTIONS(908),
    [anon_sym_PLUS_PLUS] = ACTIONS(908),
    [anon_sym_DASH_DASH] = ACTIONS(908),
    [anon_sym_new] = ACTIONS(910),
    [anon_sym_class] = ACTIONS(910),
    [anon_sym_SEMI] = ACTIONS(908),
    [anon_sym_LBRACE] = ACTIONS(908),
    [anon_sym_RBRACE] = ACTIONS(908),
    [anon_sym_assert] = ACTIONS(910),
    [anon_sym_switch] = ACTIONS(910),
    [anon_sym_case] = ACTIONS(910),
    [anon_sym_default] = ACTIONS(910),
    [anon_sym_do] = ACTIONS(910),
    [anon_sym_while] = ACTIONS(910),
    [anon_sym_break] = ACTIONS(910),
    [anon_sym_continue] = ACTIONS(910),
    [anon_sym_return] = ACTIONS(910),
    [anon_sym_synchronized] = ACTIONS(910),
    [anon_sym_throw] = ACTIONS(910),
    [anon_sym_try] = ACTIONS(910),
    [anon_sym_if] = ACTIONS(910),
    [anon_sym_else] = ACTIONS(910),
    [anon_sym_for] = ACTIONS(910),
    [anon_sym_AT] = ACTIONS(910),
    [anon_sym_open] = ACTIONS(910),
    [anon_sym_module] = ACTIONS(910),
    [anon_sym_static] = ACTIONS(910),
    [anon_sym_package] = ACTIONS(910),
    [anon_sym_import] = ACTIONS(910),
    [anon_sym_enum] = ACTIONS(910),
    [anon_sym_public] = ACTIONS(910),
    [anon_sym_protected] = ACTIONS(910),
    [anon_sym_private] = ACTIONS(910),
    [anon_sym_abstract] = ACTIONS(910),
    [anon_sym_final] = ACTIONS(910),
    [anon_sym_strictfp] = ACTIONS(910),
    [anon_sym_native] = ACTIONS(910),
    [anon_sym_transient] = ACTIONS(910),
    [anon_sym_volatile] = ACTIONS(910),
    [anon_sym_ATinterface] = ACTIONS(908),
    [anon_sym_interface] = ACTIONS(910),
    [anon_sym_byte] = ACTIONS(910),
    [anon_sym_short] = ACTIONS(910),
    [anon_sym_int] = ACTIONS(910),
    [anon_sym_long] = ACTIONS(910),
    [anon_sym_char] = ACTIONS(910),
    [anon_sym_float] = ACTIONS(910),
    [anon_sym_double] = ACTIONS(910),
    [sym_boolean_type] = ACTIONS(910),
    [sym_void_type] = ACTIONS(910),
    [sym_this] = ACTIONS(910),
    [sym_super] = ACTIONS(910),
    [sym_comment] = ACTIONS(3),
  },
  [206] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(389),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [207] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(446),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [208] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(437),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [209] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(402),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [210] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(397),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [211] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(458),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [212] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(379),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [213] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(380),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [214] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(400),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [215] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(442),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [216] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(396),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [217] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(438),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [218] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(395),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [219] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(394),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [220] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(450),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [221] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(384),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [222] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(386),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [223] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(455),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [224] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(436),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [225] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(459),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [226] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(439),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [227] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(444),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [228] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(445),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [229] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(382),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [230] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(432),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [231] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(461),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [232] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(460),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [233] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(434),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [234] = {
    [sym__literal] = STATE(316),
    [sym_expression] = STATE(388),
    [sym_cast_expression] = STATE(390),
    [sym_assignment_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_instanceof_expression] = STATE(390),
    [sym_lambda_expression] = STATE(390),
    [sym_inferred_parameters] = STATE(884),
    [sym_ternary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_primary_expression] = STATE(311),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(269),
    [sym_array_access] = STATE(269),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym__annotation] = STATE(485),
    [sym_marker_annotation] = STATE(485),
    [sym_annotation] = STATE(485),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(564),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [sym_formal_parameters] = STATE(884),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [sym_identifier] = ACTIONS(373),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(371),
    [anon_sym_module] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [235] = {
    [sym_identifier] = ACTIONS(912),
    [sym_decimal_integer_literal] = ACTIONS(912),
    [sym_hex_integer_literal] = ACTIONS(912),
    [sym_octal_integer_literal] = ACTIONS(914),
    [sym_binary_integer_literal] = ACTIONS(914),
    [sym_decimal_floating_point_literal] = ACTIONS(914),
    [sym_hex_floating_point_literal] = ACTIONS(912),
    [sym_true] = ACTIONS(912),
    [sym_false] = ACTIONS(912),
    [sym_character_literal] = ACTIONS(914),
    [sym_string_literal] = ACTIONS(914),
    [sym_null_literal] = ACTIONS(912),
    [anon_sym_LPAREN] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(912),
    [anon_sym_DASH] = ACTIONS(912),
    [anon_sym_BANG] = ACTIONS(914),
    [anon_sym_TILDE] = ACTIONS(914),
    [anon_sym_PLUS_PLUS] = ACTIONS(914),
    [anon_sym_DASH_DASH] = ACTIONS(914),
    [anon_sym_new] = ACTIONS(912),
    [anon_sym_class] = ACTIONS(912),
    [anon_sym_SEMI] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(914),
    [anon_sym_RBRACE] = ACTIONS(914),
    [anon_sym_assert] = ACTIONS(912),
    [anon_sym_switch] = ACTIONS(912),
    [anon_sym_case] = ACTIONS(912),
    [anon_sym_default] = ACTIONS(912),
    [anon_sym_do] = ACTIONS(912),
    [anon_sym_while] = ACTIONS(912),
    [anon_sym_break] = ACTIONS(912),
    [anon_sym_continue] = ACTIONS(912),
    [anon_sym_return] = ACTIONS(912),
    [anon_sym_synchronized] = ACTIONS(912),
    [anon_sym_throw] = ACTIONS(912),
    [anon_sym_try] = ACTIONS(912),
    [anon_sym_if] = ACTIONS(912),
    [anon_sym_for] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(912),
    [anon_sym_open] = ACTIONS(912),
    [anon_sym_module] = ACTIONS(912),
    [anon_sym_static] = ACTIONS(912),
    [anon_sym_package] = ACTIONS(912),
    [anon_sym_import] = ACTIONS(912),
    [anon_sym_enum] = ACTIONS(912),
    [anon_sym_public] = ACTIONS(912),
    [anon_sym_protected] = ACTIONS(912),
    [anon_sym_private] = ACTIONS(912),
    [anon_sym_abstract] = ACTIONS(912),
    [anon_sym_final] = ACTIONS(912),
    [anon_sym_strictfp] = ACTIONS(912),
    [anon_sym_native] = ACTIONS(912),
    [anon_sym_transient] = ACTIONS(912),
    [anon_sym_volatile] = ACTIONS(912),
    [anon_sym_ATinterface] = ACTIONS(914),
    [anon_sym_interface] = ACTIONS(912),
    [anon_sym_byte] = ACTIONS(912),
    [anon_sym_short] = ACTIONS(912),
    [anon_sym_int] = ACTIONS(912),
    [anon_sym_long] = ACTIONS(912),
    [anon_sym_char] = ACTIONS(912),
    [anon_sym_float] = ACTIONS(912),
    [anon_sym_double] = ACTIONS(912),
    [sym_boolean_type] = ACTIONS(912),
    [sym_void_type] = ACTIONS(912),
    [sym_this] = ACTIONS(912),
    [sym_super] = ACTIONS(912),
    [sym_comment] = ACTIONS(3),
  },
  [236] = {
    [sym__literal] = STATE(316),
    [sym_primary_expression] = STATE(793),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(640),
    [sym_array_access] = STATE(316),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_resource] = STATE(807),
    [sym__annotation] = STATE(468),
    [sym_marker_annotation] = STATE(468),
    [sym_annotation] = STATE(468),
    [sym_modifiers] = STATE(514),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(532),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [aux_sym_modifiers_repeat1] = STATE(404),
    [sym_identifier] = ACTIONS(916),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(918),
    [anon_sym_RPAREN] = ACTIONS(920),
    [anon_sym_new] = ACTIONS(922),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(924),
    [anon_sym_module] = ACTIONS(924),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [237] = {
    [sym__literal] = STATE(316),
    [sym_primary_expression] = STATE(793),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(640),
    [sym_array_access] = STATE(316),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_resource] = STATE(807),
    [sym__annotation] = STATE(468),
    [sym_marker_annotation] = STATE(468),
    [sym_annotation] = STATE(468),
    [sym_modifiers] = STATE(514),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(532),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [aux_sym_modifiers_repeat1] = STATE(404),
    [sym_identifier] = ACTIONS(916),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(918),
    [anon_sym_RPAREN] = ACTIONS(926),
    [anon_sym_new] = ACTIONS(922),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(924),
    [anon_sym_module] = ACTIONS(924),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [238] = {
    [sym_identifier] = ACTIONS(928),
    [sym_decimal_integer_literal] = ACTIONS(928),
    [sym_hex_integer_literal] = ACTIONS(928),
    [sym_octal_integer_literal] = ACTIONS(930),
    [sym_binary_integer_literal] = ACTIONS(930),
    [sym_decimal_floating_point_literal] = ACTIONS(930),
    [sym_hex_floating_point_literal] = ACTIONS(928),
    [sym_true] = ACTIONS(928),
    [sym_false] = ACTIONS(928),
    [sym_character_literal] = ACTIONS(930),
    [sym_string_literal] = ACTIONS(930),
    [sym_null_literal] = ACTIONS(928),
    [anon_sym_LPAREN] = ACTIONS(930),
    [anon_sym_PLUS] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(928),
    [anon_sym_BANG] = ACTIONS(930),
    [anon_sym_TILDE] = ACTIONS(930),
    [anon_sym_PLUS_PLUS] = ACTIONS(930),
    [anon_sym_DASH_DASH] = ACTIONS(930),
    [anon_sym_new] = ACTIONS(928),
    [anon_sym_class] = ACTIONS(928),
    [anon_sym_SEMI] = ACTIONS(930),
    [anon_sym_LBRACE] = ACTIONS(930),
    [anon_sym_RBRACE] = ACTIONS(930),
    [anon_sym_assert] = ACTIONS(928),
    [anon_sym_switch] = ACTIONS(928),
    [anon_sym_case] = ACTIONS(928),
    [anon_sym_default] = ACTIONS(928),
    [anon_sym_do] = ACTIONS(928),
    [anon_sym_while] = ACTIONS(928),
    [anon_sym_break] = ACTIONS(928),
    [anon_sym_continue] = ACTIONS(928),
    [anon_sym_return] = ACTIONS(928),
    [anon_sym_synchronized] = ACTIONS(928),
    [anon_sym_throw] = ACTIONS(928),
    [anon_sym_try] = ACTIONS(928),
    [anon_sym_if] = ACTIONS(928),
    [anon_sym_for] = ACTIONS(928),
    [anon_sym_AT] = ACTIONS(928),
    [anon_sym_open] = ACTIONS(928),
    [anon_sym_module] = ACTIONS(928),
    [anon_sym_static] = ACTIONS(928),
    [anon_sym_package] = ACTIONS(928),
    [anon_sym_import] = ACTIONS(928),
    [anon_sym_enum] = ACTIONS(928),
    [anon_sym_public] = ACTIONS(928),
    [anon_sym_protected] = ACTIONS(928),
    [anon_sym_private] = ACTIONS(928),
    [anon_sym_abstract] = ACTIONS(928),
    [anon_sym_final] = ACTIONS(928),
    [anon_sym_strictfp] = ACTIONS(928),
    [anon_sym_native] = ACTIONS(928),
    [anon_sym_transient] = ACTIONS(928),
    [anon_sym_volatile] = ACTIONS(928),
    [anon_sym_ATinterface] = ACTIONS(930),
    [anon_sym_interface] = ACTIONS(928),
    [anon_sym_byte] = ACTIONS(928),
    [anon_sym_short] = ACTIONS(928),
    [anon_sym_int] = ACTIONS(928),
    [anon_sym_long] = ACTIONS(928),
    [anon_sym_char] = ACTIONS(928),
    [anon_sym_float] = ACTIONS(928),
    [anon_sym_double] = ACTIONS(928),
    [sym_boolean_type] = ACTIONS(928),
    [sym_void_type] = ACTIONS(928),
    [sym_this] = ACTIONS(928),
    [sym_super] = ACTIONS(928),
    [sym_comment] = ACTIONS(3),
  },
  [239] = {
    [sym_identifier] = ACTIONS(932),
    [sym_decimal_integer_literal] = ACTIONS(932),
    [sym_hex_integer_literal] = ACTIONS(932),
    [sym_octal_integer_literal] = ACTIONS(934),
    [sym_binary_integer_literal] = ACTIONS(934),
    [sym_decimal_floating_point_literal] = ACTIONS(934),
    [sym_hex_floating_point_literal] = ACTIONS(932),
    [sym_true] = ACTIONS(932),
    [sym_false] = ACTIONS(932),
    [sym_character_literal] = ACTIONS(934),
    [sym_string_literal] = ACTIONS(934),
    [sym_null_literal] = ACTIONS(932),
    [anon_sym_LPAREN] = ACTIONS(934),
    [anon_sym_PLUS] = ACTIONS(932),
    [anon_sym_DASH] = ACTIONS(932),
    [anon_sym_BANG] = ACTIONS(934),
    [anon_sym_TILDE] = ACTIONS(934),
    [anon_sym_PLUS_PLUS] = ACTIONS(934),
    [anon_sym_DASH_DASH] = ACTIONS(934),
    [anon_sym_new] = ACTIONS(932),
    [anon_sym_class] = ACTIONS(932),
    [anon_sym_SEMI] = ACTIONS(934),
    [anon_sym_LBRACE] = ACTIONS(934),
    [anon_sym_RBRACE] = ACTIONS(934),
    [anon_sym_assert] = ACTIONS(932),
    [anon_sym_switch] = ACTIONS(932),
    [anon_sym_default] = ACTIONS(932),
    [anon_sym_do] = ACTIONS(932),
    [anon_sym_while] = ACTIONS(932),
    [anon_sym_break] = ACTIONS(932),
    [anon_sym_continue] = ACTIONS(932),
    [anon_sym_return] = ACTIONS(932),
    [anon_sym_synchronized] = ACTIONS(932),
    [anon_sym_throw] = ACTIONS(932),
    [anon_sym_try] = ACTIONS(932),
    [anon_sym_if] = ACTIONS(932),
    [anon_sym_for] = ACTIONS(932),
    [anon_sym_AT] = ACTIONS(932),
    [anon_sym_open] = ACTIONS(932),
    [anon_sym_module] = ACTIONS(932),
    [anon_sym_static] = ACTIONS(932),
    [anon_sym_package] = ACTIONS(932),
    [anon_sym_import] = ACTIONS(932),
    [anon_sym_enum] = ACTIONS(932),
    [anon_sym_public] = ACTIONS(932),
    [anon_sym_protected] = ACTIONS(932),
    [anon_sym_private] = ACTIONS(932),
    [anon_sym_abstract] = ACTIONS(932),
    [anon_sym_final] = ACTIONS(932),
    [anon_sym_strictfp] = ACTIONS(932),
    [anon_sym_native] = ACTIONS(932),
    [anon_sym_transient] = ACTIONS(932),
    [anon_sym_volatile] = ACTIONS(932),
    [anon_sym_ATinterface] = ACTIONS(934),
    [anon_sym_interface] = ACTIONS(932),
    [anon_sym_byte] = ACTIONS(932),
    [anon_sym_short] = ACTIONS(932),
    [anon_sym_int] = ACTIONS(932),
    [anon_sym_long] = ACTIONS(932),
    [anon_sym_char] = ACTIONS(932),
    [anon_sym_float] = ACTIONS(932),
    [anon_sym_double] = ACTIONS(932),
    [sym_boolean_type] = ACTIONS(932),
    [sym_void_type] = ACTIONS(932),
    [sym_this] = ACTIONS(932),
    [sym_super] = ACTIONS(932),
    [sym_comment] = ACTIONS(3),
  },
  [240] = {
    [sym_identifier] = ACTIONS(936),
    [sym_decimal_integer_literal] = ACTIONS(936),
    [sym_hex_integer_literal] = ACTIONS(936),
    [sym_octal_integer_literal] = ACTIONS(938),
    [sym_binary_integer_literal] = ACTIONS(938),
    [sym_decimal_floating_point_literal] = ACTIONS(938),
    [sym_hex_floating_point_literal] = ACTIONS(936),
    [sym_true] = ACTIONS(936),
    [sym_false] = ACTIONS(936),
    [sym_character_literal] = ACTIONS(938),
    [sym_string_literal] = ACTIONS(938),
    [sym_null_literal] = ACTIONS(936),
    [anon_sym_LPAREN] = ACTIONS(938),
    [anon_sym_PLUS] = ACTIONS(936),
    [anon_sym_DASH] = ACTIONS(936),
    [anon_sym_BANG] = ACTIONS(938),
    [anon_sym_TILDE] = ACTIONS(938),
    [anon_sym_PLUS_PLUS] = ACTIONS(938),
    [anon_sym_DASH_DASH] = ACTIONS(938),
    [anon_sym_new] = ACTIONS(936),
    [anon_sym_class] = ACTIONS(936),
    [anon_sym_SEMI] = ACTIONS(938),
    [anon_sym_LBRACE] = ACTIONS(938),
    [anon_sym_RBRACE] = ACTIONS(938),
    [anon_sym_assert] = ACTIONS(936),
    [anon_sym_switch] = ACTIONS(936),
    [anon_sym_default] = ACTIONS(936),
    [anon_sym_do] = ACTIONS(936),
    [anon_sym_while] = ACTIONS(936),
    [anon_sym_break] = ACTIONS(936),
    [anon_sym_continue] = ACTIONS(936),
    [anon_sym_return] = ACTIONS(936),
    [anon_sym_synchronized] = ACTIONS(936),
    [anon_sym_throw] = ACTIONS(936),
    [anon_sym_try] = ACTIONS(936),
    [anon_sym_if] = ACTIONS(936),
    [anon_sym_for] = ACTIONS(936),
    [anon_sym_AT] = ACTIONS(936),
    [anon_sym_open] = ACTIONS(936),
    [anon_sym_module] = ACTIONS(936),
    [anon_sym_static] = ACTIONS(936),
    [anon_sym_package] = ACTIONS(936),
    [anon_sym_import] = ACTIONS(936),
    [anon_sym_enum] = ACTIONS(936),
    [anon_sym_public] = ACTIONS(936),
    [anon_sym_protected] = ACTIONS(936),
    [anon_sym_private] = ACTIONS(936),
    [anon_sym_abstract] = ACTIONS(936),
    [anon_sym_final] = ACTIONS(936),
    [anon_sym_strictfp] = ACTIONS(936),
    [anon_sym_native] = ACTIONS(936),
    [anon_sym_transient] = ACTIONS(936),
    [anon_sym_volatile] = ACTIONS(936),
    [anon_sym_ATinterface] = ACTIONS(938),
    [anon_sym_interface] = ACTIONS(936),
    [anon_sym_byte] = ACTIONS(936),
    [anon_sym_short] = ACTIONS(936),
    [anon_sym_int] = ACTIONS(936),
    [anon_sym_long] = ACTIONS(936),
    [anon_sym_char] = ACTIONS(936),
    [anon_sym_float] = ACTIONS(936),
    [anon_sym_double] = ACTIONS(936),
    [sym_boolean_type] = ACTIONS(936),
    [sym_void_type] = ACTIONS(936),
    [sym_this] = ACTIONS(936),
    [sym_super] = ACTIONS(936),
    [sym_comment] = ACTIONS(3),
  },
  [241] = {
    [sym__literal] = STATE(316),
    [sym_primary_expression] = STATE(793),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(640),
    [sym_array_access] = STATE(316),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_resource] = STATE(807),
    [sym__annotation] = STATE(468),
    [sym_marker_annotation] = STATE(468),
    [sym_annotation] = STATE(468),
    [sym_modifiers] = STATE(514),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(532),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [aux_sym_modifiers_repeat1] = STATE(404),
    [sym_identifier] = ACTIONS(916),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(918),
    [anon_sym_new] = ACTIONS(922),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(924),
    [anon_sym_module] = ACTIONS(924),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [242] = {
    [sym__literal] = STATE(316),
    [sym_primary_expression] = STATE(793),
    [sym_array_creation_expression] = STATE(316),
    [sym_parenthesized_expression] = STATE(316),
    [sym_class_literal] = STATE(316),
    [sym_object_creation_expression] = STATE(316),
    [sym__unqualified_object_creation_expression] = STATE(310),
    [sym_field_access] = STATE(640),
    [sym_array_access] = STATE(316),
    [sym_method_invocation] = STATE(316),
    [sym_method_reference] = STATE(316),
    [sym_resource] = STATE(794),
    [sym__annotation] = STATE(468),
    [sym_marker_annotation] = STATE(468),
    [sym_annotation] = STATE(468),
    [sym_modifiers] = STATE(514),
    [sym__type] = STATE(917),
    [sym__unannotated_type] = STATE(532),
    [sym_annotated_type] = STATE(574),
    [sym_scoped_type_identifier] = STATE(536),
    [sym_generic_type] = STATE(560),
    [sym_array_type] = STATE(506),
    [sym_integral_type] = STATE(506),
    [sym_floating_point_type] = STATE(506),
    [aux_sym_dimensions_expr_repeat1] = STATE(485),
    [aux_sym_modifiers_repeat1] = STATE(404),
    [sym_identifier] = ACTIONS(916),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(918),
    [anon_sym_new] = ACTIONS(922),
    [anon_sym_default] = ACTIONS(367),
    [anon_sym_synchronized] = ACTIONS(367),
    [anon_sym_AT] = ACTIONS(369),
    [anon_sym_open] = ACTIONS(924),
    [anon_sym_module] = ACTIONS(924),
    [anon_sym_static] = ACTIONS(367),
    [anon_sym_public] = ACTIONS(367),
    [anon_sym_protected] = ACTIONS(367),
    [anon_sym_private] = ACTIONS(367),
    [anon_sym_abstract] = ACTIONS(367),
    [anon_sym_final] = ACTIONS(367),
    [anon_sym_strictfp] = ACTIONS(367),
    [anon_sym_native] = ACTIONS(367),
    [anon_sym_transient] = ACTIONS(367),
    [anon_sym_volatile] = ACTIONS(367),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_comment] = ACTIONS(3),
  },
  [243] = {
    [sym_identifier] = ACTIONS(940),
    [sym_decimal_integer_literal] = ACTIONS(940),
    [sym_hex_integer_literal] = ACTIONS(940),
    [sym_octal_integer_literal] = ACTIONS(942),
    [sym_binary_integer_literal] = ACTIONS(942),
    [sym_decimal_floating_point_literal] = ACTIONS(942),
    [sym_hex_floating_point_literal] = ACTIONS(940),
    [sym_true] = ACTIONS(940),
    [sym_false] = ACTIONS(940),
    [sym_character_literal] = ACTIONS(942),
    [sym_string_literal] = ACTIONS(942),
    [sym_null_literal] = ACTIONS(940),
    [anon_sym_LPAREN] = ACTIONS(942),
    [anon_sym_PLUS] = ACTIONS(940),
    [anon_sym_DASH] = ACTIONS(940),
    [anon_sym_BANG] = ACTIONS(942),
    [anon_sym_TILDE] = ACTIONS(942),
    [anon_sym_PLUS_PLUS] = ACTIONS(942),
    [anon_sym_DASH_DASH] = ACTIONS(942),
    [anon_sym_new] = ACTIONS(940),
    [anon_sym_class] = ACTIONS(940),
    [anon_sym_SEMI] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(942),
    [anon_sym_RBRACE] = ACTIONS(942),
    [anon_sym_assert] = ACTIONS(940),
    [anon_sym_switch] = ACTIONS(940),
    [anon_sym_default] = ACTIONS(940),
    [anon_sym_do] = ACTIONS(940),
    [anon_sym_while] = ACTIONS(940),
    [anon_sym_break] = ACTIONS(940),
    [anon_sym_continue] = ACTIONS(940),
    [anon_sym_return] = ACTIONS(940),
    [anon_sym_synchronized] = ACTIONS(940),
    [anon_sym_throw] = ACTIONS(940),
    [anon_sym_try] = ACTIONS(940),
    [anon_sym_if] = ACTIONS(940),
    [anon_sym_for] = ACTIONS(940),
    [anon_sym_AT] = ACTIONS(940),
    [anon_sym_open] = ACTIONS(940),
    [anon_sym_module] = ACTIONS(940),
    [anon_sym_static] = ACTIONS(940),
    [anon_sym_package] = ACTIONS(940),
    [anon_sym_import] = ACTIONS(940),
    [anon_sym_enum] = ACTIONS(940),
    [anon_sym_public] = ACTIONS(940),
    [anon_sym_protected] = ACTIONS(940),
    [anon_sym_private] = ACTIONS(940),
    [anon_sym_abstract] = ACTIONS(940),
    [anon_sym_final] = ACTIONS(940),
    [anon_sym_strictfp] = ACTIONS(940),
    [anon_sym_native] = ACTIONS(940),
    [anon_sym_transient] = ACTIONS(940),
    [anon_sym_volatile] = ACTIONS(940),
    [anon_sym_ATinterface] = ACTIONS(942),
    [anon_sym_interface] = ACTIONS(940),
    [anon_sym_byte] = ACTIONS(940),
    [anon_sym_short] = ACTIONS(940),
    [anon_sym_int] = ACTIONS(940),
    [anon_sym_long] = ACTIONS(940),
    [anon_sym_char] = ACTIONS(940),
    [anon_sym_float] = ACTIONS(940),
    [anon_sym_double] = ACTIONS(940),
    [sym_boolean_type] = ACTIONS(940),
    [sym_void_type] = ACTIONS(940),
    [sym_this] = ACTIONS(940),
    [sym_super] = ACTIONS(940),
    [sym_comment] = ACTIONS(3),
  },
  [244] = {
    [sym_identifier] = ACTIONS(944),
    [sym_decimal_integer_literal] = ACTIONS(944),
    [sym_hex_integer_literal] = ACTIONS(944),
    [sym_octal_integer_literal] = ACTIONS(946),
    [sym_binary_integer_literal] = ACTIONS(946),
    [sym_decimal_floating_point_literal] = ACTIONS(946),
    [sym_hex_floating_point_literal] = ACTIONS(944),
    [sym_true] = ACTIONS(944),
    [sym_false] = ACTIONS(944),
    [sym_character_literal] = ACTIONS(946),
    [sym_string_literal] = ACTIONS(946),
    [sym_null_literal] = ACTIONS(944),
    [anon_sym_LPAREN] = ACTIONS(946),
    [anon_sym_PLUS] = ACTIONS(944),
    [anon_sym_DASH] = ACTIONS(944),
    [anon_sym_BANG] = ACTIONS(946),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_PLUS_PLUS] = ACTIONS(946),
    [anon_sym_DASH_DASH] = ACTIONS(946),
    [anon_sym_new] = ACTIONS(944),
    [anon_sym_class] = ACTIONS(944),
    [anon_sym_SEMI] = ACTIONS(946),
    [anon_sym_LBRACE] = ACTIONS(946),
    [anon_sym_RBRACE] = ACTIONS(946),
    [anon_sym_assert] = ACTIONS(944),
    [anon_sym_switch] = ACTIONS(944),
    [anon_sym_default] = ACTIONS(944),
    [anon_sym_do] = ACTIONS(944),
    [anon_sym_while] = ACTIONS(944),
    [anon_sym_break] = ACTIONS(944),
    [anon_sym_continue] = ACTIONS(944),
    [anon_sym_return] = ACTIONS(944),
    [anon_sym_synchronized] = ACTIONS(944),
    [anon_sym_throw] = ACTIONS(944),
    [anon_sym_try] = ACTIONS(944),
    [anon_sym_if] = ACTIONS(944),
    [anon_sym_for] = ACTIONS(944),
    [anon_sym_AT] = ACTIONS(944),
    [anon_sym_open] = ACTIONS(944),
    [anon_sym_module] = ACTIONS(944),
    [anon_sym_static] = ACTIONS(944),
    [anon_sym_package] = ACTIONS(944),
    [anon_sym_import] = ACTIONS(944),
    [anon_sym_enum] = ACTIONS(944),
    [anon_sym_public] = ACTIONS(944),
    [anon_sym_protected] = ACTIONS(944),
    [anon_sym_private] = ACTIONS(944),
    [anon_sym_abstract] = ACTIONS(944),
    [anon_sym_final] = ACTIONS(944),
    [anon_sym_strictfp] = ACTIONS(944),
    [anon_sym_native] = ACTIONS(944),
    [anon_sym_transient] = ACTIONS(944),
    [anon_sym_volatile] = ACTIONS(944),
    [anon_sym_ATinterface] = ACTIONS(946),
    [anon_sym_interface] = ACTIONS(944),
    [anon_sym_byte] = ACTIONS(944),
    [anon_sym_short] = ACTIONS(944),
    [anon_sym_int] = ACTIONS(944),
    [anon_sym_long] = ACTIONS(944),
    [anon_sym_char] = ACTIONS(944),
    [anon_sym_float] = ACTIONS(944),
    [anon_sym_double] = ACTIONS(944),
    [sym_boolean_type] = ACTIONS(944),
    [sym_void_type] = ACTIONS(944),
    [sym_this] = ACTIONS(944),
    [sym_super] = ACTIONS(944),
    [sym_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(948), 1,
      sym_identifier,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(952), 1,
      anon_sym_SEMI,
    ACTIONS(954), 1,
      anon_sym_RBRACE,
    ACTIONS(956), 1,
      anon_sym_static,
    STATE(448), 1,
      sym_modifiers,
    STATE(480), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(524), 1,
      sym__unannotated_type,
    STATE(673), 1,
      sym__constructor_declarator,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(247), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [109] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(948), 1,
      sym_identifier,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(956), 1,
      anon_sym_static,
    ACTIONS(958), 1,
      anon_sym_SEMI,
    ACTIONS(960), 1,
      anon_sym_RBRACE,
    STATE(448), 1,
      sym_modifiers,
    STATE(480), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(524), 1,
      sym__unannotated_type,
    STATE(673), 1,
      sym__constructor_declarator,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(249), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [218] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      sym_identifier,
    ACTIONS(965), 1,
      anon_sym_LT,
    ACTIONS(968), 1,
      anon_sym_class,
    ACTIONS(971), 1,
      anon_sym_SEMI,
    ACTIONS(974), 1,
      anon_sym_LBRACE,
    ACTIONS(977), 1,
      anon_sym_RBRACE,
    ACTIONS(982), 1,
      anon_sym_AT,
    ACTIONS(985), 1,
      anon_sym_static,
    ACTIONS(988), 1,
      anon_sym_enum,
    ACTIONS(991), 1,
      anon_sym_ATinterface,
    ACTIONS(994), 1,
      anon_sym_interface,
    STATE(448), 1,
      sym_modifiers,
    STATE(480), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(524), 1,
      sym__unannotated_type,
    STATE(673), 1,
      sym__constructor_declarator,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(1000), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1003), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(997), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(247), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(979), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [327] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(948), 1,
      sym_identifier,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(956), 1,
      anon_sym_static,
    ACTIONS(1006), 1,
      anon_sym_SEMI,
    ACTIONS(1008), 1,
      anon_sym_RBRACE,
    STATE(448), 1,
      sym_modifiers,
    STATE(480), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(524), 1,
      sym__unannotated_type,
    STATE(673), 1,
      sym__constructor_declarator,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(245), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [436] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(948), 1,
      sym_identifier,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(952), 1,
      anon_sym_SEMI,
    ACTIONS(956), 1,
      anon_sym_static,
    ACTIONS(1010), 1,
      anon_sym_RBRACE,
    STATE(448), 1,
      sym_modifiers,
    STATE(480), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(524), 1,
      sym__unannotated_type,
    STATE(673), 1,
      sym__constructor_declarator,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(247), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [545] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_EQ,
    ACTIONS(1024), 1,
      anon_sym_LT,
    ACTIONS(1027), 1,
      anon_sym_DASH_GT,
    ACTIONS(1032), 1,
      anon_sym_DOT,
    ACTIONS(1036), 1,
      anon_sym_AT,
    STATE(345), 1,
      sym_argument_list,
    STATE(499), 1,
      sym_type_arguments,
    ACTIONS(1029), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1012), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(1022), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1016), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COLON,
    ACTIONS(1018), 14,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [627] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_EQ,
    ACTIONS(1024), 1,
      anon_sym_LT,
    ACTIONS(1027), 1,
      anon_sym_DASH_GT,
    ACTIONS(1038), 1,
      anon_sym_AMP,
    ACTIONS(1041), 1,
      anon_sym_RPAREN,
    ACTIONS(1045), 1,
      anon_sym_COMMA,
    ACTIONS(1047), 1,
      anon_sym_DOT,
    STATE(345), 1,
      sym_argument_list,
    STATE(499), 1,
      sym_type_arguments,
    STATE(798), 1,
      aux_sym_inferred_parameters_repeat1,
    ACTIONS(1029), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1036), 2,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1012), 4,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_identifier,
    ACTIONS(1018), 9,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1022), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1016), 12,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [716] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      sym_identifier,
    ACTIONS(1054), 1,
      anon_sym_LT,
    ACTIONS(1057), 1,
      anon_sym_class,
    ACTIONS(1060), 1,
      anon_sym_SEMI,
    ACTIONS(1063), 1,
      anon_sym_RBRACE,
    ACTIONS(1068), 1,
      anon_sym_AT,
    ACTIONS(1071), 1,
      anon_sym_enum,
    ACTIONS(1074), 1,
      anon_sym_ATinterface,
    ACTIONS(1077), 1,
      anon_sym_interface,
    STATE(470), 1,
      sym_modifiers,
    STATE(486), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(520), 1,
      sym__unannotated_type,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(1083), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1086), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(1080), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(252), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(1065), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [814] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(1089), 1,
      sym_identifier,
    ACTIONS(1091), 1,
      anon_sym_SEMI,
    ACTIONS(1093), 1,
      anon_sym_RBRACE,
    STATE(470), 1,
      sym_modifiers,
    STATE(486), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(520), 1,
      sym__unannotated_type,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(252), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [912] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(1089), 1,
      sym_identifier,
    ACTIONS(1095), 1,
      anon_sym_SEMI,
    ACTIONS(1097), 1,
      anon_sym_RBRACE,
    STATE(470), 1,
      sym_modifiers,
    STATE(486), 1,
      sym_type_parameters,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(520), 1,
      sym__unannotated_type,
    STATE(765), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(253), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1010] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      anon_sym_EQ,
    ACTIONS(1024), 1,
      anon_sym_LT,
    ACTIONS(1027), 1,
      anon_sym_DASH_GT,
    ACTIONS(1032), 1,
      anon_sym_DOT,
    ACTIONS(1036), 1,
      anon_sym_AT,
    ACTIONS(1099), 1,
      anon_sym_COLON,
    STATE(345), 1,
      sym_argument_list,
    STATE(499), 1,
      sym_type_arguments,
    ACTIONS(1029), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1012), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(1018), 10,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(1022), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1016), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1090] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1105), 1,
      anon_sym_EQ,
    STATE(327), 1,
      sym_argument_list,
    ACTIONS(1107), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1101), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1103), 18,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1152] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    STATE(305), 1,
      sym_argument_list,
    ACTIONS(1109), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1111), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1210] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    STATE(332), 1,
      sym_argument_list,
    ACTIONS(1113), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1115), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1268] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    STATE(307), 1,
      sym_argument_list,
    ACTIONS(1117), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1119), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1326] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    STATE(329), 1,
      sym_argument_list,
    ACTIONS(1121), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1123), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1384] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1105), 1,
      anon_sym_EQ,
    ACTIONS(1125), 1,
      sym_identifier,
    STATE(327), 1,
      sym_argument_list,
    STATE(767), 1,
      sym_scoped_identifier,
    ACTIONS(1127), 2,
      anon_sym_open,
      anon_sym_module,
    ACTIONS(1107), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1103), 13,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
    ACTIONS(1101), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1451] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1129), 1,
      sym_identifier,
    ACTIONS(1132), 1,
      anon_sym_class,
    ACTIONS(1135), 1,
      anon_sym_RBRACE,
    ACTIONS(1140), 1,
      anon_sym_AT,
    ACTIONS(1143), 1,
      anon_sym_ATinterface,
    ACTIONS(1146), 1,
      anon_sym_interface,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_modifiers,
    STATE(505), 1,
      sym_generic_type,
    STATE(534), 1,
      sym__unannotated_type,
    ACTIONS(1152), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1155), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(1149), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(262), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(1137), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1533] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1109), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1111), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1585] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1089), 1,
      sym_identifier,
    ACTIONS(1158), 1,
      anon_sym_RBRACE,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_modifiers,
    STATE(505), 1,
      sym_generic_type,
    STATE(534), 1,
      sym__unannotated_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(265), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1667] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1089), 1,
      sym_identifier,
    ACTIONS(1160), 1,
      anon_sym_RBRACE,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_modifiers,
    STATE(505), 1,
      sym_generic_type,
    STATE(534), 1,
      sym__unannotated_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(309), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(262), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1117), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1119), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1801] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1024), 1,
      anon_sym_LT,
    ACTIONS(1027), 1,
      anon_sym_DASH_GT,
    ACTIONS(1032), 1,
      anon_sym_DOT,
    ACTIONS(1036), 1,
      anon_sym_AT,
    ACTIONS(1162), 1,
      anon_sym_EQ,
    STATE(345), 1,
      sym_argument_list,
    STATE(499), 1,
      sym_type_arguments,
    ACTIONS(1029), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1018), 11,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1022), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1016), 12,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
  [1873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1166), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1925] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      anon_sym_EQ,
    ACTIONS(1022), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1016), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1018), 18,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1981] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    ACTIONS(1105), 1,
      anon_sym_EQ,
    ACTIONS(1168), 1,
      anon_sym_module,
    STATE(327), 1,
      sym_argument_list,
    ACTIONS(1107), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1101), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
    ACTIONS(1103), 14,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
  [2041] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1174), 1,
      anon_sym_LBRACK,
    STATE(275), 1,
      aux_sym_dimensions_repeat1,
    STATE(336), 1,
      sym_dimensions,
    STATE(274), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(591), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1170), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1172), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2102] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1174), 1,
      anon_sym_LBRACK,
    STATE(275), 1,
      aux_sym_dimensions_repeat1,
    STATE(331), 1,
      sym_dimensions,
    STATE(274), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(591), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1176), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1178), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2163] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 1,
      anon_sym_RPAREN,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1089), 1,
      sym_identifier,
    STATE(279), 1,
      sym_receiver_parameter,
    STATE(404), 1,
      aux_sym_modifiers_repeat1,
    STATE(487), 1,
      aux_sym_dimensions_expr_repeat1,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(512), 1,
      sym_modifiers,
    STATE(533), 1,
      sym__unannotated_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(751), 2,
      sym_formal_parameter,
      sym_spread_parameter,
    STATE(468), 3,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(367), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2240] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      anon_sym_LBRACK,
    ACTIONS(1187), 1,
      anon_sym_AT,
    STATE(274), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(605), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1180), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1182), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2295] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1194), 1,
      anon_sym_LBRACK,
    STATE(278), 1,
      aux_sym_dimensions_repeat1,
    STATE(593), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1190), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1192), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2349] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1198), 7,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_ATinterface,
    ACTIONS(1196), 31,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_to,
      anon_sym_with,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [2395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 7,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_ATinterface,
    ACTIONS(1200), 31,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_to,
      anon_sym_with,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [2441] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1208), 1,
      anon_sym_LBRACK,
    ACTIONS(1211), 1,
      anon_sym_AT,
    STATE(278), 1,
      aux_sym_dimensions_repeat1,
    STATE(593), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1204), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1206), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2495] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1089), 1,
      sym_identifier,
    ACTIONS(1214), 1,
      anon_sym_RPAREN,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(512), 1,
      sym_modifiers,
    STATE(539), 1,
      sym__unannotated_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(720), 2,
      sym_formal_parameter,
      sym_spread_parameter,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(404), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(367), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2564] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1194), 1,
      anon_sym_LBRACK,
    STATE(275), 1,
      aux_sym_dimensions_repeat1,
    STATE(372), 1,
      sym_dimensions,
    STATE(593), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1216), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1218), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2619] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1194), 1,
      anon_sym_LBRACK,
    STATE(275), 1,
      aux_sym_dimensions_repeat1,
    STATE(372), 1,
      sym_dimensions,
    STATE(593), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1220), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1222), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2674] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(1089), 1,
      sym_identifier,
    STATE(491), 1,
      sym_scoped_type_identifier,
    STATE(505), 1,
      sym_generic_type,
    STATE(512), 1,
      sym_modifiers,
    STATE(539), 1,
      sym__unannotated_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(75), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(806), 2,
      sym_formal_parameter,
      sym_spread_parameter,
    STATE(506), 3,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    STATE(404), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(367), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
   