#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 12
#define STATE_COUNT 925
#define LARGE_STATE_COUNT 20
#define SYMBOL_COUNT 218
#define ALIAS_COUNT 0
#define TOKEN_COUNT 88
#define EXTERNAL_TOKEN_COUNT 11
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 6

enum {
  sym_lower_case_identifier = 1,
  sym__upper_case_identifier_without_leading_whitespace = 2,
  sym__lower_case_identifier_without_leading_whitespace = 3,
  sym__dot_without_leading_whitespace = 4,
  anon_sym_else = 5,
  anon_sym_COLON_COLON = 6,
  anon_sym_left = 7,
  anon_sym_right = 8,
  anon_sym_non = 9,
  sym_upper_case_identifier = 10,
  aux_sym_number_literal_token1 = 11,
  sym__hex_literal = 12,
  sym_regular_char = 13,
  aux_sym_regular_string_part_token1 = 14,
  aux_sym_regular_string_part_token2 = 15,
  aux_sym_regular_string_part_multiline_token1 = 16,
  aux_sym_regular_string_part_multiline_token2 = 17,
  sym_string_escape = 18,
  sym_invalid_string_escape = 19,
  sym_module = 20,
  sym_effect = 21,
  sym_where = 22,
  sym_import = 23,
  sym_as = 24,
  sym_exposing = 25,
  anon_sym_if = 26,
  anon_sym_then = 27,
  sym_case = 28,
  sym_of = 29,
  anon_sym_let = 30,
  anon_sym_in = 31,
  sym_type = 32,
  sym_alias = 33,
  sym_port = 34,
  sym_infix = 35,
  sym_left_parenthesis = 36,
  sym_right_parenthesis = 37,
  sym_left_square_bracket = 38,
  sym_right_square_bracket = 39,
  sym_left_brace = 40,
  sym_right_brace = 41,
  sym_double_dot = 42,
  sym_comma = 43,
  sym_eq = 44,
  sym_arrow = 45,
  sym_colon = 46,
  sym_pipe = 47,
  sym_backslash = 48,
  sym_underscore = 49,
  sym_dot = 50,
  anon_sym_PLUS = 51,
  anon_sym_DASH = 52,
  anon_sym_STAR = 53,
  anon_sym_SLASH = 54,
  anon_sym_SLASH_SLASH = 55,
  anon_sym_CARET = 56,
  anon_sym_EQ_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_LT = 59,
  anon_sym_GT = 60,
  anon_sym_LT_EQ = 61,
  anon_sym_GT_EQ = 62,
  anon_sym_AMP_AMP = 63,
  anon_sym_PIPE_PIPE = 64,
  anon_sym_PLUS_PLUS = 65,
  anon_sym_LT_PIPE = 66,
  anon_sym_PIPE_GT = 67,
  anon_sym_LT_LT = 68,
  anon_sym_GT_GT = 69,
  anon_sym_LT_SLASH_GT = 70,
  anon_sym_LT_QMARK_GT = 71,
  anon_sym_PIPE_DOT = 72,
  anon_sym_PIPE_EQ = 73,
  sym_glsl_begin = 74,
  sym_glsl_end = 75,
  sym__char_quote = 76,
  sym__virtual_end_decl = 77,
  sym__virtual_open_section = 78,
  sym__virtual_end_section = 79,
  sym_minus_without_trailing_whitespace = 80,
  sym_block_comment = 81,
  sym_line_comment = 82,
  sym_open_quote = 83,
  sym_close_quote = 84,
  sym_open_quote_multiline = 85,
  sym_close_quote_multiline = 86,
  sym_glsl_content = 87,
  sym_file = 88,
  sym_module_declaration = 89,
  aux_sym__import_list = 90,
  aux_sym__top_decl_list = 91,
  sym_exposing_list = 92,
  sym__exposed_item = 93,
  sym_exposed_value = 94,
  sym_exposed_type = 95,
  sym_exposed_union_constructors = 96,
  sym_exposed_operator = 97,
  sym_upper_case_qid = 98,
  sym_value_qid = 99,
  sym_field_accessor_function_expr = 100,
  sym_import_clause = 101,
  sym_as_clause = 102,
  sym__declaration = 103,
  sym_value_declaration = 104,
  sym__internal_value_declaration_left = 105,
  sym_function_declaration_left = 106,
  sym__function_declaration_pattern = 107,
  sym_type_declaration = 108,
  sym_lower_type_name = 109,
  sym_union_variant = 110,
  sym__more_union_variants = 111,
  sym_type_alias_declaration = 112,
  sym_type_expression = 113,
  sym__type_expression_inner = 114,
  sym_type_ref = 115,
  sym__single_type_expression = 116,
  sym_type_ref_without_args = 117,
  sym_type_variable = 118,
  sym_record_type = 119,
  sym_field_type = 120,
  sym_tuple_type = 121,
  sym_type_annotation = 122,
  sym_port_annotation = 123,
  sym__expression = 124,
  sym_bin_op_expr = 125,
  sym_operator = 126,
  sym_operator_as_function_expr = 127,
  sym__operator_as_function_inner = 128,
  sym__call_or_atom = 129,
  sym_function_call_expr = 130,
  sym__function_call_target = 131,
  sym__atom = 132,
  sym_field_access_expr = 133,
  sym__field_access_start = 134,
  sym__field_access_segment = 135,
  sym_negate_expr = 136,
  sym_parenthesized_expr = 137,
  sym__literal_expr_group = 138,
  sym_char_constant_expr = 139,
  sym_open_char = 140,
  sym_close_char = 141,
  sym_number_constant_expr = 142,
  sym_string_constant_expr = 143,
  sym__string_part = 144,
  sym__string_part_multiline = 145,
  aux_sym__string_parts = 146,
  aux_sym__string_parts_multiline = 147,
  sym_anonymous_function_expr = 148,
  sym_value_expr = 149,
  sym_tuple_expr = 150,
  sym_unit_expr = 151,
  sym_list_expr = 152,
  sym_record_expr = 153,
  sym_record_base_identifier = 154,
  sym__record_base = 155,
  sym__record_inner = 156,
  sym__record_inner_fields = 157,
  sym_field = 158,
  sym_if_else_expr = 159,
  sym_case_of_expr = 160,
  sym__case_of_tail = 161,
  sym__case_of_tail2 = 162,
  sym__more_case_of_branches = 163,
  sym_case_of_branch = 164,
  sym_let_in_expr = 165,
  sym__inner_declaration = 166,
  aux_sym__more_inner_declarations = 167,
  sym_pattern = 168,
  sym__pattern_as = 169,
  sym_cons_pattern = 170,
  sym__single_pattern_cons = 171,
  sym__single_pattern = 172,
  sym__parenthesized_single_pattern = 173,
  sym_lower_pattern = 174,
  sym_anything_pattern = 175,
  sym_record_pattern = 176,
  sym_list_pattern = 177,
  sym_union_pattern = 178,
  sym_nullary_constructor_argument_pattern = 179,
  sym__union_argument_pattern = 180,
  sym_tuple_pattern = 181,
  sym__parenthesized_pattern = 182,
  sym_infix_declaration = 183,
  sym_glsl_code_expr = 184,
  sym_number_literal = 185,
  sym_regular_string_part = 186,
  sym_regular_string_part_multiline = 187,
  sym__if = 188,
  sym__then = 189,
  sym__else = 190,
  sym__let = 191,
  sym__in = 192,
  sym_operator_identifier = 193,
  aux_sym_exposing_list_repeat1 = 194,
  aux_sym_upper_case_qid_repeat1 = 195,
  aux_sym_value_qid_repeat1 = 196,
  aux_sym_function_declaration_left_repeat1 = 197,
  aux_sym_type_declaration_repeat1 = 198,
  aux_sym_type_declaration_repeat2 = 199,
  aux_sym_union_variant_repeat1 = 200,
  aux_sym_type_expression_repeat1 = 201,
  aux_sym_record_type_repeat1 = 202,
  aux_sym_tuple_type_repeat1 = 203,
  aux_sym_bin_op_expr_repeat1 = 204,
  aux_sym_function_call_expr_repeat1 = 205,
  aux_sym_field_access_expr_repeat1 = 206,
  aux_sym_anonymous_function_expr_repeat1 = 207,
  aux_sym_tuple_expr_repeat1 = 208,
  aux_sym_list_expr_repeat1 = 209,
  aux_sym__record_inner_fields_repeat1 = 210,
  aux_sym_if_else_expr_repeat1 = 211,
  aux_sym__more_case_of_branches_repeat1 = 212,
  aux_sym_cons_pattern_repeat1 = 213,
  aux_sym_record_pattern_repeat1 = 214,
  aux_sym_list_pattern_repeat1 = 215,
  aux_sym_union_pattern_repeat1 = 216,
  aux_sym_tuple_pattern_repeat1 = 217,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_lower_case_identifier] = "lower_case_identifier",
  [sym__upper_case_identifier_without_leading_whitespace] = "upper_case_identifier",
  [sym__lower_case_identifier_without_leading_whitespace] = "lower_case_identifier",
  [sym__dot_without_leading_whitespace] = "dot",
  [anon_sym_else] = "else",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_left] = "lower_case_identifier",
  [anon_sym_right] = "lower_case_identifier",
  [anon_sym_non] = "lower_case_identifier",
  [sym_upper_case_identifier] = "upper_case_identifier",
  [aux_sym_number_literal_token1] = "number_literal_token1",
  [sym__hex_literal] = "_hex_literal",
  [sym_regular_char] = "regular_string_part",
  [aux_sym_regular_string_part_token1] = "regular_string_part_token1",
  [aux_sym_regular_string_part_token2] = "regular_string_part_token2",
  [aux_sym_regular_string_part_multiline_token1] = "regular_string_part_multiline_token1",
  [aux_sym_regular_string_part_multiline_token2] = "regular_string_part_multiline_token2",
  [sym_string_escape] = "string_escape",
  [sym_invalid_string_escape] = "invalid_string_escape",
  [sym_module] = "module",
  [sym_effect] = "effect",
  [sym_where] = "where",
  [sym_import] = "import",
  [sym_as] = "as",
  [sym_exposing] = "exposing",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [sym_case] = "case",
  [sym_of] = "of",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [sym_type] = "type",
  [sym_alias] = "alias",
  [sym_port] = "port",
  [sym_infix] = "infix",
  [sym_left_parenthesis] = "left_parenthesis",
  [sym_right_parenthesis] = "right_parenthesis",
  [sym_left_square_bracket] = "left_square_bracket",
  [sym_right_square_bracket] = "right_square_bracket",
  [sym_left_brace] = "left_brace",
  [sym_right_brace] = "right_brace",
  [sym_double_dot] = "double_dot",
  [sym_comma] = "comma",
  [sym_eq] = "eq",
  [sym_arrow] = "arrow",
  [sym_colon] = "colon",
  [sym_pipe] = "pipe",
  [sym_backslash] = "backslash",
  [sym_underscore] = "underscore",
  [sym_dot] = "dot",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_LT_PIPE] = "<|",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LT_SLASH_GT] = "</>",
  [anon_sym_LT_QMARK_GT] = "<\?>",
  [anon_sym_PIPE_DOT] = "|.",
  [anon_sym_PIPE_EQ] = "|=",
  [sym_glsl_begin] = "glsl_begin",
  [sym_glsl_end] = "glsl_end",
  [sym__char_quote] = "_char_quote",
  [sym__virtual_end_decl] = "_virtual_end_decl",
  [sym__virtual_open_section] = "_virtual_open_section",
  [sym__virtual_end_section] = "_virtual_end_section",
  [sym_minus_without_trailing_whitespace] = "operator_identifier",
  [sym_block_comment] = "block_comment",
  [sym_line_comment] = "line_comment",
  [sym_open_quote] = "open_quote",
  [sym_close_quote] = "close_quote",
  [sym_open_quote_multiline] = "open_quote",
  [sym_close_quote_multiline] = "close_quote",
  [sym_glsl_content] = "glsl_content",
  [sym_file] = "file",
  [sym_module_declaration] = "module_declaration",
  [aux_sym__import_list] = "_import_list",
  [aux_sym__top_decl_list] = "_top_decl_list",
  [sym_exposing_list] = "exposing_list",
  [sym__exposed_item] = "_exposed_item",
  [sym_exposed_value] = "exposed_value",
  [sym_exposed_type] = "exposed_type",
  [sym_exposed_union_constructors] = "exposed_union_constructors",
  [sym_exposed_operator] = "exposed_operator",
  [sym_upper_case_qid] = "upper_case_qid",
  [sym_value_qid] = "value_qid",
  [sym_field_accessor_function_expr] = "field_accessor_function_expr",
  [sym_import_clause] = "import_clause",
  [sym_as_clause] = "as_clause",
  [sym__declaration] = "_declaration",
  [sym_value_declaration] = "value_declaration",
  [sym__internal_value_declaration_left] = "_internal_value_declaration_left",
  [sym_function_declaration_left] = "function_declaration_left",
  [sym__function_declaration_pattern] = "_function_declaration_pattern",
  [sym_type_declaration] = "type_declaration",
  [sym_lower_type_name] = "lower_type_name",
  [sym_union_variant] = "union_variant",
  [sym__more_union_variants] = "_more_union_variants",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_type_expression] = "type_expression",
  [sym__type_expression_inner] = "_type_expression_inner",
  [sym_type_ref] = "type_ref",
  [sym__single_type_expression] = "_single_type_expression",
  [sym_type_ref_without_args] = "type_ref",
  [sym_type_variable] = "type_variable",
  [sym_record_type] = "record_type",
  [sym_field_type] = "field_type",
  [sym_tuple_type] = "tuple_type",
  [sym_type_annotation] = "type_annotation",
  [sym_port_annotation] = "port_annotation",
  [sym__expression] = "_expression",
  [sym_bin_op_expr] = "bin_op_expr",
  [sym_operator] = "operator",
  [sym_operator_as_function_expr] = "operator_as_function_expr",
  [sym__operator_as_function_inner] = "_operator_as_function_inner",
  [sym__call_or_atom] = "_call_or_atom",
  [sym_function_call_expr] = "function_call_expr",
  [sym__function_call_target] = "_function_call_target",
  [sym__atom] = "_atom",
  [sym_field_access_expr] = "field_access_expr",
  [sym__field_access_start] = "_field_access_start",
  [sym__field_access_segment] = "_field_access_segment",
  [sym_negate_expr] = "negate_expr",
  [sym_parenthesized_expr] = "parenthesized_expr",
  [sym__literal_expr_group] = "_literal_expr_group",
  [sym_char_constant_expr] = "char_constant_expr",
  [sym_open_char] = "open_char",
  [sym_close_char] = "close_char",
  [sym_number_constant_expr] = "number_constant_expr",
  [sym_string_constant_expr] = "string_constant_expr",
  [sym__string_part] = "_string_part",
  [sym__string_part_multiline] = "_string_part_multiline",
  [aux_sym__string_parts] = "_string_parts",
  [aux_sym__string_parts_multiline] = "_string_parts_multiline",
  [sym_anonymous_function_expr] = "anonymous_function_expr",
  [sym_value_expr] = "value_expr",
  [sym_tuple_expr] = "tuple_expr",
  [sym_unit_expr] = "unit_expr",
  [sym_list_expr] = "list_expr",
  [sym_record_expr] = "record_expr",
  [sym_record_base_identifier] = "record_base_identifier",
  [sym__record_base] = "_record_base",
  [sym__record_inner] = "_record_inner",
  [sym__record_inner_fields] = "_record_inner_fields",
  [sym_field] = "field",
  [sym_if_else_expr] = "if_else_expr",
  [sym_case_of_expr] = "case_of_expr",
  [sym__case_of_tail] = "_case_of_tail",
  [sym__case_of_tail2] = "_case_of_tail2",
  [sym__more_case_of_branches] = "_more_case_of_branches",
  [sym_case_of_branch] = "case_of_branch",
  [sym_let_in_expr] = "let_in_expr",
  [sym__inner_declaration] = "_inner_declaration",
  [aux_sym__more_inner_declarations] = "_more_inner_declarations",
  [sym_pattern] = "pattern",
  [sym__pattern_as] = "_pattern_as",
  [sym_cons_pattern] = "cons_pattern",
  [sym__single_pattern_cons] = "_single_pattern_cons",
  [sym__single_pattern] = "_single_pattern",
  [sym__parenthesized_single_pattern] = "_parenthesized_single_pattern",
  [sym_lower_pattern] = "lower_pattern",
  [sym_anything_pattern] = "anything_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym_nullary_constructor_argument_pattern] = "nullary_constructor_argument_pattern",
  [sym__union_argument_pattern] = "_union_argument_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__parenthesized_pattern] = "_parenthesized_pattern",
  [sym_infix_declaration] = "infix_declaration",
  [sym_glsl_code_expr] = "glsl_code_expr",
  [sym_number_literal] = "number_literal",
  [sym_regular_string_part] = "regular_string_part",
  [sym_regular_string_part_multiline] = "regular_string_part",
  [sym__if] = "_if",
  [sym__then] = "_then",
  [sym__else] = "_else",
  [sym__let] = "_let",
  [sym__in] = "_in",
  [sym_operator_identifier] = "operator_identifier",
  [aux_sym_exposing_list_repeat1] = "exposing_list_repeat1",
  [aux_sym_upper_case_qid_repeat1] = "upper_case_qid_repeat1",
  [aux_sym_value_qid_repeat1] = "value_qid_repeat1",
  [aux_sym_function_declaration_left_repeat1] = "function_declaration_left_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_type_declaration_repeat2] = "type_declaration_repeat2",
  [aux_sym_union_variant_repeat1] = "union_variant_repeat1",
  [aux_sym_type_expression_repeat1] = "type_expression_repeat1",
  [aux_sym_record_type_repeat1] = "record_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_bin_op_expr_repeat1] = "bin_op_expr_repeat1",
  [aux_sym_function_call_expr_repeat1] = "function_call_expr_repeat1",
  [aux_sym_field_access_expr_repeat1] = "field_access_expr_repeat1",
  [aux_sym_anonymous_function_expr_repeat1] = "anonymous_function_expr_repeat1",
  [aux_sym_tuple_expr_repeat1] = "tuple_expr_repeat1",
  [aux_sym_list_expr_repeat1] = "list_expr_repeat1",
  [aux_sym__record_inner_fields_repeat1] = "_record_inner_fields_repeat1",
  [aux_sym_if_else_expr_repeat1] = "if_else_expr_repeat1",
  [aux_sym__more_case_of_branches_repeat1] = "_more_case_of_branches_repeat1",
  [aux_sym_cons_pattern_repeat1] = "cons_pattern_repeat1",
  [aux_sym_record_pattern_repeat1] = "record_pattern_repeat1",
  [aux_sym_list_pattern_repeat1] = "list_pattern_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_lower_case_identifier] = sym_lower_case_identifier,
  [sym__upper_case_identifier_without_leading_whitespace] = sym_upper_case_identifier,
  [sym__lower_case_identifier_without_leading_whitespace] = sym_lower_case_identifier,
  [sym__dot_without_leading_whitespace] = sym_dot,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_left] = sym_lower_case_identifier,
  [anon_sym_right] = sym_lower_case_identifier,
  [anon_sym_non] = sym_lower_case_identifier,
  [sym_upper_case_identifier] = sym_upper_case_identifier,
  [aux_sym_number_literal_token1] = aux_sym_number_literal_token1,
  [sym__hex_literal] = sym__hex_literal,
  [sym_regular_char] = sym_regular_string_part,
  [aux_sym_regular_string_part_token1] = aux_sym_regular_string_part_token1,
  [aux_sym_regular_string_part_token2] = aux_sym_regular_string_part_token2,
  [aux_sym_regular_string_part_multiline_token1] = aux_sym_regular_string_part_multiline_token1,
  [aux_sym_regular_string_part_multiline_token2] = aux_sym_regular_string_part_multiline_token2,
  [sym_string_escape] = sym_string_escape,
  [sym_invalid_string_escape] = sym_invalid_string_escape,
  [sym_module] = sym_module,
  [sym_effect] = sym_effect,
  [sym_where] = sym_where,
  [sym_import] = sym_import,
  [sym_as] = sym_as,
  [sym_exposing] = sym_exposing,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [sym_case] = sym_case,
  [sym_of] = sym_of,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [sym_type] = sym_type,
  [sym_alias] = sym_alias,
  [sym_port] = sym_port,
  [sym_infix] = sym_infix,
  [sym_left_parenthesis] = sym_left_parenthesis,
  [sym_right_parenthesis] = sym_right_parenthesis,
  [sym_left_square_bracket] = sym_left_square_bracket,
  [sym_right_square_bracket] = sym_right_square_bracket,
  [sym_left_brace] = sym_left_brace,
  [sym_right_brace] = sym_right_brace,
  [sym_double_dot] = sym_double_dot,
  [sym_comma] = sym_comma,
  [sym_eq] = sym_eq,
  [sym_arrow] = sym_arrow,
  [sym_colon] = sym_colon,
  [sym_pipe] = sym_pipe,
  [sym_backslash] = sym_backslash,
  [sym_underscore] = sym_underscore,
  [sym_dot] = sym_dot,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_LT_PIPE] = anon_sym_LT_PIPE,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LT_SLASH_GT] = anon_sym_LT_SLASH_GT,
  [anon_sym_LT_QMARK_GT] = anon_sym_LT_QMARK_GT,
  [anon_sym_PIPE_DOT] = anon_sym_PIPE_DOT,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [sym_glsl_begin] = sym_glsl_begin,
  [sym_glsl_end] = sym_glsl_end,
  [sym__char_quote] = sym__char_quote,
  [sym__virtual_end_decl] = sym__virtual_end_decl,
  [sym__virtual_open_section] = sym__virtual_open_section,
  [sym__virtual_end_section] = sym__virtual_end_section,
  [sym_minus_without_trailing_whitespace] = sym_operator_identifier,
  [sym_block_comment] = sym_block_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_open_quote] = sym_open_quote,
  [sym_close_quote] = sym_close_quote,
  [sym_open_quote_multiline] = sym_open_quote,
  [sym_close_quote_multiline] = sym_close_quote,
  [sym_glsl_content] = sym_glsl_content,
  [sym_file] = sym_file,
  [sym_module_declaration] = sym_module_declaration,
  [aux_sym__import_list] = aux_sym__import_list,
  [aux_sym__top_decl_list] = aux_sym__top_decl_list,
  [sym_exposing_list] = sym_exposing_list,
  [sym__exposed_item] = sym__exposed_item,
  [sym_exposed_value] = sym_exposed_value,
  [sym_exposed_type] = sym_exposed_type,
  [sym_exposed_union_constructors] = sym_exposed_union_constructors,
  [sym_exposed_operator] = sym_exposed_operator,
  [sym_upper_case_qid] = sym_upper_case_qid,
  [sym_value_qid] = sym_value_qid,
  [sym_field_accessor_function_expr] = sym_field_accessor_function_expr,
  [sym_import_clause] = sym_import_clause,
  [sym_as_clause] = sym_as_clause,
  [sym__declaration] = sym__declaration,
  [sym_value_declaration] = sym_value_declaration,
  [sym__internal_value_declaration_left] = sym__internal_value_declaration_left,
  [sym_function_declaration_left] = sym_function_declaration_left,
  [sym__function_declaration_pattern] = sym__function_declaration_pattern,
  [sym_type_declaration] = sym_type_declaration,
  [sym_lower_type_name] = sym_lower_type_name,
  [sym_union_variant] = sym_union_variant,
  [sym__more_union_variants] = sym__more_union_variants,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_type_expression] = sym_type_expression,
  [sym__type_expression_inner] = sym__type_expression_inner,
  [sym_type_ref] = sym_type_ref,
  [sym__single_type_expression] = sym__single_type_expression,
  [sym_type_ref_without_args] = sym_type_ref,
  [sym_type_variable] = sym_type_variable,
  [sym_record_type] = sym_record_type,
  [sym_field_type] = sym_field_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_type_annotation] = sym_type_annotation,
  [sym_port_annotation] = sym_port_annotation,
  [sym__expression] = sym__expression,
  [sym_bin_op_expr] = sym_bin_op_expr,
  [sym_operator] = sym_operator,
  [sym_operator_as_function_expr] = sym_operator_as_function_expr,
  [sym__operator_as_function_inner] = sym__operator_as_function_inner,
  [sym__call_or_atom] = sym__call_or_atom,
  [sym_function_call_expr] = sym_function_call_expr,
  [sym__function_call_target] = sym__function_call_target,
  [sym__atom] = sym__atom,
  [sym_field_access_expr] = sym_field_access_expr,
  [sym__field_access_start] = sym__field_access_start,
  [sym__field_access_segment] = sym__field_access_segment,
  [sym_negate_expr] = sym_negate_expr,
  [sym_parenthesized_expr] = sym_parenthesized_expr,
  [sym__literal_expr_group] = sym__literal_expr_group,
  [sym_char_constant_expr] = sym_char_constant_expr,
  [sym_open_char] = sym_open_char,
  [sym_close_char] = sym_close_char,
  [sym_number_constant_expr] = sym_number_constant_expr,
  [sym_string_constant_expr] = sym_string_constant_expr,
  [sym__string_part] = sym__string_part,
  [sym__string_part_multiline] = sym__string_part_multiline,
  [aux_sym__string_parts] = aux_sym__string_parts,
  [aux_sym__string_parts_multiline] = aux_sym__string_parts_multiline,
  [sym_anonymous_function_expr] = sym_anonymous_function_expr,
  [sym_value_expr] = sym_value_expr,
  [sym_tuple_expr] = sym_tuple_expr,
  [sym_unit_expr] = sym_unit_expr,
  [sym_list_expr] = sym_list_expr,
  [sym_record_expr] = sym_record_expr,
  [sym_record_base_identifier] = sym_record_base_identifier,
  [sym__record_base] = sym__record_base,
  [sym__record_inner] = sym__record_inner,
  [sym__record_inner_fields] = sym__record_inner_fields,
  [sym_field] = sym_field,
  [sym_if_else_expr] = sym_if_else_expr,
  [sym_case_of_expr] = sym_case_of_expr,
  [sym__case_of_tail] = sym__case_of_tail,
  [sym__case_of_tail2] = sym__case_of_tail2,
  [sym__more_case_of_branches] = sym__more_case_of_branches,
  [sym_case_of_branch] = sym_case_of_branch,
  [sym_let_in_expr] = sym_let_in_expr,
  [sym__inner_declaration] = sym__inner_declaration,
  [aux_sym__more_inner_declarations] = aux_sym__more_inner_declarations,
  [sym_pattern] = sym_pattern,
  [sym__pattern_as] = sym__pattern_as,
  [sym_cons_pattern] = sym_cons_pattern,
  [sym__single_pattern_cons] = sym__single_pattern_cons,
  [sym__single_pattern] = sym__single_pattern,
  [sym__parenthesized_single_pattern] = sym__parenthesized_single_pattern,
  [sym_lower_pattern] = sym_lower_pattern,
  [sym_anything_pattern] = sym_anything_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym_nullary_constructor_argument_pattern] = sym_nullary_constructor_argument_pattern,
  [sym__union_argument_pattern] = sym__union_argument_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__parenthesized_pattern] = sym__parenthesized_pattern,
  [sym_infix_declaration] = sym_infix_declaration,
  [sym_glsl_code_expr] = sym_glsl_code_expr,
  [sym_number_literal] = sym_number_literal,
  [sym_regular_string_part] = sym_regular_string_part,
  [sym_regular_string_part_multiline] = sym_regular_string_part,
  [sym__if] = sym__if,
  [sym__then] = sym__then,
  [sym__else] = sym__else,
  [sym__let] = sym__let,
  [sym__in] = sym__in,
  [sym_operator_identifier] = sym_operator_identifier,
  [aux_sym_exposing_list_repeat1] = aux_sym_exposing_list_repeat1,
  [aux_sym_upper_case_qid_repeat1] = aux_sym_upper_case_qid_repeat1,
  [aux_sym_value_qid_repeat1] = aux_sym_value_qid_repeat1,
  [aux_sym_function_declaration_left_repeat1] = aux_sym_function_declaration_left_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_type_declaration_repeat2] = aux_sym_type_declaration_repeat2,
  [aux_sym_union_variant_repeat1] = aux_sym_union_variant_repeat1,
  [aux_sym_type_expression_repeat1] = aux_sym_type_expression_repeat1,
  [aux_sym_record_type_repeat1] = aux_sym_record_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_bin_op_expr_repeat1] = aux_sym_bin_op_expr_repeat1,
  [aux_sym_function_call_expr_repeat1] = aux_sym_function_call_expr_repeat1,
  [aux_sym_field_access_expr_repeat1] = aux_sym_field_access_expr_repeat1,
  [aux_sym_anonymous_function_expr_repeat1] = aux_sym_anonymous_function_expr_repeat1,
  [aux_sym_tuple_expr_repeat1] = aux_sym_tuple_expr_repeat1,
  [aux_sym_list_expr_repeat1] = aux_sym_list_expr_repeat1,
  [aux_sym__record_inner_fields_repeat1] = aux_sym__record_inner_fields_repeat1,
  [aux_sym_if_else_expr_repeat1] = aux_sym_if_else_expr_repeat1,
  [aux_sym__more_case_of_branches_repeat1] = aux_sym__more_case_of_branches_repeat1,
  [aux_sym_cons_pattern_repeat1] = aux_sym_cons_pattern_repeat1,
  [aux_sym_record_pattern_repeat1] = aux_sym_record_pattern_repeat1,
  [aux_sym_list_pattern_repeat1] = aux_sym_list_pattern_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_lower_case_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__upper_case_identifier_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym__lower_case_identifier_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym__dot_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_left] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_right] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_non] = {
    .visible = true,
    .named = true,
  },
  [sym_upper_case_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__hex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_regular_char] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_regular_string_part_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_regular_string_part_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_regular_string_part_multiline_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_regular_string_part_multiline_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_invalid_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_effect] = {
    .visible = true,
    .named = true,
  },
  [sym_where] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_as] = {
    .visible = true,
    .named = true,
  },
  [sym_exposing] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_of] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_port] = {
    .visible = true,
    .named = true,
  },
  [sym_infix] = {
    .visible = true,
    .named = true,
  },
  [sym_left_parenthesis] = {
    .visible = true,
    .named = true,
  },
  [sym_right_parenthesis] = {
    .visible = true,
    .named = true,
  },
  [sym_left_square_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_right_square_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_left_brace] = {
    .visible = true,
    .named = true,
  },
  [sym_right_brace] = {
    .visible = true,
    .named = true,
  },
  [sym_double_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_glsl_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_glsl_end] = {
    .visible = true,
    .named = true,
  },
  [sym__char_quote] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_end_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_open_section] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_end_section] = {
    .visible = false,
    .named = true,
  },
  [sym_minus_without_trailing_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_open_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_close_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_open_quote_multiline] = {
    .visible = true,
    .named = true,
  },
  [sym_close_quote_multiline] = {
    .visible = true,
    .named = true,
  },
  [sym_glsl_content] = {
    .visible = true,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__import_list] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__top_decl_list] = {
    .visible = false,
    .named = false,
  },
  [sym_exposing_list] = {
    .visible = true,
    .named = true,
  },
  [sym__exposed_item] = {
    .visible = false,
    .named = true,
  },
  [sym_exposed_value] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_type] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_union_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_upper_case_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_value_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_field_accessor_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_as_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_value_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__internal_value_declaration_left] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration_left] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declaration_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lower_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_union_variant] = {
    .visible = true,
    .named = true,
  },
  [sym__more_union_variants] = {
    .visible = false,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expression_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_type_ref] = {
    .visible = true,
    .named = true,
  },
  [sym__single_type_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_type_ref_without_args] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_port_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_bin_op_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_as_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__operator_as_function_inner] = {
    .visible = false,
    .named = true,
  },
  [sym__call_or_atom] = {
    .visible = false,
    .named = true,
  },
  [sym_function_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__function_call_target] = {
    .visible = false,
    .named = true,
  },
  [sym__atom] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__field_access_start] = {
    .visible = false,
    .named = true,
  },
  [sym__field_access_segment] = {
    .visible = false,
    .named = true,
  },
  [sym_negate_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_expr_group] = {
    .visible = false,
    .named = true,
  },
  [sym_char_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_open_char] = {
    .visible = true,
    .named = true,
  },
  [sym_close_char] = {
    .visible = true,
    .named = true,
  },
  [sym_number_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_string_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__string_part] = {
    .visible = false,
    .named = true,
  },
  [sym__string_part_multiline] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__string_parts] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_parts_multiline] = {
    .visible = false,
    .named = false,
  },
  [sym_anonymous_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_value_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_list_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_record_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_record_base_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__record_base] = {
    .visible = false,
    .named = true,
  },
  [sym__record_inner] = {
    .visible = false,
    .named = true,
  },
  [sym__record_inner_fields] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_if_else_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_case_of_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__case_of_tail] = {
    .visible = false,
    .named = true,
  },
  [sym__case_of_tail2] = {
    .visible = false,
    .named = true,
  },
  [sym__more_case_of_branches] = {
    .visible = false,
    .named = true,
  },
  [sym_case_of_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__inner_declaration] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__more_inner_declarations] = {
    .visible = false,
    .named = false,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_as] = {
    .visible = false,
    .named = true,
  },
  [sym_cons_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__single_pattern_cons] = {
    .visible = false,
    .named = true,
  },
  [sym__single_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__parenthesized_single_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_lower_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_anything_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nullary_constructor_argument_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__union_argument_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_infix_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_glsl_code_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_regular_string_part] = {
    .visible = true,
    .named = true,
  },
  [sym_regular_string_part_multiline] = {
    .visible = true,
    .named = true,
  },
  [sym__if] = {
    .visible = false,
    .named = true,
  },
  [sym__then] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym__let] = {
    .visible = false,
    .named = true,
  },
  [sym__in] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_exposing_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_upper_case_qid_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_qid_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declaration_left_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_variant_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bin_op_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_call_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_access_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__record_inner_fields_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_else_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__more_case_of_branches_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cons_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_arg = 1,
  field_argPattern = 2,
  field_asClause = 3,
  field_associativity = 4,
  field_baseRecord = 5,
  field_body = 6,
  field_branch = 7,
  field_child = 8,
  field_constructor = 9,
  field_content = 10,
  field_doubleDot = 11,
  field_exposing = 12,
  field_expr = 13,
  field_exprList = 14,
  field_expression = 15,
  field_field = 16,
  field_fieldType = 17,
  field_functionDeclarationLeft = 18,
  field_moduleDeclaration = 19,
  field_moduleName = 20,
  field_name = 21,
  field_operator = 22,
  field_param = 23,
  field_part = 24,
  field_pattern = 25,
  field_patternAs = 26,
  field_patternList = 27,
  field_precedence = 28,
  field_target = 29,
  field_typeExpression = 30,
  field_typeName = 31,
  field_typeVariable = 32,
  field_unionVariant = 33,
  field_unitExpr = 34,
  field_valueDeclaration = 35,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_argPattern] = "argPattern",
  [field_asClause] = "asClause",
  [field_associativity] = "associativity",
  [field_baseRecord] = "baseRecord",
  [field_body] = "body",
  [field_branch] = "branch",
  [field_child] = "child",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_doubleDot] = "doubleDot",
  [field_exposing] = "exposing",
  [field_expr] = "expr",
  [field_exprList] = "exprList",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_fieldType] = "fieldType",
  [field_functionDeclarationLeft] = "functionDeclarationLeft",
  [field_moduleDeclaration] = "moduleDeclaration",
  [field_moduleName] = "moduleName",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_param] = "param",
  [field_part] = "part",
  [field_pattern] = "pattern",
  [field_patternAs] = "patternAs",
  [field_patternList] = "patternList",
  [field_precedence] = "precedence",
  [field_target] = "target",
  [field_typeExpression] = "typeExpression",
  [field_typeName] = "typeName",
  [field_typeVariable] = "typeVariable",
  [field_unionVariant] = "unionVariant",
  [field_unitExpr] = "unitExpr",
  [field_valueDeclaration] = "valueDeclaration",
};

static const TSFieldMapSlice ts_field_map_slices[99] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 1},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 2},
  [12] = {.index = 14, .length = 2},
  [13] = {.index = 16, .length = 2},
  [14] = {.index = 18, .length = 1},
  [15] = {.index = 19, .length = 1},
  [16] = {.index = 20, .length = 1},
  [17] = {.index = 21, .length = 2},
  [18] = {.index = 23, .length = 2},
  [19] = {.index = 25, .length = 2},
  [20] = {.index = 27, .length = 1},
  [21] = {.index = 28, .length = 1},
  [22] = {.index = 29, .length = 1},
  [23] = {.index = 30, .length = 1},
  [24] = {.index = 31, .length = 3},
  [25] = {.index = 34, .length = 1},
  [26] = {.index = 35, .length = 1},
  [27] = {.index = 36, .length = 2},
  [28] = {.index = 38, .length = 1},
  [29] = {.index = 39, .length = 1},
  [30] = {.index = 40, .length = 3},
  [31] = {.index = 43, .length = 2},
  [32] = {.index = 45, .length = 2},
  [33] = {.index = 47, .length = 2},
  [34] = {.index = 49, .length = 2},
  [35] = {.index = 51, .length = 2},
  [36] = {.index = 53, .length = 2},
  [37] = {.index = 55, .length = 1},
  [38] = {.index = 56, .length = 1},
  [39] = {.index = 57, .length = 1},
  [40] = {.index = 58, .length = 2},
  [41] = {.index = 60, .length = 2},
  [42] = {.index = 62, .length = 1},
  [43] = {.index = 63, .length = 2},
  [44] = {.index = 65, .length = 1},
  [45] = {.index = 66, .length = 1},
  [46] = {.index = 67, .length = 2},
  [47] = {.index = 69, .length = 1},
  [48] = {.index = 70, .length = 3},
  [49] = {.index = 73, .length = 3},
  [50] = {.index = 76, .length = 2},
  [51] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 1},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 1},
  [56] = {.index = 85, .length = 2},
  [57] = {.index = 87, .length = 2},
  [58] = {.index = 89, .length = 2},
  [59] = {.index = 91, .length = 1},
  [60] = {.index = 92, .length = 3},
  [61] = {.index = 95, .length = 1},
  [62] = {.index = 96, .length = 1},
  [63] = {.index = 97, .length = 2},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 101, .length = 2},
  [66] = {.index = 103, .length = 2},
  [67] = {.index = 105, .length = 2},
  [68] = {.index = 107, .length = 1},
  [69] = {.index = 108, .length = 2},
  [70] = {.index = 110, .length = 1},
  [71] = {.index = 111, .length = 2},
  [72] = {.index = 113, .length = 4},
  [73] = {.index = 117, .length = 3},
  [74] = {.index = 120, .length = 3},
  [75] = {.index = 123, .length = 3},
  [76] = {.index = 126, .length = 2},
  [77] = {.index = 128, .length = 1},
  [78] = {.index = 129, .length = 1},
  [79] = {.index = 130, .length = 1},
  [80] = {.index = 131, .length = 2},
  [81] = {.index = 133, .length = 2},
  [82] = {.index = 135, .length = 2},
  [83] = {.index = 137, .length = 2},
  [84] = {.index = 139, .length = 2},
  [85] = {.index = 141, .length = 1},
  [86] = {.index = 142, .length = 2},
  [87] = {.index = 144, .length = 2},
  [88] = {.index = 146, .length = 4},
  [89] = {.index = 150, .length = 3},
  [90] = {.index = 153, .length = 1},
  [91] = {.index = 154, .length = 2},
  [92] = {.index = 156, .length = 2},
  [93] = {.index = 158, .length = 2},
  [94] = {.index = 160, .length = 1},
  [95] = {.index = 161, .length = 1},
  [96] = {.index = 162, .length = 2},
  [97] = {.index = 164, .length = 2},
  [98] = {.index = 166, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_constructor, 0},
  [1] =
    {field_functionDeclarationLeft, 0},
  [2] =
    {field_child, 0},
  [3] =
    {field_pattern, 0},
  [4] =
    {field_child, 0, .inherited = true},
  [5] =
    {field_pattern, 1},
  [6] =
    {field_moduleName, 1},
  [7] =
    {field_moduleDeclaration, 0},
  [8] =
    {field_argPattern, 1},
    {field_constructor, 0},
  [10] =
    {field_child, 0},
    {field_patternAs, 1, .inherited = true},
  [12] =
    {field_part, 0},
    {field_part, 1, .inherited = true},
  [14] =
    {field_child, 0, .inherited = true},
    {field_patternAs, 1, .inherited = true},
  [16] =
    {field_name, 0},
    {field_typeExpression, 2},
  [18] =
    {field_part, 0, .inherited = true},
  [19] =
    {field_part, 0},
  [20] =
    {field_unitExpr, 0},
  [21] =
    {field_exposing, 2},
    {field_name, 1},
  [23] =
    {field_exposing, 2},
    {field_moduleName, 1},
  [25] =
    {field_asClause, 2},
    {field_moduleName, 1},
  [27] =
    {field_child, 1},
  [28] =
    {field_part, 1},
  [29] =
    {field_patternList, 1},
  [30] =
    {field_name, 0},
  [31] =
    {field_body, 2},
    {field_functionDeclarationLeft, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [34] =
    {field_operator, 0, .inherited = true},
  [35] =
    {field_patternAs, 1},
  [36] =
    {field_part, 0, .inherited = true},
    {field_part, 1, .inherited = true},
  [38] =
    {field_part, 1, .inherited = true},
  [39] =
    {field_name, 1},
  [40] =
    {field_asClause, 2},
    {field_exposing, 3},
    {field_moduleName, 1},
  [43] =
    {field_name, 1},
    {field_unionVariant, 3},
  [45] =
    {field_name, 1},
    {field_typeExpression, 3},
  [47] =
    {field_exposing, 3},
    {field_name, 2},
  [49] =
    {field_part, 1},
    {field_part, 2, .inherited = true},
  [51] =
    {field_patternList, 1},
    {field_patternList, 2, .inherited = true},
  [53] =
    {field_patternList, 0, .inherited = true},
    {field_patternList, 1, .inherited = true},
  [55] =
    {field_exprList, 1},
  [56] =
    {field_field, 0, .inherited = true},
  [57] =
    {field_field, 0},
  [58] =
    {field_part, 0},
    {field_part, 1},
  [60] =
    {field_arg, 1},
    {field_target, 0},
  [62] =
    {field_target, 0},
  [63] =
    {field_body, 1, .inherited = true},
    {field_valueDeclaration, 0, .inherited = true},
  [65] =
    {field_fieldType, 1},
  [66] =
    {field_baseRecord, 0},
  [67] =
    {field_name, 0},
    {field_part, 1, .inherited = true},
  [69] =
    {field_unionVariant, 0, .inherited = true},
  [70] =
    {field_name, 1},
    {field_unionVariant, 3},
    {field_unionVariant, 4, .inherited = true},
  [73] =
    {field_name, 1},
    {field_typeName, 2},
    {field_unionVariant, 4},
  [76] =
    {field_name, 2},
    {field_typeExpression, 4},
  [78] =
    {field_pattern, 1},
    {field_pattern, 3},
  [80] =
    {field_branch, 2, .inherited = true},
    {field_expr, 1},
  [82] =
    {field_valueDeclaration, 0},
  [83] =
    {field_expression, 1},
  [84] =
    {field_operator, 1},
  [85] =
    {field_baseRecord, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [87] =
    {field_baseRecord, 1, .inherited = true},
    {field_field, 1, .inherited = true},
  [89] =
    {field_field, 0},
    {field_field, 1, .inherited = true},
  [91] =
    {field_content, 1},
  [92] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
  [95] =
    {field_body, 1},
  [96] =
    {field_typeExpression, 1},
  [97] =
    {field_typeExpression, 1},
    {field_typeExpression, 2, .inherited = true},
  [99] =
    {field_typeExpression, 0, .inherited = true},
    {field_typeExpression, 1, .inherited = true},
  [101] =
    {field_fieldType, 1},
    {field_fieldType, 2, .inherited = true},
  [103] =
    {field_fieldType, 0, .inherited = true},
    {field_fieldType, 1, .inherited = true},
  [105] =
    {field_baseRecord, 1, .inherited = true},
    {field_fieldType, 2},
  [107] =
    {field_doubleDot, 2},
  [108] =
    {field_exposing, 5},
    {field_name, 2},
  [110] =
    {field_unionVariant, 1},
  [111] =
    {field_unionVariant, 0, .inherited = true},
    {field_unionVariant, 1, .inherited = true},
  [113] =
    {field_name, 1},
    {field_typeName, 2},
    {field_unionVariant, 4},
    {field_unionVariant, 5, .inherited = true},
  [117] =
    {field_name, 2},
    {field_typeExpression, 5},
    {field_typeVariable, 3},
  [120] =
    {field_associativity, 1},
    {field_operator, 3, .inherited = true},
    {field_precedence, 2},
  [123] =
    {field_pattern, 1},
    {field_pattern, 3},
    {field_pattern, 4, .inherited = true},
  [126] =
    {field_pattern, 0, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [128] =
    {field_branch, 1, .inherited = true},
  [129] =
    {field_valueDeclaration, 2, .inherited = true},
  [130] =
    {field_expr, 1},
  [131] =
    {field_expr, 1},
    {field_expr, 2, .inherited = true},
  [133] =
    {field_expr, 0, .inherited = true},
    {field_expr, 1, .inherited = true},
  [135] =
    {field_exprList, 1},
    {field_exprList, 2, .inherited = true},
  [137] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
  [139] =
    {field_expression, 2},
    {field_name, 0},
  [141] =
    {field_field, 1},
  [142] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [144] =
    {field_expr, 3},
    {field_param, 1},
  [146] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
    {field_exprList, 3, .inherited = true},
  [150] =
    {field_baseRecord, 1, .inherited = true},
    {field_fieldType, 2},
    {field_fieldType, 3, .inherited = true},
  [153] =
    {field_valueDeclaration, 1, .inherited = true},
  [154] =
    {field_valueDeclaration, 2, .inherited = true},
    {field_valueDeclaration, 3, .inherited = true},
  [156] =
    {field_valueDeclaration, 0, .inherited = true},
    {field_valueDeclaration, 1, .inherited = true},
  [158] =
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
  [160] =
    {field_branch, 1},
  [161] =
    {field_branch, 0, .inherited = true},
  [162] =
    {field_branch, 1},
    {field_branch, 2, .inherited = true},
  [164] =
    {field_branch, 0, .inherited = true},
    {field_branch, 1, .inherited = true},
  [166] =
    {field_expr, 2},
    {field_pattern, 0},
};

static TSSymbol ts_alias_sequences[99][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_upper_case_identifier_character_set_1(int32_t lookahead) {
  return
    ('A' <= lookahead && lookahead <= 'Z') ||
    (192 <= lookahead && lookahead <= 214) ||
    (216 <= lookahead && lookahead <= 222) ||
    lookahead == 256 ||
    lookahead == 258 ||
    lookahead == 260 ||
    lookahead == 262 ||
    lookahead == 264 ||
    lookahead == 266 ||
    lookahead == 268 ||
    lookahead == 270 ||
    lookahead == 272 ||
    lookahead == 274 ||
    lookahead == 276 ||
    lookahead == 278 ||
    lookahead == 280 ||
    lookahead == 282 ||
    lookahead == 284 ||
    lookahead == 286 ||
    lookahead == 288 ||
    lookahead == 290 ||
    lookahead == 292 ||
    lookahead == 294 ||
    lookahead == 296 ||
    lookahead == 298 ||
    lookahead == 300 ||
    lookahead == 302 ||
    lookahead == 304 ||
    lookahead == 306 ||
    lookahead == 308 ||
    lookahead == 310 ||
    lookahead == 313 ||
    lookahead == 315 ||
    lookahead == 317 ||
    lookahead == 319 ||
    lookahead == 321 ||
    lookahead == 323 ||
    lookahead == 325 ||
    lookahead == 327 ||
    lookahead == 330 ||
    lookahead == 332 ||
    lookahead == 334 ||
    lookahead == 336 ||
    lookahead == 338 ||
    lookahead == 340 ||
    lookahead == 342 ||
    lookahead == 344 ||
    lookahead == 346 ||
    lookahead == 348 ||
    lookahead == 350 ||
    lookahead == 352 ||
    lookahead == 354 ||
    lookahead == 356 ||
    lookahead == 358 ||
    lookahead == 360 ||
    lookahead == 362 ||
    lookahead == 364 ||
    lookahead == 366 ||
    lookahead == 368 ||
    lookahead == 370 ||
    lookahead == 372 ||
    lookahead == 374 ||
    lookahead == 376 ||
    lookahead == 377 ||
    lookahead == 379 ||
    lookahead == 381 ||
    lookahead == 385 ||
    lookahead == 386 ||
    lookahead == 388 ||
    lookahead == 390 ||
    lookahead == 391 ||
    (393 <= lookahead && lookahead <= 395) ||
    (398 <= lookahead && lookahead <= 401) ||
    lookahead == 403 ||
    lookahead == 404 ||
    (406 <= lookahead && lookahead <= 408) ||
    lookahead == 412 ||
    lookahead == 413 ||
    lookahead == 415 ||
    lookahead == 416 ||
    lookahead == 418 ||
    lookahead == 420 ||
    lookahead == 422 ||
    lookahead == 423 ||
    lookahead == 425 ||
    lookahead == 428 ||
    lookahead == 430 ||
    lookahead == 431 ||
    (433 <= lookahead && lookahead <= 435) ||
    lookahead == 437 ||
    lookahead == 439 ||
    lookahead == 440 ||
    lookahead == 444 ||
    lookahead == 452 ||
    lookahead == 455 ||
    lookahead == 458 ||
    lookahead == 461 ||
    lookahead == 463 ||
    lookahead == 465 ||
    lookahead == 467 ||
    lookahead == 469 ||
    lookahead == 471 ||
    lookahead == 473 ||
    lookahead == 475 ||
    lookahead == 478 ||
    lookahead == 480 ||
    lookahead == 482 ||
    lookahead == 484 ||
    lookahead == 486 ||
    lookahead == 488 ||
    lookahead == 490 ||
    lookahead == 492 ||
    lookahead == 494 ||
    lookahead == 497 ||
    lookahead == 500 ||
    (502 <= lookahead && lookahead <= 504) ||
    lookahead == 506 ||
    lookahead == 508 ||
    lookahead == 510 ||
    lookahead == 512 ||
    lookahead == 514 ||
    lookahead == 516 ||
    lookahead == 518 ||
    lookahead == 520 ||
    lookahead == 522 ||
    lookahead == 524 ||
    lookahead == 526 ||
    lookahead == 528 ||
    lookahead == 530 ||
    lookahead == 532 ||
    lookahead == 534 ||
    lookahead == 536 ||
    lookahead == 538 ||
    lookahead == 540 ||
    lookahead == 542 ||
    lookahead == 544 ||
    lookahead == 546 ||
    lookahead == 548 ||
    lookahead == 550 ||
    lookahead == 552 ||
    lookahead == 554 ||
    lookahead == 556 ||
    lookahead == 558 ||
    lookahead == 560 ||
    lookahead == 562 ||
    lookahead == 570 ||
    lookahead == 571 ||
    lookahead == 573 ||
    lookahead == 574 ||
    lookahead == 577 ||
    (579 <= lookahead && lookahead <= 582) ||
    lookahead == 584 ||
    lookahead == 586 ||
    lookahead == 588 ||
    lookahead == 590 ||
    lookahead == 880 ||
    lookahead == 882 ||
    lookahead == 886 ||
    lookahead == 895 ||
    lookahead == 902 ||
    (904 <= lookahead && lookahead <= 906) ||
    lookahead == 908 ||
    lookahead == 910 ||
    lookahead == 911 ||
    (913 <= lookahead && lookahead <= 929) ||
    (931 <= lookahead && lookahead <= 939) ||
    lookahead == 975 ||
    (978 <= lookahead && lookahead <= 980) ||
    lookahead == 984 ||
    lookahead == 986 ||
    lookahead == 988 ||
    lookahead == 990 ||
    lookahead == 992 ||
    lookahead == 994 ||
    lookahead == 996 ||
    lookahead == 998 ||
    lookahead == 1000 ||
    lookahead == 1002 ||
    lookahead == 1004 ||
    lookahead == 1006 ||
    lookahead == 1012 ||
    lookahead == 1015 ||
    lookahead == 1017 ||
    lookahead == 1018 ||
    (1021 <= lookahead && lookahead <= 1071) ||
    lookahead == 1120 ||
    lookahead == 1122 ||
    lookahead == 1124 ||
    lookahead == 1126 ||
    lookahead == 1128 ||
    lookahead == 1130 ||
    lookahead == 1132 ||
    lookahead == 1134 ||
    lookahead == 1136 ||
    lookahead == 1138 ||
    lookahead == 1140 ||
    lookahead == 1142 ||
    lookahead == 1144 ||
    lookahead == 1146 ||
    lookahead == 1148 ||
    lookahead == 1150 ||
    lookahead == 1152 ||
    lookahead == 1162 ||
    lookahead == 1164 ||
    lookahead == 1166 ||
    lookahead == 1168 ||
    lookahead == 1170 ||
    lookahead == 1172 ||
    lookahead == 1174 ||
    lookahead == 1176 ||
    lookahead == 1178 ||
    lookahead == 1180 ||
    lookahead == 1182 ||
    lookahead == 1184 ||
    lookahead == 1186 ||
    lookahead == 1188 ||
    lookahead == 1190 ||
    lookahead == 1192 ||
    lookahead == 1194 ||
    lookahead == 1196 ||
    lookahead == 1198 ||
    lookahead == 1200 ||
    lookahead == 1202 ||
    lookahead == 1204 ||
    lookahead == 1206 ||
    lookahead == 1208 ||
    lookahead == 1210 ||
    lookahead == 1212 ||
    lookahead == 1214 ||
    lookahead == 1216 ||
    lookahead == 1217 ||
    lookahead == 1219 ||
    lookahead == 1221 ||
    lookahead == 1223 ||
    lookahead == 1225 ||
    lookahead == 1227 ||
    lookahead == 1229 ||
    lookahead == 1232 ||
    lookahead == 1234 ||
    lookahead == 1236 ||
    lookahead == 1238 ||
    lookahead == 1240 ||
    lookahead == 1242 ||
    lookahead == 1244 ||
    lookahead == 1246 ||
    lookahead == 1248 ||
    lookahead == 1250 ||
    lookahead == 1252 ||
    lookahead == 1254 ||
    lookahead == 1256 ||
    lookahead == 1258 ||
    lookahead == 1260 ||
    lookahead == 1262 ||
    lookahead == 1264 ||
    lookahead == 1266 ||
    lookahead == 1268 ||
    lookahead == 1270 ||
    lookahead == 1272 ||
    lookahead == 1274 ||
    lookahead == 1276 ||
    lookahead == 1278 ||
    lookahead == 1280 ||
    lookahead == 1282 ||
    lookahead == 1284 ||
    lookahead == 1286 ||
    lookahead == 1288 ||
    lookahead == 1290 ||
    lookahead == 1292 ||
    lookahead == 1294 ||
    lookahead == 1296 ||
    lookahead == 1298 ||
    lookahead == 1300 ||
    lookahead == 1302 ||
    lookahead == 1304 ||
    lookahead == 1306 ||
    lookahead == 1308 ||
    lookahead == 1310 ||
    lookahead == 1312 ||
    lookahead == 1314 ||
    lookahead == 1316 ||
    lookahead == 1318 ||
    lookahead == 1320 ||
    lookahead == 1322 ||
    lookahead == 1324 ||
    lookahead == 1326 ||
    (1329 <= lookahead && lookahead <= 1366) ||
    (4256 <= lookahead && lookahead <= 4293) ||
    lookahead == 4295 ||
    lookahead == 4301 ||
    (5024 <= lookahead && lookahead <= 5109) ||
    (7312 <= lookahead && lookahead <= 7354) ||
    (7357 <= lookahead && lookahead <= 7359) ||
    lookahead == 7680 ||
    lookahead == 7682 ||
    lookahead == 7684 ||
    lookahead == 7686 ||
    lookahead == 7688 ||
    lookahead == 7690 ||
    lookahead == 7692 ||
    lookahead == 7694 ||
    lookahead == 7696 ||
    lookahead == 7698 ||
    lookahead == 7700 ||
    lookahead == 7702 ||
    lookahead == 7704 ||
    lookahead == 7706 ||
    lookahead == 7708 ||
    lookahead == 7710 ||
    lookahead == 7712 ||
    lookahead == 7714 ||
    lookahead == 7716 ||
    lookahead == 7718 ||
    lookahead == 7720 ||
    lookahead == 7722 ||
    lookahead == 7724 ||
    lookahead == 7726 ||
    lookahead == 7728 ||
    lookahead == 7730 ||
    lookahead == 7732 ||
    lookahead == 7734 ||
    lookahead == 7736 ||
    lookahead == 7738 ||
    lookahead == 7740 ||
    lookahead == 7742 ||
    lookahead == 7744 ||
    lookahead == 7746 ||
    lookahead == 7748 ||
    lookahead == 7750 ||
    lookahead == 7752 ||
    lookahead == 7754 ||
    lookahead == 7756 ||
    lookahead == 7758 ||
    lookahead == 7760 ||
    lookahead == 7762 ||
    lookahead == 7764 ||
    lookahead == 7766 ||
    lookahead == 7768 ||
    lookahead == 7770 ||
    lookahead == 7772 ||
    lookahead == 7774 ||
    lookahead == 7776 ||
    lookahead == 7778 ||
    lookahead == 7780 ||
    lookahead == 7782 ||
    lookahead == 7784 ||
    lookahead == 7786 ||
    lookahead == 7788 ||
    lookahead == 7790 ||
    lookahead == 7792 ||
    lookahead == 7794 ||
    lookahead == 7796 ||
    lookahead == 7798 ||
    lookahead == 7800 ||
    lookahead == 7802 ||
    lookahead == 7804 ||
    lookahead == 7806 ||
    lookahead == 7808 ||
    lookahead == 7810 ||
    lookahead == 7812 ||
    lookahead == 7814 ||
    lookahead == 7816 ||
    lookahead == 7818 ||
    lookahead == 7820 ||
    lookahead == 7822 ||
    lookahead == 7824 ||
    lookahead == 7826 ||
    lookahead == 7828 ||
    lookahead == 7838 ||
    lookahead == 7840 ||
    lookahead == 7842 ||
    lookahead == 7844 ||
    lookahead == 7846 ||
    lookahead == 7848 ||
    lookahead == 7850 ||
    lookahead == 7852 ||
    lookahead == 7854 ||
    lookahead == 7856 ||
    lookahead == 7858 ||
    lookahead == 7860 ||
    lookahead == 7862 ||
    lookahead == 7864 ||
    lookahead == 7866 ||
    lookahead == 7868 ||
    lookahead == 7870 ||
    lookahead == 7872 ||
    lookahead == 7874 ||
    lookahead == 7876 ||
    lookahead == 7878 ||
    lookahead == 7880 ||
    lookahead == 7882 ||
    lookahead == 7884 ||
    lookahead == 7886 ||
    lookahead == 7888 ||
    lookahead == 7890 ||
    lookahead == 7892 ||
    lookahead == 7894 ||
    lookahead == 7896 ||
    lookahead == 7898 ||
    lookahead == 7900 ||
    lookahead == 7902 ||
    lookahead == 7904 ||
    lookahead == 7906 ||
    lookahead == 7908 ||
    lookahead == 7910 ||
    lookahead == 7912 ||
    lookahead == 7914 ||
    lookahead == 7916 ||
    lookahead == 7918 ||
    lookahead == 7920 ||
    lookahead == 7922 ||
    lookahead == 7924 ||
    lookahead == 7926 ||
    lookahead == 7928 ||
    lookahead == 7930 ||
    lookahead == 7932 ||
    lookahead == 7934 ||
    (7944 <= lookahead && lookahead <= 7951) ||
    (7960 <= lookahead && lookahead <= 7965) ||
    (7976 <= lookahead && lookahead <= 7983) ||
    (7992 <= lookahead && lookahead <= 7999) ||
    (8008 <= lookahead && lookahead <= 8013) ||
    lookahead == 8025 ||
    lookahead == 8027 ||
    lookahead == 8029 ||
    lookahead == 8031 ||
    (8040 <= lookahead && lookahead <= 8047) ||
    (8120 <= lookahead && lookahead <= 8123) ||
    (8136 <= lookahead && lookahead <= 8139) ||
    (8152 <= lookahead && lookahead <= 8155) ||
    (8168 <= lookahead && lookahead <= 8172) ||
    (8184 <= lookahead && lookahead <= 8187) ||
    lookahead == 8450 ||
    lookahead == 8455 ||
    (8459 <= lookahead && lookahead <= 8461) ||
    (8464 <= lookahead && lookahead <= 8466) ||
    lookahead == 8469 ||
    (8473 <= lookahead && lookahead <= 8477) ||
    lookahead == 8484 ||
    lookahead == 8486 ||
    lookahead == 8488 ||
    (8490 <= lookahead && lookahead <= 8493) ||
    (8496 <= lookahead && lookahead <= 8499) ||
    lookahead == 8510 ||
    lookahead == 8511 ||
    lookahead == 8517 ||
    lookahead == 8579 ||
    (11264 <= lookahead && lookahead <= 11310) ||
    lookahead == 11360 ||
    (11362 <= lookahead && lookahead <= 11364) ||
    lookahead == 11367 ||
    lookahead == 11369 ||
    lookahead == 11371 ||
    (11373 <= lookahead && lookahead <= 11376) ||
    lookahead == 11378 ||
    lookahead == 11381 ||
    (11390 <= lookahead && lookahead <= 11392) ||
    lookahead == 11394 ||
    lookahead == 11396 ||
    lookahead == 11398 ||
    lookahead == 11400 ||
    lookahead == 11402 ||
    lookahead == 11404 ||
    lookahead == 11406 ||
    lookahead == 11408 ||
    lookahead == 11410 ||
    lookahead == 11412 ||
    lookahead == 11414 ||
    lookahead == 11416 ||
    lookahead == 11418 ||
    lookahead == 11420 ||
    lookahead == 11422 ||
    lookahead == 11424 ||
    lookahead == 11426 ||
    lookahead == 11428 ||
    lookahead == 11430 ||
    lookahead == 11432 ||
    lookahead == 11434 ||
    lookahead == 11436 ||
    lookahead == 11438 ||
    lookahead == 11440 ||
    lookahead == 11442 ||
    lookahead == 11444 ||
    lookahead == 11446 ||
    lookahead == 11448 ||
    lookahead == 11450 ||
    lookahead == 11452 ||
    lookahead == 11454 ||
    lookahead == 11456 ||
    lookahead == 11458 ||
    lookahead == 11460 ||
    lookahead == 11462 ||
    lookahead == 11464 ||
    lookahead == 11466 ||
    lookahead == 11468 ||
    lookahead == 11470 ||
    lookahead == 11472 ||
    lookahead == 11474 ||
    lookahead == 11476 ||
    lookahead == 11478 ||
    lookahead == 11480 ||
    lookahead == 11482 ||
    lookahead == 11484 ||
    lookahead == 11486 ||
    lookahead == 11488 ||
    lookahead == 11490 ||
    lookahead == 11499 ||
    lookahead == 11501 ||
    lookahead == 11506 ||
    lookahead == 42560 ||
    lookahead == 42562 ||
    lookahead == 42564 ||
    lookahead == 42566 ||
    lookahead == 42568 ||
    lookahead == 42570 ||
    lookahead == 42572 ||
    lookahead == 42574 ||
    lookahead == 42576 ||
    lookahead == 42578 ||
    lookahead == 42580 ||
    lookahead == 42582 ||
    lookahead == 42584 ||
    lookahead == 42586 ||
    lookahead == 42588 ||
    lookahead == 42590 ||
    lookahead == 42592 ||
    lookahead == 42594 ||
    lookahead == 42596 ||
    lookahead == 42598 ||
    lookahead == 42600 ||
    lookahead == 42602 ||
    lookahead == 42604 ||
    lookahead == 42624 ||
    lookahead == 42626 ||
    lookahead == 42628 ||
    lookahead == 42630 ||
    lookahead == 42632 ||
    lookahead == 42634 ||
    lookahead == 42636 ||
    lookahead == 42638 ||
    lookahead == 42640 ||
    lookahead == 42642 ||
    lookahead == 42644 ||
    lookahead == 42646 ||
    lookahead == 42648 ||
    lookahead == 42650 ||
    lookahead == 42786 ||
    lookahead == 42788 ||
    lookahead == 42790 ||
    lookahead == 42792 ||
    lookahead == 42794 ||
    lookahead == 42796 ||
    lookahead == 42798 ||
    lookahead == 42802 ||
    lookahead == 42804 ||
    lookahead == 42806 ||
    lookahead == 42808 ||
    lookahead == 42810 ||
    lookahead == 42812 ||
    lookahead == 42814 ||
    lookahead == 42816 ||
    lookahead == 42818 ||
    lookahead == 42820 ||
    lookahead == 42822 ||
    lookahead == 42824 ||
    lookahead == 42826 ||
    lookahead == 42828 ||
    lookahead == 42830 ||
    lookahead == 42832 ||
    lookahead == 42834 ||
    lookahead == 42836 ||
    lookahead == 42838 ||
    lookahead == 42840 ||
    lookahead == 42842 ||
    lookahead == 42844 ||
    lookahead == 42846 ||
    lookahead == 42848 ||
    lookahead == 42850 ||
    lookahead == 42852 ||
    lookahead == 42854 ||
    lookahead == 42856 ||
    lookahead == 42858 ||
    lookahead == 42860 ||
    lookahead == 42862 ||
    lookahead == 42873 ||
    lookahead == 42875 ||
    lookahead == 42877 ||
    lookahead == 42878 ||
    lookahead == 42880 ||
    lookahead == 42882 ||
    lookahead == 42884 ||
    lookahead == 42886 ||
    lookahead == 42891 ||
    lookahead == 42893 ||
    lookahead == 42896 ||
    lookahead == 42898 ||
    lookahead == 42902 ||
    lookahead == 42904 ||
    lookahead == 42906 ||
    lookahead == 42908 ||
    lookahead == 42910 ||
    lookahead == 42912 ||
    lookahead == 42914 ||
    lookahead == 42916 ||
    lookahead == 42918 ||
    lookahead == 42920 ||
    (42922 <= lookahead && lookahead <= 42926) ||
    (42928 <= lookahead && lookahead <= 42932) ||
    lookahead == 42934 ||
    lookahead == 42936 ||
    lookahead == 42938 ||
    lookahead == 42940 ||
    lookahead == 42942 ||
    lookahead == 42946 ||
    (42948 <= lookahead && lookahead <= 42950) ||
    (65313 <= lookahead && lookahead <= 65338) ||
    (66560 <= lookahead && lookahead <= 66599) ||
    (66736 <= lookahead && lookahead <= 66771) ||
    (68736 <= lookahead && lookahead <= 68786) ||
    (71840 <= lookahead && lookahead <= 71871) ||
    (93760 <= lookahead && lookahead <= 93791) ||
    (119808 <= lookahead && lookahead <= 119833) ||
    (119860 <= lookahead && lookahead <= 119885) ||
    (119912 <= lookahead && lookahead <= 119937) ||
    lookahead == 119964 ||
    lookahead == 119966 ||
    lookahead == 119967 ||
    lookahead == 119970 ||
    lookahead == 119973 ||
    lookahead == 119974 ||
    (119977 <= lookahead && lookahead <= 119980) ||
    (119982 <= lookahead && lookahead <= 119989) ||
    (120016 <= lookahead && lookahead <= 120041) ||
    lookahead == 120068 ||
    lookahead == 120069 ||
    (120071 <= lookahead && lookahead <= 120074) ||
    (120077 <= lookahead && lookahead <= 120084) ||
    (120086 <= lookahead && lookahead <= 120092) ||
    lookahead == 120120 ||
    lookahead == 120121 ||
    (120123 <= lookahead && lookahead <= 120126) ||
    (120128 <= lookahead && lookahead <= 120132) ||
    lookahead == 120134 ||
    (120138 <= lookahead && lookahead <= 120144) ||
    (120172 <= lookahead && lookahead <= 120197) ||
    (120224 <= lookahead && lookahead <= 120249) ||
    (120276 <= lookahead && lookahead <= 120301) ||
    (120328 <= lookahead && lookahead <= 120353) ||
    (120380 <= lookahead && lookahead <= 120405) ||
    (120432 <= lookahead && lookahead <= 120457) ||
    (120488 <= lookahead && lookahead <= 120512) ||
    (120546 <= lookahead && lookahead <= 120570) ||
    (120604 <= lookahead && lookahead <= 120628) ||
    (120662 <= lookahead && lookahead <= 120686) ||
    (120720 <= lookahead && lookahead <= 120744) ||
    lookahead == 120778 ||
    (125184 <= lookahead && lookahead <= 125217);
}

static inline bool sym_upper_case_identifier_character_set_2(int32_t lookahead) {
  return
    ('0' <= lookahead && lookahead <= '9') ||
    ('A' <= lookahead && lookahead <= 'Z') ||
    lookahead == '_' ||
    ('a' <= lookahead && lookahead <= 'z') ||
    lookahead == 170 ||
    lookahead == 181 ||
    lookahead == 186 ||
    (192 <= lookahead && lookahead <= 214) ||
    (216 <= lookahead && lookahead <= 246) ||
    (248 <= lookahead && lookahead <= 705) ||
    (710 <= lookahead && lookahead <= 721) ||
    (736 <= lookahead && lookahead <= 740) ||
    lookahead == 748 ||
    lookahead == 750 ||
    (880 <= lookahead && lookahead <= 884) ||
    lookahead == 886 ||
    lookahead == 887 ||
    (890 <= lookahead && lookahead <= 893) ||
    lookahead == 895 ||
    lookahead == 902 ||
    (904 <= lookahead && lookahead <= 906) ||
    lookahead == 908 ||
    (910 <= lookahead && lookahead <= 929) ||
    (931 <= lookahead && lookahead <= 1013) ||
    (1015 <= lookahead && lookahead <= 1153) ||
    (1162 <= lookahead && lookahead <= 1327) ||
    (1329 <= lookahead && lookahead <= 1366) ||
    lookahead == 1369 ||
    (1376 <= lookahead && lookahead <= 1416) ||
    (1488 <= lookahead && lookahead <= 1514) ||
    (1519 <= lookahead && lookahead <= 1522) ||
    (1568 <= lookahead && lookahead <= 1610) ||
    lookahead == 1646 ||
    lookahead == 1647 ||
    (1649 <= lookahead && lookahead <= 1747) ||
    lookahead == 1749 ||
    lookahead == 1765 ||
    lookahead == 1766 ||
    lookahead == 1774 ||
    lookahead == 1775 ||
    (1786 <= lookahead && lookahead <= 1788) ||
    lookahead == 1791 ||
    lookahead == 1808 ||
    (1810 <= lookahead && lookahead <= 1839) ||
    (1869 <= lookahead && lookahead <= 1957) ||
    lookahead == 1969 ||
    (1994 <= lookahead && lookahead <= 2026) ||
    lookahead == 2036 ||
    lookahead == 2037 ||
    lookahead == 2042 ||
    (2048 <= lookahead && lookahead <= 2069) ||
    lookahead == 2074 ||
    lookahead == 2084 ||
    lookahead == 2088 ||
    (2112 <= lookahead && lookahead <= 2136) ||
    (2144 <= lookahead && lookahead <= 2154) ||
    (2208 <= lookahead && lookahead <= 2228) ||
    (2230 <= lookahead && lookahead <= 2237) ||
    (2308 <= lookahead && lookahead <= 2361) ||
    lookahead == 2365 ||
    lookahead == 2384 ||
    (2392 <= lookahead && lookahead <= 2401) ||
    (2417 <= lookahead && lookahead <= 2432) ||
    (2437 <= lookahead && lookahead <= 2444) ||
    lookahead == 2447 ||
    lookahead == 2448 ||
    (2451 <= lookahead && lookahead <= 2472) ||
    (2474 <= lookahead && lookahead <= 2480) ||
    lookahead == 2482 ||
    (2486 <= lookahead && lookahead <= 2489) ||
    lookahead == 2493 ||
    lookahead == 2510 ||
    lookahead == 2524 ||
    lookahead == 2525 ||
    (2527 <= lookahead && lookahead <= 2529) ||
    lookahead == 2544 ||
    lookahead == 2545 ||
    lookahead == 2556 ||
    (2565 <= lookahead && lookahead <= 2570) ||
    lookahead == 2575 ||
    lookahead == 2576 ||
    (2579 <= lookahead && lookahead <= 2600) ||
    (2602 <= lookahead && lookahead <= 2608) ||
    lookahead == 2610 ||
    lookahead == 2611 ||
    lookahead == 2613 ||
    lookahead == 2614 ||
    lookahead == 2616 ||
    lookahead == 2617 ||
    (2649 <= lookahead && lookahead <= 2652) ||
    lookahead == 2654 ||
    (2674 <= lookahead && lookahead <= 2676) ||
    (2693 <= lookahead && lookahead <= 2701) ||
    (2703 <= lookahead && lookahead <= 2705) ||
    (2707 <= lookahead && lookahead <= 2728) ||
    (2730 <= lookahead && lookahead <= 2736) ||
    lookahead == 2738 ||
    lookahead == 2739 ||
    (2741 <= lookahead && lookahead <= 2745) ||
    lookahead == 2749 ||
    lookahead == 2768 ||
    lookahead == 2784 ||
    lookahead == 2785 ||
    lookahead == 2809 ||
    (2821 <= lookahead && lookahead <= 2828) ||
    lookahead == 2831 ||
    lookahead == 2832 ||
    (2835 <= lookahead && lookahead <= 2856) ||
    (2858 <= lookahead && lookahead <= 2864) ||
    lookahead == 2866 ||
    lookahead == 2867 ||
    (2869 <= lookahead && lookahead <= 2873) ||
    lookahead == 2877 ||
    lookahead == 2908 ||
    lookahead == 2909 ||
    (2911 <= lookahead && lookahead <= 2913) ||
    lookahead == 2929 ||
    lookahead == 2947 ||
    (2949 <= lookahead && lookahead <= 2954) ||
    (2958 <= lookahead && lookahead <= 2960) ||
    (2962 <= lookahead && lookahead <= 2965) ||
    lookahead == 2969 ||
    lookahead == 2970 ||
    lookahead == 2972 ||
    lookahead == 2974 ||
    lookahead == 2975 ||
    lookahead == 2979 ||
    lookahead == 2980 ||
    (2984 <= lookahead && lookahead <= 2986) ||
    (2990 <= lookahead && lookahead <= 3001) ||
    lookahead == 3024 ||
    (3077 <= lookahead && lookahead <= 3084) ||
    (3086 <= lookahead && lookahead <= 3088) ||
    (3090 <= lookahead && lookahead <= 3112) ||
    (3114 <= lookahead && lookahead <= 3129) ||
    lookahead == 3133 ||
    (3160 <= lookahead && lookahead <= 3162) ||
    lookahead == 3168 ||
    lookahead == 3169 ||
    lookahead == 3200 ||
    (3205 <= lookahead && lookahead <= 3212) ||
    (3214 <= lookahead && lookahead <= 3216) ||
    (3218 <= lookahead && lookahead <= 3240) ||
    (3242 <= lookahead && lookahead <= 3251) ||
    (3253 <= lookahead && lookahead <= 3257) ||
    lookahead == 3261 ||
    lookahead == 3294 ||
    lookahead == 3296 ||
    lookahead == 3297 ||
    lookahead == 3313 ||
    lookahead == 3314 ||
    (3333 <= lookahead && lookahead <= 3340) ||
    (3342 <= lookahead && lookahead <= 3344) ||
    (3346 <= lookahead && lookahead <= 3386) ||
    lookahead == 3389 ||
    lookahead == 3406 ||
    (3412 <= lookahead && lookahead <= 3414) ||
    (3423 <= lookahead && lookahead <= 3425) ||
    (3450 <= lookahead && lookahead <= 3455) ||
    (3461 <= lookahead && lookahead <= 3478) ||
    (3482 <= lookahead && lookahead <= 3505) ||
    (3507 <= lookahead && lookahead <= 3515) ||
    lookahead == 3517 ||
    (3520 <= lookahead && lookahead <= 3526) ||
    (3585 <= lookahead && lookahead <= 3632) ||
    lookahead == 3634 ||
    lookahead == 3635 ||
    (3648 <= lookahead && lookahead <= 3654) ||
    lookahead == 3713 ||
    lookahead == 3714 ||
    lookahead == 3716 ||
    (3718 <= lookahead && lookahead <= 3722) ||
    (3724 <= lookahead && lookahead <= 3747) ||
    lookahead == 3749 ||
    (3751 <= lookahead && lookahead <= 3760) ||
    lookahead == 3762 ||
    lookahead == 3763 ||
    lookahead == 3773 ||
    (3776 <= lookahead && lookahead <= 3780) ||
    lookahead == 3782 ||
    (3804 <= lookahead && lookahead <= 3807) ||
    lookahead == 3840 ||
    (3904 <= lookahead && lookahead <= 3911) ||
    (3913 <= lookahead && lookahead <= 3948) ||
    (3976 <= lookahead && lookahead <= 3980) ||
    (4096 <= lookahead && lookahead <= 4138) ||
    lookahead == 4159 ||
    (4176 <= lookahead && lookahead <= 4181) ||
    (4186 <= lookahead && lookahead <= 4189) ||
    lookahead == 4193 ||
    lookahead == 4197 ||
    lookahead == 4198 ||
    (4206 <= lookahead && lookahead <= 4208) ||
    (4213 <= lookahead && lookahead <= 4225) ||
    lookahead == 4238 ||
    (4256 <= lookahead && lookahead <= 4293) ||
    lookahead == 4295 ||
    lookahead == 4301 ||
    (4304 <= lookahead && lookahead <= 4346) ||
    (4348 <= lookahead && lookahead <= 4680) ||
    (4682 <= lookahead && lookahead <= 4685) ||
    (4688 <= lookahead && lookahead <= 4694) ||
    lookahead == 4696 ||
    (4698 <= lookahead && lookahead <= 4701) ||
    (4704 <= lookahead && lookahead <= 4744) ||
    (4746 <= lookahead && lookahead <= 4749) ||
    (4752 <= lookahead && lookahead <= 4784) ||
    (4786 <= lookahead && lookahead <= 4789) ||
    (4792 <= lookahead && lookahead <= 4798) ||
    lookahead == 4800 ||
    (4802 <= lookahead && lookahead <= 4805) ||
    (4808 <= lookahead && lookahead <= 4822) ||
    (4824 <= lookahead && lookahead <= 4880) ||
    (4882 <= lookahead && lookahead <= 4885) ||
    (4888 <= lookahead && lookahead <= 4954) ||
    (4992 <= lookahead && lookahead <= 5007) ||
    (5024 <= lookahead && lookahead <= 5109) ||
    (5112 <= lookahead && lookahead <= 5117) ||
    (5121 <= lookahead && lookahead <= 5740) ||
    (5743 <= lookahead && lookahead <= 5759) ||
    (5761 <= lookahead && lookahead <= 5786) ||
    (5792 <= lookahead && lookahead <= 5866) ||
    (5873 <= lookahead && lookahead <= 5880) ||
    (5888 <= lookahead && lookahead <= 5900) ||
    (5902 <= lookahead && lookahead <= 5905) ||
    (5920 <= lookahead && lookahead <= 5937) ||
    (5952 <= lookahead && lookahead <= 5969) ||
    (5984 <= lookahead && lookahead <= 5996) ||
    (5998 <= lookahead && lookahead <= 6000) ||
    (6016 <= lookahead && lookahead <= 6067) ||
    lookahead == 6103 ||
    lookahead == 6108 ||
    (6176 <= lookahead && lookahead <= 6264) ||
    (6272 <= lookahead && lookahead <= 6276) ||
    (6279 <= lookahead && lookahead <= 6312) ||
    lookahead == 6314 ||
    (6320 <= lookahead && lookahead <= 6389) ||
    (6400 <= lookahead && lookahead <= 6430) ||
    (6480 <= lookahead && lookahead <= 6509) ||
    (6512 <= lookahead && lookahead <= 6516) ||
    (6528 <= lookahead && lookahead <= 6571) ||
    (6576 <= lookahead && lookahead <= 6601) ||
    (6656 <= lookahead && lookahead <= 6678) ||
    (6688 <= lookahead && lookahead <= 6740) ||
    lookahead == 6823 ||
    (6917 <= lookahead && lookahead <= 6963) ||
    (6981 <= lookahead && lookahead <= 6987) ||
    (7043 <= lookahead && lookahead <= 7072) ||
    lookahead == 7086 ||
    lookahead == 7087 ||
    (7098 <= lookahead && lookahead <= 7141) ||
    (7168 <= lookahead && lookahead <= 7203) ||
    (7245 <= lookahead && lookahead <= 7247) ||
    (7258 <= lookahead && lookahead <= 7293) ||
    (7296 <= lookahead && lookahead <= 7304) ||
    (7312 <= lookahead && lookahead <= 7354) ||
    (7357 <= lookahead && lookahead <= 7359) ||
    (7401 <= lookahead && lookahead <= 7404) ||
    (7406 <= lookahead && lookahead <= 7411) ||
    lookahead == 7413 ||
    lookahead == 7414 ||
    lookahead == 7418 ||
    (7424 <= lookahead && lookahead <= 7615) ||
    (7680 <= lookahead && lookahead <= 7957) ||
    (7960 <= lookahead && lookahead <= 7965) ||
    (7968 <= lookahead && lookahead <= 8005) ||
    (8008 <= lookahead && lookahead <= 8013) ||
    (8016 <= lookahead && lookahead <= 8023) ||
    lookahead == 8025 ||
    lookahead == 8027 ||
    lookahead == 8029 ||
    (8031 <= lookahead && lookahead <= 8061) ||
    (8064 <= lookahead && lookahead <= 8116) ||
    (8118 <= lookahead && lookahead <= 8124) ||
    lookahead == 8126 ||
    (8130 <= lookahead && lookahead <= 8132) ||
    (8134 <= lookahead && lookahead <= 8140) ||
    (8144 <= lookahead && lookahead <= 8147) ||
    (8150 <= lookahead && lookahead <= 8155) ||
    (8160 <= lookahead && lookahead <= 8172) ||
    (8178 <= lookahead && lookahead <= 8180) ||
    (8182 <= lookahead && lookahead <= 8188) ||
    lookahead == 8305 ||
    lookahead == 8319 ||
    (8336 <= lookahead && lookahead <= 8348) ||
    lookahead == 8450 ||
    lookahead == 8455 ||
    (8458 <= lookahead && lookahead <= 8467) ||
    lookahead == 8469 ||
    (8473 <= lookahead && lookahead <= 8477) ||
    lookahead == 8484 ||
    lookahead == 8486 ||
    lookahead == 8488 ||
    (8490 <= lookahead && lookahead <= 8493) ||
    (8495 <= lookahead && lookahead <= 8505) ||
    (8508 <= lookahead && lookahead <= 8511) ||
    (8517 <= lookahead && lookahead <= 8521) ||
    lookahead == 8526 ||
    lookahead == 8579 ||
    lookahead == 8580 ||
    (11264 <= lookahead && lookahead <= 11310) ||
    (11312 <= lookahead && lookahead <= 11358) ||
    (11360 <= lookahead && lookahead <= 11492) ||
    (11499 <= lookahead && lookahead <= 11502) ||
    lookahead == 11506 ||
    lookahead == 11507 ||
    (11520 <= lookahead && lookahead <= 11557) ||
    lookahead == 11559 ||
    lookahead == 11565 ||
    (11568 <= lookahead && lookahead <= 11623) ||
    lookahead == 11631 ||
    (11648 <= lookahead && lookahead <= 11670) ||
    (11680 <= lookahead && lookahead <= 11686) ||
    (11688 <= lookahead && lookahead <= 11694) ||
    (11696 <= lookahead && lookahead <= 11702) ||
    (11704 <= lookahead && lookahead <= 11710) ||
    (11712 <= lookahead && lookahead <= 11718) ||
    (11720 <= lookahead && lookahead <= 11726) ||
    (11728 <= lookahead && lookahead <= 11734) ||
    (11736 <= lookahead && lookahead <= 11742) ||
    lookahead == 11823 ||
    lookahead == 12293 ||
    lookahead == 12294 ||
    (12337 <= lookahead && lookahead <= 12341) ||
    lookahead == 12347 ||
    lookahead == 12348 ||
    (12353 <= lookahead && lookahead <= 12438) ||
    (12445 <= lookahead && lookahead <= 12447) ||
    (12449 <= lookahead && lookahead <= 12538) ||
    (12540 <= lookahead && lookahead <= 12543) ||
    (12549 <= lookahead && lookahead <= 12591) ||
    (12593 <= lookahead && lookahead <= 12686) ||
    (12704 <= lookahead && lookahead <= 12730) ||
    (12784 <= lookahead && lookahead <= 12799) ||
    (13312 <= lookahead && lookahead <= 19893) ||
    (19968 <= lookahead && lookahead <= 40943) ||
    (40960 <= lookahead && lookahead <= 42124) ||
    (42192 <= lookahead && lookahead <= 42237) ||
    (42240 <= lookahead && lookahead <= 42508) ||
    (42512 <= lookahead && lookahead <= 42527) ||
    lookahead == 42538 ||
    lookahead == 42539 ||
    (42560 <= lookahead && lookahead <= 42606) ||
    (42623 <= lookahead && lookahead <= 42653) ||
    (42656 <= lookahead && lookahead <= 42725) ||
    (42775 <= lookahead && lookahead <= 42783) ||
    (42786 <= lookahead && lookahead <= 42888) ||
    (42891 <= lookahead && lookahead <= 42943) ||
    (42946 <= lookahead && lookahead <= 42950) ||
    (42999 <= lookahead && lookahead <= 43009) ||
    (43011 <= lookahead && lookahead <= 43013) ||
    (43015 <= lookahead && lookahead <= 43018) ||
    (43020 <= lookahead && lookahead <= 43042) ||
    (43072 <= lookahead && lookahead <= 43123) ||
    (43138 <= lookahead && lookahead <= 43187) ||
    (43250 <= lookahead && lookahead <= 43255) ||
    lookahead == 43259 ||
    lookahead == 43261 ||
    lookahead == 43262 ||
    (43274 <= lookahead && lookahead <= 43301) ||
    (43312 <= lookahead && lookahead <= 43334) ||
    (43360 <= lookahead && lookahead <= 43388) ||
    (43396 <= lookahead && lookahead <= 43442) ||
    lookahead == 43471 ||
    (43488 <= lookahead && lookahead <= 43492) ||
    (43494 <= lookahead && lookahead <= 43503) ||
    (43514 <= lookahead && lookahead <= 43518) ||
    (43520 <= lookahead && lookahead <= 43560) ||
    (43584 <= lookahead && lookahead <= 43586) ||
    (43588 <= lookahead && lookahead <= 43595) ||
    (43616 <= lookahead && lookahead <= 43638) ||
    lookahead == 43642 ||
    (43646 <= lookahead && lookahead <= 43695) ||
    lookahead == 43697 ||
    lookahead == 43701 ||
    lookahead == 43702 ||
    (43705 <= lookahead && lookahead <= 43709) ||
    lookahead == 43712 ||
    lookahead == 43714 ||
    (43739 <= lookahead && lookahead <= 43741) ||
    (43744 <= lookahead && lookahead <= 43754) ||
    (43762 <= lookahead && lookahead <= 43764) ||
    (43777 <= lookahead && lookahead <= 43782) ||
    (43785 <= lookahead && lookahead <= 43790) ||
    (43793 <= lookahead && lookahead <= 43798) ||
    (43808 <= lookahead && lookahead <= 43814) ||
    (43816 <= lookahead && lookahead <= 43822) ||
    (43824 <= lookahead && lookahead <= 43866) ||
    (43868 <= lookahead && lookahead <= 43879) ||
    (43888 <= lookahead && lookahead <= 44002) ||
    (44032 <= lookahead && lookahead <= 55203) ||
    (55216 <= lookahead && lookahead <= 55238) ||
    (55243 <= lookahead && lookahead <= 55291) ||
    (63744 <= lookahead && lookahead <= 64109) ||
    (64112 <= lookahead && lookahead <= 64217) ||
    (64256 <= lookahead && lookahead <= 64262) ||
    (64275 <= lookahead && lookahead <= 64279) ||
    lookahead == 64285 ||
    (64287 <= lookahead && lookahead <= 64296) ||
    (64298 <= lookahead && lookahead <= 64310) ||
    (64312 <= lookahead && lookahead <= 64316) ||
    lookahead == 64318 ||
    lookahead == 64320 ||
    lookahead == 64321 ||
    lookahead == 64323 ||
    lookahead == 64324 ||
    (64326 <= lookahead && lookahead <= 64433) ||
    (64467 <= lookahead && lookahead <= 64829) ||
    (64848 <= lookahead && lookahead <= 64911) ||
    (64914 <= lookahead && lookahead <= 64967) ||
    (65008 <= lookahead && lookahead <= 65019) ||
    (65136 <= lookahead && lookahead <= 65140) ||
    (65142 <= lookahead && lookahead <= 65276) ||
    (65313 <= lookahead && lookahead <= 65338) ||
    (65345 <= lookahead && lookahead <= 65370) ||
    (65382 <= lookahead && lookahead <= 65470) ||
    (65474 <= lookahead && lookahead <= 65479) ||
    (65482 <= lookahead && lookahead <= 65487) ||
    (65490 <= lookahead && lookahead <= 65495) ||
    (65498 <= lookahead && lookahead <= 65500) ||
    (65536 <= lookahead && lookahead <= 65547) ||
    (65549 <= lookahead && lookahead <= 65574) ||
    (65576 <= lookahead && lookahead <= 65594) ||
    lookahead == 65596 ||
    lookahead == 65597 ||
    (65599 <= lookahead && lookahead <= 65613) ||
    (65616 <= lookahead && lookahead <= 65629) ||
    (65664 <= lookahead && lookahead <= 65786) ||
    (66176 <= lookahead && lookahead <= 66204) ||
    (66208 <= lookahead && lookahead <= 66256) ||
    (66304 <= lookahead && lookahead <= 66335) ||
    (66349 <= lookahead && lookahead <= 66368) ||
    (66370 <= lookahead && lookahead <= 66377) ||
    (66384 <= lookahead && lookahead <= 66421) ||
    (66432 <= lookahead && lookahead <= 66461) ||
    (66464 <= lookahead && lookahead <= 66499) ||
    (66504 <= lookahead && lookahead <= 66511) ||
    (66560 <= lookahead && lookahead <= 66717) ||
    (66736 <= lookahead && lookahead <= 66771) ||
    (66776 <= lookahead && lookahead <= 66811) ||
    (66816 <= lookahead && lookahead <= 66855) ||
    (66864 <= lookahead && lookahead <= 66915) ||
    (67072 <= lookahead && lookahead <= 67382) ||
    (67392 <= lookahead && lookahead <= 67413) ||
    (67424 <= lookahead && lookahead <= 67431) ||
    (67584 <= lookahead && lookahead <= 67589) ||
    lookahead == 67592 ||
    (67594 <= lookahead && lookahead <= 67637) ||
    lookahead == 67639 ||
    lookahead == 67640 ||
    lookahead == 67644 ||
    (67647 <= lookahead && lookahead <= 67669) ||
    (67680 <= lookahead && lookahead <= 67702) ||
    (67712 <= lookahead && lookahead <= 67742) ||
    (67808 <= lookahead && lookahead <= 67826) ||
    lookahead == 67828 ||
    lookahead == 67829 ||
    (67840 <= lookahead && lookahead <= 67861) ||
    (67872 <= lookahead && lookahead <= 67897) ||
    (67968 <= lookahead && lookahead <= 68023) ||
    lookahead == 68030 ||
    lookahead == 68031 ||
    lookahead == 68096 ||
    (68112 <= lookahead && lookahead <= 68115) ||
    (68117 <= lookahead && lookahead <= 68119) ||
    (68121 <= lookahead && lookahead <= 68149) ||
    (68192 <= lookahead && lookahead <= 68220) ||
    (68224 <= lookahead && lookahead <= 68252) ||
    (68288 <= lookahead && lookahead <= 68295) ||
    (68297 <= lookahead && lookahead <= 68324) ||
    (68352 <= lookahead && lookahead <= 68405) ||
    (68416 <= lookahead && lookahead <= 68437) ||
    (68448 <= lookahead && lookahead <= 68466) ||
    (68480 <= lookahead && lookahead <= 68497) ||
    (68608 <= lookahead && lookahead <= 68680) ||
    (68736 <= lookahead && lookahead <= 68786) ||
    (68800 <= lookahead && lookahead <= 68850) ||
    (68864 <= lookahead && lookahead <= 68899) ||
    (69376 <= lookahead && lookahead <= 69404) ||
    lookahead == 69415 ||
    (69424 <= lookahead && lookahead <= 69445) ||
    (69600 <= lookahead && lookahead <= 69622) ||
    (69635 <= lookahead && lookahead <= 69687) ||
    (69763 <= lookahead && lookahead <= 69807) ||
    (69840 <= lookahead && lookahead <= 69864) ||
    (69891 <= lookahead && lookahead <= 69926) ||
    lookahead == 69956 ||
    (69968 <= lookahead && lookahead <= 70002) ||
    lookahead == 70006 ||
    (70019 <= lookahead && lookahead <= 70066) ||
    (70081 <= lookahead && lookahead <= 70084) ||
    lookahead == 70106 ||
    lookahead == 70108 ||
    (70144 <= lookahead && lookahead <= 70161) ||
    (70163 <= lookahead && lookahead <= 70187) ||
    (70272 <= lookahead && lookahead <= 70278) ||
    lookahead == 70280 ||
    (70282 <= lookahead && lookahead <= 70285) ||
    (70287 <= lookahead && lookahead <= 70301) ||
    (70303 <= lookahead && lookahead <= 70312) ||
    (70320 <= lookahead && lookahead <= 70366) ||
    (70405 <= lookahead && lookahead <= 70412) ||
    lookahead == 70415 ||
    lookahead == 70416 ||
    (70419 <= lookahead && lookahead <= 70440) ||
    (70442 <= lookahead && lookahead <= 70448) ||
    lookahead == 70450 ||
    lookahead == 70451 ||
    (70453 <= lookahead && lookahead <= 70457) ||
    lookahead == 70461 ||
    lookahead == 70480 ||
    (70493 <= lookahead && lookahead <= 70497) ||
    (70656 <= lookahead && lookahead <= 70708) ||
    (70727 <= lookahead && lookahead <= 70730) ||
    lookahead == 70751 ||
    (70784 <= lookahead && lookahead <= 70831) ||
    lookahead == 70852 ||
    lookahead == 70853 ||
    lookahead == 70855 ||
    (71040 <= lookahead && lookahead <= 71086) ||
    (71128 <= lookahead && lookahead <= 71131) ||
    (71168 <= lookahead && lookahead <= 71215) ||
    lookahead == 71236 ||
    (71296 <= lookahead && lookahead <= 71338) ||
    lookahead == 71352 ||
    (71424 <= lookahead && lookahead <= 71450) ||
    (71680 <= lookahead && lookahead <= 71723) ||
    (71840 <= lookahead && lookahead <= 71903) ||
    lookahead == 71935 ||
    (72096 <= lookahead && lookahead <= 72103) ||
    (72106 <= lookahead && lookahead <= 72144) ||
    lookahead == 72161 ||
    lookahead == 72163 ||
    lookahead == 72192 ||
    (72203 <= lookahead && lookahead <= 72242) ||
    lookahead == 72250 ||
    lookahead == 72272 ||
    (72284 <= lookahead && lookahead <= 72329) ||
    lookahead == 72349 ||
    (72384 <= lookahead && lookahead <= 72440) ||
    (72704 <= lookahead && lookahead <= 72712) ||
    (72714 <= lookahead && lookahead <= 72750) ||
    lookahead == 72768 ||
    (72818 <= lookahead && lookahead <= 72847) ||
    (72960 <= lookahead && lookahead <= 72966) ||
    lookahead == 72968 ||
    lookahead == 72969 ||
    (72971 <= lookahead && lookahead <= 73008) ||
    lookahead == 73030 ||
    (73056 <= lookahead && lookahead <= 73061) ||
    lookahead == 73063 ||
    lookahead == 73064 ||
    (73066 <= lookahead && lookahead <= 73097) ||
    lookahead == 73112 ||
    (73440 <= lookahead && lookahead <= 73458) ||
    (73728 <= lookahead && lookahead <= 74649) ||
    (74880 <= lookahead && lookahead <= 75075) ||
    (77824 <= lookahead && lookahead <= 78894) ||
    (82944 <= lookahead && lookahead <= 83526) ||
    (92160 <= lookahead && lookahead <= 92728) ||
    (92736 <= lookahead && lookahead <= 92766) ||
    (92880 <= lookahead && lookahead <= 92909) ||
    (92928 <= lookahead && lookahead <= 92975) ||
    (92992 <= lookahead && lookahead <= 92995) ||
    (93027 <= lookahead && lookahead <= 93047) ||
    (93053 <= lookahead && lookahead <= 93071) ||
    (93760 <= lookahead && lookahead <= 93823) ||
    (93952 <= lookahead && lookahead <= 94026) ||
    lookahead == 94032 ||
    (94099 <= lookahead && lookahead <= 94111) ||
    lookahead == 94176 ||
    lookahead == 94177 ||
    lookahead == 94179 ||
    (94208 <= lookahead && lookahead <= 100343) ||
    (100352 <= lookahead && lookahead <= 101106) ||
    (110592 <= lookahead && lookahead <= 110878) ||
    (110928 <= lookahead && lookahead <= 110930) ||
    (110948 <= lookahead && lookahead <= 110951) ||
    (110960 <= lookahead && lookahead <= 111355) ||
    (113664 <= lookahead && lookahead <= 113770) ||
    (113776 <= lookahead && lookahead <= 113788) ||
    (113792 <= lookahead && lookahead <= 113800) ||
    (113808 <= lookahead && lookahead <= 113817) ||
    (119808 <= lookahead && lookahead <= 119892) ||
    (119894 <= lookahead && lookahead <= 119964) ||
    lookahead == 119966 ||
    lookahead == 119967 ||
    lookahead == 119970 ||
    lookahead == 119973 ||
    lookahead == 119974 ||
    (119977 <= lookahead && lookahead <= 119980) ||
    (119982 <= lookahead && lookahead <= 119993) ||
    lookahead == 119995 ||
    (119997 <= lookahead && lookahead <= 120003) ||
    (120005 <= lookahead && lookahead <= 120069) ||
    (120071 <= lookahead && lookahead <= 120074) ||
    (120077 <= lookahead && lookahead <= 120084) ||
    (120086 <= lookahead && lookahead <= 120092) ||
    (120094 <= lookahead && lookahead <= 120121) ||
    (120123 <= lookahead && lookahead <= 120126) ||
    (120128 <= lookahead && lookahead <= 120132) ||
    lookahead == 120134 ||
    (120138 <= lookahead && lookahead <= 120144) ||
    (120146 <= lookahead && lookahead <= 120485) ||
    (120488 <= lookahead && lookahead <= 120512) ||
    (120514 <= lookahead && lookahead <= 120538) ||
    (120540 <= lookahead && lookahead <= 120570) ||
    (120572 <= lookahead && lookahead <= 120596) ||
    (120598 <= lookahead && lookahead <= 120628) ||
    (120630 <= lookahead && lookahead <= 120654) ||
    (120656 <= lookahead && lookahead <= 120686) ||
    (120688 <= lookahead && lookahead <= 120712) ||
    (120714 <= lookahead && lookahead <= 120744) ||
    (120746 <= lookahead && lookahead <= 120770) ||
    (120772 <= lookahead && lookahead <= 120779) ||
    (123136 <= lookahead && lookahead <= 123180) ||
    (123191 <= lookahead && lookahead <= 123197) ||
    lookahead == 123214 ||
    (123584 <= lookahead && lookahead <= 123627) ||
    (124928 <= lookahead && lookahead <= 125124) ||
    (125184 <= lookahead && lookahead <= 125251) ||
    lookahead == 125259 ||
    (126464 <= lookahead && lookahead <= 126467) ||
    (126469 <= lookahead && lookahead <= 126495) ||
    lookahead == 126497 ||
    lookahead == 126498 ||
    lookahead == 126500 ||
    lookahead == 126503 ||
    (126505 <= lookahead && lookahead <= 126514) ||
    (126516 <= lookahead && lookahead <= 126519) ||
    lookahead == 126521 ||
    lookahead == 126523 ||
    lookahead == 126530 ||
    lookahead == 126535 ||
    lookahead == 126537 ||
    lookahead == 126539 ||
    (126541 <= lookahead && lookahead <= 126543) ||
    lookahead == 126545 ||
    lookahead == 126546 ||
    lookahead == 126548 ||
    lookahead == 126551 ||
    lookahead == 126553 ||
    lookahead == 126555 ||
    lookahead == 126557 ||
    lookahead == 126559 ||
    lookahead == 126561 ||
    lookahead == 126562 ||
    lookahead == 126564 ||
    (126567 <= lookahead && lookahead <= 126570) ||
    (126572 <= lookahead && lookahead <= 126578) ||
    (126580 <= lookahead && lookahead <= 126583) ||
    (126585 <= lookahead && lookahead <= 126588) ||
    lookahead == 126590 ||
    (126592 <= lookahead && lookahead <= 126601) ||
    (126603 <= lookahead && lookahead <= 126619) ||
    (126625 <= lookahead && lookahead <= 126627) ||
    (126629 <= lookahead && lookahead <= 126633) ||
    (126635 <= lookahead && lookahead <= 126651) ||
    (131072 <= lookahead && lookahead <= 173782) ||
    (173824 <= lookahead && lookahead <= 177972) ||
    (177984 <= lookahead && lookahead <= 178205) ||
    (178208 <= lookahead && lookahead <= 183969) ||
    (183984 <= lookahead && lookahead <= 191456) ||
    (194560 <= lookahead && lookahead <= 195101);
}

static inline bool sym_lower_case_identifier_character_set_1(int32_t lookahead) {
  return
    ('a' <= lookahead && lookahead <= 'z') ||
    lookahead == 181 ||
    (223 <= lookahead && lookahead <= 246) ||
    (248 <= lookahead && lookahead <= 255) ||
    lookahead == 257 ||
    lookahead == 259 ||
    lookahead == 261 ||
    lookahead == 263 ||
    lookahead == 265 ||
    lookahead == 267 ||
    lookahead == 269 ||
    lookahead == 271 ||
    lookahead == 273 ||
    lookahead == 275 ||
    lookahead == 277 ||
    lookahead == 279 ||
    lookahead == 281 ||
    lookahead == 283 ||
    lookahead == 285 ||
    lookahead == 287 ||
    lookahead == 289 ||
    lookahead == 291 ||
    lookahead == 293 ||
    lookahead == 295 ||
    lookahead == 297 ||
    lookahead == 299 ||
    lookahead == 301 ||
    lookahead == 303 ||
    lookahead == 305 ||
    lookahead == 307 ||
    lookahead == 309 ||
    lookahead == 311 ||
    lookahead == 312 ||
    lookahead == 314 ||
    lookahead == 316 ||
    lookahead == 318 ||
    lookahead == 320 ||
    lookahead == 322 ||
    lookahead == 324 ||
    lookahead == 326 ||
    lookahead == 328 ||
    lookahead == 329 ||
    lookahead == 331 ||
    lookahead == 333 ||
    lookahead == 335 ||
    lookahead == 337 ||
    lookahead == 339 ||
    lookahead == 341 ||
    lookahead == 343 ||
    lookahead == 345 ||
    lookahead == 347 ||
    lookahead == 349 ||
    lookahead == 351 ||
    lookahead == 353 ||
    lookahead == 355 ||
    lookahead == 357 ||
    lookahead == 359 ||
    lookahead == 361 ||
    lookahead == 363 ||
    lookahead == 365 ||
    lookahead == 367 ||
    lookahead == 369 ||
    lookahead == 371 ||
    lookahead == 373 ||
    lookahead == 375 ||
    lookahead == 378 ||
    lookahead == 380 ||
    (382 <= lookahead && lookahead <= 384) ||
    lookahead == 387 ||
    lookahead == 389 ||
    lookahead == 392 ||
    lookahead == 396 ||
    lookahead == 397 ||
    lookahead == 402 ||
    lookahead == 405 ||
    (409 <= lookahead && lookahead <= 411) ||
    lookahead == 414 ||
    lookahead == 417 ||
    lookahead == 419 ||
    lookahead == 421 ||
    lookahead == 424 ||
    lookahead == 426 ||
    lookahead == 427 ||
    lookahead == 429 ||
    lookahead == 432 ||
    lookahead == 436 ||
    lookahead == 438 ||
    lookahead == 441 ||
    lookahead == 442 ||
    (445 <= lookahead && lookahead <= 447) ||
    lookahead == 454 ||
    lookahead == 457 ||
    lookahead == 460 ||
    lookahead == 462 ||
    lookahead == 464 ||
    lookahead == 466 ||
    lookahead == 468 ||
    lookahead == 470 ||
    lookahead == 472 ||
    lookahead == 474 ||
    lookahead == 476 ||
    lookahead == 477 ||
    lookahead == 479 ||
    lookahead == 481 ||
    lookahead == 483 ||
    lookahead == 485 ||
    lookahead == 487 ||
    lookahead == 489 ||
    lookahead == 491 ||
    lookahead == 493 ||
    lookahead == 495 ||
    lookahead == 496 ||
    lookahead == 499 ||
    lookahead == 501 ||
    lookahead == 505 ||
    lookahead == 507 ||
    lookahead == 509 ||
    lookahead == 511 ||
    lookahead == 513 ||
    lookahead == 515 ||
    lookahead == 517 ||
    lookahead == 519 ||
    lookahead == 521 ||
    lookahead == 523 ||
    lookahead == 525 ||
    lookahead == 527 ||
    lookahead == 529 ||
    lookahead == 531 ||
    lookahead == 533 ||
    lookahead == 535 ||
    lookahead == 537 ||
    lookahead == 539 ||
    lookahead == 541 ||
    lookahead == 543 ||
    lookahead == 545 ||
    lookahead == 547 ||
    lookahead == 549 ||
    lookahead == 551 ||
    lookahead == 553 ||
    lookahead == 555 ||
    lookahead == 557 ||
    lookahead == 559 ||
    lookahead == 561 ||
    (563 <= lookahead && lookahead <= 569) ||
    lookahead == 572 ||
    lookahead == 575 ||
    lookahead == 576 ||
    lookahead == 578 ||
    lookahead == 583 ||
    lookahead == 585 ||
    lookahead == 587 ||
    lookahead == 589 ||
    (591 <= lookahead && lookahead <= 659) ||
    (661 <= lookahead && lookahead <= 687) ||
    lookahead == 881 ||
    lookahead == 883 ||
    lookahead == 887 ||
    (891 <= lookahead && lookahead <= 893) ||
    lookahead == 912 ||
    (940 <= lookahead && lookahead <= 974) ||
    lookahead == 976 ||
    lookahead == 977 ||
    (981 <= lookahead && lookahead <= 983) ||
    lookahead == 985 ||
    lookahead == 987 ||
    lookahead == 989 ||
    lookahead == 991 ||
    lookahead == 993 ||
    lookahead == 995 ||
    lookahead == 997 ||
    lookahead == 999 ||
    lookahead == 1001 ||
    lookahead == 1003 ||
    lookahead == 1005 ||
    (1007 <= lookahead && lookahead <= 1011) ||
    lookahead == 1013 ||
    lookahead == 1016 ||
    lookahead == 1019 ||
    lookahead == 1020 ||
    (1072 <= lookahead && lookahead <= 1119) ||
    lookahead == 1121 ||
    lookahead == 1123 ||
    lookahead == 1125 ||
    lookahead == 1127 ||
    lookahead == 1129 ||
    lookahead == 1131 ||
    lookahead == 1133 ||
    lookahead == 1135 ||
    lookahead == 1137 ||
    lookahead == 1139 ||
    lookahead == 1141 ||
    lookahead == 1143 ||
    lookahead == 1145 ||
    lookahead == 1147 ||
    lookahead == 1149 ||
    lookahead == 1151 ||
    lookahead == 1153 ||
    lookahead == 1163 ||
    lookahead == 1165 ||
    lookahead == 1167 ||
    lookahead == 1169 ||
    lookahead == 1171 ||
    lookahead == 1173 ||
    lookahead == 1175 ||
    lookahead == 1177 ||
    lookahead == 1179 ||
    lookahead == 1181 ||
    lookahead == 1183 ||
    lookahead == 1185 ||
    lookahead == 1187 ||
    lookahead == 1189 ||
    lookahead == 1191 ||
    lookahead == 1193 ||
    lookahead == 1195 ||
    lookahead == 1197 ||
    lookahead == 1199 ||
    lookahead == 1201 ||
    lookahead == 1203 ||
    lookahead == 1205 ||
    lookahead == 1207 ||
    lookahead == 1209 ||
    lookahead == 1211 ||
    lookahead == 1213 ||
    lookahead == 1215 ||
    lookahead == 1218 ||
    lookahead == 1220 ||
    lookahead == 1222 ||
    lookahead == 1224 ||
    lookahead == 1226 ||
    lookahead == 1228 ||
    lookahead == 1230 ||
    lookahead == 1231 ||
    lookahead == 1233 ||
    lookahead == 1235 ||
    lookahead == 1237 ||
    lookahead == 1239 ||
    lookahead == 1241 ||
    lookahead == 1243 ||
    lookahead == 1245 ||
    lookahead == 1247 ||
    lookahead == 1249 ||
    lookahead == 1251 ||
    lookahead == 1253 ||
    lookahead == 1255 ||
    lookahead == 1257 ||
    lookahead == 1259 ||
    lookahead == 1261 ||
    lookahead == 1263 ||
    lookahead == 1265 ||
    lookahead == 1267 ||
    lookahead == 1269 ||
    lookahead == 1271 ||
    lookahead == 1273 ||
    lookahead == 1275 ||
    lookahead == 1277 ||
    lookahead == 1279 ||
    lookahead == 1281 ||
    lookahead == 1283 ||
    lookahead == 1285 ||
    lookahead == 1287 ||
    lookahead == 1289 ||
    lookahead == 1291 ||
    lookahead == 1293 ||
    lookahead == 1295 ||
    lookahead == 1297 ||
    lookahead == 1299 ||
    lookahead == 1301 ||
    lookahead == 1303 ||
    lookahead == 1305 ||
    lookahead == 1307 ||
    lookahead == 1309 ||
    lookahead == 1311 ||
    lookahead == 1313 ||
    lookahead == 1315 ||
    lookahead == 1317 ||
    lookahead == 1319 ||
    lookahead == 1321 ||
    lookahead == 1323 ||
    lookahead == 1325 ||
    lookahead == 1327 ||
    (1376 <= lookahead && lookahead <= 1416) ||
    (4304 <= lookahead && lookahead <= 4346) ||
    (4349 <= lookahead && lookahead <= 4351) ||
    (5112 <= lookahead && lookahead <= 5117) ||
    (7296 <= lookahead && lookahead <= 7304) ||
    (7424 <= lookahead && lookahead <= 7467) ||
    (7531 <= lookahead && lookahead <= 7543) ||
    (7545 <= lookahead && lookahead <= 7578) ||
    lookahead == 7681 ||
    lookahead == 7683 ||
    lookahead == 7685 ||
    lookahead == 7687 ||
    lookahead == 7689 ||
    lookahead == 7691 ||
    lookahead == 7693 ||
    lookahead == 7695 ||
    lookahead == 7697 ||
    lookahead == 7699 ||
    lookahead == 7701 ||
    lookahead == 7703 ||
    lookahead == 7705 ||
    lookahead == 7707 ||
    lookahead == 7709 ||
    lookahead == 7711 ||
    lookahead == 7713 ||
    lookahead == 7715 ||
    lookahead == 7717 ||
    lookahead == 7719 ||
    lookahead == 7721 ||
    lookahead == 7723 ||
    lookahead == 7725 ||
    lookahead == 7727 ||
    lookahead == 7729 ||
    lookahead == 7731 ||
    lookahead == 7733 ||
    lookahead == 7735 ||
    lookahead == 7737 ||
    lookahead == 7739 ||
    lookahead == 7741 ||
    lookahead == 7743 ||
    lookahead == 7745 ||
    lookahead == 7747 ||
    lookahead == 7749 ||
    lookahead == 7751 ||
    lookahead == 7753 ||
    lookahead == 7755 ||
    lookahead == 7757 ||
    lookahead == 7759 ||
    lookahead == 7761 ||
    lookahead == 7763 ||
    lookahead == 7765 ||
    lookahead == 7767 ||
    lookahead == 7769 ||
    lookahead == 7771 ||
    lookahead == 7773 ||
    lookahead == 7775 ||
    lookahead == 7777 ||
    lookahead == 7779 ||
    lookahead == 7781 ||
    lookahead == 7783 ||
    lookahead == 7785 ||
    lookahead == 7787 ||
    lookahead == 7789 ||
    lookahead == 7791 ||
    lookahead == 7793 ||
    lookahead == 7795 ||
    lookahead == 7797 ||
    lookahead == 7799 ||
    lookahead == 7801 ||
    lookahead == 7803 ||
    lookahead == 7805 ||
    lookahead == 7807 ||
    lookahead == 7809 ||
    lookahead == 7811 ||
    lookahead == 7813 ||
    lookahead == 7815 ||
    lookahead == 7817 ||
    lookahead == 7819 ||
    lookahead == 7821 ||
    lookahead == 7823 ||
    lookahead == 7825 ||
    lookahead == 7827 ||
    (7829 <= lookahead && lookahead <= 7837) ||
    lookahead == 7839 ||
    lookahead == 7841 ||
    lookahead == 7843 ||
    lookahead == 7845 ||
    lookahead == 7847 ||
    lookahead == 7849 ||
    lookahead == 7851 ||
    lookahead == 7853 ||
    lookahead == 7855 ||
    lookahead == 7857 ||
    lookahead == 7859 ||
    lookahead == 7861 ||
    lookahead == 7863 ||
    lookahead == 7865 ||
    lookahead == 7867 ||
    lookahead == 7869 ||
    lookahead == 7871 ||
    lookahead == 7873 ||
    lookahead == 7875 ||
    lookahead == 7877 ||
    lookahead == 7879 ||
    lookahead == 7881 ||
    lookahead == 7883 ||
    lookahead == 7885 ||
    lookahead == 7887 ||
    lookahead == 7889 ||
    lookahead == 7891 ||
    lookahead == 7893 ||
    lookahead == 7895 ||
    lookahead == 7897 ||
    lookahead == 7899 ||
    lookahead == 7901 ||
    lookahead == 7903 ||
    lookahead == 7905 ||
    lookahead == 7907 ||
    lookahead == 7909 ||
    lookahead == 7911 ||
    lookahead == 7913 ||
    lookahead == 7915 ||
    lookahead == 7917 ||
    lookahead == 7919 ||
    lookahead == 7921 ||
    lookahead == 7923 ||
    lookahead == 7925 ||
    lookahead == 7927 ||
    lookahead == 7929 ||
    lookahead == 7931 ||
    lookahead == 7933 ||
    (7935 <= lookahead && lookahead <= 7943) ||
    (7952 <= lookahead && lookahead <= 7957) ||
    (7968 <= lookahead && lookahead <= 7975) ||
    (7984 <= lookahead && lookahead <= 7991) ||
    (8000 <= lookahead && lookahead <= 8005) ||
    (8016 <= lookahead && lookahead <= 8023) ||
    (8032 <= lookahead && lookahead <= 8039) ||
    (8048 <= lookahead && lookahead <= 8061) ||
    (8064 <= lookahead && lookahead <= 8071) ||
    (8080 <= lookahead && lookahead <= 8087) ||
    (8096 <= lookahead && lookahead <= 8103) ||
    (8112 <= lookahead && lookahead <= 8116) ||
    lookahead == 8118 ||
    lookahead == 8119 ||
    lookahead == 8126 ||
    (8130 <= lookahead && lookahead <= 8132) ||
    lookahead == 8134 ||
    lookahead == 8135 ||
    (8144 <= lookahead && lookahead <= 8147) ||
    lookahead == 8150 ||
    lookahead == 8151 ||
    (8160 <= lookahead && lookahead <= 8167) ||
    (8178 <= lookahead && lookahead <= 8180) ||
    lookahead == 8182 ||
    lookahead == 8183 ||
    lookahead == 8458 ||
    lookahead == 8462 ||
    lookahead == 8463 ||
    lookahead == 8467 ||
    lookahead == 8495 ||
    lookahead == 8500 ||
    lookahead == 8505 ||
    lookahead == 8508 ||
    lookahead == 8509 ||
    (8518 <= lookahead && lookahead <= 8521) ||
    lookahead == 8526 ||
    lookahead == 8580 ||
    (11312 <= lookahead && lookahead <= 11358) ||
    lookahead == 11361 ||
    lookahead == 11365 ||
    lookahead == 11366 ||
    lookahead == 11368 ||
    lookahead == 11370 ||
    lookahead == 11372 ||
    lookahead == 11377 ||
    lookahead == 11379 ||
    lookahead == 11380 ||
    (11382 <= lookahead && lookahead <= 11387) ||
    lookahead == 11393 ||
    lookahead == 11395 ||
    lookahead == 11397 ||
    lookahead == 11399 ||
    lookahead == 11401 ||
    lookahead == 11403 ||
    lookahead == 11405 ||
    lookahead == 11407 ||
    lookahead == 11409 ||
    lookahead == 11411 ||
    lookahead == 11413 ||
    lookahead == 11415 ||
    lookahead == 11417 ||
    lookahead == 11419 ||
    lookahead == 11421 ||
    lookahead == 11423 ||
    lookahead == 11425 ||
    lookahead == 11427 ||
    lookahead == 11429 ||
    lookahead == 11431 ||
    lookahead == 11433 ||
    lookahead == 11435 ||
    lookahead == 11437 ||
    lookahead == 11439 ||
    lookahead == 11441 ||
    lookahead == 11443 ||
    lookahead == 11445 ||
    lookahead == 11447 ||
    lookahead == 11449 ||
    lookahead == 11451 ||
    lookahead == 11453 ||
    lookahead == 11455 ||
    lookahead == 11457 ||
    lookahead == 11459 ||
    lookahead == 11461 ||
    lookahead == 11463 ||
    lookahead == 11465 ||
    lookahead == 11467 ||
    lookahead == 11469 ||
    lookahead == 11471 ||
    lookahead == 11473 ||
    lookahead == 11475 ||
    lookahead == 11477 ||
    lookahead == 11479 ||
    lookahead == 11481 ||
    lookahead == 11483 ||
    lookahead == 11485 ||
    lookahead == 11487 ||
    lookahead == 11489 ||
    lookahead == 11491 ||
    lookahead == 11492 ||
    lookahead == 11500 ||
    lookahead == 11502 ||
    lookahead == 11507 ||
    (11520 <= lookahead && lookahead <= 11557) ||
    lookahead == 11559 ||
    lookahead == 11565 ||
    lookahead == 42561 ||
    lookahead == 42563 ||
    lookahead == 42565 ||
    lookahead == 42567 ||
    lookahead == 42569 ||
    lookahead == 42571 ||
    lookahead == 42573 ||
    lookahead == 42575 ||
    lookahead == 42577 ||
    lookahead == 42579 ||
    lookahead == 42581 ||
    lookahead == 42583 ||
    lookahead == 42585 ||
    lookahead == 42587 ||
    lookahead == 42589 ||
    lookahead == 42591 ||
    lookahead == 42593 ||
    lookahead == 42595 ||
    lookahead == 42597 ||
    lookahead == 42599 ||
    lookahead == 42601 ||
    lookahead == 42603 ||
    lookahead == 42605 ||
    lookahead == 42625 ||
    lookahead == 42627 ||
    lookahead == 42629 ||
    lookahead == 42631 ||
    lookahead == 42633 ||
    lookahead == 42635 ||
    lookahead == 42637 ||
    lookahead == 42639 ||
    lookahead == 42641 ||
    lookahead == 42643 ||
    lookahead == 42645 ||
    lookahead == 42647 ||
    lookahead == 42649 ||
    lookahead == 42651 ||
    lookahead == 42787 ||
    lookahead == 42789 ||
    lookahead == 42791 ||
    lookahead == 42793 ||
    lookahead == 42795 ||
    lookahead == 42797 ||
    (42799 <= lookahead && lookahead <= 42801) ||
    lookahead == 42803 ||
    lookahead == 42805 ||
    lookahead == 42807 ||
    lookahead == 42809 ||
    lookahead == 42811 ||
    lookahead == 42813 ||
    lookahead == 42815 ||
    lookahead == 42817 ||
    lookahead == 42819 ||
    lookahead == 42821 ||
    lookahead == 42823 ||
    lookahead == 42825 ||
    lookahead == 42827 ||
    lookahead == 42829 ||
    lookahead == 42831 ||
    lookahead == 42833 ||
    lookahead == 42835 ||
    lookahead == 42837 ||
    lookahead == 42839 ||
    lookahead == 42841 ||
    lookahead == 42843 ||
    lookahead == 42845 ||
    lookahead == 42847 ||
    lookahead == 42849 ||
    lookahead == 42851 ||
    lookahead == 42853 ||
    lookahead == 42855 ||
    lookahead == 42857 ||
    lookahead == 42859 ||
    lookahead == 42861 ||
    lookahead == 42863 ||
    (42865 <= lookahead && lookahead <= 42872) ||
    lookahead == 42874 ||
    lookahead == 42876 ||
    lookahead == 42879 ||
    lookahead == 42881 ||
    lookahead == 42883 ||
    lookahead == 42885 ||
    lookahead == 42887 ||
    lookahead == 42892 ||
    lookahead == 42894 ||
    lookahead == 42897 ||
    (42899 <= lookahead && lookahead <= 42901) ||
    lookahead == 42903 ||
    lookahead == 42905 ||
    lookahead == 42907 ||
    lookahead == 42909 ||
    lookahead == 42911 ||
    lookahead == 42913 ||
    lookahead == 42915 ||
    lookahead == 42917 ||
    lookahead == 42919 ||
    lookahead == 42921 ||
    lookahead == 42927 ||
    lookahead == 42933 ||
    lookahead == 42935 ||
    lookahead == 42937 ||
    lookahead == 42939 ||
    lookahead == 42941 ||
    lookahead == 42943 ||
    lookahead == 42947 ||
    lookahead == 43002 ||
    (43824 <= lookahead && lookahead <= 43866) ||
    (43872 <= lookahead && lookahead <= 43879) ||
    (43888 <= lookahead && lookahead <= 43967) ||
    (64256 <= lookahead && lookahead <= 64262) ||
    (64275 <= lookahead && lookahead <= 64279) ||
    (65345 <= lookahead && lookahead <= 65370) ||
    (66600 <= lookahead && lookahead <= 66639) ||
    (66776 <= lookahead && lookahead <= 66811) ||
    (68800 <= lookahead && lookahead <= 68850) ||
    (71872 <= lookahead && lookahead <= 71903) ||
    (93792 <= lookahead && lookahead <= 93823) ||
    (119834 <= lookahead && lookahead <= 119859) ||
    (119886 <= lookahead && lookahead <= 119892) ||
    (119894 <= lookahead && lookahead <= 119911) ||
    (119938 <= lookahead && lookahead <= 119963) ||
    (119990 <= lookahead && lookahead <= 119993) ||
    lookahead == 119995 ||
    (119997 <= lookahead && lookahead <= 120003) ||
    (120005 <= lookahead && lookahead <= 120015) ||
    (120042 <= lookahead && lookahead <= 120067) ||
    (120094 <= lookahead && lookahead <= 120119) ||
    (120146 <= lookahead && lookahead <= 120171) ||
    (120198 <= lookahead && lookahead <= 120223) ||
    (120250 <= lookahead && lookahead <= 120275) ||
    (120302 <= lookahead && lookahead <= 120327) ||
    (120354 <= lookahead && lookahead <= 120379) ||
    (120406 <= lookahead && lookahead <= 120431) ||
    (120458 <= lookahead && lookahead <= 120485) ||
    (120514 <= lookahead && lookahead <= 120538) ||
    (120540 <= lookahead && lookahead <= 120545) ||
    (120572 <= lookahead && lookahead <= 120596) ||
    (120598 <= lookahead && lookahead <= 120603) ||
    (120630 <= lookahead && lookahead <= 120654) ||
    (120656 <= lookahead && lookahead <= 120661) ||
    (120688 <= lookahead && lookahead <= 120712) ||
    (120714 <= lookahead && lookahead <= 120719) ||
    (120746 <= lookahead && lookahead <= 120770) ||
    (120772 <= lookahead && lookahead <= 120777) ||
    lookahead == 120779 ||
    (125218 <= lookahead && lookahead <= 125251);
}

static inline bool sym_lower_case_identifier_character_set_2(int32_t lookahead) {
  return
    ('a' <= lookahead && lookahead <= 'z') ||
    lookahead == 181 ||
    (223 <= lookahead && lookahead <= 246) ||
    (248 <= lookahead && lookahead <= 442) ||
    (445 <= lookahead && lookahead <= 447) ||
    lookahead == 454 ||
    lookahead == 457 ||
    (460 <= lookahead && lookahead <= 496) ||
    (499 <= lookahead && lookahead <= 659) ||
    (661 <= lookahead && lookahead <= 687) ||
    (881 <= lookahead && lookahead <= 883) ||
    lookahead == 887 ||
    (891 <= lookahead && lookahead <= 893) ||
    lookahead == 912 ||
    (940 <= lookahead && lookahead <= 1013) ||
    (1016 <= lookahead && lookahead <= 1153) ||
    (1163 <= lookahead && lookahead <= 1327) ||
    (1376 <= lookahead && lookahead <= 1416) ||
    (4304 <= lookahead && lookahead <= 4346) ||
    (4349 <= lookahead && lookahead <= 4351) ||
    (5112 <= lookahead && lookahead <= 5117) ||
    (7296 <= lookahead && lookahead <= 7304) ||
    (7424 <= lookahead && lookahead <= 7467) ||
    (7531 <= lookahead && lookahead <= 7543) ||
    (7545 <= lookahead && lookahead <= 7578) ||
    (7681 <= lookahead && lookahead <= 7957) ||
    (7968 <= lookahead && lookahead <= 8005) ||
    (8016 <= lookahead && lookahead <= 8023) ||
    (8032 <= lookahead && lookahead <= 8061) ||
    (8064 <= lookahead && lookahead <= 8071) ||
    (8080 <= lookahead && lookahead <= 8087) ||
    (8096 <= lookahead && lookahead <= 8103) ||
    (8112 <= lookahead && lookahead <= 8116) ||
    lookahead == 8118 ||
    lookahead == 8119 ||
    lookahead == 8126 ||
    (8130 <= lookahead && lookahead <= 8132) ||
    lookahead == 8134 ||
    lookahead == 8135 ||
    (8144 <= lookahead && lookahead <= 8147) ||
    lookahead == 8150 ||
    lookahead == 8151 ||
    (8160 <= lookahead && lookahead <= 8167) ||
    (8178 <= lookahead && lookahead <= 8180) ||
    lookahead == 8182 ||
    lookahead == 8183 ||
    (8458 <= lookahead && lookahead <= 8467) ||
    (8495 <= lookahead && lookahead <= 8500) ||
    lookahead == 8505 ||
    lookahead == 8508 ||
    lookahead == 8509 ||
    (8518 <= lookahead && lookahead <= 8521) ||
    lookahead == 8526 ||
    lookahead == 8580 ||
    (11312 <= lookahead && lookahead <= 11358) ||
    (11361 <= lookahead && lookahead <= 11387) ||
    (11393 <= lookahead && lookahead <= 11492) ||
    (11500 <= lookahead && lookahead <= 11502) ||
    lookahead == 11507 ||
    (11520 <= lookahead && lookahead <= 11557) ||
    lookahead == 11559 ||
    lookahead == 11565 ||
    (42561 <= lookahead && lookahead <= 42605) ||
    (42625 <= lookahead && lookahead <= 42651) ||
    (42787 <= lookahead && lookahead <= 42863) ||
    (42865 <= lookahead && lookahead <= 42887) ||
    (42892 <= lookahead && lookahead <= 42894) ||
    (42897 <= lookahead && lookahead <= 42943) ||
    lookahead == 42947 ||
    lookahead == 43002 ||
    (43824 <= lookahead && lookahead <= 43866) ||
    (43872 <= lookahead && lookahead <= 43879) ||
    (43888 <= lookahead && lookahead <= 43967) ||
    (64256 <= lookahead && lookahead <= 64262) ||
    (64275 <= lookahead && lookahead <= 64279) ||
    (65345 <= lookahead && lookahead <= 65370) ||
    (66600 <= lookahead && lookahead <= 66639) ||
    (66776 <= lookahead && lookahead <= 66811) ||
    (68800 <= lookahead && lookahead <= 68850) ||
    (71872 <= lookahead && lookahead <= 71903) ||
    (93792 <= lookahead && lookahead <= 93823) ||
    (119834 <= lookahead && lookahead <= 119892) ||
    (119894 <= lookahead && lookahead <= 119963) ||
    (119990 <= lookahead && lookahead <= 119993) ||
    lookahead == 119995 ||
    (119997 <= lookahead && lookahead <= 120003) ||
    (120005 <= lookahead && lookahead <= 120067) ||
    (120094 <= lookahead && lookahead <= 120119) ||
    (120146 <= lookahead && lookahead <= 120485) ||
    (120514 <= lookahead && lookahead <= 120538) ||
    (120540 <= lookahead && lookahead <= 120545) ||
    (120572 <= lookahead && lookahead <= 120596) ||
    (120598 <= lookahead && lookahead <= 120603) ||
    (120630 <= lookahead && lookahead <= 120654) ||
    (120656 <= lookahead && lookahead <= 120661) ||
    (120688 <= lookahead && lookahead <= 120712) ||
    (120714 <= lookahead && lookahead <= 120719) ||
    (120746 <= lookahead && lookahead <= 120770) ||
    (120772 <= lookahead && lookahead <= 120779) ||
    (125218 <= lookahead && lookahead <= 125251);
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(120);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(111);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(66)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(70);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(76);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(18)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '\r') SKIP(1)
      if (lookahead == 'u') ADVANCE(43);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(91);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(24)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(24)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(26)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(29)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(29)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(93);
      if (lookahead == '\r') ADVANCE(92);
      if (lookahead == 'u') ADVANCE(96);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(91);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(10)
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(84);
      if (lookahead != 0) ADVANCE(85);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(94);
      if (lookahead == '\r') ADVANCE(92);
      if (lookahead == 'u') ADVANCE(96);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(91);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(12)
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(82);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(23)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(23)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(28)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(28)
      if (lookahead == '\r') SKIP(15)
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(95);
      if (lookahead == '\r') ADVANCE(92);
      if (lookahead == 'u') ADVANCE(96);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(91);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(120);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(111);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(18)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(76);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      if (lookahead != 0) ADVANCE(88);
      END_STATE();
    case 20:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(72);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(113);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 21:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(115);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(113);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(72);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(33);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(24)
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 23:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(32);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(23)
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 24:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(33);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(24)
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 25:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(72);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(26)
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 26:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(26)
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 27:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(118);
      if (lookahead == '.') ADVANCE(72);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(29)
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(76);
      END_STATE();
    case 28:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(118);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(28)
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(76);
      END_STATE();
    case 29:
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(118);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == ':') ADVANCE(35);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '|') ADVANCE(34);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(29)
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(76);
      END_STATE();
    case 30:
      if (lookahead == '&') ADVANCE(132);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 32:
      if (lookahead == '.') ADVANCE(104);
      END_STATE();
    case 33:
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == ']') ADVANCE(144);
      if (lookahead == '|') ADVANCE(133);
      END_STATE();
    case 34:
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '|') ADVANCE(133);
      END_STATE();
    case 35:
      if (lookahead == ':') ADVANCE(74);
      END_STATE();
    case 36:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 37:
      if (lookahead == '>') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 38:
      if (lookahead == '>') ADVANCE(139);
      END_STATE();
    case 39:
      if (lookahead == '>') ADVANCE(140);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 41:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == '{') ADVANCE(62);
      END_STATE();
    case 44:
      if (lookahead == '|') ADVANCE(143);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(91);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == '}') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 49:
      if (lookahead == '}') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 50:
      if (lookahead == '}') ADVANCE(91);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 51:
      if (lookahead == '}') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 52:
      if (lookahead == '}') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 53:
      if (lookahead == '}') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 54:
      if (lookahead == '}') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 55:
      if (lookahead == '}') ADVANCE(92);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 63:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(70);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 64:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 65:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(68)
      if (lookahead == '\r') SKIP(64)
      END_STATE();
    case 66:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '&') ADVANCE(30);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(120);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(111);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(66)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(76);
      END_STATE();
    case 67:
      if (eof) ADVANCE(69);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '.') ADVANCE(72);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '[') ADVANCE(99);
      if (lookahead == '\\') SKIP(65)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(68)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 68:
      if (eof) ADVANCE(69);
      if (lookahead == '\'') ADVANCE(145);
      if (lookahead == '(') ADVANCE(97);
      if (lookahead == ')') ADVANCE(98);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '[') ADVANCE(99);
      if (lookahead == '\\') SKIP(65)
      if (lookahead == ']') ADVANCE(101);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(68)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (sym_upper_case_identifier_character_set_1(lookahead)) ADVANCE(75);
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym__upper_case_identifier_without_leading_whitespace);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym__lower_case_identifier_without_leading_whitespace);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym__dot_without_leading_whitespace);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym__dot_without_leading_whitespace);
      if (lookahead == '.') ADVANCE(104);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_upper_case_identifier);
      if (sym_upper_case_identifier_character_set_2(lookahead)) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_lower_case_identifier);
      if (sym_upper_case_identifier_character_set_2(lookahead)) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym_number_literal_token1);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_number_literal_token1);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_number_literal_token1);
      if (lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_number_literal_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym__hex_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_regular_char);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_regular_char);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_regular_string_part_token1);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(84);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(85);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_regular_string_part_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_regular_string_part_token2);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_regular_string_part_multiline_token1);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_regular_string_part_multiline_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_regular_string_part_multiline_token2);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_regular_string_part_multiline_token2);
      if (lookahead == '"') ADVANCE(89);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_string_escape);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(84);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(83);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '{') ADVANCE(54);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_left_parenthesis);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_right_parenthesis);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_left_square_bracket);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_left_square_bracket);
      if (lookahead == 'g') ADVANCE(40);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_right_square_bracket);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_left_brace);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_right_brace);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_double_dot);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_eq);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_eq);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_arrow);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_colon);
      if (lookahead == ':') ADVANCE(74);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_pipe);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_pipe);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == ']') ADVANCE(144);
      if (lookahead == '|') ADVANCE(133);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_pipe);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(136);
      if (lookahead == '|') ADVANCE(133);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_backslash);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_dot);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_dot);
      if (lookahead == '.') ADVANCE(104);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(134);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(108);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '<') ADVANCE(137);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '?') ADVANCE(39);
      if (lookahead == '|') ADVANCE(135);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(131);
      if (lookahead == '>') ADVANCE(138);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_LT_PIPE);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LT_SLASH_GT);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LT_QMARK_GT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PIPE_DOT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_glsl_begin);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_glsl_end);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym__char_quote);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'w') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(14)
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'x') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'm') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(30);
      if (lookahead == 'y') ADVANCE(31);
      END_STATE();
    case 13:
      if (lookahead == 'h') ADVANCE(32);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 15:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(sym_as);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 18:
      if (lookahead == 'f') ADVANCE(35);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 20:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(38);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(39);
      END_STATE();
    case 24:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_of);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'g') ADVANCE(45);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 31:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 39:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_non);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 45:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_case);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_left);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_port);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_type);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_alias);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_infix);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_right);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_where);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_effect);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_import);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_module);
      END_STATE();
    case 75:
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_exposing);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 67, .external_lex_state = 2},
  [2] = {.lex_state = 21, .external_lex_state = 3},
  [3] = {.lex_state = 21, .external_lex_state = 3},
  [4] = {.lex_state = 21, .external_lex_state = 3},
  [5] = {.lex_state = 21, .external_lex_state = 3},
  [6] = {.lex_state = 21, .external_lex_state = 3},
  [7] = {.lex_state = 21, .external_lex_state = 3},
  [8] = {.lex_state = 21, .external_lex_state = 3},
  [9] = {.lex_state = 21, .external_lex_state = 3},
  [10] = {.lex_state = 21, .external_lex_state = 3},
  [11] = {.lex_state = 21, .external_lex_state = 3},
  [12] = {.lex_state = 21, .external_lex_state = 3},
  [13] = {.lex_state = 21, .external_lex_state = 3},
  [14] = {.lex_state = 21, .external_lex_state = 4},
  [15] = {.lex_state = 21, .external_lex_state = 4},
  [16] = {.lex_state = 21, .external_lex_state = 4},
  [17] = {.lex_state = 21, .external_lex_state = 5},
  [18] = {.lex_state = 21, .external_lex_state = 5},
  [19] = {.lex_state = 21, .external_lex_state = 5},
  [20] = {.lex_state = 21, .external_lex_state = 3},
  [21] = {.lex_state = 21, .external_lex_state = 3},
  [22] = {.lex_state = 21, .external_lex_state = 3},
  [23] = {.lex_state = 21, .external_lex_state = 3},
  [24] = {.lex_state = 21, .external_lex_state = 3},
  [25] = {.lex_state = 20, .external_lex_state = 3},
  [26] = {.lex_state = 21, .external_lex_state = 3},
  [27] = {.lex_state = 20, .external_lex_state = 3},
  [28] = {.lex_state = 21, .external_lex_state = 3},
  [29] = {.lex_state = 21, .external_lex_state = 3},
  [30] = {.lex_state = 21, .external_lex_state = 3},
  [31] = {.lex_state = 20, .external_lex_state = 3},
  [32] = {.lex_state = 21, .external_lex_state = 3},
  [33] = {.lex_state = 21, .external_lex_state = 3},
  [34] = {.lex_state = 21, .external_lex_state = 3},
  [35] = {.lex_state = 20, .external_lex_state = 3},
  [36] = {.lex_state = 21, .external_lex_state = 3},
  [37] = {.lex_state = 21, .external_lex_state = 3},
  [38] = {.lex_state = 21, .external_lex_state = 3},
  [39] = {.lex_state = 21, .external_lex_state = 3},
  [40] = {.lex_state = 20, .external_lex_state = 3},
  [41] = {.lex_state = 21, .external_lex_state = 3},
  [42] = {.lex_state = 21, .external_lex_state = 3},
  [43] = {.lex_state = 21, .external_lex_state = 3},
  [44] = {.lex_state = 21, .external_lex_state = 3},
  [45] = {.lex_state = 21, .external_lex_state = 3},
  [46] = {.lex_state = 21, .external_lex_state = 3},
  [47] = {.lex_state = 21, .external_lex_state = 3},
  [48] = {.lex_state = 21, .external_lex_state = 3},
  [49] = {.lex_state = 21, .external_lex_state = 3},
  [50] = {.lex_state = 21, .external_lex_state = 3},
  [51] = {.lex_state = 21, .external_lex_state = 3},
  [52] = {.lex_state = 21, .external_lex_state = 3},
  [53] = {.lex_state = 21, .external_lex_state = 3},
  [54] = {.lex_state = 21, .external_lex_state = 3},
  [55] = {.lex_state = 21, .external_lex_state = 3},
  [56] = {.lex_state = 21, .external_lex_state = 3},
  [57] = {.lex_state = 21, .external_lex_state = 3},
  [58] = {.lex_state = 21, .external_lex_state = 3},
  [59] = {.lex_state = 21, .external_lex_state = 3},
  [60] = {.lex_state = 21, .external_lex_state = 3},
  [61] = {.lex_state = 21, .external_lex_state = 3},
  [62] = {.lex_state = 21, .external_lex_state = 3},
  [63] = {.lex_state = 21, .external_lex_state = 3},
  [64] = {.lex_state = 21, .external_lex_state = 3},
  [65] = {.lex_state = 21, .external_lex_state = 3},
  [66] = {.lex_state = 20, .external_lex_state = 3},
  [67] = {.lex_state = 20, .external_lex_state = 3},
  [68] = {.lex_state = 20, .external_lex_state = 3},
  [69] = {.lex_state = 20, .external_lex_state = 3},
  [70] = {.lex_state = 20, .external_lex_state = 3},
  [71] = {.lex_state = 20, .external_lex_state = 3},
  [72] = {.lex_state = 20, .external_lex_state = 3},
  [73] = {.lex_state = 20, .external_lex_state = 3},
  [74] = {.lex_state = 20, .external_lex_state = 3},
  [75] = {.lex_state = 20, .external_lex_state = 3},
  [76] = {.lex_state = 20, .external_lex_state = 3},
  [77] = {.lex_state = 20, .external_lex_state = 3},
  [78] = {.lex_state = 21, .external_lex_state = 3},
  [79] = {.lex_state = 21, .external_lex_state = 3},
  [80] = {.lex_state = 21, .external_lex_state = 3},
  [81] = {.lex_state = 21, .external_lex_state = 3},
  [82] = {.lex_state = 21, .external_lex_state = 3},
  [83] = {.lex_state = 21, .external_lex_state = 3},
  [84] = {.lex_state = 21, .external_lex_state = 3},
  [85] = {.lex_state = 21, .external_lex_state = 3},
  [86] = {.lex_state = 21, .external_lex_state = 3},
  [87] = {.lex_state = 21, .external_lex_state = 3},
  [88] = {.lex_state = 21, .external_lex_state = 3},
  [89] = {.lex_state = 21, .external_lex_state = 3},
  [90] = {.lex_state = 21, .external_lex_state = 3},
  [91] = {.lex_state = 21, .external_lex_state = 3},
  [92] = {.lex_state = 21, .external_lex_state = 3},
  [93] = {.lex_state = 21, .external_lex_state = 3},
  [94] = {.lex_state = 21, .external_lex_state = 3},
  [95] = {.lex_state = 21, .external_lex_state = 3},
  [96] = {.lex_state = 21, .external_lex_state = 3},
  [97] = {.lex_state = 21, .external_lex_state = 3},
  [98] = {.lex_state = 21, .external_lex_state = 3},
  [99] = {.lex_state = 21, .external_lex_state = 3},
  [100] = {.lex_state = 67, .external_lex_state = 2},
  [101] = {.lex_state = 21, .external_lex_state = 3},
  [102] = {.lex_state = 21, .external_lex_state = 3},
  [103] = {.lex_state = 21, .external_lex_state = 3},
  [104] = {.lex_state = 21, .external_lex_state = 3},
  [105] = {.lex_state = 21, .external_lex_state = 3},
  [106] = {.lex_state = 21, .external_lex_state = 3},
  [107] = {.lex_state = 21, .external_lex_state = 3},
  [108] = {.lex_state = 21, .external_lex_state = 3},
  [109] = {.lex_state = 21, .external_lex_state = 3},
  [110] = {.lex_state = 21, .external_lex_state = 3},
  [111] = {.lex_state = 67, .external_lex_state = 2},
  [112] = {.lex_state = 67, .external_lex_state = 2},
  [113] = {.lex_state = 21, .external_lex_state = 3},
  [114] = {.lex_state = 21, .external_lex_state = 3},
  [115] = {.lex_state = 21, .external_lex_state = 3},
  [116] = {.lex_state = 20, .external_lex_state = 4},
  [117] = {.lex_state = 21, .external_lex_state = 3},
  [118] = {.lex_state = 21, .external_lex_state = 3},
  [119] = {.lex_state = 20, .external_lex_state = 4},
  [120] = {.lex_state = 21, .external_lex_state = 3},
  [121] = {.lex_state = 21, .external_lex_state = 4},
  [122] = {.lex_state = 21, .external_lex_state = 3},
  [123] = {.lex_state = 21, .external_lex_state = 4},
  [124] = {.lex_state = 21, .external_lex_state = 3},
  [125] = {.lex_state = 21, .external_lex_state = 4},
  [126] = {.lex_state = 21, .external_lex_state = 5},
  [127] = {.lex_state = 67, .external_lex_state = 2},
  [128] = {.lex_state = 21, .external_lex_state = 3},
  [129] = {.lex_state = 20, .external_lex_state = 5},
  [130] = {.lex_state = 67, .external_lex_state = 2},
  [131] = {.lex_state = 21, .external_lex_state = 3},
  [132] = {.lex_state = 20, .external_lex_state = 4},
  [133] = {.lex_state = 20, .external_lex_state = 4},
  [134] = {.lex_state = 67, .external_lex_state = 2},
  [135] = {.lex_state = 67, .external_lex_state = 2},
  [136] = {.lex_state = 21, .external_lex_state = 5},
  [137] = {.lex_state = 21, .external_lex_state = 3},
  [138] = {.lex_state = 21, .external_lex_state = 3},
  [139] = {.lex_state = 21, .external_lex_state = 3},
  [140] = {.lex_state = 67, .external_lex_state = 2},
  [141] = {.lex_state = 21, .external_lex_state = 5},
  [142] = {.lex_state = 21, .external_lex_state = 3},
  [143] = {.lex_state = 20, .external_lex_state = 4},
  [144] = {.lex_state = 20, .external_lex_state = 5},
  [145] = {.lex_state = 20, .external_lex_state = 4},
  [146] = {.lex_state = 20, .external_lex_state = 4},
  [147] = {.lex_state = 20, .external_lex_state = 5},
  [148] = {.lex_state = 20, .external_lex_state = 5},
  [149] = {.lex_state = 20, .external_lex_state = 4},
  [150] = {.lex_state = 20, .external_lex_state = 4},
  [151] = {.lex_state = 20, .external_lex_state = 4},
  [152] = {.lex_state = 20, .external_lex_state = 5},
  [153] = {.lex_state = 20, .external_lex_state = 4},
  [154] = {.lex_state = 20, .external_lex_state = 4},
  [155] = {.lex_state = 20, .external_lex_state = 4},
  [156] = {.lex_state = 20, .external_lex_state = 4},
  [157] = {.lex_state = 20, .external_lex_state = 4},
  [158] = {.lex_state = 20, .external_lex_state = 4},
  [159] = {.lex_state = 20, .external_lex_state = 4},
  [160] = {.lex_state = 21, .external_lex_state = 4},
  [161] = {.lex_state = 21, .external_lex_state = 4},
  [162] = {.lex_state = 21, .external_lex_state = 4},
  [163] = {.lex_state = 21, .external_lex_state = 4},
  [164] = {.lex_state = 21, .external_lex_state = 4},
  [165] = {.lex_state = 21, .external_lex_state = 4},
  [166] = {.lex_state = 21, .external_lex_state = 4},
  [167] = {.lex_state = 21, .external_lex_state = 4},
  [168] = {.lex_state = 21, .external_lex_state = 4},
  [169] = {.lex_state = 21, .external_lex_state = 4},
  [170] = {.lex_state = 21, .external_lex_state = 4},
  [171] = {.lex_state = 21, .external_lex_state = 4},
  [172] = {.lex_state = 21, .external_lex_state = 4},
  [173] = {.lex_state = 20, .external_lex_state = 5},
  [174] = {.lex_state = 21, .external_lex_state = 4},
  [175] = {.lex_state = 21, .external_lex_state = 4},
  [176] = {.lex_state = 20, .external_lex_state = 5},
  [177] = {.lex_state = 21, .external_lex_state = 4},
  [178] = {.lex_state = 21, .external_lex_state = 4},
  [179] = {.lex_state = 21, .external_lex_state = 4},
  [180] = {.lex_state = 21, .external_lex_state = 4},
  [181] = {.lex_state = 21, .external_lex_state = 4},
  [182] = {.lex_state = 21, .external_lex_state = 4},
  [183] = {.lex_state = 20, .external_lex_state = 5},
  [184] = {.lex_state = 21, .external_lex_state = 4},
  [185] = {.lex_state = 20, .external_lex_state = 5},
  [186] = {.lex_state = 21, .external_lex_state = 4},
  [187] = {.lex_state = 20, .external_lex_state = 5},
  [188] = {.lex_state = 21, .external_lex_state = 4},
  [189] = {.lex_state = 21, .external_lex_state = 4},
  [190] = {.lex_state = 21, .external_lex_state = 4},
  [191] = {.lex_state = 20, .external_lex_state = 5},
  [192] = {.lex_state = 20, .external_lex_state = 5},
  [193] = {.lex_state = 20, .external_lex_state = 5},
  [194] = {.lex_state = 21, .external_lex_state = 4},
  [195] = {.lex_state = 20, .external_lex_state = 5},
  [196] = {.lex_state = 20, .external_lex_state = 5},
  [197] = {.lex_state = 20, .external_lex_state = 5},
  [198] = {.lex_state = 20, .external_lex_state = 5},
  [199] = {.lex_state = 21, .external_lex_state = 4},
  [200] = {.lex_state = 21, .external_lex_state = 5},
  [201] = {.lex_state = 21, .external_lex_state = 5},
  [202] = {.lex_state = 21, .external_lex_state = 5},
  [203] = {.lex_state = 21, .external_lex_state = 5},
  [204] = {.lex_state = 21, .external_lex_state = 5},
  [205] = {.lex_state = 21, .external_lex_state = 5},
  [206] = {.lex_state = 21, .external_lex_state = 5},
  [207] = {.lex_state = 21, .external_lex_state = 5},
  [208] = {.lex_state = 21, .external_lex_state = 5},
  [209] = {.lex_state = 21, .external_lex_state = 5},
  [210] = {.lex_state = 21, .external_lex_state = 5},
  [211] = {.lex_state = 21, .external_lex_state = 5},
  [212] = {.lex_state = 21, .external_lex_state = 5},
  [213] = {.lex_state = 21, .external_lex_state = 5},
  [214] = {.lex_state = 21, .external_lex_state = 5},
  [215] = {.lex_state = 21, .external_lex_state = 5},
  [216] = {.lex_state = 21, .external_lex_state = 5},
  [217] = {.lex_state = 21, .external_lex_state = 5},
  [218] = {.lex_state = 21, .external_lex_state = 5},
  [219] = {.lex_state = 21, .external_lex_state = 5},
  [220] = {.lex_state = 21, .external_lex_state = 5},
  [221] = {.lex_state = 21, .external_lex_state = 5},
  [222] = {.lex_state = 21, .external_lex_state = 5},
  [223] = {.lex_state = 21, .external_lex_state = 5},
  [224] = {.lex_state = 21, .external_lex_state = 5},
  [225] = {.lex_state = 21, .external_lex_state = 5},
  [226] = {.lex_state = 21, .external_lex_state = 5},
  [227] = {.lex_state = 21, .external_lex_state = 5},
  [228] = {.lex_state = 22, .external_lex_state = 6},
  [229] = {.lex_state = 22, .external_lex_state = 6},
  [230] = {.lex_state = 22, .external_lex_state = 6},
  [231] = {.lex_state = 23, .external_lex_state = 6},
  [232] = {.lex_state = 67, .external_lex_state = 2},
  [233] = {.lex_state = 67, .external_lex_state = 2},
  [234] = {.lex_state = 67, .external_lex_state = 2},
  [235] = {.lex_state = 25, .external_lex_state = 7},
  [236] = {.lex_state = 25, .external_lex_state = 7},
  [237] = {.lex_state = 23, .external_lex_state = 6},
  [238] = {.lex_state = 67, .external_lex_state = 2},
  [239] = {.lex_state = 67, .external_lex_state = 2},
  [240] = {.lex_state = 27, .external_lex_state = 6},
  [241] = {.lex_state = 27, .external_lex_state = 6},
  [242] = {.lex_state = 27, .external_lex_state = 6},
  [243] = {.lex_state = 23, .external_lex_state = 6},
  [244] = {.lex_state = 23, .external_lex_state = 6},
  [245] = {.lex_state = 23, .external_lex_state = 6},
  [246] = {.lex_state = 27, .external_lex_state = 6},
  [247] = {.lex_state = 25, .external_lex_state = 7},
  [248] = {.lex_state = 27, .external_lex_state = 6},
  [249] = {.lex_state = 23, .external_lex_state = 6},
  [250] = {.lex_state = 23, .external_lex_state = 6},
  [251] = {.lex_state = 67, .external_lex_state = 2},
  [252] = {.lex_state = 22, .external_lex_state = 8},
  [253] = {.lex_state = 67, .external_lex_state = 2},
  [254] = {.lex_state = 67, .external_lex_state = 2},
  [255] = {.lex_state = 67, .external_lex_state = 2},
  [256] = {.lex_state = 22, .external_lex_state = 8},
  [257] = {.lex_state = 27, .external_lex_state = 6},
  [258] = {.lex_state = 67, .external_lex_state = 2},
  [259] = {.lex_state = 67, .external_lex_state = 2},
  [260] = {.lex_state = 27, .external_lex_state = 6},
  [261] = {.lex_state = 27, .external_lex_state = 6},
  [262] = {.lex_state = 67, .external_lex_state = 2},
  [263] = {.lex_state = 67, .external_lex_state = 2},
  [264] = {.lex_state = 27, .external_lex_state = 6},
  [265] = {.lex_state = 27, .external_lex_state = 6},
  [266] = {.lex_state = 67, .external_lex_state = 2},
  [267] = {.lex_state = 67, .external_lex_state = 2},
  [268] = {.lex_state = 67, .external_lex_state = 2},
  [269] = {.lex_state = 67, .external_lex_state = 2},
  [270] = {.lex_state = 67, .external_lex_state = 2},
  [271] = {.lex_state = 27, .external_lex_state = 6},
  [272] = {.lex_state = 27, .external_lex_state = 6},
  [273] = {.lex_state = 27, .external_lex_state = 6},
  [274] = {.lex_state = 67, .external_lex_state = 2},
  [275] = {.lex_state = 27, .external_lex_state = 6},
  [276] = {.lex_state = 27, .external_lex_state = 6},
  [277] = {.lex_state = 22, .external_lex_state = 8},
  [278] = {.lex_state = 28, .external_lex_state = 6},
  [279] = {.lex_state = 67, .external_lex_state = 2},
  [280] = {.lex_state = 67, .external_lex_state = 2},
  [281] = {.lex_state = 67, .external_lex_state = 2},
  [282] = {.lex_state = 67, .external_lex_state = 2},
  [283] = {.lex_state = 67, .external_lex_state = 2},
  [284] = {.lex_state = 67, .external_lex_state = 2},
  [285] = {.lex_state = 67, .external_lex_state = 2},
  [286] = {.lex_state = 27, .external_lex_state = 6},
  [287] = {.lex_state = 67, .external_lex_state = 2},
  [288] = {.lex_state = 67, .external_lex_state = 2},
  [289] = {.lex_state = 67, .external_lex_state = 2},
  [290] = {.lex_state = 67, .external_lex_state = 2},
  [291] = {.lex_state = 67, .external_lex_state = 2},
  [292] = {.lex_state = 27, .external_lex_state = 6},
  [293] = {.lex_state = 25, .external_lex_state = 7},
  [294] = {.lex_state = 67, .external_lex_state = 2},
  [295] = {.lex_state = 67, .external_lex_state = 2},
  [296] = {.lex_state = 67, .external_lex_state = 2},
  [297] = {.lex_state = 67, .external_lex_state = 2},
  [298] = {.lex_state = 27, .external_lex_state = 6},
  [299] = {.lex_state = 27, .external_lex_state = 6},
  [300] = {.lex_state = 27, .external_lex_state = 6},
  [301] = {.lex_state = 27, .external_lex_state = 6},
  [302] = {.lex_state = 27, .external_lex_state = 6},
  [303] = {.lex_state = 27, .external_lex_state = 6},
  [304] = {.lex_state = 27, .external_lex_state = 6},
  [305] = {.lex_state = 27, .external_lex_state = 6},
  [306] = {.lex_state = 27, .external_lex_state = 6},
  [307] = {.lex_state = 27, .external_lex_state = 6},
  [308] = {.lex_state = 27, .external_lex_state = 6},
  [309] = {.lex_state = 67, .external_lex_state = 2},
  [310] = {.lex_state = 27, .external_lex_state = 6},
  [311] = {.lex_state = 67, .external_lex_state = 2},
  [312] = {.lex_state = 27, .external_lex_state = 6},
  [313] = {.lex_state = 27, .external_lex_state = 6},
  [314] = {.lex_state = 27, .external_lex_state = 6},
  [315] = {.lex_state = 22, .external_lex_state = 8},
  [316] = {.lex_state = 27, .external_lex_state = 6},
  [317] = {.lex_state = 27, .external_lex_state = 6},
  [318] = {.lex_state = 27, .external_lex_state = 6},
  [319] = {.lex_state = 67, .external_lex_state = 2},
  [320] = {.lex_state = 27, .external_lex_state = 8},
  [321] = {.lex_state = 27, .external_lex_state = 8},
  [322] = {.lex_state = 27, .external_lex_state = 8},
  [323] = {.lex_state = 27, .external_lex_state = 8},
  [324] = {.lex_state = 27, .external_lex_state = 8},
  [325] = {.lex_state = 67, .external_lex_state = 2},
  [326] = {.lex_state = 27, .external_lex_state = 7},
  [327] = {.lex_state = 27, .external_lex_state = 7},
  [328] = {.lex_state = 27, .external_lex_state = 8},
  [329] = {.lex_state = 27, .external_lex_state = 7},
  [330] = {.lex_state = 27, .external_lex_state = 7},
  [331] = {.lex_state = 27, .external_lex_state = 7},
  [332] = {.lex_state = 27, .external_lex_state = 8},
  [333] = {.lex_state = 27, .external_lex_state = 7},
  [334] = {.lex_state = 27, .external_lex_state = 8},
  [335] = {.lex_state = 27, .external_lex_state = 8},
  [336] = {.lex_state = 27, .external_lex_state = 8},
  [337] = {.lex_state = 27, .external_lex_state = 8},
  [338] = {.lex_state = 67, .external_lex_state = 2},
  [339] = {.lex_state = 27, .external_lex_state = 8},
  [340] = {.lex_state = 27, .external_lex_state = 8},
  [341] = {.lex_state = 67, .external_lex_state = 2},
  [342] = {.lex_state = 27, .external_lex_state = 8},
  [343] = {.lex_state = 27, .external_lex_state = 8},
  [344] = {.lex_state = 27, .external_lex_state = 8},
  [345] = {.lex_state = 27, .external_lex_state = 7},
  [346] = {.lex_state = 67, .external_lex_state = 2},
  [347] = {.lex_state = 27, .external_lex_state = 8},
  [348] = {.lex_state = 27, .external_lex_state = 8},
  [349] = {.lex_state = 27, .external_lex_state = 8},
  [350] = {.lex_state = 27, .external_lex_state = 8},
  [351] = {.lex_state = 27, .external_lex_state = 8},
  [352] = {.lex_state = 27, .external_lex_state = 8},
  [353] = {.lex_state = 27, .external_lex_state = 8},
  [354] = {.lex_state = 27, .external_lex_state = 7},
  [355] = {.lex_state = 27, .external_lex_state = 7},
  [356] = {.lex_state = 27, .external_lex_state = 8},
  [357] = {.lex_state = 27, .external_lex_state = 8},
  [358] = {.lex_state = 27, .external_lex_state = 8},
  [359] = {.lex_state = 27, .external_lex_state = 8},
  [360] = {.lex_state = 27, .external_lex_state = 7},
  [361] = {.lex_state = 27, .external_lex_state = 8},
  [362] = {.lex_state = 27, .external_lex_state = 7},
  [363] = {.lex_state = 27, .external_lex_state = 8},
  [364] = {.lex_state = 27, .external_lex_state = 8},
  [365] = {.lex_state = 27, .external_lex_state = 8},
  [366] = {.lex_state = 27, .external_lex_state = 8},
  [367] = {.lex_state = 27, .external_lex_state = 8},
  [368] = {.lex_state = 27, .external_lex_state = 8},
  [369] = {.lex_state = 27, .external_lex_state = 8},
  [370] = {.lex_state = 27, .external_lex_state = 8},
  [371] = {.lex_state = 27, .external_lex_state = 8},
  [372] = {.lex_state = 27, .external_lex_state = 8},
  [373] = {.lex_state = 27, .external_lex_state = 7},
  [374] = {.lex_state = 67, .external_lex_state = 2},
  [375] = {.lex_state = 27, .external_lex_state = 7},
  [376] = {.lex_state = 27, .external_lex_state = 7},
  [377] = {.lex_state = 27, .external_lex_state = 7},
  [378] = {.lex_state = 27, .external_lex_state = 8},
  [379] = {.lex_state = 27, .external_lex_state = 7},
  [380] = {.lex_state = 27, .external_lex_state = 8},
  [381] = {.lex_state = 27, .external_lex_state = 8},
  [382] = {.lex_state = 27, .external_lex_state = 8},
  [383] = {.lex_state = 27, .external_lex_state = 7},
  [384] = {.lex_state = 27, .external_lex_state = 7},
  [385] = {.lex_state = 27, .external_lex_state = 7},
  [386] = {.lex_state = 27, .external_lex_state = 7},
  [387] = {.lex_state = 27, .external_lex_state = 7},
  [388] = {.lex_state = 27, .external_lex_state = 7},
  [389] = {.lex_state = 27, .external_lex_state = 7},
  [390] = {.lex_state = 27, .external_lex_state = 7},
  [391] = {.lex_state = 27, .external_lex_state = 7},
  [392] = {.lex_state = 27, .external_lex_state = 7},
  [393] = {.lex_state = 27, .external_lex_state = 7},
  [394] = {.lex_state = 27, .external_lex_state = 7},
  [395] = {.lex_state = 27, .external_lex_state = 7},
  [396] = {.lex_state = 27, .external_lex_state = 7},
  [397] = {.lex_state = 27, .external_lex_state = 7},
  [398] = {.lex_state = 27, .external_lex_state = 7},
  [399] = {.lex_state = 27, .external_lex_state = 7},
  [400] = {.lex_state = 27, .external_lex_state = 7},
  [401] = {.lex_state = 27, .external_lex_state = 6},
  [402] = {.lex_state = 27, .external_lex_state = 7},
  [403] = {.lex_state = 27, .external_lex_state = 7},
  [404] = {.lex_state = 27, .external_lex_state = 7},
  [405] = {.lex_state = 27, .external_lex_state = 7},
  [406] = {.lex_state = 27, .external_lex_state = 7},
  [407] = {.lex_state = 27, .external_lex_state = 7},
  [408] = {.lex_state = 27, .external_lex_state = 7},
  [409] = {.lex_state = 27, .external_lex_state = 7},
  [410] = {.lex_state = 67, .external_lex_state = 2},
  [411] = {.lex_state = 67, .external_lex_state = 2},
  [412] = {.lex_state = 67, .external_lex_state = 2},
  [413] = {.lex_state = 67, .external_lex_state = 2},
  [414] = {.lex_state = 67, .external_lex_state = 2},
  [415] = {.lex_state = 67, .external_lex_state = 2},
  [416] = {.lex_state = 67, .external_lex_state = 2},
  [417] = {.lex_state = 67, .external_lex_state = 2},
  [418] = {.lex_state = 67, .external_lex_state = 2},
  [419] = {.lex_state = 67, .external_lex_state = 2},
  [420] = {.lex_state = 67, .external_lex_state = 2},
  [421] = {.lex_state = 67, .external_lex_state = 2},
  [422] = {.lex_state = 67, .external_lex_state = 2},
  [423] = {.lex_state = 67, .external_lex_state = 2},
  [424] = {.lex_state = 67, .external_lex_state = 2},
  [425] = {.lex_state = 67, .external_lex_state = 2},
  [426] = {.lex_state = 67, .external_lex_state = 2},
  [427] = {.lex_state = 67, .external_lex_state = 2},
  [428] = {.lex_state = 67, .external_lex_state = 2},
  [429] = {.lex_state = 67, .external_lex_state = 2},
  [430] = {.lex_state = 67, .external_lex_state = 2},
  [431] = {.lex_state = 67, .external_lex_state = 2},
  [432] = {.lex_state = 67, .external_lex_state = 2},
  [433] = {.lex_state = 21, .external_lex_state = 3},
  [434] = {.lex_state = 21, .external_lex_state = 3},
  [435] = {.lex_state = 67, .external_lex_state = 2},
  [436] = {.lex_state = 67, .external_lex_state = 6},
  [437] = {.lex_state = 67, .external_lex_state = 6},
  [438] = {.lex_state = 67, .external_lex_state = 6},
  [439] = {.lex_state = 67, .external_lex_state = 8},
  [440] = {.lex_state = 67, .external_lex_state = 2},
  [441] = {.lex_state = 67, .external_lex_state = 6},
  [442] = {.lex_state = 67, .external_lex_state = 2},
  [443] = {.lex_state = 67, .external_lex_state = 8},
  [444] = {.lex_state = 67, .external_lex_state = 7},
  [445] = {.lex_state = 67, .external_lex_state = 6},
  [446] = {.lex_state = 67, .external_lex_state = 6},
  [447] = {.lex_state = 67, .external_lex_state = 8},
  [448] = {.lex_state = 67, .external_lex_state = 2},
  [449] = {.lex_state = 67, .external_lex_state = 7},
  [450] = {.lex_state = 67, .external_lex_state = 6},
  [451] = {.lex_state = 67, .external_lex_state = 7},
  [452] = {.lex_state = 67, .external_lex_state = 6},
  [453] = {.lex_state = 67, .external_lex_state = 7},
  [454] = {.lex_state = 67, .external_lex_state = 2},
  [455] = {.lex_state = 67, .external_lex_state = 6},
  [456] = {.lex_state = 67, .external_lex_state = 6},
  [457] = {.lex_state = 67, .external_lex_state = 6},
  [458] = {.lex_state = 67, .external_lex_state = 6},
  [459] = {.lex_state = 67, .external_lex_state = 2},
  [460] = {.lex_state = 67, .external_lex_state = 2},
  [461] = {.lex_state = 67, .external_lex_state = 2},
  [462] = {.lex_state = 67, .external_lex_state = 7},
  [463] = {.lex_state = 67, .external_lex_state = 2},
  [464] = {.lex_state = 67, .external_lex_state = 6},
  [465] = {.lex_state = 67, .external_lex_state = 6},
  [466] = {.lex_state = 67, .external_lex_state = 2},
  [467] = {.lex_state = 67, .external_lex_state = 6},
  [468] = {.lex_state = 67, .external_lex_state = 6},
  [469] = {.lex_state = 67, .external_lex_state = 2},
  [470] = {.lex_state = 67, .external_lex_state = 2},
  [471] = {.lex_state = 67, .external_lex_state = 2},
  [472] = {.lex_state = 67, .external_lex_state = 6},
  [473] = {.lex_state = 67, .external_lex_state = 7},
  [474] = {.lex_state = 23, .external_lex_state = 6},
  [475] = {.lex_state = 67, .external_lex_state = 8},
  [476] = {.lex_state = 19, .external_lex_state = 9},
  [477] = {.lex_state = 10, .external_lex_state = 10},
  [478] = {.lex_state = 19, .external_lex_state = 9},
  [479] = {.lex_state = 19, .external_lex_state = 9},
  [480] = {.lex_state = 19, .external_lex_state = 9},
  [481] = {.lex_state = 10, .external_lex_state = 10},
  [482] = {.lex_state = 10, .external_lex_state = 10},
  [483] = {.lex_state = 67, .external_lex_state = 6},
  [484] = {.lex_state = 67, .external_lex_state = 6},
  [485] = {.lex_state = 67, .external_lex_state = 6},
  [486] = {.lex_state = 67, .external_lex_state = 6},
  [487] = {.lex_state = 19, .external_lex_state = 9},
  [488] = {.lex_state = 10, .external_lex_state = 10},
  [489] = {.lex_state = 67, .external_lex_state = 6},
  [490] = {.lex_state = 67, .external_lex_state = 6},
  [491] = {.lex_state = 10, .external_lex_state = 10},
  [492] = {.lex_state = 19, .external_lex_state = 9},
  [493] = {.lex_state = 67, .external_lex_state = 6},
  [494] = {.lex_state = 19, .external_lex_state = 9},
  [495] = {.lex_state = 67, .external_lex_state = 6},
  [496] = {.lex_state = 67, .external_lex_state = 6},
  [497] = {.lex_state = 67, .external_lex_state = 6},
  [498] = {.lex_state = 10, .external_lex_state = 10},
  [499] = {.lex_state = 19, .external_lex_state = 9},
  [500] = {.lex_state = 10, .external_lex_state = 10},
  [501] = {.lex_state = 67, .external_lex_state = 6},
  [502] = {.lex_state = 67, .external_lex_state = 6},
  [503] = {.lex_state = 67, .external_lex_state = 6},
  [504] = {.lex_state = 10, .external_lex_state = 10},
  [505] = {.lex_state = 67, .external_lex_state = 6},
  [506] = {.lex_state = 67, .external_lex_state = 6},
  [507] = {.lex_state = 67, .external_lex_state = 6},
  [508] = {.lex_state = 10, .external_lex_state = 10},
  [509] = {.lex_state = 19, .external_lex_state = 9},
  [510] = {.lex_state = 19, .external_lex_state = 9},
  [511] = {.lex_state = 10, .external_lex_state = 10},
  [512] = {.lex_state = 19, .external_lex_state = 9},
  [513] = {.lex_state = 19, .external_lex_state = 9},
  [514] = {.lex_state = 10, .external_lex_state = 10},
  [515] = {.lex_state = 19, .external_lex_state = 9},
  [516] = {.lex_state = 10, .external_lex_state = 10},
  [517] = {.lex_state = 19, .external_lex_state = 9},
  [518] = {.lex_state = 10, .external_lex_state = 10},
  [519] = {.lex_state = 10, .external_lex_state = 10},
  [520] = {.lex_state = 19, .external_lex_state = 9},
  [521] = {.lex_state = 10, .external_lex_state = 10},
  [522] = {.lex_state = 67, .external_lex_state = 6},
  [523] = {.lex_state = 67, .external_lex_state = 6},
  [524] = {.lex_state = 67, .external_lex_state = 6},
  [525] = {.lex_state = 67, .external_lex_state = 8},
  [526] = {.lex_state = 67, .external_lex_state = 8},
  [527] = {.lex_state = 67, .external_lex_state = 8},
  [528] = {.lex_state = 67, .external_lex_state = 6},
  [529] = {.lex_state = 67, .external_lex_state = 7},
  [530] = {.lex_state = 67, .external_lex_state = 6},
  [531] = {.lex_state = 67, .external_lex_state = 8},
  [532] = {.lex_state = 67, .external_lex_state = 8},
  [533] = {.lex_state = 67, .external_lex_state = 7},
  [534] = {.lex_state = 67, .external_lex_state = 8},
  [535] = {.lex_state = 67, .external_lex_state = 8},
  [536] = {.lex_state = 67, .external_lex_state = 8},
  [537] = {.lex_state = 67, .external_lex_state = 8},
  [538] = {.lex_state = 67, .external_lex_state = 8},
  [539] = {.lex_state = 67, .external_lex_state = 7},
  [540] = {.lex_state = 67, .external_lex_state = 8},
  [541] = {.lex_state = 67, .external_lex_state = 7},
  [542] = {.lex_state = 67, .external_lex_state = 7},
  [543] = {.lex_state = 67, .external_lex_state = 6},
  [544] = {.lex_state = 67, .external_lex_state = 6},
  [545] = {.lex_state = 67, .external_lex_state = 6},
  [546] = {.lex_state = 67, .external_lex_state = 7},
  [547] = {.lex_state = 67, .external_lex_state = 6},
  [548] = {.lex_state = 67, .external_lex_state = 6},
  [549] = {.lex_state = 67, .external_lex_state = 7},
  [550] = {.lex_state = 67, .external_lex_state = 7},
  [551] = {.lex_state = 0, .external_lex_state = 6},
  [552] = {.lex_state = 67, .external_lex_state = 7},
  [553] = {.lex_state = 67, .external_lex_state = 6},
  [554] = {.lex_state = 0, .external_lex_state = 6},
  [555] = {.lex_state = 0, .external_lex_state = 6},
  [556] = {.lex_state = 67, .external_lex_state = 6},
  [557] = {.lex_state = 0, .external_lex_state = 6},
  [558] = {.lex_state = 0, .external_lex_state = 6},
  [559] = {.lex_state = 67, .external_lex_state = 6},
  [560] = {.lex_state = 67, .external_lex_state = 7},
  [561] = {.lex_state = 67, .external_lex_state = 8},
  [562] = {.lex_state = 67, .external_lex_state = 7},
  [563] = {.lex_state = 67, .external_lex_state = 7},
  [564] = {.lex_state = 67, .external_lex_state = 6},
  [565] = {.lex_state = 0, .external_lex_state = 6},
  [566] = {.lex_state = 67, .external_lex_state = 6},
  [567] = {.lex_state = 67, .external_lex_state = 6},
  [568] = {.lex_state = 67, .external_lex_state = 6},
  [569] = {.lex_state = 67, .external_lex_state = 6},
  [570] = {.lex_state = 67, .external_lex_state = 6},
  [571] = {.lex_state = 0, .external_lex_state = 6},
  [572] = {.lex_state = 67, .external_lex_state = 6},
  [573] = {.lex_state = 10, .external_lex_state = 10},
  [574] = {.lex_state = 19, .external_lex_state = 9},
  [575] = {.lex_state = 0, .external_lex_state = 6},
  [576] = {.lex_state = 67, .external_lex_state = 6},
  [577] = {.lex_state = 0, .external_lex_state = 7},
  [578] = {.lex_state = 0, .external_lex_state = 6},
  [579] = {.lex_state = 67, .external_lex_state = 6},
  [580] = {.lex_state = 0, .external_lex_state = 8},
  [581] = {.lex_state = 0, .external_lex_state = 8},
  [582] = {.lex_state = 0, .external_lex_state = 8},
  [583] = {.lex_state = 67, .external_lex_state = 6},
  [584] = {.lex_state = 67, .external_lex_state = 6},
  [585] = {.lex_state = 67, .external_lex_state = 7},
  [586] = {.lex_state = 67, .external_lex_state = 6},
  [587] = {.lex_state = 67, .external_lex_state = 6},
  [588] = {.lex_state = 0, .external_lex_state = 8},
  [589] = {.lex_state = 67, .external_lex_state = 8},
  [590] = {.lex_state = 67, .external_lex_state = 7},
  [591] = {.lex_state = 67, .external_lex_state = 7},
  [592] = {.lex_state = 67, .external_lex_state = 6},
  [593] = {.lex_state = 67, .external_lex_state = 7},
  [594] = {.lex_state = 67, .external_lex_state = 7},
  [595] = {.lex_state = 0, .external_lex_state = 8},
  [596] = {.lex_state = 67, .external_lex_state = 8},
  [597] = {.lex_state = 0, .external_lex_state = 6},
  [598] = {.lex_state = 0, .external_lex_state = 8},
  [599] = {.lex_state = 67, .external_lex_state = 6},
  [600] = {.lex_state = 67, .external_lex_state = 8},
  [601] = {.lex_state = 0, .external_lex_state = 6},
  [602] = {.lex_state = 0, .external_lex_state = 6},
  [603] = {.lex_state = 12, .external_lex_state = 6},
  [604] = {.lex_state = 0, .external_lex_state = 6},
  [605] = {.lex_state = 12, .external_lex_state = 6},
  [606] = {.lex_state = 0, .external_lex_state = 6},
  [607] = {.lex_state = 12, .external_lex_state = 6},
  [608] = {.lex_state = 0, .external_lex_state = 6},
  [609] = {.lex_state = 0, .external_lex_state = 6},
  [610] = {.lex_state = 0, .external_lex_state = 6},
  [611] = {.lex_state = 12, .external_lex_state = 6},
  [612] = {.lex_state = 12, .external_lex_state = 6},
  [613] = {.lex_state = 0, .external_lex_state = 6},
  [614] = {.lex_state = 12, .external_lex_state = 6},
  [615] = {.lex_state = 0, .external_lex_state = 6},
  [616] = {.lex_state = 0, .external_lex_state = 6},
  [617] = {.lex_state = 67, .external_lex_state = 8},
  [618] = {.lex_state = 12, .external_lex_state = 6},
  [619] = {.lex_state = 0, .external_lex_state = 6},
  [620] = {.lex_state = 0, .external_lex_state = 6},
  [621] = {.lex_state = 0, .external_lex_state = 6},
  [622] = {.lex_state = 0, .external_lex_state = 8},
  [623] = {.lex_state = 12, .external_lex_state = 6},
  [624] = {.lex_state = 0, .external_lex_state = 6},
  [625] = {.lex_state = 63, .external_lex_state = 6},
  [626] = {.lex_state = 0, .external_lex_state = 6},
  [627] = {.lex_state = 0, .external_lex_state = 6},
  [628] = {.lex_state = 0, .external_lex_state = 6},
  [629] = {.lex_state = 0, .external_lex_state = 6},
  [630] = {.lex_state = 0, .external_lex_state = 6},
  [631] = {.lex_state = 63, .external_lex_state = 6},
  [632] = {.lex_state = 0, .external_lex_state = 6},
  [633] = {.lex_state = 0, .external_lex_state = 6},
  [634] = {.lex_state = 0, .external_lex_state = 6},
  [635] = {.lex_state = 67, .external_lex_state = 7},
  [636] = {.lex_state = 0, .external_lex_state = 6},
  [637] = {.lex_state = 0, .external_lex_state = 6},
  [638] = {.lex_state = 63, .external_lex_state = 6},
  [639] = {.lex_state = 67, .external_lex_state = 6},
  [640] = {.lex_state = 0, .external_lex_state = 6},
  [641] = {.lex_state = 0, .external_lex_state = 8},
  [642] = {.lex_state = 0, .external_lex_state = 6},
  [643] = {.lex_state = 0, .external_lex_state = 6},
  [644] = {.lex_state = 0, .external_lex_state = 6},
  [645] = {.lex_state = 0, .external_lex_state = 8},
  [646] = {.lex_state = 0, .external_lex_state = 6},
  [647] = {.lex_state = 0, .external_lex_state = 6},
  [648] = {.lex_state = 0, .external_lex_state = 6},
  [649] = {.lex_state = 0, .external_lex_state = 6},
  [650] = {.lex_state = 63, .external_lex_state = 6},
  [651] = {.lex_state = 0, .external_lex_state = 6},
  [652] = {.lex_state = 0, .external_lex_state = 6},
  [653] = {.lex_state = 0, .external_lex_state = 6},
  [654] = {.lex_state = 0, .external_lex_state = 6},
  [655] = {.lex_state = 0, .external_lex_state = 6},
  [656] = {.lex_state = 63, .external_lex_state = 6},
  [657] = {.lex_state = 63, .external_lex_state = 6},
  [658] = {.lex_state = 0, .external_lex_state = 6},
  [659] = {.lex_state = 0, .external_lex_state = 6},
  [660] = {.lex_state = 67, .external_lex_state = 6},
  [661] = {.lex_state = 0, .external_lex_state = 6},
  [662] = {.lex_state = 0, .external_lex_state = 6},
  [663] = {.lex_state = 0, .external_lex_state = 6},
  [664] = {.lex_state = 0, .external_lex_state = 6},
  [665] = {.lex_state = 0, .external_lex_state = 6},
  [666] = {.lex_state = 0, .external_lex_state = 6},
  [667] = {.lex_state = 0, .external_lex_state = 6},
  [668] = {.lex_state = 0, .external_lex_state = 6},
  [669] = {.lex_state = 63, .external_lex_state = 6},
  [670] = {.lex_state = 0, .external_lex_state = 6},
  [671] = {.lex_state = 0, .external_lex_state = 6},
  [672] = {.lex_state = 0, .external_lex_state = 6},
  [673] = {.lex_state = 63, .external_lex_state = 6},
  [674] = {.lex_state = 67, .external_lex_state = 6},
  [675] = {.lex_state = 67, .external_lex_state = 7},
  [676] = {.lex_state = 0, .external_lex_state = 6},
  [677] = {.lex_state = 0, .external_lex_state = 6},
  [678] = {.lex_state = 0, .external_lex_state = 8},
  [679] = {.lex_state = 67, .external_lex_state = 7},
  [680] = {.lex_state = 0, .external_lex_state = 6},
  [681] = {.lex_state = 0, .external_lex_state = 6},
  [682] = {.lex_state = 0, .external_lex_state = 6},
  [683] = {.lex_state = 0, .external_lex_state = 6},
  [684] = {.lex_state = 0, .external_lex_state = 6},
  [685] = {.lex_state = 63, .external_lex_state = 6},
  [686] = {.lex_state = 0, .external_lex_state = 6},
  [687] = {.lex_state = 0, .external_lex_state = 6},
  [688] = {.lex_state = 0, .external_lex_state = 6},
  [689] = {.lex_state = 0, .external_lex_state = 8},
  [690] = {.lex_state = 63, .external_lex_state = 6},
  [691] = {.lex_state = 0, .external_lex_state = 6},
  [692] = {.lex_state = 0, .external_lex_state = 6},
  [693] = {.lex_state = 67, .external_lex_state = 6},
  [694] = {.lex_state = 0, .external_lex_state = 6},
  [695] = {.lex_state = 0, .external_lex_state = 6},
  [696] = {.lex_state = 0, .external_lex_state = 6},
  [697] = {.lex_state = 0, .external_lex_state = 6},
  [698] = {.lex_state = 0, .external_lex_state = 6},
  [699] = {.lex_state = 0, .external_lex_state = 6},
  [700] = {.lex_state = 0, .external_lex_state = 6},
  [701] = {.lex_state = 0, .external_lex_state = 6},
  [702] = {.lex_state = 0, .external_lex_state = 6},
  [703] = {.lex_state = 63, .external_lex_state = 6},
  [704] = {.lex_state = 0, .external_lex_state = 6},
  [705] = {.lex_state = 0, .external_lex_state = 6},
  [706] = {.lex_state = 67, .external_lex_state = 6},
  [707] = {.lex_state = 67, .external_lex_state = 6},
  [708] = {.lex_state = 0, .external_lex_state = 6},
  [709] = {.lex_state = 0, .external_lex_state = 6},
  [710] = {.lex_state = 0, .external_lex_state = 6},
  [711] = {.lex_state = 63, .external_lex_state = 6},
  [712] = {.lex_state = 0, .external_lex_state = 7},
  [713] = {.lex_state = 0, .external_lex_state = 6},
  [714] = {.lex_state = 0, .external_lex_state = 6},
  [715] = {.lex_state = 0, .external_lex_state = 6},
  [716] = {.lex_state = 0, .external_lex_state = 6},
  [717] = {.lex_state = 0, .external_lex_state = 6},
  [718] = {.lex_state = 0, .external_lex_state = 6},
  [719] = {.lex_state = 0, .external_lex_state = 6},
  [720] = {.lex_state = 0, .external_lex_state = 6},
  [721] = {.lex_state = 0, .external_lex_state = 6},
  [722] = {.lex_state = 0, .external_lex_state = 6},
  [723] = {.lex_state = 0, .external_lex_state = 6},
  [724] = {.lex_state = 0, .external_lex_state = 6},
  [725] = {.lex_state = 0, .external_lex_state = 6},
  [726] = {.lex_state = 0, .external_lex_state = 6},
  [727] = {.lex_state = 63, .external_lex_state = 6},
  [728] = {.lex_state = 0, .external_lex_state = 6},
  [729] = {.lex_state = 0, .external_lex_state = 6},
  [730] = {.lex_state = 0, .external_lex_state = 6},
  [731] = {.lex_state = 0, .external_lex_state = 7},
  [732] = {.lex_state = 0, .external_lex_state = 6},
  [733] = {.lex_state = 0, .external_lex_state = 6},
  [734] = {.lex_state = 0, .external_lex_state = 6},
  [735] = {.lex_state = 0, .external_lex_state = 6},
  [736] = {.lex_state = 67, .external_lex_state = 6},
  [737] = {.lex_state = 0, .external_lex_state = 6},
  [738] = {.lex_state = 0, .external_lex_state = 6},
  [739] = {.lex_state = 0, .external_lex_state = 6},
  [740] = {.lex_state = 0, .external_lex_state = 6},
  [741] = {.lex_state = 0, .external_lex_state = 6},
  [742] = {.lex_state = 67, .external_lex_state = 6},
  [743] = {.lex_state = 0, .external_lex_state = 6},
  [744] = {.lex_state = 67, .external_lex_state = 6},
  [745] = {.lex_state = 67, .external_lex_state = 6},
  [746] = {.lex_state = 0, .external_lex_state = 6},
  [747] = {.lex_state = 0, .external_lex_state = 6},
  [748] = {.lex_state = 0, .external_lex_state = 6},
  [749] = {.lex_state = 0, .external_lex_state = 6},
  [750] = {.lex_state = 0, .external_lex_state = 6},
  [751] = {.lex_state = 0, .external_lex_state = 6},
  [752] = {.lex_state = 0, .external_lex_state = 6},
  [753] = {.lex_state = 0, .external_lex_state = 6},
  [754] = {.lex_state = 0, .external_lex_state = 6},
  [755] = {.lex_state = 0, .external_lex_state = 6},
  [756] = {.lex_state = 0, .external_lex_state = 6},
  [757] = {.lex_state = 0, .external_lex_state = 6},
  [758] = {.lex_state = 0, .external_lex_state = 6},
  [759] = {.lex_state = 0, .external_lex_state = 6},
  [760] = {.lex_state = 0, .external_lex_state = 6},
  [761] = {.lex_state = 67, .external_lex_state = 7},
  [762] = {.lex_state = 0, .external_lex_state = 6},
  [763] = {.lex_state = 0, .external_lex_state = 6},
  [764] = {.lex_state = 0, .external_lex_state = 6},
  [765] = {.lex_state = 0, .external_lex_state = 6},
  [766] = {.lex_state = 0, .external_lex_state = 6},
  [767] = {.lex_state = 0, .external_lex_state = 8},
  [768] = {.lex_state = 0, .external_lex_state = 6},
  [769] = {.lex_state = 0, .external_lex_state = 6},
  [770] = {.lex_state = 0, .external_lex_state = 6},
  [771] = {.lex_state = 0, .external_lex_state = 6},
  [772] = {.lex_state = 0, .external_lex_state = 6},
  [773] = {.lex_state = 0, .external_lex_state = 6},
  [774] = {.lex_state = 0, .external_lex_state = 11},
  [775] = {.lex_state = 0, .external_lex_state = 6},
  [776] = {.lex_state = 0, .external_lex_state = 6},
  [777] = {.lex_state = 0, .external_lex_state = 8},
  [778] = {.lex_state = 0, .external_lex_state = 11},
  [779] = {.lex_state = 0, .external_lex_state = 6},
  [780] = {.lex_state = 0, .external_lex_state = 6},
  [781] = {.lex_state = 67, .external_lex_state = 6},
  [782] = {.lex_state = 0, .external_lex_state = 8},
  [783] = {.lex_state = 67, .external_lex_state = 7},
  [784] = {.lex_state = 0, .external_lex_state = 11},
  [785] = {.lex_state = 0, .external_lex_state = 8},
  [786] = {.lex_state = 0, .external_lex_state = 6},
  [787] = {.lex_state = 0, .external_lex_state = 6},
  [788] = {.lex_state = 0, .external_lex_state = 6},
  [789] = {.lex_state = 0, .external_lex_state = 6},
  [790] = {.lex_state = 67, .external_lex_state = 6},
  [791] = {.lex_state = 0, .external_lex_state = 6},
  [792] = {.lex_state = 0, .external_lex_state = 8},
  [793] = {.lex_state = 63, .external_lex_state = 6},
  [794] = {.lex_state = 0, .external_lex_state = 6},
  [795] = {.lex_state = 0, .external_lex_state = 6},
  [796] = {.lex_state = 0, .external_lex_state = 6},
  [797] = {.lex_state = 0, .external_lex_state = 6},
  [798] = {.lex_state = 0, .external_lex_state = 6},
  [799] = {.lex_state = 0, .external_lex_state = 11},
  [800] = {.lex_state = 0, .external_lex_state = 6},
  [801] = {.lex_state = 67, .external_lex_state = 6},
  [802] = {.lex_state = 67, .external_lex_state = 7},
  [803] = {.lex_state = 0, .external_lex_state = 6},
  [804] = {.lex_state = 0, .external_lex_state = 6},
  [805] = {.lex_state = 67, .external_lex_state = 6},
  [806] = {.lex_state = 0, .external_lex_state = 11},
  [807] = {.lex_state = 0, .external_lex_state = 6},
  [808] = {.lex_state = 0, .external_lex_state = 6},
  [809] = {.lex_state = 0, .external_lex_state = 6},
  [810] = {.lex_state = 0, .external_lex_state = 6},
  [811] = {.lex_state = 67, .external_lex_state = 6},
  [812] = {.lex_state = 0, .external_lex_state = 6},
  [813] = {.lex_state = 0, .external_lex_state = 6},
  [814] = {.lex_state = 0, .external_lex_state = 6},
  [815] = {.lex_state = 0, .external_lex_state = 8},
  [816] = {.lex_state = 0, .external_lex_state = 6},
  [817] = {.lex_state = 67, .external_lex_state = 6},
  [818] = {.lex_state = 0, .external_lex_state = 6},
  [819] = {.lex_state = 0, .external_lex_state = 6},
  [820] = {.lex_state = 0, .external_lex_state = 6},
  [821] = {.lex_state = 0, .external_lex_state = 6},
  [822] = {.lex_state = 0, .external_lex_state = 11},
  [823] = {.lex_state = 67, .external_lex_state = 6},
  [824] = {.lex_state = 0, .external_lex_state = 6},
  [825] = {.lex_state = 0, .external_lex_state = 6},
  [826] = {.lex_state = 0, .external_lex_state = 6},
  [827] = {.lex_state = 0, .external_lex_state = 6},
  [828] = {.lex_state = 67, .external_lex_state = 6},
  [829] = {.lex_state = 63, .external_lex_state = 6},
  [830] = {.lex_state = 0, .external_lex_state = 7},
  [831] = {.lex_state = 0, .external_lex_state = 6},
  [832] = {.lex_state = 63, .external_lex_state = 6},
  [833] = {.lex_state = 22, .external_lex_state = 6},
  [834] = {.lex_state = 63, .external_lex_state = 6},
  [835] = {.lex_state = 0, .external_lex_state = 6},
  [836] = {.lex_state = 0, .external_lex_state = 6},
  [837] = {.lex_state = 0, .external_lex_state = 12},
  [838] = {.lex_state = 0, .external_lex_state = 6},
  [839] = {.lex_state = 0, .external_lex_state = 6},
  [840] = {.lex_state = 0, .external_lex_state = 6},
  [841] = {.lex_state = 22, .external_lex_state = 6},
  [842] = {.lex_state = 0, .external_lex_state = 12},
  [843] = {.lex_state = 0, .external_lex_state = 6},
  [844] = {.lex_state = 67, .external_lex_state = 6},
  [845] = {.lex_state = 67, .external_lex_state = 6},
  [846] = {.lex_state = 0, .external_lex_state = 7},
  [847] = {.lex_state = 0, .external_lex_state = 6},
  [848] = {.lex_state = 0, .external_lex_state = 6},
  [849] = {.lex_state = 0, .external_lex_state = 12},
  [850] = {.lex_state = 0, .external_lex_state = 7},
  [851] = {.lex_state = 63, .external_lex_state = 6},
  [852] = {.lex_state = 0, .external_lex_state = 7},
  [853] = {.lex_state = 0, .external_lex_state = 7},
  [854] = {.lex_state = 0, .external_lex_state = 6},
  [855] = {.lex_state = 63, .external_lex_state = 6},
  [856] = {.lex_state = 0, .external_lex_state = 6},
  [857] = {.lex_state = 0, .external_lex_state = 6},
  [858] = {.lex_state = 22, .external_lex_state = 6},
  [859] = {.lex_state = 0, .external_lex_state = 6},
  [860] = {.lex_state = 22, .external_lex_state = 6},
  [861] = {.lex_state = 63, .external_lex_state = 6},
  [862] = {.lex_state = 0, .external_lex_state = 6},
  [863] = {.lex_state = 0, .external_lex_state = 6},
  [864] = {.lex_state = 0, .external_lex_state = 7},
  [865] = {.lex_state = 0, .external_lex_state = 6},
  [866] = {.lex_state = 0, .external_lex_state = 7},
  [867] = {.lex_state = 63, .external_lex_state = 6},
  [868] = {.lex_state = 67, .external_lex_state = 6},
  [869] = {.lex_state = 0, .external_lex_state = 12},
  [870] = {.lex_state = 0, .external_lex_state = 6},
  [871] = {.lex_state = 0, .external_lex_state = 6},
  [872] = {.lex_state = 0, .external_lex_state = 6},
  [873] = {.lex_state = 0, .external_lex_state = 6},
  [874] = {.lex_state = 0, .external_lex_state = 6},
  [875] = {.lex_state = 0, .external_lex_state = 7},
  [876] = {.lex_state = 0, .external_lex_state = 6},
  [877] = {.lex_state = 0, .external_lex_state = 6},
  [878] = {.lex_state = 63, .external_lex_state = 6},
  [879] = {.lex_state = 0, .external_lex_state = 12},
  [880] = {.lex_state = 67, .external_lex_state = 6},
  [881] = {.lex_state = 0, .external_lex_state = 6},
  [882] = {.lex_state = 0, .external_lex_state = 6},
  [883] = {.lex_state = 0, .external_lex_state = 7},
  [884] = {.lex_state = 0, .external_lex_state = 6},
  [885] = {.lex_state = 67, .external_lex_state = 6},
  [886] = {.lex_state = 0, .external_lex_state = 13},
  [887] = {.lex_state = 0, .external_lex_state = 13},
  [888] = {.lex_state = 63, .external_lex_state = 6},
  [889] = {.lex_state = 22, .external_lex_state = 6},
  [890] = {.lex_state = 67, .external_lex_state = 6},
  [891] = {.lex_state = 0, .external_lex_state = 6},
  [892] = {.lex_state = 0, .external_lex_state = 6},
  [893] = {.lex_state = 67, .external_lex_state = 6},
  [894] = {.lex_state = 67, .external_lex_state = 6},
  [895] = {.lex_state = 0, .external_lex_state = 6},
  [896] = {.lex_state = 0, .external_lex_state = 7},
  [897] = {.lex_state = 0, .external_lex_state = 7},
  [898] = {.lex_state = 0, .external_lex_state = 13},
  [899] = {.lex_state = 63, .external_lex_state = 6},
  [900] = {.lex_state = 0, .external_lex_state = 6},
  [901] = {.lex_state = 0, .external_lex_state = 7},
  [902] = {.lex_state = 63, .external_lex_state = 6},
  [903] = {.lex_state = 0, .external_lex_state = 11},
  [904] = {.lex_state = 0, .external_lex_state = 6},
  [905] = {.lex_state = 63, .external_lex_state = 6},
  [906] = {.lex_state = 0, .external_lex_state = 13},
  [907] = {.lex_state = 0, .external_lex_state = 7},
  [908] = {.lex_state = 0, .external_lex_state = 7},
  [909] = {.lex_state = 0, .external_lex_state = 6},
  [910] = {.lex_state = 23, .external_lex_state = 6},
  [911] = {.lex_state = 67, .external_lex_state = 6},
  [912] = {.lex_state = 0, .external_lex_state = 6},
  [913] = {.lex_state = 0, .external_lex_state = 13},
  [914] = {.lex_state = 0, .external_lex_state = 7},
  [915] = {.lex_state = 0, .external_lex_state = 6},
  [916] = {.lex_state = 0, .external_lex_state = 6},
  [917] = {.lex_state = 0, .external_lex_state = 7},
  [918] = {.lex_state = 0, .external_lex_state = 6},
  [919] = {.lex_state = 0, .external_lex_state = 13},
  [920] = {.lex_state = 0, .external_lex_state = 12},
  [921] = {.lex_state = 22, .external_lex_state = 6},
  [922] = {.lex_state = 67, .external_lex_state = 6},
  [923] = {.lex_state = 0, .external_lex_state = 7},
  [924] = {.lex_state = 0, .external_lex_state = 6},
};

enum {
  ts_external_token__virtual_end_decl = 0,
  ts_external_token__virtual_open_section = 1,
  ts_external_token__virtual_end_section = 2,
  ts_external_token_minus_without_trailing_whitespace = 3,
  ts_external_token_block_comment = 4,
  ts_external_token_line_comment = 5,
  ts_external_token_open_quote = 6,
  ts_external_token_close_quote = 7,
  ts_external_token_open_quote_multiline = 8,
  ts_external_token_close_quote_multiline = 9,
  ts_external_token_glsl_content = 10,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__virtual_end_decl] = sym__virtual_end_decl,
  [ts_external_token__virtual_open_section] = sym__virtual_open_section,
  [ts_external_token__virtual_end_section] = sym__virtual_end_section,
  [ts_external_token_minus_without_trailing_whitespace] = sym_minus_without_trailing_whitespace,
  [ts_external_token_block_comment] = sym_block_comment,
  [ts_external_token_line_comment] = sym_line_comment,
  [ts_external_token_open_quote] = sym_open_quote,
  [ts_external_token_close_quote] = sym_close_quote,
  [ts_external_token_open_quote_multiline] = sym_open_quote_multiline,
  [ts_external_token_close_quote_multiline] = sym_close_quote_multiline,
  [ts_external_token_glsl_content] = sym_glsl_content,
};

static bool ts_external_scanner_states[14][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token__virtual_open_section] = true,
    [ts_external_token__virtual_end_section] = true,
    [ts_external_token_minus_without_trailing_whitespace] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_open_quote] = true,
    [ts_external_token_close_quote] = true,
    [ts_external_token_open_quote_multiline] = true,
    [ts_external_token_close_quote_multiline] = true,
    [ts_external_token_glsl_content] = true,
  },
  [2] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_open_quote] = true,
    [ts_external_token_open_quote_multiline] = true,
  },
  [3] = {
    [ts_external_token_minus_without_trailing_whitespace] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_open_quote] = true,
    [ts_external_token_open_quote_multiline] = true,
  },
  [4] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token__virtual_end_section] = true,
    [ts_external_token_minus_without_trailing_whitespace] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_open_quote] = true,
    [ts_external_token_open_quote_multiline] = true,
  },
  [5] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token_minus_without_trailing_whitespace] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_open_quote] = true,
    [ts_external_token_open_quote_multiline] = true,
  },
  [6] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [7] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [8] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token__virtual_end_section] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [9] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_close_quote_multiline] = true,
  },
  [10] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_close_quote] = true,
  },
  [11] = {
    [ts_external_token__virtual_open_section] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [12] = {
    [ts_external_token__virtual_end_section] = true,
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [13] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_glsl_content] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_lower_case_identifier] = ACTIONS(1),
    [sym__upper_case_identifier_without_leading_whitespace] = ACTIONS(1),
    [sym__dot_without_leading_whitespace] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_left] = ACTIONS(1),
    [anon_sym_right] = ACTIONS(1),
    [anon_sym_non] = ACTIONS(1),
    [aux_sym_number_literal_token1] = ACTIONS(1),
    [sym__hex_literal] = ACTIONS(1),
    [aux_sym_regular_string_part_token2] = ACTIONS(1),
    [sym_string_escape] = ACTIONS(1),
    [sym_module] = ACTIONS(1),
    [sym_effect] = ACTIONS(1),
    [sym_where] = ACTIONS(1),
    [sym_import] = ACTIONS(1),
    [sym_as] = ACTIONS(1),
    [sym_exposing] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [sym_case] = ACTIONS(1),
    [sym_of] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [sym_type] = ACTIONS(1),
    [sym_alias] = ACTIONS(1),
    [sym_port] = ACTIONS(1),
    [sym_infix] = ACTIONS(1),
    [sym_left_parenthesis] = ACTIONS(1),
    [sym_right_parenthesis] = ACTIONS(1),
    [sym_left_square_bracket] = ACTIONS(1),
    [sym_right_square_bracket] = ACTIONS(1),
    [sym_left_brace] = ACTIONS(1),
    [sym_right_brace] = ACTIONS(1),
    [sym_double_dot] = ACTIONS(1),
    [sym_comma] = ACTIONS(1),
    [sym_eq] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_pipe] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_dot] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_LT_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_QMARK_GT] = ACTIONS(1),
    [anon_sym_PIPE_DOT] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [sym_glsl_begin] = ACTIONS(1),
    [sym_glsl_end] = ACTIONS(1),
    [sym__char_quote] = ACTIONS(1),
    [sym__virtual_end_decl] = ACTIONS(1),
    [sym__virtual_open_section] = ACTIONS(1),
    [sym__virtual_end_section] = ACTIONS(1),
    [sym_minus_without_trailing_whitespace] = ACTIONS(1),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(1),
    [sym_close_quote] = ACTIONS(1),
    [sym_open_quote_multiline] = ACTIONS(1),
    [sym_close_quote_multiline] = ACTIONS(1),
    [sym_glsl_content] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(904),
    [sym_module_declaration] = STATE(901),
    [aux_sym__import_list] = STATE(100),
    [aux_sym__top_decl_list] = STATE(134),
    [sym_upper_case_qid] = STATE(239),
    [sym_import_clause] = STATE(897),
    [sym__declaration] = STATE(896),
    [sym_value_declaration] = STATE(896),
    [sym__internal_value_declaration_left] = STATE(894),
    [sym_function_declaration_left] = STATE(893),
    [sym_type_declaration] = STATE(896),
    [sym_type_alias_declaration] = STATE(896),
    [sym_type_annotation] = STATE(896),
    [sym_port_annotation] = STATE(896),
    [sym__literal_expr_group] = STATE(528),
    [sym_char_constant_expr] = STATE(528),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(528),
    [sym_string_constant_expr] = STATE(528),
    [sym_unit_expr] = STATE(528),
    [sym_pattern] = STATE(885),
    [sym_cons_pattern] = STATE(530),
    [sym__single_pattern_cons] = STATE(771),
    [sym__single_pattern] = STATE(544),
    [sym__parenthesized_single_pattern] = STATE(566),
    [sym_lower_pattern] = STATE(528),
    [sym_anything_pattern] = STATE(528),
    [sym_record_pattern] = STATE(528),
    [sym_list_pattern] = STATE(528),
    [sym_union_pattern] = STATE(528),
    [sym_tuple_pattern] = STATE(528),
    [sym__parenthesized_pattern] = STATE(771),
    [sym_infix_declaration] = STATE(896),
    [sym_number_literal] = STATE(249),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_lower_case_identifier] = ACTIONS(7),
    [sym_upper_case_identifier] = ACTIONS(9),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(13),
    [sym_module] = ACTIONS(15),
    [sym_effect] = ACTIONS(17),
    [sym_import] = ACTIONS(19),
    [sym_type] = ACTIONS(21),
    [sym_port] = ACTIONS(23),
    [sym_infix] = ACTIONS(25),
    [sym_left_parenthesis] = ACTIONS(27),
    [sym_left_square_bracket] = ACTIONS(29),
    [sym_left_brace] = ACTIONS(31),
    [sym_underscore] = ACTIONS(33),
    [sym__char_quote] = ACTIONS(35),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [2] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(3),
    [sym_operator_as_function_expr] = STATE(3),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__atom] = STATE(3),
    [sym_field_access_expr] = STATE(71),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(3),
    [sym_parenthesized_expr] = STATE(71),
    [sym__literal_expr_group] = STATE(3),
    [sym_char_constant_expr] = STATE(3),
    [sym_open_char] = STATE(607),
    [sym_number_constant_expr] = STATE(3),
    [sym_string_constant_expr] = STATE(3),
    [sym_anonymous_function_expr] = STATE(3),
    [sym_value_expr] = STATE(71),
    [sym_tuple_expr] = STATE(3),
    [sym_unit_expr] = STATE(3),
    [sym_list_expr] = STATE(3),
    [sym_record_expr] = STATE(71),
    [sym_if_else_expr] = STATE(3),
    [sym_case_of_expr] = STATE(3),
    [sym_let_in_expr] = STATE(3),
    [sym_glsl_code_expr] = STATE(3),
    [sym_number_literal] = STATE(106),
    [sym__if] = STATE(754),
    [sym__let] = STATE(794),
    [aux_sym_function_call_expr_repeat1] = STATE(3),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_else] = ACTIONS(44),
    [anon_sym_COLON_COLON] = ACTIONS(44),
    [sym_upper_case_identifier] = ACTIONS(46),
    [aux_sym_number_literal_token1] = ACTIONS(49),
    [sym__hex_literal] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(52),
    [anon_sym_then] = ACTIONS(44),
    [sym_case] = ACTIONS(55),
    [sym_of] = ACTIONS(44),
    [anon_sym_let] = ACTIONS(58),
    [sym_left_parenthesis] = ACTIONS(61),
    [sym_right_parenthesis] = ACTIONS(44),
    [sym_left_square_bracket] = ACTIONS(64),
    [sym_right_square_bracket] = ACTIONS(44),
    [sym_left_brace] = ACTIONS(67),
    [sym_right_brace] = ACTIONS(44),
    [sym_comma] = ACTIONS(44),
    [sym_backslash] = ACTIONS(70),
    [sym_dot] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(44),
    [anon_sym_DASH] = ACTIONS(44),
    [anon_sym_STAR] = ACTIONS(44),
    [anon_sym_SLASH] = ACTIONS(44),
    [anon_sym_SLASH_SLASH] = ACTIONS(44),
    [anon_sym_CARET] = ACTIONS(44),
    [anon_sym_EQ_EQ] = ACTIONS(44),
    [anon_sym_SLASH_EQ] = ACTIONS(44),
    [anon_sym_LT] = ACTIONS(44),
    [anon_sym_GT] = ACTIONS(44),
    [anon_sym_LT_EQ] = ACTIONS(44),
    [anon_sym_GT_EQ] = ACTIONS(44),
    [anon_sym_AMP_AMP] = ACTIONS(44),
    [anon_sym_PIPE_PIPE] = ACTIONS(44),
    [anon_sym_PLUS_PLUS] = ACTIONS(44),
    [anon_sym_LT_PIPE] = ACTIONS(44),
    [anon_sym_PIPE_GT] = ACTIONS(44),
    [anon_sym_LT_LT] = ACTIONS(44),
    [anon_sym_GT_GT] = ACTIONS(44),
    [anon_sym_LT_SLASH_GT] = ACTIONS(44),
    [anon_sym_LT_QMARK_GT] = ACTIONS(44),
    [anon_sym_PIPE_DOT] = ACTIONS(44),
    [anon_sym_PIPE_EQ] = ACTIONS(44),
    [sym_glsl_begin] = ACTIONS(76),
    [sym__char_quote] = ACTIONS(79),
    [sym_minus_without_trailing_whitespace] = ACTIONS(82),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(85),
    [sym_open_quote_multiline] = ACTIONS(88),
  },
  [3] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(3),
    [sym_operator_as_function_expr] = STATE(3),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__atom] = STATE(3),
    [sym_field_access_expr] = STATE(71),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(3),
    [sym_parenthesized_expr] = STATE(71),
    [sym__literal_expr_group] = STATE(3),
    [sym_char_constant_expr] = STATE(3),
    [sym_open_char] = STATE(607),
    [sym_number_constant_expr] = STATE(3),
    [sym_string_constant_expr] = STATE(3),
    [sym_anonymous_function_expr] = STATE(3),
    [sym_value_expr] = STATE(71),
    [sym_tuple_expr] = STATE(3),
    [sym_unit_expr] = STATE(3),
    [sym_list_expr] = STATE(3),
    [sym_record_expr] = STATE(71),
    [sym_if_else_expr] = STATE(3),
    [sym_case_of_expr] = STATE(3),
    [sym_let_in_expr] = STATE(3),
    [sym_glsl_code_expr] = STATE(3),
    [sym_number_literal] = STATE(106),
    [sym__if] = STATE(754),
    [sym__let] = STATE(794),
    [aux_sym_function_call_expr_repeat1] = STATE(3),
    [sym_lower_case_identifier] = ACTIONS(91),
    [anon_sym_else] = ACTIONS(94),
    [anon_sym_COLON_COLON] = ACTIONS(94),
    [sym_upper_case_identifier] = ACTIONS(96),
    [aux_sym_number_literal_token1] = ACTIONS(99),
    [sym__hex_literal] = ACTIONS(99),
    [anon_sym_if] = ACTIONS(102),
    [anon_sym_then] = ACTIONS(94),
    [sym_case] = ACTIONS(105),
    [sym_of] = ACTIONS(94),
    [anon_sym_let] = ACTIONS(108),
    [sym_left_parenthesis] = ACTIONS(111),
    [sym_right_parenthesis] = ACTIONS(94),
    [sym_left_square_bracket] = ACTIONS(114),
    [sym_right_square_bracket] = ACTIONS(94),
    [sym_left_brace] = ACTIONS(117),
    [sym_right_brace] = ACTIONS(94),
    [sym_comma] = ACTIONS(94),
    [sym_backslash] = ACTIONS(120),
    [sym_dot] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(94),
    [anon_sym_DASH] = ACTIONS(94),
    [anon_sym_STAR] = ACTIONS(94),
    [anon_sym_SLASH] = ACTIONS(94),
    [anon_sym_SLASH_SLASH] = ACTIONS(94),
    [anon_sym_CARET] = ACTIONS(94),
    [anon_sym_EQ_EQ] = ACTIONS(94),
    [anon_sym_SLASH_EQ] = ACTIONS(94),
    [anon_sym_LT] = ACTIONS(94),
    [anon_sym_GT] = ACTIONS(94),
    [anon_sym_LT_EQ] = ACTIONS(94),
    [anon_sym_GT_EQ] = ACTIONS(94),
    [anon_sym_AMP_AMP] = ACTIONS(94),
    [anon_sym_PIPE_PIPE] = ACTIONS(94),
    [anon_sym_PLUS_PLUS] = ACTIONS(94),
    [anon_sym_LT_PIPE] = ACTIONS(94),
    [anon_sym_PIPE_GT] = ACTIONS(94),
    [anon_sym_LT_LT] = ACTIONS(94),
    [anon_sym_GT_GT] = ACTIONS(94),
    [anon_sym_LT_SLASH_GT] = ACTIONS(94),
    [anon_sym_LT_QMARK_GT] = ACTIONS(94),
    [anon_sym_PIPE_DOT] = ACTIONS(94),
    [anon_sym_PIPE_EQ] = ACTIONS(94),
    [sym_glsl_begin] = ACTIONS(126),
    [sym__char_quote] = ACTIONS(129),
    [sym_minus_without_trailing_whitespace] = ACTIONS(132),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(135),
    [sym_open_quote_multiline] = ACTIONS(138),
  },
  [4] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(3),
    [sym_operator_as_function_expr] = STATE(3),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__atom] = STATE(3),
    [sym_field_access_expr] = STATE(71),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(3),
    [sym_parenthesized_expr] = STATE(71),
    [sym__literal_expr_group] = STATE(3),
    [sym_char_constant_expr] = STATE(3),
    [sym_open_char] = STATE(607),
    [sym_number_constant_expr] = STATE(3),
    [sym_string_constant_expr] = STATE(3),
    [sym_anonymous_function_expr] = STATE(3),
    [sym_value_expr] = STATE(71),
    [sym_tuple_expr] = STATE(3),
    [sym_unit_expr] = STATE(3),
    [sym_list_expr] = STATE(3),
    [sym_record_expr] = STATE(71),
    [sym_if_else_expr] = STATE(3),
    [sym_case_of_expr] = STATE(3),
    [sym_let_in_expr] = STATE(3),
    [sym_glsl_code_expr] = STATE(3),
    [sym_number_literal] = STATE(106),
    [sym__if] = STATE(754),
    [sym__let] = STATE(794),
    [aux_sym_function_call_expr_repeat1] = STATE(3),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_else] = ACTIONS(44),
    [anon_sym_COLON_COLON] = ACTIONS(44),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(145),
    [sym__hex_literal] = ACTIONS(145),
    [anon_sym_if] = ACTIONS(147),
    [anon_sym_then] = ACTIONS(44),
    [sym_case] = ACTIONS(149),
    [sym_of] = ACTIONS(44),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(153),
    [sym_right_parenthesis] = ACTIONS(44),
    [sym_left_square_bracket] = ACTIONS(155),
    [sym_right_square_bracket] = ACTIONS(44),
    [sym_left_brace] = ACTIONS(157),
    [sym_right_brace] = ACTIONS(44),
    [sym_comma] = ACTIONS(44),
    [sym_backslash] = ACTIONS(159),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(44),
    [anon_sym_DASH] = ACTIONS(44),
    [anon_sym_STAR] = ACTIONS(44),
    [anon_sym_SLASH] = ACTIONS(44),
    [anon_sym_SLASH_SLASH] = ACTIONS(44),
    [anon_sym_CARET] = ACTIONS(44),
    [anon_sym_EQ_EQ] = ACTIONS(44),
    [anon_sym_SLASH_EQ] = ACTIONS(44),
    [anon_sym_LT] = ACTIONS(44),
    [anon_sym_GT] = ACTIONS(44),
    [anon_sym_LT_EQ] = ACTIONS(44),
    [anon_sym_GT_EQ] = ACTIONS(44),
    [anon_sym_AMP_AMP] = ACTIONS(44),
    [anon_sym_PIPE_PIPE] = ACTIONS(44),
    [anon_sym_PLUS_PLUS] = ACTIONS(44),
    [anon_sym_LT_PIPE] = ACTIONS(44),
    [anon_sym_PIPE_GT] = ACTIONS(44),
    [anon_sym_LT_LT] = ACTIONS(44),
    [anon_sym_GT_GT] = ACTIONS(44),
    [anon_sym_LT_SLASH_GT] = ACTIONS(44),
    [anon_sym_LT_QMARK_GT] = ACTIONS(44),
    [anon_sym_PIPE_DOT] = ACTIONS(44),
    [anon_sym_PIPE_EQ] = ACTIONS(44),
    [sym_glsl_begin] = ACTIONS(163),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(167),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(169),
    [sym_open_quote_multiline] = ACTIONS(171),
  },
  [5] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(624),
    [sym_bin_op_expr] = STATE(624),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(877),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(179),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [6] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(627),
    [sym_bin_op_expr] = STATE(627),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(857),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(191),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [7] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(713),
    [sym_bin_op_expr] = STATE(713),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(900),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(193),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [8] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(619),
    [sym_bin_op_expr] = STATE(619),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(836),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(195),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [9] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(672),
    [sym_bin_op_expr] = STATE(672),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(915),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(197),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [10] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(701),
    [sym_bin_op_expr] = STATE(701),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(865),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(197),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [11] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(655),
    [sym_bin_op_expr] = STATE(655),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(865),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(199),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [12] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(636),
    [sym_bin_op_expr] = STATE(636),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(877),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(191),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [13] = {
    [sym_upper_case_qid] = STATE(75),
    [sym_value_qid] = STATE(75),
    [sym_field_accessor_function_expr] = STATE(107),
    [sym__expression] = STATE(653),
    [sym_bin_op_expr] = STATE(653),
    [sym_operator_as_function_expr] = STATE(107),
    [sym__operator_as_function_inner] = STATE(95),
    [sym__call_or_atom] = STATE(240),
    [sym_function_call_expr] = STATE(240),
    [sym__function_call_target] = STATE(117),
    [sym__atom] = STATE(240),
    [sym_field_access_expr] = STATE(67),
    [sym__field_access_start] = STATE(707),
    [sym_negate_expr] = STATE(240),
    [sym_parenthesized_expr] = STATE(67),
    [sym__literal_expr_group] = STATE(240),
    [sym_char_constant_expr] = STATE(240),
    [sym_open_char] = STATE(618),
    [sym_number_constant_expr] = STATE(240),
    [sym_string_constant_expr] = STATE(240),
    [sym_anonymous_function_expr] = STATE(240),
    [sym_value_expr] = STATE(67),
    [sym_tuple_expr] = STATE(240),
    [sym_unit_expr] = STATE(240),
    [sym_list_expr] = STATE(240),
    [sym_record_expr] = STATE(265),
    [sym_if_else_expr] = STATE(240),
    [sym_case_of_expr] = STATE(240),
    [sym_let_in_expr] = STATE(240),
    [sym_glsl_code_expr] = STATE(240),
    [sym_number_literal] = STATE(249),
    [sym__if] = STATE(769),
    [sym__let] = STATE(758),
    [sym_operator_identifier] = STATE(836),
    [sym_lower_case_identifier] = ACTIONS(141),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [sym_upper_case_identifier] = ACTIONS(143),
    [aux_sym_number_literal_token1] = ACTIONS(11),
    [sym__hex_literal] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(175),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(177),
    [sym_right_parenthesis] = ACTIONS(193),
    [sym_left_square_bracket] = ACTIONS(181),
    [sym_left_brace] = ACTIONS(183),
    [sym_backslash] = ACTIONS(185),
    [sym_dot] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(173),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_SLASH_EQ] = ACTIONS(173),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_AMP_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(173),
    [anon_sym_PLUS_PLUS] = ACTIONS(173),
    [anon_sym_LT_PIPE] = ACTIONS(173),
    [anon_sym_PIPE_GT] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_LT_SLASH_GT] = ACTIONS(173),
    [anon_sym_LT_QMARK_GT] = ACTIONS(173),
    [anon_sym_PIPE_DOT] = ACTIONS(173),
    [anon_sym_PIPE_EQ] = ACTIONS(173),
    [sym_glsl_begin] = ACTIONS(187),
    [sym__char_quote] = ACTIONS(165),
    [sym_minus_without_trailing_whitespace] = ACTIONS(189),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(37),
    [sym_open_quote_multiline] = ACTIONS(39),
  },
  [14] = {
    [sym_upper_case_qid] = STATE(157),
    [sym_value_qid] = STATE(157),
    [sym_field_accessor_function_expr] = STATE(15),
    [sym_operator_as_function_expr] = STATE(15),
    [sym__operator_as_function_inner] = STATE(175),
    [sym__atom] = STATE(15),
    [sym_field_access_expr] = STATE(151),
    [sym__field_access_start] = STATE(660),
    [sym_negate_expr] = STATE(15),
    [sym_parenthesized_expr] = STATE(151),
    [sym__literal_expr_group] = STATE(15),
    [sym_char_constant_expr] = STATE(15),
    [sym_open_char] = STATE(603),
    [sym_number_constant_expr] = STATE(15),
    [sym_string_constant_expr] = STATE(15),
    [sym_anonymous_function_expr] = STATE(15),
    [sym_value_expr] = STATE(151),
    [sym_tuple_expr] = STATE(15),
    [sym_unit_expr] = STATE(15),
    [sym_list_expr] = STATE(15),
    [sym_record_expr] = STATE(151),
    [sym_if_else_expr] = STATE(15),
    [sym_case_of_expr] = STATE(15),
    [sym_let_in_expr] = STATE(15),
    [sym_glsl_code_expr] = STATE(15),
    [sym_number_literal] = STATE(177),
    [sym__if] = STATE(737),
    [sym__let] = STATE(808),
    [aux_sym_function_call_expr_repeat1] = STATE(15),
    [sym_lower_case_identifier] = ACTIONS(201),
    [anon_sym_COLON_COLON] = ACTIONS(44),
    [sym_upper_case_identifier] = ACTIONS(204),
    [aux_sym_number_literal_token1] = ACTIONS(207),
    [sym__hex_literal] = ACTIONS(207),
    [anon_sym_if] = ACTIONS(52),
    [sym_case] = ACTIONS(210),
    [anon_sym_let] = ACTIONS(58),
    [sym_left_parenthesis] = ACTIONS(213),
    [sym_left_square_bracket] = ACTIONS(216),
    [sym_left_brace] = ACTIONS(219),
    [sym_backslash] = ACTIONS(222),
    [sym_dot] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(44),
    [anon_sym_DASH] = ACTIONS(44),
    [anon_sym_STAR] = ACTIONS(44),
    [anon_sym_SLASH] = ACTIONS(44),
    [anon_sym_SLASH_SLASH] = ACTIONS(44),
    [anon_sym_CARET] = ACTIONS(44),
    [anon_sym_EQ_EQ] = ACTIONS(44),
    [anon_sym_SLASH_EQ] = ACTIONS(44),
    [anon_sym_LT] = ACTIONS(44),
    [anon_sym_GT] = ACTIONS(44),
    [anon_sym_LT_EQ] = ACTIONS(44),
    [anon_sym_GT_EQ] = ACTIONS(44),
    [anon_sym_AMP_AMP] = ACTIONS(44),
    [anon_sym_PIPE_PIPE] = ACTIONS(44),
    [anon_sym_PLUS_PLUS] = ACTIONS(44),
    [anon_sym_LT_PIPE] = ACTIONS(44),
    [anon_sym_PIPE_GT] = ACTIONS(44),
    [anon_sym_LT_LT] = ACTIONS(44),
    [anon_sym_GT_GT] = ACTIONS(44),
    [anon_sym_LT_SLASH_GT] = ACTIONS(44),
    [anon_sym_LT_QMARK_GT] = ACTIONS(44),
    [anon_sym_PIPE_DOT] = ACTIONS(44),
    [anon_sym_PIPE_EQ] = ACTIONS(44),
    [sym_glsl_begin] = ACTIONS(228),
    [sym__char_quote] = ACTIONS(79),
    [sym__virtual_end_decl] = ACTIONS(231),
    [sym__virtual_end_section] = ACTIONS(231),
    [sym_minus_without_trailing_whitespace] = ACTIONS(233),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(236),
    [sym_open_quote_multiline] = ACTIONS(239),
  },
  [15] = {
    [sym_upper_case_qid] = STATE(157),
    [sym_value_qid] = STATE(157),
    [sym_field_accessor_function_expr] = STATE(15),
    [sym_operator_as_function_expr] = STATE(15),
    [sym__operator_as_function_inner] = STATE(175),
    [sym__atom] = STATE(15),
    [sym_field_access_expr] = STATE(151),
    [sym__field_access_start] = STATE(660),
    [sym_negate_expr] = STATE(15),
    [sym_parenthesized_expr] = STATE(151),
    [sym__literal_expr_group] = STATE(15),
    [sym_char_constant_expr] = STATE(15),
    [sym_open_char] = STATE(603),
    [sym_number_constant_expr] = STATE(15),
    [sym_string_constant_expr] = STATE(15),
    [sym_anonymous_function_expr] = STATE(15),
    [sym_value_expr] = STATE(151),
    [sym_tuple_expr] = STATE(15),
    [sym_unit_expr] = STATE(15),
    [sym_list_expr] = STATE(15),
    [sym_record_expr] = STATE(151),
    [sym_if_else_expr] = STATE(15),
    [sym_case_of_expr] = STATE(15),
    [sym_let_in_expr] = STATE(15),
    [sym_glsl_code_expr] = STATE(15),
    [sym_number_literal] = STATE(177),
    [sym__if] = STATE(737),
    [sym__let] = STATE(808),
    [aux_sym_function_call_expr_repeat1] = STATE(15),
    [sym_lower_case_identifier] = ACTIONS(242),
    [anon_sym_COLON_COLON] = ACTIONS(94),
    [sym_upper_case_identifier] = ACTIONS(245),
    [aux_sym_number_literal_token1] = ACTIONS(248),
    [sym__hex_literal] = ACTIONS(248),
    [anon_sym_if] = ACTIONS(102),
    [sym_case] = ACTIONS(251),
    [anon_sym_let] = ACTIONS(108),
    [sym_left_parenthesis] = ACTIONS(254),
    [sym_left_square_bracket] = ACTIONS(257),
    [sym_left_brace] = ACTIONS(260),
    [sym_backslash] = ACTIONS(263),
    [sym_dot] = ACTIONS(266),
    [anon_sym_PLUS] = ACTIONS(94),
    [anon_sym_DASH] = ACTIONS(94),
    [anon_sym_STAR] = ACTIONS(94),
    [anon_sym_SLASH] = ACTIONS(94),
    [anon_sym_SLASH_SLASH] = ACTIONS(94),
    [anon_sym_CARET] = ACTIONS(94),
    [anon_sym_EQ_EQ] = ACTIONS(94),
    [anon_sym_SLASH_EQ] = ACTIONS(94),
    [anon_sym_LT] = ACTIONS(94),
    [anon_sym_GT] = ACTIONS(94),
    [anon_sym_LT_EQ] = ACTIONS(94),
    [anon_sym_GT_EQ] = ACTIONS(94),
    [anon_sym_AMP_AMP] = ACTIONS(94),
    [anon_sym_PIPE_PIPE] = ACTIONS(94),
    [anon_sym_PLUS_PLUS] = ACTIONS(94),
    [anon_sym_LT_PIPE] = ACTIONS(94),
    [anon_sym_PIPE_GT] = ACTIONS(94),
    [anon_sym_LT_LT] = ACTIONS(94),
    [anon_sym_GT_GT] = ACTIONS(94),
    [anon_sym_LT_SLASH_GT] = ACTIONS(94),
    [anon_sym_LT_QMARK_GT] = ACTIONS(94),
    [anon_sym_PIPE_DOT] = ACTIONS(94),
    [anon_sym_PIPE_EQ] = ACTIONS(94),
    [sym_glsl_begin] = ACTIONS(269),
    [sym__char_quote] = ACTIONS(129),
    [sym__virtual_end_decl] = ACTIONS(272),
    [sym__virtual_end_section] = ACTIONS(272),
    [sym_minus_without_trailing_whitespace] = ACTIONS(274),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(277),
    [sym_open_quote_multiline] = ACTIONS(280),
  },
  [16] = {
    [sym_upper_case_qid] = STATE(157),
    [sym_value_qid] = STATE(157),
    [sym_field_accessor_function_expr] = STATE(15),
    [sym_operator_as_function_expr] = STATE(15),
    [sym__operator_as_function_inner] = STATE(175),
    [sym__atom] = STATE(15),
    [sym_field_access_expr] = STATE(151),
    [sym__field_access_start] = STATE(660),
    [sym_negate_expr] = STATE(15),
    [sym_parenthesized_expr] = STATE(151),
    [sym__literal_expr_group] = STATE(15),
    [sym_char_constant_expr] = STATE(15),
    [sym_open_char] = STATE(603),
    [sym_number_constant_expr] = STATE(15),
    [sym_string_constant_expr] = STATE(15),
    [sym_anonymous_function_expr] = STATE(15),
    [sym_value_expr] = STATE(151),
    [sym_tuple_expr] = STATE(15),
    [sym_unit_expr] = STATE(15),
    [sym_list_expr] = STATE(15),
    [sym_record_expr] = STATE(151),
    [sym_if_else_expr] = STATE(15),
    [sym_case_of_expr] = STATE(15),
    [sym_let_in_expr] = STATE(15),
    [sym_glsl_code_expr] = STATE(15),
    [sym_number_literal] = STATE(177),
    [sym__if] = STATE(737),
    [sym__let] = STATE(808),
    [aux_sym_function_call_expr_repeat1] = STATE(15),
    [sym_lower_case_identifier] = ACTIONS(283),
    [anon_sym_COLON_COLON] = ACTIONS(44),
    [sym_upper_case_identifier] = ACTIONS(285),
    [aux_sym_number_literal_token1] = ACTIONS(287),
    [sym__hex_literal] = ACTIONS(287),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(291),
    [sym_left_square_bracket] = ACTIONS(293),
    [sym_left_brace] = ACTIONS(295),
    [sym_backslash] = ACTIONS(297),
    [sym_dot] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(44),
    [anon_sym_DASH] = ACTIONS(44),
    [anon_sym_STAR] = ACTIONS(44),
    [anon_sym_SLASH] = ACTIONS(44),
    [anon_sym_SLASH_SLASH] = ACTIONS(44),
    [anon_sym_CARET] = ACTIONS(44),
    [anon_sym_EQ_EQ] = ACTIONS(44),
    [anon_sym_SLASH_EQ] = ACTIONS(44),
    [anon_sym_LT] = ACTIONS(44),
    [anon_sym_GT] = ACTIONS(44),
    [anon_sym_LT_EQ] = ACTIONS(44),
    [anon_sym_GT_EQ] = ACTIONS(44),
    [anon_sym_AMP_AMP] = ACTIONS(44),
    [anon_sym_PIPE_PIPE] = ACTIONS(44),
    [anon_sym_PLUS_PLUS] = ACTIONS(44),
    [anon_sym_LT_PIPE] = ACTIONS(44),
    [anon_sym_PIPE_GT] = ACTIONS(44),
    [anon_sym_LT_LT] = ACTIONS(44),
    [anon_sym_GT_GT] = ACTIONS(44),
    [anon_sym_LT_SLASH_GT] = ACTIONS(44),
    [anon_sym_LT_QMARK_GT] = ACTIONS(44),
    [anon_sym_PIPE_DOT] = ACTIONS(44),
    [anon_sym_PIPE_EQ] = ACTIONS(44),
    [sym_glsl_begin] = ACTIONS(301),
    [sym__char_quote] = ACTIONS(165),
    [sym__virtual_end_decl] = ACTIONS(231),
    [sym__virtual_end_section] = ACTIONS(231),
    [sym_minus_without_trailing_whitespace] = ACTIONS(303),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(305),
    [sym_open_quote_multiline] = ACTIONS(307),
  },
  [17] = {
    [sym_upper_case_qid] = STATE(195),
    [sym_value_qid] = STATE(195),
    [sym_field_accessor_function_expr] = STATE(17),
    [sym_operator_as_function_expr] = STATE(17),
    [sym__operator_as_function_inner] = STATE(200),
    [sym__atom] = STATE(17),
    [sym_field_access_expr] = STATE(192),
    [sym__field_access_start] = STATE(693),
    [sym_negate_expr] = STATE(17),
    [sym_parenthesized_expr] = STATE(192),
    [sym__literal_expr_group] = STATE(17),
    [sym_char_constant_expr] = STATE(17),
    [sym_open_char] = STATE(612),
    [sym_number_constant_expr] = STATE(17),
    [sym_string_constant_expr] = STATE(17),
    [sym_anonymous_function_expr] = STATE(17),
    [sym_value_expr] = STATE(192),
    [sym_tuple_expr] = STATE(17),
    [sym_unit_expr] = STATE(17),
    [sym_list_expr] = STATE(17),
    [sym_record_expr] = STATE(192),
    [sym_if_else_expr] = STATE(17),
    [sym_case_of_expr] = STATE(17),
    [sym_let_in_expr] = STATE(17),
    [sym_glsl_code_expr] = STATE(17),
    [sym_number_literal] = STATE(212),
    [sym__if] = STATE(764),
    [sym__let] = STATE(757),
    [aux_sym_function_call_expr_repeat1] = STATE(17),
    [sym_lower_case_identifier] = ACTIONS(309),
    [anon_sym_COLON_COLON] = ACTIONS(94),
    [sym_upper_case_identifier] = ACTIONS(312),
    [aux_sym_number_literal_token1] = ACTIONS(315),
    [sym__hex_literal] = ACTIONS(315),
    [anon_sym_if] = ACTIONS(102),
    [sym_case] = ACTIONS(318),
    [anon_sym_let] = ACTIONS(108),
    [sym_left_parenthesis] = ACTIONS(321),
    [sym_left_square_bracket] = ACTIONS(324),
    [sym_left_brace] = ACTIONS(327),
    [sym_backslash] = ACTIONS(330),
    [sym_dot] = ACTIONS(333),
    [anon_sym_PLUS] = ACTIONS(94),
    [anon_sym_DASH] = ACTIONS(94),
    [anon_sym_STAR] = ACTIONS(94),
    [anon_sym_SLASH] = ACTIONS(94),
    [anon_sym_SLASH_SLASH] = ACTIONS(94),
    [anon_sym_CARET] = ACTIONS(94),
    [anon_sym_EQ_EQ] = ACTIONS(94),
    [anon_sym_SLASH_EQ] = ACTIONS(94),
    [anon_sym_LT] = ACTIONS(94),
    [anon_sym_GT] = ACTIONS(94),
    [anon_sym_LT_EQ] = ACTIONS(94),
    [anon_sym_GT_EQ] = ACTIONS(94),
    [anon_sym_AMP_AMP] = ACTIONS(94),
    [anon_sym_PIPE_PIPE] = ACTIONS(94),
    [anon_sym_PLUS_PLUS] = ACTIONS(94),
    [anon_sym_LT_PIPE] = ACTIONS(94),
    [anon_sym_PIPE_GT] = ACTIONS(94),
    [anon_sym_LT_LT] = ACTIONS(94),
    [anon_sym_GT_GT] = ACTIONS(94),
    [anon_sym_LT_SLASH_GT] = ACTIONS(94),
    [anon_sym_LT_QMARK_GT] = ACTIONS(94),
    [anon_sym_PIPE_DOT] = ACTIONS(94),
    [anon_sym_PIPE_EQ] = ACTIONS(94),
    [sym_glsl_begin] = ACTIONS(336),
    [sym__char_quote] = ACTIONS(129),
    [sym__virtual_end_decl] = ACTIONS(272),
    [sym_minus_without_trailing_whitespace] = ACTIONS(339),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(342),
    [sym_open_quote_multiline] = ACTIONS(345),
  },
  [18] = {
    [sym_upper_case_qid] = STATE(195),
    [sym_value_qid] = STATE(195),
    [sym_field_accessor_function_expr] = STATE(17),
    [sym_operator_as_function_expr] = STATE(17),
    [sym__operator_as_function_inner] = STATE(200),
    [sym__atom] = STATE(17),
    [sym_field_access_expr] = STATE(192),
    [sym__field_access_start] = STATE(693),
    [sym_negate_expr] = STATE(17),
    [sym_parenthesized_expr] = STATE(192),
    [sym__literal_expr_group] = STATE(17),
    [sym_char_constant_expr] = STATE(17),
    [sym_open_char] = STATE(612),
    [sym_number_constant_expr] = STATE(17),
    [sym_string_constant_expr] = STATE(17),
    [sym_anonymous_function_expr] = STATE(17),
    [sym_value_expr] = STATE(192),
    [sym_tuple_expr] = STATE(17),
    [sym_unit_expr] = STATE(17),
    [sym_list_expr] = STATE(17),
    [sym_record_expr] = STATE(192),
    [sym_if_else_expr] = STATE(17),
    [sym_case_of_expr] = STATE(17),
    [sym_let_in_expr] = STATE(17),
    [sym_glsl_code_expr] = STATE(17),
    [sym_number_literal] = STATE(212),
    [sym__if] = STATE(764),
    [sym__let] = STATE(757),
    [aux_sym_function_call_expr_repeat1] = STATE(17),
    [sym_lower_case_identifier] = ACTIONS(348),
    [anon_sym_COLON_COLON] = ACTIONS(44),
    [sym_upper_case_identifier] = ACTIONS(350),
    [aux_sym_number_literal_token1] = ACTIONS(352),
    [sym__hex_literal] = ACTIONS(352),
    [anon_sym_if] = ACTIONS(147),
    [sym_case] = ACTIONS(354),
    [anon_sym_let] = ACTIONS(151),
    [sym_left_parenthesis] = ACTIONS(356),
    [sym_left_square_bracket] = ACTIONS(358),
    [sym_left_brace] = ACTIONS(360),
    [sym_backslash] = ACTIONS(362),
    [sym_dot] = ACTIONS(364),
    [anon_sym_PLUS] = ACTIONS(44),
    [anon_sym_DASH] = ACTIONS(44),
    [anon_sym_STAR] = ACTIONS(44),
    [anon_sym_SLASH] = ACTIONS(44),
    [anon_sym_SLASH_SLASH] = ACTIONS(44),
    [anon_sym_CARET] = ACTIONS(44),
    [anon_sym_EQ_EQ] = ACTIONS(44),
    [anon_sym_SLASH_EQ] = ACTIONS(44),
    [anon_sym_LT] = ACTIONS(44),
    [anon_sym_GT] = ACTIONS(44),
    [anon_sym_LT_EQ] = ACTIONS(44),
    [anon_sym_GT_EQ] = ACTIONS(44),
    [anon_sym_AMP_AMP] = ACTIONS(44),
    [anon_sym_PIPE_PIPE] = ACTIONS(44),
    [anon_sym_PLUS_PLUS] = ACTIONS(44),
    [anon_sym_LT_PIPE] = ACTIONS(44),
    [anon_sym_PIPE_GT] = ACTIONS(44),
    [anon_sym_LT_LT] = ACTIONS(44),
    [anon_sym_GT_GT] = ACTIONS(44),
    [anon_sym_LT_SLASH_GT] = ACTIONS(44),
    [anon_sym_LT_QMARK_GT] = ACTIONS(44),
    [anon_sym_PIPE_DOT] = ACTIONS(44),
    [anon_sym_PIPE_EQ] = ACTIONS(44),
    [sym_glsl_begin] = ACTIONS(366),
    [sym__char_quote] = ACTIONS(165),
    [sym__virtual_end_decl] = ACTIONS(231),
    [sym_minus_without_trailing_whitespace] = ACTIONS(368),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(370),
    [sym_open_quote_multiline] = ACTIONS(372),
  },
  [19] = {
    [sym_upper_case_qid] = STATE(195),
    [sym_value_qid] = STATE(195),
    [sym_field_accessor_function_expr] = STATE(17),
    [sym_operator_as_function_expr] = STATE(17),
    [sym__operator_as_function_inner] = STATE(200),
    [sym__atom] = STATE(17),
    [sym_field_access_expr] = STATE(192),
    [sym__field_access_start] = STATE(693),
    [sym_negate_expr] = STATE(17),
    [sym_parenthesized_expr] = STATE(192),
    [sym__literal_expr_group] = STATE(17),
    [sym_char_constant_expr] = STATE(17),
    [sym_open_char] = STATE(612),
    [sym_number_constant_expr] = STATE(17),
    [sym_string_constant_expr] = STATE(17),
    [sym_anonymous_function_expr] = STATE(17),
    [sym_value_expr] = STATE(192),
    [sym_tuple_expr] = STATE(17),
    [sym_unit_expr] = STATE(17),
    [sym_list_expr] = STATE(17),
    [sym_record_expr] = STATE(192),
    [sym_if_else_expr] = STATE(17),
    [sym_case_of_expr] = STATE(17),
    [sym_let_in_expr] = STATE(17),
    [sym_glsl_code_expr] = STATE(17),
    [sym_number_literal] = STATE(212),
    [sym__if] = STATE(764),
    [sym__let] = STATE(757),
    [aux_sym_function_call_expr_repeat1] = STATE(17),
    [sym_lower_case_identifier] = ACTIONS(374),
    [anon_sym_COLON_COLON] = ACTIONS(44),
    [sym_upper_case_identifier] = ACTIONS(377),
    [aux_sym_number_literal_token1] = ACTIONS(380),
    [sym__hex_literal] = ACTIONS(380),
    [anon_sym_if] = ACTIONS(52),
    [sym_case] = ACTIONS(383),
    [anon_sym_let] = ACTIONS(58),
    [sym_left_parenthesis] = ACTIONS(386),
    [sym_left_square_bracket] = ACTIONS(389),
    [sym_left_brace] = ACTIONS(392),
    [sym_backslash] = ACTIONS(395),
    [sym_dot] = ACTIONS(398),
    [anon_sym_PLUS] = ACTIONS(44),
    [anon_sym_DASH] = ACTIONS(44),
    [anon_sym_STAR] = ACTIONS(44),
    [anon_sym_SLASH] = ACTIONS(44),
    [anon_sym_SLASH_SLASH] = ACTIONS(44),
    [anon_sym_CARET] = ACTIONS(44),
    [anon_sym_EQ_EQ] = ACTIONS(44),
    [anon_sym_SLASH_EQ] = ACTIONS(44),
    [anon_sym_LT] = ACTIONS(44),
    [anon_sym_GT] = ACTIONS(44),
    [anon_sym_LT_EQ] = ACTIONS(44),
    [anon_sym_GT_EQ] = ACTIONS(44),
    [anon_sym_AMP_AMP] = ACTIONS(44),
    [anon_sym_PIPE_PIPE] = ACTIONS(44),
    [anon_sym_PLUS_PLUS] = ACTIONS(44),
    [anon_sym_LT_PIPE] = ACTIONS(44),
    [anon_sym_PIPE_GT] = ACTIONS(44),
    [anon_sym_LT_LT] = ACTIONS(44),
    [anon_sym_GT_GT] = ACTIONS(44),
    [anon_sym_LT_SLASH_GT] = ACTIONS(44),
    [anon_sym_LT_QMARK_GT] = ACTIONS(44),
    [anon_sym_PIPE_DOT] = ACTIONS(44),
    [anon_sym_PIPE_EQ] = ACTIONS(44),
    [sym_glsl_begin] = ACTIONS(401),
    [sym__char_quote] = ACTIONS(79),
    [sym__virtual_end_decl] = ACTIONS(231),
    [sym_minus_without_trailing_whitespace] = ACTIONS(404),
    [sym_block_comment] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [sym_open_quote] = ACTIONS(407),
    [sym_open_quote_multiline] = ACTIONS(410),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 31,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(413), 1,
      sym_right_square_bracket,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(654), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [116] = 31,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(415), 1,
      sym_right_square_bracket,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(700), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [232] = 31,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(417), 1,
      sym_right_square_bracket,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(715), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [348] = 31,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(419), 1,
      sym_right_square_bracket,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(634), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [464] = 7,
    STATE(28), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(81), 1,
      sym_operator,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(425), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(421), 20,
      anon_sym_else,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(423), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [532] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(27), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(429), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(427), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [594] = 31,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(431), 1,
      sym_right_square_bracket,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(651), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [710] = 5,
    ACTIONS(435), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(27), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(438), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(433), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [774] = 7,
    STATE(28), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(81), 1,
      sym_operator,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(440), 20,
      anon_sym_else,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(442), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [842] = 7,
    STATE(24), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(81), 1,
      sym_operator,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(449), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(447), 20,
      anon_sym_else,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(423), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [910] = 31,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(451), 1,
      sym_right_square_bracket,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(671), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1026] = 5,
    ACTIONS(455), 1,
      sym__dot_without_leading_whitespace,
    STATE(35), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(457), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(453), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [1089] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(118), 1,
      sym__function_call_target,
    STATE(151), 1,
      sym_record_expr,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(737), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(166), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(123), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1202] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(756), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1315] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(461), 1,
      sym_case,
    ACTIONS(463), 1,
      sym_left_parenthesis,
    ACTIONS(465), 1,
      sym_left_square_bracket,
    ACTIONS(467), 1,
      sym_left_brace,
    ACTIONS(469), 1,
      sym_backslash,
    ACTIONS(471), 1,
      sym_glsl_begin,
    ACTIONS(473), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(475), 1,
      sym_open_quote,
    ACTIONS(477), 1,
      sym_open_quote_multiline,
    STATE(122), 1,
      sym__function_call_target,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(355), 1,
      sym_record_expr,
    STATE(385), 1,
      sym_number_literal,
    STATE(614), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(738), 1,
      sym__if,
    STATE(776), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(459), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(395), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(329), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1428] = 5,
    ACTIONS(481), 1,
      sym__dot_without_leading_whitespace,
    STATE(35), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(479), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [1491] = 30,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(71), 1,
      sym_record_expr,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(124), 1,
      sym__function_call_target,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(752), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(79), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(29), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1604] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(490), 1,
      sym_left_parenthesis,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    STATE(120), 1,
      sym__function_call_target,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(335), 1,
      sym_record_expr,
    STATE(348), 1,
      sym_number_literal,
    STATE(605), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(747), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(777), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(323), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1717] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(118), 1,
      sym__function_call_target,
    STATE(151), 1,
      sym_record_expr,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(734), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(165), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(123), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1830] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(490), 1,
      sym_left_parenthesis,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    STATE(120), 1,
      sym__function_call_target,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(335), 1,
      sym_record_expr,
    STATE(348), 1,
      sym_number_literal,
    STATE(605), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(747), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(792), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(323), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1943] = 5,
    ACTIONS(508), 1,
      sym__dot_without_leading_whitespace,
    STATE(31), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(510), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(506), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [2006] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(490), 1,
      sym_left_parenthesis,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    STATE(120), 1,
      sym__function_call_target,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(335), 1,
      sym_record_expr,
    STATE(348), 1,
      sym_number_literal,
    STATE(605), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(743), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(356), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(323), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2119] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(461), 1,
      sym_case,
    ACTIONS(463), 1,
      sym_left_parenthesis,
    ACTIONS(465), 1,
      sym_left_square_bracket,
    ACTIONS(467), 1,
      sym_left_brace,
    ACTIONS(469), 1,
      sym_backslash,
    ACTIONS(471), 1,
      sym_glsl_begin,
    ACTIONS(473), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(475), 1,
      sym_open_quote,
    ACTIONS(477), 1,
      sym_open_quote_multiline,
    STATE(122), 1,
      sym__function_call_target,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(355), 1,
      sym_record_expr,
    STATE(385), 1,
      sym_number_literal,
    STATE(614), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(776), 1,
      sym__let,
    STATE(807), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(459), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(394), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(329), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2232] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(733), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2345] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(766), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(310), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2458] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(729), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2571] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(461), 1,
      sym_case,
    ACTIONS(463), 1,
      sym_left_parenthesis,
    ACTIONS(465), 1,
      sym_left_square_bracket,
    ACTIONS(467), 1,
      sym_left_brace,
    ACTIONS(469), 1,
      sym_backslash,
    ACTIONS(471), 1,
      sym_glsl_begin,
    ACTIONS(473), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(475), 1,
      sym_open_quote,
    ACTIONS(477), 1,
      sym_open_quote_multiline,
    STATE(122), 1,
      sym__function_call_target,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(355), 1,
      sym_record_expr,
    STATE(385), 1,
      sym_number_literal,
    STATE(614), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(776), 1,
      sym__let,
    STATE(807), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(459), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(392), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(329), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2684] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(292), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2797] = 30,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(71), 1,
      sym_record_expr,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(124), 1,
      sym__function_call_target,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(754), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(90), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(29), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [2910] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(803), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3023] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(316), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3136] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(770), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3249] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(796), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3362] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(118), 1,
      sym__function_call_target,
    STATE(151), 1,
      sym_record_expr,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(737), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(171), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(123), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3475] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(461), 1,
      sym_case,
    ACTIONS(463), 1,
      sym_left_parenthesis,
    ACTIONS(465), 1,
      sym_left_square_bracket,
    ACTIONS(467), 1,
      sym_left_brace,
    ACTIONS(469), 1,
      sym_backslash,
    ACTIONS(471), 1,
      sym_glsl_begin,
    ACTIONS(473), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(475), 1,
      sym_open_quote,
    ACTIONS(477), 1,
      sym_open_quote_multiline,
    STATE(122), 1,
      sym__function_call_target,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(355), 1,
      sym_record_expr,
    STATE(385), 1,
      sym_number_literal,
    STATE(614), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(776), 1,
      sym__let,
    STATE(807), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(459), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(883), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(329), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3588] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(824), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3701] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(839), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3814] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(490), 1,
      sym_left_parenthesis,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    STATE(120), 1,
      sym__function_call_target,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(335), 1,
      sym_record_expr,
    STATE(348), 1,
      sym_number_literal,
    STATE(605), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(747), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(371), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(323), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3927] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(490), 1,
      sym_left_parenthesis,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    STATE(120), 1,
      sym__function_call_target,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(335), 1,
      sym_record_expr,
    STATE(348), 1,
      sym_number_literal,
    STATE(605), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(747), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(358), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(323), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4040] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(115), 1,
      sym__function_call_target,
    STATE(192), 1,
      sym_record_expr,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(764), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(214), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(126), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4153] = 30,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(71), 1,
      sym_record_expr,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(124), 1,
      sym__function_call_target,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(754), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(96), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(29), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4266] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(115), 1,
      sym__function_call_target,
    STATE(192), 1,
      sym_record_expr,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(764), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(206), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(126), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4379] = 30,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(115), 1,
      sym__function_call_target,
    STATE(192), 1,
      sym_record_expr,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(760), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(205), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(126), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4492] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(827), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4605] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(762), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4718] = 30,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(884), 2,
      sym__expression,
      sym_bin_op_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(240), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4831] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(514), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(512), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [4889] = 5,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(522), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(516), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(520), 31,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [4951] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(526), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(524), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5009] = 4,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(479), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5069] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(533), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(531), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5127] = 4,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(535), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(520), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5187] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(539), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(537), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5245] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(543), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(541), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5303] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(547), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(545), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5361] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(551), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(549), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5419] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(479), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5477] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(555), 5,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(553), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5535] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(559), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(557), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5592] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(563), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(561), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5649] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(567), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(565), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5706] = 29,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(71), 1,
      sym_record_expr,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(124), 1,
      sym__function_call_target,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(754), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(88), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5815] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(571), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(569), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5872] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(575), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(573), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5929] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(579), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(577), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [5986] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(583), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(581), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6043] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(587), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(585), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6100] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(591), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(589), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6157] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(440), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6214] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(595), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(593), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6271] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(599), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(597), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6328] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(603), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(601), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6385] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(607), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(605), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6442] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(611), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(609), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6499] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(615), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(613), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6556] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(619), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(617), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6613] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(623), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(621), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6670] = 29,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(177), 1,
      sym_left_parenthesis,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym__function_call_target,
    STATE(249), 1,
      sym_number_literal,
    STATE(265), 1,
      sym_record_expr,
    STATE(618), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(107), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(67), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(305), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6779] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(627), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(625), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6836] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(631), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(629), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [6893] = 32,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(19), 1,
      sym_import,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(633), 1,
      ts_builtin_sym_end,
    ACTIONS(635), 1,
      sym_port,
    STATE(127), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(431), 1,
      aux_sym__import_list,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    STATE(897), 1,
      sym_import_clause,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [7008] = 29,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(118), 1,
      sym__function_call_target,
    STATE(151), 1,
      sym_record_expr,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(737), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(178), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7117] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(639), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(637), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7174] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(643), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(641), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7231] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(647), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(645), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7288] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(651), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(649), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7345] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(655), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(653), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7402] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(522), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(516), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(520), 31,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [7461] = 29,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(115), 1,
      sym__function_call_target,
    STATE(192), 1,
      sym_record_expr,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(764), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(222), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7570] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(659), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(657), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7627] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(663), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(661), 44,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      anon_sym_then,
      sym_case,
      sym_of,
      anon_sym_let,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [7684] = 32,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(19), 1,
      sym_import,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(635), 1,
      sym_port,
    ACTIONS(665), 1,
      ts_builtin_sym_end,
    STATE(135), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(431), 1,
      aux_sym__import_list,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    STATE(897), 1,
      sym_import_clause,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [7799] = 32,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(19), 1,
      sym_import,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(635), 1,
      sym_port,
    ACTIONS(667), 1,
      ts_builtin_sym_end,
    STATE(111), 1,
      aux_sym__import_list,
    STATE(130), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    STATE(897), 1,
      sym_import_clause,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [7914] = 29,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(461), 1,
      sym_case,
    ACTIONS(463), 1,
      sym_left_parenthesis,
    ACTIONS(465), 1,
      sym_left_square_bracket,
    ACTIONS(467), 1,
      sym_left_brace,
    ACTIONS(469), 1,
      sym_backslash,
    ACTIONS(471), 1,
      sym_glsl_begin,
    ACTIONS(473), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(475), 1,
      sym_open_quote,
    ACTIONS(477), 1,
      sym_open_quote_multiline,
    STATE(122), 1,
      sym__function_call_target,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(355), 1,
      sym_record_expr,
    STATE(385), 1,
      sym_number_literal,
    STATE(614), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(776), 1,
      sym__let,
    STATE(807), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(459), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(220), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(183), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(391), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8023] = 29,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(490), 1,
      sym_left_parenthesis,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    STATE(120), 1,
      sym__function_call_target,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(335), 1,
      sym_record_expr,
    STATE(348), 1,
      sym_number_literal,
    STATE(605), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(747), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(189), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(145), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(363), 16,
      sym__call_or_atom,
      sym_function_call_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8132] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(764), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(192), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(19), 17,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
      aux_sym_function_call_expr_repeat1,
  [8233] = 5,
    ACTIONS(669), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(116), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(438), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(433), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [8292] = 26,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(754), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(71), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(4), 17,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
      aux_sym_function_call_expr_repeat1,
  [8393] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(737), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(151), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(14), 17,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
      aux_sym_function_call_expr_repeat1,
  [8494] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(116), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(429), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(427), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [8551] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(737), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(151), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(16), 17,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
      aux_sym_function_call_expr_repeat1,
  [8652] = 7,
    STATE(101), 1,
      sym_operator,
    STATE(121), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(440), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(442), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [8715] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(764), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(192), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(18), 17,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
      aux_sym_function_call_expr_repeat1,
  [8816] = 7,
    STATE(101), 1,
      sym_operator,
    STATE(125), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(449), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(447), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(423), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [8879] = 26,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(754), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(71), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(2), 17,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
      aux_sym_function_call_expr_repeat1,
  [8980] = 7,
    STATE(101), 1,
      sym_operator,
    STATE(121), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(425), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(421), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(423), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9043] = 7,
    STATE(108), 1,
      sym_operator,
    STATE(136), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(449), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(447), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(423), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9105] = 29,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(635), 1,
      sym_port,
    ACTIONS(672), 1,
      ts_builtin_sym_end,
    STATE(140), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [9211] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(348), 1,
      sym_lower_case_identifier,
    ACTIONS(350), 1,
      sym_upper_case_identifier,
    ACTIONS(354), 1,
      sym_case,
    ACTIONS(356), 1,
      sym_left_parenthesis,
    ACTIONS(358), 1,
      sym_left_square_bracket,
    ACTIONS(360), 1,
      sym_left_brace,
    ACTIONS(362), 1,
      sym_backslash,
    ACTIONS(364), 1,
      sym_dot,
    ACTIONS(366), 1,
      sym_glsl_begin,
    ACTIONS(368), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(370), 1,
      sym_open_quote,
    ACTIONS(372), 1,
      sym_open_quote_multiline,
    STATE(200), 1,
      sym__operator_as_function_inner,
    STATE(212), 1,
      sym_number_literal,
    STATE(612), 1,
      sym_open_char,
    STATE(693), 1,
      sym__field_access_start,
    STATE(757), 1,
      sym__let,
    STATE(764), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(352), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(195), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(192), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(218), 16,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9311] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(144), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(429), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(427), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [9367] = 29,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(635), 1,
      sym_port,
    ACTIONS(665), 1,
      ts_builtin_sym_end,
    STATE(140), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [9473] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(461), 1,
      sym_case,
    ACTIONS(465), 1,
      sym_left_square_bracket,
    ACTIONS(467), 1,
      sym_left_brace,
    ACTIONS(469), 1,
      sym_backslash,
    ACTIONS(471), 1,
      sym_glsl_begin,
    ACTIONS(473), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(475), 1,
      sym_open_quote,
    ACTIONS(477), 1,
      sym_open_quote_multiline,
    ACTIONS(674), 1,
      sym_lower_case_identifier,
    ACTIONS(676), 1,
      sym_upper_case_identifier,
    ACTIONS(678), 1,
      sym_left_parenthesis,
    ACTIONS(680), 1,
      sym_dot,
    STATE(383), 1,
      sym__operator_as_function_inner,
    STATE(385), 1,
      sym_number_literal,
    STATE(614), 1,
      sym_open_char,
    STATE(706), 1,
      sym__field_access_start,
    STATE(776), 1,
      sym__let,
    STATE(807), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(459), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(376), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(355), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(409), 16,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9573] = 5,
    ACTIONS(682), 1,
      sym__dot_without_leading_whitespace,
    STATE(132), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(479), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [9631] = 5,
    ACTIONS(685), 1,
      sym__dot_without_leading_whitespace,
    STATE(143), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(510), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(506), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [9689] = 29,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(633), 1,
      ts_builtin_sym_end,
    ACTIONS(635), 1,
      sym_port,
    STATE(140), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [9795] = 29,
    ACTIONS(7), 1,
      sym_lower_case_identifier,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(21), 1,
      sym_type,
    ACTIONS(25), 1,
      sym_infix,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(635), 1,
      sym_port,
    ACTIONS(687), 1,
      ts_builtin_sym_end,
    STATE(140), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [9901] = 7,
    STATE(108), 1,
      sym_operator,
    STATE(141), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(425), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(421), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(423), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9963] = 26,
    ACTIONS(141), 1,
      sym_lower_case_identifier,
    ACTIONS(143), 1,
      sym_upper_case_identifier,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(149), 1,
      sym_case,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(153), 1,
      sym_left_parenthesis,
    ACTIONS(155), 1,
      sym_left_square_bracket,
    ACTIONS(157), 1,
      sym_left_brace,
    ACTIONS(159), 1,
      sym_backslash,
    ACTIONS(161), 1,
      sym_dot,
    ACTIONS(163), 1,
      sym_glsl_begin,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(167), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(169), 1,
      sym_open_quote,
    ACTIONS(171), 1,
      sym_open_quote_multiline,
    STATE(95), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_number_literal,
    STATE(607), 1,
      sym_open_char,
    STATE(707), 1,
      sym__field_access_start,
    STATE(754), 1,
      sym__if,
    STATE(794), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(145), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(75), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(71), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(105), 16,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [10063] = 26,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(175), 1,
      sym_case,
    ACTIONS(181), 1,
      sym_left_square_bracket,
    ACTIONS(183), 1,
      sym_left_brace,
    ACTIONS(185), 1,
      sym_backslash,
    ACTIONS(187), 1,
      sym_glsl_begin,
    ACTIONS(189), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(689), 1,
      sym_lower_case_identifier,
    ACTIONS(691), 1,
      sym_upper_case_identifier,
    ACTIONS(693), 1,
      sym_left_parenthesis,
    ACTIONS(695), 1,
      sym_dot,
    STATE(249), 1,
      sym_number_literal,
    STATE(303), 1,
      sym__operator_as_function_inner,
    STATE(618), 1,
      sym_open_char,
    STATE(674), 1,
      sym__field_access_start,
    STATE(758), 1,
      sym__let,
    STATE(769), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(11), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(271), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(265), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(299), 16,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [10163] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(488), 1,
      sym_case,
    ACTIONS(492), 1,
      sym_left_square_bracket,
    ACTIONS(494), 1,
      sym_left_brace,
    ACTIONS(496), 1,
      sym_backslash,
    ACTIONS(498), 1,
      sym_glsl_begin,
    ACTIONS(500), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(502), 1,
      sym_open_quote,
    ACTIONS(504), 1,
      sym_open_quote_multiline,
    ACTIONS(697), 1,
      sym_lower_case_identifier,
    ACTIONS(699), 1,
      sym_upper_case_identifier,
    ACTIONS(701), 1,
      sym_left_parenthesis,
    ACTIONS(703), 1,
      sym_dot,
    STATE(348), 1,
      sym_number_literal,
    STATE(381), 1,
      sym__operator_as_function_inner,
    STATE(605), 1,
      sym_open_char,
    STATE(639), 1,
      sym__field_access_start,
    STATE(747), 1,
      sym__if,
    STATE(825), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(486), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(339), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(335), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(353), 16,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [10263] = 29,
    ACTIONS(705), 1,
      ts_builtin_sym_end,
    ACTIONS(707), 1,
      sym_lower_case_identifier,
    ACTIONS(710), 1,
      sym_upper_case_identifier,
    ACTIONS(713), 1,
      aux_sym_number_literal_token1,
    ACTIONS(716), 1,
      sym__hex_literal,
    ACTIONS(719), 1,
      sym_type,
    ACTIONS(722), 1,
      sym_port,
    ACTIONS(725), 1,
      sym_infix,
    ACTIONS(728), 1,
      sym_left_parenthesis,
    ACTIONS(731), 1,
      sym_left_square_bracket,
    ACTIONS(734), 1,
      sym_left_brace,
    ACTIONS(737), 1,
      sym_underscore,
    ACTIONS(740), 1,
      sym__char_quote,
    ACTIONS(743), 1,
      sym_open_quote,
    ACTIONS(746), 1,
      sym_open_quote_multiline,
    STATE(140), 1,
      aux_sym__top_decl_list,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    STATE(894), 1,
      sym__internal_value_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(896), 7,
      sym__declaration,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [10369] = 7,
    STATE(108), 1,
      sym_operator,
    STATE(141), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(440), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(442), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10431] = 26,
    ACTIONS(147), 1,
      anon_sym_if,
    ACTIONS(151), 1,
      anon_sym_let,
    ACTIONS(165), 1,
      sym__char_quote,
    ACTIONS(283), 1,
      sym_lower_case_identifier,
    ACTIONS(285), 1,
      sym_upper_case_identifier,
    ACTIONS(289), 1,
      sym_case,
    ACTIONS(291), 1,
      sym_left_parenthesis,
    ACTIONS(293), 1,
      sym_left_square_bracket,
    ACTIONS(295), 1,
      sym_left_brace,
    ACTIONS(297), 1,
      sym_backslash,
    ACTIONS(299), 1,
      sym_dot,
    ACTIONS(301), 1,
      sym_glsl_begin,
    ACTIONS(303), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(305), 1,
      sym_open_quote,
    ACTIONS(307), 1,
      sym_open_quote_multiline,
    STATE(175), 1,
      sym__operator_as_function_inner,
    STATE(177), 1,
      sym_number_literal,
    STATE(603), 1,
      sym_open_char,
    STATE(660), 1,
      sym__field_access_start,
    STATE(737), 1,
      sym__if,
    STATE(808), 1,
      sym__let,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(287), 2,
      aux_sym_number_literal_token1,
      sym__hex_literal,
    STATE(157), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(151), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(184), 16,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym__atom,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [10531] = 5,
    ACTIONS(749), 1,
      sym__dot_without_leading_whitespace,
    STATE(132), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(457), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(453), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10589] = 5,
    ACTIONS(751), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(144), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(438), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(433), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10647] = 6,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(535), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(522), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(516), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(520), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10706] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(526), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(524), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10759] = 5,
    ACTIONS(754), 1,
      sym__dot_without_leading_whitespace,
    STATE(152), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(510), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(506), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10816] = 5,
    ACTIONS(756), 1,
      sym__dot_without_leading_whitespace,
    STATE(148), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(479), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10873] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(479), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10926] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(547), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(545), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [10979] = 4,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(535), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(520), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11034] = 5,
    ACTIONS(759), 1,
      sym__dot_without_leading_whitespace,
    STATE(148), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(457), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(453), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11091] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(539), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(537), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11144] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(555), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(553), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11197] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(514), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(512), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11250] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(543), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(541), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11303] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(551), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(549), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11356] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(533), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(531), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11409] = 4,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(479), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11464] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(595), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(593), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11516] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(587), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(585), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11568] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(559), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(557), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11620] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(631), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(629), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11672] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(627), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(625), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11724] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(563), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(561), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11776] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(623), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(621), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11828] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(615), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(613), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11880] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(611), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(609), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11932] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(603), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(601), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [11984] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(567), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(565), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12036] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(599), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(597), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12088] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(579), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(577), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12140] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(514), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(512), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12192] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(591), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(589), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12244] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(619), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(617), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12296] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(533), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(531), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12348] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(655), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(653), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12400] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(440), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12452] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(647), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(645), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12504] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(663), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(661), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12556] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(659), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(657), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12608] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(583), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(581), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12660] = 6,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(535), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(522), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(516), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(520), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12718] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(651), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(649), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12770] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(547), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(545), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12822] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(575), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(573), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12874] = 4,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(479), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12928] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(643), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(641), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [12980] = 5,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(535), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(522), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(516), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(520), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13036] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(571), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(569), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13088] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(526), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(524), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13140] = 4,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(535), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(520), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13194] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(539), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(537), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13246] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(639), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(637), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13298] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(551), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(549), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13350] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(484), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(479), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13402] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(555), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(553), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13454] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(543), 6,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(541), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13506] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(607), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(605), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13558] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(619), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(617), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13609] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(575), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(573), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13660] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(559), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(557), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13711] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(631), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(629), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13762] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(627), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(625), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13813] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(563), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(561), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13864] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(623), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(621), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13915] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(571), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(569), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [13966] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(615), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(613), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14017] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(611), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(609), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14068] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(603), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(601), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14119] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(647), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(645), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14170] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(655), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(653), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14221] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(659), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(657), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14272] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(599), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(597), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14323] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(579), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(577), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14374] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(567), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(565), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14425] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(595), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(593), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14476] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(651), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(649), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14527] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(639), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(637), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14578] = 5,
    ACTIONS(535), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(522), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(516), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
    ACTIONS(520), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14633] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(607), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(605), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14684] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(440), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14735] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(587), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(585), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14786] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(643), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(641), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14837] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(591), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(589), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14888] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(583), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(581), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14939] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(663), 5,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(661), 37,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
      sym_glsl_begin,
      sym__char_quote,
  [14990] = 5,
    ACTIONS(761), 1,
      sym__dot_without_leading_whitespace,
    STATE(228), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 11,
      anon_sym_else,
      sym_lower_case_identifier,
      sym_where,
      sym_exposing,
      anon_sym_then,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 27,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15043] = 5,
    ACTIONS(764), 1,
      sym__dot_without_leading_whitespace,
    STATE(228), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(453), 11,
      anon_sym_else,
      sym_lower_case_identifier,
      sym_where,
      sym_exposing,
      anon_sym_then,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(457), 27,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15096] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 11,
      anon_sym_else,
      sym_lower_case_identifier,
      sym_where,
      sym_exposing,
      anon_sym_then,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15144] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(641), 11,
      anon_sym_else,
      sym_lower_case_identifier,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(643), 27,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15191] = 25,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(766), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(767), 1,
      sym_value_declaration,
    STATE(880), 1,
      sym__internal_value_declaration_left,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(785), 2,
      sym_type_annotation,
      sym__inner_declaration,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [15280] = 25,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(766), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(767), 1,
      sym_value_declaration,
    STATE(880), 1,
      sym__internal_value_declaration_left,
    STATE(885), 1,
      sym_pattern,
    STATE(893), 1,
      sym_function_declaration_left,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(622), 2,
      sym_type_annotation,
      sym__inner_declaration,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [15369] = 18,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(768), 1,
      sym_lower_case_identifier,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(776), 1,
      sym_as,
    ACTIONS(778), 1,
      sym_left_parenthesis,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    STATE(414), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(770), 6,
      anon_sym_COLON_COLON,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
    STATE(238), 14,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__union_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_union_pattern_repeat1,
  [15443] = 5,
    ACTIONS(790), 1,
      sym__dot_without_leading_whitespace,
    STATE(236), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(453), 9,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      sym_pipe,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(457), 24,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15491] = 5,
    ACTIONS(792), 1,
      sym__dot_without_leading_whitespace,
    STATE(236), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 9,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      sym_pipe,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 24,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15539] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(645), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(647), 29,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15583] = 18,
    ACTIONS(795), 1,
      sym_lower_case_identifier,
    ACTIONS(800), 1,
      sym_upper_case_identifier,
    ACTIONS(803), 1,
      aux_sym_number_literal_token1,
    ACTIONS(806), 1,
      sym__hex_literal,
    ACTIONS(809), 1,
      sym_as,
    ACTIONS(811), 1,
      sym_left_parenthesis,
    ACTIONS(814), 1,
      sym_left_square_bracket,
    ACTIONS(817), 1,
      sym_left_brace,
    ACTIONS(820), 1,
      sym_underscore,
    ACTIONS(823), 1,
      sym__char_quote,
    ACTIONS(826), 1,
      sym_open_quote,
    ACTIONS(829), 1,
      sym_open_quote_multiline,
    STATE(414), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(798), 6,
      anon_sym_COLON_COLON,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
    STATE(238), 14,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__union_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_union_pattern_repeat1,
  [15657] = 18,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(768), 1,
      sym_lower_case_identifier,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(778), 1,
      sym_left_parenthesis,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(834), 1,
      sym_as,
    STATE(414), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(832), 6,
      anon_sym_COLON_COLON,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
    STATE(234), 14,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__union_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_union_pattern_repeat1,
  [15731] = 7,
    STATE(97), 1,
      sym_operator,
    STATE(241), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(449), 7,
      anon_sym_else,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
    ACTIONS(836), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15782] = 7,
    STATE(97), 1,
      sym_operator,
    STATE(248), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(425), 7,
      anon_sym_else,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
    ACTIONS(836), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15833] = 5,
    ACTIONS(838), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(242), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(433), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(438), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15880] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(605), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(607), 28,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15923] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(589), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 28,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15966] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(637), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(639), 28,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16009] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(242), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(427), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(429), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16054] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 9,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      sym_pipe,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 25,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16097] = 7,
    STATE(97), 1,
      sym_operator,
    STATE(248), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(442), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 7,
      anon_sym_else,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
    ACTIONS(841), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16148] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(653), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 28,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16191] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(657), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(659), 28,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_as,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16234] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    ACTIONS(848), 1,
      sym_arrow,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [16314] = 5,
    ACTIONS(850), 1,
      sym__dot_without_leading_whitespace,
    STATE(252), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16360] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    ACTIONS(853), 1,
      sym_arrow,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [16440] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    ACTIONS(855), 1,
      sym_arrow,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [16520] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    ACTIONS(857), 1,
      sym_arrow,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [16600] = 5,
    ACTIONS(859), 1,
      sym__dot_without_leading_whitespace,
    STATE(252), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(453), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(457), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16646] = 5,
    ACTIONS(861), 1,
      sym__dot_without_leading_whitespace,
    STATE(229), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(506), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(510), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16692] = 22,
    ACTIONS(863), 1,
      sym_lower_case_identifier,
    ACTIONS(866), 1,
      sym_upper_case_identifier,
    ACTIONS(869), 1,
      aux_sym_number_literal_token1,
    ACTIONS(872), 1,
      sym__hex_literal,
    ACTIONS(875), 1,
      sym_left_parenthesis,
    ACTIONS(878), 1,
      sym_left_square_bracket,
    ACTIONS(881), 1,
      sym_left_brace,
    ACTIONS(884), 1,
      sym_arrow,
    ACTIONS(886), 1,
      sym_underscore,
    ACTIONS(889), 1,
      sym__char_quote,
    ACTIONS(892), 1,
      sym_open_quote,
    ACTIONS(895), 1,
      sym_open_quote_multiline,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [16772] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    ACTIONS(898), 1,
      sym_arrow,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [16852] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(553), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 29,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_exposing,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16894] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(531), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 29,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      sym_exposing,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16936] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    ACTIONS(900), 1,
      sym_arrow,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(258), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17016] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(262), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17093] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(545), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17134] = 4,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(520), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(535), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17177] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(598), 1,
      sym_case_of_branch,
    STATE(618), 1,
      sym_open_char,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17256] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(581), 1,
      sym_case_of_branch,
    STATE(618), 1,
      sym_open_char,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17335] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(254), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17412] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(904), 1,
      sym_right_square_bracket,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(663), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17491] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(906), 1,
      sym_right_parenthesis,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(820), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17570] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(549), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(551), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17611] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(541), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(543), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17652] = 4,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17695] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(908), 1,
      sym_right_parenthesis,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(775), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [17774] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(524), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(526), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17815] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(512), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17856] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 27,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17897] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(577), 5,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(579), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17938] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(910), 1,
      sym_right_square_bracket,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(691), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18017] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(815), 1,
      sym_case_of_branch,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18096] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(582), 1,
      sym_case_of_branch,
    STATE(618), 1,
      sym_open_char,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18175] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(588), 1,
      sym_case_of_branch,
    STATE(618), 1,
      sym_open_char,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18254] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(259), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18331] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(580), 1,
      sym_case_of_branch,
    STATE(618), 1,
      sym_open_char,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18410] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(251), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18487] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(537), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 28,
      sym__dot_without_leading_whitespace,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18528] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(255), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18605] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(908), 1,
      sym_right_parenthesis,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(789), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18684] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(846), 1,
      sym_left_parenthesis,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(460), 1,
      sym_cons_pattern,
    STATE(461), 1,
      sym__single_pattern,
    STATE(466), 1,
      sym__parenthesized_single_pattern,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(253), 2,
      sym_pattern,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(779), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(459), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18761] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(906), 1,
      sym_right_parenthesis,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(772), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18840] = 22,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(595), 1,
      sym_case_of_branch,
    STATE(618), 1,
      sym_open_char,
    STATE(922), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18919] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(621), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(623), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18959] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(641), 6,
      sym_pipe,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(643), 25,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18999] = 7,
    STATE(414), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(776), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(770), 11,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
    STATE(238), 14,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__union_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_union_pattern_repeat1,
  [19047] = 7,
    STATE(414), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(834), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(832), 11,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
    STATE(294), 14,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym__union_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_union_pattern_repeat1,
  [19095] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(804), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [19171] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(710), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [19247] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(565), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19287] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(649), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19327] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(661), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(663), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19367] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(569), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(571), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19407] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(573), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19447] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(617), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(619), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19487] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(581), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(583), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19527] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(440), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19567] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(557), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(559), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19607] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(629), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(631), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19647] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(625), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19687] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(821), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [19763] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(561), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19803] = 21,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(27), 1,
      sym_left_parenthesis,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(530), 1,
      sym_cons_pattern,
    STATE(544), 1,
      sym__single_pattern,
    STATE(566), 1,
      sym__parenthesized_single_pattern,
    STATE(618), 1,
      sym_open_char,
    STATE(664), 1,
      sym_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(771), 2,
      sym__single_pattern_cons,
      sym__parenthesized_pattern,
    STATE(528), 11,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [19879] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(613), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(615), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19919] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(609), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(611), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19959] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(601), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(603), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19999] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(641), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(643), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20039] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(597), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(599), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20079] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(585), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20119] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(593), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(595), 27,
      anon_sym_else,
      anon_sym_COLON_COLON,
      anon_sym_then,
      sym_of,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20159] = 18,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(768), 1,
      sym_lower_case_identifier,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(778), 1,
      sym_left_parenthesis,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(912), 1,
      anon_sym_COLON_COLON,
    ACTIONS(914), 1,
      sym_as,
    ACTIONS(916), 1,
      sym_eq,
    ACTIONS(918), 1,
      sym_colon,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(374), 13,
      sym__function_declaration_pattern,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_function_declaration_left_repeat1,
  [20227] = 7,
    STATE(114), 1,
      sym_operator,
    STATE(324), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(425), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(836), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20273] = 5,
    ACTIONS(920), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(321), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(433), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(438), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20315] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(321), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(427), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(429), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20355] = 7,
    STATE(114), 1,
      sym_operator,
    STATE(320), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(449), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(836), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20401] = 7,
    STATE(114), 1,
      sym_operator,
    STATE(324), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(445), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(442), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(841), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20447] = 18,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(768), 1,
      sym_lower_case_identifier,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(778), 1,
      sym_left_parenthesis,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(912), 1,
      anon_sym_COLON_COLON,
    ACTIONS(914), 1,
      sym_as,
    ACTIONS(916), 1,
      sym_eq,
    ACTIONS(923), 1,
      sym_colon,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(374), 13,
      sym__function_declaration_pattern,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_function_declaration_left_repeat1,
  [20515] = 7,
    ACTIONS(445), 1,
      sym__virtual_end_decl,
    STATE(113), 1,
      sym_operator,
    STATE(326), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(442), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(841), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20560] = 5,
    ACTIONS(925), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(327), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(433), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(438), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20601] = 5,
    ACTIONS(928), 1,
      sym__dot_without_leading_whitespace,
    STATE(256), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(506), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(510), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20642] = 7,
    ACTIONS(449), 1,
      sym__virtual_end_decl,
    STATE(113), 1,
      sym_operator,
    STATE(331), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(836), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20687] = 4,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(327), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(427), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(429), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20726] = 7,
    ACTIONS(425), 1,
      sym__virtual_end_decl,
    STATE(113), 1,
      sym_operator,
    STATE(326), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(433), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(423), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(836), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20771] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(545), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20807] = 5,
    ACTIONS(930), 1,
      sym__dot_without_leading_whitespace,
    STATE(235), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(506), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(510), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20847] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(524), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(526), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20883] = 4,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(520), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(535), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20921] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(512), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20957] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(541), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(543), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20993] = 16,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    ACTIONS(29), 1,
      sym_left_square_bracket,
    ACTIONS(31), 1,
      sym_left_brace,
    ACTIONS(33), 1,
      sym_underscore,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(37), 1,
      sym_open_quote,
    ACTIONS(39), 1,
      sym_open_quote_multiline,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    ACTIONS(932), 1,
      sym_left_parenthesis,
    STATE(239), 1,
      sym_upper_case_qid,
    STATE(249), 1,
      sym_number_literal,
    STATE(618), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(553), 13,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym__single_pattern_cons,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [21055] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(549), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(551), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21091] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(553), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21127] = 16,
    ACTIONS(9), 1,
      sym_upper_case_identifier,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(778), 1,
      sym_left_parenthesis,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    STATE(295), 1,
      sym_upper_case_qid,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(463), 13,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym__single_pattern_cons,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [21189] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(531), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21225] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(537), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21261] = 4,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21299] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(537), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21334] = 15,
    ACTIONS(934), 1,
      sym_lower_case_identifier,
    ACTIONS(937), 1,
      aux_sym_number_literal_token1,
    ACTIONS(940), 1,
      sym__hex_literal,
    ACTIONS(943), 1,
      sym_left_parenthesis,
    ACTIONS(946), 1,
      sym_left_square_bracket,
    ACTIONS(949), 1,
      sym_left_brace,
    ACTIONS(952), 1,
      sym_eq,
    ACTIONS(954), 1,
      sym_underscore,
    ACTIONS(957), 1,
      sym__char_quote,
    ACTIONS(960), 1,
      sym_open_quote,
    ACTIONS(963), 1,
      sym_open_quote_multiline,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(346), 13,
      sym__function_declaration_pattern,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_function_declaration_left_repeat1,
  [21393] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(657), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(659), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21428] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(653), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21463] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(645), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(647), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21498] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(557), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(559), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21533] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(629), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(631), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21568] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(625), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21603] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(649), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21638] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(524), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(526), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21673] = 4,
    ACTIONS(518), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(520), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(535), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21710] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(561), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21745] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(573), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21780] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(621), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(623), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21815] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(613), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(615), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21850] = 4,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21887] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(609), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(611), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21922] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(545), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21957] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(440), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21992] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(585), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22027] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(601), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(603), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22062] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(637), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(639), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22097] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(581), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(583), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22132] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(565), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22167] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(589), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22202] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(605), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(607), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22237] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(597), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(599), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22272] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(593), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(595), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22307] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(553), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22342] = 15,
    ACTIONS(35), 1,
      sym__char_quote,
    ACTIONS(772), 1,
      aux_sym_number_literal_token1,
    ACTIONS(774), 1,
      sym__hex_literal,
    ACTIONS(778), 1,
      sym_left_parenthesis,
    ACTIONS(780), 1,
      sym_left_square_bracket,
    ACTIONS(782), 1,
      sym_left_brace,
    ACTIONS(784), 1,
      sym_underscore,
    ACTIONS(786), 1,
      sym_open_quote,
    ACTIONS(788), 1,
      sym_open_quote_multiline,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    ACTIONS(966), 1,
      sym_eq,
    STATE(418), 1,
      sym_number_literal,
    STATE(623), 1,
      sym_open_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(346), 13,
      sym__function_declaration_pattern,
      sym__literal_expr_group,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
      aux_sym_function_declaration_left_repeat1,
  [22401] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(541), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(543), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22436] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(549), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(551), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22471] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(531), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(533), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22506] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(569), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(571), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22541] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(512), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 22,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22576] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(577), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(579), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22611] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(617), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(619), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22646] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(661), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(663), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22681] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(617), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(619), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22715] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(557), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(559), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22749] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(653), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(655), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22783] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(645), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(647), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22817] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(609), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(611), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22851] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(613), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(615), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22885] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(569), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(571), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22919] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(577), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(579), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22953] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(440), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22987] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(597), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(599), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23021] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(661), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(663), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23055] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(621), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(623), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23089] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(561), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23123] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(625), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(627), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23157] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(601), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(603), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23191] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(657), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(659), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23225] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(637), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(639), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23259] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(585), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23293] = 4,
    STATE(915), 1,
      sym_operator_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(173), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(968), 20,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23329] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(565), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23363] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(629), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(631), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23397] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(581), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(583), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23431] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(605), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(607), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23465] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(593), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(595), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23499] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(589), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23533] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(573), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23567] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(649), 4,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 21,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23601] = 5,
    ACTIONS(970), 1,
      sym__dot_without_leading_whitespace,
    STATE(410), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(484), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23634] = 5,
    ACTIONS(973), 1,
      sym__dot_without_leading_whitespace,
    STATE(412), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(506), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(510), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23667] = 5,
    ACTIONS(973), 1,
      sym__dot_without_leading_whitespace,
    STATE(410), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(453), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(457), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23700] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(479), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(484), 16,
      sym_open_quote,
      sym_open_quote_multiline,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23728] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(975), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(977), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23755] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(605), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(607), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23782] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(979), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(981), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23809] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(983), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(985), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23836] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(653), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(655), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23863] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(657), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(659), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23890] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(641), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(643), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23917] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(987), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(989), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23944] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(637), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(639), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23971] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(914), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(912), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [23998] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(991), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(993), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24025] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(995), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(997), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24052] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(999), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1001), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24079] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1003), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1005), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24106] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1007), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1009), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24133] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1011), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1013), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24160] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(645), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(647), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24187] = 6,
    ACTIONS(1019), 1,
      sym_import,
    STATE(431), 1,
      aux_sym__import_list,
    STATE(897), 1,
      sym_import_clause,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1017), 5,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(1015), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      ts_builtin_sym_end,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_underscore,
      sym__char_quote,
  [24220] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(589), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(591), 15,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_square_bracket,
      sym_right_square_bracket,
      sym_left_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24247] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1024), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(1022), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
  [24273] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 4,
      sym_minus_without_trailing_whitespace,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_backslash,
    ACTIONS(1026), 13,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym__hex_literal,
      anon_sym_if,
      sym_case,
      anon_sym_let,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_dot,
      sym_glsl_begin,
      sym__char_quote,
  [24299] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1017), 6,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_import,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(1015), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      ts_builtin_sym_end,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_underscore,
      sym__char_quote,
  [24324] = 11,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    STATE(437), 1,
      aux_sym_union_variant_repeat1,
    STATE(495), 1,
      sym__single_type_expression,
    STATE(496), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1036), 4,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
      sym_arrow,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24365] = 11,
    ACTIONS(1040), 1,
      sym_lower_case_identifier,
    ACTIONS(1043), 1,
      sym_upper_case_identifier,
    ACTIONS(1046), 1,
      sym_left_parenthesis,
    ACTIONS(1051), 1,
      sym_left_brace,
    STATE(437), 1,
      aux_sym_union_variant_repeat1,
    STATE(495), 1,
      sym__single_type_expression,
    STATE(496), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1049), 4,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
      sym_arrow,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24406] = 11,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    STATE(436), 1,
      aux_sym_union_variant_repeat1,
    STATE(495), 1,
      sym__single_type_expression,
    STATE(496), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1054), 4,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
      sym_arrow,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24447] = 11,
    ACTIONS(1056), 1,
      sym_lower_case_identifier,
    ACTIONS(1059), 1,
      sym_upper_case_identifier,
    ACTIONS(1062), 1,
      sym_left_parenthesis,
    ACTIONS(1065), 1,
      sym_left_brace,
    STATE(439), 1,
      aux_sym_union_variant_repeat1,
    STATE(534), 1,
      sym__single_type_expression,
    STATE(535), 1,
      sym_upper_case_qid,
    STATE(537), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1049), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(538), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24487] = 5,
    ACTIONS(1070), 1,
      anon_sym_COLON_COLON,
    STATE(440), 1,
      aux_sym_cons_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1068), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1073), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24515] = 11,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    ACTIONS(1075), 1,
      sym_right_parenthesis,
    STATE(438), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    STATE(705), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(572), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24555] = 5,
    ACTIONS(1079), 1,
      anon_sym_COLON_COLON,
    STATE(440), 1,
      aux_sym_cons_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1077), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1081), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [24583] = 11,
    ACTIONS(1083), 1,
      sym_lower_case_identifier,
    ACTIONS(1085), 1,
      sym_upper_case_identifier,
    ACTIONS(1087), 1,
      sym_left_parenthesis,
    ACTIONS(1089), 1,
      sym_left_brace,
    STATE(439), 1,
      aux_sym_union_variant_repeat1,
    STATE(534), 1,
      sym__single_type_expression,
    STATE(535), 1,
      sym_upper_case_qid,
    STATE(537), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1036), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(538), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24623] = 11,
    ACTIONS(1091), 1,
      sym_lower_case_identifier,
    ACTIONS(1094), 1,
      sym_upper_case_identifier,
    ACTIONS(1097), 1,
      sym_left_parenthesis,
    ACTIONS(1100), 1,
      sym_left_brace,
    STATE(444), 1,
      aux_sym_union_variant_repeat1,
    STATE(549), 1,
      sym__single_type_expression,
    STATE(550), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1049), 3,
      sym__virtual_end_decl,
      sym_arrow,
      sym_pipe,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24663] = 11,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    ACTIONS(1103), 1,
      sym_right_parenthesis,
    STATE(438), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    STATE(683), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(572), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24703] = 11,
    ACTIONS(906), 1,
      sym_right_parenthesis,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    STATE(438), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    STATE(708), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(572), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24743] = 11,
    ACTIONS(1083), 1,
      sym_lower_case_identifier,
    ACTIONS(1085), 1,
      sym_upper_case_identifier,
    ACTIONS(1087), 1,
      sym_left_parenthesis,
    ACTIONS(1089), 1,
      sym_left_brace,
    STATE(443), 1,
      aux_sym_union_variant_repeat1,
    STATE(534), 1,
      sym__single_type_expression,
    STATE(535), 1,
      sym_upper_case_qid,
    STATE(537), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1054), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(538), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24783] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1105), 5,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(705), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      ts_builtin_sym_end,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_underscore,
      sym__char_quote,
  [24807] = 11,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(444), 1,
      aux_sym_union_variant_repeat1,
    STATE(549), 1,
      sym__single_type_expression,
    STATE(550), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1036), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24846] = 10,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(462), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    STATE(830), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(679), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24883] = 11,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(453), 1,
      aux_sym_union_variant_repeat1,
    STATE(549), 1,
      sym__single_type_expression,
    STATE(550), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1115), 2,
      sym__virtual_end_decl,
      sym_pipe,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24922] = 10,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(462), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    STATE(850), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(679), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24959] = 11,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(444), 1,
      aux_sym_union_variant_repeat1,
    STATE(549), 1,
      sym__single_type_expression,
    STATE(550), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1117), 2,
      sym__virtual_end_decl,
      sym_pipe,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [24998] = 4,
    ACTIONS(1005), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1119), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1121), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25023] = 10,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    STATE(438), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    STATE(755), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(572), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25060] = 10,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(462), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    STATE(852), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(679), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25097] = 10,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    STATE(438), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    STATE(759), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(572), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25134] = 10,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(462), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    STATE(875), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(679), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25171] = 4,
    ACTIONS(1125), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1123), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1127), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25196] = 5,
    ACTIONS(1133), 1,
      sym_as,
    STATE(469), 1,
      sym__pattern_as,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1129), 2,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
    ACTIONS(1131), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25223] = 5,
    ACTIONS(1133), 1,
      sym_as,
    STATE(471), 1,
      sym__pattern_as,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1135), 2,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
    ACTIONS(1137), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25250] = 11,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(449), 1,
      aux_sym_union_variant_repeat1,
    STATE(549), 1,
      sym__single_type_expression,
    STATE(550), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1054), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25289] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1139), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1141), 11,
      sym_open_quote,
      sym_open_quote_multiline,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25312] = 10,
    ACTIONS(1083), 1,
      sym_lower_case_identifier,
    ACTIONS(1085), 1,
      sym_upper_case_identifier,
    ACTIONS(1087), 1,
      sym_left_parenthesis,
    ACTIONS(1089), 1,
      sym_left_brace,
    STATE(447), 1,
      sym_upper_case_qid,
    STATE(537), 1,
      sym_unit_expr,
    STATE(782), 1,
      sym_type_expression,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(596), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(538), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25349] = 9,
    ACTIONS(1107), 1,
      sym_lower_case_identifier,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    ACTIONS(1111), 1,
      sym_left_parenthesis,
    ACTIONS(1113), 1,
      sym_left_brace,
    STATE(462), 1,
      sym_upper_case_qid,
    STATE(563), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(802), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(562), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25383] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1143), 3,
      sym_lower_case_identifier,
      aux_sym_number_literal_token1,
      sym_as,
    ACTIONS(1145), 10,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25405] = 9,
    ACTIONS(1083), 1,
      sym_lower_case_identifier,
    ACTIONS(1085), 1,
      sym_upper_case_identifier,
    ACTIONS(1087), 1,
      sym_left_parenthesis,
    ACTIONS(1089), 1,
      sym_left_brace,
    STATE(447), 1,
      sym_upper_case_qid,
    STATE(537), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(617), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(538), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25439] = 9,
    ACTIONS(1030), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    ACTIONS(1034), 1,
      sym_left_parenthesis,
    ACTIONS(1038), 1,
      sym_left_brace,
    STATE(438), 1,
      sym_upper_case_qid,
    STATE(501), 1,
      sym_unit_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(592), 3,
      sym__type_expression_inner,
      sym_type_ref,
      sym__single_type_expression,
    STATE(502), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [25473] = 3,
    ACTIONS(1149), 1,
      aux_sym_number_literal_token1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1147), 11,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25494] = 3,
    ACTIONS(1153), 1,
      aux_sym_number_literal_token1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1151), 11,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25515] = 3,
    ACTIONS(1157), 1,
      aux_sym_number_literal_token1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1155), 11,
      sym_open_quote,
      sym_open_quote_multiline,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym__hex_literal,
      sym_left_parenthesis,
      sym_left_square_bracket,
      sym_left_brace,
      sym_arrow,
      sym_underscore,
      sym__char_quote,
  [25536] = 5,
    ACTIONS(764), 1,
      sym__dot_without_leading_whitespace,
    STATE(229), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(506), 3,
      sym_lower_case_identifier,
      sym_where,
      sym_exposing,
    ACTIONS(510), 7,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25561] = 5,
    ACTIONS(790), 1,
      sym__dot_without_leading_whitespace,
    STATE(235), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(506), 3,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
    ACTIONS(510), 6,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [25585] = 7,
    ACTIONS(1159), 1,
      sym_lower_case_identifier,
    ACTIONS(1161), 1,
      sym_upper_case_identifier,
    ACTIONS(1163), 1,
      sym_left_parenthesis,
    ACTIONS(1165), 1,
      sym_double_dot,
    STATE(798), 1,
      sym__operator_as_function_inner,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(632), 4,
      sym__exposed_item,
      sym_exposed_value,
      sym_exposed_type,
      sym_exposed_operator,
  [25611] = 4,
    ACTIONS(859), 1,
      sym__dot_without_leading_whitespace,
    STATE(256), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(510), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [25631] = 5,
    ACTIONS(1171), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1169), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(520), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25652] = 5,
    ACTIONS(1177), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1175), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(482), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [25673] = 5,
    ACTIONS(1181), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25694] = 5,
    ACTIONS(1183), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25715] = 5,
    ACTIONS(1177), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1185), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(479), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25736] = 5,
    ACTIONS(1181), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [25757] = 5,
    ACTIONS(1183), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [25778] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1189), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25793] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1191), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25808] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1193), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25823] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1195), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25838] = 5,
    ACTIONS(1199), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1197), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(492), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25859] = 5,
    ACTIONS(1201), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [25880] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1203), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25895] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1205), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [25910] = 5,
    ACTIONS(1199), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1207), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(488), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [25931] = 5,
    ACTIONS(1201), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25952] = 6,
    ACTIONS(1159), 1,
      sym_lower_case_identifier,
    ACTIONS(1161), 1,
      sym_upper_case_identifier,
    ACTIONS(1163), 1,
      sym_left_parenthesis,
    STATE(798), 1,
      sym__operator_as_function_inner,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(750), 4,
      sym__exposed_item,
      sym_exposed_value,
      sym_exposed_type,
      sym_exposed_operator,
  [25975] = 5,
    ACTIONS(1209), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [25996] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1211), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [26011] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1054), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [26026] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1213), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [26041] = 5,
    ACTIONS(1217), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1215), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(481), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26062] = 5,
    ACTIONS(1221), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1219), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(494), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26083] = 5,
    ACTIONS(1221), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1223), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(519), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26104] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1225), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [26119] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1227), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [26134] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1229), 8,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_right_parenthesis,
      sym_left_brace,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [26149] = 5,
    ACTIONS(1171), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1231), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(521), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26170] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(912), 8,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_right_brace,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26185] = 4,
    ACTIONS(1233), 1,
      anon_sym_COLON_COLON,
    STATE(507), 1,
      aux_sym_cons_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1081), 6,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26204] = 4,
    ACTIONS(1235), 1,
      anon_sym_COLON_COLON,
    STATE(507), 1,
      aux_sym_cons_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1073), 6,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26223] = 5,
    ACTIONS(1244), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1238), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1241), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26244] = 5,
    ACTIONS(1252), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1246), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1249), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26265] = 5,
    ACTIONS(1254), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26286] = 5,
    ACTIONS(1254), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26307] = 5,
    ACTIONS(1258), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1256), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(510), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26328] = 5,
    ACTIONS(1217), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1260), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(478), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26349] = 5,
    ACTIONS(1258), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1262), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(511), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26370] = 5,
    ACTIONS(1264), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26391] = 5,
    ACTIONS(1264), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26412] = 5,
    ACTIONS(1268), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1266), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(515), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26433] = 5,
    ACTIONS(1268), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1270), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(516), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26454] = 5,
    ACTIONS(1209), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26475] = 5,
    ACTIONS(1272), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1167), 2,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
    ACTIONS(1179), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(509), 3,
      sym__string_part_multiline,
      aux_sym__string_parts_multiline,
      sym_regular_string_part_multiline,
  [26496] = 5,
    ACTIONS(1272), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1173), 2,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
    ACTIONS(1187), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(508), 3,
      sym__string_part,
      aux_sym__string_parts,
      sym_regular_string_part,
  [26517] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(985), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26531] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1005), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26545] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(981), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26559] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1195), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26573] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1191), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26587] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1189), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26601] = 3,
    ACTIONS(1125), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1127), 6,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26617] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1195), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26631] = 4,
    ACTIONS(1274), 1,
      sym_as,
    STATE(579), 1,
      sym__pattern_as,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1131), 5,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26649] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1203), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26663] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1205), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26677] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1189), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26691] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1211), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26705] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1054), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26719] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1213), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26733] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1225), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26747] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1227), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26761] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1203), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26775] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1229), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [26789] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1191), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26803] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1205), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26817] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(993), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26831] = 4,
    ACTIONS(1274), 1,
      sym_as,
    STATE(576), 1,
      sym__pattern_as,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1137), 5,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26849] = 3,
    ACTIONS(1005), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1121), 6,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26865] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1193), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26879] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1001), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26893] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(997), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26907] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1211), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26921] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1054), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26935] = 8,
    ACTIONS(1276), 1,
      sym_lower_case_identifier,
    ACTIONS(1278), 1,
      sym_right_brace,
    STATE(646), 1,
      sym_field,
    STATE(649), 1,
      sym__record_base,
    STATE(840), 1,
      sym__record_inner_fields,
    STATE(859), 1,
      sym__record_inner,
    STATE(868), 1,
      sym_record_base_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [26961] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1213), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [26975] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1141), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [26989] = 8,
    ACTIONS(1276), 1,
      sym_lower_case_identifier,
    ACTIONS(1280), 1,
      sym_right_brace,
    STATE(646), 1,
      sym_field,
    STATE(649), 1,
      sym__record_base,
    STATE(840), 1,
      sym__record_inner_fields,
    STATE(868), 1,
      sym_record_base_identifier,
    STATE(876), 1,
      sym__record_inner,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27015] = 8,
    ACTIONS(1276), 1,
      sym_lower_case_identifier,
    ACTIONS(1282), 1,
      sym_right_brace,
    STATE(646), 1,
      sym_field,
    STATE(649), 1,
      sym__record_base,
    STATE(831), 1,
      sym__record_inner,
    STATE(840), 1,
      sym__record_inner_fields,
    STATE(868), 1,
      sym_record_base_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27041] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(989), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27055] = 8,
    ACTIONS(1276), 1,
      sym_lower_case_identifier,
    ACTIONS(1284), 1,
      sym_right_brace,
    STATE(646), 1,
      sym_field,
    STATE(649), 1,
      sym__record_base,
    STATE(840), 1,
      sym__record_inner_fields,
    STATE(868), 1,
      sym_record_base_identifier,
    STATE(916), 1,
      sym__record_inner,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27081] = 8,
    ACTIONS(1276), 1,
      sym_lower_case_identifier,
    ACTIONS(1286), 1,
      sym_right_brace,
    STATE(646), 1,
      sym_field,
    STATE(649), 1,
      sym__record_base,
    STATE(840), 1,
      sym__record_inner_fields,
    STATE(862), 1,
      sym__record_inner,
    STATE(868), 1,
      sym_record_base_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27107] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1013), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27121] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1229), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [27135] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1193), 7,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
  [27149] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1227), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [27163] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1225), 7,
      sym__virtual_end_decl,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_left_parenthesis,
      sym_left_brace,
      sym_arrow,
      sym_pipe,
  [27177] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1009), 7,
      anon_sym_COLON_COLON,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27191] = 8,
    ACTIONS(1276), 1,
      sym_lower_case_identifier,
    ACTIONS(1288), 1,
      sym_right_brace,
    STATE(646), 1,
      sym_field,
    STATE(649), 1,
      sym__record_base,
    STATE(840), 1,
      sym__record_inner_fields,
    STATE(868), 1,
      sym_record_base_identifier,
    STATE(895), 1,
      sym__record_inner,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27217] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1145), 6,
      sym_as,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27230] = 4,
    ACTIONS(1292), 1,
      sym_arrow,
    STATE(567), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1290), 3,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
  [27246] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1151), 5,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27258] = 5,
    ACTIONS(1295), 1,
      sym_lower_case_identifier,
    ACTIONS(1297), 1,
      sym_upper_case_identifier,
    STATE(853), 1,
      sym_value_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(376), 2,
      sym_upper_case_qid,
      sym_value_qid,
  [27276] = 4,
    ACTIONS(1301), 1,
      sym_arrow,
    STATE(567), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1299), 3,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
  [27292] = 6,
    ACTIONS(1303), 1,
      sym_lower_case_identifier,
    ACTIONS(1305), 1,
      sym_right_brace,
    STATE(704), 1,
      sym_field_type,
    STATE(763), 1,
      sym__record_base,
    STATE(868), 1,
      sym_record_base_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27312] = 4,
    ACTIONS(1301), 1,
      sym_arrow,
    STATE(570), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1307), 3,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
  [27328] = 3,
    ACTIONS(1311), 1,
      sym_close_quote,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1309), 4,
      aux_sym_regular_string_part_token1,
      aux_sym_regular_string_part_token2,
      sym_string_escape,
      sym_invalid_string_escape,
  [27342] = 3,
    ACTIONS(1315), 1,
      sym_close_quote_multiline,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1313), 4,
      aux_sym_regular_string_part_multiline_token1,
      aux_sym_regular_string_part_multiline_token2,
      sym_string_escape,
      sym_invalid_string_escape,
  [27356] = 6,
    ACTIONS(1303), 1,
      sym_lower_case_identifier,
    ACTIONS(1317), 1,
      sym_right_brace,
    STATE(680), 1,
      sym_field_type,
    STATE(791), 1,
      sym__record_base,
    STATE(868), 1,
      sym_record_base_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27376] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1155), 5,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27388] = 6,
    ACTIONS(1319), 1,
      sym_as,
    ACTIONS(1321), 1,
      sym_exposing,
    ACTIONS(1323), 1,
      sym__virtual_end_decl,
    STATE(712), 1,
      sym_as_clause,
    STATE(914), 1,
      sym_exposing_list,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27408] = 6,
    ACTIONS(1303), 1,
      sym_lower_case_identifier,
    ACTIONS(1325), 1,
      sym_right_brace,
    STATE(709), 1,
      sym_field_type,
    STATE(768), 1,
      sym__record_base,
    STATE(868), 1,
      sym_record_base_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27428] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1147), 5,
      sym_right_parenthesis,
      sym_right_square_bracket,
      sym_comma,
      sym_eq,
      sym_arrow,
  [27440] = 5,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1329), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(869), 1,
      sym__more_case_of_branches,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27457] = 5,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1331), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(849), 1,
      sym__more_case_of_branches,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27474] = 5,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1333), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(842), 1,
      sym__more_case_of_branches,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27491] = 4,
    ACTIONS(1335), 1,
      sym_lower_case_identifier,
    ACTIONS(1337), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(584), 2,
      sym_lower_type_name,
      aux_sym_type_declaration_repeat1,
  [27506] = 4,
    ACTIONS(1335), 1,
      sym_lower_case_identifier,
    ACTIONS(1339), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(599), 2,
      sym_lower_type_name,
      aux_sym_type_declaration_repeat1,
  [27521] = 5,
    ACTIONS(1341), 1,
      sym_pipe,
    ACTIONS(1343), 1,
      sym__virtual_end_decl,
    STATE(594), 1,
      aux_sym_type_declaration_repeat2,
    STATE(783), 1,
      sym__more_union_variants,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27538] = 4,
    ACTIONS(1335), 1,
      sym_lower_case_identifier,
    ACTIONS(1345), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(587), 2,
      sym_lower_type_name,
      aux_sym_type_declaration_repeat1,
  [27553] = 4,
    ACTIONS(1335), 1,
      sym_lower_case_identifier,
    ACTIONS(1347), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(599), 2,
      sym_lower_type_name,
      aux_sym_type_declaration_repeat1,
  [27568] = 5,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1349), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(837), 1,
      sym__more_case_of_branches,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27585] = 4,
    ACTIONS(1351), 1,
      sym_arrow,
    STATE(589), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1290), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [27600] = 5,
    ACTIONS(1341), 1,
      sym_pipe,
    ACTIONS(1354), 1,
      sym__virtual_end_decl,
    STATE(591), 1,
      aux_sym_type_declaration_repeat2,
    STATE(783), 1,
      sym__more_union_variants,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27617] = 5,
    ACTIONS(1356), 1,
      sym_pipe,
    ACTIONS(1359), 1,
      sym__virtual_end_decl,
    STATE(591), 1,
      aux_sym_type_declaration_repeat2,
    STATE(783), 1,
      sym__more_union_variants,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27634] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1361), 4,
      sym_right_parenthesis,
      sym_right_brace,
      sym_comma,
      sym_arrow,
  [27645] = 5,
    ACTIONS(1341), 1,
      sym_pipe,
    ACTIONS(1363), 1,
      sym__virtual_end_decl,
    STATE(590), 1,
      aux_sym_type_declaration_repeat2,
    STATE(783), 1,
      sym__more_union_variants,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27662] = 5,
    ACTIONS(1341), 1,
      sym_pipe,
    ACTIONS(1365), 1,
      sym__virtual_end_decl,
    STATE(591), 1,
      aux_sym_type_declaration_repeat2,
    STATE(783), 1,
      sym__more_union_variants,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27679] = 5,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1367), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(920), 1,
      sym__more_case_of_branches,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27696] = 4,
    ACTIONS(1369), 1,
      sym_arrow,
    STATE(600), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1307), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [27711] = 4,
    ACTIONS(1371), 1,
      sym_left_parenthesis,
    STATE(748), 1,
      sym_exposed_union_constructors,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1373), 2,
      sym_right_parenthesis,
      sym_comma,
  [27726] = 5,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1375), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(879), 1,
      sym__more_case_of_branches,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27743] = 4,
    ACTIONS(1377), 1,
      sym_lower_case_identifier,
    ACTIONS(1380), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(599), 2,
      sym_lower_type_name,
      aux_sym_type_declaration_repeat1,
  [27758] = 4,
    ACTIONS(1369), 1,
      sym_arrow,
    STATE(589), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1299), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [27773] = 4,
    ACTIONS(1382), 1,
      sym_right_parenthesis,
    ACTIONS(1384), 1,
      sym_comma,
    STATE(613), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27787] = 4,
    ACTIONS(1386), 1,
      sym_right_parenthesis,
    ACTIONS(1388), 1,
      sym_comma,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27801] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1390), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27811] = 4,
    ACTIONS(1392), 1,
      sym_right_parenthesis,
    ACTIONS(1394), 1,
      sym_comma,
    STATE(684), 1,
      aux_sym_exposing_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27825] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1396), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27835] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1398), 3,
      anon_sym_left,
      anon_sym_right,
      anon_sym_non,
  [27845] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1400), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27855] = 4,
    ACTIONS(1402), 1,
      anon_sym_else,
    STATE(98), 1,
      sym__else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27869] = 4,
    ACTIONS(1404), 1,
      sym_right_brace,
    ACTIONS(1406), 1,
      sym_comma,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27883] = 4,
    ACTIONS(1408), 1,
      sym_right_brace,
    ACTIONS(1410), 1,
      sym_comma,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27897] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1413), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27907] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1415), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27917] = 4,
    ACTIONS(1417), 1,
      sym_right_parenthesis,
    ACTIONS(1419), 1,
      sym_comma,
    STATE(613), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27931] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1422), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27941] = 4,
    ACTIONS(1424), 1,
      anon_sym_else,
    STATE(396), 1,
      sym__else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27955] = 4,
    ACTIONS(1426), 1,
      sym_right_brace,
    ACTIONS(1428), 1,
      sym_comma,
    STATE(718), 1,
      aux_sym__record_inner_fields_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [27969] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1361), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [27979] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1430), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [27989] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1432), 1,
      sym_right_parenthesis,
    STATE(688), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28003] = 4,
    ACTIONS(1434), 1,
      sym_right_square_bracket,
    ACTIONS(1436), 1,
      sym_comma,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28017] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1438), 1,
      sym_right_parenthesis,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28031] = 4,
    ACTIONS(1440), 1,
      sym__virtual_end_decl,
    ACTIONS(1442), 1,
      sym__virtual_end_section,
    STATE(689), 1,
      aux_sym__more_inner_declarations,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28045] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1444), 3,
      sym_regular_char,
      sym_string_escape,
      sym_invalid_string_escape,
  [28055] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1446), 1,
      sym_right_parenthesis,
    STATE(630), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28069] = 4,
    ACTIONS(1448), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1450), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28083] = 4,
    ACTIONS(1452), 1,
      sym_right_parenthesis,
    ACTIONS(1454), 1,
      sym_comma,
    STATE(676), 1,
      aux_sym_tuple_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28097] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1456), 1,
      sym_right_parenthesis,
    STATE(648), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28111] = 4,
    ACTIONS(1458), 1,
      anon_sym_else,
    STATE(160), 1,
      sym__else,
    STATE(714), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28125] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1460), 1,
      sym_right_square_bracket,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28139] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1462), 1,
      sym_right_parenthesis,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28153] = 4,
    ACTIONS(1448), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1464), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28167] = 4,
    ACTIONS(1394), 1,
      sym_comma,
    ACTIONS(1466), 1,
      sym_right_parenthesis,
    STATE(604), 1,
      aux_sym_exposing_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28181] = 4,
    ACTIONS(1468), 1,
      anon_sym_else,
    STATE(160), 1,
      sym__else,
    STATE(714), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28195] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1470), 1,
      sym_right_square_bracket,
    STATE(629), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28209] = 4,
    ACTIONS(1290), 1,
      sym__virtual_end_decl,
    ACTIONS(1472), 1,
      sym_arrow,
    STATE(635), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28223] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1446), 1,
      sym_right_parenthesis,
    STATE(648), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28237] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1475), 1,
      sym_right_brace,
    STATE(609), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28251] = 4,
    ACTIONS(1477), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1479), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(631), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28265] = 3,
    ACTIONS(1481), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(322), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
  [28277] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1483), 1,
      sym_right_brace,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28291] = 4,
    ACTIONS(1485), 1,
      sym__virtual_end_decl,
    ACTIONS(1488), 1,
      sym__virtual_end_section,
    STATE(641), 1,
      aux_sym__more_case_of_branches_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28305] = 4,
    ACTIONS(1384), 1,
      sym_comma,
    ACTIONS(1490), 1,
      sym_right_parenthesis,
    STATE(613), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28319] = 4,
    ACTIONS(1424), 1,
      anon_sym_else,
    STATE(406), 1,
      sym__else,
    STATE(615), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28333] = 4,
    ACTIONS(1458), 1,
      anon_sym_else,
    STATE(372), 1,
      sym__else,
    STATE(659), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28347] = 4,
    ACTIONS(1327), 1,
      sym__virtual_end_decl,
    ACTIONS(1492), 1,
      sym__virtual_end_section,
    STATE(641), 1,
      aux_sym__more_case_of_branches_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28361] = 4,
    ACTIONS(1428), 1,
      sym_comma,
    ACTIONS(1494), 1,
      sym_right_brace,
    STATE(616), 1,
      aux_sym__record_inner_fields_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28375] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1496), 1,
      sym_right_square_bracket,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28389] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1498), 1,
      sym_right_parenthesis,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28403] = 4,
    ACTIONS(1500), 1,
      sym_lower_case_identifier,
    STATE(646), 1,
      sym_field,
    STATE(891), 1,
      sym__record_inner_fields,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28417] = 4,
    ACTIONS(1448), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1502), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28431] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1504), 1,
      sym_right_square_bracket,
    STATE(620), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28445] = 4,
    ACTIONS(1506), 1,
      anon_sym_else,
    STATE(372), 1,
      sym__else,
    STATE(659), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28459] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1432), 1,
      sym_right_parenthesis,
    STATE(621), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28473] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1508), 1,
      sym_right_square_bracket,
    STATE(647), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28487] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1510), 1,
      sym_right_parenthesis,
    STATE(668), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28501] = 4,
    ACTIONS(1512), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1514), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(650), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28515] = 4,
    ACTIONS(1516), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1518), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(625), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28529] = 4,
    ACTIONS(1520), 1,
      sym_right_brace,
    ACTIONS(1522), 1,
      sym_comma,
    STATE(658), 1,
      aux_sym_record_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28543] = 4,
    ACTIONS(1506), 1,
      anon_sym_else,
    STATE(352), 1,
      sym__else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28557] = 3,
    ACTIONS(1525), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(119), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
  [28569] = 4,
    ACTIONS(1527), 1,
      sym_right_square_bracket,
    ACTIONS(1529), 1,
      sym_comma,
    STATE(661), 1,
      aux_sym_list_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28583] = 4,
    ACTIONS(11), 1,
      aux_sym_number_literal_token1,
    ACTIONS(13), 1,
      sym__hex_literal,
    STATE(739), 1,
      sym_number_literal,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28597] = 4,
    ACTIONS(1532), 1,
      sym_right_square_bracket,
    ACTIONS(1534), 1,
      sym_comma,
    STATE(723), 1,
      aux_sym_list_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28611] = 4,
    ACTIONS(1454), 1,
      sym_comma,
    ACTIONS(1536), 1,
      sym_right_parenthesis,
    STATE(626), 1,
      aux_sym_tuple_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28625] = 4,
    ACTIONS(1538), 1,
      sym_right_brace,
    ACTIONS(1540), 1,
      sym_comma,
    STATE(717), 1,
      aux_sym_record_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28639] = 4,
    ACTIONS(1458), 1,
      anon_sym_else,
    STATE(89), 1,
      sym__else,
    STATE(608), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28653] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1542), 1,
      sym_right_square_bracket,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28667] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1544), 1,
      sym_right_parenthesis,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28681] = 4,
    ACTIONS(1448), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1546), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28695] = 4,
    ACTIONS(1402), 1,
      anon_sym_else,
    STATE(89), 1,
      sym__else,
    STATE(608), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28709] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1548), 1,
      sym_right_square_bracket,
    STATE(667), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28723] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1550), 1,
      sym_right_parenthesis,
    STATE(602), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28737] = 4,
    ACTIONS(1552), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1554), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(669), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28751] = 3,
    ACTIONS(1556), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(246), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
  [28763] = 4,
    ACTIONS(1299), 1,
      sym__virtual_end_decl,
    ACTIONS(1558), 1,
      sym_arrow,
    STATE(635), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28777] = 4,
    ACTIONS(1560), 1,
      sym_right_parenthesis,
    ACTIONS(1562), 1,
      sym_comma,
    STATE(676), 1,
      aux_sym_tuple_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28791] = 4,
    ACTIONS(1458), 1,
      anon_sym_else,
    STATE(406), 1,
      sym__else,
    STATE(615), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28805] = 4,
    ACTIONS(1565), 1,
      sym__virtual_end_decl,
    ACTIONS(1568), 1,
      sym__virtual_end_section,
    STATE(678), 1,
      aux_sym__more_inner_declarations,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28819] = 4,
    ACTIONS(1307), 1,
      sym__virtual_end_decl,
    ACTIONS(1558), 1,
      sym_arrow,
    STATE(675), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28833] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1570), 1,
      sym_right_brace,
    STATE(640), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28847] = 4,
    ACTIONS(1572), 1,
      anon_sym_else,
    STATE(308), 1,
      sym__else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28861] = 4,
    ACTIONS(1458), 1,
      anon_sym_else,
    STATE(217), 1,
      sym__else,
    STATE(720), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28875] = 4,
    ACTIONS(1384), 1,
      sym_comma,
    ACTIONS(1574), 1,
      sym_right_parenthesis,
    STATE(642), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28889] = 4,
    ACTIONS(1576), 1,
      sym_right_parenthesis,
    ACTIONS(1578), 1,
      sym_comma,
    STATE(684), 1,
      aux_sym_exposing_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28903] = 4,
    ACTIONS(1581), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1584), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28917] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1586), 1,
      sym_right_brace,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28931] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1588), 1,
      sym_right_square_bracket,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28945] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1590), 1,
      sym_right_parenthesis,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28959] = 4,
    ACTIONS(1440), 1,
      sym__virtual_end_decl,
    ACTIONS(1592), 1,
      sym__virtual_end_section,
    STATE(678), 1,
      aux_sym__more_inner_declarations,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28973] = 4,
    ACTIONS(1448), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1594), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [28987] = 4,
    ACTIONS(1534), 1,
      sym_comma,
    ACTIONS(1596), 1,
      sym_right_square_bracket,
    STATE(698), 1,
      aux_sym_list_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29001] = 4,
    ACTIONS(1540), 1,
      sym_comma,
    ACTIONS(1598), 1,
      sym_right_brace,
    STATE(699), 1,
      aux_sym_record_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29015] = 3,
    ACTIONS(1600), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(129), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
  [29027] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1602), 1,
      sym_right_brace,
    STATE(686), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29041] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1604), 1,
      sym_right_brace,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29055] = 4,
    ACTIONS(1384), 1,
      sym_comma,
    ACTIONS(1606), 1,
      sym_right_parenthesis,
    STATE(613), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29069] = 4,
    ACTIONS(1608), 1,
      anon_sym_else,
    STATE(217), 1,
      sym__else,
    STATE(720), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29083] = 4,
    ACTIONS(1534), 1,
      sym_comma,
    ACTIONS(1610), 1,
      sym_right_square_bracket,
    STATE(661), 1,
      aux_sym_list_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29097] = 4,
    ACTIONS(1540), 1,
      sym_comma,
    ACTIONS(1612), 1,
      sym_right_brace,
    STATE(658), 1,
      aux_sym_record_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29111] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1614), 1,
      sym_right_square_bracket,
    STATE(687), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29125] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1510), 1,
      sym_right_parenthesis,
    STATE(602), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29139] = 4,
    ACTIONS(1616), 1,
      sym_right_parenthesis,
    ACTIONS(1618), 1,
      sym_comma,
    STATE(702), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29153] = 4,
    ACTIONS(1621), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1623), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(690), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29167] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1625), 1,
      sym_right_brace,
    STATE(695), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29181] = 4,
    ACTIONS(1384), 1,
      sym_comma,
    ACTIONS(1627), 1,
      sym_right_parenthesis,
    STATE(696), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29195] = 3,
    ACTIONS(1629), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(330), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
  [29207] = 3,
    ACTIONS(1631), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(25), 2,
      sym__field_access_segment,
      aux_sym_field_access_expr_repeat1,
  [29219] = 4,
    ACTIONS(1384), 1,
      sym_comma,
    ACTIONS(1633), 1,
      sym_right_parenthesis,
    STATE(601), 1,
      aux_sym_tuple_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29233] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1635), 1,
      sym_right_brace,
    STATE(724), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29247] = 4,
    ACTIONS(1454), 1,
      sym_comma,
    ACTIONS(1637), 1,
      sym_right_parenthesis,
    STATE(726), 1,
      aux_sym_tuple_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29261] = 4,
    ACTIONS(1639), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1641), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(727), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29275] = 4,
    ACTIONS(1321), 1,
      sym_exposing,
    ACTIONS(1643), 1,
      sym__virtual_end_decl,
    STATE(864), 1,
      sym_exposing_list,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29289] = 4,
    ACTIONS(1388), 1,
      sym_comma,
    ACTIONS(1645), 1,
      sym_right_parenthesis,
    STATE(621), 1,
      aux_sym_tuple_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29303] = 4,
    ACTIONS(1468), 1,
      anon_sym_else,
    STATE(164), 1,
      sym__else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29317] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1647), 1,
      sym_right_square_bracket,
    STATE(728), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29331] = 4,
    ACTIONS(1458), 1,
      anon_sym_else,
    STATE(318), 1,
      sym__else,
    STATE(681), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29345] = 4,
    ACTIONS(1540), 1,
      sym_comma,
    ACTIONS(1649), 1,
      sym_right_brace,
    STATE(658), 1,
      aux_sym_record_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29359] = 4,
    ACTIONS(1651), 1,
      sym_right_brace,
    ACTIONS(1653), 1,
      sym_comma,
    STATE(718), 1,
      aux_sym__record_inner_fields_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29373] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1656), 1,
      sym_right_brace,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29387] = 4,
    ACTIONS(1608), 1,
      anon_sym_else,
    STATE(204), 1,
      sym__else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29401] = 4,
    ACTIONS(1572), 1,
      anon_sym_else,
    STATE(318), 1,
      sym__else,
    STATE(681), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29415] = 4,
    ACTIONS(1658), 1,
      sym_right_square_bracket,
    ACTIONS(1660), 1,
      sym_comma,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29429] = 4,
    ACTIONS(1534), 1,
      sym_comma,
    ACTIONS(1663), 1,
      sym_right_square_bracket,
    STATE(661), 1,
      aux_sym_list_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29443] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1665), 1,
      sym_right_brace,
    STATE(610), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29457] = 4,
    ACTIONS(1406), 1,
      sym_comma,
    ACTIONS(1667), 1,
      sym_right_brace,
    STATE(719), 1,
      aux_sym_record_type_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29471] = 4,
    ACTIONS(1454), 1,
      sym_comma,
    ACTIONS(1669), 1,
      sym_right_parenthesis,
    STATE(676), 1,
      aux_sym_tuple_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29485] = 4,
    ACTIONS(1448), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1671), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(685), 1,
      aux_sym_value_qid_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29499] = 4,
    ACTIONS(1436), 1,
      sym_comma,
    ACTIONS(1673), 1,
      sym_right_square_bracket,
    STATE(722), 1,
      aux_sym_list_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29513] = 3,
    ACTIONS(1675), 1,
      sym_of,
    STATE(201), 1,
      sym__case_of_tail,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29524] = 3,
    ACTIONS(1677), 1,
      sym__char_quote,
    STATE(174), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29535] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1679), 2,
      sym__virtual_end_decl,
      sym_exposing,
  [29544] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1681), 2,
      sym_right_brace,
      sym_comma,
  [29553] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1683), 2,
      sym_right_brace,
      sym_comma,
  [29562] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(628), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29573] = 3,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(826), 1,
      sym_lower_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29584] = 3,
    ACTIONS(1109), 1,
      sym_upper_case_identifier,
    STATE(577), 1,
      sym_upper_case_qid,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29595] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(633), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29606] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(677), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29617] = 3,
    ACTIONS(1163), 1,
      sym_left_parenthesis,
    STATE(845), 1,
      sym__operator_as_function_inner,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29628] = 3,
    ACTIONS(1321), 1,
      sym_exposing,
    STATE(846), 1,
      sym_exposing_list,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29639] = 3,
    ACTIONS(1687), 1,
      anon_sym_else,
    STATE(741), 1,
      aux_sym_if_else_expr_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29650] = 3,
    ACTIONS(1690), 1,
      sym_upper_case_identifier,
    ACTIONS(1692), 1,
      sym_alias,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29661] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(644), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29672] = 3,
    ACTIONS(1694), 1,
      sym_upper_case_identifier,
    STATE(585), 1,
      sym_union_variant,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29683] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1696), 2,
      sym_lower_case_identifier,
      sym_eq,
  [29692] = 3,
    ACTIONS(1698), 1,
      sym_lower_case_identifier,
    ACTIONS(1700), 1,
      sym_module,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29703] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(652), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29714] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1702), 2,
      sym_right_parenthesis,
      sym_comma,
  [29723] = 3,
    ACTIONS(1704), 1,
      sym__char_quote,
    STATE(407), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29734] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1576), 2,
      sym_right_parenthesis,
      sym_comma,
  [29743] = 3,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(665), 1,
      sym_lower_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29754] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(666), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29765] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1706), 2,
      sym_right_brace,
      sym_comma,
  [29774] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(670), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29785] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1708), 2,
      sym_right_brace,
      sym_comma,
  [29794] = 3,
    ACTIONS(1710), 1,
      sym_of,
    STATE(302), 1,
      sym__case_of_tail,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29805] = 3,
    ACTIONS(1712), 1,
      anon_sym_in,
    STATE(207), 1,
      sym__in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29816] = 3,
    ACTIONS(1714), 1,
      anon_sym_in,
    STATE(301), 1,
      sym__in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29827] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1716), 2,
      sym_right_parenthesis,
      sym_comma,
  [29836] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(682), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29847] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1718), 2,
      sym__virtual_end_decl,
      sym_pipe,
  [29856] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1720), 2,
      sym_right_square_bracket,
      sym_comma,
  [29865] = 3,
    ACTIONS(1722), 1,
      sym_lower_case_identifier,
    STATE(694), 1,
      sym_field_type,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29876] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(697), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29887] = 3,
    ACTIONS(1500), 1,
      sym_lower_case_identifier,
    STATE(732), 1,
      sym_field,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29898] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(716), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29909] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1724), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [29918] = 3,
    ACTIONS(1722), 1,
      sym_lower_case_identifier,
    STATE(725), 1,
      sym_field_type,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29929] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(721), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29940] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1726), 2,
      sym_right_parenthesis,
      sym_comma,
  [29949] = 3,
    ACTIONS(1233), 1,
      anon_sym_COLON_COLON,
    STATE(506), 1,
      aux_sym_cons_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29960] = 3,
    ACTIONS(1728), 1,
      sym_right_parenthesis,
    ACTIONS(1730), 1,
      sym_comma,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29971] = 3,
    ACTIONS(1732), 1,
      sym__char_quote,
    STATE(432), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29982] = 3,
    ACTIONS(1734), 1,
      sym__virtual_open_section,
    STATE(210), 1,
      sym__case_of_tail2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [29993] = 3,
    ACTIONS(1736), 1,
      sym_right_parenthesis,
    ACTIONS(1738), 1,
      sym_comma,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30004] = 3,
    ACTIONS(1740), 1,
      anon_sym_in,
    STATE(389), 1,
      sym__in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30015] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1742), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [30024] = 3,
    ACTIONS(1744), 1,
      sym__virtual_open_section,
    STATE(397), 1,
      sym__case_of_tail2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30035] = 3,
    ACTIONS(1079), 1,
      anon_sym_COLON_COLON,
    STATE(442), 1,
      aux_sym_cons_pattern_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30046] = 3,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(692), 1,
      sym_lower_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30057] = 3,
    ACTIONS(1746), 1,
      sym_colon,
    ACTIONS(1748), 1,
      sym_pipe,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30068] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1750), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [30077] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1752), 2,
      sym__virtual_end_decl,
      sym_pipe,
  [30086] = 3,
    ACTIONS(1754), 1,
      sym__virtual_open_section,
    STATE(314), 1,
      sym__case_of_tail2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30097] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1756), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [30106] = 3,
    ACTIONS(844), 1,
      sym_lower_case_identifier,
    STATE(470), 1,
      sym_lower_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30117] = 3,
    ACTIONS(1758), 1,
      sym__char_quote,
    STATE(225), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30128] = 3,
    ACTIONS(1321), 1,
      sym_exposing,
    STATE(908), 1,
      sym_exposing_list,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30139] = 3,
    ACTIONS(1738), 1,
      sym_comma,
    ACTIONS(1760), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30150] = 3,
    ACTIONS(1694), 1,
      sym_upper_case_identifier,
    STATE(761), 1,
      sym_union_variant,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30161] = 3,
    ACTIONS(1722), 1,
      sym_lower_case_identifier,
    STATE(637), 1,
      sym_field_type,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30172] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1762), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [30181] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1584), 2,
      sym__upper_case_identifier_without_leading_whitespace,
      sym__lower_case_identifier_without_leading_whitespace,
  [30190] = 3,
    ACTIONS(1764), 1,
      anon_sym_in,
    STATE(82), 1,
      sym__in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30201] = 3,
    ACTIONS(1766), 1,
      sym_left_brace,
    STATE(797), 1,
      sym_record_expr,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30212] = 3,
    ACTIONS(1768), 1,
      sym_of,
    STATE(83), 1,
      sym__case_of_tail,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30223] = 3,
    ACTIONS(1321), 1,
      sym_exposing,
    STATE(866), 1,
      sym_exposing_list,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30234] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1770), 2,
      sym_right_parenthesis,
      sym_comma,
  [30243] = 3,
    ACTIONS(1772), 1,
      sym__virtual_open_section,
    STATE(169), 1,
      sym__case_of_tail2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30254] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1774), 2,
      sym_right_parenthesis,
      sym_comma,
  [30263] = 3,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    STATE(788), 1,
      sym_upper_case_qid,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30274] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1361), 2,
      sym__virtual_end_decl,
      sym_arrow,
  [30283] = 3,
    ACTIONS(1776), 1,
      sym_of,
    STATE(186), 1,
      sym__case_of_tail,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30294] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1778), 2,
      sym_right_parenthesis,
      sym_comma,
  [30303] = 3,
    ACTIONS(1694), 1,
      sym_upper_case_identifier,
    STATE(593), 1,
      sym_union_variant,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30314] = 3,
    ACTIONS(1780), 1,
      sym__virtual_open_section,
    STATE(91), 1,
      sym__case_of_tail2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30325] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(643), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30336] = 3,
    ACTIONS(1782), 1,
      anon_sym_in,
    STATE(190), 1,
      sym__in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30347] = 3,
    ACTIONS(1784), 1,
      anon_sym_if,
    STATE(816), 1,
      sym__if,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30358] = 3,
    ACTIONS(1722), 1,
      sym_lower_case_identifier,
    STATE(753), 1,
      sym_field_type,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30369] = 3,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    STATE(909), 1,
      sym_upper_case_qid,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30380] = 3,
    ACTIONS(902), 1,
      sym_lower_case_identifier,
    STATE(568), 1,
      sym_lower_pattern,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30391] = 3,
    ACTIONS(1786), 1,
      sym__char_quote,
    STATE(244), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30402] = 3,
    ACTIONS(1788), 1,
      sym__char_quote,
    STATE(369), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30413] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1790), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [30422] = 3,
    ACTIONS(1685), 1,
      anon_sym_then,
    STATE(872), 1,
      sym__then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30433] = 3,
    ACTIONS(1748), 1,
      sym_pipe,
    ACTIONS(1792), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30444] = 3,
    ACTIONS(1794), 1,
      sym__char_quote,
    STATE(87), 1,
      sym_close_char,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30455] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1796), 2,
      sym_right_parenthesis,
      sym_comma,
  [30464] = 3,
    ACTIONS(1730), 1,
      sym_comma,
    ACTIONS(1798), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30475] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1800), 2,
      sym_right_square_bracket,
      sym_comma,
  [30484] = 3,
    ACTIONS(1802), 1,
      sym__virtual_open_section,
    STATE(365), 1,
      sym__case_of_tail2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30495] = 3,
    ACTIONS(1032), 1,
      sym_upper_case_identifier,
    STATE(740), 1,
      sym_upper_case_qid,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30506] = 3,
    ACTIONS(1804), 1,
      sym_of,
    STATE(408), 1,
      sym__case_of_tail,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30517] = 3,
    ACTIONS(1806), 1,
      anon_sym_in,
    STATE(378), 1,
      sym__in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30528] = 2,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1808), 2,
      sym_right_brace,
      sym_comma,
  [30537] = 3,
    ACTIONS(1810), 1,
      sym_of,
    STATE(357), 1,
      sym__case_of_tail,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30548] = 2,
    ACTIONS(1812), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30556] = 2,
    ACTIONS(1814), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30564] = 2,
    ACTIONS(1816), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30572] = 2,
    ACTIONS(1818), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30580] = 2,
    ACTIONS(1820), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30588] = 2,
    ACTIONS(1822), 1,
      sym_glsl_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30596] = 2,
    ACTIONS(1824), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30604] = 2,
    ACTIONS(1028), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30612] = 2,
    ACTIONS(1826), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30620] = 2,
    ACTIONS(1828), 1,
      sym__virtual_end_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30628] = 2,
    ACTIONS(1830), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30636] = 2,
    ACTIONS(1832), 1,
      anon_sym_then,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30644] = 2,
    ACTIONS(1834), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30652] = 2,
    ACTIONS(1836), 1,
      sym_glsl_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30660] = 2,
    ACTIONS(1838), 1,
      sym__virtual_end_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30668] = 2,
    ACTIONS(1840), 1,
      sym_colon,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30676] = 2,
    ACTIONS(1842), 1,
      sym_upper_case_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30684] = 2,
    ACTIONS(1844), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30692] = 2,
    ACTIONS(1846), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30700] = 2,
    ACTIONS(1848), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30708] = 2,
    ACTIONS(1850), 1,
      sym_lower_case_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30716] = 2,
    ACTIONS(1852), 1,
      sym__virtual_end_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30724] = 2,
    ACTIONS(1854), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30732] = 2,
    ACTIONS(1856), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30740] = 2,
    ACTIONS(1858), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30748] = 2,
    ACTIONS(1860), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30756] = 2,
    ACTIONS(1862), 1,
      sym_lower_case_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30764] = 2,
    ACTIONS(1864), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30772] = 2,
    ACTIONS(1746), 1,
      sym_colon,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30780] = 2,
    ACTIONS(1866), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30788] = 2,
    ACTIONS(1868), 1,
      sym_glsl_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30796] = 2,
    ACTIONS(1870), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30804] = 2,
    ACTIONS(1872), 1,
      sym_glsl_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30812] = 2,
    ACTIONS(1874), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30820] = 2,
    ACTIONS(1876), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30828] = 2,
    ACTIONS(1878), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30836] = 2,
    ACTIONS(1880), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30844] = 2,
    ACTIONS(1882), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30852] = 2,
    ACTIONS(1884), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30860] = 2,
    ACTIONS(1886), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30868] = 2,
    ACTIONS(1888), 1,
      sym_pipe,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30876] = 2,
    ACTIONS(1890), 1,
      sym__virtual_end_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30884] = 2,
    ACTIONS(1892), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30892] = 2,
    ACTIONS(1894), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30900] = 2,
    ACTIONS(1458), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30908] = 2,
    ACTIONS(1896), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30916] = 2,
    ACTIONS(1898), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30924] = 2,
    ACTIONS(1750), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30932] = 2,
    ACTIONS(1900), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30940] = 2,
    ACTIONS(1902), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30948] = 2,
    ACTIONS(1904), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30956] = 2,
    ACTIONS(1906), 1,
      sym__virtual_end_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30964] = 2,
    ACTIONS(1908), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30972] = 2,
    ACTIONS(1910), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30980] = 2,
    ACTIONS(1912), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30988] = 2,
    ACTIONS(1742), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [30996] = 2,
    ACTIONS(1914), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31004] = 2,
    ACTIONS(1916), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31012] = 2,
    ACTIONS(1918), 1,
      sym_glsl_content,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31020] = 2,
    ACTIONS(1920), 1,
      sym_glsl_content,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31028] = 2,
    ACTIONS(1922), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31036] = 2,
    ACTIONS(1924), 1,
      sym_glsl_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31044] = 2,
    ACTIONS(1792), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31052] = 2,
    ACTIONS(1926), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31060] = 2,
    ACTIONS(1928), 1,
      sym_left_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31068] = 2,
    ACTIONS(1930), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31076] = 2,
    ACTIONS(1932), 1,
      sym_eq,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31084] = 2,
    ACTIONS(1934), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31092] = 2,
    ACTIONS(1936), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31100] = 2,
    ACTIONS(1938), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31108] = 2,
    ACTIONS(1940), 1,
      sym_glsl_content,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31116] = 2,
    ACTIONS(1942), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31124] = 2,
    ACTIONS(1944), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31132] = 2,
    ACTIONS(1946), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31140] = 2,
    ACTIONS(1948), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31148] = 2,
    ACTIONS(1950), 1,
      sym__virtual_open_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31156] = 2,
    ACTIONS(1952), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31164] = 2,
    ACTIONS(1954), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31172] = 2,
    ACTIONS(1956), 1,
      sym_glsl_content,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31180] = 2,
    ACTIONS(1958), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31188] = 2,
    ACTIONS(1960), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31196] = 2,
    ACTIONS(1962), 1,
      sym_where,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31204] = 2,
    ACTIONS(1964), 1,
      sym_double_dot,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31212] = 2,
    ACTIONS(1966), 1,
      sym_upper_case_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31220] = 2,
    ACTIONS(1968), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31228] = 2,
    ACTIONS(1970), 1,
      sym_glsl_content,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31236] = 2,
    ACTIONS(1972), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31244] = 2,
    ACTIONS(1974), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31252] = 2,
    ACTIONS(1976), 1,
      sym_right_brace,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31260] = 2,
    ACTIONS(1978), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31268] = 2,
    ACTIONS(1980), 1,
      sym_right_parenthesis,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31276] = 2,
    ACTIONS(1982), 1,
      sym_glsl_content,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31284] = 2,
    ACTIONS(1984), 1,
      sym__virtual_end_section,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31292] = 2,
    ACTIONS(1986), 1,
      sym_glsl_end,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31300] = 2,
    ACTIONS(1988), 1,
      sym_arrow,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31308] = 2,
    ACTIONS(1990), 1,
      sym__virtual_end_decl,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
  [31316] = 2,
    ACTIONS(1992), 1,
      sym_module,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(20)] = 0,
  [SMALL_STATE(21)] = 116,
  [SMALL_STATE(22)] = 232,
  [SMALL_STATE(23)] = 348,
  [SMALL_STATE(24)] = 464,
  [SMALL_STATE(25)] = 532,
  [SMALL_STATE(26)] = 594,
  [SMALL_STATE(27)] = 710,
  [SMALL_STATE(28)] = 774,
  [SMALL_STATE(29)] = 842,
  [SMALL_STATE(30)] = 910,
  [SMALL_STATE(31)] = 1026,
  [SMALL_STATE(32)] = 1089,
  [SMALL_STATE(33)] = 1202,
  [SMALL_STATE(34)] = 1315,
  [SMALL_STATE(35)] = 1428,
  [SMALL_STATE(36)] = 1491,
  [SMALL_STATE(37)] = 1604,
  [SMALL_STATE(38)] = 1717,
  [SMALL_STATE(39)] = 1830,
  [SMALL_STATE(40)] = 1943,
  [SMALL_STATE(41)] = 2006,
  [SMALL_STATE(42)] = 2119,
  [SMALL_STATE(43)] = 2232,
  [SMALL_STATE(44)] = 2345,
  [SMALL_STATE(45)] = 2458,
  [SMALL_STATE(46)] = 2571,
  [SMALL_STATE(47)] = 2684,
  [SMALL_STATE(48)] = 2797,
  [SMALL_STATE(49)] = 2910,
  [SMALL_STATE(50)] = 3023,
  [SMALL_STATE(51)] = 3136,
  [SMALL_STATE(52)] = 3249,
  [SMALL_STATE(53)] = 3362,
  [SMALL_STATE(54)] = 3475,
  [SMALL_STATE(55)] = 3588,
  [SMALL_STATE(56)] = 3701,
  [SMALL_STATE(57)] = 3814,
  [SMALL_STATE(58)] = 3927,
  [SMALL_STATE(59)] = 4040,
  [SMALL_STATE(60)] = 4153,
  [SMALL_STATE(61)] = 4266,
  [SMALL_STATE(62)] = 4379,
  [SMALL_STATE(63)] = 4492,
  [SMALL_STATE(64)] = 4605,
  [SMALL_STATE(65)] = 4718,
  [SMALL_STATE(66)] = 4831,
  [SMALL_STATE(67)] = 4889,
  [SMALL_STATE(68)] = 4951,
  [SMALL_STATE(69)] = 5009,
  [SMALL_STATE(70)] = 5069,
  [SMALL_STATE(71)] = 5127,
  [SMALL_STATE(72)] = 5187,
  [SMALL_STATE(73)] = 5245,
  [SMALL_STATE(74)] = 5303,
  [SMALL_STATE(75)] = 5361,
  [SMALL_STATE(76)] = 5419,
  [SMALL_STATE(77)] = 5477,
  [SMALL_STATE(78)] = 5535,
  [SMALL_STATE(79)] = 5592,
  [SMALL_STATE(80)] = 5649,
  [SMALL_STATE(81)] = 5706,
  [SMALL_STATE(82)] = 5815,
  [SMALL_STATE(83)] = 5872,
  [SMALL_STATE(84)] = 5929,
  [SMALL_STATE(85)] = 5986,
  [SMALL_STATE(86)] = 6043,
  [SMALL_STATE(87)] = 6100,
  [SMALL_STATE(88)] = 6157,
  [SMALL_STATE(89)] = 6214,
  [SMALL_STATE(90)] = 6271,
  [SMALL_STATE(91)] = 6328,
  [SMALL_STATE(92)] = 6385,
  [SMALL_STATE(93)] = 6442,
  [SMALL_STATE(94)] = 6499,
  [SMALL_STATE(95)] = 6556,
  [SMALL_STATE(96)] = 6613,
  [SMALL_STATE(97)] = 6670,
  [SMALL_STATE(98)] = 6779,
  [SMALL_STATE(99)] = 6836,
  [SMALL_STATE(100)] = 6893,
  [SMALL_STATE(101)] = 7008,
  [SMALL_STATE(102)] = 7117,
  [SMALL_STATE(103)] = 7174,
  [SMALL_STATE(104)] = 7231,
  [SMALL_STATE(105)] = 7288,
  [SMALL_STATE(106)] = 7345,
  [SMALL_STATE(107)] = 7402,
  [SMALL_STATE(108)] = 7461,
  [SMALL_STATE(109)] = 7570,
  [SMALL_STATE(110)] = 7627,
  [SMALL_STATE(111)] = 7684,
  [SMALL_STATE(112)] = 7799,
  [SMALL_STATE(113)] = 7914,
  [SMALL_STATE(114)] = 8023,
  [SMALL_STATE(115)] = 8132,
  [SMALL_STATE(116)] = 8233,
  [SMALL_STATE(117)] = 8292,
  [SMALL_STATE(118)] = 8393,
  [SMALL_STATE(119)] = 8494,
  [SMALL_STATE(120)] = 8551,
  [SMALL_STATE(121)] = 8652,
  [SMALL_STATE(122)] = 8715,
  [SMALL_STATE(123)] = 8816,
  [SMALL_STATE(124)] = 8879,
  [SMALL_STATE(125)] = 8980,
  [SMALL_STATE(126)] = 9043,
  [SMALL_STATE(127)] = 9105,
  [SMALL_STATE(128)] = 9211,
  [SMALL_STATE(129)] = 9311,
  [SMALL_STATE(130)] = 9367,
  [SMALL_STATE(131)] = 9473,
  [SMALL_STATE(132)] = 9573,
  [SMALL_STATE(133)] = 9631,
  [SMALL_STATE(134)] = 9689,
  [SMALL_STATE(135)] = 9795,
  [SMALL_STATE(136)] = 9901,
  [SMALL_STATE(137)] = 9963,
  [SMALL_STATE(138)] = 10063,
  [SMALL_STATE(139)] = 10163,
  [SMALL_STATE(140)] = 10263,
  [SMALL_STATE(141)] = 10369,
  [SMALL_STATE(142)] = 10431,
  [SMALL_STATE(143)] = 10531,
  [SMALL_STATE(144)] = 10589,
  [SMALL_STATE(145)] = 10647,
  [SMALL_STATE(146)] = 10706,
  [SMALL_STATE(147)] = 10759,
  [SMALL_STATE(148)] = 10816,
  [SMALL_STATE(149)] = 10873,
  [SMALL_STATE(150)] = 10926,
  [SMALL_STATE(151)] = 10979,
  [SMALL_STATE(152)] = 11034,
  [SMALL_STATE(153)] = 11091,
  [SMALL_STATE(154)] = 11144,
  [SMALL_STATE(155)] = 11197,
  [SMALL_STATE(156)] = 11250,
  [SMALL_STATE(157)] = 11303,
  [SMALL_STATE(158)] = 11356,
  [SMALL_STATE(159)] = 11409,
  [SMALL_STATE(160)] = 11464,
  [SMALL_STATE(161)] = 11516,
  [SMALL_STATE(162)] = 11568,
  [SMALL_STATE(163)] = 11620,
  [SMALL_STATE(164)] = 11672,
  [SMALL_STATE(165)] = 11724,
  [SMALL_STATE(166)] = 11776,
  [SMALL_STATE(167)] = 11828,
  [SMALL_STATE(168)] = 11880,
  [SMALL_STATE(169)] = 11932,
  [SMALL_STATE(170)] = 11984,
  [SMALL_STATE(171)] = 12036,
  [SMALL_STATE(172)] = 12088,
  [SMALL_STATE(173)] = 12140,
  [SMALL_STATE(174)] = 12192,
  [SMALL_STATE(175)] = 12244,
  [SMALL_STATE(176)] = 12296,
  [SMALL_STATE(177)] = 12348,
  [SMALL_STATE(178)] = 12400,
  [SMALL_STATE(179)] = 12452,
  [SMALL_STATE(180)] = 12504,
  [SMALL_STATE(181)] = 12556,
  [SMALL_STATE(182)] = 12608,
  [SMALL_STATE(183)] = 12660,
  [SMALL_STATE(184)] = 12718,
  [SMALL_STATE(185)] = 12770,
  [SMALL_STATE(186)] = 12822,
  [SMALL_STATE(187)] = 12874,
  [SMALL_STATE(188)] = 12928,
  [SMALL_STATE(189)] = 12980,
  [SMALL_STATE(190)] = 13036,
  [SMALL_STATE(191)] = 13088,
  [SMALL_STATE(192)] = 13140,
  [SMALL_STATE(193)] = 13194,
  [SMALL_STATE(194)] = 13246,
  [SMALL_STATE(195)] = 13298,
  [SMALL_STATE(196)] = 13350,
  [SMALL_STATE(197)] = 13402,
  [SMALL_STATE(198)] = 13454,
  [SMALL_STATE(199)] = 13506,
  [SMALL_STATE(200)] = 13558,
  [SMALL_STATE(201)] = 13609,
  [SMALL_STATE(202)] = 13660,
  [SMALL_STATE(203)] = 13711,
  [SMALL_STATE(204)] = 13762,
  [SMALL_STATE(205)] = 13813,
  [SMALL_STATE(206)] = 13864,
  [SMALL_STATE(207)] = 13915,
  [SMALL_STATE(208)] = 13966,
  [SMALL_STATE(209)] = 14017,
  [SMALL_STATE(210)] = 14068,
  [SMALL_STATE(211)] = 14119,
  [SMALL_STATE(212)] = 14170,
  [SMALL_STATE(213)] = 14221,
  [SMALL_STATE(214)] = 14272,
  [SMALL_STATE(215)] = 14323,
  [SMALL_STATE(216)] = 14374,
  [SMALL_STATE(217)] = 14425,
  [SMALL_STATE(218)] = 14476,
  [SMALL_STATE(219)] = 14527,
  [SMALL_STATE(220)] = 14578,
  [SMALL_STATE(221)] = 14633,
  [SMALL_STATE(222)] = 14684,
  [SMALL_STATE(223)] = 14735,
  [SMALL_STATE(224)] = 14786,
  [SMALL_STATE(225)] = 14837,
  [SMALL_STATE(226)] = 14888,
  [SMALL_STATE(227)] = 14939,
  [SMALL_STATE(228)] = 14990,
  [SMALL_STATE(229)] = 15043,
  [SMALL_STATE(230)] = 15096,
  [SMALL_STATE(231)] = 15144,
  [SMALL_STATE(232)] = 15191,
  [SMALL_STATE(233)] = 15280,
  [SMALL_STATE(234)] = 15369,
  [SMALL_STATE(235)] = 15443,
  [SMALL_STATE(236)] = 15491,
  [SMALL_STATE(237)] = 15539,
  [SMALL_STATE(238)] = 15583,
  [SMALL_STATE(239)] = 15657,
  [SMALL_STATE(240)] = 15731,
  [SMALL_STATE(241)] = 15782,
  [SMALL_STATE(242)] = 15833,
  [SMALL_STATE(243)] = 15880,
  [SMALL_STATE(244)] = 15923,
  [SMALL_STATE(245)] = 15966,
  [SMALL_STATE(246)] = 16009,
  [SMALL_STATE(247)] = 16054,
  [SMALL_STATE(248)] = 16097,
  [SMALL_STATE(249)] = 16148,
  [SMALL_STATE(250)] = 16191,
  [SMALL_STATE(251)] = 16234,
  [SMALL_STATE(252)] = 16314,
  [SMALL_STATE(253)] = 16360,
  [SMALL_STATE(254)] = 16440,
  [SMALL_STATE(255)] = 16520,
  [SMALL_STATE(256)] = 16600,
  [SMALL_STATE(257)] = 16646,
  [SMALL_STATE(258)] = 16692,
  [SMALL_STATE(259)] = 16772,
  [SMALL_STATE(260)] = 16852,
  [SMALL_STATE(261)] = 16894,
  [SMALL_STATE(262)] = 16936,
  [SMALL_STATE(263)] = 17016,
  [SMALL_STATE(264)] = 17093,
  [SMALL_STATE(265)] = 17134,
  [SMALL_STATE(266)] = 17177,
  [SMALL_STATE(267)] = 17256,
  [SMALL_STATE(268)] = 17335,
  [SMALL_STATE(269)] = 17412,
  [SMALL_STATE(270)] = 17491,
  [SMALL_STATE(271)] = 17570,
  [SMALL_STATE(272)] = 17611,
  [SMALL_STATE(273)] = 17652,
  [SMALL_STATE(274)] = 17695,
  [SMALL_STATE(275)] = 17774,
  [SMALL_STATE(276)] = 17815,
  [SMALL_STATE(277)] = 17856,
  [SMALL_STATE(278)] = 17897,
  [SMALL_STATE(279)] = 17938,
  [SMALL_STATE(280)] = 18017,
  [SMALL_STATE(281)] = 18096,
  [SMALL_STATE(282)] = 18175,
  [SMALL_STATE(283)] = 18254,
  [SMALL_STATE(284)] = 18331,
  [SMALL_STATE(285)] = 18410,
  [SMALL_STATE(286)] = 18487,
  [SMALL_STATE(287)] = 18528,
  [SMALL_STATE(288)] = 18605,
  [SMALL_STATE(289)] = 18684,
  [SMALL_STATE(290)] = 18761,
  [SMALL_STATE(291)] = 18840,
  [SMALL_STATE(292)] = 18919,
  [SMALL_STATE(293)] = 18959,
  [SMALL_STATE(294)] = 18999,
  [SMALL_STATE(295)] = 19047,
  [SMALL_STATE(296)] = 19095,
  [SMALL_STATE(297)] = 19171,
  [SMALL_STATE(298)] = 19247,
  [SMALL_STATE(299)] = 19287,
  [SMALL_STATE(300)] = 19327,
  [SMALL_STATE(301)] = 19367,
  [SMALL_STATE(302)] = 19407,
  [SMALL_STATE(303)] = 19447,
  [SMALL_STATE(304)] = 19487,
  [SMALL_STATE(305)] = 19527,
  [SMALL_STATE(306)] = 19567,
  [SMALL_STATE(307)] = 19607,
  [SMALL_STATE(308)] = 19647,
  [SMALL_STATE(309)] = 19687,
  [SMALL_STATE(310)] = 19763,
  [SMALL_STATE(311)] = 19803,
  [SMALL_STATE(312)] = 19879,
  [SMALL_STATE(313)] = 19919,
  [SMALL_STATE(314)] = 19959,
  [SMALL_STATE(315)] = 19999,
  [SMALL_STATE(316)] = 20039,
  [SMALL_STATE(317)] = 20079,
  [SMALL_STATE(318)] = 20119,
  [SMALL_STATE(319)] = 20159,
  [SMALL_STATE(320)] = 20227,
  [SMALL_STATE(321)] = 20273,
  [SMALL_STATE(322)] = 20315,
  [SMALL_STATE(323)] = 20355,
  [SMALL_STATE(324)] = 20401,
  [SMALL_STATE(325)] = 20447,
  [SMALL_STATE(326)] = 20515,
  [SMALL_STATE(327)] = 20560,
  [SMALL_STATE(328)] = 20601,
  [SMALL_STATE(329)] = 20642,
  [SMALL_STATE(330)] = 20687,
  [SMALL_STATE(331)] = 20726,
  [SMALL_STATE(332)] = 20771,
  [SMALL_STATE(333)] = 20807,
  [SMALL_STATE(334)] = 20847,
  [SMALL_STATE(335)] = 20883,
  [SMALL_STATE(336)] = 20921,
  [SMALL_STATE(337)] = 20957,
  [SMALL_STATE(338)] = 20993,
  [SMALL_STATE(339)] = 21055,
  [SMALL_STATE(340)] = 21091,
  [SMALL_STATE(341)] = 21127,
  [SMALL_STATE(342)] = 21189,
  [SMALL_STATE(343)] = 21225,
  [SMALL_STATE(344)] = 21261,
  [SMALL_STATE(345)] = 21299,
  [SMALL_STATE(346)] = 21334,
  [SMALL_STATE(347)] = 21393,
  [SMALL_STATE(348)] = 21428,
  [SMALL_STATE(349)] = 21463,
  [SMALL_STATE(350)] = 21498,
  [SMALL_STATE(351)] = 21533,
  [SMALL_STATE(352)] = 21568,
  [SMALL_STATE(353)] = 21603,
  [SMALL_STATE(354)] = 21638,
  [SMALL_STATE(355)] = 21673,
  [SMALL_STATE(356)] = 21710,
  [SMALL_STATE(357)] = 21745,
  [SMALL_STATE(358)] = 21780,
  [SMALL_STATE(359)] = 21815,
  [SMALL_STATE(360)] = 21850,
  [SMALL_STATE(361)] = 21887,
  [SMALL_STATE(362)] = 21922,
  [SMALL_STATE(363)] = 21957,
  [SMALL_STATE(364)] = 21992,
  [SMALL_STATE(365)] = 22027,
  [SMALL_STATE(366)] = 22062,
  [SMALL_STATE(367)] = 22097,
  [SMALL_STATE(368)] = 22132,
  [SMALL_STATE(369)] = 22167,
  [SMALL_STATE(370)] = 22202,
  [SMALL_STATE(371)] = 22237,
  [SMALL_STATE(372)] = 22272,
  [SMALL_STATE(373)] = 22307,
  [SMALL_STATE(374)] = 22342,
  [SMALL_STATE(375)] = 22401,
  [SMALL_STATE(376)] = 22436,
  [SMALL_STATE(377)] = 22471,
  [SMALL_STATE(378)] = 22506,
  [SMALL_STATE(379)] = 22541,
  [SMALL_STATE(380)] = 22576,
  [SMALL_STATE(381)] = 22611,
  [SMALL_STATE(382)] = 22646,
  [SMALL_STATE(383)] = 22681,
  [SMALL_STATE(384)] = 22715,
  [SMALL_STATE(385)] = 22749,
  [SMALL_STATE(386)] = 22783,
  [SMALL_STATE(387)] = 22817,
  [SMALL_STATE(388)] = 22851,
  [SMALL_STATE(389)] = 22885,
  [SMALL_STATE(390)] = 22919,
  [SMALL_STATE(391)] = 22953,
  [SMALL_STATE(392)] = 22987,
  [SMALL_STATE(393)] = 23021,
  [SMALL_STATE(394)] = 23055,
  [SMALL_STATE(395)] = 23089,
  [SMALL_STATE(396)] = 23123,
  [SMALL_STATE(397)] = 23157,
  [SMALL_STATE(398)] = 23191,
  [SMALL_STATE(399)] = 23225,
  [SMALL_STATE(400)] = 23259,
  [SMALL_STATE(401)] = 23293,
  [SMALL_STATE(402)] = 23329,
  [SMALL_STATE(403)] = 23363,
  [SMALL_STATE(404)] = 23397,
  [SMALL_STATE(405)] = 23431,
  [SMALL_STATE(406)] = 23465,
  [SMALL_STATE(407)] = 23499,
  [SMALL_STATE(408)] = 23533,
  [SMALL_STATE(409)] = 23567,
  [SMALL_STATE(410)] = 23601,
  [SMALL_STATE(411)] = 23634,
  [SMALL_STATE(412)] = 23667,
  [SMALL_STATE(413)] = 23700,
  [SMALL_STATE(414)] = 23728,
  [SMALL_STATE(415)] = 23755,
  [SMALL_STATE(416)] = 23782,
  [SMALL_STATE(417)] = 23809,
  [SMALL_STATE(418)] = 23836,
  [SMALL_STATE(419)] = 23863,
  [SMALL_STATE(420)] = 23890,
  [SMALL_STATE(421)] = 23917,
  [SMALL_STATE(422)] = 23944,
  [SMALL_STATE(423)] = 23971,
  [SMALL_STATE(424)] = 23998,
  [SMALL_STATE(425)] = 24025,
  [SMALL_STATE(426)] = 24052,
  [SMALL_STATE(427)] = 24079,
  [SMALL_STATE(428)] = 24106,
  [SMALL_STATE(429)] = 24133,
  [SMALL_STATE(430)] = 24160,
  [SMALL_STATE(431)] = 24187,
  [SMALL_STATE(432)] = 24220,
  [SMALL_STATE(433)] = 24247,
  [SMALL_STATE(434)] = 24273,
  [SMALL_STATE(435)] = 24299,
  [SMALL_STATE(436)] = 24324,
  [SMALL_STATE(437)] = 24365,
  [SMALL_STATE(438)] = 24406,
  [SMALL_STATE(439)] = 24447,
  [SMALL_STATE(440)] = 24487,
  [SMALL_STATE(441)] = 24515,
  [SMALL_STATE(442)] = 24555,
  [SMALL_STATE(443)] = 24583,
  [SMALL_STATE(444)] = 24623,
  [SMALL_STATE(445)] = 24663,
  [SMALL_STATE(446)] = 24703,
  [SMALL_STATE(447)] = 24743,
  [SMALL_STATE(448)] = 24783,
  [SMALL_STATE(449)] = 24807,
  [SMALL_STATE(450)] = 24846,
  [SMALL_STATE(451)] = 24883,
  [SMALL_STATE(452)] = 24922,
  [SMALL_STATE(453)] = 24959,
  [SMALL_STATE(454)] = 24998,
  [SMALL_STATE(455)] = 25023,
  [SMALL_STATE(456)] = 25060,
  [SMALL_STATE(457)] = 25097,
  [SMALL_STATE(458)] = 25134,
  [SMALL_STATE(459)] = 25171,
  [SMALL_STATE(460)] = 25196,
  [SMALL_STATE(461)] = 25223,
  [SMALL_STATE(462)] = 25250,
  [SMALL_STATE(463)] = 25289,
  [SMALL_STATE(464)] = 25312,
  [SMALL_STATE(465)] = 25349,
  [SMALL_STATE(466)] = 25383,
  [SMALL_STATE(467)] = 25405,
  [SMALL_STATE(468)] = 25439,
  [SMALL_STATE(469)] = 25473,
  [SMALL_STATE(470)] = 25494,
  [SMALL_STATE(471)] = 25515,
  [SMALL_STATE(472)] = 25536,
  [SMALL_STATE(473)] = 25561,
  [SMALL_STATE(474)] = 25585,
  [SMALL_STATE(475)] = 25611,
  [SMALL_STATE(476)] = 25631,
  [SMALL_STATE(477)] = 25652,
  [SMALL_STATE(478)] = 25673,
  [SMALL_STATE(479)] = 25694,
  [SMALL_STATE(480)] = 25715,
  [SMALL_STATE(481)] = 25736,
  [SMALL_STATE(482)] = 25757,
  [SMALL_STATE(483)] = 25778,
  [SMALL_STATE(484)] = 25793,
  [SMALL_STATE(485)] = 25808,
  [SMALL_STATE(486)] = 25823,
  [SMALL_STATE(487)] = 25838,
  [SMALL_STATE(488)] = 25859,
  [SMALL_STATE(489)] = 25880,
  [SMALL_STATE(490)] = 25895,
  [SMALL_STATE(491)] = 25910,
  [SMALL_STATE(492)] = 25931,
  [SMALL_STATE(493)] = 25952,
  [SMALL_STATE(494)] = 25975,
  [SMALL_STATE(495)] = 25996,
  [SMALL_STATE(496)] = 26011,
  [SMALL_STATE(497)] = 26026,
  [SMALL_STATE(498)] = 26041,
  [SMALL_STATE(499)] = 26062,
  [SMALL_STATE(500)] = 26083,
  [SMALL_STATE(501)] = 26104,
  [SMALL_STATE(502)] = 26119,
  [SMALL_STATE(503)] = 26134,
  [SMALL_STATE(504)] = 26149,
  [SMALL_STATE(505)] = 26170,
  [SMALL_STATE(506)] = 26185,
  [SMALL_STATE(507)] = 26204,
  [SMALL_STATE(508)] = 26223,
  [SMALL_STATE(509)] = 26244,
  [SMALL_STATE(510)] = 26265,
  [SMALL_STATE(511)] = 26286,
  [SMALL_STATE(512)] = 26307,
  [SMALL_STATE(513)] = 26328,
  [SMALL_STATE(514)] = 26349,
  [SMALL_STATE(515)] = 26370,
  [SMALL_STATE(516)] = 26391,
  [SMALL_STATE(517)] = 26412,
  [SMALL_STATE(518)] = 26433,
  [SMALL_STATE(519)] = 26454,
  [SMALL_STATE(520)] = 26475,
  [SMALL_STATE(521)] = 26496,
  [SMALL_STATE(522)] = 26517,
  [SMALL_STATE(523)] = 26531,
  [SMALL_STATE(524)] = 26545,
  [SMALL_STATE(525)] = 26559,
  [SMALL_STATE(526)] = 26573,
  [SMALL_STATE(527)] = 26587,
  [SMALL_STATE(528)] = 26601,
  [SMALL_STATE(529)] = 26617,
  [SMALL_STATE(530)] = 26631,
  [SMALL_STATE(531)] = 26649,
  [SMALL_STATE(532)] = 26663,
  [SMALL_STATE(533)] = 26677,
  [SMALL_STATE(534)] = 26691,
  [SMALL_STATE(535)] = 26705,
  [SMALL_STATE(536)] = 26719,
  [SMALL_STATE(537)] = 26733,
  [SMALL_STATE(538)] = 26747,
  [SMALL_STATE(539)] = 26761,
  [SMALL_STATE(540)] = 26775,
  [SMALL_STATE(541)] = 26789,
  [SMALL_STATE(542)] = 26803,
  [SMALL_STATE(543)] = 26817,
  [SMALL_STATE(544)] = 26831,
  [SMALL_STATE(545)] = 26849,
  [SMALL_STATE(546)] = 26865,
  [SMALL_STATE(547)] = 26879,
  [SMALL_STATE(548)] = 26893,
  [SMALL_STATE(549)] = 26907,
  [SMALL_STATE(550)] = 26921,
  [SMALL_STATE(551)] = 26935,
  [SMALL_STATE(552)] = 26961,
  [SMALL_STATE(553)] = 26975,
  [SMALL_STATE(554)] = 26989,
  [SMALL_STATE(555)] = 27015,
  [SMALL_STATE(556)] = 27041,
  [SMALL_STATE(557)] = 27055,
  [SMALL_STATE(558)] = 27081,
  [SMALL_STATE(559)] = 27107,
  [SMALL_STATE(560)] = 27121,
  [SMALL_STATE(561)] = 27135,
  [SMALL_STATE(562)] = 27149,
  [SMALL_STATE(563)] = 27163,
  [SMALL_STATE(564)] = 27177,
  [SMALL_STATE(565)] = 27191,
  [SMALL_STATE(566)] = 27217,
  [SMALL_STATE(567)] = 27230,
  [SMALL_STATE(568)] = 27246,
  [SMALL_STATE(569)] = 27258,
  [SMALL_STATE(570)] = 27276,
  [SMALL_STATE(571)] = 27292,
  [SMALL_STATE(572)] = 27312,
  [SMALL_STATE(573)] = 27328,
  [SMALL_STATE(574)] = 27342,
  [SMALL_STATE(575)] = 27356,
  [SMALL_STATE(576)] = 27376,
  [SMALL_STATE(577)] = 27388,
  [SMALL_STATE(578)] = 27408,
  [SMALL_STATE(579)] = 27428,
  [SMALL_STATE(580)] = 27440,
  [SMALL_STATE(581)] = 27457,
  [SMALL_STATE(582)] = 27474,
  [SMALL_STATE(583)] = 27491,
  [SMALL_STATE(584)] = 27506,
  [SMALL_STATE(585)] = 27521,
  [SMALL_STATE(586)] = 27538,
  [SMALL_STATE(587)] = 27553,
  [SMALL_STATE(588)] = 27568,
  [SMALL_STATE(589)] = 27585,
  [SMALL_STATE(590)] = 27600,
  [SMALL_STATE(591)] = 27617,
  [SMALL_STATE(592)] = 27634,
  [SMALL_STATE(593)] = 27645,
  [SMALL_STATE(594)] = 27662,
  [SMALL_STATE(595)] = 27679,
  [SMALL_STATE(596)] = 27696,
  [SMALL_STATE(597)] = 27711,
  [SMALL_STATE(598)] = 27726,
  [SMALL_STATE(599)] = 27743,
  [SMALL_STATE(600)] = 27758,
  [SMALL_STATE(601)] = 27773,
  [SMALL_STATE(602)] = 27787,
  [SMALL_STATE(603)] = 27801,
  [SMALL_STATE(604)] = 27811,
  [SMALL_STATE(605)] = 27825,
  [SMALL_STATE(606)] = 27835,
  [SMALL_STATE(607)] = 27845,
  [SMALL_STATE(608)] = 27855,
  [SMALL_STATE(609)] = 27869,
  [SMALL_STATE(610)] = 27883,
  [SMALL_STATE(611)] = 27897,
  [SMALL_STATE(612)] = 27907,
  [SMALL_STATE(613)] = 27917,
  [SMALL_STATE(614)] = 27931,
  [SMALL_STATE(615)] = 27941,
  [SMALL_STATE(616)] = 27955,
  [SMALL_STATE(617)] = 27969,
  [SMALL_STATE(618)] = 27979,
  [SMALL_STATE(619)] = 27989,
  [SMALL_STATE(620)] = 28003,
  [SMALL_STATE(621)] = 28017,
  [SMALL_STATE(622)] = 28031,
  [SMALL_STATE(623)] = 28045,
  [SMALL_STATE(624)] = 28055,
  [SMALL_STATE(625)] = 28069,
  [SMALL_STATE(626)] = 28083,
  [SMALL_STATE(627)] = 28097,
  [SMALL_STATE(628)] = 28111,
  [SMALL_STATE(629)] = 28125,
  [SMALL_STATE(630)] = 28139,
  [SMALL_STATE(631)] = 28153,
  [SMALL_STATE(632)] = 28167,
  [SMALL_STATE(633)] = 28181,
  [SMALL_STATE(634)] = 28195,
  [SMALL_STATE(635)] = 28209,
  [SMALL_STATE(636)] = 28223,
  [SMALL_STATE(637)] = 28237,
  [SMALL_STATE(638)] = 28251,
  [SMALL_STATE(639)] = 28265,
  [SMALL_STATE(640)] = 28277,
  [SMALL_STATE(641)] = 28291,
  [SMALL_STATE(642)] = 28305,
  [SMALL_STATE(643)] = 28319,
  [SMALL_STATE(644)] = 28333,
  [SMALL_STATE(645)] = 28347,
  [SMALL_STATE(646)] = 28361,
  [SMALL_STATE(647)] = 28375,
  [SMALL_STATE(648)] = 28389,
  [SMALL_STATE(649)] = 28403,
  [SMALL_STATE(650)] = 28417,
  [SMALL_STATE(651)] = 28431,
  [SMALL_STATE(652)] = 28445,
  [SMALL_STATE(653)] = 28459,
  [SMALL_STATE(654)] = 28473,
  [SMALL_STATE(655)] = 28487,
  [SMALL_STATE(656)] = 28501,
  [SMALL_STATE(657)] = 28515,
  [SMALL_STATE(658)] = 28529,
  [SMALL_STATE(659)] = 28543,
  [SMALL_STATE(660)] = 28557,
  [SMALL_STATE(661)] = 28569,
  [SMALL_STATE(662)] = 28583,
  [SMALL_STATE(663)] = 28597,
  [SMALL_STATE(664)] = 28611,
  [SMALL_STATE(665)] = 28625,
  [SMALL_STATE(666)] = 28639,
  [SMALL_STATE(667)] = 28653,
  [SMALL_STATE(668)] = 28667,
  [SMALL_STATE(669)] = 28681,
  [SMALL_STATE(670)] = 28695,
  [SMALL_STATE(671)] = 28709,
  [SMALL_STATE(672)] = 28723,
  [SMALL_STATE(673)] = 28737,
  [SMALL_STATE(674)] = 28751,
  [SMALL_STATE(675)] = 28763,
  [SMALL_STATE(676)] = 28777,
  [SMALL_STATE(677)] = 28791,
  [SMALL_STATE(678)] = 28805,
  [SMALL_STATE(679)] = 28819,
  [SMALL_STATE(680)] = 28833,
  [SMALL_STATE(681)] = 28847,
  [SMALL_STATE(682)] = 28861,
  [SMALL_STATE(683)] = 28875,
  [SMALL_STATE(684)] = 28889,
  [SMALL_STATE(685)] = 28903,
  [SMALL_STATE(686)] = 28917,
  [SMALL_STATE(687)] = 28931,
  [SMALL_STATE(688)] = 28945,
  [SMALL_STATE(689)] = 28959,
  [SMALL_STATE(690)] = 28973,
  [SMALL_STATE(691)] = 28987,
  [SMALL_STATE(692)] = 29001,
  [SMALL_STATE(693)] = 29015,
  [SMALL_STATE(694)] = 29027,
  [SMALL_STATE(695)] = 29041,
  [SMALL_STATE(696)] = 29055,
  [SMALL_STATE(697)] = 29069,
  [SMALL_STATE(698)] = 29083,
  [SMALL_STATE(699)] = 29097,
  [SMALL_STATE(700)] = 29111,
  [SMALL_STATE(701)] = 29125,
  [SMALL_STATE(702)] = 29139,
  [SMALL_STATE(703)] = 29153,
  [SMALL_STATE(704)] = 29167,
  [SMALL_STATE(705)] = 29181,
  [SMALL_STATE(706)] = 29195,
  [SMALL_STATE(707)] = 29207,
  [SMALL_STATE(708)] = 29219,
  [SMALL_STATE(709)] = 29233,
  [SMALL_STATE(710)] = 29247,
  [SMALL_STATE(711)] = 29261,
  [SMALL_STATE(712)] = 29275,
  [SMALL_STATE(713)] = 29289,
  [SMALL_STATE(714)] = 29303,
  [SMALL_STATE(715)] = 29317,
  [SMALL_STATE(716)] = 29331,
  [SMALL_STATE(717)] = 29345,
  [SMALL_STATE(718)] = 29359,
  [SMALL_STATE(719)] = 29373,
  [SMALL_STATE(720)] = 29387,
  [SMALL_STATE(721)] = 29401,
  [SMALL_STATE(722)] = 29415,
  [SMALL_STATE(723)] = 29429,
  [SMALL_STATE(724)] = 29443,
  [SMALL_STATE(725)] = 29457,
  [SMALL_STATE(726)] = 29471,
  [SMALL_STATE(727)] = 29485,
  [SMALL_STATE(728)] = 29499,
  [SMALL_STATE(729)] = 29513,
  [SMALL_STATE(730)] = 29524,
  [SMALL_STATE(731)] = 29535,
  [SMALL_STATE(732)] = 29544,
  [SMALL_STATE(733)] = 29553,
  [SMALL_STATE(734)] = 29562,
  [SMALL_STATE(735)] = 29573,
  [SMALL_STATE(736)] = 29584,
  [SMALL_STATE(737)] = 29595,
  [SMALL_STATE(738)] = 29606,
  [SMALL_STATE(739)] = 29617,
  [SMALL_STATE(740)] = 29628,
  [SMALL_STATE(741)] = 29639,
  [SMALL_STATE(742)] = 29650,
  [SMALL_STATE(743)] = 29661,
  [SMALL_STATE(744)] = 29672,
  [SMALL_STATE(745)] = 29683,
  [SMALL_STATE(746)] = 29692,
  [SMALL_STATE(747)] = 29703,
  [SMALL_STATE(748)] = 29714,
  [SMALL_STATE(749)] = 29723,
  [SMALL_STATE(750)] = 29734,
  [SMALL_STATE(751)] = 29743,
  [SMALL_STATE(752)] = 29754,
  [SMALL_STATE(753)] = 29765,
  [SMALL_STATE(754)] = 29774,
  [SMALL_STATE(755)] = 29785,
  [SMALL_STATE(756)] = 29794,
  [SMALL_STATE(757)] = 29805,
  [SMALL_STATE(758)] = 29816,
  [SMALL_STATE(759)] = 29827,
  [SMALL_STATE(760)] = 29836,
  [SMALL_STATE(761)] = 29847,
  [SMALL_STATE(762)] = 29856,
  [SMALL_STATE(763)] = 29865,
  [SMALL_STATE(764)] = 29876,
  [SMALL_STATE(765)] = 29887,
  [SMALL_STATE(766)] = 29898,
  [SMALL_STATE(767)] = 29909,
  [SMALL_STATE(768)] = 29918,
  [SMALL_STATE(769)] = 29929,
  [SMALL_STATE(770)] = 29940,
  [SMALL_STATE(771)] = 29949,
  [SMALL_STATE(772)] = 29960,
  [SMALL_STATE(773)] = 29971,
  [SMALL_STATE(774)] = 29982,
  [SMALL_STATE(775)] = 29993,
  [SMALL_STATE(776)] = 30004,
  [SMALL_STATE(777)] = 30015,
  [SMALL_STATE(778)] = 30024,
  [SMALL_STATE(779)] = 30035,
  [SMALL_STATE(780)] = 30046,
  [SMALL_STATE(781)] = 30057,
  [SMALL_STATE(782)] = 30068,
  [SMALL_STATE(783)] = 30077,
  [SMALL_STATE(784)] = 30086,
  [SMALL_STATE(785)] = 30097,
  [SMALL_STATE(786)] = 30106,
  [SMALL_STATE(787)] = 30117,
  [SMALL_STATE(788)] = 30128,
  [SMALL_STATE(789)] = 30139,
  [SMALL_STATE(790)] = 30150,
  [SMALL_STATE(791)] = 30161,
  [SMALL_STATE(792)] = 30172,
  [SMALL_STATE(793)] = 30181,
  [SMALL_STATE(794)] = 30190,
  [SMALL_STATE(795)] = 30201,
  [SMALL_STATE(796)] = 30212,
  [SMALL_STATE(797)] = 30223,
  [SMALL_STATE(798)] = 30234,
  [SMALL_STATE(799)] = 30243,
  [SMALL_STATE(800)] = 30254,
  [SMALL_STATE(801)] = 30263,
  [SMALL_STATE(802)] = 30274,
  [SMALL_STATE(803)] = 30283,
  [SMALL_STATE(804)] = 30294,
  [SMALL_STATE(805)] = 30303,
  [SMALL_STATE(806)] = 30314,
  [SMALL_STATE(807)] = 30325,
  [SMALL_STATE(808)] = 30336,
  [SMALL_STATE(809)] = 30347,
  [SMALL_STATE(810)] = 30358,
  [SMALL_STATE(811)] = 30369,
  [SMALL_STATE(812)] = 30380,
  [SMALL_STATE(813)] = 30391,
  [SMALL_STATE(814)] = 30402,
  [SMALL_STATE(815)] = 30413,
  [SMALL_STATE(816)] = 30422,
  [SMALL_STATE(817)] = 30433,
  [SMALL_STATE(818)] = 30444,
  [SMALL_STATE(819)] = 30455,
  [SMALL_STATE(820)] = 30464,
  [SMALL_STATE(821)] = 30475,
  [SMALL_STATE(822)] = 30484,
  [SMALL_STATE(823)] = 30495,
  [SMALL_STATE(824)] = 30506,
  [SMALL_STATE(825)] = 30517,
  [SMALL_STATE(826)] = 30528,
  [SMALL_STATE(827)] = 30537,
  [SMALL_STATE(828)] = 30548,
  [SMALL_STATE(829)] = 30556,
  [SMALL_STATE(830)] = 30564,
  [SMALL_STATE(831)] = 30572,
  [SMALL_STATE(832)] = 30580,
  [SMALL_STATE(833)] = 30588,
  [SMALL_STATE(834)] = 30596,
  [SMALL_STATE(835)] = 30604,
  [SMALL_STATE(836)] = 30612,
  [SMALL_STATE(837)] = 30620,
  [SMALL_STATE(838)] = 30628,
  [SMALL_STATE(839)] = 30636,
  [SMALL_STATE(840)] = 30644,
  [SMALL_STATE(841)] = 30652,
  [SMALL_STATE(842)] = 30660,
  [SMALL_STATE(843)] = 30668,
  [SMALL_STATE(844)] = 30676,
  [SMALL_STATE(845)] = 30684,
  [SMALL_STATE(846)] = 30692,
  [SMALL_STATE(847)] = 30700,
  [SMALL_STATE(848)] = 30708,
  [SMALL_STATE(849)] = 30716,
  [SMALL_STATE(850)] = 30724,
  [SMALL_STATE(851)] = 30732,
  [SMALL_STATE(852)] = 30740,
  [SMALL_STATE(853)] = 30748,
  [SMALL_STATE(854)] = 30756,
  [SMALL_STATE(855)] = 30764,
  [SMALL_STATE(856)] = 30772,
  [SMALL_STATE(857)] = 30780,
  [SMALL_STATE(858)] = 30788,
  [SMALL_STATE(859)] = 30796,
  [SMALL_STATE(860)] = 30804,
  [SMALL_STATE(861)] = 30812,
  [SMALL_STATE(862)] = 30820,
  [SMALL_STATE(863)] = 30828,
  [SMALL_STATE(864)] = 30836,
  [SMALL_STATE(865)] = 30844,
  [SMALL_STATE(866)] = 30852,
  [SMALL_STATE(867)] = 30860,
  [SMALL_STATE(868)] = 30868,
  [SMALL_STATE(869)] = 30876,
  [SMALL_STATE(870)] = 30884,
  [SMALL_STATE(871)] = 30892,
  [SMALL_STATE(872)] = 30900,
  [SMALL_STATE(873)] = 30908,
  [SMALL_STATE(874)] = 30916,
  [SMALL_STATE(875)] = 30924,
  [SMALL_STATE(876)] = 30932,
  [SMALL_STATE(877)] = 30940,
  [SMALL_STATE(878)] = 30948,
  [SMALL_STATE(879)] = 30956,
  [SMALL_STATE(880)] = 30964,
  [SMALL_STATE(881)] = 30972,
  [SMALL_STATE(882)] = 30980,
  [SMALL_STATE(883)] = 30988,
  [SMALL_STATE(884)] = 30996,
  [SMALL_STATE(885)] = 31004,
  [SMALL_STATE(886)] = 31012,
  [SMALL_STATE(887)] = 31020,
  [SMALL_STATE(888)] = 31028,
  [SMALL_STATE(889)] = 31036,
  [SMALL_STATE(890)] = 31044,
  [SMALL_STATE(891)] = 31052,
  [SMALL_STATE(892)] = 31060,
  [SMALL_STATE(893)] = 31068,
  [SMALL_STATE(894)] = 31076,
  [SMALL_STATE(895)] = 31084,
  [SMALL_STATE(896)] = 31092,
  [SMALL_STATE(897)] = 31100,
  [SMALL_STATE(898)] = 31108,
  [SMALL_STATE(899)] = 31116,
  [SMALL_STATE(900)] = 31124,
  [SMALL_STATE(901)] = 31132,
  [SMALL_STATE(902)] = 31140,
  [SMALL_STATE(903)] = 31148,
  [SMALL_STATE(904)] = 31156,
  [SMALL_STATE(905)] = 31164,
  [SMALL_STATE(906)] = 31172,
  [SMALL_STATE(907)] = 31180,
  [SMALL_STATE(908)] = 31188,
  [SMALL_STATE(909)] = 31196,
  [SMALL_STATE(910)] = 31204,
  [SMALL_STATE(911)] = 31212,
  [SMALL_STATE(912)] = 31220,
  [SMALL_STATE(913)] = 31228,
  [SMALL_STATE(914)] = 31236,
  [SMALL_STATE(915)] = 31244,
  [SMALL_STATE(916)] = 31252,
  [SMALL_STATE(917)] = 31260,
  [SMALL_STATE(918)] = 31268,
  [SMALL_STATE(919)] = 31276,
  [SMALL_STATE(920)] = 31284,
  [SMALL_STATE(921)] = 31292,
  [SMALL_STATE(922)] = 31300,
  [SMALL_STATE(923)] = 31308,
  [SMALL_STATE(924)] = 31316,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(801),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(924),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(736),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(742),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(746),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [41] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(73),
  [44] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41),
  [46] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(40),
  [49] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(104),
  [52] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(56),
  [55] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(52),
  [58] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(903),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(11),
  [64] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(30),
  [67] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(558),
  [70] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(268),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(905),
  [76] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(906),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(611),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(137),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(500),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(499),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(73),
  [94] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(40),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(104),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(56),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(52),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(903),
  [111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(11),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(30),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(558),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(268),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(905),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(906),
  [129] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(611),
  [132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(137),
  [135] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(500),
  [138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(499),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(903),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(558),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(905),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(906),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(611),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(835),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(557),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(886),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [201] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(156),
  [204] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(133),
  [207] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(179),
  [210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(49),
  [213] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(5),
  [216] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(23),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(551),
  [222] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(263),
  [225] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(832),
  [228] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(919),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41),
  [233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(142),
  [236] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(477),
  [239] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(480),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(156),
  [245] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(133),
  [248] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(179),
  [251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(49),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(5),
  [257] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(23),
  [260] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(551),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(263),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(832),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(919),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2),
  [274] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(142),
  [277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(477),
  [280] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(480),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(551),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(832),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(919),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [309] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(198),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(147),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(211),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(45),
  [321] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(8),
  [324] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(21),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(565),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(289),
  [333] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(899),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(898),
  [339] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(128),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(514),
  [345] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_call_expr_repeat1, 2), SHIFT_REPEAT(512),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(565),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(899),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(898),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [374] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(198),
  [377] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(147),
  [380] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(211),
  [383] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(45),
  [386] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(8),
  [389] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(21),
  [392] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(565),
  [395] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(289),
  [398] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(899),
  [401] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(898),
  [404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(128),
  [407] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(514),
  [410] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_function_call_expr, 2, .dynamic_precedence = 10, .production_id = 41), SHIFT(512),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bin_op_expr, 2, .production_id = 40),
  [423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bin_op_expr, 2, .production_id = 40),
  [427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_access_expr, 2, .production_id = 42),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_access_expr, 2, .production_id = 42),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_field_access_expr_repeat1, 2),
  [435] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2), SHIFT_REPEAT(888),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2),
  [440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_bin_op_expr_repeat1, 2),
  [442] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_bin_op_expr_repeat1, 2), SHIFT_REPEAT(434),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bin_op_expr_repeat1, 2),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_upper_case_qid, 2),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(838),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_upper_case_qid, 2),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(887),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2),
  [481] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(838),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(913),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_upper_case_qid, 1),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(703),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_upper_case_qid, 1),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expr, 3, .production_id = 54),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expr, 3, .production_id = 54),
  [516] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_call_target, 1),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_access_start, 1),
  [520] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__atom, 1),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_call_target, 1),
  [524] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_qid, 3),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_qid, 3),
  [528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT(793),
  [531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_expr, 2),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_expr, 2),
  [535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__atom, 1),
  [537] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_qid, 4),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_qid, 4),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_qid, 1),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_qid, 1),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__field_access_segment, 2),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_access_segment, 2),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_expr, 1, .production_id = 23),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_expr, 1, .production_id = 23),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_expr, 3, .production_id = 57),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_expr, 3, .production_id = 57),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__case_of_tail2, 4, .production_id = 96),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_of_tail2, 4, .production_id = 96),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__else, 2, .production_id = 37),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__else, 2, .production_id = 37),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_accessor_function_expr, 2),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_accessor_function_expr, 2),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_in_expr, 2, .production_id = 43),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_in_expr, 2, .production_id = 43),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case_of_expr, 3, .production_id = 52),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_of_expr, 3, .production_id = 52),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__operator_as_function_inner, 3, .production_id = 55),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__operator_as_function_inner, 3, .production_id = 55),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expr, 3, .production_id = 37),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expr, 3, .production_id = 37),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_glsl_code_expr, 3, .production_id = 59),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_glsl_code_expr, 3, .production_id = 59),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_char_constant_expr, 3),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_char_constant_expr, 3),
  [593] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_else_expr, 3, .production_id = 60),
  [595] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_else_expr, 3, .production_id = 60),
  [597] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__in, 2, .production_id = 61),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__in, 2, .production_id = 61),
  [601] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__case_of_tail, 2, .production_id = 77),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_of_tail, 2, .production_id = 77),
  [605] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_close_char, 1),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_close_char, 1),
  [609] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_expr, 4, .production_id = 80),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_expr, 4, .production_id = 80),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expr, 4, .production_id = 82),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expr, 4, .production_id = 82),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_as_function_expr, 1, .production_id = 25),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_as_function_expr, 1, .production_id = 25),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_function_expr, 4, .production_id = 87),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_function_expr, 4, .production_id = 87),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_else_expr, 4, .production_id = 88),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_else_expr, 4, .production_id = 88),
  [629] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__case_of_tail2, 3, .production_id = 94),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_of_tail2, 3, .production_id = 94),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1),
  [635] = {.entry = {.count = 1, .reusable = false}}, SHIFT(848),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_constant_expr, 3),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_constant_expr, 3),
  [641] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unit_expr, 2),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unit_expr, 2),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number_literal, 1),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number_literal, 1),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negate_expr, 2),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negate_expr, 2),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number_constant_expr, 1),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number_constant_expr, 1),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_constant_expr, 2),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_constant_expr, 2),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_expr, 2),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_expr, 2),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 3, .production_id = 8),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 2, .production_id = 8),
  [669] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2), SHIFT_REPEAT(834),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 2),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [678] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(902),
  [682] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(874),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 4, .production_id = 8),
  [689] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [693] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [695] = {.entry = {.count = 1, .reusable = false}}, SHIFT(867),
  [697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [699] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [701] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [703] = {.entry = {.count = 1, .reusable = false}}, SHIFT(851),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2),
  [707] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(319),
  [710] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(411),
  [713] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(237),
  [716] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(237),
  [719] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(742),
  [722] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(848),
  [725] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(606),
  [728] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(270),
  [731] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(269),
  [734] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(751),
  [737] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(524),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(611),
  [743] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(498),
  [746] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__top_decl_list, 2), SHIFT_REPEAT(513),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(874),
  [751] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2), SHIFT_REPEAT(829),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(873),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(873),
  [761] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(882),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(882),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [768] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_pattern, 2, .production_id = 9),
  [772] = {.entry = {.count = 1, .reusable = false}}, SHIFT(430),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_pattern, 2, .production_id = 9),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(780),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(912),
  [792] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(912),
  [795] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(423),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2),
  [800] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(411),
  [803] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(430),
  [806] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(430),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_union_pattern_repeat1, 2),
  [811] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(288),
  [814] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(279),
  [817] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(780),
  [820] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(416),
  [823] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(611),
  [826] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(504),
  [829] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_pattern_repeat1, 2), SHIFT_REPEAT(476),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_pattern, 1, .production_id = 1),
  [834] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_pattern, 1, .production_id = 1),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [838] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2), SHIFT_REPEAT(855),
  [841] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bin_op_expr_repeat1, 2), SHIFT_REPEAT(434),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [850] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(847),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(847),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [863] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(423),
  [866] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(411),
  [869] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(430),
  [872] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(430),
  [875] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(274),
  [878] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(279),
  [881] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(780),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2),
  [886] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(416),
  [889] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(611),
  [892] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(504),
  [895] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_anonymous_function_expr_repeat1, 2), SHIFT_REPEAT(476),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lower_pattern, 1),
  [914] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lower_pattern, 1),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration_left, 1),
  [918] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [920] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2), SHIFT_REPEAT(861),
  [923] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [925] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_access_expr_repeat1, 2), SHIFT_REPEAT(878),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [934] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(423),
  [937] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(430),
  [940] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(430),
  [943] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(288),
  [946] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(279),
  [949] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(780),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2),
  [954] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(416),
  [957] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(611),
  [960] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(504),
  [963] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_declaration_left_repeat1, 2), SHIFT_REPEAT(476),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration_left, 2, .production_id = 6),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(835),
  [970] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_upper_case_qid_repeat1, 2), SHIFT_REPEAT(871),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(871),
  [975] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nullary_constructor_argument_pattern, 1),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nullary_constructor_argument_pattern, 1),
  [979] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anything_pattern, 1),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anything_pattern, 1),
  [983] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_pattern, 5, .production_id = 51),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_pattern, 5, .production_id = 51),
  [987] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_pattern, 2),
  [989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_pattern, 2),
  [991] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_pattern, 4, .production_id = 35),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_pattern, 4, .production_id = 35),
  [995] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_pattern, 6, .production_id = 75),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_pattern, 6, .production_id = 75),
  [999] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_pattern, 4, .production_id = 34),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_pattern, 4, .production_id = 34),
  [1003] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_pattern, 3),
  [1005] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_pattern, 3),
  [1007] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_pattern, 3, .production_id = 21),
  [1009] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_pattern, 3, .production_id = 21),
  [1011] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_pattern, 3, .production_id = 22),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_pattern, 3, .production_id = 22),
  [1015] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__import_list, 2),
  [1017] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__import_list, 2),
  [1019] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__import_list, 2), SHIFT_REPEAT(736),
  [1022] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 1),
  [1024] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 1),
  [1026] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_identifier, 1),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_identifier, 1),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_ref, 2, .production_id = 28),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1040] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(503),
  [1043] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(472),
  [1046] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(446),
  [1049] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27),
  [1051] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(578),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_ref_without_args, 1),
  [1056] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(540),
  [1059] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(475),
  [1062] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(441),
  [1065] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(571),
  [1068] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cons_pattern_repeat1, 2, .production_id = 27),
  [1070] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cons_pattern_repeat1, 2, .production_id = 27), SHIFT_REPEAT(341),
  [1073] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cons_pattern_repeat1, 2, .production_id = 27),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1077] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cons_pattern, 2, .production_id = 11),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1081] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cons_pattern, 2, .production_id = 11),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1091] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(560),
  [1094] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(473),
  [1097] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(445),
  [1100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 2, .production_id = 27), SHIFT_REPEAT(575),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__top_decl_list, 2),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 1, .production_id = 23),
  [1117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 2, .production_id = 46),
  [1119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parenthesized_single_pattern, 3, .production_id = 20),
  [1121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parenthesized_single_pattern, 3, .production_id = 20),
  [1123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_pattern, 1, .production_id = 3),
  [1125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_pattern_cons, 1),
  [1127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_pattern, 1, .production_id = 3),
  [1129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern, 1, .production_id = 3),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 1, .production_id = 3),
  [1133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(786),
  [1135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern, 1, .production_id = 5),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 1, .production_id = 5),
  [1139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cons_pattern_repeat1, 2, .production_id = 21),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cons_pattern_repeat1, 2, .production_id = 21),
  [1143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_pattern, 1, .production_id = 5),
  [1145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_pattern, 1, .production_id = 5),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 2, .production_id = 10),
  [1149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern, 2, .production_id = 10),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern_as, 2, .production_id = 26),
  [1153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern_as, 2, .production_id = 26),
  [1155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 2, .production_id = 12),
  [1157] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern, 2, .production_id = 12),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(800),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(863),
  [1167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [1169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(573),
  [1175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(482),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [1187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(508),
  [1189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 4, .production_id = 63),
  [1191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 4, .production_id = 65),
  [1193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 5, .production_id = 89),
  [1195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 4, .production_id = 67),
  [1197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 3, .production_id = 44),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_type_expression, 3, .production_id = 21),
  [1207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_variant_repeat1, 1, .production_id = 14),
  [1213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 2),
  [1215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(519),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 1, .production_id = 16),
  [1227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_type_expression, 1, .production_id = 15),
  [1229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 1),
  [1231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1235] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cons_pattern_repeat1, 2, .production_id = 27), SHIFT_REPEAT(338),
  [1238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string_parts, 2), SHIFT_REPEAT(573),
  [1241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string_parts, 2), SHIFT_REPEAT(508),
  [1244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__string_parts, 2),
  [1246] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string_parts_multiline, 2), SHIFT_REPEAT(574),
  [1249] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string_parts_multiline, 2), SHIFT_REPEAT(509),
  [1252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__string_parts_multiline, 2),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(510),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [1262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [1270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(812),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(817),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_expression_repeat1, 2, .production_id = 27),
  [1292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_expression_repeat1, 2, .production_id = 27), SHIFT_REPEAT(468),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expression, 2, .production_id = 27),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(781),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expression, 1, .production_id = 14),
  [1309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regular_string_part, 1),
  [1311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regular_string_part, 1),
  [1313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regular_string_part_multiline, 1),
  [1315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regular_string_part_multiline, 1),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(911),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(892),
  [1323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_clause, 2, .production_id = 7),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(805),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(790),
  [1343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 4, .production_id = 31),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1351] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_expression_repeat1, 2, .production_id = 27), SHIFT_REPEAT(467),
  [1354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 6, .production_id = 72),
  [1356] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat2, 2, .production_id = 71), SHIFT_REPEAT(790),
  [1359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat2, 2, .production_id = 71),
  [1361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_expression_repeat1, 2, .production_id = 28),
  [1363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 5, .production_id = 49),
  [1365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 5, .production_id = 48),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(910),
  [1373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exposed_type, 1),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(745),
  [1380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(730),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(907),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(814),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(818),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(810),
  [1408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_type_repeat1, 2, .production_id = 66),
  [1410] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_record_type_repeat1, 2, .production_id = 66), SHIFT_REPEAT(810),
  [1413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open_char, 1),
  [1415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(787),
  [1417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_type_repeat1, 2, .production_id = 64),
  [1419] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tuple_type_repeat1, 2, .production_id = 64), SHIFT_REPEAT(457),
  [1422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(749),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_inner_fields, 2, .production_id = 58),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [1430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(813),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(881),
  [1444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(773),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_else_expr_repeat1, 3, .production_id = 93),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(923),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1472] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_expression_repeat1, 2, .production_id = 27), SHIFT_REPEAT(465),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(861),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1485] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__more_case_of_branches_repeat1, 2, .production_id = 97), SHIFT_REPEAT(280),
  [1488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__more_case_of_branches_repeat1, 2, .production_id = 97),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__more_case_of_branches, 1, .dynamic_precedence = 6, .production_id = 95),
  [1494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_inner_fields, 1, .production_id = 39),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(890),
  [1502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_pattern_repeat1, 2, .production_id = 36),
  [1522] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_record_pattern_repeat1, 2, .production_id = 36), SHIFT_REPEAT(735),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(834),
  [1527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_pattern_repeat1, 2, .production_id = 27),
  [1529] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_pattern_repeat1, 2, .production_id = 27), SHIFT_REPEAT(309),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(735),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(855),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_pattern_repeat1, 2, .production_id = 76),
  [1562] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tuple_pattern_repeat1, 2, .production_id = 76), SHIFT_REPEAT(296),
  [1565] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__more_inner_declarations, 2, .production_id = 92), SHIFT_REPEAT(232),
  [1568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__more_inner_declarations, 2, .production_id = 92),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_exposing_list_repeat1, 2),
  [1578] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_exposing_list_repeat1, 2), SHIFT_REPEAT(493),
  [1581] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_qid_repeat1, 2), SHIFT_REPEAT(828),
  [1584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_value_qid_repeat1, 2),
  [1586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(870),
  [1594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(829),
  [1602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1616] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_expr_repeat1, 2, .production_id = 81),
  [1618] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tuple_expr_repeat1, 2, .production_id = 81), SHIFT_REPEAT(51),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(878),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(888),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_clause, 3, .production_id = 19),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__record_inner_fields_repeat1, 2, .production_id = 86),
  [1653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__record_inner_fields_repeat1, 2, .production_id = 86), SHIFT_REPEAT(765),
  [1656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expr_repeat1, 2, .production_id = 83),
  [1660] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_expr_repeat1, 2, .production_id = 83), SHIFT_REPEAT(64),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(774),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_as_clause, 2, .production_id = 29),
  [1681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__record_inner_fields_repeat1, 2, .production_id = 85),
  [1683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 84),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1687] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_else_expr_repeat1, 2, .production_id = 83), SHIFT_REPEAT(809),
  [1690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(844),
  [1694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lower_type_name, 1),
  [1698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(843),
  [1700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(823),
  [1702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exposed_type, 2),
  [1704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_type_repeat1, 2, .production_id = 44),
  [1708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_type, 3, .production_id = 13),
  [1710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(784),
  [1712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_type_repeat1, 2, .production_id = 62),
  [1718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__more_union_variants, 2, .production_id = 70),
  [1720] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_expr_repeat1, 2, .production_id = 37),
  [1722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [1724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__inner_declaration, 1, .production_id = 53),
  [1726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_expr_repeat1, 2, .production_id = 79),
  [1728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_declaration, 3, .production_id = 24),
  [1744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_base_identifier, 1),
  [1750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_annotation, 3, .production_id = 13),
  [1752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat2, 1, .production_id = 47),
  [1754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__more_inner_declarations, 2, .production_id = 90),
  [1758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_of_branch, 3, .production_id = 98),
  [1764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(806),
  [1770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exposed_operator, 1, .production_id = 25),
  [1772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exposed_value, 1),
  [1776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(799),
  [1778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_pattern_repeat1, 2, .production_id = 6),
  [1780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__more_case_of_branches_repeat1, 2, .production_id = 94),
  [1792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exposed_union_constructors, 3),
  [1798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_pattern_repeat1, 2, .production_id = 21),
  [1802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(778),
  [1806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_pattern_repeat1, 2, .production_id = 22),
  [1810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(822),
  [1812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(793),
  [1814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_declaration, 6, .production_id = 73),
  [1818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
