#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 12
#define STATE_COUNT 907
#define LARGE_STATE_COUNT 113
#define SYMBOL_COUNT 109
#define ALIAS_COUNT 4
#define TOKEN_COUNT 64
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 8

enum {
  anon_sym_return = 1,
  anon_sym_COMMA = 2,
  anon_sym_EQ = 3,
  anon_sym_local = 4,
  anon_sym_LBRACK = 5,
  anon_sym_RBRACK = 6,
  anon_sym_DOT = 7,
  anon_sym_do = 8,
  anon_sym_end = 9,
  anon_sym_if = 10,
  anon_sym_then = 11,
  anon_sym_elseif = 12,
  anon_sym_else = 13,
  anon_sym_while = 14,
  anon_sym_repeat = 15,
  anon_sym_until = 16,
  anon_sym_for = 17,
  anon_sym_in = 18,
  anon_sym_goto = 19,
  sym_break_statement = 20,
  anon_sym_COLON_COLON = 21,
  anon_sym_SEMI = 22,
  anon_sym_function = 23,
  anon_sym_COLON = 24,
  anon_sym_LPAREN = 25,
  anon_sym_RPAREN = 26,
  sym_spread = 27,
  sym_self = 28,
  sym_next = 29,
  anon_sym__G = 30,
  anon_sym__VERSION = 31,
  anon_sym_LBRACE = 32,
  anon_sym_RBRACE = 33,
  anon_sym_or = 34,
  anon_sym_and = 35,
  anon_sym_LT = 36,
  anon_sym_LT_EQ = 37,
  anon_sym_EQ_EQ = 38,
  anon_sym_TILDE_EQ = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT = 41,
  anon_sym_PIPE = 42,
  anon_sym_TILDE = 43,
  anon_sym_AMP = 44,
  anon_sym_LT_LT = 45,
  anon_sym_GT_GT = 46,
  anon_sym_PLUS = 47,
  anon_sym_DASH = 48,
  anon_sym_STAR = 49,
  anon_sym_SLASH = 50,
  anon_sym_SLASH_SLASH = 51,
  anon_sym_PERCENT = 52,
  anon_sym_DOT_DOT = 53,
  anon_sym_CARET = 54,
  anon_sym_not = 55,
  anon_sym_POUND = 56,
  sym_number = 57,
  sym_nil = 58,
  sym_true = 59,
  sym_false = 60,
  sym_identifier = 61,
  sym_comment = 62,
  sym_string = 63,
  sym_program = 64,
  sym_return_statement = 65,
  sym_variable_declaration = 66,
  sym_local_variable_declaration = 67,
  sym__variable_declarator = 68,
  sym_field_expression = 69,
  sym__local_variable_declarator = 70,
  sym_do_statement = 71,
  sym_if_statement = 72,
  sym_elseif = 73,
  sym_else = 74,
  sym_while_statement = 75,
  sym_repeat_statement = 76,
  sym_for_statement = 77,
  sym_for_in_statement = 78,
  sym__loop_expression = 79,
  sym__in_loop_expression = 80,
  sym_goto_statement = 81,
  sym_label_statement = 82,
  sym__empty_statement = 83,
  sym_function_statement = 84,
  sym_local_function_statement = 85,
  sym_function_call_statement = 86,
  sym_arguments = 87,
  sym_function_name = 88,
  sym_function_name_field = 89,
  sym_parameters = 90,
  sym__function_body = 91,
  sym__expression = 92,
  sym_global_variable = 93,
  sym__prefix = 94,
  sym_function_definition = 95,
  sym_table = 96,
  sym_field = 97,
  sym__field_sequence = 98,
  sym__field_sep = 99,
  sym_binary_operation = 100,
  sym_unary_operation = 101,
  aux_sym_program_repeat1 = 102,
  aux_sym_return_statement_repeat1 = 103,
  aux_sym_variable_declaration_repeat1 = 104,
  aux_sym__local_variable_declarator_repeat1 = 105,
  aux_sym_if_statement_repeat1 = 106,
  aux_sym_function_name_field_repeat1 = 107,
  aux_sym__field_sequence_repeat1 = 108,
  alias_sym_condition_expression = 109,
  alias_sym_expression = 110,
  alias_sym_method = 111,
  alias_sym_property_identifier = 112,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_return] = "return",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_local] = "local",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_goto] = "goto",
  [sym_break_statement] = "break_statement",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_COLON] = ":",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_spread] = "spread",
  [sym_self] = "self",
  [sym_next] = "next",
  [anon_sym__G] = "_G",
  [anon_sym__VERSION] = "_VERSION",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [sym_number] = "number",
  [sym_nil] = "nil",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [sym_string] = "string",
  [sym_program] = "program",
  [sym_return_statement] = "return_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym__variable_declarator] = "_variable_declarator",
  [sym_field_expression] = "field_expression",
  [sym__local_variable_declarator] = "variable_declarator",
  [sym_do_statement] = "do_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__loop_expression] = "loop_expression",
  [sym__in_loop_expression] = "loop_expression",
  [sym_goto_statement] = "goto_statement",
  [sym_label_statement] = "label_statement",
  [sym__empty_statement] = "_empty_statement",
  [sym_function_statement] = "function",
  [sym_local_function_statement] = "local_function",
  [sym_function_call_statement] = "function_call",
  [sym_arguments] = "arguments",
  [sym_function_name] = "function_name",
  [sym_function_name_field] = "function_name_field",
  [sym_parameters] = "parameters",
  [sym__function_body] = "_function_body",
  [sym__expression] = "_expression",
  [sym_global_variable] = "global_variable",
  [sym__prefix] = "_prefix",
  [sym_function_definition] = "function_definition",
  [sym_table] = "table",
  [sym_field] = "field",
  [sym__field_sequence] = "_field_sequence",
  [sym__field_sep] = "_field_sep",
  [sym_binary_operation] = "binary_operation",
  [sym_unary_operation] = "unary_operation",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_return_statement_repeat1] = "return_statement_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym__local_variable_declarator_repeat1] = "_local_variable_declarator_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_function_name_field_repeat1] = "function_name_field_repeat1",
  [aux_sym__field_sequence_repeat1] = "_field_sequence_repeat1",
  [alias_sym_condition_expression] = "condition_expression",
  [alias_sym_expression] = "expression",
  [alias_sym_method] = "method",
  [alias_sym_property_identifier] = "property_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_goto] = anon_sym_goto,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_spread] = sym_spread,
  [sym_self] = sym_self,
  [sym_next] = sym_next,
  [anon_sym__G] = anon_sym__G,
  [anon_sym__VERSION] = anon_sym__VERSION,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_number] = sym_number,
  [sym_nil] = sym_nil,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [sym_string] = sym_string,
  [sym_program] = sym_program,
  [sym_return_statement] = sym_return_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym__variable_declarator] = sym__variable_declarator,
  [sym_field_expression] = sym_field_expression,
  [sym__local_variable_declarator] = sym__local_variable_declarator,
  [sym_do_statement] = sym_do_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__loop_expression] = sym__loop_expression,
  [sym__in_loop_expression] = sym__loop_expression,
  [sym_goto_statement] = sym_goto_statement,
  [sym_label_statement] = sym_label_statement,
  [sym__empty_statement] = sym__empty_statement,
  [sym_function_statement] = sym_function_statement,
  [sym_local_function_statement] = sym_local_function_statement,
  [sym_function_call_statement] = sym_function_call_statement,
  [sym_arguments] = sym_arguments,
  [sym_function_name] = sym_function_name,
  [sym_function_name_field] = sym_function_name_field,
  [sym_parameters] = sym_parameters,
  [sym__function_body] = sym__function_body,
  [sym__expression] = sym__expression,
  [sym_global_variable] = sym_global_variable,
  [sym__prefix] = sym__prefix,
  [sym_function_definition] = sym_function_definition,
  [sym_table] = sym_table,
  [sym_field] = sym_field,
  [sym__field_sequence] = sym__field_sequence,
  [sym__field_sep] = sym__field_sep,
  [sym_binary_operation] = sym_binary_operation,
  [sym_unary_operation] = sym_unary_operation,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_return_statement_repeat1] = aux_sym_return_statement_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym__local_variable_declarator_repeat1] = aux_sym__local_variable_declarator_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_function_name_field_repeat1] = aux_sym_function_name_field_repeat1,
  [aux_sym__field_sequence_repeat1] = aux_sym__field_sequence_repeat1,
  [alias_sym_condition_expression] = alias_sym_condition_expression,
  [alias_sym_expression] = alias_sym_expression,
  [alias_sym_method] = alias_sym_method,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__G] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__VERSION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__in_loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name_field] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_global_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__prefix] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__field_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__field_sep] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_return_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__local_variable_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_name_field_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_condition_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_method] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_object = 1,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_object] = "object",
};

static const TSFieldMapSlice ts_field_map_slices[12] = {
  [2] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_object, 0},
};

static TSSymbol ts_alias_sequences[12][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_expression,
  },
  [3] = {
    [2] = alias_sym_condition_expression,
  },
  [4] = {
    [1] = sym__local_variable_declarator,
  },
  [5] = {
    [0] = sym__local_variable_declarator,
  },
  [6] = {
    [2] = alias_sym_property_identifier,
  },
  [7] = {
    [1] = alias_sym_condition_expression,
  },
  [8] = {
    [3] = alias_sym_condition_expression,
  },
  [9] = {
    [1] = alias_sym_property_identifier,
  },
  [10] = {
    [2] = alias_sym_method,
  },
  [11] = {
    [4] = alias_sym_condition_expression,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__variable_declarator, 2,
    sym__variable_declarator,
    sym__local_variable_declarator,
  sym__expression, 3,
    sym__expression,
    alias_sym_condition_expression,
    alias_sym_expression,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(95);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '%') ADVANCE(171);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(159);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == ']') ADVANCE(104);
      if (lookahead == '^') ADVANCE(174);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'a') ADVANCE(60);
      if (lookahead == 'b') ADVANCE(74);
      if (lookahead == 'd') ADVANCE(66);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(72);
      if (lookahead == 'r') ADVANCE(33);
      if (lookahead == 's') ADVANCE(39);
      if (lookahead == 't') ADVANCE(48);
      if (lookahead == 'u') ADVANCE(65);
      if (lookahead == 'w') ADVANCE(46);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(149);
      if (lookahead == '~') ADVANCE(162);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 1:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '%') ADVANCE(171);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(159);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == '^') ADVANCE(174);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'a') ADVANCE(234);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(229);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(244);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '~') ADVANCE(162);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 2:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '%') ADVANCE(171);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(159);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == '^') ADVANCE(174);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'a') ADVANCE(234);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(244);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '~') ADVANCE(162);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '%') ADVANCE(171);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(159);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == '^') ADVANCE(174);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'a') ADVANCE(234);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(244);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(235);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '~') ADVANCE(162);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(16);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(229);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(16);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(16);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(235);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'e') ADVANCE(229);
      if (lookahead == 'f') ADVANCE(198);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'e') ADVANCE(232);
      if (lookahead == 'f') ADVANCE(198);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 9:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'f') ADVANCE(198);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(235);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 10:
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 12:
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(139);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 16:
      if (lookahead == ':') ADVANCE(131);
      END_STATE();
    case 17:
      if (lookahead == 'E') ADVANCE(22);
      END_STATE();
    case 18:
      if (lookahead == 'G') ADVANCE(144);
      if (lookahead == 'V') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == 'I') ADVANCE(21);
      END_STATE();
    case 20:
      if (lookahead == 'N') ADVANCE(146);
      END_STATE();
    case 21:
      if (lookahead == 'O') ADVANCE(20);
      END_STATE();
    case 22:
      if (lookahead == 'R') ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == 'S') ADVANCE(19);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(59);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 'u') ADVANCE(64);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(80);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(26);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(81);
      END_STATE();
    case 30:
      if (lookahead == 'd') ADVANCE(152);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(109);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(86);
      if (lookahead == 'i') ADVANCE(54);
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 42:
      if (lookahead == 'f') ADVANCE(111);
      if (lookahead == 'n') ADVANCE(126);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(140);
      END_STATE();
    case 44:
      if (lookahead == 'f') ADVANCE(114);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(255);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 46:
      if (lookahead == 'h') ADVANCE(49);
      END_STATE();
    case 47:
      if (lookahead == 'h') ADVANCE(41);
      END_STATE();
    case 48:
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(70);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(129);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 58:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(77);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 71:
      if (lookahead == 'p') ADVANCE(40);
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 72:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 76:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 86:
      if (lookahead == 'x') ADVANCE(79);
      END_STATE();
    case 87:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 91:
      if (eof) ADVANCE(95);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '%') ADVANCE(171);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(159);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == '^') ADVANCE(174);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'a') ADVANCE(234);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(244);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '~') ADVANCE(162);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 92:
      if (eof) ADVANCE(95);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'f') ADVANCE(198);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '}') ADVANCE(149);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 93:
      if (eof) ADVANCE(95);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(178);
      if (lookahead == ':') ADVANCE(16);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '_') ADVANCE(191);
      if (lookahead == 'b') ADVANCE(246);
      if (lookahead == 'd') ADVANCE(236);
      if (lookahead == 'f') ADVANCE(197);
      if (lookahead == 'g') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(206);
      if (lookahead == 'r') ADVANCE(207);
      if (lookahead == 's') ADVANCE(213);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'w') ADVANCE(218);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '~') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 94:
      if (eof) ADVANCE(95);
      if (lookahead == '%') ADVANCE(171);
      if (lookahead == '&') ADVANCE(163);
      if (lookahead == '(') ADVANCE(137);
      if (lookahead == ')') ADVANCE(138);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(98);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(106);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == ':') ADVANCE(135);
      if (lookahead == ';') ADVANCE(132);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(159);
      if (lookahead == '[') ADVANCE(103);
      if (lookahead == ']') ADVANCE(104);
      if (lookahead == '^') ADVANCE(174);
      if (lookahead == 'a') ADVANCE(60);
      if (lookahead == 'd') ADVANCE(66);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'o') ADVANCE(72);
      if (lookahead == 't') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(65);
      if (lookahead == '{') ADVANCE(148);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(149);
      if (lookahead == '~') ADVANCE(162);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(94)
      END_STATE();
    case 95:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(156);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_local);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(172);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_do);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_end);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(44);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_until);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_goto);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_break_statement);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(131);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_spread);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_self);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_next);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym__G);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym__G);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym__VERSION);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym__VERSION);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(164);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '>') ADVANCE(165);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(170);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(139);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(87);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(89);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(181);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_nil);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G') ADVANCE(145);
      if (lookahead == 'V') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(223);
      if (lookahead == 'o') ADVANCE(243);
      if (lookahead == 'u') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(223);
      if (lookahead == 'u') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == 'i') ADVANCE(224);
      if (lookahead == 'o') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(248);
      if (lookahead == 'n') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(214);
      if (lookahead == 't') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 93, .external_lex_state = 1},
  [2] = {.lex_state = 4, .external_lex_state = 1},
  [3] = {.lex_state = 4, .external_lex_state = 1},
  [4] = {.lex_state = 4, .external_lex_state = 1},
  [5] = {.lex_state = 4, .external_lex_state = 1},
  [6] = {.lex_state = 4, .external_lex_state = 1},
  [7] = {.lex_state = 4, .external_lex_state = 1},
  [8] = {.lex_state = 4, .external_lex_state = 1},
  [9] = {.lex_state = 4, .external_lex_state = 1},
  [10] = {.lex_state = 4, .external_lex_state = 1},
  [11] = {.lex_state = 4, .external_lex_state = 1},
  [12] = {.lex_state = 1, .external_lex_state = 1},
  [13] = {.lex_state = 1, .external_lex_state = 1},
  [14] = {.lex_state = 1, .external_lex_state = 1},
  [15] = {.lex_state = 1, .external_lex_state = 1},
  [16] = {.lex_state = 4, .external_lex_state = 1},
  [17] = {.lex_state = 1, .external_lex_state = 1},
  [18] = {.lex_state = 1, .external_lex_state = 1},
  [19] = {.lex_state = 5, .external_lex_state = 1},
  [20] = {.lex_state = 5, .external_lex_state = 1},
  [21] = {.lex_state = 3, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 1, .external_lex_state = 1},
  [24] = {.lex_state = 5, .external_lex_state = 1},
  [25] = {.lex_state = 5, .external_lex_state = 1},
  [26] = {.lex_state = 91, .external_lex_state = 1},
  [27] = {.lex_state = 5, .external_lex_state = 1},
  [28] = {.lex_state = 1, .external_lex_state = 1},
  [29] = {.lex_state = 5, .external_lex_state = 1},
  [30] = {.lex_state = 91, .external_lex_state = 1},
  [31] = {.lex_state = 93, .external_lex_state = 1},
  [32] = {.lex_state = 1, .external_lex_state = 1},
  [33] = {.lex_state = 5, .external_lex_state = 1},
  [34] = {.lex_state = 5, .external_lex_state = 1},
  [35] = {.lex_state = 5, .external_lex_state = 1},
  [36] = {.lex_state = 1, .external_lex_state = 1},
  [37] = {.lex_state = 1, .external_lex_state = 1},
  [38] = {.lex_state = 1, .external_lex_state = 1},
  [39] = {.lex_state = 5, .external_lex_state = 1},
  [40] = {.lex_state = 5, .external_lex_state = 1},
  [41] = {.lex_state = 5, .external_lex_state = 1},
  [42] = {.lex_state = 5, .external_lex_state = 1},
  [43] = {.lex_state = 5, .external_lex_state = 1},
  [44] = {.lex_state = 6, .external_lex_state = 1},
  [45] = {.lex_state = 5, .external_lex_state = 1},
  [46] = {.lex_state = 6, .external_lex_state = 1},
  [47] = {.lex_state = 5, .external_lex_state = 1},
  [48] = {.lex_state = 5, .external_lex_state = 1},
  [49] = {.lex_state = 6, .external_lex_state = 1},
  [50] = {.lex_state = 5, .external_lex_state = 1},
  [51] = {.lex_state = 5, .external_lex_state = 1},
  [52] = {.lex_state = 5, .external_lex_state = 1},
  [53] = {.lex_state = 5, .external_lex_state = 1},
  [54] = {.lex_state = 5, .external_lex_state = 1},
  [55] = {.lex_state = 5, .external_lex_state = 1},
  [56] = {.lex_state = 5, .external_lex_state = 1},
  [57] = {.lex_state = 5, .external_lex_state = 1},
  [58] = {.lex_state = 5, .external_lex_state = 1},
  [59] = {.lex_state = 5, .external_lex_state = 1},
  [60] = {.lex_state = 5, .external_lex_state = 1},
  [61] = {.lex_state = 5, .external_lex_state = 1},
  [62] = {.lex_state = 6, .external_lex_state = 1},
  [63] = {.lex_state = 5, .external_lex_state = 1},
  [64] = {.lex_state = 5, .external_lex_state = 1},
  [65] = {.lex_state = 6, .external_lex_state = 1},
  [66] = {.lex_state = 5, .external_lex_state = 1},
  [67] = {.lex_state = 1, .external_lex_state = 1},
  [68] = {.lex_state = 5, .external_lex_state = 1},
  [69] = {.lex_state = 5, .external_lex_state = 1},
  [70] = {.lex_state = 5, .external_lex_state = 1},
  [71] = {.lex_state = 5, .external_lex_state = 1},
  [72] = {.lex_state = 5, .external_lex_state = 1},
  [73] = {.lex_state = 3, .external_lex_state = 1},
  [74] = {.lex_state = 5, .external_lex_state = 1},
  [75] = {.lex_state = 5, .external_lex_state = 1},
  [76] = {.lex_state = 5, .external_lex_state = 1},
  [77] = {.lex_state = 5, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 6, .external_lex_state = 1},
  [80] = {.lex_state = 1, .external_lex_state = 1},
  [81] = {.lex_state = 5, .external_lex_state = 1},
  [82] = {.lex_state = 5, .external_lex_state = 1},
  [83] = {.lex_state = 6, .external_lex_state = 1},
  [84] = {.lex_state = 5, .external_lex_state = 1},
  [85] = {.lex_state = 5, .external_lex_state = 1},
  [86] = {.lex_state = 1, .external_lex_state = 1},
  [87] = {.lex_state = 6, .external_lex_state = 1},
  [88] = {.lex_state = 5, .external_lex_state = 1},
  [89] = {.lex_state = 5, .external_lex_state = 1},
  [90] = {.lex_state = 5, .external_lex_state = 1},
  [91] = {.lex_state = 5, .external_lex_state = 1},
  [92] = {.lex_state = 5, .external_lex_state = 1},
  [93] = {.lex_state = 1, .external_lex_state = 1},
  [94] = {.lex_state = 5, .external_lex_state = 1},
  [95] = {.lex_state = 5, .external_lex_state = 1},
  [96] = {.lex_state = 1, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 1, .external_lex_state = 1},
  [99] = {.lex_state = 91, .external_lex_state = 1},
  [100] = {.lex_state = 6, .external_lex_state = 1},
  [101] = {.lex_state = 3, .external_lex_state = 1},
  [102] = {.lex_state = 3, .external_lex_state = 1},
  [103] = {.lex_state = 91, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 3, .external_lex_state = 1},
  [107] = {.lex_state = 5, .external_lex_state = 1},
  [108] = {.lex_state = 93, .external_lex_state = 1},
  [109] = {.lex_state = 91, .external_lex_state = 1},
  [110] = {.lex_state = 91, .external_lex_state = 1},
  [111] = {.lex_state = 2, .external_lex_state = 1},
  [112] = {.lex_state = 3, .external_lex_state = 1},
  [113] = {.lex_state = 1, .external_lex_state = 1},
  [114] = {.lex_state = 3, .external_lex_state = 1},
  [115] = {.lex_state = 2, .external_lex_state = 1},
  [116] = {.lex_state = 91, .external_lex_state = 1},
  [117] = {.lex_state = 91, .external_lex_state = 1},
  [118] = {.lex_state = 2, .external_lex_state = 1},
  [119] = {.lex_state = 3, .external_lex_state = 1},
  [120] = {.lex_state = 3, .external_lex_state = 1},
  [121] = {.lex_state = 1, .external_lex_state = 1},
  [122] = {.lex_state = 3, .external_lex_state = 1},
  [123] = {.lex_state = 3, .external_lex_state = 1},
  [124] = {.lex_state = 91, .external_lex_state = 1},
  [125] = {.lex_state = 2, .external_lex_state = 1},
  [126] = {.lex_state = 1, .external_lex_state = 1},
  [127] = {.lex_state = 91, .external_lex_state = 1},
  [128] = {.lex_state = 3, .external_lex_state = 1},
  [129] = {.lex_state = 3, .external_lex_state = 1},
  [130] = {.lex_state = 91, .external_lex_state = 1},
  [131] = {.lex_state = 91, .external_lex_state = 1},
  [132] = {.lex_state = 2, .external_lex_state = 1},
  [133] = {.lex_state = 2, .external_lex_state = 1},
  [134] = {.lex_state = 91, .external_lex_state = 1},
  [135] = {.lex_state = 3, .external_lex_state = 1},
  [136] = {.lex_state = 2, .external_lex_state = 1},
  [137] = {.lex_state = 2, .external_lex_state = 1},
  [138] = {.lex_state = 2, .external_lex_state = 1},
  [139] = {.lex_state = 3, .external_lex_state = 1},
  [140] = {.lex_state = 91, .external_lex_state = 1},
  [141] = {.lex_state = 91, .external_lex_state = 1},
  [142] = {.lex_state = 2, .external_lex_state = 1},
  [143] = {.lex_state = 3, .external_lex_state = 1},
  [144] = {.lex_state = 91, .external_lex_state = 1},
  [145] = {.lex_state = 91, .external_lex_state = 1},
  [146] = {.lex_state = 3, .external_lex_state = 1},
  [147] = {.lex_state = 2, .external_lex_state = 1},
  [148] = {.lex_state = 2, .external_lex_state = 1},
  [149] = {.lex_state = 1, .external_lex_state = 1},
  [150] = {.lex_state = 1, .external_lex_state = 1},
  [151] = {.lex_state = 91, .external_lex_state = 1},
  [152] = {.lex_state = 1, .external_lex_state = 1},
  [153] = {.lex_state = 1, .external_lex_state = 1},
  [154] = {.lex_state = 1, .external_lex_state = 1},
  [155] = {.lex_state = 1, .external_lex_state = 1},
  [156] = {.lex_state = 1, .external_lex_state = 1},
  [157] = {.lex_state = 2, .external_lex_state = 1},
  [158] = {.lex_state = 1, .external_lex_state = 1},
  [159] = {.lex_state = 1, .external_lex_state = 1},
  [160] = {.lex_state = 1, .external_lex_state = 1},
  [161] = {.lex_state = 1, .external_lex_state = 1},
  [162] = {.lex_state = 1, .external_lex_state = 1},
  [163] = {.lex_state = 1, .external_lex_state = 1},
  [164] = {.lex_state = 1, .external_lex_state = 1},
  [165] = {.lex_state = 1, .external_lex_state = 1},
  [166] = {.lex_state = 1, .external_lex_state = 1},
  [167] = {.lex_state = 1, .external_lex_state = 1},
  [168] = {.lex_state = 3, .external_lex_state = 1},
  [169] = {.lex_state = 1, .external_lex_state = 1},
  [170] = {.lex_state = 91, .external_lex_state = 1},
  [171] = {.lex_state = 1, .external_lex_state = 1},
  [172] = {.lex_state = 2, .external_lex_state = 1},
  [173] = {.lex_state = 1, .external_lex_state = 1},
  [174] = {.lex_state = 2, .external_lex_state = 1},
  [175] = {.lex_state = 91, .external_lex_state = 1},
  [176] = {.lex_state = 1, .external_lex_state = 1},
  [177] = {.lex_state = 1, .external_lex_state = 1},
  [178] = {.lex_state = 1, .external_lex_state = 1},
  [179] = {.lex_state = 91, .external_lex_state = 1},
  [180] = {.lex_state = 1, .external_lex_state = 1},
  [181] = {.lex_state = 1, .external_lex_state = 1},
  [182] = {.lex_state = 1, .external_lex_state = 1},
  [183] = {.lex_state = 2, .external_lex_state = 1},
  [184] = {.lex_state = 1, .external_lex_state = 1},
  [185] = {.lex_state = 1, .external_lex_state = 1},
  [186] = {.lex_state = 1, .external_lex_state = 1},
  [187] = {.lex_state = 1, .external_lex_state = 1},
  [188] = {.lex_state = 1, .external_lex_state = 1},
  [189] = {.lex_state = 3, .external_lex_state = 1},
  [190] = {.lex_state = 1, .external_lex_state = 1},
  [191] = {.lex_state = 1, .external_lex_state = 1},
  [192] = {.lex_state = 3, .external_lex_state = 1},
  [193] = {.lex_state = 3, .external_lex_state = 1},
  [194] = {.lex_state = 1, .external_lex_state = 1},
  [195] = {.lex_state = 91, .external_lex_state = 1},
  [196] = {.lex_state = 3, .external_lex_state = 1},
  [197] = {.lex_state = 3, .external_lex_state = 1},
  [198] = {.lex_state = 91, .external_lex_state = 1},
  [199] = {.lex_state = 91, .external_lex_state = 1},
  [200] = {.lex_state = 91, .external_lex_state = 1},
  [201] = {.lex_state = 91, .external_lex_state = 1},
  [202] = {.lex_state = 2, .external_lex_state = 1},
  [203] = {.lex_state = 91, .external_lex_state = 1},
  [204] = {.lex_state = 91, .external_lex_state = 1},
  [205] = {.lex_state = 91, .external_lex_state = 1},
  [206] = {.lex_state = 91, .external_lex_state = 1},
  [207] = {.lex_state = 91, .external_lex_state = 1},
  [208] = {.lex_state = 91, .external_lex_state = 1},
  [209] = {.lex_state = 91, .external_lex_state = 1},
  [210] = {.lex_state = 2, .external_lex_state = 1},
  [211] = {.lex_state = 91, .external_lex_state = 1},
  [212] = {.lex_state = 2, .external_lex_state = 1},
  [213] = {.lex_state = 2, .external_lex_state = 1},
  [214] = {.lex_state = 2, .external_lex_state = 1},
  [215] = {.lex_state = 2, .external_lex_state = 1},
  [216] = {.lex_state = 2, .external_lex_state = 1},
  [217] = {.lex_state = 2, .external_lex_state = 1},
  [218] = {.lex_state = 3, .external_lex_state = 1},
  [219] = {.lex_state = 2, .external_lex_state = 1},
  [220] = {.lex_state = 2, .external_lex_state = 1},
  [221] = {.lex_state = 2, .external_lex_state = 1},
  [222] = {.lex_state = 91, .external_lex_state = 1},
  [223] = {.lex_state = 2, .external_lex_state = 1},
  [224] = {.lex_state = 2, .external_lex_state = 1},
  [225] = {.lex_state = 91, .external_lex_state = 1},
  [226] = {.lex_state = 2, .external_lex_state = 1},
  [227] = {.lex_state = 3, .external_lex_state = 1},
  [228] = {.lex_state = 91, .external_lex_state = 1},
  [229] = {.lex_state = 3, .external_lex_state = 1},
  [230] = {.lex_state = 3, .external_lex_state = 1},
  [231] = {.lex_state = 2, .external_lex_state = 1},
  [232] = {.lex_state = 3, .external_lex_state = 1},
  [233] = {.lex_state = 3, .external_lex_state = 1},
  [234] = {.lex_state = 2, .external_lex_state = 1},
  [235] = {.lex_state = 3, .external_lex_state = 1},
  [236] = {.lex_state = 3, .external_lex_state = 1},
  [237] = {.lex_state = 3, .external_lex_state = 1},
  [238] = {.lex_state = 3, .external_lex_state = 1},
  [239] = {.lex_state = 2, .external_lex_state = 1},
  [240] = {.lex_state = 3, .external_lex_state = 1},
  [241] = {.lex_state = 2, .external_lex_state = 1},
  [242] = {.lex_state = 3, .external_lex_state = 1},
  [243] = {.lex_state = 3, .external_lex_state = 1},
  [244] = {.lex_state = 91, .external_lex_state = 1},
  [245] = {.lex_state = 91, .external_lex_state = 1},
  [246] = {.lex_state = 3, .external_lex_state = 1},
  [247] = {.lex_state = 3, .external_lex_state = 1},
  [248] = {.lex_state = 3, .external_lex_state = 1},
  [249] = {.lex_state = 91, .external_lex_state = 1},
  [250] = {.lex_state = 2, .external_lex_state = 1},
  [251] = {.lex_state = 91, .external_lex_state = 1},
  [252] = {.lex_state = 2, .external_lex_state = 1},
  [253] = {.lex_state = 91, .external_lex_state = 1},
  [254] = {.lex_state = 91, .external_lex_state = 1},
  [255] = {.lex_state = 3, .external_lex_state = 1},
  [256] = {.lex_state = 91, .external_lex_state = 1},
  [257] = {.lex_state = 91, .external_lex_state = 1},
  [258] = {.lex_state = 3, .external_lex_state = 1},
  [259] = {.lex_state = 3, .external_lex_state = 1},
  [260] = {.lex_state = 3, .external_lex_state = 1},
  [261] = {.lex_state = 2, .external_lex_state = 1},
  [262] = {.lex_state = 2, .external_lex_state = 1},
  [263] = {.lex_state = 2, .external_lex_state = 1},
  [264] = {.lex_state = 2, .external_lex_state = 1},
  [265] = {.lex_state = 2, .external_lex_state = 1},
  [266] = {.lex_state = 2, .external_lex_state = 1},
  [267] = {.lex_state = 2, .external_lex_state = 1},
  [268] = {.lex_state = 2, .external_lex_state = 1},
  [269] = {.lex_state = 3, .external_lex_state = 1},
  [270] = {.lex_state = 3, .external_lex_state = 1},
  [271] = {.lex_state = 2, .external_lex_state = 1},
  [272] = {.lex_state = 2, .external_lex_state = 1},
  [273] = {.lex_state = 2, .external_lex_state = 1},
  [274] = {.lex_state = 2, .external_lex_state = 1},
  [275] = {.lex_state = 2, .external_lex_state = 1},
  [276] = {.lex_state = 3, .external_lex_state = 1},
  [277] = {.lex_state = 91, .external_lex_state = 1},
  [278] = {.lex_state = 3, .external_lex_state = 1},
  [279] = {.lex_state = 3, .external_lex_state = 1},
  [280] = {.lex_state = 3, .external_lex_state = 1},
  [281] = {.lex_state = 3, .external_lex_state = 1},
  [282] = {.lex_state = 91, .external_lex_state = 1},
  [283] = {.lex_state = 91, .external_lex_state = 1},
  [284] = {.lex_state = 91, .external_lex_state = 1},
  [285] = {.lex_state = 91, .external_lex_state = 1},
  [286] = {.lex_state = 91, .external_lex_state = 1},
  [287] = {.lex_state = 91, .external_lex_state = 1},
  [288] = {.lex_state = 3, .external_lex_state = 1},
  [289] = {.lex_state = 3, .external_lex_state = 1},
  [290] = {.lex_state = 2, .external_lex_state = 1},
  [291] = {.lex_state = 3, .external_lex_state = 1},
  [292] = {.lex_state = 91, .external_lex_state = 1},
  [293] = {.lex_state = 3, .external_lex_state = 1},
  [294] = {.lex_state = 91, .external_lex_state = 1},
  [295] = {.lex_state = 91, .external_lex_state = 1},
  [296] = {.lex_state = 3, .external_lex_state = 1},
  [297] = {.lex_state = 94, .external_lex_state = 1},
  [298] = {.lex_state = 94, .external_lex_state = 1},
  [299] = {.lex_state = 94, .external_lex_state = 1},
  [300] = {.lex_state = 94, .external_lex_state = 1},
  [301] = {.lex_state = 94, .external_lex_state = 1},
  [302] = {.lex_state = 94, .external_lex_state = 1},
  [303] = {.lex_state = 94, .external_lex_state = 1},
  [304] = {.lex_state = 94, .external_lex_state = 1},
  [305] = {.lex_state = 94, .external_lex_state = 1},
  [306] = {.lex_state = 94, .external_lex_state = 1},
  [307] = {.lex_state = 94, .external_lex_state = 1},
  [308] = {.lex_state = 94, .external_lex_state = 1},
  [309] = {.lex_state = 94, .external_lex_state = 1},
  [310] = {.lex_state = 94, .external_lex_state = 1},
  [311] = {.lex_state = 94, .external_lex_state = 1},
  [312] = {.lex_state = 4, .external_lex_state = 1},
  [313] = {.lex_state = 4, .external_lex_state = 1},
  [314] = {.lex_state = 4, .external_lex_state = 1},
  [315] = {.lex_state = 4, .external_lex_state = 1},
  [316] = {.lex_state = 4, .external_lex_state = 1},
  [317] = {.lex_state = 4, .external_lex_state = 1},
  [318] = {.lex_state = 4, .external_lex_state = 1},
  [319] = {.lex_state = 4, .external_lex_state = 1},
  [320] = {.lex_state = 6, .external_lex_state = 1},
  [321] = {.lex_state = 94, .external_lex_state = 2},
  [322] = {.lex_state = 7, .external_lex_state = 1},
  [323] = {.lex_state = 94, .external_lex_state = 2},
  [324] = {.lex_state = 94, .external_lex_state = 2},
  [325] = {.lex_state = 94, .external_lex_state = 2},
  [326] = {.lex_state = 94, .external_lex_state = 2},
  [327] = {.lex_state = 94, .external_lex_state = 2},
  [328] = {.lex_state = 5, .external_lex_state = 1},
  [329] = {.lex_state = 93, .external_lex_state = 1},
  [330] = {.lex_state = 5, .external_lex_state = 1},
  [331] = {.lex_state = 94, .external_lex_state = 2},
  [332] = {.lex_state = 94, .external_lex_state = 2},
  [333] = {.lex_state = 94, .external_lex_state = 2},
  [334] = {.lex_state = 94, .external_lex_state = 2},
  [335] = {.lex_state = 93, .external_lex_state = 1},
  [336] = {.lex_state = 94, .external_lex_state = 2},
  [337] = {.lex_state = 94, .external_lex_state = 2},
  [338] = {.lex_state = 6, .external_lex_state = 1},
  [339] = {.lex_state = 5, .external_lex_state = 1},
  [340] = {.lex_state = 94, .external_lex_state = 2},
  [341] = {.lex_state = 94, .external_lex_state = 2},
  [342] = {.lex_state = 93, .external_lex_state = 1},
  [343] = {.lex_state = 4, .external_lex_state = 1},
  [344] = {.lex_state = 94, .external_lex_state = 2},
  [345] = {.lex_state = 94, .external_lex_state = 2},
  [346] = {.lex_state = 94, .external_lex_state = 2},
  [347] = {.lex_state = 94, .external_lex_state = 2},
  [348] = {.lex_state = 94, .external_lex_state = 2},
  [349] = {.lex_state = 6, .external_lex_state = 1},
  [350] = {.lex_state = 4, .external_lex_state = 1},
  [351] = {.lex_state = 93, .external_lex_state = 1},
  [352] = {.lex_state = 4, .external_lex_state = 1},
  [353] = {.lex_state = 93, .external_lex_state = 1},
  [354] = {.lex_state = 4, .external_lex_state = 1},
  [355] = {.lex_state = 6, .external_lex_state = 1},
  [356] = {.lex_state = 4, .external_lex_state = 1},
  [357] = {.lex_state = 4, .external_lex_state = 1},
  [358] = {.lex_state = 4, .external_lex_state = 1},
  [359] = {.lex_state = 4, .external_lex_state = 1},
  [360] = {.lex_state = 4, .external_lex_state = 1},
  [361] = {.lex_state = 4, .external_lex_state = 1},
  [362] = {.lex_state = 4, .external_lex_state = 1},
  [363] = {.lex_state = 92, .external_lex_state = 1},
  [364] = {.lex_state = 4, .external_lex_state = 1},
  [365] = {.lex_state = 4, .external_lex_state = 1},
  [366] = {.lex_state = 4, .external_lex_state = 1},
  [367] = {.lex_state = 4, .external_lex_state = 1},
  [368] = {.lex_state = 4, .external_lex_state = 1},
  [369] = {.lex_state = 4, .external_lex_state = 1},
  [370] = {.lex_state = 4, .external_lex_state = 1},
  [371] = {.lex_state = 92, .external_lex_state = 1},
  [372] = {.lex_state = 4, .external_lex_state = 1},
  [373] = {.lex_state = 92, .external_lex_state = 1},
  [374] = {.lex_state = 4, .external_lex_state = 1},
  [375] = {.lex_state = 4, .external_lex_state = 1},
  [376] = {.lex_state = 4, .external_lex_state = 1},
  [377] = {.lex_state = 4, .external_lex_state = 1},
  [378] = {.lex_state = 93, .external_lex_state = 1},
  [379] = {.lex_state = 5, .external_lex_state = 1},
  [380] = {.lex_state = 5, .external_lex_state = 1},
  [381] = {.lex_state = 92, .external_lex_state = 1},
  [382] = {.lex_state = 92, .external_lex_state = 1},
  [383] = {.lex_state = 5, .external_lex_state = 1},
  [384] = {.lex_state = 5, .external_lex_state = 1},
  [385] = {.lex_state = 6, .external_lex_state = 1},
  [386] = {.lex_state = 5, .external_lex_state = 1},
  [387] = {.lex_state = 6, .external_lex_state = 1},
  [388] = {.lex_state = 4, .external_lex_state = 1},
  [389] = {.lex_state = 92, .external_lex_state = 1},
  [390] = {.lex_state = 6, .external_lex_state = 1},
  [391] = {.lex_state = 4, .external_lex_state = 1},
  [392] = {.lex_state = 93, .external_lex_state = 1},
  [393] = {.lex_state = 6, .external_lex_state = 1},
  [394] = {.lex_state = 93, .external_lex_state = 1},
  [395] = {.lex_state = 93, .external_lex_state = 1},
  [396] = {.lex_state = 92, .external_lex_state = 1},
  [397] = {.lex_state = 92, .external_lex_state = 1},
  [398] = {.lex_state = 94, .external_lex_state = 1},
  [399] = {.lex_state = 8, .external_lex_state = 1},
  [400] = {.lex_state = 9, .external_lex_state = 1},
  [401] = {.lex_state = 5, .external_lex_state = 1},
  [402] = {.lex_state = 6, .external_lex_state = 1},
  [403] = {.lex_state = 92, .external_lex_state = 1},
  [404] = {.lex_state = 93, .external_lex_state = 1},
  [405] = {.lex_state = 6, .external_lex_state = 1},
  [406] = {.lex_state = 6, .external_lex_state = 1},
  [407] = {.lex_state = 6, .external_lex_state = 1},
  [408] = {.lex_state = 6, .external_lex_state = 1},
  [409] = {.lex_state = 6, .external_lex_state = 1},
  [410] = {.lex_state = 6, .external_lex_state = 1},
  [411] = {.lex_state = 6, .external_lex_state = 1},
  [412] = {.lex_state = 6, .external_lex_state = 1},
  [413] = {.lex_state = 6, .external_lex_state = 1},
  [414] = {.lex_state = 6, .external_lex_state = 1},
  [415] = {.lex_state = 6, .external_lex_state = 1},
  [416] = {.lex_state = 6, .external_lex_state = 1},
  [417] = {.lex_state = 94, .external_lex_state = 2},
  [418] = {.lex_state = 6, .external_lex_state = 1},
  [419] = {.lex_state = 6, .external_lex_state = 1},
  [420] = {.lex_state = 6, .external_lex_state = 1},
  [421] = {.lex_state = 6, .external_lex_state = 1},
  [422] = {.lex_state = 6, .external_lex_state = 1},
  [423] = {.lex_state = 6, .external_lex_state = 1},
  [424] = {.lex_state = 6, .external_lex_state = 1},
  [425] = {.lex_state = 93, .external_lex_state = 1},
  [426] = {.lex_state = 93, .external_lex_state = 1},
  [427] = {.lex_state = 93, .external_lex_state = 1},
  [428] = {.lex_state = 6, .external_lex_state = 1},
  [429] = {.lex_state = 93, .external_lex_state = 1},
  [430] = {.lex_state = 93, .external_lex_state = 1},
  [431] = {.lex_state = 93, .external_lex_state = 1},
  [432] = {.lex_state = 5, .external_lex_state = 1},
  [433] = {.lex_state = 93, .external_lex_state = 1},
  [434] = {.lex_state = 94, .external_lex_state = 2},
  [435] = {.lex_state = 93, .external_lex_state = 1},
  [436] = {.lex_state = 93, .external_lex_state = 1},
  [437] = {.lex_state = 6, .external_lex_state = 1},
  [438] = {.lex_state = 6, .external_lex_state = 1},
  [439] = {.lex_state = 93, .external_lex_state = 1},
  [440] = {.lex_state = 93, .external_lex_state = 1},
  [441] = {.lex_state = 6, .external_lex_state = 1},
  [442] = {.lex_state = 93, .external_lex_state = 1},
  [443] = {.lex_state = 5, .external_lex_state = 1},
  [444] = {.lex_state = 5, .external_lex_state = 1},
  [445] = {.lex_state = 5, .external_lex_state = 1},
  [446] = {.lex_state = 6, .external_lex_state = 1},
  [447] = {.lex_state = 5, .external_lex_state = 1},
  [448] = {.lex_state = 5, .external_lex_state = 1},
  [449] = {.lex_state = 5, .external_lex_state = 1},
  [450] = {.lex_state = 5, .external_lex_state = 1},
  [451] = {.lex_state = 5, .external_lex_state = 1},
  [452] = {.lex_state = 5, .external_lex_state = 1},
  [453] = {.lex_state = 5, .external_lex_state = 1},
  [454] = {.lex_state = 5, .external_lex_state = 1},
  [455] = {.lex_state = 5, .external_lex_state = 1},
  [456] = {.lex_state = 5, .external_lex_state = 1},
  [457] = {.lex_state = 5, .external_lex_state = 1},
  [458] = {.lex_state = 5, .external_lex_state = 1},
  [459] = {.lex_state = 5, .external_lex_state = 1},
  [460] = {.lex_state = 5, .external_lex_state = 1},
  [461] = {.lex_state = 93, .external_lex_state = 1},
  [462] = {.lex_state = 5, .external_lex_state = 1},
  [463] = {.lex_state = 5, .external_lex_state = 1},
  [464] = {.lex_state = 93, .external_lex_state = 1},
  [465] = {.lex_state = 5, .external_lex_state = 1},
  [466] = {.lex_state = 93, .external_lex_state = 1},
  [467] = {.lex_state = 93, .external_lex_state = 1},
  [468] = {.lex_state = 5, .external_lex_state = 1},
  [469] = {.lex_state = 5, .external_lex_state = 1},
  [470] = {.lex_state = 5, .external_lex_state = 1},
  [471] = {.lex_state = 5, .external_lex_state = 1},
  [472] = {.lex_state = 5, .external_lex_state = 1},
  [473] = {.lex_state = 93, .external_lex_state = 1},
  [474] = {.lex_state = 5, .external_lex_state = 1},
  [475] = {.lex_state = 5, .external_lex_state = 1},
  [476] = {.lex_state = 93, .external_lex_state = 1},
  [477] = {.lex_state = 93, .external_lex_state = 1},
  [478] = {.lex_state = 93, .external_lex_state = 1},
  [479] = {.lex_state = 93, .external_lex_state = 1},
  [480] = {.lex_state = 5, .external_lex_state = 1},
  [481] = {.lex_state = 93, .external_lex_state = 1},
  [482] = {.lex_state = 92, .external_lex_state = 1},
  [483] = {.lex_state = 93, .external_lex_state = 1},
  [484] = {.lex_state = 92, .external_lex_state = 1},
  [485] = {.lex_state = 92, .external_lex_state = 1},
  [486] = {.lex_state = 92, .external_lex_state = 1},
  [487] = {.lex_state = 92, .external_lex_state = 1},
  [488] = {.lex_state = 92, .external_lex_state = 1},
  [489] = {.lex_state = 92, .external_lex_state = 1},
  [490] = {.lex_state = 92, .external_lex_state = 1},
  [491] = {.lex_state = 92, .external_lex_state = 1},
  [492] = {.lex_state = 92, .external_lex_state = 1},
  [493] = {.lex_state = 92, .external_lex_state = 1},
  [494] = {.lex_state = 92, .external_lex_state = 1},
  [495] = {.lex_state = 92, .external_lex_state = 1},
  [496] = {.lex_state = 92, .external_lex_state = 1},
  [497] = {.lex_state = 92, .external_lex_state = 1},
  [498] = {.lex_state = 92, .external_lex_state = 1},
  [499] = {.lex_state = 92, .external_lex_state = 1},
  [500] = {.lex_state = 92, .external_lex_state = 1},
  [501] = {.lex_state = 92, .external_lex_state = 1},
  [502] = {.lex_state = 92, .external_lex_state = 1},
  [503] = {.lex_state = 92, .external_lex_state = 1},
  [504] = {.lex_state = 92, .external_lex_state = 1},
  [505] = {.lex_state = 92, .external_lex_state = 1},
  [506] = {.lex_state = 92, .external_lex_state = 1},
  [507] = {.lex_state = 92, .external_lex_state = 1},
  [508] = {.lex_state = 92, .external_lex_state = 1},
  [509] = {.lex_state = 92, .external_lex_state = 1},
  [510] = {.lex_state = 92, .external_lex_state = 1},
  [511] = {.lex_state = 92, .external_lex_state = 1},
  [512] = {.lex_state = 92, .external_lex_state = 1},
  [513] = {.lex_state = 92, .external_lex_state = 1},
  [514] = {.lex_state = 92, .external_lex_state = 1},
  [515] = {.lex_state = 92, .external_lex_state = 1},
  [516] = {.lex_state = 92, .external_lex_state = 1},
  [517] = {.lex_state = 92, .external_lex_state = 1},
  [518] = {.lex_state = 92, .external_lex_state = 1},
  [519] = {.lex_state = 92, .external_lex_state = 1},
  [520] = {.lex_state = 92, .external_lex_state = 1},
  [521] = {.lex_state = 92, .external_lex_state = 1},
  [522] = {.lex_state = 92, .external_lex_state = 1},
  [523] = {.lex_state = 92, .external_lex_state = 1},
  [524] = {.lex_state = 92, .external_lex_state = 1},
  [525] = {.lex_state = 92, .external_lex_state = 1},
  [526] = {.lex_state = 92, .external_lex_state = 1},
  [527] = {.lex_state = 92, .external_lex_state = 1},
  [528] = {.lex_state = 92, .external_lex_state = 1},
  [529] = {.lex_state = 92, .external_lex_state = 1},
  [530] = {.lex_state = 92, .external_lex_state = 1},
  [531] = {.lex_state = 92, .external_lex_state = 1},
  [532] = {.lex_state = 92, .external_lex_state = 1},
  [533] = {.lex_state = 92, .external_lex_state = 1},
  [534] = {.lex_state = 92, .external_lex_state = 1},
  [535] = {.lex_state = 92, .external_lex_state = 1},
  [536] = {.lex_state = 92, .external_lex_state = 1},
  [537] = {.lex_state = 92, .external_lex_state = 1},
  [538] = {.lex_state = 92, .external_lex_state = 1},
  [539] = {.lex_state = 92, .external_lex_state = 1},
  [540] = {.lex_state = 92, .external_lex_state = 1},
  [541] = {.lex_state = 92, .external_lex_state = 1},
  [542] = {.lex_state = 92, .external_lex_state = 1},
  [543] = {.lex_state = 92, .external_lex_state = 1},
  [544] = {.lex_state = 92, .external_lex_state = 1},
  [545] = {.lex_state = 92, .external_lex_state = 1},
  [546] = {.lex_state = 92, .external_lex_state = 1},
  [547] = {.lex_state = 92, .external_lex_state = 1},
  [548] = {.lex_state = 92, .external_lex_state = 1},
  [549] = {.lex_state = 92, .external_lex_state = 1},
  [550] = {.lex_state = 92, .external_lex_state = 1},
  [551] = {.lex_state = 92, .external_lex_state = 1},
  [552] = {.lex_state = 92, .external_lex_state = 1},
  [553] = {.lex_state = 92, .external_lex_state = 1},
  [554] = {.lex_state = 92, .external_lex_state = 1},
  [555] = {.lex_state = 92, .external_lex_state = 1},
  [556] = {.lex_state = 92, .external_lex_state = 1},
  [557] = {.lex_state = 92, .external_lex_state = 1},
  [558] = {.lex_state = 92, .external_lex_state = 1},
  [559] = {.lex_state = 92, .external_lex_state = 1},
  [560] = {.lex_state = 92, .external_lex_state = 1},
  [561] = {.lex_state = 92, .external_lex_state = 1},
  [562] = {.lex_state = 92, .external_lex_state = 1},
  [563] = {.lex_state = 92, .external_lex_state = 1},
  [564] = {.lex_state = 92, .external_lex_state = 1},
  [565] = {.lex_state = 92, .external_lex_state = 1},
  [566] = {.lex_state = 92, .external_lex_state = 1},
  [567] = {.lex_state = 92, .external_lex_state = 1},
  [568] = {.lex_state = 92, .external_lex_state = 1},
  [569] = {.lex_state = 92, .external_lex_state = 1},
  [570] = {.lex_state = 92, .external_lex_state = 1},
  [571] = {.lex_state = 92, .external_lex_state = 1},
  [572] = {.lex_state = 92, .external_lex_state = 1},
  [573] = {.lex_state = 92, .external_lex_state = 1},
  [574] = {.lex_state = 92, .external_lex_state = 1},
  [575] = {.lex_state = 92, .external_lex_state = 1},
  [576] = {.lex_state = 92, .external_lex_state = 1},
  [577] = {.lex_state = 92, .external_lex_state = 1},
  [578] = {.lex_state = 92, .external_lex_state = 1},
  [579] = {.lex_state = 92, .external_lex_state = 1},
  [580] = {.lex_state = 92, .external_lex_state = 1},
  [581] = {.lex_state = 92, .external_lex_state = 1},
  [582] = {.lex_state = 92, .external_lex_state = 1},
  [583] = {.lex_state = 92, .external_lex_state = 1},
  [584] = {.lex_state = 92, .external_lex_state = 1},
  [585] = {.lex_state = 92, .external_lex_state = 1},
  [586] = {.lex_state = 92, .external_lex_state = 1},
  [587] = {.lex_state = 92, .external_lex_state = 1},
  [588] = {.lex_state = 92, .external_lex_state = 1},
  [589] = {.lex_state = 92, .external_lex_state = 1},
  [590] = {.lex_state = 92, .external_lex_state = 1},
  [591] = {.lex_state = 92, .external_lex_state = 1},
  [592] = {.lex_state = 92, .external_lex_state = 1},
  [593] = {.lex_state = 92, .external_lex_state = 1},
  [594] = {.lex_state = 92, .external_lex_state = 1},
  [595] = {.lex_state = 92, .external_lex_state = 1},
  [596] = {.lex_state = 92, .external_lex_state = 1},
  [597] = {.lex_state = 92, .external_lex_state = 1},
  [598] = {.lex_state = 92, .external_lex_state = 1},
  [599] = {.lex_state = 92, .external_lex_state = 1},
  [600] = {.lex_state = 92, .external_lex_state = 1},
  [601] = {.lex_state = 92, .external_lex_state = 1},
  [602] = {.lex_state = 92, .external_lex_state = 1},
  [603] = {.lex_state = 92, .external_lex_state = 1},
  [604] = {.lex_state = 92, .external_lex_state = 1},
  [605] = {.lex_state = 92, .external_lex_state = 1},
  [606] = {.lex_state = 92, .external_lex_state = 1},
  [607] = {.lex_state = 92, .external_lex_state = 1},
  [608] = {.lex_state = 92, .external_lex_state = 1},
  [609] = {.lex_state = 92, .external_lex_state = 1},
  [610] = {.lex_state = 92, .external_lex_state = 1},
  [611] = {.lex_state = 92, .external_lex_state = 1},
  [612] = {.lex_state = 92, .external_lex_state = 1},
  [613] = {.lex_state = 92, .external_lex_state = 1},
  [614] = {.lex_state = 92, .external_lex_state = 1},
  [615] = {.lex_state = 92, .external_lex_state = 1},
  [616] = {.lex_state = 92, .external_lex_state = 1},
  [617] = {.lex_state = 92, .external_lex_state = 1},
  [618] = {.lex_state = 92, .external_lex_state = 1},
  [619] = {.lex_state = 92, .external_lex_state = 1},
  [620] = {.lex_state = 92, .external_lex_state = 1},
  [621] = {.lex_state = 92, .external_lex_state = 1},
  [622] = {.lex_state = 92, .external_lex_state = 1},
  [623] = {.lex_state = 92, .external_lex_state = 1},
  [624] = {.lex_state = 92, .external_lex_state = 1},
  [625] = {.lex_state = 92, .external_lex_state = 1},
  [626] = {.lex_state = 92, .external_lex_state = 1},
  [627] = {.lex_state = 92, .external_lex_state = 1},
  [628] = {.lex_state = 92, .external_lex_state = 1},
  [629] = {.lex_state = 92, .external_lex_state = 1},
  [630] = {.lex_state = 92, .external_lex_state = 1},
  [631] = {.lex_state = 92, .external_lex_state = 1},
  [632] = {.lex_state = 92, .external_lex_state = 1},
  [633] = {.lex_state = 92, .external_lex_state = 1},
  [634] = {.lex_state = 92, .external_lex_state = 1},
  [635] = {.lex_state = 92, .external_lex_state = 1},
  [636] = {.lex_state = 92, .external_lex_state = 1},
  [637] = {.lex_state = 92, .external_lex_state = 1},
  [638] = {.lex_state = 92, .external_lex_state = 1},
  [639] = {.lex_state = 92, .external_lex_state = 1},
  [640] = {.lex_state = 92, .external_lex_state = 1},
  [641] = {.lex_state = 92, .external_lex_state = 1},
  [642] = {.lex_state = 92, .external_lex_state = 1},
  [643] = {.lex_state = 92, .external_lex_state = 1},
  [644] = {.lex_state = 92, .external_lex_state = 1},
  [645] = {.lex_state = 92, .external_lex_state = 1},
  [646] = {.lex_state = 92, .external_lex_state = 1},
  [647] = {.lex_state = 92, .external_lex_state = 1},
  [648] = {.lex_state = 92, .external_lex_state = 1},
  [649] = {.lex_state = 92, .external_lex_state = 1},
  [650] = {.lex_state = 92, .external_lex_state = 1},
  [651] = {.lex_state = 92, .external_lex_state = 1},
  [652] = {.lex_state = 92, .external_lex_state = 1},
  [653] = {.lex_state = 94, .external_lex_state = 2},
  [654] = {.lex_state = 94, .external_lex_state = 2},
  [655] = {.lex_state = 94, .external_lex_state = 2},
  [656] = {.lex_state = 94, .external_lex_state = 2},
  [657] = {.lex_state = 94, .external_lex_state = 2},
  [658] = {.lex_state = 94, .external_lex_state = 2},
  [659] = {.lex_state = 94, .external_lex_state = 2},
  [660] = {.lex_state = 94, .external_lex_state = 2},
  [661] = {.lex_state = 94, .external_lex_state = 2},
  [662] = {.lex_state = 94, .external_lex_state = 2},
  [663] = {.lex_state = 94, .external_lex_state = 2},
  [664] = {.lex_state = 94, .external_lex_state = 2},
  [665] = {.lex_state = 94, .external_lex_state = 2},
  [666] = {.lex_state = 94, .external_lex_state = 2},
  [667] = {.lex_state = 94, .external_lex_state = 2},
  [668] = {.lex_state = 94, .external_lex_state = 2},
  [669] = {.lex_state = 94, .external_lex_state = 2},
  [670] = {.lex_state = 94, .external_lex_state = 2},
  [671] = {.lex_state = 94, .external_lex_state = 2},
  [672] = {.lex_state = 94, .external_lex_state = 2},
  [673] = {.lex_state = 94, .external_lex_state = 2},
  [674] = {.lex_state = 94, .external_lex_state = 2},
  [675] = {.lex_state = 94, .external_lex_state = 2},
  [676] = {.lex_state = 94, .external_lex_state = 2},
  [677] = {.lex_state = 94, .external_lex_state = 2},
  [678] = {.lex_state = 94, .external_lex_state = 2},
  [679] = {.lex_state = 94, .external_lex_state = 2},
  [680] = {.lex_state = 94, .external_lex_state = 2},
  [681] = {.lex_state = 94, .external_lex_state = 2},
  [682] = {.lex_state = 94, .external_lex_state = 2},
  [683] = {.lex_state = 94, .external_lex_state = 2},
  [684] = {.lex_state = 94, .external_lex_state = 2},
  [685] = {.lex_state = 94, .external_lex_state = 2},
  [686] = {.lex_state = 0, .external_lex_state = 2},
  [687] = {.lex_state = 11, .external_lex_state = 2},
  [688] = {.lex_state = 0, .external_lex_state = 2},
  [689] = {.lex_state = 0, .external_lex_state = 1},
  [690] = {.lex_state = 0, .external_lex_state = 1},
  [691] = {.lex_state = 0, .external_lex_state = 2},
  [692] = {.lex_state = 10, .external_lex_state = 2},
  [693] = {.lex_state = 0, .external_lex_state = 2},
  [694] = {.lex_state = 0, .external_lex_state = 2},
  [695] = {.lex_state = 0, .external_lex_state = 2},
  [696] = {.lex_state = 0, .external_lex_state = 2},
  [697] = {.lex_state = 0, .external_lex_state = 2},
  [698] = {.lex_state = 0, .external_lex_state = 2},
  [699] = {.lex_state = 0, .external_lex_state = 2},
  [700] = {.lex_state = 10, .external_lex_state = 2},
  [701] = {.lex_state = 0, .external_lex_state = 2},
  [702] = {.lex_state = 0, .external_lex_state = 2},
  [703] = {.lex_state = 10, .external_lex_state = 2},
  [704] = {.lex_state = 0, .external_lex_state = 2},
  [705] = {.lex_state = 0, .external_lex_state = 2},
  [706] = {.lex_state = 0, .external_lex_state = 2},
  [707] = {.lex_state = 10, .external_lex_state = 2},
  [708] = {.lex_state = 0, .external_lex_state = 2},
  [709] = {.lex_state = 0, .external_lex_state = 2},
  [710] = {.lex_state = 0, .external_lex_state = 2},
  [711] = {.lex_state = 0, .external_lex_state = 2},
  [712] = {.lex_state = 0, .external_lex_state = 2},
  [713] = {.lex_state = 0, .external_lex_state = 2},
  [714] = {.lex_state = 0, .external_lex_state = 2},
  [715] = {.lex_state = 0, .external_lex_state = 1},
  [716] = {.lex_state = 0, .external_lex_state = 2},
  [717] = {.lex_state = 0, .external_lex_state = 2},
  [718] = {.lex_state = 0, .external_lex_state = 1},
  [719] = {.lex_state = 0, .external_lex_state = 2},
  [720] = {.lex_state = 0, .external_lex_state = 2},
  [721] = {.lex_state = 0, .external_lex_state = 2},
  [722] = {.lex_state = 0, .external_lex_state = 2},
  [723] = {.lex_state = 0, .external_lex_state = 2},
  [724] = {.lex_state = 0, .external_lex_state = 1},
  [725] = {.lex_state = 0, .external_lex_state = 1},
  [726] = {.lex_state = 0, .external_lex_state = 1},
  [727] = {.lex_state = 0, .external_lex_state = 2},
  [728] = {.lex_state = 0, .external_lex_state = 2},
  [729] = {.lex_state = 0, .external_lex_state = 2},
  [730] = {.lex_state = 12, .external_lex_state = 2},
  [731] = {.lex_state = 0, .external_lex_state = 2},
  [732] = {.lex_state = 0, .external_lex_state = 2},
  [733] = {.lex_state = 0, .external_lex_state = 2},
  [734] = {.lex_state = 0, .external_lex_state = 2},
  [735] = {.lex_state = 10, .external_lex_state = 2},
  [736] = {.lex_state = 10, .external_lex_state = 2},
  [737] = {.lex_state = 0, .external_lex_state = 2},
  [738] = {.lex_state = 10, .external_lex_state = 2},
  [739] = {.lex_state = 0, .external_lex_state = 2},
  [740] = {.lex_state = 0, .external_lex_state = 2},
  [741] = {.lex_state = 45, .external_lex_state = 2},
  [742] = {.lex_state = 0, .external_lex_state = 2},
  [743] = {.lex_state = 0, .external_lex_state = 2},
  [744] = {.lex_state = 45, .external_lex_state = 2},
  [745] = {.lex_state = 0, .external_lex_state = 2},
  [746] = {.lex_state = 0, .external_lex_state = 2},
  [747] = {.lex_state = 0, .external_lex_state = 2},
  [748] = {.lex_state = 0, .external_lex_state = 2},
  [749] = {.lex_state = 10, .external_lex_state = 2},
  [750] = {.lex_state = 0, .external_lex_state = 2},
  [751] = {.lex_state = 0, .external_lex_state = 2},
  [752] = {.lex_state = 0, .external_lex_state = 2},
  [753] = {.lex_state = 0, .external_lex_state = 2},
  [754] = {.lex_state = 0, .external_lex_state = 2},
  [755] = {.lex_state = 0, .external_lex_state = 2},
  [756] = {.lex_state = 0, .external_lex_state = 2},
  [757] = {.lex_state = 0, .external_lex_state = 2},
  [758] = {.lex_state = 0, .external_lex_state = 2},
  [759] = {.lex_state = 0, .external_lex_state = 2},
  [760] = {.lex_state = 0, .external_lex_state = 2},
  [761] = {.lex_state = 45, .external_lex_state = 2},
  [762] = {.lex_state = 0, .external_lex_state = 2},
  [763] = {.lex_state = 0, .external_lex_state = 2},
  [764] = {.lex_state = 0, .external_lex_state = 2},
  [765] = {.lex_state = 0, .external_lex_state = 2},
  [766] = {.lex_state = 0, .external_lex_state = 2},
  [767] = {.lex_state = 0, .external_lex_state = 2},
  [768] = {.lex_state = 45, .external_lex_state = 2},
  [769] = {.lex_state = 0, .external_lex_state = 2},
  [770] = {.lex_state = 0, .external_lex_state = 2},
  [771] = {.lex_state = 0, .external_lex_state = 2},
  [772] = {.lex_state = 0, .external_lex_state = 2},
  [773] = {.lex_state = 0, .external_lex_state = 2},
  [774] = {.lex_state = 0, .external_lex_state = 2},
  [775] = {.lex_state = 10, .external_lex_state = 2},
  [776] = {.lex_state = 10, .external_lex_state = 2},
  [777] = {.lex_state = 0, .external_lex_state = 2},
  [778] = {.lex_state = 10, .external_lex_state = 2},
  [779] = {.lex_state = 0, .external_lex_state = 2},
  [780] = {.lex_state = 0, .external_lex_state = 2},
  [781] = {.lex_state = 0, .external_lex_state = 2},
  [782] = {.lex_state = 0, .external_lex_state = 2},
  [783] = {.lex_state = 0, .external_lex_state = 2},
  [784] = {.lex_state = 0, .external_lex_state = 2},
  [785] = {.lex_state = 0, .external_lex_state = 2},
  [786] = {.lex_state = 0, .external_lex_state = 2},
  [787] = {.lex_state = 0, .external_lex_state = 2},
  [788] = {.lex_state = 0, .external_lex_state = 2},
  [789] = {.lex_state = 0, .external_lex_state = 2},
  [790] = {.lex_state = 0, .external_lex_state = 2},
  [791] = {.lex_state = 0, .external_lex_state = 2},
  [792] = {.lex_state = 0, .external_lex_state = 2},
  [793] = {.lex_state = 0, .external_lex_state = 2},
  [794] = {.lex_state = 0, .external_lex_state = 2},
  [795] = {.lex_state = 10, .external_lex_state = 2},
  [796] = {.lex_state = 0, .external_lex_state = 2},
  [797] = {.lex_state = 0, .external_lex_state = 2},
  [798] = {.lex_state = 0, .external_lex_state = 2},
  [799] = {.lex_state = 0, .external_lex_state = 2},
  [800] = {.lex_state = 0, .external_lex_state = 2},
  [801] = {.lex_state = 0, .external_lex_state = 2},
  [802] = {.lex_state = 0, .external_lex_state = 2},
  [803] = {.lex_state = 0, .external_lex_state = 2},
  [804] = {.lex_state = 0, .external_lex_state = 2},
  [805] = {.lex_state = 10, .external_lex_state = 2},
  [806] = {.lex_state = 10, .external_lex_state = 2},
  [807] = {.lex_state = 0, .external_lex_state = 2},
  [808] = {.lex_state = 10, .external_lex_state = 2},
  [809] = {.lex_state = 0, .external_lex_state = 2},
  [810] = {.lex_state = 0, .external_lex_state = 2},
  [811] = {.lex_state = 0, .external_lex_state = 2},
  [812] = {.lex_state = 0, .external_lex_state = 2},
  [813] = {.lex_state = 0, .external_lex_state = 2},
  [814] = {.lex_state = 0, .external_lex_state = 2},
  [815] = {.lex_state = 0, .external_lex_state = 2},
  [816] = {.lex_state = 10, .external_lex_state = 2},
  [817] = {.lex_state = 0, .external_lex_state = 2},
  [818] = {.lex_state = 10, .external_lex_state = 2},
  [819] = {.lex_state = 0, .external_lex_state = 2},
  [820] = {.lex_state = 0, .external_lex_state = 2},
  [821] = {.lex_state = 0, .external_lex_state = 2},
  [822] = {.lex_state = 0, .external_lex_state = 2},
  [823] = {.lex_state = 0, .external_lex_state = 2},
  [824] = {.lex_state = 0, .external_lex_state = 2},
  [825] = {.lex_state = 10, .external_lex_state = 2},
  [826] = {.lex_state = 0, .external_lex_state = 2},
  [827] = {.lex_state = 0, .external_lex_state = 2},
  [828] = {.lex_state = 0, .external_lex_state = 2},
  [829] = {.lex_state = 0, .external_lex_state = 2},
  [830] = {.lex_state = 0, .external_lex_state = 2},
  [831] = {.lex_state = 0, .external_lex_state = 2},
  [832] = {.lex_state = 10, .external_lex_state = 2},
  [833] = {.lex_state = 0, .external_lex_state = 2},
  [834] = {.lex_state = 0, .external_lex_state = 2},
  [835] = {.lex_state = 0, .external_lex_state = 2},
  [836] = {.lex_state = 0, .external_lex_state = 2},
  [837] = {.lex_state = 0, .external_lex_state = 2},
  [838] = {.lex_state = 0, .external_lex_state = 2},
  [839] = {.lex_state = 10, .external_lex_state = 2},
  [840] = {.lex_state = 0, .external_lex_state = 2},
  [841] = {.lex_state = 0, .external_lex_state = 2},
  [842] = {.lex_state = 0, .external_lex_state = 2},
  [843] = {.lex_state = 0, .external_lex_state = 2},
  [844] = {.lex_state = 10, .external_lex_state = 2},
  [845] = {.lex_state = 10, .external_lex_state = 2},
  [846] = {.lex_state = 10, .external_lex_state = 2},
  [847] = {.lex_state = 10, .external_lex_state = 2},
  [848] = {.lex_state = 0, .external_lex_state = 2},
  [849] = {.lex_state = 0, .external_lex_state = 2},
  [850] = {.lex_state = 0, .external_lex_state = 2},
  [851] = {.lex_state = 0, .external_lex_state = 2},
  [852] = {.lex_state = 0, .external_lex_state = 2},
  [853] = {.lex_state = 10, .external_lex_state = 2},
  [854] = {.lex_state = 0, .external_lex_state = 2},
  [855] = {.lex_state = 10, .external_lex_state = 2},
  [856] = {.lex_state = 0, .external_lex_state = 2},
  [857] = {.lex_state = 0, .external_lex_state = 2},
  [858] = {.lex_state = 0, .external_lex_state = 2},
  [859] = {.lex_state = 0, .external_lex_state = 2},
  [860] = {.lex_state = 0, .external_lex_state = 2},
  [861] = {.lex_state = 0, .external_lex_state = 2},
  [862] = {.lex_state = 10, .external_lex_state = 2},
  [863] = {.lex_state = 0, .external_lex_state = 2},
  [864] = {.lex_state = 10, .external_lex_state = 2},
  [865] = {.lex_state = 0, .external_lex_state = 2},
  [866] = {.lex_state = 0, .external_lex_state = 2},
  [867] = {.lex_state = 0, .external_lex_state = 2},
  [868] = {.lex_state = 0, .external_lex_state = 2},
  [869] = {.lex_state = 0, .external_lex_state = 2},
  [870] = {.lex_state = 0, .external_lex_state = 2},
  [871] = {.lex_state = 0, .external_lex_state = 2},
  [872] = {.lex_state = 10, .external_lex_state = 2},
  [873] = {.lex_state = 0, .external_lex_state = 2},
  [874] = {.lex_state = 10, .external_lex_state = 2},
  [875] = {.lex_state = 0, .external_lex_state = 2},
  [876] = {.lex_state = 10, .external_lex_state = 2},
  [877] = {.lex_state = 0, .external_lex_state = 2},
  [878] = {.lex_state = 0, .external_lex_state = 2},
  [879] = {.lex_state = 0, .external_lex_state = 2},
  [880] = {.lex_state = 10, .external_lex_state = 2},
  [881] = {.lex_state = 0, .external_lex_state = 2},
  [882] = {.lex_state = 10, .external_lex_state = 2},
  [883] = {.lex_state = 0, .external_lex_state = 2},
  [884] = {.lex_state = 0, .external_lex_state = 2},
  [885] = {.lex_state = 0, .external_lex_state = 2},
  [886] = {.lex_state = 0, .external_lex_state = 2},
  [887] = {.lex_state = 0, .external_lex_state = 2},
  [888] = {.lex_state = 10, .external_lex_state = 2},
  [889] = {.lex_state = 0, .external_lex_state = 2},
  [890] = {.lex_state = 10, .external_lex_state = 2},
  [891] = {.lex_state = 10, .external_lex_state = 2},
  [892] = {.lex_state = 10, .external_lex_state = 2},
  [893] = {.lex_state = 0, .external_lex_state = 2},
  [894] = {.lex_state = 0, .external_lex_state = 2},
  [895] = {.lex_state = 0, .external_lex_state = 2},
  [896] = {.lex_state = 0, .external_lex_state = 2},
  [897] = {.lex_state = 0, .external_lex_state = 2},
  [898] = {.lex_state = 0, .external_lex_state = 2},
  [899] = {.lex_state = 10, .external_lex_state = 2},
  [900] = {.lex_state = 0, .external_lex_state = 2},
  [901] = {.lex_state = 0, .external_lex_state = 2},
  [902] = {.lex_state = 0, .external_lex_state = 2},
  [903] = {.lex_state = 0, .external_lex_state = 2},
  [904] = {.lex_state = 10, .external_lex_state = 2},
  [905] = {.lex_state = 0, .external_lex_state = 2},
  [906] = {.lex_state = 0, .external_lex_state = 2},
};

enum {
  ts_external_token_comment = 0,
  ts_external_token_string = 1,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_string] = sym_string,
};

static bool ts_external_scanner_states[3][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_comment] = true,
    [ts_external_token_string] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_spread] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [anon_sym__G] = ACTIONS(1),
    [anon_sym__VERSION] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(854),
    [sym_return_statement] = STATE(849),
    [sym_variable_declaration] = STATE(31),
    [sym_local_variable_declaration] = STATE(31),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(99),
    [sym_do_statement] = STATE(31),
    [sym_if_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_repeat_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_for_in_statement] = STATE(31),
    [sym_goto_statement] = STATE(31),
    [sym_label_statement] = STATE(31),
    [sym__empty_statement] = STATE(31),
    [sym_function_statement] = STATE(31),
    [sym_local_function_statement] = STATE(31),
    [sym_function_call_statement] = STATE(151),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(244),
    [sym_table] = STATE(244),
    [sym_binary_operation] = STATE(244),
    [sym_unary_operation] = STATE(244),
    [aux_sym_program_repeat1] = STATE(31),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_return] = ACTIONS(7),
    [anon_sym_local] = ACTIONS(9),
    [anon_sym_do] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_goto] = ACTIONS(21),
    [sym_break_statement] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(27),
    [anon_sym_function] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(31),
    [sym_spread] = ACTIONS(33),
    [sym_self] = ACTIONS(35),
    [sym_next] = ACTIONS(37),
    [anon_sym__G] = ACTIONS(39),
    [anon_sym__VERSION] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_not] = ACTIONS(45),
    [anon_sym_POUND] = ACTIONS(43),
    [sym_number] = ACTIONS(33),
    [sym_nil] = ACTIONS(37),
    [sym_true] = ACTIONS(37),
    [sym_false] = ACTIONS(37),
    [sym_identifier] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(33),
  },
  [2] = {
    [sym_return_statement] = STATE(694),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(698),
    [sym_else] = STATE(807),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(698),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [3] = {
    [sym_return_statement] = STATE(714),
    [sym_variable_declaration] = STATE(2),
    [sym_local_variable_declaration] = STATE(2),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_elseif] = STATE(712),
    [sym_else] = STATE(906),
    [sym_while_statement] = STATE(2),
    [sym_repeat_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_for_in_statement] = STATE(2),
    [sym_goto_statement] = STATE(2),
    [sym_label_statement] = STATE(2),
    [sym__empty_statement] = STATE(2),
    [sym_function_statement] = STATE(2),
    [sym_local_function_statement] = STATE(2),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(2),
    [aux_sym_if_statement_repeat1] = STATE(712),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(99),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [4] = {
    [sym_return_statement] = STATE(708),
    [sym_variable_declaration] = STATE(7),
    [sym_local_variable_declaration] = STATE(7),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_elseif] = STATE(695),
    [sym_else] = STATE(815),
    [sym_while_statement] = STATE(7),
    [sym_repeat_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_goto_statement] = STATE(7),
    [sym_label_statement] = STATE(7),
    [sym__empty_statement] = STATE(7),
    [sym_function_statement] = STATE(7),
    [sym_local_function_statement] = STATE(7),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_if_statement_repeat1] = STATE(695),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(105),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [5] = {
    [sym_return_statement] = STATE(709),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(693),
    [sym_else] = STATE(784),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(693),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [6] = {
    [sym_return_statement] = STATE(696),
    [sym_variable_declaration] = STATE(5),
    [sym_local_variable_declaration] = STATE(5),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_elseif] = STATE(691),
    [sym_else] = STATE(779),
    [sym_while_statement] = STATE(5),
    [sym_repeat_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_for_in_statement] = STATE(5),
    [sym_goto_statement] = STATE(5),
    [sym_label_statement] = STATE(5),
    [sym__empty_statement] = STATE(5),
    [sym_function_statement] = STATE(5),
    [sym_local_function_statement] = STATE(5),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_if_statement_repeat1] = STATE(691),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(113),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(115),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [7] = {
    [sym_return_statement] = STATE(706),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(705),
    [sym_else] = STATE(794),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(705),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(117),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [8] = {
    [sym_return_statement] = STATE(699),
    [sym_variable_declaration] = STATE(9),
    [sym_local_variable_declaration] = STATE(9),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_elseif] = STATE(701),
    [sym_else] = STATE(819),
    [sym_while_statement] = STATE(9),
    [sym_repeat_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_goto_statement] = STATE(9),
    [sym_label_statement] = STATE(9),
    [sym__empty_statement] = STATE(9),
    [sym_function_statement] = STATE(9),
    [sym_local_function_statement] = STATE(9),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_if_statement_repeat1] = STATE(701),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(121),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(123),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [9] = {
    [sym_return_statement] = STATE(713),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_elseif] = STATE(710),
    [sym_else] = STATE(830),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_if_statement_repeat1] = STATE(710),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(59),
    [anon_sym_else] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [10] = {
    [sym_return_statement] = STATE(737),
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(127),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(127),
    [anon_sym_else] = ACTIONS(127),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [11] = {
    [sym_return_statement] = STATE(739),
    [sym_variable_declaration] = STATE(10),
    [sym_local_variable_declaration] = STATE(10),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_repeat_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_for_in_statement] = STATE(10),
    [sym_goto_statement] = STATE(10),
    [sym_label_statement] = STATE(10),
    [sym__empty_statement] = STATE(10),
    [sym_function_statement] = STATE(10),
    [sym_local_function_statement] = STATE(10),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(10),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(51),
    [anon_sym_do] = ACTIONS(53),
    [anon_sym_end] = ACTIONS(129),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_elseif] = ACTIONS(129),
    [anon_sym_else] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_repeat] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_goto] = ACTIONS(69),
    [sym_break_statement] = ACTIONS(131),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_SEMI] = ACTIONS(133),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(79),
    [sym_spread] = ACTIONS(81),
    [sym_self] = ACTIONS(83),
    [sym_next] = ACTIONS(85),
    [anon_sym__G] = ACTIONS(87),
    [anon_sym__VERSION] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_TILDE] = ACTIONS(91),
    [anon_sym_DASH] = ACTIONS(91),
    [anon_sym_not] = ACTIONS(93),
    [anon_sym_POUND] = ACTIONS(91),
    [sym_number] = ACTIONS(81),
    [sym_nil] = ACTIONS(85),
    [sym_true] = ACTIONS(85),
    [sym_false] = ACTIONS(85),
    [sym_identifier] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(81),
  },
  [12] = {
    [sym_arguments] = STATE(93),
    [sym_table] = STATE(96),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(139),
    [anon_sym_DOT] = ACTIONS(141),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_end] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_elseif] = ACTIONS(135),
    [anon_sym_else] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(137),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [sym_spread] = ACTIONS(137),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(148),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(137),
    [anon_sym_EQ_EQ] = ACTIONS(137),
    [anon_sym_TILDE_EQ] = ACTIONS(137),
    [anon_sym_GT_EQ] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(137),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_LT_LT] = ACTIONS(137),
    [anon_sym_GT_GT] = ACTIONS(137),
    [anon_sym_PLUS] = ACTIONS(137),
    [anon_sym_DASH] = ACTIONS(137),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(137),
    [anon_sym_PERCENT] = ACTIONS(137),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(137),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(137),
    [sym_number] = ACTIONS(137),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(151),
  },
  [13] = {
    [aux_sym_variable_declaration_repeat1] = STATE(769),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_COMMA] = ACTIONS(156),
    [anon_sym_EQ] = ACTIONS(158),
    [anon_sym_local] = ACTIONS(154),
    [anon_sym_LBRACK] = ACTIONS(160),
    [anon_sym_DOT] = ACTIONS(154),
    [anon_sym_do] = ACTIONS(154),
    [anon_sym_end] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_elseif] = ACTIONS(154),
    [anon_sym_else] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_repeat] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_goto] = ACTIONS(154),
    [sym_break_statement] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(160),
    [anon_sym_SEMI] = ACTIONS(160),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_COLON] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(160),
    [sym_spread] = ACTIONS(160),
    [sym_self] = ACTIONS(154),
    [sym_next] = ACTIONS(154),
    [anon_sym__G] = ACTIONS(154),
    [anon_sym__VERSION] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_LT_EQ] = ACTIONS(160),
    [anon_sym_EQ_EQ] = ACTIONS(160),
    [anon_sym_TILDE_EQ] = ACTIONS(160),
    [anon_sym_GT_EQ] = ACTIONS(160),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_PIPE] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(160),
    [anon_sym_LT_LT] = ACTIONS(160),
    [anon_sym_GT_GT] = ACTIONS(160),
    [anon_sym_PLUS] = ACTIONS(160),
    [anon_sym_DASH] = ACTIONS(160),
    [anon_sym_STAR] = ACTIONS(160),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_SLASH_SLASH] = ACTIONS(160),
    [anon_sym_PERCENT] = ACTIONS(160),
    [anon_sym_DOT_DOT] = ACTIONS(154),
    [anon_sym_CARET] = ACTIONS(160),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_POUND] = ACTIONS(160),
    [sym_number] = ACTIONS(160),
    [sym_nil] = ACTIONS(154),
    [sym_true] = ACTIONS(154),
    [sym_false] = ACTIONS(154),
    [sym_identifier] = ACTIONS(154),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(160),
  },
  [14] = {
    [anon_sym_return] = ACTIONS(162),
    [anon_sym_COMMA] = ACTIONS(164),
    [anon_sym_EQ] = ACTIONS(162),
    [anon_sym_local] = ACTIONS(162),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_DOT] = ACTIONS(162),
    [anon_sym_do] = ACTIONS(162),
    [anon_sym_end] = ACTIONS(162),
    [anon_sym_if] = ACTIONS(162),
    [anon_sym_elseif] = ACTIONS(162),
    [anon_sym_else] = ACTIONS(162),
    [anon_sym_while] = ACTIONS(162),
    [anon_sym_repeat] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(162),
    [anon_sym_goto] = ACTIONS(162),
    [sym_break_statement] = ACTIONS(162),
    [anon_sym_COLON_COLON] = ACTIONS(164),
    [anon_sym_SEMI] = ACTIONS(164),
    [anon_sym_function] = ACTIONS(162),
    [anon_sym_COLON] = ACTIONS(162),
    [anon_sym_LPAREN] = ACTIONS(164),
    [sym_spread] = ACTIONS(164),
    [sym_self] = ACTIONS(162),
    [sym_next] = ACTIONS(162),
    [anon_sym__G] = ACTIONS(162),
    [anon_sym__VERSION] = ACTIONS(162),
    [anon_sym_LBRACE] = ACTIONS(164),
    [anon_sym_or] = ACTIONS(162),
    [anon_sym_and] = ACTIONS(162),
    [anon_sym_LT] = ACTIONS(162),
    [anon_sym_LT_EQ] = ACTIONS(164),
    [anon_sym_EQ_EQ] = ACTIONS(164),
    [anon_sym_TILDE_EQ] = ACTIONS(164),
    [anon_sym_GT_EQ] = ACTIONS(164),
    [anon_sym_GT] = ACTIONS(162),
    [anon_sym_PIPE] = ACTIONS(164),
    [anon_sym_TILDE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_LT_LT] = ACTIONS(164),
    [anon_sym_GT_GT] = ACTIONS(164),
    [anon_sym_PLUS] = ACTIONS(164),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_STAR] = ACTIONS(164),
    [anon_sym_SLASH] = ACTIONS(162),
    [anon_sym_SLASH_SLASH] = ACTIONS(164),
    [anon_sym_PERCENT] = ACTIONS(164),
    [anon_sym_DOT_DOT] = ACTIONS(162),
    [anon_sym_CARET] = ACTIONS(164),
    [anon_sym_not] = ACTIONS(162),
    [anon_sym_POUND] = ACTIONS(164),
    [sym_number] = ACTIONS(164),
    [sym_nil] = ACTIONS(162),
    [sym_true] = ACTIONS(162),
    [sym_false] = ACTIONS(162),
    [sym_identifier] = ACTIONS(162),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(164),
  },
  [15] = {
    [anon_sym_return] = ACTIONS(166),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(166),
    [anon_sym_end] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(166),
    [anon_sym_elseif] = ACTIONS(166),
    [anon_sym_else] = ACTIONS(166),
    [anon_sym_while] = ACTIONS(166),
    [anon_sym_repeat] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(166),
    [anon_sym_goto] = ACTIONS(166),
    [sym_break_statement] = ACTIONS(166),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [anon_sym_SEMI] = ACTIONS(173),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(173),
    [sym_spread] = ACTIONS(173),
    [sym_self] = ACTIONS(166),
    [sym_next] = ACTIONS(166),
    [anon_sym__G] = ACTIONS(166),
    [anon_sym__VERSION] = ACTIONS(166),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_or] = ACTIONS(166),
    [anon_sym_and] = ACTIONS(166),
    [anon_sym_LT] = ACTIONS(166),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_TILDE_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(166),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_TILDE] = ACTIONS(166),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(166),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_PERCENT] = ACTIONS(173),
    [anon_sym_DOT_DOT] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_not] = ACTIONS(166),
    [anon_sym_POUND] = ACTIONS(173),
    [sym_number] = ACTIONS(173),
    [sym_nil] = ACTIONS(166),
    [sym_true] = ACTIONS(166),
    [sym_false] = ACTIONS(166),
    [sym_identifier] = ACTIONS(166),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(173),
  },
  [16] = {
    [sym_variable_declaration] = STATE(16),
    [sym_local_variable_declaration] = STATE(16),
    [sym__variable_declarator] = STATE(13),
    [sym_field_expression] = STATE(17),
    [sym_do_statement] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_repeat_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_goto_statement] = STATE(16),
    [sym_label_statement] = STATE(16),
    [sym__empty_statement] = STATE(16),
    [sym_function_statement] = STATE(16),
    [sym_local_function_statement] = STATE(16),
    [sym_function_call_statement] = STATE(98),
    [sym__expression] = STATE(178),
    [sym_global_variable] = STATE(12),
    [sym__prefix] = STATE(12),
    [sym_function_definition] = STATE(153),
    [sym_table] = STATE(153),
    [sym_binary_operation] = STATE(153),
    [sym_unary_operation] = STATE(153),
    [aux_sym_program_repeat1] = STATE(16),
    [anon_sym_return] = ACTIONS(176),
    [anon_sym_local] = ACTIONS(178),
    [anon_sym_do] = ACTIONS(181),
    [anon_sym_end] = ACTIONS(176),
    [anon_sym_if] = ACTIONS(184),
    [anon_sym_elseif] = ACTIONS(176),
    [anon_sym_else] = ACTIONS(176),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_repeat] = ACTIONS(190),
    [anon_sym_for] = ACTIONS(193),
    [anon_sym_goto] = ACTIONS(196),
    [sym_break_statement] = ACTIONS(199),
    [anon_sym_COLON_COLON] = ACTIONS(202),
    [anon_sym_SEMI] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(211),
    [sym_spread] = ACTIONS(214),
    [sym_self] = ACTIONS(217),
    [sym_next] = ACTIONS(220),
    [anon_sym__G] = ACTIONS(223),
    [anon_sym__VERSION] = ACTIONS(223),
    [anon_sym_LBRACE] = ACTIONS(226),
    [anon_sym_TILDE] = ACTIONS(229),
    [anon_sym_DASH] = ACTIONS(229),
    [anon_sym_not] = ACTIONS(232),
    [anon_sym_POUND] = ACTIONS(229),
    [sym_number] = ACTIONS(214),
    [sym_nil] = ACTIONS(220),
    [sym_true] = ACTIONS(220),
    [sym_false] = ACTIONS(220),
    [sym_identifier] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(214),
  },
  [17] = {
    [anon_sym_return] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_end] = ACTIONS(171),
    [anon_sym_if] = ACTIONS(171),
    [anon_sym_elseif] = ACTIONS(171),
    [anon_sym_else] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_goto] = ACTIONS(171),
    [sym_break_statement] = ACTIONS(171),
    [anon_sym_COLON_COLON] = ACTIONS(169),
    [anon_sym_SEMI] = ACTIONS(169),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(169),
    [sym_spread] = ACTIONS(169),
    [sym_self] = ACTIONS(171),
    [sym_next] = ACTIONS(171),
    [anon_sym__G] = ACTIONS(171),
    [anon_sym__VERSION] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(169),
    [anon_sym_or] = ACTIONS(171),
    [anon_sym_and] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(171),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_EQ] = ACTIONS(169),
    [anon_sym_TILDE_EQ] = ACTIONS(169),
    [anon_sym_GT_EQ] = ACTIONS(169),
    [anon_sym_GT] = ACTIONS(171),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_TILDE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(169),
    [anon_sym_LT_LT] = ACTIONS(169),
    [anon_sym_GT_GT] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_STAR] = ACTIONS(169),
    [anon_sym_SLASH] = ACTIONS(171),
    [anon_sym_SLASH_SLASH] = ACTIONS(169),
    [anon_sym_PERCENT] = ACTIONS(169),
    [anon_sym_DOT_DOT] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(169),
    [anon_sym_not] = ACTIONS(171),
    [anon_sym_POUND] = ACTIONS(169),
    [sym_number] = ACTIONS(169),
    [sym_nil] = ACTIONS(171),
    [sym_true] = ACTIONS(171),
    [sym_false] = ACTIONS(171),
    [sym_identifier] = ACTIONS(171),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(169),
  },
  [18] = {
    [anon_sym_return] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_local] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_do] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_elseif] = ACTIONS(238),
    [anon_sym_else] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(238),
    [anon_sym_repeat] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(238),
    [anon_sym_goto] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(240),
    [sym_spread] = ACTIONS(240),
    [sym_self] = ACTIONS(238),
    [sym_next] = ACTIONS(238),
    [anon_sym__G] = ACTIONS(238),
    [anon_sym__VERSION] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_TILDE_EQ] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_GT_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(240),
    [sym_number] = ACTIONS(240),
    [sym_nil] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_identifier] = ACTIONS(238),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(240),
  },
  [19] = {
    [sym_return_statement] = STATE(803),
    [sym_variable_declaration] = STATE(70),
    [sym_local_variable_declaration] = STATE(70),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(70),
    [sym_if_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_repeat_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_for_in_statement] = STATE(70),
    [sym_goto_statement] = STATE(70),
    [sym_label_statement] = STATE(70),
    [sym__empty_statement] = STATE(70),
    [sym_function_statement] = STATE(70),
    [sym_local_function_statement] = STATE(70),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(70),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(248),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(264),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [20] = {
    [sym_return_statement] = STATE(831),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(286),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [21] = {
    [sym_arguments] = STATE(135),
    [sym_table] = STATE(139),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(292),
    [anon_sym_DOT] = ACTIONS(294),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_until] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(137),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(298),
    [sym_spread] = ACTIONS(137),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(137),
    [anon_sym_EQ_EQ] = ACTIONS(137),
    [anon_sym_TILDE_EQ] = ACTIONS(137),
    [anon_sym_GT_EQ] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(137),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_LT_LT] = ACTIONS(137),
    [anon_sym_GT_GT] = ACTIONS(137),
    [anon_sym_PLUS] = ACTIONS(137),
    [anon_sym_DASH] = ACTIONS(137),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(137),
    [anon_sym_PERCENT] = ACTIONS(137),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(137),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(137),
    [sym_number] = ACTIONS(137),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(304),
  },
  [22] = {
    [aux_sym_variable_declaration_repeat1] = STATE(757),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_COMMA] = ACTIONS(156),
    [anon_sym_EQ] = ACTIONS(307),
    [anon_sym_local] = ACTIONS(154),
    [anon_sym_LBRACK] = ACTIONS(160),
    [anon_sym_DOT] = ACTIONS(154),
    [anon_sym_do] = ACTIONS(154),
    [anon_sym_end] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_repeat] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_goto] = ACTIONS(154),
    [sym_break_statement] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(160),
    [anon_sym_SEMI] = ACTIONS(160),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_COLON] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(160),
    [sym_spread] = ACTIONS(160),
    [sym_self] = ACTIONS(154),
    [sym_next] = ACTIONS(154),
    [anon_sym__G] = ACTIONS(154),
    [anon_sym__VERSION] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_LT_EQ] = ACTIONS(160),
    [anon_sym_EQ_EQ] = ACTIONS(160),
    [anon_sym_TILDE_EQ] = ACTIONS(160),
    [anon_sym_GT_EQ] = ACTIONS(160),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_PIPE] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(160),
    [anon_sym_LT_LT] = ACTIONS(160),
    [anon_sym_GT_GT] = ACTIONS(160),
    [anon_sym_PLUS] = ACTIONS(160),
    [anon_sym_DASH] = ACTIONS(160),
    [anon_sym_STAR] = ACTIONS(160),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_SLASH_SLASH] = ACTIONS(160),
    [anon_sym_PERCENT] = ACTIONS(160),
    [anon_sym_DOT_DOT] = ACTIONS(154),
    [anon_sym_CARET] = ACTIONS(160),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_POUND] = ACTIONS(160),
    [sym_number] = ACTIONS(160),
    [sym_nil] = ACTIONS(154),
    [sym_true] = ACTIONS(154),
    [sym_false] = ACTIONS(154),
    [sym_identifier] = ACTIONS(154),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(160),
  },
  [23] = {
    [anon_sym_return] = ACTIONS(309),
    [anon_sym_COMMA] = ACTIONS(311),
    [anon_sym_local] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_DOT] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(309),
    [anon_sym_end] = ACTIONS(309),
    [anon_sym_if] = ACTIONS(309),
    [anon_sym_elseif] = ACTIONS(309),
    [anon_sym_else] = ACTIONS(309),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_repeat] = ACTIONS(309),
    [anon_sym_for] = ACTIONS(309),
    [anon_sym_goto] = ACTIONS(309),
    [sym_break_statement] = ACTIONS(309),
    [anon_sym_COLON_COLON] = ACTIONS(311),
    [anon_sym_SEMI] = ACTIONS(311),
    [anon_sym_function] = ACTIONS(309),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(311),
    [sym_spread] = ACTIONS(311),
    [sym_self] = ACTIONS(309),
    [sym_next] = ACTIONS(309),
    [anon_sym__G] = ACTIONS(309),
    [anon_sym__VERSION] = ACTIONS(309),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_or] = ACTIONS(309),
    [anon_sym_and] = ACTIONS(309),
    [anon_sym_LT] = ACTIONS(309),
    [anon_sym_LT_EQ] = ACTIONS(311),
    [anon_sym_EQ_EQ] = ACTIONS(311),
    [anon_sym_TILDE_EQ] = ACTIONS(311),
    [anon_sym_GT_EQ] = ACTIONS(311),
    [anon_sym_GT] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_AMP] = ACTIONS(311),
    [anon_sym_LT_LT] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(311),
    [anon_sym_DASH] = ACTIONS(311),
    [anon_sym_STAR] = ACTIONS(311),
    [anon_sym_SLASH] = ACTIONS(309),
    [anon_sym_SLASH_SLASH] = ACTIONS(311),
    [anon_sym_PERCENT] = ACTIONS(311),
    [anon_sym_DOT_DOT] = ACTIONS(309),
    [anon_sym_CARET] = ACTIONS(311),
    [anon_sym_not] = ACTIONS(309),
    [anon_sym_POUND] = ACTIONS(311),
    [sym_number] = ACTIONS(311),
    [sym_nil] = ACTIONS(309),
    [sym_true] = ACTIONS(309),
    [sym_false] = ACTIONS(309),
    [sym_identifier] = ACTIONS(309),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(311),
  },
  [24] = {
    [sym_return_statement] = STATE(852),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(313),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [25] = {
    [sym_return_statement] = STATE(848),
    [sym_variable_declaration] = STATE(24),
    [sym_local_variable_declaration] = STATE(24),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_repeat_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_goto_statement] = STATE(24),
    [sym_label_statement] = STATE(24),
    [sym__empty_statement] = STATE(24),
    [sym_function_statement] = STATE(24),
    [sym_local_function_statement] = STATE(24),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(24),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(315),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [26] = {
    [aux_sym_variable_declaration_repeat1] = STATE(752),
    [ts_builtin_sym_end] = ACTIONS(160),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_COMMA] = ACTIONS(156),
    [anon_sym_EQ] = ACTIONS(321),
    [anon_sym_local] = ACTIONS(154),
    [anon_sym_LBRACK] = ACTIONS(160),
    [anon_sym_DOT] = ACTIONS(154),
    [anon_sym_do] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_repeat] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_goto] = ACTIONS(154),
    [sym_break_statement] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(160),
    [anon_sym_SEMI] = ACTIONS(160),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_COLON] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(160),
    [sym_spread] = ACTIONS(160),
    [sym_self] = ACTIONS(154),
    [sym_next] = ACTIONS(154),
    [anon_sym__G] = ACTIONS(154),
    [anon_sym__VERSION] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_LT_EQ] = ACTIONS(160),
    [anon_sym_EQ_EQ] = ACTIONS(160),
    [anon_sym_TILDE_EQ] = ACTIONS(160),
    [anon_sym_GT_EQ] = ACTIONS(160),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_PIPE] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(160),
    [anon_sym_LT_LT] = ACTIONS(160),
    [anon_sym_GT_GT] = ACTIONS(160),
    [anon_sym_PLUS] = ACTIONS(160),
    [anon_sym_DASH] = ACTIONS(160),
    [anon_sym_STAR] = ACTIONS(160),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_SLASH_SLASH] = ACTIONS(160),
    [anon_sym_PERCENT] = ACTIONS(160),
    [anon_sym_DOT_DOT] = ACTIONS(154),
    [anon_sym_CARET] = ACTIONS(160),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_POUND] = ACTIONS(160),
    [sym_number] = ACTIONS(160),
    [sym_nil] = ACTIONS(154),
    [sym_true] = ACTIONS(154),
    [sym_false] = ACTIONS(154),
    [sym_identifier] = ACTIONS(154),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(160),
  },
  [27] = {
    [sym_return_statement] = STATE(777),
    [sym_variable_declaration] = STATE(40),
    [sym_local_variable_declaration] = STATE(40),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(40),
    [sym_if_statement] = STATE(40),
    [sym_while_statement] = STATE(40),
    [sym_repeat_statement] = STATE(40),
    [sym_for_statement] = STATE(40),
    [sym_for_in_statement] = STATE(40),
    [sym_goto_statement] = STATE(40),
    [sym_label_statement] = STATE(40),
    [sym__empty_statement] = STATE(40),
    [sym_function_statement] = STATE(40),
    [sym_local_function_statement] = STATE(40),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(40),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(325),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(327),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [28] = {
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_COMMA] = ACTIONS(331),
    [anon_sym_local] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_DOT] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(329),
    [anon_sym_end] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(329),
    [anon_sym_elseif] = ACTIONS(329),
    [anon_sym_else] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_repeat] = ACTIONS(329),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_goto] = ACTIONS(329),
    [sym_break_statement] = ACTIONS(329),
    [anon_sym_COLON_COLON] = ACTIONS(331),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_function] = ACTIONS(329),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_LPAREN] = ACTIONS(331),
    [sym_spread] = ACTIONS(331),
    [sym_self] = ACTIONS(329),
    [sym_next] = ACTIONS(329),
    [anon_sym__G] = ACTIONS(329),
    [anon_sym__VERSION] = ACTIONS(329),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_or] = ACTIONS(329),
    [anon_sym_and] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(331),
    [anon_sym_TILDE_EQ] = ACTIONS(331),
    [anon_sym_GT_EQ] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_LT_LT] = ACTIONS(331),
    [anon_sym_GT_GT] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_SLASH_SLASH] = ACTIONS(331),
    [anon_sym_PERCENT] = ACTIONS(331),
    [anon_sym_DOT_DOT] = ACTIONS(329),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_not] = ACTIONS(329),
    [anon_sym_POUND] = ACTIONS(331),
    [sym_number] = ACTIONS(331),
    [sym_nil] = ACTIONS(329),
    [sym_true] = ACTIONS(329),
    [sym_false] = ACTIONS(329),
    [sym_identifier] = ACTIONS(329),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(331),
  },
  [29] = {
    [sym_return_statement] = STATE(881),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(333),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [30] = {
    [sym_arguments] = STATE(116),
    [sym_table] = STATE(117),
    [ts_builtin_sym_end] = ACTIONS(137),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(335),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(137),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [sym_spread] = ACTIONS(137),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(344),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(137),
    [anon_sym_EQ_EQ] = ACTIONS(137),
    [anon_sym_TILDE_EQ] = ACTIONS(137),
    [anon_sym_GT_EQ] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(137),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_LT_LT] = ACTIONS(137),
    [anon_sym_GT_GT] = ACTIONS(137),
    [anon_sym_PLUS] = ACTIONS(137),
    [anon_sym_DASH] = ACTIONS(137),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(137),
    [anon_sym_PERCENT] = ACTIONS(137),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(137),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(137),
    [sym_number] = ACTIONS(137),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(347),
  },
  [31] = {
    [sym_return_statement] = STATE(823),
    [sym_variable_declaration] = STATE(108),
    [sym_local_variable_declaration] = STATE(108),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(99),
    [sym_do_statement] = STATE(108),
    [sym_if_statement] = STATE(108),
    [sym_while_statement] = STATE(108),
    [sym_repeat_statement] = STATE(108),
    [sym_for_statement] = STATE(108),
    [sym_for_in_statement] = STATE(108),
    [sym_goto_statement] = STATE(108),
    [sym_label_statement] = STATE(108),
    [sym__empty_statement] = STATE(108),
    [sym_function_statement] = STATE(108),
    [sym_local_function_statement] = STATE(108),
    [sym_function_call_statement] = STATE(151),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(244),
    [sym_table] = STATE(244),
    [sym_binary_operation] = STATE(244),
    [sym_unary_operation] = STATE(244),
    [aux_sym_program_repeat1] = STATE(108),
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_return] = ACTIONS(7),
    [anon_sym_local] = ACTIONS(9),
    [anon_sym_do] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_repeat] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_goto] = ACTIONS(21),
    [sym_break_statement] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(354),
    [anon_sym_function] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(31),
    [sym_spread] = ACTIONS(33),
    [sym_self] = ACTIONS(35),
    [sym_next] = ACTIONS(37),
    [anon_sym__G] = ACTIONS(39),
    [anon_sym__VERSION] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_not] = ACTIONS(45),
    [anon_sym_POUND] = ACTIONS(43),
    [sym_number] = ACTIONS(33),
    [sym_nil] = ACTIONS(37),
    [sym_true] = ACTIONS(37),
    [sym_false] = ACTIONS(37),
    [sym_identifier] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(33),
  },
  [32] = {
    [anon_sym_return] = ACTIONS(356),
    [anon_sym_COMMA] = ACTIONS(358),
    [anon_sym_local] = ACTIONS(356),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_DOT] = ACTIONS(356),
    [anon_sym_do] = ACTIONS(356),
    [anon_sym_end] = ACTIONS(356),
    [anon_sym_if] = ACTIONS(356),
    [anon_sym_elseif] = ACTIONS(356),
    [anon_sym_else] = ACTIONS(356),
    [anon_sym_while] = ACTIONS(356),
    [anon_sym_repeat] = ACTIONS(356),
    [anon_sym_for] = ACTIONS(356),
    [anon_sym_goto] = ACTIONS(356),
    [sym_break_statement] = ACTIONS(356),
    [anon_sym_COLON_COLON] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(356),
    [anon_sym_COLON] = ACTIONS(356),
    [anon_sym_LPAREN] = ACTIONS(358),
    [sym_spread] = ACTIONS(358),
    [sym_self] = ACTIONS(356),
    [sym_next] = ACTIONS(356),
    [anon_sym__G] = ACTIONS(356),
    [anon_sym__VERSION] = ACTIONS(356),
    [anon_sym_LBRACE] = ACTIONS(358),
    [anon_sym_or] = ACTIONS(356),
    [anon_sym_and] = ACTIONS(356),
    [anon_sym_LT] = ACTIONS(356),
    [anon_sym_LT_EQ] = ACTIONS(358),
    [anon_sym_EQ_EQ] = ACTIONS(358),
    [anon_sym_TILDE_EQ] = ACTIONS(358),
    [anon_sym_GT_EQ] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(356),
    [anon_sym_PIPE] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(356),
    [anon_sym_AMP] = ACTIONS(358),
    [anon_sym_LT_LT] = ACTIONS(358),
    [anon_sym_GT_GT] = ACTIONS(358),
    [anon_sym_PLUS] = ACTIONS(358),
    [anon_sym_DASH] = ACTIONS(358),
    [anon_sym_STAR] = ACTIONS(358),
    [anon_sym_SLASH] = ACTIONS(356),
    [anon_sym_SLASH_SLASH] = ACTIONS(358),
    [anon_sym_PERCENT] = ACTIONS(358),
    [anon_sym_DOT_DOT] = ACTIONS(356),
    [anon_sym_CARET] = ACTIONS(358),
    [anon_sym_not] = ACTIONS(356),
    [anon_sym_POUND] = ACTIONS(358),
    [sym_number] = ACTIONS(358),
    [sym_nil] = ACTIONS(356),
    [sym_true] = ACTIONS(356),
    [sym_false] = ACTIONS(356),
    [sym_identifier] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(358),
  },
  [33] = {
    [sym_return_statement] = STATE(835),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(360),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [34] = {
    [sym_return_statement] = STATE(834),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(362),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [35] = {
    [sym_return_statement] = STATE(833),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(364),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [36] = {
    [anon_sym_return] = ACTIONS(366),
    [anon_sym_COMMA] = ACTIONS(368),
    [anon_sym_local] = ACTIONS(366),
    [anon_sym_LBRACK] = ACTIONS(368),
    [anon_sym_DOT] = ACTIONS(366),
    [anon_sym_do] = ACTIONS(366),
    [anon_sym_end] = ACTIONS(366),
    [anon_sym_if] = ACTIONS(366),
    [anon_sym_elseif] = ACTIONS(366),
    [anon_sym_else] = ACTIONS(366),
    [anon_sym_while] = ACTIONS(366),
    [anon_sym_repeat] = ACTIONS(366),
    [anon_sym_for] = ACTIONS(366),
    [anon_sym_goto] = ACTIONS(366),
    [sym_break_statement] = ACTIONS(366),
    [anon_sym_COLON_COLON] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym_function] = ACTIONS(366),
    [anon_sym_COLON] = ACTIONS(366),
    [anon_sym_LPAREN] = ACTIONS(368),
    [sym_spread] = ACTIONS(368),
    [sym_self] = ACTIONS(366),
    [sym_next] = ACTIONS(366),
    [anon_sym__G] = ACTIONS(366),
    [anon_sym__VERSION] = ACTIONS(366),
    [anon_sym_LBRACE] = ACTIONS(368),
    [anon_sym_or] = ACTIONS(366),
    [anon_sym_and] = ACTIONS(366),
    [anon_sym_LT] = ACTIONS(366),
    [anon_sym_LT_EQ] = ACTIONS(368),
    [anon_sym_EQ_EQ] = ACTIONS(368),
    [anon_sym_TILDE_EQ] = ACTIONS(368),
    [anon_sym_GT_EQ] = ACTIONS(368),
    [anon_sym_GT] = ACTIONS(366),
    [anon_sym_PIPE] = ACTIONS(368),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_AMP] = ACTIONS(368),
    [anon_sym_LT_LT] = ACTIONS(368),
    [anon_sym_GT_GT] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(368),
    [anon_sym_SLASH] = ACTIONS(366),
    [anon_sym_SLASH_SLASH] = ACTIONS(368),
    [anon_sym_PERCENT] = ACTIONS(368),
    [anon_sym_DOT_DOT] = ACTIONS(366),
    [anon_sym_CARET] = ACTIONS(368),
    [anon_sym_not] = ACTIONS(366),
    [anon_sym_POUND] = ACTIONS(368),
    [sym_number] = ACTIONS(368),
    [sym_nil] = ACTIONS(366),
    [sym_true] = ACTIONS(366),
    [sym_false] = ACTIONS(366),
    [sym_identifier] = ACTIONS(366),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(368),
  },
  [37] = {
    [anon_sym_return] = ACTIONS(370),
    [anon_sym_COMMA] = ACTIONS(372),
    [anon_sym_local] = ACTIONS(370),
    [anon_sym_LBRACK] = ACTIONS(372),
    [anon_sym_DOT] = ACTIONS(370),
    [anon_sym_do] = ACTIONS(370),
    [anon_sym_end] = ACTIONS(370),
    [anon_sym_if] = ACTIONS(370),
    [anon_sym_elseif] = ACTIONS(370),
    [anon_sym_else] = ACTIONS(370),
    [anon_sym_while] = ACTIONS(370),
    [anon_sym_repeat] = ACTIONS(370),
    [anon_sym_for] = ACTIONS(370),
    [anon_sym_goto] = ACTIONS(370),
    [sym_break_statement] = ACTIONS(370),
    [anon_sym_COLON_COLON] = ACTIONS(372),
    [anon_sym_SEMI] = ACTIONS(372),
    [anon_sym_function] = ACTIONS(370),
    [anon_sym_COLON] = ACTIONS(370),
    [anon_sym_LPAREN] = ACTIONS(372),
    [sym_spread] = ACTIONS(372),
    [sym_self] = ACTIONS(370),
    [sym_next] = ACTIONS(370),
    [anon_sym__G] = ACTIONS(370),
    [anon_sym__VERSION] = ACTIONS(370),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_or] = ACTIONS(370),
    [anon_sym_and] = ACTIONS(370),
    [anon_sym_LT] = ACTIONS(370),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_TILDE_EQ] = ACTIONS(372),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_GT] = ACTIONS(370),
    [anon_sym_PIPE] = ACTIONS(372),
    [anon_sym_TILDE] = ACTIONS(370),
    [anon_sym_AMP] = ACTIONS(372),
    [anon_sym_LT_LT] = ACTIONS(372),
    [anon_sym_GT_GT] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(372),
    [anon_sym_DASH] = ACTIONS(372),
    [anon_sym_STAR] = ACTIONS(372),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_SLASH_SLASH] = ACTIONS(372),
    [anon_sym_PERCENT] = ACTIONS(372),
    [anon_sym_DOT_DOT] = ACTIONS(370),
    [anon_sym_CARET] = ACTIONS(372),
    [anon_sym_not] = ACTIONS(370),
    [anon_sym_POUND] = ACTIONS(372),
    [sym_number] = ACTIONS(372),
    [sym_nil] = ACTIONS(370),
    [sym_true] = ACTIONS(370),
    [sym_false] = ACTIONS(370),
    [sym_identifier] = ACTIONS(370),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(372),
  },
  [38] = {
    [anon_sym_return] = ACTIONS(374),
    [anon_sym_COMMA] = ACTIONS(376),
    [anon_sym_local] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [anon_sym_DOT] = ACTIONS(374),
    [anon_sym_do] = ACTIONS(374),
    [anon_sym_end] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(374),
    [anon_sym_elseif] = ACTIONS(374),
    [anon_sym_else] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(374),
    [anon_sym_repeat] = ACTIONS(374),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_goto] = ACTIONS(374),
    [sym_break_statement] = ACTIONS(374),
    [anon_sym_COLON_COLON] = ACTIONS(376),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_function] = ACTIONS(374),
    [anon_sym_COLON] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [sym_spread] = ACTIONS(376),
    [sym_self] = ACTIONS(374),
    [sym_next] = ACTIONS(374),
    [anon_sym__G] = ACTIONS(374),
    [anon_sym__VERSION] = ACTIONS(374),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_or] = ACTIONS(374),
    [anon_sym_and] = ACTIONS(374),
    [anon_sym_LT] = ACTIONS(374),
    [anon_sym_LT_EQ] = ACTIONS(376),
    [anon_sym_EQ_EQ] = ACTIONS(376),
    [anon_sym_TILDE_EQ] = ACTIONS(376),
    [anon_sym_GT_EQ] = ACTIONS(376),
    [anon_sym_GT] = ACTIONS(374),
    [anon_sym_PIPE] = ACTIONS(376),
    [anon_sym_TILDE] = ACTIONS(374),
    [anon_sym_AMP] = ACTIONS(376),
    [anon_sym_LT_LT] = ACTIONS(376),
    [anon_sym_GT_GT] = ACTIONS(376),
    [anon_sym_PLUS] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(376),
    [anon_sym_STAR] = ACTIONS(376),
    [anon_sym_SLASH] = ACTIONS(374),
    [anon_sym_SLASH_SLASH] = ACTIONS(376),
    [anon_sym_PERCENT] = ACTIONS(376),
    [anon_sym_DOT_DOT] = ACTIONS(374),
    [anon_sym_CARET] = ACTIONS(376),
    [anon_sym_not] = ACTIONS(374),
    [anon_sym_POUND] = ACTIONS(376),
    [sym_number] = ACTIONS(376),
    [sym_nil] = ACTIONS(374),
    [sym_true] = ACTIONS(374),
    [sym_false] = ACTIONS(374),
    [sym_identifier] = ACTIONS(374),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(376),
  },
  [39] = {
    [sym_return_statement] = STATE(828),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(378),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [40] = {
    [sym_return_statement] = STATE(895),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(380),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [41] = {
    [sym_return_statement] = STATE(826),
    [sym_variable_declaration] = STATE(33),
    [sym_local_variable_declaration] = STATE(33),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(33),
    [sym_if_statement] = STATE(33),
    [sym_while_statement] = STATE(33),
    [sym_repeat_statement] = STATE(33),
    [sym_for_statement] = STATE(33),
    [sym_for_in_statement] = STATE(33),
    [sym_goto_statement] = STATE(33),
    [sym_label_statement] = STATE(33),
    [sym__empty_statement] = STATE(33),
    [sym_function_statement] = STATE(33),
    [sym_local_function_statement] = STATE(33),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(33),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(382),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(384),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(386),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [42] = {
    [sym_return_statement] = STATE(824),
    [sym_variable_declaration] = STATE(34),
    [sym_local_variable_declaration] = STATE(34),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_repeat_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_for_in_statement] = STATE(34),
    [sym_goto_statement] = STATE(34),
    [sym_label_statement] = STATE(34),
    [sym__empty_statement] = STATE(34),
    [sym_function_statement] = STATE(34),
    [sym_local_function_statement] = STATE(34),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(34),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(390),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [43] = {
    [sym_return_statement] = STATE(822),
    [sym_variable_declaration] = STATE(35),
    [sym_local_variable_declaration] = STATE(35),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(35),
    [sym_if_statement] = STATE(35),
    [sym_while_statement] = STATE(35),
    [sym_repeat_statement] = STATE(35),
    [sym_for_statement] = STATE(35),
    [sym_for_in_statement] = STATE(35),
    [sym_goto_statement] = STATE(35),
    [sym_label_statement] = STATE(35),
    [sym__empty_statement] = STATE(35),
    [sym_function_statement] = STATE(35),
    [sym_local_function_statement] = STATE(35),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(35),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(394),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(396),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(398),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [44] = {
    [sym_return_statement] = STATE(905),
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(100),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(412),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(418),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [45] = {
    [sym_return_statement] = STATE(814),
    [sym_variable_declaration] = STATE(39),
    [sym_local_variable_declaration] = STATE(39),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_repeat_statement] = STATE(39),
    [sym_for_statement] = STATE(39),
    [sym_for_in_statement] = STATE(39),
    [sym_goto_statement] = STATE(39),
    [sym_label_statement] = STATE(39),
    [sym__empty_statement] = STATE(39),
    [sym_function_statement] = STATE(39),
    [sym_local_function_statement] = STATE(39),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(39),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(444),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(446),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(448),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [46] = {
    [sym_return_statement] = STATE(812),
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(100),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(450),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(418),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [47] = {
    [sym_return_statement] = STATE(809),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(452),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [48] = {
    [sym_return_statement] = STATE(870),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(454),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [49] = {
    [sym_return_statement] = STATE(799),
    [sym_variable_declaration] = STATE(46),
    [sym_local_variable_declaration] = STATE(46),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(46),
    [sym_if_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_repeat_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_for_in_statement] = STATE(46),
    [sym_goto_statement] = STATE(46),
    [sym_label_statement] = STATE(46),
    [sym__empty_statement] = STATE(46),
    [sym_function_statement] = STATE(46),
    [sym_local_function_statement] = STATE(46),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(46),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(456),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(458),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [50] = {
    [sym_return_statement] = STATE(797),
    [sym_variable_declaration] = STATE(47),
    [sym_local_variable_declaration] = STATE(47),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(47),
    [sym_if_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_repeat_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_for_in_statement] = STATE(47),
    [sym_goto_statement] = STATE(47),
    [sym_label_statement] = STATE(47),
    [sym__empty_statement] = STATE(47),
    [sym_function_statement] = STATE(47),
    [sym_local_function_statement] = STATE(47),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(47),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(462),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(464),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [51] = {
    [sym_return_statement] = STATE(787),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [52] = {
    [sym_return_statement] = STATE(786),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(470),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [53] = {
    [sym_return_statement] = STATE(785),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [54] = {
    [sym_return_statement] = STATE(889),
    [sym_variable_declaration] = STATE(81),
    [sym_local_variable_declaration] = STATE(81),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(81),
    [sym_if_statement] = STATE(81),
    [sym_while_statement] = STATE(81),
    [sym_repeat_statement] = STATE(81),
    [sym_for_statement] = STATE(81),
    [sym_for_in_statement] = STATE(81),
    [sym_goto_statement] = STATE(81),
    [sym_label_statement] = STATE(81),
    [sym__empty_statement] = STATE(81),
    [sym_function_statement] = STATE(81),
    [sym_local_function_statement] = STATE(81),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(81),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(474),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(476),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [55] = {
    [sym_return_statement] = STATE(868),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(480),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [56] = {
    [sym_return_statement] = STATE(783),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(482),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [57] = {
    [sym_return_statement] = STATE(869),
    [sym_variable_declaration] = STATE(75),
    [sym_local_variable_declaration] = STATE(75),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(75),
    [sym_if_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_repeat_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_for_in_statement] = STATE(75),
    [sym_goto_statement] = STATE(75),
    [sym_label_statement] = STATE(75),
    [sym__empty_statement] = STATE(75),
    [sym_function_statement] = STATE(75),
    [sym_local_function_statement] = STATE(75),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(75),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(484),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(486),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(488),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [58] = {
    [sym_return_statement] = STATE(782),
    [sym_variable_declaration] = STATE(51),
    [sym_local_variable_declaration] = STATE(51),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(51),
    [sym_if_statement] = STATE(51),
    [sym_while_statement] = STATE(51),
    [sym_repeat_statement] = STATE(51),
    [sym_for_statement] = STATE(51),
    [sym_for_in_statement] = STATE(51),
    [sym_goto_statement] = STATE(51),
    [sym_label_statement] = STATE(51),
    [sym__empty_statement] = STATE(51),
    [sym_function_statement] = STATE(51),
    [sym_local_function_statement] = STATE(51),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(51),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(490),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(492),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [59] = {
    [sym_return_statement] = STATE(781),
    [sym_variable_declaration] = STATE(52),
    [sym_local_variable_declaration] = STATE(52),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(52),
    [sym_if_statement] = STATE(52),
    [sym_while_statement] = STATE(52),
    [sym_repeat_statement] = STATE(52),
    [sym_for_statement] = STATE(52),
    [sym_for_in_statement] = STATE(52),
    [sym_goto_statement] = STATE(52),
    [sym_label_statement] = STATE(52),
    [sym__empty_statement] = STATE(52),
    [sym_function_statement] = STATE(52),
    [sym_local_function_statement] = STATE(52),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(52),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(498),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(500),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [60] = {
    [sym_return_statement] = STATE(780),
    [sym_variable_declaration] = STATE(53),
    [sym_local_variable_declaration] = STATE(53),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(53),
    [sym_if_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_repeat_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_for_in_statement] = STATE(53),
    [sym_goto_statement] = STATE(53),
    [sym_label_statement] = STATE(53),
    [sym__empty_statement] = STATE(53),
    [sym_function_statement] = STATE(53),
    [sym_local_function_statement] = STATE(53),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(53),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(502),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(504),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(506),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [61] = {
    [sym_return_statement] = STATE(842),
    [sym_variable_declaration] = STATE(56),
    [sym_local_variable_declaration] = STATE(56),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(56),
    [sym_if_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_repeat_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_for_in_statement] = STATE(56),
    [sym_goto_statement] = STATE(56),
    [sym_label_statement] = STATE(56),
    [sym__empty_statement] = STATE(56),
    [sym_function_statement] = STATE(56),
    [sym_local_function_statement] = STATE(56),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(56),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(508),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(510),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [62] = {
    [sym_return_statement] = STATE(840),
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(100),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(514),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(418),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [63] = {
    [sym_return_statement] = STATE(841),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(516),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [64] = {
    [sym_return_statement] = STATE(827),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(518),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [65] = {
    [sym_return_statement] = STATE(884),
    [sym_variable_declaration] = STATE(62),
    [sym_local_variable_declaration] = STATE(62),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(62),
    [sym_if_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_repeat_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_for_in_statement] = STATE(62),
    [sym_goto_statement] = STATE(62),
    [sym_label_statement] = STATE(62),
    [sym__empty_statement] = STATE(62),
    [sym_function_statement] = STATE(62),
    [sym_local_function_statement] = STATE(62),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(62),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(520),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(522),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(524),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [66] = {
    [sym_return_statement] = STATE(896),
    [sym_variable_declaration] = STATE(63),
    [sym_local_variable_declaration] = STATE(63),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_repeat_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_for_in_statement] = STATE(63),
    [sym_goto_statement] = STATE(63),
    [sym_label_statement] = STATE(63),
    [sym__empty_statement] = STATE(63),
    [sym_function_statement] = STATE(63),
    [sym_local_function_statement] = STATE(63),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(63),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(526),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(528),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(530),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [67] = {
    [anon_sym_return] = ACTIONS(532),
    [anon_sym_COMMA] = ACTIONS(534),
    [anon_sym_local] = ACTIONS(532),
    [anon_sym_LBRACK] = ACTIONS(534),
    [anon_sym_DOT] = ACTIONS(532),
    [anon_sym_do] = ACTIONS(532),
    [anon_sym_end] = ACTIONS(532),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_elseif] = ACTIONS(532),
    [anon_sym_else] = ACTIONS(532),
    [anon_sym_while] = ACTIONS(532),
    [anon_sym_repeat] = ACTIONS(532),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_goto] = ACTIONS(532),
    [sym_break_statement] = ACTIONS(532),
    [anon_sym_COLON_COLON] = ACTIONS(534),
    [anon_sym_SEMI] = ACTIONS(534),
    [anon_sym_function] = ACTIONS(532),
    [anon_sym_COLON] = ACTIONS(532),
    [anon_sym_LPAREN] = ACTIONS(534),
    [sym_spread] = ACTIONS(534),
    [sym_self] = ACTIONS(532),
    [sym_next] = ACTIONS(532),
    [anon_sym__G] = ACTIONS(532),
    [anon_sym__VERSION] = ACTIONS(532),
    [anon_sym_LBRACE] = ACTIONS(534),
    [anon_sym_or] = ACTIONS(532),
    [anon_sym_and] = ACTIONS(532),
    [anon_sym_LT] = ACTIONS(532),
    [anon_sym_LT_EQ] = ACTIONS(534),
    [anon_sym_EQ_EQ] = ACTIONS(534),
    [anon_sym_TILDE_EQ] = ACTIONS(534),
    [anon_sym_GT_EQ] = ACTIONS(534),
    [anon_sym_GT] = ACTIONS(532),
    [anon_sym_PIPE] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_AMP] = ACTIONS(534),
    [anon_sym_LT_LT] = ACTIONS(534),
    [anon_sym_GT_GT] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(534),
    [anon_sym_DASH] = ACTIONS(534),
    [anon_sym_STAR] = ACTIONS(534),
    [anon_sym_SLASH] = ACTIONS(532),
    [anon_sym_SLASH_SLASH] = ACTIONS(534),
    [anon_sym_PERCENT] = ACTIONS(534),
    [anon_sym_DOT_DOT] = ACTIONS(532),
    [anon_sym_CARET] = ACTIONS(534),
    [anon_sym_not] = ACTIONS(532),
    [anon_sym_POUND] = ACTIONS(534),
    [sym_number] = ACTIONS(534),
    [sym_nil] = ACTIONS(532),
    [sym_true] = ACTIONS(532),
    [sym_false] = ACTIONS(532),
    [sym_identifier] = ACTIONS(532),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(534),
  },
  [68] = {
    [sym_return_statement] = STATE(867),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(536),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [69] = {
    [sym_return_statement] = STATE(791),
    [sym_variable_declaration] = STATE(29),
    [sym_local_variable_declaration] = STATE(29),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_repeat_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_for_in_statement] = STATE(29),
    [sym_goto_statement] = STATE(29),
    [sym_label_statement] = STATE(29),
    [sym__empty_statement] = STATE(29),
    [sym_function_statement] = STATE(29),
    [sym_local_function_statement] = STATE(29),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(29),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(538),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(540),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [70] = {
    [sym_return_statement] = STATE(790),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [71] = {
    [sym_return_statement] = STATE(792),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [72] = {
    [sym_return_statement] = STATE(793),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [73] = {
    [aux_sym_variable_declaration_repeat1] = STATE(734),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_COMMA] = ACTIONS(156),
    [anon_sym_EQ] = ACTIONS(550),
    [anon_sym_local] = ACTIONS(154),
    [anon_sym_LBRACK] = ACTIONS(160),
    [anon_sym_DOT] = ACTIONS(154),
    [anon_sym_do] = ACTIONS(154),
    [anon_sym_if] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(154),
    [anon_sym_repeat] = ACTIONS(154),
    [anon_sym_until] = ACTIONS(154),
    [anon_sym_for] = ACTIONS(154),
    [anon_sym_goto] = ACTIONS(154),
    [sym_break_statement] = ACTIONS(154),
    [anon_sym_COLON_COLON] = ACTIONS(160),
    [anon_sym_SEMI] = ACTIONS(160),
    [anon_sym_function] = ACTIONS(154),
    [anon_sym_COLON] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(160),
    [sym_spread] = ACTIONS(160),
    [sym_self] = ACTIONS(154),
    [sym_next] = ACTIONS(154),
    [anon_sym__G] = ACTIONS(154),
    [anon_sym__VERSION] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_LT_EQ] = ACTIONS(160),
    [anon_sym_EQ_EQ] = ACTIONS(160),
    [anon_sym_TILDE_EQ] = ACTIONS(160),
    [anon_sym_GT_EQ] = ACTIONS(160),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_PIPE] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(154),
    [anon_sym_AMP] = ACTIONS(160),
    [anon_sym_LT_LT] = ACTIONS(160),
    [anon_sym_GT_GT] = ACTIONS(160),
    [anon_sym_PLUS] = ACTIONS(160),
    [anon_sym_DASH] = ACTIONS(160),
    [anon_sym_STAR] = ACTIONS(160),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_SLASH_SLASH] = ACTIONS(160),
    [anon_sym_PERCENT] = ACTIONS(160),
    [anon_sym_DOT_DOT] = ACTIONS(154),
    [anon_sym_CARET] = ACTIONS(160),
    [anon_sym_not] = ACTIONS(154),
    [anon_sym_POUND] = ACTIONS(160),
    [sym_number] = ACTIONS(160),
    [sym_nil] = ACTIONS(154),
    [sym_true] = ACTIONS(154),
    [sym_false] = ACTIONS(154),
    [sym_identifier] = ACTIONS(154),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(160),
  },
  [74] = {
    [sym_return_statement] = STATE(798),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(552),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [75] = {
    [sym_return_statement] = STATE(871),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(554),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [76] = {
    [sym_return_statement] = STATE(810),
    [sym_variable_declaration] = STATE(71),
    [sym_local_variable_declaration] = STATE(71),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(71),
    [sym_if_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_repeat_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_for_in_statement] = STATE(71),
    [sym_goto_statement] = STATE(71),
    [sym_label_statement] = STATE(71),
    [sym__empty_statement] = STATE(71),
    [sym_function_statement] = STATE(71),
    [sym_local_function_statement] = STATE(71),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(71),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(558),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(560),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [77] = {
    [sym_return_statement] = STATE(813),
    [sym_variable_declaration] = STATE(72),
    [sym_local_variable_declaration] = STATE(72),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(72),
    [sym_if_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_repeat_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_for_in_statement] = STATE(72),
    [sym_goto_statement] = STATE(72),
    [sym_label_statement] = STATE(72),
    [sym__empty_statement] = STATE(72),
    [sym_function_statement] = STATE(72),
    [sym_local_function_statement] = STATE(72),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(72),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(564),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [78] = {
    [sym_arguments] = STATE(148),
    [sym_table] = STATE(125),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_COMMA] = ACTIONS(137),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_LBRACK] = ACTIONS(568),
    [anon_sym_DOT] = ACTIONS(570),
    [anon_sym_do] = ACTIONS(135),
    [anon_sym_end] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(135),
    [anon_sym_repeat] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_goto] = ACTIONS(135),
    [sym_break_statement] = ACTIONS(135),
    [anon_sym_COLON_COLON] = ACTIONS(137),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_function] = ACTIONS(135),
    [anon_sym_COLON] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(574),
    [sym_spread] = ACTIONS(137),
    [sym_self] = ACTIONS(135),
    [sym_next] = ACTIONS(135),
    [anon_sym__G] = ACTIONS(135),
    [anon_sym__VERSION] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(135),
    [anon_sym_and] = ACTIONS(135),
    [anon_sym_LT] = ACTIONS(135),
    [anon_sym_LT_EQ] = ACTIONS(137),
    [anon_sym_EQ_EQ] = ACTIONS(137),
    [anon_sym_TILDE_EQ] = ACTIONS(137),
    [anon_sym_GT_EQ] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(135),
    [anon_sym_PIPE] = ACTIONS(137),
    [anon_sym_TILDE] = ACTIONS(135),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_LT_LT] = ACTIONS(137),
    [anon_sym_GT_GT] = ACTIONS(137),
    [anon_sym_PLUS] = ACTIONS(137),
    [anon_sym_DASH] = ACTIONS(137),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_SLASH] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(137),
    [anon_sym_PERCENT] = ACTIONS(137),
    [anon_sym_DOT_DOT] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(137),
    [anon_sym_not] = ACTIONS(135),
    [anon_sym_POUND] = ACTIONS(137),
    [sym_number] = ACTIONS(137),
    [sym_nil] = ACTIONS(135),
    [sym_true] = ACTIONS(135),
    [sym_false] = ACTIONS(135),
    [sym_identifier] = ACTIONS(135),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(580),
  },
  [79] = {
    [sym_return_statement] = STATE(811),
    [sym_variable_declaration] = STATE(44),
    [sym_local_variable_declaration] = STATE(44),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(44),
    [sym_if_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_repeat_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_for_in_statement] = STATE(44),
    [sym_goto_statement] = STATE(44),
    [sym_label_statement] = STATE(44),
    [sym__empty_statement] = STATE(44),
    [sym_function_statement] = STATE(44),
    [sym_local_function_statement] = STATE(44),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(44),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(583),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(585),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [80] = {
    [anon_sym_return] = ACTIONS(166),
    [anon_sym_COMMA] = ACTIONS(173),
    [anon_sym_local] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(166),
    [anon_sym_end] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(166),
    [anon_sym_elseif] = ACTIONS(166),
    [anon_sym_else] = ACTIONS(166),
    [anon_sym_while] = ACTIONS(166),
    [anon_sym_repeat] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(166),
    [anon_sym_goto] = ACTIONS(166),
    [sym_break_statement] = ACTIONS(166),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [anon_sym_SEMI] = ACTIONS(173),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(173),
    [sym_spread] = ACTIONS(173),
    [sym_self] = ACTIONS(166),
    [sym_next] = ACTIONS(166),
    [anon_sym__G] = ACTIONS(166),
    [anon_sym__VERSION] = ACTIONS(166),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_or] = ACTIONS(166),
    [anon_sym_and] = ACTIONS(166),
    [anon_sym_LT] = ACTIONS(166),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_TILDE_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(166),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_TILDE] = ACTIONS(166),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(166),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_PERCENT] = ACTIONS(173),
    [anon_sym_DOT_DOT] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_not] = ACTIONS(166),
    [anon_sym_POUND] = ACTIONS(173),
    [sym_number] = ACTIONS(173),
    [sym_nil] = ACTIONS(166),
    [sym_true] = ACTIONS(166),
    [sym_false] = ACTIONS(166),
    [sym_identifier] = ACTIONS(166),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(173),
  },
  [81] = {
    [sym_return_statement] = STATE(879),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(589),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [82] = {
    [sym_return_statement] = STATE(817),
    [sym_variable_declaration] = STATE(74),
    [sym_local_variable_declaration] = STATE(74),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(74),
    [sym_if_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_repeat_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_for_in_statement] = STATE(74),
    [sym_goto_statement] = STATE(74),
    [sym_label_statement] = STATE(74),
    [sym__empty_statement] = STATE(74),
    [sym_function_statement] = STATE(74),
    [sym_local_function_statement] = STATE(74),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(74),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(591),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(593),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(595),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [83] = {
    [sym_return_statement] = STATE(821),
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(100),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(597),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(418),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [84] = {
    [sym_return_statement] = STATE(865),
    [sym_variable_declaration] = STATE(68),
    [sym_local_variable_declaration] = STATE(68),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(68),
    [sym_if_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_repeat_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_for_in_statement] = STATE(68),
    [sym_goto_statement] = STATE(68),
    [sym_label_statement] = STATE(68),
    [sym__empty_statement] = STATE(68),
    [sym_function_statement] = STATE(68),
    [sym_local_function_statement] = STATE(68),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(68),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(599),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(601),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(603),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [85] = {
    [sym_return_statement] = STATE(863),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(605),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [86] = {
    [anon_sym_return] = ACTIONS(607),
    [anon_sym_COMMA] = ACTIONS(609),
    [anon_sym_local] = ACTIONS(607),
    [anon_sym_LBRACK] = ACTIONS(609),
    [anon_sym_DOT] = ACTIONS(607),
    [anon_sym_do] = ACTIONS(607),
    [anon_sym_end] = ACTIONS(607),
    [anon_sym_if] = ACTIONS(607),
    [anon_sym_elseif] = ACTIONS(607),
    [anon_sym_else] = ACTIONS(607),
    [anon_sym_while] = ACTIONS(607),
    [anon_sym_repeat] = ACTIONS(607),
    [anon_sym_for] = ACTIONS(607),
    [anon_sym_goto] = ACTIONS(607),
    [sym_break_statement] = ACTIONS(607),
    [anon_sym_COLON_COLON] = ACTIONS(609),
    [anon_sym_SEMI] = ACTIONS(609),
    [anon_sym_function] = ACTIONS(607),
    [anon_sym_COLON] = ACTIONS(607),
    [anon_sym_LPAREN] = ACTIONS(609),
    [sym_spread] = ACTIONS(609),
    [sym_self] = ACTIONS(607),
    [sym_next] = ACTIONS(607),
    [anon_sym__G] = ACTIONS(607),
    [anon_sym__VERSION] = ACTIONS(607),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_or] = ACTIONS(607),
    [anon_sym_and] = ACTIONS(607),
    [anon_sym_LT] = ACTIONS(607),
    [anon_sym_LT_EQ] = ACTIONS(609),
    [anon_sym_EQ_EQ] = ACTIONS(609),
    [anon_sym_TILDE_EQ] = ACTIONS(609),
    [anon_sym_GT_EQ] = ACTIONS(609),
    [anon_sym_GT] = ACTIONS(607),
    [anon_sym_PIPE] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(607),
    [anon_sym_AMP] = ACTIONS(609),
    [anon_sym_LT_LT] = ACTIONS(609),
    [anon_sym_GT_GT] = ACTIONS(609),
    [anon_sym_PLUS] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(609),
    [anon_sym_STAR] = ACTIONS(609),
    [anon_sym_SLASH] = ACTIONS(607),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_PERCENT] = ACTIONS(609),
    [anon_sym_DOT_DOT] = ACTIONS(607),
    [anon_sym_CARET] = ACTIONS(609),
    [anon_sym_not] = ACTIONS(607),
    [anon_sym_POUND] = ACTIONS(609),
    [sym_number] = ACTIONS(609),
    [sym_nil] = ACTIONS(607),
    [sym_true] = ACTIONS(607),
    [sym_false] = ACTIONS(607),
    [sym_identifier] = ACTIONS(607),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(609),
  },
  [87] = {
    [sym_return_statement] = STATE(875),
    [sym_variable_declaration] = STATE(83),
    [sym_local_variable_declaration] = STATE(83),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(83),
    [sym_if_statement] = STATE(83),
    [sym_while_statement] = STATE(83),
    [sym_repeat_statement] = STATE(83),
    [sym_for_statement] = STATE(83),
    [sym_for_in_statement] = STATE(83),
    [sym_goto_statement] = STATE(83),
    [sym_label_statement] = STATE(83),
    [sym__empty_statement] = STATE(83),
    [sym_function_statement] = STATE(83),
    [sym_local_function_statement] = STATE(83),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(83),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_local] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_repeat] = ACTIONS(410),
    [anon_sym_until] = ACTIONS(611),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_goto] = ACTIONS(416),
    [sym_break_statement] = ACTIONS(613),
    [anon_sym_COLON_COLON] = ACTIONS(420),
    [anon_sym_SEMI] = ACTIONS(615),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(426),
    [sym_spread] = ACTIONS(428),
    [sym_self] = ACTIONS(430),
    [sym_next] = ACTIONS(432),
    [anon_sym__G] = ACTIONS(434),
    [anon_sym__VERSION] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_not] = ACTIONS(440),
    [anon_sym_POUND] = ACTIONS(438),
    [sym_number] = ACTIONS(428),
    [sym_nil] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_identifier] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(428),
  },
  [88] = {
    [sym_return_statement] = STATE(883),
    [sym_variable_declaration] = STATE(20),
    [sym_local_variable_declaration] = STATE(20),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_repeat_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_goto_statement] = STATE(20),
    [sym_label_statement] = STATE(20),
    [sym__empty_statement] = STATE(20),
    [sym_function_statement] = STATE(20),
    [sym_local_function_statement] = STATE(20),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(20),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(617),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(619),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(621),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [89] = {
    [sym_return_statement] = STATE(900),
    [sym_variable_declaration] = STATE(48),
    [sym_local_variable_declaration] = STATE(48),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(48),
    [sym_if_statement] = STATE(48),
    [sym_while_statement] = STATE(48),
    [sym_repeat_statement] = STATE(48),
    [sym_for_statement] = STATE(48),
    [sym_for_in_statement] = STATE(48),
    [sym_goto_statement] = STATE(48),
    [sym_label_statement] = STATE(48),
    [sym__empty_statement] = STATE(48),
    [sym_function_statement] = STATE(48),
    [sym_local_function_statement] = STATE(48),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(48),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(623),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(625),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [90] = {
    [sym_return_statement] = STATE(857),
    [sym_variable_declaration] = STATE(94),
    [sym_local_variable_declaration] = STATE(94),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(94),
    [sym_if_statement] = STATE(94),
    [sym_while_statement] = STATE(94),
    [sym_repeat_statement] = STATE(94),
    [sym_for_statement] = STATE(94),
    [sym_for_in_statement] = STATE(94),
    [sym_goto_statement] = STATE(94),
    [sym_label_statement] = STATE(94),
    [sym__empty_statement] = STATE(94),
    [sym_function_statement] = STATE(94),
    [sym_local_function_statement] = STATE(94),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(94),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(629),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(631),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(633),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [91] = {
    [sym_return_statement] = STATE(903),
    [sym_variable_declaration] = STATE(64),
    [sym_local_variable_declaration] = STATE(64),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(64),
    [sym_if_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_repeat_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_for_in_statement] = STATE(64),
    [sym_goto_statement] = STATE(64),
    [sym_label_statement] = STATE(64),
    [sym__empty_statement] = STATE(64),
    [sym_function_statement] = STATE(64),
    [sym_local_function_statement] = STATE(64),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(64),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(637),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(639),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [92] = {
    [sym_return_statement] = STATE(902),
    [sym_variable_declaration] = STATE(55),
    [sym_local_variable_declaration] = STATE(55),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(55),
    [sym_if_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_repeat_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_for_in_statement] = STATE(55),
    [sym_goto_statement] = STATE(55),
    [sym_label_statement] = STATE(55),
    [sym__empty_statement] = STATE(55),
    [sym_function_statement] = STATE(55),
    [sym_local_function_statement] = STATE(55),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(55),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(641),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(643),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(645),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [93] = {
    [anon_sym_return] = ACTIONS(647),
    [anon_sym_COMMA] = ACTIONS(649),
    [anon_sym_local] = ACTIONS(647),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_do] = ACTIONS(647),
    [anon_sym_end] = ACTIONS(647),
    [anon_sym_if] = ACTIONS(647),
    [anon_sym_elseif] = ACTIONS(647),
    [anon_sym_else] = ACTIONS(647),
    [anon_sym_while] = ACTIONS(647),
    [anon_sym_repeat] = ACTIONS(647),
    [anon_sym_for] = ACTIONS(647),
    [anon_sym_goto] = ACTIONS(647),
    [sym_break_statement] = ACTIONS(647),
    [anon_sym_COLON_COLON] = ACTIONS(649),
    [anon_sym_SEMI] = ACTIONS(649),
    [anon_sym_function] = ACTIONS(647),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(649),
    [sym_spread] = ACTIONS(649),
    [sym_self] = ACTIONS(647),
    [sym_next] = ACTIONS(647),
    [anon_sym__G] = ACTIONS(647),
    [anon_sym__VERSION] = ACTIONS(647),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_or] = ACTIONS(647),
    [anon_sym_and] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(649),
    [anon_sym_EQ_EQ] = ACTIONS(649),
    [anon_sym_TILDE_EQ] = ACTIONS(649),
    [anon_sym_GT_EQ] = ACTIONS(649),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(649),
    [anon_sym_TILDE] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(649),
    [anon_sym_LT_LT] = ACTIONS(649),
    [anon_sym_GT_GT] = ACTIONS(649),
    [anon_sym_PLUS] = ACTIONS(649),
    [anon_sym_DASH] = ACTIONS(649),
    [anon_sym_STAR] = ACTIONS(649),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_SLASH_SLASH] = ACTIONS(649),
    [anon_sym_PERCENT] = ACTIONS(649),
    [anon_sym_DOT_DOT] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(649),
    [anon_sym_not] = ACTIONS(647),
    [anon_sym_POUND] = ACTIONS(649),
    [sym_number] = ACTIONS(649),
    [sym_nil] = ACTIONS(647),
    [sym_true] = ACTIONS(647),
    [sym_false] = ACTIONS(647),
    [sym_identifier] = ACTIONS(647),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(649),
  },
  [94] = {
    [sym_return_statement] = STATE(859),
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(651),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(288),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(290),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [95] = {
    [sym_return_statement] = STATE(861),
    [sym_variable_declaration] = STATE(85),
    [sym_local_variable_declaration] = STATE(85),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(85),
    [sym_if_statement] = STATE(85),
    [sym_while_statement] = STATE(85),
    [sym_repeat_statement] = STATE(85),
    [sym_for_statement] = STATE(85),
    [sym_for_in_statement] = STATE(85),
    [sym_goto_statement] = STATE(85),
    [sym_label_statement] = STATE(85),
    [sym__empty_statement] = STATE(85),
    [sym_function_statement] = STATE(85),
    [sym_local_function_statement] = STATE(85),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(85),
    [anon_sym_return] = ACTIONS(242),
    [anon_sym_local] = ACTIONS(244),
    [anon_sym_do] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(653),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(252),
    [anon_sym_repeat] = ACTIONS(254),
    [anon_sym_for] = ACTIONS(256),
    [anon_sym_goto] = ACTIONS(258),
    [sym_break_statement] = ACTIONS(655),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(268),
    [sym_spread] = ACTIONS(270),
    [sym_self] = ACTIONS(272),
    [sym_next] = ACTIONS(274),
    [anon_sym__G] = ACTIONS(276),
    [anon_sym__VERSION] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_TILDE] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(280),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(280),
    [sym_number] = ACTIONS(270),
    [sym_nil] = ACTIONS(274),
    [sym_true] = ACTIONS(274),
    [sym_false] = ACTIONS(274),
    [sym_identifier] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(270),
  },
  [96] = {
    [anon_sym_return] = ACTIONS(659),
    [anon_sym_COMMA] = ACTIONS(661),
    [anon_sym_local] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(661),
    [anon_sym_DOT] = ACTIONS(659),
    [anon_sym_do] = ACTIONS(659),
    [anon_sym_end] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_elseif] = ACTIONS(659),
    [anon_sym_else] = ACTIONS(659),
    [anon_sym_while] = ACTIONS(659),
    [anon_sym_repeat] = ACTIONS(659),
    [anon_sym_for] = ACTIONS(659),
    [anon_sym_goto] = ACTIONS(659),
    [sym_break_statement] = ACTIONS(659),
    [anon_sym_COLON_COLON] = ACTIONS(661),
    [anon_sym_SEMI] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(659),
    [anon_sym_COLON] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(661),
    [sym_spread] = ACTIONS(661),
    [sym_self] = ACTIONS(659),
    [sym_next] = ACTIONS(659),
    [anon_sym__G] = ACTIONS(659),
    [anon_sym__VERSION] = ACTIONS(659),
    [anon_sym_LBRACE] = ACTIONS(661),
    [anon_sym_or] = ACTIONS(659),
    [anon_sym_and] = ACTIONS(659),
    [anon_sym_LT] = ACTIONS(659),
    [anon_sym_LT_EQ] = ACTIONS(661),
    [anon_sym_EQ_EQ] = ACTIONS(661),
    [anon_sym_TILDE_EQ] = ACTIONS(661),
    [anon_sym_GT_EQ] = ACTIONS(661),
    [anon_sym_GT] = ACTIONS(659),
    [anon_sym_PIPE] = ACTIONS(661),
    [anon_sym_TILDE] = ACTIONS(659),
    [anon_sym_AMP] = ACTIONS(661),
    [anon_sym_LT_LT] = ACTIONS(661),
    [anon_sym_GT_GT] = ACTIONS(661),
    [anon_sym_PLUS] = ACTIONS(661),
    [anon_sym_DASH] = ACTIONS(661),
    [anon_sym_STAR] = ACTIONS(661),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_SLASH_SLASH] = ACTIONS(661),
    [anon_sym_PERCENT] = ACTIONS(661),
    [anon_sym_DOT_DOT] = ACTIONS(659),
    [anon_sym_CARET] = ACTIONS(661),
    [anon_sym_not] = ACTIONS(659),
    [anon_sym_POUND] = ACTIONS(661),
    [sym_number] = ACTIONS(661),
    [sym_nil] = ACTIONS(659),
    [sym_true] = ACTIONS(659),
    [sym_false] = ACTIONS(659),
    [sym_identifier] = ACTIONS(659),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(661),
  },
  [97] = {
    [anon_sym_return] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_end] = ACTIONS(171),
    [anon_sym_if] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_goto] = ACTIONS(171),
    [sym_break_statement] = ACTIONS(171),
    [anon_sym_COLON_COLON] = ACTIONS(169),
    [anon_sym_SEMI] = ACTIONS(169),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(169),
    [sym_spread] = ACTIONS(169),
    [sym_self] = ACTIONS(171),
    [sym_next] = ACTIONS(171),
    [anon_sym__G] = ACTIONS(171),
    [anon_sym__VERSION] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(169),
    [anon_sym_or] = ACTIONS(171),
    [anon_sym_and] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(171),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_EQ] = ACTIONS(169),
    [anon_sym_TILDE_EQ] = ACTIONS(169),
    [anon_sym_GT_EQ] = ACTIONS(169),
    [anon_sym_GT] = ACTIONS(171),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_TILDE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(169),
    [anon_sym_LT_LT] = ACTIONS(169),
    [anon_sym_GT_GT] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_STAR] = ACTIONS(169),
    [anon_sym_SLASH] = ACTIONS(171),
    [anon_sym_SLASH_SLASH] = ACTIONS(169),
    [anon_sym_PERCENT] = ACTIONS(169),
    [anon_sym_DOT_DOT] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(169),
    [anon_sym_not] = ACTIONS(171),
    [anon_sym_POUND] = ACTIONS(169),
    [sym_number] = ACTIONS(169),
    [sym_nil] = ACTIONS(171),
    [sym_true] = ACTIONS(171),
    [sym_false] = ACTIONS(171),
    [sym_identifier] = ACTIONS(171),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(169),
  },
  [98] = {
    [anon_sym_return] = ACTIONS(663),
    [anon_sym_local] = ACTIONS(663),
    [anon_sym_LBRACK] = ACTIONS(160),
    [anon_sym_DOT] = ACTIONS(154),
    [anon_sym_do] = ACTIONS(663),
    [anon_sym_end] = ACTIONS(663),
    [anon_sym_if] = ACTIONS(663),
    [anon_sym_elseif] = ACTIONS(663),
    [anon_sym_else] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_repeat] = ACTIONS(663),
    [anon_sym_for] = ACTIONS(663),
    [anon_sym_goto] = ACTIONS(663),
    [sym_break_statement] = ACTIONS(663),
    [anon_sym_COLON_COLON] = ACTIONS(665),
    [anon_sym_SEMI] = ACTIONS(665),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_COLON] = ACTIONS(154),
    [anon_sym_LPAREN] = ACTIONS(665),
    [sym_spread] = ACTIONS(665),
    [sym_self] = ACTIONS(663),
    [sym_next] = ACTIONS(663),
    [anon_sym__G] = ACTIONS(663),
    [anon_sym__VERSION] = ACTIONS(663),
    [anon_sym_LBRACE] = ACTIONS(665),
    [anon_sym_or] = ACTIONS(154),
    [anon_sym_and] = ACTIONS(154),
    [anon_sym_LT] = ACTIONS(154),
    [anon_sym_LT_EQ] = ACTIONS(160),
    [anon_sym_EQ_EQ] = ACTIONS(160),
    [anon_sym_TILDE_EQ] = ACTIONS(160),
    [anon_sym_GT_EQ] = ACTIONS(160),
    [anon_sym_GT] = ACTIONS(154),
    [anon_sym_PIPE] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(160),
    [anon_sym_LT_LT] = ACTIONS(160),
    [anon_sym_GT_GT] = ACTIONS(160),
    [anon_sym_PLUS] = ACTIONS(160),
    [anon_sym_DASH] = ACTIONS(665),
    [anon_sym_STAR] = ACTIONS(160),
    [anon_sym_SLASH] = ACTIONS(154),
    [anon_sym_SLASH_SLASH] = ACTIONS(160),
    [anon_sym_PERCENT] = ACTIONS(160),
    [anon_sym_DOT_DOT] = ACTIONS(154),
    [anon_sym_CARET] = ACTIONS(160),
    [anon_sym_not] = ACTIONS(663),
    [anon_sym_POUND] = ACTIONS(665),
    [sym_number] = ACTIONS(665),
    [sym_nil] = ACTIONS(663),
    [sym_true] = ACTIONS(663),
    [sym_false] = ACTIONS(663),
    [sym_identifier] = ACTIONS(663),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(665),
  },
  [99] = {
    [ts_builtin_sym_end] = ACTIONS(169),
    [anon_sym_return] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_if] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_goto] = ACTIONS(171),
    [sym_break_statement] = ACTIONS(171),
    [anon_sym_COLON_COLON] = ACTIONS(169),
    [anon_sym_SEMI] = ACTIONS(169),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(169),
    [sym_spread] = ACTIONS(169),
    [sym_self] = ACTIONS(171),
    [sym_next] = ACTIONS(171),
    [anon_sym__G] = ACTIONS(171),
    [anon_sym__VERSION] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(169),
    [anon_sym_or] = ACTIONS(171),
    [anon_sym_and] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(171),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_EQ] = ACTIONS(169),
    [anon_sym_TILDE_EQ] = ACTIONS(169),
    [anon_sym_GT_EQ] = ACTIONS(169),
    [anon_sym_GT] = ACTIONS(171),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_TILDE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(169),
    [anon_sym_LT_LT] = ACTIONS(169),
    [anon_sym_GT_GT] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_STAR] = ACTIONS(169),
    [anon_sym_SLASH] = ACTIONS(171),
    [anon_sym_SLASH_SLASH] = ACTIONS(169),
    [anon_sym_PERCENT] = ACTIONS(169),
    [anon_sym_DOT_DOT] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(169),
    [anon_sym_not] = ACTIONS(171),
    [anon_sym_POUND] = ACTIONS(169),
    [sym_number] = ACTIONS(169),
    [sym_nil] = ACTIONS(171),
    [sym_true] = ACTIONS(171),
    [sym_false] = ACTIONS(171),
    [sym_identifier] = ACTIONS(171),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(169),
  },
  [100] = {
    [sym_variable_declaration] = STATE(100),
    [sym_local_variable_declaration] = STATE(100),
    [sym__variable_declarator] = STATE(73),
    [sym_field_expression] = STATE(101),
    [sym_do_statement] = STATE(100),
    [sym_if_statement] = STATE(100),
    [sym_while_statement] = STATE(100),
    [sym_repeat_statement] = STATE(100),
    [sym_for_statement] = STATE(100),
    [sym_for_in_statement] = STATE(100),
    [sym_goto_statement] = STATE(100),
    [sym_label_statement] = STATE(100),
    [sym__empty_statement] = STATE(100),
    [sym_function_statement] = STATE(100),
    [sym_local_function_statement] = STATE(100),
    [sym_function_call_statement] = STATE(168),
    [sym__expression] = STATE(281),
    [sym_global_variable] = STATE(21),
    [sym__prefix] = STATE(21),
    [sym_function_definition] = STATE(197),
    [sym_table] = STATE(197),
    [sym_binary_operation] = STATE(197),
    [sym_unary_operation] = STATE(197),
    [aux_sym_program_repeat1] = STATE(100),
    [anon_sym_return] = ACTIONS(176),
    [anon_sym_local] = ACTIONS(667),
    [anon_sym_do] = ACTIONS(670),
    [anon_sym_if] = ACTIONS(673),
    [anon_sym_while] = ACTIONS(676),
    [anon_sym_repeat] = ACTIONS(679),
    [anon_sym_until] = ACTIONS(176),
    [anon_sym_for] = ACTIONS(682),
    [anon_sym_goto] = ACTIONS(685),
    [sym_break_statement] = ACTIONS(688),
    [anon_sym_COLON_COLON] = ACTIONS(691),
    [anon_sym_SEMI] = ACTIONS(694),
    [anon_sym_function] = ACTIONS(697),
    [anon_sym_LPAREN] = ACTIONS(700),
    [sym_spread] = ACTIONS(703),
    [sym_self] = ACTIONS(706),
    [sym_next] = ACTIONS(709),
    [anon_sym__G] = ACTIONS(712),
    [anon_sym__VERSION] = ACTIONS(712),
    [anon_sym_LBRACE] = ACTIONS(715),
    [anon_sym_TILDE] = ACTIONS(718),
    [anon_sym_DASH] = ACTIONS(718),
    [anon_sym_not] = ACTIONS(721),
    [anon_sym_POUND] = ACTIONS(718),
    [sym_number] = ACTIONS(703),
    [sym_nil] = ACTIONS(709),
    [sym_true] = ACTIONS(709),
    [sym_false] = ACTIONS(709),
    [sym_identifier] = ACTIONS(724),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(703),
  },
  [101] = {
    [anon_sym_return] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(171),
    [anon_sym_if] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(171),
    [anon_sym_repeat] = ACTIONS(171),
    [anon_sym_until] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_goto] = ACTIONS(171),
    [sym_break_statement] = ACTIONS(171),
    [anon_sym_COLON_COLON] = ACTIONS(169),
    [anon_sym_SEMI] = ACTIONS(169),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(169),
    [sym_spread] = ACTIONS(169),
    [sym_self] = ACTIONS(171),
    [sym_next] = ACTIONS(171),
    [anon_sym__G] = ACTIONS(171),
    [anon_sym__VERSION] = ACTIONS(171),
    [anon_sym_LBRACE] = ACTIONS(169),
    [anon_sym_or] = ACTIONS(171),
    [anon_sym_and] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(171),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_EQ] = ACTIONS(169),
    [anon_sym_TILDE_EQ] = ACTIONS(169),
    [anon_sym_GT_EQ] = ACTIONS(169),
    [anon_sym_GT] = ACTIONS(171),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_TILDE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(169),
    [anon_sym_LT_LT] = ACTIONS(169),
    [anon_sym_GT_GT] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_STAR] = ACTIONS(169),
    [anon_sym_SLASH] = ACTIONS(171),
    [anon_sym_SLASH_SLASH] = ACTIONS(169),
    [anon_sym_PERCENT] = ACTIONS(169),
    [anon_sym_DOT_DOT] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(169),
    [anon_sym_not] = ACTIONS(171),
    [anon_sym_POUND] = ACTIONS(169),
    [sym_number] = ACTIONS(169),
    [sym_nil] = ACTIONS(171),
    [sym_true] = ACTIONS(171),
    [sym_false] = ACTIONS(171),
    [sym_identifier] = ACTIONS(171),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(169),
  },
  [102] = {
    [anon_sym_return] = ACTIONS(166),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(166),
    [anon_sym_while] = ACTIONS(166),
    [anon_sym_repeat] = ACTIONS(166),
    [anon_sym_until] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(166),
    [anon_sym_goto] = ACTIONS(166),
    [sym_break_statement] = ACTIONS(166),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [anon_sym_SEMI] = ACTIONS(173),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(173),
    [sym_spread] = ACTIONS(173),
    [sym_self] = ACTIONS(166),
    [sym_next] = ACTIONS(166),
    [anon_sym__G] = ACTIONS(166),
    [anon_sym__VERSION] = ACTIONS(166),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_or] = ACTIONS(166),
    [anon_sym_and] = ACTIONS(166),
    [anon_sym_LT] = ACTIONS(166),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_TILDE_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(166),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_TILDE] = ACTIONS(166),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(166),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_PERCENT] = ACTIONS(173),
    [anon_sym_DOT_DOT] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_not] = ACTIONS(166),
    [anon_sym_POUND] = ACTIONS(173),
    [sym_number] = ACTIONS(173),
    [sym_nil] = ACTIONS(166),
    [sym_true] = ACTIONS(166),
    [sym_false] = ACTIONS(166),
    [sym_identifier] = ACTIONS(166),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(173),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(164),
    [anon_sym_return] = ACTIONS(162),
    [anon_sym_COMMA] = ACTIONS(164),
    [anon_sym_EQ] = ACTIONS(162),
    [anon_sym_local] = ACTIONS(162),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_DOT] = ACTIONS(162),
    [anon_sym_do] = ACTIONS(162),
    [anon_sym_if] = ACTIONS(162),
    [anon_sym_while] = ACTIONS(162),
    [anon_sym_repeat] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(162),
    [anon_sym_goto] = ACTIONS(162),
    [sym_break_statement] = ACTIONS(162),
    [anon_sym_COLON_COLON] = ACTIONS(164),
    [anon_sym_SEMI] = ACTIONS(164),
    [anon_sym_function] = ACTIONS(162),
    [anon_sym_COLON] = ACTIONS(162),
    [anon_sym_LPAREN] = ACTIONS(164),
    [sym_spread] = ACTIONS(164),
    [sym_self] = ACTIONS(162),
    [sym_next] = ACTIONS(162),
    [anon_sym__G] = ACTIONS(162),
    [anon_sym__VERSION] = ACTIONS(162),
    [anon_sym_LBRACE] = ACTIONS(164),
    [anon_sym_or] = ACTIONS(162),
    [anon_sym_and] = ACTIONS(162),
    [anon_sym_LT] = ACTIONS(162),
    [anon_sym_LT_EQ] = ACTIONS(164),
    [anon_sym_EQ_EQ] = ACTIONS(164),
    [anon_sym_TILDE_EQ] = ACTIONS(164),
    [anon_sym_GT_EQ] = ACTIONS(164),
    [anon_sym_GT] = ACTIONS(162),
    [anon_sym_PIPE] = ACTIONS(164),
    [anon_sym_TILDE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_LT_LT] = ACTIONS(164),
    [anon_sym_GT_GT] = ACTIONS(164),
    [anon_sym_PLUS] = ACTIONS(164),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_STAR] = ACTIONS(164),
    [anon_sym_SLASH] = ACTIONS(162),
    [anon_sym_SLASH_SLASH] = ACTIONS(164),
    [anon_sym_PERCENT] = ACTIONS(164),
    [anon_sym_DOT_DOT] = ACTIONS(162),
    [anon_sym_CARET] = ACTIONS(164),
    [anon_sym_not] = ACTIONS(162),
    [anon_sym_POUND] = ACTIONS(164),
    [sym_number] = ACTIONS(164),
    [sym_nil] = ACTIONS(162),
    [sym_true] = ACTIONS(162),
    [sym_false] = ACTIONS(162),
    [sym_identifier] = ACTIONS(162),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(164),
  },
  [104] = {
    [anon_sym_return] = ACTIONS(162),
    [anon_sym_COMMA] = ACTIONS(164),
    [anon_sym_EQ] = ACTIONS(162),
    [anon_sym_local] = ACTIONS(162),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_DOT] = ACTIONS(162),
    [anon_sym_do] = ACTIONS(162),
    [anon_sym_end] = ACTIONS(162),
    [anon_sym_if] = ACTIONS(162),
    [anon_sym_while] = ACTIONS(162),
    [anon_sym_repeat] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(162),
    [anon_sym_goto] = ACTIONS(162),
    [sym_break_statement] = ACTIONS(162),
    [anon_sym_COLON_COLON] = ACTIONS(164),
    [anon_sym_SEMI] = ACTIONS(164),
    [anon_sym_function] = ACTIONS(162),
    [anon_sym_COLON] = ACTIONS(162),
    [anon_sym_LPAREN] = ACTIONS(164),
    [sym_spread] = ACTIONS(164),
    [sym_self] = ACTIONS(162),
    [sym_next] = ACTIONS(162),
    [anon_sym__G] = ACTIONS(162),
    [anon_sym__VERSION] = ACTIONS(162),
    [anon_sym_LBRACE] = ACTIONS(164),
    [anon_sym_or] = ACTIONS(162),
    [anon_sym_and] = ACTIONS(162),
    [anon_sym_LT] = ACTIONS(162),
    [anon_sym_LT_EQ] = ACTIONS(164),
    [anon_sym_EQ_EQ] = ACTIONS(164),
    [anon_sym_TILDE_EQ] = ACTIONS(164),
    [anon_sym_GT_EQ] = ACTIONS(164),
    [anon_sym_GT] = ACTIONS(162),
    [anon_sym_PIPE] = ACTIONS(164),
    [anon_sym_TILDE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_LT_LT] = ACTIONS(164),
    [anon_sym_GT_GT] = ACTIONS(164),
    [anon_sym_PLUS] = ACTIONS(164),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_STAR] = ACTIONS(164),
    [anon_sym_SLASH] = ACTIONS(162),
    [anon_sym_SLASH_SLASH] = ACTIONS(164),
    [anon_sym_PERCENT] = ACTIONS(164),
    [anon_sym_DOT_DOT] = ACTIONS(162),
    [anon_sym_CARET] = ACTIONS(164),
    [anon_sym_not] = ACTIONS(162),
    [anon_sym_POUND] = ACTIONS(164),
    [sym_number] = ACTIONS(164),
    [sym_nil] = ACTIONS(162),
    [sym_true] = ACTIONS(162),
    [sym_false] = ACTIONS(162),
    [sym_identifier] = ACTIONS(162),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(164),
  },
  [105] = {
    [anon_sym_return] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_local] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_do] = ACTIONS(238),
    [anon_sym_end] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(238),
    [anon_sym_repeat] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(238),
    [anon_sym_goto] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(240),
    [sym_spread] = ACTIONS(240),
    [sym_self] = ACTIONS(238),
    [sym_next] = ACTIONS(238),
    [anon_sym__G] = ACTIONS(238),
    [anon_sym__VERSION] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_TILDE_EQ] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_GT_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(240),
    [sym_number] = ACTIONS(240),
    [sym_nil] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_identifier] = ACTIONS(238),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(240),
  },
  [106] = {
    [anon_sym_return] = ACTIONS(162),
    [anon_sym_COMMA] = ACTIONS(164),
    [anon_sym_EQ] = ACTIONS(162),
    [anon_sym_local] = ACTIONS(162),
    [anon_sym_LBRACK] = ACTIONS(164),
    [anon_sym_DOT] = ACTIONS(162),
    [anon_sym_do] = ACTIONS(162),
    [anon_sym_if] = ACTIONS(162),
    [anon_sym_while] = ACTIONS(162),
    [anon_sym_repeat] = ACTIONS(162),
    [anon_sym_until] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(162),
    [anon_sym_goto] = ACTIONS(162),
    [sym_break_statement] = ACTIONS(162),
    [anon_sym_COLON_COLON] = ACTIONS(164),
    [anon_sym_SEMI] = ACTIONS(164),
    [anon_sym_function] = ACTIONS(162),
    [anon_sym_COLON] = ACTIONS(162),
    [anon_sym_LPAREN] = ACTIONS(164),
    [sym_spread] = ACTIONS(164),
    [sym_self] = ACTIONS(162),
    [sym_next] = ACTIONS(162),
    [anon_sym__G] = ACTIONS(162),
    [anon_sym__VERSION] = ACTIONS(162),
    [anon_sym_LBRACE] = ACTIONS(164),
    [anon_sym_or] = ACTIONS(162),
    [anon_sym_and] = ACTIONS(162),
    [anon_sym_LT] = ACTIONS(162),
    [anon_sym_LT_EQ] = ACTIONS(164),
    [anon_sym_EQ_EQ] = ACTIONS(164),
    [anon_sym_TILDE_EQ] = ACTIONS(164),
    [anon_sym_GT_EQ] = ACTIONS(164),
    [anon_sym_GT] = ACTIONS(162),
    [anon_sym_PIPE] = ACTIONS(164),
    [anon_sym_TILDE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_LT_LT] = ACTIONS(164),
    [anon_sym_GT_GT] = ACTIONS(164),
    [anon_sym_PLUS] = ACTIONS(164),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_STAR] = ACTIONS(164),
    [anon_sym_SLASH] = ACTIONS(162),
    [anon_sym_SLASH_SLASH] = ACTIONS(164),
    [anon_sym_PERCENT] = ACTIONS(164),
    [anon_sym_DOT_DOT] = ACTIONS(162),
    [anon_sym_CARET] = ACTIONS(164),
    [anon_sym_not] = ACTIONS(162),
    [anon_sym_POUND] = ACTIONS(164),
    [sym_number] = ACTIONS(164),
    [sym_nil] = ACTIONS(162),
    [sym_true] = ACTIONS(162),
    [sym_false] = ACTIONS(162),
    [sym_identifier] = ACTIONS(162),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(164),
  },
  [107] = {
    [sym_variable_declaration] = STATE(107),
    [sym_local_variable_declaration] = STATE(107),
    [sym__variable_declarator] = STATE(22),
    [sym_field_expression] = STATE(97),
    [sym_do_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_repeat_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_for_in_statement] = STATE(107),
    [sym_goto_statement] = STATE(107),
    [sym_label_statement] = STATE(107),
    [sym__empty_statement] = STATE(107),
    [sym_function_statement] = STATE(107),
    [sym_local_function_statement] = STATE(107),
    [sym_function_call_statement] = STATE(157),
    [sym__expression] = STATE(252),
    [sym_global_variable] = STATE(78),
    [sym__prefix] = STATE(78),
    [sym_function_definition] = STATE(234),
    [sym_table] = STATE(234),
    [sym_binary_operation] = STATE(234),
    [sym_unary_operation] = STATE(234),
    [aux_sym_program_repeat1] = STATE(107),
    [anon_sym_return] = ACTIONS(176),
    [anon_sym_local] = ACTIONS(727),
    [anon_sym_do] = ACTIONS(730),
    [anon_sym_end] = ACTIONS(176),
    [anon_sym_if] = ACTIONS(733),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_repeat] = ACTIONS(739),
    [anon_sym_for] = ACTIONS(742),
    [anon_sym_goto] = ACTIONS(745),
    [sym_break_statement] = ACTIONS(748),
    [anon_sym_COLON_COLON] = ACTIONS(751),
    [anon_sym_SEMI] = ACTIONS(754),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(760),
    [sym_spread] = ACTIONS(763),
    [sym_self] = ACTIONS(766),
    [sym_next] = ACTIONS(769),
    [anon_sym__G] = ACTIONS(772),
    [anon_sym__VERSION] = ACTIONS(772),
    [anon_sym_LBRACE] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(778),
    [anon_sym_DASH] = ACTIONS(778),
    [anon_sym_not] = ACTIONS(781),
    [anon_sym_POUND] = ACTIONS(778),
    [sym_number] = ACTIONS(763),
    [sym_nil] = ACTIONS(769),
    [sym_true] = ACTIONS(769),
    [sym_false] = ACTIONS(769),
    [sym_identifier] = ACTIONS(784),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(763),
  },
  [108] = {
    [sym_variable_declaration] = STATE(108),
    [sym_local_variable_declaration] = STATE(108),
    [sym__variable_declarator] = STATE(26),
    [sym_field_expression] = STATE(99),
    [sym_do_statement] = STATE(108),
    [sym_if_statement] = STATE(108),
    [sym_while_statement] = STATE(108),
    [sym_repeat_statement] = STATE(108),
    [sym_for_statement] = STATE(108),
    [sym_for_in_statement] = STATE(108),
    [sym_goto_statement] = STATE(108),
    [sym_label_statement] = STATE(108),
    [sym__empty_statement] = STATE(108),
    [sym_function_statement] = STATE(108),
    [sym_local_function_statement] = STATE(108),
    [sym_function_call_statement] = STATE(151),
    [sym__expression] = STATE(254),
    [sym_global_variable] = STATE(30),
    [sym__prefix] = STATE(30),
    [sym_function_definition] = STATE(244),
    [sym_table] = STATE(244),
    [sym_binary_operation] = STATE(244),
    [sym_unary_operation] = STATE(244),
    [aux_sym_program_repeat1] = STATE(108),
    [ts_builtin_sym_end] = ACTIONS(787),
    [anon_sym_return] = ACTIONS(176),
    [anon_sym_local] = ACTIONS(789),
    [anon_sym_do] = ACTIONS(792),
    [anon_sym_if] = ACTIONS(795),
    [anon_sym_while] = ACTIONS(798),
    [anon_sym_repeat] = ACTIONS(801),
    [anon_sym_for] = ACTIONS(804),
    [anon_sym_goto] = ACTIONS(807),
    [sym_break_statement] = ACTIONS(810),
    [anon_sym_COLON_COLON] = ACTIONS(813),
    [anon_sym_SEMI] = ACTIONS(816),
    [anon_sym_function] = ACTIONS(819),
    [anon_sym_LPAREN] = ACTIONS(822),
    [sym_spread] = ACTIONS(825),
    [sym_self] = ACTIONS(828),
    [sym_next] = ACTIONS(831),
    [anon_sym__G] = ACTIONS(834),
    [anon_sym__VERSION] = ACTIONS(834),
    [anon_sym_LBRACE] = ACTIONS(837),
    [anon_sym_TILDE] = ACTIONS(840),
    [anon_sym_DASH] = ACTIONS(840),
    [anon_sym_not] = ACTIONS(843),
    [anon_sym_POUND] = ACTIONS(840),
    [sym_number] = ACTIONS(825),
    [sym_nil] = ACTIONS(831),
    [sym_true] = ACTIONS(831),
    [sym_false] = ACTIONS(831),
    [sym_identifier] = ACTIONS(846),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(825),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(166),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(166),
    [anon_sym_while] = ACTIONS(166),
    [anon_sym_repeat] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(166),
    [anon_sym_goto] = ACTIONS(166),
    [sym_break_statement] = ACTIONS(166),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [anon_sym_SEMI] = ACTIONS(173),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(173),
    [sym_spread] = ACTIONS(173),
    [sym_self] = ACTIONS(166),
    [sym_next] = ACTIONS(166),
    [anon_sym__G] = ACTIONS(166),
    [anon_sym__VERSION] = ACTIONS(166),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_or] = ACTIONS(166),
    [anon_sym_and] = ACTIONS(166),
    [anon_sym_LT] = ACTIONS(166),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_TILDE_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(166),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_TILDE] = ACTIONS(166),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(166),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_PERCENT] = ACTIONS(173),
    [anon_sym_DOT_DOT] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_not] = ACTIONS(166),
    [anon_sym_POUND] = ACTIONS(173),
    [sym_number] = ACTIONS(173),
    [sym_nil] = ACTIONS(166),
    [sym_true] = ACTIONS(166),
    [sym_false] = ACTIONS(166),
    [sym_identifier] = ACTIONS(166),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(173),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(240),
    [anon_sym_return] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_local] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_do] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(238),
    [anon_sym_repeat] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(238),
    [anon_sym_goto] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(240),
    [sym_spread] = ACTIONS(240),
    [sym_self] = ACTIONS(238),
    [sym_next] = ACTIONS(238),
    [anon_sym__G] = ACTIONS(238),
    [anon_sym__VERSION] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_TILDE_EQ] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_GT_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(240),
    [sym_number] = ACTIONS(240),
    [sym_nil] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_identifier] = ACTIONS(238),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(240),
  },
  [111] = {
    [anon_sym_return] = ACTIONS(166),
    [anon_sym_COMMA] = ACTIONS(169),
    [anon_sym_EQ] = ACTIONS(171),
    [anon_sym_local] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(169),
    [anon_sym_DOT] = ACTIONS(171),
    [anon_sym_do] = ACTIONS(166),
    [anon_sym_end] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(166),
    [anon_sym_while] = ACTIONS(166),
    [anon_sym_repeat] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(166),
    [anon_sym_goto] = ACTIONS(166),
    [sym_break_statement] = ACTIONS(166),
    [anon_sym_COLON_COLON] = ACTIONS(173),
    [anon_sym_SEMI] = ACTIONS(173),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_COLON] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(173),
    [sym_spread] = ACTIONS(173),
    [sym_self] = ACTIONS(166),
    [sym_next] = ACTIONS(166),
    [anon_sym__G] = ACTIONS(166),
    [anon_sym__VERSION] = ACTIONS(166),
    [anon_sym_LBRACE] = ACTIONS(173),
    [anon_sym_or] = ACTIONS(166),
    [anon_sym_and] = ACTIONS(166),
    [anon_sym_LT] = ACTIONS(166),
    [anon_sym_LT_EQ] = ACTIONS(173),
    [anon_sym_EQ_EQ] = ACTIONS(173),
    [anon_sym_TILDE_EQ] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_GT] = ACTIONS(166),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_TILDE] = ACTIONS(166),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_LT_LT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_STAR] = ACTIONS(173),
    [anon_sym_SLASH] = ACTIONS(166),
    [anon_sym_SLASH_SLASH] = ACTIONS(173),
    [anon_sym_PERCENT] = ACTIONS(173),
    [anon_sym_DOT_DOT] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_not] = ACTIONS(166),
    [anon_sym_POUND] = ACTIONS(173),
    [sym_number] = ACTIONS(173),
    [sym_nil] = ACTIONS(166),
    [sym_true] = ACTIONS(166),
    [sym_false] = ACTIONS(166),
    [sym_identifier] = ACTIONS(166),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(173),
  },
  [112] = {
    [anon_sym_return] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(238),
    [anon_sym_local] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_do] = ACTIONS(238),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_while] = ACTIONS(238),
    [anon_sym_repeat] = ACTIONS(238),
    [anon_sym_until] = ACTIONS(238),
    [anon_sym_for] = ACTIONS(238),
    [anon_sym_goto] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(240),
    [sym_spread] = ACTIONS(240),
    [sym_self] = ACTIONS(238),
    [sym_next] = ACTIONS(238),
    [anon_sym__G] = ACTIONS(238),
    [anon_sym__VERSION] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(238),
    [anon_sym_and] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_TILDE_EQ] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_GT_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(238),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(238),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(240),
    [sym_number] = ACTIONS(240),
    [sym_nil] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_identifier] = ACTIONS(238),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(240),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      anon_sym_COMMA,
    ACTIONS(855), 1,
      anon_sym_or,
    ACTIONS(857), 1,
      anon_sym_and,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    STATE(319), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(859), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(861), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(853), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(849), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [91] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(171), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(173), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(166), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(370), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [217] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(647), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(659), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(532), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [400] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(607), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [461] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(374), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [522] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      anon_sym_COMMA,
    ACTIONS(855), 1,
      anon_sym_or,
    ACTIONS(857), 1,
      anon_sym_and,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    STATE(315), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(859), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(861), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(883), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(881), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(309), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(370), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(309), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(659), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [857] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      anon_sym_COMMA,
    ACTIONS(855), 1,
      anon_sym_or,
    ACTIONS(857), 1,
      anon_sym_and,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    STATE(316), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(859), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(861), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(887), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(607), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(329), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(356), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(374), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1192] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(171), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(173), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(166), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(374), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(309), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(370), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(647), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(329), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1562] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(356), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(366), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(659), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(329), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1806] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(356), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1867] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(171), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(173), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(166), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(532), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [1993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(532), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 25,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(366), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(366), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(607), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2237] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 24,
      sym_string,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(647), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      anon_sym_COLON,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2298] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2360] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 19,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2426] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(154), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(665), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(160), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(663), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2490] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(895), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2552] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(135), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2672] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2734] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2804] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(154), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(665), 9,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(160), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(663), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2928] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [2998] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3076] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(859), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(861), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3158] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 15,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3230] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3304] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3380] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 1,
      anon_sym_or,
    ACTIONS(857), 1,
      anon_sym_and,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(859), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(861), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3526] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 1,
      anon_sym_and,
    ACTIONS(863), 1,
      anon_sym_PIPE,
    ACTIONS(865), 1,
      anon_sym_TILDE,
    ACTIONS(867), 1,
      anon_sym_AMP,
    ACTIONS(875), 1,
      anon_sym_SLASH,
    ACTIONS(877), 1,
      anon_sym_DOT_DOT,
    ACTIONS(879), 1,
      anon_sym_CARET,
    ACTIONS(859), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(869), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(873), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(861), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3610] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(154), 8,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
    ACTIONS(665), 9,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(160), 14,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
    ACTIONS(663), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3734] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_or,
    ACTIONS(921), 1,
      anon_sym_and,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    STATE(351), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(923), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(925), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(853), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(849), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3823] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 1,
      anon_sym_or,
    ACTIONS(951), 1,
      anon_sym_and,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(953), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(947), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(945), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3908] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_COMMA,
    ACTIONS(977), 1,
      anon_sym_or,
    ACTIONS(979), 1,
      anon_sym_and,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    STATE(384), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(981), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(983), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(853), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(849), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [3997] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(891), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4058] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_COMMA,
    ACTIONS(977), 1,
      anon_sym_or,
    ACTIONS(979), 1,
      anon_sym_and,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    STATE(383), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(981), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(983), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(887), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4147] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_or,
    ACTIONS(921), 1,
      anon_sym_and,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    STATE(394), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(923), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(925), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(887), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4236] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4305] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(891), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4366] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 1,
      anon_sym_or,
    ACTIONS(951), 1,
      anon_sym_and,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(953), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1005), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1003), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4451] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_or,
    ACTIONS(921), 1,
      anon_sym_and,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    STATE(392), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(923), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(925), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(883), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(881), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4540] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 1,
      anon_sym_or,
    ACTIONS(951), 1,
      anon_sym_and,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(953), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1009), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1007), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4625] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 1,
      anon_sym_or,
    ACTIONS(951), 1,
      anon_sym_and,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(953), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1013), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1011), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4710] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 1,
      anon_sym_and,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(953), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4793] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_COMMA,
    ACTIONS(977), 1,
      anon_sym_or,
    ACTIONS(979), 1,
      anon_sym_and,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    STATE(386), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(981), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(983), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(883), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(881), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4882] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(895), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 29,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [4943] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(953), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(955), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5024] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 1,
      anon_sym_PIPE,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 12,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5101] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(959), 1,
      anon_sym_TILDE,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5176] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 1,
      anon_sym_AMP,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5249] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    ACTIONS(1017), 1,
      anon_sym_or,
    ACTIONS(1019), 1,
      anon_sym_and,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    STATE(385), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1021), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(883), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(881), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5338] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(963), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5409] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(971), 1,
      anon_sym_DOT_DOT,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(965), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5478] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    ACTIONS(1017), 1,
      anon_sym_or,
    ACTIONS(1019), 1,
      anon_sym_and,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    STATE(390), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1021), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(853), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(849), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5567] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    ACTIONS(1017), 1,
      anon_sym_or,
    ACTIONS(1019), 1,
      anon_sym_and,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    STATE(393), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1021), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(887), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5656] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 1,
      anon_sym_SLASH,
    ACTIONS(973), 1,
      anon_sym_CARET,
    ACTIONS(967), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 18,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 28,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5721] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 18,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5789] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_and,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1021), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(135), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5929] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(891), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [5989] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 18,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6057] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(891), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6117] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 20,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6181] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6249] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6319] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 15,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6391] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 15,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6465] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6541] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6599] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(923), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(925), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6679] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 1,
      anon_sym_and,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(923), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(925), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [6935] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      anon_sym_or,
    ACTIONS(979), 1,
      anon_sym_and,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(981), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(983), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7019] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7079] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 19,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7143] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7211] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 15,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7281] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(895), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7341] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(895), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7401] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7473] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7605] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7681] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(981), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(983), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7761] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(895), 23,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [7995] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8055] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(903), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(901), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8181] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8241] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 19,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(135), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8421] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8489] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_or,
    ACTIONS(1019), 1,
      anon_sym_and,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1021), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8573] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1021), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1023), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8653] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 1,
      anon_sym_and,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_TILDE,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(997), 1,
      anon_sym_SLASH,
    ACTIONS(999), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(981), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(991), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(993), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(995), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(983), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8735] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_PIPE,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8811] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [8929] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_TILDE,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 24,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(135), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9061] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_or,
    ACTIONS(921), 1,
      anon_sym_and,
    ACTIONS(927), 1,
      anon_sym_PIPE,
    ACTIONS(929), 1,
      anon_sym_TILDE,
    ACTIONS(931), 1,
      anon_sym_AMP,
    ACTIONS(939), 1,
      anon_sym_SLASH,
    ACTIONS(941), 1,
      anon_sym_DOT_DOT,
    ACTIONS(943), 1,
      anon_sym_CARET,
    ACTIONS(923), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(933), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(935), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(937), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(925), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 10,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9145] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 23,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9203] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_AMP,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9275] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_SLASH,
    ACTIONS(1039), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1041), 1,
      anon_sym_CARET,
    ACTIONS(1031), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1033), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1035), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 15,
      sym_string,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9345] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9412] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(895), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9471] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9530] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1055), 1,
      anon_sym_or,
    ACTIONS(1057), 1,
      anon_sym_and,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1059), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1061), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1005), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1003), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9613] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 19,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9676] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1079), 1,
      anon_sym_or,
    ACTIONS(1081), 1,
      anon_sym_and,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1083), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1085), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1005), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1003), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9759] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 1,
      anon_sym_or,
    ACTIONS(1097), 1,
      anon_sym_and,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1099), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1101), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(947), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(945), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9842] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1079), 1,
      anon_sym_or,
    ACTIONS(1081), 1,
      anon_sym_and,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1083), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1085), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1013), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1011), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9925] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(895), 22,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [9984] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_and,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1099), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1101), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10065] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 1,
      anon_sym_or,
    ACTIONS(1097), 1,
      anon_sym_and,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1099), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1101), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1013), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1011), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10148] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10215] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(891), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10274] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10341] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(891), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10400] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 18,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10463] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10530] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10599] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10670] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10743] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 18,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10806] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(891), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10865] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 12,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [10940] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1059), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1061), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11019] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1057), 1,
      anon_sym_and,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1059), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1061), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11100] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1055), 1,
      anon_sym_or,
    ACTIONS(1057), 1,
      anon_sym_and,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1059), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1061), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1009), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1007), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11183] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1055), 1,
      anon_sym_or,
    ACTIONS(1057), 1,
      anon_sym_and,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1059), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1061), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1013), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1011), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11266] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 1,
      anon_sym_or,
    ACTIONS(1097), 1,
      anon_sym_and,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1099), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1101), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1009), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1007), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11349] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1079), 1,
      anon_sym_or,
    ACTIONS(1081), 1,
      anon_sym_and,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1083), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1085), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1009), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1007), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11432] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 16,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11499] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(895), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(893), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11558] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(891), 21,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 27,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11617] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 1,
      anon_sym_or,
    ACTIONS(1097), 1,
      anon_sym_and,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1099), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1101), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1005), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1003), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11700] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1081), 1,
      anon_sym_and,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1083), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1085), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11781] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1083), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1085), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11860] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [11935] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12008] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12079] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12146] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 14,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12215] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12286] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_CARET,
    ACTIONS(1055), 1,
      anon_sym_or,
    ACTIONS(1057), 1,
      anon_sym_and,
    ACTIONS(1063), 1,
      anon_sym_PIPE,
    ACTIONS(1065), 1,
      anon_sym_TILDE,
    ACTIONS(1067), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_SLASH,
    ACTIONS(1077), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1059), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1069), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1071), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1073), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1061), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(947), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(945), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12369] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 13,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12442] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1079), 1,
      anon_sym_or,
    ACTIONS(1081), 1,
      anon_sym_and,
    ACTIONS(1087), 1,
      anon_sym_PIPE,
    ACTIONS(1089), 1,
      anon_sym_TILDE,
    ACTIONS(1091), 1,
      anon_sym_AMP,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1083), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1085), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(947), 9,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(945), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12525] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 12,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12600] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(891), 22,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 26,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12659] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_SLASH,
    ACTIONS(1049), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1051), 1,
      anon_sym_CARET,
    ACTIONS(1043), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 15,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12728] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_PIPE,
    ACTIONS(1105), 1,
      anon_sym_TILDE,
    ACTIONS(1107), 1,
      anon_sym_AMP,
    ACTIONS(1115), 1,
      anon_sym_SLASH,
    ACTIONS(1117), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1119), 1,
      anon_sym_CARET,
    ACTIONS(1099), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1109), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1111), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1113), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1101), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 8,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_number,
    ACTIONS(889), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_or,
      anon_sym_and,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [12807] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_LBRACK,
    ACTIONS(1123), 1,
      anon_sym_DOT,
    ACTIONS(1125), 1,
      anon_sym_COLON,
    ACTIONS(1127), 1,
      anon_sym_LPAREN,
    ACTIONS(1129), 1,
      anon_sym_LBRACE,
    ACTIONS(1131), 1,
      sym_string,
    STATE(305), 1,
      sym_arguments,
    STATE(306), 1,
      sym_table,
    ACTIONS(135), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(137), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [12872] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(366), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(368), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [12919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(534), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [12966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(311), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13013] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(240), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(356), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(358), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(609), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13154] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(166), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(169), 5,
      sym_string,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
    ACTIONS(173), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(649), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(659), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(661), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(372), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(376), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(169), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(162), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(164), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 6,
      anon_sym_DOT,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(331), 33,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [13534] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1138), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13581] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 1,
      anon_sym_COMMA,
    STATE(314), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1144), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1140), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13628] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1148), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1146), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13675] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(887), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13721] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1152), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1150), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 12,
      sym_string,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13809] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1154), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(907), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13855] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 1,
      anon_sym_COMMA,
    STATE(318), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1159), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1157), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13901] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    STATE(320), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1138), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [13946] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(889), 3,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 17,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [14005] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      anon_sym_SEMI,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(417), 1,
      sym__expression,
    STATE(719), 1,
      sym__empty_statement,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1182), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [14076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(903), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(899), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(372), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14199] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(893), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(895), 27,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [14242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(911), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14283] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 1,
      anon_sym_COMMA,
    STATE(328), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1138), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14328] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_COMMA,
    STATE(329), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1138), 12,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14373] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      anon_sym_COMMA,
    STATE(339), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1144), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1140), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14418] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(889), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(891), 27,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [14461] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(889), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(891), 27,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
  [14504] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(889), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(891), 19,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
  [14557] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(889), 3,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(891), 18,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [14614] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      anon_sym_COMMA,
    STATE(342), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1144), 12,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1140), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14659] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 1,
      anon_sym_else,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
  [14722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(137), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [14763] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 1,
      anon_sym_COMMA,
    STATE(349), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1144), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1140), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14808] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      anon_sym_COMMA,
    STATE(328), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1148), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1146), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [14853] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(889), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(891), 18,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
  [14908] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(889), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(891), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [14959] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      anon_sym_COMMA,
    STATE(329), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1148), 12,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1146), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15004] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1224), 1,
      anon_sym_EQ,
    ACTIONS(1226), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1222), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15047] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 1,
      anon_sym_else,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(891), 12,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
  [15112] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(889), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(891), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [15163] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(889), 4,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
    ACTIONS(891), 24,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DOT,
  [15210] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(376), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [15251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 5,
      anon_sym_else,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(915), 28,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_do,
      anon_sym_end,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [15292] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1220), 1,
      anon_sym_COMMA,
    STATE(320), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1148), 11,
      sym_string,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1146), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15337] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15377] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    STATE(353), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1159), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1157), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1230), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15461] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 1,
      anon_sym_COMMA,
    STATE(353), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(907), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15505] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 12,
      sym_string,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1237), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1243), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1241), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1247), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1245), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1251), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1249), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1253), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1259), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1257), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15865] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1263), 1,
      anon_sym_RBRACE,
    ACTIONS(1265), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(723), 1,
      sym_field,
    STATE(850), 1,
      sym__field_sequence,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [15937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1269), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1267), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [15977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1273), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1271), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1275), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1279), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1283), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1287), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1291), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16217] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1295), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(723), 1,
      sym_field,
    STATE(837), 1,
      sym__field_sequence,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [16289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16329] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1301), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(723), 1,
      sym_field,
    STATE(856), 1,
      sym__field_sequence,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [16401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1303), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1307), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1311), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1317), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1315), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 13,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16601] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1319), 1,
      anon_sym_COMMA,
    STATE(379), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(907), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 12,
      sym_string,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1133), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16685] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1322), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(723), 1,
      sym_field,
    STATE(843), 1,
      sym__field_sequence,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [16757] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1324), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(723), 1,
      sym_field,
    STATE(860), 1,
      sym__field_sequence,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [16829] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_COMMA,
    STATE(379), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1152), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1150), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16873] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_COMMA,
    STATE(379), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1159), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1157), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16917] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    STATE(387), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(887), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [16961] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_COMMA,
    STATE(379), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(887), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17005] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      anon_sym_COMMA,
    STATE(387), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(907), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(905), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1329), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17089] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1333), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(723), 1,
      sym_field,
    STATE(804), 1,
      sym__field_sequence,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17161] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    STATE(387), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1159), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1157), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17245] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    STATE(353), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(887), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(885), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17289] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    STATE(387), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1152), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1150), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17333] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    STATE(353), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1152), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1150), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17377] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1339), 1,
      anon_sym_EQ,
    ACTIONS(1226), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1222), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17418] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1341), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(733), 1,
      sym_field,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17487] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      anon_sym_SEMI,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    ACTIONS(1343), 1,
      ts_builtin_sym_end,
    STATE(309), 1,
      sym_field_expression,
    STATE(417), 1,
      sym__expression,
    STATE(719), 1,
      sym__empty_statement,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17556] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 1,
      anon_sym_DOT,
    ACTIONS(1345), 1,
      anon_sym_EQ,
    ACTIONS(166), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(169), 5,
      sym_string,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
    ACTIONS(173), 20,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [17601] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 1,
      anon_sym_end,
    ACTIONS(1184), 1,
      anon_sym_SEMI,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(417), 1,
      sym__expression,
    STATE(719), 1,
      sym__empty_statement,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17670] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 1,
      anon_sym_until,
    ACTIONS(1184), 1,
      anon_sym_SEMI,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(417), 1,
      sym__expression,
    STATE(719), 1,
      sym__empty_statement,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17739] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1347), 1,
      anon_sym_EQ,
    ACTIONS(1226), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1222), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17780] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_EQ,
    ACTIONS(1226), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1222), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17821] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1351), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(733), 1,
      sym_field,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [17890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1243), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1241), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1251), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1249), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [17966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1287), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1291), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1253), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18080] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1269), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1267), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18118] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1259), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1257), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1230), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1237), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1243), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1241), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1311), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1283), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18384] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1357), 1,
      anon_sym_else,
    ACTIONS(1359), 1,
      anon_sym_SEMI,
    ACTIONS(1361), 1,
      anon_sym_or,
    STATE(688), 1,
      aux_sym_return_statement_repeat1,
    STATE(720), 1,
      sym__empty_statement,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1353), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [18456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1273), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1271), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1275), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1279), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1303), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1307), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1317), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1315), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1329), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1251), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1249), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18760] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1247), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1245), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1317), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1315), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1283), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1259), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1257), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1275), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [18988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1363), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19026] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19064] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_else,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(907), 8,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_do,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [19128] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1253), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19166] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1273), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1271), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1279), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1287), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19356] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19394] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1291), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1367), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19546] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1247), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1245), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1371), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19622] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1311), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19698] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1243), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1241), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19736] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1237), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1230), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1259), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1257), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1269), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1267), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1329), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [19964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1307), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1303), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1291), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1287), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20116] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(909), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1279), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20192] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1275), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1303), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1273), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1271), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(897), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(913), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1253), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1375), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20458] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1247), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1245), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1297), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1283), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1237), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1317), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1315), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1251), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1249), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1232), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1230), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20724] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1335), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20762] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1311), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1269), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1267), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 10,
      sym_string,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1379), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20876] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1307), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [20914] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1261), 1,
      anon_sym_LBRACK,
    ACTIONS(1265), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(660), 1,
      sym__expression,
    STATE(733), 1,
      sym_field,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [20980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 11,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_spread,
      anon_sym_LBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
      sym_number,
    ACTIONS(1329), 19,
      anon_sym_return,
      anon_sym_local,
      anon_sym_do,
      anon_sym_if,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_for,
      anon_sym_goto,
      sym_break_statement,
      anon_sym_function,
      sym_self,
      sym_next,
      anon_sym__G,
      anon_sym__VERSION,
      anon_sym_not,
      sym_nil,
      sym_true,
      sym_false,
      sym_identifier,
  [21018] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    ACTIONS(1383), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(655), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21081] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    ACTIONS(1385), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(662), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21144] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    ACTIONS(1387), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(654), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21207] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    ACTIONS(1389), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(657), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21270] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    ACTIONS(1391), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_field_expression,
    STATE(661), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21333] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(256), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21393] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(249), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21453] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(676), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21513] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(174), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21573] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(275), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21633] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(172), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21693] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(245), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21753] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(331), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21813] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(341), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21873] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(332), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21933] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(334), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [21993] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(345), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22053] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(333), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22113] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(340), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22173] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(321), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22233] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(336), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22293] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(344), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22353] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(183), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22413] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(274), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22473] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(326), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22533] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(682), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22593] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(671), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22653] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(673), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22713] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(666), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22773] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(667), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22833] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(668), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22893] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(184), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [22953] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(670), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23013] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(665), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23073] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(675), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23133] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(209), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23193] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(208), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23253] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(206), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23313] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(205), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23373] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(204), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23433] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(203), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23493] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(195), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23553] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(201), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23613] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(200), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23673] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(199), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23733] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(198), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23793] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(684), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23853] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(680), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23913] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(664), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [23973] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(656), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24033] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(683), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24093] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(672), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24153] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(679), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24213] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(685), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24273] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(669), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24333] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(257), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24393] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(279), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24453] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(663), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24513] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(346), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24573] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(261), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24633] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(277), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24693] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(268), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24753] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(165), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24813] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(262), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24873] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(263), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24933] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(171), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [24993] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(126), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25053] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(181), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25113] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(113), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25173] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(239), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25233] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(224), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25293] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(223), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25353] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(221), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25413] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(220), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25473] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(217), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25533] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(216), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25593] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(215), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25653] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(214), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25713] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(202), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25773] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(241), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25833] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(290), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25893] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(121), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [25953] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(180), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26013] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(678), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26073] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(237), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26133] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(282), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26193] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(283), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26253] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(284), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26313] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(285), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26373] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(286), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26433] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(250), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26493] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(295), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26553] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(152), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26613] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(273), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26673] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(272), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26733] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(271), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26793] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(182), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26853] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(185), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26913] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(186), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [26973] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(187), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27033] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(188), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27093] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(190), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27153] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(191), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27213] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(194), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27273] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(177), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27333] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(176), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27393] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(93), 1,
      anon_sym_not,
    ACTIONS(95), 1,
      sym_identifier,
    ACTIONS(1409), 1,
      anon_sym_function,
    STATE(17), 1,
      sym_field_expression,
    STATE(173), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(91), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27453] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(264), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27513] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(287), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27573] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(267), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27633] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(653), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27693] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(218), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27753] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(253), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27813] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(292), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27873] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(219), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27933] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(266), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [27993] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(255), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28053] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(193), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28113] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(259), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28173] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(280), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28233] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(278), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28293] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(681), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28353] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(196), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28413] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(238), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28473] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(240), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28533] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(243), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28593] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(247), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28653] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(248), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28713] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(236), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28773] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(233), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28833] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(232), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28893] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(230), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [28953] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(229), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29013] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(192), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29073] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(270), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29133] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(269), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29193] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1411), 1,
      anon_sym_function,
    ACTIONS(1421), 1,
      anon_sym_not,
    ACTIONS(1423), 1,
      sym_identifier,
    STATE(101), 1,
      sym_field_expression,
    STATE(189), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1419), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29253] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(276), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29313] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(260), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29373] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(251), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29433] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_not,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(1393), 1,
      anon_sym_function,
    STATE(99), 1,
      sym_field_expression,
    STATE(294), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(43), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29493] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(179), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29553] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(677), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29613] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(175), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29673] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_not,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(1395), 1,
      anon_sym_function,
    STATE(97), 1,
      sym_field_expression,
    STATE(265), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(280), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29733] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(434), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29793] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_LPAREN,
    ACTIONS(272), 1,
      sym_self,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1395), 1,
      anon_sym_function,
    ACTIONS(1399), 1,
      anon_sym_not,
    ACTIONS(1401), 1,
      sym_identifier,
    STATE(97), 1,
      sym_field_expression,
    STATE(213), 1,
      sym__expression,
    ACTIONS(276), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(270), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1397), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(274), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(78), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(234), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29853] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(658), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29913] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(167), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [29973] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(161), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30033] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(160), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30093] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(164), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30153] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(163), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30213] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(162), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30273] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(159), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30333] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(150), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30393] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(149), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30453] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(156), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30513] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      sym_self,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_function,
    ACTIONS(1415), 1,
      anon_sym_not,
    ACTIONS(1417), 1,
      sym_identifier,
    STATE(17), 1,
      sym_field_expression,
    STATE(155), 1,
      sym__expression,
    ACTIONS(87), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(81), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1413), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(85), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(12), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(153), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30573] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(258), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30633] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(225), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30693] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(288), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30753] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_self,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1393), 1,
      anon_sym_function,
    ACTIONS(1405), 1,
      anon_sym_not,
    ACTIONS(1407), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(170), 1,
      sym__expression,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(33), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1403), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(37), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(30), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(244), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30813] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(296), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30873] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(293), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30933] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(674), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [30993] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(289), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31053] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_LPAREN,
    ACTIONS(430), 1,
      sym_self,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(440), 1,
      anon_sym_not,
    ACTIONS(442), 1,
      sym_identifier,
    ACTIONS(1411), 1,
      anon_sym_function,
    STATE(101), 1,
      sym_field_expression,
    STATE(291), 1,
      sym__expression,
    ACTIONS(434), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(428), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(438), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(432), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(21), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(197), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31113] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_function,
    ACTIONS(1188), 1,
      anon_sym_LPAREN,
    ACTIONS(1192), 1,
      sym_self,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1202), 1,
      anon_sym_not,
    ACTIONS(1204), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_expression,
    STATE(659), 1,
      sym__expression,
    ACTIONS(1196), 2,
      anon_sym__G,
      anon_sym__VERSION,
    ACTIONS(1190), 3,
      sym_string,
      sym_spread,
      sym_number,
    ACTIONS(1200), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    ACTIONS(1194), 4,
      sym_next,
      sym_nil,
      sym_true,
      sym_false,
    STATE(297), 4,
      sym__variable_declarator,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
    STATE(337), 4,
      sym_function_definition,
      sym_table,
      sym_binary_operation,
      sym_unary_operation,
  [31173] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1425), 1,
      anon_sym_do,
    STATE(745), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31233] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1427), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31293] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1429), 1,
      anon_sym_RPAREN,
    STATE(763), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31353] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1431), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31409] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1433), 1,
      anon_sym_RPAREN,
    STATE(767), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31469] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1435), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31525] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1437), 1,
      anon_sym_do,
    STATE(753), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31585] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1439), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31641] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
    STATE(764), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31701] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1443), 1,
      anon_sym_RPAREN,
    STATE(755), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31761] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1445), 1,
      anon_sym_COMMA,
    ACTIONS(1447), 1,
      anon_sym_do,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31818] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1449), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31872] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1451), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31926] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1453), 1,
      anon_sym_then,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [31980] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1455), 1,
      anon_sym_do,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32034] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1457), 1,
      anon_sym_then,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32088] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1459), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32142] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1461), 1,
      anon_sym_RBRACK,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32196] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1463), 1,
      anon_sym_do,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32250] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1465), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32304] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1467), 1,
      anon_sym_do,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32358] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1469), 1,
      anon_sym_COMMA,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32412] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1471), 1,
      anon_sym_RBRACK,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32466] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1473), 1,
      anon_sym_do,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32520] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1475), 1,
      anon_sym_RBRACK,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32574] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1477), 1,
      anon_sym_RBRACK,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32628] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1479), 1,
      anon_sym_then,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32682] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1481), 1,
      anon_sym_RBRACK,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32736] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1483), 1,
      anon_sym_then,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32790] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1485), 1,
      anon_sym_then,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32844] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1487), 1,
      anon_sym_RBRACK,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32898] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1489), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [32952] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1166), 1,
      anon_sym_TILDE,
    ACTIONS(1168), 1,
      anon_sym_AMP,
    ACTIONS(1176), 1,
      anon_sym_SLASH,
    ACTIONS(1178), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1180), 1,
      anon_sym_CARET,
    ACTIONS(1228), 1,
      anon_sym_and,
    ACTIONS(1361), 1,
      anon_sym_or,
    ACTIONS(1491), 1,
      anon_sym_do,
    ACTIONS(1170), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1172), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1216), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1174), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1218), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33006] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 1,
      anon_sym_else,
    ACTIONS(1493), 1,
      anon_sym_COMMA,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(907), 7,
      ts_builtin_sym_end,
      anon_sym_do,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [33028] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(1496), 1,
      sym_self,
    ACTIONS(1498), 1,
      sym_identifier,
    STATE(99), 1,
      sym_field_expression,
    STATE(689), 1,
      sym__variable_declarator,
    ACTIONS(39), 2,
      anon_sym__G,
      anon_sym__VERSION,
    STATE(690), 3,
      sym_function_call_statement,
      sym_global_variable,
      sym__prefix,
  [33056] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1502), 1,
      anon_sym_else,
    ACTIONS(1504), 1,
      anon_sym_SEMI,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
    STATE(716), 1,
      sym__empty_statement,
    ACTIONS(1500), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [33081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1506), 2,
      anon_sym_COMMA,
      anon_sym_EQ,
    ACTIONS(160), 6,
      sym_string,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [33097] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(335), 1,
      anon_sym_LBRACK,
    ACTIONS(1508), 1,
      anon_sym_DOT,
    ACTIONS(1510), 1,
      anon_sym_COLON,
    ACTIONS(1512), 1,
      anon_sym_LPAREN,
    ACTIONS(1514), 1,
      sym_string,
    STATE(116), 1,
      sym_arguments,
    STATE(117), 1,
      sym_table,
  [33125] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1516), 1,
      anon_sym_end,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    STATE(784), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33145] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym_identifier,
    STATE(84), 1,
      sym_parameters,
    STATE(158), 1,
      sym__function_body,
    STATE(773), 1,
      sym_function_name,
    STATE(774), 1,
      sym_function_name_field,
  [33167] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1524), 1,
      anon_sym_end,
    STATE(788), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33187] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1526), 1,
      anon_sym_end,
    STATE(887), 1,
      sym_else,
    STATE(697), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33207] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1528), 1,
      anon_sym_end,
    STATE(794), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33227] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1516), 1,
      anon_sym_end,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    STATE(784), 1,
      sym_else,
    STATE(693), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33247] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1530), 1,
      anon_sym_end,
    STATE(901), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33267] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1526), 1,
      anon_sym_end,
    STATE(887), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33287] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1532), 1,
      anon_sym_end,
    STATE(830), 1,
      sym_else,
    STATE(710), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33307] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym_identifier,
    STATE(45), 1,
      sym_parameters,
    STATE(227), 1,
      sym__function_body,
    STATE(751), 1,
      sym_function_name,
    STATE(774), 1,
      sym_function_name_field,
  [33329] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1532), 1,
      anon_sym_end,
    STATE(830), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33349] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1534), 1,
      anon_sym_end,
    STATE(838), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33369] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym_identifier,
    STATE(61), 1,
      sym_parameters,
    STATE(231), 1,
      sym__function_body,
    STATE(756), 1,
      sym_function_name,
    STATE(774), 1,
      sym_function_name_field,
  [33391] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1536), 1,
      anon_sym_end,
    STATE(789), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33411] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1538), 1,
      anon_sym_end,
    STATE(820), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33431] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1538), 1,
      anon_sym_end,
    STATE(820), 1,
      sym_else,
    STATE(711), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33451] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    ACTIONS(1522), 1,
      sym_identifier,
    STATE(54), 1,
      sym_parameters,
    STATE(211), 1,
      sym__function_body,
    STATE(770), 1,
      sym_function_name,
    STATE(774), 1,
      sym_function_name_field,
  [33473] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1528), 1,
      anon_sym_end,
    STATE(794), 1,
      sym_else,
    STATE(705), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33493] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1524), 1,
      anon_sym_end,
    STATE(788), 1,
      sym_else,
    STATE(704), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33513] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1540), 1,
      anon_sym_end,
    STATE(836), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33533] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1542), 1,
      anon_sym_end,
    STATE(829), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33553] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1544), 1,
      anon_sym_end,
    STATE(807), 1,
      sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33573] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1540), 1,
      anon_sym_end,
    STATE(836), 1,
      sym_else,
    STATE(702), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33593] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(61), 1,
      anon_sym_else,
    ACTIONS(1518), 1,
      anon_sym_elseif,
    ACTIONS(1544), 1,
      anon_sym_end,
    STATE(807), 1,
      sym_else,
    STATE(698), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33613] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACE,
    ACTIONS(1546), 1,
      anon_sym_LPAREN,
    ACTIONS(1548), 1,
      sym_string,
    STATE(28), 1,
      sym_arguments,
    STATE(96), 1,
      sym_table,
  [33632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1552), 1,
      anon_sym_else,
    ACTIONS(1550), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [33645] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_RBRACE,
    STATE(396), 1,
      sym__field_sep,
    STATE(721), 1,
      aux_sym__field_sequence_repeat1,
    ACTIONS(1554), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [33662] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 1,
      anon_sym_LPAREN,
    ACTIONS(1129), 1,
      anon_sym_LBRACE,
    ACTIONS(1131), 1,
      sym_string,
    STATE(306), 1,
      sym_table,
    STATE(311), 1,
      sym_arguments,
  [33681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 1,
      anon_sym_else,
    ACTIONS(1353), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [33694] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1502), 1,
      anon_sym_else,
    ACTIONS(1500), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [33707] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1559), 1,
      anon_sym_RBRACE,
    STATE(482), 1,
      sym__field_sep,
    STATE(721), 1,
      aux_sym__field_sequence_repeat1,
    ACTIONS(1556), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [33724] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1561), 1,
      anon_sym_end,
    ACTIONS(1563), 1,
      anon_sym_elseif,
    ACTIONS(1566), 1,
      anon_sym_else,
    STATE(722), 2,
      sym_elseif,
      aux_sym_if_statement_repeat1,
  [33741] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1570), 1,
      anon_sym_RBRACE,
    STATE(403), 1,
      sym__field_sep,
    STATE(717), 1,
      aux_sym__field_sequence_repeat1,
    ACTIONS(1568), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [33758] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(1572), 1,
      anon_sym_LPAREN,
    ACTIONS(1574), 1,
      sym_string,
    STATE(128), 1,
      sym_arguments,
    STATE(139), 1,
      sym_table,
  [33777] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 1,
      anon_sym_LBRACE,
    ACTIONS(1576), 1,
      anon_sym_LPAREN,
    ACTIONS(1578), 1,
      sym_string,
    STATE(125), 1,
      sym_table,
    STATE(136), 1,
      sym_arguments,
  [33796] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(1512), 1,
      anon_sym_LPAREN,
    ACTIONS(1514), 1,
      sym_string,
    STATE(117), 1,
      sym_table,
    STATE(140), 1,
      sym_arguments,
  [33815] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1580), 1,
      anon_sym_DOT,
    STATE(727), 1,
      aux_sym_function_name_field_repeat1,
    ACTIONS(1583), 2,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [33829] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1585), 1,
      anon_sym_DOT,
    STATE(727), 1,
      aux_sym_function_name_field_repeat1,
    ACTIONS(1587), 2,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [33843] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1585), 1,
      anon_sym_DOT,
    ACTIONS(1589), 1,
      anon_sym_COLON,
    ACTIONS(1592), 1,
      anon_sym_LPAREN,
    STATE(728), 1,
      aux_sym_function_name_field_repeat1,
  [33859] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_RPAREN,
    ACTIONS(1597), 1,
      sym_spread,
    ACTIONS(1599), 2,
      sym_self,
      sym_identifier,
  [33873] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1601), 1,
      anon_sym_COMMA,
    STATE(731), 1,
      aux_sym__local_variable_declarator_repeat1,
    ACTIONS(1138), 2,
      anon_sym_in,
      anon_sym_RPAREN,
  [33887] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1604), 1,
      anon_sym_COMMA,
    ACTIONS(1606), 1,
      anon_sym_EQ,
    ACTIONS(1608), 1,
      anon_sym_in,
    STATE(765), 1,
      aux_sym__local_variable_declarator_repeat1,
  [33903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1559), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [33912] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_COMMA,
    ACTIONS(1610), 1,
      anon_sym_EQ,
    STATE(754), 1,
      aux_sym_variable_declaration_repeat1,
  [33925] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 1,
      sym_identifier,
    STATE(893), 1,
      sym__loop_expression,
    STATE(894), 1,
      sym__in_loop_expression,
  [33938] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 1,
      sym_identifier,
    STATE(885), 1,
      sym__loop_expression,
    STATE(886), 1,
      sym__in_loop_expression,
  [33951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1616), 1,
      anon_sym_else,
    ACTIONS(1614), 2,
      anon_sym_end,
      anon_sym_elseif,
  [33962] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 1,
      sym_identifier,
    STATE(877), 1,
      sym__loop_expression,
    STATE(878), 1,
      sym__in_loop_expression,
  [33975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_else,
    ACTIONS(1618), 2,
      anon_sym_end,
      anon_sym_elseif,
  [33986] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(57), 1,
      sym_parameters,
    STATE(361), 1,
      sym__function_body,
  [33999] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1620), 1,
      anon_sym_function,
    ACTIONS(1622), 1,
      sym_identifier,
    STATE(402), 1,
      sym__local_variable_declarator,
  [34012] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1624), 1,
      anon_sym_COMMA,
    ACTIONS(1626), 1,
      anon_sym_RPAREN,
    STATE(731), 1,
      aux_sym__local_variable_declarator_repeat1,
  [34025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [34034] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1630), 1,
      anon_sym_function,
    ACTIONS(1632), 1,
      sym_identifier,
    STATE(401), 1,
      sym__local_variable_declarator,
  [34047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1634), 1,
      anon_sym_do,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34060] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(61), 1,
      sym_parameters,
    STATE(231), 1,
      sym__function_body,
  [34073] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(54), 1,
      sym_parameters,
    STATE(211), 1,
      sym__function_body,
  [34086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 3,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_RPAREN,
  [34095] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 1,
      sym_identifier,
    STATE(800), 1,
      sym__in_loop_expression,
    STATE(802), 1,
      sym__loop_expression,
  [34108] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      sym_parameters,
    STATE(435), 1,
      sym__function_body,
  [34121] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      sym_parameters,
    STATE(416), 1,
      sym__function_body,
  [34134] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_COMMA,
    ACTIONS(1636), 1,
      anon_sym_EQ,
    STATE(754), 1,
      aux_sym_variable_declaration_repeat1,
  [34147] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1425), 1,
      anon_sym_do,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34160] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1638), 1,
      anon_sym_COMMA,
    ACTIONS(1641), 1,
      anon_sym_EQ,
    STATE(754), 1,
      aux_sym_variable_declaration_repeat1,
  [34173] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1643), 1,
      anon_sym_RPAREN,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34186] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(90), 1,
      sym_parameters,
    STATE(471), 1,
      sym__function_body,
  [34199] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_COMMA,
    ACTIONS(1645), 1,
      anon_sym_EQ,
    STATE(754), 1,
      aux_sym_variable_declaration_repeat1,
  [34212] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      sym_parameters,
    STATE(408), 1,
      sym__function_body,
  [34225] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(82), 1,
      sym_parameters,
    STATE(323), 1,
      sym__function_body,
  [34238] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym_parameters,
    STATE(158), 1,
      sym__function_body,
  [34251] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1647), 1,
      anon_sym_function,
    ACTIONS(1649), 1,
      sym_identifier,
    STATE(395), 1,
      sym__local_variable_declarator,
  [34264] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(90), 1,
      sym_parameters,
    STATE(468), 1,
      sym__function_body,
  [34277] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1651), 1,
      anon_sym_RPAREN,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34290] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1653), 1,
      anon_sym_RPAREN,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34303] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1604), 1,
      anon_sym_COMMA,
    ACTIONS(1655), 1,
      anon_sym_in,
    STATE(731), 1,
      aux_sym__local_variable_declarator_repeat1,
  [34316] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1657), 1,
      anon_sym_COMMA,
    ACTIONS(1659), 1,
      anon_sym_RPAREN,
    STATE(742), 1,
      aux_sym__local_variable_declarator_repeat1,
  [34329] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1661), 1,
      anon_sym_RPAREN,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34342] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 1,
      anon_sym_function,
    ACTIONS(1665), 1,
      sym_identifier,
    STATE(343), 1,
      sym__local_variable_declarator,
  [34355] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_COMMA,
    ACTIONS(1667), 1,
      anon_sym_EQ,
    STATE(754), 1,
      aux_sym_variable_declaration_repeat1,
  [34368] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      sym_parameters,
    STATE(433), 1,
      sym__function_body,
  [34381] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(45), 1,
      sym_parameters,
    STATE(227), 1,
      sym__function_body,
  [34394] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_COMMA,
    ACTIONS(1669), 1,
      anon_sym_RPAREN,
    STATE(686), 1,
      aux_sym_return_statement_repeat1,
  [34407] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1520), 1,
      anon_sym_LPAREN,
    STATE(57), 1,
      sym_parameters,
    STATE(372), 1,
      sym__function_body,
  [34420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1671), 1,
      anon_sym_COLON,
    ACTIONS(1673), 1,
      anon_sym_LPAREN,
  [34430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1675), 1,
      sym_spread,
    ACTIONS(1677), 1,
      sym_identifier,
  [34440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1677), 1,
      sym_identifier,
    ACTIONS(1679), 1,
      sym_spread,
  [34450] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1681), 1,
      anon_sym_end,
  [34457] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 1,
      sym_identifier,
  [34464] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1516), 1,
      anon_sym_end,
  [34471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1685), 1,
      anon_sym_end,
  [34478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1687), 1,
      anon_sym_end,
  [34485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1689), 1,
      anon_sym_end,
  [34492] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1691), 1,
      anon_sym_end,
  [34499] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 1,
      anon_sym_end,
  [34506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1693), 1,
      anon_sym_end,
  [34513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1695), 1,
      anon_sym_end,
  [34520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1697), 1,
      anon_sym_end,
  [34527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1536), 1,
      anon_sym_end,
  [34534] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_end,
  [34541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_end,
  [34548] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 1,
      anon_sym_end,
  [34555] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1705), 1,
      anon_sym_end,
  [34562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1707), 1,
      anon_sym_end,
  [34569] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_end,
  [34576] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1709), 1,
      sym_identifier,
  [34583] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1711), 1,
      anon_sym_COLON_COLON,
  [34590] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1713), 1,
      anon_sym_end,
  [34597] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1715), 1,
      anon_sym_end,
  [34604] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1717), 1,
      anon_sym_until,
  [34611] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_do,
  [34618] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1721), 1,
      anon_sym_COLON_COLON,
  [34625] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1723), 1,
      anon_sym_do,
  [34632] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1725), 1,
      anon_sym_end,
  [34639] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1727), 1,
      anon_sym_RBRACE,
  [34646] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1729), 1,
      sym_identifier,
  [34653] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1731), 1,
      sym_identifier,
  [34660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1526), 1,
      anon_sym_end,
  [34667] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1733), 1,
      sym_identifier,
  [34674] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1735), 1,
      anon_sym_end,
  [34681] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1737), 1,
      anon_sym_end,
  [34688] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1739), 1,
      anon_sym_until,
  [34695] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1741), 1,
      anon_sym_until,
  [34702] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1743), 1,
      anon_sym_end,
  [34709] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1745), 1,
      anon_sym_end,
  [34716] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1528), 1,
      anon_sym_end,
  [34723] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1747), 1,
      sym_identifier,
  [34730] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_end,
  [34737] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1751), 1,
      sym_identifier,
  [34744] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_end,
  [34751] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1542), 1,
      anon_sym_end,
  [34758] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      anon_sym_until,
  [34765] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1755), 1,
      anon_sym_end,
  [34772] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1757), 1,
      ts_builtin_sym_end,
  [34779] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1759), 1,
      anon_sym_end,
  [34786] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      sym_identifier,
  [34793] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1763), 1,
      anon_sym_end,
  [34800] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1765), 1,
      anon_sym_end,
  [34807] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1767), 1,
      anon_sym_end,
  [34814] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1769), 1,
      anon_sym_end,
  [34821] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1540), 1,
      anon_sym_end,
  [34828] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1771), 1,
      anon_sym_end,
  [34835] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1677), 1,
      sym_identifier,
  [34842] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1773), 1,
      anon_sym_end,
  [34849] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1775), 1,
      anon_sym_end,
  [34856] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1777), 1,
      anon_sym_end,
  [34863] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 1,
      anon_sym_end,
  [34870] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1779), 1,
      anon_sym_RBRACE,
  [34877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1781), 1,
      anon_sym_end,
  [34884] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1783), 1,
      sym_identifier,
  [34891] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1785), 1,
      anon_sym_until,
  [34898] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1787), 1,
      anon_sym_end,
  [34905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1789), 1,
      anon_sym_end,
  [34912] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1791), 1,
      anon_sym_RBRACE,
  [34919] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1793), 1,
      sym_identifier,
  [34926] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1795), 1,
      sym_identifier,
  [34933] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1797), 1,
      sym_identifier,
  [34940] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1799), 1,
      sym_identifier,
  [34947] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1801), 1,
      anon_sym_end,
  [34954] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(350), 1,
      ts_builtin_sym_end,
  [34961] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1803), 1,
      anon_sym_RBRACE,
  [34968] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1805), 1,
      anon_sym_EQ,
  [34975] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1807), 1,
      anon_sym_end,
  [34982] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1809), 1,
      sym_identifier,
  [34989] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1811), 1,
      ts_builtin_sym_end,
  [34996] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1813), 1,
      sym_identifier,
  [35003] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1815), 1,
      anon_sym_RBRACE,
  [35010] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1817), 1,
      anon_sym_end,
  [35017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1819), 1,
      anon_sym_COLON_COLON,
  [35024] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1821), 1,
      anon_sym_end,
  [35031] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1823), 1,
      anon_sym_RBRACE,
  [35038] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1825), 1,
      anon_sym_end,
  [35045] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      sym_identifier,
  [35052] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1829), 1,
      anon_sym_end,
  [35059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1831), 1,
      sym_identifier,
  [35066] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1833), 1,
      anon_sym_end,
  [35073] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_COLON_COLON,
  [35080] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1837), 1,
      anon_sym_end,
  [35087] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1839), 1,
      anon_sym_end,
  [35094] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1841), 1,
      anon_sym_end,
  [35101] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1843), 1,
      anon_sym_end,
  [35108] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1845), 1,
      anon_sym_end,
  [35115] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1847), 1,
      sym_identifier,
  [35122] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1849), 1,
      anon_sym_RPAREN,
  [35129] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1851), 1,
      sym_identifier,
  [35136] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1853), 1,
      anon_sym_until,
  [35143] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1855), 1,
      sym_identifier,
  [35150] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1857), 1,
      anon_sym_do,
  [35157] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1859), 1,
      anon_sym_do,
  [35164] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1861), 1,
      anon_sym_end,
  [35171] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1863), 1,
      sym_identifier,
  [35178] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1865), 1,
      anon_sym_end,
  [35185] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1867), 1,
      sym_identifier,
  [35192] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1869), 1,
      anon_sym_end,
  [35199] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1871), 1,
      anon_sym_until,
  [35206] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1873), 1,
      anon_sym_do,
  [35213] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1875), 1,
      anon_sym_do,
  [35220] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1530), 1,
      anon_sym_end,
  [35227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1877), 1,
      sym_identifier,
  [35234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1879), 1,
      anon_sym_end,
  [35241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1881), 1,
      sym_identifier,
  [35248] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1883), 1,
      sym_identifier,
  [35255] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1885), 1,
      sym_identifier,
  [35262] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1887), 1,
      anon_sym_do,
  [35269] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1889), 1,
      anon_sym_do,
  [35276] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1891), 1,
      anon_sym_end,
  [35283] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1893), 1,
      anon_sym_end,
  [35290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1895), 1,
      anon_sym_RPAREN,
  [35297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1897), 1,
      anon_sym_LPAREN,
  [35304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1899), 1,
      sym_identifier,
  [35311] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1901), 1,
      anon_sym_end,
  [35318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1903), 1,
      anon_sym_end,
  [35325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1905), 1,
      anon_sym_end,
  [35332] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1907), 1,
      anon_sym_end,
  [35339] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1909), 1,
      sym_identifier,
  [35346] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1911), 1,
      anon_sym_until,
  [35353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1544), 1,
      anon_sym_end,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(113)] = 0,
  [SMALL_STATE(114)] = 91,
  [SMALL_STATE(115)] = 156,
  [SMALL_STATE(116)] = 217,
  [SMALL_STATE(117)] = 278,
  [SMALL_STATE(118)] = 339,
  [SMALL_STATE(119)] = 400,
  [SMALL_STATE(120)] = 461,
  [SMALL_STATE(121)] = 522,
  [SMALL_STATE(122)] = 613,
  [SMALL_STATE(123)] = 674,
  [SMALL_STATE(124)] = 735,
  [SMALL_STATE(125)] = 796,
  [SMALL_STATE(126)] = 857,
  [SMALL_STATE(127)] = 948,
  [SMALL_STATE(128)] = 1009,
  [SMALL_STATE(129)] = 1070,
  [SMALL_STATE(130)] = 1131,
  [SMALL_STATE(131)] = 1192,
  [SMALL_STATE(132)] = 1257,
  [SMALL_STATE(133)] = 1318,
  [SMALL_STATE(134)] = 1379,
  [SMALL_STATE(135)] = 1440,
  [SMALL_STATE(136)] = 1501,
  [SMALL_STATE(137)] = 1562,
  [SMALL_STATE(138)] = 1623,
  [SMALL_STATE(139)] = 1684,
  [SMALL_STATE(140)] = 1745,
  [SMALL_STATE(141)] = 1806,
  [SMALL_STATE(142)] = 1867,
  [SMALL_STATE(143)] = 1932,
  [SMALL_STATE(144)] = 1993,
  [SMALL_STATE(145)] = 2054,
  [SMALL_STATE(146)] = 2115,
  [SMALL_STATE(147)] = 2176,
  [SMALL_STATE(148)] = 2237,
  [SMALL_STATE(149)] = 2298,
  [SMALL_STATE(150)] = 2360,
  [SMALL_STATE(151)] = 2426,
  [SMALL_STATE(152)] = 2490,
  [SMALL_STATE(153)] = 2552,
  [SMALL_STATE(154)] = 2612,
  [SMALL_STATE(155)] = 2672,
  [SMALL_STATE(156)] = 2734,
  [SMALL_STATE(157)] = 2804,
  [SMALL_STATE(158)] = 2868,
  [SMALL_STATE(159)] = 2928,
  [SMALL_STATE(160)] = 2998,
  [SMALL_STATE(161)] = 3076,
  [SMALL_STATE(162)] = 3158,
  [SMALL_STATE(163)] = 3230,
  [SMALL_STATE(164)] = 3304,
  [SMALL_STATE(165)] = 3380,
  [SMALL_STATE(166)] = 3466,
  [SMALL_STATE(167)] = 3526,
  [SMALL_STATE(168)] = 3610,
  [SMALL_STATE(169)] = 3674,
  [SMALL_STATE(170)] = 3734,
  [SMALL_STATE(171)] = 3823,
  [SMALL_STATE(172)] = 3908,
  [SMALL_STATE(173)] = 3997,
  [SMALL_STATE(174)] = 4058,
  [SMALL_STATE(175)] = 4147,
  [SMALL_STATE(176)] = 4236,
  [SMALL_STATE(177)] = 4305,
  [SMALL_STATE(178)] = 4366,
  [SMALL_STATE(179)] = 4451,
  [SMALL_STATE(180)] = 4540,
  [SMALL_STATE(181)] = 4625,
  [SMALL_STATE(182)] = 4710,
  [SMALL_STATE(183)] = 4793,
  [SMALL_STATE(184)] = 4882,
  [SMALL_STATE(185)] = 4943,
  [SMALL_STATE(186)] = 5024,
  [SMALL_STATE(187)] = 5101,
  [SMALL_STATE(188)] = 5176,
  [SMALL_STATE(189)] = 5249,
  [SMALL_STATE(190)] = 5338,
  [SMALL_STATE(191)] = 5409,
  [SMALL_STATE(192)] = 5478,
  [SMALL_STATE(193)] = 5567,
  [SMALL_STATE(194)] = 5656,
  [SMALL_STATE(195)] = 5721,
  [SMALL_STATE(196)] = 5789,
  [SMALL_STATE(197)] = 5871,
  [SMALL_STATE(198)] = 5929,
  [SMALL_STATE(199)] = 5989,
  [SMALL_STATE(200)] = 6057,
  [SMALL_STATE(201)] = 6117,
  [SMALL_STATE(202)] = 6181,
  [SMALL_STATE(203)] = 6249,
  [SMALL_STATE(204)] = 6319,
  [SMALL_STATE(205)] = 6391,
  [SMALL_STATE(206)] = 6465,
  [SMALL_STATE(207)] = 6541,
  [SMALL_STATE(208)] = 6599,
  [SMALL_STATE(209)] = 6679,
  [SMALL_STATE(210)] = 6761,
  [SMALL_STATE(211)] = 6819,
  [SMALL_STATE(212)] = 6877,
  [SMALL_STATE(213)] = 6935,
  [SMALL_STATE(214)] = 7019,
  [SMALL_STATE(215)] = 7079,
  [SMALL_STATE(216)] = 7143,
  [SMALL_STATE(217)] = 7211,
  [SMALL_STATE(218)] = 7281,
  [SMALL_STATE(219)] = 7341,
  [SMALL_STATE(220)] = 7401,
  [SMALL_STATE(221)] = 7473,
  [SMALL_STATE(222)] = 7547,
  [SMALL_STATE(223)] = 7605,
  [SMALL_STATE(224)] = 7681,
  [SMALL_STATE(225)] = 7761,
  [SMALL_STATE(226)] = 7821,
  [SMALL_STATE(227)] = 7879,
  [SMALL_STATE(228)] = 7937,
  [SMALL_STATE(229)] = 7995,
  [SMALL_STATE(230)] = 8055,
  [SMALL_STATE(231)] = 8123,
  [SMALL_STATE(232)] = 8181,
  [SMALL_STATE(233)] = 8241,
  [SMALL_STATE(234)] = 8305,
  [SMALL_STATE(235)] = 8363,
  [SMALL_STATE(236)] = 8421,
  [SMALL_STATE(237)] = 8489,
  [SMALL_STATE(238)] = 8573,
  [SMALL_STATE(239)] = 8653,
  [SMALL_STATE(240)] = 8735,
  [SMALL_STATE(241)] = 8811,
  [SMALL_STATE(242)] = 8871,
  [SMALL_STATE(243)] = 8929,
  [SMALL_STATE(244)] = 9003,
  [SMALL_STATE(245)] = 9061,
  [SMALL_STATE(246)] = 9145,
  [SMALL_STATE(247)] = 9203,
  [SMALL_STATE(248)] = 9275,
  [SMALL_STATE(249)] = 9345,
  [SMALL_STATE(250)] = 9412,
  [SMALL_STATE(251)] = 9471,
  [SMALL_STATE(252)] = 9530,
  [SMALL_STATE(253)] = 9613,
  [SMALL_STATE(254)] = 9676,
  [SMALL_STATE(255)] = 9759,
  [SMALL_STATE(256)] = 9842,
  [SMALL_STATE(257)] = 9925,
  [SMALL_STATE(258)] = 9984,
  [SMALL_STATE(259)] = 10065,
  [SMALL_STATE(260)] = 10148,
  [SMALL_STATE(261)] = 10215,
  [SMALL_STATE(262)] = 10274,
  [SMALL_STATE(263)] = 10341,
  [SMALL_STATE(264)] = 10400,
  [SMALL_STATE(265)] = 10463,
  [SMALL_STATE(266)] = 10530,
  [SMALL_STATE(267)] = 10599,
  [SMALL_STATE(268)] = 10670,
  [SMALL_STATE(269)] = 10743,
  [SMALL_STATE(270)] = 10806,
  [SMALL_STATE(271)] = 10865,
  [SMALL_STATE(272)] = 10940,
  [SMALL_STATE(273)] = 11019,
  [SMALL_STATE(274)] = 11100,
  [SMALL_STATE(275)] = 11183,
  [SMALL_STATE(276)] = 11266,
  [SMALL_STATE(277)] = 11349,
  [SMALL_STATE(278)] = 11432,
  [SMALL_STATE(279)] = 11499,
  [SMALL_STATE(280)] = 11558,
  [SMALL_STATE(281)] = 11617,
  [SMALL_STATE(282)] = 11700,
  [SMALL_STATE(283)] = 11781,
  [SMALL_STATE(284)] = 11860,
  [SMALL_STATE(285)] = 11935,
  [SMALL_STATE(286)] = 12008,
  [SMALL_STATE(287)] = 12079,
  [SMALL_STATE(288)] = 12146,
  [SMALL_STATE(289)] = 12215,
  [SMALL_STATE(290)] = 12286,
  [SMALL_STATE(291)] = 12369,
  [SMALL_STATE(292)] = 12442,
  [SMALL_STATE(293)] = 12525,
  [SMALL_STATE(294)] = 12600,
  [SMALL_STATE(295)] = 12659,
  [SMALL_STATE(296)] = 12728,
  [SMALL_STATE(297)] = 12807,
  [SMALL_STATE(298)] = 12872,
  [SMALL_STATE(299)] = 12919,
  [SMALL_STATE(300)] = 12966,
  [SMALL_STATE(301)] = 13013,
  [SMALL_STATE(302)] = 13060,
  [SMALL_STATE(303)] = 13107,
  [SMALL_STATE(304)] = 13154,
  [SMALL_STATE(305)] = 13205,
  [SMALL_STATE(306)] = 13252,
  [SMALL_STATE(307)] = 13299,
  [SMALL_STATE(308)] = 13346,
  [SMALL_STATE(309)] = 13393,
  [SMALL_STATE(310)] = 13440,
  [SMALL_STATE(311)] = 13487,
  [SMALL_STATE(312)] = 13534,
  [SMALL_STATE(313)] = 13581,
  [SMALL_STATE(314)] = 13628,
  [SMALL_STATE(315)] = 13675,
  [SMALL_STATE(316)] = 13721,
  [SMALL_STATE(317)] = 13767,
  [SMALL_STATE(318)] = 13809,
  [SMALL_STATE(319)] = 13855,
  [SMALL_STATE(320)] = 13901,
  [SMALL_STATE(321)] = 13946,
  [SMALL_STATE(322)] = 14005,
  [SMALL_STATE(323)] = 14076,
  [SMALL_STATE(324)] = 14117,
  [SMALL_STATE(325)] = 14158,
  [SMALL_STATE(326)] = 14199,
  [SMALL_STATE(327)] = 14242,
  [SMALL_STATE(328)] = 14283,
  [SMALL_STATE(329)] = 14328,
  [SMALL_STATE(330)] = 14373,
  [SMALL_STATE(331)] = 14418,
  [SMALL_STATE(332)] = 14461,
  [SMALL_STATE(333)] = 14504,
  [SMALL_STATE(334)] = 14557,
  [SMALL_STATE(335)] = 14614,
  [SMALL_STATE(336)] = 14659,
  [SMALL_STATE(337)] = 14722,
  [SMALL_STATE(338)] = 14763,
  [SMALL_STATE(339)] = 14808,
  [SMALL_STATE(340)] = 14853,
  [SMALL_STATE(341)] = 14908,
  [SMALL_STATE(342)] = 14959,
  [SMALL_STATE(343)] = 15004,
  [SMALL_STATE(344)] = 15047,
  [SMALL_STATE(345)] = 15112,
  [SMALL_STATE(346)] = 15163,
  [SMALL_STATE(347)] = 15210,
  [SMALL_STATE(348)] = 15251,
  [SMALL_STATE(349)] = 15292,
  [SMALL_STATE(350)] = 15337,
  [SMALL_STATE(351)] = 15377,
  [SMALL_STATE(352)] = 15421,
  [SMALL_STATE(353)] = 15461,
  [SMALL_STATE(354)] = 15505,
  [SMALL_STATE(355)] = 15545,
  [SMALL_STATE(356)] = 15585,
  [SMALL_STATE(357)] = 15625,
  [SMALL_STATE(358)] = 15665,
  [SMALL_STATE(359)] = 15705,
  [SMALL_STATE(360)] = 15745,
  [SMALL_STATE(361)] = 15785,
  [SMALL_STATE(362)] = 15825,
  [SMALL_STATE(363)] = 15865,
  [SMALL_STATE(364)] = 15937,
  [SMALL_STATE(365)] = 15977,
  [SMALL_STATE(366)] = 16017,
  [SMALL_STATE(367)] = 16057,
  [SMALL_STATE(368)] = 16097,
  [SMALL_STATE(369)] = 16137,
  [SMALL_STATE(370)] = 16177,
  [SMALL_STATE(371)] = 16217,
  [SMALL_STATE(372)] = 16289,
  [SMALL_STATE(373)] = 16329,
  [SMALL_STATE(374)] = 16401,
  [SMALL_STATE(375)] = 16441,
  [SMALL_STATE(376)] = 16481,
  [SMALL_STATE(377)] = 16521,
  [SMALL_STATE(378)] = 16561,
  [SMALL_STATE(379)] = 16601,
  [SMALL_STATE(380)] = 16645,
  [SMALL_STATE(381)] = 16685,
  [SMALL_STATE(382)] = 16757,
  [SMALL_STATE(383)] = 16829,
  [SMALL_STATE(384)] = 16873,
  [SMALL_STATE(385)] = 16917,
  [SMALL_STATE(386)] = 16961,
  [SMALL_STATE(387)] = 17005,
  [SMALL_STATE(388)] = 17049,
  [SMALL_STATE(389)] = 17089,
  [SMALL_STATE(390)] = 17161,
  [SMALL_STATE(391)] = 17205,
  [SMALL_STATE(392)] = 17245,
  [SMALL_STATE(393)] = 17289,
  [SMALL_STATE(394)] = 17333,
  [SMALL_STATE(395)] = 17377,
  [SMALL_STATE(396)] = 17418,
  [SMALL_STATE(397)] = 17487,
  [SMALL_STATE(398)] = 17556,
  [SMALL_STATE(399)] = 17601,
  [SMALL_STATE(400)] = 17670,
  [SMALL_STATE(401)] = 17739,
  [SMALL_STATE(402)] = 17780,
  [SMALL_STATE(403)] = 17821,
  [SMALL_STATE(404)] = 17890,
  [SMALL_STATE(405)] = 17928,
  [SMALL_STATE(406)] = 17966,
  [SMALL_STATE(407)] = 18004,
  [SMALL_STATE(408)] = 18042,
  [SMALL_STATE(409)] = 18080,
  [SMALL_STATE(410)] = 18118,
  [SMALL_STATE(411)] = 18156,
  [SMALL_STATE(412)] = 18194,
  [SMALL_STATE(413)] = 18232,
  [SMALL_STATE(414)] = 18270,
  [SMALL_STATE(415)] = 18308,
  [SMALL_STATE(416)] = 18346,
  [SMALL_STATE(417)] = 18384,
  [SMALL_STATE(418)] = 18456,
  [SMALL_STATE(419)] = 18494,
  [SMALL_STATE(420)] = 18532,
  [SMALL_STATE(421)] = 18570,
  [SMALL_STATE(422)] = 18608,
  [SMALL_STATE(423)] = 18646,
  [SMALL_STATE(424)] = 18684,
  [SMALL_STATE(425)] = 18722,
  [SMALL_STATE(426)] = 18760,
  [SMALL_STATE(427)] = 18798,
  [SMALL_STATE(428)] = 18836,
  [SMALL_STATE(429)] = 18874,
  [SMALL_STATE(430)] = 18912,
  [SMALL_STATE(431)] = 18950,
  [SMALL_STATE(432)] = 18988,
  [SMALL_STATE(433)] = 19026,
  [SMALL_STATE(434)] = 19064,
  [SMALL_STATE(435)] = 19128,
  [SMALL_STATE(436)] = 19166,
  [SMALL_STATE(437)] = 19204,
  [SMALL_STATE(438)] = 19242,
  [SMALL_STATE(439)] = 19280,
  [SMALL_STATE(440)] = 19318,
  [SMALL_STATE(441)] = 19356,
  [SMALL_STATE(442)] = 19394,
  [SMALL_STATE(443)] = 19432,
  [SMALL_STATE(444)] = 19470,
  [SMALL_STATE(445)] = 19508,
  [SMALL_STATE(446)] = 19546,
  [SMALL_STATE(447)] = 19584,
  [SMALL_STATE(448)] = 19622,
  [SMALL_STATE(449)] = 19660,
  [SMALL_STATE(450)] = 19698,
  [SMALL_STATE(451)] = 19736,
  [SMALL_STATE(452)] = 19774,
  [SMALL_STATE(453)] = 19812,
  [SMALL_STATE(454)] = 19850,
  [SMALL_STATE(455)] = 19888,
  [SMALL_STATE(456)] = 19926,
  [SMALL_STATE(457)] = 19964,
  [SMALL_STATE(458)] = 20002,
  [SMALL_STATE(459)] = 20040,
  [SMALL_STATE(460)] = 20078,
  [SMALL_STATE(461)] = 20116,
  [SMALL_STATE(462)] = 20154,
  [SMALL_STATE(463)] = 20192,
  [SMALL_STATE(464)] = 20230,
  [SMALL_STATE(465)] = 20268,
  [SMALL_STATE(466)] = 20306,
  [SMALL_STATE(467)] = 20344,
  [SMALL_STATE(468)] = 20382,
  [SMALL_STATE(469)] = 20420,
  [SMALL_STATE(470)] = 20458,
  [SMALL_STATE(471)] = 20496,
  [SMALL_STATE(472)] = 20534,
  [SMALL_STATE(473)] = 20572,
  [SMALL_STATE(474)] = 20610,
  [SMALL_STATE(475)] = 20648,
  [SMALL_STATE(476)] = 20686,
  [SMALL_STATE(477)] = 20724,
  [SMALL_STATE(478)] = 20762,
  [SMALL_STATE(479)] = 20800,
  [SMALL_STATE(480)] = 20838,
  [SMALL_STATE(481)] = 20876,
  [SMALL_STATE(482)] = 20914,
  [SMALL_STATE(483)] = 20980,
  [SMALL_STATE(484)] = 21018,
  [SMALL_STATE(485)] = 21081,
  [SMALL_STATE(486)] = 21144,
  [SMALL_STATE(487)] = 21207,
  [SMALL_STATE(488)] = 21270,
  [SMALL_STATE(489)] = 21333,
  [SMALL_STATE(490)] = 21393,
  [SMALL_STATE(491)] = 21453,
  [SMALL_STATE(492)] = 21513,
  [SMALL_STATE(493)] = 21573,
  [SMALL_STATE(494)] = 21633,
  [SMALL_STATE(495)] = 21693,
  [SMALL_STATE(496)] = 21753,
  [SMALL_STATE(497)] = 21813,
  [SMALL_STATE(498)] = 21873,
  [SMALL_STATE(499)] = 21933,
  [SMALL_STATE(500)] = 21993,
  [SMALL_STATE(501)] = 22053,
  [SMALL_STATE(502)] = 22113,
  [SMALL_STATE(503)] = 22173,
  [SMALL_STATE(504)] = 22233,
  [SMALL_STATE(505)] = 22293,
  [SMALL_STATE(506)] = 22353,
  [SMALL_STATE(507)] = 22413,
  [SMALL_STATE(508)] = 22473,
  [SMALL_STATE(509)] = 22533,
  [SMALL_STATE(510)] = 22593,
  [SMALL_STATE(511)] = 22653,
  [SMALL_STATE(512)] = 22713,
  [SMALL_STATE(513)] = 22773,
  [SMALL_STATE(514)] = 22833,
  [SMALL_STATE(515)] = 22893,
  [SMALL_STATE(516)] = 22953,
  [SMALL_STATE(517)] = 23