#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 393
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 100
#define ALIAS_COUNT 0
#define TOKEN_COUNT 49
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_SEMI = 3,
  anon_sym_module = 4,
  anon_sym_LPAREN = 5,
  anon_sym_COMMA = 6,
  anon_sym_RPAREN = 7,
  anon_sym_function = 8,
  anon_sym_EQ = 9,
  anon_sym_include = 10,
  anon_sym_use = 11,
  sym_include_path = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_for = 15,
  anon_sym_intersection_for = 16,
  anon_sym_let = 17,
  anon_sym_assign = 18,
  anon_sym_if = 19,
  anon_sym_else = 20,
  anon_sym_STAR = 21,
  anon_sym_BANG = 22,
  anon_sym_POUND = 23,
  anon_sym_PERCENT = 24,
  sym_special_variable = 25,
  sym_string = 26,
  aux_sym_number_token1 = 27,
  aux_sym_number_token2 = 28,
  anon_sym_true = 29,
  anon_sym_false = 30,
  anon_sym_LBRACK = 31,
  anon_sym_COLON = 32,
  anon_sym_RBRACK = 33,
  anon_sym_each = 34,
  anon_sym_DOT = 35,
  anon_sym_DASH = 36,
  anon_sym_PLUS = 37,
  anon_sym_PIPE_PIPE = 38,
  anon_sym_AMP_AMP = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_BANG_EQ = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_LT_EQ = 44,
  anon_sym_GT_EQ = 45,
  anon_sym_SLASH = 46,
  anon_sym_CARET = 47,
  anon_sym_QMARK = 48,
  sym_source_file = 49,
  sym__item = 50,
  sym_module_declaration = 51,
  sym_parameters_declaration = 52,
  sym__parameter_declaration = 53,
  sym_function_declaration = 54,
  sym__statement = 55,
  sym_include_statement = 56,
  sym_use_statement = 57,
  sym_assignment = 58,
  sym_union_block = 59,
  sym_for_block = 60,
  sym_intersection_for_block = 61,
  sym_let_block = 62,
  sym_assign_block = 63,
  sym_if_block = 64,
  sym_modifier_chain = 65,
  sym_modifier = 66,
  sym_transform_chain = 67,
  sym_module_call = 68,
  sym_arguments = 69,
  sym_parenthesized_assignments = 70,
  sym_parenthesized_expression = 71,
  sym_condition_update_clause = 72,
  sym__expression = 73,
  sym_let_expression = 74,
  sym__variable_name = 75,
  sym__literal = 76,
  sym_number = 77,
  sym_boolean = 78,
  sym_function = 79,
  sym_range = 80,
  sym_list = 81,
  sym__list_cell = 82,
  sym__comprehension_cell = 83,
  sym_each = 84,
  sym_list_comprehension = 85,
  sym_for_clause = 86,
  sym_if_clause = 87,
  sym_function_call = 88,
  sym_index_expression = 89,
  sym_dot_index_expression = 90,
  sym_unary_expression = 91,
  sym_binary_expression = 92,
  sym_ternary_expression = 93,
  aux_sym_source_file_repeat1 = 94,
  aux_sym_parameters_declaration_repeat1 = 95,
  aux_sym_union_block_repeat1 = 96,
  aux_sym_arguments_repeat1 = 97,
  aux_sym_parenthesized_assignments_repeat1 = 98,
  aux_sym_list_repeat1 = 99,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_SEMI] = ";",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_include] = "include",
  [anon_sym_use] = "use",
  [sym_include_path] = "include_path",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_for] = "for",
  [anon_sym_intersection_for] = "intersection_for",
  [anon_sym_let] = "let",
  [anon_sym_assign] = "assign",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_STAR] = "*",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_PERCENT] = "%",
  [sym_special_variable] = "special_variable",
  [sym_string] = "string",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACK] = "]",
  [anon_sym_each] = "each",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_QMARK] = "\?",
  [sym_source_file] = "source_file",
  [sym__item] = "_item",
  [sym_module_declaration] = "module_declaration",
  [sym_parameters_declaration] = "parameters_declaration",
  [sym__parameter_declaration] = "_parameter_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__statement] = "_statement",
  [sym_include_statement] = "include_statement",
  [sym_use_statement] = "use_statement",
  [sym_assignment] = "assignment",
  [sym_union_block] = "union_block",
  [sym_for_block] = "for_block",
  [sym_intersection_for_block] = "intersection_for_block",
  [sym_let_block] = "let_block",
  [sym_assign_block] = "assign_block",
  [sym_if_block] = "if_block",
  [sym_modifier_chain] = "modifier_chain",
  [sym_modifier] = "modifier",
  [sym_transform_chain] = "transform_chain",
  [sym_module_call] = "module_call",
  [sym_arguments] = "arguments",
  [sym_parenthesized_assignments] = "parenthesized_assignments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition_update_clause] = "condition_update_clause",
  [sym__expression] = "_expression",
  [sym_let_expression] = "let_expression",
  [sym__variable_name] = "_variable_name",
  [sym__literal] = "_literal",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_function] = "function",
  [sym_range] = "range",
  [sym_list] = "list",
  [sym__list_cell] = "_list_cell",
  [sym__comprehension_cell] = "_comprehension_cell",
  [sym_each] = "each",
  [sym_list_comprehension] = "list_comprehension",
  [sym_for_clause] = "for_clause",
  [sym_if_clause] = "if_clause",
  [sym_function_call] = "function_call",
  [sym_index_expression] = "index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_parameters_declaration_repeat1] = "parameters_declaration_repeat1",
  [aux_sym_union_block_repeat1] = "union_block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parenthesized_assignments_repeat1] = "parenthesized_assignments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_use] = anon_sym_use,
  [sym_include_path] = sym_include_path,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_intersection_for] = anon_sym_intersection_for,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_special_variable] = sym_special_variable,
  [sym_string] = sym_string,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_source_file] = sym_source_file,
  [sym__item] = sym__item,
  [sym_module_declaration] = sym_module_declaration,
  [sym_parameters_declaration] = sym_parameters_declaration,
  [sym__parameter_declaration] = sym__parameter_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__statement] = sym__statement,
  [sym_include_statement] = sym_include_statement,
  [sym_use_statement] = sym_use_statement,
  [sym_assignment] = sym_assignment,
  [sym_union_block] = sym_union_block,
  [sym_for_block] = sym_for_block,
  [sym_intersection_for_block] = sym_intersection_for_block,
  [sym_let_block] = sym_let_block,
  [sym_assign_block] = sym_assign_block,
  [sym_if_block] = sym_if_block,
  [sym_modifier_chain] = sym_modifier_chain,
  [sym_modifier] = sym_modifier,
  [sym_transform_chain] = sym_transform_chain,
  [sym_module_call] = sym_module_call,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_assignments] = sym_parenthesized_assignments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition_update_clause] = sym_condition_update_clause,
  [sym__expression] = sym__expression,
  [sym_let_expression] = sym_let_expression,
  [sym__variable_name] = sym__variable_name,
  [sym__literal] = sym__literal,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_function] = sym_function,
  [sym_range] = sym_range,
  [sym_list] = sym_list,
  [sym__list_cell] = sym__list_cell,
  [sym__comprehension_cell] = sym__comprehension_cell,
  [sym_each] = sym_each,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_for_clause] = sym_for_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_function_call] = sym_function_call,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_parameters_declaration_repeat1] = aux_sym_parameters_declaration_repeat1,
  [aux_sym_union_block_repeat1] = aux_sym_union_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parenthesized_assignments_repeat1] = aux_sym_parenthesized_assignments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [sym_include_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intersection_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_special_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_union_block] = {
    .visible = true,
    .named = true,
  },
  [sym_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_transform_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_module_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_update_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_name] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_cell] = {
    .visible = false,
    .named = true,
  },
  [sym__comprehension_cell] = {
    .visible = false,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_end = 6,
  field_function = 7,
  field_increment = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_parameters = 13,
  field_right = 14,
  field_start = 15,
  field_update = 16,
  field_value = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_function] = "function",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 3},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 4},
  [10] = {.index = 20, .length = 2},
  [11] = {.index = 22, .length = 2},
  [12] = {.index = 24, .length = 3},
  [13] = {.index = 27, .length = 3},
  [14] = {.index = 30, .length = 1},
  [15] = {.index = 31, .length = 3},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 2},
  [18] = {.index = 38, .length = 3},
  [19] = {.index = 41, .length = 3},
  [20] = {.index = 44, .length = 3},
  [21] = {.index = 47, .length = 4},
  [22] = {.index = 51, .length = 4},
  [23] = {.index = 55, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_body, 2},
  [3] =
    {field_condition, 1},
    {field_consequence, 2},
  [5] =
    {field_left, 0},
    {field_right, 2},
  [7] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_name, 1},
    {field_parameters, 2},
  [14] =
    {field_body, 2},
    {field_parameters, 1},
  [16] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_index, 2},
    {field_value, 0},
  [22] =
    {field_end, 3},
    {field_start, 1},
  [24] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [27] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [30] =
    {field_condition, 2},
  [31] =
    {field_end, 5},
    {field_increment, 3},
    {field_start, 1},
  [34] =
    {field_condition, 2},
    {field_update, 4},
  [36] =
    {field_condition, 3},
    {field_initializer, 1},
  [38] =
    {field_condition, 2},
    {field_update, 4},
    {field_update, 5},
  [41] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
  [44] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
  [47] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
    {field_update, 6},
  [51] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
  [55] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(25)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(58);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(5)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(6)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(6)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(46);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(79);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(48);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 22:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(40);
      if (lookahead == '\r') ADVANCE(41);
      END_STATE();
    case 24:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 25:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 26:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 27:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 28:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 29:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 30:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 31:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      if (lookahead == '\r') SKIP(30)
      END_STATE();
    case 32:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      END_STATE();
    case 33:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      if (lookahead == '\r') SKIP(32)
      END_STATE();
    case 34:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 35:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 36:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(31)
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 37:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '\\') SKIP(33)
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(23);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_include_path);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_special_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 't') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == 's') ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(16);
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(24);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(27);
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 23:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 33:
      if (lookahead == 'g') ADVANCE(41);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 44:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(56);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 56:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == '_') ADVANCE(61);
      END_STATE();
    case 61:
      if (lookahead == 'f') ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_intersection_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 34},
  [3] = {.lex_state = 5},
  [4] = {.lex_state = 5},
  [5] = {.lex_state = 5},
  [6] = {.lex_state = 5},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 35},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 35},
  [13] = {.lex_state = 5},
  [14] = {.lex_state = 35},
  [15] = {.lex_state = 35},
  [16] = {.lex_state = 35},
  [17] = {.lex_state = 35},
  [18] = {.lex_state = 35},
  [19] = {.lex_state = 34},
  [20] = {.lex_state = 35},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 35},
  [23] = {.lex_state = 5},
  [24] = {.lex_state = 35},
  [25] = {.lex_state = 35},
  [26] = {.lex_state = 35},
  [27] = {.lex_state = 5},
  [28] = {.lex_state = 5},
  [29] = {.lex_state = 35},
  [30] = {.lex_state = 35},
  [31] = {.lex_state = 35},
  [32] = {.lex_state = 5},
  [33] = {.lex_state = 35},
  [34] = {.lex_state = 35},
  [35] = {.lex_state = 35},
  [36] = {.lex_state = 5},
  [37] = {.lex_state = 34},
  [38] = {.lex_state = 5},
  [39] = {.lex_state = 5},
  [40] = {.lex_state = 5},
  [41] = {.lex_state = 34},
  [42] = {.lex_state = 36},
  [43] = {.lex_state = 34},
  [44] = {.lex_state = 34},
  [45] = {.lex_state = 34},
  [46] = {.lex_state = 35},
  [47] = {.lex_state = 34},
  [48] = {.lex_state = 35},
  [49] = {.lex_state = 35},
  [50] = {.lex_state = 35},
  [51] = {.lex_state = 35},
  [52] = {.lex_state = 35},
  [53] = {.lex_state = 35},
  [54] = {.lex_state = 35},
  [55] = {.lex_state = 35},
  [56] = {.lex_state = 35},
  [57] = {.lex_state = 35},
  [58] = {.lex_state = 35},
  [59] = {.lex_state = 35},
  [60] = {.lex_state = 35},
  [61] = {.lex_state = 35},
  [62] = {.lex_state = 35},
  [63] = {.lex_state = 36},
  [64] = {.lex_state = 35},
  [65] = {.lex_state = 35},
  [66] = {.lex_state = 35},
  [67] = {.lex_state = 35},
  [68] = {.lex_state = 35},
  [69] = {.lex_state = 35},
  [70] = {.lex_state = 35},
  [71] = {.lex_state = 35},
  [72] = {.lex_state = 35},
  [73] = {.lex_state = 35},
  [74] = {.lex_state = 35},
  [75] = {.lex_state = 35},
  [76] = {.lex_state = 35},
  [77] = {.lex_state = 35},
  [78] = {.lex_state = 35},
  [79] = {.lex_state = 35},
  [80] = {.lex_state = 35},
  [81] = {.lex_state = 35},
  [82] = {.lex_state = 35},
  [83] = {.lex_state = 35},
  [84] = {.lex_state = 35},
  [85] = {.lex_state = 35},
  [86] = {.lex_state = 35},
  [87] = {.lex_state = 35},
  [88] = {.lex_state = 35},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 5},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 5},
  [120] = {.lex_state = 5},
  [121] = {.lex_state = 5},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 5},
  [125] = {.lex_state = 5},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 5},
  [128] = {.lex_state = 5},
  [129] = {.lex_state = 5},
  [130] = {.lex_state = 5},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 34},
  [164] = {.lex_state = 34},
  [165] = {.lex_state = 34},
  [166] = {.lex_state = 34},
  [167] = {.lex_state = 34},
  [168] = {.lex_state = 34},
  [169] = {.lex_state = 34},
  [170] = {.lex_state = 34},
  [171] = {.lex_state = 34},
  [172] = {.lex_state = 34},
  [173] = {.lex_state = 34},
  [174] = {.lex_state = 34},
  [175] = {.lex_state = 34},
  [176] = {.lex_state = 34},
  [177] = {.lex_state = 34},
  [178] = {.lex_state = 34},
  [179] = {.lex_state = 34},
  [180] = {.lex_state = 35},
  [181] = {.lex_state = 35},
  [182] = {.lex_state = 5},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 35},
  [185] = {.lex_state = 35},
  [186] = {.lex_state = 35},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 35},
  [190] = {.lex_state = 35},
  [191] = {.lex_state = 5},
  [192] = {.lex_state = 35},
  [193] = {.lex_state = 35},
  [194] = {.lex_state = 6},
  [195] = {.lex_state = 35},
  [196] = {.lex_state = 5},
  [197] = {.lex_state = 5},
  [198] = {.lex_state = 6},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 6},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 6},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 6},
  [214] = {.lex_state = 35},
  [215] = {.lex_state = 35},
  [216] = {.lex_state = 35},
  [217] = {.lex_state = 35},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 35},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 6},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 6},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 35},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 6},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 6},
  [232] = {.lex_state = 35},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 35},
  [236] = {.lex_state = 6},
  [237] = {.lex_state = 35},
  [238] = {.lex_state = 35},
  [239] = {.lex_state = 35},
  [240] = {.lex_state = 35},
  [241] = {.lex_state = 35},
  [242] = {.lex_state = 35},
  [243] = {.lex_state = 35},
  [244] = {.lex_state = 37},
  [245] = {.lex_state = 37},
  [246] = {.lex_state = 37},
  [247] = {.lex_state = 37},
  [248] = {.lex_state = 37},
  [249] = {.lex_state = 37},
  [250] = {.lex_state = 37},
  [251] = {.lex_state = 37},
  [252] = {.lex_state = 35},
  [253] = {.lex_state = 35},
  [254] = {.lex_state = 35},
  [255] = {.lex_state = 35},
  [256] = {.lex_state = 37},
  [257] = {.lex_state = 35},
  [258] = {.lex_state = 37},
  [259] = {.lex_state = 35},
  [260] = {.lex_state = 35},
  [261] = {.lex_state = 35},
  [262] = {.lex_state = 35},
  [263] = {.lex_state = 35},
  [264] = {.lex_state = 35},
  [265] = {.lex_state = 37},
  [266] = {.lex_state = 35},
  [267] = {.lex_state = 35},
  [268] = {.lex_state = 35},
  [269] = {.lex_state = 37},
  [270] = {.lex_state = 35},
  [271] = {.lex_state = 34},
  [272] = {.lex_state = 34},
  [273] = {.lex_state = 34},
  [274] = {.lex_state = 34},
  [275] = {.lex_state = 34},
  [276] = {.lex_state = 34},
  [277] = {.lex_state = 34},
  [278] = {.lex_state = 34},
  [279] = {.lex_state = 34},
  [280] = {.lex_state = 34},
  [281] = {.lex_state = 34},
  [282] = {.lex_state = 34},
  [283] = {.lex_state = 34},
  [284] = {.lex_state = 5},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 5},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 5},
  [290] = {.lex_state = 5},
  [291] = {.lex_state = 5},
  [292] = {.lex_state = 5},
  [293] = {.lex_state = 34},
  [294] = {.lex_state = 34},
  [295] = {.lex_state = 5},
  [296] = {.lex_state = 5},
  [297] = {.lex_state = 34},
  [298] = {.lex_state = 34},
  [299] = {.lex_state = 34},
  [300] = {.lex_state = 34},
  [301] = {.lex_state = 34},
  [302] = {.lex_state = 34},
  [303] = {.lex_state = 34},
  [304] = {.lex_state = 34},
  [305] = {.lex_state = 34},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 6},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 6},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 6},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 34},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 6},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 34},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 34},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 34},
  [388] = {.lex_state = 34},
  [389] = {.lex_state = 34},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 34},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_intersection_for] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_special_variable] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token2] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(377),
    [sym__item] = STATE(19),
    [sym_module_declaration] = STATE(19),
    [sym_function_declaration] = STATE(19),
    [sym__statement] = STATE(19),
    [sym_include_statement] = STATE(19),
    [sym_use_statement] = STATE(19),
    [sym_assignment] = STATE(376),
    [sym_union_block] = STATE(19),
    [sym_for_block] = STATE(19),
    [sym_intersection_for_block] = STATE(19),
    [sym_let_block] = STATE(19),
    [sym_assign_block] = STATE(19),
    [sym_if_block] = STATE(19),
    [sym_modifier_chain] = STATE(19),
    [sym_modifier] = STATE(174),
    [sym_transform_chain] = STATE(19),
    [sym_module_call] = STATE(175),
    [sym__variable_name] = STATE(375),
    [aux_sym_source_file_repeat1] = STATE(19),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_function] = ACTIONS(13),
    [anon_sym_include] = ACTIONS(15),
    [anon_sym_use] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_intersection_for] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_assign] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_PERCENT] = ACTIONS(31),
    [sym_special_variable] = ACTIONS(33),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 17,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [50] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_COMMA,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_RBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    STATE(215), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(340), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [135] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(71), 1,
      anon_sym_COMMA,
    ACTIONS(73), 1,
      anon_sym_RBRACK,
    STATE(235), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(331), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [220] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(75), 1,
      anon_sym_COMMA,
    ACTIONS(77), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(328), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [305] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [387] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [469] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(83), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [551] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(85), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(87), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [605] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(95), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [687] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(97), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [769] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(99), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [823] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(103), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(111), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(115), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1085] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(123), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1130] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(17), 1,
      anon_sym_use,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(125), 1,
      ts_builtin_sym_end,
    ACTIONS(127), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(37), 15,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_use_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(131), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1256] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(135), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(139), 1,
      anon_sym_for,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(143), 1,
      anon_sym_if,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(310), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(163), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1380] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    STATE(220), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(307), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1504] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(177), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1594] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(135), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(139), 1,
      anon_sym_for,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(143), 1,
      anon_sym_if,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(309), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1673] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(135), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(139), 1,
      anon_sym_for,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(143), 1,
      anon_sym_if,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(307), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(181), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(189), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1887] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    STATE(220), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(316), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(193), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(197), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(201), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2101] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2180] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 1,
      ts_builtin_sym_end,
    ACTIONS(205), 1,
      sym_identifier,
    ACTIONS(208), 1,
      anon_sym_SEMI,
    ACTIONS(211), 1,
      anon_sym_module,
    ACTIONS(214), 1,
      anon_sym_function,
    ACTIONS(217), 1,
      anon_sym_include,
    ACTIONS(220), 1,
      anon_sym_use,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(226), 1,
      anon_sym_for,
    ACTIONS(229), 1,
      anon_sym_intersection_for,
    ACTIONS(232), 1,
      anon_sym_let,
    ACTIONS(235), 1,
      anon_sym_assign,
    ACTIONS(238), 1,
      anon_sym_if,
    ACTIONS(244), 1,
      sym_special_variable,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(241), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(37), 15,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_use_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [2261] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(135), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(139), 1,
      anon_sym_for,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(143), 1,
      anon_sym_if,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(316), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2340] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    STATE(254), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(374), 2,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2418] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_each,
    STATE(253), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(374), 2,
      sym_each,
      sym_list_comprehension,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2496] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(247), 1,
      anon_sym_SEMI,
    ACTIONS(249), 1,
      anon_sym_function,
    ACTIONS(251), 1,
      anon_sym_RBRACE,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(47), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2573] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(257), 1,
      aux_sym_number_token2,
    ACTIONS(255), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(253), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2618] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(247), 1,
      anon_sym_SEMI,
    ACTIONS(249), 1,
      anon_sym_function,
    ACTIONS(259), 1,
      anon_sym_RBRACE,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(47), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2695] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(249), 1,
      anon_sym_function,
    ACTIONS(261), 1,
      anon_sym_SEMI,
    ACTIONS(263), 1,
      anon_sym_RBRACE,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(41), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2772] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(249), 1,
      anon_sym_function,
    ACTIONS(265), 1,
      anon_sym_SEMI,
    ACTIONS(267), 1,
      anon_sym_RBRACE,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(43), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2849] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(85), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(87), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2906] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      sym_identifier,
    ACTIONS(284), 1,
      anon_sym_SEMI,
    ACTIONS(287), 1,
      anon_sym_module,
    ACTIONS(290), 1,
      anon_sym_function,
    ACTIONS(293), 1,
      anon_sym_include,
    ACTIONS(296), 1,
      anon_sym_LBRACE,
    ACTIONS(299), 1,
      anon_sym_RBRACE,
    ACTIONS(301), 1,
      anon_sym_for,
    ACTIONS(304), 1,
      anon_sym_intersection_for,
    ACTIONS(307), 1,
      anon_sym_let,
    ACTIONS(310), 1,
      anon_sym_assign,
    ACTIONS(313), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_special_variable,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(316), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(47), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2983] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    ACTIONS(328), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(330), 1,
      anon_sym_AMP_AMP,
    ACTIONS(338), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(332), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(322), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(324), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3054] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    ACTIONS(328), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(330), 1,
      anon_sym_AMP_AMP,
    ACTIONS(338), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(332), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(340), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(342), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3125] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(99), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3176] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(101), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
    ACTIONS(99), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
  [3235] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
    ACTIONS(99), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3298] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(332), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(99), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3363] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(85), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(87), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3414] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    ACTIONS(330), 1,
      anon_sym_AMP_AMP,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(332), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(99), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3481] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    ACTIONS(328), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(330), 1,
      anon_sym_AMP_AMP,
    ACTIONS(338), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(332), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(346), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3552] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    ACTIONS(328), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(330), 1,
      anon_sym_AMP_AMP,
    ACTIONS(338), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(326), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(332), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(336), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(348), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(350), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3623] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_SLASH,
    ACTIONS(279), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(271), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(99), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3680] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      anon_sym_LPAREN,
    ACTIONS(273), 1,
      anon_sym_LBRACK,
    ACTIONS(275), 1,
      anon_sym_DOT,
    ACTIONS(279), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(99), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3733] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(197), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3817] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(99), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3881] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(366), 1,
      aux_sym_number_token2,
    ACTIONS(255), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(253), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(193), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(123), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(131), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(115), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4093] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4177] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(368), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(370), 1,
      anon_sym_AMP_AMP,
    ACTIONS(372), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(340), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(342), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(177), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(189), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(201), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4373] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(85), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(87), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4429] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(368), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(370), 1,
      anon_sym_AMP_AMP,
    ACTIONS(372), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(346), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4499] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(368), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(370), 1,
      anon_sym_AMP_AMP,
    ACTIONS(372), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(348), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(350), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4611] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(99), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(111), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4747] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(368), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(370), 1,
      anon_sym_AMP_AMP,
    ACTIONS(372), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(322), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(324), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4817] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(99), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(163), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(181), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4999] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(370), 1,
      anon_sym_AMP_AMP,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(99), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [5065] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(99), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 12,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [5123] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(352), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(354), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(99), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(101), 10,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [5185] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(374), 1,
      sym_identifier,
    ACTIONS(376), 1,
      anon_sym_RPAREN,
    ACTIONS(378), 1,
      sym_special_variable,
    STATE(232), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(342), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5254] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(374), 1,
      sym_identifier,
    ACTIONS(378), 1,
      sym_special_variable,
    ACTIONS(380), 1,
      anon_sym_RPAREN,
    STATE(217), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(336), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5323] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(374), 1,
      sym_identifier,
    ACTIONS(378), 1,
      sym_special_variable,
    ACTIONS(382), 1,
      anon_sym_RPAREN,
    STATE(226), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(330), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5392] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(374), 1,
      sym_identifier,
    ACTIONS(378), 1,
      sym_special_variable,
    STATE(239), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(356), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5458] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(57), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5519] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(185), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5580] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(266), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5641] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(192), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5702] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(243), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5763] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(180), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5824] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(193), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5885] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(195), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5946] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(186), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6007] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(184), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6068] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(12), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6129] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(260), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6190] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(240), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6251] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(261), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6312] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(267), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6373] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(81), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6434] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(190), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6495] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(189), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6556] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(54), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6617] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(202), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6678] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(259), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6739] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(254), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6800] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(270), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6861] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(204), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6922] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(49), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6983] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(203), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7044] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(12), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7105] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(237), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7166] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(209), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7227] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(87), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7288] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(238), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7349] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(88), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7410] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(199), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7471] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(262), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7532] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(264), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7593] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(255), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7654] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(253), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7715] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(9), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7776] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7837] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(62), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7898] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(86), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7959] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(82), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8020] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(78), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8081] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(208), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8142] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(207), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8203] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(50), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8264] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(51), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8325] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(52), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8386] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(76), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8447] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(268), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8508] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(75), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8569] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(210), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8630] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(200), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8691] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(74), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8752] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(201), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8813] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(206), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8874] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(53), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8935] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(55), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8996] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(48), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9057] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9118] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_function,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      anon_sym_BANG,
    ACTIONS(412), 1,
      aux_sym_number_token1,
    STATE(70), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(414), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9179] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(59), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9240] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(181), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9301] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(252), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9362] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(56), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9423] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      sym_identifier,
    ACTIONS(386), 1,
      anon_sym_LPAREN,
    ACTIONS(388), 1,
      anon_sym_function,
    ACTIONS(390), 1,
      anon_sym_let,
    ACTIONS(392), 1,
      anon_sym_BANG,
    ACTIONS(394), 1,
      sym_special_variable,
    ACTIONS(396), 1,
      sym_string,
    ACTIONS(398), 1,
      aux_sym_number_token1,
    ACTIONS(402), 1,
      anon_sym_LBRACK,
    STATE(46), 1,
      sym__expression,
    ACTIONS(400), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(404), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(68), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(77), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9484] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(263), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9545] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(9), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9606] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      sym_identifier,
    ACTIONS(137), 1,
      anon_sym_function,
    ACTIONS(141), 1,
      anon_sym_let,
    ACTIONS(145), 1,
      anon_sym_BANG,
    ACTIONS(147), 1,
      sym_special_variable,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym__expression,
    ACTIONS(153), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(159), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9667] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    STATE(257), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(69), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(24), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9728] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_SEMI,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(250), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9783] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(436), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(244), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9838] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(438), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(275), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9893] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(440), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(272), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9948] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(442), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(251), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10003] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(444), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(249), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10058] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(446), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(274), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10113] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(448), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(248), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10168] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(450), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(269), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10223] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(452), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(246), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10278] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(454), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(277), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10333] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(276), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10388] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(458), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(271), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10443] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(460), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(280), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10498] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(462), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(245), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10553] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(464), 1,
      anon_sym_SEMI,
    STATE(174), 1,
      sym_modifier,
    STATE(175), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(278), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10608] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_include,
    ACTIONS(424), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_for,
    ACTIONS(428), 1,
      anon_sym_intersection_for,
    ACTIONS(430), 1,
      anon_sym_let,
    ACTIONS(432), 1,
      anon_sym_assign,
    ACTIONS(434), 1,
      anon_sym_if,
    ACTIONS(466), 1,
      anon_sym_SEMI,
    STATE(172), 1,
      sym_module_call,
    STATE(177), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(258), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10663] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(99), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(101), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10709] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(322), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(490), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(494), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10831] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(99), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(101), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10879] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(85), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(87), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10925] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [10975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(498), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(502), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11039] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11097] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(348), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(506), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11187] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(99), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11229] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [11283] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 1,
      aux_sym_number_token2,
    ACTIONS(255), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(253), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11317] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [11369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(512), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(516), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11433] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(528), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(530), 1,
      anon_sym_AMP_AMP,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    ACTIONS(542), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(532), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(322), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [11490] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(99), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(101), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11535] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(99), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(101), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11582] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(99), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11621] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(85), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(87), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11666] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(528), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(530), 1,
      anon_sym_AMP_AMP,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    ACTIONS(542), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(532), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(348), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [11723] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(528), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(530), 1,
      anon_sym_AMP_AMP,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    ACTIONS(542), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(532), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [11780] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(528), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(530), 1,
      anon_sym_AMP_AMP,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    ACTIONS(542), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(532), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(544), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [11837] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(85), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(87), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11876] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(532), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [11927] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(530), 1,
      anon_sym_AMP_AMP,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(532), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [11980] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(99), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12021] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_LBRACK,
    ACTIONS(524), 1,
      anon_sym_DOT,
    ACTIONS(538), 1,
      anon_sym_SLASH,
    ACTIONS(540), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(520), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(526), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(534), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(536), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [12070] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 1,
      aux_sym_number_token2,
    ACTIONS(255), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(253), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12103] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(163), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(201), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12163] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(550), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(548), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [12221] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(552), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(548), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [12279] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(554), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12335] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(558), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_arguments,
    STATE(343), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(181), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(177), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12455] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(544), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [12511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12541] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(111), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12571] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12631] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12661] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(560), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_arguments,
    STATE(326), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12751] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(123), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(131), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(197), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(193), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12871] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_arguments,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(189), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12991] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(564), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(548), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [13049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(115), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13079] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(566), 1,
      anon_sym_COLON,
    ACTIONS(568), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13136] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(570), 1,
      anon_sym_COLON,
    ACTIONS(572), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13193] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(574), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13248] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(576), 1,
      anon_sym_COLON,
    ACTIONS(578), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13305] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(548), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [13360] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(580), 1,
      anon_sym_EQ,
    ACTIONS(167), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 17,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13391] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(582), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(586), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(590), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(594), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(598), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(600), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(602), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(606), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(610), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13641] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(614), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13669] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(616), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13723] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(618), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13777] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(620), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13831] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_RPAREN,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(626), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13913] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(628), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13967] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 1,
      anon_sym_else,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(632), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [13997] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(636), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14051] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(638), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14105] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(640), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14159] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(642), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14213] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(644), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14267] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(646), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14321] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(648), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(650), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14349] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(652), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14403] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(654), 1,
      anon_sym_COLON,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14457] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(656), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14511] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_else,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(632), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14541] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_DOT,
    ACTIONS(470), 1,
      anon_sym_SLASH,
    ACTIONS(472), 1,
      anon_sym_CARET,
    ACTIONS(476), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(478), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(660), 1,
      anon_sym_RBRACK,
    STATE(20), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(474), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(482), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(594), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14622] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(610), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14649] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(626), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(614), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(586), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(590), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(606), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(664), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(668), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(600), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(602), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(648), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(650), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(598), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(672), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(676), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(680), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(684), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(688), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(692), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15065] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(696), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(700), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15113] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(704), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(708), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [15161] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(710), 7,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(714), 7,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15203] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 1,
      sym_string,
    ACTIONS(151), 1,
      aux_sym_number_token1,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(718), 1,
      anon_sym_function,
    STATE(311), 1,
      sym__literal,
    ACTIONS(720), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [15233] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(722), 1,
      anon_sym_function,
    STATE(311), 1,
      sym__literal,
    ACTIONS(724), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(30), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [15263] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_COMMA,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(726), 2,
      sym_identifier,
      sym_special_variable,
    STATE(322), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15284] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(726), 2,
      sym_identifier,
      sym_special_variable,
    STATE(363), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15302] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(726), 2,
      sym_identifier,
      sym_special_variable,
    STATE(363), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15320] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      anon_sym_SEMI,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    STATE(308), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15340] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    STATE(321), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15357] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 1,
      anon_sym_RPAREN,
    STATE(338), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15374] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(726), 2,
      sym_identifier,
      sym_special_variable,
    STATE(363), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15389] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 1,
      anon_sym_RPAREN,
    STATE(324), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15406] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    STATE(334), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15423] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15433] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15443] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_SEMI,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(314), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_else,
    ACTIONS(756), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [15471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(760), 1,
      anon_sym_else,
    ACTIONS(756), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [15483] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15493] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
    ACTIONS(764), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [15507] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(323), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15521] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(769), 1,
      anon_sym_SEMI,
    ACTIONS(771), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15537] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15547] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(775), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15557] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(777), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15570] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(779), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15583] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    ACTIONS(781), 1,
      anon_sym_EQ,
    STATE(294), 1,
      sym_arguments,
  [15596] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    ACTIONS(783), 1,
      anon_sym_COMMA,
    STATE(344), 1,
      aux_sym_parameters_declaration_repeat1,
  [15609] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(329), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15622] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(785), 1,
      anon_sym_COMMA,
    ACTIONS(787), 1,
      anon_sym_RPAREN,
    STATE(320), 1,
      aux_sym_parameters_declaration_repeat1,
  [15635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15644] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(789), 1,
      anon_sym_RPAREN,
    STATE(333), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15657] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      anon_sym_RBRACK,
    ACTIONS(791), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15670] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(793), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 1,
      anon_sym_COMMA,
    ACTIONS(798), 1,
      anon_sym_RBRACK,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15696] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_COMMA,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
    STATE(325), 1,
      aux_sym_list_repeat1,
  [15709] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(771), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15722] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(560), 1,
      anon_sym_RPAREN,
    STATE(326), 1,
      aux_sym_arguments_repeat1,
  [15735] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 1,
      anon_sym_COMMA,
    ACTIONS(806), 1,
      anon_sym_RBRACK,
    STATE(341), 1,
      aux_sym_list_repeat1,
  [15748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      anon_sym_EQ,
    ACTIONS(808), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15759] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(812), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15772] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
    STATE(335), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15785] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(816), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15798] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(558), 1,
      anon_sym_RPAREN,
    STATE(343), 1,
      aux_sym_arguments_repeat1,
  [15811] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 1,
      anon_sym_RPAREN,
    ACTIONS(818), 1,
      anon_sym_COMMA,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15824] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(821), 1,
      anon_sym_RPAREN,
    STATE(318), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15837] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 1,
      anon_sym_LPAREN,
    STATE(28), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [15848] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    ACTIONS(827), 1,
      anon_sym_RBRACK,
    STATE(345), 1,
      aux_sym_list_repeat1,
  [15861] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_RBRACK,
    ACTIONS(829), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15874] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [15887] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COMMA,
    ACTIONS(831), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15900] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(836), 1,
      anon_sym_RPAREN,
    STATE(344), 1,
      aux_sym_parameters_declaration_repeat1,
  [15913] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      anon_sym_RBRACK,
    ACTIONS(838), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 1,
      anon_sym_LPAREN,
    STATE(23), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [15937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(157), 1,
      sym_parameters_declaration,
  [15947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(169), 1,
      sym_parenthesized_assignments,
  [15957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_parenthesized_assignments,
  [15967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(27), 1,
      sym_parenthesized_expression,
  [15977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(110), 1,
      sym_parameters_declaration,
  [15987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      sym_parenthesized_expression,
  [15997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [16005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(143), 1,
      sym_parameters_declaration,
  [16015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_parenthesized_assignments,
  [16025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(171), 1,
      sym_parenthesized_expression,
  [16043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LPAREN,
    STATE(294), 1,
      sym_arguments,
  [16053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(176), 1,
      sym_parenthesized_assignments,
  [16063] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(173), 1,
      sym_parenthesized_assignments,
  [16073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(93), 1,
      sym_parenthesized_assignments,
  [16083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(166), 1,
      sym_parenthesized_assignments,
  [16093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(380), 1,
      sym_parameters_declaration,
  [16111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_parenthesized_expression,
  [16121] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(167), 1,
      sym_parenthesized_assignments,
  [16131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(163), 1,
      sym_parenthesized_assignments,
  [16141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(168), 1,
      sym_parenthesized_assignments,
  [16151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(178), 1,
      sym_parameters_declaration,
  [16161] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(170), 1,
      sym_parenthesized_assignments,
  [16171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(116), 1,
      sym_parameters_declaration,
  [16181] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_LPAREN,
    STATE(118), 1,
      sym_parenthesized_assignments,
  [16191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LPAREN,
    STATE(381), 1,
      sym_parameters_declaration,
  [16201] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 1,
      anon_sym_RPAREN,
  [16208] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      anon_sym_EQ,
  [16215] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_SEMI,
  [16222] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      ts_builtin_sym_end,
  [16229] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 1,
      sym_include_path,
  [16236] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 1,
      sym_identifier,
  [16243] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      anon_sym_EQ,
  [16250] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 1,
      anon_sym_EQ,
  [16257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 1,
      sym_identifier,
  [16264] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
  [16271] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 1,
      anon_sym_RPAREN,
  [16278] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 1,
      sym_include_path,
  [16285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_include_path,
  [16292] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      sym_identifier,
  [16299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      sym_identifier,
  [16306] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 1,
      sym_identifier,
  [16313] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_RBRACK,
  [16320] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_RBRACK,
  [16327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 50,
  [SMALL_STATE(4)] = 135,
  [SMALL_STATE(5)] = 220,
  [SMALL_STATE(6)] = 305,
  [SMALL_STATE(7)] = 387,
  [SMALL_STATE(8)] = 469,
  [SMALL_STATE(9)] = 551,
  [SMALL_STATE(10)] = 605,
  [SMALL_STATE(11)] = 687,
  [SMALL_STATE(12)] = 769,
  [SMALL_STATE(13)] = 823,
  [SMALL_STATE(14)] = 905,
  [SMALL_STATE(15)] = 950,
  [SMALL_STATE(16)] = 995,
  [SMALL_STATE(17)] = 1040,
  [SMALL_STATE(18)] = 1085,
  [SMALL_STATE(19)] = 1130,
  [SMALL_STATE(20)] = 1211,
  [SMALL_STATE(21)] = 1256,
  [SMALL_STATE(22)] = 1335,
  [SMALL_STATE(23)] = 1380,
  [SMALL_STATE(24)] = 1459,
  [SMALL_STATE(25)] = 1504,
  [SMALL_STATE(26)] = 1549,
  [SMALL_STATE(27)] = 1594,
  [SMALL_STATE(28)] = 1673,
  [SMALL_STATE(29)] = 1752,
  [SMALL_STATE(30)] = 1797,
  [SMALL_STATE(31)] = 1842,
  [SMALL_STATE(32)] = 1887,
  [SMALL_STATE(33)] = 1966,
  [SMALL_STATE(34)] = 2011,
  [SMALL_STATE(35)] = 2056,
  [SMALL_STATE(36)] = 2101,
  [SMALL_STATE(37)] = 2180,
  [SMALL_STATE(38)] = 2261,
  [SMALL_STATE(39)] = 2340,
  [SMALL_STATE(40)] = 2418,
  [SMALL_STATE(41)] = 2496,
  [SMALL_STATE(42)] = 2573,
  [SMALL_STATE(43)] = 2618,
  [SMALL_STATE(44)] = 2695,
  [SMALL_STATE(45)] = 2772,
  [SMALL_STATE(46)] = 2849,
  [SMALL_STATE(47)] = 2906,
  [SMALL_STATE(48)] = 2983,
  [SMALL_STATE(49)] = 3054,
  [SMALL_STATE(50)] = 3125,
  [SMALL_STATE(51)] = 3176,
  [SMALL_STATE(52)] = 3235,
  [SMALL_STATE(53)] = 3298,
  [SMALL_STATE(54)] = 3363,
  [SMALL_STATE(55)] = 3414,
  [SMALL_STATE(56)] = 3481,
  [SMALL_STATE(57)] = 3552,
  [SMALL_STATE(58)] = 3623,
  [SMALL_STATE(59)] = 3680,
  [SMALL_STATE(60)] = 3733,
  [SMALL_STATE(61)] = 3775,
  [SMALL_STATE(62)] = 3817,
  [SMALL_STATE(63)] = 3881,
  [SMALL_STATE(64)] = 3925,
  [SMALL_STATE(65)] = 3967,
  [SMALL_STATE(66)] = 4009,
  [SMALL_STATE(67)] = 4051,
  [SMALL_STATE(68)] = 4093,
  [SMALL_STATE(69)] = 4135,
  [SMALL_STATE(70)] = 4177,
  [SMALL_STATE(71)] = 4247,
  [SMALL_STATE(72)] = 4289,
  [SMALL_STATE(73)] = 4331,
  [SMALL_STATE(74)] = 4373,
  [SMALL_STATE(75)] = 4429,
  [SMALL_STATE(76)] = 4499,
  [SMALL_STATE(77)] = 4569,
  [SMALL_STATE(78)] = 4611,
  [SMALL_STATE(79)] = 4663,
  [SMALL_STATE(80)] = 4705,
  [SMALL_STATE(81)] = 4747,
  [SMALL_STATE(82)] = 4817,
  [SMALL_STATE(83)] = 4873,
  [SMALL_STATE(84)] = 4915,
  [SMALL_STATE(85)] = 4957,
  [SMALL_STATE(86)] = 4999,
  [SMALL_STATE(87)] = 5065,
  [SMALL_STATE(88)] = 5123,
  [SMALL_STATE(89)] = 5185,
  [SMALL_STATE(90)] = 5254,
  [SMALL_STATE(91)] = 5323,
  [SMALL_STATE(92)] = 5392,
  [SMALL_STATE(93)] = 5458,
  [SMALL_STATE(94)] = 5519,
  [SMALL_STATE(95)] = 5580,
  [SMALL_STATE(96)] = 5641,
  [SMALL_STATE(97)] = 5702,
  [SMALL_STATE(98)] = 5763,
  [SMALL_STATE(99)] = 5824,
  [SMALL_STATE(100)] = 5885,
  [SMALL_STATE(101)] = 5946,
  [SMALL_STATE(102)] = 6007,
  [SMALL_STATE(103)] = 6068,
  [SMALL_STATE(104)] = 6129,
  [SMALL_STATE(105)] = 6190,
  [SMALL_STATE(106)] = 6251,
  [SMALL_STATE(107)] = 6312,
  [SMALL_STATE(108)] = 6373,
  [SMALL_STATE(109)] = 6434,
  [SMALL_STATE(110)] = 6495,
  [SMALL_STATE(111)] = 6556,
  [SMALL_STATE(112)] = 6617,
  [SMALL_STATE(113)] = 6678,
  [SMALL_STATE(114)] = 6739,
  [SMALL_STATE(115)] = 6800,
  [SMALL_STATE(116)] = 6861,
  [SMALL_STATE(117)] = 6922,
  [SMALL_STATE(118)] = 6983,
  [SMALL_STATE(119)] = 7044,
  [SMALL_STATE(120)] = 7105,
  [SMALL_STATE(121)] = 7166,
  [SMALL_STATE(122)] = 7227,
  [SMALL_STATE(123)] = 7288,
  [SMALL_STATE(124)] = 7349,
  [SMALL_STATE(125)] = 7410,
  [SMALL_STATE(126)] = 7471,
  [SMALL_STATE(127)] = 7532,
  [SMALL_STATE(128)] = 7593,
  [SMALL_STATE(129)] = 7654,
  [SMALL_STATE(130)] = 7715,
  [SMALL_STATE(131)] = 7776,
  [SMALL_STATE(132)] = 7837,
  [SMALL_STATE(133)] = 7898,
  [SMALL_STATE(134)] = 7959,
  [SMALL_STATE(135)] = 8020,
  [SMALL_STATE(136)] = 8081,
  [SMALL_STATE(137)] = 8142,
  [SMALL_STATE(138)] = 8203,
  [SMALL_STATE(139)] = 8264,
  [SMALL_STATE(140)] = 8325,
  [SMALL_STATE(141)] = 8386,
  [SMALL_STATE(142)] = 8447,
  [SMALL_STATE(143)] = 8508,
  [SMALL_STATE(144)] = 8569,
  [SMALL_STATE(145)] = 8630,
  [SMALL_STATE(146)] = 8691,
  [SMALL_STATE(147)] = 8752,
  [SMALL_STATE(148)] = 8813,
  [SMALL_STATE(149)] = 8874,
  [SMALL_STATE(150)] = 8935,
  [SMALL_STATE(151)] = 8996,
  [SMALL_STATE(152)] = 9057,
  [SMALL_STATE(153)] = 9118,
  [SMALL_STATE(154)] = 9179,
  [SMALL_STATE(155)] = 9240,
  [SMALL_STATE(156)] = 9301,
  [SMALL_STATE(157)] = 9362,
  [SMALL_STATE(158)] = 9423,
  [SMALL_STATE(159)] = 9484,
  [SMALL_STATE(160)] = 9545,
  [SMALL_STATE(161)] = 9606,
  [SMALL_STATE(162)] = 9667,
  [SMALL_STATE(163)] = 9728,
  [SMALL_STATE(164)] = 9783,
  [SMALL_STATE(165)] = 9838,
  [SMALL_STATE(166)] = 9893,
  [SMALL_STATE(167)] = 9948,
  [SMALL_STATE(168)] = 10003,
  [SMALL_STATE(169)] = 10058,
  [SMALL_STATE(170)] = 10113,
  [SMALL_STATE(171)] = 10168,
  [SMALL_STATE(172)] = 10223,
  [SMALL_STATE(173)] = 10278,
  [SMALL_STATE(174)] = 10333,
  [SMALL_STATE(175)] = 10388,
  [SMALL_STATE(176)] = 10443,
  [SMALL_STATE(177)] = 10498,
  [SMALL_STATE(178)] = 10553,
  [SMALL_STATE(179)] = 10608,
  [SMALL_STATE(180)] = 10663,
  [SMALL_STATE(181)] = 10709,
  [SMALL_STATE(182)] = 10767,
  [SMALL_STATE(183)] = 10799,
  [SMALL_STATE(184)] = 10831,
  [SMALL_STATE(185)] = 10879,
  [SMALL_STATE(186)] = 10925,
  [SMALL_STATE(187)] = 10975,
  [SMALL_STATE(188)] = 11007,
  [SMALL_STATE(189)] = 11039,
  [SMALL_STATE(190)] = 11097,
  [SMALL_STATE(191)] = 11155,
  [SMALL_STATE(192)] = 11187,
  [SMALL_STATE(193)] = 11229,
  [SMALL_STATE(194)] = 11283,
  [SMALL_STATE(195)] = 11317,
  [SMALL_STATE(196)] = 11369,
  [SMALL_STATE(197)] = 11401,
  [SMALL_STATE(198)] = 11433,
  [SMALL_STATE(199)] = 11490,
  [SMALL_STATE(200)] = 11535,
  [SMALL_STATE(201)] = 11582,
  [SMALL_STATE(202)] = 11621,
  [SMALL_STATE(203)] = 11666,
  [SMALL_STATE(204)] = 11723,
  [SMALL_STATE(205)] = 11780,
  [SMALL_STATE(206)] = 11837,
  [SMALL_STATE(207)] = 11876,
  [SMALL_STATE(208)] = 11927,
  [SMALL_STATE(209)] = 11980,
  [SMALL_STATE(210)] = 12021,
  [SMALL_STATE(211)] = 12070,
  [SMALL_STATE(212)] = 12103,
  [SMALL_STATE(213)] = 12133,
  [SMALL_STATE(214)] = 12163,
  [SMALL_STATE(215)] = 12221,
  [SMALL_STATE(216)] = 12279,
  [SMALL_STATE(217)] = 12335,
  [SMALL_STATE(218)] = 12395,
  [SMALL_STATE(219)] = 12425,
  [SMALL_STATE(220)] = 12455,
  [SMALL_STATE(221)] = 12511,
  [SMALL_STATE(222)] = 12541,
  [SMALL_STATE(223)] = 12571,
  [SMALL_STATE(224)] = 12601,
  [SMALL_STATE(225)] = 12631,
  [SMALL_STATE(226)] = 12661,
  [SMALL_STATE(227)] = 12721,
  [SMALL_STATE(228)] = 12751,
  [SMALL_STATE(229)] = 12781,
  [SMALL_STATE(230)] = 12811,
  [SMALL_STATE(231)] = 12841,
  [SMALL_STATE(232)] = 12871,
  [SMALL_STATE(233)] = 12931,
  [SMALL_STATE(234)] = 12961,
  [SMALL_STATE(235)] = 12991,
  [SMALL_STATE(236)] = 13049,
  [SMALL_STATE(237)] = 13079,
  [SMALL_STATE(238)] = 13136,
  [SMALL_STATE(239)] = 13193,
  [SMALL_STATE(240)] = 13248,
  [SMALL_STATE(241)] = 13305,
  [SMALL_STATE(242)] = 13360,
  [SMALL_STATE(243)] = 13391,
  [SMALL_STATE(244)] = 13445,
  [SMALL_STATE(245)] = 13473,
  [SMALL_STATE(246)] = 13501,
  [SMALL_STATE(247)] = 13529,
  [SMALL_STATE(248)] = 13557,
  [SMALL_STATE(249)] = 13585,
  [SMALL_STATE(250)] = 13613,
  [SMALL_STATE(251)] = 13641,
  [SMALL_STATE(252)] = 13669,
  [SMALL_STATE(253)] = 13723,
  [SMALL_STATE(254)] = 13777,
  [SMALL_STATE(255)] = 13831,
  [SMALL_STATE(256)] = 13885,
  [SMALL_STATE(257)] = 13913,
  [SMALL_STATE(258)] = 13967,
  [SMALL_STATE(259)] = 13997,
  [SMALL_STATE(260)] = 14051,
  [SMALL_STATE(261)] = 14105,
  [SMALL_STATE(262)] = 14159,
  [SMALL_STATE(263)] = 14213,
  [SMALL_STATE(264)] = 14267,
  [SMALL_STATE(265)] = 14321,
  [SMALL_STATE(266)] = 14349,
  [SMALL_STATE(267)] = 14403,
  [SMALL_STATE(268)] = 14457,
  [SMALL_STATE(269)] = 14511,
  [SMALL_STATE(270)] = 14541,
  [SMALL_STATE(271)] = 14595,
  [SMALL_STATE(272)] = 14622,
  [SMALL_STATE(273)] = 14649,
  [SMALL_STATE(274)] = 14676,
  [SMALL_STATE(275)] = 14703,
  [SMALL_STATE(276)] = 14730,
  [SMALL_STATE(277)] = 14757,
  [SMALL_STATE(278)] = 14784,
  [SMALL_STATE(279)] = 14811,
  [SMALL_STATE(280)] = 14838,
  [SMALL_STATE(281)] = 14865,
  [SMALL_STATE(282)] = 14892,
  [SMALL_STATE(283)] = 14919,
  [SMALL_STATE(284)] = 14945,
  [SMALL_STATE(285)] = 14969,
  [SMALL_STATE(286)] = 14993,
  [SMALL_STATE(287)] = 15017,
  [SMALL_STATE(288)] = 15041,
  [SMALL_STATE(289)] = 15065,
  [SMALL_STATE(290)] = 15089,
  [SMALL_STATE(291)] = 15113,
  [SMALL_STATE(292)] = 15137,
  [SMALL_STATE(293)] = 15161,
  [SMALL_STATE(294)] = 15182,
  [SMALL_STATE(295)] = 15203,
  [SMALL_STATE(296)] = 15233,
  [SMALL_STATE(297)] = 15263,
  [SMALL_STATE(298)] = 15284,
  [SMALL_STATE(299)] = 15302,
  [SMALL_STATE(300)] = 15320,
  [SMALL_STATE(301)] = 15340,
  [SMALL_STATE(302)] = 15357,
  [SMALL_STATE(303)] = 15374,
  [SMALL_STATE(304)] = 15389,
  [SMALL_STATE(305)] = 15406,
  [SMALL_STATE(306)] = 15423,
  [SMALL_STATE(307)] = 15433,
  [SMALL_STATE(308)] = 15443,
  [SMALL_STATE(309)] = 15459,
  [SMALL_STATE(310)] = 15471,
  [SMALL_STATE(311)] = 15483,
  [SMALL_STATE(312)] = 15493,
  [SMALL_STATE(313)] = 15507,
  [SMALL_STATE(314)] = 15521,
  [SMALL_STATE(315)] = 15537,
  [SMALL_STATE(316)] = 15547,
  [SMALL_STATE(317)] = 15557,
  [SMALL_STATE(318)] = 15570,
  [SMALL_STATE(319)] = 15583,
  [SMALL_STATE(320)] = 15596,
  [SMALL_STATE(321)] = 15609,
  [SMALL_STATE(322)] = 15622,
  [SMALL_STATE(323)] = 15635,
  [SMALL_STATE(324)] = 15644,
  [SMALL_STATE(325)] = 15657,
  [SMALL_STATE(326)] = 15670,
  [SMALL_STATE(327)] = 15683,
  [SMALL_STATE(328)] = 15696,
  [SMALL_STATE(329)] = 15709,
  [SMALL_STATE(330)] = 15722,
  [SMALL_STATE(331)] = 15735,
  [SMALL_STATE(332)] = 15748,
  [SMALL_STATE(333)] = 15759,
  [SMALL_STATE(334)] = 15772,
  [SMALL_STATE(335)] = 15785,
  [SMALL_STATE(336)] = 15798,
  [SMALL_STATE(337)] = 15811,
  [SMALL_STATE(338)] = 15824,
  [SMALL_STATE(339)] = 15837,
  [SMALL_STATE(340)] = 15848,
  [SMALL_STATE(341)] = 15861,
  [SMALL_STATE(342)] = 15874,
  [SMALL_STATE(343)] = 15887,
  [SMALL_STATE(344)] = 15900,
  [SMALL_STATE(345)] = 15913,
  [SMALL_STATE(346)] = 15926,
  [SMALL_STATE(347)] = 15937,
  [SMALL_STATE(348)] = 15947,
  [SMALL_STATE(349)] = 15957,
  [SMALL_STATE(350)] = 15967,
  [SMALL_STATE(351)] = 15977,
  [SMALL_STATE(352)] = 15987,
  [SMALL_STATE(353)] = 15997,
  [SMALL_STATE(354)] = 16005,
  [SMALL_STATE(355)] = 16015,
  [SMALL_STATE(356)] = 16025,
  [SMALL_STATE(357)] = 16033,
  [SMALL_STATE(358)] = 16043,
  [SMALL_STATE(359)] = 16053,
  [SMALL_STATE(360)] = 16063,
  [SMALL_STATE(361)] = 16073,
  [SMALL_STATE(362)] = 16083,
  [SMALL_STATE(363)] = 16093,
  [SMALL_STATE(364)] = 16101,
  [SMALL_STATE(365)] = 16111,
  [SMALL_STATE(366)] = 16121,
  [SMALL_STATE(367)] = 16131,
  [SMALL_STATE(368)] = 16141,
  [SMALL_STATE(369)] = 16151,
  [SMALL_STATE(370)] = 16161,
  [SMALL_STATE(371)] = 16171,
  [SMALL_STATE(372)] = 16181,
  [SMALL_STATE(373)] = 16191,
  [SMALL_STATE(374)] = 16201,
  [SMALL_STATE(375)] = 16208,
  [SMALL_STATE(376)] = 16215,
  [SMALL_STATE(377)] = 16222,
  [SMALL_STATE(378)] = 16229,
  [SMALL_STATE(379)] = 16236,
  [SMALL_STATE(380)] = 16243,
  [SMALL_STATE(381)] = 16250,
  [SMALL_STATE(382)] = 16257,
  [SMALL_STATE(383)] = 16264,
  [SMALL_STATE(384)] = 16271,
  [SMALL_STATE(385)] = 16278,
  [SMALL_STATE(386)] = 16285,
  [SMALL_STATE(387)] = 16292,
  [SMALL_STATE(388)] = 16299,
  [SMALL_STATE(389)] = 16306,
  [SMALL_STATE(390)] = 16313,
  [SMALL_STATE(391)] = 16320,
  [SMALL_STATE(392)] = 16327,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [35] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [161] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 7, .production_id = 15),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 7, .production_id = 15),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [191] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, .production_id = 11),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, .production_id = 11),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [205] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(319),
  [208] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(37),
  [211] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(389),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(387),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(386),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(385),
  [223] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(44),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(359),
  [229] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(360),
  [232] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(362),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(348),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(365),
  [241] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(293),
  [244] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(375),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [281] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(319),
  [284] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(47),
  [287] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(389),
  [290] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(388),
  [293] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(386),
  [296] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(44),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2),
  [301] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(359),
  [304] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(360),
  [307] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(362),
  [310] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(348),
  [313] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(365),
  [316] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(293),
  [319] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(375),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 3, .production_id = 8),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 3, .production_id = 8),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 4),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 4),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 2),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 2),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 3),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 3),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 4),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 4),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 3),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 3),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 5),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 5),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 2),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 2),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comprehension_cell, 1),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_cell, 1),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 4),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [580] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier_chain, 2),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier_chain, 2),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 2),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 2),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 3),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 3),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [610] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [614] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 2),
  [626] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 2),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [634] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2),
  [650] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 2),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [658] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 2),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__item, 2),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 2),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_use_statement, 2),
  [674] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [690] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [692] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [694] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 5, .production_id = 14),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 5, .production_id = 14),
  [702] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [704] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [706] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [710] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier, 1),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier, 1),
  [714] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comprehension_cell, 3),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 3),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 3),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 2),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2),
  [766] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2), SHIFT_REPEAT(313),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_comprehension, 1),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 5, .production_id = 13),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_name, 1),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [795] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(36),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_declaration, 1),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [818] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(92),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [833] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2), SHIFT_REPEAT(303),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [848] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_openscad(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
