#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 387
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 99
#define ALIAS_COUNT 0
#define TOKEN_COUNT 49
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_SEMI = 3,
  anon_sym_module = 4,
  anon_sym_LPAREN = 5,
  anon_sym_COMMA = 6,
  anon_sym_RPAREN = 7,
  anon_sym_function = 8,
  anon_sym_EQ = 9,
  anon_sym_include = 10,
  anon_sym_use = 11,
  sym_include_path = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_for = 15,
  anon_sym_intersection_for = 16,
  anon_sym_let = 17,
  anon_sym_assign = 18,
  anon_sym_if = 19,
  anon_sym_else = 20,
  anon_sym_STAR = 21,
  anon_sym_BANG = 22,
  anon_sym_POUND = 23,
  anon_sym_PERCENT = 24,
  sym_special_variable = 25,
  sym_string = 26,
  aux_sym_number_token1 = 27,
  aux_sym_number_token2 = 28,
  anon_sym_true = 29,
  anon_sym_false = 30,
  anon_sym_LBRACK = 31,
  anon_sym_COLON = 32,
  anon_sym_RBRACK = 33,
  anon_sym_each = 34,
  anon_sym_DOT = 35,
  anon_sym_DASH = 36,
  anon_sym_PLUS = 37,
  anon_sym_PIPE_PIPE = 38,
  anon_sym_AMP_AMP = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_BANG_EQ = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_LT_EQ = 44,
  anon_sym_GT_EQ = 45,
  anon_sym_SLASH = 46,
  anon_sym_CARET = 47,
  anon_sym_QMARK = 48,
  sym_source_file = 49,
  sym__item = 50,
  sym_module_declaration = 51,
  sym_parameters_declaration = 52,
  sym__parameter_declaration = 53,
  sym_function_declaration = 54,
  sym__statement = 55,
  sym_include_statement = 56,
  sym_use_statement = 57,
  sym_assignment = 58,
  sym_union_block = 59,
  sym_for_block = 60,
  sym_intersection_for_block = 61,
  sym_let_block = 62,
  sym_assign_block = 63,
  sym_if_block = 64,
  sym_modifier_chain = 65,
  sym_modifier = 66,
  sym_transform_chain = 67,
  sym_module_call = 68,
  sym_arguments = 69,
  sym_parenthesized_assignments = 70,
  sym_parenthesized_expression = 71,
  sym_condition_update_clause = 72,
  sym__expression = 73,
  sym_let_expression = 74,
  sym__variable_name = 75,
  sym__literal = 76,
  sym_number = 77,
  sym_boolean = 78,
  sym_function = 79,
  sym_range = 80,
  sym_list = 81,
  sym__list_cell = 82,
  sym_each = 83,
  sym_list_comprehension = 84,
  sym_for_clause = 85,
  sym_if_clause = 86,
  sym_function_call = 87,
  sym_index_expression = 88,
  sym_dot_index_expression = 89,
  sym_unary_expression = 90,
  sym_binary_expression = 91,
  sym_ternary_expression = 92,
  aux_sym_source_file_repeat1 = 93,
  aux_sym_parameters_declaration_repeat1 = 94,
  aux_sym_union_block_repeat1 = 95,
  aux_sym_arguments_repeat1 = 96,
  aux_sym_parenthesized_assignments_repeat1 = 97,
  aux_sym_list_repeat1 = 98,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_SEMI] = ";",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_include] = "include",
  [anon_sym_use] = "use",
  [sym_include_path] = "include_path",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_for] = "for",
  [anon_sym_intersection_for] = "intersection_for",
  [anon_sym_let] = "let",
  [anon_sym_assign] = "assign",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_STAR] = "*",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_PERCENT] = "%",
  [sym_special_variable] = "special_variable",
  [sym_string] = "string",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACK] = "]",
  [anon_sym_each] = "each",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_QMARK] = "\?",
  [sym_source_file] = "source_file",
  [sym__item] = "_item",
  [sym_module_declaration] = "module_declaration",
  [sym_parameters_declaration] = "parameters_declaration",
  [sym__parameter_declaration] = "_parameter_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__statement] = "_statement",
  [sym_include_statement] = "include_statement",
  [sym_use_statement] = "use_statement",
  [sym_assignment] = "assignment",
  [sym_union_block] = "union_block",
  [sym_for_block] = "for_block",
  [sym_intersection_for_block] = "intersection_for_block",
  [sym_let_block] = "let_block",
  [sym_assign_block] = "assign_block",
  [sym_if_block] = "if_block",
  [sym_modifier_chain] = "modifier_chain",
  [sym_modifier] = "modifier",
  [sym_transform_chain] = "transform_chain",
  [sym_module_call] = "module_call",
  [sym_arguments] = "arguments",
  [sym_parenthesized_assignments] = "parenthesized_assignments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition_update_clause] = "condition_update_clause",
  [sym__expression] = "_expression",
  [sym_let_expression] = "let_expression",
  [sym__variable_name] = "_variable_name",
  [sym__literal] = "_literal",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_function] = "function",
  [sym_range] = "range",
  [sym_list] = "list",
  [sym__list_cell] = "_list_cell",
  [sym_each] = "each",
  [sym_list_comprehension] = "list_comprehension",
  [sym_for_clause] = "for_clause",
  [sym_if_clause] = "if_clause",
  [sym_function_call] = "function_call",
  [sym_index_expression] = "index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_parameters_declaration_repeat1] = "parameters_declaration_repeat1",
  [aux_sym_union_block_repeat1] = "union_block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parenthesized_assignments_repeat1] = "parenthesized_assignments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_use] = anon_sym_use,
  [sym_include_path] = sym_include_path,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_intersection_for] = anon_sym_intersection_for,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_special_variable] = sym_special_variable,
  [sym_string] = sym_string,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_source_file] = sym_source_file,
  [sym__item] = sym__item,
  [sym_module_declaration] = sym_module_declaration,
  [sym_parameters_declaration] = sym_parameters_declaration,
  [sym__parameter_declaration] = sym__parameter_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__statement] = sym__statement,
  [sym_include_statement] = sym_include_statement,
  [sym_use_statement] = sym_use_statement,
  [sym_assignment] = sym_assignment,
  [sym_union_block] = sym_union_block,
  [sym_for_block] = sym_for_block,
  [sym_intersection_for_block] = sym_intersection_for_block,
  [sym_let_block] = sym_let_block,
  [sym_assign_block] = sym_assign_block,
  [sym_if_block] = sym_if_block,
  [sym_modifier_chain] = sym_modifier_chain,
  [sym_modifier] = sym_modifier,
  [sym_transform_chain] = sym_transform_chain,
  [sym_module_call] = sym_module_call,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_assignments] = sym_parenthesized_assignments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition_update_clause] = sym_condition_update_clause,
  [sym__expression] = sym__expression,
  [sym_let_expression] = sym_let_expression,
  [sym__variable_name] = sym__variable_name,
  [sym__literal] = sym__literal,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_function] = sym_function,
  [sym_range] = sym_range,
  [sym_list] = sym_list,
  [sym__list_cell] = sym__list_cell,
  [sym_each] = sym_each,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_for_clause] = sym_for_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_function_call] = sym_function_call,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_parameters_declaration_repeat1] = aux_sym_parameters_declaration_repeat1,
  [aux_sym_union_block_repeat1] = aux_sym_union_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parenthesized_assignments_repeat1] = aux_sym_parenthesized_assignments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [sym_include_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intersection_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_special_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_union_block] = {
    .visible = true,
    .named = true,
  },
  [sym_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_transform_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_module_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_update_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_name] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_cell] = {
    .visible = false,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_end = 6,
  field_function = 7,
  field_increment = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_parameters = 13,
  field_right = 14,
  field_start = 15,
  field_update = 16,
  field_value = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_function] = "function",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 3},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 4},
  [10] = {.index = 20, .length = 2},
  [11] = {.index = 22, .length = 2},
  [12] = {.index = 24, .length = 3},
  [13] = {.index = 27, .length = 1},
  [14] = {.index = 28, .length = 3},
  [15] = {.index = 31, .length = 3},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 2},
  [18] = {.index = 38, .length = 3},
  [19] = {.index = 41, .length = 3},
  [20] = {.index = 44, .length = 3},
  [21] = {.index = 47, .length = 4},
  [22] = {.index = 51, .length = 4},
  [23] = {.index = 55, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_body, 2},
  [3] =
    {field_condition, 1},
    {field_consequence, 2},
  [5] =
    {field_left, 0},
    {field_right, 2},
  [7] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_name, 1},
    {field_parameters, 2},
  [14] =
    {field_body, 2},
    {field_parameters, 1},
  [16] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_index, 2},
    {field_value, 0},
  [22] =
    {field_end, 3},
    {field_start, 1},
  [24] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [27] =
    {field_condition, 2},
  [28] =
    {field_end, 5},
    {field_increment, 3},
    {field_start, 1},
  [31] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [34] =
    {field_condition, 2},
    {field_update, 4},
  [36] =
    {field_condition, 3},
    {field_initializer, 1},
  [38] =
    {field_condition, 2},
    {field_update, 4},
    {field_update, 5},
  [41] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
  [44] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
  [47] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
    {field_update, 6},
  [51] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
  [55] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(25)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(58);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(5)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(6)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(6)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(46);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(79);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(48);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 22:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(40);
      if (lookahead == '\r') ADVANCE(41);
      END_STATE();
    case 24:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 25:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 26:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 27:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 28:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 29:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 30:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 31:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      if (lookahead == '\r') SKIP(30)
      END_STATE();
    case 32:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      END_STATE();
    case 33:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      if (lookahead == '\r') SKIP(32)
      END_STATE();
    case 34:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 35:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 36:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(31)
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 37:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '\\') SKIP(33)
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(23);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_include_path);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_special_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 't') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == 's') ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(16);
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(24);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(27);
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 23:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 33:
      if (lookahead == 'g') ADVANCE(41);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 44:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(56);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 56:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == '_') ADVANCE(61);
      END_STATE();
    case 61:
      if (lookahead == 'f') ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_intersection_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 34},
  [3] = {.lex_state = 35},
  [4] = {.lex_state = 35},
  [5] = {.lex_state = 35},
  [6] = {.lex_state = 34},
  [7] = {.lex_state = 35},
  [8] = {.lex_state = 35},
  [9] = {.lex_state = 35},
  [10] = {.lex_state = 35},
  [11] = {.lex_state = 35},
  [12] = {.lex_state = 5},
  [13] = {.lex_state = 35},
  [14] = {.lex_state = 35},
  [15] = {.lex_state = 35},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 35},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 34},
  [20] = {.lex_state = 5},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 35},
  [23] = {.lex_state = 35},
  [24] = {.lex_state = 35},
  [25] = {.lex_state = 35},
  [26] = {.lex_state = 35},
  [27] = {.lex_state = 5},
  [28] = {.lex_state = 5},
  [29] = {.lex_state = 35},
  [30] = {.lex_state = 5},
  [31] = {.lex_state = 5},
  [32] = {.lex_state = 5},
  [33] = {.lex_state = 5},
  [34] = {.lex_state = 5},
  [35] = {.lex_state = 5},
  [36] = {.lex_state = 34},
  [37] = {.lex_state = 35},
  [38] = {.lex_state = 35},
  [39] = {.lex_state = 34},
  [40] = {.lex_state = 34},
  [41] = {.lex_state = 34},
  [42] = {.lex_state = 35},
  [43] = {.lex_state = 36},
  [44] = {.lex_state = 35},
  [45] = {.lex_state = 35},
  [46] = {.lex_state = 35},
  [47] = {.lex_state = 5},
  [48] = {.lex_state = 5},
  [49] = {.lex_state = 35},
  [50] = {.lex_state = 35},
  [51] = {.lex_state = 5},
  [52] = {.lex_state = 35},
  [53] = {.lex_state = 35},
  [54] = {.lex_state = 35},
  [55] = {.lex_state = 35},
  [56] = {.lex_state = 34},
  [57] = {.lex_state = 35},
  [58] = {.lex_state = 35},
  [59] = {.lex_state = 35},
  [60] = {.lex_state = 35},
  [61] = {.lex_state = 35},
  [62] = {.lex_state = 35},
  [63] = {.lex_state = 35},
  [64] = {.lex_state = 35},
  [65] = {.lex_state = 35},
  [66] = {.lex_state = 35},
  [67] = {.lex_state = 35},
  [68] = {.lex_state = 35},
  [69] = {.lex_state = 35},
  [70] = {.lex_state = 35},
  [71] = {.lex_state = 35},
  [72] = {.lex_state = 35},
  [73] = {.lex_state = 36},
  [74] = {.lex_state = 35},
  [75] = {.lex_state = 35},
  [76] = {.lex_state = 35},
  [77] = {.lex_state = 35},
  [78] = {.lex_state = 35},
  [79] = {.lex_state = 35},
  [80] = {.lex_state = 35},
  [81] = {.lex_state = 35},
  [82] = {.lex_state = 35},
  [83] = {.lex_state = 35},
  [84] = {.lex_state = 35},
  [85] = {.lex_state = 35},
  [86] = {.lex_state = 35},
  [87] = {.lex_state = 5},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 5},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 5},
  [120] = {.lex_state = 5},
  [121] = {.lex_state = 5},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 5},
  [125] = {.lex_state = 5},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 5},
  [128] = {.lex_state = 5},
  [129] = {.lex_state = 5},
  [130] = {.lex_state = 5},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 34},
  [162] = {.lex_state = 34},
  [163] = {.lex_state = 34},
  [164] = {.lex_state = 34},
  [165] = {.lex_state = 34},
  [166] = {.lex_state = 34},
  [167] = {.lex_state = 34},
  [168] = {.lex_state = 34},
  [169] = {.lex_state = 34},
  [170] = {.lex_state = 34},
  [171] = {.lex_state = 34},
  [172] = {.lex_state = 34},
  [173] = {.lex_state = 34},
  [174] = {.lex_state = 34},
  [175] = {.lex_state = 34},
  [176] = {.lex_state = 34},
  [177] = {.lex_state = 34},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 6},
  [180] = {.lex_state = 35},
  [181] = {.lex_state = 35},
  [182] = {.lex_state = 35},
  [183] = {.lex_state = 35},
  [184] = {.lex_state = 35},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 35},
  [187] = {.lex_state = 35},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 35},
  [191] = {.lex_state = 35},
  [192] = {.lex_state = 5},
  [193] = {.lex_state = 5},
  [194] = {.lex_state = 35},
  [195] = {.lex_state = 5},
  [196] = {.lex_state = 6},
  [197] = {.lex_state = 35},
  [198] = {.lex_state = 35},
  [199] = {.lex_state = 35},
  [200] = {.lex_state = 35},
  [201] = {.lex_state = 35},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 35},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 35},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 6},
  [214] = {.lex_state = 6},
  [215] = {.lex_state = 6},
  [216] = {.lex_state = 6},
  [217] = {.lex_state = 6},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 6},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 35},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 6},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 6},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 35},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 35},
  [232] = {.lex_state = 35},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 35},
  [236] = {.lex_state = 6},
  [237] = {.lex_state = 6},
  [238] = {.lex_state = 35},
  [239] = {.lex_state = 6},
  [240] = {.lex_state = 37},
  [241] = {.lex_state = 35},
  [242] = {.lex_state = 35},
  [243] = {.lex_state = 35},
  [244] = {.lex_state = 37},
  [245] = {.lex_state = 35},
  [246] = {.lex_state = 35},
  [247] = {.lex_state = 37},
  [248] = {.lex_state = 37},
  [249] = {.lex_state = 37},
  [250] = {.lex_state = 35},
  [251] = {.lex_state = 35},
  [252] = {.lex_state = 35},
  [253] = {.lex_state = 35},
  [254] = {.lex_state = 35},
  [255] = {.lex_state = 35},
  [256] = {.lex_state = 35},
  [257] = {.lex_state = 37},
  [258] = {.lex_state = 37},
  [259] = {.lex_state = 35},
  [260] = {.lex_state = 37},
  [261] = {.lex_state = 37},
  [262] = {.lex_state = 37},
  [263] = {.lex_state = 37},
  [264] = {.lex_state = 35},
  [265] = {.lex_state = 35},
  [266] = {.lex_state = 35},
  [267] = {.lex_state = 37},
  [268] = {.lex_state = 34},
  [269] = {.lex_state = 34},
  [270] = {.lex_state = 34},
  [271] = {.lex_state = 34},
  [272] = {.lex_state = 34},
  [273] = {.lex_state = 34},
  [274] = {.lex_state = 34},
  [275] = {.lex_state = 34},
  [276] = {.lex_state = 34},
  [277] = {.lex_state = 34},
  [278] = {.lex_state = 34},
  [279] = {.lex_state = 34},
  [280] = {.lex_state = 34},
  [281] = {.lex_state = 5},
  [282] = {.lex_state = 5},
  [283] = {.lex_state = 5},
  [284] = {.lex_state = 5},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 5},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 5},
  [290] = {.lex_state = 5},
  [291] = {.lex_state = 34},
  [292] = {.lex_state = 34},
  [293] = {.lex_state = 5},
  [294] = {.lex_state = 5},
  [295] = {.lex_state = 34},
  [296] = {.lex_state = 34},
  [297] = {.lex_state = 34},
  [298] = {.lex_state = 34},
  [299] = {.lex_state = 34},
  [300] = {.lex_state = 34},
  [301] = {.lex_state = 34},
  [302] = {.lex_state = 34},
  [303] = {.lex_state = 34},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 34},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 6},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 6},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 34},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 34},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 34},
  [382] = {.lex_state = 34},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 34},
  [386] = {.lex_state = 34},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_intersection_for] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_special_variable] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token2] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(371),
    [sym__item] = STATE(19),
    [sym_module_declaration] = STATE(19),
    [sym_function_declaration] = STATE(19),
    [sym__statement] = STATE(19),
    [sym_include_statement] = STATE(19),
    [sym_use_statement] = STATE(19),
    [sym_assignment] = STATE(370),
    [sym_union_block] = STATE(19),
    [sym_for_block] = STATE(19),
    [sym_intersection_for_block] = STATE(19),
    [sym_let_block] = STATE(19),
    [sym_assign_block] = STATE(19),
    [sym_if_block] = STATE(19),
    [sym_modifier_chain] = STATE(19),
    [sym_modifier] = STATE(173),
    [sym_transform_chain] = STATE(19),
    [sym_module_call] = STATE(177),
    [sym__variable_name] = STATE(369),
    [aux_sym_source_file_repeat1] = STATE(19),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_function] = ACTIONS(13),
    [anon_sym_include] = ACTIONS(15),
    [anon_sym_use] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_intersection_for] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_assign] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_PERCENT] = ACTIONS(31),
    [sym_special_variable] = ACTIONS(33),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 17,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [50] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(39), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [104] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(49), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(51), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(55), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [203] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      ts_builtin_sym_end,
    ACTIONS(59), 1,
      sym_identifier,
    ACTIONS(62), 1,
      anon_sym_SEMI,
    ACTIONS(65), 1,
      anon_sym_module,
    ACTIONS(68), 1,
      anon_sym_function,
    ACTIONS(71), 1,
      anon_sym_include,
    ACTIONS(74), 1,
      anon_sym_use,
    ACTIONS(77), 1,
      anon_sym_LBRACE,
    ACTIONS(80), 1,
      anon_sym_for,
    ACTIONS(83), 1,
      anon_sym_intersection_for,
    ACTIONS(86), 1,
      anon_sym_let,
    ACTIONS(89), 1,
      anon_sym_assign,
    ACTIONS(92), 1,
      anon_sym_if,
    ACTIONS(98), 1,
      sym_special_variable,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(95), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(6), 15,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_use_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(103), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(111), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [419] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(115), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [509] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(131), 1,
      anon_sym_if,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_each,
    STATE(28), 1,
      sym_for_clause,
    STATE(202), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(341), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(151), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(155), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(159), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [723] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_COMMA,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(183), 1,
      anon_sym_RBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    STATE(27), 1,
      sym_for_clause,
    STATE(210), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(313), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(191), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [849] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(193), 1,
      anon_sym_COMMA,
    ACTIONS(195), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(199), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(329), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [930] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(17), 1,
      anon_sym_use,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(197), 1,
      ts_builtin_sym_end,
    ACTIONS(199), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(6), 15,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_use_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1011] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(201), 1,
      anon_sym_if,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(341), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1090] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(203), 1,
      anon_sym_COMMA,
    ACTIONS(205), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(198), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(319), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(209), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(213), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1261] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(217), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(221), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(225), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1396] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(201), 1,
      anon_sym_if,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(326), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1475] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(131), 1,
      anon_sym_if,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_each,
    STATE(28), 1,
      sym_for_clause,
    STATE(202), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(326), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(229), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1599] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(231), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1677] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(233), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1755] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(235), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1833] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(237), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1911] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(239), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1989] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    ACTIONS(241), 1,
      anon_sym_RBRACK,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2067] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(243), 1,
      sym_identifier,
    ACTIONS(246), 1,
      anon_sym_SEMI,
    ACTIONS(249), 1,
      anon_sym_module,
    ACTIONS(252), 1,
      anon_sym_function,
    ACTIONS(255), 1,
      anon_sym_include,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(261), 1,
      anon_sym_RBRACE,
    ACTIONS(263), 1,
      anon_sym_for,
    ACTIONS(266), 1,
      anon_sym_intersection_for,
    ACTIONS(269), 1,
      anon_sym_let,
    ACTIONS(272), 1,
      anon_sym_assign,
    ACTIONS(275), 1,
      anon_sym_if,
    ACTIONS(281), 1,
      sym_special_variable,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(278), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(36), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2144] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(298), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    ACTIONS(312), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(302), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(284), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(286), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2215] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(39), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2266] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(314), 1,
      anon_sym_SEMI,
    ACTIONS(316), 1,
      anon_sym_function,
    ACTIONS(318), 1,
      anon_sym_RBRACE,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(36), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2343] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(316), 1,
      anon_sym_function,
    ACTIONS(320), 1,
      anon_sym_SEMI,
    ACTIONS(322), 1,
      anon_sym_RBRACE,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(39), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2420] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(316), 1,
      anon_sym_function,
    ACTIONS(324), 1,
      anon_sym_SEMI,
    ACTIONS(326), 1,
      anon_sym_RBRACE,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(56), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2497] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(298), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    ACTIONS(312), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(302), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(328), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(330), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2568] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 1,
      aux_sym_number_token2,
    ACTIONS(334), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(332), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2613] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(41), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
    ACTIONS(39), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
  [2672] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
    ACTIONS(39), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2735] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(302), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(39), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2800] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_each,
    STATE(27), 1,
      sym_for_clause,
    STATE(232), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(342), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2875] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_each,
    STATE(28), 1,
      sym_for_clause,
    STATE(202), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(338), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2950] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(302), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(39), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3017] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(39), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3074] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(127), 1,
      anon_sym_for,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_each,
    STATE(28), 1,
      sym_for_clause,
    STATE(202), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(314), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [3149] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(49), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(51), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3206] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(310), 1,
      anon_sym_CARET,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(39), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3259] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(298), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    ACTIONS(312), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(302), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(338), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(340), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3330] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(49), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(51), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3381] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(314), 1,
      anon_sym_SEMI,
    ACTIONS(316), 1,
      anon_sym_function,
    ACTIONS(342), 1,
      anon_sym_RBRACE,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    STATE(369), 1,
      sym__variable_name,
    STATE(370), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(36), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [3458] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      anon_sym_LBRACK,
    ACTIONS(294), 1,
      anon_sym_DOT,
    ACTIONS(298), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(308), 1,
      anon_sym_SLASH,
    ACTIONS(310), 1,
      anon_sym_CARET,
    ACTIONS(312), 1,
      anon_sym_QMARK,
    STATE(66), 1,
      sym_arguments,
    ACTIONS(290), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(296), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(302), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(346), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3529] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(352), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(354), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(366), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(346), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3641] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(49), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(51), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(229), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(115), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(55), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(159), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(225), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(209), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3949] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(39), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 12,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4007] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(39), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(41), 10,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [4069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4111] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(39), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4175] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(354), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(39), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4241] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(39), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(41), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4297] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      aux_sym_number_token2,
    ACTIONS(334), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(332), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4341] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(364), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(39), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4393] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(352), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(354), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(366), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(328), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(330), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4463] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(352), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(354), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(366), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(338), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(340), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4533] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(151), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4575] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(111), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(155), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(217), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4701] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(352), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(354), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 1,
      anon_sym_SLASH,
    ACTIONS(364), 1,
      anon_sym_CARET,
    ACTIONS(366), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(348), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(350), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(356), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(358), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(360), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(284), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(286), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(103), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(213), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4855] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4897] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(221), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(191), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4981] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      sym_identifier,
    ACTIONS(372), 1,
      anon_sym_RPAREN,
    ACTIONS(374), 1,
      sym_special_variable,
    STATE(200), 1,
      sym__expression,
    STATE(231), 1,
      sym__variable_name,
    STATE(320), 1,
      sym_assignment,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5050] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      sym_identifier,
    ACTIONS(374), 1,
      sym_special_variable,
    ACTIONS(376), 1,
      anon_sym_RPAREN,
    STATE(203), 1,
      sym__expression,
    STATE(231), 1,
      sym__variable_name,
    STATE(327), 1,
      sym_assignment,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5119] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      sym_identifier,
    ACTIONS(374), 1,
      sym_special_variable,
    ACTIONS(378), 1,
      anon_sym_RPAREN,
    STATE(201), 1,
      sym__expression,
    STATE(231), 1,
      sym__variable_name,
    STATE(321), 1,
      sym_assignment,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5188] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      sym_identifier,
    ACTIONS(374), 1,
      sym_special_variable,
    STATE(229), 1,
      sym__expression,
    STATE(231), 1,
      sym__variable_name,
    STATE(347), 1,
      sym_assignment,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5254] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(3), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5315] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(213), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5376] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(70), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5437] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(186), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5498] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(184), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5559] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5620] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(181), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5681] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(180), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5742] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(253), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5803] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(251), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5864] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5925] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(187), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5986] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(57), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6047] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(71), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6108] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(222), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6169] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(72), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6230] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(74), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6291] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(68), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6352] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(67), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6413] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(243), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6474] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(76), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6535] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(256), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6596] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(265), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6657] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(3), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6718] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(81), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6779] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(190), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6840] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(60), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6901] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(235), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6962] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(191), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7023] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(246), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7084] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(208), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7145] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(42), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7206] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(238), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7267] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(252), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7328] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(58), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7389] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(207), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7450] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(254), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7511] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(259), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7572] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(38), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7633] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(44), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7694] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(45), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7755] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(194), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7816] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(46), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7877] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(49), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7938] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(266), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7999] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8060] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8121] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(215), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8182] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(214), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8243] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(183), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8304] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(50), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8365] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(255), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8426] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8487] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(264), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8548] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(212), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8609] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(211), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8670] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(53), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8731] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(242), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8792] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8853] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(245), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8914] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(4), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8975] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_function,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_BANG,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    STATE(197), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(187), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9036] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(54), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9097] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(37), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9158] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      sym_special_variable,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_function,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_BANG,
    ACTIONS(386), 1,
      aux_sym_number_token1,
    STATE(75), 1,
      sym__expression,
    ACTIONS(179), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(388), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(14), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9219] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(205), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9280] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(55), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9341] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(206), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9402] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      sym_identifier,
    ACTIONS(123), 1,
      anon_sym_LPAREN,
    ACTIONS(125), 1,
      anon_sym_function,
    ACTIONS(129), 1,
      anon_sym_let,
    ACTIONS(133), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      sym_special_variable,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    STATE(196), 1,
      sym__expression,
    ACTIONS(141), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(147), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9463] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_function,
    ACTIONS(396), 1,
      anon_sym_let,
    ACTIONS(398), 1,
      anon_sym_BANG,
    ACTIONS(400), 1,
      sym_special_variable,
    ACTIONS(402), 1,
      sym_string,
    ACTIONS(404), 1,
      aux_sym_number_token1,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(52), 1,
      sym__expression,
    ACTIONS(406), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(85), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(79), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9524] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(414), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(268), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9579] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(416), 1,
      anon_sym_SEMI,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(249), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9634] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(432), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(257), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9689] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(434), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(244), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9744] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(436), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(258), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9799] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(438), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(248), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9854] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(440), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(261), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9909] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(442), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(247), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [9964] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(278), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10019] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(446), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(270), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10074] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(448), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(269), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10129] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(450), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(267), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10184] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(452), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(273), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10239] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_include,
    ACTIONS(420), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(424), 1,
      anon_sym_intersection_for,
    ACTIONS(426), 1,
      anon_sym_let,
    ACTIONS(428), 1,
      anon_sym_assign,
    ACTIONS(430), 1,
      anon_sym_if,
    ACTIONS(454), 1,
      anon_sym_SEMI,
    STATE(166), 1,
      sym_module_call,
    STATE(167), 1,
      sym_modifier,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(262), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10294] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(456), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(276), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10349] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(458), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(277), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10404] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(412), 1,
      sym_identifier,
    ACTIONS(460), 1,
      anon_sym_SEMI,
    STATE(173), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(275), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(464), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10491] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 1,
      aux_sym_number_token2,
    ACTIONS(334), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(332), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [10525] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(41), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10573] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [10623] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(41), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [10675] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(344), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10733] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(41), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [10787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(490), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10819] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(41), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10865] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(474), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(39), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(494), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(498), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10971] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(338), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11029] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(284), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(502), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(506), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11151] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(49), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(51), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11197] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 10,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(510), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11229] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(39), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 15,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11267] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(518), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11323] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(522), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(520), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11381] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(524), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(520), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11439] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(528), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      sym_arguments,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [11499] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(530), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      sym_arguments,
    STATE(318), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [11559] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(536), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(538), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    ACTIONS(550), 1,
      anon_sym_QMARK,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(520), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [11615] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(552), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      sym_arguments,
    STATE(331), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [11675] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(554), 1,
      aux_sym_number_token2,
    ACTIONS(334), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(332), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11707] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(536), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(538), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    ACTIONS(550), 1,
      anon_sym_QMARK,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(344), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [11763] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(41), 10,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11809] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(49), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(51), 12,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11853] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(49), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(51), 15,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11891] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 8,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [11939] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(556), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(520), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11997] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 6,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [12047] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(538), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(41), 5,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [12099] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(39), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(41), 12,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12143] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(548), 1,
      anon_sym_CARET,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(39), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(41), 14,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12183] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(536), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(538), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    ACTIONS(550), 1,
      anon_sym_QMARK,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(338), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [12239] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 1,
      anon_sym_LPAREN,
    ACTIONS(514), 1,
      anon_sym_LBRACK,
    ACTIONS(516), 1,
      anon_sym_DOT,
    ACTIONS(536), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(538), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      anon_sym_CARET,
    ACTIONS(550), 1,
      anon_sym_QMARK,
    STATE(224), 1,
      sym_arguments,
    ACTIONS(532), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(534), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(542), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(284), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [12295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12353] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(217), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(155), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12440] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(558), 1,
      anon_sym_COLON,
    ACTIONS(560), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [12497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(159), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12526] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(209), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(223), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(225), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(151), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(111), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(213), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12671] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(562), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12726] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(103), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12755] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(564), 1,
      anon_sym_EQ,
    ACTIONS(153), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(155), 17,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12786] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(520), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [12841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(55), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(229), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12899] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(566), 1,
      anon_sym_COLON,
    ACTIONS(568), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [12956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(115), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12985] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(221), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13014] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(570), 1,
      anon_sym_COLON,
    ACTIONS(572), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(191), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(576), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13128] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(578), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13182] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(580), 1,
      anon_sym_SEMI,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13236] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(582), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(586), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13318] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(588), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13372] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(590), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13426] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_else,
    ACTIONS(592), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(594), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [13456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(600), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(604), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13512] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(606), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13566] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(608), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13620] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(610), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13674] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(612), 1,
      anon_sym_COLON,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13728] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(614), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13782] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(616), 1,
      anon_sym_SEMI,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13836] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(618), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(620), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(622), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(626), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13946] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(628), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [14000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(632), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14028] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(636), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(640), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(644), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14112] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(646), 1,
      anon_sym_RBRACK,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [14166] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(648), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [14220] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(472), 1,
      anon_sym_SLASH,
    ACTIONS(474), 1,
      anon_sym_CARET,
    ACTIONS(482), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(484), 1,
      anon_sym_AMP_AMP,
    ACTIONS(486), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_SEMI,
    STATE(22), 1,
      sym_arguments,
    ACTIONS(468), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(470), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(476), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(478), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(480), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [14274] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(652), 1,
      anon_sym_else,
    ACTIONS(592), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(594), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(620), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(622), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(640), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(604), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(576), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(656), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(636), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(644), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(600), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(586), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(626), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(660), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(632), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(664), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14654] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(668), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(672), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(676), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14726] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(680), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(684), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(688), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(692), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14822] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(696), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(700), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(704), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(706), 7,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(710), 7,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14936] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 1,
      sym_string,
    ACTIONS(177), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      anon_sym_LBRACK,
    ACTIONS(714), 1,
      anon_sym_function,
    STATE(324), 1,
      sym__literal,
    ACTIONS(716), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(25), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [14966] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      sym_string,
    ACTIONS(139), 1,
      aux_sym_number_token1,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(718), 1,
      anon_sym_function,
    STATE(324), 1,
      sym__literal,
    ACTIONS(720), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(237), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [14996] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(726), 1,
      anon_sym_RPAREN,
    STATE(325), 1,
      sym__variable_name,
    ACTIONS(722), 2,
      sym_identifier,
      sym_special_variable,
    STATE(332), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15017] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_RPAREN,
    STATE(325), 1,
      sym__variable_name,
    ACTIONS(722), 2,
      sym_identifier,
      sym_special_variable,
    STATE(352), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15035] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    STATE(325), 1,
      sym__variable_name,
    ACTIONS(722), 2,
      sym_identifier,
      sym_special_variable,
    STATE(352), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15053] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      anon_sym_SEMI,
    ACTIONS(734), 1,
      anon_sym_RPAREN,
    STATE(307), 1,
      sym_assignment,
    STATE(369), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15073] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(325), 1,
      sym__variable_name,
    ACTIONS(722), 2,
      sym_identifier,
      sym_special_variable,
    STATE(352), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15088] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    STATE(323), 1,
      sym_assignment,
    STATE(369), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15105] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    STATE(335), 1,
      sym_assignment,
    STATE(369), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15122] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_RPAREN,
    STATE(328), 1,
      sym_assignment,
    STATE(369), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15139] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_assignment,
    STATE(369), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15156] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 1,
      anon_sym_SEMI,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    STATE(305), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15172] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_COMMA,
    STATE(305), 1,
      aux_sym_parenthesized_assignments_repeat1,
    ACTIONS(748), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [15186] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(322), 1,
      sym_assignment,
    STATE(369), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15200] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(753), 1,
      anon_sym_SEMI,
    ACTIONS(755), 1,
      anon_sym_RPAREN,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15216] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    ACTIONS(757), 1,
      anon_sym_COMMA,
    STATE(330), 1,
      aux_sym_parameters_declaration_repeat1,
  [15229] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      anon_sym_RBRACK,
    ACTIONS(759), 1,
      anon_sym_COMMA,
    STATE(310), 1,
      aux_sym_list_repeat1,
  [15242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_COMMA,
    ACTIONS(764), 1,
      anon_sym_RBRACK,
    STATE(310), 1,
      aux_sym_list_repeat1,
  [15255] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    STATE(305), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15268] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_LPAREN,
    STATE(290), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [15279] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 1,
      anon_sym_COMMA,
    ACTIONS(770), 1,
      anon_sym_RBRACK,
    STATE(309), 1,
      aux_sym_list_repeat1,
  [15292] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_else,
    ACTIONS(772), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [15303] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(776), 1,
      anon_sym_EQ,
    STATE(291), 1,
      sym_arguments,
  [15316] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 1,
      anon_sym_RBRACK,
    ACTIONS(778), 1,
      anon_sym_COMMA,
    STATE(310), 1,
      aux_sym_list_repeat1,
  [15329] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(780), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15342] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(782), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15355] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 1,
      anon_sym_COMMA,
    ACTIONS(786), 1,
      anon_sym_RBRACK,
    STATE(316), 1,
      aux_sym_list_repeat1,
  [15368] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(528), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [15381] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(530), 1,
      anon_sym_RPAREN,
    STATE(318), 1,
      aux_sym_arguments_repeat1,
  [15394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15403] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(788), 1,
      anon_sym_RPAREN,
    STATE(340), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15416] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [15425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 1,
      anon_sym_EQ,
    ACTIONS(792), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15436] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [15445] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(552), 1,
      anon_sym_RPAREN,
    STATE(331), 1,
      aux_sym_arguments_repeat1,
  [15458] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(755), 1,
      anon_sym_RPAREN,
    STATE(311), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15471] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 1,
      anon_sym_COMMA,
    ACTIONS(800), 1,
      anon_sym_RBRACK,
    STATE(333), 1,
      aux_sym_list_repeat1,
  [15484] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      anon_sym_COMMA,
    ACTIONS(805), 1,
      anon_sym_RPAREN,
    STATE(330), 1,
      aux_sym_parameters_declaration_repeat1,
  [15497] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    ACTIONS(807), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15510] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(809), 1,
      anon_sym_COMMA,
    ACTIONS(811), 1,
      anon_sym_RPAREN,
    STATE(308), 1,
      aux_sym_parameters_declaration_repeat1,
  [15523] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 1,
      anon_sym_RBRACK,
    ACTIONS(813), 1,
      anon_sym_COMMA,
    STATE(310), 1,
      aux_sym_list_repeat1,
  [15536] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(815), 1,
      anon_sym_RPAREN,
    STATE(305), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15549] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(817), 1,
      anon_sym_RPAREN,
    STATE(334), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15562] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(819), 1,
      anon_sym_RPAREN,
    STATE(305), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 1,
      anon_sym_else,
    ACTIONS(772), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [15599] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(826), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15612] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_COMMA,
    ACTIONS(828), 1,
      anon_sym_RPAREN,
    STATE(305), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15625] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [15634] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [15642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(161), 1,
      sym_parenthesized_assignments,
  [15652] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(48), 1,
      sym_parenthesized_expression,
  [15662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(153), 1,
      sym_parenthesized_assignments,
  [15672] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    STATE(291), 1,
      sym_arguments,
  [15682] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(115), 1,
      sym_parameters_declaration,
  [15700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(111), 1,
      sym_parenthesized_assignments,
  [15710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(51), 1,
      sym_parenthesized_expression,
  [15720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(172), 1,
      sym_parenthesized_expression,
  [15730] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(805), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15738] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(162), 1,
      sym_parenthesized_assignments,
  [15748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(176), 1,
      sym_parenthesized_assignments,
  [15758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(163), 1,
      sym_parenthesized_assignments,
  [15768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(175), 1,
      sym_parenthesized_assignments,
  [15778] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(164), 1,
      sym_parenthesized_assignments,
  [15788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(375), 1,
      sym_parameters_declaration,
  [15798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(165), 1,
      sym_parenthesized_assignments,
  [15808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(154), 1,
      sym_parameters_declaration,
  [15818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(170), 1,
      sym_parenthesized_assignments,
  [15828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(119), 1,
      sym_parameters_declaration,
  [15838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(169), 1,
      sym_parameters_declaration,
  [15848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(116), 1,
      sym_parenthesized_assignments,
  [15858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(137), 1,
      sym_parameters_declaration,
  [15868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LPAREN,
    STATE(138), 1,
      sym_parenthesized_assignments,
  [15878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LPAREN,
    STATE(168), 1,
      sym_parenthesized_expression,
  [15888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      anon_sym_LPAREN,
    STATE(383), 1,
      sym_parameters_declaration,
  [15898] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 1,
      anon_sym_EQ,
  [15905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 1,
      anon_sym_SEMI,
  [15912] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      ts_builtin_sym_end,
  [15919] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_RBRACK,
  [15926] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      sym_identifier,
  [15933] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      anon_sym_RPAREN,
  [15940] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_EQ,
  [15947] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 1,
      sym_include_path,
  [15954] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      sym_identifier,
  [15961] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 1,
      anon_sym_RBRACK,
  [15968] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      sym_include_path,
  [15975] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 1,
      sym_include_path,
  [15982] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 1,
      sym_identifier,
  [15989] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      sym_identifier,
  [15996] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 1,
      anon_sym_EQ,
  [16003] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_RBRACK,
  [16010] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 1,
      sym_identifier,
  [16017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 50,
  [SMALL_STATE(4)] = 104,
  [SMALL_STATE(5)] = 158,
  [SMALL_STATE(6)] = 203,
  [SMALL_STATE(7)] = 284,
  [SMALL_STATE(8)] = 329,
  [SMALL_STATE(9)] = 374,
  [SMALL_STATE(10)] = 419,
  [SMALL_STATE(11)] = 464,
  [SMALL_STATE(12)] = 509,
  [SMALL_STATE(13)] = 588,
  [SMALL_STATE(14)] = 633,
  [SMALL_STATE(15)] = 678,
  [SMALL_STATE(16)] = 723,
  [SMALL_STATE(17)] = 804,
  [SMALL_STATE(18)] = 849,
  [SMALL_STATE(19)] = 930,
  [SMALL_STATE(20)] = 1011,
  [SMALL_STATE(21)] = 1090,
  [SMALL_STATE(22)] = 1171,
  [SMALL_STATE(23)] = 1216,
  [SMALL_STATE(24)] = 1261,
  [SMALL_STATE(25)] = 1306,
  [SMALL_STATE(26)] = 1351,
  [SMALL_STATE(27)] = 1396,
  [SMALL_STATE(28)] = 1475,
  [SMALL_STATE(29)] = 1554,
  [SMALL_STATE(30)] = 1599,
  [SMALL_STATE(31)] = 1677,
  [SMALL_STATE(32)] = 1755,
  [SMALL_STATE(33)] = 1833,
  [SMALL_STATE(34)] = 1911,
  [SMALL_STATE(35)] = 1989,
  [SMALL_STATE(36)] = 2067,
  [SMALL_STATE(37)] = 2144,
  [SMALL_STATE(38)] = 2215,
  [SMALL_STATE(39)] = 2266,
  [SMALL_STATE(40)] = 2343,
  [SMALL_STATE(41)] = 2420,
  [SMALL_STATE(42)] = 2497,
  [SMALL_STATE(43)] = 2568,
  [SMALL_STATE(44)] = 2613,
  [SMALL_STATE(45)] = 2672,
  [SMALL_STATE(46)] = 2735,
  [SMALL_STATE(47)] = 2800,
  [SMALL_STATE(48)] = 2875,
  [SMALL_STATE(49)] = 2950,
  [SMALL_STATE(50)] = 3017,
  [SMALL_STATE(51)] = 3074,
  [SMALL_STATE(52)] = 3149,
  [SMALL_STATE(53)] = 3206,
  [SMALL_STATE(54)] = 3259,
  [SMALL_STATE(55)] = 3330,
  [SMALL_STATE(56)] = 3381,
  [SMALL_STATE(57)] = 3458,
  [SMALL_STATE(58)] = 3529,
  [SMALL_STATE(59)] = 3599,
  [SMALL_STATE(60)] = 3641,
  [SMALL_STATE(61)] = 3697,
  [SMALL_STATE(62)] = 3739,
  [SMALL_STATE(63)] = 3781,
  [SMALL_STATE(64)] = 3823,
  [SMALL_STATE(65)] = 3865,
  [SMALL_STATE(66)] = 3907,
  [SMALL_STATE(67)] = 3949,
  [SMALL_STATE(68)] = 4007,
  [SMALL_STATE(69)] = 4069,
  [SMALL_STATE(70)] = 4111,
  [SMALL_STATE(71)] = 4175,
  [SMALL_STATE(72)] = 4241,
  [SMALL_STATE(73)] = 4297,
  [SMALL_STATE(74)] = 4341,
  [SMALL_STATE(75)] = 4393,
  [SMALL_STATE(76)] = 4463,
  [SMALL_STATE(77)] = 4533,
  [SMALL_STATE(78)] = 4575,
  [SMALL_STATE(79)] = 4617,
  [SMALL_STATE(80)] = 4659,
  [SMALL_STATE(81)] = 4701,
  [SMALL_STATE(82)] = 4771,
  [SMALL_STATE(83)] = 4813,
  [SMALL_STATE(84)] = 4855,
  [SMALL_STATE(85)] = 4897,
  [SMALL_STATE(86)] = 4939,
  [SMALL_STATE(87)] = 4981,
  [SMALL_STATE(88)] = 5050,
  [SMALL_STATE(89)] = 5119,
  [SMALL_STATE(90)] = 5188,
  [SMALL_STATE(91)] = 5254,
  [SMALL_STATE(92)] = 5315,
  [SMALL_STATE(93)] = 5376,
  [SMALL_STATE(94)] = 5437,
  [SMALL_STATE(95)] = 5498,
  [SMALL_STATE(96)] = 5559,
  [SMALL_STATE(97)] = 5620,
  [SMALL_STATE(98)] = 5681,
  [SMALL_STATE(99)] = 5742,
  [SMALL_STATE(100)] = 5803,
  [SMALL_STATE(101)] = 5864,
  [SMALL_STATE(102)] = 5925,
  [SMALL_STATE(103)] = 5986,
  [SMALL_STATE(104)] = 6047,
  [SMALL_STATE(105)] = 6108,
  [SMALL_STATE(106)] = 6169,
  [SMALL_STATE(107)] = 6230,
  [SMALL_STATE(108)] = 6291,
  [SMALL_STATE(109)] = 6352,
  [SMALL_STATE(110)] = 6413,
  [SMALL_STATE(111)] = 6474,
  [SMALL_STATE(112)] = 6535,
  [SMALL_STATE(113)] = 6596,
  [SMALL_STATE(114)] = 6657,
  [SMALL_STATE(115)] = 6718,
  [SMALL_STATE(116)] = 6779,
  [SMALL_STATE(117)] = 6840,
  [SMALL_STATE(118)] = 6901,
  [SMALL_STATE(119)] = 6962,
  [SMALL_STATE(120)] = 7023,
  [SMALL_STATE(121)] = 7084,
  [SMALL_STATE(122)] = 7145,
  [SMALL_STATE(123)] = 7206,
  [SMALL_STATE(124)] = 7267,
  [SMALL_STATE(125)] = 7328,
  [SMALL_STATE(126)] = 7389,
  [SMALL_STATE(127)] = 7450,
  [SMALL_STATE(128)] = 7511,
  [SMALL_STATE(129)] = 7572,
  [SMALL_STATE(130)] = 7633,
  [SMALL_STATE(131)] = 7694,
  [SMALL_STATE(132)] = 7755,
  [SMALL_STATE(133)] = 7816,
  [SMALL_STATE(134)] = 7877,
  [SMALL_STATE(135)] = 7938,
  [SMALL_STATE(136)] = 7999,
  [SMALL_STATE(137)] = 8060,
  [SMALL_STATE(138)] = 8121,
  [SMALL_STATE(139)] = 8182,
  [SMALL_STATE(140)] = 8243,
  [SMALL_STATE(141)] = 8304,
  [SMALL_STATE(142)] = 8365,
  [SMALL_STATE(143)] = 8426,
  [SMALL_STATE(144)] = 8487,
  [SMALL_STATE(145)] = 8548,
  [SMALL_STATE(146)] = 8609,
  [SMALL_STATE(147)] = 8670,
  [SMALL_STATE(148)] = 8731,
  [SMALL_STATE(149)] = 8792,
  [SMALL_STATE(150)] = 8853,
  [SMALL_STATE(151)] = 8914,
  [SMALL_STATE(152)] = 8975,
  [SMALL_STATE(153)] = 9036,
  [SMALL_STATE(154)] = 9097,
  [SMALL_STATE(155)] = 9158,
  [SMALL_STATE(156)] = 9219,
  [SMALL_STATE(157)] = 9280,
  [SMALL_STATE(158)] = 9341,
  [SMALL_STATE(159)] = 9402,
  [SMALL_STATE(160)] = 9463,
  [SMALL_STATE(161)] = 9524,
  [SMALL_STATE(162)] = 9579,
  [SMALL_STATE(163)] = 9634,
  [SMALL_STATE(164)] = 9689,
  [SMALL_STATE(165)] = 9744,
  [SMALL_STATE(166)] = 9799,
  [SMALL_STATE(167)] = 9854,
  [SMALL_STATE(168)] = 9909,
  [SMALL_STATE(169)] = 9964,
  [SMALL_STATE(170)] = 10019,
  [SMALL_STATE(171)] = 10074,
  [SMALL_STATE(172)] = 10129,
  [SMALL_STATE(173)] = 10184,
  [SMALL_STATE(174)] = 10239,
  [SMALL_STATE(175)] = 10294,
  [SMALL_STATE(176)] = 10349,
  [SMALL_STATE(177)] = 10404,
  [SMALL_STATE(178)] = 10459,
  [SMALL_STATE(179)] = 10491,
  [SMALL_STATE(180)] = 10525,
  [SMALL_STATE(181)] = 10573,
  [SMALL_STATE(182)] = 10623,
  [SMALL_STATE(183)] = 10675,
  [SMALL_STATE(184)] = 10733,
  [SMALL_STATE(185)] = 10787,
  [SMALL_STATE(186)] = 10819,
  [SMALL_STATE(187)] = 10865,
  [SMALL_STATE(188)] = 10907,
  [SMALL_STATE(189)] = 10939,
  [SMALL_STATE(190)] = 10971,
  [SMALL_STATE(191)] = 11029,
  [SMALL_STATE(192)] = 11087,
  [SMALL_STATE(193)] = 11119,
  [SMALL_STATE(194)] = 11151,
  [SMALL_STATE(195)] = 11197,
  [SMALL_STATE(196)] = 11229,
  [SMALL_STATE(197)] = 11267,
  [SMALL_STATE(198)] = 11323,
  [SMALL_STATE(199)] = 11381,
  [SMALL_STATE(200)] = 11439,
  [SMALL_STATE(201)] = 11499,
  [SMALL_STATE(202)] = 11559,
  [SMALL_STATE(203)] = 11615,
  [SMALL_STATE(204)] = 11675,
  [SMALL_STATE(205)] = 11707,
  [SMALL_STATE(206)] = 11763,
  [SMALL_STATE(207)] = 11809,
  [SMALL_STATE(208)] = 11853,
  [SMALL_STATE(209)] = 11891,
  [SMALL_STATE(210)] = 11939,
  [SMALL_STATE(211)] = 11997,
  [SMALL_STATE(212)] = 12047,
  [SMALL_STATE(213)] = 12099,
  [SMALL_STATE(214)] = 12143,
  [SMALL_STATE(215)] = 12183,
  [SMALL_STATE(216)] = 12239,
  [SMALL_STATE(217)] = 12295,
  [SMALL_STATE(218)] = 12324,
  [SMALL_STATE(219)] = 12353,
  [SMALL_STATE(220)] = 12382,
  [SMALL_STATE(221)] = 12411,
  [SMALL_STATE(222)] = 12440,
  [SMALL_STATE(223)] = 12497,
  [SMALL_STATE(224)] = 12526,
  [SMALL_STATE(225)] = 12555,
  [SMALL_STATE(226)] = 12584,
  [SMALL_STATE(227)] = 12613,
  [SMALL_STATE(228)] = 12642,
  [SMALL_STATE(229)] = 12671,
  [SMALL_STATE(230)] = 12726,
  [SMALL_STATE(231)] = 12755,
  [SMALL_STATE(232)] = 12786,
  [SMALL_STATE(233)] = 12841,
  [SMALL_STATE(234)] = 12870,
  [SMALL_STATE(235)] = 12899,
  [SMALL_STATE(236)] = 12956,
  [SMALL_STATE(237)] = 12985,
  [SMALL_STATE(238)] = 13014,
  [SMALL_STATE(239)] = 13071,
  [SMALL_STATE(240)] = 13100,
  [SMALL_STATE(241)] = 13128,
  [SMALL_STATE(242)] = 13182,
  [SMALL_STATE(243)] = 13236,
  [SMALL_STATE(244)] = 13290,
  [SMALL_STATE(245)] = 13318,
  [SMALL_STATE(246)] = 13372,
  [SMALL_STATE(247)] = 13426,
  [SMALL_STATE(248)] = 13456,
  [SMALL_STATE(249)] = 13484,
  [SMALL_STATE(250)] = 13512,
  [SMALL_STATE(251)] = 13566,
  [SMALL_STATE(252)] = 13620,
  [SMALL_STATE(253)] = 13674,
  [SMALL_STATE(254)] = 13728,
  [SMALL_STATE(255)] = 13782,
  [SMALL_STATE(256)] = 13836,
  [SMALL_STATE(257)] = 13890,
  [SMALL_STATE(258)] = 13918,
  [SMALL_STATE(259)] = 13946,
  [SMALL_STATE(260)] = 14000,
  [SMALL_STATE(261)] = 14028,
  [SMALL_STATE(262)] = 14056,
  [SMALL_STATE(263)] = 14084,
  [SMALL_STATE(264)] = 14112,
  [SMALL_STATE(265)] = 14166,
  [SMALL_STATE(266)] = 14220,
  [SMALL_STATE(267)] = 14274,
  [SMALL_STATE(268)] = 14304,
  [SMALL_STATE(269)] = 14331,
  [SMALL_STATE(270)] = 14358,
  [SMALL_STATE(271)] = 14385,
  [SMALL_STATE(272)] = 14412,
  [SMALL_STATE(273)] = 14439,
  [SMALL_STATE(274)] = 14466,
  [SMALL_STATE(275)] = 14493,
  [SMALL_STATE(276)] = 14520,
  [SMALL_STATE(277)] = 14547,
  [SMALL_STATE(278)] = 14574,
  [SMALL_STATE(279)] = 14601,
  [SMALL_STATE(280)] = 14628,
  [SMALL_STATE(281)] = 14654,
  [SMALL_STATE(282)] = 14678,
  [SMALL_STATE(283)] = 14702,
  [SMALL_STATE(284)] = 14726,
  [SMALL_STATE(285)] = 14750,
  [SMALL_STATE(286)] = 14774,
  [SMALL_STATE(287)] = 14798,
  [SMALL_STATE(288)] = 14822,
  [SMALL_STATE(289)] = 14846,
  [SMALL_STATE(290)] = 14870,
  [SMALL_STATE(291)] = 14894,
  [SMALL_STATE(292)] = 14915,
  [SMALL_STATE(293)] = 14936,
  [SMALL_STATE(294)] = 14966,
  [SMALL_STATE(295)] = 14996,
  [SMALL_STATE(296)] = 15017,
  [SMALL_STATE(297)] = 15035,
  [SMALL_STATE(298)] = 15053,
  [SMALL_STATE(299)] = 15073,
  [SMALL_STATE(300)] = 15088,
  [SMALL_STATE(301)] = 15105,
  [SMALL_STATE(302)] = 15122,
  [SMALL_STATE(303)] = 15139,
  [SMALL_STATE(304)] = 15156,
  [SMALL_STATE(305)] = 15172,
  [SMALL_STATE(306)] = 15186,
  [SMALL_STATE(307)] = 15200,
  [SMALL_STATE(308)] = 15216,
  [SMALL_STATE(309)] = 15229,
  [SMALL_STATE(310)] = 15242,
  [SMALL_STATE(311)] = 15255,
  [SMALL_STATE(312)] = 15268,
  [SMALL_STATE(313)] = 15279,
  [SMALL_STATE(314)] = 15292,
  [SMALL_STATE(315)] = 15303,
  [SMALL_STATE(316)] = 15316,
  [SMALL_STATE(317)] = 15329,
  [SMALL_STATE(318)] = 15342,
  [SMALL_STATE(319)] = 15355,
  [SMALL_STATE(320)] = 15368,
  [SMALL_STATE(321)] = 15381,
  [SMALL_STATE(322)] = 15394,
  [SMALL_STATE(323)] = 15403,
  [SMALL_STATE(324)] = 15416,
  [SMALL_STATE(325)] = 15425,
  [SMALL_STATE(326)] = 15436,
  [SMALL_STATE(327)] = 15445,
  [SMALL_STATE(328)] = 15458,
  [SMALL_STATE(329)] = 15471,
  [SMALL_STATE(330)] = 15484,
  [SMALL_STATE(331)] = 15497,
  [SMALL_STATE(332)] = 15510,
  [SMALL_STATE(333)] = 15523,
  [SMALL_STATE(334)] = 15536,
  [SMALL_STATE(335)] = 15549,
  [SMALL_STATE(336)] = 15562,
  [SMALL_STATE(337)] = 15575,
  [SMALL_STATE(338)] = 15588,
  [SMALL_STATE(339)] = 15599,
  [SMALL_STATE(340)] = 15612,
  [SMALL_STATE(341)] = 15625,
  [SMALL_STATE(342)] = 15634,
  [SMALL_STATE(343)] = 15642,
  [SMALL_STATE(344)] = 15652,
  [SMALL_STATE(345)] = 15662,
  [SMALL_STATE(346)] = 15672,
  [SMALL_STATE(347)] = 15682,
  [SMALL_STATE(348)] = 15690,
  [SMALL_STATE(349)] = 15700,
  [SMALL_STATE(350)] = 15710,
  [SMALL_STATE(351)] = 15720,
  [SMALL_STATE(352)] = 15730,
  [SMALL_STATE(353)] = 15738,
  [SMALL_STATE(354)] = 15748,
  [SMALL_STATE(355)] = 15758,
  [SMALL_STATE(356)] = 15768,
  [SMALL_STATE(357)] = 15778,
  [SMALL_STATE(358)] = 15788,
  [SMALL_STATE(359)] = 15798,
  [SMALL_STATE(360)] = 15808,
  [SMALL_STATE(361)] = 15818,
  [SMALL_STATE(362)] = 15828,
  [SMALL_STATE(363)] = 15838,
  [SMALL_STATE(364)] = 15848,
  [SMALL_STATE(365)] = 15858,
  [SMALL_STATE(366)] = 15868,
  [SMALL_STATE(367)] = 15878,
  [SMALL_STATE(368)] = 15888,
  [SMALL_STATE(369)] = 15898,
  [SMALL_STATE(370)] = 15905,
  [SMALL_STATE(371)] = 15912,
  [SMALL_STATE(372)] = 15919,
  [SMALL_STATE(373)] = 15926,
  [SMALL_STATE(374)] = 15933,
  [SMALL_STATE(375)] = 15940,
  [SMALL_STATE(376)] = 15947,
  [SMALL_STATE(377)] = 15954,
  [SMALL_STATE(378)] = 15961,
  [SMALL_STATE(379)] = 15968,
  [SMALL_STATE(380)] = 15975,
  [SMALL_STATE(381)] = 15982,
  [SMALL_STATE(382)] = 15989,
  [SMALL_STATE(383)] = 15996,
  [SMALL_STATE(384)] = 16003,
  [SMALL_STATE(385)] = 16010,
  [SMALL_STATE(386)] = 16017,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [35] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [39] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [59] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(315),
  [62] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(6),
  [65] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(386),
  [68] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(381),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(380),
  [74] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(379),
  [77] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(41),
  [80] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(354),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(356),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(343),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(361),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(367),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(292),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(369),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 7, .production_id = 14),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 7, .production_id = 14),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [157] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3),
  [159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, .production_id = 11),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, .production_id = 11),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [243] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(315),
  [246] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(36),
  [249] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(386),
  [252] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(382),
  [255] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(380),
  [258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(41),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2),
  [263] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(354),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(356),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(343),
  [272] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(361),
  [275] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(367),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(292),
  [281] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(369),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 3, .production_id = 8),
  [286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 3, .production_id = 8),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [308] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 2),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 2),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 4),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 4),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 2),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 2),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 3),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 3),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 4),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 4),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 3),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 3),
  [508] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 5),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 5),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 4),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_cell, 1),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 2),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 2),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 2),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [622] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [626] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 3),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 3),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier_chain, 2),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier_chain, 2),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 2),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 2),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [652] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 2),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__item, 2),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 2),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_use_statement, 2),
  [666] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [670] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [674] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [690] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 5, .production_id = 13),
  [692] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 5, .production_id = 13),
  [694] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [702] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_clause, 2),
  [704] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 2),
  [706] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [710] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier, 1),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier, 1),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2), SHIFT_REPEAT(306),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [761] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(47),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 3),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_name, 1),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 2),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_declaration, 1),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_comprehension, 2),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [802] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2), SHIFT_REPEAT(299),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [821] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(90),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 5, .production_id = 15),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [838] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_openscad(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
