#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 383
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 98
#define ALIAS_COUNT 0
#define TOKEN_COUNT 49
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_use = 3,
  anon_sym_include = 4,
  anon_sym_SEMI = 5,
  sym_include_path = 6,
  anon_sym_module = 7,
  anon_sym_LPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_RPAREN = 10,
  anon_sym_function = 11,
  anon_sym_EQ = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_for = 15,
  anon_sym_intersection_for = 16,
  anon_sym_let = 17,
  anon_sym_assign = 18,
  anon_sym_if = 19,
  anon_sym_else = 20,
  anon_sym_STAR = 21,
  anon_sym_BANG = 22,
  anon_sym_POUND = 23,
  anon_sym_PERCENT = 24,
  sym_special_variable = 25,
  sym_string = 26,
  aux_sym_number_token1 = 27,
  aux_sym_number_token2 = 28,
  anon_sym_true = 29,
  anon_sym_false = 30,
  anon_sym_LBRACK = 31,
  anon_sym_COLON = 32,
  anon_sym_RBRACK = 33,
  anon_sym_each = 34,
  anon_sym_DOT = 35,
  anon_sym_DASH = 36,
  anon_sym_PLUS = 37,
  anon_sym_PIPE_PIPE = 38,
  anon_sym_AMP_AMP = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_BANG_EQ = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_LT_EQ = 44,
  anon_sym_GT_EQ = 45,
  anon_sym_SLASH = 46,
  anon_sym_CARET = 47,
  anon_sym_QMARK = 48,
  sym_source_file = 49,
  sym_include_statement = 50,
  sym__item = 51,
  sym_module_declaration = 52,
  sym_parameters_declaration = 53,
  sym__parameter_declaration = 54,
  sym_function_declaration = 55,
  sym__statement = 56,
  sym_assignment = 57,
  sym_union_block = 58,
  sym_for_block = 59,
  sym_intersection_for_block = 60,
  sym_let_block = 61,
  sym_assign_block = 62,
  sym_if_block = 63,
  sym_modifier_chain = 64,
  sym_modifier = 65,
  sym_transform_chain = 66,
  sym_module_call = 67,
  sym_arguments = 68,
  sym_parenthesized_assignments = 69,
  sym_parenthesized_expression = 70,
  sym_condition_update_clause = 71,
  sym__expression = 72,
  sym_let_expression = 73,
  sym__variable_name = 74,
  sym__literal = 75,
  sym_number = 76,
  sym_boolean = 77,
  sym_function = 78,
  sym_range = 79,
  sym_list = 80,
  sym__list_cell = 81,
  sym_each = 82,
  sym_list_comprehension = 83,
  sym_for_clause = 84,
  sym_if_clause = 85,
  sym_function_call = 86,
  sym_index_expression = 87,
  sym_dot_index_expression = 88,
  sym_unary_expression = 89,
  sym_binary_expression = 90,
  sym_ternary_expression = 91,
  aux_sym_source_file_repeat1 = 92,
  aux_sym_parameters_declaration_repeat1 = 93,
  aux_sym_union_block_repeat1 = 94,
  aux_sym_arguments_repeat1 = 95,
  aux_sym_parenthesized_assignments_repeat1 = 96,
  aux_sym_list_repeat1 = 97,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_use] = "use",
  [anon_sym_include] = "include",
  [anon_sym_SEMI] = ";",
  [sym_include_path] = "include_path",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_for] = "for",
  [anon_sym_intersection_for] = "intersection_for",
  [anon_sym_let] = "let",
  [anon_sym_assign] = "assign",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_STAR] = "*",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_PERCENT] = "%",
  [sym_special_variable] = "special_variable",
  [sym_string] = "string",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACK] = "]",
  [anon_sym_each] = "each",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_QMARK] = "\?",
  [sym_source_file] = "source_file",
  [sym_include_statement] = "include_statement",
  [sym__item] = "_item",
  [sym_module_declaration] = "module_declaration",
  [sym_parameters_declaration] = "parameters_declaration",
  [sym__parameter_declaration] = "_parameter_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__statement] = "_statement",
  [sym_assignment] = "assignment",
  [sym_union_block] = "union_block",
  [sym_for_block] = "for_block",
  [sym_intersection_for_block] = "intersection_for_block",
  [sym_let_block] = "let_block",
  [sym_assign_block] = "assign_block",
  [sym_if_block] = "if_block",
  [sym_modifier_chain] = "modifier_chain",
  [sym_modifier] = "modifier",
  [sym_transform_chain] = "transform_chain",
  [sym_module_call] = "module_call",
  [sym_arguments] = "arguments",
  [sym_parenthesized_assignments] = "parenthesized_assignments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition_update_clause] = "condition_update_clause",
  [sym__expression] = "_expression",
  [sym_let_expression] = "let_expression",
  [sym__variable_name] = "_variable_name",
  [sym__literal] = "_literal",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_function] = "function",
  [sym_range] = "range",
  [sym_list] = "list",
  [sym__list_cell] = "_list_cell",
  [sym_each] = "each",
  [sym_list_comprehension] = "list_comprehension",
  [sym_for_clause] = "for_clause",
  [sym_if_clause] = "if_clause",
  [sym_function_call] = "function_call",
  [sym_index_expression] = "index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_parameters_declaration_repeat1] = "parameters_declaration_repeat1",
  [aux_sym_union_block_repeat1] = "union_block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parenthesized_assignments_repeat1] = "parenthesized_assignments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_include_path] = sym_include_path,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_intersection_for] = anon_sym_intersection_for,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_special_variable] = sym_special_variable,
  [sym_string] = sym_string,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_source_file] = sym_source_file,
  [sym_include_statement] = sym_include_statement,
  [sym__item] = sym__item,
  [sym_module_declaration] = sym_module_declaration,
  [sym_parameters_declaration] = sym_parameters_declaration,
  [sym__parameter_declaration] = sym__parameter_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__statement] = sym__statement,
  [sym_assignment] = sym_assignment,
  [sym_union_block] = sym_union_block,
  [sym_for_block] = sym_for_block,
  [sym_intersection_for_block] = sym_intersection_for_block,
  [sym_let_block] = sym_let_block,
  [sym_assign_block] = sym_assign_block,
  [sym_if_block] = sym_if_block,
  [sym_modifier_chain] = sym_modifier_chain,
  [sym_modifier] = sym_modifier,
  [sym_transform_chain] = sym_transform_chain,
  [sym_module_call] = sym_module_call,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_assignments] = sym_parenthesized_assignments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition_update_clause] = sym_condition_update_clause,
  [sym__expression] = sym__expression,
  [sym_let_expression] = sym_let_expression,
  [sym__variable_name] = sym__variable_name,
  [sym__literal] = sym__literal,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_function] = sym_function,
  [sym_range] = sym_range,
  [sym_list] = sym_list,
  [sym__list_cell] = sym__list_cell,
  [sym_each] = sym_each,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_for_clause] = sym_for_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_function_call] = sym_function_call,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_parameters_declaration_repeat1] = aux_sym_parameters_declaration_repeat1,
  [aux_sym_union_block_repeat1] = aux_sym_union_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parenthesized_assignments_repeat1] = aux_sym_parenthesized_assignments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_include_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intersection_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_special_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_union_block] = {
    .visible = true,
    .named = true,
  },
  [sym_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_transform_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_module_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_update_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_name] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_cell] = {
    .visible = false,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_end = 6,
  field_function = 7,
  field_increment = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_parameters = 13,
  field_right = 14,
  field_start = 15,
  field_update = 16,
  field_value = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_function] = "function",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 3},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 4},
  [10] = {.index = 20, .length = 2},
  [11] = {.index = 22, .length = 2},
  [12] = {.index = 24, .length = 3},
  [13] = {.index = 27, .length = 1},
  [14] = {.index = 28, .length = 3},
  [15] = {.index = 31, .length = 3},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 2},
  [18] = {.index = 38, .length = 3},
  [19] = {.index = 41, .length = 3},
  [20] = {.index = 44, .length = 3},
  [21] = {.index = 47, .length = 4},
  [22] = {.index = 51, .length = 4},
  [23] = {.index = 55, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_body, 2},
  [3] =
    {field_condition, 1},
    {field_consequence, 2},
  [5] =
    {field_left, 0},
    {field_right, 2},
  [7] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_name, 1},
    {field_parameters, 2},
  [14] =
    {field_body, 2},
    {field_parameters, 1},
  [16] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_index, 2},
    {field_value, 0},
  [22] =
    {field_end, 3},
    {field_start, 1},
  [24] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [27] =
    {field_condition, 2},
  [28] =
    {field_end, 5},
    {field_increment, 3},
    {field_start, 1},
  [31] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [34] =
    {field_condition, 2},
    {field_update, 4},
  [36] =
    {field_condition, 3},
    {field_initializer, 1},
  [38] =
    {field_condition, 2},
    {field_update, 4},
    {field_update, 5},
  [41] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
  [44] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
  [47] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
    {field_update, 6},
  [51] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
  [55] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(44);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(48);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(25)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(58);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(5)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(6)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(6)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '(') ADVANCE(44);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(44);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(79);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(43);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 22:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(40);
      if (lookahead == '\r') ADVANCE(41);
      END_STATE();
    case 24:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 25:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 26:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 27:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 28:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 29:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 30:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 31:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      if (lookahead == '\r') SKIP(30)
      END_STATE();
    case 32:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      END_STATE();
    case 33:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      if (lookahead == '\r') SKIP(32)
      END_STATE();
    case 34:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(44);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 35:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(44);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(45);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(48);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 36:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(44);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(31)
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 37:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '\\') SKIP(33)
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(23);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_include_path);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_special_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 't') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == 's') ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(16);
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(24);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(27);
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 23:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 33:
      if (lookahead == 'g') ADVANCE(41);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 44:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(56);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 56:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == '_') ADVANCE(61);
      END_STATE();
    case 61:
      if (lookahead == 'f') ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_intersection_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 34},
  [3] = {.lex_state = 35},
  [4] = {.lex_state = 5},
  [5] = {.lex_state = 5},
  [6] = {.lex_state = 35},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 35},
  [13] = {.lex_state = 35},
  [14] = {.lex_state = 35},
  [15] = {.lex_state = 5},
  [16] = {.lex_state = 35},
  [17] = {.lex_state = 35},
  [18] = {.lex_state = 35},
  [19] = {.lex_state = 35},
  [20] = {.lex_state = 35},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 5},
  [23] = {.lex_state = 34},
  [24] = {.lex_state = 35},
  [25] = {.lex_state = 5},
  [26] = {.lex_state = 5},
  [27] = {.lex_state = 35},
  [28] = {.lex_state = 35},
  [29] = {.lex_state = 5},
  [30] = {.lex_state = 34},
  [31] = {.lex_state = 35},
  [32] = {.lex_state = 35},
  [33] = {.lex_state = 35},
  [34] = {.lex_state = 35},
  [35] = {.lex_state = 35},
  [36] = {.lex_state = 35},
  [37] = {.lex_state = 35},
  [38] = {.lex_state = 35},
  [39] = {.lex_state = 35},
  [40] = {.lex_state = 35},
  [41] = {.lex_state = 35},
  [42] = {.lex_state = 35},
  [43] = {.lex_state = 35},
  [44] = {.lex_state = 35},
  [45] = {.lex_state = 5},
  [46] = {.lex_state = 35},
  [47] = {.lex_state = 5},
  [48] = {.lex_state = 35},
  [49] = {.lex_state = 36},
  [50] = {.lex_state = 35},
  [51] = {.lex_state = 35},
  [52] = {.lex_state = 5},
  [53] = {.lex_state = 35},
  [54] = {.lex_state = 35},
  [55] = {.lex_state = 35},
  [56] = {.lex_state = 35},
  [57] = {.lex_state = 35},
  [58] = {.lex_state = 35},
  [59] = {.lex_state = 35},
  [60] = {.lex_state = 35},
  [61] = {.lex_state = 35},
  [62] = {.lex_state = 35},
  [63] = {.lex_state = 35},
  [64] = {.lex_state = 35},
  [65] = {.lex_state = 35},
  [66] = {.lex_state = 35},
  [67] = {.lex_state = 35},
  [68] = {.lex_state = 35},
  [69] = {.lex_state = 35},
  [70] = {.lex_state = 35},
  [71] = {.lex_state = 35},
  [72] = {.lex_state = 35},
  [73] = {.lex_state = 35},
  [74] = {.lex_state = 35},
  [75] = {.lex_state = 35},
  [76] = {.lex_state = 35},
  [77] = {.lex_state = 35},
  [78] = {.lex_state = 35},
  [79] = {.lex_state = 35},
  [80] = {.lex_state = 35},
  [81] = {.lex_state = 34},
  [82] = {.lex_state = 36},
  [83] = {.lex_state = 34},
  [84] = {.lex_state = 34},
  [85] = {.lex_state = 34},
  [86] = {.lex_state = 34},
  [87] = {.lex_state = 5},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 5},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 5},
  [120] = {.lex_state = 5},
  [121] = {.lex_state = 5},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 5},
  [125] = {.lex_state = 5},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 5},
  [128] = {.lex_state = 5},
  [129] = {.lex_state = 5},
  [130] = {.lex_state = 5},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 35},
  [162] = {.lex_state = 35},
  [163] = {.lex_state = 35},
  [164] = {.lex_state = 35},
  [165] = {.lex_state = 35},
  [166] = {.lex_state = 35},
  [167] = {.lex_state = 6},
  [168] = {.lex_state = 35},
  [169] = {.lex_state = 35},
  [170] = {.lex_state = 35},
  [171] = {.lex_state = 35},
  [172] = {.lex_state = 34},
  [173] = {.lex_state = 34},
  [174] = {.lex_state = 34},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 5},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 34},
  [179] = {.lex_state = 34},
  [180] = {.lex_state = 34},
  [181] = {.lex_state = 5},
  [182] = {.lex_state = 34},
  [183] = {.lex_state = 34},
  [184] = {.lex_state = 34},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 34},
  [187] = {.lex_state = 34},
  [188] = {.lex_state = 34},
  [189] = {.lex_state = 34},
  [190] = {.lex_state = 34},
  [191] = {.lex_state = 5},
  [192] = {.lex_state = 34},
  [193] = {.lex_state = 34},
  [194] = {.lex_state = 5},
  [195] = {.lex_state = 34},
  [196] = {.lex_state = 6},
  [197] = {.lex_state = 6},
  [198] = {.lex_state = 35},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 35},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 35},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 35},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 35},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 35},
  [213] = {.lex_state = 35},
  [214] = {.lex_state = 6},
  [215] = {.lex_state = 6},
  [216] = {.lex_state = 6},
  [217] = {.lex_state = 6},
  [218] = {.lex_state = 35},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 35},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 35},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 6},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 35},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 6},
  [230] = {.lex_state = 35},
  [231] = {.lex_state = 6},
  [232] = {.lex_state = 6},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 35},
  [236] = {.lex_state = 6},
  [237] = {.lex_state = 6},
  [238] = {.lex_state = 6},
  [239] = {.lex_state = 6},
  [240] = {.lex_state = 35},
  [241] = {.lex_state = 37},
  [242] = {.lex_state = 37},
  [243] = {.lex_state = 37},
  [244] = {.lex_state = 37},
  [245] = {.lex_state = 35},
  [246] = {.lex_state = 37},
  [247] = {.lex_state = 37},
  [248] = {.lex_state = 37},
  [249] = {.lex_state = 37},
  [250] = {.lex_state = 35},
  [251] = {.lex_state = 35},
  [252] = {.lex_state = 35},
  [253] = {.lex_state = 37},
  [254] = {.lex_state = 37},
  [255] = {.lex_state = 35},
  [256] = {.lex_state = 35},
  [257] = {.lex_state = 35},
  [258] = {.lex_state = 35},
  [259] = {.lex_state = 35},
  [260] = {.lex_state = 35},
  [261] = {.lex_state = 35},
  [262] = {.lex_state = 35},
  [263] = {.lex_state = 35},
  [264] = {.lex_state = 37},
  [265] = {.lex_state = 35},
  [266] = {.lex_state = 35},
  [267] = {.lex_state = 34},
  [268] = {.lex_state = 34},
  [269] = {.lex_state = 34},
  [270] = {.lex_state = 34},
  [271] = {.lex_state = 34},
  [272] = {.lex_state = 34},
  [273] = {.lex_state = 34},
  [274] = {.lex_state = 34},
  [275] = {.lex_state = 34},
  [276] = {.lex_state = 34},
  [277] = {.lex_state = 34},
  [278] = {.lex_state = 34},
  [279] = {.lex_state = 5},
  [280] = {.lex_state = 5},
  [281] = {.lex_state = 5},
  [282] = {.lex_state = 5},
  [283] = {.lex_state = 5},
  [284] = {.lex_state = 5},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 5},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 34},
  [290] = {.lex_state = 34},
  [291] = {.lex_state = 5},
  [292] = {.lex_state = 5},
  [293] = {.lex_state = 34},
  [294] = {.lex_state = 34},
  [295] = {.lex_state = 34},
  [296] = {.lex_state = 34},
  [297] = {.lex_state = 34},
  [298] = {.lex_state = 34},
  [299] = {.lex_state = 34},
  [300] = {.lex_state = 34},
  [301] = {.lex_state = 34},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 34},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 6},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 6},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 6},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 34},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 34},
  [376] = {.lex_state = 34},
  [377] = {.lex_state = 34},
  [378] = {.lex_state = 34},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 34},
  [382] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_intersection_for] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_special_variable] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token2] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(368),
    [sym_include_statement] = STATE(23),
    [sym__item] = STATE(23),
    [sym_module_declaration] = STATE(23),
    [sym_function_declaration] = STATE(23),
    [sym__statement] = STATE(23),
    [sym_assignment] = STATE(367),
    [sym_union_block] = STATE(23),
    [sym_for_block] = STATE(23),
    [sym_intersection_for_block] = STATE(23),
    [sym_let_block] = STATE(23),
    [sym_assign_block] = STATE(23),
    [sym_if_block] = STATE(23),
    [sym_modifier_chain] = STATE(23),
    [sym_modifier] = STATE(182),
    [sym_transform_chain] = STATE(23),
    [sym_module_call] = STATE(189),
    [sym__variable_name] = STATE(374),
    [aux_sym_source_file_repeat1] = STATE(23),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_use] = ACTIONS(9),
    [anon_sym_include] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_module] = ACTIONS(13),
    [anon_sym_function] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_intersection_for] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_assign] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(29),
    [anon_sym_PERCENT] = ACTIONS(29),
    [sym_special_variable] = ACTIONS(31),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 16,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(35), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [49] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(37), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(39), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [102] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_each,
    STATE(8), 1,
      sym_for_clause,
    STATE(203), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(337), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [181] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(79), 1,
      anon_sym_COMMA,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 1,
      anon_sym_RBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    STATE(10), 1,
      sym_for_clause,
    STATE(205), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(314), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [262] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(103), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [315] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(107), 1,
      anon_sym_COMMA,
    ACTIONS(109), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(198), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(331), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [396] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_each,
    STATE(8), 1,
      sym_for_clause,
    STATE(203), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(335), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [475] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(111), 1,
      anon_sym_if,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(337), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [554] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(111), 1,
      anon_sym_if,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(335), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [633] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(113), 1,
      anon_sym_COMMA,
    ACTIONS(115), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(200), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(322), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(123), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(127), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [846] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(133), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [968] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(145), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(149), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1144] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(151), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1222] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(153), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1300] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(155), 1,
      ts_builtin_sym_end,
    ACTIONS(157), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(9), 2,
      anon_sym_use,
      anon_sym_include,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(30), 14,
      sym_include_statement,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(161), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1422] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(163), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1500] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(165), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1622] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1666] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    ACTIONS(175), 1,
      anon_sym_RBRACK,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1744] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      ts_builtin_sym_end,
    ACTIONS(179), 1,
      sym_identifier,
    ACTIONS(185), 1,
      anon_sym_SEMI,
    ACTIONS(188), 1,
      anon_sym_module,
    ACTIONS(191), 1,
      anon_sym_function,
    ACTIONS(194), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      anon_sym_for,
    ACTIONS(200), 1,
      anon_sym_intersection_for,
    ACTIONS(203), 1,
      anon_sym_let,
    ACTIONS(206), 1,
      anon_sym_assign,
    ACTIONS(209), 1,
      anon_sym_if,
    ACTIONS(215), 1,
      sym_special_variable,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(182), 2,
      anon_sym_use,
      anon_sym_include,
    ACTIONS(212), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(30), 14,
      sym_include_statement,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1822] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(218), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(220), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(224), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(228), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1954] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(232), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1998] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(236), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2042] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(248), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(103), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2107] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
    ACTIONS(103), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2170] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    ACTIONS(262), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(264), 1,
      anon_sym_AMP_AMP,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(248), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(258), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(260), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2241] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    ACTIONS(262), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(264), 1,
      anon_sym_AMP_AMP,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(248), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(268), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(270), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2312] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(103), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2363] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(37), 13,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(39), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2420] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    ACTIONS(262), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(264), 1,
      anon_sym_AMP_AMP,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(248), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(272), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(274), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2491] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(105), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
    ACTIONS(103), 13,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
  [2550] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    ACTIONS(262), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(264), 1,
      anon_sym_AMP_AMP,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(248), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(276), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(278), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2621] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_each,
    STATE(8), 1,
      sym_for_clause,
    STATE(203), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(333), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2696] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(37), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(39), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2747] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_each,
    STATE(10), 1,
      sym_for_clause,
    STATE(235), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(347), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2822] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    ACTIONS(264), 1,
      anon_sym_AMP_AMP,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(246), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(248), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(250), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(252), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(103), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2889] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      aux_sym_number_token2,
    ACTIONS(282), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(280), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2934] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(256), 1,
      anon_sym_CARET,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(103), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2987] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_LBRACK,
    ACTIONS(244), 1,
      anon_sym_DOT,
    ACTIONS(254), 1,
      anon_sym_SLASH,
    ACTIONS(256), 1,
      anon_sym_CARET,
    STATE(69), 1,
      sym_arguments,
    ACTIONS(240), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(103), 13,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(105), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3044] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_for,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_each,
    STATE(8), 1,
      sym_for_clause,
    STATE(203), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(318), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [3119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(133), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3161] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(218), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(220), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3203] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(161), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3287] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(145), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(127), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(236), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(123), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(224), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(149), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(35), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(228), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(232), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3833] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(37), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(39), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3888] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    ACTIONS(294), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(296), 1,
      anon_sym_AMP_AMP,
    ACTIONS(304), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(298), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(276), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(278), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3957] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(103), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(105), 12,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4014] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(103), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(105), 10,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [4075] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(298), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(103), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4138] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(103), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(105), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4193] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(290), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(103), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4244] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    ACTIONS(296), 1,
      anon_sym_AMP_AMP,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(298), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(103), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4309] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    ACTIONS(294), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(296), 1,
      anon_sym_AMP_AMP,
    ACTIONS(304), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(298), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(272), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(274), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4378] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    ACTIONS(294), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(296), 1,
      anon_sym_AMP_AMP,
    ACTIONS(304), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(298), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(258), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(260), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4447] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_SLASH,
    ACTIONS(290), 1,
      anon_sym_CARET,
    ACTIONS(294), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(296), 1,
      anon_sym_AMP_AMP,
    ACTIONS(304), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(286), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(292), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(298), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(302), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(268), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(270), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4516] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(306), 1,
      sym_identifier,
    ACTIONS(309), 1,
      anon_sym_SEMI,
    ACTIONS(312), 1,
      anon_sym_module,
    ACTIONS(315), 1,
      anon_sym_function,
    ACTIONS(318), 1,
      anon_sym_LBRACE,
    ACTIONS(321), 1,
      anon_sym_RBRACE,
    ACTIONS(323), 1,
      anon_sym_for,
    ACTIONS(326), 1,
      anon_sym_intersection_for,
    ACTIONS(329), 1,
      anon_sym_let,
    ACTIONS(332), 1,
      anon_sym_assign,
    ACTIONS(335), 1,
      anon_sym_if,
    ACTIONS(341), 1,
      sym_special_variable,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(338), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(81), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4589] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      aux_sym_number_token2,
    ACTIONS(282), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(280), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4632] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(346), 1,
      anon_sym_SEMI,
    ACTIONS(348), 1,
      anon_sym_function,
    ACTIONS(350), 1,
      anon_sym_RBRACE,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(84), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4705] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(348), 1,
      anon_sym_function,
    ACTIONS(352), 1,
      anon_sym_SEMI,
    ACTIONS(354), 1,
      anon_sym_RBRACE,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(81), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4778] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(348), 1,
      anon_sym_function,
    ACTIONS(352), 1,
      anon_sym_SEMI,
    ACTIONS(356), 1,
      anon_sym_RBRACE,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(81), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4851] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(348), 1,
      anon_sym_function,
    ACTIONS(358), 1,
      anon_sym_SEMI,
    ACTIONS(360), 1,
      anon_sym_RBRACE,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    STATE(367), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(85), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4924] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_RPAREN,
    ACTIONS(366), 1,
      sym_special_variable,
    STATE(210), 1,
      sym__expression,
    STATE(220), 1,
      sym__variable_name,
    STATE(323), 1,
      sym_assignment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4993] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(366), 1,
      sym_special_variable,
    ACTIONS(368), 1,
      anon_sym_RPAREN,
    STATE(202), 1,
      sym__expression,
    STATE(220), 1,
      sym__variable_name,
    STATE(328), 1,
      sym_assignment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5062] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(366), 1,
      sym_special_variable,
    ACTIONS(370), 1,
      anon_sym_RPAREN,
    STATE(213), 1,
      sym__expression,
    STATE(220), 1,
      sym__variable_name,
    STATE(330), 1,
      sym_assignment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5131] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(366), 1,
      sym_special_variable,
    STATE(220), 1,
      sym__variable_name,
    STATE(230), 1,
      sym__expression,
    STATE(342), 1,
      sym_assignment,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5197] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(206), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5258] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(257), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5319] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(164), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5380] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(163), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5441] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(162), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5502] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(6), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5563] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(256), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5624] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(255), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5685] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(168), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5746] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(166), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5807] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(245), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5868] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(251), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5929] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(208), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5990] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(70), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6051] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(39), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6112] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(71), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6173] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(169), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6234] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(170), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6295] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(78), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6356] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(226), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6417] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(259), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6478] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(76), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6539] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(38), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6600] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(75), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6661] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(77), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6722] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(218), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6783] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(74), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6844] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(73), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6905] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(72), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6966] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(6), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7027] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(171), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7088] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(40), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7149] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(43), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7210] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(3), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7271] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(37), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7332] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(36), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7393] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(48), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7454] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(51), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7515] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(50), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7576] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(80), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7637] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7698] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(165), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7759] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(215), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7820] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7881] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(214), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7942] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(212), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8003] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(161), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8064] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(240), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8125] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(263), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8186] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(196), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8247] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(211), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8308] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(207), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8369] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(261), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8430] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(258), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8491] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(197), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8552] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(204), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8613] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      sym_identifier,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_function,
    ACTIONS(55), 1,
      anon_sym_let,
    ACTIONS(59), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      sym_special_variable,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    STATE(201), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(73), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(229), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8674] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(46), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8735] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(250), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8796] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(3), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8857] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(252), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8918] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(41), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8979] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(260), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9040] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 1,
      anon_sym_function,
    ACTIONS(374), 1,
      anon_sym_let,
    ACTIONS(376), 1,
      anon_sym_BANG,
    ACTIONS(378), 1,
      aux_sym_number_token1,
    STATE(79), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(380), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9101] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(44), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9162] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym_identifier,
    ACTIONS(384), 1,
      anon_sym_LPAREN,
    ACTIONS(386), 1,
      anon_sym_function,
    ACTIONS(388), 1,
      anon_sym_let,
    ACTIONS(390), 1,
      anon_sym_BANG,
    ACTIONS(392), 1,
      sym_special_variable,
    ACTIONS(394), 1,
      sym_string,
    ACTIONS(396), 1,
      aux_sym_number_token1,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    STATE(42), 1,
      sym__expression,
    ACTIONS(398), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(402), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(64), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9223] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(262), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9284] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(222), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9345] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(266), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9406] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_function,
    ACTIONS(83), 1,
      anon_sym_let,
    ACTIONS(85), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      sym_special_variable,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    STATE(265), 1,
      sym__expression,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(101), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(17), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9467] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(268), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9525] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(103), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(105), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [9573] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [9623] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [9675] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9729] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(103), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(105), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [9775] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      aux_sym_number_token2,
    ACTIONS(282), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(280), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [9809] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(103), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [9851] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(272), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9909] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(276), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9967] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(37), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(39), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [10013] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_SEMI,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(248), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10064] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(442), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(243), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10115] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(274), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10166] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 10,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(448), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10197] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(452), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 10,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(456), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10259] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(458), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(253), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10310] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(460), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(267), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10361] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(462), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(254), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(466), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10443] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(468), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(269), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10494] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(470), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(276), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10545] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(472), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(275), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10596] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 10,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(476), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10627] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(478), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(273), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10678] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(480), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(242), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10729] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(482), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(244), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10780] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(484), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(270), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10831] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(486), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(247), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(490), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10913] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(492), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(241), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10964] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(494), 1,
      anon_sym_SEMI,
    STATE(187), 1,
      sym_modifier,
    STATE(188), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(249), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [11015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(498), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [11046] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(426), 1,
      sym_identifier,
    ACTIONS(500), 1,
      anon_sym_SEMI,
    STATE(182), 1,
      sym_modifier,
    STATE(189), 1,
      sym_module_call,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(272), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [11097] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 5,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [11149] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(103), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(105), 10,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11195] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(526), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(524), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11253] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 1,
      aux_sym_number_token2,
    ACTIONS(282), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(280), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11285] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(530), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(524), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11343] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    ACTIONS(532), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(534), 1,
      anon_sym_QMARK,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(268), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [11399] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(538), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_arguments,
    STATE(334), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11459] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    ACTIONS(532), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(534), 1,
      anon_sym_QMARK,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(524), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [11515] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(103), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 15,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11553] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(540), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(524), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11611] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    ACTIONS(532), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(534), 1,
      anon_sym_QMARK,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(276), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [11667] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 8,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [11715] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(37), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(39), 15,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11753] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(37), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(39), 12,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11797] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(542), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_arguments,
    STATE(319), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11857] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(105), 6,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [11907] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(544), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11963] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_arguments,
    STATE(321), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12023] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(103), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(105), 12,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12067] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(520), 1,
      anon_sym_SLASH,
    ACTIONS(522), 1,
      anon_sym_CARET,
    ACTIONS(532), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(534), 1,
      anon_sym_QMARK,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(504), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(510), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(516), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(272), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [12123] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    ACTIONS(506), 1,
      anon_sym_LBRACK,
    ACTIONS(508), 1,
      anon_sym_DOT,
    ACTIONS(522), 1,
      anon_sym_CARET,
    STATE(217), 1,
      sym_arguments,
    ACTIONS(103), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 14,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12192] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(548), 1,
      anon_sym_COLON,
    ACTIONS(550), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(35), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12278] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(552), 1,
      anon_sym_EQ,
    ACTIONS(135), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 17,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(133), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12338] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(554), 1,
      anon_sym_COLON,
    ACTIONS(556), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(224), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(236), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(127), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12482] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(558), 1,
      anon_sym_COLON,
    ACTIONS(560), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(123), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12626] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(562), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(161), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(145), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(228), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12797] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(524), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [12852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(149), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(119), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(230), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(232), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(218), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(220), 18,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12968] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(564), 1,
      anon_sym_SEMI,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13022] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(566), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(568), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(572), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(576), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(580), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13134] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(582), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13188] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(586), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(590), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(594), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(598), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13300] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(600), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13354] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(602), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13408] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(604), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 1,
      anon_sym_else,
    ACTIONS(606), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(608), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [13492] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 1,
      anon_sym_else,
    ACTIONS(606), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(608), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [13522] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(614), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13576] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(616), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13630] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(618), 1,
      anon_sym_SEMI,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13684] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(620), 1,
      anon_sym_SEMI,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13738] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13792] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(624), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13846] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(626), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13900] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(628), 1,
      anon_sym_COLON,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13954] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(630), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14008] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(634), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14036] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(636), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14090] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DOT,
    ACTIONS(408), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(410), 1,
      anon_sym_AMP_AMP,
    ACTIONS(418), 1,
      anon_sym_SLASH,
    ACTIONS(420), 1,
      anon_sym_CARET,
    ACTIONS(422), 1,
      anon_sym_QMARK,
    ACTIONS(638), 1,
      anon_sym_RBRACK,
    STATE(18), 1,
      sym_arguments,
    ACTIONS(404), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(406), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(412), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(414), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(416), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(598), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(642), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14198] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(572), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(580), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(586), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(576), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(590), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(644), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(646), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(594), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(566), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(568), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(634), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(648), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(650), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(652), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(654), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(658), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(662), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(666), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(670), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(674), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(678), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(682), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(686), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(690), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [14707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 6,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
    ACTIONS(694), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
  [14727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 6,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
    ACTIONS(698), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
  [14747] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      sym_string,
    ACTIONS(91), 1,
      aux_sym_number_token1,
    ACTIONS(95), 1,
      anon_sym_LBRACK,
    ACTIONS(700), 1,
      anon_sym_function,
    STATE(326), 1,
      sym__literal,
    ACTIONS(702), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(20), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [14777] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 1,
      sym_string,
    ACTIONS(65), 1,
      aux_sym_number_token1,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_function,
    STATE(326), 1,
      sym__literal,
    ACTIONS(706), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(236), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [14807] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(710), 1,
      anon_sym_COMMA,
    ACTIONS(712), 1,
      anon_sym_RPAREN,
    STATE(310), 1,
      sym__variable_name,
    ACTIONS(708), 2,
      sym_identifier,
      sym_special_variable,
    STATE(309), 2,
      sym__parameter_declaration,
      sym_assignment,
  [14828] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 1,
      anon_sym_RPAREN,
    STATE(310), 1,
      sym__variable_name,
    ACTIONS(708), 2,
      sym_identifier,
      sym_special_variable,
    STATE(358), 2,
      sym__parameter_declaration,
      sym_assignment,
  [14846] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_SEMI,
    ACTIONS(718), 1,
      anon_sym_RPAREN,
    STATE(303), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [14866] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 1,
      anon_sym_RPAREN,
    STATE(310), 1,
      sym__variable_name,
    ACTIONS(708), 2,
      sym_identifier,
      sym_special_variable,
    STATE(358), 2,
      sym__parameter_declaration,
      sym_assignment,
  [14884] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(722), 1,
      anon_sym_RPAREN,
    STATE(325), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [14901] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_RPAREN,
    STATE(338), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [14918] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [14935] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(718), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [14952] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(310), 1,
      sym__variable_name,
    ACTIONS(708), 2,
      sym_identifier,
      sym_special_variable,
    STATE(358), 2,
      sym__parameter_declaration,
      sym_assignment,
  [14967] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_SEMI,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [14983] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(734), 1,
      anon_sym_SEMI,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    STATE(302), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [14999] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 1,
      anon_sym_COMMA,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
    ACTIONS(738), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [15013] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(324), 1,
      sym_assignment,
    STATE(374), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [15027] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 1,
      anon_sym_COMMA,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    STATE(306), 1,
      aux_sym_parameters_declaration_repeat1,
  [15040] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 1,
      anon_sym_RPAREN,
    ACTIONS(748), 1,
      anon_sym_COMMA,
    STATE(306), 1,
      aux_sym_parameters_declaration_repeat1,
  [15053] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(750), 1,
      anon_sym_EQ,
    STATE(289), 1,
      sym_arguments,
  [15066] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_COMMA,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(307), 1,
      aux_sym_parameters_declaration_repeat1,
  [15079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_EQ,
    ACTIONS(756), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15090] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15103] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(315), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15116] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 1,
      anon_sym_LPAREN,
    STATE(282), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [15127] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_COMMA,
    ACTIONS(766), 1,
      anon_sym_RBRACK,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15140] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15153] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 1,
      anon_sym_COMMA,
    ACTIONS(773), 1,
      anon_sym_RBRACK,
    STATE(316), 1,
      aux_sym_list_repeat1,
  [15166] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    ACTIONS(775), 1,
      anon_sym_COMMA,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [15179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_else,
    ACTIONS(778), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [15190] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(782), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [15203] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 1,
      anon_sym_RBRACK,
    ACTIONS(784), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_list_repeat1,
  [15216] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(786), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [15229] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 1,
      anon_sym_COMMA,
    ACTIONS(790), 1,
      anon_sym_RBRACK,
    STATE(320), 1,
      aux_sym_list_repeat1,
  [15242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(542), 1,
      anon_sym_RPAREN,
    STATE(319), 1,
      aux_sym_arguments_repeat1,
  [15255] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15264] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(792), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [15286] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    ACTIONS(796), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_list_repeat1,
  [15299] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(538), 1,
      anon_sym_RPAREN,
    STATE(334), 1,
      aux_sym_arguments_repeat1,
  [15312] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(798), 1,
      anon_sym_RPAREN,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    STATE(321), 1,
      aux_sym_arguments_repeat1,
  [15338] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_COMMA,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
    STATE(336), 1,
      aux_sym_list_repeat1,
  [15351] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    STATE(311), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 1,
      anon_sym_else,
    ACTIONS(778), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [15375] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_COMMA,
    ACTIONS(806), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [15388] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(808), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [15397] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 1,
      anon_sym_RBRACK,
    ACTIONS(810), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_list_repeat1,
  [15410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [15419] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(814), 1,
      anon_sym_RPAREN,
    STATE(329), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15432] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      anon_sym_COMMA,
    ACTIONS(816), 1,
      anon_sym_RPAREN,
    STATE(304), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(91), 1,
      sym_parameters_declaration,
  [15455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(107), 1,
      sym_parenthesized_assignments,
  [15465] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(174), 1,
      sym_parameters_declaration,
  [15483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      sym_parameters_declaration,
  [15493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_parenthesized_assignments,
  [15503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(382), 1,
      sym_parameters_declaration,
  [15513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [15521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      sym_parenthesized_expression,
  [15531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(289), 1,
      sym_arguments,
  [15541] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    STATE(180), 1,
      sym_parenthesized_expression,
  [15551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    STATE(45), 1,
      sym_parenthesized_expression,
  [15561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      sym_parenthesized_assignments,
  [15571] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(156), 1,
      sym_parenthesized_assignments,
  [15581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(184), 1,
      sym_parenthesized_assignments,
  [15591] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(155), 1,
      sym_parameters_declaration,
  [15601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(183), 1,
      sym_parenthesized_assignments,
  [15611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_parenthesized_assignments,
  [15621] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15629] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(193), 1,
      sym_parenthesized_assignments,
  [15639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(192), 1,
      sym_parenthesized_assignments,
  [15649] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(108), 1,
      sym_parameters_declaration,
  [15659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(133), 1,
      sym_parenthesized_assignments,
  [15669] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(172), 1,
      sym_parenthesized_assignments,
  [15679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 1,
      anon_sym_LPAREN,
    STATE(373), 1,
      sym_parameters_declaration,
  [15689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LPAREN,
    STATE(190), 1,
      sym_parenthesized_assignments,
  [15699] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    STATE(178), 1,
      sym_parenthesized_expression,
  [15709] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_SEMI,
  [15716] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 1,
      ts_builtin_sym_end,
  [15723] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_RBRACK,
  [15730] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
  [15737] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 1,
      sym_identifier,
  [15744] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 1,
      sym_include_path,
  [15751] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 1,
      anon_sym_EQ,
  [15758] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_EQ,
  [15765] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      sym_identifier,
  [15772] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 1,
      sym_identifier,
  [15779] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 1,
      sym_identifier,
  [15786] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      sym_identifier,
  [15793] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 1,
      anon_sym_RBRACK,
  [15800] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
  [15807] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 1,
      sym_identifier,
  [15814] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      anon_sym_EQ,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 49,
  [SMALL_STATE(4)] = 102,
  [SMALL_STATE(5)] = 181,
  [SMALL_STATE(6)] = 262,
  [SMALL_STATE(7)] = 315,
  [SMALL_STATE(8)] = 396,
  [SMALL_STATE(9)] = 475,
  [SMALL_STATE(10)] = 554,
  [SMALL_STATE(11)] = 633,
  [SMALL_STATE(12)] = 714,
  [SMALL_STATE(13)] = 758,
  [SMALL_STATE(14)] = 802,
  [SMALL_STATE(15)] = 846,
  [SMALL_STATE(16)] = 924,
  [SMALL_STATE(17)] = 968,
  [SMALL_STATE(18)] = 1012,
  [SMALL_STATE(19)] = 1056,
  [SMALL_STATE(20)] = 1100,
  [SMALL_STATE(21)] = 1144,
  [SMALL_STATE(22)] = 1222,
  [SMALL_STATE(23)] = 1300,
  [SMALL_STATE(24)] = 1378,
  [SMALL_STATE(25)] = 1422,
  [SMALL_STATE(26)] = 1500,
  [SMALL_STATE(27)] = 1578,
  [SMALL_STATE(28)] = 1622,
  [SMALL_STATE(29)] = 1666,
  [SMALL_STATE(30)] = 1744,
  [SMALL_STATE(31)] = 1822,
  [SMALL_STATE(32)] = 1866,
  [SMALL_STATE(33)] = 1910,
  [SMALL_STATE(34)] = 1954,
  [SMALL_STATE(35)] = 1998,
  [SMALL_STATE(36)] = 2042,
  [SMALL_STATE(37)] = 2107,
  [SMALL_STATE(38)] = 2170,
  [SMALL_STATE(39)] = 2241,
  [SMALL_STATE(40)] = 2312,
  [SMALL_STATE(41)] = 2363,
  [SMALL_STATE(42)] = 2420,
  [SMALL_STATE(43)] = 2491,
  [SMALL_STATE(44)] = 2550,
  [SMALL_STATE(45)] = 2621,
  [SMALL_STATE(46)] = 2696,
  [SMALL_STATE(47)] = 2747,
  [SMALL_STATE(48)] = 2822,
  [SMALL_STATE(49)] = 2889,
  [SMALL_STATE(50)] = 2934,
  [SMALL_STATE(51)] = 2987,
  [SMALL_STATE(52)] = 3044,
  [SMALL_STATE(53)] = 3119,
  [SMALL_STATE(54)] = 3161,
  [SMALL_STATE(55)] = 3203,
  [SMALL_STATE(56)] = 3245,
  [SMALL_STATE(57)] = 3287,
  [SMALL_STATE(58)] = 3329,
  [SMALL_STATE(59)] = 3371,
  [SMALL_STATE(60)] = 3413,
  [SMALL_STATE(61)] = 3455,
  [SMALL_STATE(62)] = 3497,
  [SMALL_STATE(63)] = 3539,
  [SMALL_STATE(64)] = 3581,
  [SMALL_STATE(65)] = 3623,
  [SMALL_STATE(66)] = 3665,
  [SMALL_STATE(67)] = 3707,
  [SMALL_STATE(68)] = 3749,
  [SMALL_STATE(69)] = 3791,
  [SMALL_STATE(70)] = 3833,
  [SMALL_STATE(71)] = 3888,
  [SMALL_STATE(72)] = 3957,
  [SMALL_STATE(73)] = 4014,
  [SMALL_STATE(74)] = 4075,
  [SMALL_STATE(75)] = 4138,
  [SMALL_STATE(76)] = 4193,
  [SMALL_STATE(77)] = 4244,
  [SMALL_STATE(78)] = 4309,
  [SMALL_STATE(79)] = 4378,
  [SMALL_STATE(80)] = 4447,
  [SMALL_STATE(81)] = 4516,
  [SMALL_STATE(82)] = 4589,
  [SMALL_STATE(83)] = 4632,
  [SMALL_STATE(84)] = 4705,
  [SMALL_STATE(85)] = 4778,
  [SMALL_STATE(86)] = 4851,
  [SMALL_STATE(87)] = 4924,
  [SMALL_STATE(88)] = 4993,
  [SMALL_STATE(89)] = 5062,
  [SMALL_STATE(90)] = 5131,
  [SMALL_STATE(91)] = 5197,
  [SMALL_STATE(92)] = 5258,
  [SMALL_STATE(93)] = 5319,
  [SMALL_STATE(94)] = 5380,
  [SMALL_STATE(95)] = 5441,
  [SMALL_STATE(96)] = 5502,
  [SMALL_STATE(97)] = 5563,
  [SMALL_STATE(98)] = 5624,
  [SMALL_STATE(99)] = 5685,
  [SMALL_STATE(100)] = 5746,
  [SMALL_STATE(101)] = 5807,
  [SMALL_STATE(102)] = 5868,
  [SMALL_STATE(103)] = 5929,
  [SMALL_STATE(104)] = 5990,
  [SMALL_STATE(105)] = 6051,
  [SMALL_STATE(106)] = 6112,
  [SMALL_STATE(107)] = 6173,
  [SMALL_STATE(108)] = 6234,
  [SMALL_STATE(109)] = 6295,
  [SMALL_STATE(110)] = 6356,
  [SMALL_STATE(111)] = 6417,
  [SMALL_STATE(112)] = 6478,
  [SMALL_STATE(113)] = 6539,
  [SMALL_STATE(114)] = 6600,
  [SMALL_STATE(115)] = 6661,
  [SMALL_STATE(116)] = 6722,
  [SMALL_STATE(117)] = 6783,
  [SMALL_STATE(118)] = 6844,
  [SMALL_STATE(119)] = 6905,
  [SMALL_STATE(120)] = 6966,
  [SMALL_STATE(121)] = 7027,
  [SMALL_STATE(122)] = 7088,
  [SMALL_STATE(123)] = 7149,
  [SMALL_STATE(124)] = 7210,
  [SMALL_STATE(125)] = 7271,
  [SMALL_STATE(126)] = 7332,
  [SMALL_STATE(127)] = 7393,
  [SMALL_STATE(128)] = 7454,
  [SMALL_STATE(129)] = 7515,
  [SMALL_STATE(130)] = 7576,
  [SMALL_STATE(131)] = 7637,
  [SMALL_STATE(132)] = 7698,
  [SMALL_STATE(133)] = 7759,
  [SMALL_STATE(134)] = 7820,
  [SMALL_STATE(135)] = 7881,
  [SMALL_STATE(136)] = 7942,
  [SMALL_STATE(137)] = 8003,
  [SMALL_STATE(138)] = 8064,
  [SMALL_STATE(139)] = 8125,
  [SMALL_STATE(140)] = 8186,
  [SMALL_STATE(141)] = 8247,
  [SMALL_STATE(142)] = 8308,
  [SMALL_STATE(143)] = 8369,
  [SMALL_STATE(144)] = 8430,
  [SMALL_STATE(145)] = 8491,
  [SMALL_STATE(146)] = 8552,
  [SMALL_STATE(147)] = 8613,
  [SMALL_STATE(148)] = 8674,
  [SMALL_STATE(149)] = 8735,
  [SMALL_STATE(150)] = 8796,
  [SMALL_STATE(151)] = 8857,
  [SMALL_STATE(152)] = 8918,
  [SMALL_STATE(153)] = 8979,
  [SMALL_STATE(154)] = 9040,
  [SMALL_STATE(155)] = 9101,
  [SMALL_STATE(156)] = 9162,
  [SMALL_STATE(157)] = 9223,
  [SMALL_STATE(158)] = 9284,
  [SMALL_STATE(159)] = 9345,
  [SMALL_STATE(160)] = 9406,
  [SMALL_STATE(161)] = 9467,
  [SMALL_STATE(162)] = 9525,
  [SMALL_STATE(163)] = 9573,
  [SMALL_STATE(164)] = 9623,
  [SMALL_STATE(165)] = 9675,
  [SMALL_STATE(166)] = 9729,
  [SMALL_STATE(167)] = 9775,
  [SMALL_STATE(168)] = 9809,
  [SMALL_STATE(169)] = 9851,
  [SMALL_STATE(170)] = 9909,
  [SMALL_STATE(171)] = 9967,
  [SMALL_STATE(172)] = 10013,
  [SMALL_STATE(173)] = 10064,
  [SMALL_STATE(174)] = 10115,
  [SMALL_STATE(175)] = 10166,
  [SMALL_STATE(176)] = 10197,
  [SMALL_STATE(177)] = 10228,
  [SMALL_STATE(178)] = 10259,
  [SMALL_STATE(179)] = 10310,
  [SMALL_STATE(180)] = 10361,
  [SMALL_STATE(181)] = 10412,
  [SMALL_STATE(182)] = 10443,
  [SMALL_STATE(183)] = 10494,
  [SMALL_STATE(184)] = 10545,
  [SMALL_STATE(185)] = 10596,
  [SMALL_STATE(186)] = 10627,
  [SMALL_STATE(187)] = 10678,
  [SMALL_STATE(188)] = 10729,
  [SMALL_STATE(189)] = 10780,
  [SMALL_STATE(190)] = 10831,
  [SMALL_STATE(191)] = 10882,
  [SMALL_STATE(192)] = 10913,
  [SMALL_STATE(193)] = 10964,
  [SMALL_STATE(194)] = 11015,
  [SMALL_STATE(195)] = 11046,
  [SMALL_STATE(196)] = 11097,
  [SMALL_STATE(197)] = 11149,
  [SMALL_STATE(198)] = 11195,
  [SMALL_STATE(199)] = 11253,
  [SMALL_STATE(200)] = 11285,
  [SMALL_STATE(201)] = 11343,
  [SMALL_STATE(202)] = 11399,
  [SMALL_STATE(203)] = 11459,
  [SMALL_STATE(204)] = 11515,
  [SMALL_STATE(205)] = 11553,
  [SMALL_STATE(206)] = 11611,
  [SMALL_STATE(207)] = 11667,
  [SMALL_STATE(208)] = 11715,
  [SMALL_STATE(209)] = 11753,
  [SMALL_STATE(210)] = 11797,
  [SMALL_STATE(211)] = 11857,
  [SMALL_STATE(212)] = 11907,
  [SMALL_STATE(213)] = 11963,
  [SMALL_STATE(214)] = 12023,
  [SMALL_STATE(215)] = 12067,
  [SMALL_STATE(216)] = 12123,
  [SMALL_STATE(217)] = 12163,
  [SMALL_STATE(218)] = 12192,
  [SMALL_STATE(219)] = 12249,
  [SMALL_STATE(220)] = 12278,
  [SMALL_STATE(221)] = 12309,
  [SMALL_STATE(222)] = 12338,
  [SMALL_STATE(223)] = 12395,
  [SMALL_STATE(224)] = 12424,
  [SMALL_STATE(225)] = 12453,
  [SMALL_STATE(226)] = 12482,
  [SMALL_STATE(227)] = 12539,
  [SMALL_STATE(228)] = 12568,
  [SMALL_STATE(229)] = 12597,
  [SMALL_STATE(230)] = 12626,
  [SMALL_STATE(231)] = 12681,
  [SMALL_STATE(232)] = 12710,
  [SMALL_STATE(233)] = 12739,
  [SMALL_STATE(234)] = 12768,
  [SMALL_STATE(235)] = 12797,
  [SMALL_STATE(236)] = 12852,
  [SMALL_STATE(237)] = 12881,
  [SMALL_STATE(238)] = 12910,
  [SMALL_STATE(239)] = 12939,
  [SMALL_STATE(240)] = 12968,
  [SMALL_STATE(241)] = 13022,
  [SMALL_STATE(242)] = 13050,
  [SMALL_STATE(243)] = 13078,
  [SMALL_STATE(244)] = 13106,
  [SMALL_STATE(245)] = 13134,
  [SMALL_STATE(246)] = 13188,
  [SMALL_STATE(247)] = 13216,
  [SMALL_STATE(248)] = 13244,
  [SMALL_STATE(249)] = 13272,
  [SMALL_STATE(250)] = 13300,
  [SMALL_STATE(251)] = 13354,
  [SMALL_STATE(252)] = 13408,
  [SMALL_STATE(253)] = 13462,
  [SMALL_STATE(254)] = 13492,
  [SMALL_STATE(255)] = 13522,
  [SMALL_STATE(256)] = 13576,
  [SMALL_STATE(257)] = 13630,
  [SMALL_STATE(258)] = 13684,
  [SMALL_STATE(259)] = 13738,
  [SMALL_STATE(260)] = 13792,
  [SMALL_STATE(261)] = 13846,
  [SMALL_STATE(262)] = 13900,
  [SMALL_STATE(263)] = 13954,
  [SMALL_STATE(264)] = 14008,
  [SMALL_STATE(265)] = 14036,
  [SMALL_STATE(266)] = 14090,
  [SMALL_STATE(267)] = 14144,
  [SMALL_STATE(268)] = 14171,
  [SMALL_STATE(269)] = 14198,
  [SMALL_STATE(270)] = 14225,
  [SMALL_STATE(271)] = 14252,
  [SMALL_STATE(272)] = 14279,
  [SMALL_STATE(273)] = 14306,
  [SMALL_STATE(274)] = 14333,
  [SMALL_STATE(275)] = 14360,
  [SMALL_STATE(276)] = 14387,
  [SMALL_STATE(277)] = 14414,
  [SMALL_STATE(278)] = 14441,
  [SMALL_STATE(279)] = 14467,
  [SMALL_STATE(280)] = 14491,
  [SMALL_STATE(281)] = 14515,
  [SMALL_STATE(282)] = 14539,
  [SMALL_STATE(283)] = 14563,
  [SMALL_STATE(284)] = 14587,
  [SMALL_STATE(285)] = 14611,
  [SMALL_STATE(286)] = 14635,
  [SMALL_STATE(287)] = 14659,
  [SMALL_STATE(288)] = 14683,
  [SMALL_STATE(289)] = 14707,
  [SMALL_STATE(290)] = 14727,
  [SMALL_STATE(291)] = 14747,
  [SMALL_STATE(292)] = 14777,
  [SMALL_STATE(293)] = 14807,
  [SMALL_STATE(294)] = 14828,
  [SMALL_STATE(295)] = 14846,
  [SMALL_STATE(296)] = 14866,
  [SMALL_STATE(297)] = 14884,
  [SMALL_STATE(298)] = 14901,
  [SMALL_STATE(299)] = 14918,
  [SMALL_STATE(300)] = 14935,
  [SMALL_STATE(301)] = 14952,
  [SMALL_STATE(302)] = 14967,
  [SMALL_STATE(303)] = 14983,
  [SMALL_STATE(304)] = 14999,
  [SMALL_STATE(305)] = 15013,
  [SMALL_STATE(306)] = 15027,
  [SMALL_STATE(307)] = 15040,
  [SMALL_STATE(308)] = 15053,
  [SMALL_STATE(309)] = 15066,
  [SMALL_STATE(310)] = 15079,
  [SMALL_STATE(311)] = 15090,
  [SMALL_STATE(312)] = 15103,
  [SMALL_STATE(313)] = 15116,
  [SMALL_STATE(314)] = 15127,
  [SMALL_STATE(315)] = 15140,
  [SMALL_STATE(316)] = 15153,
  [SMALL_STATE(317)] = 15166,
  [SMALL_STATE(318)] = 15179,
  [SMALL_STATE(319)] = 15190,
  [SMALL_STATE(320)] = 15203,
  [SMALL_STATE(321)] = 15216,
  [SMALL_STATE(322)] = 15229,
  [SMALL_STATE(323)] = 15242,
  [SMALL_STATE(324)] = 15255,
  [SMALL_STATE(325)] = 15264,
  [SMALL_STATE(326)] = 15277,
  [SMALL_STATE(327)] = 15286,
  [SMALL_STATE(328)] = 15299,
  [SMALL_STATE(329)] = 15312,
  [SMALL_STATE(330)] = 15325,
  [SMALL_STATE(331)] = 15338,
  [SMALL_STATE(332)] = 15351,
  [SMALL_STATE(333)] = 15364,
  [SMALL_STATE(334)] = 15375,
  [SMALL_STATE(335)] = 15388,
  [SMALL_STATE(336)] = 15397,
  [SMALL_STATE(337)] = 15410,
  [SMALL_STATE(338)] = 15419,
  [SMALL_STATE(339)] = 15432,
  [SMALL_STATE(340)] = 15445,
  [SMALL_STATE(341)] = 15455,
  [SMALL_STATE(342)] = 15465,
  [SMALL_STATE(343)] = 15473,
  [SMALL_STATE(344)] = 15483,
  [SMALL_STATE(345)] = 15493,
  [SMALL_STATE(346)] = 15503,
  [SMALL_STATE(347)] = 15513,
  [SMALL_STATE(348)] = 15521,
  [SMALL_STATE(349)] = 15531,
  [SMALL_STATE(350)] = 15541,
  [SMALL_STATE(351)] = 15551,
  [SMALL_STATE(352)] = 15561,
  [SMALL_STATE(353)] = 15571,
  [SMALL_STATE(354)] = 15581,
  [SMALL_STATE(355)] = 15591,
  [SMALL_STATE(356)] = 15601,
  [SMALL_STATE(357)] = 15611,
  [SMALL_STATE(358)] = 15621,
  [SMALL_STATE(359)] = 15629,
  [SMALL_STATE(360)] = 15639,
  [SMALL_STATE(361)] = 15649,
  [SMALL_STATE(362)] = 15659,
  [SMALL_STATE(363)] = 15669,
  [SMALL_STATE(364)] = 15679,
  [SMALL_STATE(365)] = 15689,
  [SMALL_STATE(366)] = 15699,
  [SMALL_STATE(367)] = 15709,
  [SMALL_STATE(368)] = 15716,
  [SMALL_STATE(369)] = 15723,
  [SMALL_STATE(370)] = 15730,
  [SMALL_STATE(371)] = 15737,
  [SMALL_STATE(372)] = 15744,
  [SMALL_STATE(373)] = 15751,
  [SMALL_STATE(374)] = 15758,
  [SMALL_STATE(375)] = 15765,
  [SMALL_STATE(376)] = 15772,
  [SMALL_STATE(377)] = 15779,
  [SMALL_STATE(378)] = 15786,
  [SMALL_STATE(379)] = 15793,
  [SMALL_STATE(380)] = 15800,
  [SMALL_STATE(381)] = 15807,
  [SMALL_STATE(382)] = 15814,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [33] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [35] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [37] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(313),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, .production_id = 11),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, .production_id = 11),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(308),
  [182] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(372),
  [185] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(30),
  [188] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(377),
  [191] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(376),
  [194] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(86),
  [197] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(352),
  [200] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(354),
  [203] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(356),
  [206] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(357),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(366),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(290),
  [215] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(374),
  [218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 7, .production_id = 14),
  [220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 7, .production_id = 14),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 3, .production_id = 8),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 3, .production_id = 8),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [300] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [306] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(308),
  [309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(81),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(377),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(378),
  [318] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(86),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2),
  [323] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(352),
  [326] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(354),
  [329] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(356),
  [332] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(357),
  [335] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(366),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(290),
  [341] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(374),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 2),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 2),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 2),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 2),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 3),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 3),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 3),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 3),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 4),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 4),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 4),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 4),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 5),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 5),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [516] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_cell, 1),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 4),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [568] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier_chain, 2),
  [572] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier_chain, 2),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 2),
  [580] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 2),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 3),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 3),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 2),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 2),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 2),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__item, 2),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [646] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2),
  [650] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 2),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_clause, 2),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 2),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 5, .production_id = 13),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 5, .production_id = 13),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [688] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier, 1),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier, 1),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2), SHIFT_REPEAT(305),
  [743] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2), SHIFT_REPEAT(301),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_name, 1),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_declaration, 1),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [770] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(47),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2),
  [775] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(90),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 3),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 2),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_comprehension, 2),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 5, .production_id = 15),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [824] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_openscad(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
