#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 255
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 96
#define ALIAS_COUNT 0
#define TOKEN_COUNT 48
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_use = 3,
  anon_sym_include = 4,
  anon_sym_SEMI = 5,
  sym_include_path = 6,
  anon_sym_module = 7,
  anon_sym_LPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_RPAREN = 10,
  anon_sym_function = 11,
  anon_sym_EQ = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_for = 15,
  anon_sym_intersection_for = 16,
  anon_sym_let = 17,
  anon_sym_assign = 18,
  anon_sym_if = 19,
  anon_sym_else = 20,
  anon_sym_STAR = 21,
  anon_sym_BANG = 22,
  anon_sym_POUND = 23,
  anon_sym_PERCENT = 24,
  sym_special_variable = 25,
  sym_string = 26,
  sym_number = 27,
  anon_sym_true = 28,
  anon_sym_false = 29,
  anon_sym_LBRACK = 30,
  anon_sym_COLON = 31,
  anon_sym_RBRACK = 32,
  anon_sym_each = 33,
  anon_sym_DOT = 34,
  anon_sym_DASH = 35,
  anon_sym_PLUS = 36,
  anon_sym_PIPE_PIPE = 37,
  anon_sym_AMP_AMP = 38,
  anon_sym_EQ_EQ = 39,
  anon_sym_BANG_EQ = 40,
  anon_sym_LT = 41,
  anon_sym_GT = 42,
  anon_sym_LT_EQ = 43,
  anon_sym_GT_EQ = 44,
  anon_sym_SLASH = 45,
  anon_sym_CARET = 46,
  anon_sym_QMARK = 47,
  sym_source_file = 48,
  sym_include_statement = 49,
  sym__item = 50,
  sym_module_declaration = 51,
  sym_parameters_declaration = 52,
  sym__parameter_declaration = 53,
  sym_function_declaration = 54,
  sym__statement = 55,
  sym_assignment = 56,
  sym_union_block = 57,
  sym_for_block = 58,
  sym_intersection_for_block = 59,
  sym_let_block = 60,
  sym_assign_block = 61,
  sym_if_block = 62,
  sym_modifier_chain = 63,
  sym_modifier = 64,
  sym_transform_chain = 65,
  sym_module_call = 66,
  sym_arguments = 67,
  sym_parenthesized_assignments = 68,
  sym_parenthesized_expression = 69,
  sym_condition_update_clause = 70,
  sym__expression = 71,
  sym_let_expression = 72,
  sym__variable_name = 73,
  sym__literal = 74,
  sym_boolean = 75,
  sym_function = 76,
  sym_range = 77,
  sym_list = 78,
  sym__list_cell = 79,
  sym_each = 80,
  sym_list_comprehension = 81,
  sym_for_clause = 82,
  sym_if_clause = 83,
  sym_function_call = 84,
  sym_index_expression = 85,
  sym_dot_index_expression = 86,
  sym_unary_expression = 87,
  sym_binary_expression = 88,
  sym_ternary_expression = 89,
  aux_sym_source_file_repeat1 = 90,
  aux_sym_parameters_declaration_repeat1 = 91,
  aux_sym_union_block_repeat1 = 92,
  aux_sym_arguments_repeat1 = 93,
  aux_sym_parenthesized_assignments_repeat1 = 94,
  aux_sym_list_repeat1 = 95,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_use] = "use",
  [anon_sym_include] = "include",
  [anon_sym_SEMI] = ";",
  [sym_include_path] = "include_path",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_for] = "for",
  [anon_sym_intersection_for] = "intersection_for",
  [anon_sym_let] = "let",
  [anon_sym_assign] = "assign",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_STAR] = "*",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_PERCENT] = "%",
  [sym_special_variable] = "special_variable",
  [sym_string] = "string",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACK] = "]",
  [anon_sym_each] = "each",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_QMARK] = "\?",
  [sym_source_file] = "source_file",
  [sym_include_statement] = "include_statement",
  [sym__item] = "_item",
  [sym_module_declaration] = "module_declaration",
  [sym_parameters_declaration] = "parameters_declaration",
  [sym__parameter_declaration] = "_parameter_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__statement] = "_statement",
  [sym_assignment] = "assignment",
  [sym_union_block] = "union_block",
  [sym_for_block] = "for_block",
  [sym_intersection_for_block] = "intersection_for_block",
  [sym_let_block] = "let_block",
  [sym_assign_block] = "assign_block",
  [sym_if_block] = "if_block",
  [sym_modifier_chain] = "modifier_chain",
  [sym_modifier] = "modifier",
  [sym_transform_chain] = "transform_chain",
  [sym_module_call] = "module_call",
  [sym_arguments] = "arguments",
  [sym_parenthesized_assignments] = "parenthesized_assignments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition_update_clause] = "condition_update_clause",
  [sym__expression] = "_expression",
  [sym_let_expression] = "let_expression",
  [sym__variable_name] = "_variable_name",
  [sym__literal] = "_literal",
  [sym_boolean] = "boolean",
  [sym_function] = "function",
  [sym_range] = "range",
  [sym_list] = "list",
  [sym__list_cell] = "_list_cell",
  [sym_each] = "each",
  [sym_list_comprehension] = "list_comprehension",
  [sym_for_clause] = "for_clause",
  [sym_if_clause] = "if_clause",
  [sym_function_call] = "function_call",
  [sym_index_expression] = "index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_parameters_declaration_repeat1] = "parameters_declaration_repeat1",
  [aux_sym_union_block_repeat1] = "union_block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parenthesized_assignments_repeat1] = "parenthesized_assignments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_include_path] = sym_include_path,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_intersection_for] = anon_sym_intersection_for,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_special_variable] = sym_special_variable,
  [sym_string] = sym_string,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_source_file] = sym_source_file,
  [sym_include_statement] = sym_include_statement,
  [sym__item] = sym__item,
  [sym_module_declaration] = sym_module_declaration,
  [sym_parameters_declaration] = sym_parameters_declaration,
  [sym__parameter_declaration] = sym__parameter_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__statement] = sym__statement,
  [sym_assignment] = sym_assignment,
  [sym_union_block] = sym_union_block,
  [sym_for_block] = sym_for_block,
  [sym_intersection_for_block] = sym_intersection_for_block,
  [sym_let_block] = sym_let_block,
  [sym_assign_block] = sym_assign_block,
  [sym_if_block] = sym_if_block,
  [sym_modifier_chain] = sym_modifier_chain,
  [sym_modifier] = sym_modifier,
  [sym_transform_chain] = sym_transform_chain,
  [sym_module_call] = sym_module_call,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_assignments] = sym_parenthesized_assignments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition_update_clause] = sym_condition_update_clause,
  [sym__expression] = sym__expression,
  [sym_let_expression] = sym_let_expression,
  [sym__variable_name] = sym__variable_name,
  [sym__literal] = sym__literal,
  [sym_boolean] = sym_boolean,
  [sym_function] = sym_function,
  [sym_range] = sym_range,
  [sym_list] = sym_list,
  [sym__list_cell] = sym__list_cell,
  [sym_each] = sym_each,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_for_clause] = sym_for_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_function_call] = sym_function_call,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_parameters_declaration_repeat1] = aux_sym_parameters_declaration_repeat1,
  [aux_sym_union_block_repeat1] = aux_sym_union_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parenthesized_assignments_repeat1] = aux_sym_parenthesized_assignments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_include_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intersection_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_special_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_union_block] = {
    .visible = true,
    .named = true,
  },
  [sym_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_transform_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_module_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_update_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_name] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_cell] = {
    .visible = false,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_end = 6,
  field_function = 7,
  field_increment = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_parameters = 13,
  field_right = 14,
  field_start = 15,
  field_update = 16,
  field_value = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_function] = "function",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 3},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 4},
  [10] = {.index = 20, .length = 2},
  [11] = {.index = 22, .length = 2},
  [12] = {.index = 24, .length = 3},
  [13] = {.index = 27, .length = 1},
  [14] = {.index = 28, .length = 3},
  [15] = {.index = 31, .length = 3},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 2},
  [18] = {.index = 38, .length = 3},
  [19] = {.index = 41, .length = 3},
  [20] = {.index = 44, .length = 3},
  [21] = {.index = 47, .length = 4},
  [22] = {.index = 51, .length = 4},
  [23] = {.index = 55, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_body, 2},
  [3] =
    {field_condition, 1},
    {field_consequence, 2},
  [5] =
    {field_left, 0},
    {field_right, 2},
  [7] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_name, 1},
    {field_parameters, 2},
  [14] =
    {field_body, 2},
    {field_parameters, 1},
  [16] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_index, 2},
    {field_value, 0},
  [22] =
    {field_end, 3},
    {field_start, 1},
  [24] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [27] =
    {field_condition, 2},
  [28] =
    {field_end, 5},
    {field_increment, 3},
    {field_start, 1},
  [31] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [34] =
    {field_condition, 2},
    {field_update, 4},
  [36] =
    {field_condition, 3},
    {field_initializer, 1},
  [38] =
    {field_condition, 2},
    {field_update, 4},
    {field_update, 5},
  [41] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
  [44] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
  [47] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
    {field_update, 6},
  [51] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
  [55] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '$') ADVANCE(13);
      if (lookahead == '%') ADVANCE(37);
      if (lookahead == '&') ADVANCE(6);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(28);
      if (lookahead == '*') ADVANCE(33);
      if (lookahead == '+') ADVANCE(50);
      if (lookahead == ',') ADVANCE(27);
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(48);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == ':') ADVANCE(45);
      if (lookahead == ';') ADVANCE(24);
      if (lookahead == '<') ADVANCE(55);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(56);
      if (lookahead == '?') ADVANCE(61);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '|') ADVANCE(11);
      if (lookahead == '}') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(3)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(34);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '$') ADVANCE(13);
      if (lookahead == '%') ADVANCE(37);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(28);
      if (lookahead == '*') ADVANCE(33);
      if (lookahead == '+') ADVANCE(50);
      if (lookahead == ',') ADVANCE(27);
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(12);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ';') ADVANCE(24);
      if (lookahead == '<') ADVANCE(10);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(41);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 6:
      if (lookahead == '&') ADVANCE(52);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(22);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '>') ADVANCE(25);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '|') ADVANCE(51);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 13:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 14:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(22);
      if (lookahead == '\r') ADVANCE(23);
      END_STATE();
    case 15:
      if (eof) ADVANCE(20);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 16:
      if (eof) ADVANCE(20);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(15)
      END_STATE();
    case 17:
      if (eof) ADVANCE(20);
      if (lookahead == '\n') SKIP(19)
      END_STATE();
    case 18:
      if (eof) ADVANCE(20);
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '\r') SKIP(17)
      END_STATE();
    case 19:
      if (eof) ADVANCE(20);
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '$') ADVANCE(13);
      if (lookahead == '%') ADVANCE(37);
      if (lookahead == '&') ADVANCE(6);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(28);
      if (lookahead == '*') ADVANCE(33);
      if (lookahead == '+') ADVANCE(50);
      if (lookahead == ',') ADVANCE(27);
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == ':') ADVANCE(45);
      if (lookahead == ';') ADVANCE(24);
      if (lookahead == '<') ADVANCE(55);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(56);
      if (lookahead == '?') ADVANCE(61);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') SKIP(18)
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '|') ADVANCE(11);
      if (lookahead == '}') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(22);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(22);
      if (lookahead == '\\') ADVANCE(14);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_include_path);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(53);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(54);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_special_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(57);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(58);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(22);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 't') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == 's') ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(14);
      if (lookahead == 'o') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(18);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(19);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 8:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 14:
      if (lookahead == 'l') ADVANCE(26);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(29);
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 19:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 20:
      if (lookahead == 'd') ADVANCE(32);
      END_STATE();
    case 21:
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 23:
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(36);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(38);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(39);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 35:
      if (lookahead == 'g') ADVANCE(44);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 40:
      if (lookahead == 'u') ADVANCE(47);
      END_STATE();
    case 41:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 47:
      if (lookahead == 'd') ADVANCE(52);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 57:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == '_') ADVANCE(64);
      END_STATE();
    case 64:
      if (lookahead == 'f') ADVANCE(65);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_intersection_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 19},
  [4] = {.lex_state = 19},
  [5] = {.lex_state = 19},
  [6] = {.lex_state = 19},
  [7] = {.lex_state = 19},
  [8] = {.lex_state = 19},
  [9] = {.lex_state = 19},
  [10] = {.lex_state = 19},
  [11] = {.lex_state = 19},
  [12] = {.lex_state = 19},
  [13] = {.lex_state = 19},
  [14] = {.lex_state = 19},
  [15] = {.lex_state = 19},
  [16] = {.lex_state = 19},
  [17] = {.lex_state = 19},
  [18] = {.lex_state = 19},
  [19] = {.lex_state = 19},
  [20] = {.lex_state = 19},
  [21] = {.lex_state = 19},
  [22] = {.lex_state = 19},
  [23] = {.lex_state = 19},
  [24] = {.lex_state = 19},
  [25] = {.lex_state = 19},
  [26] = {.lex_state = 19},
  [27] = {.lex_state = 19},
  [28] = {.lex_state = 19},
  [29] = {.lex_state = 19},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 3},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 3},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 3},
  [37] = {.lex_state = 19},
  [38] = {.lex_state = 19},
  [39] = {.lex_state = 19},
  [40] = {.lex_state = 19},
  [41] = {.lex_state = 19},
  [42] = {.lex_state = 19},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 19},
  [45] = {.lex_state = 19},
  [46] = {.lex_state = 19},
  [47] = {.lex_state = 19},
  [48] = {.lex_state = 19},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 19},
  [51] = {.lex_state = 19},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 19},
  [54] = {.lex_state = 19},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 19},
  [58] = {.lex_state = 19},
  [59] = {.lex_state = 19},
  [60] = {.lex_state = 19},
  [61] = {.lex_state = 19},
  [62] = {.lex_state = 19},
  [63] = {.lex_state = 19},
  [64] = {.lex_state = 19},
  [65] = {.lex_state = 19},
  [66] = {.lex_state = 19},
  [67] = {.lex_state = 19},
  [68] = {.lex_state = 19},
  [69] = {.lex_state = 19},
  [70] = {.lex_state = 19},
  [71] = {.lex_state = 19},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 3},
  [76] = {.lex_state = 3},
  [77] = {.lex_state = 3},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 3},
  [82] = {.lex_state = 3},
  [83] = {.lex_state = 3},
  [84] = {.lex_state = 3},
  [85] = {.lex_state = 3},
  [86] = {.lex_state = 3},
  [87] = {.lex_state = 3},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 3},
  [101] = {.lex_state = 3},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 3},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 3},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 3},
  [110] = {.lex_state = 3},
  [111] = {.lex_state = 3},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 3},
  [115] = {.lex_state = 3},
  [116] = {.lex_state = 3},
  [117] = {.lex_state = 3},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 3},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 19},
  [135] = {.lex_state = 19},
  [136] = {.lex_state = 19},
  [137] = {.lex_state = 19},
  [138] = {.lex_state = 19},
  [139] = {.lex_state = 19},
  [140] = {.lex_state = 19},
  [141] = {.lex_state = 19},
  [142] = {.lex_state = 19},
  [143] = {.lex_state = 19},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 19},
  [147] = {.lex_state = 19},
  [148] = {.lex_state = 19},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 19},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 19},
  [153] = {.lex_state = 19},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 19},
  [157] = {.lex_state = 19},
  [158] = {.lex_state = 19},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 19},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 19},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 3},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 3},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_intersection_for] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_special_variable] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(250),
    [sym_include_statement] = STATE(32),
    [sym__item] = STATE(32),
    [sym_module_declaration] = STATE(32),
    [sym_function_declaration] = STATE(32),
    [sym__statement] = STATE(32),
    [sym_assignment] = STATE(252),
    [sym_union_block] = STATE(32),
    [sym_for_block] = STATE(32),
    [sym_intersection_for_block] = STATE(32),
    [sym_let_block] = STATE(32),
    [sym_assign_block] = STATE(32),
    [sym_if_block] = STATE(32),
    [sym_modifier_chain] = STATE(32),
    [sym_modifier] = STATE(131),
    [sym_transform_chain] = STATE(32),
    [sym_module_call] = STATE(121),
    [sym__variable_name] = STATE(241),
    [aux_sym_source_file_repeat1] = STATE(32),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_use] = ACTIONS(9),
    [anon_sym_include] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_module] = ACTIONS(13),
    [anon_sym_function] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(19),
    [anon_sym_intersection_for] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_assign] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(29),
    [anon_sym_PERCENT] = ACTIONS(29),
    [sym_special_variable] = ACTIONS(31),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 17,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(35), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [50] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(37), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(39), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [110] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(55), 9,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(53), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
  [184] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(73), 9,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(71), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
  [258] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(51), 1,
      anon_sym_CARET,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(75), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(77), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [314] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(37), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(39), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [368] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(75), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(77), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [428] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(75), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(77), 11,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [498] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(75), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(77), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [566] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(75), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(77), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [632] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(75), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(77), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [694] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(75), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(77), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [748] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(81), 9,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(79), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
  [822] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(85), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(89), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(93), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(97), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1047] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1092] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(109), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(113), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(117), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(121), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(129), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1362] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(133), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1452] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1497] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(147), 1,
      anon_sym_COMMA,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_RBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    STATE(31), 1,
      sym_for_clause,
    STATE(135), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(219), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1575] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(171), 1,
      anon_sym_if,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(197), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1651] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(173), 1,
      ts_builtin_sym_end,
    ACTIONS(175), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    STATE(241), 1,
      sym__variable_name,
    STATE(252), 1,
      sym_assignment,
    ACTIONS(9), 2,
      anon_sym_use,
      anon_sym_include,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(35), 14,
      sym_include_statement,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1729] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(171), 1,
      anon_sym_if,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(194), 4,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
      sym_if_clause,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1805] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(177), 1,
      anon_sym_COMMA,
    ACTIONS(179), 1,
      anon_sym_RBRACK,
    STATE(31), 1,
      sym_for_clause,
    STATE(137), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(212), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1883] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      ts_builtin_sym_end,
    ACTIONS(183), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_SEMI,
    ACTIONS(192), 1,
      anon_sym_module,
    ACTIONS(195), 1,
      anon_sym_function,
    ACTIONS(198), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_for,
    ACTIONS(204), 1,
      anon_sym_intersection_for,
    ACTIONS(207), 1,
      anon_sym_let,
    ACTIONS(210), 1,
      anon_sym_assign,
    ACTIONS(213), 1,
      anon_sym_if,
    ACTIONS(219), 1,
      sym_special_variable,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    STATE(241), 1,
      sym__variable_name,
    STATE(252), 1,
      sym_assignment,
    ACTIONS(186), 2,
      anon_sym_use,
      anon_sym_include,
    ACTIONS(216), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(35), 14,
      sym_include_statement,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1961] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(222), 1,
      anon_sym_RBRACK,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(224), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2036] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    ACTIONS(252), 1,
      anon_sym_QMARK,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(224), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(226), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2107] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(37), 13,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(39), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2164] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(77), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(75), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2229] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(77), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
    ACTIONS(75), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2292] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(77), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(75), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2359] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(75), 13,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(77), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2416] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(254), 1,
      anon_sym_RBRACK,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(224), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2491] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(77), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
    ACTIONS(75), 13,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
  [2550] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(250), 1,
      anon_sym_CARET,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(75), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(77), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2603] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(75), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(77), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2654] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    ACTIONS(252), 1,
      anon_sym_QMARK,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(55), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(53), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2725] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    ACTIONS(252), 1,
      anon_sym_QMARK,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(81), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(79), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2796] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(256), 1,
      anon_sym_RBRACK,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(224), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2871] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    ACTIONS(238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(248), 1,
      anon_sym_SLASH,
    ACTIONS(250), 1,
      anon_sym_CARET,
    ACTIONS(252), 1,
      anon_sym_QMARK,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(230), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(244), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(246), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(73), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(71), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2942] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(228), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_DOT,
    STATE(68), 1,
      sym_arguments,
    ACTIONS(37), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(39), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2993] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    ACTIONS(258), 1,
      anon_sym_RBRACK,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(224), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [3068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(133), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3152] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(218), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [3224] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(151), 1,
      anon_sym_for,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      anon_sym_each,
    STATE(31), 1,
      sym_for_clause,
    STATE(139), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(224), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [3296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(93), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(97), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3380] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(101), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(105), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(109), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3506] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(113), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3590] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(129), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(89), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(121), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(85), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(35), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 14,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(117), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3884] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(224), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(226), 9,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3953] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      sym_identifier,
    ACTIONS(263), 1,
      anon_sym_SEMI,
    ACTIONS(266), 1,
      anon_sym_module,
    ACTIONS(269), 1,
      anon_sym_function,
    ACTIONS(272), 1,
      anon_sym_LBRACE,
    ACTIONS(275), 1,
      anon_sym_RBRACE,
    ACTIONS(277), 1,
      anon_sym_for,
    ACTIONS(280), 1,
      anon_sym_intersection_for,
    ACTIONS(283), 1,
      anon_sym_let,
    ACTIONS(286), 1,
      anon_sym_assign,
    ACTIONS(289), 1,
      anon_sym_if,
    ACTIONS(295), 1,
      sym_special_variable,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    STATE(241), 1,
      sym__variable_name,
    STATE(252), 1,
      sym_assignment,
    ACTIONS(292), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(72), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4026] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(298), 1,
      anon_sym_SEMI,
    ACTIONS(300), 1,
      anon_sym_function,
    ACTIONS(302), 1,
      anon_sym_RBRACE,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    STATE(241), 1,
      sym__variable_name,
    STATE(252), 1,
      sym_assignment,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(72), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4099] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      sym_special_variable,
    ACTIONS(300), 1,
      anon_sym_function,
    ACTIONS(304), 1,
      anon_sym_SEMI,
    ACTIONS(306), 1,
      anon_sym_RBRACE,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    STATE(241), 1,
      sym__variable_name,
    STATE(252), 1,
      sym_assignment,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(73), 13,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [4172] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(308), 1,
      sym_identifier,
    ACTIONS(310), 1,
      anon_sym_RPAREN,
    ACTIONS(312), 1,
      sym_special_variable,
    STATE(136), 1,
      sym__expression,
    STATE(142), 1,
      sym__variable_name,
    STATE(217), 1,
      sym_assignment,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4238] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(308), 1,
      sym_identifier,
    ACTIONS(312), 1,
      sym_special_variable,
    ACTIONS(314), 1,
      anon_sym_RPAREN,
    STATE(134), 1,
      sym__expression,
    STATE(142), 1,
      sym__variable_name,
    STATE(216), 1,
      sym_assignment,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4304] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(308), 1,
      sym_identifier,
    ACTIONS(312), 1,
      sym_special_variable,
    STATE(140), 1,
      sym__expression,
    STATE(142), 1,
      sym__variable_name,
    STATE(239), 1,
      sym_assignment,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4367] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(162), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4425] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(7), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4483] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(3), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4541] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(156), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4599] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(14), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4657] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(157), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4715] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(148), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4773] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(141), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4831] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(152), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4889] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(37), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [4947] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(153), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5005] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(164), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5063] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(158), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5121] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(5), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5179] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5237] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(51), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5295] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(147), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5353] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(138), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5411] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(38), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5469] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(45), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5527] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(6), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5585] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(150), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5643] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(48), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5701] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(8), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5759] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(9), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5817] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(10), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5875] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(11), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5933] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(12), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5991] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(13), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6049] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(146), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6107] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6165] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(50), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6223] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(47), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6281] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(46), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6339] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(44), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6397] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(40), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6455] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(39), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6513] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(41), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6571] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(316), 1,
      sym_identifier,
    ACTIONS(318), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_function,
    ACTIONS(322), 1,
      anon_sym_let,
    ACTIONS(324), 1,
      anon_sym_BANG,
    ACTIONS(326), 1,
      sym_special_variable,
    ACTIONS(332), 1,
      anon_sym_LBRACK,
    STATE(42), 1,
      sym__expression,
    ACTIONS(328), 2,
      sym_string,
      sym_number,
    ACTIONS(330), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(63), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(53), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6629] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      sym_identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    ACTIONS(149), 1,
      anon_sym_function,
    ACTIONS(153), 1,
      anon_sym_let,
    ACTIONS(155), 1,
      anon_sym_BANG,
    ACTIONS(157), 1,
      sym_special_variable,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    STATE(143), 1,
      sym__expression,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(161), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(169), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(27), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(336), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(338), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [6718] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(342), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(151), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [6769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 10,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(346), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [6800] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(348), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(160), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [6851] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(145), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [6902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(352), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(354), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [6933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(356), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(358), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [6964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 10,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(362), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [6995] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(155), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [7046] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(366), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(166), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [7097] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(368), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(161), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [7148] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(370), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(154), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [7199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(374), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [7230] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(376), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(144), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [7281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 10,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(380), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [7312] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_for,
    ACTIONS(21), 1,
      anon_sym_intersection_for,
    ACTIONS(23), 1,
      anon_sym_let,
    ACTIONS(25), 1,
      anon_sym_assign,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(340), 1,
      sym_identifier,
    ACTIONS(382), 1,
      anon_sym_SEMI,
    STATE(121), 1,
      sym_module_call,
    STATE(131), 1,
      sym_modifier,
    ACTIONS(29), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(149), 9,
      sym__statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [7363] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(386), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      sym_arguments,
    STATE(210), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7423] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(390), 1,
      anon_sym_COLON,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(388), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [7481] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(392), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      sym_arguments,
    STATE(222), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7541] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(394), 1,
      anon_sym_COLON,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(388), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [7599] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(396), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7655] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(388), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [7711] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(398), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7766] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(400), 1,
      anon_sym_COLON,
    ACTIONS(402), 1,
      anon_sym_RBRACK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7823] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      anon_sym_EQ,
    ACTIONS(131), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(133), 17,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7854] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(406), 1,
      anon_sym_COLON,
    ACTIONS(408), 1,
      anon_sym_RBRACK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(412), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [7939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(416), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [7967] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(418), 1,
      anon_sym_COLON,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8021] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(420), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8075] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(422), 1,
      anon_sym_RBRACK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(426), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8157] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(428), 1,
      anon_sym_RBRACK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(432), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8239] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(434), 1,
      anon_sym_COLON,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8293] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(436), 1,
      anon_sym_RBRACK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8347] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(440), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(444), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8403] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(446), 1,
      anon_sym_SEMI,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8457] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(448), 1,
      anon_sym_SEMI,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8511] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(450), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(452), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(454), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(458), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8621] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_else,
    ACTIONS(460), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(462), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [8651] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(466), 1,
      anon_sym_RBRACK,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(470), 11,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [8733] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_SLASH,
    ACTIONS(51), 1,
      anon_sym_CARET,
    ACTIONS(59), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(61), 1,
      anon_sym_AMP_AMP,
    ACTIONS(69), 1,
      anon_sym_QMARK,
    ACTIONS(472), 1,
      anon_sym_SEMI,
    STATE(15), 1,
      sym_arguments,
    ACTIONS(43), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(57), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(63), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(65), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(67), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(476), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [8814] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(480), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [8841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(484), 10,
      anon_sym_use,
      anon_sym_include,
      anon_sym_module,
      anon_sym_function,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [8867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(488), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [8891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(492), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [8915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(496), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [8939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(500), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [8963] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(504), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [8987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(508), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [9011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(512), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [9035] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(516), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [9059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(520), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [9083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 8,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_each,
    ACTIONS(524), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [9107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 6,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
    ACTIONS(528), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
  [9127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 6,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
    ACTIONS(532), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
  [9147] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(534), 1,
      anon_sym_function,
    STATE(201), 1,
      sym__literal,
    ACTIONS(159), 2,
      sym_string,
      sym_number,
    ACTIONS(536), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(28), 4,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [9174] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(540), 1,
      anon_sym_COMMA,
    ACTIONS(542), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym__variable_name,
    ACTIONS(538), 2,
      sym_identifier,
      sym_special_variable,
    STATE(196), 2,
      sym__parameter_declaration,
      sym_assignment,
  [9195] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(544), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym__variable_name,
    ACTIONS(538), 2,
      sym_identifier,
      sym_special_variable,
    STATE(238), 2,
      sym__parameter_declaration,
      sym_assignment,
  [9213] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    STATE(198), 1,
      sym__variable_name,
    ACTIONS(538), 2,
      sym_identifier,
      sym_special_variable,
    STATE(238), 2,
      sym__parameter_declaration,
      sym_assignment,
  [9231] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      anon_sym_SEMI,
    ACTIONS(550), 1,
      anon_sym_RPAREN,
    STATE(190), 1,
      sym_assignment,
    STATE(241), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [9251] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(552), 1,
      anon_sym_RPAREN,
    STATE(215), 1,
      sym_assignment,
    STATE(241), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [9268] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(554), 1,
      anon_sym_RPAREN,
    STATE(206), 1,
      sym_assignment,
    STATE(241), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [9285] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_RPAREN,
    STATE(208), 1,
      sym_assignment,
    STATE(241), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [9302] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 1,
      anon_sym_RPAREN,
    STATE(213), 1,
      sym_assignment,
    STATE(241), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [9319] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(198), 1,
      sym__variable_name,
    ACTIONS(538), 2,
      sym_identifier,
      sym_special_variable,
    STATE(238), 2,
      sym__parameter_declaration,
      sym_assignment,
  [9334] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 1,
      anon_sym_SEMI,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    STATE(193), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9350] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(205), 1,
      sym_assignment,
    STATE(241), 1,
      sym__variable_name,
    ACTIONS(31), 2,
      sym_identifier,
      sym_special_variable,
  [9364] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(566), 1,
      anon_sym_COMMA,
    STATE(192), 1,
      aux_sym_parenthesized_assignments_repeat1,
    ACTIONS(564), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [9378] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(569), 1,
      anon_sym_SEMI,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(192), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [9403] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 1,
      anon_sym_RBRACK,
    ACTIONS(575), 1,
      anon_sym_COMMA,
    STATE(204), 1,
      aux_sym_list_repeat1,
  [9416] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 1,
      anon_sym_COMMA,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      aux_sym_parameters_declaration_repeat1,
  [9429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [9438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      anon_sym_EQ,
    ACTIONS(583), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_RPAREN,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    STATE(199), 1,
      aux_sym_arguments_repeat1,
  [9462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_RBRACK,
    ACTIONS(590), 1,
      anon_sym_COMMA,
    STATE(204), 1,
      aux_sym_list_repeat1,
  [9475] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 3,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_RBRACK,
  [9484] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(192), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    STATE(175), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [9508] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_COMMA,
    ACTIONS(599), 1,
      anon_sym_RBRACK,
    STATE(204), 1,
      aux_sym_list_repeat1,
  [9521] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(564), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9530] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(601), 1,
      anon_sym_RPAREN,
    STATE(220), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9543] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(603), 1,
      anon_sym_RPAREN,
    STATE(192), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9556] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(605), 1,
      anon_sym_RPAREN,
    STATE(207), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9569] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    ACTIONS(607), 1,
      anon_sym_COMMA,
    STATE(221), 1,
      aux_sym_parameters_declaration_repeat1,
  [9582] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(609), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_arguments_repeat1,
  [9595] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(611), 1,
      anon_sym_RPAREN,
    STATE(192), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9608] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_RBRACK,
    STATE(195), 1,
      aux_sym_list_repeat1,
  [9621] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    STATE(202), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9634] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(617), 1,
      anon_sym_EQ,
    STATE(178), 1,
      sym_arguments,
  [9647] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(619), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9660] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(386), 1,
      anon_sym_RPAREN,
    STATE(210), 1,
      aux_sym_arguments_repeat1,
  [9673] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(392), 1,
      anon_sym_RPAREN,
    STATE(222), 1,
      aux_sym_arguments_repeat1,
  [9686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_else,
    ACTIONS(621), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9697] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(627), 1,
      anon_sym_RBRACK,
    STATE(200), 1,
      aux_sym_list_repeat1,
  [9710] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      anon_sym_RPAREN,
    STATE(192), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [9723] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 1,
      anon_sym_COMMA,
    ACTIONS(634), 1,
      anon_sym_RPAREN,
    STATE(221), 1,
      aux_sym_parameters_declaration_repeat1,
  [9736] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_COMMA,
    ACTIONS(636), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      aux_sym_arguments_repeat1,
  [9749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    STATE(240), 1,
      sym_parameters_declaration,
  [9759] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    STATE(127), 1,
      sym_parameters_declaration,
  [9777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    STATE(129), 1,
      sym_parenthesized_assignments,
  [9787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    STATE(247), 1,
      sym_parameters_declaration,
  [9797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    STATE(119), 1,
      sym_parenthesized_assignments,
  [9807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    STATE(92), 1,
      sym_parenthesized_assignments,
  [9817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_parameters_declaration,
  [9827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    STATE(110), 1,
      sym_parenthesized_assignments,
  [9837] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    STATE(122), 1,
      sym_parenthesized_assignments,
  [9847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    STATE(133), 1,
      sym_parenthesized_assignments,
  [9857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(128), 1,
      sym_parenthesized_expression,
  [9867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(178), 1,
      sym_arguments,
  [9877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_parenthesized_expression,
  [9887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    STATE(91), 1,
      sym_parameters_declaration,
  [9897] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 1,
      anon_sym_EQ,
  [9920] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      anon_sym_EQ,
  [9927] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
  [9934] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(644), 1,
      anon_sym_SEMI,
  [9941] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(646), 1,
      sym_include_path,
  [9948] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(648), 1,
      sym_identifier,
  [9955] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 1,
      sym_identifier,
  [9962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(652), 1,
      anon_sym_EQ,
  [9969] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_RBRACK,
  [9976] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      sym_identifier,
  [9983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(656), 1,
      ts_builtin_sym_end,
  [9990] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      sym_identifier,
  [9997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_SEMI,
  [10004] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 1,
      sym_identifier,
  [10011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      anon_sym_RBRACK,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 50,
  [SMALL_STATE(4)] = 110,
  [SMALL_STATE(5)] = 184,
  [SMALL_STATE(6)] = 258,
  [SMALL_STATE(7)] = 314,
  [SMALL_STATE(8)] = 368,
  [SMALL_STATE(9)] = 428,
  [SMALL_STATE(10)] = 498,
  [SMALL_STATE(11)] = 566,
  [SMALL_STATE(12)] = 632,
  [SMALL_STATE(13)] = 694,
  [SMALL_STATE(14)] = 748,
  [SMALL_STATE(15)] = 822,
  [SMALL_STATE(16)] = 867,
  [SMALL_STATE(17)] = 912,
  [SMALL_STATE(18)] = 957,
  [SMALL_STATE(19)] = 1002,
  [SMALL_STATE(20)] = 1047,
  [SMALL_STATE(21)] = 1092,
  [SMALL_STATE(22)] = 1137,
  [SMALL_STATE(23)] = 1182,
  [SMALL_STATE(24)] = 1227,
  [SMALL_STATE(25)] = 1272,
  [SMALL_STATE(26)] = 1317,
  [SMALL_STATE(27)] = 1362,
  [SMALL_STATE(28)] = 1407,
  [SMALL_STATE(29)] = 1452,
  [SMALL_STATE(30)] = 1497,
  [SMALL_STATE(31)] = 1575,
  [SMALL_STATE(32)] = 1651,
  [SMALL_STATE(33)] = 1729,
  [SMALL_STATE(34)] = 1805,
  [SMALL_STATE(35)] = 1883,
  [SMALL_STATE(36)] = 1961,
  [SMALL_STATE(37)] = 2036,
  [SMALL_STATE(38)] = 2107,
  [SMALL_STATE(39)] = 2164,
  [SMALL_STATE(40)] = 2229,
  [SMALL_STATE(41)] = 2292,
  [SMALL_STATE(42)] = 2359,
  [SMALL_STATE(43)] = 2416,
  [SMALL_STATE(44)] = 2491,
  [SMALL_STATE(45)] = 2550,
  [SMALL_STATE(46)] = 2603,
  [SMALL_STATE(47)] = 2654,
  [SMALL_STATE(48)] = 2725,
  [SMALL_STATE(49)] = 2796,
  [SMALL_STATE(50)] = 2871,
  [SMALL_STATE(51)] = 2942,
  [SMALL_STATE(52)] = 2993,
  [SMALL_STATE(53)] = 3068,
  [SMALL_STATE(54)] = 3110,
  [SMALL_STATE(55)] = 3152,
  [SMALL_STATE(56)] = 3224,
  [SMALL_STATE(57)] = 3296,
  [SMALL_STATE(58)] = 3338,
  [SMALL_STATE(59)] = 3380,
  [SMALL_STATE(60)] = 3422,
  [SMALL_STATE(61)] = 3464,
  [SMALL_STATE(62)] = 3506,
  [SMALL_STATE(63)] = 3548,
  [SMALL_STATE(64)] = 3590,
  [SMALL_STATE(65)] = 3632,
  [SMALL_STATE(66)] = 3674,
  [SMALL_STATE(67)] = 3716,
  [SMALL_STATE(68)] = 3758,
  [SMALL_STATE(69)] = 3800,
  [SMALL_STATE(70)] = 3842,
  [SMALL_STATE(71)] = 3884,
  [SMALL_STATE(72)] = 3953,
  [SMALL_STATE(73)] = 4026,
  [SMALL_STATE(74)] = 4099,
  [SMALL_STATE(75)] = 4172,
  [SMALL_STATE(76)] = 4238,
  [SMALL_STATE(77)] = 4304,
  [SMALL_STATE(78)] = 4367,
  [SMALL_STATE(79)] = 4425,
  [SMALL_STATE(80)] = 4483,
  [SMALL_STATE(81)] = 4541,
  [SMALL_STATE(82)] = 4599,
  [SMALL_STATE(83)] = 4657,
  [SMALL_STATE(84)] = 4715,
  [SMALL_STATE(85)] = 4773,
  [SMALL_STATE(86)] = 4831,
  [SMALL_STATE(87)] = 4889,
  [SMALL_STATE(88)] = 4947,
  [SMALL_STATE(89)] = 5005,
  [SMALL_STATE(90)] = 5063,
  [SMALL_STATE(91)] = 5121,
  [SMALL_STATE(92)] = 5179,
  [SMALL_STATE(93)] = 5237,
  [SMALL_STATE(94)] = 5295,
  [SMALL_STATE(95)] = 5353,
  [SMALL_STATE(96)] = 5411,
  [SMALL_STATE(97)] = 5469,
  [SMALL_STATE(98)] = 5527,
  [SMALL_STATE(99)] = 5585,
  [SMALL_STATE(100)] = 5643,
  [SMALL_STATE(101)] = 5701,
  [SMALL_STATE(102)] = 5759,
  [SMALL_STATE(103)] = 5817,
  [SMALL_STATE(104)] = 5875,
  [SMALL_STATE(105)] = 5933,
  [SMALL_STATE(106)] = 5991,
  [SMALL_STATE(107)] = 6049,
  [SMALL_STATE(108)] = 6107,
  [SMALL_STATE(109)] = 6165,
  [SMALL_STATE(110)] = 6223,
  [SMALL_STATE(111)] = 6281,
  [SMALL_STATE(112)] = 6339,
  [SMALL_STATE(113)] = 6397,
  [SMALL_STATE(114)] = 6455,
  [SMALL_STATE(115)] = 6513,
  [SMALL_STATE(116)] = 6571,
  [SMALL_STATE(117)] = 6629,
  [SMALL_STATE(118)] = 6687,
  [SMALL_STATE(119)] = 6718,
  [SMALL_STATE(120)] = 6769,
  [SMALL_STATE(121)] = 6800,
  [SMALL_STATE(122)] = 6851,
  [SMALL_STATE(123)] = 6902,
  [SMALL_STATE(124)] = 6933,
  [SMALL_STATE(125)] = 6964,
  [SMALL_STATE(126)] = 6995,
  [SMALL_STATE(127)] = 7046,
  [SMALL_STATE(128)] = 7097,
  [SMALL_STATE(129)] = 7148,
  [SMALL_STATE(130)] = 7199,
  [SMALL_STATE(131)] = 7230,
  [SMALL_STATE(132)] = 7281,
  [SMALL_STATE(133)] = 7312,
  [SMALL_STATE(134)] = 7363,
  [SMALL_STATE(135)] = 7423,
  [SMALL_STATE(136)] = 7481,
  [SMALL_STATE(137)] = 7541,
  [SMALL_STATE(138)] = 7599,
  [SMALL_STATE(139)] = 7655,
  [SMALL_STATE(140)] = 7711,
  [SMALL_STATE(141)] = 7766,
  [SMALL_STATE(142)] = 7823,
  [SMALL_STATE(143)] = 7854,
  [SMALL_STATE(144)] = 7911,
  [SMALL_STATE(145)] = 7939,
  [SMALL_STATE(146)] = 7967,
  [SMALL_STATE(147)] = 8021,
  [SMALL_STATE(148)] = 8075,
  [SMALL_STATE(149)] = 8129,
  [SMALL_STATE(150)] = 8157,
  [SMALL_STATE(151)] = 8211,
  [SMALL_STATE(152)] = 8239,
  [SMALL_STATE(153)] = 8293,
  [SMALL_STATE(154)] = 8347,
  [SMALL_STATE(155)] = 8375,
  [SMALL_STATE(156)] = 8403,
  [SMALL_STATE(157)] = 8457,
  [SMALL_STATE(158)] = 8511,
  [SMALL_STATE(159)] = 8565,
  [SMALL_STATE(160)] = 8593,
  [SMALL_STATE(161)] = 8621,
  [SMALL_STATE(162)] = 8651,
  [SMALL_STATE(163)] = 8705,
  [SMALL_STATE(164)] = 8733,
  [SMALL_STATE(165)] = 8787,
  [SMALL_STATE(166)] = 8814,
  [SMALL_STATE(167)] = 8841,
  [SMALL_STATE(168)] = 8867,
  [SMALL_STATE(169)] = 8891,
  [SMALL_STATE(170)] = 8915,
  [SMALL_STATE(171)] = 8939,
  [SMALL_STATE(172)] = 8963,
  [SMALL_STATE(173)] = 8987,
  [SMALL_STATE(174)] = 9011,
  [SMALL_STATE(175)] = 9035,
  [SMALL_STATE(176)] = 9059,
  [SMALL_STATE(177)] = 9083,
  [SMALL_STATE(178)] = 9107,
  [SMALL_STATE(179)] = 9127,
  [SMALL_STATE(180)] = 9147,
  [SMALL_STATE(181)] = 9174,
  [SMALL_STATE(182)] = 9195,
  [SMALL_STATE(183)] = 9213,
  [SMALL_STATE(184)] = 9231,
  [SMALL_STATE(185)] = 9251,
  [SMALL_STATE(186)] = 9268,
  [SMALL_STATE(187)] = 9285,
  [SMALL_STATE(188)] = 9302,
  [SMALL_STATE(189)] = 9319,
  [SMALL_STATE(190)] = 9334,
  [SMALL_STATE(191)] = 9350,
  [SMALL_STATE(192)] = 9364,
  [SMALL_STATE(193)] = 9378,
  [SMALL_STATE(194)] = 9394,
  [SMALL_STATE(195)] = 9403,
  [SMALL_STATE(196)] = 9416,
  [SMALL_STATE(197)] = 9429,
  [SMALL_STATE(198)] = 9438,
  [SMALL_STATE(199)] = 9449,
  [SMALL_STATE(200)] = 9462,
  [SMALL_STATE(201)] = 9475,
  [SMALL_STATE(202)] = 9484,
  [SMALL_STATE(203)] = 9497,
  [SMALL_STATE(204)] = 9508,
  [SMALL_STATE(205)] = 9521,
  [SMALL_STATE(206)] = 9530,
  [SMALL_STATE(207)] = 9543,
  [SMALL_STATE(208)] = 9556,
  [SMALL_STATE(209)] = 9569,
  [SMALL_STATE(210)] = 9582,
  [SMALL_STATE(211)] = 9595,
  [SMALL_STATE(212)] = 9608,
  [SMALL_STATE(213)] = 9621,
  [SMALL_STATE(214)] = 9634,
  [SMALL_STATE(215)] = 9647,
  [SMALL_STATE(216)] = 9660,
  [SMALL_STATE(217)] = 9673,
  [SMALL_STATE(218)] = 9686,
  [SMALL_STATE(219)] = 9697,
  [SMALL_STATE(220)] = 9710,
  [SMALL_STATE(221)] = 9723,
  [SMALL_STATE(222)] = 9736,
  [SMALL_STATE(223)] = 9749,
  [SMALL_STATE(224)] = 9759,
  [SMALL_STATE(225)] = 9767,
  [SMALL_STATE(226)] = 9777,
  [SMALL_STATE(227)] = 9787,
  [SMALL_STATE(228)] = 9797,
  [SMALL_STATE(229)] = 9807,
  [SMALL_STATE(230)] = 9817,
  [SMALL_STATE(231)] = 9827,
  [SMALL_STATE(232)] = 9837,
  [SMALL_STATE(233)] = 9847,
  [SMALL_STATE(234)] = 9857,
  [SMALL_STATE(235)] = 9867,
  [SMALL_STATE(236)] = 9877,
  [SMALL_STATE(237)] = 9887,
  [SMALL_STATE(238)] = 9897,
  [SMALL_STATE(239)] = 9905,
  [SMALL_STATE(240)] = 9913,
  [SMALL_STATE(241)] = 9920,
  [SMALL_STATE(242)] = 9927,
  [SMALL_STATE(243)] = 9934,
  [SMALL_STATE(244)] = 9941,
  [SMALL_STATE(245)] = 9948,
  [SMALL_STATE(246)] = 9955,
  [SMALL_STATE(247)] = 9962,
  [SMALL_STATE(248)] = 9969,
  [SMALL_STATE(249)] = 9976,
  [SMALL_STATE(250)] = 9983,
  [SMALL_STATE(251)] = 9990,
  [SMALL_STATE(252)] = 9997,
  [SMALL_STATE(253)] = 10004,
  [SMALL_STATE(254)] = 10011,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [33] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [35] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [37] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 3, .production_id = 8),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 3, .production_id = 8),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [87] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 7, .production_id = 14),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 7, .production_id = 14),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, .production_id = 11),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, .production_id = 11),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 4, .production_id = 10),
  [107] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [127] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(214),
  [186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(244),
  [189] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(35),
  [192] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(245),
  [195] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(249),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(74),
  [201] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(226),
  [204] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(228),
  [207] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(232),
  [210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(233),
  [213] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(234),
  [216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(179),
  [219] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(241),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [260] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(214),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(72),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(245),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(253),
  [272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(74),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(226),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(228),
  [283] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(232),
  [286] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(233),
  [289] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(234),
  [292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(179),
  [295] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(241),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [300] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [308] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [320] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [322] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 3),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 3),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 4),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 4),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 5),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 5),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 2),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 2),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 2),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 2),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 4),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 4),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 3),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 3),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_cell, 1),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 4),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier_chain, 2),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier_chain, 2),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [432] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 5, .production_id = 9),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 3),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 3),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 2),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 2),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 2),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 2),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 2),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__item, 2),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 3),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 3),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 5, .production_id = 13),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 5, .production_id = 13),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_clause, 2),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 2),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier, 1),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier, 1),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2),
  [566] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2), SHIFT_REPEAT(191),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 5, .production_id = 15),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_comprehension, 2),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_declaration, 1),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [587] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(77),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 2),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [596] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(56),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_name, 1),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 3),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [631] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2), SHIFT_REPEAT(189),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [656] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_openscad(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
