#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 236
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 126
#define ALIAS_COUNT 0
#define TOKEN_COUNT 67
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 50

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_return = 3,
  anon_sym_SEMI = 4,
  anon_sym_EQ = 5,
  anon_sym_COMMA = 6,
  anon_sym_COLON_COLON = 7,
  sym_break_statement = 8,
  anon_sym_goto = 9,
  anon_sym_do = 10,
  anon_sym_end = 11,
  anon_sym_while = 12,
  anon_sym_repeat = 13,
  anon_sym_until = 14,
  anon_sym_if = 15,
  anon_sym_then = 16,
  anon_sym_elseif = 17,
  anon_sym_else = 18,
  anon_sym_for = 19,
  anon_sym_in = 20,
  anon_sym_function = 21,
  anon_sym_local = 22,
  anon_sym_DOT = 23,
  anon_sym_COLON = 24,
  sym_nil = 25,
  sym_false = 26,
  sym_true = 27,
  sym_number = 28,
  sym_vararg_expression = 29,
  anon_sym_LPAREN = 30,
  anon_sym_RPAREN = 31,
  anon_sym_LBRACK = 32,
  anon_sym_RBRACK = 33,
  anon_sym_LBRACE = 34,
  anon_sym_RBRACE = 35,
  anon_sym_or = 36,
  anon_sym_and = 37,
  anon_sym_LT = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_TILDE_EQ = 41,
  anon_sym_GT_EQ = 42,
  anon_sym_GT = 43,
  anon_sym_PIPE = 44,
  anon_sym_TILDE = 45,
  anon_sym_AMP = 46,
  anon_sym_LT_LT = 47,
  anon_sym_GT_GT = 48,
  anon_sym_PLUS = 49,
  anon_sym_DASH = 50,
  anon_sym_STAR = 51,
  anon_sym_SLASH = 52,
  anon_sym_SLASH_SLASH = 53,
  anon_sym_PERCENT = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_CARET = 56,
  anon_sym_not = 57,
  anon_sym_POUND = 58,
  sym__line_comment_start = 59,
  sym__line_comment_start_only = 60,
  sym__block_comment_start = 61,
  sym__block_comment_end = 62,
  sym__comment_content = 63,
  sym__string_start = 64,
  sym__string_content = 65,
  sym__string_end = 66,
  sym_chunk = 67,
  sym__block = 68,
  sym_statement = 69,
  sym_return_statement = 70,
  sym_empty_statement = 71,
  sym_assignment_statement = 72,
  sym__variable_assignment_varlist = 73,
  sym__variable_assignment_explist = 74,
  sym_label_statement = 75,
  sym_goto_statement = 76,
  sym_do_statement = 77,
  sym_while_statement = 78,
  sym_repeat_statement = 79,
  sym_if_statement = 80,
  sym_elseif_statement = 81,
  sym_else_statement = 82,
  sym_for_statement = 83,
  sym_for_generic_clause = 84,
  sym_for_numeric_clause = 85,
  sym_declaration = 86,
  sym_function_declaration = 87,
  sym__local_function_declaration = 88,
  sym__function_name = 89,
  sym__function_name_prefix_expression = 90,
  sym__function_name_dot_index_expression = 91,
  sym__function_name_method_index_expression = 92,
  sym_variable_declaration = 93,
  sym__local_variable_assignment = 94,
  sym__variable_declaration_namelist = 95,
  sym__expression_list = 96,
  sym_expression = 97,
  sym_string = 98,
  sym_function_definition = 99,
  sym__function_body = 100,
  sym_parameters = 101,
  sym__parameter_list = 102,
  sym__prefix_expression = 103,
  sym_variable = 104,
  sym_bracket_index_expression = 105,
  sym_dot_index_expression = 106,
  sym_function_call = 107,
  sym_method_index_expression = 108,
  sym_arguments = 109,
  sym_parenthesized_expression = 110,
  sym_table_constructor = 111,
  sym__field_list = 112,
  sym__field_sep = 113,
  sym_field = 114,
  sym_binary_expression = 115,
  sym_unary_expression = 116,
  sym_comment = 117,
  aux_sym_chunk_repeat1 = 118,
  aux_sym__variable_assignment_varlist_repeat1 = 119,
  aux_sym__variable_assignment_explist_repeat1 = 120,
  aux_sym_if_statement_repeat1 = 121,
  aux_sym__variable_declaration_namelist_repeat1 = 122,
  aux_sym__expression_list_repeat1 = 123,
  aux_sym__parameter_list_repeat1 = 124,
  aux_sym__field_list_repeat1 = 125,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_return] = "return",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON_COLON] = "::",
  [sym_break_statement] = "break_statement",
  [anon_sym_goto] = "goto",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_function] = "function",
  [anon_sym_local] = "local",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON] = ":",
  [sym_nil] = "nil",
  [sym_false] = "false",
  [sym_true] = "true",
  [sym_number] = "number",
  [sym_vararg_expression] = "vararg_expression",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [sym__line_comment_start] = "comment_start",
  [sym__line_comment_start_only] = "comment_start",
  [sym__block_comment_start] = "comment_start",
  [sym__block_comment_end] = "comment_end",
  [sym__comment_content] = "comment_content",
  [sym__string_start] = "string_start",
  [sym__string_content] = "string_content",
  [sym__string_end] = "string_end",
  [sym_chunk] = "chunk",
  [sym__block] = "block",
  [sym_statement] = "statement",
  [sym_return_statement] = "return_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym__variable_assignment_varlist] = "variable_list",
  [sym__variable_assignment_explist] = "expression_list",
  [sym_label_statement] = "label_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_do_statement] = "do_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_generic_clause] = "for_generic_clause",
  [sym_for_numeric_clause] = "for_numeric_clause",
  [sym_declaration] = "declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__function_name] = "_function_name",
  [sym__function_name_prefix_expression] = "_function_name_prefix_expression",
  [sym__function_name_dot_index_expression] = "dot_index_expression",
  [sym__function_name_method_index_expression] = "method_index_expression",
  [sym_variable_declaration] = "variable_declaration",
  [sym__local_variable_assignment] = "assignment_statement",
  [sym__variable_declaration_namelist] = "variable_list",
  [sym__expression_list] = "_expression_list",
  [sym_expression] = "expression",
  [sym_string] = "string",
  [sym_function_definition] = "function_definition",
  [sym__function_body] = "_function_body",
  [sym_parameters] = "parameters",
  [sym__parameter_list] = "_parameter_list",
  [sym__prefix_expression] = "_prefix_expression",
  [sym_variable] = "variable",
  [sym_bracket_index_expression] = "bracket_index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_function_call] = "function_call",
  [sym_method_index_expression] = "method_index_expression",
  [sym_arguments] = "arguments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_table_constructor] = "table_constructor",
  [sym__field_list] = "_field_list",
  [sym__field_sep] = "_field_sep",
  [sym_field] = "field",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_comment] = "comment",
  [aux_sym_chunk_repeat1] = "chunk_repeat1",
  [aux_sym__variable_assignment_varlist_repeat1] = "_variable_assignment_varlist_repeat1",
  [aux_sym__variable_assignment_explist_repeat1] = "_variable_assignment_explist_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym__variable_declaration_namelist_repeat1] = "_variable_declaration_namelist_repeat1",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym__parameter_list_repeat1] = "_parameter_list_repeat1",
  [aux_sym__field_list_repeat1] = "_field_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_nil] = sym_nil,
  [sym_false] = sym_false,
  [sym_true] = sym_true,
  [sym_number] = sym_number,
  [sym_vararg_expression] = sym_vararg_expression,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym__line_comment_start] = sym__line_comment_start,
  [sym__line_comment_start_only] = sym__line_comment_start,
  [sym__block_comment_start] = sym__line_comment_start,
  [sym__block_comment_end] = sym__block_comment_end,
  [sym__comment_content] = sym__comment_content,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_end,
  [sym_chunk] = sym_chunk,
  [sym__block] = sym__block,
  [sym_statement] = sym_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym__variable_assignment_varlist] = sym__variable_assignment_varlist,
  [sym__variable_assignment_explist] = sym__variable_assignment_explist,
  [sym_label_statement] = sym_label_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_generic_clause] = sym_for_generic_clause,
  [sym_for_numeric_clause] = sym_for_numeric_clause,
  [sym_declaration] = sym_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__function_name] = sym__function_name,
  [sym__function_name_prefix_expression] = sym__function_name_prefix_expression,
  [sym__function_name_dot_index_expression] = sym_dot_index_expression,
  [sym__function_name_method_index_expression] = sym_method_index_expression,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym__local_variable_assignment] = sym_assignment_statement,
  [sym__variable_declaration_namelist] = sym__variable_assignment_varlist,
  [sym__expression_list] = sym__expression_list,
  [sym_expression] = sym_expression,
  [sym_string] = sym_string,
  [sym_function_definition] = sym_function_definition,
  [sym__function_body] = sym__function_body,
  [sym_parameters] = sym_parameters,
  [sym__parameter_list] = sym__parameter_list,
  [sym__prefix_expression] = sym__prefix_expression,
  [sym_variable] = sym_variable,
  [sym_bracket_index_expression] = sym_bracket_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_function_call] = sym_function_call,
  [sym_method_index_expression] = sym_method_index_expression,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_table_constructor] = sym_table_constructor,
  [sym__field_list] = sym__field_list,
  [sym__field_sep] = sym__field_sep,
  [sym_field] = sym_field,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_comment] = sym_comment,
  [aux_sym_chunk_repeat1] = aux_sym_chunk_repeat1,
  [aux_sym__variable_assignment_varlist_repeat1] = aux_sym__variable_assignment_varlist_repeat1,
  [aux_sym__variable_assignment_explist_repeat1] = aux_sym__variable_assignment_explist_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym__variable_declaration_namelist_repeat1] = aux_sym__variable_declaration_namelist_repeat1,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym__parameter_list_repeat1] = aux_sym__parameter_list_repeat1,
  [aux_sym__field_list_repeat1] = aux_sym__field_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_vararg_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym__line_comment_start] = {
    .visible = true,
    .named = false,
  },
  [sym__line_comment_start_only] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_start] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_end] = {
    .visible = true,
    .named = false,
  },
  [sym__comment_content] = {
    .visible = true,
    .named = false,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = true,
    .named = false,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_varlist] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_explist] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_generic_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_numeric_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declaration_namelist] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_bracket_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym__field_list] = {
    .visible = false,
    .named = true,
  },
  [sym__field_sep] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_chunk_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_varlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_explist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declaration_namelist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_clause = 4,
  field_condition = 5,
  field_consequence = 6,
  field_content = 7,
  field_end = 8,
  field_field = 9,
  field_left = 10,
  field_local_declaration = 11,
  field_method = 12,
  field_name = 13,
  field_operand = 14,
  field_parameters = 15,
  field_right = 16,
  field_start = 17,
  field_step = 18,
  field_table = 19,
  field_value = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_clause] = "clause",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_end] = "end",
  [field_field] = "field",
  [field_left] = "left",
  [field_local_declaration] = "local_declaration",
  [field_method] = "method",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_step] = "step",
  [field_table] = "table",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 4},
  [4] = {.index = 6, .length = 1},
  [5] = {.index = 7, .length = 1},
  [6] = {.index = 8, .length = 2},
  [7] = {.index = 10, .length = 2},
  [8] = {.index = 12, .length = 2},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 1},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 3},
  [14] = {.index = 24, .length = 2},
  [15] = {.index = 26, .length = 1},
  [16] = {.index = 27, .length = 1},
  [17] = {.index = 28, .length = 1},
  [18] = {.index = 29, .length = 1},
  [19] = {.index = 30, .length = 3},
  [20] = {.index = 33, .length = 2},
  [21] = {.index = 35, .length = 2},
  [22] = {.index = 37, .length = 2},
  [23] = {.index = 39, .length = 1},
  [24] = {.index = 40, .length = 2},
  [25] = {.index = 42, .length = 1},
  [26] = {.index = 43, .length = 2},
  [27] = {.index = 45, .length = 1},
  [28] = {.index = 46, .length = 2},
  [29] = {.index = 48, .length = 1},
  [30] = {.index = 49, .length = 1},
  [31] = {.index = 50, .length = 3},
  [32] = {.index = 53, .length = 2},
  [33] = {.index = 55, .length = 2},
  [34] = {.index = 57, .length = 2},
  [35] = {.index = 59, .length = 2},
  [36] = {.index = 61, .length = 2},
  [37] = {.index = 63, .length = 2},
  [38] = {.index = 65, .length = 2},
  [39] = {.index = 67, .length = 2},
  [40] = {.index = 69, .length = 2},
  [41] = {.index = 71, .length = 1},
  [42] = {.index = 72, .length = 2},
  [43] = {.index = 74, .length = 3},
  [44] = {.index = 77, .length = 3},
  [45] = {.index = 80, .length = 3},
  [46] = {.index = 83, .length = 3},
  [47] = {.index = 86, .length = 2},
  [48] = {.index = 88, .length = 4},
  [49] = {.index = 92, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_start, 0},
  [1] =
    {field_local_declaration, 0, .inherited = true},
  [2] =
    {field_body, 0, .inherited = true},
    {field_local_declaration, 0},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [6] =
    {field_local_declaration, 0},
  [7] =
    {field_name, 0},
  [8] =
    {field_content, 1},
    {field_start, 0},
  [10] =
    {field_end, 1},
    {field_start, 0},
  [12] =
    {field_field, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [14] =
    {field_method, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [16] =
    {field_name, 1, .inherited = true},
  [17] =
    {field_arguments, 1},
    {field_name, 0},
  [19] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [21] =
    {field_content, 1},
    {field_end, 2},
    {field_start, 0},
  [24] =
    {field_body, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
  [26] =
    {field_value, 0},
  [27] =
    {field_operand, 1},
  [28] =
    {field_body, 1},
  [29] =
    {field_condition, 2},
  [30] =
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
  [33] =
    {field_name, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [35] =
    {field_field, 2},
    {field_table, 0},
  [37] =
    {field_method, 2},
    {field_table, 0},
  [39] =
    {field_name, 1},
  [40] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [42] =
    {field_parameters, 0},
  [43] =
    {field_left, 0},
    {field_right, 2},
  [45] =
    {field_condition, 1},
  [46] =
    {field_body, 1},
    {field_condition, 3},
  [48] =
    {field_alternative, 0},
  [49] =
    {field_clause, 1},
  [50] =
    {field_body, 3, .inherited = true},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
  [53] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [55] =
    {field_body, 1},
    {field_parameters, 0},
  [57] =
    {field_name, 0},
    {field_value, 2},
  [59] =
    {field_body, 3},
    {field_condition, 1},
  [61] =
    {field_condition, 1},
    {field_consequence, 3},
  [63] =
    {field_alternative, 3},
    {field_condition, 1},
  [65] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
  [67] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [69] =
    {field_body, 3},
    {field_clause, 1},
  [71] =
    {field_value, 1},
  [72] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [74] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [77] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [80] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
  [83] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
  [86] =
    {field_name, 1},
    {field_value, 4},
  [88] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [92] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
    {field_step, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '%') ADVANCE(49);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(14);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == '0') ADVANCE(19);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == ']') ADVANCE(29);
      if (lookahead == '^') ADVANCE(51);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(11);
      END_STATE();
    case 2:
      if (lookahead == '.') ADVANCE(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 5:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 6:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 7:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 8:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '%') ADVANCE(49);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(14);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == ']') ADVANCE(29);
      if (lookahead == '^') ADVANCE(51);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 9:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '0') ADVANCE(19);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(39);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(34);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(50);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(15);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(7);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_vararg_expression);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(42);
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(43);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(11);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'u') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 65:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 8, .external_lex_state = 2},
  [2] = {.lex_state = 8, .external_lex_state = 3},
  [3] = {.lex_state = 8, .external_lex_state = 3},
  [4] = {.lex_state = 8, .external_lex_state = 3},
  [5] = {.lex_state = 8, .external_lex_state = 3},
  [6] = {.lex_state = 8, .external_lex_state = 3},
  [7] = {.lex_state = 8, .external_lex_state = 3},
  [8] = {.lex_state = 8, .external_lex_state = 3},
  [9] = {.lex_state = 8, .external_lex_state = 3},
  [10] = {.lex_state = 8, .external_lex_state = 3},
  [11] = {.lex_state = 8, .external_lex_state = 3},
  [12] = {.lex_state = 8, .external_lex_state = 3},
  [13] = {.lex_state = 8, .external_lex_state = 3},
  [14] = {.lex_state = 8, .external_lex_state = 3},
  [15] = {.lex_state = 0, .external_lex_state = 2},
  [16] = {.lex_state = 0, .external_lex_state = 2},
  [17] = {.lex_state = 0, .external_lex_state = 2},
  [18] = {.lex_state = 0, .external_lex_state = 2},
  [19] = {.lex_state = 0, .external_lex_state = 2},
  [20] = {.lex_state = 0, .external_lex_state = 2},
  [21] = {.lex_state = 0, .external_lex_state = 2},
  [22] = {.lex_state = 0, .external_lex_state = 2},
  [23] = {.lex_state = 0, .external_lex_state = 2},
  [24] = {.lex_state = 0, .external_lex_state = 2},
  [25] = {.lex_state = 0, .external_lex_state = 2},
  [26] = {.lex_state = 0, .external_lex_state = 2},
  [27] = {.lex_state = 0, .external_lex_state = 2},
  [28] = {.lex_state = 0, .external_lex_state = 2},
  [29] = {.lex_state = 0, .external_lex_state = 2},
  [30] = {.lex_state = 0, .external_lex_state = 2},
  [31] = {.lex_state = 0, .external_lex_state = 2},
  [32] = {.lex_state = 0, .external_lex_state = 2},
  [33] = {.lex_state = 0, .external_lex_state = 2},
  [34] = {.lex_state = 0, .external_lex_state = 2},
  [35] = {.lex_state = 0, .external_lex_state = 2},
  [36] = {.lex_state = 0, .external_lex_state = 2},
  [37] = {.lex_state = 0, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 2},
  [39] = {.lex_state = 0, .external_lex_state = 2},
  [40] = {.lex_state = 0, .external_lex_state = 2},
  [41] = {.lex_state = 0, .external_lex_state = 2},
  [42] = {.lex_state = 0, .external_lex_state = 2},
  [43] = {.lex_state = 0, .external_lex_state = 2},
  [44] = {.lex_state = 0, .external_lex_state = 2},
  [45] = {.lex_state = 0, .external_lex_state = 2},
  [46] = {.lex_state = 0, .external_lex_state = 2},
  [47] = {.lex_state = 0, .external_lex_state = 2},
  [48] = {.lex_state = 0, .external_lex_state = 2},
  [49] = {.lex_state = 0, .external_lex_state = 2},
  [50] = {.lex_state = 0, .external_lex_state = 2},
  [51] = {.lex_state = 0, .external_lex_state = 2},
  [52] = {.lex_state = 9, .external_lex_state = 3},
  [53] = {.lex_state = 9, .external_lex_state = 3},
  [54] = {.lex_state = 9, .external_lex_state = 3},
  [55] = {.lex_state = 8, .external_lex_state = 3},
  [56] = {.lex_state = 9, .external_lex_state = 3},
  [57] = {.lex_state = 9, .external_lex_state = 3},
  [58] = {.lex_state = 0, .external_lex_state = 2},
  [59] = {.lex_state = 0, .external_lex_state = 2},
  [60] = {.lex_state = 9, .external_lex_state = 3},
  [61] = {.lex_state = 9, .external_lex_state = 3},
  [62] = {.lex_state = 9, .external_lex_state = 3},
  [63] = {.lex_state = 9, .external_lex_state = 3},
  [64] = {.lex_state = 9, .external_lex_state = 3},
  [65] = {.lex_state = 9, .external_lex_state = 3},
  [66] = {.lex_state = 9, .external_lex_state = 3},
  [67] = {.lex_state = 9, .external_lex_state = 3},
  [68] = {.lex_state = 9, .external_lex_state = 3},
  [69] = {.lex_state = 9, .external_lex_state = 3},
  [70] = {.lex_state = 9, .external_lex_state = 3},
  [71] = {.lex_state = 9, .external_lex_state = 3},
  [72] = {.lex_state = 9, .external_lex_state = 3},
  [73] = {.lex_state = 9, .external_lex_state = 3},
  [74] = {.lex_state = 9, .external_lex_state = 3},
  [75] = {.lex_state = 9, .external_lex_state = 3},
  [76] = {.lex_state = 9, .external_lex_state = 3},
  [77] = {.lex_state = 9, .external_lex_state = 3},
  [78] = {.lex_state = 9, .external_lex_state = 3},
  [79] = {.lex_state = 9, .external_lex_state = 3},
  [80] = {.lex_state = 9, .external_lex_state = 3},
  [81] = {.lex_state = 9, .external_lex_state = 3},
  [82] = {.lex_state = 9, .external_lex_state = 3},
  [83] = {.lex_state = 9, .external_lex_state = 3},
  [84] = {.lex_state = 9, .external_lex_state = 3},
  [85] = {.lex_state = 9, .external_lex_state = 3},
  [86] = {.lex_state = 9, .external_lex_state = 3},
  [87] = {.lex_state = 9, .external_lex_state = 3},
  [88] = {.lex_state = 9, .external_lex_state = 3},
  [89] = {.lex_state = 9, .external_lex_state = 3},
  [90] = {.lex_state = 9, .external_lex_state = 3},
  [91] = {.lex_state = 9, .external_lex_state = 3},
  [92] = {.lex_state = 0, .external_lex_state = 2},
  [93] = {.lex_state = 8, .external_lex_state = 3},
  [94] = {.lex_state = 0, .external_lex_state = 2},
  [95] = {.lex_state = 0, .external_lex_state = 2},
  [96] = {.lex_state = 0, .external_lex_state = 2},
  [97] = {.lex_state = 0, .external_lex_state = 2},
  [98] = {.lex_state = 0, .external_lex_state = 2},
  [99] = {.lex_state = 0, .external_lex_state = 2},
  [100] = {.lex_state = 0, .external_lex_state = 2},
  [101] = {.lex_state = 0, .external_lex_state = 2},
  [102] = {.lex_state = 0, .external_lex_state = 2},
  [103] = {.lex_state = 0, .external_lex_state = 2},
  [104] = {.lex_state = 0, .external_lex_state = 2},
  [105] = {.lex_state = 0, .external_lex_state = 2},
  [106] = {.lex_state = 0, .external_lex_state = 2},
  [107] = {.lex_state = 0, .external_lex_state = 2},
  [108] = {.lex_state = 0, .external_lex_state = 2},
  [109] = {.lex_state = 0, .external_lex_state = 2},
  [110] = {.lex_state = 0, .external_lex_state = 2},
  [111] = {.lex_state = 0, .external_lex_state = 2},
  [112] = {.lex_state = 0, .external_lex_state = 2},
  [113] = {.lex_state = 0, .external_lex_state = 2},
  [114] = {.lex_state = 0, .external_lex_state = 2},
  [115] = {.lex_state = 0, .external_lex_state = 2},
  [116] = {.lex_state = 0, .external_lex_state = 2},
  [117] = {.lex_state = 0, .external_lex_state = 2},
  [118] = {.lex_state = 0, .external_lex_state = 2},
  [119] = {.lex_state = 0, .external_lex_state = 2},
  [120] = {.lex_state = 0, .external_lex_state = 2},
  [121] = {.lex_state = 0, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 2},
  [123] = {.lex_state = 0, .external_lex_state = 2},
  [124] = {.lex_state = 0, .external_lex_state = 2},
  [125] = {.lex_state = 0, .external_lex_state = 2},
  [126] = {.lex_state = 0, .external_lex_state = 2},
  [127] = {.lex_state = 0, .external_lex_state = 2},
  [128] = {.lex_state = 0, .external_lex_state = 2},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 0, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 2},
  [134] = {.lex_state = 0, .external_lex_state = 2},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 0, .external_lex_state = 2},
  [137] = {.lex_state = 0, .external_lex_state = 2},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 9, .external_lex_state = 3},
  [141] = {.lex_state = 0, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 8, .external_lex_state = 3},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 8, .external_lex_state = 3},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 8, .external_lex_state = 3},
  [149] = {.lex_state = 8, .external_lex_state = 3},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 0, .external_lex_state = 2},
  [152] = {.lex_state = 0, .external_lex_state = 2},
  [153] = {.lex_state = 0, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 3},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 2},
  [160] = {.lex_state = 0, .external_lex_state = 2},
  [161] = {.lex_state = 0, .external_lex_state = 2},
  [162] = {.lex_state = 9, .external_lex_state = 2},
  [163] = {.lex_state = 0, .external_lex_state = 2},
  [164] = {.lex_state = 0, .external_lex_state = 2},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 0, .external_lex_state = 2},
  [168] = {.lex_state = 0, .external_lex_state = 3},
  [169] = {.lex_state = 8, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 2},
  [172] = {.lex_state = 8, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 2},
  [175] = {.lex_state = 0, .external_lex_state = 2},
  [176] = {.lex_state = 0, .external_lex_state = 2},
  [177] = {.lex_state = 0, .external_lex_state = 2},
  [178] = {.lex_state = 0, .external_lex_state = 2},
  [179] = {.lex_state = 8, .external_lex_state = 2},
  [180] = {.lex_state = 0, .external_lex_state = 2},
  [181] = {.lex_state = 8, .external_lex_state = 2},
  [182] = {.lex_state = 0, .external_lex_state = 2},
  [183] = {.lex_state = 0, .external_lex_state = 2},
  [184] = {.lex_state = 9, .external_lex_state = 2},
  [185] = {.lex_state = 0, .external_lex_state = 4},
  [186] = {.lex_state = 0, .external_lex_state = 2},
  [187] = {.lex_state = 0, .external_lex_state = 4},
  [188] = {.lex_state = 0, .external_lex_state = 5},
  [189] = {.lex_state = 9, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 0, .external_lex_state = 2},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 0, .external_lex_state = 2},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 0, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 0, .external_lex_state = 2},
  [200] = {.lex_state = 0, .external_lex_state = 2},
  [201] = {.lex_state = 0, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 2},
  [203] = {.lex_state = 0, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 0, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 6},
  [207] = {.lex_state = 0, .external_lex_state = 2},
  [208] = {.lex_state = 0, .external_lex_state = 2},
  [209] = {.lex_state = 0, .external_lex_state = 2},
  [210] = {.lex_state = 0, .external_lex_state = 7},
  [211] = {.lex_state = 0, .external_lex_state = 2},
  [212] = {.lex_state = 0, .external_lex_state = 2},
  [213] = {.lex_state = 0, .external_lex_state = 2},
  [214] = {.lex_state = 0, .external_lex_state = 2},
  [215] = {.lex_state = 0, .external_lex_state = 2},
  [216] = {.lex_state = 0, .external_lex_state = 2},
  [217] = {.lex_state = 0, .external_lex_state = 2},
  [218] = {.lex_state = 0, .external_lex_state = 2},
  [219] = {.lex_state = 0, .external_lex_state = 2},
  [220] = {.lex_state = 0, .external_lex_state = 2},
  [221] = {.lex_state = 0, .external_lex_state = 2},
  [222] = {.lex_state = 0, .external_lex_state = 2},
  [223] = {.lex_state = 0, .external_lex_state = 2},
  [224] = {.lex_state = 0, .external_lex_state = 2},
  [225] = {.lex_state = 0, .external_lex_state = 8},
  [226] = {.lex_state = 0, .external_lex_state = 7},
  [227] = {.lex_state = 0, .external_lex_state = 2},
  [228] = {.lex_state = 0, .external_lex_state = 2},
  [229] = {.lex_state = 0, .external_lex_state = 2},
  [230] = {.lex_state = 0, .external_lex_state = 2},
  [231] = {.lex_state = 0, .external_lex_state = 2},
  [232] = {(TSStateId)(-1)},
  [233] = {(TSStateId)(-1)},
  [234] = {(TSStateId)(-1)},
  [235] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__line_comment_start = 0,
  ts_external_token__line_comment_start_only = 1,
  ts_external_token__block_comment_start = 2,
  ts_external_token__block_comment_end = 3,
  ts_external_token__comment_content = 4,
  ts_external_token__string_start = 5,
  ts_external_token__string_content = 6,
  ts_external_token__string_end = 7,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__line_comment_start] = sym__line_comment_start,
  [ts_external_token__line_comment_start_only] = sym__line_comment_start_only,
  [ts_external_token__block_comment_start] = sym__block_comment_start,
  [ts_external_token__block_comment_end] = sym__block_comment_end,
  [ts_external_token__comment_content] = sym__comment_content,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static const bool ts_external_scanner_states[9][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_end] = true,
    [ts_external_token__comment_content] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
  },
  [3] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__string_start] = true,
  },
  [4] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [5] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_end] = true,
    [ts_external_token__comment_content] = true,
  },
  [6] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__comment_content] = true,
  },
  [7] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__string_end] = true,
  },
  [8] = {
    [ts_external_token__line_comment_start] = true,
    [ts_external_token__line_comment_start_only] = true,
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_end] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym__line_comment_start] = ACTIONS(3),
    [sym__line_comment_start_only] = ACTIONS(5),
    [sym__block_comment_start] = ACTIONS(7),
    [sym__block_comment_end] = ACTIONS(1),
    [sym__comment_content] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_chunk] = STATE(230),
    [sym_statement] = STATE(127),
    [sym_return_statement] = STATE(229),
    [sym_empty_statement] = STATE(124),
    [sym_assignment_statement] = STATE(124),
    [sym__variable_assignment_varlist] = STATE(228),
    [sym_label_statement] = STATE(124),
    [sym_goto_statement] = STATE(124),
    [sym_do_statement] = STATE(124),
    [sym_while_statement] = STATE(124),
    [sym_repeat_statement] = STATE(124),
    [sym_if_statement] = STATE(124),
    [sym_for_statement] = STATE(124),
    [sym_declaration] = STATE(112),
    [sym_function_declaration] = STATE(123),
    [sym__local_function_declaration] = STATE(121),
    [sym_variable_declaration] = STATE(120),
    [sym__prefix_expression] = STATE(144),
    [sym_variable] = STATE(146),
    [sym_bracket_index_expression] = STATE(4),
    [sym_dot_index_expression] = STATE(4),
    [sym_function_call] = STATE(93),
    [sym_method_index_expression] = STATE(154),
    [sym_parenthesized_expression] = STATE(149),
    [sym_comment] = STATE(1),
    [aux_sym_chunk_repeat1] = STATE(50),
    [ts_builtin_sym_end] = ACTIONS(9),
    [sym_identifier] = ACTIONS(11),
    [sym_hash_bang_line] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(15),
    [anon_sym_SEMI] = ACTIONS(17),
    [anon_sym_COLON_COLON] = ACTIONS(19),
    [sym_break_statement] = ACTIONS(21),
    [anon_sym_goto] = ACTIONS(23),
    [anon_sym_do] = ACTIONS(25),
    [anon_sym_while] = ACTIONS(27),
    [anon_sym_repeat] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_function] = ACTIONS(35),
    [anon_sym_local] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [sym__line_comment_start] = ACTIONS(3),
    [sym__line_comment_start_only] = ACTIONS(5),
    [sym__block_comment_start] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(2), 1,
      sym_comment,
    ACTIONS(43), 25,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(41), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [68] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(3), 1,
      sym_comment,
    ACTIONS(47), 25,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(45), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [136] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(4), 1,
      sym_comment,
    ACTIONS(51), 25,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(49), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [204] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(5), 1,
      sym_comment,
    ACTIONS(55), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(53), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [271] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(6), 1,
      sym_comment,
    ACTIONS(59), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(57), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [338] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(7), 1,
      sym_comment,
    ACTIONS(63), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(61), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [405] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(8), 1,
      sym_comment,
    ACTIONS(69), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(71), 4,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(65), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(67), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [476] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(9), 1,
      sym_comment,
    ACTIONS(75), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(73), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [543] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(10), 1,
      sym_comment,
    ACTIONS(79), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(77), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [610] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(11), 1,
      sym_comment,
    ACTIONS(83), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(81), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [677] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(12), 1,
      sym_comment,
    ACTIONS(87), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(85), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [744] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(13), 1,
      sym_comment,
    ACTIONS(91), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(89), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [811] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(14), 1,
      sym_comment,
    ACTIONS(95), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(93), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [878] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(15), 1,
      sym_comment,
    ACTIONS(99), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(97), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [940] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(16), 1,
      sym_comment,
    ACTIONS(83), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(81), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1002] = 13,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(17), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(103), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1078] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    STATE(18), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(103), 17,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      sym_identifier,
  [1164] = 14,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    STATE(19), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(103), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
  [1242] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_comment,
    ACTIONS(101), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(103), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [1306] = 11,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(21), 1,
      sym_comment,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(103), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1378] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(22), 1,
      sym_comment,
    ACTIONS(79), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(77), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1440] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(23), 1,
      sym_comment,
    ACTIONS(131), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(129), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1502] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(24), 1,
      sym_comment,
    ACTIONS(87), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(85), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1564] = 17,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    STATE(25), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(103), 18,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [1648] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(26), 1,
      sym_comment,
    ACTIONS(101), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(103), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [1712] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(27), 1,
      sym_comment,
    ACTIONS(135), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(133), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1774] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(28), 1,
      sym_comment,
    ACTIONS(95), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(93), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1836] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(29), 1,
      sym_comment,
    ACTIONS(67), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(65), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1898] = 40,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(137), 1,
      anon_sym_end,
    ACTIONS(139), 1,
      anon_sym_elseif,
    ACTIONS(141), 1,
      anon_sym_else,
    STATE(30), 1,
      sym_comment,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(150), 1,
      sym__block,
    STATE(153), 1,
      aux_sym_if_statement_repeat1,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(175), 1,
      sym_elseif_statement,
    STATE(193), 1,
      sym_else_statement,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2028] = 9,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(31), 1,
      sym_comment,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DOT,
    ACTIONS(103), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [2096] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(32), 1,
      sym_comment,
    ACTIONS(143), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(145), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [2160] = 11,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(33), 1,
      sym_comment,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(103), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [2232] = 12,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    STATE(34), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(103), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [2306] = 15,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    STATE(35), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(101), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(103), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
  [2386] = 34,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    STATE(36), 1,
      sym_comment,
    STATE(38), 1,
      aux_sym_chunk_repeat1,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(165), 1,
      sym_return_statement,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(147), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2501] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(37), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(174), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(149), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2618] = 32,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(151), 1,
      ts_builtin_sym_end,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(158), 1,
      anon_sym_SEMI,
    ACTIONS(161), 1,
      anon_sym_COLON_COLON,
    ACTIONS(164), 1,
      sym_break_statement,
    ACTIONS(167), 1,
      anon_sym_goto,
    ACTIONS(170), 1,
      anon_sym_do,
    ACTIONS(173), 1,
      anon_sym_while,
    ACTIONS(176), 1,
      anon_sym_repeat,
    ACTIONS(179), 1,
      anon_sym_if,
    ACTIONS(182), 1,
      anon_sym_for,
    ACTIONS(185), 1,
      anon_sym_function,
    ACTIONS(188), 1,
      anon_sym_local,
    ACTIONS(191), 1,
      anon_sym_LPAREN,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(38), 2,
      sym_comment,
      aux_sym_chunk_repeat1,
    ACTIONS(156), 5,
      anon_sym_return,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2729] = 21,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(198), 1,
      anon_sym_COMMA,
    ACTIONS(200), 1,
      anon_sym_or,
    STATE(39), 1,
      sym_comment,
    STATE(110), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(194), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(196), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2818] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(200), 1,
      anon_sym_or,
    STATE(40), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(202), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(204), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2902] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(200), 1,
      anon_sym_or,
    STATE(41), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(206), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(208), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2985] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(210), 1,
      anon_sym_end,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(42), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(197), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3100] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(212), 1,
      anon_sym_end,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(43), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(201), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3215] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(214), 1,
      anon_sym_end,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(44), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(194), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3330] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(216), 1,
      anon_sym_end,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(45), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(220), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3445] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(218), 1,
      anon_sym_until,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(46), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(219), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3560] = 35,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(220), 1,
      anon_sym_end,
    STATE(36), 1,
      aux_sym_chunk_repeat1,
    STATE(47), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_return_statement,
    STATE(200), 1,
      sym__block,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3675] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(200), 1,
      anon_sym_or,
    STATE(48), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(222), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(224), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [3758] = 34,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(226), 1,
      ts_builtin_sym_end,
    STATE(38), 1,
      aux_sym_chunk_repeat1,
    STATE(49), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(211), 1,
      sym_return_statement,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3870] = 34,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(228), 1,
      ts_builtin_sym_end,
    STATE(38), 1,
      aux_sym_chunk_repeat1,
    STATE(50), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(224), 1,
      sym_return_statement,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3982] = 34,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_return,
    ACTIONS(17), 1,
      anon_sym_SEMI,
    ACTIONS(19), 1,
      anon_sym_COLON_COLON,
    ACTIONS(21), 1,
      sym_break_statement,
    ACTIONS(23), 1,
      anon_sym_goto,
    ACTIONS(25), 1,
      anon_sym_do,
    ACTIONS(27), 1,
      anon_sym_while,
    ACTIONS(29), 1,
      anon_sym_repeat,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(35), 1,
      anon_sym_function,
    ACTIONS(37), 1,
      anon_sym_local,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(228), 1,
      ts_builtin_sym_end,
    STATE(49), 1,
      aux_sym_chunk_repeat1,
    STATE(51), 1,
      sym_comment,
    STATE(93), 1,
      sym_function_call,
    STATE(112), 1,
      sym_declaration,
    STATE(120), 1,
      sym_variable_declaration,
    STATE(121), 1,
      sym__local_function_declaration,
    STATE(123), 1,
      sym_function_declaration,
    STATE(127), 1,
      sym_statement,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(146), 1,
      sym_variable,
    STATE(149), 1,
      sym_parenthesized_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(224), 1,
      sym_return_statement,
    STATE(228), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(124), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [4094] = 23,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(230), 1,
      ts_builtin_sym_end,
    ACTIONS(232), 1,
      anon_sym_SEMI,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(52), 1,
      sym_comment,
    STATE(58), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(151), 1,
      sym__expression_list,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    ACTIONS(234), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4179] = 23,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    ACTIONS(250), 1,
      sym_identifier,
    ACTIONS(252), 1,
      anon_sym_LBRACK,
    ACTIONS(254), 1,
      anon_sym_RBRACE,
    STATE(53), 1,
      sym_comment,
    STATE(92), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(156), 1,
      sym_field,
    STATE(208), 1,
      sym__field_list,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4261] = 23,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    ACTIONS(250), 1,
      sym_identifier,
    ACTIONS(252), 1,
      anon_sym_LBRACK,
    ACTIONS(256), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      sym_comment,
    STATE(92), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(156), 1,
      sym_field,
    STATE(212), 1,
      sym__field_list,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4343] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(258), 1,
      anon_sym_EQ,
    STATE(55), 1,
      sym_comment,
    ACTIONS(51), 5,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(49), 25,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [4393] = 22,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    ACTIONS(250), 1,
      sym_identifier,
    ACTIONS(252), 1,
      anon_sym_LBRACK,
    ACTIONS(260), 1,
      anon_sym_RBRACE,
    STATE(56), 1,
      sym_comment,
    STATE(92), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(180), 1,
      sym_field,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4472] = 22,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    ACTIONS(250), 1,
      sym_identifier,
    ACTIONS(252), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_RBRACE,
    STATE(57), 1,
      sym_comment,
    STATE(92), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(180), 1,
      sym_field,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4551] = 21,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(266), 1,
      anon_sym_COMMA,
    ACTIONS(268), 1,
      anon_sym_else,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    STATE(58), 1,
      sym_comment,
    STATE(143), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(264), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [4628] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(276), 1,
      anon_sym_else,
    STATE(59), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(274), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [4700] = 21,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    ACTIONS(278), 1,
      anon_sym_RPAREN,
    STATE(58), 1,
      sym_expression,
    STATE(60), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(195), 1,
      sym__expression_list,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4776] = 21,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    ACTIONS(250), 1,
      sym_identifier,
    ACTIONS(252), 1,
      anon_sym_LBRACK,
    STATE(61), 1,
      sym_comment,
    STATE(92), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(180), 1,
      sym_field,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4852] = 20,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(39), 1,
      sym_expression,
    STATE(62), 1,
      sym_comment,
    STATE(116), 1,
      sym__variable_assignment_explist,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4925] = 20,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(39), 1,
      sym_expression,
    STATE(63), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(202), 1,
      sym__variable_assignment_explist,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4998] = 20,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(39), 1,
      sym_expression,
    STATE(64), 1,
      sym_comment,
    STATE(113), 1,
      sym__variable_assignment_explist,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5071] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(26), 1,
      sym_expression,
    STATE(65), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5141] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(41), 1,
      sym_expression,
    STATE(66), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5211] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(48), 1,
      sym_expression,
    STATE(67), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5281] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(68), 1,
      sym_comment,
    STATE(103), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5351] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(69), 1,
      sym_comment,
    STATE(104), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5421] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(25), 1,
      sym_expression,
    STATE(70), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5491] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(20), 1,
      sym_expression,
    STATE(71), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5561] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(72), 1,
      sym_comment,
    STATE(95), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5631] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(73), 1,
      sym_comment,
    STATE(97), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5701] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(21), 1,
      sym_expression,
    STATE(74), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5771] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(75), 1,
      sym_comment,
    STATE(102), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5841] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(76), 1,
      sym_comment,
    STATE(101), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5911] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(77), 1,
      sym_comment,
    STATE(94), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5981] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(18), 1,
      sym_expression,
    STATE(78), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6051] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(31), 1,
      sym_expression,
    STATE(79), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6121] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(33), 1,
      sym_expression,
    STATE(80), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6191] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(81), 1,
      sym_comment,
    STATE(108), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6261] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(35), 1,
      sym_expression,
    STATE(82), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6331] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(83), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6401] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(34), 1,
      sym_expression,
    STATE(84), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6471] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(17), 1,
      sym_expression,
    STATE(85), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6541] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(19), 1,
      sym_expression,
    STATE(86), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6611] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(59), 1,
      sym_expression,
    STATE(87), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6681] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(88), 1,
      sym_comment,
    STATE(105), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6751] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(40), 1,
      sym_expression,
    STATE(89), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6821] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(90), 1,
      sym_comment,
    STATE(106), 1,
      sym_expression,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6891] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(11), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_function,
    ACTIONS(242), 1,
      anon_sym_LBRACE,
    ACTIONS(246), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym__string_start,
    STATE(32), 1,
      sym_expression,
    STATE(91), 1,
      sym_comment,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(154), 1,
      sym_method_index_expression,
    ACTIONS(240), 2,
      sym_number,
      sym_vararg_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(238), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(244), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(8), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6961] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    STATE(92), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(280), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7026] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(69), 1,
      anon_sym_COLON,
    STATE(93), 1,
      sym_comment,
    ACTIONS(282), 3,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
    ACTIONS(71), 5,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(284), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7071] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    STATE(94), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(286), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7136] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    STATE(95), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(288), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7201] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      sym_comment,
    STATE(98), 1,
      aux_sym__variable_declaration_namelist_repeat1,
    ACTIONS(290), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(292), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7245] = 19,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(296), 1,
      anon_sym_COMMA,
    ACTIONS(298), 1,
      anon_sym_do,
    STATE(97), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7311] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(304), 1,
      anon_sym_COMMA,
    STATE(98), 2,
      sym_comment,
      aux_sym__variable_declaration_namelist_repeat1,
    ACTIONS(300), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(302), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7353] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(99), 1,
      sym_comment,
    ACTIONS(307), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(309), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7392] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    STATE(96), 1,
      aux_sym__variable_declaration_namelist_repeat1,
    STATE(100), 1,
      sym_comment,
    ACTIONS(311), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(313), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7435] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(315), 1,
      anon_sym_do,
    STATE(101), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7498] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(317), 1,
      anon_sym_RBRACK,
    STATE(102), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7561] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(319), 1,
      anon_sym_do,
    STATE(103), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7624] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(321), 1,
      anon_sym_then,
    STATE(104), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7687] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(323), 1,
      anon_sym_RBRACK,
    STATE(105), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7750] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(325), 1,
      anon_sym_COMMA,
    STATE(106), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7813] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(327), 1,
      anon_sym_then,
    STATE(107), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7876] = 18,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(105), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_SLASH,
    ACTIONS(115), 1,
      anon_sym_DOT_DOT,
    ACTIONS(117), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(270), 1,
      anon_sym_or,
    ACTIONS(272), 1,
      anon_sym_and,
    ACTIONS(329), 1,
      anon_sym_RPAREN,
    STATE(108), 1,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(121), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(111), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7939] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    STATE(109), 2,
      sym_comment,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(331), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(333), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7979] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(198), 1,
      anon_sym_COMMA,
    STATE(109), 1,
      aux_sym__variable_assignment_explist_repeat1,
    STATE(110), 1,
      sym_comment,
    ACTIONS(338), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(340), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8021] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(346), 1,
      anon_sym_EQ,
    STATE(111), 1,
      sym_comment,
    ACTIONS(342), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(344), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8060] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(112), 1,
      sym_comment,
    ACTIONS(348), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(350), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8096] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(113), 1,
      sym_comment,
    ACTIONS(352), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(354), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8132] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(114), 1,
      sym_comment,
    ACTIONS(356), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(358), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8168] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(115), 1,
      sym_comment,
    ACTIONS(360), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(362), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8204] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(116), 1,
      sym_comment,
    ACTIONS(364), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(366), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8240] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(117), 1,
      sym_comment,
    ACTIONS(368), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(370), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8276] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(118), 1,
      sym_comment,
    ACTIONS(372), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(374), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8312] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(119), 1,
      sym_comment,
    ACTIONS(376), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(378), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8348] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(120), 1,
      sym_comment,
    ACTIONS(380), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(382), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8384] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(121), 1,
      sym_comment,
    ACTIONS(384), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(386), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8420] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(122), 1,
      sym_comment,
    ACTIONS(388), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(390), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8456] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(123), 1,
      sym_comment,
    ACTIONS(392), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(394), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8492] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(124), 1,
      sym_comment,
    ACTIONS(282), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(284), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8528] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(125), 1,
      sym_comment,
    ACTIONS(396), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(398), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8564] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(126), 1,
      sym_comment,
    ACTIONS(400), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(402), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8600] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(127), 1,
      sym_comment,
    ACTIONS(404), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(406), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8636] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(128), 1,
      sym_comment,
    ACTIONS(408), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(410), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8672] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(129), 1,
      sym_comment,
    ACTIONS(412), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(414), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8708] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(130), 1,
      sym_comment,
    ACTIONS(416), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(418), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8744] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(131), 1,
      sym_comment,
    ACTIONS(420), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(422), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8780] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(132), 1,
      sym_comment,
    ACTIONS(424), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(426), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8816] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(133), 1,
      sym_comment,
    ACTIONS(428), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(430), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8852] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(134), 1,
      sym_comment,
    ACTIONS(432), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(434), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8888] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(135), 1,
      sym_comment,
    ACTIONS(436), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(438), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8924] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(136), 1,
      sym_comment,
    ACTIONS(440), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(442), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8960] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(137), 1,
      sym_comment,
    ACTIONS(444), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(446), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8996] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(138), 1,
      sym_comment,
    ACTIONS(448), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(450), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9032] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(139), 1,
      sym_comment,
    ACTIONS(452), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(454), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9068] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(140), 1,
      sym_comment,
    ACTIONS(456), 6,
      anon_sym_function,
      sym_nil,
      sym_false,
      sym_true,
      anon_sym_not,
      sym_identifier,
    ACTIONS(458), 10,
      sym__string_start,
      sym_number,
      sym_vararg_expression,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
  [9101] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(141), 1,
      sym_comment,
    ACTIONS(462), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(460), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9133] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(142), 1,
      sym_comment,
    ACTIONS(466), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(464), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9165] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(266), 1,
      anon_sym_COMMA,
    ACTIONS(470), 1,
      anon_sym_else,
    STATE(143), 1,
      sym_comment,
    STATE(147), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(468), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [9195] = 12,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(472), 1,
      anon_sym_DOT,
    ACTIONS(474), 1,
      anon_sym_COLON,
    ACTIONS(476), 1,
      anon_sym_LPAREN,
    ACTIONS(478), 1,
      anon_sym_LBRACK,
    ACTIONS(480), 1,
      anon_sym_LBRACE,
    ACTIONS(482), 1,
      sym__string_start,
    STATE(7), 1,
      sym_arguments,
    STATE(144), 1,
      sym_comment,
    STATE(6), 2,
      sym_string,
      sym_table_constructor,
  [9233] = 11,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(484), 1,
      sym_identifier,
    STATE(144), 1,
      sym__prefix_expression,
    STATE(145), 1,
      sym_comment,
    STATE(148), 1,
      sym_variable,
    STATE(154), 1,
      sym_method_index_expression,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(149), 2,
      sym_function_call,
      sym_parenthesized_expression,
  [9269] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(486), 1,
      anon_sym_EQ,
    ACTIONS(488), 1,
      anon_sym_COMMA,
    STATE(146), 1,
      sym_comment,
    STATE(178), 1,
      aux_sym__variable_assignment_varlist_repeat1,
    ACTIONS(71), 6,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9299] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(276), 1,
      anon_sym_else,
    ACTIONS(490), 1,
      anon_sym_COMMA,
    STATE(147), 2,
      sym_comment,
      aux_sym__expression_list_repeat1,
    ACTIONS(274), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [9327] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(148), 1,
      sym_comment,
    ACTIONS(493), 2,
      anon_sym_EQ,
      anon_sym_COMMA,
    ACTIONS(71), 6,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9352] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(149), 1,
      sym_comment,
    ACTIONS(71), 6,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9373] = 10,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(141), 1,
      anon_sym_else,
    ACTIONS(495), 1,
      anon_sym_end,
    ACTIONS(497), 1,
      anon_sym_elseif,
    STATE(150), 1,
      sym_comment,
    STATE(152), 1,
      aux_sym_if_statement_repeat1,
    STATE(175), 1,
      sym_elseif_statement,
    STATE(199), 1,
      sym_else_statement,
  [9404] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(501), 1,
      anon_sym_SEMI,
    ACTIONS(503), 1,
      anon_sym_else,
    STATE(151), 1,
      sym_comment,
    ACTIONS(499), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9429] = 10,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(141), 1,
      anon_sym_else,
    ACTIONS(497), 1,
      anon_sym_elseif,
    ACTIONS(505), 1,
      anon_sym_end,
    STATE(152), 1,
      sym_comment,
    STATE(161), 1,
      aux_sym_if_statement_repeat1,
    STATE(175), 1,
      sym_elseif_statement,
    STATE(218), 1,
      sym_else_statement,
  [9460] = 10,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(141), 1,
      anon_sym_else,
    ACTIONS(497), 1,
      anon_sym_elseif,
    ACTIONS(507), 1,
      anon_sym_end,
    STATE(153), 1,
      sym_comment,
    STATE(161), 1,
      aux_sym_if_statement_repeat1,
    STATE(175), 1,
      sym_elseif_statement,
    STATE(203), 1,
      sym_else_statement,
  [9491] = 9,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(476), 1,
      anon_sym_LPAREN,
    ACTIONS(480), 1,
      anon_sym_LBRACE,
    ACTIONS(482), 1,
      sym__string_start,
    STATE(7), 1,
      sym_arguments,
    STATE(154), 1,
      sym_comment,
    STATE(6), 2,
      sym_string,
      sym_table_constructor,
  [9520] = 9,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(509), 1,
      sym_identifier,
    STATE(155), 1,
      sym_comment,
    STATE(172), 1,
      sym__function_name_dot_index_expression,
    STATE(179), 1,
      sym__function_name_prefix_expression,
    STATE(182), 1,
      sym__function_name,
    STATE(216), 1,
      sym__function_name_method_index_expression,
  [9548] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(513), 1,
      anon_sym_RBRACE,
    STATE(56), 1,
      sym__field_sep,
    STATE(156), 1,
      sym_comment,
    STATE(157), 1,
      aux_sym__field_list_repeat1,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [9574] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(260), 1,
      anon_sym_RBRACE,
    STATE(57), 1,
      sym__field_sep,
    STATE(157), 1,
      sym_comment,
    STATE(160), 1,
      aux_sym__field_list_repeat1,
    ACTIONS(511), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [9600] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(517), 1,
      anon_sym_else,
    STATE(158), 1,
      sym_comment,
    ACTIONS(515), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9622] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(503), 1,
      anon_sym_else,
    STATE(159), 1,
      sym_comment,
    ACTIONS(499), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9644] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(522), 1,
      anon_sym_RBRACE,
    STATE(61), 1,
      sym__field_sep,
    ACTIONS(519), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    STATE(160), 2,
      sym_comment,
      aux_sym__field_list_repeat1,
  [9668] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(524), 1,
      anon_sym_end,
    ACTIONS(526), 1,
      anon_sym_elseif,
    ACTIONS(529), 1,
      anon_sym_else,
    STATE(175), 1,
      sym_elseif_statement,
    STATE(161), 2,
      sym_comment,
      aux_sym_if_statement_repeat1,
  [9694] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(533), 1,
      sym_vararg_expression,
    ACTIONS(535), 1,
      anon_sym_RPAREN,
    STATE(162), 1,
      sym_comment,
    STATE(196), 1,
      sym__parameter_list,
  [9719] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(147), 1,
      anon_sym_else,
    STATE(163), 1,
      sym_comment,
    ACTIONS(537), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9740] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(539), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_function,
    STATE(111), 1,
      sym__variable_declaration_namelist,
    STATE(114), 1,
      sym__local_variable_assignment,
    STATE(164), 1,
      sym_comment,
  [9765] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(545), 1,
      anon_sym_else,
    STATE(165), 1,
      sym_comment,
    ACTIONS(543), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9786] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(547), 1,
      sym_identifier,
    STATE(166), 1,
      sym_comment,
    STATE(217), 1,
      sym__variable_declaration_namelist,
    STATE(190), 2,
      sym_for_generic_clause,
      sym_for_numeric_clause,
  [9809] = 8,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(311), 1,
      anon_sym_in,
    ACTIONS(549), 1,
      anon_sym_EQ,
    STATE(96), 1,
      aux_sym__variable_declaration_namelist_repeat1,
    STATE(167), 1,
      sym_comment,
  [9834] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(168), 1,
      sym_comment,
    ACTIONS(551), 3,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [9852] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(169), 1,
      sym_comment,
    ACTIONS(553), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [9870] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(555), 1,
      anon_sym_COMMA,
    ACTIONS(557), 1,
      anon_sym_RPAREN,
    STATE(170), 1,
      sym_comment,
    STATE(176), 1,
      aux_sym__parameter_list_repeat1,
  [9892] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(559), 1,
      anon_sym_LPAREN,
    STATE(27), 1,
      sym__function_body,
    STATE(47), 1,
      sym_parameters,
    STATE(171), 1,
      sym_comment,
  [9914] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(172), 1,
      sym_comment,
    ACTIONS(561), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [9932] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(559), 1,
      anon_sym_LPAREN,
    STATE(47), 1,
      sym_parameters,
    STATE(117), 1,
      sym__function_body,
    STATE(173), 1,
      sym_comment,
  [9954] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(565), 1,
      anon_sym_else,
    STATE(174), 1,
      sym_comment,
    ACTIONS(563), 2,
      anon_sym_end,
      anon_sym_elseif,
  [9974] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(569), 1,
      anon_sym_else,
    STATE(175), 1,
      sym_comment,
    ACTIONS(567), 2,
      anon_sym_end,
      anon_sym_elseif,
  [9994] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(571), 1,
      anon_sym_COMMA,
    ACTIONS(573), 1,
      anon_sym_RPAREN,
    STATE(176), 1,
      sym_comment,
    STATE(177), 1,
      aux_sym__parameter_list_repeat1,
  [10016] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(575), 1,
      anon_sym_COMMA,
    ACTIONS(578), 1,
      anon_sym_RPAREN,
    STATE(177), 2,
      sym_comment,
      aux_sym__parameter_list_repeat1,
  [10036] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(488), 1,
      anon_sym_COMMA,
    ACTIONS(580), 1,
      anon_sym_EQ,
    STATE(178), 1,
      sym_comment,
    STATE(183), 1,
      aux_sym__variable_assignment_varlist_repeat1,
  [10058] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(582), 1,
      anon_sym_DOT,
    ACTIONS(584), 1,
      anon_sym_COLON,
    ACTIONS(586), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_comment,
  [10080] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(180), 1,
      sym_comment,
    ACTIONS(522), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [10098] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(181), 1,
      sym_comment,
    ACTIONS(588), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [10116] = 7,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(559), 1,
      anon_sym_LPAREN,
    STATE(47), 1,
      sym_parameters,
    STATE(119), 1,
      sym__function_body,
    STATE(182), 1,
      sym_comment,
  [10138] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(590), 1,
      anon_sym_EQ,
    ACTIONS(592), 1,
      anon_sym_COMMA,
    STATE(183), 2,
      sym_comment,
      aux_sym__variable_assignment_varlist_repeat1,
  [10158] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(595), 1,
      sym_identifier,
    ACTIONS(597), 1,
      sym_vararg_expression,
    STATE(184), 1,
      sym_comment,
  [10177] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(599), 1,
      sym__string_content,
    ACTIONS(601), 1,
      sym__string_end,
    STATE(185), 1,
      sym_comment,
  [10196] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    STATE(186), 1,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10213] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(603), 1,
      sym__string_content,
    ACTIONS(605), 1,
      sym__string_end,
    STATE(187), 1,
      sym_comment,
  [10232] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(607), 1,
      sym__block_comment_end,
    ACTIONS(609), 1,
      sym__comment_content,
    STATE(188), 1,
      sym_comment,
  [10251] = 6,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(595), 1,
      sym_identifier,
    ACTIONS(611), 1,
      sym_vararg_expression,
    STATE(189), 1,
      sym_comment,
  [10270] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(613), 1,
      anon_sym_do,
    STATE(190), 1,
      sym_comment,
  [10286] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(615), 1,
      sym_identifier,
    STATE(191), 1,
      sym_comment,
  [10302] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(617), 1,
      sym_identifier,
    STATE(192), 1,
      sym_comment,
  [10318] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(619), 1,
      anon_sym_end,
    STATE(193), 1,
      sym_comment,
  [10334] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(621), 1,
      anon_sym_end,
    STATE(194), 1,
      sym_comment,
  [10350] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(623), 1,
      anon_sym_RPAREN,
    STATE(195), 1,
      sym_comment,
  [10366] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(625), 1,
      anon_sym_RPAREN,
    STATE(196), 1,
      sym_comment,
  [10382] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(627), 1,
      anon_sym_end,
    STATE(197), 1,
      sym_comment,
  [10398] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(629), 1,
      sym_identifier,
    STATE(198), 1,
      sym_comment,
  [10414] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(631), 1,
      anon_sym_end,
    STATE(199), 1,
      sym_comment,
  [10430] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(633), 1,
      anon_sym_end,
    STATE(200), 1,
      sym_comment,
  [10446] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(635), 1,
      anon_sym_end,
    STATE(201), 1,
      sym_comment,
  [10462] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(637), 1,
      anon_sym_do,
    STATE(202), 1,
      sym_comment,
  [10478] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(639), 1,
      anon_sym_end,
    STATE(203), 1,
      sym_comment,
  [10494] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(557), 1,
      anon_sym_RPAREN,
    STATE(204), 1,
      sym_comment,
  [10510] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(641), 1,
      anon_sym_EQ,
    STATE(205), 1,
      sym_comment,
  [10526] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(643), 1,
      sym__comment_content,
    STATE(206), 1,
      sym_comment,
  [10542] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(645), 1,
      sym_identifier,
    STATE(207), 1,
      sym_comment,
  [10558] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(647), 1,
      anon_sym_RBRACE,
    STATE(208), 1,
      sym_comment,
  [10574] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(649), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_comment,
  [10590] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(651), 1,
      sym__string_end,
    STATE(210), 1,
      sym_comment,
  [10606] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(653), 1,
      ts_builtin_sym_end,
    STATE(211), 1,
      sym_comment,
  [10622] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    STATE(212), 1,
      sym_comment,
  [10638] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(657), 1,
      anon_sym_LPAREN,
    STATE(213), 1,
      sym_comment,
  [10654] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(659), 1,
      sym_identifier,
    STATE(214), 1,
      sym_comment,
  [10670] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(661), 1,
      sym_identifier,
    STATE(215), 1,
      sym_comment,
  [10686] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    STATE(216), 1,
      sym_comment,
  [10702] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(665), 1,
      anon_sym_in,
    STATE(217), 1,
      sym_comment,
  [10718] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(667), 1,
      anon_sym_end,
    STATE(218), 1,
      sym_comment,
  [10734] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(669), 1,
      anon_sym_until,
    STATE(219), 1,
      sym_comment,
  [10750] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(671), 1,
      anon_sym_end,
    STATE(220), 1,
      sym_comment,
  [10766] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(673), 1,
      anon_sym_RPAREN,
    STATE(221), 1,
      sym_comment,
  [10782] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(595), 1,
      sym_identifier,
    STATE(222), 1,
      sym_comment,
  [10798] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(675), 1,
      anon_sym_COLON_COLON,
    STATE(223), 1,
      sym_comment,
  [10814] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(226), 1,
      ts_builtin_sym_end,
    STATE(224), 1,
      sym_comment,
  [10830] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(677), 1,
      sym__block_comment_end,
    STATE(225), 1,
      sym_comment,
  [10846] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(679), 1,
      sym__string_end,
    STATE(226), 1,
      sym_comment,
  [10862] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(681), 1,
      sym_identifier,
    STATE(227), 1,
      sym_comment,
  [10878] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(683), 1,
      anon_sym_EQ,
    STATE(228), 1,
      sym_comment,
  [10894] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(228), 1,
      ts_builtin_sym_end,
    STATE(229), 1,
      sym_comment,
  [10910] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(685), 1,
      ts_builtin_sym_end,
    STATE(230), 1,
      sym_comment,
  [10926] = 5,
    ACTIONS(3), 1,
      sym__line_comment_start,
    ACTIONS(5), 1,
      sym__line_comment_start_only,
    ACTIONS(7), 1,
      sym__block_comment_start,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(231), 1,
      sym_comment,
  [10942] = 1,
    ACTIONS(689), 1,
      ts_builtin_sym_end,
  [10946] = 1,
    ACTIONS(691), 1,
      ts_builtin_sym_end,
  [10950] = 1,
    ACTIONS(693), 1,
      ts_builtin_sym_end,
  [10954] = 1,
    ACTIONS(695), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 68,
  [SMALL_STATE(4)] = 136,
  [SMALL_STATE(5)] = 204,
  [SMALL_STATE(6)] = 271,
  [SMALL_STATE(7)] = 338,
  [SMALL_STATE(8)] = 405,
  [SMALL_STATE(9)] = 476,
  [SMALL_STATE(10)] = 543,
  [SMALL_STATE(11)] = 610,
  [SMALL_STATE(12)] = 677,
  [SMALL_STATE(13)] = 744,
  [SMALL_STATE(14)] = 811,
  [SMALL_STATE(15)] = 878,
  [SMALL_STATE(16)] = 940,
  [SMALL_STATE(17)] = 1002,
  [SMALL_STATE(18)] = 1078,
  [SMALL_STATE(19)] = 1164,
  [SMALL_STATE(20)] = 1242,
  [SMALL_STATE(21)] = 1306,
  [SMALL_STATE(22)] = 1378,
  [SMALL_STATE(23)] = 1440,
  [SMALL_STATE(24)] = 1502,
  [SMALL_STATE(25)] = 1564,
  [SMALL_STATE(26)] = 1648,
  [SMALL_STATE(27)] = 1712,
  [SMALL_STATE(28)] = 1774,
  [SMALL_STATE(29)] = 1836,
  [SMALL_STATE(30)] = 1898,
  [SMALL_STATE(31)] = 2028,
  [SMALL_STATE(32)] = 2096,
  [SMALL_STATE(33)] = 2160,
  [SMALL_STATE(34)] = 2232,
  [SMALL_STATE(35)] = 2306,
  [SMALL_STATE(36)] = 2386,
  [SMALL_STATE(37)] = 2501,
  [SMALL_STATE(38)] = 2618,
  [SMALL_STATE(39)] = 2729,
  [SMALL_STATE(40)] = 2818,
  [SMALL_STATE(41)] = 2902,
  [SMALL_STATE(42)] = 2985,
  [SMALL_STATE(43)] = 3100,
  [SMALL_STATE(44)] = 3215,
  [SMALL_STATE(45)] = 3330,
  [SMALL_STATE(46)] = 3445,
  [SMALL_STATE(47)] = 3560,
  [SMALL_STATE(48)] = 3675,
  [SMALL_STATE(49)] = 3758,
  [SMALL_STATE(50)] = 3870,
  [SMALL_STATE(51)] = 3982,
  [SMALL_STATE(52)] = 4094,
  [SMALL_STATE(53)] = 4179,
  [SMALL_STATE(54)] = 4261,
  [SMALL_STATE(55)] = 4343,
  [SMALL_STATE(56)] = 4393,
  [SMALL_STATE(57)] = 4472,
  [SMALL_STATE(58)] = 4551,
  [SMALL_STATE(59)] = 4628,
  [SMALL_STATE(60)] = 4700,
  [SMALL_STATE(61)] = 4776,
  [SMALL_STATE(62)] = 4852,
  [SMALL_STATE(63)] = 4925,
  [SMALL_STATE(64)] = 4998,
  [SMALL_STATE(65)] = 5071,
  [SMALL_STATE(66)] = 5141,
  [SMALL_STATE(67)] = 5211,
  [SMALL_STATE(68)] = 5281,
  [SMALL_STATE(69)] = 5351,
  [SMALL_STATE(70)] = 5421,
  [SMALL_STATE(71)] = 5491,
  [SMALL_STATE(72)] = 5561,
  [SMALL_STATE(73)] = 5631,
  [SMALL_STATE(74)] = 5701,
  [SMALL_STATE(75)] = 5771,
  [SMALL_STATE(76)] = 5841,
  [SMALL_STATE(77)] = 5911,
  [SMALL_STATE(78)] = 5981,
  [SMALL_STATE(79)] = 6051,
  [SMALL_STATE(80)] = 6121,
  [SMALL_STATE(81)] = 6191,
  [SMALL_STATE(82)] = 6261,
  [SMALL_STATE(83)] = 6331,
  [SMALL_STATE(84)] = 6401,
  [SMALL_STATE(85)] = 6471,
  [SMALL_STATE(86)] = 6541,
  [SMALL_STATE(87)] = 6611,
  [SMALL_STATE(88)] = 6681,
  [SMALL_STATE(89)] = 6751,
  [SMALL_STATE(90)] = 6821,
  [SMALL_STATE(91)] = 6891,
  [SMALL_STATE(92)] = 6961,
  [SMALL_STATE(93)] = 7026,
  [SMALL_STATE(94)] = 7071,
  [SMALL_STATE(95)] = 7136,
  [SMALL_STATE(96)] = 7201,
  [SMALL_STATE(97)] = 7245,
  [SMALL_STATE(98)] = 7311,
  [SMALL_STATE(99)] = 7353,
  [SMALL_STATE(100)] = 7392,
  [SMALL_STATE(101)] = 7435,
  [SMALL_STATE(102)] = 7498,
  [SMALL_STATE(103)] = 7561,
  [SMALL_STATE(104)] = 7624,
  [SMALL_STATE(105)] = 7687,
  [SMALL_STATE(106)] = 7750,
  [SMALL_STATE(107)] = 7813,
  [SMALL_STATE(108)] = 7876,
  [SMALL_STATE(109)] = 7939,
  [SMALL_STATE(110)] = 7979,
  [SMALL_STATE(111)] = 8021,
  [SMALL_STATE(112)] = 8060,
  [SMALL_STATE(113)] = 8096,
  [SMALL_STATE(114)] = 8132,
  [SMALL_STATE(115)] = 8168,
  [SMALL_STATE(116)] = 8204,
  [SMALL_STATE(117)] = 8240,
  [SMALL_STATE(118)] = 8276,
  [SMALL_STATE(119)] = 8312,
  [SMALL_STATE(120)] = 8348,
  [SMALL_STATE(121)] = 8384,
  [SMALL_STATE(122)] = 8420,
  [SMALL_STATE(123)] = 8456,
  [SMALL_STATE(124)] = 8492,
  [SMALL_STATE(125)] = 8528,
  [SMALL_STATE(126)] = 8564,
  [SMALL_STATE(127)] = 8600,
  [SMALL_STATE(128)] = 8636,
  [SMALL_STATE(129)] = 8672,
  [SMALL_STATE(130)] = 8708,
  [SMALL_STATE(131)] = 8744,
  [SMALL_STATE(132)] = 8780,
  [SMALL_STATE(133)] = 8816,
  [SMALL_STATE(134)] = 8852,
  [SMALL_STATE(135)] = 8888,
  [SMALL_STATE(136)] = 8924,
  [SMALL_STATE(137)] = 8960,
  [SMALL_STATE(138)] = 8996,
  [SMALL_STATE(139)] = 9032,
  [SMALL_STATE(140)] = 9068,
  [SMALL_STATE(141)] = 9101,
  [SMALL_STATE(142)] = 9133,
  [SMALL_STATE(143)] = 9165,
  [SMALL_STATE(144)] = 9195,
  [SMALL_STATE(145)] = 9233,
  [SMALL_STATE(146)] = 9269,
  [SMALL_STATE(147)] = 9299,
  [SMALL_STATE(148)] = 9327,
  [SMALL_STATE(149)] = 9352,
  [SMALL_STATE(150)] = 9373,
  [SMALL_STATE(151)] = 9404,
  [SMALL_STATE(152)] = 9429,
  [SMALL_STATE(153)] = 9460,
  [SMALL_STATE(154)] = 9491,
  [SMALL_STATE(155)] = 9520,
  [SMALL_STATE(156)] = 9548,
  [SMALL_STATE(157)] = 9574,
  [SMALL_STATE(158)] = 9600,
  [SMALL_STATE(159)] = 9622,
  [SMALL_STATE(160)] = 9644,
  [SMALL_STATE(161)] = 9668,
  [SMALL_STATE(162)] = 9694,
  [SMALL_STATE(163)] = 9719,
  [SMALL_STATE(164)] = 9740,
  [SMALL_STATE(165)] = 9765,
  [SMALL_STATE(166)] = 9786,
  [SMALL_STATE(167)] = 9809,
  [SMALL_STATE(168)] = 9834,
  [SMALL_STATE(169)] = 9852,
  [SMALL_STATE(170)] = 9870,
  [SMALL_STATE(171)] = 9892,
  [SMALL_STATE(172)] = 9914,
  [SMALL_STATE(173)] = 9932,
  [SMALL_STATE(174)] = 9954,
  [SMALL_STATE(175)] = 9974,
  [SMALL_STATE(176)] = 9994,
  [SMALL_STATE(177)] = 10016,
  [SMALL_STATE(178)] = 10036,
  [SMALL_STATE(179)] = 10058,
  [SMALL_STATE(180)] = 10080,
  [SMALL_STATE(181)] = 10098,
  [SMALL_STATE(182)] = 10116,
  [SMALL_STATE(183)] = 10138,
  [SMALL_STATE(184)] = 10158,
  [SMALL_STATE(185)] = 10177,
  [SMALL_STATE(186)] = 10196,
  [SMALL_STATE(187)] = 10213,
  [SMALL_STATE(188)] = 10232,
  [SMALL_STATE(189)] = 10251,
  [SMALL_STATE(190)] = 10270,
  [SMALL_STATE(191)] = 10286,
  [SMALL_STATE(192)] = 10302,
  [SMALL_STATE(193)] = 10318,
  [SMALL_STATE(194)] = 10334,
  [SMALL_STATE(195)] = 10350,
  [SMALL_STATE(196)] = 10366,
  [SMALL_STATE(197)] = 10382,
  [SMALL_STATE(198)] = 10398,
  [SMALL_STATE(199)] = 10414,
  [SMALL_STATE(200)] = 10430,
  [SMALL_STATE(201)] = 10446,
  [SMALL_STATE(202)] = 10462,
  [SMALL_STATE(203)] = 10478,
  [SMALL_STATE(204)] = 10494,
  [SMALL_STATE(205)] = 10510,
  [SMALL_STATE(206)] = 10526,
  [SMALL_STATE(207)] = 10542,
  [SMALL_STATE(208)] = 10558,
  [SMALL_STATE(209)] = 10574,
  [SMALL_STATE(210)] = 10590,
  [SMALL_STATE(211)] = 10606,
  [SMALL_STATE(212)] = 10622,
  [SMALL_STATE(213)] = 10638,
  [SMALL_STATE(214)] = 10654,
  [SMALL_STATE(215)] = 10670,
  [SMALL_STATE(216)] = 10686,
  [SMALL_STATE(217)] = 10702,
  [SMALL_STATE(218)] = 10718,
  [SMALL_STATE(219)] = 10734,
  [SMALL_STATE(220)] = 10750,
  [SMALL_STATE(221)] = 10766,
  [SMALL_STATE(222)] = 10782,
  [SMALL_STATE(223)] = 10798,
  [SMALL_STATE(224)] = 10814,
  [SMALL_STATE(225)] = 10830,
  [SMALL_STATE(226)] = 10846,
  [SMALL_STATE(227)] = 10862,
  [SMALL_STATE(228)] = 10878,
  [SMALL_STATE(229)] = 10894,
  [SMALL_STATE(230)] = 10910,
  [SMALL_STATE(231)] = 10926,
  [SMALL_STATE(232)] = 10942,
  [SMALL_STATE(233)] = 10946,
  [SMALL_STATE(234)] = 10950,
  [SMALL_STATE(235)] = 10954,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 0),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 21),
  [43] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 21),
  [45] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3, .production_id = 21),
  [47] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3, .production_id = 21),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [51] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1),
  [53] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [55] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 1),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 11),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 11),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefix_expression, 1),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_expression, 1),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 3),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 3),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, .production_id = 7),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, .production_id = 7),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, .production_id = 13),
  [87] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, .production_id = 13),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 2),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 2),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 3, .production_id = 33),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 3, .production_id = 33),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 26),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 26),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 2, .production_id = 25),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 2, .production_id = 25),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 2, .production_id = 14),
  [135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 2, .production_id = 14),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 16),
  [145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 16),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 1),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 3, .production_id = 27),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [153] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(4),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(138),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(227),
  [164] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(124),
  [167] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(231),
  [170] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(45),
  [173] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(68),
  [176] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(46),
  [179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(69),
  [182] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(166),
  [185] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(155),
  [188] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(164),
  [191] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(81),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 15),
  [196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 15),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 41),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 41),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 3, .production_id = 18),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 3, .production_id = 18),
  [210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 1),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 4, .production_id = 28),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 4, .production_id = 28),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 2),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 1),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 1),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [258] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 2),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 3),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 1),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 1),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1, .production_id = 15),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 34),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 47),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration_namelist, 2, .production_id = 12),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_declaration_namelist, 2, .production_id = 12),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 5, .production_id = 46),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 24),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 24),
  [304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 24), SHIFT_REPEAT(207),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 23),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 23),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration_namelist, 1, .production_id = 5),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_declaration_namelist, 1, .production_id = 5),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 7, .production_id = 49),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 42),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 42),
  [335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 42), SHIFT_REPEAT(89),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 32),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 32),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2, .production_id = 10),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2, .production_id = 10),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1, .production_id = 2),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1, .production_id = 2),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3, .production_id = 20),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 3, .production_id = 20),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5, .production_id = 40),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5, .production_id = 40),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 20),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 20),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_function_declaration, 4, .production_id = 31),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_function_declaration, 4, .production_id = 31),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_goto_statement, 2),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_goto_statement, 2),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 3, .production_id = 19),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 3, .production_id = 19),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 4),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 4),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 2),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 2),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 45),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 45),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 3, .production_id = 17),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 3, .production_id = 17),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 1),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 1),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 4, .production_id = 30),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 4, .production_id = 30),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 44),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 44),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 4, .production_id = 27),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 27),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, .production_id = 35),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, .production_id = 35),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 43),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 43),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 27),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 27),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 36),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 36),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 38),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 38),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_label_statement, 3),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_label_statement, 3),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 48),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 48),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_empty_statement, 1),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_empty_statement, 1),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 37),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 37),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__field_sep, 1),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_sep, 1),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 2),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 3),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 2),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 2),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 1, .production_id = 5),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [490] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2), SHIFT_REPEAT(87),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 23),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [499] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 1),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2), SHIFT_REPEAT(140),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 39),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 39), SHIFT_REPEAT(83),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 39),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 1),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 2),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 2),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_index_expression, 3, .production_id = 22),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_dot_index_expression, 3, .production_id = 21),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 1),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1, .production_id = 8),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 4, .production_id = 36),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 4, .production_id = 36),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 29),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 29),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 2),
  [575] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__parameter_list_repeat1, 2), SHIFT_REPEAT(222),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__parameter_list_repeat1, 2),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 2, .production_id = 12),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 24),
  [592] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 24), SHIFT_REPEAT(145),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2, .production_id = 17),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_generic_clause, 3, .production_id = 20),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 3),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 3),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [657] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_method_index_expression, 3, .production_id = 22),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1, .production_id = 9),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 4),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [685] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, .production_id = 6),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1, .production_id = 1),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, .production_id = 7),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3, .production_id = 13),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_lua_external_scanner_create(void);
void tree_sitter_lua_external_scanner_destroy(void *);
bool tree_sitter_lua_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_lua_external_scanner_serialize(void *, char *);
void tree_sitter_lua_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_lua(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_lua_external_scanner_create,
      tree_sitter_lua_external_scanner_destroy,
      tree_sitter_lua_external_scanner_scan,
      tree_sitter_lua_external_scanner_serialize,
      tree_sitter_lua_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
