#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 216
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 118
#define ALIAS_COUNT 0
#define TOKEN_COUNT 61
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 19
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 46

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_return = 3,
  anon_sym_SEMI = 4,
  anon_sym_EQ = 5,
  anon_sym_COMMA = 6,
  anon_sym_COLON_COLON = 7,
  sym_break_statement = 8,
  anon_sym_goto = 9,
  anon_sym_do = 10,
  anon_sym_end = 11,
  anon_sym_while = 12,
  anon_sym_repeat = 13,
  anon_sym_until = 14,
  anon_sym_if = 15,
  anon_sym_then = 16,
  anon_sym_elseif = 17,
  anon_sym_else = 18,
  anon_sym_for = 19,
  anon_sym_in = 20,
  anon_sym_function = 21,
  anon_sym_local = 22,
  anon_sym_DOT = 23,
  anon_sym_COLON = 24,
  sym_nil = 25,
  sym_false = 26,
  sym_true = 27,
  sym_number = 28,
  sym_vararg_expression = 29,
  anon_sym_LPAREN = 30,
  anon_sym_RPAREN = 31,
  anon_sym_LBRACK = 32,
  anon_sym_RBRACK = 33,
  anon_sym_LBRACE = 34,
  anon_sym_RBRACE = 35,
  anon_sym_or = 36,
  anon_sym_and = 37,
  anon_sym_LT = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_TILDE_EQ = 41,
  anon_sym_GT_EQ = 42,
  anon_sym_GT = 43,
  anon_sym_PIPE = 44,
  anon_sym_TILDE = 45,
  anon_sym_AMP = 46,
  anon_sym_LT_LT = 47,
  anon_sym_GT_GT = 48,
  anon_sym_PLUS = 49,
  anon_sym_DASH = 50,
  anon_sym_STAR = 51,
  anon_sym_SLASH = 52,
  anon_sym_SLASH_SLASH = 53,
  anon_sym_PERCENT = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_CARET = 56,
  anon_sym_not = 57,
  anon_sym_POUND = 58,
  sym_comment = 59,
  sym_string = 60,
  sym_chunk = 61,
  sym__block = 62,
  sym_statement = 63,
  sym_return_statement = 64,
  sym_empty_statement = 65,
  sym_assignment_statement = 66,
  sym__variable_assignment_varlist = 67,
  sym__variable_assignment_explist = 68,
  sym_label_statement = 69,
  sym_goto_statement = 70,
  sym_do_statement = 71,
  sym_while_statement = 72,
  sym_repeat_statement = 73,
  sym_if_statement = 74,
  sym_elseif_statement = 75,
  sym_else_statement = 76,
  sym_for_statement = 77,
  sym_for_generic_clause = 78,
  sym_for_numeric_clause = 79,
  sym_declaration = 80,
  sym_function_declaration = 81,
  sym__local_function_declaration = 82,
  sym__function_name = 83,
  sym__function_name_prefix_expression = 84,
  sym__function_name_dot_index_expression = 85,
  sym__function_name_method_index_expression = 86,
  sym_variable_declaration = 87,
  sym__local_variable_assignment = 88,
  sym__variable_declaration_namelist = 89,
  sym__expression_list = 90,
  sym_expression = 91,
  sym_function_definition = 92,
  sym__function_body = 93,
  sym_parameters = 94,
  sym__parameter_list = 95,
  sym__prefix_expression = 96,
  sym_variable = 97,
  sym_bracket_index_expression = 98,
  sym_dot_index_expression = 99,
  sym_function_call = 100,
  sym_method_index_expression = 101,
  sym_arguments = 102,
  sym_parenthesized_expression = 103,
  sym_table_constructor = 104,
  sym__field_list = 105,
  sym__field_sep = 106,
  sym_field = 107,
  sym_binary_expression = 108,
  sym_unary_expression = 109,
  aux_sym_chunk_repeat1 = 110,
  aux_sym__variable_assignment_varlist_repeat1 = 111,
  aux_sym__variable_assignment_explist_repeat1 = 112,
  aux_sym_if_statement_repeat1 = 113,
  aux_sym__variable_declaration_namelist_repeat1 = 114,
  aux_sym__expression_list_repeat1 = 115,
  aux_sym__parameter_list_repeat1 = 116,
  aux_sym__field_list_repeat1 = 117,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_return] = "return",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON_COLON] = "::",
  [sym_break_statement] = "break_statement",
  [anon_sym_goto] = "goto",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_function] = "function",
  [anon_sym_local] = "local",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON] = ":",
  [sym_nil] = "nil",
  [sym_false] = "false",
  [sym_true] = "true",
  [sym_number] = "number",
  [sym_vararg_expression] = "vararg_expression",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [sym_comment] = "comment",
  [sym_string] = "string",
  [sym_chunk] = "chunk",
  [sym__block] = "block",
  [sym_statement] = "statement",
  [sym_return_statement] = "return_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym__variable_assignment_varlist] = "variable_list",
  [sym__variable_assignment_explist] = "expression_list",
  [sym_label_statement] = "label_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_do_statement] = "do_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_generic_clause] = "for_generic_clause",
  [sym_for_numeric_clause] = "for_numeric_clause",
  [sym_declaration] = "declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__function_name] = "_function_name",
  [sym__function_name_prefix_expression] = "_function_name_prefix_expression",
  [sym__function_name_dot_index_expression] = "dot_index_expression",
  [sym__function_name_method_index_expression] = "method_index_expression",
  [sym_variable_declaration] = "variable_declaration",
  [sym__local_variable_assignment] = "assignment_statement",
  [sym__variable_declaration_namelist] = "variable_list",
  [sym__expression_list] = "_expression_list",
  [sym_expression] = "expression",
  [sym_function_definition] = "function_definition",
  [sym__function_body] = "_function_body",
  [sym_parameters] = "parameters",
  [sym__parameter_list] = "_parameter_list",
  [sym__prefix_expression] = "_prefix_expression",
  [sym_variable] = "variable",
  [sym_bracket_index_expression] = "bracket_index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_function_call] = "function_call",
  [sym_method_index_expression] = "method_index_expression",
  [sym_arguments] = "arguments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_table_constructor] = "table_constructor",
  [sym__field_list] = "_field_list",
  [sym__field_sep] = "_field_sep",
  [sym_field] = "field",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [aux_sym_chunk_repeat1] = "chunk_repeat1",
  [aux_sym__variable_assignment_varlist_repeat1] = "_variable_assignment_varlist_repeat1",
  [aux_sym__variable_assignment_explist_repeat1] = "_variable_assignment_explist_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym__variable_declaration_namelist_repeat1] = "_variable_declaration_namelist_repeat1",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym__parameter_list_repeat1] = "_parameter_list_repeat1",
  [aux_sym__field_list_repeat1] = "_field_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_nil] = sym_nil,
  [sym_false] = sym_false,
  [sym_true] = sym_true,
  [sym_number] = sym_number,
  [sym_vararg_expression] = sym_vararg_expression,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_comment] = sym_comment,
  [sym_string] = sym_string,
  [sym_chunk] = sym_chunk,
  [sym__block] = sym__block,
  [sym_statement] = sym_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym__variable_assignment_varlist] = sym__variable_assignment_varlist,
  [sym__variable_assignment_explist] = sym__variable_assignment_explist,
  [sym_label_statement] = sym_label_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_generic_clause] = sym_for_generic_clause,
  [sym_for_numeric_clause] = sym_for_numeric_clause,
  [sym_declaration] = sym_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__function_name] = sym__function_name,
  [sym__function_name_prefix_expression] = sym__function_name_prefix_expression,
  [sym__function_name_dot_index_expression] = sym_dot_index_expression,
  [sym__function_name_method_index_expression] = sym_method_index_expression,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym__local_variable_assignment] = sym_assignment_statement,
  [sym__variable_declaration_namelist] = sym__variable_assignment_varlist,
  [sym__expression_list] = sym__expression_list,
  [sym_expression] = sym_expression,
  [sym_function_definition] = sym_function_definition,
  [sym__function_body] = sym__function_body,
  [sym_parameters] = sym_parameters,
  [sym__parameter_list] = sym__parameter_list,
  [sym__prefix_expression] = sym__prefix_expression,
  [sym_variable] = sym_variable,
  [sym_bracket_index_expression] = sym_bracket_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_function_call] = sym_function_call,
  [sym_method_index_expression] = sym_method_index_expression,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_table_constructor] = sym_table_constructor,
  [sym__field_list] = sym__field_list,
  [sym__field_sep] = sym__field_sep,
  [sym_field] = sym_field,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [aux_sym_chunk_repeat1] = aux_sym_chunk_repeat1,
  [aux_sym__variable_assignment_varlist_repeat1] = aux_sym__variable_assignment_varlist_repeat1,
  [aux_sym__variable_assignment_explist_repeat1] = aux_sym__variable_assignment_explist_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym__variable_declaration_namelist_repeat1] = aux_sym__variable_declaration_namelist_repeat1,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym__parameter_list_repeat1] = aux_sym__parameter_list_repeat1,
  [aux_sym__field_list_repeat1] = aux_sym__field_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_vararg_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_varlist] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_explist] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_generic_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_numeric_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declaration_namelist] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_bracket_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym__field_list] = {
    .visible = false,
    .named = true,
  },
  [sym__field_sep] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_chunk_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_varlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_explist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declaration_namelist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_clause = 4,
  field_condition = 5,
  field_consequence = 6,
  field_end = 7,
  field_field = 8,
  field_left = 9,
  field_local_declaration = 10,
  field_method = 11,
  field_name = 12,
  field_operand = 13,
  field_parameters = 14,
  field_right = 15,
  field_start = 16,
  field_step = 17,
  field_table = 18,
  field_value = 19,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_clause] = "clause",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_field] = "field",
  [field_left] = "left",
  [field_local_declaration] = "local_declaration",
  [field_method] = "method",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_step] = "step",
  [field_table] = "table",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 1},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 2},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 1},
  [12] = {.index = 19, .length = 1},
  [13] = {.index = 20, .length = 1},
  [14] = {.index = 21, .length = 1},
  [15] = {.index = 22, .length = 3},
  [16] = {.index = 25, .length = 2},
  [17] = {.index = 27, .length = 2},
  [18] = {.index = 29, .length = 2},
  [19] = {.index = 31, .length = 1},
  [20] = {.index = 32, .length = 2},
  [21] = {.index = 34, .length = 1},
  [22] = {.index = 35, .length = 2},
  [23] = {.index = 37, .length = 1},
  [24] = {.index = 38, .length = 2},
  [25] = {.index = 40, .length = 1},
  [26] = {.index = 41, .length = 1},
  [27] = {.index = 42, .length = 3},
  [28] = {.index = 45, .length = 2},
  [29] = {.index = 47, .length = 2},
  [30] = {.index = 49, .length = 2},
  [31] = {.index = 51, .length = 2},
  [32] = {.index = 53, .length = 2},
  [33] = {.index = 55, .length = 2},
  [34] = {.index = 57, .length = 2},
  [35] = {.index = 59, .length = 2},
  [36] = {.index = 61, .length = 2},
  [37] = {.index = 63, .length = 1},
  [38] = {.index = 64, .length = 2},
  [39] = {.index = 66, .length = 3},
  [40] = {.index = 69, .length = 3},
  [41] = {.index = 72, .length = 3},
  [42] = {.index = 75, .length = 3},
  [43] = {.index = 78, .length = 2},
  [44] = {.index = 80, .length = 4},
  [45] = {.index = 84, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_local_declaration, 0, .inherited = true},
  [1] =
    {field_body, 0, .inherited = true},
    {field_local_declaration, 0},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [5] =
    {field_local_declaration, 0},
  [6] =
    {field_name, 0},
  [7] =
    {field_field, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [9] =
    {field_method, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [11] =
    {field_name, 1, .inherited = true},
  [12] =
    {field_arguments, 1},
    {field_name, 0},
  [14] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [16] =
    {field_body, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
  [18] =
    {field_value, 0},
  [19] =
    {field_operand, 1},
  [20] =
    {field_body, 1},
  [21] =
    {field_condition, 2},
  [22] =
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
  [25] =
    {field_name, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [27] =
    {field_field, 2},
    {field_table, 0},
  [29] =
    {field_method, 2},
    {field_table, 0},
  [31] =
    {field_name, 1},
  [32] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [34] =
    {field_parameters, 0},
  [35] =
    {field_left, 0},
    {field_right, 2},
  [37] =
    {field_condition, 1},
  [38] =
    {field_body, 1},
    {field_condition, 3},
  [40] =
    {field_alternative, 0},
  [41] =
    {field_clause, 1},
  [42] =
    {field_body, 3, .inherited = true},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
  [45] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [47] =
    {field_body, 1},
    {field_parameters, 0},
  [49] =
    {field_name, 0},
    {field_value, 2},
  [51] =
    {field_body, 3},
    {field_condition, 1},
  [53] =
    {field_condition, 1},
    {field_consequence, 3},
  [55] =
    {field_alternative, 3},
    {field_condition, 1},
  [57] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
  [59] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [61] =
    {field_body, 3},
    {field_clause, 1},
  [63] =
    {field_value, 1},
  [64] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [66] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [69] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [72] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
  [75] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
  [78] =
    {field_name, 1},
    {field_value, 4},
  [80] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [84] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
    {field_step, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '%') ADVANCE(49);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(14);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == '0') ADVANCE(19);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == ']') ADVANCE(29);
      if (lookahead == '^') ADVANCE(51);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(11);
      END_STATE();
    case 2:
      if (lookahead == '.') ADVANCE(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 5:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 6:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 7:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 8:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '%') ADVANCE(49);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(14);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == ']') ADVANCE(29);
      if (lookahead == '^') ADVANCE(51);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 9:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '0') ADVANCE(19);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(39);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(34);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(50);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(15);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(7);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_vararg_expression);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(42);
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(43);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(11);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'u') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 65:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 8, .external_lex_state = 2},
  [2] = {.lex_state = 8, .external_lex_state = 1},
  [3] = {.lex_state = 8, .external_lex_state = 1},
  [4] = {.lex_state = 8, .external_lex_state = 1},
  [5] = {.lex_state = 8, .external_lex_state = 1},
  [6] = {.lex_state = 8, .external_lex_state = 1},
  [7] = {.lex_state = 8, .external_lex_state = 1},
  [8] = {.lex_state = 8, .external_lex_state = 1},
  [9] = {.lex_state = 8, .external_lex_state = 1},
  [10] = {.lex_state = 8, .external_lex_state = 1},
  [11] = {.lex_state = 8, .external_lex_state = 1},
  [12] = {.lex_state = 8, .external_lex_state = 1},
  [13] = {.lex_state = 0, .external_lex_state = 2},
  [14] = {.lex_state = 0, .external_lex_state = 2},
  [15] = {.lex_state = 0, .external_lex_state = 2},
  [16] = {.lex_state = 0, .external_lex_state = 2},
  [17] = {.lex_state = 0, .external_lex_state = 2},
  [18] = {.lex_state = 0, .external_lex_state = 2},
  [19] = {.lex_state = 0, .external_lex_state = 2},
  [20] = {.lex_state = 0, .external_lex_state = 2},
  [21] = {.lex_state = 0, .external_lex_state = 2},
  [22] = {.lex_state = 0, .external_lex_state = 2},
  [23] = {.lex_state = 0, .external_lex_state = 2},
  [24] = {.lex_state = 0, .external_lex_state = 2},
  [25] = {.lex_state = 0, .external_lex_state = 2},
  [26] = {.lex_state = 0, .external_lex_state = 2},
  [27] = {.lex_state = 0, .external_lex_state = 2},
  [28] = {.lex_state = 0, .external_lex_state = 2},
  [29] = {.lex_state = 0, .external_lex_state = 2},
  [30] = {.lex_state = 0, .external_lex_state = 2},
  [31] = {.lex_state = 0, .external_lex_state = 2},
  [32] = {.lex_state = 0, .external_lex_state = 2},
  [33] = {.lex_state = 0, .external_lex_state = 2},
  [34] = {.lex_state = 0, .external_lex_state = 2},
  [35] = {.lex_state = 0, .external_lex_state = 2},
  [36] = {.lex_state = 0, .external_lex_state = 2},
  [37] = {.lex_state = 0, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 2},
  [39] = {.lex_state = 0, .external_lex_state = 2},
  [40] = {.lex_state = 0, .external_lex_state = 2},
  [41] = {.lex_state = 0, .external_lex_state = 2},
  [42] = {.lex_state = 0, .external_lex_state = 2},
  [43] = {.lex_state = 0, .external_lex_state = 2},
  [44] = {.lex_state = 0, .external_lex_state = 2},
  [45] = {.lex_state = 0, .external_lex_state = 2},
  [46] = {.lex_state = 0, .external_lex_state = 2},
  [47] = {.lex_state = 0, .external_lex_state = 2},
  [48] = {.lex_state = 9, .external_lex_state = 1},
  [49] = {.lex_state = 8, .external_lex_state = 1},
  [50] = {.lex_state = 0, .external_lex_state = 2},
  [51] = {.lex_state = 9, .external_lex_state = 1},
  [52] = {.lex_state = 9, .external_lex_state = 1},
  [53] = {.lex_state = 0, .external_lex_state = 2},
  [54] = {.lex_state = 9, .external_lex_state = 1},
  [55] = {.lex_state = 9, .external_lex_state = 1},
  [56] = {.lex_state = 9, .external_lex_state = 1},
  [57] = {.lex_state = 9, .external_lex_state = 1},
  [58] = {.lex_state = 9, .external_lex_state = 1},
  [59] = {.lex_state = 9, .external_lex_state = 1},
  [60] = {.lex_state = 9, .external_lex_state = 1},
  [61] = {.lex_state = 9, .external_lex_state = 1},
  [62] = {.lex_state = 9, .external_lex_state = 1},
  [63] = {.lex_state = 9, .external_lex_state = 1},
  [64] = {.lex_state = 9, .external_lex_state = 1},
  [65] = {.lex_state = 9, .external_lex_state = 1},
  [66] = {.lex_state = 9, .external_lex_state = 1},
  [67] = {.lex_state = 9, .external_lex_state = 1},
  [68] = {.lex_state = 9, .external_lex_state = 1},
  [69] = {.lex_state = 9, .external_lex_state = 1},
  [70] = {.lex_state = 9, .external_lex_state = 1},
  [71] = {.lex_state = 9, .external_lex_state = 1},
  [72] = {.lex_state = 9, .external_lex_state = 1},
  [73] = {.lex_state = 9, .external_lex_state = 1},
  [74] = {.lex_state = 9, .external_lex_state = 1},
  [75] = {.lex_state = 9, .external_lex_state = 1},
  [76] = {.lex_state = 9, .external_lex_state = 1},
  [77] = {.lex_state = 9, .external_lex_state = 1},
  [78] = {.lex_state = 9, .external_lex_state = 1},
  [79] = {.lex_state = 9, .external_lex_state = 1},
  [80] = {.lex_state = 9, .external_lex_state = 1},
  [81] = {.lex_state = 9, .external_lex_state = 1},
  [82] = {.lex_state = 9, .external_lex_state = 1},
  [83] = {.lex_state = 9, .external_lex_state = 1},
  [84] = {.lex_state = 9, .external_lex_state = 1},
  [85] = {.lex_state = 9, .external_lex_state = 1},
  [86] = {.lex_state = 9, .external_lex_state = 1},
  [87] = {.lex_state = 9, .external_lex_state = 1},
  [88] = {.lex_state = 8, .external_lex_state = 1},
  [89] = {.lex_state = 0, .external_lex_state = 2},
  [90] = {.lex_state = 0, .external_lex_state = 2},
  [91] = {.lex_state = 0, .external_lex_state = 2},
  [92] = {.lex_state = 0, .external_lex_state = 2},
  [93] = {.lex_state = 0, .external_lex_state = 2},
  [94] = {.lex_state = 0, .external_lex_state = 2},
  [95] = {.lex_state = 0, .external_lex_state = 2},
  [96] = {.lex_state = 0, .external_lex_state = 2},
  [97] = {.lex_state = 0, .external_lex_state = 2},
  [98] = {.lex_state = 0, .external_lex_state = 2},
  [99] = {.lex_state = 0, .external_lex_state = 2},
  [100] = {.lex_state = 0, .external_lex_state = 2},
  [101] = {.lex_state = 0, .external_lex_state = 2},
  [102] = {.lex_state = 0, .external_lex_state = 2},
  [103] = {.lex_state = 0, .external_lex_state = 2},
  [104] = {.lex_state = 0, .external_lex_state = 2},
  [105] = {.lex_state = 0, .external_lex_state = 2},
  [106] = {.lex_state = 0, .external_lex_state = 2},
  [107] = {.lex_state = 0, .external_lex_state = 2},
  [108] = {.lex_state = 0, .external_lex_state = 2},
  [109] = {.lex_state = 0, .external_lex_state = 2},
  [110] = {.lex_state = 0, .external_lex_state = 2},
  [111] = {.lex_state = 0, .external_lex_state = 2},
  [112] = {.lex_state = 0, .external_lex_state = 2},
  [113] = {.lex_state = 0, .external_lex_state = 2},
  [114] = {.lex_state = 0, .external_lex_state = 2},
  [115] = {.lex_state = 0, .external_lex_state = 2},
  [116] = {.lex_state = 0, .external_lex_state = 2},
  [117] = {.lex_state = 0, .external_lex_state = 2},
  [118] = {.lex_state = 0, .external_lex_state = 2},
  [119] = {.lex_state = 0, .external_lex_state = 2},
  [120] = {.lex_state = 0, .external_lex_state = 2},
  [121] = {.lex_state = 0, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 2},
  [123] = {.lex_state = 0, .external_lex_state = 2},
  [124] = {.lex_state = 0, .external_lex_state = 2},
  [125] = {.lex_state = 0, .external_lex_state = 2},
  [126] = {.lex_state = 0, .external_lex_state = 2},
  [127] = {.lex_state = 0, .external_lex_state = 2},
  [128] = {.lex_state = 0, .external_lex_state = 2},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 0, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 2},
  [134] = {.lex_state = 0, .external_lex_state = 2},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 0, .external_lex_state = 2},
  [137] = {.lex_state = 0, .external_lex_state = 2},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 8, .external_lex_state = 1},
  [141] = {.lex_state = 8, .external_lex_state = 1},
  [142] = {.lex_state = 8, .external_lex_state = 1},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 0, .external_lex_state = 2},
  [149] = {.lex_state = 0, .external_lex_state = 1},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 0, .external_lex_state = 2},
  [152] = {.lex_state = 0, .external_lex_state = 2},
  [153] = {.lex_state = 0, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 9, .external_lex_state = 2},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 2},
  [160] = {.lex_state = 0, .external_lex_state = 2},
  [161] = {.lex_state = 8, .external_lex_state = 2},
  [162] = {.lex_state = 8, .external_lex_state = 2},
  [163] = {.lex_state = 0, .external_lex_state = 2},
  [164] = {.lex_state = 0, .external_lex_state = 2},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 8, .external_lex_state = 2},
  [168] = {.lex_state = 0, .external_lex_state = 2},
  [169] = {.lex_state = 0, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 1},
  [172] = {.lex_state = 0, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 2},
  [175] = {.lex_state = 0, .external_lex_state = 2},
  [176] = {.lex_state = 9, .external_lex_state = 2},
  [177] = {.lex_state = 9, .external_lex_state = 2},
  [178] = {.lex_state = 0, .external_lex_state = 2},
  [179] = {.lex_state = 0, .external_lex_state = 2},
  [180] = {.lex_state = 0, .external_lex_state = 2},
  [181] = {.lex_state = 0, .external_lex_state = 2},
  [182] = {.lex_state = 0, .external_lex_state = 2},
  [183] = {.lex_state = 0, .external_lex_state = 2},
  [184] = {.lex_state = 0, .external_lex_state = 2},
  [185] = {.lex_state = 0, .external_lex_state = 2},
  [186] = {.lex_state = 0, .external_lex_state = 2},
  [187] = {.lex_state = 0, .external_lex_state = 2},
  [188] = {.lex_state = 0, .external_lex_state = 2},
  [189] = {.lex_state = 0, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 0, .external_lex_state = 2},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 0, .external_lex_state = 2},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 0, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 0, .external_lex_state = 2},
  [200] = {.lex_state = 0, .external_lex_state = 2},
  [201] = {.lex_state = 0, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 2},
  [203] = {.lex_state = 0, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 0, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 2},
  [207] = {.lex_state = 0, .external_lex_state = 2},
  [208] = {.lex_state = 0, .external_lex_state = 2},
  [209] = {.lex_state = 0, .external_lex_state = 2},
  [210] = {.lex_state = 0, .external_lex_state = 2},
  [211] = {.lex_state = 0, .external_lex_state = 2},
  [212] = {.lex_state = 0, .external_lex_state = 2},
  [213] = {.lex_state = 0, .external_lex_state = 2},
  [214] = {.lex_state = 0, .external_lex_state = 2},
  [215] = {.lex_state = 0, .external_lex_state = 2},
};

enum {
  ts_external_token_comment = 0,
  ts_external_token_string = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_string] = sym_string,
};

static const bool ts_external_scanner_states[3][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_comment] = true,
    [ts_external_token_string] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_string] = ACTIONS(1),
  },
  [1] = {
    [sym_chunk] = STATE(213),
    [sym_statement] = STATE(46),
    [sym_return_statement] = STATE(212),
    [sym_empty_statement] = STATE(113),
    [sym_assignment_statement] = STATE(113),
    [sym__variable_assignment_varlist] = STATE(211),
    [sym_label_statement] = STATE(113),
    [sym_goto_statement] = STATE(113),
    [sym_do_statement] = STATE(113),
    [sym_while_statement] = STATE(113),
    [sym_repeat_statement] = STATE(113),
    [sym_if_statement] = STATE(113),
    [sym_for_statement] = STATE(113),
    [sym_declaration] = STATE(114),
    [sym_function_declaration] = STATE(115),
    [sym__local_function_declaration] = STATE(117),
    [sym_variable_declaration] = STATE(124),
    [sym__prefix_expression] = STATE(142),
    [sym_variable] = STATE(140),
    [sym_bracket_index_expression] = STATE(2),
    [sym_dot_index_expression] = STATE(2),
    [sym_function_call] = STATE(88),
    [sym_method_index_expression] = STATE(149),
    [sym_parenthesized_expression] = STATE(142),
    [aux_sym_chunk_repeat1] = STATE(46),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_return] = ACTIONS(11),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_COLON_COLON] = ACTIONS(15),
    [sym_break_statement] = ACTIONS(17),
    [anon_sym_goto] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(21),
    [anon_sym_while] = ACTIONS(23),
    [anon_sym_repeat] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 25,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(37), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [59] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 25,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(41), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [118] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 25,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(45), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [177] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(55), 4,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(49), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(51), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(57), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [297] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(61), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(65), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(69), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(73), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(77), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 24,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(81), 26,
      sym_string,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(85), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [698] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(91), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
  [767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(109), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [820] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(91), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
  [891] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(89), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(91), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [946] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(89), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(91), 18,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [1021] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(89), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(91), 17,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      sym_identifier,
  [1098] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(91), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1163] = 35,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_end,
    ACTIONS(123), 1,
      anon_sym_elseif,
    ACTIONS(125), 1,
      anon_sym_else,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(145), 1,
      sym__block,
    STATE(146), 1,
      aux_sym_if_statement_repeat1,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(168), 1,
      sym_elseif_statement,
    STATE(180), 1,
      sym_else_statement,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [1280] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(91), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1343] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DOT,
    ACTIONS(91), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1402] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(127), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(129), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [1457] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(89), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(91), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [1512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(65), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(63), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(61), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1618] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(91), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1685] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(89), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(91), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(131), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1801] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(49), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1854] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 1,
      ts_builtin_sym_end,
    ACTIONS(137), 1,
      sym_identifier,
    ACTIONS(142), 1,
      anon_sym_SEMI,
    ACTIONS(145), 1,
      anon_sym_COLON_COLON,
    ACTIONS(148), 1,
      sym_break_statement,
    ACTIONS(151), 1,
      anon_sym_goto,
    ACTIONS(154), 1,
      anon_sym_do,
    ACTIONS(157), 1,
      anon_sym_while,
    ACTIONS(160), 1,
      anon_sym_repeat,
    ACTIONS(163), 1,
      anon_sym_if,
    ACTIONS(166), 1,
      anon_sym_for,
    ACTIONS(169), 1,
      anon_sym_function,
    ACTIONS(172), 1,
      anon_sym_local,
    ACTIONS(175), 1,
      anon_sym_LPAREN,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(32), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    ACTIONS(140), 5,
      anon_sym_return,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [1954] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(160), 1,
      sym_return_statement,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(32), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    ACTIONS(178), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2056] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(184), 1,
      anon_sym_COMMA,
    ACTIONS(186), 1,
      anon_sym_or,
    STATE(105), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(180), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(182), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2136] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(165), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    ACTIONS(188), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2240] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(186), 1,
      anon_sym_or,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(190), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(192), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2315] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(194), 1,
      anon_sym_until,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(203), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2417] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(196), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(189), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2519] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(186), 1,
      anon_sym_or,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(198), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(200), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2593] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(202), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(204), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2695] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(204), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(199), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2797] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(119), 1,
      anon_sym_and,
    ACTIONS(186), 1,
      anon_sym_or,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(206), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(208), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2871] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(210), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2973] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(212), 1,
      anon_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(157), 1,
      sym_return_statement,
    STATE(194), 1,
      sym__block,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(33), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3075] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(214), 1,
      ts_builtin_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(188), 1,
      sym_return_statement,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(32), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3174] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(216), 1,
      ts_builtin_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(210), 1,
      sym_return_statement,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(32), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3273] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_COLON_COLON,
    ACTIONS(17), 1,
      sym_break_statement,
    ACTIONS(19), 1,
      anon_sym_goto,
    ACTIONS(21), 1,
      anon_sym_do,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_for,
    ACTIONS(31), 1,
      anon_sym_function,
    ACTIONS(33), 1,
      anon_sym_local,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(216), 1,
      ts_builtin_sym_end,
    STATE(88), 1,
      sym_function_call,
    STATE(114), 1,
      sym_declaration,
    STATE(115), 1,
      sym_function_declaration,
    STATE(117), 1,
      sym__local_function_declaration,
    STATE(124), 1,
      sym_variable_declaration,
    STATE(140), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(210), 1,
      sym_return_statement,
    STATE(211), 1,
      sym__variable_assignment_varlist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(45), 2,
      sym_statement,
      aux_sym_chunk_repeat1,
    STATE(142), 2,
      sym__prefix_expression,
      sym_parenthesized_expression,
    STATE(113), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3372] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(218), 1,
      ts_builtin_sym_end,
    ACTIONS(220), 1,
      anon_sym_SEMI,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(50), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(143), 1,
      sym__expression_list,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    ACTIONS(222), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [3445] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 1,
      anon_sym_EQ,
    ACTIONS(39), 5,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(37), 25,
      sym_string,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [3486] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(240), 1,
      anon_sym_COMMA,
    ACTIONS(242), 1,
      anon_sym_else,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    STATE(139), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(238), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [3554] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LBRACK,
    ACTIONS(252), 1,
      anon_sym_RBRACE,
    STATE(89), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(148), 1,
      sym_field,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(186), 1,
      sym__field_list,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [3624] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LBRACK,
    ACTIONS(254), 1,
      anon_sym_RBRACE,
    STATE(89), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(148), 1,
      sym_field,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(215), 1,
      sym__field_list,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [3694] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(258), 1,
      anon_sym_else,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(256), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [3757] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LBRACK,
    ACTIONS(260), 1,
      anon_sym_RBRACE,
    STATE(89), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(173), 1,
      sym_field,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [3824] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_RBRACE,
    STATE(89), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(173), 1,
      sym_field,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [3891] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    ACTIONS(264), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(208), 1,
      sym__expression_list,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [3955] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    ACTIONS(248), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LBRACK,
    STATE(89), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(173), 1,
      sym_field,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4019] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(34), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(198), 1,
      sym__variable_assignment_explist,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4080] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(34), 1,
      sym_expression,
    STATE(118), 1,
      sym__variable_assignment_explist,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4141] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(34), 1,
      sym_expression,
    STATE(112), 1,
      sym__variable_assignment_explist,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4202] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(90), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4260] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(19), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4318] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(100), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4376] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(92), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4434] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(102), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4492] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(104), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4550] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(25), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4608] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(95), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4666] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(101), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4724] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(42), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4782] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(36), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4840] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(96), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4898] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(39), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4956] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(24), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5014] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(98), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5072] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(23), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5130] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(99), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5188] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(22), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5246] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(91), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5304] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(17), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5362] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(20), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5420] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(53), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5478] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(29), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5536] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(18), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5594] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(16), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5652] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(14), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5710] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(224), 1,
      anon_sym_function,
    ACTIONS(230), 1,
      anon_sym_LBRACE,
    ACTIONS(234), 1,
      anon_sym_not,
    STATE(28), 1,
      sym_expression,
    STATE(142), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(226), 3,
      sym_nil,
      sym_false,
      sym_true,
    ACTIONS(228), 3,
      sym_string,
      sym_number,
      sym_vararg_expression,
    ACTIONS(232), 3,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_POUND,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(31), 4,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5768] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_COLON,
    ACTIONS(266), 3,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
    ACTIONS(55), 5,
      sym_string,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(268), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [5804] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(270), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [5860] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(272), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [5916] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(274), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [5972] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(276), 1,
      anon_sym_COMMA,
    ACTIONS(278), 1,
      anon_sym_do,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6029] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(284), 1,
      anon_sym_COMMA,
    STATE(93), 1,
      aux_sym__variable_declaration_namelist_repeat1,
    ACTIONS(280), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(282), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6064] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_COMMA,
    STATE(93), 1,
      aux_sym__variable_declaration_namelist_repeat1,
    ACTIONS(287), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(289), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6099] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(293), 1,
      anon_sym_RPAREN,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6153] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(295), 1,
      anon_sym_COMMA,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(299), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6237] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_RBRACK,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6291] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(303), 1,
      anon_sym_then,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6345] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(305), 1,
      anon_sym_do,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6399] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(307), 1,
      anon_sym_do,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6453] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(309), 1,
      anon_sym_then,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6507] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_COMMA,
    STATE(94), 1,
      aux_sym__variable_declaration_namelist_repeat1,
    ACTIONS(311), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(313), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6541] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_TILDE,
    ACTIONS(95), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_SLASH,
    ACTIONS(105), 1,
      anon_sym_DOT_DOT,
    ACTIONS(107), 1,
      anon_sym_CARET,
    ACTIONS(113), 1,
      anon_sym_PIPE,
    ACTIONS(244), 1,
      anon_sym_or,
    ACTIONS(246), 1,
      anon_sym_and,
    ACTIONS(315), 1,
      anon_sym_RBRACK,
    ACTIONS(97), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(99), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(115), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(117), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6595] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      anon_sym_COMMA,
    STATE(106), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(317), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(319), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6628] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 1,
      anon_sym_COMMA,
    STATE(106), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(321), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(323), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6661] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 1,
      anon_sym_EQ,
    ACTIONS(328), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(330), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(336), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(338), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(340), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(344), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6772] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(346), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(348), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(350), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(352), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6826] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(266), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(268), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(356), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(360), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(362), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(364), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(366), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(368), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(372), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(376), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(380), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(384), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(388), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(392), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(396), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(400), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(404), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(408), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(412), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(416), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(420), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(422), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(424), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(428), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(432), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(434), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(436), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(438), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(442), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7466] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 1,
      anon_sym_else,
    ACTIONS(446), 1,
      anon_sym_COMMA,
    STATE(137), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(256), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [7487] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      sym_identifier,
    STATE(141), 1,
      sym_variable,
    STATE(149), 1,
      sym_method_index_expression,
    STATE(2), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(142), 3,
      sym__prefix_expression,
      sym_function_call,
      sym_parenthesized_expression,
  [7512] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 1,
      anon_sym_COMMA,
    ACTIONS(453), 1,
      anon_sym_else,
    STATE(137), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(451), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [7533] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      anon_sym_EQ,
    ACTIONS(457), 1,
      anon_sym_COMMA,
    STATE(174), 1,
      aux_sym__variable_assignment_varlist_repeat1,
    ACTIONS(55), 6,
      sym_string,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [7554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 2,
      anon_sym_EQ,
      anon_sym_COMMA,
    ACTIONS(55), 6,
      sym_string,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [7570] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_COLON,
    ACTIONS(465), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_LBRACK,
    ACTIONS(469), 1,
      anon_sym_LBRACE,
    ACTIONS(471), 1,
      sym_string,
    STATE(6), 1,
      sym_arguments,
    STATE(10), 1,
      sym_table_constructor,
  [7598] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      anon_sym_SEMI,
    ACTIONS(477), 1,
      anon_sym_else,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [7614] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      anon_sym_else,
    ACTIONS(479), 1,
      anon_sym_end,
    ACTIONS(481), 1,
      anon_sym_elseif,
    STATE(151), 1,
      aux_sym_if_statement_repeat1,
    STATE(168), 1,
      sym_elseif_statement,
    STATE(202), 1,
      sym_else_statement,
  [7636] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      anon_sym_else,
    ACTIONS(481), 1,
      anon_sym_elseif,
    ACTIONS(483), 1,
      anon_sym_end,
    STATE(144), 1,
      aux_sym_if_statement_repeat1,
    STATE(168), 1,
      sym_elseif_statement,
    STATE(183), 1,
      sym_else_statement,
  [7658] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      anon_sym_else,
    ACTIONS(481), 1,
      anon_sym_elseif,
    ACTIONS(485), 1,
      anon_sym_end,
    STATE(151), 1,
      aux_sym_if_statement_repeat1,
    STATE(168), 1,
      sym_elseif_statement,
    STATE(179), 1,
      sym_else_statement,
  [7680] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(260), 1,
      anon_sym_RBRACE,
    STATE(55), 1,
      sym__field_sep,
    STATE(154), 1,
      aux_sym__field_list_repeat1,
    ACTIONS(487), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [7697] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      sym__field_sep,
    STATE(147), 1,
      aux_sym__field_list_repeat1,
    ACTIONS(489), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [7714] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      anon_sym_LPAREN,
    ACTIONS(469), 1,
      anon_sym_LBRACE,
    ACTIONS(471), 1,
      sym_string,
    STATE(6), 1,
      sym_arguments,
    STATE(10), 1,
      sym_table_constructor,
  [7733] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 1,
      anon_sym_else,
    ACTIONS(493), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [7746] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 1,
      anon_sym_end,
    ACTIONS(499), 1,
      anon_sym_elseif,
    ACTIONS(502), 1,
      anon_sym_else,
    STATE(151), 1,
      aux_sym_if_statement_repeat1,
    STATE(168), 1,
      sym_elseif_statement,
  [7765] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 1,
      sym_identifier,
    STATE(161), 1,
      sym__function_name_dot_index_expression,
    STATE(166), 1,
      sym__function_name,
    STATE(167), 1,
      sym__function_name_prefix_expression,
    STATE(197), 1,
      sym__function_name_method_index_expression,
  [7784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 1,
      anon_sym_else,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [7797] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      anon_sym_RBRACE,
    STATE(57), 1,
      sym__field_sep,
    STATE(154), 1,
      aux_sym__field_list_repeat1,
    ACTIONS(506), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [7814] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 1,
      sym_identifier,
    ACTIONS(513), 1,
      sym_vararg_expression,
    ACTIONS(515), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym__parameter_list,
  [7830] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_COMMA,
    ACTIONS(311), 1,
      anon_sym_in,
    ACTIONS(517), 1,
      anon_sym_EQ,
    STATE(94), 1,
      aux_sym__variable_declaration_namelist_repeat1,
  [7846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(178), 1,
      anon_sym_else,
    ACTIONS(519), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [7858] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 1,
      sym_identifier,
    ACTIONS(523), 1,
      anon_sym_function,
    STATE(107), 1,
      sym__variable_declaration_namelist,
    STATE(129), 1,
      sym__local_variable_assignment,
  [7874] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      sym_identifier,
    STATE(200), 1,
      sym__variable_declaration_namelist,
    STATE(201), 2,
      sym_for_generic_clause,
      sym_for_numeric_clause,
  [7888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_else,
    ACTIONS(527), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [7900] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [7909] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [7918] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 1,
      anon_sym_LPAREN,
    STATE(30), 1,
      sym__function_body,
    STATE(41), 1,
      sym_parameters,
  [7931] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    ACTIONS(539), 1,
      anon_sym_RPAREN,
    STATE(170), 1,
      aux_sym__parameter_list_repeat1,
  [7944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_else,
    ACTIONS(541), 2,
      anon_sym_end,
      anon_sym_elseif,
  [7955] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 1,
      anon_sym_LPAREN,
    STATE(41), 1,
      sym_parameters,
    STATE(119), 1,
      sym__function_body,
  [7968] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(547), 1,
      anon_sym_COLON,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
  [7981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      anon_sym_else,
    ACTIONS(551), 2,
      anon_sym_end,
      anon_sym_elseif,
  [7992] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 1,
      anon_sym_COMMA,
    ACTIONS(558), 1,
      anon_sym_RPAREN,
    STATE(169), 1,
      aux_sym__parameter_list_repeat1,
  [8005] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(560), 1,
      anon_sym_COMMA,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    STATE(169), 1,
      aux_sym__parameter_list_repeat1,
  [8018] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(564), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [8027] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(566), 1,
      anon_sym_EQ,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    STATE(172), 1,
      aux_sym__variable_assignment_varlist_repeat1,
  [8040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [8049] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      anon_sym_COMMA,
    ACTIONS(571), 1,
      anon_sym_EQ,
    STATE(172), 1,
      aux_sym__variable_assignment_varlist_repeat1,
  [8062] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 1,
      anon_sym_LPAREN,
    STATE(41), 1,
      sym_parameters,
    STATE(121), 1,
      sym__function_body,
  [8075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(575), 1,
      sym_vararg_expression,
  [8085] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      sym_vararg_expression,
  [8095] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [8103] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 1,
      anon_sym_end,
  [8110] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_end,
  [8117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 1,
      anon_sym_end,
  [8124] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 1,
      sym_identifier,
  [8131] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      anon_sym_end,
  [8138] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(589), 1,
      sym_identifier,
  [8145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      sym_identifier,
  [8152] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      anon_sym_RBRACE,
  [8159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 1,
      anon_sym_LPAREN,
  [8166] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 1,
      ts_builtin_sym_end,
  [8173] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 1,
      anon_sym_end,
  [8180] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
  [8187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(603), 1,
      sym_identifier,
  [8194] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      sym_identifier,
  [8201] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_RPAREN,
  [8208] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      anon_sym_end,
  [8215] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_EQ,
  [8222] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 1,
      sym_identifier,
  [8229] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      anon_sym_LPAREN,
  [8236] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      anon_sym_do,
  [8243] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 1,
      anon_sym_end,
  [8250] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 1,
      anon_sym_in,
  [8257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_do,
  [8264] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_end,
  [8271] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      anon_sym_until,
  [8278] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 1,
      anon_sym_end,
  [8285] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 1,
      anon_sym_RPAREN,
  [8292] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      sym_identifier,
  [8299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_COLON_COLON,
  [8306] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      anon_sym_RPAREN,
  [8313] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_RPAREN,
  [8320] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      ts_builtin_sym_end,
  [8327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_EQ,
  [8334] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(216), 1,
      ts_builtin_sym_end,
  [8341] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      ts_builtin_sym_end,
  [8348] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 1,
      sym_identifier,
  [8355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 59,
  [SMALL_STATE(4)] = 118,
  [SMALL_STATE(5)] = 177,
  [SMALL_STATE(6)] = 239,
  [SMALL_STATE(7)] = 297,
  [SMALL_STATE(8)] = 355,
  [SMALL_STATE(9)] = 413,
  [SMALL_STATE(10)] = 471,
  [SMALL_STATE(11)] = 529,
  [SMALL_STATE(12)] = 587,
  [SMALL_STATE(13)] = 645,
  [SMALL_STATE(14)] = 698,
  [SMALL_STATE(15)] = 767,
  [SMALL_STATE(16)] = 820,
  [SMALL_STATE(17)] = 891,
  [SMALL_STATE(18)] = 946,
  [SMALL_STATE(19)] = 1021,
  [SMALL_STATE(20)] = 1098,
  [SMALL_STATE(21)] = 1163,
  [SMALL_STATE(22)] = 1280,
  [SMALL_STATE(23)] = 1343,
  [SMALL_STATE(24)] = 1402,
  [SMALL_STATE(25)] = 1457,
  [SMALL_STATE(26)] = 1512,
  [SMALL_STATE(27)] = 1565,
  [SMALL_STATE(28)] = 1618,
  [SMALL_STATE(29)] = 1685,
  [SMALL_STATE(30)] = 1748,
  [SMALL_STATE(31)] = 1801,
  [SMALL_STATE(32)] = 1854,
  [SMALL_STATE(33)] = 1954,
  [SMALL_STATE(34)] = 2056,
  [SMALL_STATE(35)] = 2136,
  [SMALL_STATE(36)] = 2240,
  [SMALL_STATE(37)] = 2315,
  [SMALL_STATE(38)] = 2417,
  [SMALL_STATE(39)] = 2519,
  [SMALL_STATE(40)] = 2593,
  [SMALL_STATE(41)] = 2695,
  [SMALL_STATE(42)] = 2797,
  [SMALL_STATE(43)] = 2871,
  [SMALL_STATE(44)] = 2973,
  [SMALL_STATE(45)] = 3075,
  [SMALL_STATE(46)] = 3174,
  [SMALL_STATE(47)] = 3273,
  [SMALL_STATE(48)] = 3372,
  [SMALL_STATE(49)] = 3445,
  [SMALL_STATE(50)] = 3486,
  [SMALL_STATE(51)] = 3554,
  [SMALL_STATE(52)] = 3624,
  [SMALL_STATE(53)] = 3694,
  [SMALL_STATE(54)] = 3757,
  [SMALL_STATE(55)] = 3824,
  [SMALL_STATE(56)] = 3891,
  [SMALL_STATE(57)] = 3955,
  [SMALL_STATE(58)] = 4019,
  [SMALL_STATE(59)] = 4080,
  [SMALL_STATE(60)] = 4141,
  [SMALL_STATE(61)] = 4202,
  [SMALL_STATE(62)] = 4260,
  [SMALL_STATE(63)] = 4318,
  [SMALL_STATE(64)] = 4376,
  [SMALL_STATE(65)] = 4434,
  [SMALL_STATE(66)] = 4492,
  [SMALL_STATE(67)] = 4550,
  [SMALL_STATE(68)] = 4608,
  [SMALL_STATE(69)] = 4666,
  [SMALL_STATE(70)] = 4724,
  [SMALL_STATE(71)] = 4782,
  [SMALL_STATE(72)] = 4840,
  [SMALL_STATE(73)] = 4898,
  [SMALL_STATE(74)] = 4956,
  [SMALL_STATE(75)] = 5014,
  [SMALL_STATE(76)] = 5072,
  [SMALL_STATE(77)] = 5130,
  [SMALL_STATE(78)] = 5188,
  [SMALL_STATE(79)] = 5246,
  [SMALL_STATE(80)] = 5304,
  [SMALL_STATE(81)] = 5362,
  [SMALL_STATE(82)] = 5420,
  [SMALL_STATE(83)] = 5478,
  [SMALL_STATE(84)] = 5536,
  [SMALL_STATE(85)] = 5594,
  [SMALL_STATE(86)] = 5652,
  [SMALL_STATE(87)] = 5710,
  [SMALL_STATE(88)] = 5768,
  [SMALL_STATE(89)] = 5804,
  [SMALL_STATE(90)] = 5860,
  [SMALL_STATE(91)] = 5916,
  [SMALL_STATE(92)] = 5972,
  [SMALL_STATE(93)] = 6029,
  [SMALL_STATE(94)] = 6064,
  [SMALL_STATE(95)] = 6099,
  [SMALL_STATE(96)] = 6153,
  [SMALL_STATE(97)] = 6207,
  [SMALL_STATE(98)] = 6237,
  [SMALL_STATE(99)] = 6291,
  [SMALL_STATE(100)] = 6345,
  [SMALL_STATE(101)] = 6399,
  [SMALL_STATE(102)] = 6453,
  [SMALL_STATE(103)] = 6507,
  [SMALL_STATE(104)] = 6541,
  [SMALL_STATE(105)] = 6595,
  [SMALL_STATE(106)] = 6628,
  [SMALL_STATE(107)] = 6661,
  [SMALL_STATE(108)] = 6691,
  [SMALL_STATE(109)] = 6718,
  [SMALL_STATE(110)] = 6745,
  [SMALL_STATE(111)] = 6772,
  [SMALL_STATE(112)] = 6799,
  [SMALL_STATE(113)] = 6826,
  [SMALL_STATE(114)] = 6853,
  [SMALL_STATE(115)] = 6880,
  [SMALL_STATE(116)] = 6907,
  [SMALL_STATE(117)] = 6934,
  [SMALL_STATE(118)] = 6961,
  [SMALL_STATE(119)] = 6988,
  [SMALL_STATE(120)] = 7015,
  [SMALL_STATE(121)] = 7042,
  [SMALL_STATE(122)] = 7069,
  [SMALL_STATE(123)] = 7096,
  [SMALL_STATE(124)] = 7123,
  [SMALL_STATE(125)] = 7150,
  [SMALL_STATE(126)] = 7177,
  [SMALL_STATE(127)] = 7204,
  [SMALL_STATE(128)] = 7231,
  [SMALL_STATE(129)] = 7258,
  [SMALL_STATE(130)] = 7285,
  [SMALL_STATE(131)] = 7312,
  [SMALL_STATE(132)] = 7339,
  [SMALL_STATE(133)] = 7366,
  [SMALL_STATE(134)] = 7393,
  [SMALL_STATE(135)] = 7420,
  [SMALL_STATE(136)] = 7443,
  [SMALL_STATE(137)] = 7466,
  [SMALL_STATE(138)] = 7487,
  [SMALL_STATE(139)] = 7512,
  [SMALL_STATE(140)] = 7533,
  [SMALL_STATE(141)] = 7554,
  [SMALL_STATE(142)] = 7570,
  [SMALL_STATE(143)] = 7598,
  [SMALL_STATE(144)] = 7614,
  [SMALL_STATE(145)] = 7636,
  [SMALL_STATE(146)] = 7658,
  [SMALL_STATE(147)] = 7680,
  [SMALL_STATE(148)] = 7697,
  [SMALL_STATE(149)] = 7714,
  [SMALL_STATE(150)] = 7733,
  [SMALL_STATE(151)] = 7746,
  [SMALL_STATE(152)] = 7765,
  [SMALL_STATE(153)] = 7784,
  [SMALL_STATE(154)] = 7797,
  [SMALL_STATE(155)] = 7814,
  [SMALL_STATE(156)] = 7830,
  [SMALL_STATE(157)] = 7846,
  [SMALL_STATE(158)] = 7858,
  [SMALL_STATE(159)] = 7874,
  [SMALL_STATE(160)] = 7888,
  [SMALL_STATE(161)] = 7900,
  [SMALL_STATE(162)] = 7909,
  [SMALL_STATE(163)] = 7918,
  [SMALL_STATE(164)] = 7931,
  [SMALL_STATE(165)] = 7944,
  [SMALL_STATE(166)] = 7955,
  [SMALL_STATE(167)] = 7968,
  [SMALL_STATE(168)] = 7981,
  [SMALL_STATE(169)] = 7992,
  [SMALL_STATE(170)] = 8005,
  [SMALL_STATE(171)] = 8018,
  [SMALL_STATE(172)] = 8027,
  [SMALL_STATE(173)] = 8040,
  [SMALL_STATE(174)] = 8049,
  [SMALL_STATE(175)] = 8062,
  [SMALL_STATE(176)] = 8075,
  [SMALL_STATE(177)] = 8085,
  [SMALL_STATE(178)] = 8095,
  [SMALL_STATE(179)] = 8103,
  [SMALL_STATE(180)] = 8110,
  [SMALL_STATE(181)] = 8117,
  [SMALL_STATE(182)] = 8124,
  [SMALL_STATE(183)] = 8131,
  [SMALL_STATE(184)] = 8138,
  [SMALL_STATE(185)] = 8145,
  [SMALL_STATE(186)] = 8152,
  [SMALL_STATE(187)] = 8159,
  [SMALL_STATE(188)] = 8166,
  [SMALL_STATE(189)] = 8173,
  [SMALL_STATE(190)] = 8180,
  [SMALL_STATE(191)] = 8187,
  [SMALL_STATE(192)] = 8194,
  [SMALL_STATE(193)] = 8201,
  [SMALL_STATE(194)] = 8208,
  [SMALL_STATE(195)] = 8215,
  [SMALL_STATE(196)] = 8222,
  [SMALL_STATE(197)] = 8229,
  [SMALL_STATE(198)] = 8236,
  [SMALL_STATE(199)] = 8243,
  [SMALL_STATE(200)] = 8250,
  [SMALL_STATE(201)] = 8257,
  [SMALL_STATE(202)] = 8264,
  [SMALL_STATE(203)] = 8271,
  [SMALL_STATE(204)] = 8278,
  [SMALL_STATE(205)] = 8285,
  [SMALL_STATE(206)] = 8292,
  [SMALL_STATE(207)] = 8299,
  [SMALL_STATE(208)] = 8306,
  [SMALL_STATE(209)] = 8313,
  [SMALL_STATE(210)] = 8320,
  [SMALL_STATE(211)] = 8327,
  [SMALL_STATE(212)] = 8334,
  [SMALL_STATE(213)] = 8341,
  [SMALL_STATE(214)] = 8348,
  [SMALL_STATE(215)] = 8355,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [39] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 17),
  [43] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 17),
  [45] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3, .production_id = 17),
  [47] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3, .production_id = 17),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [51] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefix_expression, 1),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_expression, 1),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 8),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 8),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 2),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 2),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 3),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 3),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 1),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 2, .production_id = 21),
  [87] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 2, .production_id = 21),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 22),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 3, .production_id = 29),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 3, .production_id = 29),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 12),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 12),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 2, .production_id = 10),
  [133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 2, .production_id = 10),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(2),
  [140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(120),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(182),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(113),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(214),
  [154] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(40),
  [157] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(63),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(37),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(65),
  [166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(159),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(152),
  [172] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(158),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(68),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 1),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 11),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 11),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 3, .production_id = 23),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 37),
  [192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 37),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 4, .production_id = 24),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 4, .production_id = 24),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 3, .production_id = 14),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 3, .production_id = 14),
  [210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 1),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 2),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 1),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 1),
  [224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 1),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 1),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 2),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 3),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1, .production_id = 11),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 43),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 30),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 5, .production_id = 42),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 20),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 20),
  [284] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 20), SHIFT_REPEAT(185),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration_namelist, 2, .production_id = 9),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_declaration_namelist, 2, .production_id = 9),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 19),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_declaration_namelist_repeat1, 2, .production_id = 19),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 7, .production_id = 45),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_declaration_namelist, 1, .production_id = 4),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_declaration_namelist, 1, .production_id = 4),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 28),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 28),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 38),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 38),
  [325] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 38), SHIFT_REPEAT(71),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2, .production_id = 7),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2, .production_id = 7),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_goto_statement, 2),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_goto_statement, 2),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 4, .production_id = 26),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 4, .production_id = 26),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 3, .production_id = 13),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 3, .production_id = 13),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, .production_id = 31),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, .production_id = 31),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3, .production_id = 16),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 3, .production_id = 16),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1, .production_id = 1),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1, .production_id = 1),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_label_statement, 3),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_label_statement, 3),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 2),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 2),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 16),
  [372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 16),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 3, .production_id = 15),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 3, .production_id = 15),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_empty_statement, 1),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_empty_statement, 1),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_function_declaration, 4, .production_id = 27),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_function_declaration, 4, .production_id = 27),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 33),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 33),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 32),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 32),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 34),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 34),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 44),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 44),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 23),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 23),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5, .production_id = 36),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5, .production_id = 36),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2),
  [418] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 39),
  [420] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 39),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 4, .production_id = 23),
  [424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 23),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 40),
  [428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 40),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 2),
  [432] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 2),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 41),
  [436] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 41),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 2),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 3),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3),
  [446] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2), SHIFT_REPEAT(82),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 2),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 2),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 1, .production_id = 4),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 19),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [477] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 1),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 35),
  [499] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 35), SHIFT_REPEAT(77),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 35),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [506] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2), SHIFT_REPEAT(57),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 1),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 2),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 2),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1, .production_id = 5),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_dot_index_expression, 3, .production_id = 17),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 1),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 4, .production_id = 32),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 4, .production_id = 32),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [549] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 25),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 25),
  [555] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__parameter_list_repeat1, 2), SHIFT_REPEAT(206),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__parameter_list_repeat1, 2),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 2),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_index_expression, 3, .production_id = 18),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 20),
  [568] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 20), SHIFT_REPEAT(138),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 2, .production_id = 9),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2, .production_id = 13),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [595] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_method_index_expression, 3, .production_id = 18),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 3),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 3),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1, .production_id = 6),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_generic_clause, 3, .production_id = 16),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 4),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [641] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_lua_external_scanner_create(void);
void tree_sitter_lua_external_scanner_destroy(void *);
bool tree_sitter_lua_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_lua_external_scanner_serialize(void *, char *);
void tree_sitter_lua_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_lua(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_lua_external_scanner_create,
      tree_sitter_lua_external_scanner_destroy,
      tree_sitter_lua_external_scanner_scan,
      tree_sitter_lua_external_scanner_serialize,
      tree_sitter_lua_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
