#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 313
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 123
#define ALIAS_COUNT 0
#define TOKEN_COUNT 60
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_schema = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_extend = 4,
  anon_sym_scalar = 5,
  anon_sym_type = 6,
  anon_sym_interface = 7,
  anon_sym_union = 8,
  anon_sym_enum = 9,
  anon_sym_input = 10,
  anon_sym_AMP = 11,
  anon_sym_implements = 12,
  anon_sym_COLON = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PIPE = 17,
  anon_sym_query = 18,
  anon_sym_mutation = 19,
  anon_sym_subscription = 20,
  anon_sym_DOLLAR = 21,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 22,
  aux_sym_string_value_token1 = 23,
  anon_sym_DQUOTE = 24,
  aux_sym_string_value_token2 = 25,
  sym_int_value = 26,
  sym_float_value = 27,
  anon_sym_true = 28,
  anon_sym_false = 29,
  sym_null_value = 30,
  anon_sym_LBRACK = 31,
  anon_sym_RBRACK = 32,
  anon_sym_on = 33,
  anon_sym_AT = 34,
  anon_sym_directive = 35,
  anon_sym_repeatable = 36,
  anon_sym_QUERY = 37,
  anon_sym_MUTATION = 38,
  anon_sym_SUBSCRIPTION = 39,
  anon_sym_FIELD = 40,
  anon_sym_FRAGMENT_DEFINITION = 41,
  anon_sym_FRAGMENT_SPREAD = 42,
  anon_sym_INLINE_FRAGMENT = 43,
  anon_sym_VARIABLE_DEFINITION = 44,
  anon_sym_SCHEMA = 45,
  anon_sym_SCALAR = 46,
  anon_sym_OBJECT = 47,
  anon_sym_FIELD_DEFINITION = 48,
  anon_sym_ARGUMENT_DEFINITION = 49,
  anon_sym_INTERFACE = 50,
  anon_sym_UNION = 51,
  anon_sym_ENUM = 52,
  anon_sym_ENUM_VALUE = 53,
  anon_sym_INPUT_OBJECT = 54,
  anon_sym_INPUT_FIELD_DEFINITION = 55,
  anon_sym_BANG = 56,
  sym_name = 57,
  sym_comment = 58,
  sym_comma = 59,
  sym_document = 60,
  sym_item = 61,
  sym_schema_definition = 62,
  sym_schema_extension = 63,
  sym_type_extension = 64,
  sym_scalar_type_extension = 65,
  sym_object_type_extension = 66,
  sym_interface_type_extension = 67,
  sym_union_type_extension = 68,
  sym_enum_type_extension = 69,
  sym_input_object_type_extension = 70,
  sym_input_fields_definition = 71,
  sym_enum_values_definition = 72,
  sym_enum_value_definition = 73,
  sym_implements_interfaces = 74,
  sym_fields_definition = 75,
  sym_field_definition = 76,
  sym_arguments_definition = 77,
  sym_input_value_definition = 78,
  sym_default_value = 79,
  sym_union_member_types = 80,
  sym_root_operation_type_definition = 81,
  sym_operation_type = 82,
  sym_type_definition = 83,
  sym_scalar_type_definition = 84,
  sym_object_type_definition = 85,
  sym_interface_type_definition = 86,
  sym_union_type_definition = 87,
  sym_enum_type_definition = 88,
  sym_input_object_type_definition = 89,
  sym_arguments = 90,
  sym_argument = 91,
  sym_value = 92,
  sym_variable = 93,
  sym_string_value = 94,
  sym_boolean_value = 95,
  sym_enum_value = 96,
  sym_list_value = 97,
  sym_object_value = 98,
  sym_object_field = 99,
  sym_directives = 100,
  sym_directive = 101,
  sym_directive_definition = 102,
  sym_directive_locations = 103,
  sym_directive_location = 104,
  sym_executable_directive_location = 105,
  sym_type_system_directive_location = 106,
  sym_type = 107,
  sym_named_type = 108,
  sym_list_type = 109,
  sym_non_null_type = 110,
  sym_description = 111,
  aux_sym_document_repeat1 = 112,
  aux_sym_schema_definition_repeat1 = 113,
  aux_sym_input_object_type_extension_repeat1 = 114,
  aux_sym_input_fields_definition_repeat1 = 115,
  aux_sym_enum_values_definition_repeat1 = 116,
  aux_sym_fields_definition_repeat1 = 117,
  aux_sym_union_member_types_repeat1 = 118,
  aux_sym_arguments_repeat1 = 119,
  aux_sym_list_value_repeat1 = 120,
  aux_sym_object_value_repeat1 = 121,
  aux_sym_directives_repeat1 = 122,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_schema] = "schema",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_extend] = "extend",
  [anon_sym_scalar] = "scalar",
  [anon_sym_type] = "type",
  [anon_sym_interface] = "interface",
  [anon_sym_union] = "union",
  [anon_sym_enum] = "enum",
  [anon_sym_input] = "input",
  [anon_sym_AMP] = "&",
  [anon_sym_implements] = "implements",
  [anon_sym_COLON] = ":",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PIPE] = "|",
  [anon_sym_query] = "query",
  [anon_sym_mutation] = "mutation",
  [anon_sym_subscription] = "subscription",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [aux_sym_string_value_token1] = "string_value_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_value_token2] = "string_value_token2",
  [sym_int_value] = "int_value",
  [sym_float_value] = "float_value",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_null_value] = "null_value",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_on] = "on",
  [anon_sym_AT] = "@",
  [anon_sym_directive] = "directive",
  [anon_sym_repeatable] = "repeatable",
  [anon_sym_QUERY] = "QUERY",
  [anon_sym_MUTATION] = "MUTATION",
  [anon_sym_SUBSCRIPTION] = "SUBSCRIPTION",
  [anon_sym_FIELD] = "FIELD",
  [anon_sym_FRAGMENT_DEFINITION] = "FRAGMENT_DEFINITION",
  [anon_sym_FRAGMENT_SPREAD] = "FRAGMENT_SPREAD",
  [anon_sym_INLINE_FRAGMENT] = "INLINE_FRAGMENT",
  [anon_sym_VARIABLE_DEFINITION] = "VARIABLE_DEFINITION",
  [anon_sym_SCHEMA] = "SCHEMA",
  [anon_sym_SCALAR] = "SCALAR",
  [anon_sym_OBJECT] = "OBJECT",
  [anon_sym_FIELD_DEFINITION] = "FIELD_DEFINITION",
  [anon_sym_ARGUMENT_DEFINITION] = "ARGUMENT_DEFINITION",
  [anon_sym_INTERFACE] = "INTERFACE",
  [anon_sym_UNION] = "UNION",
  [anon_sym_ENUM] = "ENUM",
  [anon_sym_ENUM_VALUE] = "ENUM_VALUE",
  [anon_sym_INPUT_OBJECT] = "INPUT_OBJECT",
  [anon_sym_INPUT_FIELD_DEFINITION] = "INPUT_FIELD_DEFINITION",
  [anon_sym_BANG] = "!",
  [sym_name] = "name",
  [sym_comment] = "comment",
  [sym_comma] = "comma",
  [sym_document] = "document",
  [sym_item] = "item",
  [sym_schema_definition] = "schema_definition",
  [sym_schema_extension] = "schema_extension",
  [sym_type_extension] = "type_extension",
  [sym_scalar_type_extension] = "scalar_type_extension",
  [sym_object_type_extension] = "object_type_extension",
  [sym_interface_type_extension] = "interface_type_extension",
  [sym_union_type_extension] = "union_type_extension",
  [sym_enum_type_extension] = "enum_type_extension",
  [sym_input_object_type_extension] = "input_object_type_extension",
  [sym_input_fields_definition] = "input_fields_definition",
  [sym_enum_values_definition] = "enum_values_definition",
  [sym_enum_value_definition] = "enum_value_definition",
  [sym_implements_interfaces] = "implements_interfaces",
  [sym_fields_definition] = "fields_definition",
  [sym_field_definition] = "field_definition",
  [sym_arguments_definition] = "arguments_definition",
  [sym_input_value_definition] = "input_value_definition",
  [sym_default_value] = "default_value",
  [sym_union_member_types] = "union_member_types",
  [sym_root_operation_type_definition] = "root_operation_type_definition",
  [sym_operation_type] = "operation_type",
  [sym_type_definition] = "type_definition",
  [sym_scalar_type_definition] = "scalar_type_definition",
  [sym_object_type_definition] = "object_type_definition",
  [sym_interface_type_definition] = "interface_type_definition",
  [sym_union_type_definition] = "union_type_definition",
  [sym_enum_type_definition] = "enum_type_definition",
  [sym_input_object_type_definition] = "input_object_type_definition",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_value] = "value",
  [sym_variable] = "variable",
  [sym_string_value] = "string_value",
  [sym_boolean_value] = "boolean_value",
  [sym_enum_value] = "enum_value",
  [sym_list_value] = "list_value",
  [sym_object_value] = "object_value",
  [sym_object_field] = "object_field",
  [sym_directives] = "directives",
  [sym_directive] = "directive",
  [sym_directive_definition] = "directive_definition",
  [sym_directive_locations] = "directive_locations",
  [sym_directive_location] = "directive_location",
  [sym_executable_directive_location] = "executable_directive_location",
  [sym_type_system_directive_location] = "type_system_directive_location",
  [sym_type] = "type",
  [sym_named_type] = "named_type",
  [sym_list_type] = "list_type",
  [sym_non_null_type] = "non_null_type",
  [sym_description] = "description",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_schema_definition_repeat1] = "schema_definition_repeat1",
  [aux_sym_input_object_type_extension_repeat1] = "input_object_type_extension_repeat1",
  [aux_sym_input_fields_definition_repeat1] = "input_fields_definition_repeat1",
  [aux_sym_enum_values_definition_repeat1] = "enum_values_definition_repeat1",
  [aux_sym_fields_definition_repeat1] = "fields_definition_repeat1",
  [aux_sym_union_member_types_repeat1] = "union_member_types_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_list_value_repeat1] = "list_value_repeat1",
  [aux_sym_object_value_repeat1] = "object_value_repeat1",
  [aux_sym_directives_repeat1] = "directives_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_schema] = anon_sym_schema,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_extend] = anon_sym_extend,
  [anon_sym_scalar] = anon_sym_scalar,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_input] = anon_sym_input,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_query] = anon_sym_query,
  [anon_sym_mutation] = anon_sym_mutation,
  [anon_sym_subscription] = anon_sym_subscription,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym_string_value_token1] = aux_sym_string_value_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_value_token2] = aux_sym_string_value_token2,
  [sym_int_value] = sym_int_value,
  [sym_float_value] = sym_float_value,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_null_value] = sym_null_value,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_directive] = anon_sym_directive,
  [anon_sym_repeatable] = anon_sym_repeatable,
  [anon_sym_QUERY] = anon_sym_QUERY,
  [anon_sym_MUTATION] = anon_sym_MUTATION,
  [anon_sym_SUBSCRIPTION] = anon_sym_SUBSCRIPTION,
  [anon_sym_FIELD] = anon_sym_FIELD,
  [anon_sym_FRAGMENT_DEFINITION] = anon_sym_FRAGMENT_DEFINITION,
  [anon_sym_FRAGMENT_SPREAD] = anon_sym_FRAGMENT_SPREAD,
  [anon_sym_INLINE_FRAGMENT] = anon_sym_INLINE_FRAGMENT,
  [anon_sym_VARIABLE_DEFINITION] = anon_sym_VARIABLE_DEFINITION,
  [anon_sym_SCHEMA] = anon_sym_SCHEMA,
  [anon_sym_SCALAR] = anon_sym_SCALAR,
  [anon_sym_OBJECT] = anon_sym_OBJECT,
  [anon_sym_FIELD_DEFINITION] = anon_sym_FIELD_DEFINITION,
  [anon_sym_ARGUMENT_DEFINITION] = anon_sym_ARGUMENT_DEFINITION,
  [anon_sym_INTERFACE] = anon_sym_INTERFACE,
  [anon_sym_UNION] = anon_sym_UNION,
  [anon_sym_ENUM] = anon_sym_ENUM,
  [anon_sym_ENUM_VALUE] = anon_sym_ENUM_VALUE,
  [anon_sym_INPUT_OBJECT] = anon_sym_INPUT_OBJECT,
  [anon_sym_INPUT_FIELD_DEFINITION] = anon_sym_INPUT_FIELD_DEFINITION,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_name] = sym_name,
  [sym_comment] = sym_comment,
  [sym_comma] = sym_comma,
  [sym_document] = sym_document,
  [sym_item] = sym_item,
  [sym_schema_definition] = sym_schema_definition,
  [sym_schema_extension] = sym_schema_extension,
  [sym_type_extension] = sym_type_extension,
  [sym_scalar_type_extension] = sym_scalar_type_extension,
  [sym_object_type_extension] = sym_object_type_extension,
  [sym_interface_type_extension] = sym_interface_type_extension,
  [sym_union_type_extension] = sym_union_type_extension,
  [sym_enum_type_extension] = sym_enum_type_extension,
  [sym_input_object_type_extension] = sym_input_object_type_extension,
  [sym_input_fields_definition] = sym_input_fields_definition,
  [sym_enum_values_definition] = sym_enum_values_definition,
  [sym_enum_value_definition] = sym_enum_value_definition,
  [sym_implements_interfaces] = sym_implements_interfaces,
  [sym_fields_definition] = sym_fields_definition,
  [sym_field_definition] = sym_field_definition,
  [sym_arguments_definition] = sym_arguments_definition,
  [sym_input_value_definition] = sym_input_value_definition,
  [sym_default_value] = sym_default_value,
  [sym_union_member_types] = sym_union_member_types,
  [sym_root_operation_type_definition] = sym_root_operation_type_definition,
  [sym_operation_type] = sym_operation_type,
  [sym_type_definition] = sym_type_definition,
  [sym_scalar_type_definition] = sym_scalar_type_definition,
  [sym_object_type_definition] = sym_object_type_definition,
  [sym_interface_type_definition] = sym_interface_type_definition,
  [sym_union_type_definition] = sym_union_type_definition,
  [sym_enum_type_definition] = sym_enum_type_definition,
  [sym_input_object_type_definition] = sym_input_object_type_definition,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_value] = sym_value,
  [sym_variable] = sym_variable,
  [sym_string_value] = sym_string_value,
  [sym_boolean_value] = sym_boolean_value,
  [sym_enum_value] = sym_enum_value,
  [sym_list_value] = sym_list_value,
  [sym_object_value] = sym_object_value,
  [sym_object_field] = sym_object_field,
  [sym_directives] = sym_directives,
  [sym_directive] = sym_directive,
  [sym_directive_definition] = sym_directive_definition,
  [sym_directive_locations] = sym_directive_locations,
  [sym_directive_location] = sym_directive_location,
  [sym_executable_directive_location] = sym_executable_directive_location,
  [sym_type_system_directive_location] = sym_type_system_directive_location,
  [sym_type] = sym_type,
  [sym_named_type] = sym_named_type,
  [sym_list_type] = sym_list_type,
  [sym_non_null_type] = sym_non_null_type,
  [sym_description] = sym_description,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_schema_definition_repeat1] = aux_sym_schema_definition_repeat1,
  [aux_sym_input_object_type_extension_repeat1] = aux_sym_input_object_type_extension_repeat1,
  [aux_sym_input_fields_definition_repeat1] = aux_sym_input_fields_definition_repeat1,
  [aux_sym_enum_values_definition_repeat1] = aux_sym_enum_values_definition_repeat1,
  [aux_sym_fields_definition_repeat1] = aux_sym_fields_definition_repeat1,
  [aux_sym_union_member_types_repeat1] = aux_sym_union_member_types_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_list_value_repeat1] = aux_sym_list_value_repeat1,
  [aux_sym_object_value_repeat1] = aux_sym_object_value_repeat1,
  [aux_sym_directives_repeat1] = aux_sym_directives_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_schema] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_scalar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_input] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_query] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_subscription] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_value_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_int_value] = {
    .visible = true,
    .named = true,
  },
  [sym_float_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_null_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_directive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeatable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QUERY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_MUTATION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUBSCRIPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FIELD] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FRAGMENT_DEFINITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FRAGMENT_SPREAD] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INLINE_FRAGMENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE_DEFINITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SCHEMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SCALAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBJECT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FIELD_DEFINITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ARGUMENT_DEFINITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INTERFACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENUM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENUM_VALUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INPUT_OBJECT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INPUT_FIELD_DEFINITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_item] = {
    .visible = true,
    .named = true,
  },
  [sym_schema_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_schema_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_input_object_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_input_fields_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_values_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_value_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_fields_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_input_value_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [sym_union_member_types] = {
    .visible = true,
    .named = true,
  },
  [sym_root_operation_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_input_object_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string_value] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_value] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_value] = {
    .visible = true,
    .named = true,
  },
  [sym_list_value] = {
    .visible = true,
    .named = true,
  },
  [sym_object_value] = {
    .visible = true,
    .named = true,
  },
  [sym_object_field] = {
    .visible = true,
    .named = true,
  },
  [sym_directives] = {
    .visible = true,
    .named = true,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_locations] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_location] = {
    .visible = true,
    .named = true,
  },
  [sym_executable_directive_location] = {
    .visible = true,
    .named = true,
  },
  [sym_type_system_directive_location] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_named_type] = {
    .visible = true,
    .named = true,
  },
  [sym_list_type] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_type] = {
    .visible = true,
    .named = true,
  },
  [sym_description] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_schema_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_input_object_type_extension_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_input_fields_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_values_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fields_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_member_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_directives_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(261);
      if (lookahead == '!') ADVANCE(327);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(341);
      if (lookahead == '$') ADVANCE(282);
      if (lookahead == '&') ADVANCE(272);
      if (lookahead == '(') ADVANCE(275);
      if (lookahead == ')') ADVANCE(276);
      if (lookahead == ',') ADVANCE(342);
      if (lookahead == '-') ADVANCE(6);
      if (lookahead == '0') ADVANCE(292);
      if (lookahead == ':') ADVANCE(274);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '@') ADVANCE(305);
      if (lookahead == 'A') ADVANCE(132);
      if (lookahead == 'E') ADVANCE(112);
      if (lookahead == 'F') ADVANCE(66);
      if (lookahead == 'I') ADVANCE(102);
      if (lookahead == 'M') ADVANCE(155);
      if (lookahead == 'O') ADVANCE(18);
      if (lookahead == 'Q') ADVANCE(157);
      if (lookahead == 'S') ADVANCE(22);
      if (lookahead == 'U') ADVANCE(103);
      if (lookahead == 'V') ADVANCE(8);
      if (lookahead == '[') ADVANCE(302);
      if (lookahead == ']') ADVANCE(303);
      if (lookahead == 'd') ADVANCE(200);
      if (lookahead == 'e') ADVANCE(222);
      if (lookahead == 'f') ADVANCE(169);
      if (lookahead == 'i') ADVANCE(212);
      if (lookahead == 'm') ADVANCE(251);
      if (lookahead == 'n') ADVANCE(252);
      if (lookahead == 'o') ADVANCE(216);
      if (lookahead == 'q') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(192);
      if (lookahead == 's') ADVANCE(179);
      if (lookahead == 't') ADVANCE(237);
      if (lookahead == 'u') ADVANCE(221);
      if (lookahead == '{') ADVANCE(263);
      if (lookahead == '|') ADVANCE(278);
      if (lookahead == '}') ADVANCE(264);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(327);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(341);
      if (lookahead == '&') ADVANCE(272);
      if (lookahead == '(') ADVANCE(275);
      if (lookahead == ')') ADVANCE(276);
      if (lookahead == ',') ADVANCE(342);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '@') ADVANCE(305);
      if (lookahead == '[') ADVANCE(302);
      if (lookahead == ']') ADVANCE(303);
      if (lookahead == '|') ADVANCE(278);
      if (lookahead == '}') ADVANCE(264);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 65279) SKIP(1)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(341);
      if (lookahead == '$') ADVANCE(282);
      if (lookahead == ',') ADVANCE(342);
      if (lookahead == '-') ADVANCE(6);
      if (lookahead == '0') ADVANCE(292);
      if (lookahead == '[') ADVANCE(302);
      if (lookahead == ']') ADVANCE(303);
      if (lookahead == 'f') ADVANCE(328);
      if (lookahead == 'n') ADVANCE(337);
      if (lookahead == 't') ADVANCE(334);
      if (lookahead == '{') ADVANCE(263);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 65279) SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(283);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(260);
      if (lookahead != 0) ADVANCE(286);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '#') ADVANCE(341);
      if (lookahead == ',') ADVANCE(342);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 65279) SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '0') ADVANCE(292);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 7:
      if (lookahead == 'A') ADVANCE(316);
      END_STATE();
    case 8:
      if (lookahead == 'A') ADVANCE(136);
      END_STATE();
    case 9:
      if (lookahead == 'A') ADVANCE(64);
      END_STATE();
    case 10:
      if (lookahead == 'A') ADVANCE(95);
      if (lookahead == 'H') ADVANCE(41);
      END_STATE();
    case 11:
      if (lookahead == 'A') ADVANCE(20);
      END_STATE();
    case 12:
      if (lookahead == 'A') ADVANCE(148);
      END_STATE();
    case 13:
      if (lookahead == 'A') ADVANCE(25);
      END_STATE();
    case 14:
      if (lookahead == 'A') ADVANCE(96);
      END_STATE();
    case 15:
      if (lookahead == 'A') ADVANCE(28);
      END_STATE();
    case 16:
      if (lookahead == 'A') ADVANCE(135);
      END_STATE();
    case 17:
      if (lookahead == 'A') ADVANCE(65);
      END_STATE();
    case 18:
      if (lookahead == 'B') ADVANCE(89);
      END_STATE();
    case 19:
      if (lookahead == 'B') ADVANCE(140);
      END_STATE();
    case 20:
      if (lookahead == 'B') ADVANCE(94);
      END_STATE();
    case 21:
      if (lookahead == 'B') ADVANCE(90);
      END_STATE();
    case 22:
      if (lookahead == 'C') ADVANCE(10);
      if (lookahead == 'U') ADVANCE(19);
      END_STATE();
    case 23:
      if (lookahead == 'C') ADVANCE(142);
      END_STATE();
    case 24:
      if (lookahead == 'C') ADVANCE(143);
      END_STATE();
    case 25:
      if (lookahead == 'C') ADVANCE(37);
      END_STATE();
    case 26:
      if (lookahead == 'C') ADVANCE(137);
      END_STATE();
    case 27:
      if (lookahead == 'D') ADVANCE(311);
      END_STATE();
    case 28:
      if (lookahead == 'D') ADVANCE(313);
      END_STATE();
    case 29:
      if (lookahead == 'D') ADVANCE(42);
      END_STATE();
    case 30:
      if (lookahead == 'D') ADVANCE(50);
      END_STATE();
    case 31:
      if (lookahead == 'D') ADVANCE(51);
      if (lookahead == 'S') ADVANCE(130);
      END_STATE();
    case 32:
      if (lookahead == 'D') ADVANCE(52);
      END_STATE();
    case 33:
      if (lookahead == 'D') ADVANCE(53);
      END_STATE();
    case 34:
      if (lookahead == 'D') ADVANCE(168);
      END_STATE();
    case 35:
      if (lookahead == 'E') ADVANCE(91);
      END_STATE();
    case 36:
      if (lookahead == 'E') ADVANCE(23);
      END_STATE();
    case 37:
      if (lookahead == 'E') ADVANCE(321);
      END_STATE();
    case 38:
      if (lookahead == 'E') ADVANCE(324);
      END_STATE();
    case 39:
      if (lookahead == 'E') ADVANCE(165);
      END_STATE();
    case 40:
      if (lookahead == 'E') ADVANCE(133);
      END_STATE();
    case 41:
      if (lookahead == 'E') ADVANCE(98);
      END_STATE();
    case 42:
      if (lookahead == 'E') ADVANCE(58);
      END_STATE();
    case 43:
      if (lookahead == 'E') ADVANCE(134);
      END_STATE();
    case 44:
      if (lookahead == 'E') ADVANCE(113);
      END_STATE();
    case 45:
      if (lookahead == 'E') ADVANCE(115);
      END_STATE();
    case 46:
      if (lookahead == 'E') ADVANCE(15);
      END_STATE();
    case 47:
      if (lookahead == 'E') ADVANCE(117);
      END_STATE();
    case 48:
      if (lookahead == 'E') ADVANCE(93);
      END_STATE();
    case 49:
      if (lookahead == 'E') ADVANCE(24);
      END_STATE();
    case 50:
      if (lookahead == 'E') ADVANCE(59);
      END_STATE();
    case 51:
      if (lookahead == 'E') ADVANCE(60);
      END_STATE();
    case 52:
      if (lookahead == 'E') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'E') ADVANCE(62);
      END_STATE();
    case 54:
      if (lookahead == 'E') ADVANCE(167);
      END_STATE();
    case 55:
      if (lookahead == 'F') ADVANCE(79);
      if (lookahead == 'O') ADVANCE(21);
      END_STATE();
    case 56:
      if (lookahead == 'F') ADVANCE(139);
      END_STATE();
    case 57:
      if (lookahead == 'F') ADVANCE(13);
      END_STATE();
    case 58:
      if (lookahead == 'F') ADVANCE(71);
      END_STATE();
    case 59:
      if (lookahead == 'F') ADVANCE(85);
      END_STATE();
    case 60:
      if (lookahead == 'F') ADVANCE(86);
      END_STATE();
    case 61:
      if (lookahead == 'F') ADVANCE(87);
      END_STATE();
    case 62:
      if (lookahead == 'F') ADVANCE(88);
      END_STATE();
    case 63:
      if (lookahead == 'G') ADVANCE(159);
      END_STATE();
    case 64:
      if (lookahead == 'G') ADVANCE(100);
      END_STATE();
    case 65:
      if (lookahead == 'G') ADVANCE(101);
      END_STATE();
    case 66:
      if (lookahead == 'I') ADVANCE(35);
      if (lookahead == 'R') ADVANCE(9);
      END_STATE();
    case 67:
      if (lookahead == 'I') ADVANCE(122);
      END_STATE();
    case 68:
      if (lookahead == 'I') ADVANCE(131);
      END_STATE();
    case 69:
      if (lookahead == 'I') ADVANCE(114);
      END_STATE();
    case 70:
      if (lookahead == 'I') ADVANCE(11);
      END_STATE();
    case 71:
      if (lookahead == 'I') ADVANCE(116);
      END_STATE();
    case 72:
      if (lookahead == 'I') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == 'I') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 'I') ADVANCE(125);
      END_STATE();
    case 75:
      if (lookahead == 'I') ADVANCE(126);
      END_STATE();
    case 76:
      if (lookahead == 'I') ADVANCE(127);
      END_STATE();
    case 77:
      if (lookahead == 'I') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == 'I') ADVANCE(129);
      END_STATE();
    case 79:
      if (lookahead == 'I') ADVANCE(48);
      END_STATE();
    case 80:
      if (lookahead == 'I') ADVANCE(150);
      END_STATE();
    case 81:
      if (lookahead == 'I') ADVANCE(151);
      END_STATE();
    case 82:
      if (lookahead == 'I') ADVANCE(152);
      END_STATE();
    case 83:
      if (lookahead == 'I') ADVANCE(153);
      END_STATE();
    case 84:
      if (lookahead == 'I') ADVANCE(154);
      END_STATE();
    case 85:
      if (lookahead == 'I') ADVANCE(118);
      END_STATE();
    case 86:
      if (lookahead == 'I') ADVANCE(119);
      END_STATE();
    case 87:
      if (lookahead == 'I') ADVANCE(120);
      END_STATE();
    case 88:
      if (lookahead == 'I') ADVANCE(121);
      END_STATE();
    case 89:
      if (lookahead == 'J') ADVANCE(36);
      END_STATE();
    case 90:
      if (lookahead == 'J') ADVANCE(49);
      END_STATE();
    case 91:
      if (lookahead == 'L') ADVANCE(27);
      END_STATE();
    case 92:
      if (lookahead == 'L') ADVANCE(69);
      if (lookahead == 'P') ADVANCE(158);
      if (lookahead == 'T') ADVANCE(43);
      END_STATE();
    case 93:
      if (lookahead == 'L') ADVANCE(34);
      END_STATE();
    case 94:
      if (lookahead == 'L') ADVANCE(54);
      END_STATE();
    case 95:
      if (lookahead == 'L') ADVANCE(16);
      END_STATE();
    case 96:
      if (lookahead == 'L') ADVANCE(160);
      END_STATE();
    case 97:
      if (lookahead == 'M') ADVANCE(323);
      END_STATE();
    case 98:
      if (lookahead == 'M') ADVANCE(7);
      END_STATE();
    case 99:
      if (lookahead == 'M') ADVANCE(44);
      END_STATE();
    case 100:
      if (lookahead == 'M') ADVANCE(45);
      END_STATE();
    case 101:
      if (lookahead == 'M') ADVANCE(47);
      END_STATE();
    case 102:
      if (lookahead == 'N') ADVANCE(92);
      END_STATE();
    case 103:
      if (lookahead == 'N') ADVANCE(67);
      END_STATE();
    case 104:
      if (lookahead == 'N') ADVANCE(322);
      END_STATE();
    case 105:
      if (lookahead == 'N') ADVANCE(309);
      END_STATE();
    case 106:
      if (lookahead == 'N') ADVANCE(310);
      END_STATE();
    case 107:
      if (lookahead == 'N') ADVANCE(319);
      END_STATE();
    case 108:
      if (lookahead == 'N') ADVANCE(320);
      END_STATE();
    case 109:
      if (lookahead == 'N') ADVANCE(312);
      END_STATE();
    case 110:
      if (lookahead == 'N') ADVANCE(315);
      END_STATE();
    case 111:
      if (lookahead == 'N') ADVANCE(326);
      END_STATE();
    case 112:
      if (lookahead == 'N') ADVANCE(156);
      END_STATE();
    case 113:
      if (lookahead == 'N') ADVANCE(146);
      END_STATE();
    case 114:
      if (lookahead == 'N') ADVANCE(39);
      END_STATE();
    case 115:
      if (lookahead == 'N') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'N') ADVANCE(80);
      END_STATE();
    case 117:
      if (lookahead == 'N') ADVANCE(144);
      END_STATE();
    case 118:
      if (lookahead == 'N') ADVANCE(81);
      END_STATE();
    case 119:
      if (lookahead == 'N') ADVANCE(82);
      END_STATE();
    case 120:
      if (lookahead == 'N') ADVANCE(83);
      END_STATE();
    case 121:
      if (lookahead == 'N') ADVANCE(84);
      END_STATE();
    case 122:
      if (lookahead == 'O') ADVANCE(104);
      END_STATE();
    case 123:
      if (lookahead == 'O') ADVANCE(105);
      END_STATE();
    case 124:
      if (lookahead == 'O') ADVANCE(106);
      END_STATE();
    case 125:
      if (lookahead == 'O') ADVANCE(107);
      END_STATE();
    case 126:
      if (lookahead == 'O') ADVANCE(108);
      END_STATE();
    case 127:
      if (lookahead == 'O') ADVANCE(109);
      END_STATE();
    case 128:
      if (lookahead == 'O') ADVANCE(110);
      END_STATE();
    case 129:
      if (lookahead == 'O') ADVANCE(111);
      END_STATE();
    case 130:
      if (lookahead == 'P') ADVANCE(138);
      END_STATE();
    case 131:
      if (lookahead == 'P') ADVANCE(149);
      END_STATE();
    case 132:
      if (lookahead == 'R') ADVANCE(63);
      END_STATE();
    case 133:
      if (lookahead == 'R') ADVANCE(162);
      END_STATE();
    case 134:
      if (lookahead == 'R') ADVANCE(57);
      END_STATE();
    case 135:
      if (lookahead == 'R') ADVANCE(317);
      END_STATE();
    case 136:
      if (lookahead == 'R') ADVANCE(70);
      END_STATE();
    case 137:
      if (lookahead == 'R') ADVANCE(68);
      END_STATE();
    case 138:
      if (lookahead == 'R') ADVANCE(46);
      END_STATE();
    case 139:
      if (lookahead == 'R') ADVANCE(17);
      END_STATE();
    case 140:
      if (lookahead == 'S') ADVANCE(26);
      END_STATE();
    case 141:
      if (lookahead == 'T') ADVANCE(163);
      END_STATE();
    case 142:
      if (lookahead == 'T') ADVANCE(318);
      END_STATE();
    case 143:
      if (lookahead == 'T') ADVANCE(325);
      END_STATE();
    case 144:
      if (lookahead == 'T') ADVANCE(314);
      END_STATE();
    case 145:
      if (lookahead == 'T') ADVANCE(12);
      END_STATE();
    case 146:
      if (lookahead == 'T') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'T') ADVANCE(164);
      END_STATE();
    case 148:
      if (lookahead == 'T') ADVANCE(72);
      END_STATE();
    case 149:
      if (lookahead == 'T') ADVANCE(73);
      END_STATE();
    case 150:
      if (lookahead == 'T') ADVANCE(74);
      END_STATE();
    case 151:
      if (lookahead == 'T') ADVANCE(75);
      END_STATE();
    case 152:
      if (lookahead == 'T') ADVANCE(76);
      END_STATE();
    case 153:
      if (lookahead == 'T') ADVANCE(77);
      END_STATE();
    case 154:
      if (lookahead == 'T') ADVANCE(78);
      END_STATE();
    case 155:
      if (lookahead == 'U') ADVANCE(145);
      END_STATE();
    case 156:
      if (lookahead == 'U') ADVANCE(97);
      END_STATE();
    case 157:
      if (lookahead == 'U') ADVANCE(40);
      END_STATE();
    case 158:
      if (lookahead == 'U') ADVANCE(141);
      END_STATE();
    case 159:
      if (lookahead == 'U') ADVANCE(99);
      END_STATE();
    case 160:
      if (lookahead == 'U') ADVANCE(38);
      END_STATE();
    case 161:
      if (lookahead == 'V') ADVANCE(14);
      END_STATE();
    case 162:
      if (lookahead == 'Y') ADVANCE(308);
      END_STATE();
    case 163:
      if (lookahead == '_') ADVANCE(55);
      END_STATE();
    case 164:
      if (lookahead == '_') ADVANCE(31);
      END_STATE();
    case 165:
      if (lookahead == '_') ADVANCE(56);
      END_STATE();
    case 166:
      if (lookahead == '_') ADVANCE(30);
      END_STATE();
    case 167:
      if (lookahead == '_') ADVANCE(32);
      END_STATE();
    case 168:
      if (lookahead == '_') ADVANCE(33);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(206);
      END_STATE();
    case 170:
      if (lookahead == 'a') ADVANCE(262);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(178);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 173:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(247);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(208);
      if (lookahead == 'h') ADVANCE(193);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(246);
      END_STATE();
    case 177:
      if (lookahead == 'b') ADVANCE(239);
      END_STATE();
    case 178:
      if (lookahead == 'b') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'c') ADVANCE(175);
      if (lookahead == 'u') ADVANCE(177);
      END_STATE();
    case 180:
      if (lookahead == 'c') ADVANCE(236);
      END_STATE();
    case 181:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 182:
      if (lookahead == 'c') ADVANCE(189);
      END_STATE();
    case 183:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(298);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(306);
      END_STATE();
    case 189:
      if (lookahead == 'e') ADVANCE(268);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(307);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 199:
      if (lookahead == 'f') ADVANCE(172);
      END_STATE();
    case 200:
      if (lookahead == 'i') ADVANCE(235);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(224);
      END_STATE();
    case 202:
      if (lookahead == 'i') ADVANCE(255);
      END_STATE();
    case 203:
      if (lookahead == 'i') ADVANCE(231);
      END_STATE();
    case 204:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 206:
      if (lookahead == 'l') ADVANCE(240);
      END_STATE();
    case 207:
      if (lookahead == 'l') ADVANCE(300);
      END_STATE();
    case 208:
      if (lookahead == 'l') ADVANCE(173);
      END_STATE();
    case 209:
      if (lookahead == 'l') ADVANCE(207);
      END_STATE();
    case 210:
      if (lookahead == 'l') ADVANCE(196);
      END_STATE();
    case 211:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 212:
      if (lookahead == 'm') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 213:
      if (lookahead == 'm') ADVANCE(270);
      END_STATE();
    case 214:
      if (lookahead == 'm') ADVANCE(170);
      END_STATE();
    case 215:
      if (lookahead == 'm') ADVANCE(197);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(304);
      END_STATE();
    case 217:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 218:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 219:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(281);
      END_STATE();
    case 221:
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(249);
      if (lookahead == 'x') ADVANCE(245);
      END_STATE();
    case 223:
      if (lookahead == 'n') ADVANCE(244);
      END_STATE();
    case 224:
      if (lookahead == 'o') ADVANCE(218);
      END_STATE();
    case 225:
      if (lookahead == 'o') ADVANCE(219);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(220);
      END_STATE();
    case 227:
      if (lookahead == 'p') ADVANCE(210);
      END_STATE();
    case 228:
      if (lookahead == 'p') ADVANCE(198);
      END_STATE();
    case 229:
      if (lookahead == 'p') ADVANCE(186);
      END_STATE();
    case 230:
      if (lookahead == 'p') ADVANCE(253);
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 231:
      if (lookahead == 'p') ADVANCE(248);
      END_STATE();
    case 232:
      if (lookahead == 'r') ADVANCE(256);
      END_STATE();
    case 233:
      if (lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 234:
      if (lookahead == 'r') ADVANCE(266);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 236:
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 237:
      if (lookahead == 'r') ADVANCE(254);
      if (lookahead == 'y') ADVANCE(229);
      END_STATE();
    case 238:
      if (lookahead == 's') ADVANCE(273);
      END_STATE();
    case 239:
      if (lookahead == 's') ADVANCE(180);
      END_STATE();
    case 240:
      if (lookahead == 's') ADVANCE(187);
      END_STATE();
    case 241:
      if (lookahead == 't') ADVANCE(271);
      END_STATE();
    case 242:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 244:
      if (lookahead == 't') ADVANCE(238);
      END_STATE();
    case 245:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 246:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 247:
      if (lookahead == 't') ADVANCE(204);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 249:
      if (lookahead == 'u') ADVANCE(213);
      END_STATE();
    case 250:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 251:
      if (lookahead == 'u') ADVANCE(242);
      END_STATE();
    case 252:
      if (lookahead == 'u') ADVANCE(209);
      END_STATE();
    case 253:
      if (lookahead == 'u') ADVANCE(241);
      END_STATE();
    case 254:
      if (lookahead == 'u') ADVANCE(185);
      END_STATE();
    case 255:
      if (lookahead == 'v') ADVANCE(188);
      END_STATE();
    case 256:
      if (lookahead == 'y') ADVANCE(279);
      END_STATE();
    case 257:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      END_STATE();
    case 258:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(294);
      END_STATE();
    case 259:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      END_STATE();
    case 260:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(286);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_schema);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_extend);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_scalar);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_input);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_query);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_mutation);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_subscription);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '\n') ADVANCE(286);
      if (lookahead == '"') ADVANCE(340);
      if (lookahead != 0) ADVANCE(284);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 65279) ADVANCE(285);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '#') ADVANCE(284);
      if (lookahead == ',') ADVANCE(344);
      if (lookahead != 0) ADVANCE(286);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(286);
      if (lookahead == '"') ADVANCE(4);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(3);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '#') ADVANCE(290);
      if (lookahead == ',') ADVANCE(343);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 65279) ADVANCE(289);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_int_value);
      if (lookahead == '.') ADVANCE(258);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_int_value);
      if (lookahead == '.') ADVANCE(258);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_float_value);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(294);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_float_value);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(295);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_null_value);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_null_value);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_directive);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_repeatable);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_QUERY);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_MUTATION);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_SUBSCRIPTION);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_FIELD);
      if (lookahead == '_') ADVANCE(29);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_FRAGMENT_DEFINITION);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_FRAGMENT_SPREAD);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_INLINE_FRAGMENT);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_VARIABLE_DEFINITION);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_SCHEMA);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_SCALAR);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_OBJECT);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_FIELD_DEFINITION);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_ARGUMENT_DEFINITION);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_INTERFACE);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_UNION);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_ENUM);
      if (lookahead == '_') ADVANCE(161);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_ENUM_VALUE);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_INPUT_OBJECT);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_INPUT_FIELD_DEFINITION);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(338);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(286);
      if (lookahead == '"') ADVANCE(341);
      if (lookahead != 0) ADVANCE(284);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(286);
      if (lookahead == '"') ADVANCE(339);
      if (lookahead != 0) ADVANCE(284);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(341);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_comma);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(291);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_comma);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(286);
      if (lookahead == '"') ADVANCE(4);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 289},
  [251] = {.lex_state = 285},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 5},
  [291] = {.lex_state = 5},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 5},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 5},
  [306] = {.lex_state = 285},
  [307] = {.lex_state = 289},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 285},
  [310] = {.lex_state = 289},
  [311] = {.lex_state = 285},
  [312] = {.lex_state = 289},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_schema] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_extend] = ACTIONS(1),
    [anon_sym_scalar] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_input] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_query] = ACTIONS(1),
    [anon_sym_mutation] = ACTIONS(1),
    [anon_sym_subscription] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_int_value] = ACTIONS(1),
    [sym_float_value] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_null_value] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_directive] = ACTIONS(1),
    [anon_sym_repeatable] = ACTIONS(1),
    [anon_sym_QUERY] = ACTIONS(1),
    [anon_sym_MUTATION] = ACTIONS(1),
    [anon_sym_SUBSCRIPTION] = ACTIONS(1),
    [anon_sym_FIELD] = ACTIONS(1),
    [anon_sym_FRAGMENT_DEFINITION] = ACTIONS(1),
    [anon_sym_FRAGMENT_SPREAD] = ACTIONS(1),
    [anon_sym_INLINE_FRAGMENT] = ACTIONS(1),
    [anon_sym_VARIABLE_DEFINITION] = ACTIONS(1),
    [anon_sym_SCHEMA] = ACTIONS(1),
    [anon_sym_SCALAR] = ACTIONS(1),
    [anon_sym_OBJECT] = ACTIONS(1),
    [anon_sym_FIELD_DEFINITION] = ACTIONS(1),
    [anon_sym_ARGUMENT_DEFINITION] = ACTIONS(1),
    [anon_sym_INTERFACE] = ACTIONS(1),
    [anon_sym_UNION] = ACTIONS(1),
    [anon_sym_ENUM] = ACTIONS(1),
    [anon_sym_ENUM_VALUE] = ACTIONS(1),
    [anon_sym_INPUT_OBJECT] = ACTIONS(1),
    [anon_sym_INPUT_FIELD_DEFINITION] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(3),
  },
  [1] = {
    [sym_document] = STATE(282),
    [sym_item] = STATE(3),
    [sym_schema_definition] = STATE(131),
    [sym_schema_extension] = STATE(131),
    [sym_type_extension] = STATE(131),
    [sym_scalar_type_extension] = STATE(128),
    [sym_object_type_extension] = STATE(128),
    [sym_interface_type_extension] = STATE(128),
    [sym_union_type_extension] = STATE(128),
    [sym_enum_type_extension] = STATE(128),
    [sym_input_object_type_extension] = STATE(128),
    [sym_type_definition] = STATE(131),
    [sym_scalar_type_definition] = STATE(121),
    [sym_object_type_definition] = STATE(121),
    [sym_interface_type_definition] = STATE(121),
    [sym_union_type_definition] = STATE(121),
    [sym_enum_type_definition] = STATE(121),
    [sym_input_object_type_definition] = STATE(121),
    [sym_string_value] = STATE(146),
    [sym_directive_definition] = STATE(131),
    [sym_description] = STATE(147),
    [aux_sym_document_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_schema] = ACTIONS(7),
    [anon_sym_extend] = ACTIONS(9),
    [anon_sym_scalar] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_interface] = ACTIONS(15),
    [anon_sym_union] = ACTIONS(17),
    [anon_sym_enum] = ACTIONS(19),
    [anon_sym_input] = ACTIONS(21),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(23),
    [anon_sym_DQUOTE] = ACTIONS(25),
    [anon_sym_directive] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 19,
    ACTIONS(29), 1,
      ts_builtin_sym_end,
    ACTIONS(31), 1,
      anon_sym_schema,
    ACTIONS(34), 1,
      anon_sym_extend,
    ACTIONS(37), 1,
      anon_sym_scalar,
    ACTIONS(40), 1,
      anon_sym_type,
    ACTIONS(43), 1,
      anon_sym_interface,
    ACTIONS(46), 1,
      anon_sym_union,
    ACTIONS(49), 1,
      anon_sym_enum,
    ACTIONS(52), 1,
      anon_sym_input,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(58), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      anon_sym_directive,
    STATE(146), 1,
      sym_string_value,
    STATE(147), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(2), 2,
      sym_item,
      aux_sym_document_repeat1,
    STATE(131), 5,
      sym_schema_definition,
      sym_schema_extension,
      sym_type_extension,
      sym_type_definition,
      sym_directive_definition,
    STATE(121), 6,
      sym_scalar_type_definition,
      sym_object_type_definition,
      sym_interface_type_definition,
      sym_union_type_definition,
      sym_enum_type_definition,
      sym_input_object_type_definition,
    STATE(128), 6,
      sym_scalar_type_extension,
      sym_object_type_extension,
      sym_interface_type_extension,
      sym_union_type_extension,
      sym_enum_type_extension,
      sym_input_object_type_extension,
  [74] = 19,
    ACTIONS(7), 1,
      anon_sym_schema,
    ACTIONS(9), 1,
      anon_sym_extend,
    ACTIONS(11), 1,
      anon_sym_scalar,
    ACTIONS(13), 1,
      anon_sym_type,
    ACTIONS(15), 1,
      anon_sym_interface,
    ACTIONS(17), 1,
      anon_sym_union,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_input,
    ACTIONS(23), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_directive,
    ACTIONS(64), 1,
      ts_builtin_sym_end,
    STATE(146), 1,
      sym_string_value,
    STATE(147), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(2), 2,
      sym_item,
      aux_sym_document_repeat1,
    STATE(131), 5,
      sym_schema_definition,
      sym_schema_extension,
      sym_type_extension,
      sym_type_definition,
      sym_directive_definition,
    STATE(121), 6,
      sym_scalar_type_definition,
      sym_object_type_definition,
      sym_interface_type_definition,
      sym_union_type_definition,
      sym_enum_type_definition,
      sym_input_object_type_definition,
    STATE(128), 6,
      sym_scalar_type_extension,
      sym_object_type_extension,
      sym_interface_type_extension,
      sym_union_type_extension,
      sym_enum_type_extension,
      sym_input_object_type_extension,
  [148] = 9,
    ACTIONS(66), 1,
      anon_sym_PIPE,
    ACTIONS(70), 1,
      anon_sym_FIELD,
    ACTIONS(74), 1,
      anon_sym_ENUM,
    STATE(73), 1,
      sym_directive_location,
    STATE(74), 1,
      sym_directive_locations,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(72), 2,
      sym_executable_directive_location,
      sym_type_system_directive_location,
    ACTIONS(68), 7,
      anon_sym_QUERY,
      anon_sym_MUTATION,
      anon_sym_SUBSCRIPTION,
      anon_sym_FRAGMENT_DEFINITION,
      anon_sym_FRAGMENT_SPREAD,
      anon_sym_INLINE_FRAGMENT,
      anon_sym_VARIABLE_DEFINITION,
    ACTIONS(72), 10,
      anon_sym_SCHEMA,
      anon_sym_SCALAR,
      anon_sym_OBJECT,
      anon_sym_FIELD_DEFINITION,
      anon_sym_ARGUMENT_DEFINITION,
      anon_sym_INTERFACE,
      anon_sym_UNION,
      anon_sym_ENUM_VALUE,
      anon_sym_INPUT_OBJECT,
      anon_sym_INPUT_FIELD_DEFINITION,
  [193] = 9,
    ACTIONS(66), 1,
      anon_sym_PIPE,
    ACTIONS(70), 1,
      anon_sym_FIELD,
    ACTIONS(74), 1,
      anon_sym_ENUM,
    STATE(73), 1,
      sym_directive_location,
    STATE(79), 1,
      sym_directive_locations,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(72), 2,
      sym_executable_directive_location,
      sym_type_system_directive_location,
    ACTIONS(68), 7,
      anon_sym_QUERY,
      anon_sym_MUTATION,
      anon_sym_SUBSCRIPTION,
      anon_sym_FRAGMENT_DEFINITION,
      anon_sym_FRAGMENT_SPREAD,
      anon_sym_INLINE_FRAGMENT,
      anon_sym_VARIABLE_DEFINITION,
    ACTIONS(72), 10,
      anon_sym_SCHEMA,
      anon_sym_SCALAR,
      anon_sym_OBJECT,
      anon_sym_FIELD_DEFINITION,
      anon_sym_ARGUMENT_DEFINITION,
      anon_sym_INTERFACE,
      anon_sym_UNION,
      anon_sym_ENUM_VALUE,
      anon_sym_INPUT_OBJECT,
      anon_sym_INPUT_FIELD_DEFINITION,
  [238] = 9,
    ACTIONS(66), 1,
      anon_sym_PIPE,
    ACTIONS(70), 1,
      anon_sym_FIELD,
    ACTIONS(74), 1,
      anon_sym_ENUM,
    STATE(73), 1,
      sym_directive_location,
    STATE(82), 1,
      sym_directive_locations,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(72), 2,
      sym_executable_directive_location,
      sym_type_system_directive_location,
    ACTIONS(68), 7,
      anon_sym_QUERY,
      anon_sym_MUTATION,
      anon_sym_SUBSCRIPTION,
      anon_sym_FRAGMENT_DEFINITION,
      anon_sym_FRAGMENT_SPREAD,
      anon_sym_INLINE_FRAGMENT,
      anon_sym_VARIABLE_DEFINITION,
    ACTIONS(72), 10,
      anon_sym_SCHEMA,
      anon_sym_SCALAR,
      anon_sym_OBJECT,
      anon_sym_FIELD_DEFINITION,
      anon_sym_ARGUMENT_DEFINITION,
      anon_sym_INTERFACE,
      anon_sym_UNION,
      anon_sym_ENUM_VALUE,
      anon_sym_INPUT_OBJECT,
      anon_sym_INPUT_FIELD_DEFINITION,
  [283] = 9,
    ACTIONS(66), 1,
      anon_sym_PIPE,
    ACTIONS(70), 1,
      anon_sym_FIELD,
    ACTIONS(74), 1,
      anon_sym_ENUM,
    STATE(73), 1,
      sym_directive_location,
    STATE(80), 1,
      sym_directive_locations,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(72), 2,
      sym_executable_directive_location,
      sym_type_system_directive_location,
    ACTIONS(68), 7,
      anon_sym_QUERY,
      anon_sym_MUTATION,
      anon_sym_SUBSCRIPTION,
      anon_sym_FRAGMENT_DEFINITION,
      anon_sym_FRAGMENT_SPREAD,
      anon_sym_INLINE_FRAGMENT,
      anon_sym_VARIABLE_DEFINITION,
    ACTIONS(72), 10,
      anon_sym_SCHEMA,
      anon_sym_SCALAR,
      anon_sym_OBJECT,
      anon_sym_FIELD_DEFINITION,
      anon_sym_ARGUMENT_DEFINITION,
      anon_sym_INTERFACE,
      anon_sym_UNION,
      anon_sym_ENUM_VALUE,
      anon_sym_INPUT_OBJECT,
      anon_sym_INPUT_FIELD_DEFINITION,
  [328] = 7,
    ACTIONS(70), 1,
      anon_sym_FIELD,
    ACTIONS(74), 1,
      anon_sym_ENUM,
    STATE(75), 1,
      sym_directive_location,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(72), 2,
      sym_executable_directive_location,
      sym_type_system_directive_location,
    ACTIONS(68), 7,
      anon_sym_QUERY,
      anon_sym_MUTATION,
      anon_sym_SUBSCRIPTION,
      anon_sym_FRAGMENT_DEFINITION,
      anon_sym_FRAGMENT_SPREAD,
      anon_sym_INLINE_FRAGMENT,
      anon_sym_VARIABLE_DEFINITION,
    ACTIONS(72), 10,
      anon_sym_SCHEMA,
      anon_sym_SCALAR,
      anon_sym_OBJECT,
      anon_sym_FIELD_DEFINITION,
      anon_sym_ARGUMENT_DEFINITION,
      anon_sym_INTERFACE,
      anon_sym_UNION,
      anon_sym_ENUM_VALUE,
      anon_sym_INPUT_OBJECT,
      anon_sym_INPUT_FIELD_DEFINITION,
  [367] = 3,
    ACTIONS(78), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(76), 21,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_directive,
      anon_sym_BANG,
  [398] = 7,
    ACTIONS(70), 1,
      anon_sym_FIELD,
    ACTIONS(74), 1,
      anon_sym_ENUM,
    STATE(81), 1,
      sym_directive_location,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(72), 2,
      sym_executable_directive_location,
      sym_type_system_directive_location,
    ACTIONS(68), 7,
      anon_sym_QUERY,
      anon_sym_MUTATION,
      anon_sym_SUBSCRIPTION,
      anon_sym_FRAGMENT_DEFINITION,
      anon_sym_FRAGMENT_SPREAD,
      anon_sym_INLINE_FRAGMENT,
      anon_sym_VARIABLE_DEFINITION,
    ACTIONS(72), 10,
      anon_sym_SCHEMA,
      anon_sym_SCALAR,
      anon_sym_OBJECT,
      anon_sym_FIELD_DEFINITION,
      anon_sym_ARGUMENT_DEFINITION,
      anon_sym_INTERFACE,
      anon_sym_UNION,
      anon_sym_ENUM_VALUE,
      anon_sym_INPUT_OBJECT,
      anon_sym_INPUT_FIELD_DEFINITION,
  [437] = 13,
    ACTIONS(80), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_DOLLAR,
    ACTIONS(84), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      sym_float_value,
    ACTIONS(94), 1,
      anon_sym_LBRACK,
    ACTIONS(96), 1,
      anon_sym_RBRACK,
    ACTIONS(98), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(88), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(92), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [486] = 10,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(104), 1,
      anon_sym_implements,
    ACTIONS(106), 1,
      anon_sym_DQUOTE,
    ACTIONS(108), 1,
      anon_sym_AT,
    STATE(22), 1,
      sym_implements_interfaces,
    STATE(70), 1,
      sym_directives,
    STATE(113), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(100), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [529] = 13,
    ACTIONS(80), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_DOLLAR,
    ACTIONS(84), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      sym_float_value,
    ACTIONS(94), 1,
      anon_sym_LBRACK,
    ACTIONS(98), 1,
      sym_name,
    ACTIONS(110), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(88), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(92), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(20), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [578] = 10,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(104), 1,
      anon_sym_implements,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(114), 1,
      anon_sym_DQUOTE,
    STATE(23), 1,
      sym_implements_interfaces,
    STATE(69), 1,
      sym_directives,
    STATE(92), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(112), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [621] = 10,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(104), 1,
      anon_sym_implements,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(118), 1,
      anon_sym_DQUOTE,
    STATE(24), 1,
      sym_implements_interfaces,
    STATE(63), 1,
      sym_directives,
    STATE(122), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(116), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [664] = 13,
    ACTIONS(80), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_DOLLAR,
    ACTIONS(84), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      sym_float_value,
    ACTIONS(94), 1,
      anon_sym_LBRACK,
    ACTIONS(98), 1,
      sym_name,
    ACTIONS(120), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(88), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(92), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [713] = 13,
    ACTIONS(122), 1,
      anon_sym_LBRACE,
    ACTIONS(125), 1,
      anon_sym_DOLLAR,
    ACTIONS(128), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(131), 1,
      anon_sym_DQUOTE,
    ACTIONS(137), 1,
      sym_float_value,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(146), 1,
      anon_sym_RBRACK,
    ACTIONS(148), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(134), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [762] = 13,
    ACTIONS(80), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_DOLLAR,
    ACTIONS(84), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      sym_float_value,
    ACTIONS(94), 1,
      anon_sym_LBRACK,
    ACTIONS(98), 1,
      sym_name,
    ACTIONS(151), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(88), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(92), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [811] = 10,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(104), 1,
      anon_sym_implements,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(155), 1,
      anon_sym_DQUOTE,
    STATE(26), 1,
      sym_implements_interfaces,
    STATE(57), 1,
      sym_directives,
    STATE(112), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(153), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [854] = 13,
    ACTIONS(80), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_DOLLAR,
    ACTIONS(84), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      sym_float_value,
    ACTIONS(94), 1,
      anon_sym_LBRACK,
    ACTIONS(98), 1,
      sym_name,
    ACTIONS(157), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(88), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(92), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(17), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [903] = 13,
    ACTIONS(80), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_DOLLAR,
    ACTIONS(84), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(86), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      sym_float_value,
    ACTIONS(94), 1,
      anon_sym_LBRACK,
    ACTIONS(98), 1,
      sym_name,
    ACTIONS(159), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(88), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(92), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(16), 2,
      sym_value,
      aux_sym_list_value_repeat1,
    STATE(107), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [952] = 9,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(163), 1,
      anon_sym_AMP,
    ACTIONS(165), 1,
      anon_sym_DQUOTE,
    STATE(53), 1,
      sym_directives,
    STATE(117), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(161), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [992] = 9,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(118), 1,
      anon_sym_DQUOTE,
    ACTIONS(163), 1,
      anon_sym_AMP,
    STATE(63), 1,
      sym_directives,
    STATE(122), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(116), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1032] = 9,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(163), 1,
      anon_sym_AMP,
    ACTIONS(169), 1,
      anon_sym_DQUOTE,
    STATE(67), 1,
      sym_directives,
    STATE(89), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(167), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1072] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(175), 1,
      anon_sym_DQUOTE,
    STATE(50), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    STATE(43), 2,
      sym_input_fields_definition,
      aux_sym_input_object_type_extension_repeat1,
    ACTIONS(171), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1110] = 9,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(163), 1,
      anon_sym_AMP,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    STATE(65), 1,
      sym_directives,
    STATE(118), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(177), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1150] = 12,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_DOLLAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_float_value,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(197), 1,
      sym_name,
    STATE(184), 1,
      sym_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(189), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(193), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(177), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [1195] = 12,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_DOLLAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      sym_float_value,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(197), 1,
      sym_name,
    STATE(232), 1,
      sym_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(189), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(193), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(177), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [1240] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_DQUOTE,
    STATE(54), 1,
      sym_directives,
    STATE(130), 1,
      sym_input_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(199), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1277] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    STATE(55), 1,
      sym_directives,
    STATE(129), 1,
      sym_enum_values_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(203), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1314] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(213), 1,
      anon_sym_DQUOTE,
    STATE(56), 1,
      sym_directives,
    STATE(124), 1,
      sym_union_member_types,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(209), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1351] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(217), 1,
      anon_sym_DQUOTE,
    STATE(52), 1,
      sym_directives,
    STATE(114), 1,
      sym_union_member_types,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(215), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1388] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(221), 1,
      anon_sym_DQUOTE,
    STATE(64), 1,
      sym_directives,
    STATE(94), 1,
      sym_union_member_types,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(219), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1425] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    STATE(62), 1,
      sym_directives,
    STATE(96), 1,
      sym_enum_values_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(223), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1462] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_DQUOTE,
    STATE(58), 1,
      sym_directives,
    STATE(98), 1,
      sym_input_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(227), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1499] = 8,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(233), 1,
      anon_sym_DQUOTE,
    STATE(61), 1,
      sym_directives,
    STATE(115), 1,
      sym_enum_values_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(231), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1536] = 12,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(237), 1,
      anon_sym_DOLLAR,
    ACTIONS(239), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(241), 1,
      anon_sym_DQUOTE,
    ACTIONS(245), 1,
      sym_float_value,
    ACTIONS(249), 1,
      anon_sym_LBRACK,
    ACTIONS(251), 1,
      sym_name,
    STATE(247), 1,
      sym_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(243), 2,
      sym_int_value,
      sym_null_value,
    ACTIONS(247), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(239), 6,
      sym_variable,
      sym_string_value,
      sym_boolean_value,
      sym_enum_value,
      sym_list_value,
      sym_object_value,
  [1581] = 5,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(255), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(40), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(253), 13,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1611] = 5,
    ACTIONS(259), 1,
      anon_sym_LPAREN,
    ACTIONS(261), 1,
      anon_sym_DQUOTE,
    STATE(49), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(257), 14,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      anon_sym_directive,
  [1641] = 5,
    ACTIONS(265), 1,
      anon_sym_DQUOTE,
    ACTIONS(267), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(40), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(263), 13,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1671] = 6,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(272), 1,
      anon_sym_DQUOTE,
    STATE(86), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(270), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1702] = 6,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(276), 1,
      anon_sym_DQUOTE,
    STATE(126), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(274), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1733] = 5,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(46), 2,
      sym_input_fields_definition,
      aux_sym_input_object_type_extension_repeat1,
    ACTIONS(278), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1761] = 3,
    ACTIONS(284), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(282), 14,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      anon_sym_directive,
  [1785] = 3,
    ACTIONS(288), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(286), 14,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_AMP,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      anon_sym_directive,
  [1809] = 5,
    ACTIONS(292), 1,
      anon_sym_LBRACE,
    ACTIONS(295), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(46), 2,
      sym_input_fields_definition,
      aux_sym_input_object_type_extension_repeat1,
    ACTIONS(290), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1837] = 5,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(299), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(46), 2,
      sym_input_fields_definition,
      aux_sym_input_object_type_extension_repeat1,
    ACTIONS(297), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1865] = 3,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(301), 14,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_AMP,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      anon_sym_directive,
  [1889] = 3,
    ACTIONS(307), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(305), 14,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      anon_sym_directive,
  [1913] = 5,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(47), 2,
      sym_input_fields_definition,
      aux_sym_input_object_type_extension_repeat1,
    ACTIONS(278), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1941] = 5,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(314), 1,
      anon_sym_DQUOTE,
    STATE(51), 1,
      aux_sym_union_member_types_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(309), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1968] = 5,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(318), 1,
      anon_sym_DQUOTE,
    STATE(83), 1,
      sym_union_member_types,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(316), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [1995] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(322), 1,
      anon_sym_DQUOTE,
    STATE(116), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(320), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2022] = 5,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(326), 1,
      anon_sym_DQUOTE,
    STATE(85), 1,
      sym_input_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(324), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2049] = 5,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(330), 1,
      anon_sym_DQUOTE,
    STATE(87), 1,
      sym_enum_values_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(328), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2076] = 5,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(334), 1,
      anon_sym_DQUOTE,
    STATE(99), 1,
      sym_union_member_types,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(332), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2103] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    STATE(118), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(177), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2130] = 5,
    ACTIONS(173), 1,
      anon_sym_LBRACE,
    ACTIONS(201), 1,
      anon_sym_DQUOTE,
    STATE(130), 1,
      sym_input_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(199), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2157] = 5,
    ACTIONS(338), 1,
      anon_sym_PIPE,
    ACTIONS(340), 1,
      anon_sym_DQUOTE,
    STATE(68), 1,
      aux_sym_union_member_types_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(336), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2184] = 5,
    ACTIONS(338), 1,
      anon_sym_PIPE,
    ACTIONS(340), 1,
      anon_sym_DQUOTE,
    STATE(51), 1,
      aux_sym_union_member_types_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(336), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2211] = 5,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(344), 1,
      anon_sym_DQUOTE,
    STATE(108), 1,
      sym_enum_values_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(342), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2238] = 5,
    ACTIONS(205), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    STATE(129), 1,
      sym_enum_values_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(203), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2265] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DQUOTE,
    STATE(89), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(167), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2292] = 5,
    ACTIONS(211), 1,
      anon_sym_EQ,
    ACTIONS(213), 1,
      anon_sym_DQUOTE,
    STATE(124), 1,
      sym_union_member_types,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(209), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2319] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(348), 1,
      anon_sym_DQUOTE,
    STATE(110), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(346), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2346] = 5,
    ACTIONS(338), 1,
      anon_sym_PIPE,
    ACTIONS(352), 1,
      anon_sym_DQUOTE,
    STATE(60), 1,
      aux_sym_union_member_types_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(350), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2373] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(356), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(354), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2400] = 5,
    ACTIONS(338), 1,
      anon_sym_PIPE,
    ACTIONS(360), 1,
      anon_sym_DQUOTE,
    STATE(51), 1,
      aux_sym_union_member_types_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(358), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2427] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(118), 1,
      anon_sym_DQUOTE,
    STATE(122), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(116), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2454] = 5,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(165), 1,
      anon_sym_DQUOTE,
    STATE(117), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(161), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2481] = 3,
    ACTIONS(314), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(309), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2503] = 3,
    ACTIONS(364), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(362), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2525] = 3,
    ACTIONS(368), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(366), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2547] = 4,
    ACTIONS(372), 1,
      anon_sym_PIPE,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(370), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2571] = 3,
    ACTIONS(378), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(376), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2593] = 3,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(380), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2615] = 3,
    ACTIONS(386), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(384), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2637] = 3,
    ACTIONS(390), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(388), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_LBRACE,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2659] = 4,
    ACTIONS(372), 1,
      anon_sym_PIPE,
    ACTIONS(394), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(392), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2683] = 4,
    ACTIONS(372), 1,
      anon_sym_PIPE,
    ACTIONS(398), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(396), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2707] = 3,
    ACTIONS(402), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(400), 12,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_PIPE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2729] = 4,
    ACTIONS(372), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(404), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2753] = 3,
    ACTIONS(410), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(408), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2774] = 3,
    ACTIONS(414), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(412), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2795] = 3,
    ACTIONS(418), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(416), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2816] = 3,
    ACTIONS(276), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(274), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2837] = 3,
    ACTIONS(422), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(420), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2858] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(424), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(426), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [2879] = 3,
    ACTIONS(356), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(354), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2900] = 3,
    ACTIONS(430), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(428), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2921] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(432), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(434), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [2942] = 3,
    ACTIONS(118), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(116), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [2963] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(436), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(438), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [2984] = 3,
    ACTIONS(213), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(209), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3005] = 3,
    ACTIONS(442), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(440), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3026] = 3,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(203), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3047] = 3,
    ACTIONS(446), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(444), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3068] = 3,
    ACTIONS(201), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(199), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3089] = 3,
    ACTIONS(450), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(448), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3110] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(452), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(454), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [3131] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(456), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(458), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [3152] = 3,
    ACTIONS(462), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(460), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3173] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(464), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(466), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [3194] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(468), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(470), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [3215] = 3,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(472), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3236] = 3,
    ACTIONS(478), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(476), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3257] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(480), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(482), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [3278] = 3,
    ACTIONS(486), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(484), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3299] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(488), 6,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_float_value,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(490), 6,
      anon_sym_DQUOTE,
      sym_int_value,
      anon_sym_true,
      anon_sym_false,
      sym_null_value,
      sym_name,
  [3320] = 3,
    ACTIONS(494), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(492), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3341] = 3,
    ACTIONS(498), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(496), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3362] = 3,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(177), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3383] = 3,
    ACTIONS(165), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(161), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3404] = 3,
    ACTIONS(318), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(316), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3425] = 3,
    ACTIONS(344), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(342), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3446] = 3,
    ACTIONS(502), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(500), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3467] = 3,
    ACTIONS(322), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(320), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3488] = 3,
    ACTIONS(348), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(346), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3509] = 3,
    ACTIONS(506), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(504), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3530] = 3,
    ACTIONS(510), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(508), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3551] = 3,
    ACTIONS(514), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(512), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3572] = 3,
    ACTIONS(169), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(167), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3593] = 3,
    ACTIONS(518), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(516), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3614] = 3,
    ACTIONS(334), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(332), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3635] = 3,
    ACTIONS(522), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(520), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3656] = 3,
    ACTIONS(526), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(524), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3677] = 3,
    ACTIONS(530), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(528), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3698] = 3,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(532), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3719] = 3,
    ACTIONS(330), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(328), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3740] = 3,
    ACTIONS(326), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(324), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3761] = 3,
    ACTIONS(538), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(536), 11,
      ts_builtin_sym_end,
      anon_sym_schema,
      anon_sym_extend,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_directive,
  [3782] = 8,
    ACTIONS(542), 1,
      anon_sym_EQ,
    ACTIONS(544), 1,
      anon_sym_DQUOTE,
    ACTIONS(546), 1,
      anon_sym_AT,
    STATE(140), 1,
      sym_default_value,
    STATE(199), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(540), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [3812] = 8,
    ACTIONS(542), 1,
      anon_sym_EQ,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(550), 1,
      anon_sym_DQUOTE,
    STATE(135), 1,
      sym_default_value,
    STATE(196), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(548), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [3842] = 3,
    ACTIONS(554), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(552), 8,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_BANG,
      sym_name,
  [3860] = 6,
    ACTIONS(544), 1,
      anon_sym_DQUOTE,
    ACTIONS(546), 1,
      anon_sym_AT,
    STATE(199), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(540), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [3884] = 8,
    ACTIONS(558), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(561), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(284), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(556), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
    STATE(136), 2,
      sym_input_value_definition,
      aux_sym_input_fields_definition_repeat1,
  [3912] = 9,
    ACTIONS(567), 1,
      anon_sym_RBRACE,
    ACTIONS(569), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(572), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_name,
    STATE(156), 1,
      sym_enum_value,
    STATE(246), 1,
      sym_description,
    STATE(264), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(137), 2,
      sym_enum_value_definition,
      aux_sym_enum_values_definition_repeat1,
  [3942] = 4,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(582), 1,
      anon_sym_BANG,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(578), 7,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_AT,
      sym_name,
  [3962] = 9,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    ACTIONS(586), 1,
      sym_name,
    STATE(156), 1,
      sym_enum_value,
    STATE(246), 1,
      sym_description,
    STATE(264), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(137), 2,
      sym_enum_value_definition,
      aux_sym_enum_values_definition_repeat1,
  [3992] = 6,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(590), 1,
      anon_sym_DQUOTE,
    STATE(194), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(588), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4016] = 8,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(592), 1,
      anon_sym_RBRACE,
    ACTIONS(594), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(265), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(157), 2,
      sym_field_definition,
      aux_sym_fields_definition_repeat1,
  [4043] = 3,
    ACTIONS(78), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(76), 7,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      anon_sym_BANG,
      sym_name,
  [4060] = 8,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(596), 1,
      anon_sym_RPAREN,
    ACTIONS(598), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(284), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(136), 2,
      sym_input_value_definition,
      aux_sym_input_fields_definition_repeat1,
  [4087] = 6,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(602), 1,
      anon_sym_DQUOTE,
    STATE(205), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(600), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4110] = 6,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    STATE(206), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(604), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4133] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(608), 8,
      anon_sym_schema,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_directive,
  [4148] = 9,
    ACTIONS(610), 1,
      anon_sym_schema,
    ACTIONS(612), 1,
      anon_sym_scalar,
    ACTIONS(614), 1,
      anon_sym_type,
    ACTIONS(616), 1,
      anon_sym_interface,
    ACTIONS(618), 1,
      anon_sym_union,
    ACTIONS(620), 1,
      anon_sym_enum,
    ACTIONS(622), 1,
      anon_sym_input,
    ACTIONS(624), 1,
      anon_sym_directive,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [4177] = 3,
    ACTIONS(580), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(578), 7,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_AT,
      sym_name,
  [4194] = 5,
    ACTIONS(255), 1,
      anon_sym_DQUOTE,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(155), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(253), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4215] = 6,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(628), 1,
      anon_sym_DQUOTE,
    STATE(210), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(626), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4238] = 8,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      sym_name,
    STATE(156), 1,
      sym_enum_value,
    STATE(246), 1,
      sym_description,
    STATE(264), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(139), 2,
      sym_enum_value_definition,
      aux_sym_enum_values_definition_repeat1,
  [4265] = 8,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(598), 1,
      sym_name,
    ACTIONS(630), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_string_value,
    STATE(284), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(136), 2,
      sym_input_value_definition,
      aux_sym_input_fields_definition_repeat1,
  [4292] = 6,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(634), 1,
      anon_sym_DQUOTE,
    STATE(219), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(632), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4315] = 5,
    ACTIONS(261), 1,
      anon_sym_DQUOTE,
    ACTIONS(636), 1,
      anon_sym_LPAREN,
    STATE(191), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(257), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4336] = 5,
    ACTIONS(265), 1,
      anon_sym_DQUOTE,
    ACTIONS(638), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(155), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(263), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4357] = 6,
    ACTIONS(546), 1,
      anon_sym_AT,
    ACTIONS(643), 1,
      anon_sym_DQUOTE,
    STATE(202), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(149), 2,
      sym_directive,
      aux_sym_directives_repeat1,
    ACTIONS(641), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [4380] = 8,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
    ACTIONS(647), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(650), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(265), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(157), 2,
      sym_field_definition,
      aux_sym_fields_definition_repeat1,
  [4407] = 8,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(104), 1,
      anon_sym_implements,
    ACTIONS(108), 1,
      anon_sym_AT,
    STATE(90), 1,
      sym_fields_definition,
    STATE(167), 1,
      sym_implements_interfaces,
    STATE(227), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [4434] = 8,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(104), 1,
      anon_sym_implements,
    ACTIONS(108), 1,
      anon_sym_AT,
    STATE(120), 1,
      sym_fields_definition,
    STATE(169), 1,
      sym_implements_interfaces,
    STATE(244), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [4461] = 3,
    ACTIONS(658), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(656), 7,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_AT,
      sym_name,
  [4478] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(424), 8,
      anon_sym_schema,
      anon_sym_scalar,
      anon_sym_type,
      anon_sym_interface,
      anon_sym_union,
      anon_sym_enum,
      anon_sym_input,
      anon_sym_directive,
  [4493] = 5,
    ACTIONS(660), 1,
      anon_sym_RBRACE,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(162), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(662), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4513] = 7,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(598), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(284), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(152), 2,
      sym_input_value_definition,
      aux_sym_input_fields_definition_repeat1,
  [4537] = 5,
    ACTIONS(665), 1,
      anon_sym_RBRACE,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(162), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4557] = 5,
    ACTIONS(669), 1,
      anon_sym_RBRACE,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(162), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4577] = 7,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(598), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(284), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(143), 2,
      sym_input_value_definition,
      aux_sym_input_fields_definition_repeat1,
  [4601] = 7,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(163), 1,
      anon_sym_AMP,
    STATE(120), 1,
      sym_fields_definition,
    STATE(244), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [4625] = 5,
    ACTIONS(671), 1,
      anon_sym_RBRACE,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(162), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4645] = 7,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(163), 1,
      anon_sym_AMP,
    STATE(95), 1,
      sym_fields_definition,
    STATE(242), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [4669] = 7,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym_name,
    STATE(264), 1,
      sym_string_value,
    STATE(265), 1,
      sym_description,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(141), 2,
      sym_field_definition,
      aux_sym_fields_definition_repeat1,
  [4693] = 8,
    ACTIONS(673), 1,
      anon_sym_schema,
    ACTIONS(675), 1,
      anon_sym_scalar,
    ACTIONS(677), 1,
      anon_sym_type,
    ACTIONS(679), 1,
      anon_sym_interface,
    ACTIONS(681), 1,
      anon_sym_union,
    ACTIONS(683), 1,
      anon_sym_enum,
    ACTIONS(685), 1,
      anon_sym_input,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [4719] = 4,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(164), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4736] = 3,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(488), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4751] = 6,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_name,
    STATE(148), 1,
      sym_non_null_type,
    STATE(153), 1,
      sym_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(138), 2,
      sym_named_type,
      sym_list_type,
  [4772] = 4,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(165), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4789] = 3,
    ACTIONS(470), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(468), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4804] = 3,
    ACTIONS(482), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(480), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4819] = 3,
    ACTIONS(438), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(436), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4834] = 3,
    ACTIONS(466), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(464), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4849] = 6,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(691), 1,
      sym_name,
    STATE(148), 1,
      sym_non_null_type,
    STATE(286), 1,
      sym_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(138), 2,
      sym_named_type,
      sym_list_type,
  [4870] = 6,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_name,
    STATE(144), 1,
      sym_type,
    STATE(148), 1,
      sym_non_null_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(138), 2,
      sym_named_type,
      sym_list_type,
  [4891] = 6,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_name,
    STATE(133), 1,
      sym_type,
    STATE(148), 1,
      sym_non_null_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(138), 2,
      sym_named_type,
      sym_list_type,
  [4912] = 4,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(168), 2,
      sym_root_operation_type_definition,
      aux_sym_schema_definition_repeat1,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [4929] = 3,
    ACTIONS(695), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(693), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4944] = 6,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_name,
    STATE(132), 1,
      sym_type,
    STATE(148), 1,
      sym_non_null_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(138), 2,
      sym_named_type,
      sym_list_type,
  [4965] = 3,
    ACTIONS(458), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(456), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4980] = 3,
    ACTIONS(454), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(452), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [4995] = 3,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(432), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [5010] = 3,
    ACTIONS(284), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(282), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [5025] = 6,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_name,
    STATE(145), 1,
      sym_type,
    STATE(148), 1,
      sym_non_null_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(138), 2,
      sym_named_type,
      sym_list_type,
  [5046] = 3,
    ACTIONS(307), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(305), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [5061] = 3,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(424), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_AT,
      sym_name,
  [5076] = 4,
    STATE(270), 1,
      sym_operation_type,
    STATE(271), 1,
      sym_root_operation_type_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [5092] = 3,
    ACTIONS(699), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(697), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5106] = 4,
    STATE(254), 1,
      sym_root_operation_type_definition,
    STATE(270), 1,
      sym_operation_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(667), 3,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [5122] = 3,
    ACTIONS(544), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(540), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5136] = 5,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(701), 1,
      anon_sym_LBRACE,
    STATE(266), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [5154] = 5,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    STATE(252), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [5172] = 3,
    ACTIONS(590), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(588), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5186] = 5,
    ACTIONS(108), 1,
      anon_sym_AT,
    ACTIONS(705), 1,
      anon_sym_LBRACE,
    STATE(275), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [5204] = 4,
    ACTIONS(108), 1,
      anon_sym_AT,
    STATE(111), 1,
      sym_directives,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(38), 2,
      sym_directive,
      aux_sym_directives_repeat1,
  [5219] = 3,
    ACTIONS(628), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(626), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5232] = 4,
    ACTIONS(707), 1,
      anon_sym_RBRACE,
    ACTIONS(709), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(203), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5247] = 4,
    ACTIONS(712), 1,
      anon_sym_RPAREN,
    ACTIONS(714), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(204), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [5262] = 3,
    ACTIONS(719), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(717), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5275] = 3,
    ACTIONS(602), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(600), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5288] = 4,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
    ACTIONS(723), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(203), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5303] = 4,
    ACTIONS(723), 1,
      sym_name,
    ACTIONS(725), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(207), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5318] = 5,
    ACTIONS(727), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      anon_sym_on,
    ACTIONS(731), 1,
      anon_sym_repeatable,
    STATE(234), 1,
      sym_arguments_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5335] = 3,
    ACTIONS(735), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(733), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5348] = 4,
    ACTIONS(737), 1,
      anon_sym_RPAREN,
    ACTIONS(739), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(204), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [5363] = 4,
    ACTIONS(723), 1,
      sym_name,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(215), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5378] = 4,
    ACTIONS(723), 1,
      sym_name,
    ACTIONS(743), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(203), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5393] = 4,
    ACTIONS(739), 1,
      sym_name,
    ACTIONS(745), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(204), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [5408] = 4,
    ACTIONS(723), 1,
      sym_name,
    ACTIONS(747), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(203), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5423] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(749), 4,
      anon_sym_RBRACE,
      anon_sym_query,
      anon_sym_mutation,
      anon_sym_subscription,
  [5434] = 5,
    ACTIONS(727), 1,
      anon_sym_LPAREN,
    ACTIONS(751), 1,
      anon_sym_on,
    ACTIONS(753), 1,
      anon_sym_repeatable,
    STATE(243), 1,
      sym_arguments_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5451] = 4,
    ACTIONS(723), 1,
      sym_name,
    ACTIONS(755), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(213), 2,
      sym_object_field,
      aux_sym_object_value_repeat1,
  [5466] = 3,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(604), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_name,
  [5479] = 3,
    ACTIONS(739), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(214), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [5491] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(757), 3,
      anon_sym_COLON,
      anon_sym_on,
      anon_sym_repeatable,
  [5501] = 4,
    ACTIONS(691), 1,
      sym_name,
    ACTIONS(759), 1,
      anon_sym_PIPE,
    STATE(66), 1,
      sym_named_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5515] = 3,
    ACTIONS(739), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    STATE(211), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [5527] = 4,
    ACTIONS(727), 1,
      anon_sym_LPAREN,
    ACTIONS(761), 1,
      anon_sym_COLON,
    STATE(273), 1,
      sym_arguments_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5541] = 4,
    ACTIONS(163), 1,
      anon_sym_AMP,
    ACTIONS(691), 1,
      sym_name,
    STATE(48), 1,
      sym_named_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5555] = 4,
    ACTIONS(727), 1,
      anon_sym_LPAREN,
    ACTIONS(763), 1,
      anon_sym_COLON,
    STATE(253), 1,
      sym_arguments_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5569] = 3,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    STATE(120), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5580] = 3,
    ACTIONS(691), 1,
      sym_name,
    STATE(45), 1,
      sym_named_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5591] = 3,
    ACTIONS(691), 1,
      sym_name,
    STATE(71), 1,
      sym_named_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5602] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5611] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(432), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5620] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(765), 2,
      anon_sym_RPAREN,
      sym_name,
  [5629] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(436), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5638] = 3,
    ACTIONS(751), 1,
      anon_sym_on,
    ACTIONS(753), 1,
      anon_sym_repeatable,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5649] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(452), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5658] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5667] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5676] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5685] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5694] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 3,
      anon_sym_RBRACE,
      sym_name,
      sym_comma,
  [5703] = 3,
    ACTIONS(691), 1,
      sym_name,
    STATE(216), 1,
      sym_named_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5714] = 3,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    STATE(125), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5725] = 3,
    ACTIONS(767), 1,
      anon_sym_on,
    ACTIONS(769), 1,
      anon_sym_repeatable,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5736] = 3,
    ACTIONS(102), 1,
      anon_sym_LBRACE,
    STATE(95), 1,
      sym_fields_definition,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5747] = 3,
    ACTIONS(691), 1,
      sym_name,
    STATE(59), 1,
      sym_named_type,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5758] = 3,
    ACTIONS(586), 1,
      sym_name,
    STATE(150), 1,
      sym_enum_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 1,
      sym_comma,
    ACTIONS(771), 2,
      anon_sym_RBRACE,
      sym_name,
  [5780] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
    ACTIONS(775), 2,
      anon_sym_RBRACE,
      sym_name,
  [5789] = 2,
    ACTIONS(777), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5797] = 2,
    ACTIONS(779), 1,
      aux_sym_string_value_token2,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [5805] = 2,
    ACTIONS(783), 1,
      aux_sym_string_value_token1,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [5813] = 2,
    ACTIONS(705), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5821] = 2,
    ACTIONS(785), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5829] = 2,
    ACTIONS(787), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5837] = 2,
    ACTIONS(789), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5845] = 2,
    ACTIONS(791), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5853] = 2,
    ACTIONS(793), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5861] = 2,
    ACTIONS(795), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5869] = 2,
    ACTIONS(797), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5877] = 2,
    ACTIONS(799), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5885] = 2,
    ACTIONS(801), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5893] = 2,
    ACTIONS(803), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5901] = 2,
    ACTIONS(805), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5909] = 2,
    ACTIONS(608), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5917] = 2,
    ACTIONS(807), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5925] = 2,
    ACTIONS(809), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5933] = 2,
    ACTIONS(811), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5941] = 2,
    ACTIONS(813), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5949] = 2,
    ACTIONS(767), 1,
      anon_sym_on,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5957] = 2,
    ACTIONS(815), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5965] = 2,
    ACTIONS(817), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5973] = 2,
    ACTIONS(819), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5981] = 2,
    ACTIONS(763), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5989] = 2,
    ACTIONS(821), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [5997] = 2,
    ACTIONS(823), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6005] = 2,
    ACTIONS(825), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6013] = 2,
    ACTIONS(827), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6021] = 2,
    ACTIONS(829), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6029] = 2,
    ACTIONS(831), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6037] = 2,
    ACTIONS(833), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6045] = 2,
    ACTIONS(835), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6053] = 2,
    ACTIONS(837), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6061] = 2,
    ACTIONS(839), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6069] = 2,
    ACTIONS(841), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6077] = 2,
    ACTIONS(751), 1,
      anon_sym_on,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6085] = 2,
    ACTIONS(843), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6093] = 2,
    ACTIONS(845), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6101] = 2,
    ACTIONS(847), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6109] = 2,
    ACTIONS(849), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6117] = 2,
    ACTIONS(849), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6125] = 2,
    ACTIONS(827), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6133] = 2,
    ACTIONS(851), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6141] = 2,
    ACTIONS(853), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6149] = 2,
    ACTIONS(855), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6157] = 2,
    ACTIONS(857), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6165] = 2,
    ACTIONS(859), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6173] = 2,
    ACTIONS(861), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6181] = 2,
    ACTIONS(861), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6189] = 2,
    ACTIONS(863), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6197] = 2,
    ACTIONS(865), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6205] = 2,
    ACTIONS(867), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6213] = 2,
    ACTIONS(869), 1,
      anon_sym_on,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6221] = 2,
    ACTIONS(871), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6229] = 2,
    ACTIONS(873), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6237] = 2,
    ACTIONS(873), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6245] = 2,
    ACTIONS(875), 1,
      aux_sym_string_value_token1,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [6253] = 2,
    ACTIONS(877), 1,
      aux_sym_string_value_token2,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [6261] = 2,
    ACTIONS(879), 1,
      sym_name,
    ACTIONS(3), 2,
      sym_comment,
      sym_comma,
  [6269] = 2,
    ACTIONS(881), 1,
      aux_sym_string_value_token1,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [6277] = 2,
    ACTIONS(883), 1,
      aux_sym_string_value_token2,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [6285] = 2,
    ACTIONS(885), 1,
      aux_sym_string_value_token1,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
  [6293] = 2,
    ACTIONS(887), 1,
      aux_sym_string_value_token2,
    ACTIONS(781), 2,
      sym_comment,
      sym_comma,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 74,
  [SMALL_STATE(4)] = 148,
  [SMALL_STATE(5)] = 193,
  [SMALL_STATE(6)] = 238,
  [SMALL_STATE(7)] = 283,
  [SMALL_STATE(8)] = 328,
  [SMALL_STATE(9)] = 367,
  [SMALL_STATE(10)] = 398,
  [SMALL_STATE(11)] = 437,
  [SMALL_STATE(12)] = 486,
  [SMALL_STATE(13)] = 529,
  [SMALL_STATE(14)] = 578,
  [SMALL_STATE(15)] = 621,
  [SMALL_STATE(16)] = 664,
  [SMALL_STATE(17)] = 713,
  [SMALL_STATE(18)] = 762,
  [SMALL_STATE(19)] = 811,
  [SMALL_STATE(20)] = 854,
  [SMALL_STATE(21)] = 903,
  [SMALL_STATE(22)] = 952,
  [SMALL_STATE(23)] = 992,
  [SMALL_STATE(24)] = 1032,
  [SMALL_STATE(25)] = 1072,
  [SMALL_STATE(26)] = 1110,
  [SMALL_STATE(27)] = 1150,
  [SMALL_STATE(28)] = 1195,
  [SMALL_STATE(29)] = 1240,
  [SMALL_STATE(30)] = 1277,
  [SMALL_STATE(31)] = 1314,
  [SMALL_STATE(32)] = 1351,
  [SMALL_STATE(33)] = 1388,
  [SMALL_STATE(34)] = 1425,
  [SMALL_STATE(35)] = 1462,
  [SMALL_STATE(36)] = 1499,
  [SMALL_STATE(37)] = 1536,
  [SMALL_STATE(38)] = 1581,
  [SMALL_STATE(39)] = 1611,
  [SMALL_STATE(40)] = 1641,
  [SMALL_STATE(41)] = 1671,
  [SMALL_STATE(42)] = 1702,
  [SMALL_STATE(43)] = 1733,
  [SMALL_STATE(44)] = 1761,
  [SMALL_STATE(45)] = 1785,
  [SMALL_STATE(46)] = 1809,
  [SMALL_STATE(47)] = 1837,
  [SMALL_STATE(48)] = 1865,
  [SMALL_STATE(49)] = 1889,
  [SMALL_STATE(50)] = 1913,
  [SMALL_STATE(51)] = 1941,
  [SMALL_STATE(52)] = 1968,
  [SMALL_STATE(53)] = 1995,
  [SMALL_STATE(54)] = 2022,
  [SMALL_STATE(55)] = 2049,
  [SMALL_STATE(56)] = 2076,
  [SMALL_STATE(57)] = 2103,
  [SMALL_STATE(58)] = 2130,
  [SMALL_STATE(59)] = 2157,
  [SMALL_STATE(60)] = 2184,
  [SMALL_STATE(61)] = 2211,
  [SMALL_STATE(62)] = 2238,
  [SMALL_STATE(63)] = 2265,
  [SMALL_STATE(64)] = 2292,
  [SMALL_STATE(65)] = 2319,
  [SMALL_STATE(66)] = 2346,
  [SMALL_STATE(67)] = 2373,
  [SMALL_STATE(68)] = 2400,
  [SMALL_STATE(69)] = 2427,
  [SMALL_STATE(70)] = 2454,
  [SMALL_STATE(71)] = 2481,
  [SMALL_STATE(72)] = 2503,
  [SMALL_STATE(73)] = 2525,
  [SMALL_STATE(74)] = 2547,
  [SMALL_STATE(75)] = 2571,
  [SMALL_STATE(76)] = 2593,
  [SMALL_STATE(77)] = 2615,
  [SMALL_STATE(78)] = 2637,
  [SMALL_STATE(79)] = 2659,
  [SMALL_STATE(80)] = 2683,
  [SMALL_STATE(81)] = 2707,
  [SMALL_STATE(82)] = 2729,
  [SMALL_STATE(83)] = 2753,
  [SMALL_STATE(84)] = 2774,
  [SMALL_STATE(85)] = 2795,
  [SMALL_STATE(86)] = 2816,
  [SMALL_STATE(87)] = 2837,
  [SMALL_STATE(88)] = 2858,
  [SMALL_STATE(89)] = 2879,
  [SMALL_STATE(90)] = 2900,
  [SMALL_STATE(91)] = 2921,
  [SMALL_STATE(92)] = 2942,
  [SMALL_STATE(93)] = 2963,
  [SMALL_STATE(94)] = 2984,
  [SMALL_STATE(95)] = 3005,
  [SMALL_STATE(96)] = 3026,
  [SMALL_STATE(97)] = 3047,
  [SMALL_STATE(98)] = 3068,
  [SMALL_STATE(99)] = 3089,
  [SMALL_STATE(100)] = 3110,
  [SMALL_STATE(101)] = 3131,
  [SMALL_STATE(102)] = 3152,
  [SMALL_STATE(103)] = 3173,
  [SMALL_STATE(104)] = 3194,
  [SMALL_STATE(105)] = 3215,
  [SMALL_STATE(106)] = 3236,
  [SMALL_STATE(107)] = 3257,
  [SMALL_STATE(108)] = 3278,
  [SMALL_STATE(109)] = 3299,
  [SMALL_STATE(110)] = 3320,
  [SMALL_STATE(111)] = 3341,
  [SMALL_STATE(112)] = 3362,
  [SMALL_STATE(113)] = 3383,
  [SMALL_STATE(114)] = 3404,
  [SMALL_STATE(115)] = 3425,
  [SMALL_STATE(116)] = 3446,
  [SMALL_STATE(117)] = 3467,
  [SMALL_STATE(118)] = 3488,
  [SMALL_STATE(119)] = 3509,
  [SMALL_STATE(120)] = 3530,
  [SMALL_STATE(121)] = 3551,
  [SMALL_STATE(122)] = 3572,
  [SMALL_STATE(123)] = 3593,
  [SMALL_STATE(124)] = 3614,
  [SMALL_STATE(125)] = 3635,
  [SMALL_STATE(126)] = 3656,
  [SMALL_STATE(127)] = 3677,
  [SMALL_STATE(128)] = 3698,
  [SMALL_STATE(129)] = 3719,
  [SMALL_STATE(130)] = 3740,
  [SMALL_STATE(131)] = 3761,
  [SMALL_STATE(132)] = 3782,
  [SMALL_STATE(133)] = 3812,
  [SMALL_STATE(134)] = 3842,
  [SMALL_STATE(135)] = 3860,
  [SMALL_STATE(136)] = 3884,
  [SMALL_STATE(137)] = 3912,
  [SMALL_STATE(138)] = 3942,
  [SMALL_STATE(139)] = 3962,
  [SMALL_STATE(140)] = 3992,
  [SMALL_STATE(141)] = 4016,
  [SMALL_STATE(142)] = 4043,
  [SMALL_STATE(143)] = 4060,
  [SMALL_STATE(144)] = 4087,
  [SMALL_STATE(145)] = 4110,
  [SMALL_STATE(146)] = 4133,
  [SMALL_STATE(147)] = 4148,
  [SMALL_STATE(148)] = 4177,
  [SMALL_STATE(149)] = 4194,
  [SMALL_STATE(150)] = 4215,
  [SMALL_STATE(151)] = 4238,
  [SMALL_STATE(152)] = 4265,
  [SMALL_STATE(153)] = 4292,
  [SMALL_STATE(154)] = 4315,
  [SMALL_STATE(155)] = 4336,
  [SMALL_STATE(156)] = 4357,
  [SMALL_STATE(157)] = 4380,
  [SMALL_STATE(158)] = 4407,
  [SMALL_STATE(159)] = 4434,
  [SMALL_STATE(160)] = 4461,
  [SMALL_STATE(161)] = 4478,
  [SMALL_STATE(162)] = 4493,
  [SMALL_STATE(163)] = 4513,
  [SMALL_STATE(164)] = 4537,
  [SMALL_STATE(165)] = 4557,
  [SMALL_STATE(166)] = 4577,
  [SMALL_STATE(167)] = 4601,
  [SMALL_STATE(168)] = 4625,
  [SMALL_STATE(169)] = 4645,
  [SMALL_STATE(170)] = 4669,
  [SMALL_STATE(171)] = 4693,
  [SMALL_STATE(172)] = 4719,
  [SMALL_STATE(173)] = 4736,
  [SMALL_STATE(174)] = 4751,
  [SMALL_STATE(175)] = 4772,
  [SMALL_STATE(176)] = 4789,
  [SMALL_STATE(177)] = 4804,
  [SMALL_STATE(178)] = 4819,
  [SMALL_STATE(179)] = 4834,
  [SMALL_STATE(180)] = 4849,
  [SMALL_STATE(181)] = 4870,
  [SMALL_STATE(182)] = 4891,
  [SMALL_STATE(183)] = 4912,
  [SMALL_STATE(184)] = 4929,
  [SMALL_STATE(185)] = 4944,
  [SMALL_STATE(186)] = 4965,
  [SMALL_STATE(187)] = 4980,
  [SMALL_STATE(188)] = 4995,
  [SMALL_STATE(189)] = 5010,
  [SMALL_STATE(190)] = 5025,
  [SMALL_STATE(191)] = 5046,
  [SMALL_STATE(192)] = 5061,
  [SMALL_STATE(193)] = 5076,
  [SMALL_STATE(194)] = 5092,
  [SMALL_STATE(195)] = 5106,
  [SMALL_STATE(196)] = 5122,
  [SMALL_STATE(197)] = 5136,
  [SMALL_STATE(198)] = 5154,
  [SMALL_STATE(199)] = 5172,
  [SMALL_STATE(200)] = 5186,
  [SMALL_STATE(201)] = 5204,
  [SMALL_STATE(202)] = 5219,
  [SMALL_STATE(203)] = 5232,
  [SMALL_STATE(204)] = 5247,
  [SMALL_STATE(205)] = 5262,
  [SMALL_STATE(206)] = 5275,
  [SMALL_STATE(207)] = 5288,
  [SMALL_STATE(208)] = 5303,
  [SMALL_STATE(209)] = 5318,
  [SMALL_STATE(210)] = 5335,
  [SMALL_STATE(211)] = 5348,
  [SMALL_STATE(212)] = 5363,
  [SMALL_STATE(213)] = 5378,
  [SMALL_STATE(214)] = 5393,
  [SMALL_STATE(215)] = 5408,
  [SMALL_STATE(216)] = 5423,
  [SMALL_STATE(217)] = 5434,
  [SMALL_STATE(218)] = 5451,
  [SMALL_STATE(219)] = 5466,
  [SMALL_STATE(220)] = 5479,
  [SMALL_STATE(221)] = 5491,
  [SMALL_STATE(222)] = 5501,
  [SMALL_STATE(223)] = 5515,
  [SMALL_STATE(224)] = 5527,
  [SMALL_STATE(225)] = 5541,
  [SMALL_STATE(226)] = 5555,
  [SMALL_STATE(227)] = 5569,
  [SMALL_STATE(228)] = 5580,
  [SMALL_STATE(229)] = 5591,
  [SMALL_STATE(230)] = 5602,
  [SMALL_STATE(231)] = 5611,
  [SMALL_STATE(232)] = 5620,
  [SMALL_STATE(233)] = 5629,
  [SMALL_STATE(234)] = 5638,
  [SMALL_STATE(235)] = 5649,
  [SMALL_STATE(236)] = 5658,
  [SMALL_STATE(237)] = 5667,
  [SMALL_STATE(238)] = 5676,
  [SMALL_STATE(239)] = 5685,
  [SMALL_STATE(240)] = 5694,
  [SMALL_STATE(241)] = 5703,
  [SMALL_STATE(242)] = 5714,
  [SMALL_STATE(243)] = 5725,
  [SMALL_STATE(244)] = 5736,
  [SMALL_STATE(245)] = 5747,
  [SMALL_STATE(246)] = 5758,
  [SMALL_STATE(247)] = 5769,
  [SMALL_STATE(248)] = 5780,
  [SMALL_STATE(249)] = 5789,
  [SMALL_STATE(250)] = 5797,
  [SMALL_STATE(251)] = 5805,
  [SMALL_STATE(252)] = 5813,
  [SMALL_STATE(253)] = 5821,
  [SMALL_STATE(254)] = 5829,
  [SMALL_STATE(255)] = 5837,
  [SMALL_STATE(256)] = 5845,
  [SMALL_STATE(257)] = 5853,
  [SMALL_STATE(258)] = 5861,
  [SMALL_STATE(259)] = 5869,
  [SMALL_STATE(260)] = 5877,
  [SMALL_STATE(261)] = 5885,
  [SMALL_STATE(262)] = 5893,
  [SMALL_STATE(263)] = 5901,
  [SMALL_STATE(264)] = 5909,
  [SMALL_STATE(265)] = 5917,
  [SMALL_STATE(266)] = 5925,
  [SMALL_STATE(267)] = 5933,
  [SMALL_STATE(268)] = 5941,
  [SMALL_STATE(269)] = 5949,
  [SMALL_STATE(270)] = 5957,
  [SMALL_STATE(271)] = 5965,
  [SMALL_STATE(272)] = 5973,
  [SMALL_STATE(273)] = 5981,
  [SMALL_STATE(274)] = 5989,
  [SMALL_STATE(275)] = 5997,
  [SMALL_STATE(276)] = 6005,
  [SMALL_STATE(277)] = 6013,
  [SMALL_STATE(278)] = 6021,
  [SMALL_STATE(279)] = 6029,
  [SMALL_STATE(280)] = 6037,
  [SMALL_STATE(281)] = 6045,
  [SMALL_STATE(282)] = 6053,
  [SMALL_STATE(283)] = 6061,
  [SMALL_STATE(284)] = 6069,
  [SMALL_STATE(285)] = 6077,
  [SMALL_STATE(286)] = 6085,
  [SMALL_STATE(287)] = 6093,
  [SMALL_STATE(288)] = 6101,
  [SMALL_STATE(289)] = 6109,
  [SMALL_STATE(290)] = 6117,
  [SMALL_STATE(291)] = 6125,
  [SMALL_STATE(292)] = 6133,
  [SMALL_STATE(293)] = 6141,
  [SMALL_STATE(294)] = 6149,
  [SMALL_STATE(295)] = 6157,
  [SMALL_STATE(296)] = 6165,
  [SMALL_STATE(297)] = 6173,
  [SMALL_STATE(298)] = 6181,
  [SMALL_STATE(299)] = 6189,
  [SMALL_STATE(300)] = 6197,
  [SMALL_STATE(301)] = 6205,
  [SMALL_STATE(302)] = 6213,
  [SMALL_STATE(303)] = 6221,
  [SMALL_STATE(304)] = 6229,
  [SMALL_STATE(305)] = 6237,
  [SMALL_STATE(306)] = 6245,
  [SMALL_STATE(307)] = 6253,
  [SMALL_STATE(308)] = 6261,
  [SMALL_STATE(309)] = 6269,
  [SMALL_STATE(310)] = 6277,
  [SMALL_STATE(311)] = 6285,
  [SMALL_STATE(312)] = 6293,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [29] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2),
  [31] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(198),
  [34] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(171),
  [37] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(301),
  [40] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(296),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(294),
  [46] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(261),
  [49] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(257),
  [52] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(256),
  [55] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(251),
  [58] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(250),
  [61] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(281),
  [64] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [66] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [68] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [70] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [72] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [74] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [76] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_type, 1),
  [78] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_type, 1),
  [80] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [82] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [84] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [86] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [88] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [90] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [92] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [94] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [96] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [98] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_extension, 3),
  [102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [106] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_extension, 3),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_definition, 2),
  [114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_definition, 2),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_definition, 3),
  [118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_definition, 3),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(218),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(293),
  [128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(309),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(310),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(107),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(107),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(104),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(21),
  [146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_value_repeat1, 2),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_value_repeat1, 2), SHIFT_REPEAT(109),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_extension, 3),
  [155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_extension, 3),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_extension, 4),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [165] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_extension, 4),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_definition, 4),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_definition, 4),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_extension, 3),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_extension, 3),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_extension, 4),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_extension, 4),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_definition, 3),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_definition, 3),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_definition, 3),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_definition, 3),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_definition, 3),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_definition, 3),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_extension, 3),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_extension, 3),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_definition, 2),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_definition, 2),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_definition, 2),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_definition, 2),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_definition, 2),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_definition, 2),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_extension, 3),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_extension, 3),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directives, 1),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directives, 1),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive, 2),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive, 2),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_directives_repeat1, 2),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_directives_repeat1, 2),
  [267] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_directives_repeat1, 2), SHIFT_REPEAT(280),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_type_definition, 2),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_type_definition, 2),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_type_definition, 3),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_type_definition, 3),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_extension, 4),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_extension, 4),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_implements_interfaces, 3),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_implements_interfaces, 3),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_input_object_type_extension_repeat1, 2),
  [292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_input_object_type_extension_repeat1, 2), SHIFT_REPEAT(163),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_input_object_type_extension_repeat1, 2),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_extension, 5),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_extension, 5),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_implements_interfaces, 2),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_implements_interfaces, 2),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive, 3),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive, 3),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_member_types_repeat1, 2),
  [311] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_member_types_repeat1, 2), SHIFT_REPEAT(229),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_union_member_types_repeat1, 2),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_extension, 4),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_extension, 4),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_extension, 5),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_extension, 5),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_definition, 4),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_definition, 4),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_definition, 4),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_definition, 4),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_definition, 4),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_definition, 4),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_member_types, 3),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_member_types, 3),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_extension, 4),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_extension, 4),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_extension, 5),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_extension, 5),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_member_types, 2),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_member_types, 2),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_definition, 5),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_definition, 5),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_member_types, 4),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_member_types, 4),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_location, 1),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_location, 1),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_locations, 1),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_locations, 1),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_definition, 5),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_definition, 5),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_locations, 2),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_locations, 2),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_system_directive_location, 1),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_system_directive_location, 1),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_executable_directive_location, 1),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_executable_directive_location, 1),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_fields_definition, 3),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_fields_definition, 3),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_definition, 6),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_definition, 6),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_definition, 8),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_definition, 8),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_locations, 3),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_locations, 3),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_definition, 7),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_definition, 7),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_extension, 5),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_extension, 5),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_extension, 5),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_extension, 5),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_object_type_definition, 5),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_object_type_definition, 5),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_definition, 5),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_definition, 5),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_value, 3),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_value, 3),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_definition, 3),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_definition, 3),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_value, 3),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_value, 3),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_value, 3),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_value, 3),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_definition, 5),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_definition, 5),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fields_definition, 3),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fields_definition, 3),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_type_definition, 5),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_type_definition, 5),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_value, 2),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_value, 2),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 2),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 2),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_values_definition, 3),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_values_definition, 3),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_value, 2),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_value, 2),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_value, 1),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_value, 1),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_definition, 4),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_definition, 4),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_extension, 6),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_extension, 6),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_type_extension, 5),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_type_extension, 5),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_value, 1),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_value, 1),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_extension, 6),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_extension, 6),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_type_extension, 4),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_type_extension, 4),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_extension, 6),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_extension, 6),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_definition, 5),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_definition, 5),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_definition, 4),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_definition, 4),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_definition, 1),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_definition, 1),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_definition, 6),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_schema_definition, 6),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_type_definition, 6),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object_type_definition, 6),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_type_definition, 4),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_type_definition, 4),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_type_definition, 6),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_type_definition, 6),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_extension, 1),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_extension, 1),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item, 1),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item, 1),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_value_definition, 4),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [544] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_value_definition, 4),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_value_definition, 3),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_value_definition, 3),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_type, 3),
  [554] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_type, 3),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_input_fields_definition_repeat1, 2),
  [558] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_input_fields_definition_repeat1, 2), SHIFT_REPEAT(306),
  [561] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_input_fields_definition_repeat1, 2), SHIFT_REPEAT(307),
  [564] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_input_fields_definition_repeat1, 2), SHIFT_REPEAT(283),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_values_definition_repeat1, 2),
  [569] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_values_definition_repeat1, 2), SHIFT_REPEAT(306),
  [572] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_values_definition_repeat1, 2), SHIFT_REPEAT(307),
  [575] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_values_definition_repeat1, 2), SHIFT_REPEAT(173),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1),
  [580] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 1),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_value_definition, 5),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_value_definition, 5),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_definition, 5),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_definition, 5),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_definition, 4),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_definition, 4),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_description, 1),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_value_definition, 2),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_value_definition, 2),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_definition, 3),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_definition, 3),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [638] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_directives_repeat1, 2), SHIFT_REPEAT(288),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_value_definition, 1),
  [643] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_value_definition, 1),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fields_definition_repeat1, 2),
  [647] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fields_definition_repeat1, 2), SHIFT_REPEAT(306),
  [650] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fields_definition_repeat1, 2), SHIFT_REPEAT(307),
  [653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fields_definition_repeat1, 2), SHIFT_REPEAT(224),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_non_null_type, 2),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_non_null_type, 2),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_schema_definition_repeat1, 2),
  [662] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_schema_definition_repeat1, 2), SHIFT_REPEAT(255),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_value, 2),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_default_value, 2),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_input_value_definition, 6),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_input_value_definition, 6),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_object_value_repeat1, 2),
  [709] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_object_value_repeat1, 2), SHIFT_REPEAT(279),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [714] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(268),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_definition, 6),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_definition, 6),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_value_definition, 3),
  [735] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_value_definition, 3),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_root_operation_type_definition, 3),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments_definition, 3),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 3),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_field, 3),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object_field, 4),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [779] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [781] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [783] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_type, 1),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [837] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [877] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [881] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_graphql(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
