#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 200
#define LARGE_STATE_COUNT 27
#define SYMBOL_COUNT 66
#define ALIAS_COUNT 0
#define TOKEN_COUNT 34
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 23

enum {
  anon_sym_LBRACE = 1,
  anon_sym_RBRACE = 2,
  anon_sym_SEMI = 3,
  anon_sym_POUND = 4,
  aux_sym__special_preproc_call_token1 = 5,
  aux_sym__special_preproc_call_token2 = 6,
  aux_sym__cond_preproc_call_token1 = 7,
  anon_sym_LBRACK = 8,
  anon_sym_RBRACK = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_POUND_LBRACE = 12,
  anon_sym_POUND_RBRACE = 13,
  aux_sym_code_body_token1 = 14,
  anon_sym_DOLLAR_LBRACE = 15,
  anon_sym_RBRACE2 = 16,
  anon_sym_DOLLAR = 17,
  sym_prev_scope = 18,
  anon_sym_on = 19,
  anon_sym_off = 20,
  anon_sym_true = 21,
  anon_sym_false = 22,
  sym_number_literal = 23,
  anon_sym_L_DQUOTE = 24,
  anon_sym_u_DQUOTE = 25,
  anon_sym_U_DQUOTE = 26,
  anon_sym_u8_DQUOTE = 27,
  anon_sym_DQUOTE = 28,
  aux_sym_string_literal_token1 = 29,
  sym_escape_sequence = 30,
  aux_sym_comment_token1 = 31,
  aux_sym_identifier_token1 = 32,
  sym__identifier = 33,
  sym_source_file = 34,
  sym__statement = 35,
  sym_dict = 36,
  sym_dict_core = 37,
  sym_key_value = 38,
  sym_preproc_call = 39,
  sym__special_preproc_call = 40,
  sym__cond_preproc_call = 41,
  sym__generic_preproc_call = 42,
  sym__value = 43,
  sym_dimensions = 44,
  sym_list = 45,
  sym__uniform_list = 46,
  sym__non_uniform_list = 47,
  sym__list_item = 48,
  sym_dict_headless = 49,
  sym_code = 50,
  sym_code_body = 51,
  sym_macro = 52,
  sym__macro_braces = 53,
  sym__macro_no_braces = 54,
  sym_boolean = 55,
  sym_string_literal = 56,
  sym_comment = 57,
  sym_identifier = 58,
  aux_sym_source_file_repeat1 = 59,
  aux_sym_dict_core_repeat1 = 60,
  aux_sym_key_value_repeat1 = 61,
  aux_sym_dimensions_repeat1 = 62,
  aux_sym__non_uniform_list_repeat1 = 63,
  aux_sym_code_body_repeat1 = 64,
  aux_sym_string_literal_repeat1 = 65,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SEMI] = ";",
  [anon_sym_POUND] = "#",
  [aux_sym__special_preproc_call_token1] = "_special_preproc_call_token1",
  [aux_sym__special_preproc_call_token2] = "_special_preproc_call_token2",
  [aux_sym__cond_preproc_call_token1] = "_cond_preproc_call_token1",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_POUND_LBRACE] = "#{",
  [anon_sym_POUND_RBRACE] = "#}",
  [aux_sym_code_body_token1] = "code_body_token1",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_RBRACE2] = "}",
  [anon_sym_DOLLAR] = "$",
  [sym_prev_scope] = "prev_scope",
  [anon_sym_on] = "on",
  [anon_sym_off] = "off",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [aux_sym_comment_token1] = "comment_token1",
  [aux_sym_identifier_token1] = "identifier_token1",
  [sym__identifier] = "_identifier",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym_dict] = "dict",
  [sym_dict_core] = "dict_core",
  [sym_key_value] = "key_value",
  [sym_preproc_call] = "preproc_call",
  [sym__special_preproc_call] = "_special_preproc_call",
  [sym__cond_preproc_call] = "_cond_preproc_call",
  [sym__generic_preproc_call] = "_generic_preproc_call",
  [sym__value] = "_value",
  [sym_dimensions] = "dimensions",
  [sym_list] = "list",
  [sym__uniform_list] = "_uniform_list",
  [sym__non_uniform_list] = "_non_uniform_list",
  [sym__list_item] = "_list_item",
  [sym_dict_headless] = "dict_headless",
  [sym_code] = "code",
  [sym_code_body] = "code_body",
  [sym_macro] = "macro",
  [sym__macro_braces] = "_macro_braces",
  [sym__macro_no_braces] = "_macro_no_braces",
  [sym_boolean] = "boolean",
  [sym_string_literal] = "string_literal",
  [sym_comment] = "comment",
  [sym_identifier] = "identifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_dict_core_repeat1] = "dict_core_repeat1",
  [aux_sym_key_value_repeat1] = "key_value_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym__non_uniform_list_repeat1] = "_non_uniform_list_repeat1",
  [aux_sym_code_body_repeat1] = "code_body_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE2,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym__special_preproc_call_token1] = aux_sym__special_preproc_call_token1,
  [aux_sym__special_preproc_call_token2] = aux_sym__special_preproc_call_token2,
  [aux_sym__cond_preproc_call_token1] = aux_sym__cond_preproc_call_token1,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_POUND_LBRACE] = anon_sym_POUND_LBRACE,
  [anon_sym_POUND_RBRACE] = anon_sym_POUND_RBRACE,
  [aux_sym_code_body_token1] = aux_sym_code_body_token1,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_RBRACE2] = anon_sym_RBRACE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_prev_scope] = sym_prev_scope,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_off] = anon_sym_off,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [sym__identifier] = sym__identifier,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym_dict] = sym_dict,
  [sym_dict_core] = sym_dict_core,
  [sym_key_value] = sym_key_value,
  [sym_preproc_call] = sym_preproc_call,
  [sym__special_preproc_call] = sym__special_preproc_call,
  [sym__cond_preproc_call] = sym__cond_preproc_call,
  [sym__generic_preproc_call] = sym__generic_preproc_call,
  [sym__value] = sym__value,
  [sym_dimensions] = sym_dimensions,
  [sym_list] = sym_list,
  [sym__uniform_list] = sym__uniform_list,
  [sym__non_uniform_list] = sym__non_uniform_list,
  [sym__list_item] = sym__list_item,
  [sym_dict_headless] = sym_dict_headless,
  [sym_code] = sym_code,
  [sym_code_body] = sym_code_body,
  [sym_macro] = sym_macro,
  [sym__macro_braces] = sym__macro_braces,
  [sym__macro_no_braces] = sym__macro_no_braces,
  [sym_boolean] = sym_boolean,
  [sym_string_literal] = sym_string_literal,
  [sym_comment] = sym_comment,
  [sym_identifier] = sym_identifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_dict_core_repeat1] = aux_sym_dict_core_repeat1,
  [aux_sym_key_value_repeat1] = aux_sym_key_value_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym__non_uniform_list_repeat1] = aux_sym__non_uniform_list_repeat1,
  [aux_sym_code_body_repeat1] = aux_sym_code_body_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__special_preproc_call_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__special_preproc_call_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__cond_preproc_call_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_code_body_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_prev_scope] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_off] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_dict] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_core] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym__special_preproc_call] = {
    .visible = false,
    .named = true,
  },
  [sym__cond_preproc_call] = {
    .visible = false,
    .named = true,
  },
  [sym__generic_preproc_call] = {
    .visible = false,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__uniform_list] = {
    .visible = false,
    .named = true,
  },
  [sym__non_uniform_list] = {
    .visible = false,
    .named = true,
  },
  [sym__list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_dict_headless] = {
    .visible = true,
    .named = true,
  },
  [sym_code] = {
    .visible = true,
    .named = true,
  },
  [sym_code_body] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_braces] = {
    .visible = false,
    .named = true,
  },
  [sym__macro_no_braces] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_core_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__non_uniform_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_argument = 1,
  field_dict_body = 2,
  field_dimension = 3,
  field_directive = 4,
  field_item = 5,
  field_key = 6,
  field_keyword = 7,
  field_size = 8,
  field_type = 9,
  field_value = 10,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_dict_body] = "dict_body",
  [field_dimension] = "dimension",
  [field_directive] = "directive",
  [field_item] = "item",
  [field_key] = "key",
  [field_keyword] = "keyword",
  [field_size] = "size",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 3},
  [2] = {.index = 3, .length = 2},
  [3] = {.index = 5, .length = 2},
  [4] = {.index = 7, .length = 2},
  [5] = {.index = 9, .length = 1},
  [6] = {.index = 10, .length = 6},
  [7] = {.index = 16, .length = 3},
  [8] = {.index = 19, .length = 1},
  [9] = {.index = 20, .length = 1},
  [10] = {.index = 21, .length = 1},
  [11] = {.index = 22, .length = 1},
  [12] = {.index = 23, .length = 4},
  [13] = {.index = 27, .length = 2},
  [14] = {.index = 29, .length = 1},
  [15] = {.index = 30, .length = 4},
  [16] = {.index = 34, .length = 4},
  [17] = {.index = 38, .length = 1},
  [18] = {.index = 39, .length = 2},
  [19] = {.index = 41, .length = 2},
  [20] = {.index = 43, .length = 2},
  [21] = {.index = 45, .length = 2},
  [22] = {.index = 47, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_item, 0, .inherited = true},
    {field_size, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [3] =
    {field_argument, 0, .inherited = true},
    {field_directive, 0, .inherited = true},
  [5] =
    {field_item, 0, .inherited = true},
    {field_size, 0, .inherited = true},
  [7] =
    {field_directive, 0},
    {field_directive, 1},
  [9] =
    {field_keyword, 0},
  [10] =
    {field_item, 0, .inherited = true},
    {field_item, 1, .inherited = true},
    {field_size, 0, .inherited = true},
    {field_size, 1, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [16] =
    {field_argument, 2},
    {field_directive, 0},
    {field_directive, 1},
  [19] =
    {field_dimension, 0},
  [20] =
    {field_item, 1},
  [21] =
    {field_size, 0},
  [22] =
    {field_key, 0},
  [23] =
    {field_dict_body, 0},
    {field_item, 0, .inherited = true},
    {field_size, 0, .inherited = true},
    {field_type, 0, .inherited = true},
  [27] =
    {field_keyword, 0},
    {field_value, 1},
  [29] =
    {field_type, 0},
  [30] =
    {field_argument, 2},
    {field_argument, 3},
    {field_directive, 0},
    {field_directive, 1},
  [34] =
    {field_dict_body, 1},
    {field_item, 1, .inherited = true},
    {field_size, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [38] =
    {field_dimension, 1, .inherited = true},
  [39] =
    {field_dimension, 0, .inherited = true},
    {field_dimension, 1, .inherited = true},
  [41] =
    {field_item, 2},
    {field_size, 0},
  [43] =
    {field_item, 2},
    {field_type, 0},
  [45] =
    {field_size, 1},
    {field_type, 0},
  [47] =
    {field_item, 3},
    {field_size, 1},
    {field_type, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '$') ADVANCE(100);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(101);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == 'L') ADVANCE(142);
      if (lookahead == 'U') ADVANCE(143);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') SKIP(60)
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(145);
      if (lookahead == 'i') ADVANCE(146);
      if (lookahead == 'o') ADVANCE(147);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '!' ||
          lookahead == ':') ADVANCE(103);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(24);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(137);
      if (lookahead == '\r') ADVANCE(139);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(14)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '"') ADVANCE(123);
      if (lookahead == '#') ADVANCE(44);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == 'L') ADVANCE(93);
      if (lookahead == 'U') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead == 'u') ADVANCE(95);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(90);
      if (lookahead != 0) ADVANCE(92);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(21)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(21)
      if (lookahead == '\r') SKIP(6)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(28)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(28)
      if (lookahead == '\r') SKIP(8)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(127);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '\r') ADVANCE(129);
      if (lookahead == 'U') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(51);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(132);
      if (lookahead != 0) ADVANCE(129);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(27)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(27)
      if (lookahead == '\r') SKIP(12)
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '$') ADVANCE(100);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == 'L') ADVANCE(142);
      if (lookahead == 'U') ADVANCE(143);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == 'f') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(147);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(24);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(120);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(43);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(137);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead != 0) ADVANCE(24);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '\n' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(24);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 27:
      if (lookahead == '/') ADVANCE(101);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '!' ||
          lookahead == '.' ||
          lookahead == ':') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 28:
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'i') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 29:
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(20);
      END_STATE();
    case 30:
      if (lookahead == 'd') ADVANCE(37);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 35:
      if (lookahead == 'f') ADVANCE(106);
      END_STATE();
    case 36:
      if (lookahead == 'f') ADVANCE(77);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 39:
      if (lookahead == 'q') ADVANCE(78);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(84);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(84);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{') ADVANCE(92);
      END_STATE();
    case 45:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(112);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(112);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(129);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(92);
      END_STATE();
    case 57:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(20);
      END_STATE();
    case 58:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(137);
      if (lookahead == '\r') ADVANCE(140);
      END_STATE();
    case 59:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 60:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(65)
      if (lookahead == '\r') SKIP(59)
      END_STATE();
    case 61:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 62:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(66)
      if (lookahead == '\r') SKIP(61)
      END_STATE();
    case 63:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 64:
      if (eof) ADVANCE(69);
      if (lookahead == '\n') SKIP(68)
      if (lookahead == '\r') SKIP(63)
      END_STATE();
    case 65:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '$') ADVANCE(100);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(101);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == 'L') ADVANCE(142);
      if (lookahead == 'U') ADVANCE(143);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') SKIP(60)
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(145);
      if (lookahead == 'i') ADVANCE(146);
      if (lookahead == 'o') ADVANCE(147);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '!' ||
          lookahead == ':') ADVANCE(103);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 66:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '$') ADVANCE(100);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == 'L') ADVANCE(142);
      if (lookahead == 'U') ADVANCE(143);
      if (lookahead == '\\') SKIP(62)
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 67:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '$') ADVANCE(100);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == 'L') ADVANCE(142);
      if (lookahead == 'U') ADVANCE(143);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') SKIP(64)
      if (lookahead == 'f') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(147);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 68:
      if (eof) ADVANCE(69);
      if (lookahead == '"') ADVANCE(122);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '$') ADVANCE(100);
      if (lookahead == '(') ADVANCE(81);
      if (lookahead == ')') ADVANCE(82);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ';') ADVANCE(72);
      if (lookahead == 'L') ADVANCE(142);
      if (lookahead == 'U') ADVANCE(143);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') SKIP(64)
      if (lookahead == 'f') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(147);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '{') ADVANCE(83);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '{') ADVANCE(83);
      if (lookahead == '}') ADVANCE(84);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__special_preproc_call_token1);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym__special_preproc_call_token2);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym__cond_preproc_call_token1);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_POUND_LBRACE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_POUND_RBRACE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '\n') ADVANCE(24);
      if (lookahead == '"') ADVANCE(16);
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '\n') ADVANCE(24);
      if (lookahead == '"') ADVANCE(16);
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '\n') ADVANCE(137);
      if (lookahead == '\r') ADVANCE(88);
      if (lookahead == '"') ADVANCE(134);
      if (lookahead == '#') ADVANCE(138);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '\n') ADVANCE(137);
      if (lookahead == '"') ADVANCE(134);
      if (lookahead == '#') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(87);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '\r') ADVANCE(92);
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(123);
      if (lookahead == '#') ADVANCE(44);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == 'L') ADVANCE(93);
      if (lookahead == 'U') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead == 'u') ADVANCE(95);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '/') ADVANCE(96);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(115);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(117);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '8') ADVANCE(97);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(134);
      if (lookahead == '#') ADVANCE(138);
      if (lookahead == '\\') ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_code_body_token1);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(92);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_RBRACE2);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(98);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_prev_scope);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '!' ||
          lookahead == '.' ||
          lookahead == ':') ADVANCE(103);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_prev_scope);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '!' ||
          lookahead == '.' ||
          lookahead == '/' ||
          lookahead == ':') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(137);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_prev_scope);
      if (lookahead == '!' ||
          lookahead == '.' ||
          lookahead == '/' ||
          lookahead == ':') ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_prev_scope);
      if (lookahead == '!' ||
          lookahead == '.' ||
          lookahead == '/' ||
          lookahead == ':') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_off);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_number_literal);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(109);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(112);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_L_DQUOTE);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(20);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_u_DQUOTE);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(20);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_U_DQUOTE);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(20);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_u8_DQUOTE);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(20);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(20);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(126);
      if (lookahead == '/') ADVANCE(128);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(128);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '/') ADVANCE(128);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(128);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(11);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(131);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\n') ADVANCE(20);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\n') ADVANCE(20);
      if (lookahead == '"') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead != 0) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '"') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\\') ADVANCE(87);
      if (lookahead == '{' ||
          lookahead == '}') ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(96);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(135);
      if (lookahead == '"') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(2);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(137);
      if (lookahead == '\\') ADVANCE(58);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '"') ADVANCE(114);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '"') ADVANCE(118);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '"') ADVANCE(116);
      if (lookahead == '8') ADVANCE(17);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(31);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 66},
  [2] = {.lex_state = 67},
  [3] = {.lex_state = 67},
  [4] = {.lex_state = 67},
  [5] = {.lex_state = 67},
  [6] = {.lex_state = 67},
  [7] = {.lex_state = 67},
  [8] = {.lex_state = 67},
  [9] = {.lex_state = 67},
  [10] = {.lex_state = 67},
  [11] = {.lex_state = 67},
  [12] = {.lex_state = 67},
  [13] = {.lex_state = 67},
  [14] = {.lex_state = 67},
  [15] = {.lex_state = 67},
  [16] = {.lex_state = 67},
  [17] = {.lex_state = 67},
  [18] = {.lex_state = 67},
  [19] = {.lex_state = 67},
  [20] = {.lex_state = 67},
  [21] = {.lex_state = 67},
  [22] = {.lex_state = 67},
  [23] = {.lex_state = 67},
  [24] = {.lex_state = 67},
  [25] = {.lex_state = 67},
  [26] = {.lex_state = 67},
  [27] = {.lex_state = 66},
  [28] = {.lex_state = 66},
  [29] = {.lex_state = 66},
  [30] = {.lex_state = 66},
  [31] = {.lex_state = 66},
  [32] = {.lex_state = 66},
  [33] = {.lex_state = 66},
  [34] = {.lex_state = 66},
  [35] = {.lex_state = 66},
  [36] = {.lex_state = 66},
  [37] = {.lex_state = 67, .external_lex_state = 1},
  [38] = {.lex_state = 14},
  [39] = {.lex_state = 14},
  [40] = {.lex_state = 14},
  [41] = {.lex_state = 14},
  [42] = {.lex_state = 14},
  [43] = {.lex_state = 14},
  [44] = {.lex_state = 14},
  [45] = {.lex_state = 14},
  [46] = {.lex_state = 14},
  [47] = {.lex_state = 14},
  [48] = {.lex_state = 14},
  [49] = {.lex_state = 14},
  [50] = {.lex_state = 14},
  [51] = {.lex_state = 14},
  [52] = {.lex_state = 14},
  [53] = {.lex_state = 67},
  [54] = {.lex_state = 14},
  [55] = {.lex_state = 14},
  [56] = {.lex_state = 14},
  [57] = {.lex_state = 14},
  [58] = {.lex_state = 14},
  [59] = {.lex_state = 14},
  [60] = {.lex_state = 14},
  [61] = {.lex_state = 67},
  [62] = {.lex_state = 67},
  [63] = {.lex_state = 14},
  [64] = {.lex_state = 67},
  [65] = {.lex_state = 67},
  [66] = {.lex_state = 67},
  [67] = {.lex_state = 14},
  [68] = {.lex_state = 14},
  [69] = {.lex_state = 67},
  [70] = {.lex_state = 67},
  [71] = {.lex_state = 66},
  [72] = {.lex_state = 67},
  [73] = {.lex_state = 66},
  [74] = {.lex_state = 67},
  [75] = {.lex_state = 66},
  [76] = {.lex_state = 66},
  [77] = {.lex_state = 67},
  [78] = {.lex_state = 67},
  [79] = {.lex_state = 67},
  [80] = {.lex_state = 67},
  [81] = {.lex_state = 67},
  [82] = {.lex_state = 66},
  [83] = {.lex_state = 67},
  [84] = {.lex_state = 67},
  [85] = {.lex_state = 14},
  [86] = {.lex_state = 67},
  [87] = {.lex_state = 67},
  [88] = {.lex_state = 67},
  [89] = {.lex_state = 14},
  [90] = {.lex_state = 67},
  [91] = {.lex_state = 66},
  [92] = {.lex_state = 67},
  [93] = {.lex_state = 67},
  [94] = {.lex_state = 67},
  [95] = {.lex_state = 67},
  [96] = {.lex_state = 67},
  [97] = {.lex_state = 67},
  [98] = {.lex_state = 67},
  [99] = {.lex_state = 67},
  [100] = {.lex_state = 67},
  [101] = {.lex_state = 67},
  [102] = {.lex_state = 67},
  [103] = {.lex_state = 66, .external_lex_state = 1},
  [104] = {.lex_state = 66},
  [105] = {.lex_state = 66},
  [106] = {.lex_state = 66},
  [107] = {.lex_state = 66},
  [108] = {.lex_state = 66},
  [109] = {.lex_state = 66},
  [110] = {.lex_state = 66},
  [111] = {.lex_state = 66},
  [112] = {.lex_state = 66},
  [113] = {.lex_state = 66},
  [114] = {.lex_state = 66},
  [115] = {.lex_state = 66},
  [116] = {.lex_state = 66},
  [117] = {.lex_state = 66},
  [118] = {.lex_state = 66},
  [119] = {.lex_state = 66},
  [120] = {.lex_state = 66},
  [121] = {.lex_state = 66},
  [122] = {.lex_state = 66},
  [123] = {.lex_state = 66},
  [124] = {.lex_state = 66},
  [125] = {.lex_state = 66},
  [126] = {.lex_state = 66},
  [127] = {.lex_state = 66},
  [128] = {.lex_state = 66},
  [129] = {.lex_state = 66},
  [130] = {.lex_state = 66},
  [131] = {.lex_state = 66},
  [132] = {.lex_state = 66},
  [133] = {.lex_state = 66},
  [134] = {.lex_state = 66},
  [135] = {.lex_state = 66},
  [136] = {.lex_state = 66},
  [137] = {.lex_state = 66},
  [138] = {.lex_state = 66},
  [139] = {.lex_state = 66},
  [140] = {.lex_state = 66},
  [141] = {.lex_state = 66},
  [142] = {.lex_state = 66},
  [143] = {.lex_state = 66},
  [144] = {.lex_state = 66},
  [145] = {.lex_state = 66},
  [146] = {.lex_state = 66},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 21},
  [154] = {.lex_state = 21},
  [155] = {.lex_state = 28},
  [156] = {.lex_state = 28},
  [157] = {.lex_state = 28},
  [158] = {.lex_state = 28},
  [159] = {.lex_state = 28},
  [160] = {.lex_state = 28},
  [161] = {.lex_state = 21},
  [162] = {.lex_state = 66},
  [163] = {.lex_state = 10},
  [164] = {.lex_state = 10},
  [165] = {.lex_state = 10},
  [166] = {.lex_state = 10},
  [167] = {.lex_state = 10},
  [168] = {.lex_state = 10},
  [169] = {.lex_state = 21, .external_lex_state = 1},
  [170] = {.lex_state = 10},
  [171] = {.lex_state = 21},
  [172] = {.lex_state = 27},
  [173] = {.lex_state = 10},
  [174] = {.lex_state = 27},
  [175] = {.lex_state = 21},
  [176] = {.lex_state = 66},
  [177] = {.lex_state = 27},
  [178] = {.lex_state = 27},
  [179] = {.lex_state = 27},
  [180] = {.lex_state = 21},
  [181] = {.lex_state = 21},
  [182] = {.lex_state = 21},
  [183] = {.lex_state = 21},
  [184] = {.lex_state = 66},
  [185] = {.lex_state = 21},
  [186] = {.lex_state = 66},
  [187] = {.lex_state = 66},
  [188] = {.lex_state = 66},
  [189] = {.lex_state = 66},
  [190] = {.lex_state = 67},
  [191] = {.lex_state = 67},
  [192] = {.lex_state = 66},
  [193] = {.lex_state = 21},
  [194] = {.lex_state = 66},
  [195] = {.lex_state = 66},
  [196] = {.lex_state = 66},
  [197] = {.lex_state = 67},
  [198] = {.lex_state = 67},
  [199] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__identifier = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__identifier] = sym__identifier,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__identifier] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [aux_sym__special_preproc_call_token1] = ACTIONS(1),
    [aux_sym__special_preproc_call_token2] = ACTIONS(1),
    [aux_sym__cond_preproc_call_token1] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_POUND_LBRACE] = ACTIONS(1),
    [anon_sym_POUND_RBRACE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE2] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_prev_scope] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_off] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_L_DQUOTE] = ACTIONS(1),
    [anon_sym_u_DQUOTE] = ACTIONS(1),
    [anon_sym_U_DQUOTE] = ACTIONS(1),
    [anon_sym_u8_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(195),
    [sym__statement] = STATE(146),
    [sym_dict] = STATE(136),
    [sym_key_value] = STATE(136),
    [sym_preproc_call] = STATE(136),
    [sym__special_preproc_call] = STATE(110),
    [sym__cond_preproc_call] = STATE(109),
    [sym__generic_preproc_call] = STATE(108),
    [sym_list] = STATE(189),
    [sym__uniform_list] = STATE(123),
    [sym__non_uniform_list] = STATE(130),
    [sym_string_literal] = STATE(21),
    [sym_comment] = STATE(1),
    [sym_identifier] = STATE(20),
    [aux_sym_source_file_repeat1] = STATE(35),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [sym_number_literal] = ACTIONS(11),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [2] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(2),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(27),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [3] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(3),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(39),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [4] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(4),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(41),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [5] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(5),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(43),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [6] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(6),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [7] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(7),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(47),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [8] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(8),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(6),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(49),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [9] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(9),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(51),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [10] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(10),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [11] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(11),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [12] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(12),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(13),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [13] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(13),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(59),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [14] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(14),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(16),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [15] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(15),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(3),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(63),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [16] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(16),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [17] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(17),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(67),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [18] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(18),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_POUND] = ACTIONS(72),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(78),
    [anon_sym_RPAREN] = ACTIONS(81),
    [anon_sym_POUND_LBRACE] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(86),
    [anon_sym_DOLLAR] = ACTIONS(89),
    [anon_sym_on] = ACTIONS(92),
    [anon_sym_off] = ACTIONS(92),
    [anon_sym_true] = ACTIONS(92),
    [anon_sym_false] = ACTIONS(92),
    [sym_number_literal] = ACTIONS(95),
    [anon_sym_L_DQUOTE] = ACTIONS(98),
    [anon_sym_u_DQUOTE] = ACTIONS(98),
    [anon_sym_U_DQUOTE] = ACTIONS(98),
    [anon_sym_u8_DQUOTE] = ACTIONS(98),
    [anon_sym_DQUOTE] = ACTIONS(98),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(101),
  },
  [19] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(99),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(98),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(99),
    [sym_comment] = STATE(19),
    [sym_identifier] = STATE(92),
    [aux_sym__non_uniform_list_repeat1] = STATE(11),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(104),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(37),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [20] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(101),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(96),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(96),
    [sym_comment] = STATE(20),
    [sym_identifier] = STATE(95),
    [aux_sym_key_value_repeat1] = STATE(25),
    [anon_sym_LBRACE] = ACTIONS(106),
    [anon_sym_SEMI] = ACTIONS(108),
    [anon_sym_POUND] = ACTIONS(110),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(112),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(114),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [21] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(101),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(96),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(96),
    [sym_comment] = STATE(21),
    [sym_identifier] = STATE(95),
    [aux_sym_key_value_repeat1] = STATE(25),
    [anon_sym_LBRACE] = ACTIONS(106),
    [anon_sym_SEMI] = ACTIONS(108),
    [anon_sym_POUND] = ACTIONS(110),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(116),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [22] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(110),
    [sym__cond_preproc_call] = STATE(109),
    [sym__generic_preproc_call] = STATE(108),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(184),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(188),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(184),
    [sym_comment] = STATE(22),
    [sym_identifier] = STATE(162),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(120),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(122),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(124),
  },
  [23] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(101),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(96),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(96),
    [sym_comment] = STATE(23),
    [sym_identifier] = STATE(95),
    [aux_sym_key_value_repeat1] = STATE(25),
    [anon_sym_LBRACE] = ACTIONS(106),
    [anon_sym_SEMI] = ACTIONS(108),
    [anon_sym_POUND] = ACTIONS(110),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(126),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(114),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [24] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(110),
    [sym__cond_preproc_call] = STATE(109),
    [sym__generic_preproc_call] = STATE(108),
    [sym__value] = STATE(85),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(184),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym__list_item] = STATE(196),
    [sym_dict_headless] = STATE(85),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(184),
    [sym_comment] = STATE(24),
    [sym_identifier] = STATE(162),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(118),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(120),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(122),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(124),
  },
  [25] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(101),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(96),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(96),
    [sym_comment] = STATE(25),
    [sym_identifier] = STATE(95),
    [aux_sym_key_value_repeat1] = STATE(26),
    [anon_sym_SEMI] = ACTIONS(128),
    [anon_sym_POUND] = ACTIONS(110),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_POUND_LBRACE] = ACTIONS(29),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(31),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_on] = ACTIONS(35),
    [anon_sym_off] = ACTIONS(35),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [sym_number_literal] = ACTIONS(116),
    [anon_sym_L_DQUOTE] = ACTIONS(13),
    [anon_sym_u_DQUOTE] = ACTIONS(13),
    [anon_sym_U_DQUOTE] = ACTIONS(13),
    [anon_sym_u8_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(17),
  },
  [26] = {
    [sym_dict] = STATE(42),
    [sym_preproc_call] = STATE(42),
    [sym__special_preproc_call] = STATE(80),
    [sym__cond_preproc_call] = STATE(62),
    [sym__generic_preproc_call] = STATE(79),
    [sym__value] = STATE(101),
    [sym_dimensions] = STATE(42),
    [sym_list] = STATE(96),
    [sym__uniform_list] = STATE(45),
    [sym__non_uniform_list] = STATE(46),
    [sym_code] = STATE(42),
    [sym_macro] = STATE(42),
    [sym__macro_braces] = STATE(48),
    [sym__macro_no_braces] = STATE(48),
    [sym_boolean] = STATE(42),
    [sym_string_literal] = STATE(96),
    [sym_comment] = STATE(26),
    [sym_identifier] = STATE(95),
    [aux_sym_key_value_repeat1] = STATE(26),
    [anon_sym_SEMI] = ACTIONS(130),
    [anon_sym_POUND] = ACTIONS(132),
    [anon_sym_LBRACK] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_POUND_LBRACE] = ACTIONS(141),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(144),
    [anon_sym_DOLLAR] = ACTIONS(147),
    [anon_sym_on] = ACTIONS(150),
    [anon_sym_off] = ACTIONS(150),
    [anon_sym_true] = ACTIONS(150),
    [anon_sym_false] = ACTIONS(150),
    [sym_number_literal] = ACTIONS(153),
    [anon_sym_L_DQUOTE] = ACTIONS(156),
    [anon_sym_u_DQUOTE] = ACTIONS(156),
    [anon_sym_U_DQUOTE] = ACTIONS(156),
    [anon_sym_u8_DQUOTE] = ACTIONS(156),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [aux_sym_comment_token1] = ACTIONS(15),
    [aux_sym_identifier_token1] = ACTIONS(159),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(162), 1,
      anon_sym_RBRACE,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(27), 1,
      sym_comment,
    STATE(30), 1,
      aux_sym_dict_core_repeat1,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(192), 1,
      sym_dict_core,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [80] = 24,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(168), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(28), 1,
      sym_comment,
    STATE(30), 1,
      aux_sym_dict_core_repeat1,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(186), 1,
      sym_dict_core,
    STATE(189), 1,
      sym_list,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [160] = 22,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(170), 1,
      anon_sym_RBRACE,
    ACTIONS(172), 1,
      anon_sym_POUND,
    ACTIONS(175), 1,
      anon_sym_LPAREN,
    ACTIONS(178), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(181), 1,
      anon_sym_DOLLAR,
    ACTIONS(184), 1,
      sym_number_literal,
    ACTIONS(190), 1,
      aux_sym_identifier_token1,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(29), 2,
      sym_comment,
      aux_sym_dict_core_repeat1,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(187), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [235] = 23,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(193), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(29), 1,
      aux_sym_dict_core_repeat1,
    STATE(30), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [312] = 23,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(195), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(29), 1,
      aux_sym_dict_core_repeat1,
    STATE(31), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [389] = 23,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(32), 1,
      sym_comment,
    STATE(33), 1,
      aux_sym_dict_core_repeat1,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [466] = 23,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(199), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(29), 1,
      aux_sym_dict_core_repeat1,
    STATE(33), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [543] = 23,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(201), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      sym_string_literal,
    STATE(23), 1,
      sym_identifier,
    STATE(31), 1,
      aux_sym_dict_core_repeat1,
    STATE(34), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(132), 1,
      sym_macro,
    STATE(145), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [620] = 19,
    ACTIONS(7), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(11), 1,
      sym_number_literal,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(203), 1,
      ts_builtin_sym_end,
    STATE(20), 1,
      sym_identifier,
    STATE(21), 1,
      sym_string_literal,
    STATE(35), 1,
      sym_comment,
    STATE(36), 1,
      aux_sym_source_file_repeat1,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(146), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [684] = 18,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(205), 1,
      ts_builtin_sym_end,
    ACTIONS(207), 1,
      anon_sym_POUND,
    ACTIONS(210), 1,
      anon_sym_LPAREN,
    ACTIONS(213), 1,
      sym_number_literal,
    ACTIONS(219), 1,
      aux_sym_identifier_token1,
    STATE(20), 1,
      sym_identifier,
    STATE(21), 1,
      sym_string_literal,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(123), 1,
      sym__uniform_list,
    STATE(130), 1,
      sym__non_uniform_list,
    STATE(146), 1,
      sym__statement,
    STATE(189), 1,
      sym_list,
    STATE(36), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(136), 3,
      sym_dict,
      sym_key_value,
      sym_preproc_call,
    ACTIONS(216), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [746] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(226), 1,
      sym__identifier,
    STATE(37), 1,
      sym_comment,
    ACTIONS(224), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(222), 18,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE2,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [781] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(38), 1,
      sym_comment,
    ACTIONS(230), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(228), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [813] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(39), 1,
      sym_comment,
    ACTIONS(234), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(232), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [845] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(40), 1,
      sym_comment,
    ACTIONS(238), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(236), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [877] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(41), 1,
      sym_comment,
    ACTIONS(242), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(240), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [909] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(42), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [941] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(43), 1,
      sym_comment,
    ACTIONS(250), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(248), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [973] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(44), 1,
      sym_comment,
    ACTIONS(254), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(252), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1005] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(45), 1,
      sym_comment,
    ACTIONS(258), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(256), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1037] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(46), 1,
      sym_comment,
    ACTIONS(262), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(260), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1069] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(47), 1,
      sym_comment,
    ACTIONS(266), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(264), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1101] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(48), 1,
      sym_comment,
    ACTIONS(270), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(268), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1133] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(49), 1,
      sym_comment,
    ACTIONS(274), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(272), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1165] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(50), 1,
      sym_comment,
    ACTIONS(278), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(276), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1197] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(51), 1,
      sym_comment,
    ACTIONS(282), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(280), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1229] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(52), 1,
      sym_comment,
    ACTIONS(286), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(284), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1261] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(53), 1,
      sym_comment,
    ACTIONS(290), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(288), 18,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_RBRACE2,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1293] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(54), 1,
      sym_comment,
    ACTIONS(294), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(292), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1325] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(55), 1,
      sym_comment,
    ACTIONS(298), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(296), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1357] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(56), 1,
      sym_comment,
    ACTIONS(302), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(300), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1389] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(57), 1,
      sym_comment,
    ACTIONS(306), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(304), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1421] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(58), 1,
      sym_comment,
    ACTIONS(310), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(308), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1453] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(59), 1,
      sym_comment,
    ACTIONS(314), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(312), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1485] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(60), 1,
      sym_comment,
    ACTIONS(318), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(316), 18,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1517] = 7,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(240), 1,
      ts_builtin_sym_end,
    ACTIONS(328), 1,
      anon_sym_DOLLAR,
    STATE(61), 1,
      sym_comment,
    ACTIONS(325), 2,
      anon_sym_POUND,
      aux_sym_identifier_token1,
    ACTIONS(320), 8,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    ACTIONS(323), 8,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
  [1554] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(62), 1,
      sym_comment,
    ACTIONS(332), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(330), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1585] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(272), 1,
      anon_sym_RBRACE,
    STATE(63), 1,
      sym_comment,
    ACTIONS(339), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(337), 7,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(334), 9,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1620] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(344), 1,
      anon_sym_SEMI,
    STATE(64), 1,
      sym_comment,
    ACTIONS(346), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(342), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1653] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(65), 1,
      sym_comment,
    ACTIONS(350), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(348), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1684] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(66), 1,
      sym_comment,
    ACTIONS(354), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(352), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1715] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(248), 1,
      anon_sym_RBRACE,
    STATE(67), 1,
      sym_comment,
    ACTIONS(359), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(348), 7,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(356), 9,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1750] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(252), 1,
      anon_sym_RBRACE,
    STATE(68), 1,
      sym_comment,
    ACTIONS(365), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(352), 7,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(362), 9,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1785] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(370), 1,
      anon_sym_SEMI,
    STATE(69), 1,
      sym_comment,
    ACTIONS(372), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(368), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1818] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(374), 1,
      anon_sym_SEMI,
    STATE(70), 1,
      sym_comment,
    ACTIONS(282), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(280), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1851] = 13,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(120), 1,
      anon_sym_DOLLAR,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(376), 1,
      anon_sym_POUND,
    STATE(71), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(48), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    STATE(51), 5,
      sym_preproc_call,
      sym_dict_headless,
      sym_macro,
      sym_string_literal,
      sym_identifier,
  [1900] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(72), 1,
      sym_comment,
    ACTIONS(378), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(337), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [1931] = 13,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(120), 1,
      anon_sym_DOLLAR,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(376), 1,
      anon_sym_POUND,
    STATE(73), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(48), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    STATE(113), 5,
      sym_preproc_call,
      sym_dict_headless,
      sym_macro,
      sym_string_literal,
      sym_identifier,
  [1980] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(74), 1,
      sym_comment,
    ACTIONS(328), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(323), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2011] = 13,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(33), 1,
      anon_sym_DOLLAR,
    ACTIONS(380), 1,
      anon_sym_POUND,
    STATE(62), 1,
      sym__cond_preproc_call,
    STATE(75), 1,
      sym_comment,
    STATE(79), 1,
      sym__generic_preproc_call,
    STATE(80), 1,
      sym__special_preproc_call,
    STATE(48), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    STATE(70), 5,
      sym_preproc_call,
      sym_dict_headless,
      sym_macro,
      sym_string_literal,
      sym_identifier,
  [2060] = 13,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(33), 1,
      anon_sym_DOLLAR,
    ACTIONS(380), 1,
      anon_sym_POUND,
    STATE(62), 1,
      sym__cond_preproc_call,
    STATE(76), 1,
      sym_comment,
    STATE(79), 1,
      sym__generic_preproc_call,
    STATE(80), 1,
      sym__special_preproc_call,
    STATE(48), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    STATE(51), 5,
      sym_preproc_call,
      sym_dict_headless,
      sym_macro,
      sym_string_literal,
      sym_identifier,
  [2109] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(77), 1,
      sym_comment,
    ACTIONS(384), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(382), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2140] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(78), 1,
      sym_comment,
    ACTIONS(388), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(386), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2171] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(79), 1,
      sym_comment,
    ACTIONS(392), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(390), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2202] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(80), 1,
      sym_comment,
    ACTIONS(392), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(390), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2233] = 7,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(272), 1,
      ts_builtin_sym_end,
    ACTIONS(378), 1,
      anon_sym_DOLLAR,
    STATE(81), 1,
      sym_comment,
    ACTIONS(339), 2,
      anon_sym_POUND,
      aux_sym_identifier_token1,
    ACTIONS(334), 8,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    ACTIONS(337), 8,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
  [2270] = 13,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(394), 1,
      anon_sym_LBRACE,
    ACTIONS(396), 1,
      anon_sym_POUND,
    STATE(82), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    ACTIONS(398), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    STATE(113), 5,
      sym_preproc_call,
      sym_dict_headless,
      sym_macro,
      sym_string_literal,
      sym_identifier,
  [2319] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(83), 1,
      sym_comment,
    ACTIONS(402), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(400), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2350] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(84), 1,
      sym_comment,
    ACTIONS(406), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(404), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2381] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(85), 1,
      sym_comment,
    ACTIONS(410), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(408), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2412] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(86), 1,
      sym_comment,
    ACTIONS(372), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(368), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2443] = 7,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(248), 1,
      ts_builtin_sym_end,
    ACTIONS(350), 1,
      anon_sym_DOLLAR,
    STATE(87), 1,
      sym_comment,
    ACTIONS(359), 2,
      anon_sym_POUND,
      aux_sym_identifier_token1,
    ACTIONS(348), 8,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(356), 8,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2480] = 7,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(252), 1,
      ts_builtin_sym_end,
    ACTIONS(354), 1,
      anon_sym_DOLLAR,
    STATE(88), 1,
      sym_comment,
    ACTIONS(365), 2,
      anon_sym_POUND,
      aux_sym_identifier_token1,
    ACTIONS(352), 8,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(362), 8,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2517] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(240), 1,
      anon_sym_RBRACE,
    STATE(89), 1,
      sym_comment,
    ACTIONS(325), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(323), 7,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_POUND_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(320), 9,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2552] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(90), 1,
      sym_comment,
    ACTIONS(414), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(412), 17,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2583] = 13,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    ACTIONS(394), 1,
      anon_sym_LBRACE,
    ACTIONS(396), 1,
      anon_sym_POUND,
    STATE(91), 1,
      sym_comment,
    STATE(108), 1,
      sym__generic_preproc_call,
    STATE(109), 1,
      sym__cond_preproc_call,
    STATE(110), 1,
      sym__special_preproc_call,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    ACTIONS(398), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
    STATE(117), 5,
      sym_preproc_call,
      sym_dict_headless,
      sym_macro,
      sym_string_literal,
      sym_identifier,
  [2632] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(92), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2662] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(416), 1,
      anon_sym_LBRACE,
    STATE(93), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 15,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2694] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(94), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2724] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(418), 1,
      anon_sym_LBRACE,
    STATE(95), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 15,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2756] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(418), 1,
      anon_sym_LBRACE,
    STATE(96), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 15,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2788] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(416), 1,
      anon_sym_LBRACE,
    STATE(97), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 15,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2820] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(98), 1,
      sym_comment,
    ACTIONS(422), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(420), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2850] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(99), 1,
      sym_comment,
    ACTIONS(246), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(244), 16,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2880] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(424), 1,
      anon_sym_SEMI,
    STATE(100), 1,
      sym_comment,
    ACTIONS(372), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(368), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2911] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(101), 1,
      sym_comment,
    ACTIONS(429), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(427), 15,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2940] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(431), 1,
      anon_sym_SEMI,
    STATE(102), 1,
      sym_comment,
    ACTIONS(346), 3,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(342), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_POUND_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_on,
      anon_sym_off,
      anon_sym_true,
      anon_sym_false,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [2971] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(434), 1,
      sym__identifier,
    STATE(103), 1,
      sym_comment,
    ACTIONS(224), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(222), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3000] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(104), 1,
      sym_comment,
    ACTIONS(290), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(288), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3026] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(436), 1,
      anon_sym_SEMI,
    STATE(105), 1,
      sym_comment,
    ACTIONS(346), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(342), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3053] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(438), 1,
      anon_sym_SEMI,
    STATE(106), 1,
      sym_comment,
    ACTIONS(372), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(368), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3080] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(107), 1,
      sym_comment,
    ACTIONS(414), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(412), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3105] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(108), 1,
      sym_comment,
    ACTIONS(392), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(390), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3130] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(109), 1,
      sym_comment,
    ACTIONS(332), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(330), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3155] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(110), 1,
      sym_comment,
    ACTIONS(392), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(390), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3180] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(111), 1,
      sym_comment,
    ACTIONS(306), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(304), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3205] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(112), 1,
      sym_comment,
    ACTIONS(294), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(292), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3230] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(440), 1,
      anon_sym_SEMI,
    STATE(113), 1,
      sym_comment,
    ACTIONS(282), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(280), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3257] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(114), 1,
      sym_comment,
    ACTIONS(378), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(337), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3282] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(115), 1,
      sym_comment,
    ACTIONS(350), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(348), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3307] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(116), 1,
      sym_comment,
    ACTIONS(354), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(352), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3332] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(117), 1,
      sym_comment,
    ACTIONS(282), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(280), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3357] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(118), 1,
      sym_comment,
    ACTIONS(286), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(284), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3382] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(119), 1,
      sym_comment,
    ACTIONS(328), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(323), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3407] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(120), 1,
      sym_comment,
    ACTIONS(270), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(268), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3432] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(121), 1,
      sym_comment,
    ACTIONS(402), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(400), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3457] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(122), 1,
      sym_comment,
    ACTIONS(278), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(276), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3482] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(256), 1,
      anon_sym_LBRACE,
    STATE(123), 1,
      sym_comment,
    ACTIONS(444), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(442), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3509] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(124), 1,
      sym_comment,
    ACTIONS(388), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(386), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3534] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(125), 1,
      sym_comment,
    ACTIONS(314), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(312), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3559] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(126), 1,
      sym_comment,
    ACTIONS(310), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(308), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3584] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(448), 1,
      anon_sym_LBRACE,
    ACTIONS(450), 1,
      anon_sym_LPAREN,
    STATE(127), 1,
      sym_comment,
    ACTIONS(453), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(446), 10,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3613] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(128), 1,
      sym_comment,
    ACTIONS(384), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(382), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3638] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(129), 1,
      sym_comment,
    ACTIONS(230), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(228), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3663] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(260), 1,
      anon_sym_LBRACE,
    STATE(130), 1,
      sym_comment,
    ACTIONS(457), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(455), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3690] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(131), 1,
      sym_comment,
    ACTIONS(266), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(264), 12,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3715] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(461), 1,
      anon_sym_SEMI,
    STATE(132), 1,
      sym_comment,
    ACTIONS(463), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(459), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3741] = 8,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    STATE(133), 1,
      sym_comment,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(124), 3,
      sym_macro,
      sym_string_literal,
      sym_identifier,
    ACTIONS(398), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3773] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(134), 1,
      sym_comment,
    ACTIONS(406), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(404), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3797] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(135), 1,
      sym_comment,
    ACTIONS(372), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(368), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3821] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(136), 1,
      sym_comment,
    ACTIONS(453), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(446), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3845] = 8,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    STATE(137), 1,
      sym_comment,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(133), 3,
      sym_macro,
      sym_string_literal,
      sym_identifier,
    ACTIONS(398), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3877] = 8,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(31), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(120), 1,
      anon_sym_DOLLAR,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    STATE(138), 1,
      sym_comment,
    STATE(48), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(124), 3,
      sym_macro,
      sym_string_literal,
      sym_identifier,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3909] = 8,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    STATE(139), 1,
      sym_comment,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(142), 3,
      sym_macro,
      sym_string_literal,
      sym_identifier,
    ACTIONS(398), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3941] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(140), 1,
      sym_comment,
    ACTIONS(467), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(465), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3965] = 8,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(164), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(166), 1,
      anon_sym_DOLLAR,
    STATE(141), 1,
      sym_comment,
    STATE(120), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(138), 3,
      sym_macro,
      sym_string_literal,
      sym_identifier,
    ACTIONS(398), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [3997] = 8,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(17), 1,
      aux_sym_identifier_token1,
    ACTIONS(31), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(33), 1,
      anon_sym_DOLLAR,
    STATE(142), 1,
      sym_comment,
    STATE(48), 2,
      sym__macro_braces,
      sym__macro_no_braces,
    STATE(78), 3,
      sym_macro,
      sym_string_literal,
      sym_identifier,
    ACTIONS(13), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4029] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(143), 1,
      sym_comment,
    ACTIONS(471), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(469), 11,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4053] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(144), 1,
      sym_comment,
    ACTIONS(475), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(473), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4076] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(145), 1,
      sym_comment,
    ACTIONS(479), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    ACTIONS(477), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LPAREN,
      anon_sym_DOLLAR_LBRACE,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4099] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(483), 1,
      aux_sym_identifier_token1,
    STATE(146), 1,
      sym_comment,
    ACTIONS(481), 9,
      ts_builtin_sym_end,
      anon_sym_POUND,
      anon_sym_LPAREN,
      sym_number_literal,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4120] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(485), 1,
      anon_sym_POUND_RBRACE,
    ACTIONS(487), 1,
      aux_sym_code_body_token1,
    STATE(147), 1,
      sym_comment,
    STATE(149), 1,
      aux_sym_code_body_repeat1,
    STATE(150), 1,
      sym_string_literal,
    STATE(193), 1,
      sym_code_body,
    ACTIONS(489), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4149] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(491), 1,
      anon_sym_POUND_RBRACE,
    ACTIONS(493), 1,
      aux_sym_code_body_token1,
    STATE(150), 1,
      sym_string_literal,
    STATE(148), 2,
      sym_comment,
      aux_sym_code_body_repeat1,
    ACTIONS(496), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4173] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(487), 1,
      aux_sym_code_body_token1,
    ACTIONS(499), 1,
      anon_sym_POUND_RBRACE,
    STATE(148), 1,
      aux_sym_code_body_repeat1,
    STATE(149), 1,
      sym_comment,
    STATE(150), 1,
      sym_string_literal,
    ACTIONS(489), 5,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4199] = 3,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(150), 1,
      sym_comment,
    ACTIONS(501), 7,
      anon_sym_POUND_RBRACE,
      aux_sym_code_body_token1,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4215] = 3,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(151), 1,
      sym_comment,
    ACTIONS(278), 7,
      anon_sym_POUND_RBRACE,
      aux_sym_code_body_token1,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4231] = 3,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(152), 1,
      sym_comment,
    ACTIONS(230), 7,
      anon_sym_POUND_RBRACE,
      aux_sym_code_body_token1,
      anon_sym_L_DQUOTE,
      anon_sym_u_DQUOTE,
      anon_sym_U_DQUOTE,
      anon_sym_u8_DQUOTE,
      anon_sym_DQUOTE,
  [4247] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(503), 1,
      anon_sym_RBRACK,
    ACTIONS(505), 1,
      sym_number_literal,
    ACTIONS(508), 1,
      aux_sym_identifier_token1,
    STATE(175), 1,
      sym_identifier,
    STATE(153), 2,
      sym_comment,
      aux_sym_dimensions_repeat1,
  [4267] = 7,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(511), 1,
      anon_sym_RBRACK,
    ACTIONS(513), 1,
      sym_number_literal,
    ACTIONS(515), 1,
      aux_sym_identifier_token1,
    STATE(153), 1,
      aux_sym_dimensions_repeat1,
    STATE(154), 1,
      sym_comment,
    STATE(175), 1,
      sym_identifier,
  [4289] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(519), 1,
      aux_sym__cond_preproc_call_token1,
    STATE(82), 1,
      sym_identifier,
    STATE(155), 1,
      sym_comment,
    ACTIONS(517), 2,
      aux_sym__special_preproc_call_token1,
      aux_sym__special_preproc_call_token2,
  [4309] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(521), 1,
      aux_sym__cond_preproc_call_token1,
    STATE(73), 1,
      sym_identifier,
    STATE(156), 1,
      sym_comment,
    ACTIONS(517), 2,
      aux_sym__special_preproc_call_token1,
      aux_sym__special_preproc_call_token2,
  [4329] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(521), 1,
      aux_sym__cond_preproc_call_token1,
    STATE(71), 1,
      sym_identifier,
    STATE(157), 1,
      sym_comment,
    ACTIONS(517), 2,
      aux_sym__special_preproc_call_token1,
      aux_sym__special_preproc_call_token2,
  [4349] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(525), 1,
      aux_sym__cond_preproc_call_token1,
    STATE(75), 1,
      sym_identifier,
    STATE(158), 1,
      sym_comment,
    ACTIONS(523), 2,
      aux_sym__special_preproc_call_token1,
      aux_sym__special_preproc_call_token2,
  [4369] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(519), 1,
      aux_sym__cond_preproc_call_token1,
    STATE(91), 1,
      sym_identifier,
    STATE(159), 1,
      sym_comment,
    ACTIONS(517), 2,
      aux_sym__special_preproc_call_token1,
      aux_sym__special_preproc_call_token2,
  [4389] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(124), 1,
      aux_sym_identifier_token1,
    ACTIONS(525), 1,
      aux_sym__cond_preproc_call_token1,
    STATE(76), 1,
      sym_identifier,
    STATE(160), 1,
      sym_comment,
    ACTIONS(523), 2,
      aux_sym__special_preproc_call_token1,
      aux_sym__special_preproc_call_token2,
  [4409] = 7,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(513), 1,
      sym_number_literal,
    ACTIONS(515), 1,
      aux_sym_identifier_token1,
    ACTIONS(527), 1,
      anon_sym_RBRACK,
    STATE(154), 1,
      aux_sym_dimensions_repeat1,
    STATE(161), 1,
      sym_comment,
    STATE(175), 1,
      sym_identifier,
  [4431] = 6,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(106), 1,
      anon_sym_LBRACE,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    ACTIONS(529), 1,
      anon_sym_LPAREN,
    ACTIONS(531), 1,
      sym_number_literal,
    STATE(162), 1,
      sym_comment,
  [4450] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(533), 1,
      anon_sym_DQUOTE,
    ACTIONS(535), 1,
      aux_sym_string_literal_token1,
    ACTIONS(537), 1,
      sym_escape_sequence,
    STATE(163), 1,
      sym_comment,
    STATE(166), 1,
      aux_sym_string_literal_repeat1,
  [4469] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(535), 1,
      aux_sym_string_literal_token1,
    ACTIONS(537), 1,
      sym_escape_sequence,
    ACTIONS(539), 1,
      anon_sym_DQUOTE,
    STATE(164), 1,
      sym_comment,
    STATE(168), 1,
      aux_sym_string_literal_repeat1,
  [4488] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(535), 1,
      aux_sym_string_literal_token1,
    ACTIONS(537), 1,
      sym_escape_sequence,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    STATE(165), 1,
      sym_comment,
    STATE(170), 1,
      aux_sym_string_literal_repeat1,
  [4507] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(543), 1,
      anon_sym_DQUOTE,
    ACTIONS(545), 1,
      aux_sym_string_literal_token1,
    ACTIONS(548), 1,
      sym_escape_sequence,
    STATE(166), 2,
      sym_comment,
      aux_sym_string_literal_repeat1,
  [4524] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(535), 1,
      aux_sym_string_literal_token1,
    ACTIONS(537), 1,
      sym_escape_sequence,
    ACTIONS(551), 1,
      anon_sym_DQUOTE,
    STATE(163), 1,
      aux_sym_string_literal_repeat1,
    STATE(167), 1,
      sym_comment,
  [4543] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(535), 1,
      aux_sym_string_literal_token1,
    ACTIONS(537), 1,
      sym_escape_sequence,
    ACTIONS(553), 1,
      anon_sym_DQUOTE,
    STATE(166), 1,
      aux_sym_string_literal_repeat1,
    STATE(168), 1,
      sym_comment,
  [4562] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(555), 1,
      sym__identifier,
    STATE(169), 1,
      sym_comment,
    ACTIONS(222), 3,
      anon_sym_RBRACK,
      sym_number_literal,
      aux_sym_identifier_token1,
  [4577] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(535), 1,
      aux_sym_string_literal_token1,
    ACTIONS(537), 1,
      sym_escape_sequence,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    STATE(166), 1,
      aux_sym_string_literal_repeat1,
    STATE(170), 1,
      sym_comment,
  [4596] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(171), 1,
      sym_comment,
    ACTIONS(288), 3,
      anon_sym_RBRACK,
      sym_number_literal,
      aux_sym_identifier_token1,
  [4608] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(559), 1,
      sym_prev_scope,
    ACTIONS(561), 1,
      aux_sym_identifier_token1,
    STATE(58), 1,
      sym_identifier,
    STATE(172), 1,
      sym_comment,
  [4624] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(565), 1,
      aux_sym_string_literal_token1,
    STATE(173), 1,
      sym_comment,
    ACTIONS(563), 2,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [4638] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(561), 1,
      aux_sym_identifier_token1,
    ACTIONS(567), 1,
      sym_prev_scope,
    STATE(174), 1,
      sym_comment,
    STATE(197), 1,
      sym_identifier,
  [4654] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    STATE(175), 1,
      sym_comment,
    ACTIONS(569), 3,
      anon_sym_RBRACK,
      sym_number_literal,
      aux_sym_identifier_token1,
  [4666] = 5,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    ACTIONS(448), 1,
      anon_sym_LBRACE,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    STATE(176), 1,
      sym_comment,
  [4682] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(561), 1,
      aux_sym_identifier_token1,
    ACTIONS(573), 1,
      sym_prev_scope,
    STATE(177), 1,
      sym_comment,
    STATE(191), 1,
      sym_identifier,
  [4698] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(575), 1,
      sym_prev_scope,
    ACTIONS(577), 1,
      aux_sym_identifier_token1,
    STATE(58), 1,
      sym_identifier,
    STATE(178), 1,
      sym_comment,
  [4714] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(577), 1,
      aux_sym_identifier_token1,
    ACTIONS(579), 1,
      sym_prev_scope,
    STATE(126), 1,
      sym_identifier,
    STATE(179), 1,
      sym_comment,
  [4730] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(561), 1,
      aux_sym_identifier_token1,
    STATE(180), 1,
      sym_comment,
    STATE(190), 1,
      sym_identifier,
  [4743] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(561), 1,
      aux_sym_identifier_token1,
    STATE(181), 1,
      sym_comment,
    STATE(198), 1,
      sym_identifier,
  [4756] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(561), 1,
      aux_sym_identifier_token1,
    STATE(52), 1,
      sym_identifier,
    STATE(182), 1,
      sym_comment,
  [4769] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(577), 1,
      aux_sym_identifier_token1,
    STATE(118), 1,
      sym_identifier,
    STATE(183), 1,
      sym_comment,
  [4782] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(106), 1,
      anon_sym_LBRACE,
    ACTIONS(244), 1,
      anon_sym_RBRACE,
    STATE(184), 1,
      sym_comment,
  [4795] = 4,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(577), 1,
      aux_sym_identifier_token1,
    STATE(52), 1,
      sym_identifier,
    STATE(185), 1,
      sym_comment,
  [4808] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(581), 1,
      anon_sym_RBRACE,
    STATE(186), 1,
      sym_comment,
  [4818] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(583), 1,
      anon_sym_LPAREN,
    STATE(187), 1,
      sym_comment,
  [4828] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(585), 1,
      anon_sym_RBRACE,
    STATE(188), 1,
      sym_comment,
  [4838] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(106), 1,
      anon_sym_LBRACE,
    STATE(189), 1,
      sym_comment,
  [4848] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(587), 1,
      anon_sym_RBRACE2,
    STATE(190), 1,
      sym_comment,
  [4858] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(589), 1,
      anon_sym_RBRACE2,
    STATE(191), 1,
      sym_comment,
  [4868] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(192), 1,
      sym_comment,
  [4878] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(593), 1,
      anon_sym_POUND_RBRACE,
    STATE(193), 1,
      sym_comment,
  [4888] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(595), 1,
      anon_sym_RBRACE,
    STATE(194), 1,
      sym_comment,
  [4898] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(597), 1,
      ts_builtin_sym_end,
    STATE(195), 1,
      sym_comment,
  [4908] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(599), 1,
      anon_sym_RBRACE,
    STATE(196), 1,
      sym_comment,
  [4918] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(601), 1,
      anon_sym_RBRACE2,
    STATE(197), 1,
      sym_comment,
  [4928] = 3,
    ACTIONS(15), 1,
      aux_sym_comment_token1,
    ACTIONS(603), 1,
      anon_sym_RBRACE2,
    STATE(198), 1,
      sym_comment,
  [4938] = 1,
    ACTIONS(605), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(27)] = 0,
  [SMALL_STATE(28)] = 80,
  [SMALL_STATE(29)] = 160,
  [SMALL_STATE(30)] = 235,
  [SMALL_STATE(31)] = 312,
  [SMALL_STATE(32)] = 389,
  [SMALL_STATE(33)] = 466,
  [SMALL_STATE(34)] = 543,
  [SMALL_STATE(35)] = 620,
  [SMALL_STATE(36)] = 684,
  [SMALL_STATE(37)] = 746,
  [SMALL_STATE(38)] = 781,
  [SMALL_STATE(39)] = 813,
  [SMALL_STATE(40)] = 845,
  [SMALL_STATE(41)] = 877,
  [SMALL_STATE(42)] = 909,
  [SMALL_STATE(43)] = 941,
  [SMALL_STATE(44)] = 973,
  [SMALL_STATE(45)] = 1005,
  [SMALL_STATE(46)] = 1037,
  [SMALL_STATE(47)] = 1069,
  [SMALL_STATE(48)] = 1101,
  [SMALL_STATE(49)] = 1133,
  [SMALL_STATE(50)] = 1165,
  [SMALL_STATE(51)] = 1197,
  [SMALL_STATE(52)] = 1229,
  [SMALL_STATE(53)] = 1261,
  [SMALL_STATE(54)] = 1293,
  [SMALL_STATE(55)] = 1325,
  [SMALL_STATE(56)] = 1357,
  [SMALL_STATE(57)] = 1389,
  [SMALL_STATE(58)] = 1421,
  [SMALL_STATE(59)] = 1453,
  [SMALL_STATE(60)] = 1485,
  [SMALL_STATE(61)] = 1517,
  [SMALL_STATE(62)] = 1554,
  [SMALL_STATE(63)] = 1585,
  [SMALL_STATE(64)] = 1620,
  [SMALL_STATE(65)] = 1653,
  [SMALL_STATE(66)] = 1684,
  [SMALL_STATE(67)] = 1715,
  [SMALL_STATE(68)] = 1750,
  [SMALL_STATE(69)] = 1785,
  [SMALL_STATE(70)] = 1818,
  [SMALL_STATE(71)] = 1851,
  [SMALL_STATE(72)] = 1900,
  [SMALL_STATE(73)] = 1931,
  [SMALL_STATE(74)] = 1980,
  [SMALL_STATE(75)] = 2011,
  [SMALL_STATE(76)] = 2060,
  [SMALL_STATE(77)] = 2109,
  [SMALL_STATE(78)] = 2140,
  [SMALL_STATE(79)] = 2171,
  [SMALL_STATE(80)] = 2202,
  [SMALL_STATE(81)] = 2233,
  [SMALL_STATE(82)] = 2270,
  [SMALL_STATE(83)] = 2319,
  [SMALL_STATE(84)] = 2350,
  [SMALL_STATE(85)] = 2381,
  [SMALL_STATE(86)] = 2412,
  [SMALL_STATE(87)] = 2443,
  [SMALL_STATE(88)] = 2480,
  [SMALL_STATE(89)] = 2517,
  [SMALL_STATE(90)] = 2552,
  [SMALL_STATE(91)] = 2583,
  [SMALL_STATE(92)] = 2632,
  [SMALL_STATE(93)] = 2662,
  [SMALL_STATE(94)] = 2694,
  [SMALL_STATE(95)] = 2724,
  [SMALL_STATE(96)] = 2756,
  [SMALL_STATE(97)] = 2788,
  [SMALL_STATE(98)] = 2820,
  [SMALL_STATE(99)] = 2850,
  [SMALL_STATE(100)] = 2880,
  [SMALL_STATE(101)] = 2911,
  [SMALL_STATE(102)] = 2940,
  [SMALL_STATE(103)] = 2971,
  [SMALL_STATE(104)] = 3000,
  [SMALL_STATE(105)] = 3026,
  [SMALL_STATE(106)] = 3053,
  [SMALL_STATE(107)] = 3080,
  [SMALL_STATE(108)] = 3105,
  [SMALL_STATE(109)] = 3130,
  [SMALL_STATE(110)] = 3155,
  [SMALL_STATE(111)] = 3180,
  [SMALL_STATE(112)] = 3205,
  [SMALL_STATE(113)] = 3230,
  [SMALL_STATE(114)] = 3257,
  [SMALL_STATE(115)] = 3282,
  [SMALL_STATE(116)] = 3307,
  [SMALL_STATE(117)] = 3332,
  [SMALL_STATE(118)] = 3357,
  [SMALL_STATE(119)] = 3382,
  [SMALL_STATE(120)] = 3407,
  [SMALL_STATE(121)] = 3432,
  [SMALL_STATE(122)] = 3457,
  [SMALL_STATE(123)] = 3482,
  [SMALL_STATE(124)] = 3509,
  [SMALL_STATE(125)] = 3534,
  [SMALL_STATE(126)] = 3559,
  [SMALL_STATE(127)] = 3584,
  [SMALL_STATE(128)] = 3613,
  [SMALL_STATE(129)] = 3638,
  [SMALL_STATE(130)] = 3663,
  [SMALL_STATE(131)] = 3690,
  [SMALL_STATE(132)] = 3715,
  [SMALL_STATE(133)] = 3741,
  [SMALL_STATE(134)] = 3773,
  [SMALL_STATE(135)] = 3797,
  [SMALL_STATE(136)] = 3821,
  [SMALL_STATE(137)] = 3845,
  [SMALL_STATE(138)] = 3877,
  [SMALL_STATE(139)] = 3909,
  [SMALL_STATE(140)] = 3941,
  [SMALL_STATE(141)] = 3965,
  [SMALL_STATE(142)] = 3997,
  [SMALL_STATE(143)] = 4029,
  [SMALL_STATE(144)] = 4053,
  [SMALL_STATE(145)] = 4076,
  [SMALL_STATE(146)] = 4099,
  [SMALL_STATE(147)] = 4120,
  [SMALL_STATE(148)] = 4149,
  [SMALL_STATE(149)] = 4173,
  [SMALL_STATE(150)] = 4199,
  [SMALL_STATE(151)] = 4215,
  [SMALL_STATE(152)] = 4231,
  [SMALL_STATE(153)] = 4247,
  [SMALL_STATE(154)] = 4267,
  [SMALL_STATE(155)] = 4289,
  [SMALL_STATE(156)] = 4309,
  [SMALL_STATE(157)] = 4329,
  [SMALL_STATE(158)] = 4349,
  [SMALL_STATE(159)] = 4369,
  [SMALL_STATE(160)] = 4389,
  [SMALL_STATE(161)] = 4409,
  [SMALL_STATE(162)] = 4431,
  [SMALL_STATE(163)] = 4450,
  [SMALL_STATE(164)] = 4469,
  [SMALL_STATE(165)] = 4488,
  [SMALL_STATE(166)] = 4507,
  [SMALL_STATE(167)] = 4524,
  [SMALL_STATE(168)] = 4543,
  [SMALL_STATE(169)] = 4562,
  [SMALL_STATE(170)] = 4577,
  [SMALL_STATE(171)] = 4596,
  [SMALL_STATE(172)] = 4608,
  [SMALL_STATE(173)] = 4624,
  [SMALL_STATE(174)] = 4638,
  [SMALL_STATE(175)] = 4654,
  [SMALL_STATE(176)] = 4666,
  [SMALL_STATE(177)] = 4682,
  [SMALL_STATE(178)] = 4698,
  [SMALL_STATE(179)] = 4714,
  [SMALL_STATE(180)] = 4730,
  [SMALL_STATE(181)] = 4743,
  [SMALL_STATE(182)] = 4756,
  [SMALL_STATE(183)] = 4769,
  [SMALL_STATE(184)] = 4782,
  [SMALL_STATE(185)] = 4795,
  [SMALL_STATE(186)] = 4808,
  [SMALL_STATE(187)] = 4818,
  [SMALL_STATE(188)] = 4828,
  [SMALL_STATE(189)] = 4838,
  [SMALL_STATE(190)] = 4848,
  [SMALL_STATE(191)] = 4858,
  [SMALL_STATE(192)] = 4868,
  [SMALL_STATE(193)] = 4878,
  [SMALL_STATE(194)] = 4888,
  [SMALL_STATE(195)] = 4898,
  [SMALL_STATE(196)] = 4908,
  [SMALL_STATE(197)] = 4918,
  [SMALL_STATE(198)] = 4928,
  [SMALL_STATE(199)] = 4938,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [69] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(32),
  [72] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(158),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(161),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(10),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(147),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(177),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(172),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(40),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(94),
  [98] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(167),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__non_uniform_list_repeat1, 2), SHIFT_REPEAT(37),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [110] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [118] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [120] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [124] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2),
  [132] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(160),
  [135] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(161),
  [138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(10),
  [141] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(147),
  [144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(177),
  [147] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(172),
  [150] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(40),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(97),
  [156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(167),
  [159] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_value_repeat1, 2), SHIFT_REPEAT(37),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6),
  [172] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(155),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(4),
  [178] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(174),
  [181] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(179),
  [184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(127),
  [187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(167),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_dict_core_repeat1, 2, .production_id = 6), SHIFT_REPEAT(37),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dict_core, 1, .production_id = 12),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, .production_id = 1),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, .production_id = 6),
  [207] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, .production_id = 6), SHIFT_REPEAT(155),
  [210] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, .production_id = 6), SHIFT_REPEAT(4),
  [213] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, .production_id = 6), SHIFT_REPEAT(127),
  [216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, .production_id = 6), SHIFT_REPEAT(167),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, .production_id = 6), SHIFT_REPEAT(37),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 3),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 3),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_code, 2),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_code, 2),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 5, .production_id = 22),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 5, .production_id = 22),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 4, .production_id = 21),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 4, .production_id = 21),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 4, .production_id = 20),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 4, .production_id = 20),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 1, .production_id = 3),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 1, .production_id = 3),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 1, .production_id = 1),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 1, .production_id = 1),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__macro_braces, 4),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__macro_braces, 4),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro, 1),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro, 1),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 3, .production_id = 14),
  [274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 3, .production_id = 14),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 2),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 2),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__generic_preproc_call, 3, .production_id = 7),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__generic_preproc_call, 3, .production_id = 7),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__macro_no_braces, 3),
  [286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__macro_no_braces, 3),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 2),
  [290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 2),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__macro_braces, 3),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__macro_braces, 3),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_code, 3),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_code, 3),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimensions, 3, .production_id = 17),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dimensions, 3, .production_id = 17),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dict_headless, 3, .production_id = 16),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dict_headless, 3, .production_id = 16),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__macro_no_braces, 2),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__macro_no_braces, 2),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dict_headless, 2),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dict_headless, 2),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimensions, 2),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dimensions, 2),
  [320] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__non_uniform_list, 4, .production_id = 19), REDUCE(sym__non_uniform_list, 5, .production_id = 22),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 4, .production_id = 19),
  [325] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__non_uniform_list, 4, .production_id = 19), REDUCE(sym__non_uniform_list, 5, .production_id = 22),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 4, .production_id = 19),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__special_preproc_call, 1, .production_id = 2),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__special_preproc_call, 1, .production_id = 2),
  [334] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__non_uniform_list, 2), REDUCE(sym__non_uniform_list, 3, .production_id = 14),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 2),
  [339] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__non_uniform_list, 2), REDUCE(sym__non_uniform_list, 3, .production_id = 14),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dict, 3, .production_id = 11),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dict, 3, .production_id = 11),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 3, .production_id = 10),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 3, .production_id = 10),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__non_uniform_list, 3, .production_id = 9),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 3, .production_id = 9),
  [356] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__non_uniform_list, 3, .production_id = 10), REDUCE(sym__non_uniform_list, 4, .production_id = 21),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__non_uniform_list, 3, .production_id = 10), REDUCE(sym__non_uniform_list, 4, .production_id = 21),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__non_uniform_list, 3, .production_id = 9), REDUCE(sym__non_uniform_list, 4, .production_id = 20),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__non_uniform_list, 3, .production_id = 9), REDUCE(sym__non_uniform_list, 4, .production_id = 20),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dict, 4, .production_id = 11),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dict, 4, .production_id = 11),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__non_uniform_list, 2),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__special_preproc_call, 2, .production_id = 4),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__special_preproc_call, 2, .production_id = 4),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cond_preproc_call, 4, .production_id = 15),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__cond_preproc_call, 4, .production_id = 15),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_call, 1, .production_id = 2),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_call, 1, .production_id = 2),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__uniform_list, 4, .production_id = 19),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__uniform_list, 4, .production_id = 19),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dict, 5, .production_id = 11),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dict, 5, .production_id = 11),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_item, 1),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__list_item, 1),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__generic_preproc_call, 4, .production_id = 7),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__generic_preproc_call, 4, .production_id = 7),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__non_uniform_list_repeat1, 1),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__non_uniform_list_repeat1, 1),
  [424] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_dict, 4, .production_id = 11), SHIFT(84),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_key_value_repeat1, 1),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_key_value_repeat1, 1),
  [431] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_dict, 3, .production_id = 11), SHIFT(86),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1, .production_id = 3),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1, .production_id = 3),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [450] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__statement, 1), SHIFT(14),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1, .production_id = 1),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1, .production_id = 1),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 1),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dict_core_repeat1, 1),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value, 3, .production_id = 13),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_value, 3, .production_id = 13),
  [469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value, 2, .production_id = 5),
  [471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_value, 2, .production_id = 5),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 2),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dict_core_repeat1, 2),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dict_core_repeat1, 1, .production_id = 1),
  [479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dict_core_repeat1, 1, .production_id = 1),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1, .production_id = 1),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 1, .production_id = 1),
  [485] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_code_body_repeat1, 2),
  [493] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_code_body_repeat1, 2), SHIFT_REPEAT(150),
  [496] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_code_body_repeat1, 2), SHIFT_REPEAT(164),
  [499] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_code_body, 1),
  [501] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_code_body_repeat1, 1),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dimensions_repeat1, 2, .production_id = 18),
  [505] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dimensions_repeat1, 2, .production_id = 18), SHIFT_REPEAT(175),
  [508] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dimensions_repeat1, 2, .production_id = 18), SHIFT_REPEAT(169),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2),
  [545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(173),
  [548] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(173),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [563] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 1),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_literal_repeat1, 1),
  [567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [569] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dimensions_repeat1, 1, .production_id = 8),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [597] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_foam_external_scanner_create(void);
void tree_sitter_foam_external_scanner_destroy(void *);
bool tree_sitter_foam_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_foam_external_scanner_serialize(void *, char *);
void tree_sitter_foam_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_foam(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_foam_external_scanner_create,
      tree_sitter_foam_external_scanner_destroy,
      tree_sitter_foam_external_scanner_scan,
      tree_sitter_foam_external_scanner_serialize,
      tree_sitter_foam_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
