#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1023
#define LARGE_STATE_COUNT 20
#define SYMBOL_COUNT 197
#define ALIAS_COUNT 2
#define TOKEN_COUNT 85
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 99

enum {
  sym_lower_case_identifier = 1,
  anon_sym_LBRACE_DASH = 2,
  anon_sym_DASH_RBRACE = 3,
  sym_line_comment = 4,
  anon_sym_LPAREN = 5,
  anon_sym_COMMA = 6,
  anon_sym_RPAREN = 7,
  sym__upper_case_identifier_without_leading_whitespace = 8,
  sym__lower_case_identifier_without_leading_whitespace = 9,
  sym__dot_without_leading_whitespace = 10,
  anon_sym_PIPE = 11,
  anon_sym_LBRACE = 12,
  anon_sym_RBRACE = 13,
  anon_sym_SQUOTE = 14,
  aux_sym_char_constant_expr_token1 = 15,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 16,
  aux_sym_string_constant_expr_token1 = 17,
  anon_sym_DQUOTE = 18,
  aux_sym_string_constant_expr_token2 = 19,
  anon_sym_LBRACK = 20,
  anon_sym_RBRACK = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_then = 24,
  anon_sym_let = 25,
  anon_sym_in = 26,
  anon_sym_COLON_COLON = 27,
  anon_sym_left = 28,
  anon_sym_right = 29,
  anon_sym_non = 30,
  sym__glsl_begin = 31,
  sym__glsl_end = 32,
  sym_upper_case_identifier = 33,
  sym_number_literal = 34,
  sym_string_escape = 35,
  sym_invalid_string_escape = 36,
  sym_module = 37,
  sym_effect = 38,
  sym_where = 39,
  sym_import = 40,
  sym_as = 41,
  sym_exposing = 42,
  sym_case = 43,
  sym_of = 44,
  sym_type = 45,
  sym_alias = 46,
  sym_port = 47,
  sym_infix = 48,
  sym_double_dot = 49,
  sym_eq = 50,
  sym_arrow = 51,
  sym_colon = 52,
  sym_backslash = 53,
  sym_underscore = 54,
  sym_dot = 55,
  anon_sym_PLUS = 56,
  anon_sym_DASH = 57,
  anon_sym_STAR = 58,
  anon_sym_SLASH = 59,
  anon_sym_SLASH_SLASH = 60,
  anon_sym_CARET = 61,
  anon_sym_EQ_EQ = 62,
  anon_sym_SLASH_EQ = 63,
  anon_sym_LT = 64,
  anon_sym_GT = 65,
  anon_sym_LT_EQ = 66,
  anon_sym_GT_EQ = 67,
  anon_sym_AMP_AMP = 68,
  anon_sym_PIPE_PIPE = 69,
  anon_sym_PLUS_PLUS = 70,
  anon_sym_LT_PIPE = 71,
  anon_sym_PIPE_GT = 72,
  anon_sym_LT_LT = 73,
  anon_sym_GT_GT = 74,
  anon_sym_LT_SLASH_GT = 75,
  anon_sym_LT_QMARK_GT = 76,
  anon_sym_PIPE_DOT = 77,
  anon_sym_PIPE_EQ = 78,
  sym__virtual_end_decl = 79,
  sym__virtual_open_section = 80,
  sym__virtual_end_section = 81,
  sym_minus_without_trailing_whitespace = 82,
  sym_glsl_content = 83,
  sym__block_comment_content = 84,
  sym_file = 85,
  sym_block_comment = 86,
  sym_module_declaration = 87,
  aux_sym__import_list = 88,
  aux_sym__top_decl_list = 89,
  sym_exposing_list = 90,
  sym_exposed_value = 91,
  sym_exposed_type = 92,
  sym_exposed_union_constructors = 93,
  sym_exposed_operator = 94,
  sym_upper_case_qid = 95,
  sym_value_qid = 96,
  sym_field_accessor_function_expr = 97,
  sym_import_clause = 98,
  sym_as_clause = 99,
  sym_value_declaration = 100,
  sym_function_declaration_left = 101,
  sym_type_declaration = 102,
  sym_lower_type_name = 103,
  sym_union_variant = 104,
  sym__more_union_variants = 105,
  sym_type_alias_declaration = 106,
  sym_type_expression = 107,
  sym__type_expression_inner = 108,
  sym_type_ref = 109,
  sym__single_type_expression = 110,
  sym_type_ref_without_args = 111,
  sym_type_variable = 112,
  sym_record_type = 113,
  sym_field_type = 114,
  sym_tuple_type = 115,
  sym_type_annotation = 116,
  sym_port_annotation = 117,
  sym__expression = 118,
  sym_bin_op_expr = 119,
  sym_operator = 120,
  sym_operator_as_function_expr = 121,
  sym__operator_as_function_inner = 122,
  sym__call_or_atom = 123,
  sym_function_call_expr = 124,
  sym__function_call_target = 125,
  sym__atom = 126,
  sym_field_access_expr = 127,
  sym__field_access_start = 128,
  sym__field_access_segment = 129,
  sym_negate_expr = 130,
  sym_parenthesized_expr = 131,
  sym__literal_expr_group = 132,
  sym_char_constant_expr = 133,
  sym_number_constant_expr = 134,
  sym_string_constant_expr = 135,
  sym_anonymous_function_expr = 136,
  sym_value_expr = 137,
  sym_tuple_expr = 138,
  sym_unit_expr = 139,
  sym_list_expr = 140,
  sym_record_expr = 141,
  sym_record_base_identifier = 142,
  sym__record_base = 143,
  sym__record_inner = 144,
  sym_field = 145,
  sym_if_else_expr = 146,
  sym__if = 147,
  sym__then = 148,
  sym__else = 149,
  sym_case_of_expr = 150,
  sym__more_case_of_branches = 151,
  sym_case_of_branch = 152,
  sym_let_in_expr = 153,
  sym__inner_declaration = 154,
  sym_pattern = 155,
  sym_cons_pattern = 156,
  sym__single_pattern_cons = 157,
  sym__single_pattern = 158,
  sym_lower_pattern = 159,
  sym_anything_pattern = 160,
  sym_record_pattern = 161,
  sym_list_pattern = 162,
  sym_union_pattern = 163,
  sym_nullary_constructor_argument_pattern = 164,
  sym__union_argument_pattern = 165,
  sym_tuple_pattern = 166,
  sym__parenthesized_pattern = 167,
  sym_infix_declaration = 168,
  sym_glsl_code_expr = 169,
  sym_operator_identifier = 170,
  aux_sym_exposing_list_repeat1 = 171,
  aux_sym_upper_case_qid_repeat1 = 172,
  aux_sym_value_qid_repeat1 = 173,
  aux_sym_function_declaration_left_repeat1 = 174,
  aux_sym_type_declaration_repeat1 = 175,
  aux_sym_type_declaration_repeat2 = 176,
  aux_sym_union_variant_repeat1 = 177,
  aux_sym_type_expression_repeat1 = 178,
  aux_sym_record_type_repeat1 = 179,
  aux_sym_tuple_type_repeat1 = 180,
  aux_sym_bin_op_expr_repeat1 = 181,
  aux_sym_function_call_expr_repeat1 = 182,
  aux_sym_field_access_expr_repeat1 = 183,
  aux_sym_string_constant_expr_repeat1 = 184,
  aux_sym_string_constant_expr_repeat2 = 185,
  aux_sym_anonymous_function_expr_repeat1 = 186,
  aux_sym_tuple_expr_repeat1 = 187,
  aux_sym_list_expr_repeat1 = 188,
  aux_sym__record_inner_repeat1 = 189,
  aux_sym_if_else_expr_repeat1 = 190,
  aux_sym__more_case_of_branches_repeat1 = 191,
  aux_sym_let_in_expr_repeat1 = 192,
  aux_sym_record_pattern_repeat1 = 193,
  aux_sym_list_pattern_repeat1 = 194,
  aux_sym_union_pattern_repeat1 = 195,
  aux_sym_tuple_pattern_repeat1 = 196,
  alias_sym_close_char = 197,
  alias_sym_close_quote = 198,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_lower_case_identifier] = "lower_case_identifier",
  [anon_sym_LBRACE_DASH] = "{-",
  [anon_sym_DASH_RBRACE] = "-}",
  [sym_line_comment] = "line_comment",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [sym__upper_case_identifier_without_leading_whitespace] = "upper_case_identifier",
  [sym__lower_case_identifier_without_leading_whitespace] = "lower_case_identifier",
  [sym__dot_without_leading_whitespace] = "dot",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SQUOTE] = "open_char",
  [aux_sym_char_constant_expr_token1] = "regular_string_part",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "open_quote",
  [aux_sym_string_constant_expr_token1] = "regular_string_part",
  [anon_sym_DQUOTE] = "open_quote",
  [aux_sym_string_constant_expr_token2] = "regular_string_part",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_let] = "let",
  [anon_sym_in] = "in",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_left] = "lower_case_identifier",
  [anon_sym_right] = "lower_case_identifier",
  [anon_sym_non] = "lower_case_identifier",
  [sym__glsl_begin] = "_glsl_begin",
  [sym__glsl_end] = "_glsl_end",
  [sym_upper_case_identifier] = "upper_case_identifier",
  [sym_number_literal] = "number_literal",
  [sym_string_escape] = "string_escape",
  [sym_invalid_string_escape] = "invalid_string_escape",
  [sym_module] = "module",
  [sym_effect] = "effect",
  [sym_where] = "where",
  [sym_import] = "import",
  [sym_as] = "as",
  [sym_exposing] = "exposing",
  [sym_case] = "case",
  [sym_of] = "of",
  [sym_type] = "type",
  [sym_alias] = "alias",
  [sym_port] = "port",
  [sym_infix] = "infix",
  [sym_double_dot] = "double_dot",
  [sym_eq] = "eq",
  [sym_arrow] = "arrow",
  [sym_colon] = "colon",
  [sym_backslash] = "backslash",
  [sym_underscore] = "underscore",
  [sym_dot] = "dot",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_LT_PIPE] = "<|",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LT_SLASH_GT] = "</>",
  [anon_sym_LT_QMARK_GT] = "<\?>",
  [anon_sym_PIPE_DOT] = "|.",
  [anon_sym_PIPE_EQ] = "|=",
  [sym__virtual_end_decl] = "_virtual_end_decl",
  [sym__virtual_open_section] = "_virtual_open_section",
  [sym__virtual_end_section] = "_virtual_end_section",
  [sym_minus_without_trailing_whitespace] = "operator_identifier",
  [sym_glsl_content] = "glsl_content",
  [sym__block_comment_content] = "_block_comment_content",
  [sym_file] = "file",
  [sym_block_comment] = "block_comment",
  [sym_module_declaration] = "module_declaration",
  [aux_sym__import_list] = "_import_list",
  [aux_sym__top_decl_list] = "_top_decl_list",
  [sym_exposing_list] = "exposing_list",
  [sym_exposed_value] = "exposed_value",
  [sym_exposed_type] = "exposed_type",
  [sym_exposed_union_constructors] = "exposed_union_constructors",
  [sym_exposed_operator] = "exposed_operator",
  [sym_upper_case_qid] = "upper_case_qid",
  [sym_value_qid] = "value_qid",
  [sym_field_accessor_function_expr] = "field_accessor_function_expr",
  [sym_import_clause] = "import_clause",
  [sym_as_clause] = "as_clause",
  [sym_value_declaration] = "value_declaration",
  [sym_function_declaration_left] = "function_declaration_left",
  [sym_type_declaration] = "type_declaration",
  [sym_lower_type_name] = "lower_type_name",
  [sym_union_variant] = "union_variant",
  [sym__more_union_variants] = "_more_union_variants",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_type_expression] = "type_expression",
  [sym__type_expression_inner] = "_type_expression_inner",
  [sym_type_ref] = "type_ref",
  [sym__single_type_expression] = "_single_type_expression",
  [sym_type_ref_without_args] = "type_ref",
  [sym_type_variable] = "type_variable",
  [sym_record_type] = "record_type",
  [sym_field_type] = "field_type",
  [sym_tuple_type] = "tuple_type",
  [sym_type_annotation] = "type_annotation",
  [sym_port_annotation] = "port_annotation",
  [sym__expression] = "_expression",
  [sym_bin_op_expr] = "bin_op_expr",
  [sym_operator] = "operator",
  [sym_operator_as_function_expr] = "operator_as_function_expr",
  [sym__operator_as_function_inner] = "_operator_as_function_inner",
  [sym__call_or_atom] = "_call_or_atom",
  [sym_function_call_expr] = "function_call_expr",
  [sym__function_call_target] = "_function_call_target",
  [sym__atom] = "_atom",
  [sym_field_access_expr] = "field_access_expr",
  [sym__field_access_start] = "_field_access_start",
  [sym__field_access_segment] = "_field_access_segment",
  [sym_negate_expr] = "negate_expr",
  [sym_parenthesized_expr] = "parenthesized_expr",
  [sym__literal_expr_group] = "_literal_expr_group",
  [sym_char_constant_expr] = "char_constant_expr",
  [sym_number_constant_expr] = "number_constant_expr",
  [sym_string_constant_expr] = "string_constant_expr",
  [sym_anonymous_function_expr] = "anonymous_function_expr",
  [sym_value_expr] = "value_expr",
  [sym_tuple_expr] = "tuple_expr",
  [sym_unit_expr] = "unit_expr",
  [sym_list_expr] = "list_expr",
  [sym_record_expr] = "record_expr",
  [sym_record_base_identifier] = "record_base_identifier",
  [sym__record_base] = "_record_base",
  [sym__record_inner] = "_record_inner",
  [sym_field] = "field",
  [sym_if_else_expr] = "if_else_expr",
  [sym__if] = "_if",
  [sym__then] = "_then",
  [sym__else] = "_else",
  [sym_case_of_expr] = "case_of_expr",
  [sym__more_case_of_branches] = "_more_case_of_branches",
  [sym_case_of_branch] = "case_of_branch",
  [sym_let_in_expr] = "let_in_expr",
  [sym__inner_declaration] = "_inner_declaration",
  [sym_pattern] = "pattern",
  [sym_cons_pattern] = "cons_pattern",
  [sym__single_pattern_cons] = "_single_pattern_cons",
  [sym__single_pattern] = "_single_pattern",
  [sym_lower_pattern] = "lower_pattern",
  [sym_anything_pattern] = "anything_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym_nullary_constructor_argument_pattern] = "nullary_constructor_argument_pattern",
  [sym__union_argument_pattern] = "_union_argument_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__parenthesized_pattern] = "_parenthesized_pattern",
  [sym_infix_declaration] = "infix_declaration",
  [sym_glsl_code_expr] = "glsl_code_expr",
  [sym_operator_identifier] = "operator_identifier",
  [aux_sym_exposing_list_repeat1] = "exposing_list_repeat1",
  [aux_sym_upper_case_qid_repeat1] = "upper_case_qid_repeat1",
  [aux_sym_value_qid_repeat1] = "value_qid_repeat1",
  [aux_sym_function_declaration_left_repeat1] = "function_declaration_left_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_type_declaration_repeat2] = "type_declaration_repeat2",
  [aux_sym_union_variant_repeat1] = "union_variant_repeat1",
  [aux_sym_type_expression_repeat1] = "type_expression_repeat1",
  [aux_sym_record_type_repeat1] = "record_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_bin_op_expr_repeat1] = "bin_op_expr_repeat1",
  [aux_sym_function_call_expr_repeat1] = "function_call_expr_repeat1",
  [aux_sym_field_access_expr_repeat1] = "field_access_expr_repeat1",
  [aux_sym_string_constant_expr_repeat1] = "string_constant_expr_repeat1",
  [aux_sym_string_constant_expr_repeat2] = "string_constant_expr_repeat2",
  [aux_sym_anonymous_function_expr_repeat1] = "anonymous_function_expr_repeat1",
  [aux_sym_tuple_expr_repeat1] = "tuple_expr_repeat1",
  [aux_sym_list_expr_repeat1] = "list_expr_repeat1",
  [aux_sym__record_inner_repeat1] = "_record_inner_repeat1",
  [aux_sym_if_else_expr_repeat1] = "if_else_expr_repeat1",
  [aux_sym__more_case_of_branches_repeat1] = "_more_case_of_branches_repeat1",
  [aux_sym_let_in_expr_repeat1] = "let_in_expr_repeat1",
  [aux_sym_record_pattern_repeat1] = "record_pattern_repeat1",
  [aux_sym_list_pattern_repeat1] = "list_pattern_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [alias_sym_close_char] = "close_char",
  [alias_sym_close_quote] = "close_quote",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_lower_case_identifier] = sym_lower_case_identifier,
  [anon_sym_LBRACE_DASH] = anon_sym_LBRACE_DASH,
  [anon_sym_DASH_RBRACE] = anon_sym_DASH_RBRACE,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym__upper_case_identifier_without_leading_whitespace] = sym_upper_case_identifier,
  [sym__lower_case_identifier_without_leading_whitespace] = sym_lower_case_identifier,
  [sym__dot_without_leading_whitespace] = sym_dot,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_constant_expr_token1] = aux_sym_char_constant_expr_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym_string_constant_expr_token1] = aux_sym_char_constant_expr_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym_string_constant_expr_token2] = aux_sym_char_constant_expr_token1,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_left] = sym_lower_case_identifier,
  [anon_sym_right] = sym_lower_case_identifier,
  [anon_sym_non] = sym_lower_case_identifier,
  [sym__glsl_begin] = sym__glsl_begin,
  [sym__glsl_end] = sym__glsl_end,
  [sym_upper_case_identifier] = sym_upper_case_identifier,
  [sym_number_literal] = sym_number_literal,
  [sym_string_escape] = sym_string_escape,
  [sym_invalid_string_escape] = sym_invalid_string_escape,
  [sym_module] = sym_module,
  [sym_effect] = sym_effect,
  [sym_where] = sym_where,
  [sym_import] = sym_import,
  [sym_as] = sym_as,
  [sym_exposing] = sym_exposing,
  [sym_case] = sym_case,
  [sym_of] = sym_of,
  [sym_type] = sym_type,
  [sym_alias] = sym_alias,
  [sym_port] = sym_port,
  [sym_infix] = sym_infix,
  [sym_double_dot] = sym_double_dot,
  [sym_eq] = sym_eq,
  [sym_arrow] = sym_arrow,
  [sym_colon] = sym_colon,
  [sym_backslash] = sym_backslash,
  [sym_underscore] = sym_underscore,
  [sym_dot] = sym_dot,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_LT_PIPE] = anon_sym_LT_PIPE,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LT_SLASH_GT] = anon_sym_LT_SLASH_GT,
  [anon_sym_LT_QMARK_GT] = anon_sym_LT_QMARK_GT,
  [anon_sym_PIPE_DOT] = anon_sym_PIPE_DOT,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [sym__virtual_end_decl] = sym__virtual_end_decl,
  [sym__virtual_open_section] = sym__virtual_open_section,
  [sym__virtual_end_section] = sym__virtual_end_section,
  [sym_minus_without_trailing_whitespace] = sym_operator_identifier,
  [sym_glsl_content] = sym_glsl_content,
  [sym__block_comment_content] = sym__block_comment_content,
  [sym_file] = sym_file,
  [sym_block_comment] = sym_block_comment,
  [sym_module_declaration] = sym_module_declaration,
  [aux_sym__import_list] = aux_sym__import_list,
  [aux_sym__top_decl_list] = aux_sym__top_decl_list,
  [sym_exposing_list] = sym_exposing_list,
  [sym_exposed_value] = sym_exposed_value,
  [sym_exposed_type] = sym_exposed_type,
  [sym_exposed_union_constructors] = sym_exposed_union_constructors,
  [sym_exposed_operator] = sym_exposed_operator,
  [sym_upper_case_qid] = sym_upper_case_qid,
  [sym_value_qid] = sym_value_qid,
  [sym_field_accessor_function_expr] = sym_field_accessor_function_expr,
  [sym_import_clause] = sym_import_clause,
  [sym_as_clause] = sym_as_clause,
  [sym_value_declaration] = sym_value_declaration,
  [sym_function_declaration_left] = sym_function_declaration_left,
  [sym_type_declaration] = sym_type_declaration,
  [sym_lower_type_name] = sym_lower_type_name,
  [sym_union_variant] = sym_union_variant,
  [sym__more_union_variants] = sym__more_union_variants,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_type_expression] = sym_type_expression,
  [sym__type_expression_inner] = sym__type_expression_inner,
  [sym_type_ref] = sym_type_ref,
  [sym__single_type_expression] = sym__single_type_expression,
  [sym_type_ref_without_args] = sym_type_ref,
  [sym_type_variable] = sym_type_variable,
  [sym_record_type] = sym_record_type,
  [sym_field_type] = sym_field_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_type_annotation] = sym_type_annotation,
  [sym_port_annotation] = sym_port_annotation,
  [sym__expression] = sym__expression,
  [sym_bin_op_expr] = sym_bin_op_expr,
  [sym_operator] = sym_operator,
  [sym_operator_as_function_expr] = sym_operator_as_function_expr,
  [sym__operator_as_function_inner] = sym__operator_as_function_inner,
  [sym__call_or_atom] = sym__call_or_atom,
  [sym_function_call_expr] = sym_function_call_expr,
  [sym__function_call_target] = sym__function_call_target,
  [sym__atom] = sym__atom,
  [sym_field_access_expr] = sym_field_access_expr,
  [sym__field_access_start] = sym__field_access_start,
  [sym__field_access_segment] = sym__field_access_segment,
  [sym_negate_expr] = sym_negate_expr,
  [sym_parenthesized_expr] = sym_parenthesized_expr,
  [sym__literal_expr_group] = sym__literal_expr_group,
  [sym_char_constant_expr] = sym_char_constant_expr,
  [sym_number_constant_expr] = sym_number_constant_expr,
  [sym_string_constant_expr] = sym_string_constant_expr,
  [sym_anonymous_function_expr] = sym_anonymous_function_expr,
  [sym_value_expr] = sym_value_expr,
  [sym_tuple_expr] = sym_tuple_expr,
  [sym_unit_expr] = sym_unit_expr,
  [sym_list_expr] = sym_list_expr,
  [sym_record_expr] = sym_record_expr,
  [sym_record_base_identifier] = sym_record_base_identifier,
  [sym__record_base] = sym__record_base,
  [sym__record_inner] = sym__record_inner,
  [sym_field] = sym_field,
  [sym_if_else_expr] = sym_if_else_expr,
  [sym__if] = sym__if,
  [sym__then] = sym__then,
  [sym__else] = sym__else,
  [sym_case_of_expr] = sym_case_of_expr,
  [sym__more_case_of_branches] = sym__more_case_of_branches,
  [sym_case_of_branch] = sym_case_of_branch,
  [sym_let_in_expr] = sym_let_in_expr,
  [sym__inner_declaration] = sym__inner_declaration,
  [sym_pattern] = sym_pattern,
  [sym_cons_pattern] = sym_cons_pattern,
  [sym__single_pattern_cons] = sym__single_pattern_cons,
  [sym__single_pattern] = sym__single_pattern,
  [sym_lower_pattern] = sym_lower_pattern,
  [sym_anything_pattern] = sym_anything_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym_nullary_constructor_argument_pattern] = sym_nullary_constructor_argument_pattern,
  [sym__union_argument_pattern] = sym__union_argument_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__parenthesized_pattern] = sym__parenthesized_pattern,
  [sym_infix_declaration] = sym_infix_declaration,
  [sym_glsl_code_expr] = sym_glsl_code_expr,
  [sym_operator_identifier] = sym_operator_identifier,
  [aux_sym_exposing_list_repeat1] = aux_sym_exposing_list_repeat1,
  [aux_sym_upper_case_qid_repeat1] = aux_sym_upper_case_qid_repeat1,
  [aux_sym_value_qid_repeat1] = aux_sym_value_qid_repeat1,
  [aux_sym_function_declaration_left_repeat1] = aux_sym_function_declaration_left_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_type_declaration_repeat2] = aux_sym_type_declaration_repeat2,
  [aux_sym_union_variant_repeat1] = aux_sym_union_variant_repeat1,
  [aux_sym_type_expression_repeat1] = aux_sym_type_expression_repeat1,
  [aux_sym_record_type_repeat1] = aux_sym_record_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_bin_op_expr_repeat1] = aux_sym_bin_op_expr_repeat1,
  [aux_sym_function_call_expr_repeat1] = aux_sym_function_call_expr_repeat1,
  [aux_sym_field_access_expr_repeat1] = aux_sym_field_access_expr_repeat1,
  [aux_sym_string_constant_expr_repeat1] = aux_sym_string_constant_expr_repeat1,
  [aux_sym_string_constant_expr_repeat2] = aux_sym_string_constant_expr_repeat2,
  [aux_sym_anonymous_function_expr_repeat1] = aux_sym_anonymous_function_expr_repeat1,
  [aux_sym_tuple_expr_repeat1] = aux_sym_tuple_expr_repeat1,
  [aux_sym_list_expr_repeat1] = aux_sym_list_expr_repeat1,
  [aux_sym__record_inner_repeat1] = aux_sym__record_inner_repeat1,
  [aux_sym_if_else_expr_repeat1] = aux_sym_if_else_expr_repeat1,
  [aux_sym__more_case_of_branches_repeat1] = aux_sym__more_case_of_branches_repeat1,
  [aux_sym_let_in_expr_repeat1] = aux_sym_let_in_expr_repeat1,
  [aux_sym_record_pattern_repeat1] = aux_sym_record_pattern_repeat1,
  [aux_sym_list_pattern_repeat1] = aux_sym_list_pattern_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [alias_sym_close_char] = alias_sym_close_char,
  [alias_sym_close_quote] = alias_sym_close_quote,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_lower_case_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__upper_case_identifier_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym__lower_case_identifier_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym__dot_without_leading_whitespace] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_char_constant_expr_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_constant_expr_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_constant_expr_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_left] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_right] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_non] = {
    .visible = true,
    .named = true,
  },
  [sym__glsl_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__glsl_end] = {
    .visible = false,
    .named = true,
  },
  [sym_upper_case_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_invalid_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_effect] = {
    .visible = true,
    .named = true,
  },
  [sym_where] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_as] = {
    .visible = true,
    .named = true,
  },
  [sym_exposing] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_of] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_port] = {
    .visible = true,
    .named = true,
  },
  [sym_infix] = {
    .visible = true,
    .named = true,
  },
  [sym_double_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym__virtual_end_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_open_section] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_end_section] = {
    .visible = false,
    .named = true,
  },
  [sym_minus_without_trailing_whitespace] = {
    .visible = true,
    .named = true,
  },
  [sym_glsl_content] = {
    .visible = true,
    .named = true,
  },
  [sym__block_comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__import_list] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__top_decl_list] = {
    .visible = false,
    .named = false,
  },
  [sym_exposing_list] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_value] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_type] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_union_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_exposed_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_upper_case_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_value_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_field_accessor_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_as_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_value_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration_left] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lower_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_union_variant] = {
    .visible = true,
    .named = true,
  },
  [sym__more_union_variants] = {
    .visible = false,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expression_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_type_ref] = {
    .visible = true,
    .named = true,
  },
  [sym__single_type_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_type_ref_without_args] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_port_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_bin_op_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_as_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__operator_as_function_inner] = {
    .visible = false,
    .named = true,
  },
  [sym__call_or_atom] = {
    .visible = false,
    .named = true,
  },
  [sym_function_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__function_call_target] = {
    .visible = false,
    .named = true,
  },
  [sym__atom] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__field_access_start] = {
    .visible = false,
    .named = true,
  },
  [sym__field_access_segment] = {
    .visible = false,
    .named = true,
  },
  [sym_negate_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_expr_group] = {
    .visible = false,
    .named = true,
  },
  [sym_char_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_number_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_string_constant_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_value_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_list_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_record_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_record_base_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__record_base] = {
    .visible = false,
    .named = true,
  },
  [sym__record_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_if_else_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__if] = {
    .visible = false,
    .named = true,
  },
  [sym__then] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym_case_of_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__more_case_of_branches] = {
    .visible = false,
    .named = true,
  },
  [sym_case_of_branch] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__inner_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_cons_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__single_pattern_cons] = {
    .visible = false,
    .named = true,
  },
  [sym__single_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_lower_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_anything_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nullary_constructor_argument_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__union_argument_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_infix_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_glsl_code_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_exposing_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_upper_case_qid_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_qid_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_declaration_left_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_variant_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bin_op_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_call_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_access_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_constant_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_constant_expr_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__record_inner_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_else_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__more_case_of_branches_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_close_char] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_close_quote] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_arg = 1,
  field_argPattern = 2,
  field_asClause = 3,
  field_associativity = 4,
  field_baseRecord = 5,
  field_body = 6,
  field_branch = 7,
  field_child = 8,
  field_constructor = 9,
  field_content = 10,
  field_doubleDot = 11,
  field_exposing = 12,
  field_expr = 13,
  field_exprList = 14,
  field_expression = 15,
  field_field = 16,
  field_fieldType = 17,
  field_functionDeclarationLeft = 18,
  field_moduleDeclaration = 19,
  field_moduleName = 20,
  field_name = 21,
  field_operator = 22,
  field_param = 23,
  field_part = 24,
  field_pattern = 25,
  field_patternAs = 26,
  field_patternList = 27,
  field_precedence = 28,
  field_target = 29,
  field_typeExpression = 30,
  field_typeName = 31,
  field_typeVariable = 32,
  field_unionVariant = 33,
  field_unitExpr = 34,
  field_valueDeclaration = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_argPattern] = "argPattern",
  [field_asClause] = "asClause",
  [field_associativity] = "associativity",
  [field_baseRecord] = "baseRecord",
  [field_body] = "body",
  [field_branch] = "branch",
  [field_child] = "child",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_doubleDot] = "doubleDot",
  [field_exposing] = "exposing",
  [field_expr] = "expr",
  [field_exprList] = "exprList",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_fieldType] = "fieldType",
  [field_functionDeclarationLeft] = "functionDeclarationLeft",
  [field_moduleDeclaration] = "moduleDeclaration",
  [field_moduleName] = "moduleName",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_param] = "param",
  [field_part] = "part",
  [field_pattern] = "pattern",
  [field_patternAs] = "patternAs",
  [field_patternList] = "patternList",
  [field_precedence] = "precedence",
  [field_target] = "target",
  [field_typeExpression] = "typeExpression",
  [field_typeName] = "typeName",
  [field_typeVariable] = "typeVariable",
  [field_unionVariant] = "unionVariant",
  [field_unitExpr] = "unitExpr",
  [field_valueDeclaration] = "valueDeclaration",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 1},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 1},
  [13] = {.index = 10, .length = 1},
  [14] = {.index = 11, .length = 2},
  [15] = {.index = 13, .length = 1},
  [16] = {.index = 14, .length = 1},
  [17] = {.index = 15, .length = 1},
  [18] = {.index = 16, .length = 2},
  [19] = {.index = 18, .length = 2},
  [20] = {.index = 20, .length = 2},
  [21] = {.index = 22, .length = 1},
  [22] = {.index = 23, .length = 2},
  [23] = {.index = 25, .length = 1},
  [24] = {.index = 26, .length = 2},
  [25] = {.index = 28, .length = 2},
  [26] = {.index = 30, .length = 2},
  [27] = {.index = 32, .length = 2},
  [28] = {.index = 34, .length = 2},
  [29] = {.index = 36, .length = 2},
  [30] = {.index = 38, .length = 2},
  [31] = {.index = 40, .length = 2},
  [32] = {.index = 42, .length = 1},
  [33] = {.index = 43, .length = 1},
  [34] = {.index = 44, .length = 3},
  [35] = {.index = 47, .length = 2},
  [36] = {.index = 49, .length = 2},
  [37] = {.index = 51, .length = 2},
  [38] = {.index = 53, .length = 1},
  [39] = {.index = 54, .length = 1},
  [40] = {.index = 55, .length = 2},
  [41] = {.index = 57, .length = 2},
  [42] = {.index = 59, .length = 1},
  [43] = {.index = 60, .length = 2},
  [44] = {.index = 62, .length = 1},
  [45] = {.index = 63, .length = 1},
  [46] = {.index = 64, .length = 2},
  [47] = {.index = 66, .length = 1},
  [48] = {.index = 67, .length = 3},
  [49] = {.index = 70, .length = 3},
  [50] = {.index = 73, .length = 2},
  [51] = {.index = 75, .length = 1},
  [52] = {.index = 76, .length = 1},
  [53] = {.index = 77, .length = 2},
  [54] = {.index = 79, .length = 2},
  [55] = {.index = 81, .length = 2},
  [56] = {.index = 83, .length = 1},
  [57] = {.index = 84, .length = 1},
  [58] = {.index = 85, .length = 3},
  [59] = {.index = 88, .length = 3},
  [60] = {.index = 91, .length = 2},
  [61] = {.index = 93, .length = 1},
  [62] = {.index = 94, .length = 2},
  [63] = {.index = 96, .length = 2},
  [64] = {.index = 98, .length = 2},
  [65] = {.index = 100, .length = 2},
  [66] = {.index = 102, .length = 2},
  [67] = {.index = 104, .length = 1},
  [68] = {.index = 105, .length = 2},
  [69] = {.index = 107, .length = 1},
  [70] = {.index = 108, .length = 2},
  [71] = {.index = 110, .length = 4},
  [72] = {.index = 114, .length = 3},
  [73] = {.index = 117, .length = 3},
  [74] = {.index = 120, .length = 1},
  [75] = {.index = 121, .length = 2},
  [76] = {.index = 123, .length = 2},
  [77] = {.index = 125, .length = 2},
  [78] = {.index = 127, .length = 3},
  [79] = {.index = 130, .length = 1},
  [80] = {.index = 131, .length = 2},
  [81] = {.index = 133, .length = 2},
  [82] = {.index = 135, .length = 2},
  [83] = {.index = 137, .length = 2},
  [84] = {.index = 139, .length = 4},
  [85] = {.index = 143, .length = 3},
  [86] = {.index = 146, .length = 1},
  [87] = {.index = 147, .length = 2},
  [88] = {.index = 149, .length = 2},
  [89] = {.index = 151, .length = 2},
  [90] = {.index = 153, .length = 2},
  [91] = {.index = 155, .length = 1},
  [92] = {.index = 156, .length = 2},
  [93] = {.index = 158, .length = 3},
  [94] = {.index = 161, .length = 1},
  [95] = {.index = 162, .length = 3},
  [96] = {.index = 165, .length = 2},
  [97] = {.index = 167, .length = 2},
  [98] = {.index = 169, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_constructor, 0},
  [1] =
    {field_child, 0},
  [2] =
    {field_child, 0, .inherited = true},
  [3] =
    {field_pattern, 1},
  [4] =
    {field_moduleName, 1},
  [5] =
    {field_moduleDeclaration, 0},
  [6] =
    {field_argPattern, 1},
    {field_constructor, 0},
  [8] =
    {field_child, 1},
  [9] =
    {field_patternList, 1},
  [10] =
    {field_part, 1},
  [11] =
    {field_name, 0},
    {field_typeExpression, 2},
  [13] =
    {field_part, 0, .inherited = true},
  [14] =
    {field_part, 0},
  [15] =
    {field_unitExpr, 0},
  [16] =
    {field_exposing, 2},
    {field_name, 1},
  [18] =
    {field_exposing, 2},
    {field_moduleName, 1},
  [20] =
    {field_asClause, 2},
    {field_moduleName, 1},
  [22] =
    {field_name, 0},
  [23] =
    {field_body, 2},
    {field_functionDeclarationLeft, 0},
  [25] =
    {field_operator, 0, .inherited = true},
  [26] =
    {field_body, 2},
    {field_pattern, 0},
  [28] =
    {field_child, 0},
    {field_patternAs, 2},
  [30] =
    {field_part, 0},
    {field_part, 2},
  [32] =
    {field_child, 0, .inherited = true},
    {field_patternAs, 2},
  [34] =
    {field_patternList, 1},
    {field_patternList, 2, .inherited = true},
  [36] =
    {field_patternList, 0, .inherited = true},
    {field_patternList, 1, .inherited = true},
  [38] =
    {field_part, 1},
    {field_part, 2, .inherited = true},
  [40] =
    {field_part, 0, .inherited = true},
    {field_part, 1, .inherited = true},
  [42] =
    {field_part, 1, .inherited = true},
  [43] =
    {field_name, 1},
  [44] =
    {field_asClause, 2},
    {field_exposing, 3},
    {field_moduleName, 1},
  [47] =
    {field_name, 1},
    {field_unionVariant, 3},
  [49] =
    {field_name, 1},
    {field_typeExpression, 3},
  [51] =
    {field_exposing, 3},
    {field_name, 2},
  [53] =
    {field_field, 0},
  [54] =
    {field_exprList, 1},
  [55] =
    {field_part, 0},
    {field_part, 1},
  [57] =
    {field_arg, 1},
    {field_target, 0},
  [59] =
    {field_target, 0},
  [60] =
    {field_pattern, 1},
    {field_pattern, 3},
  [62] =
    {field_fieldType, 1},
  [63] =
    {field_baseRecord, 0},
  [64] =
    {field_name, 0},
    {field_part, 1, .inherited = true},
  [66] =
    {field_unionVariant, 0, .inherited = true},
  [67] =
    {field_name, 1},
    {field_unionVariant, 3},
    {field_unionVariant, 4, .inherited = true},
  [70] =
    {field_name, 1},
    {field_typeName, 2},
    {field_unionVariant, 4},
  [73] =
    {field_name, 2},
    {field_typeExpression, 4},
  [75] =
    {field_expression, 1},
  [76] =
    {field_operator, 1},
  [77] =
    {field_baseRecord, 0, .inherited = true},
    {field_field, 1},
  [79] =
    {field_baseRecord, 1, .inherited = true},
    {field_field, 1, .inherited = true},
  [81] =
    {field_field, 0},
    {field_field, 1, .inherited = true},
  [83] =
    {field_valueDeclaration, 0},
  [84] =
    {field_content, 1},
  [85] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
  [88] =
    {field_pattern, 1},
    {field_pattern, 3},
    {field_pattern, 4, .inherited = true},
  [91] =
    {field_pattern, 0, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [93] =
    {field_typeExpression, 1},
  [94] =
    {field_typeExpression, 1},
    {field_typeExpression, 2, .inherited = true},
  [96] =
    {field_typeExpression, 0, .inherited = true},
    {field_typeExpression, 1, .inherited = true},
  [98] =
    {field_fieldType, 1},
    {field_fieldType, 2, .inherited = true},
  [100] =
    {field_fieldType, 0, .inherited = true},
    {field_fieldType, 1, .inherited = true},
  [102] =
    {field_baseRecord, 1, .inherited = true},
    {field_fieldType, 2},
  [104] =
    {field_doubleDot, 2},
  [105] =
    {field_exposing, 5},
    {field_name, 2},
  [107] =
    {field_unionVariant, 1},
  [108] =
    {field_unionVariant, 0, .inherited = true},
    {field_unionVariant, 1, .inherited = true},
  [110] =
    {field_name, 1},
    {field_typeName, 2},
    {field_unionVariant, 4},
    {field_unionVariant, 5, .inherited = true},
  [114] =
    {field_name, 2},
    {field_typeExpression, 5},
    {field_typeVariable, 3},
  [117] =
    {field_associativity, 1},
    {field_operator, 3, .inherited = true},
    {field_precedence, 2},
  [120] =
    {field_expr, 1},
  [121] =
    {field_expr, 1},
    {field_expr, 2, .inherited = true},
  [123] =
    {field_expr, 0, .inherited = true},
    {field_expr, 1, .inherited = true},
  [125] =
    {field_expression, 2},
    {field_name, 0},
  [127] =
    {field_baseRecord, 0, .inherited = true},
    {field_field, 1},
    {field_field, 2, .inherited = true},
  [130] =
    {field_field, 1},
  [131] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [133] =
    {field_exprList, 1},
    {field_exprList, 2, .inherited = true},
  [135] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
  [137] =
    {field_expr, 3},
    {field_param, 1},
  [139] =
    {field_exprList, 0, .inherited = true},
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
    {field_exprList, 3, .inherited = true},
  [143] =
    {field_baseRecord, 1, .inherited = true},
    {field_fieldType, 2},
    {field_fieldType, 3, .inherited = true},
  [146] =
    {field_valueDeclaration, 1, .inherited = true},
  [147] =
    {field_valueDeclaration, 0, .inherited = true},
    {field_valueDeclaration, 1, .inherited = true},
  [149] =
    {field_exprList, 1, .inherited = true},
    {field_exprList, 2, .inherited = true},
  [151] =
    {field_body, 5},
    {field_valueDeclaration, 2, .inherited = true},
  [153] =
    {field_branch, 4},
    {field_expr, 1},
  [155] =
    {field_branch, 0, .inherited = true},
  [156] =
    {field_branch, 5},
    {field_expr, 2},
  [158] =
    {field_body, 6},
    {field_valueDeclaration, 2, .inherited = true},
    {field_valueDeclaration, 3, .inherited = true},
  [161] =
    {field_branch, 1},
  [162] =
    {field_branch, 4},
    {field_branch, 5, .inherited = true},
    {field_expr, 1},
  [165] =
    {field_branch, 0, .inherited = true},
    {field_branch, 1, .inherited = true},
  [167] =
    {field_expr, 2},
    {field_pattern, 0},
  [169] =
    {field_branch, 5},
    {field_branch, 6, .inherited = true},
    {field_expr, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [1] = alias_sym_close_quote,
  },
  [11] = {
    [2] = alias_sym_close_char,
  },
  [12] = {
    [2] = alias_sym_close_quote,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym__upper_case_identifier_without_leading_whitespace_character_set_1(int32_t c) {
  return (c < 7760
    ? (c < 990
      ? (c < 430
        ? (c < 330
          ? (c < 288
            ? (c < 268
              ? (c < 258
                ? (c < 216
                  ? (c < 192
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 214)
                  : (c <= 222 || c == 256))
                : (c <= 258 || (c < 264
                  ? (c < 262
                    ? c == 260
                    : c <= 262)
                  : (c <= 264 || c == 266))))
              : (c <= 268 || (c < 278
                ? (c < 274
                  ? (c < 272
                    ? c == 270
                    : c <= 272)
                  : (c <= 274 || c == 276))
                : (c <= 278 || (c < 284
                  ? (c < 282
                    ? c == 280
                    : c <= 282)
                  : (c <= 284 || c == 286))))))
            : (c <= 288 || (c < 308
              ? (c < 298
                ? (c < 294
                  ? (c < 292
                    ? c == 290
                    : c <= 292)
                  : (c <= 294 || c == 296))
                : (c <= 298 || (c < 304
                  ? (c < 302
                    ? c == 300
                    : c <= 302)
                  : (c <= 304 || c == 306))))
              : (c <= 308 || (c < 319
                ? (c < 315
                  ? (c < 313
                    ? c == 310
                    : c <= 313)
                  : (c <= 315 || c == 317))
                : (c <= 319 || (c < 325
                  ? (c < 323
                    ? c == 321
                    : c <= 323)
                  : (c <= 325 || c == 327))))))))
          : (c <= 330 || (c < 370
            ? (c < 350
              ? (c < 340
                ? (c < 336
                  ? (c < 334
                    ? c == 332
                    : c <= 334)
                  : (c <= 336 || c == 338))
                : (c <= 340 || (c < 346
                  ? (c < 344
                    ? c == 342
                    : c <= 344)
                  : (c <= 346 || c == 348))))
              : (c <= 350 || (c < 360
                ? (c < 356
                  ? (c < 354
                    ? c == 352
                    : c <= 354)
                  : (c <= 356 || c == 358))
                : (c <= 360 || (c < 366
                  ? (c < 364
                    ? c == 362
                    : c <= 364)
                  : (c <= 366 || c == 368))))))
            : (c <= 370 || (c < 398
              ? (c < 381
                ? (c < 376
                  ? (c < 374
                    ? c == 372
                    : c <= 374)
                  : (c <= 377 || c == 379))
                : (c <= 381 || (c < 390
                  ? (c < 388
                    ? (c >= 385 && c <= 386)
                    : c <= 388)
                  : (c <= 391 || (c >= 393 && c <= 395)))))
              : (c <= 401 || (c < 418
                ? (c < 412
                  ? (c < 406
                    ? (c >= 403 && c <= 404)
                    : c <= 408)
                  : (c <= 413 || (c >= 415 && c <= 416)))
                : (c <= 418 || (c < 425
                  ? (c < 422
                    ? c == 420
                    : c <= 423)
                  : (c <= 425 || c == 428))))))))))
        : (c <= 431 || (c < 530
          ? (c < 486
            ? (c < 465
              ? (c < 452
                ? (c < 439
                  ? (c < 437
                    ? (c >= 433 && c <= 435)
                    : c <= 437)
                  : (c <= 440 || c == 444))
                : (c <= 452 || (c < 461
                  ? (c < 458
                    ? c == 455
                    : c <= 458)
                  : (c <= 461 || c == 463))))
              : (c <= 465 || (c < 475
                ? (c < 471
                  ? (c < 469
                    ? c == 467
                    : c <= 469)
                  : (c <= 471 || c == 473))
                : (c <= 475 || (c < 482
                  ? (c < 480
                    ? c == 478
                    : c <= 480)
                  : (c <= 482 || c == 484))))))
            : (c <= 486 || (c < 510
              ? (c < 497
                ? (c < 492
                  ? (c < 490
                    ? c == 488
                    : c <= 490)
                  : (c <= 492 || c == 494))
                : (c <= 497 || (c < 506
                  ? (c < 502
                    ? c == 500
                    : c <= 504)
                  : (c <= 506 || c == 508))))
              : (c <= 510 || (c < 520
                ? (c < 516
                  ? (c < 514
                    ? c == 512
                    : c <= 514)
                  : (c <= 516 || c == 518))
                : (c <= 520 || (c < 526
                  ? (c < 524
                    ? c == 522
                    : c <= 524)
                  : (c <= 526 || c == 528))))))))
          : (c <= 530 || (c < 579
            ? (c < 550
              ? (c < 540
                ? (c < 536
                  ? (c < 534
                    ? c == 532
                    : c <= 534)
                  : (c <= 536 || c == 538))
                : (c <= 540 || (c < 546
                  ? (c < 544
                    ? c == 542
                    : c <= 544)
                  : (c <= 546 || c == 548))))
              : (c <= 550 || (c < 560
                ? (c < 556
                  ? (c < 554
                    ? c == 552
                    : c <= 554)
                  : (c <= 556 || c == 558))
                : (c <= 560 || (c < 573
                  ? (c < 570
                    ? c == 562
                    : c <= 571)
                  : (c <= 574 || c == 577))))))
            : (c <= 582 || (c < 904
              ? (c < 880
                ? (c < 588
                  ? (c < 586
                    ? c == 584
                    : c <= 586)
                  : (c <= 588 || c == 590))
                : (c <= 880 || (c < 895
                  ? (c < 886
                    ? c == 882
                    : c <= 886)
                  : (c <= 895 || c == 902))))
              : (c <= 906 || (c < 975
                ? (c < 913
                  ? (c < 910
                    ? c == 908
                    : c <= 911)
                  : (c <= 929 || (c >= 931 && c <= 939)))
                : (c <= 975 || (c < 986
                  ? (c < 984
                    ? (c >= 978 && c <= 980)
                    : c <= 984)
                  : (c <= 986 || c == 988))))))))))))
      : (c <= 990 || (c < 1264
        ? (c < 1182
          ? (c < 1134
            ? (c < 1015
              ? (c < 1000
                ? (c < 996
                  ? (c < 994
                    ? c == 992
                    : c <= 994)
                  : (c <= 996 || c == 998))
                : (c <= 1000 || (c < 1006
                  ? (c < 1004
                    ? c == 1002
                    : c <= 1004)
                  : (c <= 1006 || c == 1012))))
              : (c <= 1015 || (c < 1124
                ? (c < 1120
                  ? (c < 1021
                    ? (c >= 1017 && c <= 1018)
                    : c <= 1071)
                  : (c <= 1120 || c == 1122))
                : (c <= 1124 || (c < 1130
                  ? (c < 1128
                    ? c == 1126
                    : c <= 1128)
                  : (c <= 1130 || c == 1132))))))
            : (c <= 1134 || (c < 1162
              ? (c < 1144
                ? (c < 1140
                  ? (c < 1138
                    ? c == 1136
                    : c <= 1138)
                  : (c <= 1140 || c == 1142))
                : (c <= 1144 || (c < 1150
                  ? (c < 1148
                    ? c == 1146
                    : c <= 1148)
                  : (c <= 1150 || c == 1152))))
              : (c <= 1162 || (c < 1172
                ? (c < 1168
                  ? (c < 1166
                    ? c == 1164
                    : c <= 1166)
                  : (c <= 1168 || c == 1170))
                : (c <= 1172 || (c < 1178
                  ? (c < 1176
                    ? c == 1174
                    : c <= 1176)
                  : (c <= 1178 || c == 1180))))))))
          : (c <= 1182 || (c < 1223
            ? (c < 1202
              ? (c < 1192
                ? (c < 1188
                  ? (c < 1186
                    ? c == 1184
                    : c <= 1186)
                  : (c <= 1188 || c == 1190))
                : (c <= 1192 || (c < 1198
                  ? (c < 1196
                    ? c == 1194
                    : c <= 1196)
                  : (c <= 1198 || c == 1200))))
              : (c <= 1202 || (c < 1212
                ? (c < 1208
                  ? (c < 1206
                    ? c == 1204
                    : c <= 1206)
                  : (c <= 1208 || c == 1210))
                : (c <= 1212 || (c < 1219
                  ? (c < 1216
                    ? c == 1214
                    : c <= 1217)
                  : (c <= 1219 || c == 1221))))))
            : (c <= 1223 || (c < 1244
              ? (c < 1234
                ? (c < 1229
                  ? (c < 1227
                    ? c == 1225
                    : c <= 1227)
                  : (c <= 1229 || c == 1232))
                : (c <= 1234 || (c < 1240
                  ? (c < 1238
                    ? c == 1236
                    : c <= 1238)
                  : (c <= 1240 || c == 1242))))
              : (c <= 1244 || (c < 1254
                ? (c < 1250
                  ? (c < 1248
                    ? c == 1246
                    : c <= 1248)
                  : (c <= 1250 || c == 1252))
                : (c <= 1254 || (c < 1260
                  ? (c < 1258
                    ? c == 1256
                    : c <= 1258)
                  : (c <= 1260 || c == 1262))))))))))
        : (c <= 1264 || (c < 7682
          ? (c < 1304
            ? (c < 1284
              ? (c < 1274
                ? (c < 1270
                  ? (c < 1268
                    ? c == 1266
                    : c <= 1268)
                  : (c <= 1270 || c == 1272))
                : (c <= 1274 || (c < 1280
                  ? (c < 1278
                    ? c == 1276
                    : c <= 1278)
                  : (c <= 1280 || c == 1282))))
              : (c <= 1284 || (c < 1294
                ? (c < 1290
                  ? (c < 1288
                    ? c == 1286
                    : c <= 1288)
                  : (c <= 1290 || c == 1292))
                : (c <= 1294 || (c < 1300
                  ? (c < 1298
                    ? c == 1296
                    : c <= 1298)
                  : (c <= 1300 || c == 1302))))))
            : (c <= 1304 || (c < 1324
              ? (c < 1314
                ? (c < 1310
                  ? (c < 1308
                    ? c == 1306
                    : c <= 1308)
                  : (c <= 1310 || c == 1312))
                : (c <= 1314 || (c < 1320
                  ? (c < 1318
                    ? c == 1316
                    : c <= 1318)
                  : (c <= 1320 || c == 1322))))
              : (c <= 1324 || (c < 4301
                ? (c < 4256
                  ? (c < 1329
                    ? c == 1326
                    : c <= 1366)
                  : (c <= 4293 || c == 4295))
                : (c <= 4301 || (c < 7357
                  ? (c < 7312
                    ? (c >= 5024 && c <= 5109)
                    : c <= 7354)
                  : (c <= 7359 || c == 7680))))))))
          : (c <= 7682 || (c < 7722
            ? (c < 7702
              ? (c < 7692
                ? (c < 7688
                  ? (c < 7686
                    ? c == 7684
                    : c <= 7686)
                  : (c <= 7688 || c == 7690))
                : (c <= 7692 || (c < 7698
                  ? (c < 7696
                    ? c == 7694
                    : c <= 7696)
                  : (c <= 7698 || c == 7700))))
              : (c <= 7702 || (c < 7712
                ? (c < 7708
                  ? (c < 7706
                    ? c == 7704
                    : c <= 7706)
                  : (c <= 7708 || c == 7710))
                : (c <= 7712 || (c < 7718
                  ? (c < 7716
                    ? c == 7714
                    : c <= 7716)
                  : (c <= 7718 || c == 7720))))))
            : (c <= 7722 || (c < 7742
              ? (c < 7732
                ? (c < 7728
                  ? (c < 7726
                    ? c == 7724
                    : c <= 7726)
                  : (c <= 7728 || c == 7730))
                : (c <= 7732 || (c < 7738
                  ? (c < 7736
                    ? c == 7734
                    : c <= 7736)
                  : (c <= 7738 || c == 7740))))
              : (c <= 7742 || (c < 7752
                ? (c < 7748
                  ? (c < 7746
                    ? c == 7744
                    : c <= 7746)
                  : (c <= 7748 || c == 7750))
                : (c <= 7752 || (c < 7756
                  ? c == 7754
                  : (c <= 7756 || c == 7758))))))))))))))
    : (c <= 7760 || (c < 11466
      ? (c < 7928
        ? (c < 7848
          ? (c < 7800
            ? (c < 7780
              ? (c < 7770
                ? (c < 7766
                  ? (c < 7764
                    ? c == 7762
                    : c <= 7764)
                  : (c <= 7766 || c == 7768))
                : (c <= 7770 || (c < 7776
                  ? (c < 7774
                    ? c == 7772
                    : c <= 7774)
                  : (c <= 7776 || c == 7778))))
              : (c <= 7780 || (c < 7790
                ? (c < 7786
                  ? (c < 7784
                    ? c == 7782
                    : c <= 7784)
                  : (c <= 7786 || c == 7788))
                : (c <= 7790 || (c < 7796
                  ? (c < 7794
                    ? c == 7792
                    : c <= 7794)
                  : (c <= 7796 || c == 7798))))))
            : (c <= 7800 || (c < 7820
              ? (c < 7810
                ? (c < 7806
                  ? (c < 7804
                    ? c == 7802
                    : c <= 7804)
                  : (c <= 7806 || c == 7808))
                : (c <= 7810 || (c < 7816
                  ? (c < 7814
                    ? c == 7812
                    : c <= 7814)
                  : (c <= 7816 || c == 7818))))
              : (c <= 7820 || (c < 7838
                ? (c < 7826
                  ? (c < 7824
                    ? c == 7822
                    : c <= 7824)
                  : (c <= 7826 || c == 7828))
                : (c <= 7838 || (c < 7844
                  ? (c < 7842
                    ? c == 7840
                    : c <= 7842)
                  : (c <= 7844 || c == 7846))))))))
          : (c <= 7848 || (c < 7888
            ? (c < 7868
              ? (c < 7858
                ? (c < 7854
                  ? (c < 7852
                    ? c == 7850
                    : c <= 7852)
                  : (c <= 7854 || c == 7856))
                : (c <= 7858 || (c < 7864
                  ? (c < 7862
                    ? c == 7860
                    : c <= 7862)
                  : (c <= 7864 || c == 7866))))
              : (c <= 7868 || (c < 7878
                ? (c < 7874
                  ? (c < 7872
                    ? c == 7870
                    : c <= 7872)
                  : (c <= 7874 || c == 7876))
                : (c <= 7878 || (c < 7884
                  ? (c < 7882
                    ? c == 7880
                    : c <= 7882)
                  : (c <= 7884 || c == 7886))))))
            : (c <= 7888 || (c < 7908
              ? (c < 7898
                ? (c < 7894
                  ? (c < 7892
                    ? c == 7890
                    : c <= 7892)
                  : (c <= 7894 || c == 7896))
                : (c <= 7898 || (c < 7904
                  ? (c < 7902
                    ? c == 7900
                    : c <= 7902)
                  : (c <= 7904 || c == 7906))))
              : (c <= 7908 || (c < 7918
                ? (c < 7914
                  ? (c < 7912
                    ? c == 7910
                    : c <= 7912)
                  : (c <= 7914 || c == 7916))
                : (c <= 7918 || (c < 7924
                  ? (c < 7922
                    ? c == 7920
                    : c <= 7922)
                  : (c <= 7924 || c == 7926))))))))))
        : (c <= 7928 || (c < 11378
          ? (c < 8455
            ? (c < 8027
              ? (c < 7960
                ? (c < 7934
                  ? (c < 7932
                    ? c == 7930
                    : c <= 7932)
                  : (c <= 7934 || (c >= 7944 && c <= 7951)))
                : (c <= 7965 || (c < 8008
                  ? (c < 7992
                    ? (c >= 7976 && c <= 7983)
                    : c <= 7999)
                  : (c <= 8013 || c == 8025))))
              : (c <= 8027 || (c < 8136
                ? (c < 8040
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8031)
                  : (c <= 8047 || (c >= 8120 && c <= 8123)))
                : (c <= 8139 || (c < 8184
                  ? (c < 8168
                    ? (c >= 8152 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8187 || c == 8450))))))
            : (c <= 8455 || (c < 8510
              ? (c < 8484
                ? (c < 8469
                  ? (c < 8464
                    ? (c >= 8459 && c <= 8461)
                    : c <= 8466)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8493 || (c >= 8496 && c <= 8499)))))
              : (c <= 8511 || (c < 11362
                ? (c < 11264
                  ? (c < 8579
                    ? c == 8517
                    : c <= 8579)
                  : (c <= 11310 || c == 11360))
                : (c <= 11364 || (c < 11371
                  ? (c < 11369
                    ? c == 11367
                    : c <= 11369)
                  : (c <= 11371 || (c >= 11373 && c <= 11376)))))))))
          : (c <= 11378 || (c < 11428
            ? (c < 11408
              ? (c < 11398
                ? (c < 11394
                  ? (c < 11390
                    ? c == 11381
                    : c <= 11392)
                  : (c <= 11394 || c == 11396))
                : (c <= 11398 || (c < 11404
                  ? (c < 11402
                    ? c == 11400
                    : c <= 11402)
                  : (c <= 11404 || c == 11406))))
              : (c <= 11408 || (c < 11418
                ? (c < 11414
                  ? (c < 11412
                    ? c == 11410
                    : c <= 11412)
                  : (c <= 11414 || c == 11416))
                : (c <= 11418 || (c < 11424
                  ? (c < 11422
                    ? c == 11420
                    : c <= 11422)
                  : (c <= 11424 || c == 11426))))))
            : (c <= 11428 || (c < 11448
              ? (c < 11438
                ? (c < 11434
                  ? (c < 11432
                    ? c == 11430
                    : c <= 11432)
                  : (c <= 11434 || c == 11436))
                : (c <= 11438 || (c < 11444
                  ? (c < 11442
                    ? c == 11440
                    : c <= 11442)
                  : (c <= 11444 || c == 11446))))
              : (c <= 11448 || (c < 11458
                ? (c < 11454
                  ? (c < 11452
                    ? c == 11450
                    : c <= 11452)
                  : (c <= 11454 || c == 11456))
                : (c <= 11458 || (c < 11462
                  ? c == 11460
                  : (c <= 11462 || c == 11464))))))))))))
      : (c <= 11466 || (c < 42842
        ? (c < 42626
          ? (c < 42568
            ? (c < 11486
              ? (c < 11476
                ? (c < 11472
                  ? (c < 11470
                    ? c == 11468
                    : c <= 11470)
                  : (c <= 11472 || c == 11474))
                : (c <= 11476 || (c < 11482
                  ? (c < 11480
                    ? c == 11478
                    : c <= 11480)
                  : (c <= 11482 || c == 11484))))
              : (c <= 11486 || (c < 11506
                ? (c < 11499
                  ? (c < 11490
                    ? c == 11488
                    : c <= 11490)
                  : (c <= 11499 || c == 11501))
                : (c <= 11506 || (c < 42564
                  ? (c < 42562
                    ? c == 42560
                    : c <= 42562)
                  : (c <= 42564 || c == 42566))))))
            : (c <= 42568 || (c < 42588
              ? (c < 42578
                ? (c < 42574
                  ? (c < 42572
                    ? c == 42570
                    : c <= 42572)
                  : (c <= 42574 || c == 42576))
                : (c <= 42578 || (c < 42584
                  ? (c < 42582
                    ? c == 42580
                    : c <= 42582)
                  : (c <= 42584 || c == 42586))))
              : (c <= 42588 || (c < 42598
                ? (c < 42594
                  ? (c < 42592
                    ? c == 42590
                    : c <= 42592)
                  : (c <= 42594 || c == 42596))
                : (c <= 42598 || (c < 42604
                  ? (c < 42602
                    ? c == 42600
                    : c <= 42602)
                  : (c <= 42604 || c == 42624))))))))
          : (c <= 42626 || (c < 42802
            ? (c < 42646
              ? (c < 42636
                ? (c < 42632
                  ? (c < 42630
                    ? c == 42628
                    : c <= 42630)
                  : (c <= 42632 || c == 42634))
                : (c <= 42636 || (c < 42642
                  ? (c < 42640
                    ? c == 42638
                    : c <= 42640)
                  : (c <= 42642 || c == 42644))))
              : (c <= 42646 || (c < 42790
                ? (c < 42786
                  ? (c < 42650
                    ? c == 42648
                    : c <= 42650)
                  : (c <= 42786 || c == 42788))
                : (c <= 42790 || (c < 42796
                  ? (c < 42794
                    ? c == 42792
                    : c <= 42794)
                  : (c <= 42796 || c == 42798))))))
            : (c <= 42802 || (c < 42822
              ? (c < 42812
                ? (c < 42808
                  ? (c < 42806
                    ? c == 42804
                    : c <= 42806)
                  : (c <= 42808 || c == 42810))
                : (c <= 42812 || (c < 42818
                  ? (c < 42816
                    ? c == 42814
                    : c <= 42816)
                  : (c <= 42818 || c == 42820))))
              : (c <= 42822 || (c < 42832
                ? (c < 42828
                  ? (c < 42826
                    ? c == 42824
                    : c <= 42826)
                  : (c <= 42828 || c == 42830))
                : (c <= 42832 || (c < 42838
                  ? (c < 42836
                    ? c == 42834
                    : c <= 42836)
                  : (c <= 42838 || c == 42840))))))))))
        : (c <= 42842 || (c < 42948
          ? (c < 42896
            ? (c < 42862
              ? (c < 42852
                ? (c < 42848
                  ? (c < 42846
                    ? c == 42844
                    : c <= 42846)
                  : (c <= 42848 || c == 42850))
                : (c <= 42852 || (c < 42858
                  ? (c < 42856
                    ? c == 42854
                    : c <= 42856)
                  : (c <= 42858 || c == 42860))))
              : (c <= 42862 || (c < 42882
                ? (c < 42877
                  ? (c < 42875
                    ? c == 42873
                    : c <= 42875)
                  : (c <= 42878 || c == 42880))
                : (c <= 42882 || (c < 42891
                  ? (c < 42886
                    ? c == 42884
                    : c <= 42886)
                  : (c <= 42891 || c == 42893))))))
            : (c <= 42896 || (c < 42918
              ? (c < 42908
                ? (c < 42904
                  ? (c < 42902
                    ? c == 42898
                    : c <= 42902)
                  : (c <= 42904 || c == 42906))
                : (c <= 42908 || (c < 42914
                  ? (c < 42912
                    ? c == 42910
                    : c <= 42912)
                  : (c <= 42914 || c == 42916))))
              : (c <= 42918 || (c < 42936
                ? (c < 42928
                  ? (c < 42922
                    ? c == 42920
                    : c <= 42926)
                  : (c <= 42932 || c == 42934))
                : (c <= 42936 || (c < 42942
                  ? (c < 42940
                    ? c == 42938
                    : c <= 42940)
                  : (c <= 42942 || c == 42946))))))))
          : (c <= 42950 || (c < 120086
            ? (c < 119964
              ? (c < 71840
                ? (c < 66736
                  ? (c < 66560
                    ? (c >= 65313 && c <= 65338)
                    : c <= 66599)
                  : (c <= 66771 || (c >= 68736 && c <= 68786)))
                : (c <= 71871 || (c < 119860
                  ? (c < 119808
                    ? (c >= 93760 && c <= 93791)
                    : c <= 119833)
                  : (c <= 119885 || (c >= 119912 && c <= 119937)))))
              : (c <= 119964 || (c < 119982
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c >= 119977 && c <= 119980)))
                : (c <= 119989 || (c < 120071
                  ? (c < 120068
                    ? (c >= 120016 && c <= 120041)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))))
            : (c <= 120092 || (c < 120380
              ? (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120120 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120276
                  ? (c < 120224
                    ? (c >= 120172 && c <= 120197)
                    : c <= 120249)
                  : (c <= 120301 || (c >= 120328 && c <= 120353)))))
              : (c <= 120405 || (c < 120662
                ? (c < 120546
                  ? (c < 120488
                    ? (c >= 120432 && c <= 120457)
                    : c <= 120512)
                  : (c <= 120570 || (c >= 120604 && c <= 120628)))
                : (c <= 120686 || (c < 120778
                  ? (c >= 120720 && c <= 120744)
                  : (c <= 120778 || (c >= 125184 && c <= 125217)))))))))))))))));
}

static inline bool sym__upper_case_identifier_without_leading_whitespace_character_set_2(int32_t c) {
  return (c < 42240
    ? (c < 3776
      ? (c < 2616
        ? (c < 1808
          ? (c < 904
            ? (c < 248
              ? (c < 170
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 192
                  ? (c < 186
                    ? c == 181
                    : c <= 186)
                  : (c <= 214 || (c >= 216 && c <= 246)))))
              : (c <= 705 || (c < 880
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || c == 750))
                : (c <= 884 || (c < 895
                  ? (c < 890
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || c == 902))))))
            : (c <= 906 || (c < 1519
              ? (c < 1162
                ? (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1376
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)
                  : (c <= 1416 || (c >= 1488 && c <= 1514)))))
              : (c <= 1522 || (c < 1765
                ? (c < 1649
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1610)
                    : c <= 1647)
                  : (c <= 1747 || c == 1749))
                : (c <= 1766 || (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))))))))
          : (c <= 1808 || (c < 2417
            ? (c < 2088
              ? (c < 2036
                ? (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c >= 1994 && c <= 2026)))
                : (c <= 2037 || (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || c == 2084))))
              : (c <= 2088 || (c < 2308
                ? (c < 2208
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2228 || (c >= 2230 && c <= 2237)))
                : (c <= 2361 || (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))))))
            : (c <= 2432 || (c < 2527
              ? (c < 2482
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))
                : (c <= 2482 || (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))))
              : (c <= 2529 || (c < 2579
                ? (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))))))))))
        : (c <= 2617 || (c < 3114
          ? (c < 2869
            ? (c < 2749
              ? (c < 2703
                ? (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c >= 2693 && c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))))
              : (c <= 2749 || (c < 2831
                ? (c < 2809
                  ? (c < 2784
                    ? c == 2768
                    : c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))))))
            : (c <= 2873 || (c < 2972
              ? (c < 2947
                ? (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))
                : (c <= 2947 || (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))))
              : (c <= 2972 || (c < 3024
                ? (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))
                : (c <= 3024 || (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))))))
          : (c <= 3129 || (c < 3412
            ? (c < 3261
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3169 || c == 3200))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))))
              : (c <= 3261 || (c < 3342
                ? (c < 3313
                  ? (c < 3296
                    ? c == 3294
                    : c <= 3297)
                  : (c <= 3314 || (c >= 3333 && c <= 3340)))
                : (c <= 3344 || (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : (c <= 3389 || c == 3406))))))
            : (c <= 3414 || (c < 3648
              ? (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || (c >= 3634 && c <= 3635)))))
              : (c <= 3654 || (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))))))))))))
      : (c <= 3780 || (c < 7401
        ? (c < 5121
          ? (c < 4348
            ? (c < 4186
              ? (c < 3913
                ? (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c >= 4176 && c <= 4181)))))
              : (c <= 4189 || (c < 4238
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c >= 4213 && c <= 4225)))
                : (c <= 4238 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))))))
            : (c <= 4680 || (c < 4800
              ? (c < 4704
                ? (c < 4696
                  ? (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)
                  : (c <= 4696 || (c >= 4698 && c <= 4701)))
                : (c <= 4744 || (c < 4786
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)
                  : (c <= 4789 || (c >= 4792 && c <= 4798)))))
              : (c <= 4800 || (c < 4888
                ? (c < 4824
                  ? (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)
                  : (c <= 4880 || (c >= 4882 && c <= 4885)))
                : (c <= 4954 || (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))))))))
          : (c <= 5740 || (c < 6400
            ? (c < 5998
              ? (c < 5888
                ? (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5873 && c <= 5880)))
                : (c <= 5900 || (c < 5952
                  ? (c < 5920
                    ? (c >= 5902 && c <= 5905)
                    : c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))))
              : (c <= 6000 || (c < 6272
                ? (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : (c <= 6314 || (c >= 6320 && c <= 6389)))))))
            : (c <= 6430 || (c < 7043
              ? (c < 6656
                ? (c < 6528
                  ? (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)
                  : (c <= 6571 || (c >= 6576 && c <= 6601)))
                : (c <= 6678 || (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c >= 6981 && c <= 6987)))))
              : (c <= 7072 || (c < 7258
                ? (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))
                : (c <= 7293 || (c < 7312
                  ? (c >= 7296 && c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))))))))))
        : (c <= 7404 || (c < 8517
          ? (c < 8144
            ? (c < 8025
              ? (c < 7680
                ? (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))
              : (c <= 8025 || (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8130
                  ? c == 8126
                  : (c <= 8132 || (c >= 8134 && c <= 8140)))))))
            : (c <= 8147 || (c < 8458
              ? (c < 8305
                ? (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8473
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : (c <= 8505 || (c >= 8508 && c <= 8511)))))))))
          : (c <= 8521 || (c < 11720
            ? (c < 11565
              ? (c < 11360
                ? (c < 11264
                  ? (c < 8579
                    ? c == 8526
                    : c <= 8580)
                  : (c <= 11310 || (c >= 11312 && c <= 11358)))
                : (c <= 11492 || (c < 11520
                  ? (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)
                  : (c <= 11557 || c == 11559))))
              : (c <= 11565 || (c < 11688
                ? (c < 11648
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))))))
            : (c <= 11726 || (c < 12540
              ? (c < 12337
                ? (c < 11823
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11823 || (c >= 12293 && c <= 12294)))
                : (c <= 12341 || (c < 12445
                  ? (c < 12353
                    ? (c >= 12347 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c >= 12449 && c <= 12538)))))
              : (c <= 12543 || (c < 13312
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12730 || (c >= 12784 && c <= 12799)))
                : (c <= 19893 || (c < 40960
                  ? (c >= 19968 && c <= 40943)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))))))))))))))
    : (c <= 42508 || (c < 70320
      ? (c < 65536
        ? (c < 43744
          ? (c < 43312
            ? (c < 42999
              ? (c < 42656
                ? (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))
                : (c <= 42725 || (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42943 || (c >= 42946 && c <= 42950)))))
              : (c <= 43009 || (c < 43138
                ? (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))
                : (c <= 43187 || (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))))))
            : (c <= 43334 || (c < 43616
              ? (c < 43494
                ? (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c >= 43488 && c <= 43492)))
                : (c <= 43503 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)
                  : (c <= 43586 || (c >= 43588 && c <= 43595)))))
              : (c <= 43638 || (c < 43705
                ? (c < 43697
                  ? (c < 43646
                    ? c == 43642
                    : c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))))))))
          : (c <= 43754 || (c < 64298
            ? (c < 44032
              ? (c < 43808
                ? (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))
                : (c <= 43814 || (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43879 || (c >= 43888 && c <= 44002)))))
              : (c <= 55203 || (c < 64256
                ? (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))))))
            : (c <= 64310 || (c < 65136
              ? (c < 64326
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))
                : (c <= 64433 || (c < 64914
                  ? (c < 64848
                    ? (c >= 64467 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c >= 65008 && c <= 65019)))))
              : (c <= 65140 || (c < 65474
                ? (c < 65345
                  ? (c < 65313
                    ? (c >= 65142 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65470)))
                : (c <= 65479 || (c < 65490
                  ? (c >= 65482 && c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))))))))))
        : (c <= 65547 || (c < 68096
          ? (c < 66816
            ? (c < 66349
              ? (c < 65616
                ? (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66208
                  ? (c < 66176
                    ? (c >= 65664 && c <= 65786)
                    : c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))))
              : (c <= 66368 || (c < 66504
                ? (c < 66432
                  ? (c < 66384
                    ? (c >= 66370 && c <= 66377)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))))))
            : (c <= 66855 || (c < 67647
              ? (c < 67584
                ? (c < 67392
                  ? (c < 67072
                    ? (c >= 66864 && c <= 66915)
                    : c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))
                : (c <= 67589 || (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))))
              : (c <= 67669 || (c < 67840
                ? (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c >= 67828 && c <= 67829)))
                : (c <= 67861 || (c < 67968
                  ? (c >= 67872 && c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))))))))
          : (c <= 68096 || (c < 69600
            ? (c < 68448
              ? (c < 68224
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))))
              : (c <= 68466 || (c < 68864
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))
                : (c <= 68899 || (c < 69415
                  ? (c >= 69376 && c <= 69404)
                  : (c <= 69415 || (c >= 69424 && c <= 69445)))))))
            : (c <= 69622 || (c < 70106
              ? (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? (c >= 69635 && c <= 69687)
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))
              : (c <= 70106 || (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70287
                  ? (c >= 70282 && c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))))))))))
      : (c <= 70366 || (c < 119808
        ? (c < 72768
          ? (c < 71296
            ? (c < 70656
              ? (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))
              : (c <= 70708 || (c < 70855
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70751)
                  : (c <= 70831 || (c >= 70852 && c <= 70853)))
                : (c <= 70855 || (c < 71168
                  ? (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)
                  : (c <= 71215 || c == 71236))))))
            : (c <= 71338 || (c < 72192
              ? (c < 71935
                ? (c < 71680
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71935 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))))
              : (c <= 72192 || (c < 72349
                ? (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))
                : (c <= 72349 || (c < 72704
                  ? (c >= 72384 && c <= 72440)
                  : (c <= 72712 || (c >= 72714 && c <= 72750)))))))))
          : (c <= 72768 || (c < 92992
            ? (c < 73440
              ? (c < 73030
                ? (c < 72968
                  ? (c < 72960
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72966)
                  : (c <= 72969 || (c >= 72971 && c <= 73008)))
                : (c <= 73030 || (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || c == 73112))))
              : (c <= 73458 || (c < 92160
                ? (c < 77824
                  ? (c < 74880
                    ? (c >= 73728 && c <= 74649)
                    : c <= 75075)
                  : (c <= 78894 || (c >= 82944 && c <= 83526)))
                : (c <= 92728 || (c < 92880
                  ? (c >= 92736 && c <= 92766)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))))))
            : (c <= 92995 || (c < 100352
              ? (c < 94032
                ? (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))
                : (c <= 94032 || (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))))
              : (c <= 101106 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110878)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113792
                  ? (c >= 113776 && c <= 113788)
                  : (c <= 113800 || (c >= 113808 && c <= 113817)))))))))))
        : (c <= 119892 || (c < 126469
          ? (c < 120488
            ? (c < 120071
              ? (c < 119977
                ? (c < 119970
                  ? (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)
                  : (c <= 119970 || (c >= 119973 && c <= 119974)))
                : (c <= 119980 || (c < 119997
                  ? (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)
                  : (c <= 120003 || (c >= 120005 && c <= 120069)))))
              : (c <= 120074 || (c < 120128
                ? (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c >= 120123 && c <= 120126)))
                : (c <= 120132 || (c < 120138
                  ? c == 120134
                  : (c <= 120144 || (c >= 120146 && c <= 120485)))))))
            : (c <= 120512 || (c < 120772
              ? (c < 120630
                ? (c < 120572
                  ? (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)
                  : (c <= 120596 || (c >= 120598 && c <= 120628)))
                : (c <= 120654 || (c < 120714
                  ? (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)
                  : (c <= 120744 || (c >= 120746 && c <= 120770)))))
              : (c <= 120779 || (c < 124928
                ? (c < 123214
                  ? (c < 123191
                    ? (c >= 123136 && c <= 123180)
                    : c <= 123197)
                  : (c <= 123214 || (c >= 123584 && c <= 123627)))
                : (c <= 125124 || (c < 125259
                  ? (c >= 125184 && c <= 125251)
                  : (c <= 125259 || (c >= 126464 && c <= 126467)))))))))
          : (c <= 126495 || (c < 126559
            ? (c < 126537
              ? (c < 126516
                ? (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c >= 126505 && c <= 126514)))
                : (c <= 126519 || (c < 126530
                  ? (c < 126523
                    ? c == 126521
                    : c <= 126523)
                  : (c <= 126530 || c == 126535))))
              : (c <= 126537 || (c < 126551
                ? (c < 126545
                  ? (c < 126541
                    ? c == 126539
                    : c <= 126543)
                  : (c <= 126546 || c == 126548))
                : (c <= 126551 || (c < 126555
                  ? c == 126553
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173782 || (c >= 173824 && c <= 177972)))
                : (c <= 178205 || (c < 183984
                  ? (c >= 178208 && c <= 183969)
                  : (c <= 191456 || (c >= 194560 && c <= 195101)))))))))))))))));
}

static inline bool sym_lower_case_identifier_character_set_1(int32_t c) {
  return (c < 8526
    ? (c < 7531
      ? (c < 887
        ? (c < 454
          ? (c < 223
            ? (c < 181
              ? (c >= 'a' && c <= 'z')
              : c <= 181)
            : (c <= 246 || (c < 445
              ? (c >= 248 && c <= 442)
              : c <= 447)))
          : (c <= 454 || (c < 499
            ? (c < 460
              ? c == 457
              : c <= 496)
            : (c <= 659 || (c < 881
              ? (c >= 661 && c <= 687)
              : c <= 883)))))
        : (c <= 887 || (c < 1376
          ? (c < 940
            ? (c < 912
              ? (c >= 891 && c <= 893)
              : c <= 912)
            : (c <= 1013 || (c < 1163
              ? (c >= 1016 && c <= 1153)
              : c <= 1327)))
          : (c <= 1416 || (c < 5112
            ? (c < 4349
              ? (c >= 4304 && c <= 4346)
              : c <= 4351)
            : (c <= 5117 || (c < 7424
              ? (c >= 7296 && c <= 7304)
              : c <= 7467)))))))
      : (c <= 7543 || (c < 8130
        ? (c < 8064
          ? (c < 7968
            ? (c < 7681
              ? (c >= 7545 && c <= 7578)
              : c <= 7957)
            : (c <= 8005 || (c < 8032
              ? (c >= 8016 && c <= 8023)
              : c <= 8061)))
          : (c <= 8071 || (c < 8112
            ? (c < 8096
              ? (c >= 8080 && c <= 8087)
              : c <= 8103)
            : (c <= 8116 || (c < 8126
              ? (c >= 8118 && c <= 8119)
              : c <= 8126)))))
        : (c <= 8132 || (c < 8182
          ? (c < 8150
            ? (c < 8144
              ? (c >= 8134 && c <= 8135)
              : c <= 8147)
            : (c <= 8151 || (c < 8178
              ? (c >= 8160 && c <= 8167)
              : c <= 8180)))
          : (c <= 8183 || (c < 8505
            ? (c < 8495
              ? (c >= 8458 && c <= 8467)
              : c <= 8500)
            : (c <= 8505 || (c < 8518
              ? (c >= 8508 && c <= 8509)
              : c <= 8521)))))))))
    : (c <= 8526 || (c < 66600
      ? (c < 42787
        ? (c < 11507
          ? (c < 11361
            ? (c < 11312
              ? c == 8580
              : c <= 11358)
            : (c <= 11387 || (c < 11500
              ? (c >= 11393 && c <= 11492)
              : c <= 11502)))
          : (c <= 11507 || (c < 11565
            ? (c < 11559
              ? (c >= 11520 && c <= 11557)
              : c <= 11559)
            : (c <= 11565 || (c < 42625
              ? (c >= 42561 && c <= 42605)
              : c <= 42651)))))
        : (c <= 42863 || (c < 43824
          ? (c < 42897
            ? (c < 42892
              ? (c >= 42865 && c <= 42887)
              : c <= 42894)
            : (c <= 42943 || (c < 43002
              ? c == 42947
              : c <= 43002)))
          : (c <= 43866 || (c < 64256
            ? (c < 43888
              ? (c >= 43872 && c <= 43879)
              : c <= 43967)
            : (c <= 64262 || (c < 65345
              ? (c >= 64275 && c <= 64279)
              : c <= 65370)))))))
      : (c <= 66639 || (c < 120146
        ? (c < 119894
          ? (c < 71872
            ? (c < 68800
              ? (c >= 66776 && c <= 66811)
              : c <= 68850)
            : (c <= 71903 || (c < 119834
              ? (c >= 93792 && c <= 93823)
              : c <= 119892)))
          : (c <= 119963 || (c < 119997
            ? (c < 119995
              ? (c >= 119990 && c <= 119993)
              : c <= 119995)
            : (c <= 120003 || (c < 120094
              ? (c >= 120005 && c <= 120067)
              : c <= 120119)))))
        : (c <= 120485 || (c < 120656
          ? (c < 120572
            ? (c < 120540
              ? (c >= 120514 && c <= 120538)
              : c <= 120545)
            : (c <= 120596 || (c < 120630
              ? (c >= 120598 && c <= 120603)
              : c <= 120654)))
          : (c <= 120661 || (c < 120746
            ? (c < 120714
              ? (c >= 120688 && c <= 120712)
              : c <= 120719)
            : (c <= 120770 || (c < 125218
              ? (c >= 120772 && c <= 120779)
              : c <= 125251)))))))))));
}

static inline bool sym_lower_case_identifier_character_set_2(int32_t c) {
  return (c < 7769
    ? (c < 997
      ? (c < 432
        ? (c < 331
          ? (c < 289
            ? (c < 269
              ? (c < 259
                ? (c < 223
                  ? (c < 181
                    ? (c >= 'a' && c <= 'z')
                    : c <= 181)
                  : (c <= 246 || (c < 257
                    ? (c >= 248 && c <= 255)
                    : c <= 257)))
                : (c <= 259 || (c < 265
                  ? (c < 263
                    ? c == 261
                    : c <= 263)
                  : (c <= 265 || c == 267))))
              : (c <= 269 || (c < 279
                ? (c < 275
                  ? (c < 273
                    ? c == 271
                    : c <= 273)
                  : (c <= 275 || c == 277))
                : (c <= 279 || (c < 285
                  ? (c < 283
                    ? c == 281
                    : c <= 283)
                  : (c <= 285 || c == 287))))))
            : (c <= 289 || (c < 309
              ? (c < 299
                ? (c < 295
                  ? (c < 293
                    ? c == 291
                    : c <= 293)
                  : (c <= 295 || c == 297))
                : (c <= 299 || (c < 305
                  ? (c < 303
                    ? c == 301
                    : c <= 303)
                  : (c <= 305 || c == 307))))
              : (c <= 309 || (c < 320
                ? (c < 316
                  ? (c < 314
                    ? (c >= 311 && c <= 312)
                    : c <= 314)
                  : (c <= 316 || c == 318))
                : (c <= 320 || (c < 326
                  ? (c < 324
                    ? c == 322
                    : c <= 324)
                  : (c <= 326 || (c >= 328 && c <= 329)))))))))
          : (c <= 331 || (c < 371
            ? (c < 351
              ? (c < 341
                ? (c < 337
                  ? (c < 335
                    ? c == 333
                    : c <= 335)
                  : (c <= 337 || c == 339))
                : (c <= 341 || (c < 347
                  ? (c < 345
                    ? c == 343
                    : c <= 345)
                  : (c <= 347 || c == 349))))
              : (c <= 351 || (c < 361
                ? (c < 357
                  ? (c < 355
                    ? c == 353
                    : c <= 355)
                  : (c <= 357 || c == 359))
                : (c <= 361 || (c < 367
                  ? (c < 365
                    ? c == 363
                    : c <= 365)
                  : (c <= 367 || c == 369))))))
            : (c <= 371 || (c < 402
              ? (c < 382
                ? (c < 378
                  ? (c < 375
                    ? c == 373
                    : c <= 375)
                  : (c <= 378 || c == 380))
                : (c <= 384 || (c < 392
                  ? (c < 389
                    ? c == 387
                    : c <= 389)
                  : (c <= 392 || (c >= 396 && c <= 397)))))
              : (c <= 402 || (c < 419
                ? (c < 414
                  ? (c < 409
                    ? c == 405
                    : c <= 411)
                  : (c <= 414 || c == 417))
                : (c <= 419 || (c < 426
                  ? (c < 424
                    ? c == 421
                    : c <= 424)
                  : (c <= 427 || c == 429))))))))))
        : (c <= 432 || (c < 531
          ? (c < 487
            ? (c < 466
              ? (c < 454
                ? (c < 441
                  ? (c < 438
                    ? c == 436
                    : c <= 438)
                  : (c <= 442 || (c >= 445 && c <= 447)))
                : (c <= 454 || (c < 462
                  ? (c < 460
                    ? c == 457
                    : c <= 460)
                  : (c <= 462 || c == 464))))
              : (c <= 466 || (c < 476
                ? (c < 472
                  ? (c < 470
                    ? c == 468
                    : c <= 470)
                  : (c <= 472 || c == 474))
                : (c <= 477 || (c < 483
                  ? (c < 481
                    ? c == 479
                    : c <= 481)
                  : (c <= 483 || c == 485))))))
            : (c <= 487 || (c < 511
              ? (c < 499
                ? (c < 493
                  ? (c < 491
                    ? c == 489
                    : c <= 491)
                  : (c <= 493 || (c >= 495 && c <= 496)))
                : (c <= 499 || (c < 507
                  ? (c < 505
                    ? c == 501
                    : c <= 505)
                  : (c <= 507 || c == 509))))
              : (c <= 511 || (c < 521
                ? (c < 517
                  ? (c < 515
                    ? c == 513
                    : c <= 515)
                  : (c <= 517 || c == 519))
                : (c <= 521 || (c < 527
                  ? (c < 525
                    ? c == 523
                    : c <= 525)
                  : (c <= 527 || c == 529))))))))
          : (c <= 531 || (c < 583
            ? (c < 551
              ? (c < 541
                ? (c < 537
                  ? (c < 535
                    ? c == 533
                    : c <= 535)
                  : (c <= 537 || c == 539))
                : (c <= 541 || (c < 547
                  ? (c < 545
                    ? c == 543
                    : c <= 545)
                  : (c <= 547 || c == 549))))
              : (c <= 551 || (c < 561
                ? (c < 557
                  ? (c < 555
                    ? c == 553
                    : c <= 555)
                  : (c <= 557 || c == 559))
                : (c <= 561 || (c < 575
                  ? (c < 572
                    ? (c >= 563 && c <= 569)
                    : c <= 572)
                  : (c <= 576 || c == 578))))))
            : (c <= 583 || (c < 912
              ? (c < 661
                ? (c < 589
                  ? (c < 587
                    ? c == 585
                    : c <= 587)
                  : (c <= 589 || (c >= 591 && c <= 659)))
                : (c <= 687 || (c < 887
                  ? (c < 883
                    ? c == 881
                    : c <= 883)
                  : (c <= 887 || (c >= 891 && c <= 893)))))
              : (c <= 912 || (c < 987
                ? (c < 981
                  ? (c < 976
                    ? (c >= 940 && c <= 974)
                    : c <= 977)
                  : (c <= 983 || c == 985))
                : (c <= 987 || (c < 993
                  ? (c < 991
                    ? c == 989
                    : c <= 991)
                  : (c <= 993 || c == 995))))))))))))
      : (c <= 997 || (c < 1273
        ? (c < 1191
          ? (c < 1143
            ? (c < 1123
              ? (c < 1013
                ? (c < 1003
                  ? (c < 1001
                    ? c == 999
                    : c <= 1001)
                  : (c <= 1003 || (c < 1007
                    ? c == 1005
                    : c <= 1011)))
                : (c <= 1013 || (c < 1072
                  ? (c < 1019
                    ? c == 1016
                    : c <= 1020)
                  : (c <= 1119 || c == 1121))))
              : (c <= 1123 || (c < 1133
                ? (c < 1129
                  ? (c < 1127
                    ? c == 1125
                    : c <= 1127)
                  : (c <= 1129 || c == 1131))
                : (c <= 1133 || (c < 1139
                  ? (c < 1137
                    ? c == 1135
                    : c <= 1137)
                  : (c <= 1139 || c == 1141))))))
            : (c <= 1143 || (c < 1171
              ? (c < 1153
                ? (c < 1149
                  ? (c < 1147
                    ? c == 1145
                    : c <= 1147)
                  : (c <= 1149 || c == 1151))
                : (c <= 1153 || (c < 1167
                  ? (c < 1165
                    ? c == 1163
                    : c <= 1165)
                  : (c <= 1167 || c == 1169))))
              : (c <= 1171 || (c < 1181
                ? (c < 1177
                  ? (c < 1175
                    ? c == 1173
                    : c <= 1175)
                  : (c <= 1177 || c == 1179))
                : (c <= 1181 || (c < 1187
                  ? (c < 1185
                    ? c == 1183
                    : c <= 1185)
                  : (c <= 1187 || c == 1189))))))))
          : (c <= 1191 || (c < 1233
            ? (c < 1211
              ? (c < 1201
                ? (c < 1197
                  ? (c < 1195
                    ? c == 1193
                    : c <= 1195)
                  : (c <= 1197 || c == 1199))
                : (c <= 1201 || (c < 1207
                  ? (c < 1205
                    ? c == 1203
                    : c <= 1205)
                  : (c <= 1207 || c == 1209))))
              : (c <= 1211 || (c < 1222
                ? (c < 1218
                  ? (c < 1215
                    ? c == 1213
                    : c <= 1215)
                  : (c <= 1218 || c == 1220))
                : (c <= 1222 || (c < 1228
                  ? (c < 1226
                    ? c == 1224
                    : c <= 1226)
                  : (c <= 1228 || (c >= 1230 && c <= 1231)))))))
            : (c <= 1233 || (c < 1253
              ? (c < 1243
                ? (c < 1239
                  ? (c < 1237
                    ? c == 1235
                    : c <= 1237)
                  : (c <= 1239 || c == 1241))
                : (c <= 1243 || (c < 1249
                  ? (c < 1247
                    ? c == 1245
                    : c <= 1247)
                  : (c <= 1249 || c == 1251))))
              : (c <= 1253 || (c < 1263
                ? (c < 1259
                  ? (c < 1257
                    ? c == 1255
                    : c <= 1257)
                  : (c <= 1259 || c == 1261))
                : (c <= 1263 || (c < 1269
                  ? (c < 1267
                    ? c == 1265
                    : c <= 1267)
                  : (c <= 1269 || c == 1271))))))))))
        : (c <= 1273 || (c < 7689
          ? (c < 1313
            ? (c < 1293
              ? (c < 1283
                ? (c < 1279
                  ? (c < 1277
                    ? c == 1275
                    : c <= 1277)
                  : (c <= 1279 || c == 1281))
                : (c <= 1283 || (c < 1289
                  ? (c < 1287
                    ? c == 1285
                    : c <= 1287)
                  : (c <= 1289 || c == 1291))))
              : (c <= 1293 || (c < 1303
                ? (c < 1299
                  ? (c < 1297
                    ? c == 1295
                    : c <= 1297)
                  : (c <= 1299 || c == 1301))
                : (c <= 1303 || (c < 1309
                  ? (c < 1307
                    ? c == 1305
                    : c <= 1307)
                  : (c <= 1309 || c == 1311))))))
            : (c <= 1313 || (c < 4349
              ? (c < 1323
                ? (c < 1319
                  ? (c < 1317
                    ? c == 1315
                    : c <= 1317)
                  : (c <= 1319 || c == 1321))
                : (c <= 1323 || (c < 1376
                  ? (c < 1327
                    ? c == 1325
                    : c <= 1327)
                  : (c <= 1416 || (c >= 4304 && c <= 4346)))))
              : (c <= 4351 || (c < 7545
                ? (c < 7424
                  ? (c < 7296
                    ? (c >= 5112 && c <= 5117)
                    : c <= 7304)
                  : (c <= 7467 || (c >= 7531 && c <= 7543)))
                : (c <= 7578 || (c < 7685
                  ? (c < 7683
                    ? c == 7681
                    : c <= 7683)
                  : (c <= 7685 || c == 7687))))))))
          : (c <= 7689 || (c < 7729
            ? (c < 7709
              ? (c < 7699
                ? (c < 7695
                  ? (c < 7693
                    ? c == 7691
                    : c <= 7693)
                  : (c <= 7695 || c == 7697))
                : (c <= 7699 || (c < 7705
                  ? (c < 7703
                    ? c == 7701
                    : c <= 7703)
                  : (c <= 7705 || c == 7707))))
              : (c <= 7709 || (c < 7719
                ? (c < 7715
                  ? (c < 7713
                    ? c == 7711
                    : c <= 7713)
                  : (c <= 7715 || c == 7717))
                : (c <= 7719 || (c < 7725
                  ? (c < 7723
                    ? c == 7721
                    : c <= 7723)
                  : (c <= 7725 || c == 7727))))))
            : (c <= 7729 || (c < 7749
              ? (c < 7739
                ? (c < 7735
                  ? (c < 7733
                    ? c == 7731
                    : c <= 7733)
                  : (c <= 7735 || c == 7737))
                : (c <= 7739 || (c < 7745
                  ? (c < 7743
                    ? c == 7741
                    : c <= 7743)
                  : (c <= 7745 || c == 7747))))
              : (c <= 7749 || (c < 7759
                ? (c < 7755
                  ? (c < 7753
                    ? c == 7751
                    : c <= 7753)
                  : (c <= 7755 || c == 7757))
                : (c <= 7759 || (c < 7765
                  ? (c < 7763
                    ? c == 7761
                    : c <= 7763)
                  : (c <= 7765 || c == 7767))))))))))))))
    : (c <= 7769 || (c < 11477
      ? (c < 7968
        ? (c < 7859
          ? (c < 7811
            ? (c < 7791
              ? (c < 7781
                ? (c < 7775
                  ? (c < 7773
                    ? c == 7771
                    : c <= 7773)
                  : (c <= 7775 || (c < 7779
                    ? c == 7777
                    : c <= 7779)))
                : (c <= 7781 || (c < 7787
                  ? (c < 7785
                    ? c == 7783
                    : c <= 7785)
                  : (c <= 7787 || c == 7789))))
              : (c <= 7791 || (c < 7801
                ? (c < 7797
                  ? (c < 7795
                    ? c == 7793
                    : c <= 7795)
                  : (c <= 7797 || c == 7799))
                : (c <= 7801 || (c < 7807
                  ? (c < 7805
                    ? c == 7803
                    : c <= 7805)
                  : (c <= 7807 || c == 7809))))))
            : (c <= 7811 || (c < 7839
              ? (c < 7821
                ? (c < 7817
                  ? (c < 7815
                    ? c == 7813
                    : c <= 7815)
                  : (c <= 7817 || c == 7819))
                : (c <= 7821 || (c < 7827
                  ? (c < 7825
                    ? c == 7823
                    : c <= 7825)
                  : (c <= 7827 || (c >= 7829 && c <= 7837)))))
              : (c <= 7839 || (c < 7849
                ? (c < 7845
                  ? (c < 7843
                    ? c == 7841
                    : c <= 7843)
                  : (c <= 7845 || c == 7847))
                : (c <= 7849 || (c < 7855
                  ? (c < 7853
                    ? c == 7851
                    : c <= 7853)
                  : (c <= 7855 || c == 7857))))))))
          : (c <= 7859 || (c < 7899
            ? (c < 7879
              ? (c < 7869
                ? (c < 7865
                  ? (c < 7863
                    ? c == 7861
                    : c <= 7863)
                  : (c <= 7865 || c == 7867))
                : (c <= 7869 || (c < 7875
                  ? (c < 7873
                    ? c == 7871
                    : c <= 7873)
                  : (c <= 7875 || c == 7877))))
              : (c <= 7879 || (c < 7889
                ? (c < 7885
                  ? (c < 7883
                    ? c == 7881
                    : c <= 7883)
                  : (c <= 7885 || c == 7887))
                : (c <= 7889 || (c < 7895
                  ? (c < 7893
                    ? c == 7891
                    : c <= 7893)
                  : (c <= 7895 || c == 7897))))))
            : (c <= 7899 || (c < 7919
              ? (c < 7909
                ? (c < 7905
                  ? (c < 7903
                    ? c == 7901
                    : c <= 7903)
                  : (c <= 7905 || c == 7907))
                : (c <= 7909 || (c < 7915
                  ? (c < 7913
                    ? c == 7911
                    : c <= 7913)
                  : (c <= 7915 || c == 7917))))
              : (c <= 7919 || (c < 7929
                ? (c < 7925
                  ? (c < 7923
                    ? c == 7921
                    : c <= 7923)
                  : (c <= 7925 || c == 7927))
                : (c <= 7929 || (c < 7935
                  ? (c < 7933
                    ? c == 7931
                    : c <= 7933)
                  : (c <= 7943 || (c >= 7952 && c <= 7957)))))))))))
        : (c <= 7975 || (c < 11397
          ? (c < 8462
            ? (c < 8118
              ? (c < 8048
                ? (c < 8016
                  ? (c < 8000
                    ? (c >= 7984 && c <= 7991)
                    : c <= 8005)
                  : (c <= 8023 || (c >= 8032 && c <= 8039)))
                : (c <= 8061 || (c < 8096
                  ? (c < 8080
                    ? (c >= 8064 && c <= 8071)
                    : c <= 8087)
                  : (c <= 8103 || (c >= 8112 && c <= 8116)))))
              : (c <= 8119 || (c < 8150
                ? (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8135 || (c >= 8144 && c <= 8147)))
                : (c <= 8151 || (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8167)
                    : c <= 8180)
                  : (c <= 8183 || c == 8458))))))
            : (c <= 8463 || (c < 11361
              ? (c < 8508
                ? (c < 8500
                  ? (c < 8495
                    ? c == 8467
                    : c <= 8495)
                  : (c <= 8500 || c == 8505))
                : (c <= 8509 || (c < 8580
                  ? (c < 8526
                    ? (c >= 8518 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8580 || (c >= 11312 && c <= 11358)))))
              : (c <= 11361 || (c < 11377
                ? (c < 11370
                  ? (c < 11368
                    ? (c >= 11365 && c <= 11366)
                    : c <= 11368)
                  : (c <= 11370 || c == 11372))
                : (c <= 11377 || (c < 11393
                  ? (c < 11382
                    ? (c >= 11379 && c <= 11380)
                    : c <= 11387)
                  : (c <= 11393 || c == 11395))))))))
          : (c <= 11397 || (c < 11437
            ? (c < 11417
              ? (c < 11407
                ? (c < 11403
                  ? (c < 11401
                    ? c == 11399
                    : c <= 11401)
                  : (c <= 11403 || c == 11405))
                : (c <= 11407 || (c < 11413
                  ? (c < 11411
                    ? c == 11409
                    : c <= 11411)
                  : (c <= 11413 || c == 11415))))
              : (c <= 11417 || (c < 11427
                ? (c < 11423
                  ? (c < 11421
                    ? c == 11419
                    : c <= 11421)
                  : (c <= 11423 || c == 11425))
                : (c <= 11427 || (c < 11433
                  ? (c < 11431
                    ? c == 11429
                    : c <= 11431)
                  : (c <= 11433 || c == 11435))))))
            : (c <= 11437 || (c < 11457
              ? (c < 11447
                ? (c < 11443
                  ? (c < 11441
                    ? c == 11439
                    : c <= 11441)
                  : (c <= 11443 || c == 11445))
                : (c <= 11447 || (c < 11453
                  ? (c < 11451
                    ? c == 11449
                    : c <= 11451)
                  : (c <= 11453 || c == 11455))))
              : (c <= 11457 || (c < 11467
                ? (c < 11463
                  ? (c < 11461
                    ? c == 11459
                    : c <= 11461)
                  : (c <= 11463 || c == 11465))
                : (c <= 11467 || (c < 11473
                  ? (c < 11471
                    ? c == 11469
                    : c <= 11471)
                  : (c <= 11473 || c == 11475))))))))))))
      : (c <= 11477 || (c < 42847
        ? (c < 42631
          ? (c < 42573
            ? (c < 11507
              ? (c < 11487
                ? (c < 11483
                  ? (c < 11481
                    ? c == 11479
                    : c <= 11481)
                  : (c <= 11483 || c == 11485))
                : (c <= 11487 || (c < 11500
                  ? (c < 11491
                    ? c == 11489
                    : c <= 11492)
                  : (c <= 11500 || c == 11502))))
              : (c <= 11507 || (c < 42563
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || c == 42561))
                : (c <= 42563 || (c < 42569
                  ? (c < 42567
                    ? c == 42565
                    : c <= 42567)
                  : (c <= 42569 || c == 42571))))))
            : (c <= 42573 || (c < 42593
              ? (c < 42583
                ? (c < 42579
                  ? (c < 42577
                    ? c == 42575
                    : c <= 42577)
                  : (c <= 42579 || c == 42581))
                : (c <= 42583 || (c < 42589
                  ? (c < 42587
                    ? c == 42585
                    : c <= 42587)
                  : (c <= 42589 || c == 42591))))
              : (c <= 42593 || (c < 42603
                ? (c < 42599
                  ? (c < 42597
                    ? c == 42595
                    : c <= 42597)
                  : (c <= 42599 || c == 42601))
                : (c <= 42603 || (c < 42627
                  ? (c < 42625
                    ? c == 42605
                    : c <= 42625)
                  : (c <= 42627 || c == 42629))))))))
          : (c <= 42631 || (c < 42807
            ? (c < 42651
              ? (c < 42641
                ? (c < 42637
                  ? (c < 42635
                    ? c == 42633
                    : c <= 42635)
                  : (c <= 42637 || c == 42639))
                : (c <= 42641 || (c < 42647
                  ? (c < 42645
                    ? c == 42643
                    : c <= 42645)
                  : (c <= 42647 || c == 42649))))
              : (c <= 42651 || (c < 42795
                ? (c < 42791
                  ? (c < 42789
                    ? c == 42787
                    : c <= 42789)
                  : (c <= 42791 || c == 42793))
                : (c <= 42795 || (c < 42803
                  ? (c < 42799
                    ? c == 42797
                    : c <= 42801)
                  : (c <= 42803 || c == 42805))))))
            : (c <= 42807 || (c < 42827
              ? (c < 42817
                ? (c < 42813
                  ? (c < 42811
                    ? c == 42809
                    : c <= 42811)
                  : (c <= 42813 || c == 42815))
                : (c <= 42817 || (c < 42823
                  ? (c < 42821
                    ? c == 42819
                    : c <= 42821)
                  : (c <= 42823 || c == 42825))))
              : (c <= 42827 || (c < 42837
                ? (c < 42833
                  ? (c < 42831
                    ? c == 42829
                    : c <= 42831)
                  : (c <= 42833 || c == 42835))
                : (c <= 42837 || (c < 42843
                  ? (c < 42841
                    ? c == 42839
                    : c <= 42841)
                  : (c <= 42843 || c == 42845))))))))))
        : (c <= 42847 || (c < 43824
          ? (c < 42899
            ? (c < 42874
              ? (c < 42857
                ? (c < 42853
                  ? (c < 42851
                    ? c == 42849
                    : c <= 42851)
                  : (c <= 42853 || c == 42855))
                : (c <= 42857 || (c < 42863
                  ? (c < 42861
                    ? c == 42859
                    : c <= 42861)
                  : (c <= 42863 || (c >= 42865 && c <= 42872)))))
              : (c <= 42874 || (c < 42885
                ? (c < 42881
                  ? (c < 42879
                    ? c == 42876
                    : c <= 42879)
                  : (c <= 42881 || c == 42883))
                : (c <= 42885 || (c < 42894
                  ? (c < 42892
                    ? c == 42887
                    : c <= 42892)
                  : (c <= 42894 || c == 42897))))))
            : (c <= 42901 || (c < 42921
              ? (c < 42911
                ? (c < 42907
                  ? (c < 42905
                    ? c == 42903
                    : c <= 42905)
                  : (c <= 42907 || c == 42909))
                : (c <= 42911 || (c < 42917
                  ? (c < 42915
                    ? c == 42913
                    : c <= 42915)
                  : (c <= 42917 || c == 42919))))
              : (c <= 42921 || (c < 42939
                ? (c < 42935
                  ? (c < 42933
                    ? c == 42927
                    : c <= 42933)
                  : (c <= 42935 || c == 42937))
                : (c <= 42939 || (c < 42947
                  ? (c < 42943
                    ? c == 42941
                    : c <= 42943)
                  : (c <= 42947 || c == 43002))))))))
          : (c <= 43866 || (c < 120094
            ? (c < 93792
              ? (c < 65345
                ? (c < 64256
                  ? (c < 43888
                    ? (c >= 43872 && c <= 43879)
                    : c <= 43967)
                  : (c <= 64262 || (c >= 64275 && c <= 64279)))
                : (c <= 65370 || (c < 68800
                  ? (c < 66776
                    ? (c >= 66600 && c <= 66639)
                    : c <= 66811)
                  : (c <= 68850 || (c >= 71872 && c <= 71903)))))
              : (c <= 93823 || (c < 119990
                ? (c < 119894
                  ? (c < 119886
                    ? (c >= 119834 && c <= 119859)
                    : c <= 119892)
                  : (c <= 119911 || (c >= 119938 && c <= 119963)))
                : (c <= 119993 || (c < 120005
                  ? (c < 119997
                    ? c == 119995
                    : c <= 120003)
                  : (c <= 120015 || (c >= 120042 && c <= 120067)))))))
            : (c <= 120119 || (c < 120572
              ? (c < 120354
                ? (c < 120250
                  ? (c < 120198
                    ? (c >= 120146 && c <= 120171)
                    : c <= 120223)
                  : (c <= 120275 || (c >= 120302 && c <= 120327)))
                : (c <= 120379 || (c < 120514
                  ? (c < 120458
                    ? (c >= 120406 && c <= 120431)
                    : c <= 120485)
                  : (c <= 120538 || (c >= 120540 && c <= 120545)))))
              : (c <= 120596 || (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120603)
                    : c <= 120654)
                  : (c <= 120661 || (c >= 120688 && c <= 120712)))
                : (c <= 120719 || (c < 120779
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120777)
                  : (c <= 120779 || (c >= 125218 && c <= 125251)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(76);
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(88);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '_') ADVANCE(134);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(73)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(85);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(17)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '\r') SKIP(1)
      if (lookahead == 'u') ADVANCE(50);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(123);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(30)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(30)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(32)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(32)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(28)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(28)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(26)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '-') ADVANCE(108);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(107);
      if (lookahead != 0) ADVANCE(109);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead == '\r') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(127);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(123);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(13)
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '{') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(98);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(95);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(125);
      if (lookahead == '\r') ADVANCE(124);
      if (lookahead == 'u') ADVANCE(127);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(123);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(38)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(38)
      if (lookahead == '\r') SKIP(15)
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '_') ADVANCE(134);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(141);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(42);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(141);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(42);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(99);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(99);
      if (lookahead != 0) ADVANCE(104);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '{') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(25);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(101);
      if (lookahead != 0) ADVANCE(104);
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(70);
      if (lookahead != 0) ADVANCE(104);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(21);
      if (lookahead != 0) ADVANCE(104);
      END_STATE();
    case 26:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(138);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(36);
      if (lookahead == '|') ADVANCE(42);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(26)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 27:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(42);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(28)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 28:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(42);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(28)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 29:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(30)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 30:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(30)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 31:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(138);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(36);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(32)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(85);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 32:
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(138);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == ':') ADVANCE(43);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '{') ADVANCE(36);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(32)
      if (sym_lower_case_identifier_character_set_2(lookahead)) ADVANCE(117);
      END_STATE();
    case 33:
      if (lookahead == '&') ADVANCE(152);
      END_STATE();
    case 34:
      if (lookahead == '-') ADVANCE(81);
      END_STATE();
    case 35:
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '>') ADVANCE(131);
      if (lookahead == '}') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(77);
      END_STATE();
    case 37:
      if (lookahead == '-') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 38:
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '{') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      END_STATE();
    case 39:
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '{') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(85);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(86);
      END_STATE();
    case 40:
      if (lookahead == '.') ADVANCE(128);
      END_STATE();
    case 41:
      if (lookahead == '.') ADVANCE(161);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(156);
      if (lookahead == ']') ADVANCE(115);
      if (lookahead == '|') ADVANCE(153);
      END_STATE();
    case 42:
      if (lookahead == '.') ADVANCE(161);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(156);
      if (lookahead == '|') ADVANCE(153);
      END_STATE();
    case 43:
      if (lookahead == ':') ADVANCE(113);
      END_STATE();
    case 44:
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 45:
      if (lookahead == '>') ADVANCE(159);
      END_STATE();
    case 46:
      if (lookahead == '>') ADVANCE(160);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == '{') ADVANCE(69);
      END_STATE();
    case 51:
      if (lookahead == '|') ADVANCE(114);
      END_STATE();
    case 52:
      if (lookahead == '}') ADVANCE(123);
      END_STATE();
    case 53:
      if (lookahead == '}') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == '}') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == '}') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 56:
      if (lookahead == '}') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 57:
      if (lookahead == '}') ADVANCE(123);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 58:
      if (lookahead == '}') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 59:
      if (lookahead == '}') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 60:
      if (lookahead == '}') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 61:
      if (lookahead == '}') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '}') ADVANCE(124);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(104);
      END_STATE();
    case 71:
      if (eof) ADVANCE(76);
      if (lookahead == '\n') SKIP(75)
      END_STATE();
    case 72:
      if (eof) ADVANCE(76);
      if (lookahead == '\n') SKIP(75)
      if (lookahead == '\r') SKIP(71)
      END_STATE();
    case 73:
      if (eof) ADVANCE(76);
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '^') ADVANCE(145);
      if (lookahead == '_') ADVANCE(134);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(90);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(73)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 74:
      if (eof) ADVANCE(76);
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '=') ADVANCE(129);
      if (lookahead == '[') ADVANCE(110);
      if (lookahead == '\\') SKIP(72)
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '_') ADVANCE(134);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(75)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 75:
      if (eof) ADVANCE(76);
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '\'') ADVANCE(94);
      if (lookahead == '(') ADVANCE(82);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '0') ADVANCE(118);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '=') ADVANCE(129);
      if (lookahead == '[') ADVANCE(110);
      if (lookahead == '\\') SKIP(72)
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == '_') ADVANCE(134);
      if (lookahead == '{') ADVANCE(92);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(75)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(119);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_1(lookahead)) ADVANCE(116);
      if (sym_lower_case_identifier_character_set_1(lookahead)) ADVANCE(117);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACE_DASH);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DASH_RBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '"') ADVANCE(81);
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '"') ADVANCE(79);
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym__upper_case_identifier_without_leading_whitespace);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_2(lookahead)) ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym__lower_case_identifier_without_leading_whitespace);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_2(lookahead)) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym__dot_without_leading_whitespace);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym__dot_without_leading_whitespace);
      if (lookahead == '.') ADVANCE(128);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '.') ADVANCE(161);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(156);
      if (lookahead == ']') ADVANCE(115);
      if (lookahead == '|') ADVANCE(153);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '.') ADVANCE(161);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(156);
      if (lookahead == '|') ADVANCE(153);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '-') ADVANCE(77);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      if (lookahead == '-') ADVANCE(81);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      if (lookahead == '-') ADVANCE(77);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_char_constant_expr_token1);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '{') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(98);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(95);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '\n') ADVANCE(104);
      if (lookahead == '"') ADVANCE(80);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(100);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(25);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(104);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(24);
      if (lookahead == '-') ADVANCE(104);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(104);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(24);
      if (lookahead == '-') ADVANCE(100);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(104);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token1);
      if (lookahead == '"') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(20);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token2);
      if (lookahead == '-') ADVANCE(108);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(107);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token2);
      if (lookahead == '-') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_string_constant_expr_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == 'g') ADVANCE(47);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym__glsl_begin);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym__glsl_end);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_upper_case_identifier);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_2(lookahead)) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_lower_case_identifier);
      if (sym__upper_case_identifier_without_leading_whitespace_character_set_2(lookahead)) ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == 'e') ADVANCE(37);
      if (lookahead == 'x') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == 'e') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == 'e') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_string_escape);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(98);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(12);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_invalid_string_escape);
      if (lookahead == '{') ADVANCE(61);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_double_dot);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_eq);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_eq);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_arrow);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_colon);
      if (lookahead == ':') ADVANCE(113);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_backslash);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_dot);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_dot);
      if (lookahead == '.') ADVANCE(128);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(154);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(81);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '>') ADVANCE(131);
      if (lookahead == '}') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(119);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(45);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(150);
      if (lookahead == '?') ADVANCE(46);
      if (lookahead == '|') ADVANCE(155);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '>') ADVANCE(158);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT_PIPE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LT_SLASH_GT);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LT_QMARK_GT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_PIPE_DOT);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'w') ADVANCE(13);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(14)
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'x') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'm') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(30);
      if (lookahead == 'y') ADVANCE(31);
      END_STATE();
    case 13:
      if (lookahead == 'h') ADVANCE(32);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 15:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(sym_as);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 18:
      if (lookahead == 'f') ADVANCE(35);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 20:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(38);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(39);
      END_STATE();
    case 24:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_of);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'g') ADVANCE(45);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 31:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 39:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_non);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 45:
      if (lookahead == 'h') ADVANCE(59);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_case);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 'x') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_left);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_port);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_type);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_alias);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_infix);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_right);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_where);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_effect);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_import);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_module);
      END_STATE();
    case 75:
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_exposing);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 74},
  [2] = {.lex_state = 19, .external_lex_state = 2},
  [3] = {.lex_state = 19, .external_lex_state = 2},
  [4] = {.lex_state = 19, .external_lex_state = 2},
  [5] = {.lex_state = 19, .external_lex_state = 2},
  [6] = {.lex_state = 19, .external_lex_state = 2},
  [7] = {.lex_state = 19, .external_lex_state = 2},
  [8] = {.lex_state = 19, .external_lex_state = 2},
  [9] = {.lex_state = 19, .external_lex_state = 2},
  [10] = {.lex_state = 19, .external_lex_state = 2},
  [11] = {.lex_state = 19, .external_lex_state = 2},
  [12] = {.lex_state = 19, .external_lex_state = 2},
  [13] = {.lex_state = 19, .external_lex_state = 2},
  [14] = {.lex_state = 19, .external_lex_state = 3},
  [15] = {.lex_state = 19, .external_lex_state = 3},
  [16] = {.lex_state = 19, .external_lex_state = 3},
  [17] = {.lex_state = 19, .external_lex_state = 4},
  [18] = {.lex_state = 19, .external_lex_state = 4},
  [19] = {.lex_state = 19, .external_lex_state = 4},
  [20] = {.lex_state = 18, .external_lex_state = 2},
  [21] = {.lex_state = 19, .external_lex_state = 2},
  [22] = {.lex_state = 19, .external_lex_state = 2},
  [23] = {.lex_state = 18, .external_lex_state = 2},
  [24] = {.lex_state = 19, .external_lex_state = 2},
  [25] = {.lex_state = 18, .external_lex_state = 2},
  [26] = {.lex_state = 18, .external_lex_state = 2},
  [27] = {.lex_state = 18, .external_lex_state = 2},
  [28] = {.lex_state = 18, .external_lex_state = 2},
  [29] = {.lex_state = 18, .external_lex_state = 2},
  [30] = {.lex_state = 18, .external_lex_state = 2},
  [31] = {.lex_state = 18, .external_lex_state = 2},
  [32] = {.lex_state = 18, .external_lex_state = 2},
  [33] = {.lex_state = 18, .external_lex_state = 2},
  [34] = {.lex_state = 18, .external_lex_state = 2},
  [35] = {.lex_state = 18, .external_lex_state = 2},
  [36] = {.lex_state = 18, .external_lex_state = 2},
  [37] = {.lex_state = 18, .external_lex_state = 2},
  [38] = {.lex_state = 18, .external_lex_state = 2},
  [39] = {.lex_state = 18, .external_lex_state = 2},
  [40] = {.lex_state = 18, .external_lex_state = 2},
  [41] = {.lex_state = 18, .external_lex_state = 2},
  [42] = {.lex_state = 19, .external_lex_state = 2},
  [43] = {.lex_state = 19, .external_lex_state = 2},
  [44] = {.lex_state = 19, .external_lex_state = 2},
  [45] = {.lex_state = 19, .external_lex_state = 2},
  [46] = {.lex_state = 19, .external_lex_state = 2},
  [47] = {.lex_state = 19, .external_lex_state = 2},
  [48] = {.lex_state = 19, .external_lex_state = 2},
  [49] = {.lex_state = 19, .external_lex_state = 2},
  [50] = {.lex_state = 19, .external_lex_state = 2},
  [51] = {.lex_state = 19, .external_lex_state = 2},
  [52] = {.lex_state = 19, .external_lex_state = 2},
  [53] = {.lex_state = 19, .external_lex_state = 2},
  [54] = {.lex_state = 19, .external_lex_state = 2},
  [55] = {.lex_state = 19, .external_lex_state = 2},
  [56] = {.lex_state = 19, .external_lex_state = 2},
  [57] = {.lex_state = 19, .external_lex_state = 2},
  [58] = {.lex_state = 19, .external_lex_state = 2},
  [59] = {.lex_state = 19, .external_lex_state = 2},
  [60] = {.lex_state = 19, .external_lex_state = 2},
  [61] = {.lex_state = 19, .external_lex_state = 2},
  [62] = {.lex_state = 19, .external_lex_state = 2},
  [63] = {.lex_state = 19, .external_lex_state = 2},
  [64] = {.lex_state = 19, .external_lex_state = 2},
  [65] = {.lex_state = 19, .external_lex_state = 2},
  [66] = {.lex_state = 19, .external_lex_state = 2},
  [67] = {.lex_state = 19, .external_lex_state = 2},
  [68] = {.lex_state = 19, .external_lex_state = 2},
  [69] = {.lex_state = 19, .external_lex_state = 2},
  [70] = {.lex_state = 19, .external_lex_state = 2},
  [71] = {.lex_state = 19, .external_lex_state = 2},
  [72] = {.lex_state = 19, .external_lex_state = 2},
  [73] = {.lex_state = 19, .external_lex_state = 2},
  [74] = {.lex_state = 19, .external_lex_state = 2},
  [75] = {.lex_state = 19, .external_lex_state = 2},
  [76] = {.lex_state = 19, .external_lex_state = 2},
  [77] = {.lex_state = 19, .external_lex_state = 2},
  [78] = {.lex_state = 19, .external_lex_state = 2},
  [79] = {.lex_state = 19, .external_lex_state = 2},
  [80] = {.lex_state = 19, .external_lex_state = 2},
  [81] = {.lex_state = 19, .external_lex_state = 2},
  [82] = {.lex_state = 19, .external_lex_state = 2},
  [83] = {.lex_state = 19, .external_lex_state = 2},
  [84] = {.lex_state = 19, .external_lex_state = 2},
  [85] = {.lex_state = 19, .external_lex_state = 2},
  [86] = {.lex_state = 19, .external_lex_state = 2},
  [87] = {.lex_state = 19, .external_lex_state = 2},
  [88] = {.lex_state = 19, .external_lex_state = 2},
  [89] = {.lex_state = 19, .external_lex_state = 3},
  [90] = {.lex_state = 19, .external_lex_state = 2},
  [91] = {.lex_state = 19, .external_lex_state = 2},
  [92] = {.lex_state = 19, .external_lex_state = 2},
  [93] = {.lex_state = 19, .external_lex_state = 2},
  [94] = {.lex_state = 19, .external_lex_state = 2},
  [95] = {.lex_state = 19, .external_lex_state = 2},
  [96] = {.lex_state = 19, .external_lex_state = 2},
  [97] = {.lex_state = 19, .external_lex_state = 2},
  [98] = {.lex_state = 19, .external_lex_state = 2},
  [99] = {.lex_state = 19, .external_lex_state = 2},
  [100] = {.lex_state = 19, .external_lex_state = 2},
  [101] = {.lex_state = 19, .external_lex_state = 2},
  [102] = {.lex_state = 19, .external_lex_state = 2},
  [103] = {.lex_state = 19, .external_lex_state = 2},
  [104] = {.lex_state = 19, .external_lex_state = 2},
  [105] = {.lex_state = 18, .external_lex_state = 3},
  [106] = {.lex_state = 19, .external_lex_state = 2},
  [107] = {.lex_state = 19, .external_lex_state = 2},
  [108] = {.lex_state = 19, .external_lex_state = 2},
  [109] = {.lex_state = 19, .external_lex_state = 2},
  [110] = {.lex_state = 19, .external_lex_state = 2},
  [111] = {.lex_state = 19, .external_lex_state = 2},
  [112] = {.lex_state = 19, .external_lex_state = 2},
  [113] = {.lex_state = 19, .external_lex_state = 2},
  [114] = {.lex_state = 19, .external_lex_state = 2},
  [115] = {.lex_state = 18, .external_lex_state = 3},
  [116] = {.lex_state = 19, .external_lex_state = 3},
  [117] = {.lex_state = 19, .external_lex_state = 2},
  [118] = {.lex_state = 19, .external_lex_state = 2},
  [119] = {.lex_state = 19, .external_lex_state = 2},
  [120] = {.lex_state = 19, .external_lex_state = 2},
  [121] = {.lex_state = 19, .external_lex_state = 2},
  [122] = {.lex_state = 19, .external_lex_state = 2},
  [123] = {.lex_state = 19, .external_lex_state = 2},
  [124] = {.lex_state = 19, .external_lex_state = 2},
  [125] = {.lex_state = 19, .external_lex_state = 2},
  [126] = {.lex_state = 19, .external_lex_state = 3},
  [127] = {.lex_state = 19, .external_lex_state = 2},
  [128] = {.lex_state = 19, .external_lex_state = 2},
  [129] = {.lex_state = 19, .external_lex_state = 2},
  [130] = {.lex_state = 19, .external_lex_state = 2},
  [131] = {.lex_state = 19, .external_lex_state = 2},
  [132] = {.lex_state = 19, .external_lex_state = 2},
  [133] = {.lex_state = 18, .external_lex_state = 3},
  [134] = {.lex_state = 18, .external_lex_state = 3},
  [135] = {.lex_state = 18, .external_lex_state = 3},
  [136] = {.lex_state = 19, .external_lex_state = 4},
  [137] = {.lex_state = 18, .external_lex_state = 3},
  [138] = {.lex_state = 19, .external_lex_state = 2},
  [139] = {.lex_state = 19, .external_lex_state = 4},
  [140] = {.lex_state = 18, .external_lex_state = 3},
  [141] = {.lex_state = 18, .external_lex_state = 3},
  [142] = {.lex_state = 18, .external_lex_state = 4},
  [143] = {.lex_state = 19, .external_lex_state = 4},
  [144] = {.lex_state = 18, .external_lex_state = 3},
  [145] = {.lex_state = 18, .external_lex_state = 3},
  [146] = {.lex_state = 18, .external_lex_state = 3},
  [147] = {.lex_state = 18, .external_lex_state = 3},
  [148] = {.lex_state = 18, .external_lex_state = 3},
  [149] = {.lex_state = 19, .external_lex_state = 2},
  [150] = {.lex_state = 18, .external_lex_state = 3},
  [151] = {.lex_state = 18, .external_lex_state = 4},
  [152] = {.lex_state = 19, .external_lex_state = 2},
  [153] = {.lex_state = 18, .external_lex_state = 3},
  [154] = {.lex_state = 19, .external_lex_state = 2},
  [155] = {.lex_state = 18, .external_lex_state = 3},
  [156] = {.lex_state = 18, .external_lex_state = 3},
  [157] = {.lex_state = 19, .external_lex_state = 2},
  [158] = {.lex_state = 19, .external_lex_state = 2},
  [159] = {.lex_state = 18, .external_lex_state = 3},
  [160] = {.lex_state = 18, .external_lex_state = 3},
  [161] = {.lex_state = 19, .external_lex_state = 3},
  [162] = {.lex_state = 19, .external_lex_state = 3},
  [163] = {.lex_state = 19, .external_lex_state = 3},
  [164] = {.lex_state = 19, .external_lex_state = 3},
  [165] = {.lex_state = 19, .external_lex_state = 3},
  [166] = {.lex_state = 19, .external_lex_state = 3},
  [167] = {.lex_state = 19, .external_lex_state = 3},
  [168] = {.lex_state = 19, .external_lex_state = 3},
  [169] = {.lex_state = 19, .external_lex_state = 3},
  [170] = {.lex_state = 19, .external_lex_state = 3},
  [171] = {.lex_state = 19, .external_lex_state = 3},
  [172] = {.lex_state = 19, .external_lex_state = 3},
  [173] = {.lex_state = 19, .external_lex_state = 3},
  [174] = {.lex_state = 19, .external_lex_state = 3},
  [175] = {.lex_state = 19, .external_lex_state = 3},
  [176] = {.lex_state = 19, .external_lex_state = 3},
  [177] = {.lex_state = 19, .external_lex_state = 3},
  [178] = {.lex_state = 19, .external_lex_state = 3},
  [179] = {.lex_state = 18, .external_lex_state = 4},
  [180] = {.lex_state = 19, .external_lex_state = 3},
  [181] = {.lex_state = 19, .external_lex_state = 3},
  [182] = {.lex_state = 19, .external_lex_state = 3},
  [183] = {.lex_state = 19, .external_lex_state = 3},
  [184] = {.lex_state = 19, .external_lex_state = 3},
  [185] = {.lex_state = 19, .external_lex_state = 3},
  [186] = {.lex_state = 19, .external_lex_state = 3},
  [187] = {.lex_state = 19, .external_lex_state = 3},
  [188] = {.lex_state = 19, .external_lex_state = 3},
  [189] = {.lex_state = 19, .external_lex_state = 3},
  [190] = {.lex_state = 19, .external_lex_state = 3},
  [191] = {.lex_state = 18, .external_lex_state = 4},
  [192] = {.lex_state = 19, .external_lex_state = 3},
  [193] = {.lex_state = 19, .external_lex_state = 3},
  [194] = {.lex_state = 19, .external_lex_state = 3},
  [195] = {.lex_state = 18, .external_lex_state = 4},
  [196] = {.lex_state = 19, .external_lex_state = 3},
  [197] = {.lex_state = 19, .external_lex_state = 3},
  [198] = {.lex_state = 19, .external_lex_state = 2},
  [199] = {.lex_state = 18, .external_lex_state = 4},
  [200] = {.lex_state = 19, .external_lex_state = 2},
  [201] = {.lex_state = 18, .external_lex_state = 4},
  [202] = {.lex_state = 18, .external_lex_state = 4},
  [203] = {.lex_state = 74},
  [204] = {.lex_state = 18, .external_lex_state = 4},
  [205] = {.lex_state = 19, .external_lex_state = 2},
  [206] = {.lex_state = 74},
  [207] = {.lex_state = 18, .external_lex_state = 4},
  [208] = {.lex_state = 74},
  [209] = {.lex_state = 18, .external_lex_state = 4},
  [210] = {.lex_state = 18, .external_lex_state = 4},
  [211] = {.lex_state = 18, .external_lex_state = 4},
  [212] = {.lex_state = 18, .external_lex_state = 4},
  [213] = {.lex_state = 18, .external_lex_state = 4},
  [214] = {.lex_state = 18, .external_lex_state = 4},
  [215] = {.lex_state = 19, .external_lex_state = 2},
  [216] = {.lex_state = 18, .external_lex_state = 4},
  [217] = {.lex_state = 19, .external_lex_state = 2},
  [218] = {.lex_state = 18, .external_lex_state = 4},
  [219] = {.lex_state = 19, .external_lex_state = 2},
  [220] = {.lex_state = 18, .external_lex_state = 4},
  [221] = {.lex_state = 19, .external_lex_state = 4},
  [222] = {.lex_state = 19, .external_lex_state = 4},
  [223] = {.lex_state = 19, .external_lex_state = 4},
  [224] = {.lex_state = 19, .external_lex_state = 4},
  [225] = {.lex_state = 19, .external_lex_state = 4},
  [226] = {.lex_state = 19, .external_lex_state = 4},
  [227] = {.lex_state = 19, .external_lex_state = 4},
  [228] = {.lex_state = 19, .external_lex_state = 4},
  [229] = {.lex_state = 19, .external_lex_state = 4},
  [230] = {.lex_state = 19, .external_lex_state = 4},
  [231] = {.lex_state = 19, .external_lex_state = 4},
  [232] = {.lex_state = 19, .external_lex_state = 4},
  [233] = {.lex_state = 19, .external_lex_state = 4},
  [234] = {.lex_state = 19, .external_lex_state = 4},
  [235] = {.lex_state = 19, .external_lex_state = 4},
  [236] = {.lex_state = 19, .external_lex_state = 2},
  [237] = {.lex_state = 19, .external_lex_state = 2},
  [238] = {.lex_state = 19, .external_lex_state = 4},
  [239] = {.lex_state = 19, .external_lex_state = 4},
  [240] = {.lex_state = 19, .external_lex_state = 4},
  [241] = {.lex_state = 19, .external_lex_state = 4},
  [242] = {.lex_state = 19, .external_lex_state = 4},
  [243] = {.lex_state = 19, .external_lex_state = 2},
  [244] = {.lex_state = 19, .external_lex_state = 2},
  [245] = {.lex_state = 19, .external_lex_state = 2},
  [246] = {.lex_state = 19, .external_lex_state = 4},
  [247] = {.lex_state = 19, .external_lex_state = 4},
  [248] = {.lex_state = 19, .external_lex_state = 2},
  [249] = {.lex_state = 19, .external_lex_state = 4},
  [250] = {.lex_state = 19, .external_lex_state = 4},
  [251] = {.lex_state = 19, .external_lex_state = 4},
  [252] = {.lex_state = 19, .external_lex_state = 4},
  [253] = {.lex_state = 19, .external_lex_state = 4},
  [254] = {.lex_state = 19, .external_lex_state = 4},
  [255] = {.lex_state = 19, .external_lex_state = 4},
  [256] = {.lex_state = 19, .external_lex_state = 4},
  [257] = {.lex_state = 19, .external_lex_state = 4},
  [258] = {.lex_state = 19, .external_lex_state = 4},
  [259] = {.lex_state = 19, .external_lex_state = 4},
  [260] = {.lex_state = 19, .external_lex_state = 4},
  [261] = {.lex_state = 74},
  [262] = {.lex_state = 74},
  [263] = {.lex_state = 74},
  [264] = {.lex_state = 74},
  [265] = {.lex_state = 74},
  [266] = {.lex_state = 29, .external_lex_state = 5},
  [267] = {.lex_state = 29, .external_lex_state = 5},
  [268] = {.lex_state = 29, .external_lex_state = 5},
  [269] = {.lex_state = 31},
  [270] = {.lex_state = 31},
  [271] = {.lex_state = 31},
  [272] = {.lex_state = 31},
  [273] = {.lex_state = 31},
  [274] = {.lex_state = 27, .external_lex_state = 6},
  [275] = {.lex_state = 27, .external_lex_state = 6},
  [276] = {.lex_state = 31},
  [277] = {.lex_state = 27, .external_lex_state = 6},
  [278] = {.lex_state = 31},
  [279] = {.lex_state = 31},
  [280] = {.lex_state = 31},
  [281] = {.lex_state = 31},
  [282] = {.lex_state = 31},
  [283] = {.lex_state = 31},
  [284] = {.lex_state = 31},
  [285] = {.lex_state = 31},
  [286] = {.lex_state = 27, .external_lex_state = 6},
  [287] = {.lex_state = 74},
  [288] = {.lex_state = 31},
  [289] = {.lex_state = 31},
  [290] = {.lex_state = 74},
  [291] = {.lex_state = 31},
  [292] = {.lex_state = 31},
  [293] = {.lex_state = 26},
  [294] = {.lex_state = 31},
  [295] = {.lex_state = 74},
  [296] = {.lex_state = 31},
  [297] = {.lex_state = 74},
  [298] = {.lex_state = 29, .external_lex_state = 5},
  [299] = {.lex_state = 74},
  [300] = {.lex_state = 74},
  [301] = {.lex_state = 74},
  [302] = {.lex_state = 74},
  [303] = {.lex_state = 74},
  [304] = {.lex_state = 31},
  [305] = {.lex_state = 31},
  [306] = {.lex_state = 31},
  [307] = {.lex_state = 31},
  [308] = {.lex_state = 31},
  [309] = {.lex_state = 31},
  [310] = {.lex_state = 31},
  [311] = {.lex_state = 31},
  [312] = {.lex_state = 31},
  [313] = {.lex_state = 74},
  [314] = {.lex_state = 31},
  [315] = {.lex_state = 31},
  [316] = {.lex_state = 31},
  [317] = {.lex_state = 31},
  [318] = {.lex_state = 31},
  [319] = {.lex_state = 31},
  [320] = {.lex_state = 31},
  [321] = {.lex_state = 31},
  [322] = {.lex_state = 31},
  [323] = {.lex_state = 31},
  [324] = {.lex_state = 31},
  [325] = {.lex_state = 31},
  [326] = {.lex_state = 31},
  [327] = {.lex_state = 31},
  [328] = {.lex_state = 31},
  [329] = {.lex_state = 31},
  [330] = {.lex_state = 31},
  [331] = {.lex_state = 31},
  [332] = {.lex_state = 31},
  [333] = {.lex_state = 31},
  [334] = {.lex_state = 31},
  [335] = {.lex_state = 31, .external_lex_state = 6},
  [336] = {.lex_state = 31, .external_lex_state = 6},
  [337] = {.lex_state = 31, .external_lex_state = 6},
  [338] = {.lex_state = 31, .external_lex_state = 6},
  [339] = {.lex_state = 31, .external_lex_state = 6},
  [340] = {.lex_state = 74},
  [341] = {.lex_state = 74},
  [342] = {.lex_state = 74},
  [343] = {.lex_state = 74},
  [344] = {.lex_state = 74},
  [345] = {.lex_state = 31, .external_lex_state = 6},
  [346] = {.lex_state = 74},
  [347] = {.lex_state = 74},
  [348] = {.lex_state = 31, .external_lex_state = 6},
  [349] = {.lex_state = 31, .external_lex_state = 6},
  [350] = {.lex_state = 31, .external_lex_state = 6},
  [351] = {.lex_state = 31, .external_lex_state = 5},
  [352] = {.lex_state = 74},
  [353] = {.lex_state = 31, .external_lex_state = 5},
  [354] = {.lex_state = 74},
  [355] = {.lex_state = 31, .external_lex_state = 5},
  [356] = {.lex_state = 31, .external_lex_state = 6},
  [357] = {.lex_state = 74},
  [358] = {.lex_state = 74},
  [359] = {.lex_state = 31, .external_lex_state = 5},
  [360] = {.lex_state = 74},
  [361] = {.lex_state = 74},
  [362] = {.lex_state = 31, .external_lex_state = 6},
  [363] = {.lex_state = 31, .external_lex_state = 5},
  [364] = {.lex_state = 31, .external_lex_state = 6},
  [365] = {.lex_state = 74},
  [366] = {.lex_state = 31, .external_lex_state = 6},
  [367] = {.lex_state = 74},
  [368] = {.lex_state = 74},
  [369] = {.lex_state = 74},
  [370] = {.lex_state = 74},
  [371] = {.lex_state = 74},
  [372] = {.lex_state = 31, .external_lex_state = 6},
  [373] = {.lex_state = 74},
  [374] = {.lex_state = 31, .external_lex_state = 6},
  [375] = {.lex_state = 31, .external_lex_state = 6},
  [376] = {.lex_state = 74},
  [377] = {.lex_state = 74},
  [378] = {.lex_state = 74},
  [379] = {.lex_state = 74},
  [380] = {.lex_state = 74},
  [381] = {.lex_state = 31, .external_lex_state = 6},
  [382] = {.lex_state = 74},
  [383] = {.lex_state = 74},
  [384] = {.lex_state = 74},
  [385] = {.lex_state = 74},
  [386] = {.lex_state = 74},
  [387] = {.lex_state = 74},
  [388] = {.lex_state = 31, .external_lex_state = 6},
  [389] = {.lex_state = 31, .external_lex_state = 6},
  [390] = {.lex_state = 31, .external_lex_state = 6},
  [391] = {.lex_state = 31, .external_lex_state = 6},
  [392] = {.lex_state = 31, .external_lex_state = 6},
  [393] = {.lex_state = 31, .external_lex_state = 6},
  [394] = {.lex_state = 74},
  [395] = {.lex_state = 31, .external_lex_state = 6},
  [396] = {.lex_state = 31, .external_lex_state = 6},
  [397] = {.lex_state = 74},
  [398] = {.lex_state = 31, .external_lex_state = 6},
  [399] = {.lex_state = 31, .external_lex_state = 6},
  [400] = {.lex_state = 31, .external_lex_state = 6},
  [401] = {.lex_state = 31, .external_lex_state = 6},
  [402] = {.lex_state = 31, .external_lex_state = 6},
  [403] = {.lex_state = 31, .external_lex_state = 6},
  [404] = {.lex_state = 31, .external_lex_state = 6},
  [405] = {.lex_state = 31, .external_lex_state = 6},
  [406] = {.lex_state = 31, .external_lex_state = 6},
  [407] = {.lex_state = 31, .external_lex_state = 6},
  [408] = {.lex_state = 31, .external_lex_state = 6},
  [409] = {.lex_state = 31, .external_lex_state = 6},
  [410] = {.lex_state = 31, .external_lex_state = 5},
  [411] = {.lex_state = 31, .external_lex_state = 6},
  [412] = {.lex_state = 31, .external_lex_state = 6},
  [413] = {.lex_state = 31, .external_lex_state = 6},
  [414] = {.lex_state = 31, .external_lex_state = 6},
  [415] = {.lex_state = 31, .external_lex_state = 6},
  [416] = {.lex_state = 31, .external_lex_state = 6},
  [417] = {.lex_state = 74},
  [418] = {.lex_state = 31, .external_lex_state = 6},
  [419] = {.lex_state = 31, .external_lex_state = 6},
  [420] = {.lex_state = 31, .external_lex_state = 6},
  [421] = {.lex_state = 31, .external_lex_state = 6},
  [422] = {.lex_state = 31, .external_lex_state = 5},
  [423] = {.lex_state = 31},
  [424] = {.lex_state = 31, .external_lex_state = 5},
  [425] = {.lex_state = 31, .external_lex_state = 5},
  [426] = {.lex_state = 31, .external_lex_state = 5},
  [427] = {.lex_state = 31},
  [428] = {.lex_state = 31},
  [429] = {.lex_state = 31},
  [430] = {.lex_state = 31, .external_lex_state = 5},
  [431] = {.lex_state = 31, .external_lex_state = 5},
  [432] = {.lex_state = 31, .external_lex_state = 5},
  [433] = {.lex_state = 31},
  [434] = {.lex_state = 31},
  [435] = {.lex_state = 31, .external_lex_state = 5},
  [436] = {.lex_state = 31},
  [437] = {.lex_state = 31},
  [438] = {.lex_state = 31},
  [439] = {.lex_state = 31, .external_lex_state = 5},
  [440] = {.lex_state = 31, .external_lex_state = 5},
  [441] = {.lex_state = 31},
  [442] = {.lex_state = 31},
  [443] = {.lex_state = 31},
  [444] = {.lex_state = 31, .external_lex_state = 5},
  [445] = {.lex_state = 31, .external_lex_state = 5},
  [446] = {.lex_state = 31, .external_lex_state = 5},
  [447] = {.lex_state = 74},
  [448] = {.lex_state = 31, .external_lex_state = 5},
  [449] = {.lex_state = 31, .external_lex_state = 5},
  [450] = {.lex_state = 31, .external_lex_state = 5},
  [451] = {.lex_state = 31, .external_lex_state = 5},
  [452] = {.lex_state = 31, .external_lex_state = 5},
  [453] = {.lex_state = 31, .external_lex_state = 5},
  [454] = {.lex_state = 31, .external_lex_state = 5},
  [455] = {.lex_state = 74},
  [456] = {.lex_state = 31, .external_lex_state = 5},
  [457] = {.lex_state = 31, .external_lex_state = 5},
  [458] = {.lex_state = 31, .external_lex_state = 5},
  [459] = {.lex_state = 31, .external_lex_state = 5},
  [460] = {.lex_state = 31, .external_lex_state = 5},
  [461] = {.lex_state = 31, .external_lex_state = 5},
  [462] = {.lex_state = 31, .external_lex_state = 5},
  [463] = {.lex_state = 74},
  [464] = {.lex_state = 31, .external_lex_state = 5},
  [465] = {.lex_state = 31, .external_lex_state = 5},
  [466] = {.lex_state = 31},
  [467] = {.lex_state = 31, .external_lex_state = 5},
  [468] = {.lex_state = 31, .external_lex_state = 5},
  [469] = {.lex_state = 31, .external_lex_state = 5},
  [470] = {.lex_state = 31, .external_lex_state = 5},
  [471] = {.lex_state = 31, .external_lex_state = 5},
  [472] = {.lex_state = 31, .external_lex_state = 5},
  [473] = {.lex_state = 31, .external_lex_state = 5},
  [474] = {.lex_state = 31, .external_lex_state = 5},
  [475] = {.lex_state = 31, .external_lex_state = 5},
  [476] = {.lex_state = 74},
  [477] = {.lex_state = 31, .external_lex_state = 5},
  [478] = {.lex_state = 31, .external_lex_state = 5},
  [479] = {.lex_state = 31, .external_lex_state = 5},
  [480] = {.lex_state = 74},
  [481] = {.lex_state = 74},
  [482] = {.lex_state = 74},
  [483] = {.lex_state = 74},
  [484] = {.lex_state = 74},
  [485] = {.lex_state = 74},
  [486] = {.lex_state = 74},
  [487] = {.lex_state = 74},
  [488] = {.lex_state = 74},
  [489] = {.lex_state = 74},
  [490] = {.lex_state = 74},
  [491] = {.lex_state = 74},
  [492] = {.lex_state = 74},
  [493] = {.lex_state = 74},
  [494] = {.lex_state = 74},
  [495] = {.lex_state = 74},
  [496] = {.lex_state = 74},
  [497] = {.lex_state = 74},
  [498] = {.lex_state = 74},
  [499] = {.lex_state = 74},
  [500] = {.lex_state = 74},
  [501] = {.lex_state = 74},
  [502] = {.lex_state = 74},
  [503] = {.lex_state = 74},
  [504] = {.lex_state = 74},
  [505] = {.lex_state = 74},
  [506] = {.lex_state = 74},
  [507] = {.lex_state = 74},
  [508] = {.lex_state = 74},
  [509] = {.lex_state = 74},
  [510] = {.lex_state = 74},
  [511] = {.lex_state = 74},
  [512] = {.lex_state = 74},
  [513] = {.lex_state = 74},
  [514] = {.lex_state = 74},
  [515] = {.lex_state = 19, .external_lex_state = 2},
  [516] = {.lex_state = 19, .external_lex_state = 2},
  [517] = {.lex_state = 74},
  [518] = {.lex_state = 74, .external_lex_state = 6},
  [519] = {.lex_state = 74, .external_lex_state = 5},
  [520] = {.lex_state = 74},
  [521] = {.lex_state = 74},
  [522] = {.lex_state = 74, .external_lex_state = 6},
  [523] = {.lex_state = 74},
  [524] = {.lex_state = 74},
  [525] = {.lex_state = 74, .external_lex_state = 6},
  [526] = {.lex_state = 74},
  [527] = {.lex_state = 74},
  [528] = {.lex_state = 74, .external_lex_state = 5},
  [529] = {.lex_state = 74},
  [530] = {.lex_state = 74, .external_lex_state = 5},
  [531] = {.lex_state = 74},
  [532] = {.lex_state = 74},
  [533] = {.lex_state = 74},
  [534] = {.lex_state = 74},
  [535] = {.lex_state = 74, .external_lex_state = 5},
  [536] = {.lex_state = 74},
  [537] = {.lex_state = 74, .external_lex_state = 5},
  [538] = {.lex_state = 74},
  [539] = {.lex_state = 74},
  [540] = {.lex_state = 74},
  [541] = {.lex_state = 74},
  [542] = {.lex_state = 74},
  [543] = {.lex_state = 74, .external_lex_state = 5},
  [544] = {.lex_state = 74},
  [545] = {.lex_state = 74},
  [546] = {.lex_state = 74, .external_lex_state = 6},
  [547] = {.lex_state = 74},
  [548] = {.lex_state = 74},
  [549] = {.lex_state = 74},
  [550] = {.lex_state = 74},
  [551] = {.lex_state = 74},
  [552] = {.lex_state = 74},
  [553] = {.lex_state = 74},
  [554] = {.lex_state = 26},
  [555] = {.lex_state = 74},
  [556] = {.lex_state = 74},
  [557] = {.lex_state = 74},
  [558] = {.lex_state = 74},
  [559] = {.lex_state = 74},
  [560] = {.lex_state = 74, .external_lex_state = 5},
  [561] = {.lex_state = 74, .external_lex_state = 6},
  [562] = {.lex_state = 74, .external_lex_state = 5},
  [563] = {.lex_state = 74, .external_lex_state = 5},
  [564] = {.lex_state = 74, .external_lex_state = 5},
  [565] = {.lex_state = 74, .external_lex_state = 6},
  [566] = {.lex_state = 74},
  [567] = {.lex_state = 74, .external_lex_state = 5},
  [568] = {.lex_state = 74, .external_lex_state = 5},
  [569] = {.lex_state = 74, .external_lex_state = 5},
  [570] = {.lex_state = 74},
  [571] = {.lex_state = 74, .external_lex_state = 6},
  [572] = {.lex_state = 74, .external_lex_state = 5},
  [573] = {.lex_state = 74, .external_lex_state = 5},
  [574] = {.lex_state = 74, .external_lex_state = 6},
  [575] = {.lex_state = 74, .external_lex_state = 6},
  [576] = {.lex_state = 74, .external_lex_state = 6},
  [577] = {.lex_state = 74, .external_lex_state = 6},
  [578] = {.lex_state = 74, .external_lex_state = 6},
  [579] = {.lex_state = 74, .external_lex_state = 6},
  [580] = {.lex_state = 74, .external_lex_state = 5},
  [581] = {.lex_state = 74, .external_lex_state = 5},
  [582] = {.lex_state = 74, .external_lex_state = 6},
  [583] = {.lex_state = 74, .external_lex_state = 5},
  [584] = {.lex_state = 74, .external_lex_state = 6},
  [585] = {.lex_state = 74, .external_lex_state = 6},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 11},
  [593] = {.lex_state = 23},
  [594] = {.lex_state = 11},
  [595] = {.lex_state = 23},
  [596] = {.lex_state = 11},
  [597] = {.lex_state = 11},
  [598] = {.lex_state = 0, .external_lex_state = 6},
  [599] = {.lex_state = 23},
  [600] = {.lex_state = 23},
  [601] = {.lex_state = 23},
  [602] = {.lex_state = 0, .external_lex_state = 6},
  [603] = {.lex_state = 23},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 11},
  [606] = {.lex_state = 23},
  [607] = {.lex_state = 0, .external_lex_state = 6},
  [608] = {.lex_state = 74},
  [609] = {.lex_state = 74},
  [610] = {.lex_state = 0, .external_lex_state = 6},
  [611] = {.lex_state = 11},
  [612] = {.lex_state = 23},
  [613] = {.lex_state = 11},
  [614] = {.lex_state = 11},
  [615] = {.lex_state = 11},
  [616] = {.lex_state = 23},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 23},
  [619] = {.lex_state = 0, .external_lex_state = 6},
  [620] = {.lex_state = 11},
  [621] = {.lex_state = 11},
  [622] = {.lex_state = 0, .external_lex_state = 5},
  [623] = {.lex_state = 0, .external_lex_state = 6},
  [624] = {.lex_state = 23},
  [625] = {.lex_state = 74},
  [626] = {.lex_state = 23},
  [627] = {.lex_state = 11},
  [628] = {.lex_state = 23},
  [629] = {.lex_state = 11},
  [630] = {.lex_state = 11},
  [631] = {.lex_state = 74},
  [632] = {.lex_state = 11},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 23},
  [635] = {.lex_state = 23},
  [636] = {.lex_state = 74, .external_lex_state = 5},
  [637] = {.lex_state = 11},
  [638] = {.lex_state = 0, .external_lex_state = 6},
  [639] = {.lex_state = 23},
  [640] = {.lex_state = 74},
  [641] = {.lex_state = 74, .external_lex_state = 5},
  [642] = {.lex_state = 74},
  [643] = {.lex_state = 74},
  [644] = {.lex_state = 74, .external_lex_state = 5},
  [645] = {.lex_state = 0, .external_lex_state = 6},
  [646] = {.lex_state = 0, .external_lex_state = 6},
  [647] = {.lex_state = 0, .external_lex_state = 6},
  [648] = {.lex_state = 74},
  [649] = {.lex_state = 74, .external_lex_state = 5},
  [650] = {.lex_state = 74},
  [651] = {.lex_state = 0, .external_lex_state = 6},
  [652] = {.lex_state = 74},
  [653] = {.lex_state = 74, .external_lex_state = 5},
  [654] = {.lex_state = 74, .external_lex_state = 6},
  [655] = {.lex_state = 0, .external_lex_state = 6},
  [656] = {.lex_state = 74},
  [657] = {.lex_state = 74, .external_lex_state = 6},
  [658] = {.lex_state = 0, .external_lex_state = 6},
  [659] = {.lex_state = 74},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 74, .external_lex_state = 6},
  [662] = {.lex_state = 0, .external_lex_state = 6},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 74, .external_lex_state = 5},
  [667] = {.lex_state = 0, .external_lex_state = 5},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0, .external_lex_state = 6},
  [670] = {.lex_state = 74, .external_lex_state = 6},
  [671] = {.lex_state = 0, .external_lex_state = 6},
  [672] = {.lex_state = 13},
  [673] = {.lex_state = 13},
  [674] = {.lex_state = 0, .external_lex_state = 6},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0, .external_lex_state = 6},
  [677] = {.lex_state = 13},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 74},
  [680] = {.lex_state = 0, .external_lex_state = 6},
  [681] = {.lex_state = 0, .external_lex_state = 6},
  [682] = {.lex_state = 13},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0, .external_lex_state = 6},
  [685] = {.lex_state = 0, .external_lex_state = 6},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 13},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 74, .external_lex_state = 6},
  [690] = {.lex_state = 74, .external_lex_state = 6},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0, .external_lex_state = 6},
  [694] = {.lex_state = 0, .external_lex_state = 6},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 13},
  [698] = {.lex_state = 13},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0, .external_lex_state = 6},
  [701] = {.lex_state = 0, .external_lex_state = 6},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 74, .external_lex_state = 5},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 39},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0, .external_lex_state = 6},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 39},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 74},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 39},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 39},
  [723] = {.lex_state = 39},
  [724] = {.lex_state = 74},
  [725] = {.lex_state = 0, .external_lex_state = 6},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 39},
  [734] = {.lex_state = 39},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 39},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 74},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 74, .external_lex_state = 5},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 39},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 39},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 74},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 74},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0, .external_lex_state = 6},
  [783] = {.lex_state = 39},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 39},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 39},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 74},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 74, .external_lex_state = 5},
  [803] = {.lex_state = 74, .external_lex_state = 5},
  [804] = {.lex_state = 0, .external_lex_state = 7},
  [805] = {.lex_state = 74},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 74},
  [808] = {.lex_state = 74},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0, .external_lex_state = 6},
  [812] = {.lex_state = 0, .external_lex_state = 6},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 74},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 74},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 74},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 74},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 74, .external_lex_state = 5},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 74, .external_lex_state = 5},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 74},
  [842] = {.lex_state = 0, .external_lex_state = 6},
  [843] = {.lex_state = 74},
  [844] = {.lex_state = 0, .external_lex_state = 7},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0, .external_lex_state = 6},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0, .external_lex_state = 7},
  [851] = {.lex_state = 74, .external_lex_state = 5},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0, .external_lex_state = 6},
  [855] = {.lex_state = 0, .external_lex_state = 7},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0, .external_lex_state = 5},
  [863] = {.lex_state = 0, .external_lex_state = 7},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 74},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0, .external_lex_state = 7},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 74},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 39},
  [872] = {.lex_state = 0, .external_lex_state = 6},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 74},
  [876] = {.lex_state = 0, .external_lex_state = 5},
  [877] = {.lex_state = 31},
  [878] = {.lex_state = 39},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 39},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 31},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 39},
  [888] = {.lex_state = 31},
  [889] = {.lex_state = 0, .external_lex_state = 7},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 74},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 31},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 39},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0, .external_lex_state = 5},
  [903] = {.lex_state = 31},
  [904] = {.lex_state = 39},
  [905] = {.lex_state = 31},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0, .external_lex_state = 5},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0, .external_lex_state = 5},
  [912] = {.lex_state = 0, .external_lex_state = 7},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0, .external_lex_state = 5},
  [916] = {.lex_state = 39},
  [917] = {.lex_state = 39},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 74},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 31},
  [922] = {.lex_state = 31},
  [923] = {.lex_state = 0, .external_lex_state = 7},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 74},
  [926] = {.lex_state = 74},
  [927] = {.lex_state = 74},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0, .external_lex_state = 8},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0, .external_lex_state = 9},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0, .external_lex_state = 5},
  [936] = {.lex_state = 74},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0, .external_lex_state = 5},
  [939] = {.lex_state = 0, .external_lex_state = 7},
  [940] = {.lex_state = 0, .external_lex_state = 5},
  [941] = {.lex_state = 0, .external_lex_state = 7},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0, .external_lex_state = 8},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0, .external_lex_state = 5},
  [950] = {.lex_state = 39},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0, .external_lex_state = 5},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 74},
  [955] = {.lex_state = 31},
  [956] = {.lex_state = 0, .external_lex_state = 8},
  [957] = {.lex_state = 0, .external_lex_state = 5},
  [958] = {.lex_state = 26},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 31},
  [962] = {.lex_state = 39},
  [963] = {.lex_state = 0, .external_lex_state = 5},
  [964] = {.lex_state = 31},
  [965] = {.lex_state = 0, .external_lex_state = 8},
  [966] = {.lex_state = 0, .external_lex_state = 5},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 39},
  [971] = {.lex_state = 0, .external_lex_state = 10},
  [972] = {.lex_state = 0, .external_lex_state = 8},
  [973] = {.lex_state = 74},
  [974] = {.lex_state = 0, .external_lex_state = 8},
  [975] = {.lex_state = 31},
  [976] = {.lex_state = 0, .external_lex_state = 9},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 39},
  [979] = {.lex_state = 74},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0, .external_lex_state = 9},
  [984] = {.lex_state = 0, .external_lex_state = 9},
  [985] = {.lex_state = 74},
  [986] = {.lex_state = 31},
  [987] = {.lex_state = 0, .external_lex_state = 9},
  [988] = {.lex_state = 0, .external_lex_state = 9},
  [989] = {.lex_state = 0, .external_lex_state = 9},
  [990] = {.lex_state = 0, .external_lex_state = 9},
  [991] = {.lex_state = 0, .external_lex_state = 9},
  [992] = {.lex_state = 0, .external_lex_state = 5},
  [993] = {.lex_state = 0, .external_lex_state = 9},
  [994] = {.lex_state = 0, .external_lex_state = 9},
  [995] = {.lex_state = 0, .external_lex_state = 9},
  [996] = {.lex_state = 0, .external_lex_state = 9},
  [997] = {.lex_state = 0, .external_lex_state = 9},
  [998] = {.lex_state = 0, .external_lex_state = 5},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0, .external_lex_state = 9},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0, .external_lex_state = 9},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0, .external_lex_state = 9},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0, .external_lex_state = 9},
  [1013] = {.lex_state = 74},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0, .external_lex_state = 5},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 39},
  [1019] = {.lex_state = 0, .external_lex_state = 5},
  [1020] = {.lex_state = 0, .external_lex_state = 5},
  [1021] = {.lex_state = 0, .external_lex_state = 7},
  [1022] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__virtual_end_decl = 0,
  ts_external_token__virtual_open_section = 1,
  ts_external_token__virtual_end_section = 2,
  ts_external_token_minus_without_trailing_whitespace = 3,
  ts_external_token_glsl_content = 4,
  ts_external_token__block_comment_content = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__virtual_end_decl] = sym__virtual_end_decl,
  [ts_external_token__virtual_open_section] = sym__virtual_open_section,
  [ts_external_token__virtual_end_section] = sym__virtual_end_section,
  [ts_external_token_minus_without_trailing_whitespace] = sym_minus_without_trailing_whitespace,
  [ts_external_token_glsl_content] = sym_glsl_content,
  [ts_external_token__block_comment_content] = sym__block_comment_content,
};

static const bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token__virtual_open_section] = true,
    [ts_external_token__virtual_end_section] = true,
    [ts_external_token_minus_without_trailing_whitespace] = true,
    [ts_external_token_glsl_content] = true,
    [ts_external_token__block_comment_content] = true,
  },
  [2] = {
    [ts_external_token_minus_without_trailing_whitespace] = true,
  },
  [3] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token__virtual_end_section] = true,
    [ts_external_token_minus_without_trailing_whitespace] = true,
  },
  [4] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token_minus_without_trailing_whitespace] = true,
  },
  [5] = {
    [ts_external_token__virtual_end_decl] = true,
  },
  [6] = {
    [ts_external_token__virtual_end_decl] = true,
    [ts_external_token__virtual_end_section] = true,
  },
  [7] = {
    [ts_external_token__virtual_end_section] = true,
  },
  [8] = {
    [ts_external_token_glsl_content] = true,
  },
  [9] = {
    [ts_external_token__virtual_open_section] = true,
  },
  [10] = {
    [ts_external_token__block_comment_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_lower_case_identifier] = ACTIONS(1),
    [anon_sym_LBRACE_DASH] = ACTIONS(3),
    [anon_sym_DASH_RBRACE] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym__upper_case_identifier_without_leading_whitespace] = ACTIONS(1),
    [sym__dot_without_leading_whitespace] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_left] = ACTIONS(1),
    [anon_sym_right] = ACTIONS(1),
    [anon_sym_non] = ACTIONS(1),
    [sym__glsl_begin] = ACTIONS(1),
    [sym__glsl_end] = ACTIONS(1),
    [sym_upper_case_identifier] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [sym_string_escape] = ACTIONS(1),
    [sym_module] = ACTIONS(1),
    [sym_effect] = ACTIONS(1),
    [sym_where] = ACTIONS(1),
    [sym_import] = ACTIONS(1),
    [sym_as] = ACTIONS(1),
    [sym_exposing] = ACTIONS(1),
    [sym_case] = ACTIONS(1),
    [sym_of] = ACTIONS(1),
    [sym_type] = ACTIONS(1),
    [sym_alias] = ACTIONS(1),
    [sym_port] = ACTIONS(1),
    [sym_infix] = ACTIONS(1),
    [sym_double_dot] = ACTIONS(1),
    [sym_eq] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_dot] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_LT_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_QMARK_GT] = ACTIONS(1),
    [anon_sym_PIPE_DOT] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [sym__virtual_end_decl] = ACTIONS(1),
    [sym__virtual_open_section] = ACTIONS(1),
    [sym__virtual_end_section] = ACTIONS(1),
    [sym_minus_without_trailing_whitespace] = ACTIONS(1),
    [sym_glsl_content] = ACTIONS(1),
    [sym__block_comment_content] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(897),
    [sym_block_comment] = STATE(1),
    [sym_module_declaration] = STATE(938),
    [aux_sym__import_list] = STATE(206),
    [aux_sym__top_decl_list] = STATE(264),
    [sym_upper_case_qid] = STATE(290),
    [sym_import_clause] = STATE(1019),
    [sym_value_declaration] = STATE(992),
    [sym_function_declaration_left] = STATE(936),
    [sym_type_declaration] = STATE(992),
    [sym_type_alias_declaration] = STATE(992),
    [sym_type_annotation] = STATE(992),
    [sym_port_annotation] = STATE(992),
    [sym__literal_expr_group] = STATE(507),
    [sym_char_constant_expr] = STATE(505),
    [sym_number_constant_expr] = STATE(505),
    [sym_string_constant_expr] = STATE(505),
    [sym_unit_expr] = STATE(507),
    [sym_pattern] = STATE(985),
    [sym_cons_pattern] = STATE(511),
    [sym__single_pattern_cons] = STATE(982),
    [sym__single_pattern] = STATE(512),
    [sym_lower_pattern] = STATE(507),
    [sym_anything_pattern] = STATE(507),
    [sym_record_pattern] = STATE(507),
    [sym_list_pattern] = STATE(507),
    [sym_union_pattern] = STATE(507),
    [sym_tuple_pattern] = STATE(507),
    [sym__parenthesized_pattern] = STATE(504),
    [sym_infix_declaration] = STATE(992),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_lower_case_identifier] = ACTIONS(9),
    [anon_sym_LBRACE_DASH] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(21),
    [sym_upper_case_identifier] = ACTIONS(23),
    [sym_number_literal] = ACTIONS(25),
    [sym_module] = ACTIONS(27),
    [sym_effect] = ACTIONS(29),
    [sym_import] = ACTIONS(31),
    [sym_type] = ACTIONS(33),
    [sym_port] = ACTIONS(35),
    [sym_infix] = ACTIONS(37),
    [sym_underscore] = ACTIONS(39),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(50),
    [sym_operator_as_function_expr] = STATE(50),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__atom] = STATE(76),
    [sym_field_access_expr] = STATE(41),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(50),
    [sym_parenthesized_expr] = STATE(41),
    [sym__literal_expr_group] = STATE(50),
    [sym_char_constant_expr] = STATE(57),
    [sym_number_constant_expr] = STATE(57),
    [sym_string_constant_expr] = STATE(57),
    [sym_anonymous_function_expr] = STATE(50),
    [sym_value_expr] = STATE(41),
    [sym_tuple_expr] = STATE(50),
    [sym_unit_expr] = STATE(50),
    [sym_list_expr] = STATE(50),
    [sym_record_expr] = STATE(41),
    [sym_if_else_expr] = STATE(50),
    [sym__if] = STATE(827),
    [sym_case_of_expr] = STATE(50),
    [sym_let_in_expr] = STATE(50),
    [sym_glsl_code_expr] = STATE(50),
    [aux_sym_function_call_expr_repeat1] = STATE(3),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(49),
    [anon_sym_RPAREN] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(51),
    [anon_sym_RBRACE] = ACTIONS(49),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(55),
    [anon_sym_DQUOTE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(49),
    [anon_sym_else] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_then] = ACTIONS(49),
    [anon_sym_let] = ACTIONS(63),
    [anon_sym_COLON_COLON] = ACTIONS(49),
    [sym__glsl_begin] = ACTIONS(65),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(69),
    [sym_case] = ACTIONS(71),
    [sym_of] = ACTIONS(49),
    [sym_backslash] = ACTIONS(73),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(49),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_SLASH_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(49),
    [anon_sym_EQ_EQ] = ACTIONS(49),
    [anon_sym_SLASH_EQ] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(49),
    [anon_sym_GT_EQ] = ACTIONS(49),
    [anon_sym_AMP_AMP] = ACTIONS(49),
    [anon_sym_PIPE_PIPE] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(49),
    [anon_sym_LT_PIPE] = ACTIONS(49),
    [anon_sym_PIPE_GT] = ACTIONS(49),
    [anon_sym_LT_LT] = ACTIONS(49),
    [anon_sym_GT_GT] = ACTIONS(49),
    [anon_sym_LT_SLASH_GT] = ACTIONS(49),
    [anon_sym_LT_QMARK_GT] = ACTIONS(49),
    [anon_sym_PIPE_DOT] = ACTIONS(49),
    [anon_sym_PIPE_EQ] = ACTIONS(49),
    [sym_minus_without_trailing_whitespace] = ACTIONS(77),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(50),
    [sym_operator_as_function_expr] = STATE(50),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__atom] = STATE(76),
    [sym_field_access_expr] = STATE(41),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(50),
    [sym_parenthesized_expr] = STATE(41),
    [sym__literal_expr_group] = STATE(50),
    [sym_char_constant_expr] = STATE(57),
    [sym_number_constant_expr] = STATE(57),
    [sym_string_constant_expr] = STATE(57),
    [sym_anonymous_function_expr] = STATE(50),
    [sym_value_expr] = STATE(41),
    [sym_tuple_expr] = STATE(50),
    [sym_unit_expr] = STATE(50),
    [sym_list_expr] = STATE(50),
    [sym_record_expr] = STATE(41),
    [sym_if_else_expr] = STATE(50),
    [sym__if] = STATE(827),
    [sym_case_of_expr] = STATE(50),
    [sym_let_in_expr] = STATE(50),
    [sym_glsl_code_expr] = STATE(50),
    [aux_sym_function_call_expr_repeat1] = STATE(3),
    [sym_lower_case_identifier] = ACTIONS(79),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(82),
    [anon_sym_COMMA] = ACTIONS(85),
    [anon_sym_RPAREN] = ACTIONS(85),
    [anon_sym_LBRACE] = ACTIONS(87),
    [anon_sym_RBRACE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(90),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(93),
    [anon_sym_DQUOTE] = ACTIONS(96),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_RBRACK] = ACTIONS(85),
    [anon_sym_else] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(102),
    [anon_sym_then] = ACTIONS(85),
    [anon_sym_let] = ACTIONS(105),
    [anon_sym_COLON_COLON] = ACTIONS(85),
    [sym__glsl_begin] = ACTIONS(108),
    [sym_upper_case_identifier] = ACTIONS(111),
    [sym_number_literal] = ACTIONS(114),
    [sym_case] = ACTIONS(117),
    [sym_of] = ACTIONS(85),
    [sym_backslash] = ACTIONS(120),
    [sym_dot] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_SLASH_SLASH] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_EQ_EQ] = ACTIONS(85),
    [anon_sym_SLASH_EQ] = ACTIONS(85),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_LT_EQ] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(85),
    [anon_sym_AMP_AMP] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_LT_PIPE] = ACTIONS(85),
    [anon_sym_PIPE_GT] = ACTIONS(85),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_LT_SLASH_GT] = ACTIONS(85),
    [anon_sym_LT_QMARK_GT] = ACTIONS(85),
    [anon_sym_PIPE_DOT] = ACTIONS(85),
    [anon_sym_PIPE_EQ] = ACTIONS(85),
    [sym_minus_without_trailing_whitespace] = ACTIONS(126),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(50),
    [sym_operator_as_function_expr] = STATE(50),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__atom] = STATE(76),
    [sym_field_access_expr] = STATE(41),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(50),
    [sym_parenthesized_expr] = STATE(41),
    [sym__literal_expr_group] = STATE(50),
    [sym_char_constant_expr] = STATE(57),
    [sym_number_constant_expr] = STATE(57),
    [sym_string_constant_expr] = STATE(57),
    [sym_anonymous_function_expr] = STATE(50),
    [sym_value_expr] = STATE(41),
    [sym_tuple_expr] = STATE(50),
    [sym_unit_expr] = STATE(50),
    [sym_list_expr] = STATE(50),
    [sym_record_expr] = STATE(41),
    [sym_if_else_expr] = STATE(50),
    [sym__if] = STATE(827),
    [sym_case_of_expr] = STATE(50),
    [sym_let_in_expr] = STATE(50),
    [sym_glsl_code_expr] = STATE(50),
    [aux_sym_function_call_expr_repeat1] = STATE(3),
    [sym_lower_case_identifier] = ACTIONS(129),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(132),
    [anon_sym_COMMA] = ACTIONS(49),
    [anon_sym_RPAREN] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(135),
    [anon_sym_RBRACE] = ACTIONS(49),
    [anon_sym_SQUOTE] = ACTIONS(138),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(141),
    [anon_sym_DQUOTE] = ACTIONS(144),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(49),
    [anon_sym_else] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_then] = ACTIONS(49),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_COLON_COLON] = ACTIONS(49),
    [sym__glsl_begin] = ACTIONS(156),
    [sym_upper_case_identifier] = ACTIONS(159),
    [sym_number_literal] = ACTIONS(162),
    [sym_case] = ACTIONS(165),
    [sym_of] = ACTIONS(49),
    [sym_backslash] = ACTIONS(168),
    [sym_dot] = ACTIONS(171),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(49),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_SLASH_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(49),
    [anon_sym_EQ_EQ] = ACTIONS(49),
    [anon_sym_SLASH_EQ] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(49),
    [anon_sym_GT_EQ] = ACTIONS(49),
    [anon_sym_AMP_AMP] = ACTIONS(49),
    [anon_sym_PIPE_PIPE] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(49),
    [anon_sym_LT_PIPE] = ACTIONS(49),
    [anon_sym_PIPE_GT] = ACTIONS(49),
    [anon_sym_LT_LT] = ACTIONS(49),
    [anon_sym_GT_GT] = ACTIONS(49),
    [anon_sym_LT_SLASH_GT] = ACTIONS(49),
    [anon_sym_LT_QMARK_GT] = ACTIONS(49),
    [anon_sym_PIPE_DOT] = ACTIONS(49),
    [anon_sym_PIPE_EQ] = ACTIONS(49),
    [sym_minus_without_trailing_whitespace] = ACTIONS(174),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(702),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(900),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(199),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(769),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(884),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(205),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(207),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(728),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(980),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(211),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(699),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(913),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(213),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(215),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(714),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(913),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(199),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(744),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(960),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(217),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(219),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(695),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(895),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(223),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(717),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(895),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(211),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_upper_case_qid] = STATE(32),
    [sym_value_qid] = STATE(32),
    [sym_field_accessor_function_expr] = STATE(78),
    [sym__expression] = STATE(781),
    [sym_bin_op_expr] = STATE(308),
    [sym_operator_as_function_expr] = STATE(78),
    [sym__operator_as_function_inner] = STATE(70),
    [sym__call_or_atom] = STATE(269),
    [sym_function_call_expr] = STATE(306),
    [sym__function_call_target] = STATE(215),
    [sym__atom] = STATE(306),
    [sym_field_access_expr] = STATE(30),
    [sym__field_access_start] = STATE(778),
    [sym_negate_expr] = STATE(305),
    [sym_parenthesized_expr] = STATE(30),
    [sym__literal_expr_group] = STATE(305),
    [sym_char_constant_expr] = STATE(322),
    [sym_number_constant_expr] = STATE(322),
    [sym_string_constant_expr] = STATE(322),
    [sym_anonymous_function_expr] = STATE(305),
    [sym_value_expr] = STATE(30),
    [sym_tuple_expr] = STATE(305),
    [sym_unit_expr] = STATE(305),
    [sym_list_expr] = STATE(305),
    [sym_record_expr] = STATE(291),
    [sym_if_else_expr] = STATE(305),
    [sym__if] = STATE(849),
    [sym_case_of_expr] = STATE(305),
    [sym_let_in_expr] = STATE(305),
    [sym_glsl_code_expr] = STATE(305),
    [sym_operator_identifier] = STATE(960),
    [sym_lower_case_identifier] = ACTIONS(41),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(177),
    [anon_sym_RPAREN] = ACTIONS(205),
    [anon_sym_LBRACE] = ACTIONS(181),
    [anon_sym_SQUOTE] = ACTIONS(183),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(191),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [sym__glsl_begin] = ACTIONS(195),
    [sym_upper_case_identifier] = ACTIONS(67),
    [sym_number_literal] = ACTIONS(197),
    [sym_case] = ACTIONS(207),
    [sym_backslash] = ACTIONS(201),
    [sym_dot] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_DASH] = ACTIONS(193),
    [anon_sym_STAR] = ACTIONS(193),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_SLASH_SLASH] = ACTIONS(193),
    [anon_sym_CARET] = ACTIONS(193),
    [anon_sym_EQ_EQ] = ACTIONS(193),
    [anon_sym_SLASH_EQ] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(193),
    [anon_sym_LT_EQ] = ACTIONS(193),
    [anon_sym_GT_EQ] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_PLUS_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_GT_GT] = ACTIONS(193),
    [anon_sym_LT_SLASH_GT] = ACTIONS(193),
    [anon_sym_LT_QMARK_GT] = ACTIONS(193),
    [anon_sym_PIPE_DOT] = ACTIONS(193),
    [anon_sym_PIPE_EQ] = ACTIONS(193),
    [sym_minus_without_trailing_whitespace] = ACTIONS(203),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_upper_case_qid] = STATE(140),
    [sym_value_qid] = STATE(140),
    [sym_field_accessor_function_expr] = STATE(182),
    [sym_operator_as_function_expr] = STATE(182),
    [sym__operator_as_function_inner] = STATE(178),
    [sym__atom] = STATE(161),
    [sym_field_access_expr] = STATE(160),
    [sym__field_access_start] = STATE(748),
    [sym_negate_expr] = STATE(182),
    [sym_parenthesized_expr] = STATE(160),
    [sym__literal_expr_group] = STATE(182),
    [sym_char_constant_expr] = STATE(172),
    [sym_number_constant_expr] = STATE(172),
    [sym_string_constant_expr] = STATE(172),
    [sym_anonymous_function_expr] = STATE(182),
    [sym_value_expr] = STATE(160),
    [sym_tuple_expr] = STATE(182),
    [sym_unit_expr] = STATE(182),
    [sym_list_expr] = STATE(182),
    [sym_record_expr] = STATE(160),
    [sym_if_else_expr] = STATE(182),
    [sym__if] = STATE(815),
    [sym_case_of_expr] = STATE(182),
    [sym_let_in_expr] = STATE(182),
    [sym_glsl_code_expr] = STATE(182),
    [aux_sym_function_call_expr_repeat1] = STATE(15),
    [sym_lower_case_identifier] = ACTIONS(225),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_RPAREN] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(231),
    [anon_sym_SQUOTE] = ACTIONS(234),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(246),
    [anon_sym_COLON_COLON] = ACTIONS(49),
    [sym__glsl_begin] = ACTIONS(249),
    [sym_upper_case_identifier] = ACTIONS(252),
    [sym_number_literal] = ACTIONS(255),
    [sym_case] = ACTIONS(258),
    [sym_backslash] = ACTIONS(261),
    [sym_dot] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(49),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_SLASH_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(49),
    [anon_sym_EQ_EQ] = ACTIONS(49),
    [anon_sym_SLASH_EQ] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(49),
    [anon_sym_GT_EQ] = ACTIONS(49),
    [anon_sym_AMP_AMP] = ACTIONS(49),
    [anon_sym_PIPE_PIPE] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(49),
    [anon_sym_LT_PIPE] = ACTIONS(49),
    [anon_sym_PIPE_GT] = ACTIONS(49),
    [anon_sym_LT_LT] = ACTIONS(49),
    [anon_sym_GT_GT] = ACTIONS(49),
    [anon_sym_LT_SLASH_GT] = ACTIONS(49),
    [anon_sym_LT_QMARK_GT] = ACTIONS(49),
    [anon_sym_PIPE_DOT] = ACTIONS(49),
    [anon_sym_PIPE_EQ] = ACTIONS(49),
    [sym__virtual_end_decl] = ACTIONS(267),
    [sym__virtual_end_section] = ACTIONS(267),
    [sym_minus_without_trailing_whitespace] = ACTIONS(269),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_upper_case_qid] = STATE(140),
    [sym_value_qid] = STATE(140),
    [sym_field_accessor_function_expr] = STATE(182),
    [sym_operator_as_function_expr] = STATE(182),
    [sym__operator_as_function_inner] = STATE(178),
    [sym__atom] = STATE(161),
    [sym_field_access_expr] = STATE(160),
    [sym__field_access_start] = STATE(748),
    [sym_negate_expr] = STATE(182),
    [sym_parenthesized_expr] = STATE(160),
    [sym__literal_expr_group] = STATE(182),
    [sym_char_constant_expr] = STATE(172),
    [sym_number_constant_expr] = STATE(172),
    [sym_string_constant_expr] = STATE(172),
    [sym_anonymous_function_expr] = STATE(182),
    [sym_value_expr] = STATE(160),
    [sym_tuple_expr] = STATE(182),
    [sym_unit_expr] = STATE(182),
    [sym_list_expr] = STATE(182),
    [sym_record_expr] = STATE(160),
    [sym_if_else_expr] = STATE(182),
    [sym__if] = STATE(815),
    [sym_case_of_expr] = STATE(182),
    [sym_let_in_expr] = STATE(182),
    [sym_glsl_code_expr] = STATE(182),
    [aux_sym_function_call_expr_repeat1] = STATE(15),
    [sym_lower_case_identifier] = ACTIONS(272),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(275),
    [anon_sym_RPAREN] = ACTIONS(85),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(281),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(284),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_LBRACK] = ACTIONS(290),
    [anon_sym_if] = ACTIONS(102),
    [anon_sym_let] = ACTIONS(293),
    [anon_sym_COLON_COLON] = ACTIONS(85),
    [sym__glsl_begin] = ACTIONS(296),
    [sym_upper_case_identifier] = ACTIONS(299),
    [sym_number_literal] = ACTIONS(302),
    [sym_case] = ACTIONS(305),
    [sym_backslash] = ACTIONS(308),
    [sym_dot] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_SLASH_SLASH] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_EQ_EQ] = ACTIONS(85),
    [anon_sym_SLASH_EQ] = ACTIONS(85),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_LT_EQ] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(85),
    [anon_sym_AMP_AMP] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_LT_PIPE] = ACTIONS(85),
    [anon_sym_PIPE_GT] = ACTIONS(85),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_LT_SLASH_GT] = ACTIONS(85),
    [anon_sym_LT_QMARK_GT] = ACTIONS(85),
    [anon_sym_PIPE_DOT] = ACTIONS(85),
    [anon_sym_PIPE_EQ] = ACTIONS(85),
    [sym__virtual_end_decl] = ACTIONS(314),
    [sym__virtual_end_section] = ACTIONS(314),
    [sym_minus_without_trailing_whitespace] = ACTIONS(316),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_upper_case_qid] = STATE(140),
    [sym_value_qid] = STATE(140),
    [sym_field_accessor_function_expr] = STATE(182),
    [sym_operator_as_function_expr] = STATE(182),
    [sym__operator_as_function_inner] = STATE(178),
    [sym__atom] = STATE(161),
    [sym_field_access_expr] = STATE(160),
    [sym__field_access_start] = STATE(748),
    [sym_negate_expr] = STATE(182),
    [sym_parenthesized_expr] = STATE(160),
    [sym__literal_expr_group] = STATE(182),
    [sym_char_constant_expr] = STATE(172),
    [sym_number_constant_expr] = STATE(172),
    [sym_string_constant_expr] = STATE(172),
    [sym_anonymous_function_expr] = STATE(182),
    [sym_value_expr] = STATE(160),
    [sym_tuple_expr] = STATE(182),
    [sym_unit_expr] = STATE(182),
    [sym_list_expr] = STATE(182),
    [sym_record_expr] = STATE(160),
    [sym_if_else_expr] = STATE(182),
    [sym__if] = STATE(815),
    [sym_case_of_expr] = STATE(182),
    [sym_let_in_expr] = STATE(182),
    [sym_glsl_code_expr] = STATE(182),
    [aux_sym_function_call_expr_repeat1] = STATE(15),
    [sym_lower_case_identifier] = ACTIONS(319),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(321),
    [anon_sym_RPAREN] = ACTIONS(49),
    [anon_sym_LBRACE] = ACTIONS(323),
    [anon_sym_SQUOTE] = ACTIONS(325),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(327),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(49),
    [sym__glsl_begin] = ACTIONS(335),
    [sym_upper_case_identifier] = ACTIONS(337),
    [sym_number_literal] = ACTIONS(339),
    [sym_case] = ACTIONS(341),
    [sym_backslash] = ACTIONS(343),
    [sym_dot] = ACTIONS(345),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(49),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_SLASH_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(49),
    [anon_sym_EQ_EQ] = ACTIONS(49),
    [anon_sym_SLASH_EQ] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(49),
    [anon_sym_GT_EQ] = ACTIONS(49),
    [anon_sym_AMP_AMP] = ACTIONS(49),
    [anon_sym_PIPE_PIPE] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(49),
    [anon_sym_LT_PIPE] = ACTIONS(49),
    [anon_sym_PIPE_GT] = ACTIONS(49),
    [anon_sym_LT_LT] = ACTIONS(49),
    [anon_sym_GT_GT] = ACTIONS(49),
    [anon_sym_LT_SLASH_GT] = ACTIONS(49),
    [anon_sym_LT_QMARK_GT] = ACTIONS(49),
    [anon_sym_PIPE_DOT] = ACTIONS(49),
    [anon_sym_PIPE_EQ] = ACTIONS(49),
    [sym__virtual_end_decl] = ACTIONS(267),
    [sym__virtual_end_section] = ACTIONS(267),
    [sym_minus_without_trailing_whitespace] = ACTIONS(347),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_upper_case_qid] = STATE(216),
    [sym_value_qid] = STATE(216),
    [sym_field_accessor_function_expr] = STATE(234),
    [sym_operator_as_function_expr] = STATE(234),
    [sym__operator_as_function_inner] = STATE(221),
    [sym__atom] = STATE(241),
    [sym_field_access_expr] = STATE(211),
    [sym__field_access_start] = STATE(679),
    [sym_negate_expr] = STATE(234),
    [sym_parenthesized_expr] = STATE(211),
    [sym__literal_expr_group] = STATE(234),
    [sym_char_constant_expr] = STATE(260),
    [sym_number_constant_expr] = STATE(260),
    [sym_string_constant_expr] = STATE(260),
    [sym_anonymous_function_expr] = STATE(234),
    [sym_value_expr] = STATE(211),
    [sym_tuple_expr] = STATE(234),
    [sym_unit_expr] = STATE(234),
    [sym_list_expr] = STATE(234),
    [sym_record_expr] = STATE(211),
    [sym_if_else_expr] = STATE(234),
    [sym__if] = STATE(833),
    [sym_case_of_expr] = STATE(234),
    [sym_let_in_expr] = STATE(234),
    [sym_glsl_code_expr] = STATE(234),
    [aux_sym_function_call_expr_repeat1] = STATE(19),
    [sym_lower_case_identifier] = ACTIONS(349),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(352),
    [anon_sym_LBRACE] = ACTIONS(355),
    [anon_sym_SQUOTE] = ACTIONS(358),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(364),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(370),
    [anon_sym_COLON_COLON] = ACTIONS(49),
    [sym__glsl_begin] = ACTIONS(373),
    [sym_upper_case_identifier] = ACTIONS(376),
    [sym_number_literal] = ACTIONS(379),
    [sym_case] = ACTIONS(382),
    [sym_backslash] = ACTIONS(385),
    [sym_dot] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(49),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_SLASH_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(49),
    [anon_sym_EQ_EQ] = ACTIONS(49),
    [anon_sym_SLASH_EQ] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(49),
    [anon_sym_GT_EQ] = ACTIONS(49),
    [anon_sym_AMP_AMP] = ACTIONS(49),
    [anon_sym_PIPE_PIPE] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(49),
    [anon_sym_LT_PIPE] = ACTIONS(49),
    [anon_sym_PIPE_GT] = ACTIONS(49),
    [anon_sym_LT_LT] = ACTIONS(49),
    [anon_sym_GT_GT] = ACTIONS(49),
    [anon_sym_LT_SLASH_GT] = ACTIONS(49),
    [anon_sym_LT_QMARK_GT] = ACTIONS(49),
    [anon_sym_PIPE_DOT] = ACTIONS(49),
    [anon_sym_PIPE_EQ] = ACTIONS(49),
    [sym__virtual_end_decl] = ACTIONS(267),
    [sym_minus_without_trailing_whitespace] = ACTIONS(391),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_upper_case_qid] = STATE(216),
    [sym_value_qid] = STATE(216),
    [sym_field_accessor_function_expr] = STATE(234),
    [sym_operator_as_function_expr] = STATE(234),
    [sym__operator_as_function_inner] = STATE(221),
    [sym__atom] = STATE(241),
    [sym_field_access_expr] = STATE(211),
    [sym__field_access_start] = STATE(679),
    [sym_negate_expr] = STATE(234),
    [sym_parenthesized_expr] = STATE(211),
    [sym__literal_expr_group] = STATE(234),
    [sym_char_constant_expr] = STATE(260),
    [sym_number_constant_expr] = STATE(260),
    [sym_string_constant_expr] = STATE(260),
    [sym_anonymous_function_expr] = STATE(234),
    [sym_value_expr] = STATE(211),
    [sym_tuple_expr] = STATE(234),
    [sym_unit_expr] = STATE(234),
    [sym_list_expr] = STATE(234),
    [sym_record_expr] = STATE(211),
    [sym_if_else_expr] = STATE(234),
    [sym__if] = STATE(833),
    [sym_case_of_expr] = STATE(234),
    [sym_let_in_expr] = STATE(234),
    [sym_glsl_code_expr] = STATE(234),
    [aux_sym_function_call_expr_repeat1] = STATE(19),
    [sym_lower_case_identifier] = ACTIONS(394),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_SQUOTE] = ACTIONS(400),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(404),
    [anon_sym_LBRACK] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(61),
    [anon_sym_let] = ACTIONS(408),
    [anon_sym_COLON_COLON] = ACTIONS(49),
    [sym__glsl_begin] = ACTIONS(410),
    [sym_upper_case_identifier] = ACTIONS(412),
    [sym_number_literal] = ACTIONS(414),
    [sym_case] = ACTIONS(416),
    [sym_backslash] = ACTIONS(418),
    [sym_dot] = ACTIONS(420),
    [anon_sym_PLUS] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(49),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_SLASH_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(49),
    [anon_sym_EQ_EQ] = ACTIONS(49),
    [anon_sym_SLASH_EQ] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(49),
    [anon_sym_GT_EQ] = ACTIONS(49),
    [anon_sym_AMP_AMP] = ACTIONS(49),
    [anon_sym_PIPE_PIPE] = ACTIONS(49),
    [anon_sym_PLUS_PLUS] = ACTIONS(49),
    [anon_sym_LT_PIPE] = ACTIONS(49),
    [anon_sym_PIPE_GT] = ACTIONS(49),
    [anon_sym_LT_LT] = ACTIONS(49),
    [anon_sym_GT_GT] = ACTIONS(49),
    [anon_sym_LT_SLASH_GT] = ACTIONS(49),
    [anon_sym_LT_QMARK_GT] = ACTIONS(49),
    [anon_sym_PIPE_DOT] = ACTIONS(49),
    [anon_sym_PIPE_EQ] = ACTIONS(49),
    [sym__virtual_end_decl] = ACTIONS(267),
    [sym_minus_without_trailing_whitespace] = ACTIONS(422),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_upper_case_qid] = STATE(216),
    [sym_value_qid] = STATE(216),
    [sym_field_accessor_function_expr] = STATE(234),
    [sym_operator_as_function_expr] = STATE(234),
    [sym__operator_as_function_inner] = STATE(221),
    [sym__atom] = STATE(241),
    [sym_field_access_expr] = STATE(211),
    [sym__field_access_start] = STATE(679),
    [sym_negate_expr] = STATE(234),
    [sym_parenthesized_expr] = STATE(211),
    [sym__literal_expr_group] = STATE(234),
    [sym_char_constant_expr] = STATE(260),
    [sym_number_constant_expr] = STATE(260),
    [sym_string_constant_expr] = STATE(260),
    [sym_anonymous_function_expr] = STATE(234),
    [sym_value_expr] = STATE(211),
    [sym_tuple_expr] = STATE(234),
    [sym_unit_expr] = STATE(234),
    [sym_list_expr] = STATE(234),
    [sym_record_expr] = STATE(211),
    [sym_if_else_expr] = STATE(234),
    [sym__if] = STATE(833),
    [sym_case_of_expr] = STATE(234),
    [sym_let_in_expr] = STATE(234),
    [sym_glsl_code_expr] = STATE(234),
    [aux_sym_function_call_expr_repeat1] = STATE(19),
    [sym_lower_case_identifier] = ACTIONS(424),
    [anon_sym_LBRACE_DASH] = ACTIONS(43),
    [sym_line_comment] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(427),
    [anon_sym_LBRACE] = ACTIONS(430),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [anon_sym_LBRACK] = ACTIONS(442),
    [anon_sym_if] = ACTIONS(102),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_COLON_COLON] = ACTIONS(85),
    [sym__glsl_begin] = ACTIONS(448),
    [sym_upper_case_identifier] = ACTIONS(451),
    [sym_number_literal] = ACTIONS(454),
    [sym_case] = ACTIONS(457),
    [sym_backslash] = ACTIONS(460),
    [sym_dot] = ACTIONS(463),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_DASH] = ACTIONS(85),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_SLASH_SLASH] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [anon_sym_EQ_EQ] = ACTIONS(85),
    [anon_sym_SLASH_EQ] = ACTIONS(85),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_GT] = ACTIONS(85),
    [anon_sym_LT_EQ] = ACTIONS(85),
    [anon_sym_GT_EQ] = ACTIONS(85),
    [anon_sym_AMP_AMP] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(85),
    [anon_sym_PLUS_PLUS] = ACTIONS(85),
    [anon_sym_LT_PIPE] = ACTIONS(85),
    [anon_sym_PIPE_GT] = ACTIONS(85),
    [anon_sym_LT_LT] = ACTIONS(85),
    [anon_sym_GT_GT] = ACTIONS(85),
    [anon_sym_LT_SLASH_GT] = ACTIONS(85),
    [anon_sym_LT_QMARK_GT] = ACTIONS(85),
    [anon_sym_PIPE_DOT] = ACTIONS(85),
    [anon_sym_PIPE_EQ] = ACTIONS(85),
    [sym__virtual_end_decl] = ACTIONS(314),
    [sym_minus_without_trailing_whitespace] = ACTIONS(466),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(20), 1,
      sym_block_comment,
    STATE(23), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(34), 1,
      sym__field_access_segment,
    ACTIONS(471), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(469), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [68] = 9,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(21), 1,
      sym_block_comment,
    STATE(24), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(158), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(477), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(473), 21,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
    ACTIONS(475), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [140] = 9,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(21), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(22), 1,
      sym_block_comment,
    STATE(158), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(481), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(479), 21,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
    ACTIONS(475), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [212] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(485), 1,
      sym__dot_without_leading_whitespace,
    STATE(34), 1,
      sym__field_access_segment,
    ACTIONS(488), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    STATE(23), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(483), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [280] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(158), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(495), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    STATE(24), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(490), 21,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
    ACTIONS(492), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [350] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(499), 1,
      sym__dot_without_leading_whitespace,
    STATE(25), 1,
      sym_block_comment,
    STATE(26), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(501), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(497), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [417] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(505), 1,
      sym__dot_without_leading_whitespace,
    STATE(26), 1,
      sym_block_comment,
    STATE(27), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(507), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(503), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [484] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(511), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(514), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    STATE(27), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(509), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [549] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(28), 1,
      sym_block_comment,
    ACTIONS(518), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(516), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [611] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(29), 1,
      sym_block_comment,
    ACTIONS(522), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(520), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [673] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(30), 1,
      sym_block_comment,
    ACTIONS(530), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(524), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [739] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(31), 1,
      sym_block_comment,
    ACTIONS(534), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(532), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [801] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(32), 1,
      sym_block_comment,
    ACTIONS(538), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(536), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [863] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(33), 1,
      sym_block_comment,
    ACTIONS(543), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(540), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [929] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(34), 1,
      sym_block_comment,
    ACTIONS(548), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(546), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [991] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(35), 1,
      sym_block_comment,
    ACTIONS(552), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(550), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1053] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(554), 1,
      sym__dot_without_leading_whitespace,
    STATE(36), 1,
      sym_block_comment,
    ACTIONS(514), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1117] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(37), 1,
      sym_block_comment,
    ACTIONS(559), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(557), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1179] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(38), 1,
      sym_block_comment,
    ACTIONS(563), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(561), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1241] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(39), 1,
      sym_block_comment,
    ACTIONS(567), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(565), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1303] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(40), 1,
      sym_block_comment,
    ACTIONS(514), 3,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(509), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1365] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(41), 1,
      sym_block_comment,
    ACTIONS(569), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(526), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1429] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(42), 1,
      sym_block_comment,
    ACTIONS(573), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(571), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1490] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(43), 1,
      sym_block_comment,
    ACTIONS(577), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(575), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1551] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(44), 1,
      sym_block_comment,
    ACTIONS(581), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(579), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1612] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(45), 1,
      sym_block_comment,
    ACTIONS(585), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(583), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1673] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(46), 1,
      sym_block_comment,
    ACTIONS(589), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(587), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1734] = 34,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(591), 1,
      anon_sym_RBRACK,
    ACTIONS(593), 1,
      sym_case,
    STATE(47), 1,
      sym_block_comment,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(712), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [1853] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(48), 1,
      sym_block_comment,
    ACTIONS(597), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(595), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1914] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(49), 1,
      sym_block_comment,
    ACTIONS(601), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(599), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [1975] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(50), 1,
      sym_block_comment,
    ACTIONS(569), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(526), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2036] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(51), 1,
      sym_block_comment,
    ACTIONS(605), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(603), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2097] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(52), 1,
      sym_block_comment,
    ACTIONS(609), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(607), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2158] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(53), 1,
      sym_block_comment,
    ACTIONS(613), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(611), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2219] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(54), 1,
      sym_block_comment,
    ACTIONS(617), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(615), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2280] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(55), 1,
      sym_block_comment,
    ACTIONS(621), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(619), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2341] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(56), 1,
      sym_block_comment,
    ACTIONS(625), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(623), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2402] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(57), 1,
      sym_block_comment,
    ACTIONS(629), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(627), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2463] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(58), 1,
      sym_block_comment,
    ACTIONS(633), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(631), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2524] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(59), 1,
      sym_block_comment,
    ACTIONS(637), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(635), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2585] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(60), 1,
      sym_block_comment,
    ACTIONS(543), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(540), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2648] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(61), 1,
      sym_block_comment,
    ACTIONS(641), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(639), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2709] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(62), 1,
      sym_block_comment,
    ACTIONS(481), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(479), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2770] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(63), 1,
      sym_block_comment,
    ACTIONS(645), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(643), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2831] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(64), 1,
      sym_block_comment,
    ACTIONS(649), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(647), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2892] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(65), 1,
      sym_block_comment,
    ACTIONS(653), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(651), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [2953] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(66), 1,
      sym_block_comment,
    ACTIONS(657), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(655), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3014] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(67), 1,
      sym_block_comment,
    ACTIONS(661), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(659), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3075] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(68), 1,
      sym_block_comment,
    ACTIONS(665), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(663), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3136] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(69), 1,
      sym_block_comment,
    ACTIONS(669), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(667), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3197] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(70), 1,
      sym_block_comment,
    ACTIONS(673), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(671), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3258] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(71), 1,
      sym_block_comment,
    ACTIONS(677), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(675), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3319] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(72), 1,
      sym_block_comment,
    ACTIONS(681), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(679), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3380] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(73), 1,
      sym_block_comment,
    ACTIONS(495), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(490), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3441] = 34,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    ACTIONS(683), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(74), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(731), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3560] = 34,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    ACTIONS(685), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(75), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(784), 1,
      sym__expression,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3679] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(76), 1,
      sym_block_comment,
    ACTIONS(689), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(687), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3740] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(77), 1,
      sym_block_comment,
    ACTIONS(693), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(691), 45,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_if,
      anon_sym_then,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_of,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3801] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(78), 1,
      sym_block_comment,
    ACTIONS(530), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(524), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 31,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [3864] = 34,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    ACTIONS(695), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(79), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(768), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [3983] = 34,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    ACTIONS(697), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(80), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(736), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4102] = 34,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    ACTIONS(699), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(81), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(720), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4221] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(22), 1,
      sym__call_or_atom,
    STATE(41), 1,
      sym_record_expr,
    STATE(43), 1,
      sym__expression,
    STATE(62), 1,
      sym_bin_op_expr,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(82), 1,
      sym_block_comment,
    STATE(200), 1,
      sym__function_call_target,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(66), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(33), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(50), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4337] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(83), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(852), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4453] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(84), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1011), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4569] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(85), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(353), 1,
      sym__call_or_atom,
    STATE(430), 1,
      sym_record_expr,
    STATE(468), 1,
      sym_bin_op_expr,
    STATE(679), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(966), 1,
      sym__expression,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4685] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(86), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(353), 1,
      sym__call_or_atom,
    STATE(430), 1,
      sym_record_expr,
    STATE(459), 1,
      sym__expression,
    STATE(468), 1,
      sym_bin_op_expr,
    STATE(679), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4801] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(87), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(353), 1,
      sym__call_or_atom,
    STATE(430), 1,
      sym_record_expr,
    STATE(468), 1,
      sym_bin_op_expr,
    STATE(679), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(957), 1,
      sym__expression,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [4917] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(88), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(967), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5033] = 9,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(89), 1,
      sym_block_comment,
    STATE(126), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(149), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(481), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(479), 15,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(475), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [5101] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(90), 1,
      sym_block_comment,
    STATE(136), 1,
      sym__call_or_atom,
    STATE(198), 1,
      sym__function_call_target,
    STATE(211), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(226), 1,
      sym__expression,
    STATE(228), 1,
      sym_bin_op_expr,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(227), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(229), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(199), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(234), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5217] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(91), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1010), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5333] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(92), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(411), 1,
      sym__expression,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5449] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(93), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(412), 1,
      sym__expression,
    STATE(748), 1,
      sym__field_access_start,
    STATE(819), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5565] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(94), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1009), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5681] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(95), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(418), 1,
      sym__expression,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5797] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(96), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(416), 1,
      sym__expression,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [5913] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(97), 1,
      sym_block_comment,
    STATE(136), 1,
      sym__call_or_atom,
    STATE(198), 1,
      sym__function_call_target,
    STATE(211), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(228), 1,
      sym_bin_op_expr,
    STATE(253), 1,
      sym__expression,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(227), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(229), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(199), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(234), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6029] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(98), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(868), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6145] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(99), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1008), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6261] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(100), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1006), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6377] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(101), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1005), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6493] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(102), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1003), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6609] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(103), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(327), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6725] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(104), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(324), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [6841] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(749), 1,
      sym__dot_without_leading_whitespace,
    STATE(145), 1,
      sym__field_access_segment,
    STATE(105), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(488), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(483), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [6905] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(106), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1002), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7021] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(107), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1000), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7137] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(108), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(999), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7253] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(109), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(320), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(838), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7369] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(110), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(319), 1,
      sym__expression,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7485] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(111), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(1017), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7601] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(112), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(700), 1,
      sym__expression,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7717] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(113), 1,
      sym_block_comment,
    STATE(136), 1,
      sym__call_or_atom,
    STATE(198), 1,
      sym__function_call_target,
    STATE(211), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(228), 1,
      sym_bin_op_expr,
    STATE(238), 1,
      sym__expression,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(227), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(229), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(199), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(234), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7833] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(114), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(353), 1,
      sym__call_or_atom,
    STATE(430), 1,
      sym_record_expr,
    STATE(468), 1,
      sym_bin_op_expr,
    STATE(471), 1,
      sym__expression,
    STATE(679), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [7949] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(105), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(115), 1,
      sym_block_comment,
    STATE(145), 1,
      sym__field_access_segment,
    ACTIONS(471), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(469), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [8013] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(149), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    STATE(116), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(495), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(490), 15,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(492), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [8079] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(22), 1,
      sym__call_or_atom,
    STATE(41), 1,
      sym_record_expr,
    STATE(62), 1,
      sym_bin_op_expr,
    STATE(65), 1,
      sym__expression,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(117), 1,
      sym_block_comment,
    STATE(200), 1,
      sym__function_call_target,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(66), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(33), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(50), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8195] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(118), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(353), 1,
      sym__call_or_atom,
    STATE(430), 1,
      sym_record_expr,
    STATE(460), 1,
      sym__expression,
    STATE(468), 1,
      sym_bin_op_expr,
    STATE(679), 1,
      sym__field_access_start,
    STATE(873), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8311] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(22), 1,
      sym__call_or_atom,
    STATE(41), 1,
      sym_record_expr,
    STATE(62), 1,
      sym_bin_op_expr,
    STATE(67), 1,
      sym__expression,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(119), 1,
      sym_block_comment,
    STATE(200), 1,
      sym__function_call_target,
    STATE(778), 1,
      sym__field_access_start,
    STATE(822), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(66), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(33), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(50), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8427] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(120), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(859), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8543] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(89), 1,
      sym__call_or_atom,
    STATE(121), 1,
      sym_block_comment,
    STATE(160), 1,
      sym_record_expr,
    STATE(165), 1,
      sym_bin_op_expr,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(194), 1,
      sym__expression,
    STATE(217), 1,
      sym__function_call_target,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(163), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(166), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(159), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(182), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8659] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(89), 1,
      sym__call_or_atom,
    STATE(122), 1,
      sym_block_comment,
    STATE(160), 1,
      sym_record_expr,
    STATE(165), 1,
      sym_bin_op_expr,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(189), 1,
      sym__expression,
    STATE(217), 1,
      sym__function_call_target,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(163), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(166), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(159), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(182), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8775] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(123), 1,
      sym_block_comment,
    STATE(136), 1,
      sym__call_or_atom,
    STATE(198), 1,
      sym__function_call_target,
    STATE(211), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(228), 1,
      sym_bin_op_expr,
    STATE(239), 1,
      sym__expression,
    STATE(679), 1,
      sym__field_access_start,
    STATE(829), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(227), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(229), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(199), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(234), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [8891] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(22), 1,
      sym__call_or_atom,
    STATE(41), 1,
      sym_record_expr,
    STATE(62), 1,
      sym_bin_op_expr,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(71), 1,
      sym__expression,
    STATE(124), 1,
      sym_block_comment,
    STATE(200), 1,
      sym__function_call_target,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(66), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(33), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(50), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9007] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(125), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(890), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9123] = 9,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(116), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(126), 1,
      sym_block_comment,
    STATE(149), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(477), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(473), 15,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(475), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9191] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(89), 1,
      sym__call_or_atom,
    STATE(127), 1,
      sym_block_comment,
    STATE(160), 1,
      sym_record_expr,
    STATE(165), 1,
      sym_bin_op_expr,
    STATE(169), 1,
      sym__expression,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(217), 1,
      sym__function_call_target,
    STATE(748), 1,
      sym__field_access_start,
    STATE(813), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(163), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(166), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(159), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(182), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9307] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(89), 1,
      sym__call_or_atom,
    STATE(128), 1,
      sym_block_comment,
    STATE(160), 1,
      sym_record_expr,
    STATE(164), 1,
      sym__expression,
    STATE(165), 1,
      sym_bin_op_expr,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(217), 1,
      sym__function_call_target,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(163), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(166), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(159), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(182), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9423] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(129), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(842), 1,
      sym__expression,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9539] = 33,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(130), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(269), 1,
      sym__call_or_atom,
    STATE(291), 1,
      sym_record_expr,
    STATE(308), 1,
      sym_bin_op_expr,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(879), 1,
      sym__expression,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9655] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(131), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(353), 1,
      sym__call_or_atom,
    STATE(430), 1,
      sym_record_expr,
    STATE(464), 1,
      sym__expression,
    STATE(468), 1,
      sym_bin_op_expr,
    STATE(679), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9771] = 33,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(132), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(339), 1,
      sym__call_or_atom,
    STATE(349), 1,
      sym_record_expr,
    STATE(390), 1,
      sym_bin_op_expr,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(846), 1,
      sym__expression,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [9887] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(752), 1,
      sym__dot_without_leading_whitespace,
    STATE(133), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(514), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [9948] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(755), 1,
      sym__dot_without_leading_whitespace,
    STATE(133), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(134), 1,
      sym_block_comment,
    ACTIONS(507), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(503), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10011] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(757), 1,
      sym__dot_without_leading_whitespace,
    STATE(134), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(135), 1,
      sym_block_comment,
    ACTIONS(501), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(497), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10074] = 9,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(136), 1,
      sym_block_comment,
    STATE(138), 1,
      sym_operator,
    STATE(143), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(481), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(479), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(475), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10140] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(137), 1,
      sym_block_comment,
    ACTIONS(522), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(520), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10198] = 31,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(138), 1,
      sym_block_comment,
    STATE(198), 1,
      sym__function_call_target,
    STATE(211), 1,
      sym_record_expr,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(231), 1,
      sym__call_or_atom,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(227), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(229), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(199), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(234), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [10308] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(138), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    STATE(139), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(495), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(490), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(492), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10372] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(140), 1,
      sym_block_comment,
    ACTIONS(538), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(536), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10430] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(141), 1,
      sym_block_comment,
    ACTIONS(514), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(509), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10488] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(759), 1,
      sym__dot_without_leading_whitespace,
    STATE(214), 1,
      sym__field_access_segment,
    STATE(142), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(488), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(483), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10550] = 9,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(138), 1,
      sym_operator,
    STATE(139), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(143), 1,
      sym_block_comment,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(477), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(473), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(475), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10616] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(144), 1,
      sym_block_comment,
    ACTIONS(530), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(569), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(524), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10680] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(145), 1,
      sym_block_comment,
    ACTIONS(548), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(546), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10738] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(146), 1,
      sym_block_comment,
    ACTIONS(552), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(550), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10796] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(147), 1,
      sym_block_comment,
    ACTIONS(534), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(532), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10854] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(554), 1,
      sym__dot_without_leading_whitespace,
    STATE(148), 1,
      sym_block_comment,
    ACTIONS(514), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [10914] = 31,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(149), 1,
      sym_block_comment,
    STATE(160), 1,
      sym_record_expr,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(184), 1,
      sym__call_or_atom,
    STATE(217), 1,
      sym__function_call_target,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(163), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(166), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(159), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(182), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [11024] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(150), 1,
      sym_block_comment,
    ACTIONS(559), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(557), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11082] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(142), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(151), 1,
      sym_block_comment,
    STATE(214), 1,
      sym__field_access_segment,
    ACTIONS(471), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(469), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11144] = 31,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(177), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(152), 1,
      sym_block_comment,
    STATE(215), 1,
      sym__function_call_target,
    STATE(291), 1,
      sym_record_expr,
    STATE(311), 1,
      sym__call_or_atom,
    STATE(778), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(78), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(306), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(30), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(305), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [11254] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(153), 1,
      sym_block_comment,
    ACTIONS(567), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(565), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11312] = 31,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    STATE(154), 1,
      sym_block_comment,
    STATE(219), 1,
      sym__function_call_target,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(430), 1,
      sym_record_expr,
    STATE(453), 1,
      sym__call_or_atom,
    STATE(679), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(235), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(469), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(218), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(472), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [11422] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(155), 1,
      sym_block_comment,
    ACTIONS(563), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(561), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11480] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(156), 1,
      sym_block_comment,
    ACTIONS(518), 5,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(516), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11538] = 31,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(725), 1,
      anon_sym_LPAREN,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    STATE(157), 1,
      sym_block_comment,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym__function_call_target,
    STATE(349), 1,
      sym_record_expr,
    STATE(398), 1,
      sym__call_or_atom,
    STATE(748), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(183), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(403), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(144), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(388), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [11648] = 31,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(41), 1,
      sym_record_expr,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(73), 1,
      sym__call_or_atom,
    STATE(158), 1,
      sym_block_comment,
    STATE(200), 1,
      sym__function_call_target,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(60), 2,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
    STATE(66), 2,
      sym_function_call_expr,
      sym__atom,
    STATE(33), 3,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(50), 10,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [11758] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(159), 1,
      sym_block_comment,
    ACTIONS(543), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(569), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(540), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11822] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(160), 1,
      sym_block_comment,
    ACTIONS(569), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(526), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11882] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(161), 1,
      sym_block_comment,
    ACTIONS(689), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(687), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11939] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(162), 1,
      sym_block_comment,
    ACTIONS(585), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(583), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [11996] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(163), 1,
      sym_block_comment,
    ACTIONS(657), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(655), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12053] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(164), 1,
      sym_block_comment,
    ACTIONS(653), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(651), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12110] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(165), 1,
      sym_block_comment,
    ACTIONS(481), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(479), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12167] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(166), 1,
      sym_block_comment,
    ACTIONS(543), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(569), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(540), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12228] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(167), 1,
      sym_block_comment,
    ACTIONS(609), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(607), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12285] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(168), 1,
      sym_block_comment,
    ACTIONS(613), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(611), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12342] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(169), 1,
      sym_block_comment,
    ACTIONS(661), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(659), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12399] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(170), 1,
      sym_block_comment,
    ACTIONS(621), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(619), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12456] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(171), 1,
      sym_block_comment,
    ACTIONS(625), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(623), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12513] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(172), 1,
      sym_block_comment,
    ACTIONS(629), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(627), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12570] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(173), 1,
      sym_block_comment,
    ACTIONS(633), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(631), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12627] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(174), 1,
      sym_block_comment,
    ACTIONS(589), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(587), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12684] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(175), 1,
      sym_block_comment,
    ACTIONS(665), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(663), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12741] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(176), 1,
      sym_block_comment,
    ACTIONS(597), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(595), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12798] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(177), 1,
      sym_block_comment,
    ACTIONS(669), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(667), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12855] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(178), 1,
      sym_block_comment,
    ACTIONS(673), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(671), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12912] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(762), 1,
      sym__dot_without_leading_whitespace,
    STATE(179), 1,
      sym_block_comment,
    STATE(195), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(501), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(497), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [12973] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(180), 1,
      sym_block_comment,
    ACTIONS(573), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(571), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13030] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(181), 1,
      sym_block_comment,
    ACTIONS(581), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(579), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13087] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(182), 1,
      sym_block_comment,
    ACTIONS(569), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(526), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13144] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(183), 1,
      sym_block_comment,
    ACTIONS(530), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(569), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    ACTIONS(524), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 25,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13205] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(184), 1,
      sym_block_comment,
    ACTIONS(495), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(490), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13262] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(185), 1,
      sym_block_comment,
    ACTIONS(641), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(639), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13319] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(186), 1,
      sym_block_comment,
    ACTIONS(601), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(599), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13376] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(187), 1,
      sym_block_comment,
    ACTIONS(637), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(635), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13433] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(188), 1,
      sym_block_comment,
    ACTIONS(617), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(615), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13490] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(189), 1,
      sym_block_comment,
    ACTIONS(677), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(675), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13547] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(190), 1,
      sym_block_comment,
    ACTIONS(681), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(679), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13604] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(764), 1,
      sym__dot_without_leading_whitespace,
    STATE(191), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(514), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13663] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(192), 1,
      sym_block_comment,
    ACTIONS(645), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(643), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13720] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(193), 1,
      sym_block_comment,
    ACTIONS(605), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(603), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13777] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(194), 1,
      sym_block_comment,
    ACTIONS(577), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(575), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13834] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(767), 1,
      sym__dot_without_leading_whitespace,
    STATE(191), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(195), 1,
      sym_block_comment,
    ACTIONS(507), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(503), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13895] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(196), 1,
      sym_block_comment,
    ACTIONS(693), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(691), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [13952] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(197), 1,
      sym_block_comment,
    ACTIONS(649), 4,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(647), 39,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14009] = 28,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(17), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(198), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(241), 1,
      sym__atom,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(211), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(234), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [14111] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(569), 1,
      sym__virtual_end_decl,
    STATE(199), 1,
      sym_block_comment,
    ACTIONS(543), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(540), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14173] = 28,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(4), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(76), 1,
      sym__atom,
    STATE(200), 1,
      sym_block_comment,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(41), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(50), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [14275] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(201), 1,
      sym_block_comment,
    ACTIONS(559), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(557), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14331] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(554), 1,
      sym__dot_without_leading_whitespace,
    STATE(202), 1,
      sym_block_comment,
    ACTIONS(514), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(509), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14389] = 31,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(769), 1,
      ts_builtin_sym_end,
    ACTIONS(771), 1,
      sym_port,
    STATE(203), 1,
      sym_block_comment,
    STATE(208), 1,
      aux_sym__import_list,
    STATE(263), 1,
      aux_sym__top_decl_list,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(1019), 1,
      sym_import_clause,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [14497] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(204), 1,
      sym_block_comment,
    ACTIONS(522), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(520), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14553] = 28,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(16), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(161), 1,
      sym__atom,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(205), 1,
      sym_block_comment,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(160), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(182), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [14655] = 31,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(771), 1,
      sym_port,
    ACTIONS(773), 1,
      ts_builtin_sym_end,
    STATE(206), 1,
      sym_block_comment,
    STATE(261), 1,
      aux_sym__top_decl_list,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(489), 1,
      aux_sym__import_list,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(1019), 1,
      sym_import_clause,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [14763] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(207), 1,
      sym_block_comment,
    ACTIONS(567), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(565), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14819] = 31,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(31), 1,
      sym_import,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(771), 1,
      sym_port,
    ACTIONS(775), 1,
      ts_builtin_sym_end,
    STATE(208), 1,
      sym_block_comment,
    STATE(265), 1,
      aux_sym__top_decl_list,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(489), 1,
      aux_sym__import_list,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(1019), 1,
      sym_import_clause,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [14927] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(209), 1,
      sym_block_comment,
    ACTIONS(552), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(550), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [14983] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(210), 1,
      sym_block_comment,
    ACTIONS(563), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(561), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15039] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(211), 1,
      sym_block_comment,
    ACTIONS(569), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(526), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15097] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(212), 1,
      sym_block_comment,
    ACTIONS(534), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(532), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15153] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(213), 1,
      sym_block_comment,
    ACTIONS(518), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(516), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15209] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(214), 1,
      sym_block_comment,
    ACTIONS(548), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(546), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15265] = 28,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(2), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(76), 1,
      sym__atom,
    STATE(215), 1,
      sym_block_comment,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(41), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(50), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [15367] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(216), 1,
      sym_block_comment,
    ACTIONS(538), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(536), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15423] = 28,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(14), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(161), 1,
      sym__atom,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(217), 1,
      sym_block_comment,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(160), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(182), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [15525] = 8,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    ACTIONS(569), 1,
      sym__virtual_end_decl,
    STATE(218), 1,
      sym_block_comment,
    ACTIONS(530), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(524), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15587] = 28,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(18), 1,
      aux_sym_function_call_expr_repeat1,
    STATE(219), 1,
      sym_block_comment,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(241), 1,
      sym__atom,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(211), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(234), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [15689] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(220), 1,
      sym_block_comment,
    ACTIONS(514), 4,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym__dot_without_leading_whitespace,
      sym_backslash,
    ACTIONS(509), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15745] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(221), 1,
      sym_block_comment,
    ACTIONS(673), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(671), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15800] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(222), 1,
      sym_block_comment,
    ACTIONS(617), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(615), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15855] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(223), 1,
      sym_block_comment,
    ACTIONS(649), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(647), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15910] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(224), 1,
      sym_block_comment,
    ACTIONS(681), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(679), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [15965] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(225), 1,
      sym_block_comment,
    ACTIONS(613), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(611), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16020] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(226), 1,
      sym_block_comment,
    ACTIONS(677), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(675), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16075] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(569), 1,
      sym__virtual_end_decl,
    STATE(227), 1,
      sym_block_comment,
    ACTIONS(543), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(540), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16134] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(228), 1,
      sym_block_comment,
    ACTIONS(481), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(479), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16189] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(229), 1,
      sym_block_comment,
    ACTIONS(657), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(655), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16244] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(230), 1,
      sym_block_comment,
    ACTIONS(665), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(663), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16299] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(231), 1,
      sym_block_comment,
    ACTIONS(495), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(490), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16354] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(232), 1,
      sym_block_comment,
    ACTIONS(645), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(643), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16409] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(233), 1,
      sym_block_comment,
    ACTIONS(609), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(607), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16464] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(234), 1,
      sym_block_comment,
    ACTIONS(569), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(526), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16519] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(569), 1,
      sym__virtual_end_decl,
    STATE(235), 1,
      sym_block_comment,
    ACTIONS(530), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(524), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
    ACTIONS(526), 24,
      anon_sym_COLON_COLON,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16578] = 27,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(727), 1,
      anon_sym_LBRACE,
    ACTIONS(729), 1,
      anon_sym_SQUOTE,
    ACTIONS(731), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(733), 1,
      anon_sym_DQUOTE,
    ACTIONS(735), 1,
      anon_sym_LBRACK,
    ACTIONS(737), 1,
      anon_sym_let,
    ACTIONS(739), 1,
      sym__glsl_begin,
    ACTIONS(741), 1,
      sym_number_literal,
    ACTIONS(743), 1,
      sym_case,
    ACTIONS(745), 1,
      sym_backslash,
    ACTIONS(747), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(777), 1,
      sym_lower_case_identifier,
    ACTIONS(779), 1,
      anon_sym_LPAREN,
    ACTIONS(781), 1,
      sym_upper_case_identifier,
    ACTIONS(783), 1,
      sym_dot,
    STATE(236), 1,
      sym_block_comment,
    STATE(391), 1,
      sym__operator_as_function_inner,
    STATE(402), 1,
      sym__atom,
    STATE(715), 1,
      sym__field_access_start,
    STATE(821), 1,
      sym__if,
    STATE(364), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(399), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(349), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(388), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [16677] = 27,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_LBRACK,
    ACTIONS(191), 1,
      anon_sym_let,
    ACTIONS(195), 1,
      sym__glsl_begin,
    ACTIONS(197), 1,
      sym_number_literal,
    ACTIONS(201), 1,
      sym_backslash,
    ACTIONS(203), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(593), 1,
      sym_case,
    ACTIONS(785), 1,
      sym_lower_case_identifier,
    ACTIONS(787), 1,
      anon_sym_LPAREN,
    ACTIONS(789), 1,
      sym_upper_case_identifier,
    ACTIONS(791), 1,
      sym_dot,
    STATE(237), 1,
      sym_block_comment,
    STATE(315), 1,
      sym__operator_as_function_inner,
    STATE(316), 1,
      sym__atom,
    STATE(771), 1,
      sym__field_access_start,
    STATE(849), 1,
      sym__if,
    STATE(285), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(322), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(291), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(305), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [16776] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(238), 1,
      sym_block_comment,
    ACTIONS(653), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(651), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16831] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(239), 1,
      sym_block_comment,
    ACTIONS(661), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(659), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16886] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(240), 1,
      sym_block_comment,
    ACTIONS(637), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(635), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16941] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(241), 1,
      sym_block_comment,
    ACTIONS(689), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(687), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [16996] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(242), 1,
      sym_block_comment,
    ACTIONS(601), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(599), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17051] = 27,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(394), 1,
      sym_lower_case_identifier,
    ACTIONS(396), 1,
      anon_sym_LPAREN,
    ACTIONS(398), 1,
      anon_sym_LBRACE,
    ACTIONS(400), 1,
      anon_sym_SQUOTE,
    ACTIONS(402), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_let,
    ACTIONS(410), 1,
      sym__glsl_begin,
    ACTIONS(412), 1,
      sym_upper_case_identifier,
    ACTIONS(414), 1,
      sym_number_literal,
    ACTIONS(416), 1,
      sym_case,
    ACTIONS(418), 1,
      sym_backslash,
    ACTIONS(420), 1,
      sym_dot,
    ACTIONS(422), 1,
      sym_minus_without_trailing_whitespace,
    STATE(221), 1,
      sym__operator_as_function_inner,
    STATE(242), 1,
      sym__atom,
    STATE(243), 1,
      sym_block_comment,
    STATE(679), 1,
      sym__field_access_start,
    STATE(833), 1,
      sym__if,
    STATE(216), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(260), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(211), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(234), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [17150] = 27,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(319), 1,
      sym_lower_case_identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_LBRACE,
    ACTIONS(325), 1,
      anon_sym_SQUOTE,
    ACTIONS(327), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    ACTIONS(331), 1,
      anon_sym_LBRACK,
    ACTIONS(333), 1,
      anon_sym_let,
    ACTIONS(335), 1,
      sym__glsl_begin,
    ACTIONS(337), 1,
      sym_upper_case_identifier,
    ACTIONS(339), 1,
      sym_number_literal,
    ACTIONS(341), 1,
      sym_case,
    ACTIONS(343), 1,
      sym_backslash,
    ACTIONS(345), 1,
      sym_dot,
    ACTIONS(347), 1,
      sym_minus_without_trailing_whitespace,
    STATE(178), 1,
      sym__operator_as_function_inner,
    STATE(186), 1,
      sym__atom,
    STATE(244), 1,
      sym_block_comment,
    STATE(748), 1,
      sym__field_access_start,
    STATE(815), 1,
      sym__if,
    STATE(140), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(172), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(160), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(182), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [17249] = 27,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    ACTIONS(705), 1,
      anon_sym_SQUOTE,
    ACTIONS(707), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(709), 1,
      anon_sym_DQUOTE,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    ACTIONS(713), 1,
      anon_sym_let,
    ACTIONS(715), 1,
      sym__glsl_begin,
    ACTIONS(717), 1,
      sym_number_literal,
    ACTIONS(719), 1,
      sym_case,
    ACTIONS(721), 1,
      sym_backslash,
    ACTIONS(723), 1,
      sym_minus_without_trailing_whitespace,
    ACTIONS(793), 1,
      sym_lower_case_identifier,
    ACTIONS(795), 1,
      anon_sym_LPAREN,
    ACTIONS(797), 1,
      sym_upper_case_identifier,
    ACTIONS(799), 1,
      sym_dot,
    STATE(245), 1,
      sym_block_comment,
    STATE(446), 1,
      sym__atom,
    STATE(448), 1,
      sym__operator_as_function_inner,
    STATE(724), 1,
      sym__field_access_start,
    STATE(823), 1,
      sym__if,
    STATE(440), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(445), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(430), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(472), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [17348] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(246), 1,
      sym_block_comment,
    ACTIONS(621), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(619), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17403] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(247), 1,
      sym_block_comment,
    ACTIONS(605), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(603), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17458] = 27,
    ACTIONS(41), 1,
      sym_lower_case_identifier,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_LBRACE,
    ACTIONS(53), 1,
      anon_sym_SQUOTE,
    ACTIONS(55), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_if,
    ACTIONS(63), 1,
      anon_sym_let,
    ACTIONS(65), 1,
      sym__glsl_begin,
    ACTIONS(67), 1,
      sym_upper_case_identifier,
    ACTIONS(69), 1,
      sym_number_literal,
    ACTIONS(71), 1,
      sym_case,
    ACTIONS(73), 1,
      sym_backslash,
    ACTIONS(75), 1,
      sym_dot,
    ACTIONS(77), 1,
      sym_minus_without_trailing_whitespace,
    STATE(49), 1,
      sym__atom,
    STATE(70), 1,
      sym__operator_as_function_inner,
    STATE(248), 1,
      sym_block_comment,
    STATE(778), 1,
      sym__field_access_start,
    STATE(827), 1,
      sym__if,
    STATE(32), 2,
      sym_upper_case_qid,
      sym_value_qid,
    STATE(57), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(41), 4,
      sym_field_access_expr,
      sym_parenthesized_expr,
      sym_value_expr,
      sym_record_expr,
    STATE(50), 12,
      sym_field_accessor_function_expr,
      sym_operator_as_function_expr,
      sym_negate_expr,
      sym__literal_expr_group,
      sym_anonymous_function_expr,
      sym_tuple_expr,
      sym_unit_expr,
      sym_list_expr,
      sym_if_else_expr,
      sym_case_of_expr,
      sym_let_in_expr,
      sym_glsl_code_expr,
  [17557] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(249), 1,
      sym_block_comment,
    ACTIONS(589), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(587), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17612] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(250), 1,
      sym_block_comment,
    ACTIONS(625), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(623), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17667] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(251), 1,
      sym_block_comment,
    ACTIONS(669), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(667), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17722] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(252), 1,
      sym_block_comment,
    ACTIONS(585), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(583), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17777] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(253), 1,
      sym_block_comment,
    ACTIONS(577), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(575), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17832] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(254), 1,
      sym_block_comment,
    ACTIONS(597), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(595), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17887] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(255), 1,
      sym_block_comment,
    ACTIONS(693), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(691), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17942] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(256), 1,
      sym_block_comment,
    ACTIONS(633), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(631), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [17997] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(257), 1,
      sym_block_comment,
    ACTIONS(573), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(571), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18052] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(258), 1,
      sym_block_comment,
    ACTIONS(581), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(579), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18107] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(259), 1,
      sym_block_comment,
    ACTIONS(641), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(639), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18162] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(260), 1,
      sym_block_comment,
    ACTIONS(629), 3,
      sym__virtual_end_decl,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(627), 38,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      anon_sym_COLON_COLON,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18217] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(771), 1,
      sym_port,
    ACTIONS(801), 1,
      ts_builtin_sym_end,
    STATE(261), 1,
      sym_block_comment,
    STATE(262), 1,
      aux_sym__top_decl_list,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18316] = 27,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(803), 1,
      ts_builtin_sym_end,
    ACTIONS(805), 1,
      sym_lower_case_identifier,
    ACTIONS(808), 1,
      anon_sym_LPAREN,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(820), 1,
      anon_sym_DQUOTE,
    ACTIONS(823), 1,
      anon_sym_LBRACK,
    ACTIONS(826), 1,
      sym_upper_case_identifier,
    ACTIONS(829), 1,
      sym_number_literal,
    ACTIONS(832), 1,
      sym_type,
    ACTIONS(835), 1,
      sym_port,
    ACTIONS(838), 1,
      sym_infix,
    ACTIONS(841), 1,
      sym_underscore,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(262), 2,
      sym_block_comment,
      aux_sym__top_decl_list,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18413] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(771), 1,
      sym_port,
    ACTIONS(775), 1,
      ts_builtin_sym_end,
    STATE(262), 1,
      aux_sym__top_decl_list,
    STATE(263), 1,
      sym_block_comment,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18512] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(771), 1,
      sym_port,
    ACTIONS(773), 1,
      ts_builtin_sym_end,
    STATE(262), 1,
      aux_sym__top_decl_list,
    STATE(264), 1,
      sym_block_comment,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18611] = 28,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_lower_case_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(33), 1,
      sym_type,
    ACTIONS(37), 1,
      sym_infix,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(771), 1,
      sym_port,
    ACTIONS(844), 1,
      ts_builtin_sym_end,
    STATE(262), 1,
      aux_sym__top_decl_list,
    STATE(265), 1,
      sym_block_comment,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(936), 1,
      sym_function_declaration_left,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(985), 1,
      sym_pattern,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(992), 6,
      sym_value_declaration,
      sym_type_declaration,
      sym_type_alias_declaration,
      sym_type_annotation,
      sym_port_annotation,
      sym_infix_declaration,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [18710] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(846), 1,
      sym__dot_without_leading_whitespace,
    STATE(266), 1,
      sym_block_comment,
    STATE(267), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(503), 10,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 23,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18763] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(848), 1,
      sym__dot_without_leading_whitespace,
    STATE(267), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(509), 10,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 23,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18814] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(268), 1,
      sym_block_comment,
    ACTIONS(509), 10,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 24,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18862] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(152), 1,
      sym_operator,
    STATE(269), 1,
      sym_block_comment,
    STATE(270), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(475), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      sym_of,
    ACTIONS(851), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18918] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(152), 1,
      sym_operator,
    STATE(270), 1,
      sym_block_comment,
    STATE(272), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(475), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(477), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      sym_of,
    ACTIONS(851), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [18974] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(853), 1,
      sym__dot_without_leading_whitespace,
    STATE(284), 1,
      sym__field_access_segment,
    STATE(271), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(488), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19026] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(152), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    STATE(272), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(492), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      sym_of,
    ACTIONS(856), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19080] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(271), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(273), 1,
      sym_block_comment,
    STATE(284), 1,
      sym__field_access_segment,
    ACTIONS(469), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(471), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19132] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(859), 1,
      sym__dot_without_leading_whitespace,
    STATE(274), 1,
      sym_block_comment,
    STATE(275), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(503), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19184] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(861), 1,
      sym__dot_without_leading_whitespace,
    STATE(275), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(509), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19234] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(864), 1,
      sym__dot_without_leading_whitespace,
    STATE(276), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(509), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19283] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(277), 1,
      sym_block_comment,
    ACTIONS(509), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 27,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19330] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(278), 1,
      sym_block_comment,
    ACTIONS(565), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 28,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_exposing,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19377] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(279), 1,
      sym_block_comment,
    ACTIONS(520), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(522), 28,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_exposing,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19424] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(867), 1,
      sym__dot_without_leading_whitespace,
    STATE(276), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(280), 1,
      sym_block_comment,
    ACTIONS(503), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19475] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(869), 1,
      sym__dot_without_leading_whitespace,
    STATE(280), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(281), 1,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(501), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19526] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(282), 1,
      sym_block_comment,
    ACTIONS(532), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(534), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19572] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(283), 1,
      sym_block_comment,
    ACTIONS(550), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19618] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(284), 1,
      sym_block_comment,
    ACTIONS(546), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19664] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(285), 1,
      sym_block_comment,
    ACTIONS(536), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(538), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19710] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(286), 1,
      sym_block_comment,
    ACTIONS(623), 6,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 26,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19756] = 19,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(871), 1,
      sym_lower_case_identifier,
    ACTIONS(874), 1,
      anon_sym_LPAREN,
    ACTIONS(879), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_SQUOTE,
    ACTIONS(885), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(888), 1,
      anon_sym_DQUOTE,
    ACTIONS(891), 1,
      anon_sym_LBRACK,
    ACTIONS(894), 1,
      sym_upper_case_identifier,
    ACTIONS(897), 1,
      sym_number_literal,
    ACTIONS(900), 1,
      sym_as,
    ACTIONS(902), 1,
      sym_underscore,
    STATE(502), 1,
      sym__union_argument_pattern,
    STATE(508), 1,
      sym_upper_case_qid,
    STATE(287), 2,
      sym_block_comment,
      aux_sym_union_pattern_repeat1,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(877), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_eq,
      sym_arrow,
    STATE(503), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [19830] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(288), 1,
      sym_block_comment,
    ACTIONS(509), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19876] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(289), 1,
      sym_block_comment,
    ACTIONS(516), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [19922] = 20,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(905), 1,
      sym_lower_case_identifier,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(911), 1,
      sym_as,
    STATE(290), 1,
      sym_block_comment,
    STATE(295), 1,
      aux_sym_union_pattern_repeat1,
    STATE(502), 1,
      sym__union_argument_pattern,
    STATE(508), 1,
      sym_upper_case_qid,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(909), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_eq,
      sym_arrow,
    STATE(503), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [19998] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(291), 1,
      sym_block_comment,
    ACTIONS(526), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20046] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(554), 1,
      sym__dot_without_leading_whitespace,
    STATE(292), 1,
      sym_block_comment,
    ACTIONS(509), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20094] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(293), 1,
      sym_block_comment,
    ACTIONS(587), 6,
      sym_eq,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20140] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(294), 1,
      sym_block_comment,
    ACTIONS(557), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(559), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20186] = 20,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(905), 1,
      sym_lower_case_identifier,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(915), 1,
      sym_as,
    STATE(287), 1,
      aux_sym_union_pattern_repeat1,
    STATE(295), 1,
      sym_block_comment,
    STATE(502), 1,
      sym__union_argument_pattern,
    STATE(508), 1,
      sym_upper_case_qid,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(913), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_eq,
      sym_arrow,
    STATE(503), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [20262] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(296), 1,
      sym_block_comment,
    ACTIONS(561), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 27,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20308] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(297), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(685), 1,
      sym__inner_declaration,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [20393] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(298), 1,
      sym_block_comment,
    ACTIONS(623), 7,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 24,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20438] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(299), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(671), 1,
      sym__inner_declaration,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [20523] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(300), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(676), 1,
      sym__inner_declaration,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [20608] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(301), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(681), 1,
      sym__inner_declaration,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [20693] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(302), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(694), 1,
      sym__inner_declaration,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [20778] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(303), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(782), 1,
      sym__inner_declaration,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [20863] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(304), 1,
      sym_block_comment,
    ACTIONS(595), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(597), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20908] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(305), 1,
      sym_block_comment,
    ACTIONS(526), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20953] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(306), 1,
      sym_block_comment,
    ACTIONS(655), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [20998] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(307), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21043] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(308), 1,
      sym_block_comment,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21088] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(309), 1,
      sym_block_comment,
    ACTIONS(631), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21133] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(310), 1,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(581), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21178] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(311), 1,
      sym_block_comment,
    ACTIONS(490), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21223] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(312), 1,
      sym_block_comment,
    ACTIONS(639), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21268] = 25,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(917), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(313), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(811), 1,
      sym_type_annotation,
    STATE(812), 1,
      sym_value_declaration,
    STATE(872), 1,
      sym__inner_declaration,
    STATE(926), 1,
      sym_function_declaration_left,
    STATE(927), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [21353] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(314), 1,
      sym_block_comment,
    ACTIONS(643), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21398] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(315), 1,
      sym_block_comment,
    ACTIONS(671), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(673), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21443] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(316), 1,
      sym_block_comment,
    ACTIONS(599), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21488] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(317), 1,
      sym_block_comment,
    ACTIONS(667), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21533] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(318), 1,
      sym_block_comment,
    ACTIONS(647), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(649), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21578] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(319), 1,
      sym_block_comment,
    ACTIONS(651), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(653), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21623] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(320), 1,
      sym_block_comment,
    ACTIONS(659), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21668] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(321), 1,
      sym_block_comment,
    ACTIONS(663), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21713] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(322), 1,
      sym_block_comment,
    ACTIONS(627), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21758] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(323), 1,
      sym_block_comment,
    ACTIONS(623), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21803] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(324), 1,
      sym_block_comment,
    ACTIONS(675), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(677), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21848] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(325), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21893] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(326), 1,
      sym_block_comment,
    ACTIONS(691), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(693), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21938] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(327), 1,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(577), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [21983] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(328), 1,
      sym_block_comment,
    ACTIONS(607), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22028] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(329), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22073] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(330), 1,
      sym_block_comment,
    ACTIONS(603), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22118] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(331), 1,
      sym_block_comment,
    ACTIONS(619), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22163] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(332), 1,
      sym_block_comment,
    ACTIONS(615), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22208] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(333), 1,
      sym_block_comment,
    ACTIONS(611), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22253] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(334), 1,
      sym_block_comment,
    ACTIONS(635), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 26,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_COLON_COLON,
      sym_of,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22298] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(157), 1,
      sym_operator,
    STATE(335), 1,
      sym_block_comment,
    STATE(338), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(477), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    ACTIONS(475), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(851), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22350] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(336), 1,
      sym_block_comment,
    STATE(337), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(348), 1,
      sym__field_access_segment,
    ACTIONS(469), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(471), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22398] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(919), 1,
      sym__dot_without_leading_whitespace,
    STATE(348), 1,
      sym__field_access_segment,
    STATE(337), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(488), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22446] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(157), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    STATE(338), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(495), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    ACTIONS(492), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(856), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22496] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(157), 1,
      sym_operator,
    STATE(335), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(339), 1,
      sym_block_comment,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(481), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    ACTIONS(475), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(851), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22548] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(924), 1,
      sym_arrow,
    STATE(340), 1,
      sym_block_comment,
    STATE(346), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [22627] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(926), 1,
      sym_arrow,
    STATE(341), 1,
      sym_block_comment,
    STATE(346), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [22706] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(928), 1,
      sym_arrow,
    STATE(342), 1,
      sym_block_comment,
    STATE(346), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [22785] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(930), 1,
      sym_arrow,
    STATE(343), 1,
      sym_block_comment,
    STATE(346), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [22864] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(932), 1,
      sym_arrow,
    STATE(344), 1,
      sym_block_comment,
    STATE(346), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [22943] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(934), 1,
      sym__dot_without_leading_whitespace,
    STATE(274), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(345), 1,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(501), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [22990] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(936), 1,
      sym_lower_case_identifier,
    ACTIONS(939), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(945), 1,
      anon_sym_SQUOTE,
    ACTIONS(948), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(951), 1,
      anon_sym_DQUOTE,
    ACTIONS(954), 1,
      anon_sym_LBRACK,
    ACTIONS(957), 1,
      sym_upper_case_identifier,
    ACTIONS(960), 1,
      sym_number_literal,
    ACTIONS(963), 1,
      sym_arrow,
    ACTIONS(965), 1,
      sym_underscore,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(346), 2,
      sym_block_comment,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23067] = 23,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(968), 1,
      sym_arrow,
    STATE(346), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(347), 1,
      sym_block_comment,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23146] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(348), 1,
      sym_block_comment,
    ACTIONS(546), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23188] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(349), 1,
      sym_block_comment,
    ACTIONS(526), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23232] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(350), 1,
      sym_block_comment,
    ACTIONS(550), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23274] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(495), 1,
      sym__virtual_end_decl,
    STATE(154), 1,
      sym_operator,
    STATE(516), 1,
      sym_operator_identifier,
    STATE(351), 2,
      sym_block_comment,
      aux_sym_bin_op_expr_repeat1,
    ACTIONS(492), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(856), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23322] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(352), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(701), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23398] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(481), 1,
      sym__virtual_end_decl,
    STATE(154), 1,
      sym_operator,
    STATE(353), 1,
      sym_block_comment,
    STATE(359), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(475), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(851), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23448] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(354), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(658), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23524] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(970), 1,
      sym__dot_without_leading_whitespace,
    STATE(439), 1,
      sym__field_access_segment,
    STATE(355), 2,
      sym_block_comment,
      aux_sym_field_access_expr_repeat1,
    ACTIONS(483), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(488), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23570] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(554), 1,
      sym__dot_without_leading_whitespace,
    STATE(356), 1,
      sym_block_comment,
    ACTIONS(509), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23614] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(357), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(651), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23690] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(358), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(607), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23766] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(477), 1,
      sym__virtual_end_decl,
    STATE(154), 1,
      sym_operator,
    STATE(351), 1,
      aux_sym_bin_op_expr_repeat1,
    STATE(359), 1,
      sym_block_comment,
    STATE(516), 1,
      sym_operator_identifier,
    ACTIONS(475), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(851), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [23816] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(347), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(360), 1,
      sym_block_comment,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23892] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(361), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(645), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [23968] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(362), 1,
      sym_block_comment,
    ACTIONS(532), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(534), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24010] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(355), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(363), 1,
      sym_block_comment,
    STATE(439), 1,
      sym__field_access_segment,
    ACTIONS(469), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(471), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24056] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(364), 1,
      sym_block_comment,
    ACTIONS(536), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(538), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24098] = 10,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(365), 1,
      sym_block_comment,
    STATE(370), 1,
      aux_sym_union_pattern_repeat1,
    STATE(502), 1,
      sym__union_argument_pattern,
    STATE(508), 1,
      sym_upper_case_qid,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(911), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(909), 9,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
    STATE(503), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [24150] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(366), 1,
      sym_block_comment,
    ACTIONS(557), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(559), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24192] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(973), 1,
      anon_sym_RBRACK,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(367), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(678), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24268] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(341), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(368), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24344] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(975), 1,
      anon_sym_RPAREN,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(369), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(798), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24420] = 10,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(287), 1,
      aux_sym_union_pattern_repeat1,
    STATE(370), 1,
      sym_block_comment,
    STATE(502), 1,
      sym__union_argument_pattern,
    STATE(508), 1,
      sym_upper_case_qid,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    ACTIONS(915), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(913), 9,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
    STATE(503), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_nullary_constructor_argument_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [24472] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(371), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(623), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24548] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(372), 1,
      sym_block_comment,
    ACTIONS(561), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24590] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(373), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(602), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24666] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(374), 1,
      sym_block_comment,
    ACTIONS(565), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24708] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(375), 1,
      sym_block_comment,
    ACTIONS(520), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(522), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [24750] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(376), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(598), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24826] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(342), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(377), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24902] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(378), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(662), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [24978] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(379), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(638), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25054] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(344), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(380), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25130] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(381), 1,
      sym_block_comment,
    ACTIONS(516), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 23,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25172] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(975), 1,
      anon_sym_RPAREN,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(382), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(818), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25248] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(383), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(619), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25324] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(384), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(610), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25400] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(340), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(385), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25476] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(343), 1,
      aux_sym_anonymous_function_expr_repeat1,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(386), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(544), 1,
      sym_pattern,
    STATE(928), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25552] = 22,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(387), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(647), 1,
      sym_case_of_branch,
    STATE(875), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25628] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(388), 1,
      sym_block_comment,
    ACTIONS(526), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25669] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(389), 1,
      sym_block_comment,
    ACTIONS(587), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25710] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(390), 1,
      sym_block_comment,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25751] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(391), 1,
      sym_block_comment,
    ACTIONS(671), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(673), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25792] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(392), 1,
      sym_block_comment,
    ACTIONS(607), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25833] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(393), 1,
      sym_block_comment,
    ACTIONS(595), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(597), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25874] = 21,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(394), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(683), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [25947] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(395), 1,
      sym_block_comment,
    ACTIONS(611), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [25988] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(396), 1,
      sym_block_comment,
    ACTIONS(619), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26029] = 21,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(397), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(801), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [26102] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(398), 1,
      sym_block_comment,
    ACTIONS(490), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26143] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(399), 1,
      sym_block_comment,
    ACTIONS(627), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26184] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(400), 1,
      sym_block_comment,
    ACTIONS(635), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26225] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(401), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26266] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(402), 1,
      sym_block_comment,
    ACTIONS(599), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26307] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(403), 1,
      sym_block_comment,
    ACTIONS(655), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26348] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(404), 1,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(581), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26389] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(405), 1,
      sym_block_comment,
    ACTIONS(639), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26430] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(406), 1,
      sym_block_comment,
    ACTIONS(643), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26471] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(407), 1,
      sym_block_comment,
    ACTIONS(647), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(649), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26512] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(408), 1,
      sym_block_comment,
    ACTIONS(615), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26553] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(409), 1,
      sym_block_comment,
    ACTIONS(631), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26594] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(977), 1,
      sym__dot_without_leading_whitespace,
    STATE(266), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(410), 1,
      sym_block_comment,
    ACTIONS(497), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(501), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26639] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(411), 1,
      sym_block_comment,
    ACTIONS(651), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(653), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26680] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(412), 1,
      sym_block_comment,
    ACTIONS(659), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26721] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(413), 1,
      sym_block_comment,
    ACTIONS(663), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26762] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(414), 1,
      sym_block_comment,
    ACTIONS(603), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26803] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(415), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26844] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(416), 1,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(577), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26885] = 21,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(417), 1,
      sym_block_comment,
    STATE(504), 1,
      sym__parenthesized_pattern,
    STATE(511), 1,
      sym_cons_pattern,
    STATE(512), 1,
      sym__single_pattern,
    STATE(835), 1,
      sym_pattern,
    STATE(982), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(507), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
  [26958] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(418), 1,
      sym_block_comment,
    ACTIONS(675), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(677), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [26999] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(419), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27040] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(420), 1,
      sym_block_comment,
    ACTIONS(691), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(693), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27081] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(421), 1,
      sym_block_comment,
    ACTIONS(667), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 22,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27122] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(422), 1,
      sym_block_comment,
    ACTIONS(565), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27162] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(979), 1,
      anon_sym_RPAREN,
    STATE(423), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27204] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(424), 1,
      sym_block_comment,
    ACTIONS(557), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(559), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27244] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(554), 1,
      sym__dot_without_leading_whitespace,
    STATE(425), 1,
      sym_block_comment,
    ACTIONS(509), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27286] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(426), 1,
      sym_block_comment,
    ACTIONS(516), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27326] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(982), 1,
      anon_sym_RPAREN,
    STATE(427), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27368] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(985), 1,
      anon_sym_RPAREN,
    STATE(428), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27410] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(988), 1,
      anon_sym_RPAREN,
    STATE(429), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27452] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym__dot_without_leading_whitespace,
    STATE(430), 1,
      sym_block_comment,
    ACTIONS(526), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27494] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(431), 1,
      sym_block_comment,
    ACTIONS(550), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27534] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(432), 1,
      sym_block_comment,
    ACTIONS(532), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(534), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27574] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(991), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27616] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(994), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27658] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(435), 1,
      sym_block_comment,
    ACTIONS(520), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(522), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27698] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(997), 1,
      anon_sym_RPAREN,
    STATE(436), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27740] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    STATE(437), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27782] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1003), 1,
      anon_sym_RPAREN,
    STATE(438), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27824] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(439), 1,
      sym_block_comment,
    ACTIONS(546), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27864] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(440), 1,
      sym_block_comment,
    ACTIONS(536), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(538), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27904] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1006), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27946] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1009), 1,
      anon_sym_RPAREN,
    STATE(442), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [27988] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1012), 1,
      anon_sym_RPAREN,
    STATE(443), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28030] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(444), 1,
      sym_block_comment,
    ACTIONS(561), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 21,
      sym__virtual_end_decl,
      sym__dot_without_leading_whitespace,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28070] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(445), 1,
      sym_block_comment,
    ACTIONS(627), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28109] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(446), 1,
      sym_block_comment,
    ACTIONS(599), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(601), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28148] = 18,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(290), 1,
      sym_upper_case_qid,
    STATE(447), 1,
      sym_block_comment,
    STATE(509), 1,
      sym_cons_pattern,
    STATE(570), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(504), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [28213] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(448), 1,
      sym_block_comment,
    ACTIONS(671), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(673), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28252] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(449), 1,
      sym_block_comment,
    ACTIONS(587), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28291] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(450), 1,
      sym_block_comment,
    ACTIONS(571), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(573), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28330] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(451), 1,
      sym_block_comment,
    ACTIONS(579), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(581), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28369] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(452), 1,
      sym_block_comment,
    ACTIONS(667), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28408] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(453), 1,
      sym_block_comment,
    ACTIONS(490), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28447] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(454), 1,
      sym_block_comment,
    ACTIONS(639), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(641), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28486] = 19,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(905), 1,
      sym_lower_case_identifier,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1017), 1,
      sym_as,
    ACTIONS(1019), 1,
      sym_eq,
    ACTIONS(1021), 1,
      sym_colon,
    STATE(455), 1,
      sym_block_comment,
    STATE(484), 1,
      aux_sym_function_declaration_left_repeat1,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(545), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [28553] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(456), 1,
      sym_block_comment,
    ACTIONS(643), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28592] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(457), 1,
      sym_block_comment,
    ACTIONS(607), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28631] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(458), 1,
      sym_block_comment,
    ACTIONS(647), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(649), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28670] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(459), 1,
      sym_block_comment,
    ACTIONS(651), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(653), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28709] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(460), 1,
      sym_block_comment,
    ACTIONS(659), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28748] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(461), 1,
      sym_block_comment,
    ACTIONS(663), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28787] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(462), 1,
      sym_block_comment,
    ACTIONS(595), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(597), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28826] = 18,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(365), 1,
      sym_upper_case_qid,
    STATE(463), 1,
      sym_block_comment,
    STATE(509), 1,
      sym_cons_pattern,
    STATE(540), 1,
      sym__single_pattern_cons,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(504), 9,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_union_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [28891] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(464), 1,
      sym_block_comment,
    ACTIONS(675), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(677), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28930] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(465), 1,
      sym_block_comment,
    ACTIONS(679), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(681), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [28969] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(466), 1,
      sym_block_comment,
    STATE(884), 1,
      sym_operator_identifier,
    ACTIONS(193), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1023), 19,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29010] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(467), 1,
      sym_block_comment,
    ACTIONS(611), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29049] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(468), 1,
      sym_block_comment,
    ACTIONS(479), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29088] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(469), 1,
      sym_block_comment,
    ACTIONS(655), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29127] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(470), 1,
      sym_block_comment,
    ACTIONS(691), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(693), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29166] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(471), 1,
      sym_block_comment,
    ACTIONS(575), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(577), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29205] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(472), 1,
      sym_block_comment,
    ACTIONS(526), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(569), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29244] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(473), 1,
      sym_block_comment,
    ACTIONS(583), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29283] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(474), 1,
      sym_block_comment,
    ACTIONS(603), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(605), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29322] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(475), 1,
      sym_block_comment,
    ACTIONS(615), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29361] = 19,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(905), 1,
      sym_lower_case_identifier,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1017), 1,
      sym_as,
    ACTIONS(1019), 1,
      sym_eq,
    ACTIONS(1025), 1,
      sym_colon,
    STATE(476), 1,
      sym_block_comment,
    STATE(484), 1,
      aux_sym_function_declaration_left_repeat1,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(545), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [29428] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(477), 1,
      sym_block_comment,
    ACTIONS(635), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(637), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29467] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(478), 1,
      sym_block_comment,
    ACTIONS(631), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29506] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(479), 1,
      sym_block_comment,
    ACTIONS(619), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 20,
      sym__virtual_end_decl,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_LT_PIPE,
      anon_sym_PIPE_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT_SLASH_GT,
      anon_sym_LT_QMARK_GT,
      anon_sym_PIPE_DOT,
      anon_sym_PIPE_EQ,
  [29545] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1027), 1,
      sym__dot_without_leading_whitespace,
    STATE(480), 1,
      sym_block_comment,
    STATE(483), 1,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(503), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(507), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29585] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1027), 1,
      sym__dot_without_leading_whitespace,
    STATE(480), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(481), 1,
      sym_block_comment,
    ACTIONS(497), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(501), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29625] = 15,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1029), 1,
      sym_lower_case_identifier,
    ACTIONS(1032), 1,
      anon_sym_LPAREN,
    ACTIONS(1035), 1,
      anon_sym_LBRACE,
    ACTIONS(1038), 1,
      anon_sym_SQUOTE,
    ACTIONS(1041), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1044), 1,
      anon_sym_DQUOTE,
    ACTIONS(1047), 1,
      anon_sym_LBRACK,
    ACTIONS(1050), 1,
      sym_number_literal,
    ACTIONS(1053), 1,
      sym_eq,
    ACTIONS(1055), 1,
      sym_underscore,
    STATE(482), 2,
      sym_block_comment,
      aux_sym_function_declaration_left_repeat1,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(545), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [29681] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1058), 1,
      sym__dot_without_leading_whitespace,
    STATE(483), 2,
      sym_block_comment,
      aux_sym_upper_case_qid_repeat1,
    ACTIONS(509), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(514), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29719] = 16,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(13), 1,
      anon_sym_LBRACE,
    ACTIONS(15), 1,
      anon_sym_SQUOTE,
    ACTIONS(17), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      sym_number_literal,
    ACTIONS(39), 1,
      sym_underscore,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    ACTIONS(1061), 1,
      sym_eq,
    STATE(482), 1,
      aux_sym_function_declaration_left_repeat1,
    STATE(484), 1,
      sym_block_comment,
    STATE(505), 3,
      sym_char_constant_expr,
      sym_number_constant_expr,
      sym_string_constant_expr,
    STATE(545), 8,
      sym__literal_expr_group,
      sym_unit_expr,
      sym_lower_pattern,
      sym_anything_pattern,
      sym_record_pattern,
      sym_list_pattern,
      sym_tuple_pattern,
      sym__parenthesized_pattern,
  [29777] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(485), 1,
      sym_block_comment,
    ACTIONS(509), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_where,
      sym_as,
      sym_exposing,
    ACTIONS(514), 15,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym__dot_without_leading_whitespace,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29812] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(486), 1,
      sym_block_comment,
    ACTIONS(1017), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1015), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29844] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(487), 1,
      sym_block_comment,
    ACTIONS(623), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(625), 14,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29876] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(488), 1,
      sym_block_comment,
    ACTIONS(631), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(633), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29907] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1067), 1,
      sym_import,
    STATE(1019), 1,
      sym_import_clause,
    STATE(489), 2,
      sym_block_comment,
      aux_sym__import_list,
    ACTIONS(1065), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(1063), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_underscore,
  [29942] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(490), 1,
      sym_block_comment,
    ACTIONS(1070), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1072), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [29973] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(491), 1,
      sym_block_comment,
    ACTIONS(1074), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1076), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30004] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(492), 1,
      sym_block_comment,
    ACTIONS(611), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(613), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30035] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(493), 1,
      sym_block_comment,
    ACTIONS(1078), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1080), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30066] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(494), 1,
      sym_block_comment,
    ACTIONS(607), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(609), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30097] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(495), 1,
      sym_block_comment,
    ACTIONS(1082), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1084), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30128] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(496), 1,
      sym_block_comment,
    ACTIONS(1086), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1088), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30159] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(497), 1,
      sym_block_comment,
    ACTIONS(1090), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1092), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30190] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(498), 1,
      sym_block_comment,
    ACTIONS(1094), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1096), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30221] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(499), 1,
      sym_block_comment,
    ACTIONS(1098), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1100), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30252] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(500), 1,
      sym_block_comment,
    ACTIONS(1102), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1104), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30283] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(501), 1,
      sym_block_comment,
    ACTIONS(619), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(621), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30314] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(502), 1,
      sym_block_comment,
    ACTIONS(1106), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1108), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30345] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(503), 1,
      sym_block_comment,
    ACTIONS(1110), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1112), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30376] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(504), 1,
      sym_block_comment,
    ACTIONS(1114), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1116), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30407] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(505), 1,
      sym_block_comment,
    ACTIONS(627), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(629), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30438] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1092), 1,
      anon_sym_COLON_COLON,
    STATE(506), 1,
      sym_block_comment,
    ACTIONS(1118), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1120), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30471] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1116), 1,
      anon_sym_COLON_COLON,
    STATE(507), 1,
      sym_block_comment,
    ACTIONS(1122), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1124), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30504] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(508), 1,
      sym_block_comment,
    ACTIONS(1126), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1128), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON_COLON,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30535] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(509), 1,
      sym_block_comment,
    ACTIONS(1130), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1132), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30565] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    STATE(510), 1,
      sym_block_comment,
    STATE(514), 1,
      aux_sym_union_variant_repeat1,
    STATE(552), 1,
      sym__single_type_expression,
    STATE(553), 1,
      sym_upper_case_qid,
    STATE(555), 1,
      sym_unit_expr,
    ACTIONS(1138), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [30611] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1146), 1,
      sym_as,
    STATE(511), 1,
      sym_block_comment,
    ACTIONS(1142), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
    ACTIONS(1144), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30643] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1152), 1,
      sym_as,
    STATE(512), 1,
      sym_block_comment,
    ACTIONS(1148), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
    ACTIONS(1150), 12,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30675] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    STATE(510), 1,
      aux_sym_union_variant_repeat1,
    STATE(513), 1,
      sym_block_comment,
    STATE(552), 1,
      sym__single_type_expression,
    STATE(553), 1,
      sym_upper_case_qid,
    STATE(555), 1,
      sym_unit_expr,
    ACTIONS(1154), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [30721] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1156), 1,
      sym_lower_case_identifier,
    ACTIONS(1159), 1,
      anon_sym_LPAREN,
    ACTIONS(1164), 1,
      anon_sym_LBRACE,
    ACTIONS(1167), 1,
      sym_upper_case_identifier,
    STATE(552), 1,
      sym__single_type_expression,
    STATE(553), 1,
      sym_upper_case_qid,
    STATE(555), 1,
      sym_unit_expr,
    STATE(514), 2,
      sym_block_comment,
      aux_sym_union_variant_repeat1,
    ACTIONS(1162), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [30765] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(515), 1,
      sym_block_comment,
    ACTIONS(1172), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(1170), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
  [30795] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(516), 1,
      sym_block_comment,
    ACTIONS(1176), 2,
      sym_minus_without_trailing_whitespace,
      sym_backslash,
    ACTIONS(1174), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_if,
      anon_sym_let,
      sym__glsl_begin,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_case,
      sym_dot,
  [30825] = 15,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    ACTIONS(1178), 1,
      anon_sym_RPAREN,
    STATE(513), 1,
      sym_upper_case_qid,
    STATE(517), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_unit_expr,
    STATE(625), 1,
      sym__type_expression_inner,
    STATE(640), 1,
      sym_type_ref,
    STATE(643), 1,
      sym__single_type_expression,
    STATE(691), 1,
      sym_type_expression,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [30874] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1180), 1,
      sym_lower_case_identifier,
    ACTIONS(1183), 1,
      anon_sym_LPAREN,
    ACTIONS(1186), 1,
      anon_sym_LBRACE,
    ACTIONS(1189), 1,
      sym_upper_case_identifier,
    STATE(571), 1,
      sym_unit_expr,
    STATE(575), 1,
      sym_upper_case_qid,
    STATE(582), 1,
      sym__single_type_expression,
    STATE(518), 2,
      sym_block_comment,
      aux_sym_union_variant_repeat1,
    ACTIONS(1162), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(561), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [30917] = 12,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1192), 1,
      sym_lower_case_identifier,
    ACTIONS(1195), 1,
      anon_sym_LPAREN,
    ACTIONS(1198), 1,
      anon_sym_LBRACE,
    ACTIONS(1201), 1,
      sym_upper_case_identifier,
    STATE(560), 1,
      sym__single_type_expression,
    STATE(567), 1,
      sym_unit_expr,
    STATE(569), 1,
      sym_upper_case_qid,
    STATE(519), 2,
      sym_block_comment,
      aux_sym_union_variant_repeat1,
    ACTIONS(1162), 3,
      sym__virtual_end_decl,
      anon_sym_PIPE,
      sym_arrow,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [30960] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(520), 1,
      sym_block_comment,
    ACTIONS(1206), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1204), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [30989] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(521), 1,
      sym_block_comment,
    ACTIONS(1210), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1208), 13,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_arrow,
      sym_underscore,
  [31018] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1212), 1,
      sym_lower_case_identifier,
    ACTIONS(1214), 1,
      anon_sym_LPAREN,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      sym_upper_case_identifier,
    STATE(522), 1,
      sym_block_comment,
    STATE(525), 1,
      aux_sym_union_variant_repeat1,
    STATE(571), 1,
      sym_unit_expr,
    STATE(575), 1,
      sym_upper_case_qid,
    STATE(582), 1,
      sym__single_type_expression,
    ACTIONS(1154), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(561), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31063] = 15,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(975), 1,
      anon_sym_RPAREN,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    STATE(513), 1,
      sym_upper_case_qid,
    STATE(523), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_unit_expr,
    STATE(625), 1,
      sym__type_expression_inner,
    STATE(640), 1,
      sym_type_ref,
    STATE(643), 1,
      sym__single_type_expression,
    STATE(726), 1,
      sym_type_expression,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31112] = 15,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    ACTIONS(1220), 1,
      anon_sym_RPAREN,
    STATE(513), 1,
      sym_upper_case_qid,
    STATE(524), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_unit_expr,
    STATE(625), 1,
      sym__type_expression_inner,
    STATE(640), 1,
      sym_type_ref,
    STATE(643), 1,
      sym__single_type_expression,
    STATE(779), 1,
      sym_type_expression,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31161] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1212), 1,
      sym_lower_case_identifier,
    ACTIONS(1214), 1,
      anon_sym_LPAREN,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      sym_upper_case_identifier,
    STATE(518), 1,
      aux_sym_union_variant_repeat1,
    STATE(525), 1,
      sym_block_comment,
    STATE(571), 1,
      sym_unit_expr,
    STATE(575), 1,
      sym_upper_case_qid,
    STATE(582), 1,
      sym__single_type_expression,
    ACTIONS(1138), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
    STATE(561), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31206] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(526), 1,
      sym_block_comment,
    ACTIONS(1065), 7,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_import,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(1063), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_underscore,
  [31235] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(527), 1,
      sym_block_comment,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(567), 1,
      sym_unit_expr,
    STATE(666), 1,
      sym__type_expression_inner,
    STATE(802), 1,
      sym_type_ref,
    STATE(803), 1,
      sym__single_type_expression,
    STATE(1020), 1,
      sym_type_expression,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31281] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(519), 1,
      aux_sym_union_variant_repeat1,
    STATE(528), 1,
      sym_block_comment,
    STATE(560), 1,
      sym__single_type_expression,
    STATE(567), 1,
      sym_unit_expr,
    STATE(569), 1,
      sym_upper_case_qid,
    ACTIONS(1230), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31325] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(529), 1,
      sym_block_comment,
    ACTIONS(1232), 6,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_type,
      sym_port,
      sym_infix,
    ACTIONS(803), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_underscore,
  [31353] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(528), 1,
      aux_sym_union_variant_repeat1,
    STATE(530), 1,
      sym_block_comment,
    STATE(560), 1,
      sym__single_type_expression,
    STATE(567), 1,
      sym_unit_expr,
    STATE(569), 1,
      sym_upper_case_qid,
    ACTIONS(1234), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31397] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(531), 1,
      sym_block_comment,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(567), 1,
      sym_unit_expr,
    STATE(666), 1,
      sym__type_expression_inner,
    STATE(802), 1,
      sym_type_ref,
    STATE(803), 1,
      sym__single_type_expression,
    STATE(952), 1,
      sym_type_expression,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31443] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    STATE(513), 1,
      sym_upper_case_qid,
    STATE(532), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_unit_expr,
    STATE(625), 1,
      sym__type_expression_inner,
    STATE(640), 1,
      sym_type_ref,
    STATE(643), 1,
      sym__single_type_expression,
    STATE(800), 1,
      sym_type_expression,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31489] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(533), 1,
      sym_block_comment,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(567), 1,
      sym_unit_expr,
    STATE(666), 1,
      sym__type_expression_inner,
    STATE(802), 1,
      sym_type_ref,
    STATE(803), 1,
      sym__single_type_expression,
    STATE(940), 1,
      sym_type_expression,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31535] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(534), 1,
      sym_block_comment,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(567), 1,
      sym_unit_expr,
    STATE(666), 1,
      sym__type_expression_inner,
    STATE(802), 1,
      sym_type_ref,
    STATE(803), 1,
      sym__single_type_expression,
    STATE(911), 1,
      sym_type_expression,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31581] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(519), 1,
      aux_sym_union_variant_repeat1,
    STATE(535), 1,
      sym_block_comment,
    STATE(560), 1,
      sym__single_type_expression,
    STATE(567), 1,
      sym_unit_expr,
    STATE(569), 1,
      sym_upper_case_qid,
    ACTIONS(1138), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31625] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    STATE(513), 1,
      sym_upper_case_qid,
    STATE(536), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_unit_expr,
    STATE(625), 1,
      sym__type_expression_inner,
    STATE(640), 1,
      sym_type_ref,
    STATE(643), 1,
      sym__single_type_expression,
    STATE(817), 1,
      sym_type_expression,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31671] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(535), 1,
      aux_sym_union_variant_repeat1,
    STATE(537), 1,
      sym_block_comment,
    STATE(560), 1,
      sym__single_type_expression,
    STATE(567), 1,
      sym_unit_expr,
    STATE(569), 1,
      sym_upper_case_qid,
    ACTIONS(1154), 2,
      sym__virtual_end_decl,
      sym_arrow,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31715] = 14,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1212), 1,
      sym_lower_case_identifier,
    ACTIONS(1214), 1,
      anon_sym_LPAREN,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      sym_upper_case_identifier,
    STATE(522), 1,
      sym_upper_case_qid,
    STATE(538), 1,
      sym_block_comment,
    STATE(571), 1,
      sym_unit_expr,
    STATE(661), 1,
      sym__type_expression_inner,
    STATE(670), 1,
      sym_type_ref,
    STATE(690), 1,
      sym__single_type_expression,
    STATE(854), 1,
      sym_type_expression,
    STATE(561), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31761] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1212), 1,
      sym_lower_case_identifier,
    ACTIONS(1214), 1,
      anon_sym_LPAREN,
    ACTIONS(1216), 1,
      anon_sym_LBRACE,
    ACTIONS(1218), 1,
      sym_upper_case_identifier,
    STATE(522), 1,
      sym_upper_case_qid,
    STATE(539), 1,
      sym_block_comment,
    STATE(571), 1,
      sym_unit_expr,
    STATE(670), 1,
      sym_type_ref,
    STATE(689), 1,
      sym__type_expression_inner,
    STATE(690), 1,
      sym__single_type_expression,
    STATE(561), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31804] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1236), 1,
      anon_sym_COLON_COLON,
    STATE(540), 1,
      sym_block_comment,
    ACTIONS(1130), 4,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_lower_case_identifier,
      sym_as,
    ACTIONS(1132), 8,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
  [31833] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    ACTIONS(1134), 1,
      sym_lower_case_identifier,
    ACTIONS(1136), 1,
      anon_sym_LPAREN,
    ACTIONS(1140), 1,
      anon_sym_LBRACE,
    STATE(513), 1,
      sym_upper_case_qid,
    STATE(541), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_unit_expr,
    STATE(640), 1,
      sym_type_ref,
    STATE(643), 1,
      sym__single_type_expression,
    STATE(652), 1,
      sym__type_expression_inner,
    STATE(548), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31876] = 13,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_lower_case_identifier,
    ACTIONS(1224), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(537), 1,
      sym_upper_case_qid,
    STATE(542), 1,
      sym_block_comment,
    STATE(567), 1,
      sym_unit_expr,
    STATE(802), 1,
      sym_type_ref,
    STATE(803), 1,
      sym__single_type_expression,
    STATE(851), 1,
      sym__type_expression_inner,
    STATE(568), 4,
      sym_type_ref_without_args,
      sym_type_variable,
      sym_record_type,
      sym_tuple_type,
  [31919] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(846), 1,
      sym__dot_without_leading_whitespace,
    STATE(266), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(543), 1,
      sym_block_comment,
    ACTIONS(497), 4,
      anon_sym_LBRACE,
      sym_lower_case_identifier,
      sym_as,
      sym_exposing,
    ACTIONS(501), 5,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_arrow,
  [31948] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(544), 1,
      sym_block_comment,
    ACTIONS(1240), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1238), 9,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_arrow,
      sym_underscore,
  [31973] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(545), 1,
      sym_block_comment,
    ACTIONS(1244), 2,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1242), 8,
      anon_sym_LPAREN,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_LBRACK,
      sym_lower_case_identifier,
      sym_number_literal,
      sym_eq,
      sym_underscore,
  [31997] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(497), 1,
      anon_sym_LBRACE,
    ACTIONS(859), 1,
      sym__dot_without_leading_whitespace,
    STATE(274), 1,
      aux_sym_upper_case_qid_repeat1,
    STATE(546), 1,
      sym_block_comment,
    ACTIONS(501), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32024] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1248), 1,
      anon_sym_LBRACE,
    STATE(547), 1,
      sym_block_comment,
    ACTIONS(1246), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32046] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1252), 1,
      anon_sym_LBRACE,
    STATE(548), 1,
      sym_block_comment,
    ACTIONS(1250), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32068] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1256), 1,
      anon_sym_LBRACE,
    STATE(549), 1,
      sym_block_comment,
    ACTIONS(1254), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32090] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1260), 1,
      anon_sym_LBRACE,
    STATE(550), 1,
      sym_block_comment,
    ACTIONS(1258), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32112] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1264), 1,
      anon_sym_LBRACE,
    STATE(551), 1,
      sym_block_comment,
    ACTIONS(1262), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32134] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(552), 1,
      sym_block_comment,
    ACTIONS(1266), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32156] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1270), 1,
      anon_sym_LBRACE,
    STATE(553), 1,
      sym_block_comment,
    ACTIONS(1154), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32178] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1272), 1,
      sym_lower_case_identifier,
    ACTIONS(1274), 1,
      anon_sym_LPAREN,
    ACTIONS(1276), 1,
      sym_upper_case_identifier,
    ACTIONS(1278), 1,
      sym_double_dot,
    STATE(554), 1,
      sym_block_comment,
    STATE(845), 1,
      sym__operator_as_function_inner,
    STATE(758), 3,
      sym_exposed_value,
      sym_exposed_type,
      sym_exposed_operator,
  [32208] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1282), 1,
      anon_sym_LBRACE,
    STATE(555), 1,
      sym_block_comment,
    ACTIONS(1280), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32230] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1286), 1,
      anon_sym_LBRACE,
    STATE(556), 1,
      sym_block_comment,
    ACTIONS(1284), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32252] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1290), 1,
      anon_sym_LBRACE,
    STATE(557), 1,
      sym_block_comment,
    ACTIONS(1288), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32274] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1294), 1,
      anon_sym_LBRACE,
    STATE(558), 1,
      sym_block_comment,
    ACTIONS(1292), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32296] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1298), 1,
      anon_sym_LBRACE,
    STATE(559), 1,
      sym_block_comment,
    ACTIONS(1296), 7,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32318] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(560), 1,
      sym_block_comment,
    ACTIONS(1266), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32339] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1252), 1,
      anon_sym_LBRACE,
    STATE(561), 1,
      sym_block_comment,
    ACTIONS(1250), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32360] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1248), 1,
      anon_sym_LBRACE,
    STATE(562), 1,
      sym_block_comment,
    ACTIONS(1246), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32381] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1290), 1,
      anon_sym_LBRACE,
    STATE(563), 1,
      sym_block_comment,
    ACTIONS(1288), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32402] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1260), 1,
      anon_sym_LBRACE,
    STATE(564), 1,
      sym_block_comment,
    ACTIONS(1258), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32423] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1298), 1,
      anon_sym_LBRACE,
    STATE(565), 1,
      sym_block_comment,
    ACTIONS(1296), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32444] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1272), 1,
      sym_lower_case_identifier,
    ACTIONS(1274), 1,
      anon_sym_LPAREN,
    ACTIONS(1276), 1,
      sym_upper_case_identifier,
    STATE(566), 1,
      sym_block_comment,
    STATE(845), 1,
      sym__operator_as_function_inner,
    STATE(870), 3,
      sym_exposed_value,
      sym_exposed_type,
      sym_exposed_operator,
  [32471] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1282), 1,
      anon_sym_LBRACE,
    STATE(567), 1,
      sym_block_comment,
    ACTIONS(1280), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32492] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1252), 1,
      anon_sym_LBRACE,
    STATE(568), 1,
      sym_block_comment,
    ACTIONS(1250), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32513] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1270), 1,
      anon_sym_LBRACE,
    STATE(569), 1,
      sym_block_comment,
    ACTIONS(1154), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32534] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1300), 1,
      anon_sym_COLON_COLON,
    STATE(570), 1,
      sym_block_comment,
    ACTIONS(1132), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      sym_as,
      sym_eq,
      sym_arrow,
  [32555] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1282), 1,
      anon_sym_LBRACE,
    STATE(571), 1,
      sym_block_comment,
    ACTIONS(1280), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32576] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1256), 1,
      anon_sym_LBRACE,
    STATE(572), 1,
      sym_block_comment,
    ACTIONS(1254), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32597] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1298), 1,
      anon_sym_LBRACE,
    STATE(573), 1,
      sym_block_comment,
    ACTIONS(1296), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32618] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1260), 1,
      anon_sym_LBRACE,
    STATE(574), 1,
      sym_block_comment,
    ACTIONS(1258), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32639] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1270), 1,
      anon_sym_LBRACE,
    STATE(575), 1,
      sym_block_comment,
    ACTIONS(1154), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32660] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1290), 1,
      anon_sym_LBRACE,
    STATE(576), 1,
      sym_block_comment,
    ACTIONS(1288), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32681] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1248), 1,
      anon_sym_LBRACE,
    STATE(577), 1,
      sym_block_comment,
    ACTIONS(1246), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32702] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1294), 1,
      anon_sym_LBRACE,
    STATE(578), 1,
      sym_block_comment,
    ACTIONS(1292), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32723] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1264), 1,
      anon_sym_LBRACE,
    STATE(579), 1,
      sym_block_comment,
    ACTIONS(1262), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32744] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1294), 1,
      anon_sym_LBRACE,
    STATE(580), 1,
      sym_block_comment,
    ACTIONS(1292), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32765] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1286), 1,
      anon_sym_LBRACE,
    STATE(581), 1,
      sym_block_comment,
    ACTIONS(1284), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32786] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(582), 1,
      sym_block_comment,
    ACTIONS(1266), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32807] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1264), 1,
      anon_sym_LBRACE,
    STATE(583), 1,
      sym_block_comment,
    ACTIONS(1262), 6,
      sym__virtual_end_decl,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32828] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1256), 1,
      anon_sym_LBRACE,
    STATE(584), 1,
      sym_block_comment,
    ACTIONS(1254), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32849] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1286), 1,
      anon_sym_LBRACE,
    STATE(585), 1,
      sym_block_comment,
    ACTIONS(1284), 6,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_LPAREN,
      sym_upper_case_identifier,
      sym_lower_case_identifier,
      sym_arrow,
  [32870] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_lower_case_identifier,
    ACTIONS(1304), 1,
      anon_sym_RBRACE,
    STATE(586), 1,
      sym_block_comment,
    STATE(718), 1,
      sym_field,
    STATE(874), 1,
      sym__record_base,
    STATE(883), 1,
      sym__record_inner,
    STATE(925), 1,
      sym_record_base_identifier,
  [32898] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_lower_case_identifier,
    ACTIONS(1306), 1,
      anon_sym_RBRACE,
    STATE(587), 1,
      sym_block_comment,
    STATE(718), 1,
      sym_field,
    STATE(874), 1,
      sym__record_base,
    STATE(925), 1,
      sym_record_base_identifier,
    STATE(959), 1,
      sym__record_inner,
  [32926] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_lower_case_identifier,
    ACTIONS(1308), 1,
      anon_sym_RBRACE,
    STATE(588), 1,
      sym_block_comment,
    STATE(718), 1,
      sym_field,
    STATE(874), 1,
      sym__record_base,
    STATE(892), 1,
      sym__record_inner,
    STATE(925), 1,
      sym_record_base_identifier,
  [32954] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_lower_case_identifier,
    ACTIONS(1310), 1,
      anon_sym_RBRACE,
    STATE(589), 1,
      sym_block_comment,
    STATE(718), 1,
      sym_field,
    STATE(874), 1,
      sym__record_base,
    STATE(925), 1,
      sym_record_base_identifier,
    STATE(948), 1,
      sym__record_inner,
  [32982] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_lower_case_identifier,
    ACTIONS(1312), 1,
      anon_sym_RBRACE,
    STATE(590), 1,
      sym_block_comment,
    STATE(718), 1,
      sym_field,
    STATE(874), 1,
      sym__record_base,
    STATE(901), 1,
      sym__record_inner,
    STATE(925), 1,
      sym_record_base_identifier,
  [33010] = 9,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_lower_case_identifier,
    ACTIONS(1314), 1,
      anon_sym_RBRACE,
    STATE(591), 1,
      sym_block_comment,
    STATE(718), 1,
      sym_field,
    STATE(874), 1,
      sym__record_base,
    STATE(925), 1,
      sym_record_base_identifier,
    STATE(981), 1,
      sym__record_inner,
  [33038] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1316), 1,
      anon_sym_DQUOTE,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    STATE(592), 1,
      sym_block_comment,
    STATE(632), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33061] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1322), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    STATE(593), 1,
      sym_block_comment,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33084] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    STATE(594), 1,
      sym_block_comment,
    STATE(596), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33107] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1330), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(595), 1,
      sym_block_comment,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33130] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1330), 1,
      anon_sym_DQUOTE,
    STATE(596), 1,
      sym_block_comment,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33153] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1332), 1,
      anon_sym_DQUOTE,
    STATE(597), 1,
      sym_block_comment,
    STATE(615), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33176] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1334), 1,
      anon_sym_RPAREN,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1338), 1,
      sym__virtual_end_section,
    STATE(598), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(844), 1,
      sym__more_case_of_branches,
  [33201] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1340), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1342), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1345), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(599), 2,
      sym_block_comment,
      aux_sym_string_constant_expr_repeat1,
  [33222] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1332), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(600), 1,
      sym_block_comment,
    STATE(603), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33245] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1316), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    STATE(601), 1,
      sym_block_comment,
    STATE(634), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33268] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1348), 1,
      anon_sym_RPAREN,
    ACTIONS(1350), 1,
      sym__virtual_end_section,
    STATE(602), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(855), 1,
      sym__more_case_of_branches,
  [33293] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1352), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(603), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33316] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1354), 1,
      sym_lower_case_identifier,
    ACTIONS(1356), 1,
      anon_sym_RBRACE,
    STATE(604), 1,
      sym_block_comment,
    STATE(727), 1,
      sym_field_type,
    STATE(847), 1,
      sym__record_base,
    STATE(925), 1,
      sym_record_base_identifier,
  [33341] = 6,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1358), 1,
      anon_sym_DQUOTE,
    ACTIONS(1360), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1363), 2,
      sym_string_escape,
      sym_invalid_string_escape,
    STATE(605), 2,
      sym_block_comment,
      aux_sym_string_constant_expr_repeat2,
  [33362] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(595), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(606), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33385] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1366), 1,
      anon_sym_RPAREN,
    ACTIONS(1368), 1,
      sym__virtual_end_section,
    STATE(607), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(867), 1,
      sym__more_case_of_branches,
  [33410] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1372), 1,
      sym_arrow,
    STATE(608), 1,
      sym_block_comment,
    STATE(631), 1,
      aux_sym_type_expression_repeat1,
    ACTIONS(1370), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [33431] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1374), 1,
      sym_lower_case_identifier,
    ACTIONS(1376), 1,
      sym_upper_case_identifier,
    STATE(609), 1,
      sym_block_comment,
    STATE(935), 1,
      sym_value_expr,
    STATE(440), 2,
      sym_upper_case_qid,
      sym_value_qid,
  [33454] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1378), 1,
      anon_sym_RPAREN,
    ACTIONS(1380), 1,
      sym__virtual_end_section,
    STATE(610), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(863), 1,
      sym__more_case_of_branches,
  [33479] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1382), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(611), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33502] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1382), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(612), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33525] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1384), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(613), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33548] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1386), 1,
      anon_sym_DQUOTE,
    STATE(611), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(614), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33571] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1352), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(615), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33594] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1386), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(612), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(616), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33617] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1354), 1,
      sym_lower_case_identifier,
    ACTIONS(1388), 1,
      anon_sym_RBRACE,
    STATE(617), 1,
      sym_block_comment,
    STATE(696), 1,
      sym_field_type,
    STATE(858), 1,
      sym__record_base,
    STATE(925), 1,
      sym_record_base_identifier,
  [33642] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1390), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(593), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(618), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33665] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1392), 1,
      anon_sym_RPAREN,
    ACTIONS(1394), 1,
      sym__virtual_end_section,
    STATE(619), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(850), 1,
      sym__more_case_of_branches,
  [33690] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1390), 1,
      anon_sym_DQUOTE,
    STATE(620), 1,
      sym_block_comment,
    STATE(621), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33713] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1322), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(621), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33736] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1396), 1,
      sym_as,
    ACTIONS(1398), 1,
      sym_exposing,
    ACTIONS(1400), 1,
      sym__virtual_end_decl,
    STATE(622), 1,
      sym_block_comment,
    STATE(667), 1,
      sym_as_clause,
    STATE(998), 1,
      sym_exposing_list,
  [33761] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1402), 1,
      anon_sym_RPAREN,
    ACTIONS(1404), 1,
      sym__virtual_end_section,
    STATE(623), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(804), 1,
      sym__more_case_of_branches,
  [33786] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1384), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(624), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33809] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1372), 1,
      sym_arrow,
    STATE(608), 1,
      aux_sym_type_expression_repeat1,
    STATE(625), 1,
      sym_block_comment,
    ACTIONS(1406), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [33830] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1408), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(626), 1,
      sym_block_comment,
    STATE(628), 1,
      aux_sym_string_constant_expr_repeat1,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33853] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1408), 1,
      anon_sym_DQUOTE,
    STATE(627), 1,
      sym_block_comment,
    STATE(630), 1,
      aux_sym_string_constant_expr_repeat2,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33876] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1410), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(628), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33899] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1412), 1,
      anon_sym_DQUOTE,
    STATE(613), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(629), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33922] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1410), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(630), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33945] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1416), 1,
      sym_arrow,
    STATE(631), 2,
      sym_block_comment,
      aux_sym_type_expression_repeat1,
    ACTIONS(1414), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [33964] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      aux_sym_string_constant_expr_token2,
    ACTIONS(1419), 1,
      anon_sym_DQUOTE,
    STATE(605), 1,
      aux_sym_string_constant_expr_repeat2,
    STATE(632), 1,
      sym_block_comment,
    ACTIONS(1320), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [33987] = 8,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1354), 1,
      sym_lower_case_identifier,
    ACTIONS(1421), 1,
      anon_sym_RBRACE,
    STATE(633), 1,
      sym_block_comment,
    STATE(780), 1,
      sym_field_type,
    STATE(832), 1,
      sym__record_base,
    STATE(925), 1,
      sym_record_base_identifier,
  [34012] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1419), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(599), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(634), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [34035] = 7,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      aux_sym_string_constant_expr_token1,
    ACTIONS(1412), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(624), 1,
      aux_sym_string_constant_expr_repeat1,
    STATE(635), 1,
      sym_block_comment,
    ACTIONS(1326), 2,
      sym_string_escape,
      sym_invalid_string_escape,
  [34058] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_PIPE,
    ACTIONS(1425), 1,
      sym__virtual_end_decl,
    STATE(636), 1,
      sym_block_comment,
    STATE(644), 1,
      aux_sym_type_declaration_repeat2,
    STATE(839), 1,
      sym__more_union_variants,
  [34080] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1429), 1,
      aux_sym_string_constant_expr_token2,
    STATE(637), 1,
      sym_block_comment,
    ACTIONS(1427), 3,
      anon_sym_DQUOTE,
      sym_string_escape,
      sym_invalid_string_escape,
  [34098] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1431), 1,
      sym__virtual_end_section,
    STATE(638), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(1021), 1,
      sym__more_case_of_branches,
  [34120] = 5,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    ACTIONS(1435), 1,
      aux_sym_string_constant_expr_token1,
    STATE(639), 1,
      sym_block_comment,
    ACTIONS(1433), 3,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      sym_string_escape,
      sym_invalid_string_escape,
  [34138] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(640), 1,
      sym_block_comment,
    ACTIONS(1437), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [34154] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1439), 1,
      anon_sym_PIPE,
    ACTIONS(1442), 1,
      sym__virtual_end_decl,
    STATE(839), 1,
      sym__more_union_variants,
    STATE(641), 2,
      sym_block_comment,
      aux_sym_type_declaration_repeat2,
  [34174] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1444), 1,
      sym_lower_case_identifier,
    ACTIONS(1446), 1,
      sym_eq,
    STATE(642), 1,
      sym_block_comment,
    STATE(648), 1,
      aux_sym_type_declaration_repeat1,
    STATE(808), 1,
      sym_lower_type_name,
  [34196] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(643), 1,
      sym_block_comment,
    ACTIONS(1448), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [34212] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_PIPE,
    ACTIONS(1450), 1,
      sym__virtual_end_decl,
    STATE(641), 1,
      aux_sym_type_declaration_repeat2,
    STATE(644), 1,
      sym_block_comment,
    STATE(839), 1,
      sym__more_union_variants,
  [34234] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1452), 1,
      sym__virtual_end_section,
    STATE(645), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(941), 1,
      sym__more_case_of_branches,
  [34256] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1456), 1,
      sym__virtual_end_decl,
    ACTIONS(1454), 2,
      sym__virtual_end_section,
      anon_sym_RPAREN,
    STATE(646), 2,
      sym_block_comment,
      aux_sym__more_case_of_branches_repeat1,
  [34274] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1459), 1,
      sym__virtual_end_section,
    STATE(647), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(923), 1,
      sym__more_case_of_branches,
  [34296] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1444), 1,
      sym_lower_case_identifier,
    ACTIONS(1461), 1,
      sym_eq,
    STATE(648), 1,
      sym_block_comment,
    STATE(656), 1,
      aux_sym_type_declaration_repeat1,
    STATE(808), 1,
      sym_lower_type_name,
  [34318] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_PIPE,
    ACTIONS(1463), 1,
      sym__virtual_end_decl,
    STATE(649), 1,
      sym_block_comment,
    STATE(653), 1,
      aux_sym_type_declaration_repeat2,
    STATE(839), 1,
      sym__more_union_variants,
  [34340] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1444), 1,
      sym_lower_case_identifier,
    ACTIONS(1465), 1,
      sym_eq,
    STATE(650), 1,
      sym_block_comment,
    STATE(659), 1,
      aux_sym_type_declaration_repeat1,
    STATE(808), 1,
      sym_lower_type_name,
  [34362] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1467), 1,
      sym__virtual_end_section,
    STATE(651), 1,
      sym_block_comment,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(889), 1,
      sym__more_case_of_branches,
  [34384] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(652), 1,
      sym_block_comment,
    ACTIONS(1469), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      sym_arrow,
  [34400] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_PIPE,
    ACTIONS(1471), 1,
      sym__virtual_end_decl,
    STATE(641), 1,
      aux_sym_type_declaration_repeat2,
    STATE(653), 1,
      sym_block_comment,
    STATE(839), 1,
      sym__more_union_variants,
  [34422] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1473), 1,
      sym_arrow,
    ACTIONS(1414), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
    STATE(654), 2,
      sym_block_comment,
      aux_sym_type_expression_repeat1,
  [34440] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    STATE(646), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(655), 1,
      sym_block_comment,
    ACTIONS(1476), 2,
      sym__virtual_end_section,
      anon_sym_RPAREN,
  [34460] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1478), 1,
      sym_lower_case_identifier,
    ACTIONS(1481), 1,
      sym_eq,
    STATE(808), 1,
      sym_lower_type_name,
    STATE(656), 2,
      sym_block_comment,
      aux_sym_type_declaration_repeat1,
  [34480] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1483), 1,
      sym_arrow,
    STATE(654), 1,
      aux_sym_type_expression_repeat1,
    STATE(657), 1,
      sym_block_comment,
    ACTIONS(1370), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [34500] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1485), 1,
      sym__virtual_end_section,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(658), 1,
      sym_block_comment,
    STATE(939), 1,
      sym__more_case_of_branches,
  [34522] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1444), 1,
      sym_lower_case_identifier,
    ACTIONS(1487), 1,
      sym_eq,
    STATE(656), 1,
      aux_sym_type_declaration_repeat1,
    STATE(659), 1,
      sym_block_comment,
    STATE(808), 1,
      sym_lower_type_name,
  [34544] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    STATE(660), 1,
      sym_block_comment,
    STATE(860), 1,
      sym_exposed_union_constructors,
    ACTIONS(1491), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [34564] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1483), 1,
      sym_arrow,
    STATE(657), 1,
      aux_sym_type_expression_repeat1,
    STATE(661), 1,
      sym_block_comment,
    ACTIONS(1406), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [34584] = 7,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym__virtual_end_decl,
    ACTIONS(1493), 1,
      sym__virtual_end_section,
    STATE(655), 1,
      aux_sym__more_case_of_branches_repeat1,
    STATE(662), 1,
      sym_block_comment,
    STATE(912), 1,
      sym__more_case_of_branches,
  [34606] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1495), 1,
      anon_sym_else,
    STATE(259), 1,
      sym__else,
    STATE(663), 1,
      sym_block_comment,
    STATE(746), 1,
      aux_sym_if_else_expr_repeat1,
  [34625] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1499), 1,
      anon_sym_RBRACE,
    STATE(664), 1,
      sym_block_comment,
    STATE(772), 1,
      aux_sym_record_type_repeat1,
  [34644] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1501), 1,
      anon_sym_COMMA,
    ACTIONS(1503), 1,
      anon_sym_RBRACK,
    STATE(665), 1,
      sym_block_comment,
    STATE(688), 1,
      aux_sym_list_pattern_repeat1,
  [34663] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1406), 1,
      sym__virtual_end_decl,
    ACTIONS(1505), 1,
      sym_arrow,
    STATE(666), 1,
      sym_block_comment,
    STATE(703), 1,
      aux_sym_type_expression_repeat1,
  [34682] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1398), 1,
      sym_exposing,
    ACTIONS(1507), 1,
      sym__virtual_end_decl,
    STATE(667), 1,
      sym_block_comment,
    STATE(915), 1,
      sym_exposing_list,
  [34701] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(668), 1,
      sym_block_comment,
    ACTIONS(1509), 3,
      anon_sym_left,
      anon_sym_right,
      anon_sym_non,
  [34716] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1513), 1,
      sym__virtual_end_section,
    STATE(669), 1,
      sym_block_comment,
    STATE(709), 1,
      aux_sym_let_in_expr_repeat1,
  [34735] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(670), 1,
      sym_block_comment,
    ACTIONS(1437), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [34750] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1515), 1,
      sym__virtual_end_section,
    STATE(669), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(671), 1,
      sym_block_comment,
  [34769] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(672), 1,
      sym_block_comment,
    ACTIONS(1517), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [34784] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(673), 1,
      sym_block_comment,
    ACTIONS(1519), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [34799] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1521), 1,
      sym__virtual_end_section,
    STATE(674), 1,
      sym_block_comment,
    STATE(709), 1,
      aux_sym_let_in_expr_repeat1,
  [34818] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1523), 1,
      anon_sym_COMMA,
    ACTIONS(1525), 1,
      anon_sym_RBRACE,
    STATE(675), 1,
      sym_block_comment,
    STATE(716), 1,
      aux_sym_record_pattern_repeat1,
  [34837] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1527), 1,
      sym__virtual_end_section,
    STATE(674), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(676), 1,
      sym_block_comment,
  [34856] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(677), 1,
      sym_block_comment,
    ACTIONS(1529), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [34871] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1501), 1,
      anon_sym_COMMA,
    ACTIONS(1531), 1,
      anon_sym_RBRACK,
    STATE(665), 1,
      aux_sym_list_pattern_repeat1,
    STATE(678), 1,
      sym_block_comment,
  [34890] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1533), 1,
      sym__dot_without_leading_whitespace,
    STATE(151), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(214), 1,
      sym__field_access_segment,
    STATE(679), 1,
      sym_block_comment,
  [34909] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1535), 1,
      sym__virtual_end_section,
    STATE(680), 1,
      sym_block_comment,
    STATE(709), 1,
      aux_sym_let_in_expr_repeat1,
  [34928] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1537), 1,
      sym__virtual_end_section,
    STATE(680), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(681), 1,
      sym_block_comment,
  [34947] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(682), 1,
      sym_block_comment,
    ACTIONS(1539), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [34962] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1541), 1,
      anon_sym_COMMA,
    ACTIONS(1543), 1,
      anon_sym_RPAREN,
    STATE(683), 1,
      sym_block_comment,
    STATE(749), 1,
      aux_sym_tuple_pattern_repeat1,
  [34981] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1545), 1,
      sym__virtual_end_section,
    STATE(684), 1,
      sym_block_comment,
    STATE(709), 1,
      aux_sym_let_in_expr_repeat1,
  [35000] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1547), 1,
      sym__virtual_end_section,
    STATE(684), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(685), 1,
      sym_block_comment,
  [35019] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1549), 1,
      anon_sym_COMMA,
    ACTIONS(1552), 1,
      anon_sym_RBRACE,
    STATE(686), 2,
      sym_block_comment,
      aux_sym_record_pattern_repeat1,
  [35036] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(687), 1,
      sym_block_comment,
    ACTIONS(1554), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35051] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1556), 1,
      anon_sym_COMMA,
    ACTIONS(1559), 1,
      anon_sym_RBRACK,
    STATE(688), 2,
      sym_block_comment,
      aux_sym_list_pattern_repeat1,
  [35068] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(689), 1,
      sym_block_comment,
    ACTIONS(1469), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [35083] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(690), 1,
      sym_block_comment,
    ACTIONS(1448), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      sym_arrow,
  [35098] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_COMMA,
    ACTIONS(1563), 1,
      anon_sym_RPAREN,
    STATE(691), 1,
      sym_block_comment,
    STATE(750), 1,
      aux_sym_tuple_type_repeat1,
  [35117] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1565), 1,
      anon_sym_else,
    STATE(321), 1,
      sym__else,
    STATE(692), 1,
      sym_block_comment,
    STATE(799), 1,
      aux_sym_if_else_expr_repeat1,
  [35136] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1567), 1,
      sym__virtual_end_section,
    STATE(693), 1,
      sym_block_comment,
    STATE(709), 1,
      aux_sym_let_in_expr_repeat1,
  [35155] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1569), 1,
      sym__virtual_end_section,
    STATE(693), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(694), 1,
      sym_block_comment,
  [35174] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1573), 1,
      anon_sym_RPAREN,
    STATE(695), 1,
      sym_block_comment,
    STATE(793), 1,
      aux_sym_tuple_expr_repeat1,
  [35193] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1575), 1,
      anon_sym_RBRACE,
    STATE(696), 1,
      sym_block_comment,
    STATE(753), 1,
      aux_sym_record_type_repeat1,
  [35212] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(697), 1,
      sym_block_comment,
    ACTIONS(1577), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35227] = 4,
    ACTIONS(43), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(45), 1,
      sym_line_comment,
    STATE(698), 1,
      sym_block_comment,
    ACTIONS(1579), 3,
      aux_sym_char_constant_expr_token1,
      sym_string_escape,
      sym_invalid_string_escape,
  [35242] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1581), 1,
      anon_sym_RPAREN,
    STATE(699), 1,
      sym_block_comment,
    STATE(708), 1,
      aux_sym_tuple_expr_repeat1,
  [35261] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(700), 1,
      sym_block_comment,
    ACTIONS(1583), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
  [35276] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(701), 1,
      sym_block_comment,
    ACTIONS(1585), 3,
      sym__virtual_end_decl,
      sym__virtual_end_section,
      anon_sym_RPAREN,
  [35291] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1587), 1,
      anon_sym_RPAREN,
    STATE(702), 1,
      sym_block_comment,
    STATE(730), 1,
      aux_sym_tuple_expr_repeat1,
  [35310] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1370), 1,
      sym__virtual_end_decl,
    ACTIONS(1505), 1,
      sym_arrow,
    STATE(703), 1,
      sym_block_comment,
    STATE(757), 1,
      aux_sym_type_expression_repeat1,
  [35329] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      anon_sym_else,
    STATE(185), 1,
      sym__else,
    STATE(704), 1,
      sym_block_comment,
    STATE(756), 1,
      aux_sym_if_else_expr_repeat1,
  [35348] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1593), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(705), 1,
      sym_block_comment,
    STATE(719), 1,
      aux_sym_value_qid_repeat1,
  [35367] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      anon_sym_else,
    STATE(454), 1,
      sym__else,
    STATE(706), 1,
      sym_block_comment,
    STATE(785), 1,
      aux_sym_if_else_expr_repeat1,
  [35386] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1597), 1,
      anon_sym_RBRACK,
    STATE(707), 1,
      sym_block_comment,
    STATE(735), 1,
      aux_sym_list_expr_repeat1,
  [35405] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1599), 1,
      anon_sym_RPAREN,
    STATE(708), 1,
      sym_block_comment,
    STATE(754), 1,
      aux_sym_tuple_expr_repeat1,
  [35424] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1601), 1,
      sym__virtual_end_decl,
    ACTIONS(1604), 1,
      sym__virtual_end_section,
    STATE(709), 2,
      sym_block_comment,
      aux_sym_let_in_expr_repeat1,
  [35441] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1606), 1,
      anon_sym_else,
    STATE(185), 1,
      sym__else,
    STATE(710), 1,
      sym_block_comment,
    STATE(756), 1,
      aux_sym_if_else_expr_repeat1,
  [35460] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1608), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1610), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(705), 1,
      aux_sym_value_qid_repeat1,
    STATE(711), 1,
      sym_block_comment,
  [35479] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1612), 1,
      anon_sym_RBRACK,
    STATE(707), 1,
      aux_sym_list_expr_repeat1,
    STATE(712), 1,
      sym_block_comment,
  [35498] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1614), 1,
      anon_sym_COMMA,
    ACTIONS(1617), 1,
      anon_sym_RPAREN,
    STATE(713), 2,
      sym_block_comment,
      aux_sym_exposing_list_repeat1,
  [35515] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1581), 1,
      anon_sym_RPAREN,
    STATE(714), 1,
      sym_block_comment,
    STATE(730), 1,
      aux_sym_tuple_expr_repeat1,
  [35534] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1619), 1,
      sym__dot_without_leading_whitespace,
    STATE(336), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(348), 1,
      sym__field_access_segment,
    STATE(715), 1,
      sym_block_comment,
  [35553] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1523), 1,
      anon_sym_COMMA,
    ACTIONS(1621), 1,
      anon_sym_RBRACE,
    STATE(686), 1,
      aux_sym_record_pattern_repeat1,
    STATE(716), 1,
      sym_block_comment,
  [35572] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1573), 1,
      anon_sym_RPAREN,
    STATE(717), 1,
      sym_block_comment,
    STATE(773), 1,
      aux_sym_tuple_expr_repeat1,
  [35591] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1623), 1,
      anon_sym_COMMA,
    ACTIONS(1625), 1,
      anon_sym_RBRACE,
    STATE(718), 1,
      sym_block_comment,
    STATE(775), 1,
      aux_sym__record_inner_repeat1,
  [35610] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1627), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1630), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(719), 2,
      sym_block_comment,
      aux_sym_value_qid_repeat1,
  [35627] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1632), 1,
      anon_sym_RBRACK,
    STATE(720), 1,
      sym_block_comment,
    STATE(776), 1,
      aux_sym_list_expr_repeat1,
  [35646] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      anon_sym_else,
    STATE(405), 1,
      sym__else,
    STATE(721), 1,
      sym_block_comment,
    STATE(777), 1,
      aux_sym_if_else_expr_repeat1,
  [35665] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1634), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1636), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(722), 1,
      sym_block_comment,
    STATE(783), 1,
      aux_sym_value_qid_repeat1,
  [35684] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1638), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(719), 1,
      aux_sym_value_qid_repeat1,
    STATE(723), 1,
      sym_block_comment,
  [35703] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1640), 1,
      sym__dot_without_leading_whitespace,
    STATE(363), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(439), 1,
      sym__field_access_segment,
    STATE(724), 1,
      sym_block_comment,
  [35722] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1642), 1,
      sym__virtual_end_section,
    STATE(709), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(725), 1,
      sym_block_comment,
  [35741] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_COMMA,
    ACTIONS(1644), 1,
      anon_sym_RPAREN,
    STATE(726), 1,
      sym_block_comment,
    STATE(738), 1,
      aux_sym_tuple_type_repeat1,
  [35760] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1646), 1,
      anon_sym_RBRACE,
    STATE(727), 1,
      sym_block_comment,
    STATE(739), 1,
      aux_sym_record_type_repeat1,
  [35779] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1648), 1,
      anon_sym_RPAREN,
    STATE(728), 1,
      sym_block_comment,
    STATE(773), 1,
      aux_sym_tuple_expr_repeat1,
  [35798] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1650), 1,
      anon_sym_RBRACK,
    STATE(729), 1,
      sym_block_comment,
    STATE(735), 1,
      aux_sym_list_expr_repeat1,
  [35817] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1652), 1,
      anon_sym_RPAREN,
    STATE(730), 1,
      sym_block_comment,
    STATE(754), 1,
      aux_sym_tuple_expr_repeat1,
  [35836] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1654), 1,
      anon_sym_RBRACK,
    STATE(731), 1,
      sym_block_comment,
    STATE(742), 1,
      aux_sym_list_expr_repeat1,
  [35855] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1656), 1,
      anon_sym_else,
    STATE(405), 1,
      sym__else,
    STATE(732), 1,
      sym_block_comment,
    STATE(777), 1,
      aux_sym_if_else_expr_repeat1,
  [35874] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1658), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1660), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(733), 1,
      sym_block_comment,
    STATE(743), 1,
      aux_sym_value_qid_repeat1,
  [35893] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1662), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1664), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(723), 1,
      aux_sym_value_qid_repeat1,
    STATE(734), 1,
      sym_block_comment,
  [35912] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1666), 1,
      anon_sym_COMMA,
    ACTIONS(1669), 1,
      anon_sym_RBRACK,
    STATE(735), 2,
      sym_block_comment,
      aux_sym_list_expr_repeat1,
  [35929] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1671), 1,
      anon_sym_RBRACK,
    STATE(729), 1,
      aux_sym_list_expr_repeat1,
    STATE(736), 1,
      sym_block_comment,
  [35948] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1565), 1,
      anon_sym_else,
    STATE(312), 1,
      sym__else,
    STATE(692), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(737), 1,
      sym_block_comment,
  [35967] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_COMMA,
    ACTIONS(1673), 1,
      anon_sym_RPAREN,
    STATE(738), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_tuple_type_repeat1,
  [35986] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1675), 1,
      anon_sym_RBRACE,
    STATE(739), 1,
      sym_block_comment,
    STATE(772), 1,
      aux_sym_record_type_repeat1,
  [36005] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1677), 1,
      anon_sym_RBRACE,
    STATE(740), 1,
      sym_block_comment,
    STATE(747), 1,
      aux_sym_record_type_repeat1,
  [36024] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1679), 1,
      anon_sym_RPAREN,
    STATE(741), 1,
      sym_block_comment,
    STATE(754), 1,
      aux_sym_tuple_expr_repeat1,
  [36043] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1681), 1,
      anon_sym_RBRACK,
    STATE(735), 1,
      aux_sym_list_expr_repeat1,
    STATE(742), 1,
      sym_block_comment,
  [36062] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1683), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(719), 1,
      aux_sym_value_qid_repeat1,
    STATE(743), 1,
      sym_block_comment,
  [36081] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1685), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_block_comment,
    STATE(764), 1,
      aux_sym_tuple_expr_repeat1,
  [36100] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1687), 1,
      anon_sym_COMMA,
    ACTIONS(1690), 1,
      anon_sym_RBRACE,
    STATE(745), 2,
      sym_block_comment,
      aux_sym__record_inner_repeat1,
  [36117] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1495), 1,
      anon_sym_else,
    STATE(230), 1,
      sym__else,
    STATE(746), 1,
      sym_block_comment,
    STATE(799), 1,
      aux_sym_if_else_expr_repeat1,
  [36136] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1692), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      sym_block_comment,
    STATE(772), 1,
      aux_sym_record_type_repeat1,
  [36155] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1694), 1,
      sym__dot_without_leading_whitespace,
    STATE(115), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(145), 1,
      sym__field_access_segment,
    STATE(748), 1,
      sym_block_comment,
  [36174] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1541), 1,
      anon_sym_COMMA,
    ACTIONS(1696), 1,
      anon_sym_RPAREN,
    STATE(749), 1,
      sym_block_comment,
    STATE(789), 1,
      aux_sym_tuple_pattern_repeat1,
  [36193] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_COMMA,
    ACTIONS(1698), 1,
      anon_sym_RPAREN,
    STATE(750), 1,
      sym_block_comment,
    STATE(787), 1,
      aux_sym_tuple_type_repeat1,
  [36212] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1623), 1,
      anon_sym_COMMA,
    ACTIONS(1700), 1,
      anon_sym_RBRACE,
    STATE(745), 1,
      aux_sym__record_inner_repeat1,
    STATE(751), 1,
      sym_block_comment,
  [36231] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      anon_sym_else,
    STATE(312), 1,
      sym__else,
    STATE(692), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(752), 1,
      sym_block_comment,
  [36250] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1702), 1,
      anon_sym_RBRACE,
    STATE(753), 1,
      sym_block_comment,
    STATE(772), 1,
      aux_sym_record_type_repeat1,
  [36269] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1704), 1,
      anon_sym_COMMA,
    ACTIONS(1707), 1,
      anon_sym_RPAREN,
    STATE(754), 2,
      sym_block_comment,
      aux_sym_tuple_expr_repeat1,
  [36286] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1709), 1,
      anon_sym_RBRACE,
    STATE(755), 1,
      sym_block_comment,
    STATE(770), 1,
      aux_sym_record_type_repeat1,
  [36305] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1606), 1,
      anon_sym_else,
    STATE(175), 1,
      sym__else,
    STATE(756), 1,
      sym_block_comment,
    STATE(799), 1,
      aux_sym_if_else_expr_repeat1,
  [36324] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1414), 1,
      sym__virtual_end_decl,
    ACTIONS(1711), 1,
      sym_arrow,
    STATE(757), 2,
      sym_block_comment,
      aux_sym_type_expression_repeat1,
  [36341] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1714), 1,
      anon_sym_COMMA,
    ACTIONS(1716), 1,
      anon_sym_RPAREN,
    STATE(758), 1,
      sym_block_comment,
    STATE(762), 1,
      aux_sym_exposing_list_repeat1,
  [36360] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      anon_sym_else,
    STATE(61), 1,
      sym__else,
    STATE(759), 1,
      sym_block_comment,
    STATE(763), 1,
      aux_sym_if_else_expr_repeat1,
  [36379] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1718), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(719), 1,
      aux_sym_value_qid_repeat1,
    STATE(760), 1,
      sym_block_comment,
  [36398] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1720), 1,
      anon_sym_RBRACK,
    STATE(735), 1,
      aux_sym_list_expr_repeat1,
    STATE(761), 1,
      sym_block_comment,
  [36417] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1714), 1,
      anon_sym_COMMA,
    ACTIONS(1722), 1,
      anon_sym_RPAREN,
    STATE(713), 1,
      aux_sym_exposing_list_repeat1,
    STATE(762), 1,
      sym_block_comment,
  [36436] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1724), 1,
      anon_sym_else,
    STATE(68), 1,
      sym__else,
    STATE(763), 1,
      sym_block_comment,
    STATE(799), 1,
      aux_sym_if_else_expr_repeat1,
  [36455] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1726), 1,
      anon_sym_RPAREN,
    STATE(754), 1,
      aux_sym_tuple_expr_repeat1,
    STATE(764), 1,
      sym_block_comment,
  [36474] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1724), 1,
      anon_sym_else,
    STATE(61), 1,
      sym__else,
    STATE(763), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(765), 1,
      sym_block_comment,
  [36493] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1728), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1730), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(760), 1,
      aux_sym_value_qid_repeat1,
    STATE(766), 1,
      sym_block_comment,
  [36512] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1732), 1,
      anon_sym_else,
    STATE(454), 1,
      sym__else,
    STATE(767), 1,
      sym_block_comment,
    STATE(785), 1,
      aux_sym_if_else_expr_repeat1,
  [36531] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1734), 1,
      anon_sym_RBRACK,
    STATE(761), 1,
      aux_sym_list_expr_repeat1,
    STATE(768), 1,
      sym_block_comment,
  [36550] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1736), 1,
      anon_sym_RPAREN,
    STATE(741), 1,
      aux_sym_tuple_expr_repeat1,
    STATE(769), 1,
      sym_block_comment,
  [36569] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1738), 1,
      anon_sym_RBRACE,
    STATE(770), 1,
      sym_block_comment,
    STATE(772), 1,
      aux_sym_record_type_repeat1,
  [36588] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1740), 1,
      sym__dot_without_leading_whitespace,
    STATE(273), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(284), 1,
      sym__field_access_segment,
    STATE(771), 1,
      sym_block_comment,
  [36607] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1742), 1,
      anon_sym_COMMA,
    ACTIONS(1745), 1,
      anon_sym_RBRACE,
    STATE(772), 2,
      sym_block_comment,
      aux_sym_record_type_repeat1,
  [36624] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1747), 1,
      anon_sym_RPAREN,
    STATE(754), 1,
      aux_sym_tuple_expr_repeat1,
    STATE(773), 1,
      sym_block_comment,
  [36643] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1623), 1,
      anon_sym_COMMA,
    ACTIONS(1749), 1,
      anon_sym_RBRACE,
    STATE(751), 1,
      aux_sym__record_inner_repeat1,
    STATE(774), 1,
      sym_block_comment,
  [36662] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1623), 1,
      anon_sym_COMMA,
    ACTIONS(1751), 1,
      anon_sym_RBRACE,
    STATE(745), 1,
      aux_sym__record_inner_repeat1,
    STATE(775), 1,
      sym_block_comment,
  [36681] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1753), 1,
      anon_sym_RBRACK,
    STATE(735), 1,
      aux_sym_list_expr_repeat1,
    STATE(776), 1,
      sym_block_comment,
  [36700] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1656), 1,
      anon_sym_else,
    STATE(413), 1,
      sym__else,
    STATE(777), 1,
      sym_block_comment,
    STATE(799), 1,
      aux_sym_if_else_expr_repeat1,
  [36719] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1755), 1,
      sym__dot_without_leading_whitespace,
    STATE(20), 1,
      aux_sym_field_access_expr_repeat1,
    STATE(34), 1,
      sym__field_access_segment,
    STATE(778), 1,
      sym_block_comment,
  [36738] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_COMMA,
    ACTIONS(1757), 1,
      anon_sym_RPAREN,
    STATE(779), 1,
      sym_block_comment,
    STATE(790), 1,
      aux_sym_tuple_type_repeat1,
  [36757] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1759), 1,
      anon_sym_RBRACE,
    STATE(780), 1,
      sym_block_comment,
    STATE(791), 1,
      aux_sym_record_type_repeat1,
  [36776] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1685), 1,
      anon_sym_RPAREN,
    STATE(741), 1,
      aux_sym_tuple_expr_repeat1,
    STATE(781), 1,
      sym_block_comment,
  [36795] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      sym__virtual_end_decl,
    ACTIONS(1761), 1,
      sym__virtual_end_section,
    STATE(725), 1,
      aux_sym_let_in_expr_repeat1,
    STATE(782), 1,
      sym_block_comment,
  [36814] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1763), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(719), 1,
      aux_sym_value_qid_repeat1,
    STATE(783), 1,
      sym_block_comment,
  [36833] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1765), 1,
      anon_sym_RBRACK,
    STATE(784), 1,
      sym_block_comment,
    STATE(794), 1,
      aux_sym_list_expr_repeat1,
  [36852] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1732), 1,
      anon_sym_else,
    STATE(461), 1,
      sym__else,
    STATE(785), 1,
      sym_block_comment,
    STATE(799), 1,
      aux_sym_if_else_expr_repeat1,
  [36871] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1767), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1769), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(786), 1,
      sym_block_comment,
    STATE(795), 1,
      aux_sym_value_qid_repeat1,
  [36890] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1771), 1,
      anon_sym_COMMA,
    ACTIONS(1774), 1,
      anon_sym_RPAREN,
    STATE(787), 2,
      sym_block_comment,
      aux_sym_tuple_type_repeat1,
  [36907] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      anon_sym_else,
    STATE(259), 1,
      sym__else,
    STATE(746), 1,
      aux_sym_if_else_expr_repeat1,
    STATE(788), 1,
      sym_block_comment,
  [36926] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1776), 1,
      anon_sym_COMMA,
    ACTIONS(1779), 1,
      anon_sym_RPAREN,
    STATE(789), 2,
      sym_block_comment,
      aux_sym_tuple_pattern_repeat1,
  [36943] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      anon_sym_COMMA,
    ACTIONS(1781), 1,
      anon_sym_RPAREN,
    STATE(787), 1,
      aux_sym_tuple_type_repeat1,
    STATE(790), 1,
      sym_block_comment,
  [36962] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1783), 1,
      anon_sym_RBRACE,
    STATE(772), 1,
      aux_sym_record_type_repeat1,
    STATE(791), 1,
      sym_block_comment,
  [36981] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      anon_sym_COMMA,
    ACTIONS(1785), 1,
      anon_sym_RBRACE,
    STATE(664), 1,
      aux_sym_record_type_repeat1,
    STATE(792), 1,
      sym_block_comment,
  [37000] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      anon_sym_COMMA,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
    STATE(754), 1,
      aux_sym_tuple_expr_repeat1,
    STATE(793), 1,
      sym_block_comment,
  [37019] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1789), 1,
      anon_sym_RBRACK,
    STATE(735), 1,
      aux_sym_list_expr_repeat1,
    STATE(794), 1,
      sym_block_comment,
  [37038] = 6,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      sym__upper_case_identifier_without_leading_whitespace,
    ACTIONS(1791), 1,
      sym__lower_case_identifier_without_leading_whitespace,
    STATE(719), 1,
      aux_sym_value_qid_repeat1,
    STATE(795), 1,
      sym_block_comment,
  [37057] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1398), 1,
      sym_exposing,
    STATE(796), 1,
      sym_block_comment,
    STATE(963), 1,
      sym_exposing_list,
  [37073] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1793), 1,
      anon_sym_PIPE,
    ACTIONS(1795), 1,
      sym_eq,
    STATE(797), 1,
      sym_block_comment,
  [37089] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1797), 1,
      anon_sym_COMMA,
    ACTIONS(1799), 1,
      anon_sym_RPAREN,
    STATE(798), 1,
      sym_block_comment,
  [37105] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1801), 1,
      anon_sym_else,
    STATE(799), 2,
      sym_block_comment,
      aux_sym_if_else_expr_repeat1,
  [37119] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(800), 1,
      sym_block_comment,
    ACTIONS(1804), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [37133] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(801), 1,
      sym_block_comment,
    ACTIONS(1806), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [37147] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(802), 1,
      sym_block_comment,
    ACTIONS(1437), 2,
      sym__virtual_end_decl,
      sym_arrow,
  [37161] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(803), 1,
      sym_block_comment,
    ACTIONS(1448), 2,
      sym__virtual_end_decl,
      sym_arrow,
  [37175] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1808), 1,
      anon_sym_RPAREN,
    ACTIONS(1810), 1,
      sym__virtual_end_section,
    STATE(804), 1,
      sym_block_comment,
  [37191] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(805), 1,
      sym_block_comment,
    ACTIONS(1812), 2,
      sym_lower_case_identifier,
      sym_eq,
  [37205] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(806), 1,
      sym_block_comment,
    STATE(830), 1,
      sym_lower_pattern,
  [37221] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1814), 1,
      sym_upper_case_identifier,
    STATE(649), 1,
      sym_union_variant,
    STATE(807), 1,
      sym_block_comment,
  [37237] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(808), 1,
      sym_block_comment,
    ACTIONS(1816), 2,
      sym_lower_case_identifier,
      sym_eq,
  [37251] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1398), 1,
      sym_exposing,
    STATE(809), 1,
      sym_block_comment,
    STATE(909), 1,
      sym_exposing_list,
  [37267] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1274), 1,
      anon_sym_LPAREN,
    STATE(810), 1,
      sym_block_comment,
    STATE(919), 1,
      sym__operator_as_function_inner,
  [37283] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(811), 1,
      sym_block_comment,
    ACTIONS(1818), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [37297] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(812), 1,
      sym_block_comment,
    ACTIONS(1820), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [37311] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(704), 1,
      sym__then,
    STATE(813), 1,
      sym_block_comment,
  [37327] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    STATE(814), 1,
      sym_block_comment,
    STATE(826), 1,
      sym_upper_case_qid,
  [37343] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(710), 1,
      sym__then,
    STATE(815), 1,
      sym_block_comment,
  [37359] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1824), 1,
      sym_lower_case_identifier,
    STATE(816), 1,
      sym_block_comment,
    STATE(864), 1,
      sym_field,
  [37375] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(817), 1,
      sym_block_comment,
    ACTIONS(1826), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [37389] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1797), 1,
      anon_sym_COMMA,
    ACTIONS(1828), 1,
      anon_sym_RPAREN,
    STATE(818), 1,
      sym_block_comment,
  [37405] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(721), 1,
      sym__then,
    STATE(819), 1,
      sym_block_comment,
  [37421] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1830), 1,
      sym_lower_case_identifier,
    ACTIONS(1832), 1,
      sym_module,
    STATE(820), 1,
      sym_block_comment,
  [37437] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(732), 1,
      sym__then,
    STATE(821), 1,
      sym_block_comment,
  [37453] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(759), 1,
      sym__then,
    STATE(822), 1,
      sym_block_comment,
  [37469] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(767), 1,
      sym__then,
    STATE(823), 1,
      sym_block_comment,
  [37485] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(824), 1,
      sym_block_comment,
    ACTIONS(1834), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [37499] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(825), 1,
      sym_block_comment,
    ACTIONS(1836), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [37513] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1398), 1,
      sym_exposing,
    STATE(826), 1,
      sym_block_comment,
    STATE(1015), 1,
      sym_exposing_list,
  [37529] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(765), 1,
      sym__then,
    STATE(827), 1,
      sym_block_comment,
  [37545] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    STATE(828), 1,
      sym_block_comment,
    STATE(1014), 1,
      sym_upper_case_qid,
  [37561] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(788), 1,
      sym__then,
    STATE(829), 1,
      sym_block_comment,
  [37577] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(830), 1,
      sym_block_comment,
    ACTIONS(1838), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [37591] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      sym_upper_case_identifier,
    STATE(809), 1,
      sym_upper_case_qid,
    STATE(831), 1,
      sym_block_comment,
  [37607] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1840), 1,
      sym_lower_case_identifier,
    STATE(792), 1,
      sym_field_type,
    STATE(832), 1,
      sym_block_comment,
  [37623] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(663), 1,
      sym__then,
    STATE(833), 1,
      sym_block_comment,
  [37639] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1228), 1,
      sym_upper_case_identifier,
    STATE(622), 1,
      sym_upper_case_qid,
    STATE(834), 1,
      sym_block_comment,
  [37655] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(835), 1,
      sym_block_comment,
    ACTIONS(1842), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [37669] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(836), 1,
      sym_block_comment,
    ACTIONS(1844), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
  [37683] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(675), 1,
      sym_lower_pattern,
    STATE(837), 1,
      sym_block_comment,
  [37699] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1822), 1,
      anon_sym_then,
    STATE(752), 1,
      sym__then,
    STATE(838), 1,
      sym_block_comment,
  [37715] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(839), 1,
      sym_block_comment,
    ACTIONS(1846), 2,
      sym__virtual_end_decl,
      anon_sym_PIPE,
  [37729] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(922), 1,
      sym_lower_case_identifier,
    STATE(520), 1,
      sym_lower_pattern,
    STATE(840), 1,
      sym_block_comment,
  [37745] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(1814), 1,
      sym_upper_case_identifier,
    STATE(836), 1,
      sym_union_variant,
    STATE(841), 1,
      sym_block_comment,
  [37761] = 4,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(842), 1,
      sym_block_comment,
    ACTIONS(1848), 2,
      sym__virtual_end_decl,
      sym__virtual_end_section,
  [37775] = 5,
    ACTIONS(3), 1,
      anon_sym_LBRACE_DASH,
    ACTIONS(5), 