#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 662
#define LARGE_STATE_COUNT 48
#define SYMBOL_COUNT 214
#define ALIAS_COUNT 0
#define TOKEN_COUNT 85
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 40
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 86

enum {
  anon_sym_contract = 1,
  anon_sym_extends = 2,
  anon_sym_implements = 3,
  anon_sym_LBRACE = 4,
  anon_sym_RBRACE = 5,
  anon_sym_SLASH_SLASH_SLASH = 6,
  aux_sym_cwspec_line_token1 = 7,
  anon_sym_SLASH_STAR_STAR = 8,
  aux_sym_cwspec_block_token1 = 9,
  anon_sym_SLASH = 10,
  anon_sym_interface = 11,
  anon_sym_import = 12,
  anon_sym_STAR = 13,
  anon_sym_from = 14,
  anon_sym_LPAREN = 15,
  anon_sym_COMMA = 16,
  anon_sym_RPAREN = 17,
  anon_sym_as = 18,
  anon_sym_error = 19,
  anon_sym_event = 20,
  anon_sym_state = 21,
  anon_sym_exec = 22,
  anon_sym_query = 23,
  anon_sym_COLON = 24,
  anon_sym_LBRACK = 25,
  anon_sym_RBRACK = 26,
  anon_sym_DASH_GT = 27,
  anon_sym_instantiate = 28,
  anon_sym_migrate = 29,
  anon_sym_QMARK = 30,
  anon_sym_DOT = 31,
  anon_sym_DASH = 32,
  anon_sym_BANG = 33,
  anon_sym_PERCENT = 34,
  anon_sym_PLUS = 35,
  anon_sym_LT = 36,
  anon_sym_GT = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_GT_EQ = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_BANG_EQ = 41,
  anon_sym_and = 42,
  anon_sym_or = 43,
  sym_unit_val = 44,
  sym_string_val = 45,
  sym_integer_val = 46,
  sym_decimal_val = 47,
  anon_sym_true = 48,
  anon_sym_false = 49,
  sym_none_val = 50,
  anon_sym_let = 51,
  anon_sym_EQ = 52,
  anon_sym_if = 53,
  anon_sym_else = 54,
  anon_sym_for = 55,
  anon_sym_in = 56,
  anon_sym_emit = 57,
  anon_sym_return = 58,
  anon_sym_fail = 59,
  sym_type_name = 60,
  sym_ident = 61,
  anon_sym_bool = 62,
  anon_sym_i8 = 63,
  anon_sym_i16 = 64,
  anon_sym_i32 = 65,
  anon_sym_i64 = 66,
  anon_sym_i128 = 67,
  anon_sym_u8 = 68,
  anon_sym_u16 = 69,
  anon_sym_u32 = 70,
  anon_sym_u64 = 71,
  anon_sym_u128 = 72,
  anon_sym_byte = 73,
  anon_sym_PLUS_EQ = 74,
  anon_sym_DASH_EQ = 75,
  anon_sym_STAR_EQ = 76,
  anon_sym_SLASH_EQ = 77,
  anon_sym_PERCENT_EQ = 78,
  anon_sym_LBRACK_RBRACK = 79,
  anon_sym_struct = 80,
  anon_sym_enum = 81,
  anon_sym_type = 82,
  sym_infer_type = 83,
  anon_sym_COLON_COLON = 84,
  sym_cwscript_src = 85,
  sym__cws_item = 86,
  sym_contract_defn = 87,
  sym_contract_body = 88,
  sym_interface_body = 89,
  sym_cwspec = 90,
  sym_cwspec_line = 91,
  sym_cwspec_block = 92,
  sym_interface_defn = 93,
  sym__import_stmt = 94,
  sym_import_all = 95,
  sym_import_items = 96,
  sym_import_list = 97,
  sym_import_item = 98,
  sym_error_block = 99,
  sym_event_block = 100,
  sym_state_block = 101,
  sym_exec_block = 102,
  sym_query_block = 103,
  sym_contract_item = 104,
  sym_interface_item = 105,
  sym_error_block_item = 106,
  sym_event_block_item = 107,
  sym_exec_block_item = 108,
  sym_query_block_item = 109,
  sym_error_defn = 110,
  sym_event_defn = 111,
  sym_state_defn = 112,
  sym_state_block_item = 113,
  sym__state_defn = 114,
  sym_state_item = 115,
  sym_state_map = 116,
  sym_map_key = 117,
  sym__named_fn_defn = 118,
  sym__fn_defn = 119,
  sym__named_fn_decl = 120,
  sym__fn_decl = 121,
  sym_instantiate_defn = 122,
  sym_instantiate_decl = 123,
  sym_exec_defn = 124,
  sym_exec_decl = 125,
  sym_query_defn = 126,
  sym_query_decl = 127,
  sym_migrate_defn = 128,
  sym_migrate_decl = 129,
  sym_fn_args = 130,
  sym_fn_arg = 131,
  sym_fn_body = 132,
  sym__stmt = 133,
  sym_expr = 134,
  sym_grouped_expr = 135,
  sym_member_access_expr = 136,
  sym_table_lookup_expr = 137,
  sym_unary_neg_expr = 138,
  sym_unary_not_expr = 139,
  sym_mult_div_mod_expr = 140,
  sym_add_sub_expr = 141,
  sym_comparison_expr = 142,
  sym_equality_expr = 143,
  sym_and_expr = 144,
  sym_or_expr = 145,
  sym_query_expr = 146,
  sym__fn_call_expr = 147,
  sym_pos_args_fn_call_expr = 148,
  sym_pos_args = 149,
  sym_named_args_fn_call_expr = 150,
  sym_named_args = 151,
  sym_named_arg = 152,
  sym__val = 153,
  sym_struct_val = 154,
  sym_struct_val_member = 155,
  sym_tuple_struct_val = 156,
  sym_vec_val = 157,
  sym__bool_val = 158,
  sym__bindings = 159,
  sym_ident_binding = 160,
  sym_struct_unpack_binding = 161,
  sym_let_stmt = 162,
  sym_assign_stmt = 163,
  sym_if_stmt = 164,
  sym_if_clause = 165,
  sym_else_if_clause = 166,
  sym_else_clause = 167,
  sym_for_stmt = 168,
  sym__directive_stmt = 169,
  sym_exec_stmt = 170,
  sym_emit_stmt = 171,
  sym_return_stmt = 172,
  sym_fail_stmt = 173,
  sym__enum_variant = 174,
  sym__enum_variant_struct = 175,
  sym__enum_variant_tuple = 176,
  sym_builtin_type = 177,
  sym_assign_op = 178,
  sym_ident_list = 179,
  sym_struct_member = 180,
  sym_tuple_type = 181,
  sym_short_option_type = 182,
  sym_short_vec_type = 183,
  sym__type_defn = 184,
  sym_struct_defn = 185,
  sym_enum_defn = 186,
  sym_enum_body = 187,
  sym_type_alias_defn = 188,
  sym_type_expr = 189,
  sym_type_path = 190,
  aux_sym_cwscript_src_repeat1 = 191,
  aux_sym_contract_body_repeat1 = 192,
  aux_sym_interface_body_repeat1 = 193,
  aux_sym_cwspec_line_repeat1 = 194,
  aux_sym_cwspec_block_repeat1 = 195,
  aux_sym_import_list_repeat1 = 196,
  aux_sym_error_block_repeat1 = 197,
  aux_sym_event_block_repeat1 = 198,
  aux_sym_state_block_repeat1 = 199,
  aux_sym_exec_block_repeat1 = 200,
  aux_sym_query_block_repeat1 = 201,
  aux_sym_state_map_repeat1 = 202,
  aux_sym_fn_args_repeat1 = 203,
  aux_sym_fn_body_repeat1 = 204,
  aux_sym_pos_args_repeat1 = 205,
  aux_sym_named_args_repeat1 = 206,
  aux_sym_struct_val_repeat1 = 207,
  aux_sym_if_stmt_repeat1 = 208,
  aux_sym__enum_variant_struct_repeat1 = 209,
  aux_sym__enum_variant_tuple_repeat1 = 210,
  aux_sym_ident_list_repeat1 = 211,
  aux_sym_enum_body_repeat1 = 212,
  aux_sym_type_path_repeat1 = 213,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_contract] = "contract",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SLASH_SLASH_SLASH] = "///",
  [aux_sym_cwspec_line_token1] = "cwspec_line_token1",
  [anon_sym_SLASH_STAR_STAR] = "/**",
  [aux_sym_cwspec_block_token1] = "cwspec_block_token1",
  [anon_sym_SLASH] = "/",
  [anon_sym_interface] = "interface",
  [anon_sym_import] = "import",
  [anon_sym_STAR] = "*",
  [anon_sym_from] = "from",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_as] = "as",
  [anon_sym_error] = "error",
  [anon_sym_event] = "event",
  [anon_sym_state] = "state",
  [anon_sym_exec] = "exec",
  [anon_sym_query] = "query",
  [anon_sym_COLON] = ":",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_instantiate] = "instantiate",
  [anon_sym_migrate] = "migrate",
  [anon_sym_QMARK] = "\?",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS] = "+",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [sym_unit_val] = "unit_val",
  [sym_string_val] = "string_val",
  [sym_integer_val] = "integer_val",
  [sym_decimal_val] = "decimal_val",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_none_val] = "none_val",
  [anon_sym_let] = "let",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_emit] = "emit",
  [anon_sym_return] = "return",
  [anon_sym_fail] = "fail",
  [sym_type_name] = "type_name",
  [sym_ident] = "ident",
  [anon_sym_bool] = "bool",
  [anon_sym_i8] = "i8",
  [anon_sym_i16] = "i16",
  [anon_sym_i32] = "i32",
  [anon_sym_i64] = "i64",
  [anon_sym_i128] = "i128",
  [anon_sym_u8] = "u8",
  [anon_sym_u16] = "u16",
  [anon_sym_u32] = "u32",
  [anon_sym_u64] = "u64",
  [anon_sym_u128] = "u128",
  [anon_sym_byte] = "byte",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_type] = "type",
  [sym_infer_type] = "infer_type",
  [anon_sym_COLON_COLON] = "::",
  [sym_cwscript_src] = "cwscript_src",
  [sym__cws_item] = "_cws_item",
  [sym_contract_defn] = "contract_defn",
  [sym_contract_body] = "contract_body",
  [sym_interface_body] = "interface_body",
  [sym_cwspec] = "cwspec",
  [sym_cwspec_line] = "cwspec_line",
  [sym_cwspec_block] = "cwspec_block",
  [sym_interface_defn] = "interface_defn",
  [sym__import_stmt] = "_import_stmt",
  [sym_import_all] = "import_all",
  [sym_import_items] = "import_items",
  [sym_import_list] = "import_list",
  [sym_import_item] = "import_item",
  [sym_error_block] = "error_block",
  [sym_event_block] = "event_block",
  [sym_state_block] = "state_block",
  [sym_exec_block] = "exec_block",
  [sym_query_block] = "query_block",
  [sym_contract_item] = "contract_item",
  [sym_interface_item] = "interface_item",
  [sym_error_block_item] = "error_block_item",
  [sym_event_block_item] = "event_block_item",
  [sym_exec_block_item] = "exec_block_item",
  [sym_query_block_item] = "query_block_item",
  [sym_error_defn] = "error_defn",
  [sym_event_defn] = "event_defn",
  [sym_state_defn] = "state_defn",
  [sym_state_block_item] = "state_block_item",
  [sym__state_defn] = "_state_defn",
  [sym_state_item] = "state_item",
  [sym_state_map] = "state_map",
  [sym_map_key] = "map_key",
  [sym__named_fn_defn] = "_named_fn_defn",
  [sym__fn_defn] = "_fn_defn",
  [sym__named_fn_decl] = "_named_fn_decl",
  [sym__fn_decl] = "_fn_decl",
  [sym_instantiate_defn] = "instantiate_defn",
  [sym_instantiate_decl] = "instantiate_decl",
  [sym_exec_defn] = "exec_defn",
  [sym_exec_decl] = "exec_decl",
  [sym_query_defn] = "query_defn",
  [sym_query_decl] = "query_decl",
  [sym_migrate_defn] = "migrate_defn",
  [sym_migrate_decl] = "migrate_decl",
  [sym_fn_args] = "fn_args",
  [sym_fn_arg] = "fn_arg",
  [sym_fn_body] = "fn_body",
  [sym__stmt] = "_stmt",
  [sym_expr] = "expr",
  [sym_grouped_expr] = "grouped_expr",
  [sym_member_access_expr] = "member_access_expr",
  [sym_table_lookup_expr] = "table_lookup_expr",
  [sym_unary_neg_expr] = "unary_neg_expr",
  [sym_unary_not_expr] = "unary_not_expr",
  [sym_mult_div_mod_expr] = "mult_div_mod_expr",
  [sym_add_sub_expr] = "add_sub_expr",
  [sym_comparison_expr] = "comparison_expr",
  [sym_equality_expr] = "equality_expr",
  [sym_and_expr] = "and_expr",
  [sym_or_expr] = "or_expr",
  [sym_query_expr] = "query_expr",
  [sym__fn_call_expr] = "_fn_call_expr",
  [sym_pos_args_fn_call_expr] = "pos_args_fn_call_expr",
  [sym_pos_args] = "pos_args",
  [sym_named_args_fn_call_expr] = "named_args_fn_call_expr",
  [sym_named_args] = "named_args",
  [sym_named_arg] = "named_arg",
  [sym__val] = "_val",
  [sym_struct_val] = "struct_val",
  [sym_struct_val_member] = "struct_val_member",
  [sym_tuple_struct_val] = "tuple_struct_val",
  [sym_vec_val] = "vec_val",
  [sym__bool_val] = "_bool_val",
  [sym__bindings] = "_bindings",
  [sym_ident_binding] = "ident_binding",
  [sym_struct_unpack_binding] = "struct_unpack_binding",
  [sym_let_stmt] = "let_stmt",
  [sym_assign_stmt] = "assign_stmt",
  [sym_if_stmt] = "if_stmt",
  [sym_if_clause] = "if_clause",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_stmt] = "for_stmt",
  [sym__directive_stmt] = "_directive_stmt",
  [sym_exec_stmt] = "exec_stmt",
  [sym_emit_stmt] = "emit_stmt",
  [sym_return_stmt] = "return_stmt",
  [sym_fail_stmt] = "fail_stmt",
  [sym__enum_variant] = "_enum_variant",
  [sym__enum_variant_struct] = "_enum_variant_struct",
  [sym__enum_variant_tuple] = "_enum_variant_tuple",
  [sym_builtin_type] = "builtin_type",
  [sym_assign_op] = "assign_op",
  [sym_ident_list] = "ident_list",
  [sym_struct_member] = "struct_member",
  [sym_tuple_type] = "tuple_type",
  [sym_short_option_type] = "short_option_type",
  [sym_short_vec_type] = "short_vec_type",
  [sym__type_defn] = "_type_defn",
  [sym_struct_defn] = "struct_defn",
  [sym_enum_defn] = "enum_defn",
  [sym_enum_body] = "enum_body",
  [sym_type_alias_defn] = "type_alias_defn",
  [sym_type_expr] = "type_expr",
  [sym_type_path] = "type_path",
  [aux_sym_cwscript_src_repeat1] = "cwscript_src_repeat1",
  [aux_sym_contract_body_repeat1] = "contract_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym_cwspec_line_repeat1] = "cwspec_line_repeat1",
  [aux_sym_cwspec_block_repeat1] = "cwspec_block_repeat1",
  [aux_sym_import_list_repeat1] = "import_list_repeat1",
  [aux_sym_error_block_repeat1] = "error_block_repeat1",
  [aux_sym_event_block_repeat1] = "event_block_repeat1",
  [aux_sym_state_block_repeat1] = "state_block_repeat1",
  [aux_sym_exec_block_repeat1] = "exec_block_repeat1",
  [aux_sym_query_block_repeat1] = "query_block_repeat1",
  [aux_sym_state_map_repeat1] = "state_map_repeat1",
  [aux_sym_fn_args_repeat1] = "fn_args_repeat1",
  [aux_sym_fn_body_repeat1] = "fn_body_repeat1",
  [aux_sym_pos_args_repeat1] = "pos_args_repeat1",
  [aux_sym_named_args_repeat1] = "named_args_repeat1",
  [aux_sym_struct_val_repeat1] = "struct_val_repeat1",
  [aux_sym_if_stmt_repeat1] = "if_stmt_repeat1",
  [aux_sym__enum_variant_struct_repeat1] = "_enum_variant_struct_repeat1",
  [aux_sym__enum_variant_tuple_repeat1] = "_enum_variant_tuple_repeat1",
  [aux_sym_ident_list_repeat1] = "ident_list_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_type_path_repeat1] = "type_path_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SLASH_SLASH_SLASH] = anon_sym_SLASH_SLASH_SLASH,
  [aux_sym_cwspec_line_token1] = aux_sym_cwspec_line_token1,
  [anon_sym_SLASH_STAR_STAR] = anon_sym_SLASH_STAR_STAR,
  [aux_sym_cwspec_block_token1] = aux_sym_cwspec_block_token1,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_state] = anon_sym_state,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_query] = anon_sym_query,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_instantiate] = anon_sym_instantiate,
  [anon_sym_migrate] = anon_sym_migrate,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [sym_unit_val] = sym_unit_val,
  [sym_string_val] = sym_string_val,
  [sym_integer_val] = sym_integer_val,
  [sym_decimal_val] = sym_decimal_val,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_none_val] = sym_none_val,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_emit] = anon_sym_emit,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_fail] = anon_sym_fail,
  [sym_type_name] = sym_type_name,
  [sym_ident] = sym_ident,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_i8] = anon_sym_i8,
  [anon_sym_i16] = anon_sym_i16,
  [anon_sym_i32] = anon_sym_i32,
  [anon_sym_i64] = anon_sym_i64,
  [anon_sym_i128] = anon_sym_i128,
  [anon_sym_u8] = anon_sym_u8,
  [anon_sym_u16] = anon_sym_u16,
  [anon_sym_u32] = anon_sym_u32,
  [anon_sym_u64] = anon_sym_u64,
  [anon_sym_u128] = anon_sym_u128,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_type] = anon_sym_type,
  [sym_infer_type] = sym_infer_type,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_cwscript_src] = sym_cwscript_src,
  [sym__cws_item] = sym__cws_item,
  [sym_contract_defn] = sym_contract_defn,
  [sym_contract_body] = sym_contract_body,
  [sym_interface_body] = sym_interface_body,
  [sym_cwspec] = sym_cwspec,
  [sym_cwspec_line] = sym_cwspec_line,
  [sym_cwspec_block] = sym_cwspec_block,
  [sym_interface_defn] = sym_interface_defn,
  [sym__import_stmt] = sym__import_stmt,
  [sym_import_all] = sym_import_all,
  [sym_import_items] = sym_import_items,
  [sym_import_list] = sym_import_list,
  [sym_import_item] = sym_import_item,
  [sym_error_block] = sym_error_block,
  [sym_event_block] = sym_event_block,
  [sym_state_block] = sym_state_block,
  [sym_exec_block] = sym_exec_block,
  [sym_query_block] = sym_query_block,
  [sym_contract_item] = sym_contract_item,
  [sym_interface_item] = sym_interface_item,
  [sym_error_block_item] = sym_error_block_item,
  [sym_event_block_item] = sym_event_block_item,
  [sym_exec_block_item] = sym_exec_block_item,
  [sym_query_block_item] = sym_query_block_item,
  [sym_error_defn] = sym_error_defn,
  [sym_event_defn] = sym_event_defn,
  [sym_state_defn] = sym_state_defn,
  [sym_state_block_item] = sym_state_block_item,
  [sym__state_defn] = sym__state_defn,
  [sym_state_item] = sym_state_item,
  [sym_state_map] = sym_state_map,
  [sym_map_key] = sym_map_key,
  [sym__named_fn_defn] = sym__named_fn_defn,
  [sym__fn_defn] = sym__fn_defn,
  [sym__named_fn_decl] = sym__named_fn_decl,
  [sym__fn_decl] = sym__fn_decl,
  [sym_instantiate_defn] = sym_instantiate_defn,
  [sym_instantiate_decl] = sym_instantiate_decl,
  [sym_exec_defn] = sym_exec_defn,
  [sym_exec_decl] = sym_exec_decl,
  [sym_query_defn] = sym_query_defn,
  [sym_query_decl] = sym_query_decl,
  [sym_migrate_defn] = sym_migrate_defn,
  [sym_migrate_decl] = sym_migrate_decl,
  [sym_fn_args] = sym_fn_args,
  [sym_fn_arg] = sym_fn_arg,
  [sym_fn_body] = sym_fn_body,
  [sym__stmt] = sym__stmt,
  [sym_expr] = sym_expr,
  [sym_grouped_expr] = sym_grouped_expr,
  [sym_member_access_expr] = sym_member_access_expr,
  [sym_table_lookup_expr] = sym_table_lookup_expr,
  [sym_unary_neg_expr] = sym_unary_neg_expr,
  [sym_unary_not_expr] = sym_unary_not_expr,
  [sym_mult_div_mod_expr] = sym_mult_div_mod_expr,
  [sym_add_sub_expr] = sym_add_sub_expr,
  [sym_comparison_expr] = sym_comparison_expr,
  [sym_equality_expr] = sym_equality_expr,
  [sym_and_expr] = sym_and_expr,
  [sym_or_expr] = sym_or_expr,
  [sym_query_expr] = sym_query_expr,
  [sym__fn_call_expr] = sym__fn_call_expr,
  [sym_pos_args_fn_call_expr] = sym_pos_args_fn_call_expr,
  [sym_pos_args] = sym_pos_args,
  [sym_named_args_fn_call_expr] = sym_named_args_fn_call_expr,
  [sym_named_args] = sym_named_args,
  [sym_named_arg] = sym_named_arg,
  [sym__val] = sym__val,
  [sym_struct_val] = sym_struct_val,
  [sym_struct_val_member] = sym_struct_val_member,
  [sym_tuple_struct_val] = sym_tuple_struct_val,
  [sym_vec_val] = sym_vec_val,
  [sym__bool_val] = sym__bool_val,
  [sym__bindings] = sym__bindings,
  [sym_ident_binding] = sym_ident_binding,
  [sym_struct_unpack_binding] = sym_struct_unpack_binding,
  [sym_let_stmt] = sym_let_stmt,
  [sym_assign_stmt] = sym_assign_stmt,
  [sym_if_stmt] = sym_if_stmt,
  [sym_if_clause] = sym_if_clause,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_stmt] = sym_for_stmt,
  [sym__directive_stmt] = sym__directive_stmt,
  [sym_exec_stmt] = sym_exec_stmt,
  [sym_emit_stmt] = sym_emit_stmt,
  [sym_return_stmt] = sym_return_stmt,
  [sym_fail_stmt] = sym_fail_stmt,
  [sym__enum_variant] = sym__enum_variant,
  [sym__enum_variant_struct] = sym__enum_variant_struct,
  [sym__enum_variant_tuple] = sym__enum_variant_tuple,
  [sym_builtin_type] = sym_builtin_type,
  [sym_assign_op] = sym_assign_op,
  [sym_ident_list] = sym_ident_list,
  [sym_struct_member] = sym_struct_member,
  [sym_tuple_type] = sym_tuple_type,
  [sym_short_option_type] = sym_short_option_type,
  [sym_short_vec_type] = sym_short_vec_type,
  [sym__type_defn] = sym__type_defn,
  [sym_struct_defn] = sym_struct_defn,
  [sym_enum_defn] = sym_enum_defn,
  [sym_enum_body] = sym_enum_body,
  [sym_type_alias_defn] = sym_type_alias_defn,
  [sym_type_expr] = sym_type_expr,
  [sym_type_path] = sym_type_path,
  [aux_sym_cwscript_src_repeat1] = aux_sym_cwscript_src_repeat1,
  [aux_sym_contract_body_repeat1] = aux_sym_contract_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym_cwspec_line_repeat1] = aux_sym_cwspec_line_repeat1,
  [aux_sym_cwspec_block_repeat1] = aux_sym_cwspec_block_repeat1,
  [aux_sym_import_list_repeat1] = aux_sym_import_list_repeat1,
  [aux_sym_error_block_repeat1] = aux_sym_error_block_repeat1,
  [aux_sym_event_block_repeat1] = aux_sym_event_block_repeat1,
  [aux_sym_state_block_repeat1] = aux_sym_state_block_repeat1,
  [aux_sym_exec_block_repeat1] = aux_sym_exec_block_repeat1,
  [aux_sym_query_block_repeat1] = aux_sym_query_block_repeat1,
  [aux_sym_state_map_repeat1] = aux_sym_state_map_repeat1,
  [aux_sym_fn_args_repeat1] = aux_sym_fn_args_repeat1,
  [aux_sym_fn_body_repeat1] = aux_sym_fn_body_repeat1,
  [aux_sym_pos_args_repeat1] = aux_sym_pos_args_repeat1,
  [aux_sym_named_args_repeat1] = aux_sym_named_args_repeat1,
  [aux_sym_struct_val_repeat1] = aux_sym_struct_val_repeat1,
  [aux_sym_if_stmt_repeat1] = aux_sym_if_stmt_repeat1,
  [aux_sym__enum_variant_struct_repeat1] = aux_sym__enum_variant_struct_repeat1,
  [aux_sym__enum_variant_tuple_repeat1] = aux_sym__enum_variant_tuple_repeat1,
  [aux_sym_ident_list_repeat1] = aux_sym_ident_list_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_type_path_repeat1] = aux_sym_type_path_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cwspec_line_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cwspec_block_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_state] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_query] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instantiate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_migrate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [sym_unit_val] = {
    .visible = true,
    .named = true,
  },
  [sym_string_val] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_val] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_val] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_none_val] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_emit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fail] = {
    .visible = true,
    .named = false,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_cwscript_src] = {
    .visible = true,
    .named = true,
  },
  [sym__cws_item] = {
    .visible = false,
    .named = true,
  },
  [sym_contract_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_body] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_cwspec] = {
    .visible = true,
    .named = true,
  },
  [sym_cwspec_line] = {
    .visible = true,
    .named = true,
  },
  [sym_cwspec_block] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_defn] = {
    .visible = true,
    .named = true,
  },
  [sym__import_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_import_all] = {
    .visible = true,
    .named = true,
  },
  [sym_import_items] = {
    .visible = true,
    .named = true,
  },
  [sym_import_list] = {
    .visible = true,
    .named = true,
  },
  [sym_import_item] = {
    .visible = true,
    .named = true,
  },
  [sym_error_block] = {
    .visible = true,
    .named = true,
  },
  [sym_event_block] = {
    .visible = true,
    .named = true,
  },
  [sym_state_block] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_block] = {
    .visible = true,
    .named = true,
  },
  [sym_query_block] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_item] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_item] = {
    .visible = true,
    .named = true,
  },
  [sym_error_block_item] = {
    .visible = true,
    .named = true,
  },
  [sym_event_block_item] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_block_item] = {
    .visible = true,
    .named = true,
  },
  [sym_query_block_item] = {
    .visible = true,
    .named = true,
  },
  [sym_error_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_event_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_state_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_state_block_item] = {
    .visible = true,
    .named = true,
  },
  [sym__state_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_state_item] = {
    .visible = true,
    .named = true,
  },
  [sym_state_map] = {
    .visible = true,
    .named = true,
  },
  [sym_map_key] = {
    .visible = true,
    .named = true,
  },
  [sym__named_fn_defn] = {
    .visible = false,
    .named = true,
  },
  [sym__fn_defn] = {
    .visible = false,
    .named = true,
  },
  [sym__named_fn_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__fn_decl] = {
    .visible = false,
    .named = true,
  },
  [sym_instantiate_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiate_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_query_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_query_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_migrate_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_migrate_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_args] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_body] = {
    .visible = true,
    .named = true,
  },
  [sym__stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_grouped_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_member_access_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_table_lookup_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_neg_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_not_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_div_mod_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_add_sub_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_and_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_or_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_query_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__fn_call_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_pos_args_fn_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_pos_args] = {
    .visible = true,
    .named = true,
  },
  [sym_named_args_fn_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_named_args] = {
    .visible = true,
    .named = true,
  },
  [sym_named_arg] = {
    .visible = true,
    .named = true,
  },
  [sym__val] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_val] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_val_member] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_struct_val] = {
    .visible = true,
    .named = true,
  },
  [sym_vec_val] = {
    .visible = true,
    .named = true,
  },
  [sym__bool_val] = {
    .visible = false,
    .named = true,
  },
  [sym__bindings] = {
    .visible = false,
    .named = true,
  },
  [sym_ident_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_unpack_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_let_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_if_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__directive_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_exec_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_emit_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_return_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_fail_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_variant] = {
    .visible = false,
    .named = true,
  },
  [sym__enum_variant_struct] = {
    .visible = false,
    .named = true,
  },
  [sym__enum_variant_tuple] = {
    .visible = false,
    .named = true,
  },
  [sym_builtin_type] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_op] = {
    .visible = true,
    .named = true,
  },
  [sym_ident_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_short_option_type] = {
    .visible = true,
    .named = true,
  },
  [sym_short_vec_type] = {
    .visible = true,
    .named = true,
  },
  [sym__type_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_type_path] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_cwscript_src_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cwspec_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cwspec_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_error_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_event_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exec_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_query_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_map_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fn_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fn_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pos_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_val_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_stmt_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__enum_variant_struct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__enum_variant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ident_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_path_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_arg = 2,
  field_args = 3,
  field_bases = 4,
  field_bindings = 5,
  field_body = 6,
  field_definition = 7,
  field_else_clause = 8,
  field_else_if_clauses = 9,
  field_filepath = 10,
  field_function = 11,
  field_if_clause = 12,
  field_index = 13,
  field_interfaces = 14,
  field_is_option = 15,
  field_iterable = 16,
  field_key = 17,
  field_key_name = 18,
  field_key_type = 19,
  field_lhs = 20,
  field_map_keys = 21,
  field_member = 22,
  field_member_vals = 23,
  field_members = 24,
  field_members_vals = 25,
  field_name = 26,
  field_op = 27,
  field_option = 28,
  field_predicate = 29,
  field_return_type = 30,
  field_rhs = 31,
  field_spec = 32,
  field_struct_members = 33,
  field_symbol = 34,
  field_symbols = 35,
  field_tuple_members = 36,
  field_type = 37,
  field_vals = 38,
  field_value = 39,
  field_var_name = 40,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arg] = "arg",
  [field_args] = "args",
  [field_bases] = "bases",
  [field_bindings] = "bindings",
  [field_body] = "body",
  [field_definition] = "definition",
  [field_else_clause] = "else_clause",
  [field_else_if_clauses] = "else_if_clauses",
  [field_filepath] = "filepath",
  [field_function] = "function",
  [field_if_clause] = "if_clause",
  [field_index] = "index",
  [field_interfaces] = "interfaces",
  [field_is_option] = "is_option",
  [field_iterable] = "iterable",
  [field_key] = "key",
  [field_key_name] = "key_name",
  [field_key_type] = "key_type",
  [field_lhs] = "lhs",
  [field_map_keys] = "map_keys",
  [field_member] = "member",
  [field_member_vals] = "member_vals",
  [field_members] = "members",
  [field_members_vals] = "members_vals",
  [field_name] = "name",
  [field_op] = "op",
  [field_option] = "option",
  [field_predicate] = "predicate",
  [field_return_type] = "return_type",
  [field_rhs] = "rhs",
  [field_spec] = "spec",
  [field_struct_members] = "struct_members",
  [field_symbol] = "symbol",
  [field_symbols] = "symbols",
  [field_tuple_members] = "tuple_members",
  [field_type] = "type",
  [field_vals] = "vals",
  [field_value] = "value",
  [field_var_name] = "var_name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 4},
  [8] = {.index = 15, .length = 4},
  [9] = {.index = 19, .length = 4},
  [10] = {.index = 23, .length = 3},
  [11] = {.index = 26, .length = 2},
  [12] = {.index = 28, .length = 4},
  [13] = {.index = 32, .length = 3},
  [14] = {.index = 35, .length = 3},
  [15] = {.index = 38, .length = 2},
  [16] = {.index = 40, .length = 3},
  [17] = {.index = 43, .length = 2},
  [18] = {.index = 45, .length = 1},
  [19] = {.index = 46, .length = 4},
  [20] = {.index = 50, .length = 3},
  [21] = {.index = 53, .length = 2},
  [22] = {.index = 55, .length = 5},
  [23] = {.index = 60, .length = 1},
  [24] = {.index = 61, .length = 5},
  [25] = {.index = 66, .length = 4},
  [26] = {.index = 70, .length = 4},
  [27] = {.index = 74, .length = 3},
  [28] = {.index = 77, .length = 2},
  [29] = {.index = 79, .length = 4},
  [30] = {.index = 83, .length = 3},
  [31] = {.index = 86, .length = 5},
  [32] = {.index = 91, .length = 5},
  [33] = {.index = 96, .length = 6},
  [34] = {.index = 102, .length = 5},
  [35] = {.index = 107, .length = 1},
  [36] = {.index = 108, .length = 2},
  [37] = {.index = 110, .length = 4},
  [38] = {.index = 114, .length = 3},
  [39] = {.index = 117, .length = 1},
  [40] = {.index = 118, .length = 2},
  [41] = {.index = 120, .length = 2},
  [42] = {.index = 122, .length = 2},
  [43] = {.index = 124, .length = 2},
  [44] = {.index = 126, .length = 2},
  [45] = {.index = 128, .length = 1},
  [46] = {.index = 129, .length = 3},
  [47] = {.index = 132, .length = 2},
  [48] = {.index = 134, .length = 1},
  [49] = {.index = 135, .length = 1},
  [50] = {.index = 136, .length = 2},
  [51] = {.index = 138, .length = 2},
  [52] = {.index = 140, .length = 2},
  [53] = {.index = 142, .length = 3},
  [54] = {.index = 145, .length = 3},
  [55] = {.index = 148, .length = 3},
  [56] = {.index = 151, .length = 7},
  [57] = {.index = 158, .length = 3},
  [58] = {.index = 161, .length = 3},
  [59] = {.index = 164, .length = 3},
  [60] = {.index = 167, .length = 4},
  [61] = {.index = 171, .length = 3},
  [62] = {.index = 174, .length = 1},
  [63] = {.index = 175, .length = 2},
  [64] = {.index = 177, .length = 3},
  [65] = {.index = 180, .length = 2},
  [66] = {.index = 182, .length = 2},
  [67] = {.index = 184, .length = 1},
  [68] = {.index = 185, .length = 3},
  [69] = {.index = 188, .length = 1},
  [70] = {.index = 189, .length = 8},
  [71] = {.index = 197, .length = 8},
  [72] = {.index = 205, .length = 3},
  [73] = {.index = 208, .length = 4},
  [74] = {.index = 212, .length = 2},
  [75] = {.index = 214, .length = 2},
  [76] = {.index = 216, .length = 2},
  [77] = {.index = 218, .length = 2},
  [78] = {.index = 220, .length = 2},
  [79] = {.index = 222, .length = 2},
  [80] = {.index = 224, .length = 2},
  [81] = {.index = 226, .length = 3},
  [82] = {.index = 229, .length = 2},
  [83] = {.index = 231, .length = 3},
  [84] = {.index = 234, .length = 3},
  [85] = {.index = 237, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_symbol, 0},
  [1] =
    {field_body, 2},
    {field_name, 1},
  [3] =
    {field_filepath, 3},
  [4] =
    {field_alias, 2},
    {field_symbol, 0},
  [6] =
    {field_filepath, 3},
    {field_symbols, 1},
  [8] =
    {field_body, 3},
    {field_name, 2},
    {field_spec, 0},
  [11] =
    {field_bases, 2},
    {field_bases, 3},
    {field_body, 4},
    {field_name, 1},
  [15] =
    {field_body, 4},
    {field_interfaces, 2},
    {field_interfaces, 3},
    {field_name, 1},
  [19] =
    {field_members, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_struct_members, 1, .inherited = true},
    {field_tuple_members, 1, .inherited = true},
  [23] =
    {field_members, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_struct_members, 0, .inherited = true},
  [26] =
    {field_name, 0, .inherited = true},
    {field_tuple_members, 0, .inherited = true},
  [28] =
    {field_args, 1, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [32] =
    {field_args, 1, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [35] =
    {field_members, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_struct_members, 1, .inherited = true},
  [38] =
    {field_name, 1, .inherited = true},
    {field_tuple_members, 1, .inherited = true},
  [40] =
    {field_args, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [43] =
    {field_args, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [45] =
    {field_args, 0},
  [46] =
    {field_members, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_struct_members, 0, .inherited = true},
    {field_tuple_members, 0, .inherited = true},
  [50] =
    {field_args, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [53] =
    {field_args, 0},
    {field_body, 1},
  [55] =
    {field_members, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_spec, 0},
    {field_struct_members, 2, .inherited = true},
    {field_tuple_members, 2, .inherited = true},
  [60] =
    {field_spec, 0},
  [61] =
    {field_args, 2, .inherited = true},
    {field_body, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_spec, 0},
  [66] =
    {field_args, 2, .inherited = true},
    {field_body, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_spec, 0},
  [70] =
    {field_members, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_spec, 0},
    {field_struct_members, 2, .inherited = true},
  [74] =
    {field_name, 2, .inherited = true},
    {field_spec, 0},
    {field_tuple_members, 2, .inherited = true},
  [77] =
    {field_args, 1},
    {field_name, 0},
  [79] =
    {field_args, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_spec, 0},
  [83] =
    {field_args, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_spec, 0},
  [86] =
    {field_bases, 3},
    {field_bases, 4},
    {field_body, 5},
    {field_name, 2},
    {field_spec, 0},
  [91] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_interfaces, 4},
    {field_name, 2},
    {field_spec, 0},
  [96] =
    {field_bases, 2},
    {field_bases, 3},
    {field_body, 6},
    {field_interfaces, 4},
    {field_interfaces, 5},
    {field_name, 1},
  [102] =
    {field_members, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_spec, 0},
    {field_struct_members, 1, .inherited = true},
    {field_tuple_members, 1, .inherited = true},
  [107] =
    {field_name, 0},
  [108] =
    {field_key, 0},
    {field_type, 2},
  [110] =
    {field_args, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_spec, 0},
  [114] =
    {field_args, 1},
    {field_body, 2},
    {field_name, 0},
  [117] =
    {field_if_clause, 0},
  [118] =
    {field_alias, 1},
    {field_definition, 3},
  [120] =
    {field_args, 0},
    {field_return_type, 2},
  [122] =
    {field_members, 2},
    {field_name, 0},
  [124] =
    {field_name, 0},
    {field_struct_members, 2},
  [126] =
    {field_name, 0},
    {field_tuple_members, 2},
  [128] =
    {field_key_type, 1},
  [129] =
    {field_key, 0},
    {field_map_keys, 1},
    {field_type, 3},
  [132] =
    {field_name, 0},
    {field_type, 2},
  [134] =
    {field_arg, 1},
  [135] =
    {field_var_name, 0},
  [136] =
    {field_args, 1},
    {field_function, 0},
  [138] =
    {field_else_clause, 1},
    {field_if_clause, 0},
  [140] =
    {field_else_if_clauses, 1},
    {field_if_clause, 0},
  [142] =
    {field_args, 0},
    {field_body, 3},
    {field_return_type, 2},
  [145] =
    {field_alias, 2},
    {field_definition, 4},
    {field_spec, 0},
  [148] =
    {field_args, 1},
    {field_name, 0},
    {field_return_type, 3},
  [151] =
    {field_bases, 3},
    {field_bases, 4},
    {field_body, 7},
    {field_interfaces, 5},
    {field_interfaces, 6},
    {field_name, 2},
    {field_spec, 0},
  [158] =
    {field_members, 2},
    {field_members, 3},
    {field_name, 0},
  [161] =
    {field_name, 0},
    {field_struct_members, 2},
    {field_struct_members, 3},
  [164] =
    {field_name, 0},
    {field_tuple_members, 2},
    {field_tuple_members, 3},
  [167] =
    {field_args, 1},
    {field_body, 4},
    {field_name, 0},
    {field_return_type, 3},
  [171] =
    {field_name, 0},
    {field_option, 1},
    {field_type, 3},
  [174] =
    {field_vals, 1},
  [175] =
    {field_body, 2},
    {field_predicate, 1},
  [177] =
    {field_lhs, 0},
    {field_op, 1},
    {field_rhs, 2},
  [180] =
    {field_lhs, 0},
    {field_member, 2},
  [182] =
    {field_lhs, 0},
    {field_rhs, 2},
  [184] =
    {field_body, 1},
  [185] =
    {field_else_clause, 2},
    {field_else_if_clauses, 1},
    {field_if_clause, 0},
  [188] =
    {field_type, 0},
  [189] =
    {field_members, 1, .inherited = true},
    {field_members, 2, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_struct_members, 1, .inherited = true},
    {field_struct_members, 2, .inherited = true},
    {field_tuple_members, 1, .inherited = true},
    {field_tuple_members, 2, .inherited = true},
  [197] =
    {field_members, 0, .inherited = true},
    {field_members, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_struct_members, 0, .inherited = true},
    {field_struct_members, 1, .inherited = true},
    {field_tuple_members, 0, .inherited = true},
    {field_tuple_members, 1, .inherited = true},
  [205] =
    {field_is_option, 1},
    {field_name, 0},
    {field_type, 3},
  [208] =
    {field_members, 2},
    {field_members, 3},
    {field_members, 4},
    {field_name, 0},
  [212] =
    {field_key_name, 1},
    {field_key_type, 3},
  [214] =
    {field_vals, 1},
    {field_vals, 2},
  [216] =
    {field_type, 2},
    {field_var_name, 0},
  [218] =
    {field_bindings, 1},
    {field_rhs, 3},
  [220] =
    {field_index, 2},
    {field_lhs, 0},
  [222] =
    {field_members_vals, 2},
    {field_type, 0},
  [224] =
    {field_member_vals, 2},
    {field_type, 0},
  [226] =
    {field_bindings, 1},
    {field_body, 4},
    {field_iterable, 3},
  [229] =
    {field_name, 0},
    {field_value, 2},
  [231] =
    {field_members_vals, 2},
    {field_members_vals, 3},
    {field_type, 0},
  [234] =
    {field_member_vals, 2},
    {field_member_vals, 3},
    {field_type, 0},
  [237] =
    {field_members_vals, 2},
    {field_members_vals, 3},
    {field_members_vals, 4},
    {field_type, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(140);
      if (lookahead == '!') ADVANCE(183);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(185);
      if (lookahead == '(') ADVANCE(159);
      if (lookahead == ')') ADVANCE(161);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '+') ADVANCE(187);
      if (lookahead == ',') ADVANCE(160);
      if (lookahead == '-') ADVANCE(181);
      if (lookahead == '.') ADVANCE(178);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == ':') ADVANCE(171);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(211);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(172);
      if (lookahead == ']') ADVANCE(173);
      if (lookahead == '_') ADVANCE(326);
      if (lookahead == 'a') ADVANCE(78);
      if (lookahead == 'b') ADVANCE(90);
      if (lookahead == 'c') ADVANCE(88);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == 'f') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(14);
      if (lookahead == 'l') ADVANCE(56);
      if (lookahead == 'm') ADVANCE(66);
      if (lookahead == 'n') ADVANCE(91);
      if (lookahead == 'o') ADVANCE(98);
      if (lookahead == 'q') ADVANCE(132);
      if (lookahead == 'r') ADVANCE(59);
      if (lookahead == 's') ADVANCE(114);
      if (lookahead == 't') ADVANCE(108);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == '{') ADVANCE(144);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(183);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(185);
      if (lookahead == '(') ADVANCE(159);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '+') ADVANCE(187);
      if (lookahead == '-') ADVANCE(180);
      if (lookahead == '.') ADVANCE(178);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(211);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(172);
      if (lookahead == '_') ADVANCE(327);
      if (lookahead == 'a') ADVANCE(261);
      if (lookahead == 'b') ADVANCE(266);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == 'f') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(226);
      if (lookahead == 'l') ADVANCE(249);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'o') ADVANCE(270);
      if (lookahead == 'q') ADVANCE(284);
      if (lookahead == 'r') ADVANCE(251);
      if (lookahead == 's') ADVANCE(279);
      if (lookahead == 't') ADVANCE(273);
      if (lookahead == 'u') ADVANCE(228);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('c' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(182);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(159);
      if (lookahead == ')') ADVANCE(161);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '[') ADVANCE(172);
      if (lookahead == ']') ADVANCE(173);
      if (lookahead == '_') ADVANCE(327);
      if (lookahead == 'b') ADVANCE(266);
      if (lookahead == 'e') ADVANCE(262);
      if (lookahead == 'f') ADVANCE(238);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'q') ADVANCE(284);
      if (lookahead == 's') ADVANCE(279);
      if (lookahead == 't') ADVANCE(273);
      if (lookahead == 'u') ADVANCE(228);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(182);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(159);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == ':') ADVANCE(170);
      if (lookahead == '=') ADVANCE(210);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(172);
      if (lookahead == '_') ADVANCE(327);
      if (lookahead == 'b') ADVANCE(266);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == 'f') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(226);
      if (lookahead == 'l') ADVANCE(249);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'q') ADVANCE(284);
      if (lookahead == 'r') ADVANCE(251);
      if (lookahead == 's') ADVANCE(279);
      if (lookahead == 't') ADVANCE(273);
      if (lookahead == 'u') ADVANCE(228);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(182);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(159);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '[') ADVANCE(172);
      if (lookahead == '_') ADVANCE(327);
      if (lookahead == 'b') ADVANCE(266);
      if (lookahead == 'e') ADVANCE(257);
      if (lookahead == 'f') ADVANCE(237);
      if (lookahead == 'i') ADVANCE(226);
      if (lookahead == 'l') ADVANCE(249);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'q') ADVANCE(284);
      if (lookahead == 'r') ADVANCE(251);
      if (lookahead == 's') ADVANCE(279);
      if (lookahead == 't') ADVANCE(273);
      if (lookahead == 'u') ADVANCE(228);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '%') ADVANCE(184);
      if (lookahead == '(') ADVANCE(158);
      if (lookahead == ')') ADVANCE(161);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '+') ADVANCE(186);
      if (lookahead == ',') ADVANCE(160);
      if (lookahead == '-') ADVANCE(179);
      if (lookahead == '.') ADVANCE(178);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == ':') ADVANCE(170);
      if (lookahead == '<') ADVANCE(188);
      if (lookahead == '=') ADVANCE(28);
      if (lookahead == '>') ADVANCE(189);
      if (lookahead == '[') ADVANCE(172);
      if (lookahead == ']') ADVANCE(173);
      if (lookahead == 'a') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(79);
      if (lookahead == 'o') ADVANCE(98);
      if (lookahead == '{') ADVANCE(144);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(199);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(158);
      if (lookahead == ')') ADVANCE(161);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(30);
      if (lookahead == '{') ADVANCE(144);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 8:
      if (lookahead == '(') ADVANCE(158);
      if (lookahead == ')') ADVANCE(161);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '_') ADVANCE(327);
      if (lookahead == 'b') ADVANCE(266);
      if (lookahead == 'e') ADVANCE(262);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 's') ADVANCE(279);
      if (lookahead == 't') ADVANCE(287);
      if (lookahead == 'u') ADVANCE(228);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(13);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(149);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(150);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(150);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(146);
      END_STATE();
    case 14:
      if (lookahead == '1') ADVANCE(17);
      if (lookahead == '3') ADVANCE(18);
      if (lookahead == '6') ADVANCE(21);
      if (lookahead == '8') ADVANCE(292);
      if (lookahead == 'f') ADVANCE(212);
      if (lookahead == 'm') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 15:
      if (lookahead == '1') ADVANCE(17);
      if (lookahead == '3') ADVANCE(18);
      if (lookahead == '6') ADVANCE(21);
      if (lookahead == '8') ADVANCE(292);
      if (lookahead == 'm') ADVANCE(97);
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 16:
      if (lookahead == '1') ADVANCE(20);
      if (lookahead == '3') ADVANCE(19);
      if (lookahead == '6') ADVANCE(22);
      if (lookahead == '8') ADVANCE(302);
      END_STATE();
    case 17:
      if (lookahead == '2') ADVANCE(23);
      if (lookahead == '6') ADVANCE(294);
      END_STATE();
    case 18:
      if (lookahead == '2') ADVANCE(296);
      END_STATE();
    case 19:
      if (lookahead == '2') ADVANCE(306);
      END_STATE();
    case 20:
      if (lookahead == '2') ADVANCE(24);
      if (lookahead == '6') ADVANCE(304);
      END_STATE();
    case 21:
      if (lookahead == '4') ADVANCE(298);
      END_STATE();
    case 22:
      if (lookahead == '4') ADVANCE(308);
      END_STATE();
    case 23:
      if (lookahead == '8') ADVANCE(300);
      END_STATE();
    case 24:
      if (lookahead == '8') ADVANCE(310);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(328);
      END_STATE();
    case 26:
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(79);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(192);
      END_STATE();
    case 29:
      if (lookahead == '>') ADVANCE(174);
      END_STATE();
    case 30:
      if (lookahead == ']') ADVANCE(319);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(99);
      if (lookahead == 'r') ADVANCE(92);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(40);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(128);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(87);
      END_STATE();
    case 37:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 39:
      if (lookahead == 'c') ADVANCE(119);
      END_STATE();
    case 40:
      if (lookahead == 'c') ADVANCE(120);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'd') ADVANCE(194);
      END_STATE();
    case 43:
      if (lookahead == 'd') ADVANCE(109);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(312);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(82);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 64:
      if (lookahead == 'f') ADVANCE(32);
      END_STATE();
    case 65:
      if (lookahead == 'g') ADVANCE(100);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(111);
      if (lookahead == 'm') ADVANCE(68);
      if (lookahead == 'n') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(105);
      if (lookahead == 'v') ADVANCE(62);
      if (lookahead == 'x') ADVANCE(45);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(290);
      END_STATE();
    case 72:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(322);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(157);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(63);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(221);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(105);
      if (lookahead == 'v') ADVANCE(62);
      if (lookahead == 'x') ADVANCE(44);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(126);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(48);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(125);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 94:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(73);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(50);
      END_STATE();
    case 97:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 99:
      if (lookahead == 'r') ADVANCE(216);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 107:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == 'y') ADVANCE(96);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(142);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 112:
      if (lookahead == 's') ADVANCE(51);
      END_STATE();
    case 113:
      if (lookahead == 's') ADVANCE(124);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(36);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(55);
      END_STATE();
    case 130:
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 131:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 132:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 134:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 135:
      if (lookahead == 'y') ADVANCE(168);
      END_STATE();
    case 136:
      if (lookahead == 'y') ADVANCE(96);
      END_STATE();
    case 137:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 138:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 139:
      if (eof) ADVANCE(140);
      if (lookahead == '(') ADVANCE(158);
      if (lookahead == ')') ADVANCE(161);
      if (lookahead == ',') ADVANCE(160);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '=') ADVANCE(210);
      if (lookahead == '?') ADVANCE(177);
      if (lookahead == '[') ADVANCE(30);
      if (lookahead == ']') ADVANCE(173);
      if (lookahead == '_') ADVANCE(326);
      if (lookahead == 'b') ADVANCE(90);
      if (lookahead == 'c') ADVANCE(88);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(15);
      if (lookahead == 'm') ADVANCE(66);
      if (lookahead == 'q') ADVANCE(132);
      if (lookahead == 's') ADVANCE(114);
      if (lookahead == 't') ADVANCE(136);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == '{') ADVANCE(144);
      if (lookahead == '}') ADVANCE(145);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(139)
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(225);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_contract);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_cwspec_line_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(148);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_cwspec_line_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR_STAR);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_cwspec_block_token1);
      if (lookahead == '*') ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(12);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(13);
      if (lookahead == '=') ADVANCE(317);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(316);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == ')') ADVANCE(198);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_state);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_exec);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_query);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_query);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(328);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_instantiate);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_migrate);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(315);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(315);
      if (lookahead == '>') ADVANCE(174);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(318);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(314);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(190);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_unit_val);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_string_val);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_integer_val);
      if (lookahead == '.') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_decimal_val);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_none_val);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_none_val);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(192);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_emit);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_emit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_fail);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_fail);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_type_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '1') ADVANCE(229);
      if (lookahead == '3') ADVANCE(230);
      if (lookahead == '6') ADVANCE(233);
      if (lookahead == '8') ADVANCE(293);
      if (lookahead == 'f') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '1') ADVANCE(229);
      if (lookahead == '3') ADVANCE(230);
      if (lookahead == '6') ADVANCE(233);
      if (lookahead == '8') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '1') ADVANCE(232);
      if (lookahead == '3') ADVANCE(231);
      if (lookahead == '6') ADVANCE(234);
      if (lookahead == '8') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(235);
      if (lookahead == '6') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(236);
      if (lookahead == '6') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '4') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '4') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '8') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '8') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(252);
      if (lookahead == 'o') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'd') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(276);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(256);
      if (lookahead == 'l') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(275);
      if (lookahead == 'm') ADVANCE(253);
      if (lookahead == 'n') ADVANCE(282);
      if (lookahead == 'x') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(253);
      if (lookahead == 'n') ADVANCE(282);
      if (lookahead == 'x') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(265);
      if (lookahead == 'y') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(286);
      if (lookahead == 'y') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(272);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_i8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_i16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_i32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_i64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_i128);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_i128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_u8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_u16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_u32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_u64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_u128);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_u128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_byte);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_struct);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_enum);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_infer_type);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_infer_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 139},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 4},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 4},
  [89] = {.lex_state = 4},
  [90] = {.lex_state = 4},
  [91] = {.lex_state = 4},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 8},
  [99] = {.lex_state = 8},
  [100] = {.lex_state = 8},
  [101] = {.lex_state = 139},
  [102] = {.lex_state = 139},
  [103] = {.lex_state = 8},
  [104] = {.lex_state = 139},
  [105] = {.lex_state = 139},
  [106] = {.lex_state = 139},
  [107] = {.lex_state = 139},
  [108] = {.lex_state = 139},
  [109] = {.lex_state = 139},
  [110] = {.lex_state = 139},
  [111] = {.lex_state = 139},
  [112] = {.lex_state = 139},
  [113] = {.lex_state = 139},
  [114] = {.lex_state = 139},
  [115] = {.lex_state = 139},
  [116] = {.lex_state = 139},
  [117] = {.lex_state = 139},
  [118] = {.lex_state = 139},
  [119] = {.lex_state = 139},
  [120] = {.lex_state = 139},
  [121] = {.lex_state = 139},
  [122] = {.lex_state = 139},
  [123] = {.lex_state = 139},
  [124] = {.lex_state = 139},
  [125] = {.lex_state = 139},
  [126] = {.lex_state = 139},
  [127] = {.lex_state = 139},
  [128] = {.lex_state = 139},
  [129] = {.lex_state = 139},
  [130] = {.lex_state = 139},
  [131] = {.lex_state = 139},
  [132] = {.lex_state = 139},
  [133] = {.lex_state = 139},
  [134] = {.lex_state = 2},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 139},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 139},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 139},
  [147] = {.lex_state = 139},
  [148] = {.lex_state = 139},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 139},
  [159] = {.lex_state = 139},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 139},
  [162] = {.lex_state = 139},
  [163] = {.lex_state = 5},
  [164] = {.lex_state = 139},
  [165] = {.lex_state = 139},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 5},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 5},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 139},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 139},
  [180] = {.lex_state = 139},
  [181] = {.lex_state = 139},
  [182] = {.lex_state = 139},
  [183] = {.lex_state = 139},
  [184] = {.lex_state = 139},
  [185] = {.lex_state = 139},
  [186] = {.lex_state = 139},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 139},
  [189] = {.lex_state = 139},
  [190] = {.lex_state = 139},
  [191] = {.lex_state = 139},
  [192] = {.lex_state = 139},
  [193] = {.lex_state = 139},
  [194] = {.lex_state = 5},
  [195] = {.lex_state = 139},
  [196] = {.lex_state = 139},
  [197] = {.lex_state = 5},
  [198] = {.lex_state = 5},
  [199] = {.lex_state = 139},
  [200] = {.lex_state = 5},
  [201] = {.lex_state = 139},
  [202] = {.lex_state = 139},
  [203] = {.lex_state = 139},
  [204] = {.lex_state = 139},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 5},
  [207] = {.lex_state = 5},
  [208] = {.lex_state = 5},
  [209] = {.lex_state = 5},
  [210] = {.lex_state = 5},
  [211] = {.lex_state = 5},
  [212] = {.lex_state = 5},
  [213] = {.lex_state = 5},
  [214] = {.lex_state = 139},
  [215] = {.lex_state = 139},
  [216] = {.lex_state = 139},
  [217] = {.lex_state = 139},
  [218] = {.lex_state = 139},
  [219] = {.lex_state = 139},
  [220] = {.lex_state = 139},
  [221] = {.lex_state = 139},
  [222] = {.lex_state = 139},
  [223] = {.lex_state = 7},
  [224] = {.lex_state = 139},
  [225] = {.lex_state = 7},
  [226] = {.lex_state = 139},
  [227] = {.lex_state = 7},
  [228] = {.lex_state = 139},
  [229] = {.lex_state = 139},
  [230] = {.lex_state = 7},
  [231] = {.lex_state = 7},
  [232] = {.lex_state = 139},
  [233] = {.lex_state = 139},
  [234] = {.lex_state = 7},
  [235] = {.lex_state = 7},
  [236] = {.lex_state = 7},
  [237] = {.lex_state = 139},
  [238] = {.lex_state = 139},
  [239] = {.lex_state = 7},
  [240] = {.lex_state = 139},
  [241] = {.lex_state = 139},
  [242] = {.lex_state = 139},
  [243] = {.lex_state = 139},
  [244] = {.lex_state = 139},
  [245] = {.lex_state = 139},
  [246] = {.lex_state = 139},
  [247] = {.lex_state = 139},
  [248] = {.lex_state = 139},
  [249] = {.lex_state = 139},
  [250] = {.lex_state = 139},
  [251] = {.lex_state = 139},
  [252] = {.lex_state = 139},
  [253] = {.lex_state = 139},
  [254] = {.lex_state = 139},
  [255] = {.lex_state = 139},
  [256] = {.lex_state = 139},
  [257] = {.lex_state = 139},
  [258] = {.lex_state = 139},
  [259] = {.lex_state = 139},
  [260] = {.lex_state = 139},
  [261] = {.lex_state = 139},
  [262] = {.lex_state = 139},
  [263] = {.lex_state = 139},
  [264] = {.lex_state = 139},
  [265] = {.lex_state = 139},
  [266] = {.lex_state = 139},
  [267] = {.lex_state = 139},
  [268] = {.lex_state = 139},
  [269] = {.lex_state = 139},
  [270] = {.lex_state = 139},
  [271] = {.lex_state = 139},
  [272] = {.lex_state = 139},
  [273] = {.lex_state = 139},
  [274] = {.lex_state = 139},
  [275] = {.lex_state = 139},
  [276] = {.lex_state = 139},
  [277] = {.lex_state = 139},
  [278] = {.lex_state = 139},
  [279] = {.lex_state = 139},
  [280] = {.lex_state = 139},
  [281] = {.lex_state = 139},
  [282] = {.lex_state = 7},
  [283] = {.lex_state = 7},
  [284] = {.lex_state = 7},
  [285] = {.lex_state = 7},
  [286] = {.lex_state = 139},
  [287] = {.lex_state = 7},
  [288] = {.lex_state = 7},
  [289] = {.lex_state = 139},
  [290] = {.lex_state = 139},
  [291] = {.lex_state = 7},
  [292] = {.lex_state = 7},
  [293] = {.lex_state = 7},
  [294] = {.lex_state = 139},
  [295] = {.lex_state = 7},
  [296] = {.lex_state = 7},
  [297] = {.lex_state = 7},
  [298] = {.lex_state = 7},
  [299] = {.lex_state = 139},
  [300] = {.lex_state = 139},
  [301] = {.lex_state = 7},
  [302] = {.lex_state = 139},
  [303] = {.lex_state = 7},
  [304] = {.lex_state = 7},
  [305] = {.lex_state = 7},
  [306] = {.lex_state = 7},
  [307] = {.lex_state = 139},
  [308] = {.lex_state = 139},
  [309] = {.lex_state = 7},
  [310] = {.lex_state = 7},
  [311] = {.lex_state = 139},
  [312] = {.lex_state = 139},
  [313] = {.lex_state = 7},
  [314] = {.lex_state = 7},
  [315] = {.lex_state = 139},
  [316] = {.lex_state = 139},
  [317] = {.lex_state = 139},
  [318] = {.lex_state = 139},
  [319] = {.lex_state = 7},
  [320] = {.lex_state = 7},
  [321] = {.lex_state = 7},
  [322] = {.lex_state = 7},
  [323] = {.lex_state = 7},
  [324] = {.lex_state = 139},
  [325] = {.lex_state = 7},
  [326] = {.lex_state = 139},
  [327] = {.lex_state = 7},
  [328] = {.lex_state = 139},
  [329] = {.lex_state = 139},
  [330] = {.lex_state = 139},
  [331] = {.lex_state = 7},
  [332] = {.lex_state = 7},
  [333] = {.lex_state = 7},
  [334] = {.lex_state = 7},
  [335] = {.lex_state = 7},
  [336] = {.lex_state = 7},
  [337] = {.lex_state = 7},
  [338] = {.lex_state = 7},
  [339] = {.lex_state = 139},
  [340] = {.lex_state = 139},
  [341] = {.lex_state = 7},
  [342] = {.lex_state = 7},
  [343] = {.lex_state = 7},
  [344] = {.lex_state = 7},
  [345] = {.lex_state = 7},
  [346] = {.lex_state = 7},
  [347] = {.lex_state = 7},
  [348] = {.lex_state = 7},
  [349] = {.lex_state = 139},
  [350] = {.lex_state = 7},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 7},
  [353] = {.lex_state = 139},
  [354] = {.lex_state = 7},
  [355] = {.lex_state = 139},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 7},
  [358] = {.lex_state = 7},
  [359] = {.lex_state = 7},
  [360] = {.lex_state = 7},
  [361] = {.lex_state = 7},
  [362] = {.lex_state = 7},
  [363] = {.lex_state = 139},
  [364] = {.lex_state = 139},
  [365] = {.lex_state = 139},
  [366] = {.lex_state = 7},
  [367] = {.lex_state = 7},
  [368] = {.lex_state = 26},
  [369] = {.lex_state = 7},
  [370] = {.lex_state = 139},
  [371] = {.lex_state = 26},
  [372] = {.lex_state = 7},
  [373] = {.lex_state = 26},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 139},
  [377] = {.lex_state = 7},
  [378] = {.lex_state = 7},
  [379] = {.lex_state = 3},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 139},
  [383] = {.lex_state = 7},
  [384] = {.lex_state = 7},
  [385] = {.lex_state = 7},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 7},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 139},
  [390] = {.lex_state = 139},
  [391] = {.lex_state = 7},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 26},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 7},
  [396] = {.lex_state = 3},
  [397] = {.lex_state = 7},
  [398] = {.lex_state = 139},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 7},
  [401] = {.lex_state = 7},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 7},
  [404] = {.lex_state = 7},
  [405] = {.lex_state = 3},
  [406] = {.lex_state = 7},
  [407] = {.lex_state = 139},
  [408] = {.lex_state = 7},
  [409] = {.lex_state = 139},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 7},
  [412] = {.lex_state = 7},
  [413] = {.lex_state = 7},
  [414] = {.lex_state = 7},
  [415] = {.lex_state = 139},
  [416] = {.lex_state = 3},
  [417] = {.lex_state = 7},
  [418] = {.lex_state = 7},
  [419] = {.lex_state = 139},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 139},
  [422] = {.lex_state = 139},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 7},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 7},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 139},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 7},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 7},
  [443] = {.lex_state = 7},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 7},
  [450] = {.lex_state = 7},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 7},
  [453] = {.lex_state = 7},
  [454] = {.lex_state = 7},
  [455] = {.lex_state = 7},
  [456] = {.lex_state = 7},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 7},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 139},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 7},
  [463] = {.lex_state = 7},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 7},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 139},
  [470] = {.lex_state = 139},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 7},
  [477] = {.lex_state = 139},
  [478] = {.lex_state = 139},
  [479] = {.lex_state = 7},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 7},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 139},
  [487] = {.lex_state = 7},
  [488] = {.lex_state = 26},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 7},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 7},
  [503] = {.lex_state = 7},
  [504] = {.lex_state = 139},
  [505] = {.lex_state = 7},
  [506] = {.lex_state = 7},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 7},
  [510] = {.lex_state = 26},
  [511] = {.lex_state = 7},
  [512] = {.lex_state = 139},
  [513] = {.lex_state = 139},
  [514] = {.lex_state = 7},
  [515] = {.lex_state = 7},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 7},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 7},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 26},
  [523] = {.lex_state = 26},
  [524] = {.lex_state = 26},
  [525] = {.lex_state = 26},
  [526] = {.lex_state = 26},
  [527] = {.lex_state = 26},
  [528] = {.lex_state = 26},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 26},
  [531] = {.lex_state = 26},
  [532] = {.lex_state = 7},
  [533] = {.lex_state = 26},
  [534] = {.lex_state = 26},
  [535] = {.lex_state = 26},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 26},
  [538] = {.lex_state = 26},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 26},
  [541] = {.lex_state = 26},
  [542] = {.lex_state = 26},
  [543] = {.lex_state = 26},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 26},
  [546] = {.lex_state = 26},
  [547] = {.lex_state = 26},
  [548] = {.lex_state = 26},
  [549] = {.lex_state = 7},
  [550] = {.lex_state = 26},
  [551] = {.lex_state = 26},
  [552] = {.lex_state = 26},
  [553] = {.lex_state = 26},
  [554] = {.lex_state = 26},
  [555] = {.lex_state = 26},
  [556] = {.lex_state = 7},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 139},
  [559] = {.lex_state = 7},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 7},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 139},
  [565] = {.lex_state = 139},
  [566] = {.lex_state = 7},
  [567] = {.lex_state = 3},
  [568] = {.lex_state = 7},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 7},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 3},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 7},
  [577] = {.lex_state = 7},
  [578] = {.lex_state = 7},
  [579] = {.lex_state = 7},
  [580] = {.lex_state = 7},
  [581] = {.lex_state = 7},
  [582] = {.lex_state = 7},
  [583] = {.lex_state = 7},
  [584] = {.lex_state = 7},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 139},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 7},
  [589] = {.lex_state = 139},
  [590] = {.lex_state = 7},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 139},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 5},
  [596] = {.lex_state = 3},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 3},
  [599] = {.lex_state = 7},
  [600] = {.lex_state = 7},
  [601] = {.lex_state = 7},
  [602] = {.lex_state = 7},
  [603] = {.lex_state = 3},
  [604] = {.lex_state = 7},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 139},
  [608] = {.lex_state = 7},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 5},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 7},
  [616] = {.lex_state = 3},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 7},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 7},
  [622] = {.lex_state = 7},
  [623] = {.lex_state = 7},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 7},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 7},
  [628] = {.lex_state = 7},
  [629] = {.lex_state = 7},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 7},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 3},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 7},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 3},
  [640] = {.lex_state = 7},
  [641] = {.lex_state = 3},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 7},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 11},
  [646] = {.lex_state = 7},
  [647] = {.lex_state = 3},
  [648] = {.lex_state = 7},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 7},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 11},
  [653] = {.lex_state = 5},
  [654] = {.lex_state = 147},
  [655] = {.lex_state = 7},
  [656] = {.lex_state = 147},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 7},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_contract] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_state] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_query] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_migrate] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [sym_unit_val] = ACTIONS(1),
    [sym_string_val] = ACTIONS(1),
    [sym_integer_val] = ACTIONS(1),
    [sym_decimal_val] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_none_val] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_emit] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_fail] = ACTIONS(1),
    [sym_type_name] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_i128] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_u128] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [sym_infer_type] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
  },
  [1] = {
    [sym_cwscript_src] = STATE(624),
    [sym__cws_item] = STATE(214),
    [sym_contract_defn] = STATE(214),
    [sym_cwspec] = STATE(586),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_interface_defn] = STATE(214),
    [sym__import_stmt] = STATE(214),
    [sym_import_all] = STATE(214),
    [sym_import_items] = STATE(214),
    [aux_sym_cwscript_src_repeat1] = STATE(214),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_contract] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_interface] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
  },
  [2] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(5),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(5),
    [sym_assign_stmt] = STATE(5),
    [sym_if_stmt] = STATE(5),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(5),
    [sym__directive_stmt] = STATE(5),
    [sym_exec_stmt] = STATE(5),
    [sym_emit_stmt] = STATE(5),
    [sym_return_stmt] = STATE(5),
    [sym_fail_stmt] = STATE(5),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(5),
    [anon_sym_RBRACE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_exec] = ACTIONS(19),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_emit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(41),
    [anon_sym_fail] = ACTIONS(43),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [3] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(6),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(6),
    [sym_assign_stmt] = STATE(6),
    [sym_if_stmt] = STATE(6),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(6),
    [sym__directive_stmt] = STATE(6),
    [sym_exec_stmt] = STATE(6),
    [sym_emit_stmt] = STATE(6),
    [sym_return_stmt] = STATE(6),
    [sym_fail_stmt] = STATE(6),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(6),
    [anon_sym_RBRACE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_exec] = ACTIONS(19),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_emit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(41),
    [anon_sym_fail] = ACTIONS(43),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [4] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(2),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(2),
    [sym_assign_stmt] = STATE(2),
    [sym_if_stmt] = STATE(2),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(2),
    [sym__directive_stmt] = STATE(2),
    [sym_exec_stmt] = STATE(2),
    [sym_emit_stmt] = STATE(2),
    [sym_return_stmt] = STATE(2),
    [sym_fail_stmt] = STATE(2),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(2),
    [anon_sym_RBRACE] = ACTIONS(59),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_exec] = ACTIONS(19),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_emit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(41),
    [anon_sym_fail] = ACTIONS(43),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [5] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(5),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(5),
    [sym_assign_stmt] = STATE(5),
    [sym_if_stmt] = STATE(5),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(5),
    [sym__directive_stmt] = STATE(5),
    [sym_exec_stmt] = STATE(5),
    [sym_emit_stmt] = STATE(5),
    [sym_return_stmt] = STATE(5),
    [sym_fail_stmt] = STATE(5),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(5),
    [anon_sym_RBRACE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(63),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(66),
    [anon_sym_LPAREN] = ACTIONS(69),
    [anon_sym_exec] = ACTIONS(72),
    [anon_sym_query] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(78),
    [anon_sym_DASH] = ACTIONS(81),
    [anon_sym_BANG] = ACTIONS(84),
    [sym_unit_val] = ACTIONS(87),
    [sym_string_val] = ACTIONS(87),
    [sym_integer_val] = ACTIONS(90),
    [sym_decimal_val] = ACTIONS(87),
    [anon_sym_true] = ACTIONS(90),
    [anon_sym_false] = ACTIONS(90),
    [sym_none_val] = ACTIONS(90),
    [anon_sym_let] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(96),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_emit] = ACTIONS(102),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_fail] = ACTIONS(108),
    [sym_type_name] = ACTIONS(111),
    [sym_ident] = ACTIONS(90),
    [anon_sym_bool] = ACTIONS(114),
    [anon_sym_i8] = ACTIONS(114),
    [anon_sym_i16] = ACTIONS(114),
    [anon_sym_i32] = ACTIONS(114),
    [anon_sym_i64] = ACTIONS(114),
    [anon_sym_i128] = ACTIONS(114),
    [anon_sym_u8] = ACTIONS(114),
    [anon_sym_u16] = ACTIONS(114),
    [anon_sym_u32] = ACTIONS(114),
    [anon_sym_u64] = ACTIONS(114),
    [anon_sym_u128] = ACTIONS(114),
    [anon_sym_byte] = ACTIONS(114),
    [anon_sym_struct] = ACTIONS(117),
    [anon_sym_enum] = ACTIONS(120),
    [anon_sym_type] = ACTIONS(123),
    [sym_infer_type] = ACTIONS(126),
  },
  [6] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(5),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(5),
    [sym_assign_stmt] = STATE(5),
    [sym_if_stmt] = STATE(5),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(5),
    [sym__directive_stmt] = STATE(5),
    [sym_exec_stmt] = STATE(5),
    [sym_emit_stmt] = STATE(5),
    [sym_return_stmt] = STATE(5),
    [sym_fail_stmt] = STATE(5),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(5),
    [anon_sym_RBRACE] = ACTIONS(129),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_exec] = ACTIONS(19),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_emit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(41),
    [anon_sym_fail] = ACTIONS(43),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [7] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(8),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(8),
    [sym_assign_stmt] = STATE(8),
    [sym_if_stmt] = STATE(8),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(8),
    [sym__directive_stmt] = STATE(8),
    [sym_exec_stmt] = STATE(8),
    [sym_emit_stmt] = STATE(8),
    [sym_return_stmt] = STATE(8),
    [sym_fail_stmt] = STATE(8),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(8),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_exec] = ACTIONS(19),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_emit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(41),
    [anon_sym_fail] = ACTIONS(43),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [8] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym__stmt] = STATE(5),
    [sym_expr] = STATE(48),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_let_stmt] = STATE(5),
    [sym_assign_stmt] = STATE(5),
    [sym_if_stmt] = STATE(5),
    [sym_if_clause] = STATE(85),
    [sym_for_stmt] = STATE(5),
    [sym__directive_stmt] = STATE(5),
    [sym_exec_stmt] = STATE(5),
    [sym_emit_stmt] = STATE(5),
    [sym_return_stmt] = STATE(5),
    [sym_fail_stmt] = STATE(5),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [aux_sym_fn_body_repeat1] = STATE(5),
    [anon_sym_RBRACE] = ACTIONS(133),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_exec] = ACTIONS(19),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_emit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(41),
    [anon_sym_fail] = ACTIONS(43),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [9] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(154),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym_named_arg] = STATE(489),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_RPAREN] = ACTIONS(137),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(151),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [10] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(152),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym_named_arg] = STATE(473),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_RPAREN] = ACTIONS(153),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(151),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [11] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(151),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_RPAREN] = ACTIONS(155),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [12] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(210),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(294),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [13] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(212),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(294),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [14] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(187),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_RPAREN] = ACTIONS(159),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [15] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(175),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_RBRACK] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [16] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(153),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_RBRACK] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [17] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(194),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [18] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(143),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [19] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(213),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [20] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(56),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [21] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(57),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [22] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(82),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [23] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(145),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [24] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(144),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [25] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(51),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [26] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(205),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [27] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(206),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [28] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(135),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [29] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(54),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [30] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(84),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [31] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(55),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [32] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(207),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [33] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(211),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [34] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(49),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [35] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(79),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [36] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(52),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [37] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(136),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [38] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(50),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [39] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(141),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [40] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(142),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [41] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(137),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [42] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(81),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [43] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(80),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [44] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(139),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [45] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(53),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [46] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(208),
    [sym_grouped_expr] = STATE(150),
    [sym_member_access_expr] = STATE(150),
    [sym_table_lookup_expr] = STATE(150),
    [sym_unary_neg_expr] = STATE(150),
    [sym_unary_not_expr] = STATE(150),
    [sym_mult_div_mod_expr] = STATE(150),
    [sym_add_sub_expr] = STATE(150),
    [sym_comparison_expr] = STATE(150),
    [sym_equality_expr] = STATE(150),
    [sym_and_expr] = STATE(150),
    [sym_or_expr] = STATE(150),
    [sym_query_expr] = STATE(150),
    [sym__fn_call_expr] = STATE(150),
    [sym_pos_args_fn_call_expr] = STATE(150),
    [sym_named_args_fn_call_expr] = STATE(150),
    [sym__val] = STATE(150),
    [sym_struct_val] = STATE(150),
    [sym_tuple_struct_val] = STATE(150),
    [sym_vec_val] = STATE(150),
    [sym__bool_val] = STATE(150),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(382),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_query] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(145),
    [sym_unit_val] = ACTIONS(147),
    [sym_string_val] = ACTIONS(147),
    [sym_integer_val] = ACTIONS(149),
    [sym_decimal_val] = ACTIONS(147),
    [anon_sym_true] = ACTIONS(149),
    [anon_sym_false] = ACTIONS(149),
    [sym_none_val] = ACTIONS(149),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(149),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
  [47] = {
    [sym_cwspec] = STATE(436),
    [sym_cwspec_line] = STATE(286),
    [sym_cwspec_block] = STATE(286),
    [sym_expr] = STATE(83),
    [sym_grouped_expr] = STATE(67),
    [sym_member_access_expr] = STATE(67),
    [sym_table_lookup_expr] = STATE(67),
    [sym_unary_neg_expr] = STATE(67),
    [sym_unary_not_expr] = STATE(67),
    [sym_mult_div_mod_expr] = STATE(67),
    [sym_add_sub_expr] = STATE(67),
    [sym_comparison_expr] = STATE(67),
    [sym_equality_expr] = STATE(67),
    [sym_and_expr] = STATE(67),
    [sym_or_expr] = STATE(67),
    [sym_query_expr] = STATE(67),
    [sym__fn_call_expr] = STATE(67),
    [sym_pos_args_fn_call_expr] = STATE(67),
    [sym_named_args_fn_call_expr] = STATE(67),
    [sym__val] = STATE(67),
    [sym_struct_val] = STATE(67),
    [sym_tuple_struct_val] = STATE(67),
    [sym_vec_val] = STATE(67),
    [sym__bool_val] = STATE(67),
    [sym_builtin_type] = STATE(201),
    [sym_tuple_type] = STATE(201),
    [sym_short_option_type] = STATE(201),
    [sym_short_vec_type] = STATE(201),
    [sym__type_defn] = STATE(201),
    [sym_struct_defn] = STATE(201),
    [sym_enum_defn] = STATE(201),
    [sym_type_alias_defn] = STATE(201),
    [sym_type_expr] = STATE(390),
    [sym_type_path] = STATE(201),
    [aux_sym_cwspec_line_repeat1] = STATE(226),
    [aux_sym_cwspec_block_repeat1] = STATE(228),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [anon_sym_SLASH_STAR_STAR] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_query] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [sym_unit_val] = ACTIONS(29),
    [sym_string_val] = ACTIONS(29),
    [sym_integer_val] = ACTIONS(31),
    [sym_decimal_val] = ACTIONS(29),
    [anon_sym_true] = ACTIONS(31),
    [anon_sym_false] = ACTIONS(31),
    [sym_none_val] = ACTIONS(31),
    [sym_type_name] = ACTIONS(45),
    [sym_ident] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(47),
    [anon_sym_i8] = ACTIONS(47),
    [anon_sym_i16] = ACTIONS(47),
    [anon_sym_i32] = ACTIONS(47),
    [anon_sym_i64] = ACTIONS(47),
    [anon_sym_i128] = ACTIONS(47),
    [anon_sym_u8] = ACTIONS(47),
    [anon_sym_u16] = ACTIONS(47),
    [anon_sym_u32] = ACTIONS(47),
    [anon_sym_u64] = ACTIONS(47),
    [anon_sym_u128] = ACTIONS(47),
    [anon_sym_byte] = ACTIONS(47),
    [anon_sym_struct] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(51),
    [anon_sym_type] = ACTIONS(53),
    [sym_infer_type] = ACTIONS(55),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 17,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_EQ,
    STATE(42), 1,
      sym_assign_op,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(177), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(191), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(165), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(171), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [97] = 14,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(177), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(193), 12,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(195), 31,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [187] = 13,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(177), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(197), 12,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(199), 32,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [275] = 11,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(177), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(201), 14,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(203), 33,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [359] = 12,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(177), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(205), 12,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(207), 33,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [445] = 7,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(209), 16,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(211), 40,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [521] = 7,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(213), 16,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(215), 40,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [597] = 7,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(217), 16,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(219), 40,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [673] = 8,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(221), 16,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(223), 37,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [751] = 9,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(177), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(167), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(225), 16,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(227), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [831] = 2,
    ACTIONS(229), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(231), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [895] = 2,
    ACTIONS(233), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(235), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [959] = 2,
    ACTIONS(237), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(239), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1023] = 2,
    ACTIONS(241), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(243), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1087] = 2,
    ACTIONS(245), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(247), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1151] = 2,
    ACTIONS(249), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(251), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1215] = 2,
    ACTIONS(253), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(255), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1279] = 2,
    ACTIONS(257), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(259), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1343] = 2,
    ACTIONS(261), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(263), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1407] = 2,
    ACTIONS(265), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(267), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1471] = 2,
    ACTIONS(269), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(271), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1535] = 2,
    ACTIONS(273), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(275), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1599] = 2,
    ACTIONS(277), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(279), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1663] = 2,
    ACTIONS(281), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(283), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1727] = 2,
    ACTIONS(285), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(287), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1791] = 2,
    ACTIONS(289), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(291), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1855] = 2,
    ACTIONS(293), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(295), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1919] = 2,
    ACTIONS(297), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(299), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [1983] = 2,
    ACTIONS(301), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(303), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2047] = 2,
    ACTIONS(305), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(307), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2111] = 2,
    ACTIONS(309), 18,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
    ACTIONS(311), 41,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2175] = 15,
    ACTIONS(167), 1,
      anon_sym_SLASH,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(319), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(313), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(317), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2261] = 15,
    ACTIONS(167), 1,
      anon_sym_SLASH,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(319), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(321), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(323), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2347] = 15,
    ACTIONS(167), 1,
      anon_sym_SLASH,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(319), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(325), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(327), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2433] = 15,
    ACTIONS(167), 1,
      anon_sym_SLASH,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(319), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(329), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(331), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2519] = 15,
    ACTIONS(167), 1,
      anon_sym_SLASH,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(319), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(335), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2605] = 15,
    ACTIONS(167), 1,
      anon_sym_SLASH,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      anon_sym_DOT,
    ACTIONS(185), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(63), 1,
      sym_named_args,
    STATE(78), 1,
      sym_pos_args,
    ACTIONS(179), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(181), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(183), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(319), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(337), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(339), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2691] = 5,
    ACTIONS(345), 1,
      anon_sym_else,
    STATE(92), 1,
      sym_else_clause,
    STATE(86), 2,
      sym_else_if_clause,
      aux_sym_if_stmt_repeat1,
    ACTIONS(341), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(343), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2746] = 5,
    ACTIONS(345), 1,
      anon_sym_else,
    STATE(93), 1,
      sym_else_clause,
    STATE(87), 2,
      sym_else_if_clause,
      aux_sym_if_stmt_repeat1,
    ACTIONS(347), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(349), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2801] = 4,
    ACTIONS(355), 1,
      anon_sym_else,
    STATE(87), 2,
      sym_else_if_clause,
      aux_sym_if_stmt_repeat1,
    ACTIONS(351), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(353), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2853] = 2,
    ACTIONS(358), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(360), 31,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2899] = 2,
    ACTIONS(362), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(364), 31,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2945] = 2,
    ACTIONS(366), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(368), 31,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [2991] = 2,
    ACTIONS(370), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(372), 31,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3037] = 2,
    ACTIONS(374), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(376), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3082] = 2,
    ACTIONS(378), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(380), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3127] = 2,
    ACTIONS(382), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(384), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3172] = 2,
    ACTIONS(386), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(388), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3217] = 2,
    ACTIONS(358), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(360), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3262] = 2,
    ACTIONS(362), 10,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(364), 30,
      anon_sym_LPAREN,
      anon_sym_exec,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3307] = 18,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(49), 1,
      anon_sym_struct,
    ACTIONS(51), 1,
      anon_sym_enum,
    ACTIONS(53), 1,
      anon_sym_type,
    ACTIONS(55), 1,
      sym_infer_type,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_RPAREN,
    ACTIONS(394), 1,
      sym_ident,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(355), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(446), 1,
      sym_struct_member,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(47), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [3382] = 18,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(49), 1,
      anon_sym_struct,
    ACTIONS(51), 1,
      anon_sym_enum,
    ACTIONS(53), 1,
      anon_sym_type,
    ACTIONS(55), 1,
      sym_infer_type,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      sym_ident,
    ACTIONS(396), 1,
      anon_sym_RPAREN,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(349), 1,
      sym_type_expr,
    STATE(435), 1,
      sym_struct_member,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(47), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [3457] = 18,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(49), 1,
      anon_sym_struct,
    ACTIONS(51), 1,
      anon_sym_enum,
    ACTIONS(53), 1,
      anon_sym_type,
    ACTIONS(55), 1,
      sym_infer_type,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      sym_ident,
    ACTIONS(398), 1,
      anon_sym_RPAREN,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(365), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(494), 1,
      sym_struct_member,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(47), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [3532] = 19,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    ACTIONS(402), 1,
      anon_sym_error,
    ACTIONS(404), 1,
      anon_sym_event,
    ACTIONS(406), 1,
      anon_sym_state,
    ACTIONS(408), 1,
      anon_sym_exec,
    ACTIONS(410), 1,
      anon_sym_query,
    ACTIONS(412), 1,
      anon_sym_instantiate,
    ACTIONS(414), 1,
      anon_sym_migrate,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(289), 1,
      sym_cwspec,
    STATE(108), 2,
      sym_contract_item,
      aux_sym_contract_body_repeat1,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(258), 16,
      sym_error_block,
      sym_event_block,
      sym_state_block,
      sym_exec_block,
      sym_query_block,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
  [3607] = 19,
    ACTIONS(422), 1,
      anon_sym_RBRACE,
    ACTIONS(424), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(427), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(430), 1,
      anon_sym_error,
    ACTIONS(433), 1,
      anon_sym_event,
    ACTIONS(436), 1,
      anon_sym_state,
    ACTIONS(439), 1,
      anon_sym_exec,
    ACTIONS(442), 1,
      anon_sym_query,
    ACTIONS(445), 1,
      anon_sym_instantiate,
    ACTIONS(448), 1,
      anon_sym_migrate,
    ACTIONS(451), 1,
      anon_sym_struct,
    ACTIONS(454), 1,
      anon_sym_enum,
    ACTIONS(457), 1,
      anon_sym_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(289), 1,
      sym_cwspec,
    STATE(102), 2,
      sym_contract_item,
      aux_sym_contract_body_repeat1,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(258), 16,
      sym_error_block,
      sym_event_block,
      sym_state_block,
      sym_exec_block,
      sym_query_block,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
  [3682] = 16,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(49), 1,
      anon_sym_struct,
    ACTIONS(51), 1,
      anon_sym_enum,
    ACTIONS(53), 1,
      anon_sym_type,
    ACTIONS(55), 1,
      sym_infer_type,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      sym_ident,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(430), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(47), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [3751] = 19,
    ACTIONS(462), 1,
      anon_sym_RBRACE,
    ACTIONS(464), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(467), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(470), 1,
      anon_sym_error,
    ACTIONS(473), 1,
      anon_sym_event,
    ACTIONS(476), 1,
      anon_sym_state,
    ACTIONS(479), 1,
      anon_sym_exec,
    ACTIONS(482), 1,
      anon_sym_query,
    ACTIONS(485), 1,
      anon_sym_instantiate,
    ACTIONS(488), 1,
      anon_sym_migrate,
    ACTIONS(491), 1,
      anon_sym_struct,
    ACTIONS(494), 1,
      anon_sym_enum,
    ACTIONS(497), 1,
      anon_sym_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(290), 1,
      sym_cwspec,
    STATE(104), 2,
      sym_interface_item,
      aux_sym_interface_body_repeat1,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(265), 16,
      sym_error_block,
      sym_event_block,
      sym_state_block,
      sym_exec_block,
      sym_query_block,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_decl,
      sym_exec_decl,
      sym_query_decl,
      sym_migrate_decl,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
  [3826] = 16,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(376), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [3895] = 19,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(402), 1,
      anon_sym_error,
    ACTIONS(404), 1,
      anon_sym_event,
    ACTIONS(406), 1,
      anon_sym_state,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(504), 1,
      anon_sym_RBRACE,
    ACTIONS(506), 1,
      anon_sym_exec,
    ACTIONS(508), 1,
      anon_sym_query,
    ACTIONS(510), 1,
      anon_sym_instantiate,
    ACTIONS(512), 1,
      anon_sym_migrate,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(290), 1,
      sym_cwspec,
    STATE(104), 2,
      sym_interface_item,
      aux_sym_interface_body_repeat1,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(265), 16,
      sym_error_block,
      sym_event_block,
      sym_state_block,
      sym_exec_block,
      sym_query_block,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_decl,
      sym_exec_decl,
      sym_query_decl,
      sym_migrate_decl,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
  [3970] = 16,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    ACTIONS(514), 1,
      anon_sym_RPAREN,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(363), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4039] = 19,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(402), 1,
      anon_sym_error,
    ACTIONS(404), 1,
      anon_sym_event,
    ACTIONS(406), 1,
      anon_sym_state,
    ACTIONS(408), 1,
      anon_sym_exec,
    ACTIONS(410), 1,
      anon_sym_query,
    ACTIONS(412), 1,
      anon_sym_instantiate,
    ACTIONS(414), 1,
      anon_sym_migrate,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(516), 1,
      anon_sym_RBRACE,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(289), 1,
      sym_cwspec,
    STATE(102), 2,
      sym_contract_item,
      aux_sym_contract_body_repeat1,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(258), 16,
      sym_error_block,
      sym_event_block,
      sym_state_block,
      sym_exec_block,
      sym_query_block,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
  [4114] = 19,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(402), 1,
      anon_sym_error,
    ACTIONS(404), 1,
      anon_sym_event,
    ACTIONS(406), 1,
      anon_sym_state,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(506), 1,
      anon_sym_exec,
    ACTIONS(508), 1,
      anon_sym_query,
    ACTIONS(510), 1,
      anon_sym_instantiate,
    ACTIONS(512), 1,
      anon_sym_migrate,
    ACTIONS(518), 1,
      anon_sym_RBRACE,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(290), 1,
      sym_cwspec,
    STATE(106), 2,
      sym_interface_item,
      aux_sym_interface_body_repeat1,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(265), 16,
      sym_error_block,
      sym_event_block,
      sym_state_block,
      sym_exec_block,
      sym_query_block,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_decl,
      sym_exec_decl,
      sym_query_decl,
      sym_migrate_decl,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
  [4189] = 16,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    ACTIONS(520), 1,
      anon_sym_RPAREN,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(353), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4258] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      sym_type_name,
    ACTIONS(528), 1,
      anon_sym_struct,
    ACTIONS(530), 1,
      anon_sym_enum,
    ACTIONS(532), 1,
      anon_sym_type,
    ACTIONS(534), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(321), 1,
      sym_type_expr,
    STATE(495), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(310), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(526), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4324] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(220), 1,
      sym_type_expr,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4390] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(219), 1,
      sym_type_expr,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4456] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(409), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4522] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(370), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4588] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(536), 1,
      anon_sym_LPAREN,
    ACTIONS(538), 1,
      sym_type_name,
    ACTIONS(542), 1,
      anon_sym_struct,
    ACTIONS(544), 1,
      anon_sym_enum,
    ACTIONS(546), 1,
      anon_sym_type,
    ACTIONS(548), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(447), 1,
      sym_cwspec,
    STATE(534), 1,
      sym_type_expr,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(531), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(540), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4654] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(189), 1,
      sym_type_expr,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4720] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(536), 1,
      anon_sym_LPAREN,
    ACTIONS(538), 1,
      sym_type_name,
    ACTIONS(542), 1,
      anon_sym_struct,
    ACTIONS(544), 1,
      anon_sym_enum,
    ACTIONS(546), 1,
      anon_sym_type,
    ACTIONS(548), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(447), 1,
      sym_cwspec,
    STATE(546), 1,
      sym_type_expr,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(531), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(540), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4786] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(164), 1,
      sym_type_expr,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4852] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(389), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4918] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      sym_type_name,
    ACTIONS(528), 1,
      anon_sym_struct,
    ACTIONS(530), 1,
      anon_sym_enum,
    ACTIONS(532), 1,
      anon_sym_type,
    ACTIONS(534), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(327), 1,
      sym_type_expr,
    STATE(495), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(310), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(526), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [4984] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      sym_type_name,
    ACTIONS(528), 1,
      anon_sym_struct,
    ACTIONS(530), 1,
      anon_sym_enum,
    ACTIONS(532), 1,
      anon_sym_type,
    ACTIONS(534), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(297), 1,
      sym_type_expr,
    STATE(495), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(310), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(526), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5050] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(421), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5116] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(221), 1,
      sym_type_expr,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5182] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      sym_type_name,
    ACTIONS(528), 1,
      anon_sym_struct,
    ACTIONS(530), 1,
      anon_sym_enum,
    ACTIONS(532), 1,
      anon_sym_type,
    ACTIONS(534), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(344), 1,
      sym_type_expr,
    STATE(495), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(310), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(526), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5248] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(536), 1,
      anon_sym_LPAREN,
    ACTIONS(538), 1,
      sym_type_name,
    ACTIONS(542), 1,
      anon_sym_struct,
    ACTIONS(544), 1,
      anon_sym_enum,
    ACTIONS(546), 1,
      anon_sym_type,
    ACTIONS(548), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(447), 1,
      sym_cwspec,
    STATE(510), 1,
      sym_type_expr,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(531), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(540), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5314] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(422), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5380] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(364), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5446] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(398), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5512] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(407), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5578] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(522), 1,
      anon_sym_LPAREN,
    ACTIONS(524), 1,
      sym_type_name,
    ACTIONS(528), 1,
      anon_sym_struct,
    ACTIONS(530), 1,
      anon_sym_enum,
    ACTIONS(532), 1,
      anon_sym_type,
    ACTIONS(534), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(343), 1,
      sym_type_expr,
    STATE(495), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(310), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(526), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5644] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(222), 1,
      sym_type_expr,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5710] = 15,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(45), 1,
      sym_type_name,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(416), 1,
      anon_sym_struct,
    ACTIONS(418), 1,
      anon_sym_enum,
    ACTIONS(420), 1,
      anon_sym_type,
    ACTIONS(502), 1,
      sym_infer_type,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(415), 1,
      sym_type_expr,
    STATE(436), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(201), 9,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym_type_path,
    ACTIONS(500), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [5776] = 2,
    ACTIONS(550), 9,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(552), 23,
      anon_sym_LPAREN,
      anon_sym_query,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5813] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(193), 5,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [5863] = 7,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(211), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(209), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [5901] = 11,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(205), 7,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_and,
      anon_sym_or,
  [5947] = 3,
    ACTIONS(576), 1,
      anon_sym_COLON_COLON,
    STATE(146), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(574), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [5977] = 12,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(197), 6,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_or,
  [6025] = 3,
    ACTIONS(576), 1,
      anon_sym_COLON_COLON,
    STATE(138), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(578), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6055] = 9,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(227), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(225), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6097] = 10,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(201), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6141] = 8,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(223), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(221), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6181] = 7,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(219), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(217), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6219] = 7,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(215), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(213), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6257] = 3,
    ACTIONS(582), 1,
      anon_sym_COLON_COLON,
    STATE(146), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(580), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6287] = 1,
    ACTIONS(580), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      anon_sym_COLON_COLON,
  [6312] = 1,
    ACTIONS(585), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6336] = 2,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6362] = 2,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(265), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6388] = 15,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(589), 1,
      anon_sym_RPAREN,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    STATE(459), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [6440] = 15,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_RPAREN,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    STATE(465), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [6492] = 15,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(593), 1,
      anon_sym_RBRACK,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    STATE(474), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [6544] = 15,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(595), 1,
      anon_sym_RPAREN,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    STATE(426), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [6596] = 2,
    ACTIONS(255), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(253), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6622] = 2,
    ACTIONS(243), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(241), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6648] = 2,
    ACTIONS(247), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(245), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6674] = 1,
    ACTIONS(597), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6698] = 1,
    ACTIONS(599), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6722] = 2,
    ACTIONS(263), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(261), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6748] = 1,
    ACTIONS(601), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6772] = 1,
    ACTIONS(603), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6796] = 2,
    ACTIONS(295), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(293), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6822] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(605), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_EQ,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6850] = 1,
    ACTIONS(611), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [6874] = 2,
    ACTIONS(291), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(289), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6900] = 2,
    ACTIONS(287), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(285), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6926] = 2,
    ACTIONS(283), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(281), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6952] = 2,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [6978] = 2,
    ACTIONS(259), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(257), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7004] = 2,
    ACTIONS(239), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(237), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7030] = 2,
    ACTIONS(235), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(233), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7056] = 2,
    ACTIONS(307), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(305), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7082] = 2,
    ACTIONS(299), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(297), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7108] = 15,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(613), 1,
      anon_sym_RBRACK,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    STATE(438), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [7160] = 1,
    ACTIONS(615), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7184] = 2,
    ACTIONS(279), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7210] = 2,
    ACTIONS(231), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(229), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7236] = 1,
    ACTIONS(617), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7260] = 1,
    ACTIONS(619), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7284] = 1,
    ACTIONS(621), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7308] = 1,
    ACTIONS(623), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7332] = 1,
    ACTIONS(625), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7356] = 1,
    ACTIONS(627), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7380] = 1,
    ACTIONS(629), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7404] = 1,
    ACTIONS(631), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7428] = 15,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(633), 1,
      anon_sym_RPAREN,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    STATE(434), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [7480] = 1,
    ACTIONS(635), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7504] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(637), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_EQ,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7532] = 1,
    ACTIONS(639), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7556] = 1,
    ACTIONS(641), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7580] = 1,
    ACTIONS(643), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7604] = 1,
    ACTIONS(645), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7628] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(647), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [7676] = 1,
    ACTIONS(649), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7700] = 1,
    ACTIONS(651), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7724] = 2,
    ACTIONS(251), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(249), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7750] = 2,
    ACTIONS(311), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(309), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7776] = 1,
    ACTIONS(653), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7800] = 2,
    ACTIONS(303), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(301), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [7826] = 1,
    ACTIONS(655), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7850] = 1,
    ACTIONS(657), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7874] = 1,
    ACTIONS(659), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7898] = 1,
    ACTIONS(661), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_QMARK,
      anon_sym_EQ,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [7922] = 14,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(663), 1,
      anon_sym_LBRACE,
    STATE(95), 1,
      sym_fn_body,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [7971] = 14,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_LBRACE,
    STATE(91), 1,
      sym_fn_body,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8020] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(667), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8067] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(669), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8114] = 3,
    ACTIONS(673), 1,
      anon_sym_COLON,
    ACTIONS(675), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(671), 16,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
  [8140] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(677), 1,
      anon_sym_RPAREN,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8186] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(679), 1,
      anon_sym_RBRACK,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8232] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(681), 1,
      anon_sym_RPAREN,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8278] = 13,
    ACTIONS(556), 1,
      anon_sym_LPAREN,
    ACTIONS(558), 1,
      anon_sym_LBRACK,
    ACTIONS(560), 1,
      anon_sym_DOT,
    ACTIONS(570), 1,
      anon_sym_and,
    ACTIONS(572), 1,
      anon_sym_or,
    ACTIONS(683), 1,
      anon_sym_RBRACK,
    STATE(197), 1,
      sym_named_args,
    STATE(198), 1,
      sym_pos_args,
    ACTIONS(562), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(564), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(568), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(554), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [8324] = 11,
    ACTIONS(5), 1,
      anon_sym_contract,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(11), 1,
      anon_sym_interface,
    ACTIONS(13), 1,
      anon_sym_import,
    ACTIONS(685), 1,
      ts_builtin_sym_end,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(586), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(215), 7,
      sym__cws_item,
      sym_contract_defn,
      sym_interface_defn,
      sym__import_stmt,
      sym_import_all,
      sym_import_items,
      aux_sym_cwscript_src_repeat1,
  [8365] = 11,
    ACTIONS(687), 1,
      ts_builtin_sym_end,
    ACTIONS(689), 1,
      anon_sym_contract,
    ACTIONS(692), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(695), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(698), 1,
      anon_sym_interface,
    ACTIONS(701), 1,
      anon_sym_import,
    STATE(226), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(228), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(586), 1,
      sym_cwspec,
    STATE(286), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(215), 7,
      sym__cws_item,
      sym_contract_defn,
      sym_interface_defn,
      sym__import_stmt,
      sym_import_all,
      sym_import_items,
      aux_sym_cwscript_src_repeat1,
  [8406] = 1,
    ACTIONS(704), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH_GT,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8424] = 1,
    ACTIONS(706), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH_GT,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8442] = 1,
    ACTIONS(708), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_DASH_GT,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8460] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(710), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8482] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(712), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8504] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(714), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8526] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(716), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8548] = 12,
    ACTIONS(718), 1,
      anon_sym_RBRACE,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(724), 1,
      sym_ident,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(401), 1,
      sym__enum_variant,
    STATE(406), 1,
      sym_cwspec,
    STATE(418), 1,
      sym__enum_variant_struct,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(235), 2,
      sym_error_block_item,
      aux_sym_error_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [8587] = 3,
    ACTIONS(728), 1,
      anon_sym_SLASH_STAR_STAR,
    STATE(224), 1,
      aux_sym_cwspec_block_repeat1,
    ACTIONS(726), 12,
      anon_sym_contract,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8608] = 10,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(731), 1,
      anon_sym_RBRACE,
    ACTIONS(733), 1,
      sym_ident,
    STATE(417), 1,
      sym_cwspec,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(236), 2,
      sym_state_block_item,
      aux_sym_state_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(412), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [8643] = 3,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(237), 1,
      aux_sym_cwspec_line_repeat1,
    ACTIONS(735), 12,
      anon_sym_contract,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8664] = 12,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(724), 1,
      sym_ident,
    ACTIONS(737), 1,
      anon_sym_RBRACE,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(391), 1,
      sym__enum_variant,
    STATE(395), 1,
      sym_cwspec,
    STATE(418), 1,
      sym__enum_variant_struct,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(230), 2,
      sym_event_block_item,
      aux_sym_event_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [8703] = 3,
    ACTIONS(9), 1,
      anon_sym_SLASH_STAR_STAR,
    STATE(224), 1,
      aux_sym_cwspec_block_repeat1,
    ACTIONS(739), 12,
      anon_sym_contract,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8724] = 2,
    ACTIONS(743), 1,
      anon_sym_DASH_GT,
    ACTIONS(741), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8743] = 12,
    ACTIONS(745), 1,
      anon_sym_RBRACE,
    ACTIONS(747), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(750), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(753), 1,
      sym_ident,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(391), 1,
      sym__enum_variant,
    STATE(395), 1,
      sym_cwspec,
    STATE(418), 1,
      sym__enum_variant_struct,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(230), 2,
      sym_event_block_item,
      aux_sym_event_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [8782] = 12,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(724), 1,
      sym_ident,
    ACTIONS(756), 1,
      anon_sym_RBRACE,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(401), 1,
      sym__enum_variant,
    STATE(406), 1,
      sym_cwspec,
    STATE(418), 1,
      sym__enum_variant_struct,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(223), 2,
      sym_error_block_item,
      aux_sym_error_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [8821] = 1,
    ACTIONS(758), 14,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_COMMA,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8838] = 1,
    ACTIONS(760), 14,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_COMMA,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8855] = 12,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(724), 1,
      sym_ident,
    ACTIONS(762), 1,
      anon_sym_RBRACE,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(391), 1,
      sym__enum_variant,
    STATE(395), 1,
      sym_cwspec,
    STATE(418), 1,
      sym__enum_variant_struct,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(227), 2,
      sym_event_block_item,
      aux_sym_event_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [8894] = 12,
    ACTIONS(764), 1,
      anon_sym_RBRACE,
    ACTIONS(766), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(769), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(772), 1,
      sym_ident,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(401), 1,
      sym__enum_variant,
    STATE(406), 1,
      sym_cwspec,
    STATE(418), 1,
      sym__enum_variant_struct,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(235), 2,
      sym_error_block_item,
      aux_sym_error_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [8933] = 10,
    ACTIONS(775), 1,
      anon_sym_RBRACE,
    ACTIONS(777), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(780), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(783), 1,
      sym_ident,
    STATE(417), 1,
      sym_cwspec,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(236), 2,
      sym_state_block_item,
      aux_sym_state_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(412), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [8968] = 3,
    ACTIONS(788), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(237), 1,
      aux_sym_cwspec_line_repeat1,
    ACTIONS(786), 12,
      anon_sym_contract,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [8989] = 2,
    ACTIONS(793), 1,
      anon_sym_DASH_GT,
    ACTIONS(791), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9008] = 10,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(733), 1,
      sym_ident,
    ACTIONS(795), 1,
      anon_sym_RBRACE,
    STATE(417), 1,
      sym_cwspec,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(225), 2,
      sym_state_block_item,
      aux_sym_state_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
    STATE(412), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [9043] = 1,
    ACTIONS(797), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9059] = 1,
    ACTIONS(799), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9075] = 1,
    ACTIONS(801), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9091] = 1,
    ACTIONS(803), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9107] = 1,
    ACTIONS(805), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9123] = 1,
    ACTIONS(786), 13,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9139] = 1,
    ACTIONS(807), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9155] = 1,
    ACTIONS(362), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9171] = 1,
    ACTIONS(809), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9187] = 1,
    ACTIONS(811), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9203] = 1,
    ACTIONS(813), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9219] = 1,
    ACTIONS(815), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9235] = 1,
    ACTIONS(817), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9251] = 1,
    ACTIONS(819), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9267] = 1,
    ACTIONS(821), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9283] = 1,
    ACTIONS(823), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9299] = 1,
    ACTIONS(825), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9315] = 1,
    ACTIONS(827), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9331] = 1,
    ACTIONS(829), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9347] = 1,
    ACTIONS(831), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9363] = 1,
    ACTIONS(833), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9379] = 1,
    ACTIONS(835), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9395] = 1,
    ACTIONS(837), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9411] = 1,
    ACTIONS(839), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9427] = 1,
    ACTIONS(841), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9443] = 1,
    ACTIONS(843), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9459] = 1,
    ACTIONS(845), 13,
      anon_sym_contract,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9475] = 1,
    ACTIONS(847), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9491] = 1,
    ACTIONS(849), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9507] = 1,
    ACTIONS(851), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9523] = 1,
    ACTIONS(853), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9539] = 1,
    ACTIONS(855), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9555] = 1,
    ACTIONS(857), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9571] = 1,
    ACTIONS(859), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9587] = 1,
    ACTIONS(861), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9603] = 1,
    ACTIONS(863), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9619] = 1,
    ACTIONS(358), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9635] = 1,
    ACTIONS(865), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9651] = 1,
    ACTIONS(867), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9667] = 1,
    ACTIONS(869), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9683] = 1,
    ACTIONS(871), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9699] = 1,
    ACTIONS(873), 13,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9715] = 10,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(875), 1,
      anon_sym_RBRACE,
    ACTIONS(877), 1,
      sym_ident,
    STATE(408), 1,
      sym__named_fn_decl,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(604), 1,
      sym_cwspec,
    STATE(284), 2,
      sym_exec_block_item,
      aux_sym_exec_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [9748] = 10,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(877), 1,
      sym_ident,
    ACTIONS(879), 1,
      anon_sym_RBRACE,
    STATE(404), 1,
      sym__named_fn_decl,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(601), 1,
      sym_cwspec,
    STATE(288), 2,
      sym_query_block_item,
      aux_sym_query_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [9781] = 10,
    ACTIONS(881), 1,
      anon_sym_RBRACE,
    ACTIONS(883), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(886), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(889), 1,
      sym_ident,
    STATE(408), 1,
      sym__named_fn_decl,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(604), 1,
      sym_cwspec,
    STATE(284), 2,
      sym_exec_block_item,
      aux_sym_exec_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [9814] = 10,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(877), 1,
      sym_ident,
    ACTIONS(892), 1,
      anon_sym_RBRACE,
    STATE(408), 1,
      sym__named_fn_decl,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(604), 1,
      sym_cwspec,
    STATE(282), 2,
      sym_exec_block_item,
      aux_sym_exec_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [9847] = 1,
    ACTIONS(894), 12,
      anon_sym_contract,
      anon_sym_interface,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
  [9862] = 10,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(877), 1,
      sym_ident,
    ACTIONS(896), 1,
      anon_sym_RBRACE,
    STATE(404), 1,
      sym__named_fn_decl,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(601), 1,
      sym_cwspec,
    STATE(283), 2,
      sym_query_block_item,
      aux_sym_query_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [9895] = 10,
    ACTIONS(898), 1,
      anon_sym_RBRACE,
    ACTIONS(900), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(906), 1,
      sym_ident,
    STATE(404), 1,
      sym__named_fn_decl,
    STATE(449), 1,
      aux_sym_cwspec_line_repeat1,
    STATE(450), 1,
      aux_sym_cwspec_block_repeat1,
    STATE(601), 1,
      sym_cwspec,
    STATE(288), 2,
      sym_query_block_item,
      aux_sym_query_block_repeat1,
    STATE(629), 2,
      sym_cwspec_line,
      sym_cwspec_block,
  [9928] = 10,
    ACTIONS(909), 1,
      anon_sym_error,
    ACTIONS(911), 1,
      anon_sym_event,
    ACTIONS(913), 1,
      anon_sym_state,
    ACTIONS(915), 1,
      anon_sym_exec,
    ACTIONS(917), 1,
      anon_sym_query,
    ACTIONS(919), 1,
      anon_sym_instantiate,
    ACTIONS(921), 1,
      anon_sym_migrate,
    ACTIONS(923), 1,
      anon_sym_struct,
    ACTIONS(925), 1,
      anon_sym_enum,
    ACTIONS(927), 1,
      anon_sym_type,
  [9959] = 10,
    ACTIONS(909), 1,
      anon_sym_error,
    ACTIONS(911), 1,
      anon_sym_event,
    ACTIONS(913), 1,
      anon_sym_state,
    ACTIONS(923), 1,
      anon_sym_struct,
    ACTIONS(925), 1,
      anon_sym_enum,
    ACTIONS(927), 1,
      anon_sym_type,
    ACTIONS(929), 1,
      anon_sym_exec,
    ACTIONS(931), 1,
      anon_sym_query,
    ACTIONS(933), 1,
      anon_sym_instantiate,
    ACTIONS(935), 1,
      anon_sym_migrate,
  [9990] = 3,
    ACTIONS(937), 1,
      anon_sym_COLON_COLON,
    STATE(291), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(580), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10005] = 3,
    ACTIONS(940), 1,
      anon_sym_COLON_COLON,
    STATE(291), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(574), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10020] = 3,
    ACTIONS(940), 1,
      anon_sym_COLON_COLON,
    STATE(292), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(578), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10035] = 7,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_LPAREN,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(948), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10057] = 1,
    ACTIONS(580), 7,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
      anon_sym_COLON_COLON,
  [10067] = 1,
    ACTIONS(597), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10076] = 3,
    ACTIONS(950), 1,
      anon_sym_QMARK,
    ACTIONS(952), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(716), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [10089] = 1,
    ACTIONS(639), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10098] = 1,
    ACTIONS(954), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10107] = 1,
    ACTIONS(956), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10116] = 1,
    ACTIONS(651), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10125] = 1,
    ACTIONS(958), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10134] = 1,
    ACTIONS(643), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10143] = 1,
    ACTIONS(645), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10152] = 1,
    ACTIONS(615), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10161] = 1,
    ACTIONS(629), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10170] = 1,
    ACTIONS(960), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10179] = 1,
    ACTIONS(962), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10188] = 1,
    ACTIONS(631), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10197] = 1,
    ACTIONS(655), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10206] = 1,
    ACTIONS(964), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10215] = 1,
    ACTIONS(966), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10224] = 1,
    ACTIONS(653), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10233] = 1,
    ACTIONS(659), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10242] = 1,
    ACTIONS(968), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10251] = 1,
    ACTIONS(970), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10260] = 1,
    ACTIONS(972), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10269] = 1,
    ACTIONS(974), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10278] = 1,
    ACTIONS(657), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10287] = 1,
    ACTIONS(641), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10296] = 3,
    ACTIONS(950), 1,
      anon_sym_QMARK,
    ACTIONS(952), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(637), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [10309] = 1,
    ACTIONS(661), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10318] = 1,
    ACTIONS(599), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10327] = 1,
    ACTIONS(976), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10336] = 1,
    ACTIONS(635), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10345] = 1,
    ACTIONS(978), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10354] = 3,
    ACTIONS(950), 1,
      anon_sym_QMARK,
    ACTIONS(952), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(714), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [10367] = 1,
    ACTIONS(980), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10376] = 1,
    ACTIONS(982), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10385] = 1,
    ACTIONS(984), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10394] = 1,
    ACTIONS(649), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10403] = 1,
    ACTIONS(585), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10412] = 1,
    ACTIONS(625), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10421] = 1,
    ACTIONS(611), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10430] = 1,
    ACTIONS(623), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10439] = 1,
    ACTIONS(601), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10448] = 1,
    ACTIONS(603), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10457] = 1,
    ACTIONS(619), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10466] = 1,
    ACTIONS(986), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10475] = 1,
    ACTIONS(988), 6,
      ts_builtin_sym_end,
      anon_sym_contract,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_interface,
      anon_sym_import,
  [10484] = 1,
    ACTIONS(621), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10493] = 1,
    ACTIONS(627), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10502] = 3,
    ACTIONS(950), 1,
      anon_sym_QMARK,
    ACTIONS(952), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(605), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [10515] = 3,
    ACTIONS(950), 1,
      anon_sym_QMARK,
    ACTIONS(952), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(712), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [10528] = 1,
    ACTIONS(617), 6,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_QMARK,
      sym_ident,
      anon_sym_LBRACK_RBRACK,
  [10537] = 5,
    ACTIONS(990), 1,
      anon_sym_RBRACE,
    ACTIONS(992), 1,
      sym_ident,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [10553] = 3,
    ACTIONS(994), 1,
      anon_sym_LBRACE,
    ACTIONS(996), 1,
      sym_ident,
    STATE(259), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [10565] = 1,
    ACTIONS(708), 5,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_DASH_GT,
      sym_ident,
  [10573] = 5,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(998), 1,
      anon_sym_RPAREN,
    STATE(481), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10589] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1000), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [10605] = 3,
    ACTIONS(1004), 1,
      anon_sym_COMMA,
    STATE(351), 1,
      aux_sym_ident_list_repeat1,
    ACTIONS(1002), 3,
      anon_sym_implements,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [10617] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1007), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [10633] = 5,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1009), 1,
      anon_sym_RPAREN,
    STATE(425), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10649] = 1,
    ACTIONS(704), 5,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_DASH_GT,
      sym_ident,
  [10657] = 5,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1011), 1,
      anon_sym_RPAREN,
    STATE(431), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10673] = 5,
    ACTIONS(1013), 1,
      anon_sym_STAR,
    ACTIONS(1015), 1,
      anon_sym_LPAREN,
    ACTIONS(1017), 1,
      sym_ident,
    STATE(484), 1,
      sym_import_item,
    STATE(619), 1,
      sym_import_list,
  [10689] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(445), 1,
      sym__enum_variant,
  [10705] = 2,
    ACTIONS(1021), 1,
      anon_sym_DASH_GT,
    ACTIONS(791), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [10715] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1023), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(521), 1,
      sym__enum_variant,
  [10731] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1025), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [10747] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1027), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [10763] = 1,
    ACTIONS(706), 5,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      anon_sym_DASH_GT,
      sym_ident,
  [10771] = 5,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1029), 1,
      anon_sym_RPAREN,
    STATE(475), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10787] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1031), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10799] = 5,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1033), 1,
      anon_sym_RPAREN,
    STATE(485), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10815] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1035), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(492), 1,
      sym__enum_variant,
  [10831] = 3,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    ACTIONS(1039), 1,
      sym_ident,
    STATE(630), 3,
      sym__bindings,
      sym_ident_binding,
      sym_struct_unpack_binding,
  [10843] = 3,
    ACTIONS(1041), 1,
      anon_sym_COLON_COLON,
    STATE(368), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(580), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [10855] = 3,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    ACTIONS(1044), 1,
      sym_ident,
    STATE(610), 3,
      sym__bindings,
      sym_ident_binding,
      sym_struct_unpack_binding,
  [10867] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1046), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10879] = 3,
    ACTIONS(1048), 1,
      anon_sym_COLON_COLON,
    STATE(368), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(574), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [10891] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1050), 1,
      anon_sym_RBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [10907] = 3,
    ACTIONS(1048), 1,
      anon_sym_COLON_COLON,
    STATE(371), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(578), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [10919] = 3,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    STATE(351), 1,
      aux_sym_ident_list_repeat1,
    ACTIONS(1052), 3,
      anon_sym_implements,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [10931] = 3,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    STATE(374), 1,
      aux_sym_ident_list_repeat1,
    ACTIONS(1056), 3,
      anon_sym_implements,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [10943] = 5,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(948), 1,
      anon_sym_RPAREN,
    STATE(539), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [10959] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1058), 1,
      anon_sym_LBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(267), 1,
      sym__enum_variant,
  [10975] = 5,
    ACTIONS(992), 1,
      sym_ident,
    ACTIONS(1060), 1,
      anon_sym_LBRACE,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(262), 1,
      sym__enum_variant,
  [10991] = 3,
    ACTIONS(1062), 1,
      anon_sym_COLON,
    ACTIONS(1064), 1,
      anon_sym_LBRACK,
    STATE(410), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11002] = 2,
    ACTIONS(1068), 1,
      anon_sym_as,
    ACTIONS(1066), 3,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11011] = 3,
    ACTIONS(1072), 1,
      anon_sym_COMMA,
    STATE(381), 1,
      aux_sym_import_list_repeat1,
    ACTIONS(1070), 2,
      anon_sym_from,
      anon_sym_RPAREN,
  [11022] = 4,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(942), 1,
      anon_sym_LBRACE,
    ACTIONS(944), 1,
      anon_sym_LPAREN,
  [11035] = 1,
    ACTIONS(758), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11042] = 4,
    ACTIONS(992), 1,
      sym_ident,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(280), 1,
      sym__enum_variant,
  [11055] = 4,
    ACTIONS(992), 1,
      sym_ident,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(277), 1,
      sym__enum_variant,
  [11068] = 4,
    ACTIONS(663), 1,
      anon_sym_LBRACE,
    ACTIONS(1075), 1,
      anon_sym_if,
    STATE(90), 1,
      sym_if_clause,
    STATE(94), 1,
      sym_fn_body,
  [11081] = 2,
    ACTIONS(996), 1,
      sym_ident,
    STATE(240), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [11090] = 4,
    ACTIONS(1077), 1,
      anon_sym_extends,
    ACTIONS(1079), 1,
      anon_sym_implements,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    STATE(302), 1,
      sym_contract_body,
  [11103] = 4,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1083), 1,
      anon_sym_LBRACE,
    STATE(279), 1,
      sym_fn_body,
  [11116] = 4,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1085), 1,
      anon_sym_LBRACE,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
  [11129] = 1,
    ACTIONS(1089), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11136] = 3,
    ACTIONS(1093), 1,
      anon_sym_COMMA,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
    ACTIONS(1091), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [11147] = 1,
    ACTIONS(580), 4,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
      anon_sym_COLON_COLON,
  [11154] = 3,
    ACTIONS(1096), 1,
      anon_sym_COMMA,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
    ACTIONS(647), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [11165] = 4,
    ACTIONS(724), 1,
      sym_ident,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(413), 1,
      sym__enum_variant,
    STATE(418), 1,
      sym__enum_variant_struct,
  [11178] = 3,
    ACTIONS(1064), 1,
      anon_sym_LBRACK,
    ACTIONS(1099), 1,
      anon_sym_COLON,
    STATE(405), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11189] = 1,
    ACTIONS(1101), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11196] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1103), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11207] = 1,
    ACTIONS(1002), 4,
      anon_sym_implements,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [11214] = 1,
    ACTIONS(1105), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11221] = 1,
    ACTIONS(1107), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11228] = 4,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    ACTIONS(1109), 1,
      anon_sym_extends,
    ACTIONS(1111), 1,
      anon_sym_implements,
    STATE(330), 1,
      sym_contract_body,
  [11241] = 1,
    ACTIONS(1113), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11248] = 1,
    ACTIONS(1115), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11255] = 3,
    ACTIONS(1117), 1,
      anon_sym_COLON,
    ACTIONS(1119), 1,
      anon_sym_LBRACK,
    STATE(405), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11266] = 4,
    ACTIONS(724), 1,
      sym_ident,
    STATE(383), 1,
      sym__enum_variant_tuple,
    STATE(397), 1,
      sym__enum_variant,
    STATE(418), 1,
      sym__enum_variant_struct,
  [11279] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1122), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11290] = 1,
    ACTIONS(1124), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11297] = 4,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1083), 1,
      anon_sym_LBRACE,
    STATE(270), 1,
      sym_fn_body,
  [11310] = 3,
    ACTIONS(1064), 1,
      anon_sym_LBRACK,
    ACTIONS(1126), 1,
      anon_sym_COLON,
    STATE(405), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11321] = 1,
    ACTIONS(1128), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11328] = 1,
    ACTIONS(1130), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11335] = 1,
    ACTIONS(1132), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11342] = 4,
    ACTIONS(992), 1,
      sym_ident,
    STATE(232), 1,
      sym__enum_variant_tuple,
    STATE(233), 1,
      sym__enum_variant_struct,
    STATE(591), 1,
      sym__enum_variant,
  [11355] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1134), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11366] = 3,
    ACTIONS(1064), 1,
      anon_sym_LBRACK,
    ACTIONS(1136), 1,
      anon_sym_COLON,
    STATE(396), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11377] = 2,
    ACTIONS(733), 1,
      sym_ident,
    STATE(411), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [11386] = 1,
    ACTIONS(760), 4,
      anon_sym_RBRACE,
      anon_sym_SLASH_SLASH_SLASH,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [11393] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(229), 1,
      sym_fn_args,
    STATE(249), 1,
      sym__fn_decl,
  [11403] = 3,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1142), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11413] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1144), 1,
      anon_sym_RBRACK,
  [11423] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1146), 1,
      anon_sym_EQ,
  [11433] = 3,
    ACTIONS(1148), 1,
      anon_sym_COMMA,
    ACTIONS(1150), 1,
      anon_sym_RPAREN,
    STATE(536), 1,
      aux_sym_fn_args_repeat1,
  [11443] = 3,
    ACTIONS(1152), 1,
      anon_sym_RBRACE,
    ACTIONS(1154), 1,
      sym_ident,
    STATE(516), 1,
      sym_struct_val_member,
  [11453] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1156), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [11463] = 3,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(1158), 1,
      anon_sym_RPAREN,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
  [11473] = 3,
    ACTIONS(1160), 1,
      anon_sym_RBRACE,
    ACTIONS(1162), 1,
      sym_ident,
    STATE(508), 1,
      sym_struct_member,
  [11483] = 3,
    ACTIONS(1164), 1,
      anon_sym_COMMA,
    ACTIONS(1166), 1,
      anon_sym_RPAREN,
    STATE(440), 1,
      aux_sym_named_args_repeat1,
  [11493] = 3,
    ACTIONS(1168), 1,
      anon_sym_RBRACE,
    ACTIONS(1170), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym_enum_body_repeat1,
  [11503] = 3,
    ACTIONS(607), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1172), 1,
      anon_sym_RBRACK,
  [11513] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1174), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [11523] = 3,
    ACTIONS(1154), 1,
      sym_ident,
    ACTIONS(1176), 1,
      anon_sym_RBRACE,
    STATE(575), 1,
      sym_struct_val_member,
  [11533] = 3,
    ACTIONS(1176), 1,
      anon_sym_RBRACE,
    ACTIONS(1178), 1,
      anon_sym_COMMA,
    STATE(444), 1,
      aux_sym_struct_val_repeat1,
  [11543] = 3,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(1180), 1,
      anon_sym_RPAREN,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
  [11553] = 3,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1182), 1,
      anon_sym_RPAREN,
    STATE(501), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11563] = 3,
    ACTIONS(923), 1,
      anon_sym_struct,
    ACTIONS(925), 1,
      anon_sym_enum,
    ACTIONS(927), 1,
      anon_sym_type,
  [11573] = 3,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1184), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11583] = 3,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(1186), 1,
      anon_sym_RBRACK,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
  [11593] = 3,
    ACTIONS(1188), 1,
      anon_sym_RBRACE,
    ACTIONS(1190), 1,
      anon_sym_COMMA,
    STATE(518), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11603] = 3,
    ACTIONS(1192), 1,
      anon_sym_COMMA,
    ACTIONS(1195), 1,
      anon_sym_RPAREN,
    STATE(440), 1,
      aux_sym_named_args_repeat1,
  [11613] = 3,
    ACTIONS(1197), 1,
      anon_sym_RBRACE,
    ACTIONS(1199), 1,
      anon_sym_COMMA,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11623] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1197), 1,
      anon_sym_RBRACE,
    STATE(508), 1,
      sym_struct_member,
  [11633] = 3,
    ACTIONS(1154), 1,
      sym_ident,
    ACTIONS(1201), 1,
      anon_sym_RBRACE,
    STATE(575), 1,
      sym_struct_val_member,
  [11643] = 3,
    ACTIONS(1203), 1,
      anon_sym_RBRACE,
    ACTIONS(1205), 1,
      anon_sym_COMMA,
    STATE(444), 1,
      aux_sym_struct_val_repeat1,
  [11653] = 3,
    ACTIONS(1208), 1,
      anon_sym_RBRACE,
    ACTIONS(1210), 1,
      anon_sym_COMMA,
    STATE(429), 1,
      aux_sym_enum_body_repeat1,
  [11663] = 3,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1212), 1,
      anon_sym_RPAREN,
    STATE(437), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11673] = 3,
    ACTIONS(1214), 1,
      anon_sym_struct,
    ACTIONS(1216), 1,
      anon_sym_enum,
    ACTIONS(1218), 1,
      anon_sym_type,
  [11683] = 3,
    ACTIONS(1220), 1,
      anon_sym_RBRACE,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    STATE(441), 1,
      aux_sym__enum_variant_struct_repeat1,
  [11693] = 3,
    ACTIONS(720), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(735), 1,
      sym_ident,
    STATE(452), 1,
      aux_sym_cwspec_line_repeat1,
  [11703] = 3,
    ACTIONS(722), 1,
      anon_sym_SLASH_STAR_STAR,
    ACTIONS(739), 1,
      sym_ident,
    STATE(453), 1,
      aux_sym_cwspec_block_repeat1,
  [11713] = 3,
    ACTIONS(1224), 1,
      anon_sym_RBRACE,
    ACTIONS(1226), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym_enum_body_repeat1,
  [11723] = 3,
    ACTIONS(786), 1,
      sym_ident,
    ACTIONS(1228), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(452), 1,
      aux_sym_cwspec_line_repeat1,
  [11733] = 3,
    ACTIONS(726), 1,
      sym_ident,
    ACTIONS(1231), 1,
      anon_sym_SLASH_STAR_STAR,
    STATE(453), 1,
      aux_sym_cwspec_block_repeat1,
  [11743] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1234), 1,
      anon_sym_RBRACE,
    STATE(448), 1,
      sym_struct_member,
  [11753] = 3,
    ACTIONS(1236), 1,
      sym_ident,
    STATE(525), 1,
      sym__enum_variant_struct,
    STATE(526), 1,
      sym__enum_variant_tuple,
  [11763] = 3,
    ACTIONS(1236), 1,
      sym_ident,
    STATE(522), 1,
      sym__enum_variant_struct,
    STATE(523), 1,
      sym__enum_variant_tuple,
  [11773] = 3,
    ACTIONS(1148), 1,
      anon_sym_COMMA,
    ACTIONS(1238), 1,
      anon_sym_RPAREN,
    STATE(423), 1,
      aux_sym_fn_args_repeat1,
  [11783] = 3,
    ACTIONS(1154), 1,
      sym_ident,
    ACTIONS(1240), 1,
      anon_sym_RBRACE,
    STATE(575), 1,
      sym_struct_val_member,
  [11793] = 3,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(1242), 1,
      anon_sym_RPAREN,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
  [11803] = 3,
    ACTIONS(1083), 1,
      anon_sym_LBRACE,
    ACTIONS(1244), 1,
      anon_sym_DASH_GT,
    STATE(281), 1,
      sym_fn_body,
  [11813] = 3,
    ACTIONS(1246), 1,
      anon_sym_RBRACE,
    ACTIONS(1248), 1,
      anon_sym_COMMA,
    STATE(444), 1,
      aux_sym_struct_val_repeat1,
  [11823] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1250), 1,
      anon_sym_RBRACE,
    STATE(439), 1,
      sym_struct_member,
  [11833] = 3,
    ACTIONS(1154), 1,
      sym_ident,
    ACTIONS(1246), 1,
      anon_sym_RBRACE,
    STATE(575), 1,
      sym_struct_val_member,
  [11843] = 3,
    ACTIONS(1164), 1,
      anon_sym_COMMA,
    ACTIONS(1252), 1,
      anon_sym_RPAREN,
    STATE(440), 1,
      aux_sym_named_args_repeat1,
  [11853] = 3,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(1254), 1,
      anon_sym_RPAREN,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
  [11863] = 3,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    ACTIONS(1256), 1,
      anon_sym_implements,
    STATE(329), 1,
      sym_contract_body,
  [11873] = 3,
    ACTIONS(1017), 1,
      sym_ident,
    ACTIONS(1258), 1,
      anon_sym_RPAREN,
    STATE(498), 1,
      sym_import_item,
  [11883] = 3,
    ACTIONS(1260), 1,
      anon_sym_RBRACE,
    ACTIONS(1262), 1,
      anon_sym_COMMA,
    STATE(461), 1,
      aux_sym_struct_val_repeat1,
  [11893] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(229), 1,
      sym_fn_args,
    STATE(253), 1,
      sym__fn_decl,
  [11903] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(229), 1,
      sym_fn_args,
    STATE(255), 1,
      sym__fn_decl,
  [11913] = 3,
    ACTIONS(1264), 1,
      anon_sym_extends,
    ACTIONS(1266), 1,
      anon_sym_LBRACE,
    STATE(308), 1,
      sym_interface_body,
  [11923] = 3,
    ACTIONS(1266), 1,
      anon_sym_LBRACE,
    ACTIONS(1268), 1,
      anon_sym_extends,
    STATE(328), 1,
      sym_interface_body,
  [11933] = 3,
    ACTIONS(1164), 1,
      anon_sym_COMMA,
    ACTIONS(1270), 1,
      anon_sym_RPAREN,
    STATE(464), 1,
      aux_sym_named_args_repeat1,
  [11943] = 3,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(1272), 1,
      anon_sym_RBRACK,
    STATE(394), 1,
      aux_sym_pos_args_repeat1,
  [11953] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1274), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [11963] = 3,
    ACTIONS(992), 1,
      sym_ident,
    STATE(185), 1,
      sym__enum_variant_struct,
    STATE(186), 1,
      sym__enum_variant_tuple,
  [11973] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(269), 1,
      sym__fn_defn,
    STATE(486), 1,
      sym_fn_args,
  [11983] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(271), 1,
      sym__fn_defn,
    STATE(486), 1,
      sym_fn_args,
  [11993] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1276), 1,
      anon_sym_RBRACE,
    STATE(508), 1,
      sym_struct_member,
  [12003] = 3,
    ACTIONS(1278), 1,
      anon_sym_RBRACE,
    ACTIONS(1280), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym_enum_body_repeat1,
  [12013] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1282), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [12023] = 3,
    ACTIONS(1284), 1,
      anon_sym_RBRACE,
    ACTIONS(1286), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym_enum_body_repeat1,
  [12033] = 3,
    ACTIONS(1154), 1,
      sym_ident,
    ACTIONS(1289), 1,
      anon_sym_RBRACE,
    STATE(468), 1,
      sym_struct_val_member,
  [12043] = 3,
    ACTIONS(1291), 1,
      anon_sym_from,
    ACTIONS(1293), 1,
      anon_sym_COMMA,
    STATE(544), 1,
      aux_sym_import_list_repeat1,
  [12053] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1295), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [12063] = 3,
    ACTIONS(1083), 1,
      anon_sym_LBRACE,
    ACTIONS(1297), 1,
      anon_sym_DASH_GT,
    STATE(254), 1,
      sym_fn_body,
  [12073] = 3,
    ACTIONS(1299), 1,
      anon_sym_RPAREN,
    ACTIONS(1301), 1,
      sym_ident,
    STATE(457), 1,
      sym_fn_arg,
  [12083] = 1,
    ACTIONS(653), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12089] = 3,
    ACTIONS(1164), 1,
      anon_sym_COMMA,
    ACTIONS(1303), 1,
      anon_sym_RPAREN,
    STATE(428), 1,
      aux_sym_named_args_repeat1,
  [12099] = 3,
    ACTIONS(1305), 1,
      anon_sym_RBRACE,
    ACTIONS(1307), 1,
      anon_sym_COMMA,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
  [12109] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1305), 1,
      anon_sym_RBRACE,
    STATE(508), 1,
      sym_struct_member,
  [12119] = 3,
    ACTIONS(1309), 1,
      anon_sym_RBRACE,
    ACTIONS(1311), 1,
      anon_sym_COMMA,
    STATE(480), 1,
      aux_sym_enum_body_repeat1,
  [12129] = 3,
    ACTIONS(1148), 1,
      anon_sym_COMMA,
    ACTIONS(1313), 1,
      anon_sym_RPAREN,
    STATE(536), 1,
      aux_sym_fn_args_repeat1,
  [12139] = 3,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1315), 1,
      anon_sym_RPAREN,
    STATE(420), 1,
      aux_sym__enum_variant_struct_repeat1,
  [12149] = 3,
    ACTIONS(1317), 1,
      anon_sym_struct,
    ACTIONS(1319), 1,
      anon_sym_enum,
    ACTIONS(1321), 1,
      anon_sym_type,
  [12159] = 3,
    ACTIONS(1323), 1,
      anon_sym_RBRACE,
    ACTIONS(1325), 1,
      anon_sym_COMMA,
    STATE(490), 1,
      aux_sym__enum_variant_struct_repeat1,
  [12169] = 3,
    ACTIONS(1327), 1,
      anon_sym_COMMA,
    ACTIONS(1329), 1,
      anon_sym_RPAREN,
    STATE(500), 1,
      aux_sym_import_list_repeat1,
  [12179] = 1,
    ACTIONS(1070), 3,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12185] = 1,
    ACTIONS(1331), 3,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12191] = 3,
    ACTIONS(1333), 1,
      anon_sym_COMMA,
    ACTIONS(1335), 1,
      anon_sym_RPAREN,
    STATE(381), 1,
      aux_sym_import_list_repeat1,
  [12201] = 3,
    ACTIONS(1140), 1,
      anon_sym_COMMA,
    ACTIONS(1337), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
  [12211] = 3,
    ACTIONS(1017), 1,
      sym_ident,
    ACTIONS(1335), 1,
      anon_sym_RPAREN,
    STATE(498), 1,
      sym_import_item,
  [12221] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1339), 1,
      anon_sym_RBRACE,
    STATE(508), 1,
      sym_struct_member,
  [12231] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(229), 1,
      sym_fn_args,
    STATE(264), 1,
      sym__fn_decl,
  [12241] = 3,
    ACTIONS(1341), 1,
      anon_sym_LBRACE,
    ACTIONS(1343), 1,
      sym_ident,
    STATE(241), 1,
      sym__named_fn_decl,
  [12251] = 3,
    ACTIONS(1343), 1,
      sym_ident,
    ACTIONS(1345), 1,
      anon_sym_LBRACE,
    STATE(268), 1,
      sym__named_fn_decl,
  [12261] = 3,
    ACTIONS(1148), 1,
      anon_sym_COMMA,
    ACTIONS(1347), 1,
      anon_sym_RPAREN,
    STATE(493), 1,
      aux_sym_fn_args_repeat1,
  [12271] = 1,
    ACTIONS(1091), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12277] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1349), 1,
      anon_sym_RBRACE,
    STATE(496), 1,
      sym_struct_member,
  [12287] = 3,
    ACTIONS(1146), 1,
      anon_sym_in,
    ACTIONS(1351), 1,
      anon_sym_QMARK,
    ACTIONS(1353), 1,
      anon_sym_LBRACK_RBRACK,
  [12297] = 3,
    ACTIONS(992), 1,
      sym_ident,
    STATE(195), 1,
      sym__enum_variant_struct,
    STATE(196), 1,
      sym__enum_variant_tuple,
  [12307] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym__fn_defn,
    STATE(486), 1,
      sym_fn_args,
  [12317] = 3,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(250), 1,
      sym__fn_defn,
    STATE(486), 1,
      sym_fn_args,
  [12327] = 3,
    ACTIONS(1341), 1,
      anon_sym_LBRACE,
    ACTIONS(1355), 1,
      sym_ident,
    STATE(252), 1,
      sym__named_fn_defn,
  [12337] = 3,
    ACTIONS(1345), 1,
      anon_sym_LBRACE,
    ACTIONS(1355), 1,
      sym_ident,
    STATE(256), 1,
      sym__named_fn_defn,
  [12347] = 3,
    ACTIONS(1357), 1,
      anon_sym_RBRACE,
    ACTIONS(1359), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      aux_sym_struct_val_repeat1,
  [12357] = 3,
    ACTIONS(724), 1,
      sym_ident,
    STATE(306), 1,
      sym__enum_variant_struct,
    STATE(309), 1,
      sym__enum_variant_tuple,
  [12367] = 3,
    ACTIONS(1339), 1,
      anon_sym_RBRACE,
    ACTIONS(1361), 1,
      anon_sym_COMMA,
    STATE(392), 1,
      aux_sym__enum_variant_struct_repeat1,
  [12377] = 3,
    ACTIONS(1301), 1,
      sym_ident,
    ACTIONS(1363), 1,
      anon_sym_RPAREN,
    STATE(507), 1,
      sym_fn_arg,
  [12387] = 3,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    ACTIONS(1365), 1,
      anon_sym_implements,
    STATE(324), 1,
      sym_contract_body,
  [12397] = 3,
    ACTIONS(1367), 1,
      anon_sym_RBRACE,
    ACTIONS(1369), 1,
      anon_sym_COMMA,
    STATE(451), 1,
      aux_sym_enum_body_repeat1,
  [12407] = 1,
    ACTIONS(649), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12413] = 1,
    ACTIONS(651), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12419] = 1,
    ACTIONS(615), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12425] = 1,
    ACTIONS(629), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12431] = 1,
    ACTIONS(631), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12437] = 1,
    ACTIONS(661), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12443] = 1,
    ACTIONS(659), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12449] = 3,
    ACTIONS(1103), 1,
      anon_sym_RPAREN,
    ACTIONS(1371), 1,
      anon_sym_COMMA,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [12459] = 1,
    ACTIONS(657), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12465] = 1,
    ACTIONS(655), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12471] = 3,
    ACTIONS(724), 1,
      sym_ident,
    STATE(301), 1,
      sym__enum_variant_tuple,
    STATE(331), 1,
      sym__enum_variant_struct,
  [12481] = 1,
    ACTIONS(585), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12487] = 3,
    ACTIONS(637), 1,
      anon_sym_in,
    ACTIONS(1351), 1,
      anon_sym_QMARK,
    ACTIONS(1353), 1,
      anon_sym_LBRACK_RBRACK,
  [12497] = 1,
    ACTIONS(635), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12503] = 3,
    ACTIONS(1374), 1,
      anon_sym_COMMA,
    ACTIONS(1377), 1,
      anon_sym_RPAREN,
    STATE(536), 1,
      aux_sym_fn_args_repeat1,
  [12513] = 1,
    ACTIONS(627), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12519] = 1,
    ACTIONS(625), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12525] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(1379), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      aux_sym__enum_variant_tuple_repeat1,
  [12535] = 1,
    ACTIONS(623), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12541] = 1,
    ACTIONS(621), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12547] = 1,
    ACTIONS(619), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12553] = 1,
    ACTIONS(617), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12559] = 3,
    ACTIONS(1293), 1,
      anon_sym_COMMA,
    ACTIONS(1381), 1,
      anon_sym_from,
    STATE(381), 1,
      aux_sym_import_list_repeat1,
  [12569] = 1,
    ACTIONS(611), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12575] = 3,
    ACTIONS(605), 1,
      anon_sym_in,
    ACTIONS(1351), 1,
      anon_sym_QMARK,
    ACTIONS(1353), 1,
      anon_sym_LBRACK_RBRACK,
  [12585] = 1,
    ACTIONS(603), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12591] = 1,
    ACTIONS(601), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12597] = 3,
    ACTIONS(1162), 1,
      sym_ident,
    ACTIONS(1383), 1,
      anon_sym_RBRACE,
    STATE(508), 1,
      sym_struct_member,
  [12607] = 1,
    ACTIONS(599), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12613] = 1,
    ACTIONS(597), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12619] = 1,
    ACTIONS(639), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12625] = 1,
    ACTIONS(641), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12631] = 1,
    ACTIONS(643), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12637] = 1,
    ACTIONS(645), 3,
      anon_sym_QMARK,
      anon_sym_in,
      anon_sym_LBRACK_RBRACK,
  [12643] = 2,
    ACTIONS(1355), 1,
      sym_ident,
    STATE(273), 1,
      sym__named_fn_defn,
  [12650] = 1,
    ACTIONS(1377), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12655] = 2,
    ACTIONS(1385), 1,
      anon_sym_LBRACE,
    ACTIONS(1387), 1,
      anon_sym_LPAREN,
  [12662] = 2,
    ACTIONS(1301), 1,
      sym_ident,
    STATE(557), 1,
      sym_fn_arg,
  [12669] = 1,
    ACTIONS(1389), 2,
      anon_sym_EQ,
      anon_sym_in,
  [12674] = 2,
    ACTIONS(1343), 1,
      sym_ident,
    STATE(261), 1,
      sym__named_fn_decl,
  [12681] = 2,
    ACTIONS(1391), 1,
      anon_sym_LBRACE,
    STATE(305), 1,
      sym_enum_body,
  [12688] = 2,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    STATE(326), 1,
      sym_contract_body,
  [12695] = 2,
    ACTIONS(1393), 1,
      anon_sym_LPAREN,
    STATE(358), 1,
      sym_fn_args,
  [12702] = 2,
    ACTIONS(1395), 1,
      anon_sym_LBRACE,
    ACTIONS(1397), 1,
      anon_sym_LPAREN,
  [12709] = 2,
    ACTIONS(1017), 1,
      sym_ident,
    STATE(498), 1,
      sym_import_item,
  [12716] = 1,
    ACTIONS(1399), 2,
      anon_sym_COLON,
      anon_sym_LBRACK,
  [12721] = 2,
    ACTIONS(1401), 1,
      sym_ident,
    STATE(572), 1,
      sym_named_arg,
  [12728] = 2,
    ACTIONS(1075), 1,
      anon_sym_if,
    STATE(90), 1,
      sym_if_clause,
  [12735] = 2,
    ACTIONS(1162), 1,
      sym_ident,
    STATE(508), 1,
      sym_struct_member,
  [12742] = 2,
    ACTIONS(1266), 1,
      anon_sym_LBRACE,
    STATE(315), 1,
      sym_interface_body,
  [12749] = 1,
    ACTIONS(1195), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12754] = 2,
    ACTIONS(1391), 1,
      anon_sym_LBRACE,
    STATE(325), 1,
      sym_enum_body,
  [12761] = 2,
    ACTIONS(1403), 1,
      anon_sym_COLON,
    ACTIONS(1405), 1,
      anon_sym_QMARK,
  [12768] = 1,
    ACTIONS(1203), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [12773] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(587), 1,
      sym_ident_list,
  [12780] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(466), 1,
      sym_ident_list,
  [12787] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(609), 1,
      sym_ident_list,
  [12794] = 2,
    ACTIONS(1154), 1,
      sym_ident,
    STATE(575), 1,
      sym_struct_val_member,
  [12801] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(606), 1,
      sym_ident_list,
  [12808] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(571), 1,
      sym_ident_list,
  [12815] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(563), 1,
      sym_ident_list,
  [12822] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(520), 1,
      sym_ident_list,
  [12829] = 1,
    ACTIONS(786), 2,
      anon_sym_SLASH_SLASH_SLASH,
      sym_ident,
  [12834] = 2,
    ACTIONS(1409), 1,
      anon_sym_LBRACE,
    STATE(535), 1,
      sym_enum_body,
  [12841] = 2,
    ACTIONS(1411), 1,
      anon_sym_contract,
    ACTIONS(1413), 1,
      anon_sym_interface,
  [12848] = 2,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    STATE(316), 1,
      sym_contract_body,
  [12855] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(605), 1,
      sym_ident_list,
  [12862] = 2,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    ACTIONS(1417), 1,
      anon_sym_LPAREN,
  [12869] = 1,
    ACTIONS(845), 2,
      anon_sym_SLASH_STAR_STAR,
      sym_ident,
  [12874] = 1,
    ACTIONS(1419), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [12879] = 2,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(460), 1,
      sym_fn_args,
  [12886] = 2,
    ACTIONS(1421), 1,
      anon_sym_LBRACE,
    STATE(176), 1,
      sym_enum_body,
  [12893] = 2,
    ACTIONS(1421), 1,
      anon_sym_LBRACE,
    STATE(188), 1,
      sym_enum_body,
  [12900] = 2,
    ACTIONS(1423), 1,
      anon_sym_COLON,
    ACTIONS(1425), 1,
      anon_sym_in,
  [12907] = 2,
    ACTIONS(1425), 1,
      anon_sym_EQ,
    ACTIONS(1427), 1,
      anon_sym_COLON,
  [12914] = 2,
    ACTIONS(1409), 1,
      anon_sym_LBRACE,
    STATE(524), 1,
      sym_enum_body,
  [12921] = 2,
    ACTIONS(1429), 1,
      anon_sym_COLON,
    ACTIONS(1431), 1,
      anon_sym_QMARK,
  [12928] = 2,
    ACTIONS(1017), 1,
      sym_ident,
    STATE(497), 1,
      sym_import_item,
  [12935] = 2,
    ACTIONS(1407), 1,
      sym_ident,
    STATE(631), 1,
      sym_ident_list,
  [12942] = 2,
    ACTIONS(877), 1,
      sym_ident,
    STATE(400), 1,
      sym__named_fn_decl,
  [12949] = 2,
    ACTIONS(1355), 1,
      sym_ident,
    STATE(275), 1,
      sym__named_fn_defn,
  [12956] = 1,
    ACTIONS(1433), 2,
      anon_sym_COLON,
      anon_sym_LBRACK,
  [12961] = 2,
    ACTIONS(877), 1,
      sym_ident,
    STATE(403), 1,
      sym__named_fn_decl,
  [12968] = 2,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    STATE(340), 1,
      sym_contract_body,
  [12975] = 2,
    ACTIONS(1266), 1,
      anon_sym_LBRACE,
    STATE(339), 1,
      sym_interface_body,
  [12982] = 2,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(238), 1,
      sym_fn_args,
  [12989] = 2,
    ACTIONS(1343), 1,
      sym_ident,
    STATE(263), 1,
      sym__named_fn_decl,
  [12996] = 2,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
    STATE(311), 1,
      sym_contract_body,
  [13003] = 1,
    ACTIONS(1435), 1,
      anon_sym_in,
  [13007] = 1,
    ACTIONS(1437), 1,
      anon_sym_from,
  [13011] = 1,
    ACTIONS(1439), 1,
      anon_sym_SLASH,
  [13015] = 1,
    ACTIONS(1441), 1,
      sym_type_name,
  [13019] = 1,
    ACTIONS(1443), 1,
      anon_sym_from,
  [13023] = 1,
    ACTIONS(1445), 1,
      sym_ident,
  [13027] = 1,
    ACTIONS(1447), 1,
      anon_sym_COLON,
  [13031] = 1,
    ACTIONS(1449), 1,
      anon_sym_EQ,
  [13035] = 1,
    ACTIONS(1451), 1,
      sym_ident,
  [13039] = 1,
    ACTIONS(1453), 1,
      anon_sym_from,
  [13043] = 1,
    ACTIONS(1455), 1,
      anon_sym_EQ,
  [13047] = 1,
    ACTIONS(1457), 1,
      sym_ident,
  [13051] = 1,
    ACTIONS(1459), 1,
      sym_ident,
  [13055] = 1,
    ACTIONS(1461), 1,
      sym_ident,
  [13059] = 1,
    ACTIONS(1463), 1,
      ts_builtin_sym_end,
  [13063] = 1,
    ACTIONS(1465), 1,
      sym_ident,
  [13067] = 1,
    ACTIONS(1467), 1,
      anon_sym_EQ,
  [13071] = 1,
    ACTIONS(1469), 1,
      sym_ident,
  [13075] = 1,
    ACTIONS(1471), 1,
      sym_ident,
  [13079] = 1,
    ACTIONS(894), 1,
      sym_ident,
  [13083] = 1,
    ACTIONS(1473), 1,
      anon_sym_EQ,
  [13087] = 1,
    ACTIONS(1475), 1,
      anon_sym_RBRACE,
  [13091] = 1,
    ACTIONS(1477), 1,
      sym_ident,
  [13095] = 1,
    ACTIONS(1479), 1,
      anon_sym_from,
  [13099] = 1,
    ACTIONS(1481), 1,
      sym_string_val,
  [13103] = 1,
    ACTIONS(1483), 1,
      anon_sym_COLON,
  [13107] = 1,
    ACTIONS(1485), 1,
      anon_sym_EQ,
  [13111] = 1,
    ACTIONS(1487), 1,
      sym_ident,
  [13115] = 1,
    ACTIONS(1489), 1,
      anon_sym_from,
  [13119] = 1,
    ACTIONS(673), 1,
      anon_sym_COLON,
  [13123] = 1,
    ACTIONS(1491), 1,
      sym_ident,
  [13127] = 1,
    ACTIONS(1493), 1,
      anon_sym_COLON,
  [13131] = 1,
    ACTIONS(1495), 1,
      sym_type_name,
  [13135] = 1,
    ACTIONS(1497), 1,
      sym_ident,
  [13139] = 1,
    ACTIONS(1499), 1,
      sym_string_val,
  [13143] = 1,
    ACTIONS(1501), 1,
      aux_sym_cwspec_block_token1,
  [13147] = 1,
    ACTIONS(1503), 1,
      sym_ident,
  [13151] = 1,
    ACTIONS(1505), 1,
      anon_sym_COLON,
  [13155] = 1,
    ACTIONS(1507), 1,
      sym_ident,
  [13159] = 1,
    ACTIONS(1509), 1,
      anon_sym_EQ,
  [13163] = 1,
    ACTIONS(1511), 1,
      sym_ident,
  [13167] = 1,
    ACTIONS(1513), 1,
      sym_type_name,
  [13171] = 1,
    ACTIONS(1515), 1,
      aux_sym_cwspec_block_token1,
  [13175] = 1,
    ACTIONS(1517), 1,
      anon_sym_SLASH,
  [13179] = 1,
    ACTIONS(1519), 1,
      aux_sym_cwspec_line_token1,
  [13183] = 1,
    ACTIONS(1521), 1,
      sym_ident,
  [13187] = 1,
    ACTIONS(1523), 1,
      aux_sym_cwspec_line_token1,
  [13191] = 1,
    ACTIONS(1525), 1,
      anon_sym_EQ,
  [13195] = 1,
    ACTIONS(1527), 1,
      sym_ident,
  [13199] = 1,
    ACTIONS(1529), 1,
      sym_type_name,
  [13203] = 1,
    ACTIONS(1531), 1,
      sym_type_name,
  [13207] = 1,
    ACTIONS(1533), 1,
      sym_type_name,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(48)] = 0,
  [SMALL_STATE(49)] = 97,
  [SMALL_STATE(50)] = 187,
  [SMALL_STATE(51)] = 275,
  [SMALL_STATE(52)] = 359,
  [SMALL_STATE(53)] = 445,
  [SMALL_STATE(54)] = 521,
  [SMALL_STATE(55)] = 597,
  [SMALL_STATE(56)] = 673,
  [SMALL_STATE(57)] = 751,
  [SMALL_STATE(58)] = 831,
  [SMALL_STATE(59)] = 895,
  [SMALL_STATE(60)] = 959,
  [SMALL_STATE(61)] = 1023,
  [SMALL_STATE(62)] = 1087,
  [SMALL_STATE(63)] = 1151,
  [SMALL_STATE(64)] = 1215,
  [SMALL_STATE(65)] = 1279,
  [SMALL_STATE(66)] = 1343,
  [SMALL_STATE(67)] = 1407,
  [SMALL_STATE(68)] = 1471,
  [SMALL_STATE(69)] = 1535,
  [SMALL_STATE(70)] = 1599,
  [SMALL_STATE(71)] = 1663,
  [SMALL_STATE(72)] = 1727,
  [SMALL_STATE(73)] = 1791,
  [SMALL_STATE(74)] = 1855,
  [SMALL_STATE(75)] = 1919,
  [SMALL_STATE(76)] = 1983,
  [SMALL_STATE(77)] = 2047,
  [SMALL_STATE(78)] = 2111,
  [SMALL_STATE(79)] = 2175,
  [SMALL_STATE(80)] = 2261,
  [SMALL_STATE(81)] = 2347,
  [SMALL_STATE(82)] = 2433,
  [SMALL_STATE(83)] = 2519,
  [SMALL_STATE(84)] = 2605,
  [SMALL_STATE(85)] = 2691,
  [SMALL_STATE(86)] = 2746,
  [SMALL_STATE(87)] = 2801,
  [SMALL_STATE(88)] = 2853,
  [SMALL_STATE(89)] = 2899,
  [SMALL_STATE(90)] = 2945,
  [SMALL_STATE(91)] = 2991,
  [SMALL_STATE(92)] = 3037,
  [SMALL_STATE(93)] = 3082,
  [SMALL_STATE(94)] = 3127,
  [SMALL_STATE(95)] = 3172,
  [SMALL_STATE(96)] = 3217,
  [SMALL_STATE(97)] = 3262,
  [SMALL_STATE(98)] = 3307,
  [SMALL_STATE(99)] = 3382,
  [SMALL_STATE(100)] = 3457,
  [SMALL_STATE(101)] = 3532,
  [SMALL_STATE(102)] = 3607,
  [SMALL_STATE(103)] = 3682,
  [SMALL_STATE(104)] = 3751,
  [SMALL_STATE(105)] = 3826,
  [SMALL_STATE(106)] = 3895,
  [SMALL_STATE(107)] = 3970,
  [SMALL_STATE(108)] = 4039,
  [SMALL_STATE(109)] = 4114,
  [SMALL_STATE(110)] = 4189,
  [SMALL_STATE(111)] = 4258,
  [SMALL_STATE(112)] = 4324,
  [SMALL_STATE(113)] = 4390,
  [SMALL_STATE(114)] = 4456,
  [SMALL_STATE(115)] = 4522,
  [SMALL_STATE(116)] = 4588,
  [SMALL_STATE(117)] = 4654,
  [SMALL_STATE(118)] = 4720,
  [SMALL_STATE(119)] = 4786,
  [SMALL_STATE(120)] = 4852,
  [SMALL_STATE(121)] = 4918,
  [SMALL_STATE(122)] = 4984,
  [SMALL_STATE(123)] = 5050,
  [SMALL_STATE(124)] = 5116,
  [SMALL_STATE(125)] = 5182,
  [SMALL_STATE(126)] = 5248,
  [SMALL_STATE(127)] = 5314,
  [SMALL_STATE(128)] = 5380,
  [SMALL_STATE(129)] = 5446,
  [SMALL_STATE(130)] = 5512,
  [SMALL_STATE(131)] = 5578,
  [SMALL_STATE(132)] = 5644,
  [SMALL_STATE(133)] = 5710,
  [SMALL_STATE(134)] = 5776,
  [SMALL_STATE(135)] = 5813,
  [SMALL_STATE(136)] = 5863,
  [SMALL_STATE(137)] = 5901,
  [SMALL_STATE(138)] = 5947,
  [SMALL_STATE(139)] = 5977,
  [SMALL_STATE(140)] = 6025,
  [SMALL_STATE(141)] = 6055,
  [SMALL_STATE(142)] = 6097,
  [SMALL_STATE(143)] = 6141,
  [SMALL_STATE(144)] = 6181,
  [SMALL_STATE(145)] = 6219,
  [SMALL_STATE(146)] = 6257,
  [SMALL_STATE(147)] = 6287,
  [SMALL_STATE(148)] = 6312,
  [SMALL_STATE(149)] = 6336,
  [SMALL_STATE(150)] = 6362,
  [SMALL_STATE(151)] = 6388,
  [SMALL_STATE(152)] = 6440,
  [SMALL_STATE(153)] = 6492,
  [SMALL_STATE(154)] = 6544,
  [SMALL_STATE(155)] = 6596,
  [SMALL_STATE(156)] = 6622,
  [SMALL_STATE(157)] = 6648,
  [SMALL_STATE(158)] = 6674,
  [SMALL_STATE(159)] = 6698,
  [SMALL_STATE(160)] = 6722,
  [SMALL_STATE(161)] = 6748,
  [SMALL_STATE(162)] = 6772,
  [SMALL_STATE(163)] = 6796,
  [SMALL_STATE(164)] = 6822,
  [SMALL_STATE(165)] = 6850,
  [SMALL_STATE(166)] = 6874,
  [SMALL_STATE(167)] = 6900,
  [SMALL_STATE(168)] = 6926,
  [SMALL_STATE(169)] = 6952,
  [SMALL_STATE(170)] = 6978,
  [SMALL_STATE(171)] = 7004,
  [SMALL_STATE(172)] = 7030,
  [SMALL_STATE(173)] = 7056,
  [SMALL_STATE(174)] = 7082,
  [SMALL_STATE(175)] = 7108,
  [SMALL_STATE(176)] = 7160,
  [SMALL_STATE(177)] = 7184,
  [SMALL_STATE(178)] = 7210,
  [SMALL_STATE(179)] = 7236,
  [SMALL_STATE(180)] = 7260,
  [SMALL_STATE(181)] = 7284,
  [SMALL_STATE(182)] = 7308,
  [SMALL_STATE(183)] = 7332,
  [SMALL_STATE(184)] = 7356,
  [SMALL_STATE(185)] = 7380,
  [SMALL_STATE(186)] = 7404,
  [SMALL_STATE(187)] = 7428,
  [SMALL_STATE(188)] = 7480,
  [SMALL_STATE(189)] = 7504,
  [SMALL_STATE(190)] = 7532,
  [SMALL_STATE(191)] = 7556,
  [SMALL_STATE(192)] = 7580,
  [SMALL_STATE(193)] = 7604,
  [SMALL_STATE(194)] = 7628,
  [SMALL_STATE(195)] = 7676,
  [SMALL_STATE(196)] = 7700,
  [SMALL_STATE(197)] = 7724,
  [SMALL_STATE(198)] = 7750,
  [SMALL_STATE(199)] = 7776,
  [SMALL_STATE(200)] = 7800,
  [SMALL_STATE(201)] = 7826,
  [SMALL_STATE(202)] = 7850,
  [SMALL_STATE(203)] = 7874,
  [SMALL_STATE(204)] = 7898,
  [SMALL_STATE(205)] = 7922,
  [SMALL_STATE(206)] = 7971,
  [SMALL_STATE(207)] = 8020,
  [SMALL_STATE(208)] = 8067,
  [SMALL_STATE(209)] = 8114,
  [SMALL_STATE(210)] = 8140,
  [SMALL_STATE(211)] = 8186,
  [SMALL_STATE(212)] = 8232,
  [SMALL_STATE(213)] = 8278,
  [SMALL_STATE(214)] = 8324,
  [SMALL_STATE(215)] = 8365,
  [SMALL_STATE(216)] = 8406,
  [SMALL_STATE(217)] = 8424,
  [SMALL_STATE(218)] = 8442,
  [SMALL_STATE(219)] = 8460,
  [SMALL_STATE(220)] = 8482,
  [SMALL_STATE(221)] = 8504,
  [SMALL_STATE(222)] = 8526,
  [SMALL_STATE(223)] = 8548,
  [SMALL_STATE(224)] = 8587,
  [SMALL_STATE(225)] = 8608,
  [SMALL_STATE(226)] = 8643,
  [SMALL_STATE(227)] = 8664,
  [SMALL_STATE(228)] = 8703,
  [SMALL_STATE(229)] = 8724,
  [SMALL_STATE(230)] = 8743,
  [SMALL_STATE(231)] = 8782,
  [SMALL_STATE(232)] = 8821,
  [SMALL_STATE(233)] = 8838,
  [SMALL_STATE(234)] = 8855,
  [SMALL_STATE(235)] = 8894,
  [SMALL_STATE(236)] = 8933,
  [SMALL_STATE(237)] = 8968,
  [SMALL_STATE(238)] = 8989,
  [SMALL_STATE(239)] = 9008,
  [SMALL_STATE(240)] = 9043,
  [SMALL_STATE(241)] = 9059,
  [SMALL_STATE(242)] = 9075,
  [SMALL_STATE(243)] = 9091,
  [SMALL_STATE(244)] = 9107,
  [SMALL_STATE(245)] = 9123,
  [SMALL_STATE(246)] = 9139,
  [SMALL_STATE(247)] = 9155,
  [SMALL_STATE(248)] = 9171,
  [SMALL_STATE(249)] = 9187,
  [SMALL_STATE(250)] = 9203,
  [SMALL_STATE(251)] = 9219,
  [SMALL_STATE(252)] = 9235,
  [SMALL_STATE(253)] = 9251,
  [SMALL_STATE(254)] = 9267,
  [SMALL_STATE(255)] = 9283,
  [SMALL_STATE(256)] = 9299,
  [SMALL_STATE(257)] = 9315,
  [SMALL_STATE(258)] = 9331,
  [SMALL_STATE(259)] = 9347,
  [SMALL_STATE(260)] = 9363,
  [SMALL_STATE(261)] = 9379,
  [SMALL_STATE(262)] = 9395,
  [SMALL_STATE(263)] = 9411,
  [SMALL_STATE(264)] = 9427,
  [SMALL_STATE(265)] = 9443,
  [SMALL_STATE(266)] = 9459,
  [SMALL_STATE(267)] = 9475,
  [SMALL_STATE(268)] = 9491,
  [SMALL_STATE(269)] = 9507,
  [SMALL_STATE(270)] = 9523,
  [SMALL_STATE(271)] = 9539,
  [SMALL_STATE(272)] = 9555,
  [SMALL_STATE(273)] = 9571,
  [SMALL_STATE(274)] = 9587,
  [SMALL_STATE(275)] = 9603,
  [SMALL_STATE(276)] = 9619,
  [SMALL_STATE(277)] = 9635,
  [SMALL_STATE(278)] = 9651,
  [SMALL_STATE(279)] = 9667,
  [SMALL_STATE(280)] = 9683,
  [SMALL_STATE(281)] = 9699,
  [SMALL_STATE(282)] = 9715,
  [SMALL_STATE(283)] = 9748,
  [SMALL_STATE(284)] = 9781,
  [SMALL_STATE(285)] = 9814,
  [SMALL_STATE(286)] = 9847,
  [SMALL_STATE(287)] = 9862,
  [SMALL_STATE(288)] = 9895,
  [SMALL_STATE(289)] = 9928,
  [SMALL_STATE(290)] = 9959,
  [SMALL_STATE(291)] = 9990,
  [SMALL_STATE(292)] = 10005,
  [SMALL_STATE(293)] = 10020,
  [SMALL_STATE(294)] = 10035,
  [SMALL_STATE(295)] = 10057,
  [SMALL_STATE(296)] = 10067,
  [SMALL_STATE(297)] = 10076,
  [SMALL_STATE(298)] = 10089,
  [SMALL_STATE(299)] = 10098,
  [SMALL_STATE(300)] = 10107,
  [SMALL_STATE(301)] = 10116,
  [SMALL_STATE(302)] = 10125,
  [SMALL_STATE(303)] = 10134,
  [SMALL_STATE(304)] = 10143,
  [SMALL_STATE(305)] = 10152,
  [SMALL_STATE(306)] = 10161,
  [SMALL_STATE(307)] = 10170,
  [SMALL_STATE(308)] = 10179,
  [SMALL_STATE(309)] = 10188,
  [SMALL_STATE(310)] = 10197,
  [SMALL_STATE(311)] = 10206,
  [SMALL_STATE(312)] = 10215,
  [SMALL_STATE(313)] = 10224,
  [SMALL_STATE(314)] = 10233,
  [SMALL_STATE(315)] = 10242,
  [SMALL_STATE(316)] = 10251,
  [SMALL_STATE(317)] = 10260,
  [SMALL_STATE(318)] = 10269,
  [SMALL_STATE(319)] = 10278,
  [SMALL_STATE(320)] = 10287,
  [SMALL_STATE(321)] = 10296,
  [SMALL_STATE(322)] = 10309,
  [SMALL_STATE(323)] = 10318,
  [SMALL_STATE(324)] = 10327,
  [SMALL_STATE(325)] = 10336,
  [SMALL_STATE(326)] = 10345,
  [SMALL_STATE(327)] = 10354,
  [SMALL_STATE(328)] = 10367,
  [SMALL_STATE(329)] = 10376,
  [SMALL_STATE(330)] = 10385,
  [SMALL_STATE(331)] = 10394,
  [SMALL_STATE(332)] = 10403,
  [SMALL_STATE(333)] = 10412,
  [SMALL_STATE(334)] = 10421,
  [SMALL_STATE(335)] = 10430,
  [SMALL_STATE(336)] = 10439,
  [SMALL_STATE(337)] = 10448,
  [SMALL_STATE(338)] = 10457,
  [SMALL_STATE(339)] = 10466,
  [SMALL_STATE(340)] = 10475,
  [SMALL_STATE(341)] = 10484,
  [SMALL_STATE(342)] = 10493,
  [SMALL_STATE(343)] = 10502,
  [SMALL_STATE(344)] = 10515,
  [SMALL_STATE(345)] = 10528,
  [SMALL_STATE(346)] = 10537,
  [SMALL_STATE(347)] = 10553,
  [SMALL_STATE(348)] = 10565,
  [SMALL_STATE(349)] = 10573,
  [SMALL_STATE(350)] = 10589,
  [SMALL_STATE(351)] = 10605,
  [SMALL_STATE(352)] = 10617,
  [SMALL_STATE(353)] = 10633,
  [SMALL_STATE(354)] = 10649,
  [SMALL_STATE(355)] = 10657,
  [SMALL_STATE(356)] = 10673,
  [SMALL_STATE(357)] = 10689,
  [SMALL_STATE(358)] = 10705,
  [SMALL_STATE(359)] = 10715,
  [SMALL_STATE(360)] = 10731,
  [SMALL_STATE(361)] = 10747,
  [SMALL_STATE(362)] = 10763,
  [SMALL_STATE(363)] = 10771,
  [SMALL_STATE(364)] = 10787,
  [SMALL_STATE(365)] = 10799,
  [SMALL_STATE(366)] = 10815,
  [SMALL_STATE(367)] = 10831,
  [SMALL_STATE(368)] = 10843,
  [SMALL_STATE(369)] = 10855,
  [SMALL_STATE(370)] = 10867,
  [SMALL_STATE(371)] = 10879,
  [SMALL_STATE(372)] = 10891,
  [SMALL_STATE(373)] = 10907,
  [SMALL_STATE(374)] = 10919,
  [SMALL_STATE(375)] = 10931,
  [SMALL_STATE(376)] = 10943,
  [SMALL_STATE(377)] = 10959,
  [SMALL_STATE(378)] = 10975,
  [SMALL_STATE(379)] = 10991,
  [SMALL_STATE(380)] = 11002,
  [SMALL_STATE(381)] = 11011,
  [SMALL_STATE(382)] = 11022,
  [SMALL_STATE(383)] = 11035,
  [SMALL_STATE(384)] = 11042,
  [SMALL_STATE(385)] = 11055,
  [SMALL_STATE(386)] = 11068,
  [SMALL_STATE(387)] = 11081,
  [SMALL_STATE(388)] = 11090,
  [SMALL_STATE(389)] = 11103,
  [SMALL_STATE(390)] = 11116,
  [SMALL_STATE(391)] = 11129,
  [SMALL_STATE(392)] = 11136,
  [SMALL_STATE(393)] = 11147,
  [SMALL_STATE(394)] = 11154,
  [SMALL_STATE(395)] = 11165,
  [SMALL_STATE(396)] = 11178,
  [SMALL_STATE(397)] = 11189,
  [SMALL_STATE(398)] = 11196,
  [SMALL_STATE(399)] = 11207,
  [SMALL_STATE(400)] = 11214,
  [SMALL_STATE(401)] = 11221,
  [SMALL_STATE(402)] = 11228,
  [SMALL_STATE(403)] = 11241,
  [SMALL_STATE(404)] = 11248,
  [SMALL_STATE(405)] = 11255,
  [SMALL_STATE(406)] = 11266,
  [SMALL_STATE(407)] = 11279,
  [SMALL_STATE(408)] = 11290,
  [SMALL_STATE(409)] = 11297,
  [SMALL_STATE(410)] = 11310,
  [SMALL_STATE(411)] = 11321,
  [SMALL_STATE(412)] = 11328,
  [SMALL_STATE(413)] = 11335,
  [SMALL_STATE(414)] = 11342,
  [SMALL_STATE(415)] = 11355,
  [SMALL_STATE(416)] = 11366,
  [SMALL_STATE(417)] = 11377,
  [SMALL_STATE(418)] = 11386,
  [SMALL_STATE(419)] = 11393,
  [SMALL_STATE(420)] = 11403,
  [SMALL_STATE(421)] = 11413,
  [SMALL_STATE(422)] = 11423,
  [SMALL_STATE(423)] = 11433,
  [SMALL_STATE(424)] = 11443,
  [SMALL_STATE(425)] = 11453,
  [SMALL_STATE(426)] = 11463,
  [SMALL_STATE(427)] = 11473,
  [SMALL_STATE(428)] = 11483,
  [SMALL_STATE(429)] = 11493,
  [SMALL_STATE(430)] = 11503,
  [SMALL_STATE(431)] = 11513,
  [SMALL_STATE(432)] = 11523,
  [SMALL_STATE(433)] = 11533,
  [SMALL_STATE(434)] = 11543,
  [SMALL_STATE(435)] = 11553,
  [SMALL_STATE(436)] = 11563,
  [SMALL_STATE(437)] = 11573,
  [SMALL_STATE(438)] = 11583,
  [SMALL_STATE(439)] = 11593,
  [SMALL_STATE(440)] = 11603,
  [SMALL_STATE(441)] = 11613,
  [SMALL_STATE(442)] = 11623,
  [SMALL_STATE(443)] = 11633,
  [SMALL_STATE(444)] = 11643,
  [SMALL_STATE(445)] = 11653,
  [SMALL_STATE(446)] = 11663,
  [SMALL_STATE(447)] = 11673,
  [SMALL_STATE(448)] = 11683,
  [SMALL_STATE(449)] = 11693,
  [SMALL_STATE(450)] = 11703,
  [SMALL_STATE(451)] = 11713,
  [SMALL_STATE(452)] = 11723,
  [SMALL_STATE(453)] = 11733,
  [SMALL_STATE(454)] = 11743,
  [SMALL_STATE(455)] = 11753,
  [SMALL_STATE(456)] = 11763,
  [SMALL_STATE(457)] = 11773,
  [SMALL_STATE(458)] = 11783,
  [SMALL_STATE(459)] = 11793,
  [SMALL_STATE(460)] = 11803,
  [SMALL_STATE(461)] = 11813,
  [SMALL_STATE(462)] = 11823,
  [SMALL_STATE(463)] = 11833,
  [SMALL_STATE(464)] = 11843,
  [SMALL_STATE(465)] = 11853,
  [SMALL_STATE(466)] = 11863,
  [SMALL_STATE(467)] = 11873,
  [SMALL_STATE(468)] = 11883,
  [SMALL_STATE(469)] = 11893,
  [SMALL_STATE(470)] = 11903,
  [SMALL_STATE(471)] = 11913,
  [SMALL_STATE(472)] = 11923,
  [SMALL_STATE(473)] = 11933,
  [SMALL_STATE(474)] = 11943,
  [SMALL_STATE(475)] = 11953,
  [SMALL_STATE(476)] = 11963,
  [SMALL_STATE(477)] = 11973,
  [SMALL_STATE(478)] = 11983,
  [SMALL_STATE(479)] = 11993,
  [SMALL_STATE(480)] = 12003,
  [SMALL_STATE(481)] = 12013,
  [SMALL_STATE(482)] = 12023,
  [SMALL_STATE(483)] = 12033,
  [SMALL_STATE(484)] = 12043,
  [SMALL_STATE(485)] = 12053,
  [SMALL_STATE(486)] = 12063,
  [SMALL_STATE(487)] = 12073,
  [SMALL_STATE(488)] = 12083,
  [SMALL_STATE(489)] = 12089,
  [SMALL_STATE(490)] = 12099,
  [SMALL_STATE(491)] = 12109,
  [SMALL_STATE(492)] = 12119,
  [SMALL_STATE(493)] = 12129,
  [SMALL_STATE(494)] = 12139,
  [SMALL_STATE(495)] = 12149,
  [SMALL_STATE(496)] = 12159,
  [SMALL_STATE(497)] = 12169,
  [SMALL_STATE(498)] = 12179,
  [SMALL_STATE(499)] = 12185,
  [SMALL_STATE(500)] = 12191,
  [SMALL_STATE(501)] = 12201,
  [SMALL_STATE(502)] = 12211,
  [SMALL_STATE(503)] = 12221,
  [SMALL_STATE(504)] = 12231,
  [SMALL_STATE(505)] = 12241,
  [SMALL_STATE(506)] = 12251,
  [SMALL_STATE(507)] = 12261,
  [SMALL_STATE(508)] = 12271,
  [SMALL_STATE(509)] = 12277,
  [SMALL_STATE(510)] = 12287,
  [SMALL_STATE(511)] = 12297,
  [SMALL_STATE(512)] = 12307,
  [SMALL_STATE(513)] = 12317,
  [SMALL_STATE(514)] = 12327,
  [SMALL_STATE(515)] = 12337,
  [SMALL_STATE(516)] = 12347,
  [SMALL_STATE(517)] = 12357,
  [SMALL_STATE(518)] = 12367,
  [SMALL_STATE(519)] = 12377,
  [SMALL_STATE(520)] = 12387,
  [SMALL_STATE(521)] = 12397,
  [SMALL_STATE(522)] = 12407,
  [SMALL_STATE(523)] = 12413,
  [SMALL_STATE(524)] = 12419,
  [SMALL_STATE(525)] = 12425,
  [SMALL_STATE(526)] = 12431,
  [SMALL_STATE(527)] = 12437,
  [SMALL_STATE(528)] = 12443,
  [SMALL_STATE(529)] = 12449,
  [SMALL_STATE(530)] = 12459,
  [SMALL_STATE(531)] = 12465,
  [SMALL_STATE(532)] = 12471,
  [SMALL_STATE(533)] = 12481,
  [SMALL_STATE(534)] = 12487,
  [SMALL_STATE(535)] = 12497,
  [SMALL_STATE(536)] = 12503,
  [SMALL_STATE(537)] = 12513,
  [SMALL_STATE(538)] = 12519,
  [SMALL_STATE(539)] = 12525,
  [SMALL_STATE(540)] = 12535,
  [SMALL_STATE(541)] = 12541,
  [SMALL_STATE(542)] = 12547,
  [SMALL_STATE(543)] = 12553,
  [SMALL_STATE(544)] = 12559,
  [SMALL_STATE(545)] = 12569,
  [SMALL_STATE(546)] = 12575,
  [SMALL_STATE(547)] = 12585,
  [SMALL_STATE(548)] = 12591,
  [SMALL_STATE(549)] = 12597,
  [SMALL_STATE(550)] = 12607,
  [SMALL_STATE(551)] = 12613,
  [SMALL_STATE(552)] = 12619,
  [SMALL_STATE(553)] = 12625,
  [SMALL_STATE(554)] = 12631,
  [SMALL_STATE(555)] = 12637,
  [SMALL_STATE(556)] = 12643,
  [SMALL_STATE(557)] = 12650,
  [SMALL_STATE(558)] = 12655,
  [SMALL_STATE(559)] = 12662,
  [SMALL_STATE(560)] = 12669,
  [SMALL_STATE(561)] = 12674,
  [SMALL_STATE(562)] = 12681,
  [SMALL_STATE(563)] = 12688,
  [SMALL_STATE(564)] = 12695,
  [SMALL_STATE(565)] = 12702,
  [SMALL_STATE(566)] = 12709,
  [SMALL_STATE(567)] = 12716,
  [SMALL_STATE(568)] = 12721,
  [SMALL_STATE(569)] = 12728,
  [SMALL_STATE(570)] = 12735,
  [SMALL_STATE(571)] = 12742,
  [SMALL_STATE(572)] = 12749,
  [SMALL_STATE(573)] = 12754,
  [SMALL_STATE(574)] = 12761,
  [SMALL_STATE(575)] = 12768,
  [SMALL_STATE(576)] = 12773,
  [SMALL_STATE(577)] = 12780,
  [SMALL_STATE(578)] = 12787,
  [SMALL_STATE(579)] = 12794,
  [SMALL_STATE(580)] = 12801,
  [SMALL_STATE(581)] = 12808,
  [SMALL_STATE(582)] = 12815,
  [SMALL_STATE(583)] = 12822,
  [SMALL_STATE(584)] = 12829,
  [SMALL_STATE(585)] = 12834,
  [SMALL_STATE(586)] = 12841,
  [SMALL_STATE(587)] = 12848,
  [SMALL_STATE(588)] = 12855,
  [SMALL_STATE(589)] = 12862,
  [SMALL_STATE(590)] = 12869,
  [SMALL_STATE(591)] = 12874,
  [SMALL_STATE(592)] = 12879,
  [SMALL_STATE(593)] = 12886,
  [SMALL_STATE(594)] = 12893,
  [SMALL_STATE(595)] = 12900,
  [SMALL_STATE(596)] = 12907,
  [SMALL_STATE(597)] = 12914,
  [SMALL_STATE(598)] = 12921,
  [SMALL_STATE(599)] = 12928,
  [SMALL_STATE(600)] = 12935,
  [SMALL_STATE(601)] = 12942,
  [SMALL_STATE(602)] = 12949,
  [SMALL_STATE(603)] = 12956,
  [SMALL_STATE(604)] = 12961,
  [SMALL_STATE(605)] = 12968,
  [SMALL_STATE(606)] = 12975,
  [SMALL_STATE(607)] = 12982,
  [SMALL_STATE(608)] = 12989,
  [SMALL_STATE(609)] = 12996,
  [SMALL_STATE(610)] = 13003,
  [SMALL_STATE(611)] = 13007,
  [SMALL_STATE(612)] = 13011,
  [SMALL_STATE(613)] = 13015,
  [SMALL_STATE(614)] = 13019,
  [SMALL_STATE(615)] = 13023,
  [SMALL_STATE(616)] = 13027,
  [SMALL_STATE(617)] = 13031,
  [SMALL_STATE(618)] = 13035,
  [SMALL_STATE(619)] = 13039,
  [SMALL_STATE(620)] = 13043,
  [SMALL_STATE(621)] = 13047,
  [SMALL_STATE(622)] = 13051,
  [SMALL_STATE(623)] = 13055,
  [SMALL_STATE(624)] = 13059,
  [SMALL_STATE(625)] = 13063,
  [SMALL_STATE(626)] = 13067,
  [SMALL_STATE(627)] = 13071,
  [SMALL_STATE(628)] = 13075,
  [SMALL_STATE(629)] = 13079,
  [SMALL_STATE(630)] = 13083,
  [SMALL_STATE(631)] = 13087,
  [SMALL_STATE(632)] = 13091,
  [SMALL_STATE(633)] = 13095,
  [SMALL_STATE(634)] = 13099,
  [SMALL_STATE(635)] = 13103,
  [SMALL_STATE(636)] = 13107,
  [SMALL_STATE(637)] = 13111,
  [SMALL_STATE(638)] = 13115,
  [SMALL_STATE(639)] = 13119,
  [SMALL_STATE(640)] = 13123,
  [SMALL_STATE(641)] = 13127,
  [SMALL_STATE(642)] = 13131,
  [SMALL_STATE(643)] = 13135,
  [SMALL_STATE(644)] = 13139,
  [SMALL_STATE(645)] = 13143,
  [SMALL_STATE(646)] = 13147,
  [SMALL_STATE(647)] = 13151,
  [SMALL_STATE(648)] = 13155,
  [SMALL_STATE(649)] = 13159,
  [SMALL_STATE(650)] = 13163,
  [SMALL_STATE(651)] = 13167,
  [SMALL_STATE(652)] = 13171,
  [SMALL_STATE(653)] = 13175,
  [SMALL_STATE(654)] = 13179,
  [SMALL_STATE(655)] = 13183,
  [SMALL_STATE(656)] = 13187,
  [SMALL_STATE(657)] = 13191,
  [SMALL_STATE(658)] = 13195,
  [SMALL_STATE(659)] = 13199,
  [SMALL_STATE(660)] = 13203,
  [SMALL_STATE(661)] = 13207,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwscript_src, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(643),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2),
  [63] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(654),
  [66] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(652),
  [69] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(12),
  [72] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(35),
  [75] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(34),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(15),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(31),
  [84] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(29),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(67),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(67),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(367),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(27),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(369),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(43),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(22),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(47),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(140),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(202),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(511),
  [120] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(643),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(642),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(201),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__stmt, 1),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__stmt, 1),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_expr, 2, .production_id = 48),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query_expr, 2, .production_id = 48),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_or_expr, 3, .production_id = 66),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_or_expr, 3, .production_id = 66),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equality_expr, 3, .production_id = 64),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equality_expr, 3, .production_id = 64),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_and_expr, 3, .production_id = 66),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_and_expr, 3, .production_id = 66),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mult_div_mod_expr, 3, .production_id = 64),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mult_div_mod_expr, 3, .production_id = 64),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_not_expr, 2, .production_id = 48),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_not_expr, 2, .production_id = 48),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_neg_expr, 2, .production_id = 48),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_neg_expr, 2, .production_id = 48),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_add_sub_expr, 3, .production_id = 64),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_add_sub_expr, 3, .production_id = 64),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comparison_expr, 3, .production_id = 64),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comparison_expr, 3, .production_id = 64),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouped_expr, 3),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouped_expr, 3),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 3, .production_id = 69),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 3, .production_id = 69),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_val, 4, .production_id = 75),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_val, 4, .production_id = 75),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_struct_val, 5, .production_id = 84),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_struct_val, 5, .production_id = 84),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 5, .production_id = 83),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 5, .production_id = 83),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args_fn_call_expr, 2, .production_id = 50),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args_fn_call_expr, 2, .production_id = 50),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 6, .production_id = 85),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 6, .production_id = 85),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pos_args, 3),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pos_args, 3),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args, 4),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args, 4),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 1),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 1),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args, 3),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args, 3),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_struct_val, 3, .production_id = 69),
  [275] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_struct_val, 3, .production_id = 69),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_val, 3, .production_id = 62),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_val, 3, .production_id = 62),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_lookup_expr, 4, .production_id = 78),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_lookup_expr, 4, .production_id = 78),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 4, .production_id = 79),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 4, .production_id = 79),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_struct_val, 4, .production_id = 80),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_struct_val, 4, .production_id = 80),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pos_args, 4),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pos_args, 4),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args, 2),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args, 2),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_val, 2),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_val, 2),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_access_expr, 3, .production_id = 65),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_access_expr, 3, .production_id = 65),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pos_args_fn_call_expr, 2, .production_id = 50),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pos_args_fn_call_expr, 2, .production_id = 50),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_stmt, 2, .production_id = 48),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exec_stmt, 2, .production_id = 48),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_emit_stmt, 2, .production_id = 48),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_emit_stmt, 2, .production_id = 48),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_stmt, 3, .production_id = 64),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_stmt, 3, .production_id = 64),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_stmt, 2, .production_id = 48),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_stmt, 2, .production_id = 48),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fail_stmt, 2, .production_id = 48),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fail_stmt, 2, .production_id = 48),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_stmt, 4, .production_id = 77),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_stmt, 4, .production_id = 77),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 1, .production_id = 39),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 1, .production_id = 39),
  [345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 2, .production_id = 52),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 2, .production_id = 52),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_stmt_repeat1, 2),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_stmt_repeat1, 2),
  [355] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_stmt_repeat1, 2), SHIFT_REPEAT(569),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_body, 3),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fn_body, 3),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_body, 2),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fn_body, 2),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_clause, 2),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 2),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 63),
  [372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_clause, 3, .production_id = 63),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 2, .production_id = 51),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 2, .production_id = 51),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 3, .production_id = 68),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 3, .production_id = 68),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 2, .production_id = 67),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2, .production_id = 67),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_stmt, 5, .production_id = 81),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_stmt, 5, .production_id = 81),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2),
  [424] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(654),
  [427] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(652),
  [430] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(377),
  [433] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(378),
  [436] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(347),
  [439] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(515),
  [442] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(514),
  [445] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(513),
  [448] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(512),
  [451] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(511),
  [454] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(643),
  [457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_body_repeat1, 2), SHIFT_REPEAT(642),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2),
  [464] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(654),
  [467] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(652),
  [470] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(377),
  [473] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(378),
  [476] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(347),
  [479] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(506),
  [482] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(505),
  [485] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(504),
  [488] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(419),
  [491] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(511),
  [494] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(643),
  [497] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2), SHIFT_REPEAT(642),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [550] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_op, 1),
  [552] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_op, 1),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_path, 2),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_path, 1),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2),
  [582] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2), SHIFT_REPEAT(623),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_tuple, 5, .production_id = 59),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_struct, 5, .production_id = 58),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 3),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_struct, 5, .production_id = 57),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_defn, 5, .production_id = 54),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3, .production_id = 9),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_defn, 3, .production_id = 2),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_vec_type, 2),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_option_type, 2),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_tuple, 4, .production_id = 44),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_struct, 4, .production_id = 43),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 2),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_struct, 4, .production_id = 42),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_defn, 3, .production_id = 26),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_defn, 3, .production_id = 27),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [635] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_defn, 4, .production_id = 6),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_defn, 4, .production_id = 40),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 4, .production_id = 9),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 4, .production_id = 70),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_struct, 6, .production_id = 73),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 4),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pos_args_repeat1, 2),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_defn, 2, .production_id = 14),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_defn, 2, .production_id = 15),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 5, .production_id = 70),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expr, 1),
  [657] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_type, 1),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_tuple, 3, .production_id = 35),
  [661] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant_struct, 3, .production_id = 35),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val_member, 3, .production_id = 82),
  [669] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_arg, 3, .production_id = 82),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__val, 1),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__val, 1),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwscript_src, 1),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2),
  [689] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2), SHIFT_REPEAT(648),
  [692] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2), SHIFT_REPEAT(654),
  [695] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2), SHIFT_REPEAT(652),
  [698] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2), SHIFT_REPEAT(632),
  [701] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2), SHIFT_REPEAT(356),
  [704] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 4),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 2),
  [708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 3),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__fn_decl, 3, .production_id = 41),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_map, 4, .production_id = 46),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_item, 3, .production_id = 36),
  [716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_fn_decl, 4, .production_id = 55),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(645),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cwspec_block_repeat1, 2),
  [728] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwspec_block_repeat1, 2), SHIFT_REPEAT(652),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwspec_line, 1),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwspec_block, 1),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__fn_decl, 1, .production_id = 18),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_event_block_repeat1, 2),
  [747] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_event_block_repeat1, 2), SHIFT_REPEAT(656),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_event_block_repeat1, 2), SHIFT_REPEAT(645),
  [753] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_event_block_repeat1, 2), SHIFT_REPEAT(565),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant, 1, .production_id = 11),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_variant, 1, .production_id = 10),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_error_block_repeat1, 2),
  [766] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_error_block_repeat1, 2), SHIFT_REPEAT(656),
  [769] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_error_block_repeat1, 2), SHIFT_REPEAT(645),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_error_block_repeat1, 2), SHIFT_REPEAT(565),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_state_block_repeat1, 2),
  [777] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_state_block_repeat1, 2), SHIFT_REPEAT(656),
  [780] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_state_block_repeat1, 2), SHIFT_REPEAT(645),
  [783] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_state_block_repeat1, 2), SHIFT_REPEAT(416),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cwspec_line_repeat1, 2),
  [788] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwspec_line_repeat1, 2), SHIFT_REPEAT(654),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_fn_decl, 2, .production_id = 28),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_defn, 3, .production_id = 23),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_decl, 2, .production_id = 16),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_block, 4),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_block, 4),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_block, 4),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_block, 3),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_migrate_defn, 2, .production_id = 13),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_migrate_decl, 2, .production_id = 17),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instantiate_defn, 2, .production_id = 13),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_block, 4),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_defn, 2, .production_id = 12),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_migrate_decl, 3, .production_id = 30),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__fn_defn, 2, .production_id = 21),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instantiate_decl, 3, .production_id = 30),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_defn, 2, .production_id = 12),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_block, 3),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_item, 1),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_defn, 2),
  [833] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_block, 4),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_decl, 3, .production_id = 29),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_defn, 2, .production_id = 9),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_decl, 3, .production_id = 29),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instantiate_decl, 2, .production_id = 17),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_item, 1),
  [845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cwspec_block_repeat1, 3),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_defn, 2, .production_id = 9),
  [849] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_decl, 2, .production_id = 16),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_migrate_defn, 3, .production_id = 25),
  [853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_fn_defn, 5, .production_id = 60),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instantiate_defn, 3, .production_id = 25),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_block, 3),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_defn, 3, .production_id = 24),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_block, 3),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_defn, 3, .production_id = 24),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_defn, 3, .production_id = 22),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_block, 3),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__fn_defn, 4, .production_id = 53),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_defn, 3, .production_id = 22),
  [873] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_fn_defn, 3, .production_id = 38),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_exec_block_repeat1, 2),
  [883] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_exec_block_repeat1, 2), SHIFT_REPEAT(656),
  [886] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_exec_block_repeat1, 2), SHIFT_REPEAT(645),
  [889] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_exec_block_repeat1, 2), SHIFT_REPEAT(564),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwspec, 1),
  [896] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_query_block_repeat1, 2),
  [900] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_block_repeat1, 2), SHIFT_REPEAT(656),
  [903] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_block_repeat1, 2), SHIFT_REPEAT(645),
  [906] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_block_repeat1, 2), SHIFT_REPEAT(564),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [937] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2), SHIFT_REPEAT(621),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_body, 2),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_body, 2),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 4, .production_id = 6),
  [960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_body, 3),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_defn, 4, .production_id = 6),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 6, .production_id = 32),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_body, 3),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_defn, 5, .production_id = 7),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 8, .production_id = 56),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_items, 4, .production_id = 5),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_all, 4, .production_id = 3),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 5, .production_id = 7),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 5, .production_id = 8),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_defn, 3, .production_id = 2),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 6, .production_id = 31),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 3, .production_id = 2),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_defn, 6, .production_id = 31),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 7, .production_id = 33),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_ident_list_repeat1, 2),
  [1004] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ident_list_repeat1, 2), SHIFT_REPEAT(622),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3, .production_id = 47),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1041] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2), SHIFT_REPEAT(637),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 4, .production_id = 72),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_list, 2),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_list, 1),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_item, 1, .production_id = 1),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [1070] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_list_repeat1, 2),
  [1072] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_list_repeat1, 2), SHIFT_REPEAT(566),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1089] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_block_item, 1, .production_id = 19),
  [1091] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__enum_variant_struct_repeat1, 2),
  [1093] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__enum_variant_struct_repeat1, 2), SHIFT_REPEAT(570),
  [1096] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pos_args_repeat1, 2), SHIFT_REPEAT(17),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_block_item, 2, .production_id = 34),
  [1103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__enum_variant_tuple_repeat1, 2),
  [1105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_block_item, 2, .production_id = 37),
  [1107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_block_item, 1, .production_id = 19),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_block_item, 2, .production_id = 37),
  [1115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_block_item, 1, .production_id = 20),
  [1117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_state_map_repeat1, 2),
  [1119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_state_map_repeat1, 2), SHIFT_REPEAT(103),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_arg, 3, .production_id = 47),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_block_item, 1, .production_id = 20),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_block_item, 2, .production_id = 23),
  [1130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_block_item, 1),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_block_item, 2, .production_id = 34),
  [1134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_arg, 4, .production_id = 61),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_binding, 3, .production_id = 76),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_args_repeat1, 2), SHIFT_REPEAT(568),
  [1195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_args_repeat1, 2),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_val_repeat1, 2),
  [1205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_val_repeat1, 2), SHIFT_REPEAT(579),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1228] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwspec_line_repeat1, 2), SHIFT_REPEAT(656),
  [1231] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwspec_block_repeat1, 2), SHIFT_REPEAT(645),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, .production_id = 71),
  [1286] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, .production_id = 71), SHIFT_REPEAT(414),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_list, 1),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_item, 3, .production_id = 4),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1371] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(129),
  [1374] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_args_repeat1, 2), SHIFT_REPEAT(559),
  [1377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fn_args_repeat1, 2),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_list, 2),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_unpack_binding, 3),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_key, 3, .production_id = 45),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, .production_id = 9),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_binding, 1, .production_id = 49),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_key, 5, .production_id = 74),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_list, 4),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(644),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1463] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_list, 5),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_list, 3),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_cwscript(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
