#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 440
#define LARGE_STATE_COUNT 11
#define SYMBOL_COUNT 175
#define ALIAS_COUNT 0
#define TOKEN_COUNT 77
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 27
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 51

enum {
  anon_sym_contract = 1,
  anon_sym_extends = 2,
  anon_sym_implements = 3,
  anon_sym_LBRACE = 4,
  anon_sym_RBRACE = 5,
  anon_sym_error = 6,
  anon_sym_event = 7,
  anon_sym_state = 8,
  anon_sym_exec = 9,
  anon_sym_query = 10,
  anon_sym_COLON = 11,
  anon_sym_LBRACK = 12,
  anon_sym_RBRACK = 13,
  anon_sym_instantiate = 14,
  anon_sym_migrate = 15,
  anon_sym_LPAREN = 16,
  anon_sym_RPAREN = 17,
  anon_sym_DASH_GT = 18,
  anon_sym_DOT = 19,
  anon_sym_DASH = 20,
  anon_sym_BANG = 21,
  anon_sym_STAR = 22,
  anon_sym_SLASH = 23,
  anon_sym_PERCENT = 24,
  anon_sym_PLUS = 25,
  anon_sym_LT = 26,
  anon_sym_GT = 27,
  anon_sym_LT_EQ = 28,
  anon_sym_GT_EQ = 29,
  anon_sym_EQ_EQ = 30,
  anon_sym_BANG_EQ = 31,
  anon_sym_and = 32,
  anon_sym_or = 33,
  anon_sym_COMMA = 34,
  sym_unit_val = 35,
  sym_string_val = 36,
  sym_integer_val = 37,
  sym_decimal_val = 38,
  anon_sym_true = 39,
  anon_sym_false = 40,
  sym_none_val = 41,
  anon_sym_let = 42,
  anon_sym_EQ = 43,
  anon_sym_if = 44,
  anon_sym_else = 45,
  anon_sym_for = 46,
  anon_sym_in = 47,
  anon_sym_emit = 48,
  anon_sym_return = 49,
  anon_sym_fail = 50,
  sym_type_name = 51,
  sym_ident = 52,
  anon_sym_bool = 53,
  anon_sym_i8 = 54,
  anon_sym_i16 = 55,
  anon_sym_i32 = 56,
  anon_sym_i64 = 57,
  anon_sym_i128 = 58,
  anon_sym_u8 = 59,
  anon_sym_u16 = 60,
  anon_sym_u32 = 61,
  anon_sym_u64 = 62,
  anon_sym_u128 = 63,
  anon_sym_byte = 64,
  anon_sym_PLUS_EQ = 65,
  anon_sym_DASH_EQ = 66,
  anon_sym_STAR_EQ = 67,
  anon_sym_SLASH_EQ = 68,
  anon_sym_PERCENT_EQ = 69,
  anon_sym_QMARK = 70,
  anon_sym_LBRACK_RBRACK = 71,
  anon_sym_struct = 72,
  anon_sym_enum = 73,
  anon_sym_type = 74,
  sym_infer_type = 75,
  anon_sym_COLON_COLON = 76,
  sym_cwscript_src = 77,
  sym__cws_item = 78,
  sym_contract_defn = 79,
  sym__contract_item = 80,
  sym_error_defn = 81,
  sym_event_defn = 82,
  sym_state_defn = 83,
  sym__state_defn = 84,
  sym_state_item = 85,
  sym_state_map = 86,
  sym_map_key = 87,
  sym__named_fn_defn = 88,
  sym__fn_defn = 89,
  sym_instantiate_defn = 90,
  sym_exec_defn = 91,
  sym_query_defn = 92,
  sym_migrate_defn = 93,
  sym_fn_args = 94,
  sym_fn_arg = 95,
  sym_fn_return_type = 96,
  sym_fn_body = 97,
  sym__stmt = 98,
  sym__expr = 99,
  sym_grouped_expr = 100,
  sym_member_access_expr = 101,
  sym_table_lookup_expr = 102,
  sym_unary_neg_expr = 103,
  sym_unary_not_expr = 104,
  sym_mult_div_mod_expr = 105,
  sym_add_sub_expr = 106,
  sym_comparison_expr = 107,
  sym_equality_expr = 108,
  sym_and_expr = 109,
  sym_or_expr = 110,
  sym_query_expr = 111,
  sym__fn_call_expr = 112,
  sym_pos_args_fn_call_expr = 113,
  sym_named_args_fn_call_expr = 114,
  sym_named_call_arg = 115,
  sym__val = 116,
  sym_struct_val = 117,
  sym_struct_val_member = 118,
  sym_tuple_struct_val = 119,
  sym_vec_val = 120,
  sym__bool_val = 121,
  sym__bindings = 122,
  sym_ident_binding = 123,
  sym_struct_unpack_binding = 124,
  sym_let_stmt = 125,
  sym_assign_stmt = 126,
  sym_if_stmt = 127,
  sym_if_clause = 128,
  sym_else_if_clause = 129,
  sym_else_clause = 130,
  sym_for_stmt = 131,
  sym__directive_stmt = 132,
  sym_exec_stmt = 133,
  sym_emit_stmt = 134,
  sym_return_stmt = 135,
  sym_fail_stmt = 136,
  sym__enum_variant = 137,
  sym_enum_variant_struct = 138,
  sym_enum_variant_tuple = 139,
  sym_enum_variant_unit = 140,
  sym_builtin_type = 141,
  sym_assign_op = 142,
  sym_ident_list = 143,
  sym_struct_member = 144,
  sym_tuple_type = 145,
  sym_short_option_type = 146,
  sym_short_vec_type = 147,
  sym__type_defn = 148,
  sym_struct_defn = 149,
  sym_struct_body = 150,
  sym_enum_defn = 151,
  sym_enum_body = 152,
  sym_type_alias_defn = 153,
  sym__type_expr = 154,
  sym_type_path = 155,
  aux_sym_cwscript_src_repeat1 = 156,
  aux_sym_contract_defn_repeat1 = 157,
  aux_sym__contract_item_repeat1 = 158,
  aux_sym__contract_item_repeat2 = 159,
  aux_sym__contract_item_repeat3 = 160,
  aux_sym_state_map_repeat1 = 161,
  aux_sym_fn_args_repeat1 = 162,
  aux_sym_fn_body_repeat1 = 163,
  aux_sym_pos_args_fn_call_expr_repeat1 = 164,
  aux_sym_named_args_fn_call_expr_repeat1 = 165,
  aux_sym_struct_val_repeat1 = 166,
  aux_sym_struct_unpack_binding_repeat1 = 167,
  aux_sym_if_stmt_repeat1 = 168,
  aux_sym_enum_variant_struct_repeat1 = 169,
  aux_sym_enum_variant_tuple_repeat1 = 170,
  aux_sym_ident_list_repeat1 = 171,
  aux_sym_tuple_type_repeat1 = 172,
  aux_sym_struct_body_repeat1 = 173,
  aux_sym_type_path_repeat1 = 174,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_contract] = "contract",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_error] = "error",
  [anon_sym_event] = "event",
  [anon_sym_state] = "state",
  [anon_sym_exec] = "exec",
  [anon_sym_query] = "query",
  [anon_sym_COLON] = ":",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_instantiate] = "instantiate",
  [anon_sym_migrate] = "migrate",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS] = "+",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_COMMA] = ",",
  [sym_unit_val] = "unit_val",
  [sym_string_val] = "string_val",
  [sym_integer_val] = "integer_val",
  [sym_decimal_val] = "decimal_val",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_none_val] = "none_val",
  [anon_sym_let] = "let",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_emit] = "emit",
  [anon_sym_return] = "return",
  [anon_sym_fail] = "fail",
  [sym_type_name] = "type_name",
  [sym_ident] = "ident",
  [anon_sym_bool] = "bool",
  [anon_sym_i8] = "i8",
  [anon_sym_i16] = "i16",
  [anon_sym_i32] = "i32",
  [anon_sym_i64] = "i64",
  [anon_sym_i128] = "i128",
  [anon_sym_u8] = "u8",
  [anon_sym_u16] = "u16",
  [anon_sym_u32] = "u32",
  [anon_sym_u64] = "u64",
  [anon_sym_u128] = "u128",
  [anon_sym_byte] = "byte",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_type] = "type",
  [sym_infer_type] = "infer_type",
  [anon_sym_COLON_COLON] = "::",
  [sym_cwscript_src] = "cwscript_src",
  [sym__cws_item] = "_cws_item",
  [sym_contract_defn] = "contract_defn",
  [sym__contract_item] = "_contract_item",
  [sym_error_defn] = "error_defn",
  [sym_event_defn] = "event_defn",
  [sym_state_defn] = "state_defn",
  [sym__state_defn] = "_state_defn",
  [sym_state_item] = "state_item",
  [sym_state_map] = "state_map",
  [sym_map_key] = "map_key",
  [sym__named_fn_defn] = "_named_fn_defn",
  [sym__fn_defn] = "_fn_defn",
  [sym_instantiate_defn] = "instantiate_defn",
  [sym_exec_defn] = "exec_defn",
  [sym_query_defn] = "query_defn",
  [sym_migrate_defn] = "migrate_defn",
  [sym_fn_args] = "fn_args",
  [sym_fn_arg] = "fn_arg",
  [sym_fn_return_type] = "fn_return_type",
  [sym_fn_body] = "fn_body",
  [sym__stmt] = "_stmt",
  [sym__expr] = "_expr",
  [sym_grouped_expr] = "grouped_expr",
  [sym_member_access_expr] = "member_access_expr",
  [sym_table_lookup_expr] = "table_lookup_expr",
  [sym_unary_neg_expr] = "unary_neg_expr",
  [sym_unary_not_expr] = "unary_not_expr",
  [sym_mult_div_mod_expr] = "mult_div_mod_expr",
  [sym_add_sub_expr] = "add_sub_expr",
  [sym_comparison_expr] = "comparison_expr",
  [sym_equality_expr] = "equality_expr",
  [sym_and_expr] = "and_expr",
  [sym_or_expr] = "or_expr",
  [sym_query_expr] = "query_expr",
  [sym__fn_call_expr] = "_fn_call_expr",
  [sym_pos_args_fn_call_expr] = "pos_args_fn_call_expr",
  [sym_named_args_fn_call_expr] = "named_args_fn_call_expr",
  [sym_named_call_arg] = "named_call_arg",
  [sym__val] = "_val",
  [sym_struct_val] = "struct_val",
  [sym_struct_val_member] = "struct_val_member",
  [sym_tuple_struct_val] = "tuple_struct_val",
  [sym_vec_val] = "vec_val",
  [sym__bool_val] = "_bool_val",
  [sym__bindings] = "_bindings",
  [sym_ident_binding] = "ident_binding",
  [sym_struct_unpack_binding] = "struct_unpack_binding",
  [sym_let_stmt] = "let_stmt",
  [sym_assign_stmt] = "assign_stmt",
  [sym_if_stmt] = "if_stmt",
  [sym_if_clause] = "if_clause",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_stmt] = "for_stmt",
  [sym__directive_stmt] = "_directive_stmt",
  [sym_exec_stmt] = "exec_stmt",
  [sym_emit_stmt] = "emit_stmt",
  [sym_return_stmt] = "return_stmt",
  [sym_fail_stmt] = "fail_stmt",
  [sym__enum_variant] = "_enum_variant",
  [sym_enum_variant_struct] = "enum_variant_struct",
  [sym_enum_variant_tuple] = "enum_variant_tuple",
  [sym_enum_variant_unit] = "enum_variant_unit",
  [sym_builtin_type] = "builtin_type",
  [sym_assign_op] = "assign_op",
  [sym_ident_list] = "ident_list",
  [sym_struct_member] = "struct_member",
  [sym_tuple_type] = "tuple_type",
  [sym_short_option_type] = "short_option_type",
  [sym_short_vec_type] = "short_vec_type",
  [sym__type_defn] = "_type_defn",
  [sym_struct_defn] = "struct_defn",
  [sym_struct_body] = "struct_body",
  [sym_enum_defn] = "enum_defn",
  [sym_enum_body] = "enum_body",
  [sym_type_alias_defn] = "type_alias_defn",
  [sym__type_expr] = "_type_expr",
  [sym_type_path] = "type_path",
  [aux_sym_cwscript_src_repeat1] = "cwscript_src_repeat1",
  [aux_sym_contract_defn_repeat1] = "contract_defn_repeat1",
  [aux_sym__contract_item_repeat1] = "_contract_item_repeat1",
  [aux_sym__contract_item_repeat2] = "_contract_item_repeat2",
  [aux_sym__contract_item_repeat3] = "_contract_item_repeat3",
  [aux_sym_state_map_repeat1] = "state_map_repeat1",
  [aux_sym_fn_args_repeat1] = "fn_args_repeat1",
  [aux_sym_fn_body_repeat1] = "fn_body_repeat1",
  [aux_sym_pos_args_fn_call_expr_repeat1] = "pos_args_fn_call_expr_repeat1",
  [aux_sym_named_args_fn_call_expr_repeat1] = "named_args_fn_call_expr_repeat1",
  [aux_sym_struct_val_repeat1] = "struct_val_repeat1",
  [aux_sym_struct_unpack_binding_repeat1] = "struct_unpack_binding_repeat1",
  [aux_sym_if_stmt_repeat1] = "if_stmt_repeat1",
  [aux_sym_enum_variant_struct_repeat1] = "enum_variant_struct_repeat1",
  [aux_sym_enum_variant_tuple_repeat1] = "enum_variant_tuple_repeat1",
  [aux_sym_ident_list_repeat1] = "ident_list_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_struct_body_repeat1] = "struct_body_repeat1",
  [aux_sym_type_path_repeat1] = "type_path_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_state] = anon_sym_state,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_query] = anon_sym_query,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_instantiate] = anon_sym_instantiate,
  [anon_sym_migrate] = anon_sym_migrate,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_unit_val] = sym_unit_val,
  [sym_string_val] = sym_string_val,
  [sym_integer_val] = sym_integer_val,
  [sym_decimal_val] = sym_decimal_val,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_none_val] = sym_none_val,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_emit] = anon_sym_emit,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_fail] = anon_sym_fail,
  [sym_type_name] = sym_type_name,
  [sym_ident] = sym_ident,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_i8] = anon_sym_i8,
  [anon_sym_i16] = anon_sym_i16,
  [anon_sym_i32] = anon_sym_i32,
  [anon_sym_i64] = anon_sym_i64,
  [anon_sym_i128] = anon_sym_i128,
  [anon_sym_u8] = anon_sym_u8,
  [anon_sym_u16] = anon_sym_u16,
  [anon_sym_u32] = anon_sym_u32,
  [anon_sym_u64] = anon_sym_u64,
  [anon_sym_u128] = anon_sym_u128,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_type] = anon_sym_type,
  [sym_infer_type] = sym_infer_type,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_cwscript_src] = sym_cwscript_src,
  [sym__cws_item] = sym__cws_item,
  [sym_contract_defn] = sym_contract_defn,
  [sym__contract_item] = sym__contract_item,
  [sym_error_defn] = sym_error_defn,
  [sym_event_defn] = sym_event_defn,
  [sym_state_defn] = sym_state_defn,
  [sym__state_defn] = sym__state_defn,
  [sym_state_item] = sym_state_item,
  [sym_state_map] = sym_state_map,
  [sym_map_key] = sym_map_key,
  [sym__named_fn_defn] = sym__named_fn_defn,
  [sym__fn_defn] = sym__fn_defn,
  [sym_instantiate_defn] = sym_instantiate_defn,
  [sym_exec_defn] = sym_exec_defn,
  [sym_query_defn] = sym_query_defn,
  [sym_migrate_defn] = sym_migrate_defn,
  [sym_fn_args] = sym_fn_args,
  [sym_fn_arg] = sym_fn_arg,
  [sym_fn_return_type] = sym_fn_return_type,
  [sym_fn_body] = sym_fn_body,
  [sym__stmt] = sym__stmt,
  [sym__expr] = sym__expr,
  [sym_grouped_expr] = sym_grouped_expr,
  [sym_member_access_expr] = sym_member_access_expr,
  [sym_table_lookup_expr] = sym_table_lookup_expr,
  [sym_unary_neg_expr] = sym_unary_neg_expr,
  [sym_unary_not_expr] = sym_unary_not_expr,
  [sym_mult_div_mod_expr] = sym_mult_div_mod_expr,
  [sym_add_sub_expr] = sym_add_sub_expr,
  [sym_comparison_expr] = sym_comparison_expr,
  [sym_equality_expr] = sym_equality_expr,
  [sym_and_expr] = sym_and_expr,
  [sym_or_expr] = sym_or_expr,
  [sym_query_expr] = sym_query_expr,
  [sym__fn_call_expr] = sym__fn_call_expr,
  [sym_pos_args_fn_call_expr] = sym_pos_args_fn_call_expr,
  [sym_named_args_fn_call_expr] = sym_named_args_fn_call_expr,
  [sym_named_call_arg] = sym_named_call_arg,
  [sym__val] = sym__val,
  [sym_struct_val] = sym_struct_val,
  [sym_struct_val_member] = sym_struct_val_member,
  [sym_tuple_struct_val] = sym_tuple_struct_val,
  [sym_vec_val] = sym_vec_val,
  [sym__bool_val] = sym__bool_val,
  [sym__bindings] = sym__bindings,
  [sym_ident_binding] = sym_ident_binding,
  [sym_struct_unpack_binding] = sym_struct_unpack_binding,
  [sym_let_stmt] = sym_let_stmt,
  [sym_assign_stmt] = sym_assign_stmt,
  [sym_if_stmt] = sym_if_stmt,
  [sym_if_clause] = sym_if_clause,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_stmt] = sym_for_stmt,
  [sym__directive_stmt] = sym__directive_stmt,
  [sym_exec_stmt] = sym_exec_stmt,
  [sym_emit_stmt] = sym_emit_stmt,
  [sym_return_stmt] = sym_return_stmt,
  [sym_fail_stmt] = sym_fail_stmt,
  [sym__enum_variant] = sym__enum_variant,
  [sym_enum_variant_struct] = sym_enum_variant_struct,
  [sym_enum_variant_tuple] = sym_enum_variant_tuple,
  [sym_enum_variant_unit] = sym_enum_variant_unit,
  [sym_builtin_type] = sym_builtin_type,
  [sym_assign_op] = sym_assign_op,
  [sym_ident_list] = sym_ident_list,
  [sym_struct_member] = sym_struct_member,
  [sym_tuple_type] = sym_tuple_type,
  [sym_short_option_type] = sym_short_option_type,
  [sym_short_vec_type] = sym_short_vec_type,
  [sym__type_defn] = sym__type_defn,
  [sym_struct_defn] = sym_struct_defn,
  [sym_struct_body] = sym_struct_body,
  [sym_enum_defn] = sym_enum_defn,
  [sym_enum_body] = sym_enum_body,
  [sym_type_alias_defn] = sym_type_alias_defn,
  [sym__type_expr] = sym__type_expr,
  [sym_type_path] = sym_type_path,
  [aux_sym_cwscript_src_repeat1] = aux_sym_cwscript_src_repeat1,
  [aux_sym_contract_defn_repeat1] = aux_sym_contract_defn_repeat1,
  [aux_sym__contract_item_repeat1] = aux_sym__contract_item_repeat1,
  [aux_sym__contract_item_repeat2] = aux_sym__contract_item_repeat2,
  [aux_sym__contract_item_repeat3] = aux_sym__contract_item_repeat3,
  [aux_sym_state_map_repeat1] = aux_sym_state_map_repeat1,
  [aux_sym_fn_args_repeat1] = aux_sym_fn_args_repeat1,
  [aux_sym_fn_body_repeat1] = aux_sym_fn_body_repeat1,
  [aux_sym_pos_args_fn_call_expr_repeat1] = aux_sym_pos_args_fn_call_expr_repeat1,
  [aux_sym_named_args_fn_call_expr_repeat1] = aux_sym_named_args_fn_call_expr_repeat1,
  [aux_sym_struct_val_repeat1] = aux_sym_struct_val_repeat1,
  [aux_sym_struct_unpack_binding_repeat1] = aux_sym_struct_unpack_binding_repeat1,
  [aux_sym_if_stmt_repeat1] = aux_sym_if_stmt_repeat1,
  [aux_sym_enum_variant_struct_repeat1] = aux_sym_enum_variant_struct_repeat1,
  [aux_sym_enum_variant_tuple_repeat1] = aux_sym_enum_variant_tuple_repeat1,
  [aux_sym_ident_list_repeat1] = aux_sym_ident_list_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_struct_body_repeat1] = aux_sym_struct_body_repeat1,
  [aux_sym_type_path_repeat1] = aux_sym_type_path_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_state] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_query] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instantiate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_migrate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_unit_val] = {
    .visible = true,
    .named = true,
  },
  [sym_string_val] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_val] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_val] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_none_val] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_emit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fail] = {
    .visible = true,
    .named = false,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_cwscript_src] = {
    .visible = true,
    .named = true,
  },
  [sym__cws_item] = {
    .visible = false,
    .named = true,
  },
  [sym_contract_defn] = {
    .visible = true,
    .named = true,
  },
  [sym__contract_item] = {
    .visible = false,
    .named = true,
  },
  [sym_error_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_event_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_state_defn] = {
    .visible = true,
    .named = true,
  },
  [sym__state_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_state_item] = {
    .visible = true,
    .named = true,
  },
  [sym_state_map] = {
    .visible = true,
    .named = true,
  },
  [sym_map_key] = {
    .visible = true,
    .named = true,
  },
  [sym__named_fn_defn] = {
    .visible = false,
    .named = true,
  },
  [sym__fn_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_instantiate_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_query_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_migrate_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_args] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_body] = {
    .visible = true,
    .named = true,
  },
  [sym__stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym_grouped_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_member_access_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_table_lookup_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_neg_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_not_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_div_mod_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_add_sub_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_and_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_or_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_query_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__fn_call_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_pos_args_fn_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_named_args_fn_call_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_named_call_arg] = {
    .visible = true,
    .named = true,
  },
  [sym__val] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_val] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_val_member] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_struct_val] = {
    .visible = true,
    .named = true,
  },
  [sym_vec_val] = {
    .visible = true,
    .named = true,
  },
  [sym__bool_val] = {
    .visible = false,
    .named = true,
  },
  [sym__bindings] = {
    .visible = false,
    .named = true,
  },
  [sym_ident_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_unpack_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_let_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_if_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__directive_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_exec_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_emit_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_return_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym_fail_stmt] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_variant] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_variant_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_type] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_op] = {
    .visible = true,
    .named = true,
  },
  [sym_ident_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_short_option_type] = {
    .visible = true,
    .named = true,
  },
  [sym_short_vec_type] = {
    .visible = true,
    .named = true,
  },
  [sym__type_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_defn] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_type_path] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_cwscript_src_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_defn_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__contract_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__contract_item_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__contract_item_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_map_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fn_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fn_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pos_args_fn_call_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_args_fn_call_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_val_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_unpack_binding_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_stmt_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_variant_struct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_variant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ident_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_path_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_arg = 1,
  field_args = 2,
  field_bases = 3,
  field_bindings = 4,
  field_body = 5,
  field_else_clause = 6,
  field_else_if_clauses = 7,
  field_if_clause = 8,
  field_index = 9,
  field_interfaces = 10,
  field_key = 11,
  field_key_name = 12,
  field_key_type = 13,
  field_lhs = 14,
  field_member = 15,
  field_member_vals = 16,
  field_members = 17,
  field_members_vals = 18,
  field_name = 19,
  field_op = 20,
  field_predicate = 21,
  field_return_type = 22,
  field_rhs = 23,
  field_type = 24,
  field_vals = 25,
  field_value = 26,
  field_var_name = 27,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_args] = "args",
  [field_bases] = "bases",
  [field_bindings] = "bindings",
  [field_body] = "body",
  [field_else_clause] = "else_clause",
  [field_else_if_clauses] = "else_if_clauses",
  [field_if_clause] = "if_clause",
  [field_index] = "index",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_key_name] = "key_name",
  [field_key_type] = "key_type",
  [field_lhs] = "lhs",
  [field_member] = "member",
  [field_member_vals] = "member_vals",
  [field_members] = "members",
  [field_members_vals] = "members_vals",
  [field_name] = "name",
  [field_op] = "op",
  [field_predicate] = "predicate",
  [field_return_type] = "return_type",
  [field_rhs] = "rhs",
  [field_type] = "type",
  [field_vals] = "vals",
  [field_value] = "value",
  [field_var_name] = "var_name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 4},
  [5] = {.index = 10, .length = 3},
  [6] = {.index = 13, .length = 6},
  [7] = {.index = 19, .length = 8},
  [8] = {.index = 27, .length = 3},
  [9] = {.index = 30, .length = 3},
  [10] = {.index = 33, .length = 2},
  [11] = {.index = 35, .length = 8},
  [12] = {.index = 43, .length = 8},
  [13] = {.index = 51, .length = 2},
  [14] = {.index = 53, .length = 4},
  [15] = {.index = 57, .length = 3},
  [16] = {.index = 60, .length = 1},
  [17] = {.index = 61, .length = 3},
  [18] = {.index = 64, .length = 5},
  [19] = {.index = 69, .length = 2},
  [20] = {.index = 71, .length = 1},
  [21] = {.index = 72, .length = 2},
  [22] = {.index = 74, .length = 4},
  [23] = {.index = 78, .length = 2},
  [24] = {.index = 80, .length = 1},
  [25] = {.index = 81, .length = 1},
  [26] = {.index = 82, .length = 2},
  [27] = {.index = 84, .length = 2},
  [28] = {.index = 86, .length = 10},
  [29] = {.index = 96, .length = 3},
  [30] = {.index = 99, .length = 1},
  [31] = {.index = 100, .length = 2},
  [32] = {.index = 102, .length = 2},
  [33] = {.index = 104, .length = 3},
  [34] = {.index = 107, .length = 3},
  [35] = {.index = 110, .length = 2},
  [36] = {.index = 112, .length = 2},
  [37] = {.index = 114, .length = 1},
  [38] = {.index = 115, .length = 1},
  [39] = {.index = 116, .length = 3},
  [40] = {.index = 119, .length = 1},
  [41] = {.index = 120, .length = 2},
  [42] = {.index = 122, .length = 2},
  [43] = {.index = 124, .length = 2},
  [44] = {.index = 126, .length = 2},
  [45] = {.index = 128, .length = 2},
  [46] = {.index = 130, .length = 2},
  [47] = {.index = 132, .length = 1},
  [48] = {.index = 133, .length = 2},
  [49] = {.index = 135, .length = 3},
  [50] = {.index = 138, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_args, 0, .inherited = true},
    {field_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [5] =
    {field_name, 0},
  [6] =
    {field_args, 1, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [10] =
    {field_args, 1, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [13] =
    {field_args, 3, .inherited = true},
    {field_body, 3},
    {field_body, 3, .inherited = true},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
  [19] =
    {field_args, 0, .inherited = true},
    {field_args, 1, .inherited = true},
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [27] =
    {field_bases, 2},
    {field_bases, 3},
    {field_name, 1},
  [30] =
    {field_interfaces, 2},
    {field_interfaces, 3},
    {field_name, 1},
  [33] =
    {field_args, 0},
    {field_body, 1},
  [35] =
    {field_args, 5, .inherited = true},
    {field_bases, 2},
    {field_bases, 3},
    {field_body, 5},
    {field_body, 5, .inherited = true},
    {field_name, 1},
    {field_name, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
  [43] =
    {field_args, 5, .inherited = true},
    {field_body, 5},
    {field_body, 5, .inherited = true},
    {field_interfaces, 2},
    {field_interfaces, 3},
    {field_name, 1},
    {field_name, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
  [51] =
    {field_key, 0},
    {field_type, 2},
  [53] =
    {field_args, 2, .inherited = true},
    {field_body, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
  [57] =
    {field_args, 1},
    {field_body, 2},
    {field_name, 0},
  [60] =
    {field_if_clause, 0},
  [61] =
    {field_args, 0},
    {field_body, 2},
    {field_return_type, 1},
  [64] =
    {field_bases, 2},
    {field_bases, 3},
    {field_interfaces, 4},
    {field_interfaces, 5},
    {field_name, 1},
  [69] =
    {field_members, 2},
    {field_name, 0},
  [71] =
    {field_key_type, 1},
  [72] =
    {field_key, 0},
    {field_type, 3},
  [74] =
    {field_args, 1},
    {field_body, 3},
    {field_name, 0},
    {field_return_type, 2},
  [78] =
    {field_name, 0},
    {field_type, 2},
  [80] =
    {field_arg, 1},
  [81] =
    {field_var_name, 0},
  [82] =
    {field_else_clause, 1},
    {field_if_clause, 0},
  [84] =
    {field_else_if_clauses, 1},
    {field_if_clause, 0},
  [86] =
    {field_args, 7, .inherited = true},
    {field_bases, 2},
    {field_bases, 3},
    {field_body, 7},
    {field_body, 7, .inherited = true},
    {field_interfaces, 4},
    {field_interfaces, 5},
    {field_name, 1},
    {field_name, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
  [96] =
    {field_members, 2},
    {field_members, 3},
    {field_name, 0},
  [99] =
    {field_vals, 1},
  [100] =
    {field_body, 2},
    {field_predicate, 1},
  [102] =
    {field_lhs, 0},
    {field_member, 2},
  [104] =
    {field_lhs, 0},
    {field_op, 1},
    {field_rhs, 2},
  [107] =
    {field_lhs, 0},
    {field_lhs, 2},
    {field_op, 1},
  [110] =
    {field_lhs, 0},
    {field_rhs, 2},
  [112] =
    {field_lhs, 0},
    {field_lhs, 2},
  [114] =
    {field_op, 1},
  [115] =
    {field_body, 1},
  [116] =
    {field_else_clause, 2},
    {field_else_if_clauses, 1},
    {field_if_clause, 0},
  [119] =
    {field_type, 0},
  [120] =
    {field_key_name, 1},
    {field_key_type, 3},
  [122] =
    {field_vals, 1},
    {field_vals, 2},
  [124] =
    {field_type, 2},
    {field_var_name, 0},
  [126] =
    {field_index, 2},
    {field_lhs, 0},
  [128] =
    {field_members_vals, 2},
    {field_type, 0},
  [130] =
    {field_member_vals, 2},
    {field_type, 0},
  [132] =
    {field_bindings, 1},
  [133] =
    {field_name, 0},
    {field_value, 2},
  [135] =
    {field_members_vals, 2},
    {field_members_vals, 3},
    {field_type, 0},
  [138] =
    {field_member_vals, 2},
    {field_member_vals, 3},
    {field_type, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(122);
      if (lookahead == '!') ADVANCE(150);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(156);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(169);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == '<') ADVANCE(159);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(160);
      if (lookahead == '?') ADVANCE(291);
      if (lookahead == '[') ADVANCE(137);
      if (lookahead == ']') ADVANCE(138);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'b') ADVANCE(79);
      if (lookahead == 'c') ADVANCE(78);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == 'f') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(10);
      if (lookahead == 'l') ADVANCE(50);
      if (lookahead == 'm') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(80);
      if (lookahead == 'o') ADVANCE(84);
      if (lookahead == 'q') ADVANCE(115);
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 's') ADVANCE(98);
      if (lookahead == 't') ADVANCE(92);
      if (lookahead == 'u') ADVANCE(12);
      if (lookahead == '{') ADVANCE(126);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(150);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '%') ADVANCE(155);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '*') ADVANCE(151);
      if (lookahead == '+') ADVANCE(157);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '<') ADVANCE(159);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(160);
      if (lookahead == '[') ADVANCE(137);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'a') ADVANCE(233);
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(230);
      if (lookahead == 'f') ADVANCE(209);
      if (lookahead == 'i') ADVANCE(198);
      if (lookahead == 'l') ADVANCE(221);
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == 'o') ADVANCE(242);
      if (lookahead == 'q') ADVANCE(256);
      if (lookahead == 'r') ADVANCE(223);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(200);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      if (('c' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '[') ADVANCE(137);
      if (lookahead == ']') ADVANCE(138);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(234);
      if (lookahead == 'f') ADVANCE(210);
      if (lookahead == 'i') ADVANCE(199);
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == 'q') ADVANCE(256);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(200);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ',') ADVANCE(169);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == ':') ADVANCE(135);
      if (lookahead == '=') ADVANCE(182);
      if (lookahead == '[') ADVANCE(137);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(230);
      if (lookahead == 'f') ADVANCE(209);
      if (lookahead == 'i') ADVANCE(198);
      if (lookahead == 'l') ADVANCE(221);
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == 'q') ADVANCE(256);
      if (lookahead == 'r') ADVANCE(223);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(200);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(149);
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '[') ADVANCE(137);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(229);
      if (lookahead == 'f') ADVANCE(209);
      if (lookahead == 'i') ADVANCE(198);
      if (lookahead == 'l') ADVANCE(221);
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == 'q') ADVANCE(256);
      if (lookahead == 'r') ADVANCE(223);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == 'u') ADVANCE(200);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(156);
      if (lookahead == '(') ADVANCE(141);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == ',') ADVANCE(169);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == ':') ADVANCE(135);
      if (lookahead == '<') ADVANCE(159);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(160);
      if (lookahead == '[') ADVANCE(137);
      if (lookahead == ']') ADVANCE(138);
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 'o') ADVANCE(84);
      if (lookahead == '{') ADVANCE(126);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(171);
      if (lookahead == '\\') ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(141);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == ',') ADVANCE(169);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == ':') ADVANCE(21);
      if (lookahead == '=') ADVANCE(182);
      if (lookahead == '?') ADVANCE(291);
      if (lookahead == '[') ADVANCE(26);
      if (lookahead == ']') ADVANCE(138);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == 'b') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == 'i') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(57);
      if (lookahead == 'q') ADVANCE(115);
      if (lookahead == 's') ADVANCE(98);
      if (lookahead == 't') ADVANCE(119);
      if (lookahead == 'u') ADVANCE(12);
      if (lookahead == '{') ADVANCE(126);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 8:
      if (lookahead == '(') ADVANCE(141);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == ':') ADVANCE(21);
      if (lookahead == '?') ADVANCE(291);
      if (lookahead == '[') ADVANCE(26);
      if (lookahead == '{') ADVANCE(126);
      if (lookahead == '}') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 9:
      if (lookahead == '(') ADVANCE(141);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(234);
      if (lookahead == 'i') ADVANCE(199);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(259);
      if (lookahead == 'u') ADVANCE(200);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(197);
      END_STATE();
    case 10:
      if (lookahead == '1') ADVANCE(13);
      if (lookahead == '3') ADVANCE(14);
      if (lookahead == '6') ADVANCE(17);
      if (lookahead == '8') ADVANCE(264);
      if (lookahead == 'f') ADVANCE(184);
      if (lookahead == 'm') ADVANCE(82);
      if (lookahead == 'n') ADVANCE(190);
      END_STATE();
    case 11:
      if (lookahead == '1') ADVANCE(13);
      if (lookahead == '3') ADVANCE(14);
      if (lookahead == '6') ADVANCE(17);
      if (lookahead == '8') ADVANCE(264);
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 12:
      if (lookahead == '1') ADVANCE(16);
      if (lookahead == '3') ADVANCE(15);
      if (lookahead == '6') ADVANCE(18);
      if (lookahead == '8') ADVANCE(274);
      END_STATE();
    case 13:
      if (lookahead == '2') ADVANCE(19);
      if (lookahead == '6') ADVANCE(266);
      END_STATE();
    case 14:
      if (lookahead == '2') ADVANCE(268);
      END_STATE();
    case 15:
      if (lookahead == '2') ADVANCE(278);
      END_STATE();
    case 16:
      if (lookahead == '2') ADVANCE(20);
      if (lookahead == '6') ADVANCE(276);
      END_STATE();
    case 17:
      if (lookahead == '4') ADVANCE(270);
      END_STATE();
    case 18:
      if (lookahead == '4') ADVANCE(280);
      END_STATE();
    case 19:
      if (lookahead == '8') ADVANCE(272);
      END_STATE();
    case 20:
      if (lookahead == '8') ADVANCE(282);
      END_STATE();
    case 21:
      if (lookahead == ':') ADVANCE(301);
      END_STATE();
    case 22:
      if (lookahead == ':') ADVANCE(21);
      if (lookahead == '?') ADVANCE(291);
      if (lookahead == '[') ADVANCE(26);
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(164);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(163);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(144);
      END_STATE();
    case 26:
      if (lookahead == ']') ADVANCE(292);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(110);
      if (lookahead == 'r') ADVANCE(114);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(35);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(111);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(103);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 37:
      if (lookahead == 'd') ADVANCE(93);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(33);
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 56:
      if (lookahead == 'g') ADVANCE(86);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(63);
      if (lookahead == 'l') ADVANCE(96);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(95);
      if (lookahead == 'm') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(113);
      if (lookahead == 'r') ADVANCE(90);
      if (lookahead == 'v') ADVANCE(54);
      if (lookahead == 'x') ADVANCE(39);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(262);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 65:
      if (lookahead == 'm') ADVANCE(295);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(55);
      END_STATE();
    case 67:
      if (lookahead == 'n') ADVANCE(36);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(190);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(193);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(113);
      if (lookahead == 'r') ADVANCE(90);
      if (lookahead == 'v') ADVANCE(54);
      if (lookahead == 'x') ADVANCE(38);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 79:
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(88);
      END_STATE();
    case 82:
      if (lookahead == 'p') ADVANCE(64);
      END_STATE();
    case 83:
      if (lookahead == 'p') ADVANCE(44);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(167);
      END_STATE();
    case 85:
      if (lookahead == 'r') ADVANCE(188);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 87:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 88:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(69);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(116);
      if (lookahead == 'y') ADVANCE(83);
      END_STATE();
    case 93:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 94:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 95:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 97:
      if (lookahead == 's') ADVANCE(107);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(94);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(65);
      END_STATE();
    case 114:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 115:
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 116:
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 117:
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 118:
      if (lookahead == 'y') ADVANCE(133);
      END_STATE();
    case 119:
      if (lookahead == 'y') ADVANCE(83);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(173);
      END_STATE();
    case 121:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_contract);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_state);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_exec);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_query);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_query);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(301);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_instantiate);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_migrate);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == ')') ADVANCE(170);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(287);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(287);
      if (lookahead == '>') ADVANCE(144);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(164);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(288);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(289);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(290);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(286);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unit_val);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_string_val);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_integer_val);
      if (lookahead == '.') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_decimal_val);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_none_val);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_none_val);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(163);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_emit);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_emit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_fail);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_fail);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_type_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '1') ADVANCE(201);
      if (lookahead == '3') ADVANCE(202);
      if (lookahead == '6') ADVANCE(205);
      if (lookahead == '8') ADVANCE(265);
      if (lookahead == 'f') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '1') ADVANCE(201);
      if (lookahead == '3') ADVANCE(202);
      if (lookahead == '6') ADVANCE(205);
      if (lookahead == '8') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '1') ADVANCE(204);
      if (lookahead == '3') ADVANCE(203);
      if (lookahead == '6') ADVANCE(206);
      if (lookahead == '8') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(207);
      if (lookahead == '6') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '2') ADVANCE(208);
      if (lookahead == '6') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '4') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '4') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '8') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '8') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(224);
      if (lookahead == 'o') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'd') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(247);
      if (lookahead == 'm') ADVANCE(225);
      if (lookahead == 'n') ADVANCE(254);
      if (lookahead == 'x') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(225);
      if (lookahead == 'n') ADVANCE(254);
      if (lookahead == 'x') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(237);
      if (lookahead == 'y') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(258);
      if (lookahead == 'y') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_i8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_i16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_i32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_i64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_i128);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_i128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_u8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_u16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_u32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_u64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_u128);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_u128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_byte);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_struct);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_enum);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_infer_type);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_infer_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 3},
  [10] = {.lex_state = 3},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 4},
  [82] = {.lex_state = 4},
  [83] = {.lex_state = 4},
  [84] = {.lex_state = 4},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 4},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 7},
  [96] = {.lex_state = 7},
  [97] = {.lex_state = 7},
  [98] = {.lex_state = 7},
  [99] = {.lex_state = 7},
  [100] = {.lex_state = 7},
  [101] = {.lex_state = 7},
  [102] = {.lex_state = 7},
  [103] = {.lex_state = 7},
  [104] = {.lex_state = 7},
  [105] = {.lex_state = 7},
  [106] = {.lex_state = 7},
  [107] = {.lex_state = 7},
  [108] = {.lex_state = 7},
  [109] = {.lex_state = 7},
  [110] = {.lex_state = 7},
  [111] = {.lex_state = 7},
  [112] = {.lex_state = 9},
  [113] = {.lex_state = 9},
  [114] = {.lex_state = 7},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 7},
  [117] = {.lex_state = 7},
  [118] = {.lex_state = 9},
  [119] = {.lex_state = 7},
  [120] = {.lex_state = 7},
  [121] = {.lex_state = 7},
  [122] = {.lex_state = 7},
  [123] = {.lex_state = 7},
  [124] = {.lex_state = 7},
  [125] = {.lex_state = 7},
  [126] = {.lex_state = 7},
  [127] = {.lex_state = 7},
  [128] = {.lex_state = 7},
  [129] = {.lex_state = 7},
  [130] = {.lex_state = 7},
  [131] = {.lex_state = 7},
  [132] = {.lex_state = 7},
  [133] = {.lex_state = 7},
  [134] = {.lex_state = 7},
  [135] = {.lex_state = 7},
  [136] = {.lex_state = 7},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 5},
  [164] = {.lex_state = 7},
  [165] = {.lex_state = 5},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 5},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 5},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 5},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 7},
  [180] = {.lex_state = 7},
  [181] = {.lex_state = 7},
  [182] = {.lex_state = 7},
  [183] = {.lex_state = 7},
  [184] = {.lex_state = 7},
  [185] = {.lex_state = 7},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 7},
  [190] = {.lex_state = 7},
  [191] = {.lex_state = 7},
  [192] = {.lex_state = 7},
  [193] = {.lex_state = 7},
  [194] = {.lex_state = 7},
  [195] = {.lex_state = 7},
  [196] = {.lex_state = 7},
  [197] = {.lex_state = 7},
  [198] = {.lex_state = 7},
  [199] = {.lex_state = 7},
  [200] = {.lex_state = 7},
  [201] = {.lex_state = 7},
  [202] = {.lex_state = 7},
  [203] = {.lex_state = 7},
  [204] = {.lex_state = 7},
  [205] = {.lex_state = 7},
  [206] = {.lex_state = 7},
  [207] = {.lex_state = 7},
  [208] = {.lex_state = 7},
  [209] = {.lex_state = 7},
  [210] = {.lex_state = 7},
  [211] = {.lex_state = 7},
  [212] = {.lex_state = 7},
  [213] = {.lex_state = 7},
  [214] = {.lex_state = 7},
  [215] = {.lex_state = 7},
  [216] = {.lex_state = 7},
  [217] = {.lex_state = 7},
  [218] = {.lex_state = 8},
  [219] = {.lex_state = 8},
  [220] = {.lex_state = 8},
  [221] = {.lex_state = 8},
  [222] = {.lex_state = 8},
  [223] = {.lex_state = 8},
  [224] = {.lex_state = 7},
  [225] = {.lex_state = 8},
  [226] = {.lex_state = 8},
  [227] = {.lex_state = 8},
  [228] = {.lex_state = 8},
  [229] = {.lex_state = 8},
  [230] = {.lex_state = 8},
  [231] = {.lex_state = 8},
  [232] = {.lex_state = 8},
  [233] = {.lex_state = 8},
  [234] = {.lex_state = 8},
  [235] = {.lex_state = 8},
  [236] = {.lex_state = 8},
  [237] = {.lex_state = 8},
  [238] = {.lex_state = 8},
  [239] = {.lex_state = 22},
  [240] = {.lex_state = 8},
  [241] = {.lex_state = 7},
  [242] = {.lex_state = 8},
  [243] = {.lex_state = 7},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 8},
  [246] = {.lex_state = 8},
  [247] = {.lex_state = 8},
  [248] = {.lex_state = 7},
  [249] = {.lex_state = 8},
  [250] = {.lex_state = 8},
  [251] = {.lex_state = 8},
  [252] = {.lex_state = 8},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 8},
  [255] = {.lex_state = 8},
  [256] = {.lex_state = 7},
  [257] = {.lex_state = 8},
  [258] = {.lex_state = 8},
  [259] = {.lex_state = 22},
  [260] = {.lex_state = 7},
  [261] = {.lex_state = 8},
  [262] = {.lex_state = 22},
  [263] = {.lex_state = 8},
  [264] = {.lex_state = 3},
  [265] = {.lex_state = 8},
  [266] = {.lex_state = 8},
  [267] = {.lex_state = 7},
  [268] = {.lex_state = 7},
  [269] = {.lex_state = 8},
  [270] = {.lex_state = 3},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 8},
  [274] = {.lex_state = 8},
  [275] = {.lex_state = 3},
  [276] = {.lex_state = 7},
  [277] = {.lex_state = 8},
  [278] = {.lex_state = 8},
  [279] = {.lex_state = 3},
  [280] = {.lex_state = 8},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 8},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 8},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 7},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 22},
  [289] = {.lex_state = 3},
  [290] = {.lex_state = 8},
  [291] = {.lex_state = 3},
  [292] = {.lex_state = 8},
  [293] = {.lex_state = 8},
  [294] = {.lex_state = 8},
  [295] = {.lex_state = 7},
  [296] = {.lex_state = 8},
  [297] = {.lex_state = 8},
  [298] = {.lex_state = 8},
  [299] = {.lex_state = 7},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 7},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 7},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 8},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 8},
  [327] = {.lex_state = 8},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 7},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 22},
  [334] = {.lex_state = 22},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 22},
  [338] = {.lex_state = 22},
  [339] = {.lex_state = 22},
  [340] = {.lex_state = 22},
  [341] = {.lex_state = 22},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 7},
  [345] = {.lex_state = 7},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 22},
  [348] = {.lex_state = 8},
  [349] = {.lex_state = 22},
  [350] = {.lex_state = 8},
  [351] = {.lex_state = 22},
  [352] = {.lex_state = 22},
  [353] = {.lex_state = 8},
  [354] = {.lex_state = 22},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 22},
  [358] = {.lex_state = 22},
  [359] = {.lex_state = 8},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 7},
  [363] = {.lex_state = 8},
  [364] = {.lex_state = 8},
  [365] = {.lex_state = 8},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 8},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 8},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 7},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 3},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 8},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 7},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 8},
  [392] = {.lex_state = 8},
  [393] = {.lex_state = 8},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 8},
  [396] = {.lex_state = 8},
  [397] = {.lex_state = 8},
  [398] = {.lex_state = 8},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 3},
  [401] = {.lex_state = 7},
  [402] = {.lex_state = 8},
  [403] = {.lex_state = 8},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 8},
  [406] = {.lex_state = 8},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 8},
  [409] = {.lex_state = 8},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 8},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 8},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 8},
  [419] = {.lex_state = 8},
  [420] = {.lex_state = 8},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 3},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 8},
  [427] = {.lex_state = 3},
  [428] = {.lex_state = 3},
  [429] = {.lex_state = 3},
  [430] = {.lex_state = 8},
  [431] = {.lex_state = 8},
  [432] = {.lex_state = 8},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 8},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 8},
  [438] = {.lex_state = 8},
  [439] = {.lex_state = 8},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_contract] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_state] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_query] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_migrate] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_unit_val] = ACTIONS(1),
    [sym_string_val] = ACTIONS(1),
    [sym_integer_val] = ACTIONS(1),
    [sym_decimal_val] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_none_val] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_emit] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_fail] = ACTIONS(1),
    [sym_type_name] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_i128] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_u128] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [sym_infer_type] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
  },
  [1] = {
    [sym_cwscript_src] = STATE(436),
    [sym__cws_item] = STATE(244),
    [sym_contract_defn] = STATE(244),
    [aux_sym_cwscript_src_repeat1] = STATE(244),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_contract] = ACTIONS(5),
  },
  [2] = {
    [sym__stmt] = STATE(10),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(10),
    [sym_assign_stmt] = STATE(10),
    [sym_if_stmt] = STATE(10),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(10),
    [sym__directive_stmt] = STATE(10),
    [sym_exec_stmt] = STATE(10),
    [sym_emit_stmt] = STATE(10),
    [sym_return_stmt] = STATE(10),
    [sym_fail_stmt] = STATE(10),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(10),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [3] = {
    [sym__stmt] = STATE(10),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(10),
    [sym_assign_stmt] = STATE(10),
    [sym_if_stmt] = STATE(10),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(10),
    [sym__directive_stmt] = STATE(10),
    [sym_exec_stmt] = STATE(10),
    [sym_emit_stmt] = STATE(10),
    [sym_return_stmt] = STATE(10),
    [sym_fail_stmt] = STATE(10),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(10),
    [anon_sym_RBRACE] = ACTIONS(49),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [4] = {
    [sym__stmt] = STATE(3),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(3),
    [sym_assign_stmt] = STATE(3),
    [sym_if_stmt] = STATE(3),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(3),
    [sym__directive_stmt] = STATE(3),
    [sym_exec_stmt] = STATE(3),
    [sym_emit_stmt] = STATE(3),
    [sym_return_stmt] = STATE(3),
    [sym_fail_stmt] = STATE(3),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(3),
    [anon_sym_RBRACE] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [5] = {
    [sym__stmt] = STATE(10),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(10),
    [sym_assign_stmt] = STATE(10),
    [sym_if_stmt] = STATE(10),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(10),
    [sym__directive_stmt] = STATE(10),
    [sym_exec_stmt] = STATE(10),
    [sym_emit_stmt] = STATE(10),
    [sym_return_stmt] = STATE(10),
    [sym_fail_stmt] = STATE(10),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(10),
    [anon_sym_RBRACE] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [6] = {
    [sym__stmt] = STATE(5),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(5),
    [sym_assign_stmt] = STATE(5),
    [sym_if_stmt] = STATE(5),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(5),
    [sym__directive_stmt] = STATE(5),
    [sym_exec_stmt] = STATE(5),
    [sym_emit_stmt] = STATE(5),
    [sym_return_stmt] = STATE(5),
    [sym_fail_stmt] = STATE(5),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(5),
    [anon_sym_RBRACE] = ACTIONS(55),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [7] = {
    [sym__stmt] = STATE(10),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(10),
    [sym_assign_stmt] = STATE(10),
    [sym_if_stmt] = STATE(10),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(10),
    [sym__directive_stmt] = STATE(10),
    [sym_exec_stmt] = STATE(10),
    [sym_emit_stmt] = STATE(10),
    [sym_return_stmt] = STATE(10),
    [sym_fail_stmt] = STATE(10),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(10),
    [anon_sym_RBRACE] = ACTIONS(57),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [8] = {
    [sym__stmt] = STATE(7),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(7),
    [sym_assign_stmt] = STATE(7),
    [sym_if_stmt] = STATE(7),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(7),
    [sym__directive_stmt] = STATE(7),
    [sym_exec_stmt] = STATE(7),
    [sym_emit_stmt] = STATE(7),
    [sym_return_stmt] = STATE(7),
    [sym_fail_stmt] = STATE(7),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(7),
    [anon_sym_RBRACE] = ACTIONS(59),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [9] = {
    [sym__stmt] = STATE(2),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(2),
    [sym_assign_stmt] = STATE(2),
    [sym_if_stmt] = STATE(2),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(2),
    [sym__directive_stmt] = STATE(2),
    [sym_exec_stmt] = STATE(2),
    [sym_emit_stmt] = STATE(2),
    [sym_return_stmt] = STATE(2),
    [sym_fail_stmt] = STATE(2),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(2),
    [anon_sym_RBRACE] = ACTIONS(61),
    [anon_sym_exec] = ACTIONS(9),
    [anon_sym_query] = ACTIONS(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [sym_unit_val] = ACTIONS(21),
    [sym_string_val] = ACTIONS(21),
    [sym_integer_val] = ACTIONS(23),
    [sym_decimal_val] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_none_val] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_for] = ACTIONS(29),
    [anon_sym_emit] = ACTIONS(31),
    [anon_sym_return] = ACTIONS(33),
    [anon_sym_fail] = ACTIONS(35),
    [sym_type_name] = ACTIONS(37),
    [sym_ident] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(39),
    [anon_sym_i8] = ACTIONS(39),
    [anon_sym_i16] = ACTIONS(39),
    [anon_sym_i32] = ACTIONS(39),
    [anon_sym_i64] = ACTIONS(39),
    [anon_sym_i128] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(39),
    [anon_sym_u16] = ACTIONS(39),
    [anon_sym_u32] = ACTIONS(39),
    [anon_sym_u64] = ACTIONS(39),
    [anon_sym_u128] = ACTIONS(39),
    [anon_sym_byte] = ACTIONS(39),
    [anon_sym_struct] = ACTIONS(41),
    [anon_sym_enum] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(45),
    [sym_infer_type] = ACTIONS(47),
  },
  [10] = {
    [sym__stmt] = STATE(10),
    [sym__expr] = STATE(163),
    [sym_grouped_expr] = STATE(163),
    [sym_member_access_expr] = STATE(163),
    [sym_table_lookup_expr] = STATE(163),
    [sym_unary_neg_expr] = STATE(163),
    [sym_unary_not_expr] = STATE(163),
    [sym_mult_div_mod_expr] = STATE(163),
    [sym_add_sub_expr] = STATE(163),
    [sym_comparison_expr] = STATE(163),
    [sym_equality_expr] = STATE(163),
    [sym_and_expr] = STATE(163),
    [sym_or_expr] = STATE(163),
    [sym_query_expr] = STATE(163),
    [sym__fn_call_expr] = STATE(163),
    [sym_pos_args_fn_call_expr] = STATE(163),
    [sym_named_args_fn_call_expr] = STATE(163),
    [sym__val] = STATE(163),
    [sym_struct_val] = STATE(163),
    [sym_tuple_struct_val] = STATE(163),
    [sym_vec_val] = STATE(163),
    [sym__bool_val] = STATE(163),
    [sym_let_stmt] = STATE(10),
    [sym_assign_stmt] = STATE(10),
    [sym_if_stmt] = STATE(10),
    [sym_if_clause] = STATE(82),
    [sym_for_stmt] = STATE(10),
    [sym__directive_stmt] = STATE(10),
    [sym_exec_stmt] = STATE(10),
    [sym_emit_stmt] = STATE(10),
    [sym_return_stmt] = STATE(10),
    [sym_fail_stmt] = STATE(10),
    [sym_builtin_type] = STATE(267),
    [sym_tuple_type] = STATE(267),
    [sym_short_option_type] = STATE(267),
    [sym_short_vec_type] = STATE(267),
    [sym__type_defn] = STATE(267),
    [sym_struct_defn] = STATE(267),
    [sym_enum_defn] = STATE(267),
    [sym_type_alias_defn] = STATE(267),
    [sym__type_expr] = STATE(267),
    [sym_type_path] = STATE(267),
    [aux_sym_fn_body_repeat1] = STATE(10),
    [anon_sym_RBRACE] = ACTIONS(63),
    [anon_sym_exec] = ACTIONS(65),
    [anon_sym_query] = ACTIONS(68),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(80),
    [sym_unit_val] = ACTIONS(83),
    [sym_string_val] = ACTIONS(83),
    [sym_integer_val] = ACTIONS(86),
    [sym_decimal_val] = ACTIONS(83),
    [anon_sym_true] = ACTIONS(86),
    [anon_sym_false] = ACTIONS(86),
    [sym_none_val] = ACTIONS(86),
    [anon_sym_let] = ACTIONS(89),
    [anon_sym_if] = ACTIONS(92),
    [anon_sym_for] = ACTIONS(95),
    [anon_sym_emit] = ACTIONS(98),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_fail] = ACTIONS(104),
    [sym_type_name] = ACTIONS(107),
    [sym_ident] = ACTIONS(86),
    [anon_sym_bool] = ACTIONS(110),
    [anon_sym_i8] = ACTIONS(110),
    [anon_sym_i16] = ACTIONS(110),
    [anon_sym_i32] = ACTIONS(110),
    [anon_sym_i64] = ACTIONS(110),
    [anon_sym_i128] = ACTIONS(110),
    [anon_sym_u8] = ACTIONS(110),
    [anon_sym_u16] = ACTIONS(110),
    [anon_sym_u32] = ACTIONS(110),
    [anon_sym_u64] = ACTIONS(110),
    [anon_sym_u128] = ACTIONS(110),
    [anon_sym_byte] = ACTIONS(110),
    [anon_sym_struct] = ACTIONS(113),
    [anon_sym_enum] = ACTIONS(116),
    [anon_sym_type] = ACTIONS(119),
    [sym_infer_type] = ACTIONS(122),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 18,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    ACTIONS(131), 1,
      sym_ident,
    STATE(314), 1,
      sym_named_call_arg,
    ACTIONS(127), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(129), 4,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(170), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [100] = 18,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(131), 1,
      sym_ident,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(355), 1,
      sym_named_call_arg,
    ACTIONS(135), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(137), 4,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(167), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [200] = 16,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      sym_infer_type,
    ACTIONS(141), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(143), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(224), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(186), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [295] = 16,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(151), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(166), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [390] = 16,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      sym_infer_type,
    ACTIONS(153), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(155), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(224), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(188), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [485] = 16,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(157), 1,
      anon_sym_RBRACK,
    ACTIONS(159), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(161), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(165), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [580] = 16,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(163), 1,
      anon_sym_RBRACK,
    ACTIONS(165), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(167), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(168), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [675] = 16,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    ACTIONS(171), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(173), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(171), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [770] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(175), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(177), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(140), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [862] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(179), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(181), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(173), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [954] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(193), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(195), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(75), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1046] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(199), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(201), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(174), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1138] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(203), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(205), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(59), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1230] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(207), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(209), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(160), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1322] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(211), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(213), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(161), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1414] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(215), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(217), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(58), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1506] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(219), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(221), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(52), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1598] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(223), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(225), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(158), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1690] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(227), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(229), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(76), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1782] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(231), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(233), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(73), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1874] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(235), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(237), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(187), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [1966] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(239), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(241), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(144), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2058] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(243), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(245), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(143), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2150] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(247), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(249), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(142), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2242] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(251), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(253), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(141), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2334] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(255), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(257), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(74), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2426] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(259), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(261), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(139), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2518] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(263), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(265), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(55), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2610] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(267), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(269), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(172), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2702] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(271), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(273), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(78), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2794] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(275), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(277), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(77), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2886] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(279), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(281), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(72), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [2978] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(283), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(285), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(70), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3070] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(287), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(289), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(51), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3162] = 15,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(183), 1,
      anon_sym_query,
    ACTIONS(185), 1,
      anon_sym_LBRACK,
    ACTIONS(187), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_DASH,
    ACTIONS(191), 1,
      anon_sym_BANG,
    ACTIONS(197), 1,
      sym_infer_type,
    ACTIONS(291), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(293), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(286), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(68), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3254] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(295), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(297), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(176), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3346] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(299), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(301), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(177), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3438] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(303), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(305), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(175), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3530] = 15,
    ACTIONS(11), 1,
      anon_sym_query,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      anon_sym_DASH,
    ACTIONS(19), 1,
      anon_sym_BANG,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(47), 1,
      sym_infer_type,
    ACTIONS(307), 3,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
    ACTIONS(309), 5,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
    STATE(267), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
    STATE(178), 21,
      sym__expr,
      sym_grouped_expr,
      sym_member_access_expr,
      sym_table_lookup_expr,
      sym_unary_neg_expr,
      sym_unary_not_expr,
      sym_mult_div_mod_expr,
      sym_add_sub_expr,
      sym_comparison_expr,
      sym_equality_expr,
      sym_and_expr,
      sym_or_expr,
      sym_query_expr,
      sym__fn_call_expr,
      sym_pos_args_fn_call_expr,
      sym_named_args_fn_call_expr,
      sym__val,
      sym_struct_val,
      sym_tuple_struct_val,
      sym_vec_val,
      sym__bool_val,
  [3622] = 2,
    ACTIONS(311), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(313), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3678] = 5,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(315), 14,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(317), 34,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3740] = 12,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(341), 1,
      anon_sym_or,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(325), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(327), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3816] = 2,
    ACTIONS(343), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(345), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3872] = 2,
    ACTIONS(347), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(349), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [3928] = 12,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(341), 1,
      anon_sym_or,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(351), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(353), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4004] = 2,
    ACTIONS(355), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(357), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4060] = 2,
    ACTIONS(359), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(361), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4116] = 5,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(363), 14,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(365), 34,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4178] = 5,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(367), 14,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(369), 34,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4240] = 2,
    ACTIONS(371), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(373), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4296] = 2,
    ACTIONS(375), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(377), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4352] = 2,
    ACTIONS(379), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(381), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4408] = 2,
    ACTIONS(383), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(385), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4464] = 2,
    ACTIONS(387), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(389), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4520] = 2,
    ACTIONS(391), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(393), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4576] = 2,
    ACTIONS(395), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(397), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4632] = 2,
    ACTIONS(399), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(401), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4688] = 6,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(403), 11,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(405), 34,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4752] = 2,
    ACTIONS(407), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(409), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4808] = 7,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(411), 9,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(413), 34,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4874] = 2,
    ACTIONS(415), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(417), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [4930] = 9,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(419), 7,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(421), 32,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5000] = 12,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(341), 1,
      anon_sym_or,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(423), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(425), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5076] = 12,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(341), 1,
      anon_sym_or,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(427), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(429), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5152] = 12,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(341), 1,
      anon_sym_or,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(431), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(433), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5228] = 12,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(341), 1,
      anon_sym_or,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(435), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(437), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5304] = 10,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(439), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(441), 32,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5376] = 11,
    ACTIONS(319), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    ACTIONS(323), 1,
      anon_sym_DOT,
    ACTIONS(339), 1,
      anon_sym_and,
    ACTIONS(329), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(333), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(335), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(337), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(331), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(443), 5,
      anon_sym_RBRACE,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(445), 31,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_BANG,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5450] = 2,
    ACTIONS(447), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(449), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5506] = 2,
    ACTIONS(451), 16,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(453), 35,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5562] = 5,
    ACTIONS(459), 1,
      anon_sym_else,
    STATE(88), 1,
      sym_else_clause,
    STATE(83), 2,
      sym_else_if_clause,
      aux_sym_if_stmt_repeat1,
    ACTIONS(455), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(457), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5615] = 5,
    ACTIONS(459), 1,
      anon_sym_else,
    STATE(90), 1,
      sym_else_clause,
    STATE(81), 2,
      sym_else_if_clause,
      aux_sym_if_stmt_repeat1,
    ACTIONS(461), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(463), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5668] = 4,
    ACTIONS(469), 1,
      anon_sym_else,
    STATE(83), 2,
      sym_else_if_clause,
      aux_sym_if_stmt_repeat1,
    ACTIONS(465), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(467), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5718] = 2,
    ACTIONS(472), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(474), 31,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5762] = 2,
    ACTIONS(476), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(478), 31,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5806] = 2,
    ACTIONS(480), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(482), 31,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5850] = 2,
    ACTIONS(484), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(486), 31,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5894] = 2,
    ACTIONS(488), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(490), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5937] = 2,
    ACTIONS(492), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(494), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [5980] = 2,
    ACTIONS(496), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(498), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6023] = 2,
    ACTIONS(472), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(474), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6066] = 2,
    ACTIONS(476), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(478), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6109] = 2,
    ACTIONS(500), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(502), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6152] = 2,
    ACTIONS(504), 8,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(506), 30,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      anon_sym_let,
      anon_sym_if,
      anon_sym_for,
      anon_sym_emit,
      anon_sym_return,
      anon_sym_fail,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6195] = 3,
    ACTIONS(510), 1,
      anon_sym_COLON_COLON,
    STATE(95), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(508), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6237] = 3,
    ACTIONS(515), 1,
      anon_sym_COLON_COLON,
    STATE(97), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(513), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6279] = 3,
    ACTIONS(515), 1,
      anon_sym_COLON_COLON,
    STATE(95), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(517), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6321] = 1,
    ACTIONS(508), 34,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
      anon_sym_COLON_COLON,
  [6358] = 1,
    ACTIONS(519), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6394] = 1,
    ACTIONS(521), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6430] = 1,
    ACTIONS(523), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6466] = 1,
    ACTIONS(525), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6502] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(527), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6542] = 1,
    ACTIONS(533), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6578] = 1,
    ACTIONS(535), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6614] = 1,
    ACTIONS(537), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6650] = 1,
    ACTIONS(539), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6686] = 1,
    ACTIONS(541), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6722] = 1,
    ACTIONS(543), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6758] = 1,
    ACTIONS(545), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6794] = 1,
    ACTIONS(547), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_RBRACK,
      anon_sym_instantiate,
      anon_sym_migrate,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [6830] = 12,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_RPAREN,
    ACTIONS(553), 1,
      sym_ident,
    ACTIONS(555), 1,
      sym_infer_type,
    STATE(117), 1,
      aux_sym_enum_variant_tuple_repeat1,
    STATE(302), 1,
      sym_struct_member,
    STATE(164), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [6887] = 12,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(553), 1,
      sym_ident,
    ACTIONS(555), 1,
      sym_infer_type,
    ACTIONS(557), 1,
      anon_sym_RPAREN,
    STATE(114), 1,
      aux_sym_enum_variant_tuple_repeat1,
    STATE(323), 1,
      sym_struct_member,
    STATE(164), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [6944] = 10,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(559), 1,
      anon_sym_RPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(569), 1,
      sym_infer_type,
    STATE(116), 1,
      aux_sym_enum_variant_tuple_repeat1,
    STATE(164), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [6995] = 2,
    ACTIONS(573), 7,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_BANG,
      sym_unit_val,
      sym_string_val,
      sym_decimal_val,
      sym_type_name,
    ACTIONS(571), 23,
      anon_sym_query,
      anon_sym_LPAREN,
      sym_integer_val,
      anon_sym_true,
      anon_sym_false,
      sym_none_val,
      sym_ident,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [7030] = 10,
    ACTIONS(575), 1,
      anon_sym_LPAREN,
    ACTIONS(578), 1,
      anon_sym_RPAREN,
    ACTIONS(580), 1,
      sym_type_name,
    ACTIONS(586), 1,
      anon_sym_struct,
    ACTIONS(589), 1,
      anon_sym_enum,
    ACTIONS(592), 1,
      anon_sym_type,
    ACTIONS(595), 1,
      sym_infer_type,
    STATE(116), 1,
      aux_sym_enum_variant_tuple_repeat1,
    STATE(164), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(583), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7081] = 10,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(569), 1,
      sym_infer_type,
    ACTIONS(598), 1,
      anon_sym_RPAREN,
    STATE(116), 1,
      aux_sym_enum_variant_tuple_repeat1,
    STATE(164), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7132] = 9,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(41), 1,
      anon_sym_struct,
    ACTIONS(43), 1,
      anon_sym_enum,
    ACTIONS(45), 1,
      anon_sym_type,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(600), 1,
      sym_ident,
    ACTIONS(602), 1,
      sym_infer_type,
    STATE(304), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(39), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7180] = 9,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(604), 1,
      anon_sym_RPAREN,
    ACTIONS(606), 1,
      sym_infer_type,
    STATE(256), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7228] = 9,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(608), 1,
      sym_infer_type,
    STATE(260), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7276] = 9,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(610), 1,
      anon_sym_RPAREN,
    ACTIONS(612), 1,
      sym_infer_type,
    STATE(243), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7324] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(614), 1,
      sym_infer_type,
    STATE(331), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7369] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(616), 1,
      sym_infer_type,
    STATE(306), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7414] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(618), 1,
      sym_infer_type,
    STATE(248), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7459] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(620), 1,
      sym_infer_type,
    STATE(192), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7504] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(622), 1,
      sym_infer_type,
    STATE(299), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7549] = 8,
    ACTIONS(624), 1,
      anon_sym_LPAREN,
    ACTIONS(626), 1,
      sym_type_name,
    ACTIONS(630), 1,
      anon_sym_struct,
    ACTIONS(632), 1,
      anon_sym_enum,
    ACTIONS(634), 1,
      anon_sym_type,
    ACTIONS(636), 1,
      sym_infer_type,
    STATE(334), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(628), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7594] = 8,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      sym_type_name,
    ACTIONS(644), 1,
      anon_sym_struct,
    ACTIONS(646), 1,
      anon_sym_enum,
    ACTIONS(648), 1,
      anon_sym_type,
    ACTIONS(650), 1,
      sym_infer_type,
    STATE(249), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(642), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7639] = 8,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      sym_type_name,
    ACTIONS(644), 1,
      anon_sym_struct,
    ACTIONS(646), 1,
      anon_sym_enum,
    ACTIONS(648), 1,
      anon_sym_type,
    ACTIONS(652), 1,
      sym_infer_type,
    STATE(294), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(642), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7684] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(654), 1,
      sym_infer_type,
    STATE(103), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7729] = 8,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      sym_type_name,
    ACTIONS(644), 1,
      anon_sym_struct,
    ACTIONS(646), 1,
      anon_sym_enum,
    ACTIONS(648), 1,
      anon_sym_type,
    ACTIONS(656), 1,
      sym_infer_type,
    STATE(282), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(642), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7774] = 8,
    ACTIONS(624), 1,
      anon_sym_LPAREN,
    ACTIONS(626), 1,
      sym_type_name,
    ACTIONS(630), 1,
      anon_sym_struct,
    ACTIONS(632), 1,
      anon_sym_enum,
    ACTIONS(634), 1,
      anon_sym_type,
    ACTIONS(658), 1,
      sym_infer_type,
    STATE(338), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(628), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7819] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(660), 1,
      sym_infer_type,
    STATE(241), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7864] = 8,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      sym_type_name,
    ACTIONS(644), 1,
      anon_sym_struct,
    ACTIONS(646), 1,
      anon_sym_enum,
    ACTIONS(648), 1,
      anon_sym_type,
    ACTIONS(662), 1,
      sym_infer_type,
    STATE(298), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(642), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7909] = 8,
    ACTIONS(638), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      sym_type_name,
    ACTIONS(644), 1,
      anon_sym_struct,
    ACTIONS(646), 1,
      anon_sym_enum,
    ACTIONS(648), 1,
      anon_sym_type,
    ACTIONS(664), 1,
      sym_infer_type,
    STATE(273), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(642), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7954] = 8,
    ACTIONS(37), 1,
      sym_type_name,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(563), 1,
      anon_sym_struct,
    ACTIONS(565), 1,
      anon_sym_enum,
    ACTIONS(567), 1,
      anon_sym_type,
    ACTIONS(666), 1,
      sym_infer_type,
    STATE(193), 10,
      sym_builtin_type,
      sym_tuple_type,
      sym_short_option_type,
      sym_short_vec_type,
      sym__type_defn,
      sym_struct_defn,
      sym_enum_defn,
      sym_type_alias_defn,
      sym__type_expr,
      sym_type_path,
    ACTIONS(561), 12,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
  [7999] = 2,
    ACTIONS(381), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(379), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8031] = 2,
    ACTIONS(389), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(387), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8063] = 11,
    ACTIONS(445), 1,
      anon_sym_EQ,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(674), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(443), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8113] = 10,
    ACTIONS(441), 1,
      anon_sym_EQ,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(674), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(439), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8161] = 9,
    ACTIONS(421), 1,
      anon_sym_EQ,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(674), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(419), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8207] = 7,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(674), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(413), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(411), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8249] = 5,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(317), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(315), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8287] = 6,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(405), 5,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(403), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8327] = 2,
    ACTIONS(377), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(375), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8359] = 2,
    ACTIONS(401), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(399), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8391] = 2,
    ACTIONS(313), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(311), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8423] = 2,
    ACTIONS(453), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(451), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8455] = 2,
    ACTIONS(373), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(371), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8487] = 2,
    ACTIONS(449), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(447), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8519] = 2,
    ACTIONS(417), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(415), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8551] = 2,
    ACTIONS(385), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(383), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8583] = 2,
    ACTIONS(397), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(395), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8615] = 2,
    ACTIONS(361), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(359), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8647] = 2,
    ACTIONS(349), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(347), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8679] = 2,
    ACTIONS(345), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(343), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8711] = 2,
    ACTIONS(357), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(355), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8743] = 12,
    ACTIONS(327), 1,
      anon_sym_EQ,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(674), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(325), 10,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8795] = 2,
    ACTIONS(409), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(407), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8827] = 5,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(369), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(367), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8865] = 5,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(365), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(363), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8903] = 2,
    ACTIONS(393), 8,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(391), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8935] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(688), 1,
      anon_sym_EQ,
    STATE(38), 1,
      sym_assign_op,
    ACTIONS(674), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(676), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(690), 5,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8985] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(692), 19,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_type_name,
      anon_sym_bool,
      anon_sym_i8,
      anon_sym_i16,
      anon_sym_i32,
      anon_sym_i64,
      anon_sym_i128,
      anon_sym_u8,
      anon_sym_u16,
      anon_sym_u32,
      anon_sym_u64,
      anon_sym_u128,
      anon_sym_byte,
      anon_sym_struct,
      anon_sym_enum,
      anon_sym_type,
      sym_infer_type,
  [9013] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(694), 1,
      anon_sym_RBRACK,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    STATE(346), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9059] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(702), 1,
      anon_sym_RPAREN,
    STATE(308), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9105] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(704), 1,
      anon_sym_RPAREN,
    STATE(335), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9151] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(706), 1,
      anon_sym_RBRACK,
    STATE(315), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9197] = 3,
    ACTIONS(708), 1,
      anon_sym_COLON,
    ACTIONS(712), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(710), 16,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_COMMA,
  [9223] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(714), 1,
      anon_sym_RPAREN,
    STATE(311), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9269] = 13,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(716), 1,
      anon_sym_RPAREN,
    STATE(328), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9315] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(718), 3,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [9357] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(720), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9398] = 12,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(722), 1,
      anon_sym_LBRACE,
    STATE(86), 1,
      sym_fn_body,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9441] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(724), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9482] = 12,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(726), 1,
      anon_sym_LBRACE,
    STATE(94), 1,
      sym_fn_body,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9525] = 12,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(726), 1,
      anon_sym_LBRACE,
    STATE(93), 1,
      sym_fn_body,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9568] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(728), 1,
      anon_sym_RBRACK,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9608] = 10,
    ACTIONS(730), 1,
      anon_sym_RBRACE,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    STATE(182), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9646] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(746), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9684] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(748), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9722] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(750), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9760] = 10,
    ACTIONS(752), 1,
      anon_sym_RBRACE,
    ACTIONS(754), 1,
      anon_sym_error,
    ACTIONS(757), 1,
      anon_sym_event,
    ACTIONS(760), 1,
      anon_sym_state,
    ACTIONS(763), 1,
      anon_sym_exec,
    ACTIONS(766), 1,
      anon_sym_query,
    ACTIONS(769), 1,
      anon_sym_instantiate,
    ACTIONS(772), 1,
      anon_sym_migrate,
    STATE(183), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9798] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(775), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9836] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(777), 1,
      anon_sym_RBRACE,
    STATE(184), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [9874] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(779), 1,
      anon_sym_RPAREN,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9914] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(781), 1,
      anon_sym_RBRACK,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9954] = 11,
    ACTIONS(668), 1,
      anon_sym_LBRACK,
    ACTIONS(670), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT,
    ACTIONS(684), 1,
      anon_sym_and,
    ACTIONS(686), 1,
      anon_sym_or,
    ACTIONS(783), 1,
      anon_sym_RPAREN,
    ACTIONS(678), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(682), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(696), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(698), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
  [9994] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(785), 1,
      anon_sym_RBRACE,
    STATE(181), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [10032] = 10,
    ACTIONS(732), 1,
      anon_sym_error,
    ACTIONS(734), 1,
      anon_sym_event,
    ACTIONS(736), 1,
      anon_sym_state,
    ACTIONS(738), 1,
      anon_sym_exec,
    ACTIONS(740), 1,
      anon_sym_query,
    ACTIONS(742), 1,
      anon_sym_instantiate,
    ACTIONS(744), 1,
      anon_sym_migrate,
    ACTIONS(787), 1,
      anon_sym_RBRACE,
    STATE(180), 1,
      aux_sym_contract_defn_repeat1,
    STATE(216), 8,
      sym__contract_item,
      sym_error_defn,
      sym_event_defn,
      sym_state_defn,
      sym_instantiate_defn,
      sym_exec_defn,
      sym_query_defn,
      sym_migrate_defn,
  [10070] = 3,
    ACTIONS(789), 1,
      anon_sym_LBRACE,
    ACTIONS(793), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10087] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(795), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10104] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(797), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10121] = 1,
    ACTIONS(799), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10132] = 1,
    ACTIONS(801), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10143] = 1,
    ACTIONS(803), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10154] = 1,
    ACTIONS(805), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10165] = 1,
    ACTIONS(807), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10176] = 1,
    ACTIONS(809), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10187] = 1,
    ACTIONS(476), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10198] = 1,
    ACTIONS(811), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10209] = 1,
    ACTIONS(813), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10220] = 1,
    ACTIONS(815), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10231] = 1,
    ACTIONS(817), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10242] = 1,
    ACTIONS(819), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10253] = 1,
    ACTIONS(821), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10264] = 1,
    ACTIONS(823), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10275] = 1,
    ACTIONS(825), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10286] = 1,
    ACTIONS(827), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10297] = 1,
    ACTIONS(829), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10308] = 1,
    ACTIONS(831), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10319] = 1,
    ACTIONS(833), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10330] = 1,
    ACTIONS(472), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10341] = 1,
    ACTIONS(835), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10352] = 1,
    ACTIONS(837), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10363] = 1,
    ACTIONS(839), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10374] = 1,
    ACTIONS(841), 8,
      anon_sym_RBRACE,
      anon_sym_error,
      anon_sym_event,
      anon_sym_state,
      anon_sym_exec,
      anon_sym_query,
      anon_sym_instantiate,
      anon_sym_migrate,
  [10385] = 3,
    ACTIONS(843), 1,
      anon_sym_RBRACE,
    ACTIONS(845), 1,
      sym_ident,
    STATE(223), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10399] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(847), 1,
      anon_sym_RBRACE,
    STATE(226), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10413] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(849), 1,
      anon_sym_RBRACE,
    STATE(223), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10427] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(851), 1,
      anon_sym_RBRACE,
    STATE(218), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10441] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(853), 1,
      anon_sym_RBRACE,
    STATE(223), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10455] = 3,
    ACTIONS(855), 1,
      anon_sym_RBRACE,
    ACTIONS(857), 1,
      sym_ident,
    STATE(223), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10469] = 7,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(860), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_LPAREN,
    ACTIONS(864), 1,
      anon_sym_RPAREN,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    STATE(330), 1,
      aux_sym_tuple_type_repeat1,
  [10491] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(868), 1,
      anon_sym_RBRACE,
    STATE(222), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10505] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(870), 1,
      anon_sym_RBRACE,
    STATE(223), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10519] = 3,
    ACTIONS(872), 1,
      anon_sym_COLON_COLON,
    STATE(230), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(517), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10533] = 3,
    ACTIONS(845), 1,
      sym_ident,
    ACTIONS(874), 1,
      anon_sym_RBRACE,
    STATE(220), 5,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
      aux_sym__contract_item_repeat1,
  [10547] = 3,
    ACTIONS(872), 1,
      anon_sym_COLON_COLON,
    STATE(227), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(513), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10561] = 3,
    ACTIONS(876), 1,
      anon_sym_COLON_COLON,
    STATE(230), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(508), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10575] = 3,
    ACTIONS(874), 1,
      anon_sym_RBRACE,
    ACTIONS(879), 1,
      sym_ident,
    STATE(232), 4,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
      aux_sym__contract_item_repeat2,
  [10588] = 3,
    ACTIONS(849), 1,
      anon_sym_RBRACE,
    ACTIONS(879), 1,
      sym_ident,
    STATE(235), 4,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
      aux_sym__contract_item_repeat2,
  [10601] = 3,
    ACTIONS(881), 1,
      anon_sym_LBRACE,
    ACTIONS(883), 1,
      sym_ident,
    STATE(202), 4,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
  [10614] = 3,
    ACTIONS(881), 1,
      anon_sym_LBRACE,
    ACTIONS(883), 1,
      sym_ident,
    STATE(197), 4,
      sym__enum_variant,
      sym_enum_variant_struct,
      sym_enum_variant_tuple,
      sym_enum_variant_unit,
  [10627] = 3,
    ACTIONS(885), 1,
      anon_sym_RBRACE,
    ACTIONS(887), 1,
      sym_ident,
    STATE(235), 4,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
      aux_sym__contract_item_repeat2,
  [10640] = 1,
    ACTIONS(508), 6,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_COLON_COLON,
  [10649] = 1,
    ACTIONS(543), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10657] = 1,
    ACTIONS(533), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10665] = 3,
    ACTIONS(890), 1,
      anon_sym_COLON_COLON,
    STATE(239), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(508), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10677] = 3,
    ACTIONS(893), 1,
      anon_sym_LBRACE,
    ACTIONS(895), 1,
      sym_ident,
    STATE(411), 3,
      sym__bindings,
      sym_ident_binding,
      sym_struct_unpack_binding,
  [10689] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(897), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_EQ,
  [10701] = 3,
    ACTIONS(893), 1,
      anon_sym_LBRACE,
    ACTIONS(899), 1,
      sym_ident,
    STATE(415), 3,
      sym__bindings,
      sym_ident_binding,
      sym_struct_unpack_binding,
  [10713] = 5,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(901), 1,
      anon_sym_RPAREN,
    STATE(307), 1,
      aux_sym_tuple_type_repeat1,
  [10729] = 3,
    ACTIONS(5), 1,
      anon_sym_contract,
    ACTIONS(903), 1,
      ts_builtin_sym_end,
    STATE(253), 3,
      sym__cws_item,
      sym_contract_defn,
      aux_sym_cwscript_src_repeat1,
  [10741] = 1,
    ACTIONS(547), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10749] = 1,
    ACTIONS(541), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10757] = 1,
    ACTIONS(545), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10765] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(905), 3,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [10777] = 3,
    ACTIONS(907), 1,
      anon_sym_QMARK,
    ACTIONS(909), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(527), 3,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
  [10789] = 1,
    ACTIONS(521), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10797] = 1,
    ACTIONS(537), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10805] = 1,
    ACTIONS(519), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10813] = 3,
    ACTIONS(911), 1,
      ts_builtin_sym_end,
    ACTIONS(913), 1,
      anon_sym_contract,
    STATE(253), 3,
      sym__cws_item,
      sym_contract_defn,
      aux_sym_cwscript_src_repeat1,
  [10825] = 1,
    ACTIONS(539), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10833] = 1,
    ACTIONS(535), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10841] = 5,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(916), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_tuple_type_repeat1,
  [10857] = 1,
    ACTIONS(523), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10865] = 1,
    ACTIONS(525), 5,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      sym_ident,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10873] = 3,
    ACTIONS(918), 1,
      anon_sym_COLON_COLON,
    STATE(262), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(513), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10885] = 5,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(864), 1,
      anon_sym_RPAREN,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    STATE(330), 1,
      aux_sym_tuple_type_repeat1,
  [10901] = 3,
    ACTIONS(920), 1,
      anon_sym_LBRACE,
    ACTIONS(922), 1,
      sym_ident,
    STATE(209), 3,
      sym__state_defn,
      sym_state_item,
      sym_state_map,
  [10913] = 3,
    ACTIONS(918), 1,
      anon_sym_COLON_COLON,
    STATE(239), 1,
      aux_sym_type_path_repeat1,
    ACTIONS(517), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [10925] = 3,
    ACTIONS(924), 1,
      anon_sym_RBRACE,
    ACTIONS(926), 1,
      sym_ident,
    STATE(263), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [10936] = 3,
    ACTIONS(929), 1,
      anon_sym_COLON,
    ACTIONS(931), 1,
      anon_sym_LBRACK,
    STATE(289), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [10947] = 3,
    ACTIONS(933), 1,
      anon_sym_RBRACE,
    ACTIONS(935), 1,
      sym_ident,
    STATE(290), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [10958] = 3,
    ACTIONS(937), 1,
      anon_sym_RPAREN,
    ACTIONS(939), 1,
      sym_ident,
    STATE(293), 2,
      sym_fn_arg,
      aux_sym_fn_args_repeat1,
  [10969] = 4,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(860), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_LPAREN,
  [10982] = 4,
    ACTIONS(941), 1,
      anon_sym_LBRACE,
    ACTIONS(943), 1,
      anon_sym_DASH_GT,
    STATE(360), 1,
      sym_fn_return_type,
    STATE(405), 1,
      sym_fn_body,
  [10995] = 4,
    ACTIONS(874), 1,
      anon_sym_RBRACE,
    ACTIONS(945), 1,
      sym_ident,
    STATE(280), 1,
      aux_sym__contract_item_repeat3,
    STATE(398), 1,
      sym__named_fn_defn,
  [11008] = 2,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(947), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_EQ,
  [11017] = 4,
    ACTIONS(726), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_if,
    STATE(87), 1,
      sym_if_clause,
    STATE(89), 1,
      sym_fn_body,
  [11030] = 3,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(285), 1,
      aux_sym_ident_list_repeat1,
    ACTIONS(953), 2,
      anon_sym_implements,
      anon_sym_LBRACE,
  [11041] = 3,
    ACTIONS(907), 1,
      anon_sym_QMARK,
    ACTIONS(909), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(957), 2,
      anon_sym_RPAREN,
      sym_ident,
  [11052] = 3,
    ACTIONS(935), 1,
      sym_ident,
    ACTIONS(959), 1,
      anon_sym_RBRACE,
    STATE(297), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [11063] = 3,
    ACTIONS(931), 1,
      anon_sym_LBRACK,
    ACTIONS(961), 1,
      anon_sym_COLON,
    STATE(291), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11074] = 4,
    ACTIONS(943), 1,
      anon_sym_DASH_GT,
    ACTIONS(963), 1,
      anon_sym_LBRACE,
    STATE(217), 1,
      sym_fn_body,
    STATE(375), 1,
      sym_fn_return_type,
  [11087] = 3,
    ACTIONS(965), 1,
      anon_sym_LBRACE,
    ACTIONS(967), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 2,
      anon_sym_RBRACE,
      sym_ident,
  [11098] = 3,
    ACTIONS(939), 1,
      sym_ident,
    ACTIONS(969), 1,
      anon_sym_RPAREN,
    STATE(266), 2,
      sym_fn_arg,
      aux_sym_fn_args_repeat1,
  [11109] = 3,
    ACTIONS(931), 1,
      anon_sym_LBRACK,
    ACTIONS(971), 1,
      anon_sym_COLON,
    STATE(275), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11120] = 4,
    ACTIONS(945), 1,
      sym_ident,
    ACTIONS(973), 1,
      anon_sym_RBRACE,
    STATE(296), 1,
      aux_sym__contract_item_repeat3,
    STATE(398), 1,
      sym__named_fn_defn,
  [11133] = 3,
    ACTIONS(977), 1,
      anon_sym_COMMA,
    STATE(281), 1,
      aux_sym_ident_list_repeat1,
    ACTIONS(975), 2,
      anon_sym_implements,
      anon_sym_LBRACE,
  [11144] = 3,
    ACTIONS(907), 1,
      anon_sym_QMARK,
    ACTIONS(909), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(797), 2,
      anon_sym_RBRACE,
      sym_ident,
  [11155] = 3,
    ACTIONS(982), 1,
      anon_sym_COMMA,
    STATE(283), 1,
      aux_sym_enum_variant_struct_repeat1,
    ACTIONS(980), 2,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
  [11166] = 3,
    ACTIONS(935), 1,
      sym_ident,
    ACTIONS(985), 1,
      anon_sym_RBRACE,
    STATE(292), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [11177] = 3,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    STATE(281), 1,
      aux_sym_ident_list_repeat1,
    ACTIONS(987), 2,
      anon_sym_implements,
      anon_sym_LBRACE,
  [11188] = 4,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
  [11201] = 3,
    ACTIONS(993), 1,
      anon_sym_COMMA,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
    ACTIONS(718), 2,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [11212] = 1,
    ACTIONS(508), 4,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      anon_sym_COLON_COLON,
  [11219] = 3,
    ACTIONS(931), 1,
      anon_sym_LBRACK,
    ACTIONS(996), 1,
      anon_sym_COLON,
    STATE(291), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11230] = 3,
    ACTIONS(935), 1,
      sym_ident,
    ACTIONS(998), 1,
      anon_sym_RBRACE,
    STATE(263), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [11241] = 3,
    ACTIONS(1000), 1,
      anon_sym_COLON,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    STATE(291), 2,
      sym_map_key,
      aux_sym_state_map_repeat1,
  [11252] = 3,
    ACTIONS(935), 1,
      sym_ident,
    ACTIONS(1005), 1,
      anon_sym_RBRACE,
    STATE(263), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [11263] = 3,
    ACTIONS(1007), 1,
      anon_sym_RPAREN,
    ACTIONS(1009), 1,
      sym_ident,
    STATE(293), 2,
      sym_fn_arg,
      aux_sym_fn_args_repeat1,
  [11274] = 3,
    ACTIONS(907), 1,
      anon_sym_QMARK,
    ACTIONS(909), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(795), 2,
      anon_sym_RBRACE,
      sym_ident,
  [11285] = 4,
    ACTIONS(943), 1,
      anon_sym_DASH_GT,
    ACTIONS(963), 1,
      anon_sym_LBRACE,
    STATE(204), 1,
      sym_fn_body,
    STATE(376), 1,
      sym_fn_return_type,
  [11298] = 4,
    ACTIONS(1012), 1,
      anon_sym_RBRACE,
    ACTIONS(1014), 1,
      sym_ident,
    STATE(296), 1,
      aux_sym__contract_item_repeat3,
    STATE(398), 1,
      sym__named_fn_defn,
  [11311] = 3,
    ACTIONS(935), 1,
      sym_ident,
    ACTIONS(1017), 1,
      anon_sym_RBRACE,
    STATE(263), 2,
      sym_struct_member,
      aux_sym_struct_body_repeat1,
  [11322] = 3,
    ACTIONS(907), 1,
      anon_sym_QMARK,
    ACTIONS(909), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(905), 2,
      anon_sym_RBRACE,
      sym_ident,
  [11333] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1019), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11344] = 3,
    ACTIONS(1021), 1,
      anon_sym_RBRACE,
    ACTIONS(1023), 1,
      anon_sym_COMMA,
    STATE(300), 1,
      aux_sym_struct_unpack_binding_repeat1,
  [11354] = 1,
    ACTIONS(980), 3,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11360] = 3,
    ACTIONS(1026), 1,
      anon_sym_RPAREN,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    STATE(316), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11370] = 3,
    ACTIONS(1030), 1,
      anon_sym_extends,
    ACTIONS(1032), 1,
      anon_sym_implements,
    ACTIONS(1034), 1,
      anon_sym_LBRACE,
  [11380] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1036), 1,
      anon_sym_RBRACK,
  [11390] = 1,
    ACTIONS(975), 3,
      anon_sym_implements,
      anon_sym_LBRACE,
      anon_sym_COMMA,
  [11396] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1038), 1,
      anon_sym_LBRACE,
  [11406] = 3,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(1040), 1,
      anon_sym_RPAREN,
    STATE(342), 1,
      aux_sym_tuple_type_repeat1,
  [11416] = 3,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(1042), 1,
      anon_sym_RPAREN,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
  [11426] = 3,
    ACTIONS(1044), 1,
      anon_sym_RBRACE,
    ACTIONS(1046), 1,
      anon_sym_COMMA,
    STATE(319), 1,
      aux_sym_struct_val_repeat1,
  [11436] = 3,
    ACTIONS(1048), 1,
      anon_sym_RPAREN,
    ACTIONS(1050), 1,
      anon_sym_COMMA,
    STATE(322), 1,
      aux_sym_named_args_fn_call_expr_repeat1,
  [11446] = 3,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(1052), 1,
      anon_sym_RPAREN,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
  [11456] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1054), 1,
      anon_sym_RBRACE,
    STATE(283), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11466] = 3,
    ACTIONS(1046), 1,
      anon_sym_COMMA,
    ACTIONS(1056), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      aux_sym_struct_val_repeat1,
  [11476] = 3,
    ACTIONS(1050), 1,
      anon_sym_COMMA,
    ACTIONS(1058), 1,
      anon_sym_RPAREN,
    STATE(310), 1,
      aux_sym_named_args_fn_call_expr_repeat1,
  [11486] = 3,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(1060), 1,
      anon_sym_RBRACK,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
  [11496] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1062), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11506] = 3,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(1064), 1,
      anon_sym_RPAREN,
    STATE(342), 1,
      aux_sym_tuple_type_repeat1,
  [11516] = 3,
    ACTIONS(1066), 1,
      anon_sym_RBRACE,
    ACTIONS(1068), 1,
      sym_ident,
    STATE(313), 1,
      sym_struct_val_member,
  [11526] = 3,
    ACTIONS(1070), 1,
      anon_sym_RBRACE,
    ACTIONS(1072), 1,
      anon_sym_COMMA,
    STATE(319), 1,
      aux_sym_struct_val_repeat1,
  [11536] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1075), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11546] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1077), 1,
      anon_sym_RBRACE,
    STATE(283), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11556] = 3,
    ACTIONS(1079), 1,
      anon_sym_RPAREN,
    ACTIONS(1081), 1,
      anon_sym_COMMA,
    STATE(322), 1,
      aux_sym_named_args_fn_call_expr_repeat1,
  [11566] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1084), 1,
      anon_sym_RPAREN,
    STATE(320), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11576] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1086), 1,
      anon_sym_RBRACE,
    STATE(321), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11586] = 3,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1088), 1,
      anon_sym_RBRACE,
    STATE(312), 1,
      aux_sym_enum_variant_struct_repeat1,
  [11596] = 3,
    ACTIONS(1068), 1,
      sym_ident,
    ACTIONS(1090), 1,
      anon_sym_RBRACE,
    STATE(343), 1,
      sym_struct_val_member,
  [11606] = 3,
    ACTIONS(1092), 1,
      anon_sym_RBRACE,
    ACTIONS(1094), 1,
      sym_ident,
    STATE(324), 1,
      sym_struct_member,
  [11616] = 3,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(1096), 1,
      anon_sym_RPAREN,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
  [11626] = 3,
    ACTIONS(1046), 1,
      anon_sym_COMMA,
    ACTIONS(1098), 1,
      anon_sym_RBRACE,
    STATE(319), 1,
      aux_sym_struct_val_repeat1,
  [11636] = 3,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(1100), 1,
      anon_sym_RPAREN,
    STATE(342), 1,
      aux_sym_tuple_type_repeat1,
  [11646] = 3,
    ACTIONS(529), 1,
      anon_sym_QMARK,
    ACTIONS(531), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(1102), 1,
      anon_sym_RBRACK,
  [11656] = 3,
    ACTIONS(1050), 1,
      anon_sym_COMMA,
    ACTIONS(1104), 1,
      anon_sym_RPAREN,
    STATE(322), 1,
      aux_sym_named_args_fn_call_expr_repeat1,
  [11666] = 1,
    ACTIONS(523), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11672] = 3,
    ACTIONS(897), 1,
      anon_sym_in,
    ACTIONS(1106), 1,
      anon_sym_QMARK,
    ACTIONS(1108), 1,
      anon_sym_LBRACK_RBRACK,
  [11682] = 3,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(1110), 1,
      anon_sym_RPAREN,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
  [11692] = 3,
    ACTIONS(1112), 1,
      anon_sym_RBRACE,
    ACTIONS(1114), 1,
      anon_sym_COMMA,
    STATE(300), 1,
      aux_sym_struct_unpack_binding_repeat1,
  [11702] = 1,
    ACTIONS(519), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11708] = 3,
    ACTIONS(527), 1,
      anon_sym_in,
    ACTIONS(1106), 1,
      anon_sym_QMARK,
    ACTIONS(1108), 1,
      anon_sym_LBRACK_RBRACK,
  [11718] = 1,
    ACTIONS(533), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11724] = 1,
    ACTIONS(537), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11730] = 1,
    ACTIONS(539), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11736] = 3,
    ACTIONS(1019), 1,
      anon_sym_RPAREN,
    ACTIONS(1116), 1,
      anon_sym_COMMA,
    STATE(342), 1,
      aux_sym_tuple_type_repeat1,
  [11746] = 3,
    ACTIONS(1046), 1,
      anon_sym_COMMA,
    ACTIONS(1119), 1,
      anon_sym_RBRACE,
    STATE(329), 1,
      aux_sym_struct_val_repeat1,
  [11756] = 3,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    STATE(215), 1,
      sym__fn_defn,
    STATE(295), 1,
      sym_fn_args,
  [11766] = 3,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    STATE(196), 1,
      sym__fn_defn,
    STATE(295), 1,
      sym_fn_args,
  [11776] = 3,
    ACTIONS(700), 1,
      anon_sym_COMMA,
    ACTIONS(1123), 1,
      anon_sym_RBRACK,
    STATE(287), 1,
      aux_sym_pos_args_fn_call_expr_repeat1,
  [11786] = 1,
    ACTIONS(547), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11792] = 3,
    ACTIONS(1125), 1,
      anon_sym_LBRACE,
    ACTIONS(1127), 1,
      sym_ident,
    STATE(194), 1,
      sym__named_fn_defn,
  [11802] = 1,
    ACTIONS(545), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11808] = 3,
    ACTIONS(1094), 1,
      sym_ident,
    ACTIONS(1129), 1,
      anon_sym_RBRACE,
    STATE(325), 1,
      sym_struct_member,
  [11818] = 1,
    ACTIONS(543), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11824] = 1,
    ACTIONS(535), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11830] = 3,
    ACTIONS(1125), 1,
      anon_sym_LBRACE,
    ACTIONS(1127), 1,
      sym_ident,
    STATE(207), 1,
      sym__named_fn_defn,
  [11840] = 1,
    ACTIONS(525), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11846] = 3,
    ACTIONS(1050), 1,
      anon_sym_COMMA,
    ACTIONS(1131), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      aux_sym_named_args_fn_call_expr_repeat1,
  [11856] = 3,
    ACTIONS(1114), 1,
      anon_sym_COMMA,
    ACTIONS(1133), 1,
      anon_sym_RBRACE,
    STATE(336), 1,
      aux_sym_struct_unpack_binding_repeat1,
  [11866] = 1,
    ACTIONS(541), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11872] = 1,
    ACTIONS(521), 3,
      anon_sym_in,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [11878] = 1,
    ACTIONS(825), 2,
      anon_sym_RBRACE,
      sym_ident,
  [11883] = 2,
    ACTIONS(941), 1,
      anon_sym_LBRACE,
    STATE(369), 1,
      sym_fn_body,
  [11890] = 1,
    ACTIONS(1135), 2,
      anon_sym_EQ,
      anon_sym_in,
  [11895] = 2,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    STATE(268), 1,
      sym_fn_args,
  [11902] = 2,
    ACTIONS(895), 1,
      sym_ident,
    STATE(368), 1,
      sym_ident_binding,
  [11909] = 2,
    ACTIONS(1137), 1,
      sym_ident,
    STATE(413), 1,
      sym_ident_list,
  [11916] = 2,
    ACTIONS(1139), 1,
      sym_ident,
    STATE(377), 1,
      sym_named_call_arg,
  [11923] = 2,
    ACTIONS(951), 1,
      anon_sym_if,
    STATE(87), 1,
      sym_if_clause,
  [11930] = 2,
    ACTIONS(1068), 1,
      sym_ident,
    STATE(399), 1,
      sym_struct_val_member,
  [11937] = 1,
    ACTIONS(1021), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [11942] = 1,
    ACTIONS(809), 2,
      anon_sym_RBRACE,
      sym_ident,
  [11947] = 1,
    ACTIONS(1141), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [11952] = 1,
    ACTIONS(1143), 2,
      anon_sym_EQ,
      anon_sym_in,
  [11957] = 1,
    ACTIONS(1145), 2,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
  [11962] = 1,
    ACTIONS(1147), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [11967] = 1,
    ACTIONS(1149), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [11972] = 2,
    ACTIONS(963), 1,
      anon_sym_LBRACE,
    STATE(199), 1,
      sym_fn_body,
  [11979] = 2,
    ACTIONS(963), 1,
      anon_sym_LBRACE,
    STATE(214), 1,
      sym_fn_body,
  [11986] = 1,
    ACTIONS(1079), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11991] = 1,
    ACTIONS(1151), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [11996] = 1,
    ACTIONS(1153), 2,
      anon_sym_COLON,
      anon_sym_LBRACK,
  [12001] = 1,
    ACTIONS(1155), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [12006] = 1,
    ACTIONS(1157), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [12011] = 1,
    ACTIONS(1159), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [12016] = 1,
    ACTIONS(472), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12021] = 2,
    ACTIONS(1161), 1,
      anon_sym_implements,
    ACTIONS(1163), 1,
      anon_sym_LBRACE,
  [12028] = 2,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    STATE(276), 1,
      sym_fn_args,
  [12035] = 2,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    STATE(358), 1,
      sym_enum_body,
  [12042] = 2,
    ACTIONS(1167), 1,
      anon_sym_LBRACE,
    STATE(357), 1,
      sym_struct_body,
  [12049] = 2,
    ACTIONS(1169), 1,
      anon_sym_LBRACE,
    STATE(246), 1,
      sym_struct_body,
  [12056] = 2,
    ACTIONS(1171), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      sym_enum_body,
  [12063] = 1,
    ACTIONS(1173), 2,
      ts_builtin_sym_end,
      anon_sym_contract,
  [12068] = 2,
    ACTIONS(1137), 1,
      sym_ident,
    STATE(384), 1,
      sym_ident_list,
  [12075] = 2,
    ACTIONS(1094), 1,
      sym_ident,
    STATE(301), 1,
      sym_struct_member,
  [12082] = 2,
    ACTIONS(1137), 1,
      sym_ident,
    STATE(414), 1,
      sym_ident_list,
  [12089] = 2,
    ACTIONS(947), 1,
      anon_sym_in,
    ACTIONS(1175), 1,
      anon_sym_COLON,
  [12096] = 2,
    ACTIONS(895), 1,
      sym_ident,
    STATE(356), 1,
      sym_ident_binding,
  [12103] = 1,
    ACTIONS(829), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12108] = 1,
    ACTIONS(821), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12113] = 1,
    ACTIONS(1177), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12118] = 1,
    ACTIONS(1070), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [12123] = 1,
    ACTIONS(1179), 2,
      anon_sym_COLON,
      anon_sym_LBRACK,
  [12128] = 1,
    ACTIONS(1181), 2,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
  [12133] = 1,
    ACTIONS(815), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12138] = 1,
    ACTIONS(819), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12143] = 2,
    ACTIONS(1183), 1,
      anon_sym_LBRACE,
    STATE(100), 1,
      sym_enum_body,
  [12150] = 1,
    ACTIONS(841), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12155] = 1,
    ACTIONS(476), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12160] = 2,
    ACTIONS(1185), 1,
      anon_sym_LBRACE,
    STATE(108), 1,
      sym_struct_body,
  [12167] = 1,
    ACTIONS(807), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12172] = 1,
    ACTIONS(833), 2,
      anon_sym_RBRACE,
      sym_ident,
  [12177] = 1,
    ACTIONS(1187), 1,
      anon_sym_COLON,
  [12181] = 1,
    ACTIONS(1189), 1,
      anon_sym_EQ,
  [12185] = 1,
    ACTIONS(1191), 1,
      sym_ident,
  [12189] = 1,
    ACTIONS(1193), 1,
      anon_sym_LBRACE,
  [12193] = 1,
    ACTIONS(1195), 1,
      anon_sym_LBRACE,
  [12197] = 1,
    ACTIONS(1197), 1,
      anon_sym_in,
  [12201] = 1,
    ACTIONS(1199), 1,
      sym_ident,
  [12205] = 1,
    ACTIONS(1201), 1,
      anon_sym_EQ,
  [12209] = 1,
    ACTIONS(1203), 1,
      sym_ident,
  [12213] = 1,
    ACTIONS(1205), 1,
      sym_ident,
  [12217] = 1,
    ACTIONS(1207), 1,
      sym_ident,
  [12221] = 1,
    ACTIONS(1209), 1,
      anon_sym_EQ,
  [12225] = 1,
    ACTIONS(708), 1,
      anon_sym_COLON,
  [12229] = 1,
    ACTIONS(1211), 1,
      sym_type_name,
  [12233] = 1,
    ACTIONS(1213), 1,
      anon_sym_COLON,
  [12237] = 1,
    ACTIONS(1215), 1,
      anon_sym_EQ,
  [12241] = 1,
    ACTIONS(1217), 1,
      sym_ident,
  [12245] = 1,
    ACTIONS(1219), 1,
      anon_sym_COLON,
  [12249] = 1,
    ACTIONS(1221), 1,
      anon_sym_COLON,
  [12253] = 1,
    ACTIONS(1223), 1,
      anon_sym_COLON,
  [12257] = 1,
    ACTIONS(1225), 1,
      sym_ident,
  [12261] = 1,
    ACTIONS(1227), 1,
      sym_ident,
  [12265] = 1,
    ACTIONS(1229), 1,
      sym_ident,
  [12269] = 1,
    ACTIONS(1231), 1,
      sym_type_name,
  [12273] = 1,
    ACTIONS(1233), 1,
      sym_type_name,
  [12277] = 1,
    ACTIONS(1235), 1,
      sym_ident,
  [12281] = 1,
    ACTIONS(1237), 1,
      ts_builtin_sym_end,
  [12285] = 1,
    ACTIONS(1239), 1,
      sym_ident,
  [12289] = 1,
    ACTIONS(1241), 1,
      sym_ident,
  [12293] = 1,
    ACTIONS(1243), 1,
      sym_ident,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(11)] = 0,
  [SMALL_STATE(12)] = 100,
  [SMALL_STATE(13)] = 200,
  [SMALL_STATE(14)] = 295,
  [SMALL_STATE(15)] = 390,
  [SMALL_STATE(16)] = 485,
  [SMALL_STATE(17)] = 580,
  [SMALL_STATE(18)] = 675,
  [SMALL_STATE(19)] = 770,
  [SMALL_STATE(20)] = 862,
  [SMALL_STATE(21)] = 954,
  [SMALL_STATE(22)] = 1046,
  [SMALL_STATE(23)] = 1138,
  [SMALL_STATE(24)] = 1230,
  [SMALL_STATE(25)] = 1322,
  [SMALL_STATE(26)] = 1414,
  [SMALL_STATE(27)] = 1506,
  [SMALL_STATE(28)] = 1598,
  [SMALL_STATE(29)] = 1690,
  [SMALL_STATE(30)] = 1782,
  [SMALL_STATE(31)] = 1874,
  [SMALL_STATE(32)] = 1966,
  [SMALL_STATE(33)] = 2058,
  [SMALL_STATE(34)] = 2150,
  [SMALL_STATE(35)] = 2242,
  [SMALL_STATE(36)] = 2334,
  [SMALL_STATE(37)] = 2426,
  [SMALL_STATE(38)] = 2518,
  [SMALL_STATE(39)] = 2610,
  [SMALL_STATE(40)] = 2702,
  [SMALL_STATE(41)] = 2794,
  [SMALL_STATE(42)] = 2886,
  [SMALL_STATE(43)] = 2978,
  [SMALL_STATE(44)] = 3070,
  [SMALL_STATE(45)] = 3162,
  [SMALL_STATE(46)] = 3254,
  [SMALL_STATE(47)] = 3346,
  [SMALL_STATE(48)] = 3438,
  [SMALL_STATE(49)] = 3530,
  [SMALL_STATE(50)] = 3622,
  [SMALL_STATE(51)] = 3678,
  [SMALL_STATE(52)] = 3740,
  [SMALL_STATE(53)] = 3816,
  [SMALL_STATE(54)] = 3872,
  [SMALL_STATE(55)] = 3928,
  [SMALL_STATE(56)] = 4004,
  [SMALL_STATE(57)] = 4060,
  [SMALL_STATE(58)] = 4116,
  [SMALL_STATE(59)] = 4178,
  [SMALL_STATE(60)] = 4240,
  [SMALL_STATE(61)] = 4296,
  [SMALL_STATE(62)] = 4352,
  [SMALL_STATE(63)] = 4408,
  [SMALL_STATE(64)] = 4464,
  [SMALL_STATE(65)] = 4520,
  [SMALL_STATE(66)] = 4576,
  [SMALL_STATE(67)] = 4632,
  [SMALL_STATE(68)] = 4688,
  [SMALL_STATE(69)] = 4752,
  [SMALL_STATE(70)] = 4808,
  [SMALL_STATE(71)] = 4874,
  [SMALL_STATE(72)] = 4930,
  [SMALL_STATE(73)] = 5000,
  [SMALL_STATE(74)] = 5076,
  [SMALL_STATE(75)] = 5152,
  [SMALL_STATE(76)] = 5228,
  [SMALL_STATE(77)] = 5304,
  [SMALL_STATE(78)] = 5376,
  [SMALL_STATE(79)] = 5450,
  [SMALL_STATE(80)] = 5506,
  [SMALL_STATE(81)] = 5562,
  [SMALL_STATE(82)] = 5615,
  [SMALL_STATE(83)] = 5668,
  [SMALL_STATE(84)] = 5718,
  [SMALL_STATE(85)] = 5762,
  [SMALL_STATE(86)] = 5806,
  [SMALL_STATE(87)] = 5850,
  [SMALL_STATE(88)] = 5894,
  [SMALL_STATE(89)] = 5937,
  [SMALL_STATE(90)] = 5980,
  [SMALL_STATE(91)] = 6023,
  [SMALL_STATE(92)] = 6066,
  [SMALL_STATE(93)] = 6109,
  [SMALL_STATE(94)] = 6152,
  [SMALL_STATE(95)] = 6195,
  [SMALL_STATE(96)] = 6237,
  [SMALL_STATE(97)] = 6279,
  [SMALL_STATE(98)] = 6321,
  [SMALL_STATE(99)] = 6358,
  [SMALL_STATE(100)] = 6394,
  [SMALL_STATE(101)] = 6430,
  [SMALL_STATE(102)] = 6466,
  [SMALL_STATE(103)] = 6502,
  [SMALL_STATE(104)] = 6542,
  [SMALL_STATE(105)] = 6578,
  [SMALL_STATE(106)] = 6614,
  [SMALL_STATE(107)] = 6650,
  [SMALL_STATE(108)] = 6686,
  [SMALL_STATE(109)] = 6722,
  [SMALL_STATE(110)] = 6758,
  [SMALL_STATE(111)] = 6794,
  [SMALL_STATE(112)] = 6830,
  [SMALL_STATE(113)] = 6887,
  [SMALL_STATE(114)] = 6944,
  [SMALL_STATE(115)] = 6995,
  [SMALL_STATE(116)] = 7030,
  [SMALL_STATE(117)] = 7081,
  [SMALL_STATE(118)] = 7132,
  [SMALL_STATE(119)] = 7180,
  [SMALL_STATE(120)] = 7228,
  [SMALL_STATE(121)] = 7276,
  [SMALL_STATE(122)] = 7324,
  [SMALL_STATE(123)] = 7369,
  [SMALL_STATE(124)] = 7414,
  [SMALL_STATE(125)] = 7459,
  [SMALL_STATE(126)] = 7504,
  [SMALL_STATE(127)] = 7549,
  [SMALL_STATE(128)] = 7594,
  [SMALL_STATE(129)] = 7639,
  [SMALL_STATE(130)] = 7684,
  [SMALL_STATE(131)] = 7729,
  [SMALL_STATE(132)] = 7774,
  [SMALL_STATE(133)] = 7819,
  [SMALL_STATE(134)] = 7864,
  [SMALL_STATE(135)] = 7909,
  [SMALL_STATE(136)] = 7954,
  [SMALL_STATE(137)] = 7999,
  [SMALL_STATE(138)] = 8031,
  [SMALL_STATE(139)] = 8063,
  [SMALL_STATE(140)] = 8113,
  [SMALL_STATE(141)] = 8161,
  [SMALL_STATE(142)] = 8207,
  [SMALL_STATE(143)] = 8249,
  [SMALL_STATE(144)] = 8287,
  [SMALL_STATE(145)] = 8327,
  [SMALL_STATE(146)] = 8359,
  [SMALL_STATE(147)] = 8391,
  [SMALL_STATE(148)] = 8423,
  [SMALL_STATE(149)] = 8455,
  [SMALL_STATE(150)] = 8487,
  [SMALL_STATE(151)] = 8519,
  [SMALL_STATE(152)] = 8551,
  [SMALL_STATE(153)] = 8583,
  [SMALL_STATE(154)] = 8615,
  [SMALL_STATE(155)] = 8647,
  [SMALL_STATE(156)] = 8679,
  [SMALL_STATE(157)] = 8711,
  [SMALL_STATE(158)] = 8743,
  [SMALL_STATE(159)] = 8795,
  [SMALL_STATE(160)] = 8827,
  [SMALL_STATE(161)] = 8865,
  [SMALL_STATE(162)] = 8903,
  [SMALL_STATE(163)] = 8935,
  [SMALL_STATE(164)] = 8985,
  [SMALL_STATE(165)] = 9013,
  [SMALL_STATE(166)] = 9059,
  [SMALL_STATE(167)] = 9105,
  [SMALL_STATE(168)] = 9151,
  [SMALL_STATE(169)] = 9197,
  [SMALL_STATE(170)] = 9223,
  [SMALL_STATE(171)] = 9269,
  [SMALL_STATE(172)] = 9315,
  [SMALL_STATE(173)] = 9357,
  [SMALL_STATE(174)] = 9398,
  [SMALL_STATE(175)] = 9441,
  [SMALL_STATE(176)] = 9482,
  [SMALL_STATE(177)] = 9525,
  [SMALL_STATE(178)] = 9568,
  [SMALL_STATE(179)] = 9608,
  [SMALL_STATE(180)] = 9646,
  [SMALL_STATE(181)] = 9684,
  [SMALL_STATE(182)] = 9722,
  [SMALL_STATE(183)] = 9760,
  [SMALL_STATE(184)] = 9798,
  [SMALL_STATE(185)] = 9836,
  [SMALL_STATE(186)] = 9874,
  [SMALL_STATE(187)] = 9914,
  [SMALL_STATE(188)] = 9954,
  [SMALL_STATE(189)] = 9994,
  [SMALL_STATE(190)] = 10032,
  [SMALL_STATE(191)] = 10070,
  [SMALL_STATE(192)] = 10087,
  [SMALL_STATE(193)] = 10104,
  [SMALL_STATE(194)] = 10121,
  [SMALL_STATE(195)] = 10132,
  [SMALL_STATE(196)] = 10143,
  [SMALL_STATE(197)] = 10154,
  [SMALL_STATE(198)] = 10165,
  [SMALL_STATE(199)] = 10176,
  [SMALL_STATE(200)] = 10187,
  [SMALL_STATE(201)] = 10198,
  [SMALL_STATE(202)] = 10209,
  [SMALL_STATE(203)] = 10220,
  [SMALL_STATE(204)] = 10231,
  [SMALL_STATE(205)] = 10242,
  [SMALL_STATE(206)] = 10253,
  [SMALL_STATE(207)] = 10264,
  [SMALL_STATE(208)] = 10275,
  [SMALL_STATE(209)] = 10286,
  [SMALL_STATE(210)] = 10297,
  [SMALL_STATE(211)] = 10308,
  [SMALL_STATE(212)] = 10319,
  [SMALL_STATE(213)] = 10330,
  [SMALL_STATE(214)] = 10341,
  [SMALL_STATE(215)] = 10352,
  [SMALL_STATE(216)] = 10363,
  [SMALL_STATE(217)] = 10374,
  [SMALL_STATE(218)] = 10385,
  [SMALL_STATE(219)] = 10399,
  [SMALL_STATE(220)] = 10413,
  [SMALL_STATE(221)] = 10427,
  [SMALL_STATE(222)] = 10441,
  [SMALL_STATE(223)] = 10455,
  [SMALL_STATE(224)] = 10469,
  [SMALL_STATE(225)] = 10491,
  [SMALL_STATE(226)] = 10505,
  [SMALL_STATE(227)] = 10519,
  [SMALL_STATE(228)] = 10533,
  [SMALL_STATE(229)] = 10547,
  [SMALL_STATE(230)] = 10561,
  [SMALL_STATE(231)] = 10575,
  [SMALL_STATE(232)] = 10588,
  [SMALL_STATE(233)] = 10601,
  [SMALL_STATE(234)] = 10614,
  [SMALL_STATE(235)] = 10627,
  [SMALL_STATE(236)] = 10640,
  [SMALL_STATE(237)] = 10649,
  [SMALL_STATE(238)] = 10657,
  [SMALL_STATE(239)] = 10665,
  [SMALL_STATE(240)] = 10677,
  [SMALL_STATE(241)] = 10689,
  [SMALL_STATE(242)] = 10701,
  [SMALL_STATE(243)] = 10713,
  [SMALL_STATE(244)] = 10729,
  [SMALL_STATE(245)] = 10741,
  [SMALL_STATE(246)] = 10749,
  [SMALL_STATE(247)] = 10757,
  [SMALL_STATE(248)] = 10765,
  [SMALL_STATE(249)] = 10777,
  [SMALL_STATE(250)] = 10789,
  [SMALL_STATE(251)] = 10797,
  [SMALL_STATE(252)] = 10805,
  [SMALL_STATE(253)] = 10813,
  [SMALL_STATE(254)] = 10825,
  [SMALL_STATE(255)] = 10833,
  [SMALL_STATE(256)] = 10841,
  [SMALL_STATE(257)] = 10857,
  [SMALL_STATE(258)] = 10865,
  [SMALL_STATE(259)] = 10873,
  [SMALL_STATE(260)] = 10885,
  [SMALL_STATE(261)] = 10901,
  [SMALL_STATE(262)] = 10913,
  [SMALL_STATE(263)] = 10925,
  [SMALL_STATE(264)] = 10936,
  [SMALL_STATE(265)] = 10947,
  [SMALL_STATE(266)] = 10958,
  [SMALL_STATE(267)] = 10969,
  [SMALL_STATE(268)] = 10982,
  [SMALL_STATE(269)] = 10995,
  [SMALL_STATE(270)] = 11008,
  [SMALL_STATE(271)] = 11017,
  [SMALL_STATE(272)] = 11030,
  [SMALL_STATE(273)] = 11041,
  [SMALL_STATE(274)] = 11052,
  [SMALL_STATE(275)] = 11063,
  [SMALL_STATE(276)] = 11074,
  [SMALL_STATE(277)] = 11087,
  [SMALL_STATE(278)] = 11098,
  [SMALL_STATE(279)] = 11109,
  [SMALL_STATE(280)] = 11120,
  [SMALL_STATE(281)] = 11133,
  [SMALL_STATE(282)] = 11144,
  [SMALL_STATE(283)] = 11155,
  [SMALL_STATE(284)] = 11166,
  [SMALL_STATE(285)] = 11177,
  [SMALL_STATE(286)] = 11188,
  [SMALL_STATE(287)] = 11201,
  [SMALL_STATE(288)] = 11212,
  [SMALL_STATE(289)] = 11219,
  [SMALL_STATE(290)] = 11230,
  [SMALL_STATE(291)] = 11241,
  [SMALL_STATE(292)] = 11252,
  [SMALL_STATE(293)] = 11263,
  [SMALL_STATE(294)] = 11274,
  [SMALL_STATE(295)] = 11285,
  [SMALL_STATE(296)] = 11298,
  [SMALL_STATE(297)] = 11311,
  [SMALL_STATE(298)] = 11322,
  [SMALL_STATE(299)] = 11333,
  [SMALL_STATE(300)] = 11344,
  [SMALL_STATE(301)] = 11354,
  [SMALL_STATE(302)] = 11360,
  [SMALL_STATE(303)] = 11370,
  [SMALL_STATE(304)] = 11380,
  [SMALL_STATE(305)] = 11390,
  [SMALL_STATE(306)] = 11396,
  [SMALL_STATE(307)] = 11406,
  [SMALL_STATE(308)] = 11416,
  [SMALL_STATE(309)] = 11426,
  [SMALL_STATE(310)] = 11436,
  [SMALL_STATE(311)] = 11446,
  [SMALL_STATE(312)] = 11456,
  [SMALL_STATE(313)] = 11466,
  [SMALL_STATE(314)] = 11476,
  [SMALL_STATE(315)] = 11486,
  [SMALL_STATE(316)] = 11496,
  [SMALL_STATE(317)] = 11506,
  [SMALL_STATE(318)] = 11516,
  [SMALL_STATE(319)] = 11526,
  [SMALL_STATE(320)] = 11536,
  [SMALL_STATE(321)] = 11546,
  [SMALL_STATE(322)] = 11556,
  [SMALL_STATE(323)] = 11566,
  [SMALL_STATE(324)] = 11576,
  [SMALL_STATE(325)] = 11586,
  [SMALL_STATE(326)] = 11596,
  [SMALL_STATE(327)] = 11606,
  [SMALL_STATE(328)] = 11616,
  [SMALL_STATE(329)] = 11626,
  [SMALL_STATE(330)] = 11636,
  [SMALL_STATE(331)] = 11646,
  [SMALL_STATE(332)] = 11656,
  [SMALL_STATE(333)] = 11666,
  [SMALL_STATE(334)] = 11672,
  [SMALL_STATE(335)] = 11682,
  [SMALL_STATE(336)] = 11692,
  [SMALL_STATE(337)] = 11702,
  [SMALL_STATE(338)] = 11708,
  [SMALL_STATE(339)] = 11718,
  [SMALL_STATE(340)] = 11724,
  [SMALL_STATE(341)] = 11730,
  [SMALL_STATE(342)] = 11736,
  [SMALL_STATE(343)] = 11746,
  [SMALL_STATE(344)] = 11756,
  [SMALL_STATE(345)] = 11766,
  [SMALL_STATE(346)] = 11776,
  [SMALL_STATE(347)] = 11786,
  [SMALL_STATE(348)] = 11792,
  [SMALL_STATE(349)] = 11802,
  [SMALL_STATE(350)] = 11808,
  [SMALL_STATE(351)] = 11818,
  [SMALL_STATE(352)] = 11824,
  [SMALL_STATE(353)] = 11830,
  [SMALL_STATE(354)] = 11840,
  [SMALL_STATE(355)] = 11846,
  [SMALL_STATE(356)] = 11856,
  [SMALL_STATE(357)] = 11866,
  [SMALL_STATE(358)] = 11872,
  [SMALL_STATE(359)] = 11878,
  [SMALL_STATE(360)] = 11883,
  [SMALL_STATE(361)] = 11890,
  [SMALL_STATE(362)] = 11895,
  [SMALL_STATE(363)] = 11902,
  [SMALL_STATE(364)] = 11909,
  [SMALL_STATE(365)] = 11916,
  [SMALL_STATE(366)] = 11923,
  [SMALL_STATE(367)] = 11930,
  [SMALL_STATE(368)] = 11937,
  [SMALL_STATE(369)] = 11942,
  [SMALL_STATE(370)] = 11947,
  [SMALL_STATE(371)] = 11952,
  [SMALL_STATE(372)] = 11957,
  [SMALL_STATE(373)] = 11962,
  [SMALL_STATE(374)] = 11967,
  [SMALL_STATE(375)] = 11972,
  [SMALL_STATE(376)] = 11979,
  [SMALL_STATE(377)] = 11986,
  [SMALL_STATE(378)] = 11991,
  [SMALL_STATE(379)] = 11996,
  [SMALL_STATE(380)] = 12001,
  [SMALL_STATE(381)] = 12006,
  [SMALL_STATE(382)] = 12011,
  [SMALL_STATE(383)] = 12016,
  [SMALL_STATE(384)] = 12021,
  [SMALL_STATE(385)] = 12028,
  [SMALL_STATE(386)] = 12035,
  [SMALL_STATE(387)] = 12042,
  [SMALL_STATE(388)] = 12049,
  [SMALL_STATE(389)] = 12056,
  [SMALL_STATE(390)] = 12063,
  [SMALL_STATE(391)] = 12068,
  [SMALL_STATE(392)] = 12075,
  [SMALL_STATE(393)] = 12082,
  [SMALL_STATE(394)] = 12089,
  [SMALL_STATE(395)] = 12096,
  [SMALL_STATE(396)] = 12103,
  [SMALL_STATE(397)] = 12108,
  [SMALL_STATE(398)] = 12113,
  [SMALL_STATE(399)] = 12118,
  [SMALL_STATE(400)] = 12123,
  [SMALL_STATE(401)] = 12128,
  [SMALL_STATE(402)] = 12133,
  [SMALL_STATE(403)] = 12138,
  [SMALL_STATE(404)] = 12143,
  [SMALL_STATE(405)] = 12150,
  [SMALL_STATE(406)] = 12155,
  [SMALL_STATE(407)] = 12160,
  [SMALL_STATE(408)] = 12167,
  [SMALL_STATE(409)] = 12172,
  [SMALL_STATE(410)] = 12177,
  [SMALL_STATE(411)] = 12181,
  [SMALL_STATE(412)] = 12185,
  [SMALL_STATE(413)] = 12189,
  [SMALL_STATE(414)] = 12193,
  [SMALL_STATE(415)] = 12197,
  [SMALL_STATE(416)] = 12201,
  [SMALL_STATE(417)] = 12205,
  [SMALL_STATE(418)] = 12209,
  [SMALL_STATE(419)] = 12213,
  [SMALL_STATE(420)] = 12217,
  [SMALL_STATE(421)] = 12221,
  [SMALL_STATE(422)] = 12225,
  [SMALL_STATE(423)] = 12229,
  [SMALL_STATE(424)] = 12233,
  [SMALL_STATE(425)] = 12237,
  [SMALL_STATE(426)] = 12241,
  [SMALL_STATE(427)] = 12245,
  [SMALL_STATE(428)] = 12249,
  [SMALL_STATE(429)] = 12253,
  [SMALL_STATE(430)] = 12257,
  [SMALL_STATE(431)] = 12261,
  [SMALL_STATE(432)] = 12265,
  [SMALL_STATE(433)] = 12269,
  [SMALL_STATE(434)] = 12273,
  [SMALL_STATE(435)] = 12277,
  [SMALL_STATE(436)] = 12281,
  [SMALL_STATE(437)] = 12285,
  [SMALL_STATE(438)] = 12289,
  [SMALL_STATE(439)] = 12293,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwscript_src, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2),
  [65] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(29),
  [68] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(28),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(16),
  [74] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(15),
  [77] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(25),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(24),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(163),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(163),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(240),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(22),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(242),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(21),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(36),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(30),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(96),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(111),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(416),
  [116] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(435),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(434),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fn_body_repeat1, 2), SHIFT_REPEAT(267),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [229] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args_fn_call_expr, 3),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args_fn_call_expr, 3),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mult_div_mod_expr, 3, .production_id = 34),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mult_div_mod_expr, 3, .production_id = 34),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_expr, 2, .production_id = 24),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query_expr, 2, .production_id = 24),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_struct_val, 4, .production_id = 46),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_struct_val, 4, .production_id = 46),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 4, .production_id = 45),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 4, .production_id = 45),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_stmt, 3, .production_id = 37),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_stmt, 3, .production_id = 37),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pos_args_fn_call_expr, 5),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pos_args_fn_call_expr, 5),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args_fn_call_expr, 4),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args_fn_call_expr, 4),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_neg_expr, 2, .production_id = 24),
  [365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_neg_expr, 2, .production_id = 24),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_not_expr, 2, .production_id = 24),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_not_expr, 2, .production_id = 24),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 5, .production_id = 49),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 5, .production_id = 49),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_struct_val, 5, .production_id = 50),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_struct_val, 5, .production_id = 50),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pos_args_fn_call_expr, 4),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pos_args_fn_call_expr, 4),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_val, 3, .production_id = 30),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_val, 3, .production_id = 30),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouped_expr, 3),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouped_expr, 3),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_args_fn_call_expr, 5),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_args_fn_call_expr, 5),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_lookup_expr, 4, .production_id = 44),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_lookup_expr, 4, .production_id = 44),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_access_expr, 3, .production_id = 32),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_access_expr, 3, .production_id = 32),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_add_sub_expr, 3, .production_id = 33),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_add_sub_expr, 3, .production_id = 33),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_val, 2),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_val, 2),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comparison_expr, 3, .production_id = 33),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comparison_expr, 3, .production_id = 33),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_val, 4, .production_id = 42),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_val, 4, .production_id = 42),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equality_expr, 3, .production_id = 33),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equality_expr, 3, .production_id = 33),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fail_stmt, 2, .production_id = 24),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fail_stmt, 2, .production_id = 24),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_stmt, 2, .production_id = 24),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_stmt, 2, .production_id = 24),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_emit_stmt, 2, .production_id = 24),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_emit_stmt, 2, .production_id = 24),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_stmt, 2, .production_id = 24),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exec_stmt, 2, .production_id = 24),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_and_expr, 3, .production_id = 35),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_and_expr, 3, .production_id = 35),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_or_expr, 3, .production_id = 36),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_or_expr, 3, .production_id = 36),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val, 3, .production_id = 40),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_val, 3, .production_id = 40),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_struct_val, 3, .production_id = 40),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_struct_val, 3, .production_id = 40),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 2, .production_id = 27),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 2, .production_id = 27),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 1, .production_id = 16),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 1, .production_id = 16),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_stmt_repeat1, 2),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_stmt_repeat1, 2),
  [469] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_stmt_repeat1, 2), SHIFT_REPEAT(366),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_body, 3),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fn_body, 3),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_body, 2),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fn_body, 2),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 31),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_clause, 3, .production_id = 31),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_clause, 2),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 2),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 3, .production_id = 39),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 3, .production_id = 39),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 2, .production_id = 38),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2, .production_id = 38),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_stmt, 2, .production_id = 26),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_stmt, 2, .production_id = 26),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_stmt, 5, .production_id = 47),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_stmt, 5, .production_id = 47),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_stmt, 5, .production_id = 47),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_stmt, 5, .production_id = 47),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2),
  [510] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2), SHIFT_REPEAT(412),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_path, 1),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_path, 2),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 3),
  [521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_defn, 3, .production_id = 1),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 3),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_defn, 4, .production_id = 1),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2),
  [535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_vec_type, 2),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 2),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 4),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_defn, 3, .production_id = 1),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_option_type, 2),
  [545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 2),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_type, 1),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_op, 1),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_op, 1),
  [575] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(120),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2),
  [580] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(96),
  [583] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(111),
  [586] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(416),
  [589] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(435),
  [592] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(434),
  [595] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 2), SHIFT_REPEAT(164),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [678] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [692] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_variant_tuple_repeat1, 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__val, 1),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__val, 1),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pos_args_fn_call_expr_repeat1, 2),
  [720] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_val_member, 3, .production_id = 48),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_call_arg, 3, .production_id = 48),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7),
  [754] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(234),
  [757] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(233),
  [760] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(261),
  [763] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(353),
  [766] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(348),
  [769] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(345),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 2, .production_id = 7), SHIFT_REPEAT(344),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_unit, 1, .production_id = 3),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_map, 4, .production_id = 21),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_item, 3, .production_id = 13),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query_defn, 2, .production_id = 4),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__contract_item, 4),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instantiate_defn, 2, .production_id = 5),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_defn, 2),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_struct, 4, .production_id = 3),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_fn_defn, 4, .production_id = 22),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__contract_item, 4, .production_id = 14),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_defn, 2),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_struct, 5, .production_id = 3),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__fn_defn, 2, .production_id = 10),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_tuple, 4, .production_id = 19),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_struct, 3, .production_id = 3),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exec_defn, 2, .production_id = 4),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_tuple, 3, .production_id = 3),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_state_defn, 2),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_struct, 5, .production_id = 29),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__contract_item, 3),
  [833] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_variant_struct, 4, .production_id = 19),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__fn_defn, 3, .production_id = 17),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_migrate_defn, 2, .production_id = 5),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_contract_defn_repeat1, 1, .production_id = 2),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_fn_defn, 3, .production_id = 15),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat1, 2),
  [857] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat1, 2), SHIFT_REPEAT(277),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [876] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2), SHIFT_REPEAT(419),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat2, 2),
  [887] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat2, 2), SHIFT_REPEAT(279),
  [890] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_path_repeat1, 2), SHIFT_REPEAT(418),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_binding, 3, .production_id = 43),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cwscript_src, 1),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3, .production_id = 23),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2),
  [913] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cwscript_src_repeat1, 2), SHIFT_REPEAT(420),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_repeat1, 2),
  [926] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_repeat1, 2), SHIFT_REPEAT(428),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_binding, 1, .production_id = 25),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_list, 1),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_arg, 3, .production_id = 23),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_ident_list_repeat1, 2),
  [977] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_ident_list_repeat1, 2), SHIFT_REPEAT(430),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_variant_struct_repeat1, 2),
  [982] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_variant_struct_repeat1, 2), SHIFT_REPEAT(392),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_list, 2),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [993] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pos_args_fn_call_expr_repeat1, 2), SHIFT_REPEAT(39),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1000] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_state_map_repeat1, 2),
  [1002] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_state_map_repeat1, 2), SHIFT_REPEAT(118),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fn_args_repeat1, 2),
  [1009] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fn_args_repeat1, 2), SHIFT_REPEAT(429),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat3, 2, .production_id = 7),
  [1014] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat3, 2, .production_id = 7), SHIFT_REPEAT(362),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tuple_type_repeat1, 2),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_unpack_binding_repeat1, 2),
  [1023] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_unpack_binding_repeat1, 2), SHIFT_REPEAT(363),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_return_type, 2),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1070] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_val_repeat1, 2),
  [1072] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_val_repeat1, 2), SHIFT_REPEAT(367),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1079] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_args_fn_call_expr_repeat1, 2),
  [1081] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_args_fn_call_expr_repeat1, 2), SHIFT_REPEAT(365),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tuple_type_repeat1, 2), SHIFT_REPEAT(126),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_unpack_binding, 3),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 9, .production_id = 28),
  [1143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_unpack_binding, 4),
  [1145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 2),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 6, .production_id = 9),
  [1149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 6, .production_id = 8),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 7, .production_id = 11),
  [1153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_key, 3, .production_id = 20),
  [1155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 5, .production_id = 6),
  [1157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 7, .production_id = 12),
  [1159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 4, .production_id = 1),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_contract_defn, 8, .production_id = 18),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__contract_item_repeat3, 1, .production_id = 2),
  [1179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_key, 5, .production_id = 41),
  [1181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fn_args, 3),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1237] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_cwscript(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
